/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.InstructionComparator;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public abstract class Instruction
implements Cloneable,
Serializable {
    protected short length = 1;
    protected short opcode = (short)-1;
    private static InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(short opcode, short length) {
        this.length = length;
        this.opcode = opcode;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this.opcode];
    }

    public String toString(boolean verbose) {
        if (verbose) {
            return this.getName() + "[" + this.opcode + "](" + this.length + ")";
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool cp) {
        return this.toString(false);
    }

    public Instruction copy() {
        Instruction i = null;
        if (InstructionConstants.INSTRUCTIONS[this.getOpcode()] != null) {
            i = this;
        } else {
            try {
                i = (Instruction)this.clone();
            }
            catch (CloneNotSupportedException e) {
                System.err.println(e);
            }
        }
        return i;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
    }

    public static final Instruction readInstruction(ByteSequence bytes) throws IOException {
        boolean wide = false;
        short opcode = (short)bytes.readUnsignedByte();
        Instruction obj = null;
        if (opcode == 196) {
            wide = true;
            opcode = (short)bytes.readUnsignedByte();
        }
        if (InstructionConstants.INSTRUCTIONS[opcode] != null) {
            return InstructionConstants.INSTRUCTIONS[opcode];
        }
        try {
            switch (opcode) {
                case 0: {
                    obj = new NOP();
                    break;
                }
                case 1: {
                    obj = new ACONST_NULL();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    obj = new ICONST();
                    break;
                }
                case 9: 
                case 10: {
                    obj = new LCONST();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    obj = new FCONST();
                    break;
                }
                case 14: 
                case 15: {
                    obj = new DCONST();
                    break;
                }
                case 16: {
                    obj = new BIPUSH();
                    break;
                }
                case 17: {
                    obj = new SIPUSH();
                    break;
                }
                case 18: {
                    obj = new LDC();
                    break;
                }
                case 19: {
                    obj = new LDC_W();
                    break;
                }
                case 20: {
                    obj = new LDC2_W();
                    break;
                }
                case 21: {
                    obj = new ILOAD();
                    break;
                }
                case 22: {
                    obj = new LLOAD();
                    break;
                }
                case 23: {
                    obj = new FLOAD();
                    break;
                }
                case 24: {
                    obj = new DLOAD();
                    break;
                }
                case 25: {
                    obj = new ALOAD();
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    obj = new ILOAD();
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    obj = new LLOAD();
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    obj = new FLOAD();
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    obj = new DLOAD();
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    obj = new ALOAD();
                    break;
                }
                case 46: {
                    obj = new IALOAD();
                    break;
                }
                case 47: {
                    obj = new LALOAD();
                    break;
                }
                case 48: {
                    obj = new FALOAD();
                    break;
                }
                case 49: {
                    obj = new DALOAD();
                    break;
                }
                case 50: {
                    obj = new AALOAD();
                    break;
                }
                case 51: {
                    obj = new BALOAD();
                    break;
                }
                case 52: {
                    obj = new CALOAD();
                    break;
                }
                case 53: {
                    obj = new SALOAD();
                    break;
                }
                case 54: {
                    obj = new ISTORE();
                    break;
                }
                case 55: {
                    obj = new LSTORE();
                    break;
                }
                case 56: {
                    obj = new FSTORE();
                    break;
                }
                case 57: {
                    obj = new DSTORE();
                    break;
                }
                case 58: {
                    obj = new ASTORE();
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    obj = new ISTORE();
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    obj = new LSTORE();
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    obj = new FSTORE();
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    obj = new DSTORE();
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    obj = new ASTORE();
                    break;
                }
                case 79: {
                    obj = new IASTORE();
                    break;
                }
                case 80: {
                    obj = new LASTORE();
                    break;
                }
                case 81: {
                    obj = new FASTORE();
                    break;
                }
                case 82: {
                    obj = new DASTORE();
                    break;
                }
                case 83: {
                    obj = new AASTORE();
                    break;
                }
                case 84: {
                    obj = new BASTORE();
                    break;
                }
                case 85: {
                    obj = new CASTORE();
                    break;
                }
                case 86: {
                    obj = new SASTORE();
                    break;
                }
                case 87: {
                    obj = new POP();
                    break;
                }
                case 88: {
                    obj = new POP2();
                    break;
                }
                case 89: {
                    obj = new DUP();
                    break;
                }
                case 90: {
                    obj = new DUP_X1();
                    break;
                }
                case 91: {
                    obj = new DUP_X2();
                    break;
                }
                case 92: {
                    obj = new DUP2();
                    break;
                }
                case 93: {
                    obj = new DUP2_X1();
                    break;
                }
                case 94: {
                    obj = new DUP2_X2();
                    break;
                }
                case 95: {
                    obj = new SWAP();
                    break;
                }
                case 96: {
                    obj = new IADD();
                    break;
                }
                case 97: {
                    obj = new LADD();
                    break;
                }
                case 98: {
                    obj = new FADD();
                    break;
                }
                case 99: {
                    obj = new DADD();
                    break;
                }
                case 100: {
                    obj = new ISUB();
                    break;
                }
                case 101: {
                    obj = new LSUB();
                    break;
                }
                case 102: {
                    obj = new FSUB();
                    break;
                }
                case 103: {
                    obj = new DSUB();
                    break;
                }
                case 104: {
                    obj = new IMUL();
                    break;
                }
                case 105: {
                    obj = new LMUL();
                    break;
                }
                case 106: {
                    obj = new FMUL();
                    break;
                }
                case 107: {
                    obj = new DMUL();
                    break;
                }
                case 108: {
                    obj = new IDIV();
                    break;
                }
                case 109: {
                    obj = new LDIV();
                    break;
                }
                case 110: {
                    obj = new FDIV();
                    break;
                }
                case 111: {
                    obj = new DDIV();
                    break;
                }
                case 112: {
                    obj = new IREM();
                    break;
                }
                case 113: {
                    obj = new LREM();
                    break;
                }
                case 114: {
                    obj = new FREM();
                    break;
                }
                case 115: {
                    obj = new DREM();
                    break;
                }
                case 116: {
                    obj = new INEG();
                    break;
                }
                case 117: {
                    obj = new LNEG();
                    break;
                }
                case 118: {
                    obj = new FNEG();
                    break;
                }
                case 119: {
                    obj = new DNEG();
                    break;
                }
                case 120: {
                    obj = new ISHL();
                    break;
                }
                case 121: {
                    obj = new LSHL();
                    break;
                }
                case 122: {
                    obj = new ISHR();
                    break;
                }
                case 123: {
                    obj = new LSHR();
                    break;
                }
                case 124: {
                    obj = new IUSHR();
                    break;
                }
                case 125: {
                    obj = new LUSHR();
                    break;
                }
                case 126: {
                    obj = new IAND();
                    break;
                }
                case 127: {
                    obj = new LAND();
                    break;
                }
                case 128: {
                    obj = new IOR();
                    break;
                }
                case 129: {
                    obj = new LOR();
                    break;
                }
                case 130: {
                    obj = new IXOR();
                    break;
                }
                case 131: {
                    obj = new LXOR();
                    break;
                }
                case 132: {
                    obj = new IINC();
                    break;
                }
                case 133: {
                    obj = new I2L();
                    break;
                }
                case 134: {
                    obj = new I2F();
                    break;
                }
                case 135: {
                    obj = new I2D();
                    break;
                }
                case 136: {
                    obj = new L2I();
                    break;
                }
                case 137: {
                    obj = new L2F();
                    break;
                }
                case 138: {
                    obj = new L2D();
                    break;
                }
                case 139: {
                    obj = new F2I();
                    break;
                }
                case 140: {
                    obj = new F2L();
                    break;
                }
                case 141: {
                    obj = new F2D();
                    break;
                }
                case 142: {
                    obj = new D2I();
                    break;
                }
                case 143: {
                    obj = new D2L();
                    break;
                }
                case 144: {
                    obj = new D2F();
                    break;
                }
                case 145: {
                    obj = new I2B();
                    break;
                }
                case 146: {
                    obj = new I2C();
                    break;
                }
                case 147: {
                    obj = new I2S();
                    break;
                }
                case 148: {
                    obj = new LCMP();
                    break;
                }
                case 149: {
                    obj = new FCMPL();
                    break;
                }
                case 150: {
                    obj = new FCMPG();
                    break;
                }
                case 151: {
                    obj = new DCMPL();
                    break;
                }
                case 152: {
                    obj = new DCMPG();
                    break;
                }
                case 153: {
                    obj = new IFEQ();
                    break;
                }
                case 154: {
                    obj = new IFNE();
                    break;
                }
                case 155: {
                    obj = new IFLT();
                    break;
                }
                case 156: {
                    obj = new IFGE();
                    break;
                }
                case 157: {
                    obj = new IFGT();
                    break;
                }
                case 158: {
                    obj = new IFLE();
                    break;
                }
                case 159: {
                    obj = new IF_ICMPEQ();
                    break;
                }
                case 160: {
                    obj = new IF_ICMPNE();
                    break;
                }
                case 161: {
                    obj = new IF_ICMPLT();
                    break;
                }
                case 162: {
                    obj = new IF_ICMPGE();
                    break;
                }
                case 163: {
                    obj = new IF_ICMPGT();
                    break;
                }
                case 164: {
                    obj = new IF_ICMPLE();
                    break;
                }
                case 165: {
                    obj = new IF_ACMPEQ();
                    break;
                }
                case 166: {
                    obj = new IF_ACMPNE();
                    break;
                }
                case 167: {
                    obj = new GOTO();
                    break;
                }
                case 168: {
                    obj = new JSR();
                    break;
                }
                case 169: {
                    obj = new RET();
                    break;
                }
                case 170: {
                    obj = new TABLESWITCH();
                    break;
                }
                case 171: {
                    obj = new LOOKUPSWITCH();
                    break;
                }
                case 172: {
                    obj = new IRETURN();
                    break;
                }
                case 173: {
                    obj = new LRETURN();
                    break;
                }
                case 174: {
                    obj = new FRETURN();
                    break;
                }
                case 175: {
                    obj = new DRETURN();
                    break;
                }
                case 176: {
                    obj = new ARETURN();
                    break;
                }
                case 177: {
                    obj = new RETURN();
                    break;
                }
                case 178: {
                    obj = new GETSTATIC();
                    break;
                }
                case 179: {
                    obj = new PUTSTATIC();
                    break;
                }
                case 180: {
                    obj = new GETFIELD();
                    break;
                }
                case 181: {
                    obj = new PUTFIELD();
                    break;
                }
                case 182: {
                    obj = new INVOKEVIRTUAL();
                    break;
                }
                case 183: {
                    obj = new INVOKESPECIAL();
                    break;
                }
                case 184: {
                    obj = new INVOKESTATIC();
                    break;
                }
                case 185: {
                    obj = new INVOKEINTERFACE();
                    break;
                }
                case 187: {
                    obj = new NEW();
                    break;
                }
                case 188: {
                    obj = new NEWARRAY();
                    break;
                }
                case 189: {
                    obj = new ANEWARRAY();
                    break;
                }
                case 190: {
                    obj = new ARRAYLENGTH();
                    break;
                }
                case 191: {
                    obj = new ATHROW();
                    break;
                }
                case 192: {
                    obj = new CHECKCAST();
                    break;
                }
                case 193: {
                    obj = new INSTANCEOF();
                    break;
                }
                case 194: {
                    obj = new MONITORENTER();
                    break;
                }
                case 195: {
                    obj = new MONITOREXIT();
                    break;
                }
                case 197: {
                    obj = new MULTIANEWARRAY();
                    break;
                }
                case 198: {
                    obj = new IFNULL();
                    break;
                }
                case 199: {
                    obj = new IFNONNULL();
                    break;
                }
                case 200: {
                    obj = new GOTO_W();
                    break;
                }
                case 201: {
                    obj = new JSR_W();
                    break;
                }
                default: {
                    throw new ClassGenException("Illegal opcode detected");
                }
            }
        }
        catch (ClassGenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassGenException(e.toString());
        }
        if (wide && !(obj instanceof LocalVariableInstruction) && !(obj instanceof IINC) && !(obj instanceof RET)) {
            throw new ClassGenException("Illegal opcode after wide: " + opcode);
        }
        super.setOpcode(opcode);
        obj.initFromFile(bytes, wide);
        return obj;
    }

    private static final String className(short opcode) {
        String name = Constants.OPCODE_NAMES[opcode].toUpperCase();
        try {
            int len = name.length();
            char ch1 = name.charAt(len - 2);
            char ch2 = name.charAt(len - 1);
            if (ch1 == '_' && ch2 >= '0' && ch2 <= '5') {
                name = name.substring(0, len - 2);
            }
            if (name.equals("ICONST_M1")) {
                name = "ICONST";
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return "org.apache.bcel.generic." + name;
    }

    public int consumeStack(ConstantPoolGen cpg) {
        return Constants.CONSUME_STACK[this.opcode];
    }

    public int produceStack(ConstantPoolGen cpg) {
        return Constants.PRODUCE_STACK[this.opcode];
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        return this.length;
    }

    private void setOpcode(short opcode) {
        this.opcode = opcode;
    }

    void dispose() {
    }

    public abstract void accept(Visitor var1);

    public static InstructionComparator getComparator() {
        return cmp;
    }

    public static void setComparator(InstructionComparator c) {
        cmp = c;
    }

    public boolean equals(Object that) {
        return that instanceof Instruction ? cmp.equals(this, (Instruction)that) : false;
    }
}

