/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.EscapeTokenizer;
import com.mysql.jdbc.StringUtils;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class EscapeProcessor {
    EscapeProcessor() {
    }

    public static final Object escapeSQL(String sql) throws SQLException {
        int nextEndBrace;
        boolean replaceEscapeSequence = false;
        String escapeSequence = null;
        if (sql == null) {
            return null;
        }
        int beginBrace = sql.indexOf(123);
        int n = nextEndBrace = beginBrace == -1 ? -1 : sql.indexOf(125, beginBrace);
        if (nextEndBrace == -1) {
            return sql;
        }
        StringBuffer newSql = new StringBuffer();
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(sql);
        byte usesVariables = 0;
        while (escapeTokenizer.hasMoreTokens()) {
            String token = escapeTokenizer.nextToken();
            if (token.length() == 0) continue;
            if (token.charAt(0) == '{') {
                String day2;
                String month2;
                String year4;
                StringTokenizer st;
                String argument;
                String collapsedToken;
                int nestedBrace;
                if (!token.endsWith("}")) {
                    throw new SQLException("Not a valid escape sequence: " + token);
                }
                if (token.length() > 2 && (nestedBrace = token.indexOf(123, 2)) != -1) {
                    StringBuffer buf = new StringBuffer(token.substring(0, 1));
                    Object remainingResults = EscapeProcessor.escapeSQL(token.substring(1, token.length() - 1));
                    String remaining = null;
                    if (remainingResults instanceof String) {
                        remaining = (String)remainingResults;
                    } else {
                        remaining = ((EscapeProcessorResult)remainingResults).escapedSql;
                        if (usesVariables != 1) {
                            usesVariables = ((EscapeProcessorResult)remainingResults).usesVariables;
                        }
                    }
                    buf.append(remaining);
                    buf.append('}');
                    token = buf.toString();
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken = EscapeProcessor.removeWhitespace(token), "{escape")) {
                    try {
                        StringTokenizer st2 = new StringTokenizer(token, " '");
                        st2.nextToken();
                        escapeSequence = st2.nextToken();
                        if (escapeSequence.length() < 3) {
                            throw new SQLException("Syntax error for escape sequence '" + token + "'", "42000");
                        }
                        escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1);
                        replaceEscapeSequence = true;
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for escape sequence '" + token + "'", "42000");
                    }
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{fn")) {
                    int startPos = StringUtils.indexOfIgnoreCase(token, "fn ") + 3;
                    int endPos = token.length() - 1;
                    newSql.append(token.substring(startPos, endPos));
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{d")) {
                    int startPos = token.indexOf(39) + 1;
                    int endPos = token.lastIndexOf(39);
                    if (startPos == -1 || endPos == -1) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + token + "'", "42000");
                    }
                    argument = token.substring(startPos, endPos);
                    try {
                        st = new StringTokenizer(argument, " -");
                        year4 = st.nextToken();
                        month2 = st.nextToken();
                        day2 = st.nextToken();
                        String dateString = "'" + year4 + "-" + month2 + "-" + day2 + "'";
                        newSql.append(dateString);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + argument + "'", "42000");
                    }
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{ts")) {
                    int startPos = token.indexOf(39) + 1;
                    int endPos = token.lastIndexOf(39);
                    if (startPos == -1 || endPos == -1) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + token + "'", "42000");
                    }
                    argument = token.substring(startPos, endPos);
                    try {
                        st = new StringTokenizer(argument, " .-:");
                        year4 = st.nextToken();
                        month2 = st.nextToken();
                        day2 = st.nextToken();
                        String hour = st.nextToken();
                        String minute = st.nextToken();
                        String second = st.nextToken();
                        newSql.append("'").append(year4).append("-").append(month2).append("-").append(day2).append(" ").append(hour).append(":").append(minute).append(":").append(second).append("'");
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000");
                    }
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{t")) {
                    int startPos = token.indexOf(39) + 1;
                    int endPos = token.lastIndexOf(39);
                    if (startPos == -1 || endPos == -1) {
                        throw new SQLException("Syntax error for TIME escape sequence '" + token + "'", "42000");
                    }
                    argument = token.substring(startPos, endPos);
                    try {
                        st = new StringTokenizer(argument, " :");
                        String hour = st.nextToken();
                        String minute = st.nextToken();
                        String second = st.nextToken();
                        String timeString = "'" + hour + ":" + minute + ":" + second + "'";
                        newSql.append(timeString);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for escape sequence '" + argument + "'", "42000");
                    }
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{call") || StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                    int startPos = StringUtils.indexOfIgnoreCase(token, "CALL") + 5;
                    int endPos = token.length() - 1;
                    newSql.append("CALL ");
                    newSql.append(token.substring(startPos, endPos));
                    continue;
                }
                if (!StringUtils.startsWithIgnoreCase(collapsedToken, "{oj")) continue;
                newSql.append(token);
                continue;
            }
            newSql.append(token);
        }
        String escapedSql = newSql.toString();
        if (replaceEscapeSequence) {
            String currentSql = escapedSql;
            while (currentSql.indexOf(escapeSequence) != -1) {
                int escapePos = currentSql.indexOf(escapeSequence);
                String lhs = currentSql.substring(0, escapePos);
                String rhs = currentSql.substring(escapePos + 1, currentSql.length());
                currentSql = lhs + "\\" + rhs;
            }
            escapedSql = currentSql;
        }
        EscapeProcessorResult epr = new EscapeProcessorResult();
        epr.escapedSql = escapedSql;
        if (usesVariables != 1) {
            epr.usesVariables = escapeTokenizer.sawVariableUse() ? (byte)1 : 0;
        }
        return epr;
    }

    private static String removeWhitespace(String toCollapse) {
        if (toCollapse == null) {
            return null;
        }
        int length = toCollapse.length();
        StringBuffer collapsed = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = toCollapse.charAt(i);
            if (Character.isWhitespace(c)) continue;
            collapsed.append(c);
        }
        return collapsed.toString();
    }
}

