/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class RefreshLocalAliasVisitor
extends RefreshLocalVisitor {
    public RefreshLocalAliasVisitor(IProgressMonitor monitor) {
        super(monitor);
    }

    protected void createResource(UnifiedTreeNode node, Resource target) throws CoreException {
        super.createResource(node, target);
        if (node.getLocalLocation() == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, new Path(node.getLocalLocation()));
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                super.createResource(node, (Resource)aliases[i]);
                ++i;
            }
        }
    }

    protected void deleteResource(UnifiedTreeNode node, Resource target) throws CoreException {
        super.deleteResource(node, target);
        if (node.getLocalLocation() == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, new Path(node.getLocalLocation()));
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                super.deleteResource(node, (Resource)aliases[i]);
                ++i;
            }
        }
    }

    protected void resourceChanged(UnifiedTreeNode node, Resource target) throws CoreException {
        super.resourceChanged(node, target);
        if (node.getLocalLocation() == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, new Path(node.getLocalLocation()));
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                super.resourceChanged(node, (Resource)aliases[i]);
                ++i;
            }
        }
    }

    protected void fileToFolder(UnifiedTreeNode node, Resource target) throws CoreException {
        super.fileToFolder(node, target);
        if (node.getLocalLocation() == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, new Path(node.getLocalLocation()));
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                super.fileToFolder(node, (Resource)aliases[i]);
                ++i;
            }
        }
    }

    protected void folderToFile(UnifiedTreeNode node, Resource target) throws CoreException {
        super.folderToFile(node, target);
        if (node.getLocalLocation() == null) {
            return;
        }
        IResource[] aliases = this.workspace.getAliasManager().computeAliases(target, new Path(node.getLocalLocation()));
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                super.folderToFile(node, (Resource)aliases[i]);
                ++i;
            }
        }
    }

    protected void refresh(Container parent) throws CoreException {
        parent.getLocalManager().refresh(parent, 0, true, null);
    }
}

