/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStoreEntry;
import org.eclipse.core.internal.localstore.IHistoryStoreVisitor;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class HistoryStore {
    protected Workspace workspace;
    protected IPath location;
    protected BlobStore blobStore;
    private IndexedStoreWrapper store;
    private static final String INDEX_FILE = ".index";
    protected boolean stateAlreadyExists;

    public HistoryStore(Workspace workspace, IPath location, int limit) {
        this.workspace = workspace;
        this.blobStore = new BlobStore(location, limit);
        this.store = new IndexedStoreWrapper(location.append(INDEX_FILE));
    }

    protected void accept(byte[] key, IHistoryStoreVisitor visitor, boolean visitOnPartialMatch, boolean includeLastModTime) {
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.find(key);
            while (cursor.keyMatches(key)) {
                HistoryStoreEntry storedEntry;
                HistoryStoreEntry storedEntry2;
                int bytesToOmit;
                byte[] storedKey = cursor.getKey();
                int n = bytesToOmit = includeLastModTime ? 1 : 9;
                if (storedKey.length - bytesToOmit == key.length && !visitor.visit(storedEntry2 = HistoryStoreEntry.create(this.store, cursor))) break;
                if (!visitOnPartialMatch) {
                    cursor.next();
                    continue;
                }
                byte b = storedKey[key.length];
                if ((key[key.length - 1] == 47 || b == 47) && !visitor.visit(storedEntry = HistoryStoreEntry.create(this.store, cursor))) break;
                cursor.next();
            }
            cursor.close();
        }
        catch (Exception e) {
            String message = Policy.bind("history.problemsAccessing");
            ResourceStatus status = new ResourceStatus(271, null, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    protected void accept(IPath path, IHistoryStoreVisitor visitor, boolean visitOnPartialMatch) {
        this.accept(Convert.toUTF8(path.toString()), visitor, visitOnPartialMatch, false);
    }

    protected void addState(IPath path, UniversalUniqueIdentifier uuid, long lastModified) {
        byte[] keyPrefix = HistoryStoreEntry.keyPrefixToBytes(path, lastModified);
        class CountVisitor
        implements IHistoryStoreVisitor {
            byte count;
            final /* synthetic */ HistoryStore this$0;

            CountVisitor(HistoryStore historyStore) {
                this.this$0 = historyStore;
                this.count = 0;
            }

            public boolean visit(HistoryStoreEntry entry) throws IndexedStoreException {
                this.count = (byte)(this.count + 1);
                return true;
            }

            public byte getCount() {
                return this.count;
            }
        }
        CountVisitor visitor = new CountVisitor(this);
        this.accept(keyPrefix, visitor, false, true);
        HistoryStoreEntry entryToInsert = new HistoryStoreEntry(path, uuid, lastModified, visitor.getCount());
        try {
            ObjectID valueID = this.store.createObject(entryToInsert.valueToBytes());
            this.store.getIndex().insert(entryToInsert.getKey(), (Insertable)valueID);
        }
        catch (Exception e) {
            this.resetIndexedStore();
            String message = Policy.bind("history.couldNotAdd", path.toString());
            ResourceStatus status = new ResourceStatus(272, path, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public UniversalUniqueIdentifier addState(IPath key, File localFile, long lastModified, boolean moveContents) {
        if (Policy.DEBUG_HISTORY) {
            System.out.println("History: Adding state for key: " + key + ", file: " + localFile + ", timestamp: " + lastModified + ", size: " + localFile.length());
        }
        if (!this.isValid(localFile)) {
            return null;
        }
        UniversalUniqueIdentifier uuid = null;
        try {
            uuid = this.blobStore.addBlob(localFile, moveContents);
            this.addState(key, uuid, lastModified);
            this.store.commit();
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return uuid;
    }

    public UniversalUniqueIdentifier addState(IPath key, IPath localLocation, long lastModified, boolean moveContents) {
        return this.addState(key, localLocation.toFile(), lastModified, moveContents);
    }

    public void clean() {
        WorkspaceDescription description = this.workspace.internalGetDescription();
        long minimumTimestamp = System.currentTimeMillis() - description.getFileStateLongevity();
        int max = description.getMaxFileStates();
        IPath current = null;
        ArrayList<HistoryStoreEntry> result = new ArrayList<HistoryStoreEntry>(Math.min(max, 1000));
        HashSet<String> blobs = new HashSet<String>();
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.findFirstEntry();
            while (cursor.isSet()) {
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                if (entry.getLastModified() < minimumTimestamp) {
                    this.remove(entry);
                    continue;
                }
                if (!entry.getPath().equals(current)) {
                    this.removeOldestEntries(result, max);
                    result.clear();
                    current = entry.getPath();
                }
                result.add(entry);
                blobs.add(entry.getUUID().toString());
                cursor.next();
            }
            this.removeOldestEntries(result, max);
            cursor.close();
            this.store.commit();
            this.removeGarbage(blobs);
        }
        catch (Exception e) {
            String message = Policy.bind("history.problemsCleaning");
            ResourceStatus status = new ResourceStatus(273, null, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    protected boolean stateAlreadyExists(IPath path, final UniversalUniqueIdentifier uuid) {
        this.stateAlreadyExists = false;
        IHistoryStoreVisitor visitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry entry) throws IndexedStoreException {
                if (uuid.equals(entry.getUUID())) {
                    HistoryStore.this.stateAlreadyExists = true;
                    return false;
                }
                return true;
            }
        };
        this.accept(path, visitor, false);
        return this.stateAlreadyExists;
    }

    public void copyHistory(final IPath source, final IPath destination) {
        ResourceStatus status;
        String message;
        if (source == null || destination == null) {
            String message2 = Policy.bind("history.copyToNull");
            ResourceStatus status2 = new ResourceStatus(566, source, message2, null);
            ResourcesPlugin.getPlugin().getLog().log(status2);
            return;
        }
        if (source.equals(destination)) {
            String message3 = Policy.bind("history.copyToSelf");
            ResourceStatus status3 = new ResourceStatus(566, source, message3, null);
            ResourcesPlugin.getPlugin().getLog().log(status3);
            return;
        }
        final HashSet matches = new HashSet();
        IHistoryStoreVisitor visitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry entry) throws IndexedStoreException {
                IPath path = entry.getPath();
                int prefixSegments = source.matchingFirstSegments(path);
                if (prefixSegments == 0) {
                    String message = Policy.bind("history.interalPathErrors", source.toString(), path.toString());
                    ResourceStatus status = new ResourceStatus(566, source, message, null);
                    ResourcesPlugin.getPlugin().getLog().log(status);
                    return false;
                }
                if (!HistoryStore.this.stateAlreadyExists(path = destination.append(path.removeFirstSegments(prefixSegments)), entry.getUUID())) {
                    matches.add(path);
                    HistoryStore.this.addState(path, entry.getUUID(), entry.getLastModified());
                }
                return true;
            }
        };
        this.accept(source, visitor, true);
        WorkspaceDescription description = this.workspace.internalGetDescription();
        int maxFileStates = description.getMaxFileStates();
        try {
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                LinkedList<HistoryStoreEntry> removeEntries = new LinkedList<HistoryStoreEntry>();
                IndexCursor cursor = this.store.getCursor();
                IPath path = (IPath)i.next();
                byte[] key = Convert.toUTF8(path.toString());
                cursor.find(key);
                while (cursor.keyMatches(key)) {
                    removeEntries.add(HistoryStoreEntry.create(this.store, cursor));
                    cursor.next();
                }
                cursor.close();
                this.removeOldestEntries(removeEntries, maxFileStates);
            }
        }
        catch (IndexedStoreException e) {
            message = Policy.bind("history.problemsPurging", source.toString(), destination.toString());
            status = new ResourceStatus(568, source, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        catch (CoreException e) {
            message = Policy.bind("history.problemsPurging", source.toString(), destination.toString());
            status = new ResourceStatus(568, source, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        try {
            this.store.commit();
        }
        catch (CoreException e) {
            message = Policy.bind("history.problemsCopying", source.toString(), destination.toString());
            status = new ResourceStatus(568, source, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public boolean exists(IFileState target) {
        return this.blobStore.fileFor(((FileState)target).getUUID()).exists();
    }

    public InputStream getContents(IFileState target) throws CoreException {
        if (!this.exists(target)) {
            String message = Policy.bind("history.notValid");
            throw new ResourceException(271, target.getFullPath(), message, null);
        }
        return this.blobStore.getBlob(((FileState)target).getUUID());
    }

    public IFileState[] getStates(final IPath key) {
        int max = this.workspace.internalGetDescription().getMaxFileStates();
        final ArrayList result = new ArrayList(max);
        IHistoryStoreVisitor visitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry entry) throws IndexedStoreException {
                result.add(new FileState(HistoryStore.this, key, entry.getLastModified(), entry.getUUID()));
                return true;
            }
        };
        this.accept(key, visitor, false);
        if (result.isEmpty()) {
            return ICoreConstants.EMPTY_FILE_STATES;
        }
        IFileState[] states = new IFileState[result.size()];
        int i = 0;
        while (i < states.length) {
            states[i] = (IFileState)result.get(result.size() - (i + 1));
            ++i;
        }
        return states;
    }

    public boolean isValid(File localFile) {
        boolean result;
        WorkspaceDescription description = this.workspace.internalGetDescription();
        boolean bl = result = localFile.length() <= description.getMaxFileStateSize();
        if (Policy.DEBUG_HISTORY && !result) {
            System.out.println("History: Ignoring file (too large). File: " + localFile.getAbsolutePath() + ", size: " + localFile.length() + ", max: " + description.getMaxFileStateSize());
        }
        return result;
    }

    protected void remove(HistoryStoreEntry entry) throws IndexedStoreException {
        entry.remove();
    }

    public void removeAll() {
        this.removeAll(this.workspace.getRoot());
    }

    public void removeAll(IResource resource) {
        try {
            IndexCursor cursor = this.store.getCursor();
            byte[] key = Convert.toUTF8(resource.getFullPath().toString());
            cursor.find(key);
            while (cursor.keyMatches(key)) {
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                this.remove(entry);
            }
            cursor.close();
            this.store.commit();
        }
        catch (Exception e) {
            String message = Policy.bind("history.problemsRemoving", resource.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(273, resource.getFullPath(), message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public void removeGarbage() {
        HashSet<String> blobsToPreserv = new HashSet<String>();
        try {
            IndexCursor cursor = this.store.getCursor();
            cursor.findFirstEntry();
            while (cursor.isSet()) {
                HistoryStoreEntry entry = HistoryStoreEntry.create(this.store, cursor);
                blobsToPreserv.add(entry.getUUID().toString());
                cursor.next();
            }
            cursor.close();
        }
        catch (Exception e) {
            String message = Policy.bind("history.problemsCleaning");
            ResourceStatus status = new ResourceStatus(273, null, message, e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        this.removeGarbage(blobsToPreserv);
    }

    protected void removeGarbage(Set blobsToPreserv) {
        this.blobStore.deleteAllExcept(blobsToPreserv);
    }

    protected void removeOldestEntries(List entries, int maxEntries) throws IndexedStoreException {
        if (entries.size() <= maxEntries) {
            return;
        }
        int limit = entries.size() - maxEntries;
        int i = 0;
        while (i < limit) {
            this.remove((HistoryStoreEntry)entries.get(i));
            ++i;
        }
    }

    public void shutdown(IProgressMonitor monitor) {
        if (this.store == null) {
            return;
        }
        this.store.close();
    }

    public void startup(IProgressMonitor monitor) {
    }

    protected void resetIndexedStore() {
        this.store.reset();
        IPath location = this.workspace.getMetaArea().getHistoryStoreLocation();
        File target = location.toFile();
        Workspace.clear(target);
        target.mkdirs();
        String message = Policy.bind("history.corrupt");
        ResourceStatus status = new ResourceStatus(566, null, message, null);
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public File getFileFor(UniversalUniqueIdentifier uuid) {
        return this.blobStore.fileFor(uuid);
    }

    public Set allFiles(IPath path, int depth) {
        HashSet allFiles = new HashSet();
        int pathLength = path.segmentCount();
        class PathCollector
        implements IHistoryStoreVisitor {
            final /* synthetic */ HistoryStore this$0;
            private final /* synthetic */ int val$depth;
            private final /* synthetic */ int val$pathLength;
            private final /* synthetic */ Set val$allFiles;

            PathCollector(HistoryStore historyStore, int n, int n2, Set set) {
                this.this$0 = historyStore;
                this.val$depth = n;
                this.val$pathLength = n2;
                this.val$allFiles = set;
            }

            public boolean visit(HistoryStoreEntry state) {
                IPath memberPath = state.getPath();
                boolean withinDepthRange = false;
                switch (this.val$depth) {
                    case 0: {
                        withinDepthRange = memberPath.segmentCount() == this.val$pathLength;
                        break;
                    }
                    case 1: {
                        withinDepthRange = memberPath.segmentCount() <= this.val$pathLength + 1;
                        break;
                    }
                    case 2: {
                        withinDepthRange = true;
                    }
                }
                if (withinDepthRange) {
                    this.val$allFiles.add(memberPath);
                }
                return withinDepthRange;
            }
        }
        this.accept(path, new PathCollector(this, depth, pathLength, allFiles), true);
        return allFiles;
    }
}

