/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.ByteArrayBuffer;
import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.CompressedInputStream;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionFeatureNotAvailableException;
import com.mysql.jdbc.ExportControlled;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlDataTruncation;
import com.mysql.jdbc.PacketTooBigException;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.RowDataDynamic;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Security;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.UpdatableResultSet;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.trace.Tracer;
import com.mysql.jdbc.util.ReadAheadInputStream;
import com.mysql.jdbc.util.ResultSetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.Deflater;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class MysqlIO {
    protected static final int NULL_LENGTH = -1;
    protected static final int COMP_HEADER_LENGTH = 3;
    protected static final int MIN_COMPRESS_LEN = 50;
    protected static final int HEADER_LENGTH = 4;
    private static int maxBufferSize;
    private static final int CLIENT_COMPRESS = 32;
    protected static final int CLIENT_CONNECT_WITH_DB = 8;
    private static final int CLIENT_FOUND_ROWS = 2;
    private static final int CLIENT_LOCAL_FILES = 128;
    private static final int CLIENT_LONG_FLAG = 4;
    private static final int CLIENT_LONG_PASSWORD = 1;
    private static final int CLIENT_PROTOCOL_41 = 512;
    private static final int CLIENT_INTERACTIVE = 1024;
    protected static final int CLIENT_SSL = 2048;
    private static final int CLIENT_TRANSACTIONS = 8192;
    protected static final int CLIENT_RESERVED = 16384;
    protected static final int CLIENT_SECURE_CONNECTION = 32768;
    private static final int CLIENT_MULTI_QUERIES = 65536;
    private static final int CLIENT_MULTI_RESULTS = 131072;
    private static final int SERVER_STATUS_IN_TRANS = 1;
    private static final int SERVER_STATUS_AUTOCOMMIT = 2;
    private static final int SERVER_MORE_RESULTS_EXISTS = 8;
    private static final int SERVER_QUERY_NO_GOOD_INDEX_USED = 16;
    private static final int SERVER_QUERY_NO_INDEX_USED = 32;
    private static final String FALSE_SCRAMBLE = "xxxxxxxx";
    protected static final int MAX_QUERY_SIZE_TO_LOG = 1024;
    protected static final int MAX_QUERY_SIZE_TO_EXPLAIN = 0x100000;
    private static String jvmPlatformCharset;
    private boolean binaryResultsAreUnpacked = true;
    protected static final String ZERO_DATE_VALUE_MARKER = "0000-00-00";
    protected static final String ZERO_DATETIME_VALUE_MARKER = "0000-00-00 00:00:00";
    private static final int MAX_PACKET_DUMP_LENGTH = 1024;
    private boolean packetSequenceReset = false;
    protected int serverCharsetIndex;
    private Buffer reusablePacket = null;
    private Buffer sendPacket = null;
    private Buffer sharedSendPacket = null;
    protected BufferedOutputStream mysqlOutput = null;
    protected Connection connection;
    private Deflater deflater = null;
    protected InputStream mysqlInput = null;
    private LinkedList packetDebugRingBuffer = null;
    private RowData streamingData = null;
    protected Socket mysqlConnection = null;
    private SocketChannel socketChannel;
    private SocketFactory socketFactory = null;
    private SoftReference loadFileBufRef;
    private SoftReference splitBufRef;
    protected String host = null;
    protected String seed;
    private String serverVersion = null;
    private String socketFactoryClassName = null;
    private byte[] packetHeaderBuf = new byte[4];
    private boolean colDecimalNeedsBump = false;
    private boolean hadWarnings = false;
    private boolean has41NewNewProt = false;
    private boolean hasLongColumnInfo = false;
    private boolean isInteractiveClient = false;
    private boolean logSlowQueries = false;
    private boolean platformDbCharsetMatches = true;
    private boolean profileSql = false;
    private boolean queryBadIndexUsed = false;
    private boolean queryNoIndexUsed = false;
    private boolean use41Extensions = false;
    private boolean useCompression = false;
    protected boolean useNewIo = false;
    private boolean useNewLargePackets = false;
    private boolean useNewUpdateCounts = false;
    private byte packetSequence = 0;
    private byte readPacketSequence = (byte)-1;
    private boolean checkPacketSequence = false;
    byte protocolVersion = 0;
    private int maxAllowedPacket = 0x100000;
    protected int maxThreeBytes = 16581375;
    protected int port = 3306;
    protected int serverCapabilities;
    private int serverMajorVersion = 0;
    private int serverMinorVersion = 0;
    private int serverStatus = 0;
    private int serverSubMinorVersion = 0;
    private int warningCount = 0;
    protected long clientParam = 0L;
    protected long lastPacketSentTimeMs = 0L;
    private boolean traceProtocol = false;
    private boolean enablePacketDebug = false;
    private ByteBuffer channelClearBuf;
    private Calendar sessionCalendar;
    private boolean useConnectWithDb;
    private boolean needToGrabQueryFromPacket;
    private boolean autoGenerateTestcaseScript;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;
    private static final JoinPoint.StaticPart ajc$tjp_44;
    private static final JoinPoint.StaticPart ajc$tjp_45;
    private static final JoinPoint.StaticPart ajc$tjp_46;
    private static final JoinPoint.StaticPart ajc$tjp_47;
    private static final JoinPoint.StaticPart ajc$tjp_48;
    private static final JoinPoint.StaticPart ajc$tjp_49;
    private static final JoinPoint.StaticPart ajc$tjp_50;
    private static final JoinPoint.StaticPart ajc$tjp_51;
    private static final JoinPoint.StaticPart ajc$tjp_52;
    private static final JoinPoint.StaticPart ajc$tjp_53;
    private static final JoinPoint.StaticPart ajc$tjp_54;
    private static final JoinPoint.StaticPart ajc$tjp_55;
    private static final JoinPoint.StaticPart ajc$tjp_56;
    private static final JoinPoint.StaticPart ajc$tjp_57;
    private static final JoinPoint.StaticPart ajc$tjp_58;
    private static final JoinPoint.StaticPart ajc$tjp_59;
    private static final JoinPoint.StaticPart ajc$tjp_60;
    private static final JoinPoint.StaticPart ajc$tjp_61;
    private static final JoinPoint.StaticPart ajc$tjp_62;
    private static final JoinPoint.StaticPart ajc$tjp_63;
    private static final JoinPoint.StaticPart ajc$tjp_64;
    private static final JoinPoint.StaticPart ajc$tjp_65;
    private static final JoinPoint.StaticPart ajc$tjp_66;
    private static final JoinPoint.StaticPart ajc$tjp_67;
    private static final JoinPoint.StaticPart ajc$tjp_68;
    private static final JoinPoint.StaticPart ajc$tjp_69;
    private static final JoinPoint.StaticPart ajc$tjp_70;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Factory factory = new Factory("MysqlIO.java", Class.forName("com.mysql.jdbc.MysqlIO"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-hasLongColumnInfo-com.mysql.jdbc.MysqlIO----boolean-"), 336);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isDataAvailable-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-boolean-"), 341);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-checkErrorPacket-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 798);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-checkForCharsetMismatch-com.mysql.jdbc.MysqlIO----void-"), 805);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-clearInputStream-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 822);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-resetReadPacketSequence-com.mysql.jdbc.MysqlIO----void-"), 872);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-dumpPacketRingBuffer-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 876);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-explainSlowQuery-com.mysql.jdbc.MysqlIO-[B:java.lang.String:-querySQL:truncatedQuery:-java.sql.SQLException:-void-"), 904);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-getMaxBuf-com.mysql.jdbc.MysqlIO----int-"), 936);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getServerMajorVersion-com.mysql.jdbc.MysqlIO----int-"), 945);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getServerMinorVersion-com.mysql.jdbc.MysqlIO----int-"), 954);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getServerSubMinorVersion-com.mysql.jdbc.MysqlIO----int-"), 963);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getLastPacketSentTimeMs-com.mysql.jdbc.MysqlIO----long-"), 358);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getServerVersion-com.mysql.jdbc.MysqlIO----java.lang.String-"), 972);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-doHandshake-com.mysql.jdbc.MysqlIO-java.lang.String:java.lang.String:java.lang.String:-user:password:database:-java.sql.SQLException:-void-"), 989);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-changeDatabaseTo-com.mysql.jdbc.MysqlIO-java.lang.String:-database:-java.sql.SQLException:com.mysql.jdbc.CommunicationsException:-void-"), 1278);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-nextRow-com.mysql.jdbc.MysqlIO-[Lcom.mysql.jdbc.Field;:int:boolean:int:-fields:columnCount:isBinaryEncoded:resultSetConcurrency:-java.sql.SQLException:-[Ljava.lang.Object;-"), 1316);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-quit-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 1363);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getSharedSendPacket-com.mysql.jdbc.MysqlIO----com.mysql.jdbc.Buffer-"), 1377);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-closeStreamer-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.RowData:-streamer:-java.sql.SQLException:-void-"), 1391);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-readAllResults-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:int:int:int:boolean:java.lang.String:com.mysql.jdbc.Buffer:boolean:long:boolean:-callingStatement:maxRows:resultSetType:resultSetConcurrency:streamResults:catalog:resultPacket:isBinaryEncoded:preSentColumnCount:unpackFieldInfo:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 1411);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-resetMaxBuf-com.mysql.jdbc.MysqlIO----void-"), 1473);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-sendCommand-com.mysql.jdbc.MysqlIO-int:java.lang.String:com.mysql.jdbc.Buffer:boolean:java.lang.String:-command:extraData:queryPacket:skipCheck:extraDataCharEncoding:-java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 1504);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getResultSet-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:long:int:int:int:boolean:java.lang.String:boolean:boolean:-callingStatement:columnCount:maxRows:resultSetType:resultSetConcurrency:streamResults:catalog:isBinaryEncoded:unpackFieldInfo:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 388);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-sqlQueryDirect-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:java.lang.String:java.lang.String:com.mysql.jdbc.Buffer:int:com.mysql.jdbc.Connection:int:int:boolean:java.lang.String:boolean:-callingStatement:query:characterEncoding:queryPacket:maxRows:conn:resultSetType:resultSetConcurrency:streamResults:catalog:unpackFieldInfo:-java.lang.Exception:-com.mysql.jdbc.ResultSet-"), 1634);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getHost-com.mysql.jdbc.MysqlIO----java.lang.String-"), 1845);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isVersion-com.mysql.jdbc.MysqlIO-int:int:int:-major:minor:subminor:--boolean-"), 1860);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-versionMeetsMinimum-com.mysql.jdbc.MysqlIO-int:int:int:-major:minor:subminor:--boolean-"), 1876);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a-getPacketDumpToLog-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:int:-packetToDump:packetLength:--java.lang.String-"), 1909);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-readFully-com.mysql.jdbc.MysqlIO-java.io.InputStream:[B:int:int:-in:b:off:len:-java.io.IOException:-int-"), 1924);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-readResultsForQueryOrUpdate-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:int:int:int:boolean:java.lang.String:com.mysql.jdbc.Buffer:boolean:long:boolean:-callingStatement:maxRows:resultSetType:resultSetConcurrency:streamResults:catalog:resultPacket:isBinaryEncoded:preSentColumnCount:unpackFieldInfo:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 1968);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-alignPacketSize-com.mysql.jdbc.MysqlIO-int:int:-a:l:--int-"), 2000);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-buildResultSetWithRows-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:java.lang.String:[Lcom.mysql.jdbc.Field;:com.mysql.jdbc.RowData:int:int:boolean:-callingStatement:catalog:fields:rows:resultSetType:resultSetConcurrency:isBinaryEncoded:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 2008);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-buildResultSetWithUpdates-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:com.mysql.jdbc.Buffer:-callingStatement:resultPacket:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 2041);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14-forceClose-com.mysql.jdbc.MysqlIO----void-"), 442);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkForOutstandingStreamingData-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 2093);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-compressPacket-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:int:int:int:-packet:offset:packetLen:headerLength:-java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 2112);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-readServerStatusForResultSets-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:-rowPacket:-java.sql.SQLException:-void-"), 2162);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createSocketFactory-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-com.mysql.jdbc.SocketFactory-"), 2184);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-enqueuePacketForDebugging-com.mysql.jdbc.MysqlIO-boolean:boolean:int:[B:com.mysql.jdbc.Buffer:-isPacketBeingSent:isPacketReused:sendLength:header:packet:-java.sql.SQLException:-void-"), 2204);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-readChannelFully-com.mysql.jdbc.MysqlIO-java.nio.ByteBuffer:int:-buf:length:-java.io.IOException:-void-"), 2268);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-readSingleRowSet-com.mysql.jdbc.MysqlIO-long:int:int:boolean:[Lcom.mysql.jdbc.Field;:-columnCount:maxRows:resultSetConcurrency:isBinaryEncoded:fields:-java.sql.SQLException:-com.mysql.jdbc.RowData-"), 2287);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-readViaChannel-com.mysql.jdbc.MysqlIO---java.io.IOException:java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 2318);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reclaimLargeReusablePacket-com.mysql.jdbc.MysqlIO----void-"), 2357);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-reuseAndReadPacket-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:-reuse:-java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 2376);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14-readPacket-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 482);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkPacketSequencing-com.mysql.jdbc.MysqlIO-byte:-multiPacketSeq:-com.mysql.jdbc.CommunicationsException:-void-"), 2617);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-send-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:-packet:-java.sql.SQLException:-void-"), 2649);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-enableMultiQueries-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 2661);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-disableMultiQueries-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 2670);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-send-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:int:-packet:packetLen:-java.sql.SQLException:-void-"), 2681);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-sendFileToServer-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Statement:java.lang.String:-callingStatement:fileName:-java.sql.SQLException:-com.mysql.jdbc.ResultSet-"), 2775);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkErrorPacket-com.mysql.jdbc.MysqlIO-int:-command:-java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 2900);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-sendSplitPackets-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:-packet:-java.sql.SQLException:-void-"), 3023);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-sendSplitPacketsViaChannel-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:-packet:-java.sql.SQLException:-void-"), 3141);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reclaimLargeSharedSendPacket-com.mysql.jdbc.MysqlIO----void-"), 3247);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14-unpackField-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:boolean:-packet:extractDefaultValues:-java.sql.SQLException:-com.mysql.jdbc.Field-"), 578);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reuseAndReadViaChannel-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:-reuse:-java.sql.SQLException:-com.mysql.jdbc.Buffer-"), 3257);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-hadWarnings-com.mysql.jdbc.MysqlIO----boolean-"), 3455);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-scanForAndThrowDataTruncation-com.mysql.jdbc.MysqlIO---java.sql.SQLException:-void-"), 3459);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-secureAuth-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:int:java.lang.String:java.lang.String:java.lang.String:boolean:-packet:packLength:user:password:database:writeClientParams:-java.sql.SQLException:-void-"), 3482);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-secureAuth411-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:int:java.lang.String:java.lang.String:java.lang.String:boolean:-packet:packLength:user:password:database:writeClientParams:-java.sql.SQLException:-void-"), 3647);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-unpackBinaryResultSetRow-com.mysql.jdbc.MysqlIO-[Lcom.mysql.jdbc.Field;:com.mysql.jdbc.Buffer:int:-fields:binaryData:resultSetConcurrency:-java.sql.SQLException:-[Ljava.lang.Object;-"), 3732);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-extractNativeEncodedColumn-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:[Lcom.mysql.jdbc.Field;:int:[Ljava.lang.Object;:-binaryData:fields:columnIndex:unpackedRowData:-java.sql.SQLException:-void-"), 3783);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-unpackNativeEncodedColumn-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:[Lcom.mysql.jdbc.Field;:int:[Ljava.lang.Object;:-binaryData:fields:columnIndex:unpackedRowData:-java.sql.SQLException:-void-"), 3866);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-sendViaChannel-com.mysql.jdbc.MysqlIO-com.mysql.jdbc.Buffer:int:-packet:packetLength:-java.sql.SQLException:-void-"), 4214);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getCalendarInstanceForSessionOrNew-com.mysql.jdbc.MysqlIO----java.util.Calendar-"), 4244);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-adjustStartForFieldLength-com.mysql.jdbc.MysqlIO-int:int:-nameStart:nameLength:--int-"), 689);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-negotiateSSLConnection-com.mysql.jdbc.MysqlIO-java.lang.String:java.lang.String:java.lang.String:int:-user:password:database:packLength:-java.sql.SQLException:com.mysql.jdbc.CommunicationsException:-void-"), 4265);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isSetNeededForAutoCommitMode-com.mysql.jdbc.MysqlIO-boolean:-autoCommitFlag:--boolean-"), 705);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-changeUser-com.mysql.jdbc.MysqlIO-java.lang.String:java.lang.String:java.lang.String:-userName:password:database:-java.sql.SQLException:-void-"), 736);
        maxBufferSize = 65535;
        jvmPlatformCharset = null;
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter(new ByteArrayOutputStream());
            jvmPlatformCharset = outWriter.getEncoding();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            try {
                if (outWriter == null) throw throwable;
                outWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (outWriter == null) return;
        outWriter.close();
    }

    public MysqlIO(String host, int port, Properties props, String socketFactoryClassName, Connection conn, int socketTimeout) throws IOException, SQLException {
        this.connection = conn;
        if (this.connection.getEnablePacketDebug()) {
            this.packetDebugRingBuffer = new LinkedList();
        }
        this.logSlowQueries = this.connection.getLogSlowQueries();
        this.useNewIo = this.connection.getUseNewIo();
        this.reusablePacket = this.useNewIo ? Buffer.allocateDirect(this.connection.getNetBufferLength(), true) : Buffer.allocateNew(this.connection.getNetBufferLength(), false);
        this.port = port;
        this.host = host;
        if (!this.useNewIo) {
            this.socketFactoryClassName = socketFactoryClassName;
            this.socketFactory = this.createSocketFactory();
            this.mysqlConnection = this.socketFactory.connect(this.host, this.port, props);
            if (socketTimeout != 0) {
                try {
                    this.mysqlConnection.setSoTimeout(socketTimeout);
                }
                catch (Exception exception) {}
            }
            this.mysqlConnection = this.socketFactory.beforeHandshake();
            this.mysqlInput = this.connection.getUseReadAheadInput() ? new ReadAheadInputStream(this.mysqlConnection.getInputStream(), 16384, this.connection.getTraceProtocol(), this.connection.getLog()) : (this.connection.useUnbufferedInput() ? this.mysqlConnection.getInputStream() : new BufferedInputStream(this.mysqlConnection.getInputStream(), 16384));
            this.mysqlOutput = new BufferedOutputStream(this.mysqlConnection.getOutputStream(), 16384);
        } else {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(true);
            this.socketChannel.connect(new InetSocketAddress(host, port));
            this.channelClearBuf = ByteBuffer.allocate(4096);
            this.mysqlInput = this.socketChannel.socket().getInputStream();
        }
        this.isInteractiveClient = this.connection.getInteractiveClient();
        this.profileSql = this.connection.getProfileSql();
        this.sessionCalendar = Calendar.getInstance();
        this.autoGenerateTestcaseScript = this.connection.getAutoGenerateTestcaseScript();
        this.needToGrabQueryFromPacket = this.profileSql || this.logSlowQueries || this.autoGenerateTestcaseScript;
    }

    public boolean hasLongColumnInfo() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.hasLongColumnInfo;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    protected boolean isDataAvailable() throws SQLException {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            bl = !this.useNewIo ? this.mysqlInput.available() > 0 : false;
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        boolean bl2 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    protected long getLastPacketSentTimeMs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = this.lastPacketSentTimeMs;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    /*
     * WARNING - void declaration
     */
    protected ResultSet getResultSet(Statement statement, long l, int n, int n2, int n3, boolean bl, String string, boolean bl2, boolean bl3) throws SQLException {
        void resultSetType;
        void catalog;
        void callingStatement;
        ResultSet rs;
        void isBinaryEncoded;
        void resultSetConcurrency;
        void streamResults;
        Buffer packet;
        void columnCount;
        void unpackFieldInfo;
        Statement statement2 = statement;
        long l2 = l;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        boolean bl4 = bl;
        String string2 = string;
        boolean bl5 = bl2;
        boolean bl6 = bl3;
        Object[] objectArray = new Object[]{statement2, Conversions.longObject((long)l2), Conversions.intObject((int)n4), Conversions.intObject((int)n5), Conversions.intObject((int)n6), Conversions.booleanObject((boolean)bl4), string2, Conversions.booleanObject((boolean)bl5), Conversions.booleanObject((boolean)bl6)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Field[] fields = null;
        if (unpackFieldInfo != false) {
            fields = new Field[(int)columnCount];
        }
        int i = 0;
        while ((long)i < columnCount) {
            Buffer fieldPacket = null;
            if (this.useNewIo) {
                packet = this.reuseAndReadPacket(this.reusablePacket);
                if (unpackFieldInfo != false) {
                    fieldPacket = new ByteArrayBuffer(packet.getByteBuffer());
                }
            } else {
                fieldPacket = this.readPacket();
            }
            if (unpackFieldInfo != false) {
                fields[i] = this.unpackField(fieldPacket, false);
            }
            ++i;
        }
        packet = this.reuseAndReadPacket(this.reusablePacket);
        RowData rowData = null;
        if (streamResults == false) {
            void maxRows;
            rowData = this.readSingleRowSet((long)columnCount, (int)maxRows, (int)resultSetConcurrency, (boolean)isBinaryEncoded, fields);
        } else {
            this.streamingData = rowData = new RowDataDynamic(this, (int)columnCount, fields, (boolean)isBinaryEncoded);
        }
        ResultSet resultSet = rs = this.buildResultSetWithRows((Statement)callingStatement, (String)catalog, fields, rowData, (int)resultSetType, (int)resultSetConcurrency, (boolean)isBinaryEncoded);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    protected final void forceClose() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            if (this.mysqlInput != null) {
                this.mysqlInput.close();
            }
        }
        catch (IOException iOException) {
            this.mysqlInput = null;
        }
        try {
            if (this.mysqlOutput != null) {
                this.mysqlOutput.close();
            }
        }
        catch (IOException iOException) {
            this.mysqlOutput = null;
        }
        try {
            if (this.mysqlConnection != null) {
                this.mysqlConnection.close();
            }
        }
        catch (IOException iOException) {
            this.mysqlConnection = null;
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected final Buffer readPacket() throws SQLException {
        Buffer buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            if (!this.useNewIo) {
                int lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
                if (lengthRead < 4) {
                    this.forceClose();
                    throw new IOException(Messages.getString("MysqlIO.1"));
                }
                int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
                if (this.traceProtocol) {
                    StringBuffer traceMessageBuf = new StringBuffer();
                    traceMessageBuf.append(Messages.getString("MysqlIO.2"));
                    traceMessageBuf.append(packetLength);
                    traceMessageBuf.append(Messages.getString("MysqlIO.3"));
                    traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                    this.connection.getLog().logTrace(traceMessageBuf.toString());
                }
                byte multiPacketSeq = this.packetHeaderBuf[3];
                if (!this.packetSequenceReset) {
                    if (this.enablePacketDebug && this.checkPacketSequence) {
                        this.checkPacketSequencing(multiPacketSeq);
                    }
                } else {
                    this.packetSequenceReset = false;
                }
                this.readPacketSequence = multiPacketSeq;
                byte[] buffer2 = new byte[packetLength + 1];
                int numBytesRead = this.readFully(this.mysqlInput, buffer2, 0, packetLength);
                if (numBytesRead != packetLength) {
                    throw new IOException("Short read, expected " + packetLength + " bytes, only read " + numBytesRead);
                }
                buffer2[packetLength] = 0;
                Buffer packet = Buffer.allocateNew(buffer2, this.useNewIo);
                packet.setBufLength(packetLength + 1);
                if (this.traceProtocol) {
                    StringBuffer traceMessageBuf = new StringBuffer();
                    traceMessageBuf.append(Messages.getString("MysqlIO.4"));
                    traceMessageBuf.append(MysqlIO.getPacketDumpToLog(packet, packetLength));
                    this.connection.getLog().logTrace(traceMessageBuf.toString());
                }
                if (this.enablePacketDebug) {
                    this.enqueuePacketForDebugging(false, false, 0, this.packetHeaderBuf, packet);
                }
                buffer = packet;
            } else {
                buffer = this.readViaChannel();
            }
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        catch (OutOfMemoryError oom) {
            try {
                this.connection.realClose(false, false, true, oom);
            }
            catch (Throwable throwable) {}
            throw oom;
        }
        Buffer buffer3 = buffer;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer3, joinPoint);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    protected final Field unpackField(Buffer buffer, boolean bl) throws SQLException {
        Field field;
        void packet;
        Buffer buffer2 = buffer;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)buffer2, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.use41Extensions) {
            Field field2;
            void extractDefaultValues;
            if (this.has41NewNewProt) {
                int catalogNameStart = packet.getPosition() + 1;
                int catalogNameLength = packet.fastSkipLenString();
                catalogNameStart = this.adjustStartForFieldLength(catalogNameStart, catalogNameLength);
            }
            int databaseNameStart = packet.getPosition() + 1;
            int databaseNameLength = packet.fastSkipLenString();
            databaseNameStart = this.adjustStartForFieldLength(databaseNameStart, databaseNameLength);
            int tableNameStart = packet.getPosition() + 1;
            int tableNameLength = packet.fastSkipLenString();
            tableNameStart = this.adjustStartForFieldLength(tableNameStart, tableNameLength);
            int originalTableNameStart = packet.getPosition() + 1;
            int originalTableNameLength = packet.fastSkipLenString();
            originalTableNameStart = this.adjustStartForFieldLength(originalTableNameStart, originalTableNameLength);
            int nameStart = packet.getPosition() + 1;
            int nameLength = packet.fastSkipLenString();
            nameStart = this.adjustStartForFieldLength(nameStart, nameLength);
            int originalColumnNameStart = packet.getPosition() + 1;
            int originalColumnNameLength = packet.fastSkipLenString();
            originalColumnNameStart = this.adjustStartForFieldLength(originalColumnNameStart, originalColumnNameLength);
            packet.readByte();
            short charSetNumber = (short)packet.readInt();
            long colLength = 0L;
            colLength = this.has41NewNewProt ? packet.readLong() : (long)packet.readLongInt();
            int colType = packet.readByte() & 0xFF;
            short colFlag = 0;
            colFlag = this.hasLongColumnInfo ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
            int colDecimals = packet.readByte() & 0xFF;
            int defaultValueStart = -1;
            int defaultValueLength = -1;
            if (extractDefaultValues != false) {
                defaultValueStart = packet.getPosition() + 1;
                defaultValueLength = packet.fastSkipLenString();
            }
            field = field2 = new Field(this.connection, packet.getByteBuffer(), databaseNameStart, databaseNameLength, tableNameStart, tableNameLength, originalTableNameStart, originalTableNameLength, nameStart, nameLength, originalColumnNameStart, originalColumnNameLength, colLength, colType, colFlag, colDecimals, defaultValueStart, defaultValueLength, charSetNumber);
        } else {
            Field field3;
            int tableNameStart = packet.getPosition() + 1;
            int tableNameLength = packet.fastSkipLenString();
            tableNameStart = this.adjustStartForFieldLength(tableNameStart, tableNameLength);
            int nameStart = packet.getPosition() + 1;
            int nameLength = packet.fastSkipLenString();
            nameStart = this.adjustStartForFieldLength(nameStart, nameLength);
            int colLength = packet.readnBytes();
            int colType = packet.readnBytes();
            packet.readByte();
            short colFlag = 0;
            colFlag = this.hasLongColumnInfo ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
            int colDecimals = packet.readByte() & 0xFF;
            if (this.colDecimalNeedsBump) {
                ++colDecimals;
            }
            field = field3 = new Field(this.connection, packet.getByteBuffer(), nameStart, nameLength, tableNameStart, tableNameLength, colLength, colType, colFlag, colDecimals);
        }
        Field field4 = field;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(field4, joinPoint);
        return field;
    }

    /*
     * WARNING - void declaration
     */
    private int adjustStartForFieldLength(int n, int n2) {
        void nameStart;
        void nameLength;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        void var6_6 = nameLength < 251 ? nameStart : (nameLength >= 251 && nameLength < 65536 ? nameStart + 2 : (nameLength >= 65536 && nameLength < 0x1000000 ? nameStart + 3 : nameStart + 8));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)var6_6), joinPoint);
        return (int)var6_6;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSetNeededForAutoCommitMode(boolean bl) {
        boolean bl2;
        boolean bl3 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.use41Extensions && this.connection.getElideSetAutoCommits()) {
            void autoCommitFlag;
            boolean autoCommitModeOnServer;
            boolean bl4 = autoCommitModeOnServer = (this.serverStatus & 2) != 0;
            if (autoCommitFlag == false) {
                boolean inTransactionOnServer;
                boolean bl5 = inTransactionOnServer = (this.serverStatus & 1) != 0;
                bl2 = !inTransactionOnServer;
            } else {
                bl2 = !autoCommitModeOnServer;
            }
        } else {
            bl2 = true;
        }
        boolean bl6 = bl2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl6), joinPoint);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    protected void changeUser(String string, String string2, String string3) throws SQLException {
        void database;
        void password;
        void userName;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.packetSequence = (byte)-1;
        int passwordLength = 16;
        int userLength = 0;
        if (userName != null) {
            userLength = userName.length();
        }
        int packLength = userLength + passwordLength + 7 + 4;
        if ((this.serverCapabilities & 0x8000) != 0) {
            Buffer changeUserPacket = Buffer.allocateNew(packLength + 1, this.useNewIo);
            changeUserPacket.writeByte((byte)17);
            if (this.versionMeetsMinimum(4, 1, 1)) {
                this.secureAuth411(changeUserPacket, packLength, (String)userName, (String)password, (String)database, false);
            } else {
                this.secureAuth(changeUserPacket, packLength, (String)userName, (String)password, (String)database, false);
            }
        } else {
            boolean localUseConnectWithDb;
            Buffer packet = Buffer.allocateNew(packLength, this.useNewIo);
            packet.writeByte((byte)17);
            packet.writeString((String)userName);
            if (this.protocolVersion > 9) {
                packet.writeString(Util.newCrypt((String)password, this.seed));
            } else {
                packet.writeString(Util.oldCrypt((String)password, this.seed));
            }
            boolean bl = localUseConnectWithDb = this.useConnectWithDb && database != null && database.length() > 0;
            if (localUseConnectWithDb) {
                packet.writeString((String)database);
            }
            this.send(packet);
            this.checkErrorPacket();
            if (!localUseConnectWithDb) {
                this.changeDatabaseTo((String)database);
            }
        }
        Object var14_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var14_15, joinPoint);
    }

    protected Buffer checkErrorPacket() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buffer = this.checkErrorPacket(-1);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    protected void checkForCharsetMismatch() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.connection.getUseUnicode() && this.connection.getEncoding() != null) {
            String encodingToCheck = jvmPlatformCharset;
            if (encodingToCheck == null) {
                encodingToCheck = System.getProperty("file.encoding");
            }
            this.platformDbCharsetMatches = encodingToCheck == null ? false : encodingToCheck.equals(this.connection.getEncoding());
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void clearInputStream() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.useNewIo) {
            try {
                int len = this.mysqlInput.available();
                while (len > 0) {
                    this.mysqlInput.skip(len);
                    len = this.mysqlInput.available();
                }
            }
            catch (IOException ioEx) {
                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
            }
        }
        try {
            try {
                this.socketChannel.configureBlocking(false);
                int ioEx = 0;
                while ((ioEx = this.socketChannel.read(this.channelClearBuf)) != 0 && ioEx != -1) {
                    this.channelClearBuf.clear();
                }
            }
            catch (IOException ioEx) {
                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
            }
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            try {
                this.socketChannel.configureBlocking(true);
                throw throwable;
            }
            catch (IOException ioEx) {
                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
            }
        }
        {
            Object var2_8 = null;
        }
        try {}
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        this.socketChannel.configureBlocking(true);
        Object var6_11 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_11, joinPoint);
    }

    protected void resetReadPacketSequence() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.readPacketSequence = 0;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected void dumpPacketRingBuffer() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.packetDebugRingBuffer != null && this.connection.getEnablePacketDebug()) {
            StringBuffer dumpBuffer = new StringBuffer();
            dumpBuffer.append("Last " + this.packetDebugRingBuffer.size() + " packets received from server, from oldest->newest:\n");
            dumpBuffer.append("\n");
            Iterator ringBufIter = this.packetDebugRingBuffer.iterator();
            while (ringBufIter.hasNext()) {
                dumpBuffer.append((StringBuffer)ringBufIter.next());
                dumpBuffer.append("\n");
            }
            this.connection.getLog().logTrace(dumpBuffer.toString());
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void explainSlowQuery(byte[] byArray, String string) throws SQLException {
        void truncatedQuery;
        byte[] byArray2 = byArray;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)byArray2, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (StringUtils.startsWithIgnoreCaseAndWs((String)truncatedQuery, "SELECT")) {
            PreparedStatement stmt;
            block9: {
                stmt = null;
                java.sql.ResultSet rs = null;
                try {
                    try {
                        void querySQL;
                        stmt = this.connection.clientPrepareStatement("EXPLAIN ?");
                        stmt.setBytesNoEscapeNoQuotes(1, (byte[])querySQL);
                        rs = stmt.executeQuery();
                        StringBuffer explainResults = new StringBuffer(String.valueOf(Messages.getString("MysqlIO.8")) + (String)truncatedQuery + Messages.getString("MysqlIO.9"));
                        ResultSetUtil.appendResultSetSlashGStyle(explainResults, rs);
                        this.connection.getLog().logWarn(explainResults.toString());
                    }
                    catch (SQLException sQLException) {}
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                {
                    Object var6_11 = null;
                    if (rs == null) break block9;
                }
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        Object var11_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var11_12, joinPoint);
    }

    static int getMaxBuf() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = maxBufferSize;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final int getServerMajorVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.serverMajorVersion;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final int getServerMinorVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.serverMinorVersion;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final int getServerSubMinorVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.serverSubMinorVersion;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    String getServerVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.serverVersion;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    void doHandshake(String string, String string2, String string3) throws SQLException {
        void password;
        void user;
        void database;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkPacketSequence = false;
        this.readPacketSequence = 0;
        Buffer buf = this.readPacket();
        this.protocolVersion = buf.readByte();
        if (this.protocolVersion == -1) {
            try {
                this.mysqlConnection.close();
            }
            catch (Exception exception) {}
            int errno = 2000;
            errno = buf.readInt();
            String serverErrorMessage = buf.readString();
            StringBuffer errorBuf = new StringBuffer(Messages.getString("MysqlIO.10"));
            errorBuf.append(serverErrorMessage);
            errorBuf.append("\"");
            String xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
            throw new SQLException(String.valueOf(SQLError.get(xOpen)) + ", " + errorBuf.toString(), xOpen, errno);
        }
        this.serverVersion = buf.readString();
        int point = this.serverVersion.indexOf(".");
        if (point != -1) {
            try {
                int n;
                this.serverMajorVersion = n = Integer.parseInt(this.serverVersion.substring(0, point));
            }
            catch (NumberFormatException numberFormatException) {}
            String remaining = this.serverVersion.substring(point + 1, this.serverVersion.length());
            point = remaining.indexOf(".");
            if (point != -1) {
                try {
                    int n;
                    this.serverMinorVersion = n = Integer.parseInt(remaining.substring(0, point));
                }
                catch (NumberFormatException numberFormatException) {}
                remaining = remaining.substring(point + 1, remaining.length());
                int pos = 0;
                while (pos < remaining.length()) {
                    if (remaining.charAt(pos) < '0' || remaining.charAt(pos) > '9') break;
                    ++pos;
                }
                try {
                    int n;
                    this.serverSubMinorVersion = n = Integer.parseInt(remaining.substring(0, pos));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (this.versionMeetsMinimum(4, 0, 8)) {
            this.maxThreeBytes = 0xFFFFFF;
            this.useNewLargePackets = true;
        } else {
            this.maxThreeBytes = 16581375;
            this.useNewLargePackets = false;
        }
        this.colDecimalNeedsBump = this.versionMeetsMinimum(3, 23, 0);
        this.colDecimalNeedsBump = !this.versionMeetsMinimum(3, 23, 15);
        this.useNewUpdateCounts = this.versionMeetsMinimum(3, 22, 5);
        buf.readLong();
        this.seed = buf.readString();
        this.serverCapabilities = 0;
        if (buf.getPosition() < buf.getBufLength()) {
            this.serverCapabilities = buf.readInt();
        }
        if (this.versionMeetsMinimum(4, 1, 1)) {
            int position = buf.getPosition();
            this.serverCharsetIndex = buf.readByte() & 0xFF;
            this.serverStatus = buf.readInt();
            buf.setPosition(position + 16);
            String seedPart2 = buf.readString();
            StringBuffer newSeed = new StringBuffer(20);
            newSeed.append(this.seed);
            newSeed.append(seedPart2);
            this.seed = newSeed.toString();
        }
        if ((this.serverCapabilities & 0x20) != 0 && this.connection.getUseCompression()) {
            this.clientParam |= 0x20L;
        }
        boolean bl = this.useConnectWithDb = database != null && database.length() > 0 && !this.connection.getCreateDatabaseIfNotExist();
        if (this.useConnectWithDb) {
            this.clientParam |= 8L;
        }
        if ((this.serverCapabilities & 0x800) == 0 && this.connection.getUseSSL()) {
            if (this.connection.getRequireSSL()) {
                this.connection.close();
                this.forceClose();
                throw new SQLException(Messages.getString("MysqlIO.15"), "08001");
            }
            this.connection.setUseSSL(false);
        }
        if ((this.serverCapabilities & 4) != 0) {
            this.clientParam |= 4L;
            this.hasLongColumnInfo = true;
        }
        this.clientParam |= 2L;
        if (this.connection.getAllowLoadLocalInfile()) {
            this.clientParam |= 0x80L;
        }
        if (this.isInteractiveClient) {
            this.clientParam |= 0x400L;
        }
        this.clientParam = this.protocolVersion > 9 ? (this.clientParam |= 1L) : (this.clientParam &= 0xFFFFFFFFFFFFFFFEL);
        if (this.versionMeetsMinimum(4, 1, 0)) {
            if (this.versionMeetsMinimum(4, 1, 1)) {
                this.clientParam |= 0x200L;
                this.has41NewNewProt = true;
                this.clientParam |= 0x2000L;
                this.clientParam |= 0x20000L;
                if (this.connection.getAllowMultiQueries()) {
                    this.clientParam |= 0x10000L;
                }
            } else {
                this.clientParam |= 0x4000L;
                this.has41NewNewProt = false;
            }
            this.use41Extensions = true;
        }
        int passwordLength = 16;
        int userLength = 0;
        int databaseLength = 0;
        if (user != null) {
            userLength = user.length();
        }
        if (database != null) {
            databaseLength = database.length();
        }
        int packLength = userLength + passwordLength + databaseLength + 7 + 4;
        Buffer packet = null;
        if (!this.connection.getUseSSL()) {
            if ((this.serverCapabilities & 0x8000) != 0) {
                this.clientParam |= 0x8000L;
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    this.secureAuth411(null, packLength, (String)user, (String)password, (String)database, true);
                } else {
                    this.secureAuth(null, packLength, (String)user, (String)password, (String)database, true);
                }
            } else {
                packet = Buffer.allocateNew(packLength, this.useNewIo);
                if ((this.clientParam & 0x4000L) != 0L) {
                    if (this.versionMeetsMinimum(4, 1, 1)) {
                        packet.writeLong(this.clientParam);
                        packet.writeLong(this.maxThreeBytes);
                        packet.writeByte((byte)8);
                        packet.writeBytesNoNull(new byte[23]);
                    } else {
                        packet.writeLong(this.clientParam);
                        packet.writeLong(this.maxThreeBytes);
                    }
                } else {
                    packet.writeInt((int)this.clientParam);
                    packet.writeLongInt(this.maxThreeBytes);
                }
                packet.writeString((String)user);
                if (this.protocolVersion > 9) {
                    packet.writeString(Util.newCrypt((String)password, this.seed));
                } else {
                    packet.writeString(Util.oldCrypt((String)password, this.seed));
                }
                if (this.useConnectWithDb) {
                    packet.writeString((String)database);
                }
                this.send(packet);
            }
        } else {
            this.negotiateSSLConnection((String)user, (String)password, (String)database, packLength);
        }
        if (!this.versionMeetsMinimum(4, 1, 1)) {
            this.checkErrorPacket();
        }
        if ((this.serverCapabilities & 0x20) != 0 && this.connection.getUseCompression()) {
            this.deflater = new Deflater();
            this.useCompression = true;
            this.mysqlInput = new CompressedInputStream(this.connection, this.mysqlInput);
        }
        if (!this.useConnectWithDb) {
            this.changeDatabaseTo((String)database);
        }
        Object var16_27 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var16_27, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void changeDatabaseTo(String string) throws SQLException, CommunicationsException {
        void database;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (database != null && database.length() != 0) {
            try {
                this.sendCommand(2, (String)database, null, false, null);
            }
            catch (Exception ex) {
                if (this.connection.getCreateDatabaseIfNotExist()) {
                    this.sendCommand(3, "CREATE DATABASE IF NOT EXISTS " + (String)database, null, false, null);
                    this.sendCommand(2, (String)database, null, false, null);
                }
                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ex);
            }
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final Object[] nextRow(Field[] fieldArray, int n, boolean bl, int n2) throws SQLException {
        Object object;
        void isBinaryEncoded;
        Field[] fieldArray2 = fieldArray;
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        Object[] objectArray = new Object[]{fieldArray2, Conversions.intObject((int)n3), Conversions.booleanObject((boolean)bl2), Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer rowPacket = this.checkErrorPacket();
        if (isBinaryEncoded == false) {
            rowPacket.setPosition(rowPacket.getPosition() - 1);
            if (!rowPacket.isLastDataPacket()) {
                void columnCount;
                byte[][] rowData = new byte[columnCount][];
                int offset = 0;
                int i = 0;
                while (i < columnCount) {
                    rowData[i] = rowPacket.readLenByteArray(offset);
                    ++i;
                }
                object = rowData;
            } else {
                this.readServerStatusForResultSets(rowPacket);
                object = null;
            }
        } else if (!rowPacket.isLastDataPacket()) {
            void resultSetConcurrency;
            void fields;
            object = this.unpackBinaryResultSetRow((Field[])fields, rowPacket, (int)resultSetConcurrency);
        } else {
            rowPacket.setPosition(rowPacket.getPosition() - 1);
            this.readServerStatusForResultSets(rowPacket);
            object = null;
        }
        Object[] objectArray2 = object;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(objectArray2, joinPoint);
        return object;
    }

    final void quit() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer packet = Buffer.allocateNew(6, this.useNewIo);
        this.packetSequence = (byte)-1;
        packet.writeByte((byte)1);
        this.send(packet);
        this.forceClose();
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    Buffer getSharedSendPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.sharedSendPacket == null) {
            this.sharedSendPacket = this.useNewIo ? Buffer.allocateDirect(this.connection.getNetBufferLength(), true) : Buffer.allocateNew(this.connection.getNetBufferLength(), false);
        }
        Buffer buffer = this.sharedSendPacket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    void closeStreamer(RowData rowData) throws SQLException {
        void streamer;
        RowData rowData2 = rowData;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)rowData2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.streamingData == null) {
            throw new SQLException(String.valueOf(Messages.getString("MysqlIO.17")) + streamer + Messages.getString("MysqlIO.18"));
        }
        if (streamer != this.streamingData) {
            throw new SQLException(String.valueOf(Messages.getString("MysqlIO.19")) + streamer + Messages.getString("MysqlIO.20") + Messages.getString("MysqlIO.21") + Messages.getString("MysqlIO.22"));
        }
        this.streamingData = null;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    ResultSet readAllResults(Statement statement, int n, int n2, int n3, boolean bl, String string, Buffer buffer, boolean bl2, long l, boolean bl3) throws SQLException {
        boolean serverHasMoreResults;
        void unpackFieldInfo;
        void preSentColumnCount;
        void isBinaryEncoded;
        void catalog;
        void streamResults;
        void resultSetConcurrency;
        void resultSetType;
        void maxRows;
        void callingStatement;
        ResultSet topLevelResultSet;
        void resultPacket;
        Statement statement2 = statement;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        boolean bl4 = bl;
        String string2 = string;
        Buffer buffer2 = buffer;
        boolean bl5 = bl2;
        long l2 = l;
        boolean bl6 = bl3;
        Object[] objectArray = new Object[]{statement2, Conversions.intObject((int)n4), Conversions.intObject((int)n5), Conversions.intObject((int)n6), Conversions.booleanObject((boolean)bl4), string2, buffer2, Conversions.booleanObject((boolean)bl5), Conversions.longObject((long)l2), Conversions.booleanObject((boolean)bl6)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        resultPacket.setPosition(resultPacket.getPosition() - 1);
        ResultSet currentResultSet = topLevelResultSet = this.readResultsForQueryOrUpdate((Statement)callingStatement, (int)maxRows, (int)resultSetType, (int)resultSetConcurrency, (boolean)streamResults, (String)catalog, (Buffer)resultPacket, (boolean)isBinaryEncoded, (long)preSentColumnCount, (boolean)unpackFieldInfo);
        boolean checkForMoreResults = (this.clientParam & 0x20000L) != 0L;
        boolean bl7 = serverHasMoreResults = (this.serverStatus & 8) != 0;
        if (serverHasMoreResults && streamResults != false) {
            this.clearInputStream();
            throw new SQLException(Messages.getString("MysqlIO.23"), "S1C00");
        }
        boolean moreRowSetsExist = checkForMoreResults & serverHasMoreResults;
        while (moreRowSetsExist) {
            Buffer fieldPacket = this.checkErrorPacket();
            fieldPacket.setPosition(0);
            if (fieldPacket.readByte(0) == 0 && fieldPacket.readByte(1) == 0 && fieldPacket.readByte(2) == 0) break;
            ResultSet newResultSet = this.readResultsForQueryOrUpdate((Statement)callingStatement, (int)maxRows, (int)resultSetType, (int)resultSetConcurrency, (boolean)streamResults, (String)catalog, fieldPacket, (boolean)isBinaryEncoded, (long)preSentColumnCount, (boolean)unpackFieldInfo);
            currentResultSet.setNextResultSet(newResultSet);
            currentResultSet = newResultSet;
            boolean bl8 = moreRowSetsExist = (this.serverStatus & 8) != 0;
        }
        if (streamResults == false) {
            this.clearInputStream();
        }
        this.reclaimLargeReusablePacket();
        ResultSet resultSet = topLevelResultSet;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    void resetMaxBuf() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.maxAllowedPacket = this.connection.getMaxAllowedPacket();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final Buffer sendCommand(int n, String string, Buffer buffer, boolean bl, String string2) throws SQLException {
        Buffer buffer2;
        int n2 = n;
        String string3 = string;
        Buffer buffer3 = buffer;
        boolean bl2 = bl;
        String string4 = string2;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2), string3, buffer3, Conversions.booleanObject((boolean)bl2), string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.enablePacketDebug = this.connection.getEnablePacketDebug();
        this.traceProtocol = this.connection.getTraceProtocol();
        this.readPacketSequence = 0;
        try {
            void skipCheck;
            void command;
            int bytesLeft;
            this.checkForOutstandingStreamingData();
            this.serverStatus = 0;
            this.hadWarnings = false;
            this.warningCount = 0;
            this.queryNoIndexUsed = false;
            this.queryBadIndexUsed = false;
            if (this.useCompression && (bytesLeft = this.mysqlInput.available()) > 0) {
                this.mysqlInput.skip(bytesLeft);
            }
            try {
                void queryPacket;
                this.clearInputStream();
                if (queryPacket == null) {
                    void extraData;
                    int packLength = 8 + (extraData != null ? extraData.length() : 0) + 2;
                    if (this.sendPacket == null) {
                        this.sendPacket = Buffer.allocateNew(packLength, this.useNewIo);
                    }
                    this.packetSequence = (byte)-1;
                    this.readPacketSequence = 0;
                    this.checkPacketSequence = true;
                    this.sendPacket.clear();
                    this.sendPacket.writeByte((byte)command);
                    if (command == 2 || command == 5 || command == 6 || command == 3 || command == 22) {
                        void extraDataCharEncoding;
                        if (extraDataCharEncoding == null) {
                            this.sendPacket.writeStringNoNull((String)extraData);
                        } else {
                            this.sendPacket.writeStringNoNull((String)extraData, (String)extraDataCharEncoding, this.connection.getServerCharacterEncoding(), this.connection.parserKnowsUnicode());
                        }
                    } else if (command == 12) {
                        long id = new Long((String)extraData);
                        this.sendPacket.writeLong(id);
                    }
                    this.send(this.sendPacket);
                } else {
                    this.packetSequence = (byte)-1;
                    this.send((Buffer)queryPacket);
                }
            }
            catch (SQLException sqlEx) {
                throw sqlEx;
            }
            catch (Exception ex) {
                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ex);
            }
            Buffer returnPacket = null;
            if (skipCheck == false) {
                if (command == 23 || command == 26) {
                    this.readPacketSequence = 0;
                    this.packetSequenceReset = true;
                }
                returnPacket = this.checkErrorPacket((int)command);
            }
            buffer2 = returnPacket;
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        Buffer buffer4 = buffer2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer4, joinPoint);
        return buffer2;
    }

    /*
     * WARNING - void declaration
     */
    final ResultSet sqlQueryDirect(Statement statement, String string, String string2, Buffer buffer, int n, Connection connection, int n2, int n3, boolean bl, String string3, boolean bl2) throws Exception {
        void unpackFieldInfo;
        void catalog;
        void streamResults;
        void resultSetConcurrency;
        void resultSetType;
        void maxRows;
        void callingStatement;
        Buffer queryPacket;
        void query;
        Statement statement2 = statement;
        String string4 = string;
        String string5 = string2;
        Buffer buffer2 = buffer;
        int n4 = n;
        Connection connection2 = connection;
        int n5 = n2;
        int n6 = n3;
        boolean bl3 = bl;
        String string6 = string3;
        boolean bl4 = bl2;
        Object[] objectArray = new Object[]{statement2, string4, string5, buffer2, Conversions.intObject((int)n4), connection2, Conversions.intObject((int)n5), Conversions.intObject((int)n6), Conversions.booleanObject((boolean)bl3), string6, Conversions.booleanObject((boolean)bl4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long queryStartTime = 0L;
        long queryEndTime = 0L;
        if (query != null) {
            void characterEncoding;
            int packLength = 5 + query.length() * 2 + 2;
            if (this.sendPacket == null) {
                this.sendPacket = this.useNewIo ? Buffer.allocateDirect(packLength, this.useNewIo) : Buffer.allocateNew(packLength, false);
            } else {
                this.sendPacket.clear();
            }
            this.sendPacket.writeByte((byte)3);
            if (characterEncoding != null) {
                if (this.platformDbCharsetMatches) {
                    this.sendPacket.writeStringNoNull((String)query, (String)characterEncoding, this.connection.getServerCharacterEncoding(), this.connection.parserKnowsUnicode());
                } else if (StringUtils.startsWithIgnoreCaseAndWs((String)query, "LOAD DATA")) {
                    this.sendPacket.writeBytesNoNull(query.getBytes());
                } else {
                    this.sendPacket.writeStringNoNull((String)query, (String)characterEncoding, this.connection.getServerCharacterEncoding(), this.connection.parserKnowsUnicode());
                }
            } else {
                this.sendPacket.writeStringNoNull((String)query);
            }
            queryPacket = this.sendPacket;
        }
        byte[] queryBuf = null;
        int oldPacketPosition = 0;
        if (this.needToGrabQueryFromPacket) {
            queryBuf = queryPacket.getByteBuffer();
            oldPacketPosition = queryPacket.getPosition();
            queryStartTime = System.currentTimeMillis();
        }
        Buffer resultPacket = this.sendCommand(3, null, queryPacket, false, null);
        long fetchBeginTime = 0L;
        long fetchEndTime = 0L;
        String profileQueryToLog = null;
        boolean queryWasSlow = false;
        if (this.profileSql || this.logSlowQueries) {
            queryEndTime = System.currentTimeMillis();
            boolean shouldExtractQuery = false;
            if (this.profileSql) {
                shouldExtractQuery = true;
            } else if (this.logSlowQueries && queryEndTime - queryStartTime >= (long)this.connection.getSlowQueryThresholdMillis()) {
                shouldExtractQuery = true;
                queryWasSlow = true;
            }
            if (shouldExtractQuery) {
                boolean truncated = false;
                int extractPosition = oldPacketPosition;
                if (oldPacketPosition > this.connection.getMaxQuerySizeToLog()) {
                    extractPosition = this.connection.getMaxQuerySizeToLog() + 5;
                    truncated = true;
                }
                profileQueryToLog = new String(queryBuf, 5, extractPosition - 5);
                if (truncated) {
                    profileQueryToLog = String.valueOf(profileQueryToLog) + Messages.getString("MysqlIO.25");
                }
            }
            fetchBeginTime = queryEndTime;
        }
        if (this.autoGenerateTestcaseScript) {
            Object testcaseQuery = null;
            testcaseQuery = query != null ? query : new String(queryBuf, 5, oldPacketPosition - 5);
            StringBuffer debugBuf = new StringBuffer(testcaseQuery.length() + 32);
            this.connection.generateConnectionCommentBlock(debugBuf);
            debugBuf.append((String)testcaseQuery);
            debugBuf.append(';');
            this.connection.dumpTestcaseQuery(debugBuf.toString());
        }
        ResultSet rs = this.readAllResults((Statement)callingStatement, (int)maxRows, (int)resultSetType, (int)resultSetConcurrency, (boolean)streamResults, (String)catalog, resultPacket, false, -1L, (boolean)unpackFieldInfo);
        if (queryWasSlow) {
            StringBuffer mesgBuf = new StringBuffer(48 + profileQueryToLog.length());
            mesgBuf.append(Messages.getString("MysqlIO.26"));
            mesgBuf.append(this.connection.getSlowQueryThresholdMillis());
            mesgBuf.append(Messages.getString("MysqlIO.26a"));
            mesgBuf.append(queryEndTime - queryStartTime);
            mesgBuf.append(Messages.getString("MysqlIO.27"));
            mesgBuf.append(profileQueryToLog);
            this.connection.getLog().logWarn(mesgBuf.toString());
            if (this.connection.getExplainSlowQueries()) {
                if (oldPacketPosition < 0x100000) {
                    this.explainSlowQuery(queryPacket.getBytes(5, oldPacketPosition - 5), profileQueryToLog);
                } else {
                    this.connection.getLog().logWarn(String.valueOf(Messages.getString("MysqlIO.28")) + 0x100000 + Messages.getString("MysqlIO.29"));
                }
            }
        }
        if (this.profileSql) {
            fetchEndTime = System.currentTimeMillis();
            ProfileEventSink eventSink = ProfileEventSink.getInstance(this.connection);
            eventSink.consumeEvent(new ProfilerEvent(3, "", (String)catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), (int)(queryEndTime - queryStartTime), null, new Throwable(), profileQueryToLog));
            eventSink.consumeEvent(new ProfilerEvent(5, "", (String)catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), (int)(fetchEndTime - fetchBeginTime), null, new Throwable(), null));
            if (this.queryBadIndexUsed) {
                eventSink.consumeEvent(new ProfilerEvent(0, "", (String)catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), (int)(queryEndTime - queryStartTime), null, new Throwable(), String.valueOf(Messages.getString("MysqlIO.33")) + profileQueryToLog));
            }
            if (this.queryNoIndexUsed) {
                eventSink.consumeEvent(new ProfilerEvent(0, "", (String)catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), (int)(queryEndTime - queryStartTime), null, new Throwable(), String.valueOf(Messages.getString("MysqlIO.35")) + profileQueryToLog));
            }
        }
        if (this.hadWarnings) {
            this.scanForAndThrowDataTruncation();
        }
        ResultSet resultSet = rs;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    String getHost() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.host;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    boolean isVersion(int n, int n2, int n3) {
        void subminor;
        void minor;
        void major;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n4), Conversions.intObject((int)n5), Conversions.intObject((int)n6)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = major == this.getServerMajorVersion() && minor == this.getServerMinorVersion() && subminor == this.getServerSubMinorVersion();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    boolean versionMeetsMinimum(int n, int n2, int n3) {
        void subminor;
        void minor;
        void major;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n4), Conversions.intObject((int)n5), Conversions.intObject((int)n6)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.getServerMajorVersion() >= major ? (this.getServerMajorVersion() == major ? (this.getServerMinorVersion() >= minor ? (this.getServerMinorVersion() == minor ? this.getServerSubMinorVersion() >= subminor : true) : false) : true) : false;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getPacketDumpToLog(Buffer buffer, int n) {
        String string;
        Buffer packetToDump;
        void packetLength;
        Buffer buffer2 = buffer;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, null, null, (Object)buffer2, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (packetLength < 1024) {
            string = packetToDump.dump((int)packetLength);
        } else {
            StringBuffer packetDumpBuf = new StringBuffer(4096);
            packetDumpBuf.append(packetToDump.dump(1024));
            packetDumpBuf.append(Messages.getString("MysqlIO.36"));
            packetDumpBuf.append(1024);
            packetDumpBuf.append(Messages.getString("MysqlIO.37"));
            string = packetDumpBuf.toString();
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        void len;
        InputStream inputStream2 = inputStream;
        byte[] byArray2 = byArray;
        int n3 = n;
        int n4 = n2;
        Object[] objectArray = new Object[]{inputStream2, byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = 0;
        while (n5 < len) {
            void off;
            void b;
            void in;
            int count = in.read((byte[])b, (int)(off + n5), (int)(len - n5));
            if (count < 0) {
                throw new EOFException();
            }
            n5 += count;
        }
        int n6 = n5;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n6), joinPoint);
        return n6;
    }

    /*
     * WARNING - void declaration
     */
    private final ResultSet readResultsForQueryOrUpdate(Statement statement, int n, int n2, int n3, boolean bl, String string, Buffer buffer, boolean bl2, long l, boolean bl3) throws SQLException {
        ResultSet resultSet;
        void callingStatement;
        void resultPacket;
        Statement statement2 = statement;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        boolean bl4 = bl;
        String string2 = string;
        Buffer buffer2 = buffer;
        boolean bl5 = bl2;
        long l2 = l;
        boolean bl6 = bl3;
        Object[] objectArray = new Object[]{statement2, Conversions.intObject((int)n4), Conversions.intObject((int)n5), Conversions.intObject((int)n6), Conversions.booleanObject((boolean)bl4), string2, buffer2, Conversions.booleanObject((boolean)bl5), Conversions.longObject((long)l2), Conversions.booleanObject((boolean)bl6)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long columnCount = resultPacket.readFieldLength();
        if (columnCount == 0L) {
            resultSet = this.buildResultSetWithUpdates((Statement)callingStatement, (Buffer)resultPacket);
        } else if (columnCount == -1L) {
            String charEncoding = null;
            if (this.connection.getUseUnicode()) {
                charEncoding = this.connection.getEncoding();
            }
            String fileName = null;
            fileName = this.platformDbCharsetMatches ? (charEncoding != null ? resultPacket.readString(charEncoding) : resultPacket.readString()) : resultPacket.readString();
            resultSet = this.sendFileToServer((Statement)callingStatement, fileName);
        } else {
            void unpackFieldInfo;
            void isBinaryEncoded;
            void catalog;
            void streamResults;
            void resultSetConcurrency;
            void resultSetType;
            void maxRows;
            ResultSet results;
            resultSet = results = this.getResultSet((Statement)callingStatement, columnCount, (int)maxRows, (int)resultSetType, (int)resultSetConcurrency, (boolean)streamResults, (String)catalog, (boolean)isBinaryEncoded, (boolean)unpackFieldInfo);
        }
        ResultSet resultSet2 = resultSet;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet2, joinPoint);
        return resultSet;
    }

    /*
     * WARNING - void declaration
     */
    private int alignPacketSize(int n, int n2) {
        void l;
        void a;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n5 = a + l - true & ~(l - true);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n5), joinPoint);
        return n5;
    }

    /*
     * WARNING - void declaration
     */
    private ResultSet buildResultSetWithRows(Statement statement, String string, Field[] fieldArray, RowData rowData, int n, int n2, boolean bl) throws SQLException {
        ResultSet resultSet;
        JoinPoint joinPoint;
        block4: {
            void resultSetType;
            void resultSetConcurrency;
            Statement statement2 = statement;
            String string2 = string;
            Field[] fieldArray2 = fieldArray;
            RowData rowData2 = rowData;
            int n3 = n;
            int n4 = n2;
            boolean bl2 = bl;
            Object[] objectArray = new Object[]{statement2, string2, fieldArray2, rowData2, Conversions.intObject((int)n3), Conversions.intObject((int)n4), Conversions.booleanObject((boolean)bl2)};
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            ResultSet rs = null;
            switch (resultSetConcurrency) {
                case 1007: {
                    void isBinaryEncoded;
                    void callingStatement;
                    void rows;
                    void fields;
                    void catalog;
                    rs = new ResultSet((String)catalog, (Field[])fields, (RowData)rows, this.connection, (Statement)callingStatement);
                    if (isBinaryEncoded == false) break;
                    rs.setBinaryEncoded();
                    break;
                }
                case 1008: {
                    void callingStatement;
                    void rows;
                    void fields;
                    void catalog;
                    rs = new UpdatableResultSet((String)catalog, (Field[])fields, (RowData)rows, this.connection, (Statement)callingStatement);
                    break;
                }
                default: {
                    void callingStatement;
                    void rows;
                    void fields;
                    void catalog;
                    resultSet = new ResultSet((String)catalog, (Field[])fields, (RowData)rows, this.connection, (Statement)callingStatement);
                    break block4;
                }
            }
            rs.setResultSetType((int)resultSetType);
            rs.setResultSetConcurrency((int)resultSetConcurrency);
            resultSet = rs;
        }
        ResultSet resultSet2 = resultSet;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet2, joinPoint);
        return resultSet;
    }

    /*
     * WARNING - void declaration
     */
    private ResultSet buildResultSetWithUpdates(Statement statement, Buffer buffer) throws SQLException {
        void callingStatement;
        Statement statement2 = statement;
        Buffer buffer2 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)statement2, (Object)buffer2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long updateCount = -1L;
        long updateID = -1L;
        String info = null;
        try {
            void resultPacket;
            if (this.useNewUpdateCounts) {
                updateCount = resultPacket.newReadLength();
                updateID = resultPacket.newReadLength();
            } else {
                updateCount = resultPacket.readLength();
                updateID = resultPacket.readLength();
            }
            if (this.use41Extensions) {
                this.serverStatus = resultPacket.readInt();
                this.warningCount = resultPacket.readInt();
                if (this.warningCount > 0) {
                    this.hadWarnings = true;
                }
                resultPacket.readByte();
                if (this.profileSql) {
                    this.queryNoIndexUsed = (this.serverStatus & 0x10) != 0;
                    boolean bl = this.queryBadIndexUsed = (this.serverStatus & 0x20) != 0;
                }
            }
            if (this.connection.isReadInfoMsgEnabled()) {
                info = resultPacket.readString();
            }
        }
        catch (Exception ex) {
            throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + ex.getClass().getName(), "S1000", -1);
        }
        ResultSet updateRs = new ResultSet(updateCount, updateID, this.connection, (Statement)callingStatement);
        if (info != null) {
            updateRs.setServerInfo(info);
        }
        ResultSet resultSet = updateRs;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    private void checkForOutstandingStreamingData() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.streamingData != null) {
            if (!this.connection.getClobberStreamingResults()) {
                throw new SQLException(String.valueOf(Messages.getString("MysqlIO.39")) + this.streamingData + Messages.getString("MysqlIO.40") + Messages.getString("MysqlIO.41") + Messages.getString("MysqlIO.42"));
            }
            this.streamingData.getOwner().realClose(false);
            this.clearInputStream();
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private Buffer compressPacket(Buffer buffer, int n, int n2, int n3) throws SQLException {
        void offset;
        void headerLength;
        void packetLen;
        void packet;
        Buffer buffer2 = buffer;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        Object[] objectArray = new Object[]{buffer2, Conversions.intObject((int)n4), Conversions.intObject((int)n5), Conversions.intObject((int)n6)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        packet.writeLongInt((int)(packetLen - headerLength));
        packet.writeByte((byte)0);
        int lengthToWrite = 0;
        int compressedLength = 0;
        byte[] bytesToCompress = packet.getByteBuffer();
        byte[] compressedBytes = null;
        int offsetWrite = 0;
        if (packetLen < 50) {
            lengthToWrite = packetLen;
            compressedBytes = packet.getByteBuffer();
            compressedLength = 0;
            offsetWrite = offset;
        } else {
            compressedBytes = new byte[bytesToCompress.length * 2];
            this.deflater.reset();
            this.deflater.setInput(bytesToCompress, (int)offset, (int)packetLen);
            this.deflater.finish();
            int compLen = this.deflater.deflate(compressedBytes);
            if (compLen > packetLen) {
                lengthToWrite = packetLen;
                compressedBytes = packet.getByteBuffer();
                compressedLength = 0;
                offsetWrite = offset;
            } else {
                lengthToWrite = compLen;
                headerLength += 3;
                compressedLength = packetLen;
            }
        }
        Buffer compressedPacket = Buffer.allocateNew((int)(packetLen + headerLength), this.useNewIo);
        compressedPacket.setPosition(0);
        compressedPacket.writeLongInt(lengthToWrite);
        compressedPacket.writeByte(this.packetSequence);
        compressedPacket.writeLongInt(compressedLength);
        compressedPacket.writeBytesNoNull(compressedBytes, offsetWrite, lengthToWrite);
        Buffer buffer3 = compressedPacket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer3, joinPoint);
        return buffer3;
    }

    /*
     * WARNING - void declaration
     */
    private final void readServerStatusForResultSets(Buffer buffer) throws SQLException {
        Buffer buffer2 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)buffer2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.use41Extensions) {
            void rowPacket;
            rowPacket.readByte();
            this.warningCount = rowPacket.readInt();
            if (this.warningCount > 0) {
                this.hadWarnings = true;
            }
            this.serverStatus = rowPacket.readInt();
            if (this.profileSql) {
                this.queryNoIndexUsed = (this.serverStatus & 0x10) != 0;
                this.queryBadIndexUsed = (this.serverStatus & 0x20) != 0;
            }
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    private SocketFactory createSocketFactory() throws SQLException {
        SocketFactory socketFactory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            if (this.socketFactoryClassName == null) {
                throw new SQLException(Messages.getString("MysqlIO.75"), "08001");
            }
            socketFactory = (SocketFactory)Class.forName(this.socketFactoryClassName).newInstance();
        }
        catch (Exception ex) {
            throw new SQLException(String.valueOf(Messages.getString("MysqlIO.76")) + this.socketFactoryClassName + Messages.getString("MysqlIO.77") + ex.toString() + (this.connection.getParanoid() ? "" : Util.stackTraceToString(ex)), "08001");
        }
        SocketFactory socketFactory2 = socketFactory;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socketFactory2, joinPoint);
        return socketFactory;
    }

    /*
     * WARNING - void declaration
     */
    private void enqueuePacketForDebugging(boolean bl, boolean bl2, int n, byte[] byArray, Buffer buffer) throws SQLException {
        void packet;
        void isPacketBeingSent;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        int n2 = n;
        byte[] byArray2 = byArray;
        Buffer buffer2 = buffer;
        Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4), Conversions.intObject((int)n2), byArray2, buffer2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.packetDebugRingBuffer.size() + 1 > this.connection.getPacketDebugBufferSize()) {
            this.packetDebugRingBuffer.removeFirst();
        }
        StringBuffer packetDump = null;
        if (isPacketBeingSent == false) {
            void isPacketReused;
            void header;
            int bytesToDump = Math.min(1024, packet.getBufLength());
            Buffer packetToDump = Buffer.allocateNew(4 + bytesToDump, false);
            packetToDump.setPosition(0);
            packetToDump.writeBytesNoNull((byte[])header);
            packetToDump.writeBytesNoNull(packet.getBytes(0, bytesToDump));
            String packetPayload = packetToDump.dump(bytesToDump);
            packetDump = new StringBuffer(96 + packetPayload.length());
            packetDump.append("Server ");
            if (isPacketReused != false) {
                packetDump.append("(re-used)");
            } else {
                packetDump.append("(new)");
            }
            packetDump.append(" ");
            packetDump.append(packet.toSuperString());
            packetDump.append(" --------------------> Client\n");
            packetDump.append("\nPacket payload:\n\n");
            packetDump.append(packetPayload);
            if (bytesToDump == 1024) {
                packetDump.append("\nNote: Packet of " + packet.getBufLength() + " bytes truncated to " + 1024 + " bytes.\n");
            }
        } else {
            void sendLength;
            int bytesToDump = Math.min(1024, (int)sendLength);
            String packetPayload = packet.dump(bytesToDump);
            packetDump = new StringBuffer(68 + packetPayload.length());
            packetDump.append("Client ");
            packetDump.append(packet.toSuperString());
            packetDump.append("--------------------> Server\n");
            packetDump.append("\nPacket payload:\n\n");
            packetDump.append(packetPayload);
            if (bytesToDump == 1024) {
                packetDump.append("\nNote: Packet of " + (int)sendLength + " bytes truncated to " + 1024 + " bytes.\n");
            }
        }
        this.packetDebugRingBuffer.addLast(packetDump);
        Object var17_19 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var17_19, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void readChannelFully(ByteBuffer byteBuffer, int n) throws IOException {
        void length;
        ByteBuffer byteBuffer2 = byteBuffer;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)byteBuffer2, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n3 = 0;
        while (n3 < length) {
            void buf;
            int count = this.socketChannel.read((ByteBuffer)buf);
            if (count < 0) {
                throw new EOFException();
            }
            buf.position(n3 += count);
        }
        Object var8_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_8, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private RowData readSingleRowSet(long l, int n, int n2, boolean bl, Field[] fieldArray) throws SQLException {
        RowDataStatic rowData;
        void resultSetConcurrency;
        void isBinaryEncoded;
        void columnCount;
        void fields;
        long l2 = l;
        int n3 = n;
        int n4 = n2;
        boolean bl2 = bl;
        Field[] fieldArray2 = fieldArray;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l2), Conversions.intObject((int)n3), Conversions.intObject((int)n4), Conversions.booleanObject((boolean)bl2), fieldArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object[] rowBytes = this.nextRow((Field[])fields, (int)columnCount, (boolean)isBinaryEncoded, (int)resultSetConcurrency);
        int rowCount = 0;
        if (rowBytes != null) {
            rows.add(rowBytes);
            rowCount = 1;
        }
        while (rowBytes != null) {
            void maxRows;
            rowBytes = this.nextRow((Field[])fields, (int)columnCount, (boolean)isBinaryEncoded, (int)resultSetConcurrency);
            if (rowBytes == null || maxRows != -1 && rowCount >= maxRows) continue;
            rows.add(rowBytes);
            ++rowCount;
        }
        RowDataStatic rowDataStatic = rowData = new RowDataStatic(rows);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(rowDataStatic, joinPoint);
        return rowDataStatic;
    }

    private Buffer readViaChannel() throws IOException, SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer packet = Buffer.allocateNew(16384, true);
        packet.setPosition(0);
        packet.setBufLength(4);
        ByteBuffer lenBuf = packet.getNioBuffer();
        this.readChannelFully(lenBuf, 4);
        byte b1 = lenBuf.get(0);
        byte b2 = lenBuf.get(1);
        byte b3 = lenBuf.get(2);
        int packetLength = (b1 & 0xFF) + ((b2 & 0xFF) << 8) + ((b3 & 0xFF) << 16);
        if (packetLength == -65793) {
            this.forceClose();
            throw new IOException(Messages.getString("MysqlIO.79"));
        }
        packet.ensureCapacity(packetLength + 1);
        packet.setBufLength(packetLength);
        packet.setPosition(0);
        this.socketChannel.read(packet.getNioBuffer());
        packet.setBufLength(packetLength + 1);
        packet.setPosition(packetLength);
        packet.writeByte((byte)0);
        packet.setPosition(0);
        Buffer buffer = packet;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    private void reclaimLargeReusablePacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.reusablePacket != null && this.reusablePacket.getCapacity() > 0x100000) {
            this.reusablePacket = Buffer.allocateNew(this.connection.getNetBufferLength(), this.useNewIo);
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private final Buffer reuseAndReadPacket(Buffer buffer) throws SQLException {
        Buffer buffer2;
        void reuse;
        Buffer buffer3 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)buffer3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.useNewIo) {
            try {
                reuse.setWasMultiPacket(false);
                int lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
                if (lengthRead < 4) {
                    this.forceClose();
                    throw new IOException(Messages.getString("MysqlIO.43"));
                }
                int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
                if (this.traceProtocol) {
                    StringBuffer traceMessageBuf = new StringBuffer();
                    traceMessageBuf.append(Messages.getString("MysqlIO.44"));
                    traceMessageBuf.append(packetLength);
                    traceMessageBuf.append(Messages.getString("MysqlIO.45"));
                    traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                    this.connection.getLog().logTrace(traceMessageBuf.toString());
                }
                byte multiPacketSeq = this.packetHeaderBuf[3];
                if (!this.packetSequenceReset) {
                    if (this.enablePacketDebug && this.checkPacketSequence) {
                        this.checkPacketSequencing(multiPacketSeq);
                    }
                } else {
                    this.packetSequenceReset = false;
                }
                this.readPacketSequence = multiPacketSeq;
                reuse.setPosition(0);
                if (reuse.getByteBuffer().length <= packetLength) {
                    reuse.setByteBuffer(new byte[packetLength + 1]);
                }
                reuse.setBufLength(packetLength);
                int numBytesRead = this.readFully(this.mysqlInput, reuse.getByteBuffer(), 0, packetLength);
                if (numBytesRead != packetLength) {
                    throw new IOException("Short read, expected " + packetLength + " bytes, only read " + numBytesRead);
                }
                if (this.traceProtocol) {
                    StringBuffer traceMessageBuf = new StringBuffer();
                    traceMessageBuf.append(Messages.getString("MysqlIO.46"));
                    traceMessageBuf.append(MysqlIO.getPacketDumpToLog((Buffer)reuse, packetLength));
                    this.connection.getLog().logTrace(traceMessageBuf.toString());
                }
                if (this.enablePacketDebug) {
                    this.enqueuePacketForDebugging(false, true, 0, this.packetHeaderBuf, (Buffer)reuse);
                }
                boolean isMultiPacket = false;
                if (packetLength == this.maxThreeBytes) {
                    reuse.setPosition(this.maxThreeBytes);
                    int packetEndPoint = packetLength;
                    isMultiPacket = true;
                    this.packetHeaderBuf = new byte[4];
                    lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
                    if (lengthRead < 4) {
                        this.forceClose();
                        throw new IOException(Messages.getString("MysqlIO.47"));
                    }
                    packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
                    Buffer multiPacket = Buffer.allocateNew(packetLength, this.useNewIo);
                    boolean firstMultiPkt = true;
                    while (true) {
                        int bytesRead;
                        int lengthToWrite;
                        byte[] byteBuf;
                        byte newPacketSeq;
                        if (!firstMultiPkt) {
                            this.packetHeaderBuf = new byte[4];
                            lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
                            if (lengthRead < 4) {
                                this.forceClose();
                                throw new IOException(Messages.getString("MysqlIO.48"));
                            }
                            packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
                        } else {
                            firstMultiPkt = false;
                        }
                        if (!this.useNewLargePackets && packetLength == 1) {
                            this.clearInputStream();
                            break;
                        }
                        if (packetLength < this.maxThreeBytes) {
                            newPacketSeq = this.packetHeaderBuf[3];
                            if (newPacketSeq != multiPacketSeq + 1) {
                                throw new IOException(Messages.getString("MysqlIO.49"));
                            }
                            multiPacketSeq = newPacketSeq;
                            multiPacket.setPosition(0);
                            multiPacket.setBufLength(packetLength);
                            byteBuf = multiPacket.getByteBuffer();
                            lengthToWrite = packetLength;
                            bytesRead = this.readFully(this.mysqlInput, byteBuf, 0, packetLength);
                            if (bytesRead != lengthToWrite) {
                                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, new SQLException(String.valueOf(Messages.getString("MysqlIO.50")) + lengthToWrite + Messages.getString("MysqlIO.51") + bytesRead + "."));
                            }
                            reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
                            packetEndPoint += lengthToWrite;
                            break;
                        }
                        newPacketSeq = this.packetHeaderBuf[3];
                        if (newPacketSeq != multiPacketSeq + 1) {
                            throw new IOException(Messages.getString("MysqlIO.53"));
                        }
                        multiPacketSeq = newPacketSeq;
                        multiPacket.setPosition(0);
                        multiPacket.setBufLength(packetLength);
                        byteBuf = multiPacket.getByteBuffer();
                        lengthToWrite = packetLength;
                        bytesRead = this.readFully(this.mysqlInput, byteBuf, 0, packetLength);
                        if (bytesRead != lengthToWrite) {
                            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, new SQLException(String.valueOf(Messages.getString("MysqlIO.54")) + lengthToWrite + Messages.getString("MysqlIO.55") + bytesRead + "."));
                        }
                        reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
                        packetEndPoint += lengthToWrite;
                    }
                    reuse.setPosition(0);
                    reuse.setWasMultiPacket(true);
                }
                if (!isMultiPacket) {
                    reuse.getByteBuffer()[packetLength] = 0;
                }
                buffer2 = reuse;
            }
            catch (IOException ioEx) {
                throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
            }
            catch (OutOfMemoryError oom) {
                try {
                    this.clearInputStream();
                }
                catch (Throwable throwable) {}
                try {
                    this.connection.realClose(false, false, true, oom);
                }
                catch (Throwable throwable) {}
                throw oom;
            }
        }
        buffer2 = this.reuseAndReadViaChannel((Buffer)reuse);
        Buffer buffer4 = buffer2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer4, joinPoint);
        return buffer2;
    }

    /*
     * WARNING - void declaration
     */
    private void checkPacketSequencing(byte by) throws CommunicationsException {
        void multiPacketSeq;
        byte by2 = by;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)Conversions.byteObject((byte)by2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (multiPacketSeq == -128 && this.readPacketSequence != 127) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, new IOException("Packets out of order, expected packet # -128, but received packet # " + (int)multiPacketSeq));
        }
        if (this.readPacketSequence == -1 && multiPacketSeq != false) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, new IOException("Packets out of order, expected packet # -1, but received packet # " + (int)multiPacketSeq));
        }
        if (multiPacketSeq != -128 && this.readPacketSequence != -1 && multiPacketSeq != this.readPacketSequence + 1) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, new IOException("Packets out of order, expected packet # " + (this.readPacketSequence + 1) + ", but received packet # " + (int)multiPacketSeq));
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void send(Buffer buffer) throws SQLException {
        void packet;
        Buffer buffer2 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)buffer2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int l = packet.getPosition();
        this.send((Buffer)packet, l);
        if (packet == this.sharedSendPacket) {
            this.reclaimLargeSharedSendPacket();
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    void enableMultiQueries() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buf = this.getSharedSendPacket();
        buf.clear();
        buf.writeByte((byte)27);
        buf.writeInt(0);
        this.sendCommand(27, null, buf, false, null);
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    void disableMultiQueries() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buf = this.getSharedSendPacket();
        buf.clear();
        buf.writeByte((byte)27);
        buf.writeInt(1);
        this.sendCommand(27, null, buf, false, null);
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private final void send(Buffer buffer, int n) throws SQLException {
        Buffer buffer2 = buffer;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)buffer2, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            void packet;
            int packetLen;
            if (packetLen > this.maxAllowedPacket) {
                throw new PacketTooBigException(packetLen, this.maxAllowedPacket);
            }
            if (this.connection.getMaintainTimeStats()) {
                this.lastPacketSentTimeMs = System.currentTimeMillis();
            }
            if (this.serverMajorVersion >= 4 && packetLen >= this.maxThreeBytes) {
                if (!this.useNewIo) {
                    this.sendSplitPackets((Buffer)packet);
                } else {
                    this.sendSplitPacketsViaChannel((Buffer)packet);
                }
            } else {
                this.packetSequence = (byte)(this.packetSequence + 1);
                Buffer packetToSend = packet;
                packetToSend.setPosition(0);
                if (this.useCompression) {
                    void originalPacketLen = packetLen;
                    packetToSend = this.compressPacket((Buffer)packet, 0, packetLen, 4);
                    packetLen = packetToSend.getPosition();
                    if (this.traceProtocol) {
                        StringBuffer traceMessageBuf = new StringBuffer();
                        traceMessageBuf.append(Messages.getString("MysqlIO.57"));
                        traceMessageBuf.append(MysqlIO.getPacketDumpToLog(packetToSend, packetLen));
                        traceMessageBuf.append(Messages.getString("MysqlIO.58"));
                        traceMessageBuf.append(MysqlIO.getPacketDumpToLog((Buffer)packet, (int)originalPacketLen));
                        this.connection.getLog().logTrace(traceMessageBuf.toString());
                    }
                } else {
                    packetToSend.writeLongInt((int)(packetLen - 4));
                    packetToSend.writeByte(this.packetSequence);
                    if (this.traceProtocol) {
                        StringBuffer traceMessageBuf = new StringBuffer();
                        traceMessageBuf.append(Messages.getString("MysqlIO.59"));
                        traceMessageBuf.append(packetToSend.dump(packetLen));
                        this.connection.getLog().logTrace(traceMessageBuf.toString());
                    }
                }
                if (!this.useNewIo) {
                    this.mysqlOutput.write(packetToSend.getByteBuffer(), 0, packetLen);
                    this.mysqlOutput.flush();
                } else {
                    this.sendViaChannel(packetToSend, packetLen);
                }
            }
            if (this.enablePacketDebug) {
                this.enqueuePacketForDebugging(true, false, (int)(packetLen + 5), this.packetHeaderBuf, (Buffer)packet);
            }
            if (packet == this.sharedSendPacket) {
                this.reclaimLargeSharedSendPacket();
            }
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        Object var9_11 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_11, joinPoint);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ResultSet sendFileToServer(Statement statement, String string) throws SQLException {
        void callingStatement;
        Buffer filePacket;
        JoinPoint joinPoint;
        block23: {
            block22: {
                Statement statement2 = statement;
                String string2 = string;
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object)statement2, (Object)string2);
                Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                filePacket = this.loadFileBufRef == null ? null : (Buffer)this.loadFileBufRef.get();
                int bigPacketLength = Math.min(this.connection.getMaxAllowedPacket() - 12, this.alignPacketSize(this.connection.getMaxAllowedPacket() - 16, 4096) - 12);
                int oneMeg = 0x100000;
                int smallerPacketSizeAligned = Math.min(oneMeg - 12, this.alignPacketSize(oneMeg - 16, 4096) - 12);
                int packetLength = Math.min(smallerPacketSizeAligned, bigPacketLength);
                if (filePacket == null) {
                    try {
                        filePacket = Buffer.allocateNew(packetLength + 4, this.useNewIo);
                        this.loadFileBufRef = new SoftReference<Buffer>(filePacket);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new SQLException("Could not allocate packet of " + packetLength + " bytes required for LOAD DATA LOCAL INFILE operation." + " Try increasing max heap allocation for JVM or decreasing server variable " + "'max_allowed_packet'", "S1001");
                    }
                }
                filePacket.clear();
                this.send(filePacket, 0);
                byte[] fileBuf = new byte[packetLength];
                BufferedInputStream fileIn = null;
                try {
                    void fileName;
                    try {
                        if (!this.connection.getAllowUrlInLocalInfile()) {
                            fileIn = new BufferedInputStream(new FileInputStream((String)fileName));
                        } else if (fileName.indexOf(":") != -1) {
                            try {
                                URL urlFromFileName = new URL((String)fileName);
                                fileIn = new BufferedInputStream(urlFromFileName.openStream());
                            }
                            catch (MalformedURLException malformedURLException) {
                                fileIn = new BufferedInputStream(new FileInputStream((String)fileName));
                            }
                        } else {
                            fileIn = new BufferedInputStream(new FileInputStream((String)fileName));
                        }
                        int bytesRead = 0;
                        while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                            filePacket.clear();
                            filePacket.writeBytesNoNull(fileBuf, 0, bytesRead);
                            this.send(filePacket);
                        }
                    }
                    catch (IOException ioEx) {
                        StringBuffer messageBuf = new StringBuffer(Messages.getString("MysqlIO.60"));
                        if (!this.connection.getParanoid()) {
                            messageBuf.append("'");
                            if (fileName != null) {
                                messageBuf.append((String)fileName);
                            }
                            messageBuf.append("'");
                        }
                        messageBuf.append(Messages.getString("MysqlIO.63"));
                        if (this.connection.getParanoid()) throw new SQLException(messageBuf.toString(), "S1009");
                        messageBuf.append(Messages.getString("MysqlIO.64"));
                        messageBuf.append(Util.stackTraceToString(ioEx));
                        throw new SQLException(messageBuf.toString(), "S1009");
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    if (fileIn == null) {
                        filePacket.clear();
                        this.send(filePacket);
                        this.checkErrorPacket();
                        throw throwable;
                    }
                    try {
                        fileIn.close();
                    }
                    catch (Exception exception) {
                        throw new SQLException(Messages.getString("MysqlIO.65"), "S1000");
                    }
                    fileIn = null;
                    throw throwable;
                }
                {
                    Object var12_20 = null;
                    if (fileIn == null) break block22;
                }
                try {}
                catch (Exception exception) {
                    throw new SQLException(Messages.getString("MysqlIO.65"), "S1000");
                }
                fileIn.close();
                fileIn = null;
                break block23;
            }
            filePacket.clear();
            this.send(filePacket);
            this.checkErrorPacket();
        }
        filePacket.clear();
        this.send(filePacket);
        Buffer resultPacket = this.checkErrorPacket();
        ResultSet resultSet = this.buildResultSetWithUpdates((Statement)callingStatement, resultPacket);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    private Buffer checkErrorPacket(int n) throws SQLException {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte statusCode = 0;
        Buffer resultPacket = null;
        this.serverStatus = 0;
        try {
            resultPacket = this.reuseAndReadPacket(this.reusablePacket);
            statusCode = resultPacket.readByte();
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception fallThru) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, fallThru);
        }
        if (statusCode == -1) {
            int errno = 2000;
            if (this.protocolVersion > 9) {
                errno = resultPacket.readInt();
                String xOpen = null;
                String serverErrorMessage = resultPacket.readString();
                if (serverErrorMessage.startsWith("#")) {
                    if (serverErrorMessage.length() > 6) {
                        xOpen = serverErrorMessage.substring(1, 6);
                        serverErrorMessage = serverErrorMessage.substring(6);
                        if (xOpen.equals("HY000")) {
                            xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
                        }
                    } else {
                        xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
                    }
                } else {
                    xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
                }
                this.clearInputStream();
                StringBuffer errorBuf = new StringBuffer();
                String xOpenErrorMessage = SQLError.get(xOpen);
                if (!this.connection.getUseOnlyServerErrorMessages() && xOpenErrorMessage != null) {
                    errorBuf.append(xOpenErrorMessage);
                    errorBuf.append(Messages.getString("MysqlIO.68"));
                }
                errorBuf.append(serverErrorMessage);
                if (!this.connection.getUseOnlyServerErrorMessages() && xOpenErrorMessage != null) {
                    errorBuf.append("\"");
                }
                if (xOpen != null && xOpen.startsWith("22")) {
                    throw new MysqlDataTruncation(errorBuf.toString(), 0, true, false, 0, 0);
                }
                throw new SQLException(errorBuf.toString(), xOpen, errno);
            }
            String serverErrorMessage = resultPacket.readString();
            this.clearInputStream();
            if (serverErrorMessage.indexOf(Messages.getString("MysqlIO.70")) != -1) {
                throw new SQLException(String.valueOf(SQLError.get("S0022")) + ", " + serverErrorMessage, "S0022", -1);
            }
            StringBuffer errorBuf = new StringBuffer(Messages.getString("MysqlIO.72"));
            errorBuf.append(serverErrorMessage);
            errorBuf.append("\"");
            throw new SQLException(String.valueOf(SQLError.get("S1000")) + ", " + errorBuf.toString(), "S1000", -1);
        }
        Buffer buffer = resultPacket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    private final void sendSplitPackets(Buffer buffer) throws SQLException {
        Buffer buffer2 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)buffer2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            Buffer packetToSend;
            int packetLen;
            void packet;
            Buffer headerPacket;
            Buffer buffer3 = headerPacket = this.splitBufRef == null ? null : (Buffer)this.splitBufRef.get();
            if (headerPacket == null) {
                headerPacket = Buffer.allocateNew(this.maxThreeBytes + 4, this.useNewIo);
                this.splitBufRef = new SoftReference<Buffer>(headerPacket);
            }
            int len = packet.getPosition();
            int splitSize = this.maxThreeBytes;
            int originalPacketPos = 4;
            byte[] origPacketBytes = packet.getByteBuffer();
            byte[] headerPacketBytes = headerPacket.getByteBuffer();
            while (len >= this.maxThreeBytes) {
                this.packetSequence = (byte)(this.packetSequence + 1);
                headerPacket.setPosition(0);
                headerPacket.writeLongInt(splitSize);
                headerPacket.writeByte(this.packetSequence);
                System.arraycopy(origPacketBytes, originalPacketPos, headerPacketBytes, 4, splitSize);
                packetLen = splitSize + 4;
                if (!this.useCompression) {
                    this.mysqlOutput.write(headerPacketBytes, 0, splitSize + 4);
                    this.mysqlOutput.flush();
                } else {
                    headerPacket.setPosition(0);
                    packetToSend = this.compressPacket(headerPacket, 4, splitSize, 4);
                    packetLen = packetToSend.getPosition();
                    this.mysqlOutput.write(packetToSend.getByteBuffer(), 0, packetLen);
                    this.mysqlOutput.flush();
                }
                originalPacketPos += splitSize;
                len -= splitSize;
            }
            headerPacket.clear();
            headerPacket.setPosition(0);
            headerPacket.writeLongInt(len - 4);
            this.packetSequence = (byte)(this.packetSequence + 1);
            headerPacket.writeByte(this.packetSequence);
            if (len != 0) {
                System.arraycopy(origPacketBytes, originalPacketPos, headerPacketBytes, 4, len - 4);
            }
            packetLen = len - 4;
            if (!this.useCompression) {
                this.mysqlOutput.write(headerPacket.getByteBuffer(), 0, len);
                this.mysqlOutput.flush();
            } else {
                headerPacket.setPosition(0);
                packetToSend = this.compressPacket(headerPacket, 4, packetLen, 4);
                packetLen = packetToSend.getPosition();
                this.mysqlOutput.write(packetToSend.getByteBuffer(), 0, packetLen);
                this.mysqlOutput.flush();
            }
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        Object var12_13 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var12_13, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendSplitPacketsViaChannel(Buffer buffer) throws SQLException {
        Buffer buffer2 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)buffer2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            Buffer packetToSend;
            int packetLen;
            void packet;
            Buffer headerPacket;
            Buffer buffer3 = headerPacket = this.splitBufRef == null ? null : (Buffer)this.splitBufRef.get();
            if (headerPacket == null) {
                headerPacket = Buffer.allocateNew(this.maxThreeBytes + 4, this.useNewIo);
                this.splitBufRef = new SoftReference<Buffer>(headerPacket);
            }
            int len = packet.getPosition();
            int splitSize = this.maxThreeBytes;
            int originalPacketPos = 4;
            byte[] origPacketBytes = packet.getByteBuffer();
            while (len >= this.maxThreeBytes) {
                this.packetSequence = (byte)(this.packetSequence + 1);
                headerPacket.setPosition(0);
                headerPacket.writeLongInt(splitSize);
                headerPacket.writeByte(this.packetSequence);
                headerPacket.setPosition(4);
                headerPacket.writeBytesNoNull(origPacketBytes, originalPacketPos, splitSize);
                packetLen = splitSize + 4;
                if (!this.useCompression) {
                    headerPacket.getNioBuffer().limit(splitSize + 4);
                    headerPacket.setPosition(0);
                    this.socketChannel.write(headerPacket.getNioBuffer());
                } else {
                    headerPacket.setPosition(0);
                    packetToSend = this.compressPacket(headerPacket, 4, splitSize, 4);
                    packetLen = packetToSend.getPosition();
                    packetToSend.setPosition(0);
                    packetToSend.getNioBuffer().limit(packetLen);
                    this.socketChannel.write(packetToSend.getNioBuffer());
                }
                originalPacketPos += splitSize;
                len -= splitSize;
            }
            headerPacket.clear();
            headerPacket.setPosition(0);
            headerPacket.writeLongInt(len - 4);
            this.packetSequence = (byte)(this.packetSequence + 1);
            headerPacket.writeByte(this.packetSequence);
            if (len != 0) {
                headerPacket.setPosition(4);
                headerPacket.writeBytesNoNull(origPacketBytes, originalPacketPos, len - 4);
            }
            packetLen = len - 4;
            if (!this.useCompression) {
                headerPacket.getNioBuffer().limit(len);
                headerPacket.setPosition(0);
                this.socketChannel.write(headerPacket.getNioBuffer());
            } else {
                headerPacket.setPosition(0);
                packetToSend = this.compressPacket(headerPacket, 4, packetLen, 4);
                packetLen = packetToSend.getPosition();
                packetToSend.setPosition(0);
                packetToSend.getNioBuffer().limit(packetLen);
                this.socketChannel.write(packetToSend.getNioBuffer());
            }
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        Object var11_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var11_12, joinPoint);
    }

    private void reclaimLargeSharedSendPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.sharedSendPacket != null && this.sharedSendPacket.getCapacity() > 0x100000) {
            this.sharedSendPacket = Buffer.allocateNew(this.connection.getNetBufferLength(), this.useNewIo);
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private Buffer reuseAndReadViaChannel(Buffer buffer) throws SQLException {
        void v0;
        Buffer buffer2 = buffer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)buffer2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            void reuse;
            reuse.setWasMultiPacket(false);
            reuse.setPosition(0);
            reuse.setBufLength(4);
            ByteBuffer lenBuf = reuse.getNioBuffer();
            this.readChannelFully(lenBuf, 4);
            byte b1 = lenBuf.get(0);
            byte b2 = lenBuf.get(1);
            byte b3 = lenBuf.get(2);
            int packetLength = (b1 & 0xFF) + ((b2 & 0xFF) << 8) + ((b3 & 0xFF) << 16);
            if (packetLength == -65793) {
                this.forceClose();
                throw new IOException(Messages.getString("MysqlIO.80"));
            }
            byte multiPacketSeq = lenBuf.get(3);
            reuse.setPosition(0);
            reuse.ensureCapacity(packetLength + 1);
            reuse.setBufLength(packetLength);
            this.readChannelFully(reuse.getNioBuffer(), packetLength);
            reuse.setPosition(0);
            boolean isMultiPacket = false;
            if (packetLength == this.maxThreeBytes) {
                reuse.setPosition(this.maxThreeBytes);
                int packetEndPoint = packetLength;
                isMultiPacket = true;
                Buffer lenChannelBuf = Buffer.allocateNew(4, true);
                lenBuf = lenChannelBuf.getNioBuffer();
                lenBuf.position(0);
                this.readChannelFully(lenBuf, 4);
                b1 = lenBuf.get(0);
                b2 = lenBuf.get(1);
                b3 = lenBuf.get(2);
                packetLength = (b1 & 0xFF) + ((b2 & 0xFF) << 8) + ((b3 & 0xFF) << 16);
                if (packetLength == -65793) {
                    this.forceClose();
                    throw new IOException(Messages.getString("MysqlIO.81"));
                }
                Buffer multiPacket = Buffer.allocateNew(packetLength, this.useNewIo);
                boolean firstMultiPkt = true;
                while (true) {
                    byte[] byteBuf;
                    int lengthToWrite;
                    byte newPacketSeq;
                    if (!firstMultiPkt) {
                        lenBuf.position(0);
                        this.readChannelFully(lenBuf, 4);
                        b1 = lenBuf.get(0);
                        b2 = lenBuf.get(1);
                        b3 = lenBuf.get(2);
                        packetLength = (b1 & 0xFF) + ((b2 & 0xFF) << 8) + ((b3 & 0xFF) << 16);
                        if (packetLength == -65793) {
                            this.forceClose();
                            throw new IOException(Messages.getString("MysqlIO.82"));
                        }
                    } else {
                        firstMultiPkt = false;
                    }
                    if (!this.useNewLargePackets && packetLength == 1) {
                        this.clearInputStream();
                        break;
                    }
                    if (packetLength < this.maxThreeBytes) {
                        lenBuf.position(0);
                        this.readChannelFully(lenBuf, 1);
                        newPacketSeq = lenBuf.get(0);
                        if (newPacketSeq != multiPacketSeq + 1) {
                            throw new IOException(Messages.getString("MysqlIO.83"));
                        }
                        multiPacketSeq = newPacketSeq;
                        multiPacket.setPosition(0);
                        multiPacket.setBufLength(packetLength);
                        lengthToWrite = packetLength;
                        this.readChannelFully(multiPacket.getNioBuffer(), packetLength);
                        byteBuf = multiPacket.getByteBuffer();
                        reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
                        packetEndPoint += lengthToWrite;
                        break;
                    }
                    lenBuf.position(0);
                    this.readChannelFully(lenBuf, 1);
                    newPacketSeq = lenBuf.get(0);
                    if (newPacketSeq != multiPacketSeq + 1) {
                        throw new IOException(Messages.getString("MysqlIO.84"));
                    }
                    multiPacketSeq = newPacketSeq;
                    multiPacket.setPosition(0);
                    multiPacket.setBufLength(packetLength);
                    lengthToWrite = packetLength;
                    this.readChannelFully(multiPacket.getNioBuffer(), packetLength);
                    byteBuf = multiPacket.getByteBuffer();
                    reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
                    packetEndPoint += lengthToWrite;
                }
                reuse.setPosition(0);
                reuse.setWasMultiPacket(true);
            }
            if (!isMultiPacket) {
                reuse.setPosition(packetLength);
                reuse.writeByte((byte)0);
            }
            reuse.setPosition(0);
            v0 = reuse;
        }
        catch (IOException ioEx) {
            throw new CommunicationsException(this.connection, this.lastPacketSentTimeMs, ioEx);
        }
        catch (OutOfMemoryError oom) {
            try {
                this.clearInputStream();
            }
            catch (Throwable throwable) {}
            try {
                this.connection.realClose(false, false, true, oom);
            }
            catch (Throwable throwable) {}
            throw oom;
        }
        void var18_20 = v0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var18_20, joinPoint);
        return v0;
    }

    boolean hadWarnings() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.hadWarnings;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    void scanForAndThrowDataTruncation() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.streamingData == null && this.versionMeetsMinimum(4, 1, 0) && this.connection.getJdbcCompliantTruncation()) {
            SQLError.convertShowWarningsToSQLWarnings(this.connection, this.warningCount, true);
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void secureAuth(Buffer buffer, int n, String string, String string2, String string3, boolean bl) throws SQLException {
        void password;
        void user;
        void writeClientParams;
        void packLength;
        Buffer packet;
        Buffer buffer2 = buffer;
        int n2 = n;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{buffer2, Conversions.intObject((int)n2), string4, string5, string6, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (packet == null) {
            packet = Buffer.allocateNew((int)packLength, this.useNewIo);
        }
        if (writeClientParams != false) {
            if (this.use41Extensions) {
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    packet.writeLong(this.clientParam);
                    packet.writeLong(this.maxThreeBytes);
                    packet.writeByte((byte)8);
                    packet.writeBytesNoNull(new byte[23]);
                } else {
                    packet.writeLong(this.clientParam);
                    packet.writeLong(this.maxThreeBytes);
                }
            } else {
                packet.writeInt((int)this.clientParam);
                packet.writeLongInt(this.maxThreeBytes);
            }
        }
        packet.writeString((String)user);
        if (password.length() != 0) {
            packet.writeString(FALSE_SCRAMBLE);
        } else {
            packet.writeString("");
        }
        if (this.useConnectWithDb) {
            void database;
            packet.writeString((String)database);
        }
        this.send(packet);
        if (password.length() > 0) {
            Buffer b = this.readPacket();
            b.setPosition(0);
            byte[] replyAsBytes = b.getByteBuffer();
            if (replyAsBytes.length == 25 && replyAsBytes[0] != 0) {
                if (replyAsBytes[0] != 42) {
                    try {
                        byte[] buff = Security.passwordHashStage1((String)password);
                        byte[] passwordHash = new byte[buff.length];
                        System.arraycopy(buff, 0, passwordHash, 0, buff.length);
                        passwordHash = Security.passwordHashStage2(passwordHash, replyAsBytes);
                        byte[] packetDataAfterSalt = new byte[replyAsBytes.length - 5];
                        System.arraycopy(replyAsBytes, 4, packetDataAfterSalt, 0, replyAsBytes.length - 5);
                        byte[] mysqlScrambleBuff = new byte[20];
                        Security.passwordCrypt(packetDataAfterSalt, mysqlScrambleBuff, passwordHash, 20);
                        Security.passwordCrypt(mysqlScrambleBuff, buff, buff, 20);
                        Buffer packet2 = Buffer.allocateNew(25, this.useNewIo);
                        packet2.writeBytesNoNull(buff);
                        this.packetSequence = (byte)(this.packetSequence + 1);
                        this.send(packet2, 24);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SQLException(String.valueOf(Messages.getString("MysqlIO.91")) + Messages.getString("MysqlIO.92"), "S1000");
                    }
                }
                try {
                    byte[] passwordHash = Security.createKeyFromOldPassword((String)password);
                    byte[] netReadPos4 = new byte[replyAsBytes.length - 5];
                    System.arraycopy(replyAsBytes, 4, netReadPos4, 0, replyAsBytes.length - 5);
                    byte[] mysqlScrambleBuff = new byte[20];
                    Security.passwordCrypt(netReadPos4, mysqlScrambleBuff, passwordHash, 20);
                    String scrambledPassword = Util.scramble(new String(mysqlScrambleBuff), (String)password);
                    Buffer packet2 = Buffer.allocateNew((int)packLength, this.useNewIo);
                    packet2.writeString(scrambledPassword);
                    this.packetSequence = (byte)(this.packetSequence + 1);
                    this.send(packet2, 24);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SQLException(String.valueOf(Messages.getString("MysqlIO.93")) + Messages.getString("MysqlIO.94"), "S1000");
                }
            }
        }
        Object var22_27 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var22_27, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    void secureAuth411(Buffer buffer, int n, String string, String string2, String string3, boolean bl) throws SQLException {
        void password;
        void user;
        void writeClientParams;
        Buffer packet;
        Buffer buffer2 = buffer;
        int n2 = n;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{buffer2, Conversions.intObject((int)n2), string4, string5, string6, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (packet == null) {
            void packLength;
            packet = Buffer.allocateNew((int)packLength, this.useNewIo);
        }
        if (writeClientParams != false) {
            if (this.use41Extensions) {
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    packet.writeLong(this.clientParam);
                    packet.writeLong(this.maxThreeBytes);
                    packet.writeByte((byte)8);
                    packet.writeBytesNoNull(new byte[23]);
                } else {
                    packet.writeLong(this.clientParam);
                    packet.writeLong(this.maxThreeBytes);
                }
            } else {
                packet.writeInt((int)this.clientParam);
                packet.writeLongInt(this.maxThreeBytes);
            }
        }
        packet.writeString((String)user);
        if (password.length() != 0) {
            packet.writeByte((byte)20);
            try {
                packet.writeBytesNoNull(Security.scramble411((String)password, this.seed));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SQLException(String.valueOf(Messages.getString("MysqlIO.95")) + Messages.getString("MysqlIO.96"), "S1000");
            }
        } else {
            packet.writeByte((byte)0);
        }
        if (this.useConnectWithDb) {
            void database;
            packet.writeString((String)database);
        }
        this.send(packet);
        byte by = this.packetSequence;
        this.packetSequence = (byte)(by + 1);
        byte savePacketSequence = by;
        Buffer reply = this.checkErrorPacket();
        if (reply.isLastDataPacket()) {
            this.packetSequence = savePacketSequence = (byte)(savePacketSequence + 1);
            packet.clear();
            String seed323 = this.seed.substring(0, 8);
            packet.writeString(Util.newCrypt((String)password, seed323));
            this.send(packet);
            this.checkErrorPacket();
        }
        Object var18_18 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var18_18, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] unpackBinaryResultSetRow(Field[] fieldArray, Buffer buffer, int n) throws SQLException {
        void binaryData;
        void fields;
        Field[] fieldArray2 = fieldArray;
        Buffer buffer2 = buffer;
        int n2 = n;
        Object[] objectArray = new Object[]{fieldArray2, buffer2, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int numFields = ((void)fields).length;
        Object[] unpackedRowData = new Object[numFields];
        int nullCount = (numFields + 9) / 8;
        byte[] nullBitMask = new byte[nullCount];
        int i = 0;
        while (i < nullCount) {
            nullBitMask[i] = binaryData.readByte();
            ++i;
        }
        int nullMaskPos = 0;
        int bit = 4;
        int i2 = 0;
        while (i2 < numFields) {
            void resultSetConcurrency;
            if ((nullBitMask[nullMaskPos] & bit) != 0) {
                unpackedRowData[i2] = null;
            } else if (resultSetConcurrency != 1008) {
                this.extractNativeEncodedColumn((Buffer)binaryData, (Field[])fields, i2, unpackedRowData);
            } else {
                this.unpackNativeEncodedColumn((Buffer)binaryData, (Field[])fields, i2, unpackedRowData);
            }
            if (((bit <<= 1) & 0xFF) == 0) {
                bit = 1;
                ++nullMaskPos;
            }
            ++i2;
        }
        Object[] objectArray2 = unpackedRowData;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(objectArray2, joinPoint);
        return unpackedRowData;
    }

    /*
     * WARNING - void declaration
     */
    private final void extractNativeEncodedColumn(Buffer buffer, Field[] fieldArray, int n, Object[] objectArray) throws SQLException {
        void columnIndex;
        void fields;
        Buffer buffer2 = buffer;
        Field[] fieldArray2 = fieldArray;
        int n2 = n;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[]{buffer2, fieldArray2, Conversions.intObject((int)n2), objectArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this, (Object[])objectArray3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        void curField = fields[columnIndex];
        switch (curField.getMysqlType()) {
            case 6: {
                break;
            }
            case 1: {
                void binaryData;
                unpackedRowData[columnIndex] = new byte[]{binaryData.readByte()};
                break;
            }
            case 2: 
            case 13: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.getBytes(2);
                break;
            }
            case 3: 
            case 9: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.getBytes(4);
                break;
            }
            case 8: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.getBytes(8);
                break;
            }
            case 4: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.getBytes(4);
                break;
            }
            case 5: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.getBytes(8);
                break;
            }
            case 11: {
                void binaryData;
                int length = (int)binaryData.readFieldLength();
                unpackedRowData[columnIndex] = binaryData.getBytes(length);
                break;
            }
            case 10: {
                void binaryData;
                int length = (int)binaryData.readFieldLength();
                unpackedRowData[columnIndex] = binaryData.getBytes(length);
                break;
            }
            case 7: 
            case 12: {
                void binaryData;
                int length = (int)binaryData.readFieldLength();
                unpackedRowData[columnIndex] = binaryData.getBytes(length);
                break;
            }
            case 0: 
            case 15: 
            case 246: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.readLenByteArray(0);
                break;
            }
            case 16: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.readLenByteArray(0);
                break;
            }
            default: {
                throw new SQLException(String.valueOf(Messages.getString("MysqlIO.97")) + curField.getMysqlType() + Messages.getString("MysqlIO.98") + (int)columnIndex + Messages.getString("MysqlIO.99") + ((void)fields).length + Messages.getString("MysqlIO.100"), "S1000");
            }
        }
        Object var13_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var13_15, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private final void unpackNativeEncodedColumn(Buffer buffer, Field[] fieldArray, int n, Object[] objectArray) throws SQLException {
        void columnIndex;
        void fields;
        Buffer buffer2 = buffer;
        Field[] fieldArray2 = fieldArray;
        int n2 = n;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[]{buffer2, fieldArray2, Conversions.intObject((int)n2), objectArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object[])objectArray3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        void curField = fields[columnIndex];
        switch (curField.getMysqlType()) {
            case 6: {
                break;
            }
            case 1: {
                void binaryData;
                byte tinyVal = binaryData.readByte();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = String.valueOf(tinyVal).getBytes();
                    break;
                }
                short unsignedTinyVal = (short)(tinyVal & 0xFF);
                unpackedRowData[columnIndex] = String.valueOf(unsignedTinyVal).getBytes();
                break;
            }
            case 2: 
            case 13: {
                void binaryData;
                short shortVal = (short)binaryData.readInt();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = String.valueOf(shortVal).getBytes();
                    break;
                }
                int unsignedShortVal = shortVal & 0xFFFF;
                unpackedRowData[columnIndex] = String.valueOf(unsignedShortVal).getBytes();
                break;
            }
            case 3: 
            case 9: {
                void binaryData;
                int intVal = (int)binaryData.readLong();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = String.valueOf(intVal).getBytes();
                    break;
                }
                long longVal = (long)intVal & 0xFFFFFFFFL;
                unpackedRowData[columnIndex] = String.valueOf(longVal).getBytes();
                break;
            }
            case 8: {
                void binaryData;
                long longVal = binaryData.readLongLong();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = String.valueOf(longVal).getBytes();
                    break;
                }
                BigInteger asBigInteger = ResultSet.convertLongToUlong(longVal);
                unpackedRowData[columnIndex] = asBigInteger.toString().getBytes();
                break;
            }
            case 4: {
                void binaryData;
                float floatVal = Float.intBitsToFloat(binaryData.readIntAsLong());
                unpackedRowData[columnIndex] = String.valueOf(floatVal).getBytes();
                break;
            }
            case 5: {
                void binaryData;
                double doubleVal = Double.longBitsToDouble(binaryData.readLongLong());
                unpackedRowData[columnIndex] = String.valueOf(doubleVal).getBytes();
                break;
            }
            case 11: {
                void binaryData;
                int length = (int)binaryData.readFieldLength();
                int hour = 0;
                byte minute = 0;
                byte seconds = 0;
                if (length != 0) {
                    binaryData.readByte();
                    binaryData.readLong();
                    hour = binaryData.readByte();
                    minute = binaryData.readByte();
                    seconds = binaryData.readByte();
                    if (length > 8) {
                        binaryData.readLong();
                    }
                }
                byte[] timeAsBytes = new byte[]{(byte)Character.forDigit(hour / 10, 10), (byte)Character.forDigit(hour % 10, 10), 58, (byte)Character.forDigit(minute / 10, 10), (byte)Character.forDigit(minute % 10, 10), 58, (byte)Character.forDigit(seconds / 10, 10), (byte)Character.forDigit(seconds % 10, 10)};
                unpackedRowData[columnIndex] = timeAsBytes;
                break;
            }
            case 10: {
                void binaryData;
                int length = (int)binaryData.readFieldLength();
                int year = 0;
                byte month = 0;
                byte day = 0;
                boolean hour = false;
                boolean minute = false;
                boolean seconds = false;
                if (length != 0) {
                    year = binaryData.readInt();
                    month = binaryData.readByte();
                    day = binaryData.readByte();
                }
                if (year == 0 && month == 0 && day == 0) {
                    if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                        unpackedRowData[columnIndex] = null;
                        break;
                    }
                    if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                        throw new SQLException("Value '0000-00-00' can not be represented as java.sql.Date", "S1009");
                    }
                    year = 1;
                    month = 1;
                    day = 1;
                }
                byte[] dateAsBytes = new byte[10];
                dateAsBytes[0] = (byte)Character.forDigit(year / 1000, 10);
                int after1000 = year % 1000;
                dateAsBytes[1] = (byte)Character.forDigit(after1000 / 100, 10);
                int after100 = after1000 % 100;
                dateAsBytes[2] = (byte)Character.forDigit(after100 / 10, 10);
                dateAsBytes[3] = (byte)Character.forDigit(after100 % 10, 10);
                dateAsBytes[4] = 45;
                dateAsBytes[5] = (byte)Character.forDigit(month / 10, 10);
                dateAsBytes[6] = (byte)Character.forDigit(month % 10, 10);
                dateAsBytes[7] = 45;
                dateAsBytes[8] = (byte)Character.forDigit(day / 10, 10);
                dateAsBytes[9] = (byte)Character.forDigit(day % 10, 10);
                unpackedRowData[columnIndex] = dateAsBytes;
                break;
            }
            case 7: 
            case 12: {
                void binaryData;
                int length = (int)binaryData.readFieldLength();
                int year = 0;
                byte month = 0;
                byte day = 0;
                byte hour = 0;
                byte minute = 0;
                byte seconds = 0;
                int nanos = 0;
                if (length != 0) {
                    year = binaryData.readInt();
                    month = binaryData.readByte();
                    day = binaryData.readByte();
                    if (length > 4) {
                        hour = binaryData.readByte();
                        minute = binaryData.readByte();
                        seconds = binaryData.readByte();
                    }
                }
                if (year == 0 && month == 0 && day == 0) {
                    if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                        unpackedRowData[columnIndex] = null;
                        break;
                    }
                    if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                        throw new SQLException("Value '0000-00-00' can not be represented as java.sql.Timestamp", "S1009");
                    }
                    year = 1;
                    month = 1;
                    day = 1;
                }
                int stringLength = 19;
                byte[] nanosAsBytes = Integer.toString(nanos).getBytes();
                byte[] datetimeAsBytes = new byte[stringLength += 1 + nanosAsBytes.length];
                datetimeAsBytes[0] = (byte)Character.forDigit(year / 1000, 10);
                int after1000 = year % 1000;
                datetimeAsBytes[1] = (byte)Character.forDigit(after1000 / 100, 10);
                int after100 = after1000 % 100;
                datetimeAsBytes[2] = (byte)Character.forDigit(after100 / 10, 10);
                datetimeAsBytes[3] = (byte)Character.forDigit(after100 % 10, 10);
                datetimeAsBytes[4] = 45;
                datetimeAsBytes[5] = (byte)Character.forDigit(month / 10, 10);
                datetimeAsBytes[6] = (byte)Character.forDigit(month % 10, 10);
                datetimeAsBytes[7] = 45;
                datetimeAsBytes[8] = (byte)Character.forDigit(day / 10, 10);
                datetimeAsBytes[9] = (byte)Character.forDigit(day % 10, 10);
                datetimeAsBytes[10] = 32;
                datetimeAsBytes[11] = (byte)Character.forDigit(hour / 10, 10);
                datetimeAsBytes[12] = (byte)Character.forDigit(hour % 10, 10);
                datetimeAsBytes[13] = 58;
                datetimeAsBytes[14] = (byte)Character.forDigit(minute / 10, 10);
                datetimeAsBytes[15] = (byte)Character.forDigit(minute % 10, 10);
                datetimeAsBytes[16] = 58;
                datetimeAsBytes[17] = (byte)Character.forDigit(seconds / 10, 10);
                datetimeAsBytes[18] = (byte)Character.forDigit(seconds % 10, 10);
                datetimeAsBytes[19] = 46;
                int nanosOffset = 20;
                int j = 0;
                while (j < nanosAsBytes.length) {
                    datetimeAsBytes[nanosOffset + j] = nanosAsBytes[j];
                    ++j;
                }
                unpackedRowData[columnIndex] = datetimeAsBytes;
                break;
            }
            case 0: 
            case 15: 
            case 246: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                void binaryData;
                unpackedRowData[columnIndex] = binaryData.readLenByteArray(0);
                break;
            }
            default: {
                throw new SQLException(String.valueOf(Messages.getString("MysqlIO.97")) + curField.getMysqlType() + Messages.getString("MysqlIO.98") + (int)columnIndex + Messages.getString("MysqlIO.99") + ((void)fields).length + Messages.getString("MysqlIO.100"), "S1000");
            }
        }
        Object var37_52 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var37_52, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void sendViaChannel(Buffer buffer, int n) throws SQLException {
        Buffer buffer2 = buffer;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)buffer2, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            void packetLength;
            void packet;
            int oldLength = packet.getBufLength();
            packet.getNioBuffer().limit((int)packetLength);
            packet.setPosition(0);
            this.socketChannel.write(packet.getNioBuffer());
            packet.setBufLength(oldLength);
        }
        catch (IOException ioEx) {
            StringBuffer message = new StringBuffer(SQLError.get("08S01"));
            message.append(": ");
            message.append(ioEx.getClass().getName());
            message.append(Messages.getString("MysqlIO.102"));
            message.append(ioEx.getMessage());
            if (!this.connection.getParanoid()) {
                message.append(Util.stackTraceToString(ioEx));
            }
            throw new SQLException(message.toString(), "08S01", 0);
        }
        Object var8_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_9, joinPoint);
    }

    private Calendar getCalendarInstanceForSessionOrNew() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Calendar calendar = this.connection.getDynamicCalendars() ? Calendar.getInstance() : this.sessionCalendar;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(calendar, joinPoint);
        return calendar;
    }

    /*
     * WARNING - void declaration
     */
    private void negotiateSSLConnection(String string, String string2, String string3, int n) throws SQLException, CommunicationsException {
        void database;
        void password;
        void user;
        void packLength;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        int n2 = n;
        Object[] objectArray = new Object[]{string4, string5, string6, Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (!ExportControlled.enabled()) {
            throw new ConnectionFeatureNotAvailableException(this.connection, this.lastPacketSentTimeMs, null);
        }
        boolean doSecureAuth = false;
        if ((this.serverCapabilities & 0x8000) != 0) {
            this.clientParam |= 0x8000L;
            doSecureAuth = true;
        }
        this.clientParam |= 0x800L;
        Buffer packet = Buffer.allocateNew((int)packLength, this.useNewIo);
        if ((this.clientParam & 0x4000L) != 0L) {
            packet.writeLong(this.clientParam);
        } else {
            packet.writeInt((int)this.clientParam);
        }
        this.send(packet);
        ExportControlled.transformSocketToSSLSocket(this);
        packet.clear();
        if (doSecureAuth) {
            if (this.versionMeetsMinimum(4, 1, 1)) {
                this.secureAuth411(null, (int)packLength, (String)user, (String)password, (String)database, true);
            } else {
                this.secureAuth411(null, (int)packLength, (String)user, (String)password, (String)database, true);
            }
        } else {
            if ((this.clientParam & 0x4000L) != 0L) {
                packet.writeLong(this.clientParam);
                packet.writeLong(this.maxThreeBytes);
            } else {
                packet.writeInt((int)this.clientParam);
                packet.writeLongInt(this.maxThreeBytes);
            }
            packet.writeString((String)user);
            if (this.protocolVersion > 9) {
                packet.writeString(Util.newCrypt((String)password, this.seed));
            } else {
                packet.writeString(Util.oldCrypt((String)password, this.seed));
            }
            if ((this.serverCapabilities & 8) != 0 && database != null && database.length() > 0) {
                packet.writeString((String)database);
            }
            this.send(packet);
        }
        Object var13_13 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var13_13, joinPoint);
    }
}

