/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class CompressedInputStream
extends InputStream {
    private byte[] buffer;
    private Connection connection;
    private InputStream in;
    private Inflater inflater;
    private byte[] packetHeaderBuffer = new byte[7];
    private int pos = 0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;

    public CompressedInputStream(Connection conn, InputStream streamFromServer) {
        this.connection = conn;
        this.in = streamFromServer;
        this.inflater = new Inflater();
    }

    public int available() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.buffer == null ? this.in.available() : this.buffer.length - this.pos + this.in.available();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public void close() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.in.close();
        this.buffer = null;
        this.inflater = null;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private void getNextPacketFromServer() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] uncompressedData = null;
        int lengthRead = this.readFully(this.packetHeaderBuffer, 0, 7);
        if (lengthRead < 7) {
            throw new IOException("Unexpected end of input stream");
        }
        int compressedPacketLength = (this.packetHeaderBuffer[0] & 0xFF) + ((this.packetHeaderBuffer[1] & 0xFF) << 8) + ((this.packetHeaderBuffer[2] & 0xFF) << 16);
        int uncompressedLength = (this.packetHeaderBuffer[4] & 0xFF) + ((this.packetHeaderBuffer[5] & 0xFF) << 8) + ((this.packetHeaderBuffer[6] & 0xFF) << 16);
        if (this.connection.getTraceProtocol()) {
            try {
                this.connection.getLog().logTrace("Reading compressed packet of length " + compressedPacketLength + " uncompressed to " + uncompressedLength);
            }
            catch (SQLException sqlEx) {
                throw new IOException(sqlEx.toString());
            }
        }
        if (uncompressedLength > 0) {
            uncompressedData = new byte[uncompressedLength];
            byte[] compressedBuffer = new byte[compressedPacketLength];
            this.readFully(compressedBuffer, 0, compressedPacketLength);
            try {
                this.inflater.reset();
            }
            catch (NullPointerException nullPointerException) {
                this.inflater = new Inflater();
            }
            this.inflater.setInput(compressedBuffer);
            try {
                this.inflater.inflate(uncompressedData);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Error while uncompressing packet from server.");
            }
            this.inflater.end();
        } else {
            if (this.connection.getTraceProtocol()) {
                try {
                    this.connection.getLog().logTrace("Packet didn't meet compression threshold, not uncompressing...");
                }
                catch (SQLException compressedBuffer) {
                    throw new IOException(compressedBuffer.toString());
                }
            }
            uncompressedData = new byte[compressedPacketLength];
            this.readFully(uncompressedData, 0, compressedPacketLength);
        }
        if (this.connection.getTraceProtocol()) {
            try {
                this.connection.getLog().logTrace("Uncompressed packet: \n" + StringUtils.dumpAsHex(uncompressedData, compressedPacketLength));
            }
            catch (SQLException compressedBuffer) {
                throw new IOException(compressedBuffer.toString());
            }
        }
        if (this.buffer != null && this.pos < this.buffer.length) {
            if (this.connection.getTraceProtocol()) {
                try {
                    this.connection.getLog().logTrace("Combining remaining packet with new: ");
                }
                catch (SQLException compressedBuffer) {
                    throw new IOException(compressedBuffer.toString());
                }
            }
            int remaining = this.buffer.length - this.pos;
            byte[] newBuffer = new byte[remaining + uncompressedData.length];
            int newIndex = 0;
            int i = this.pos;
            while (i < this.buffer.length) {
                newBuffer[newIndex++] = this.buffer[i];
                ++i;
            }
            System.arraycopy(uncompressedData, 0, newBuffer, newIndex, uncompressedData.length);
            uncompressedData = newBuffer;
        }
        this.pos = 0;
        this.buffer = uncompressedData;
        Object var10_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_15, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void getNextPacketIfRequired(int n) throws IOException {
        void numBytes;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.buffer == null || this.pos + numBytes > this.buffer.length) {
            this.getNextPacketFromServer();
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public int read() throws IOException {
        int n;
        JoinPoint joinPoint;
        block2: {
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            try {
                this.getNextPacketIfRequired(1);
            }
            catch (IOException iOException) {
                n = -1;
                break block2;
            }
            n = this.buffer[this.pos++] & 0xFF;
        }
        int n2 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] byArray) throws IOException {
        void b;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.read((byte[])b, 0, ((void)b).length);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        JoinPoint joinPoint;
        block6: {
            void len;
            void off;
            void b;
            byte[] byArray2 = byArray;
            int n4 = n;
            int n5 = n2;
            Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n4), Conversions.intObject((int)n5)};
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > ((void)b).length || len < 0 || off + len > ((void)b).length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len <= 0) {
                n3 = 0;
            } else {
                try {
                    this.getNextPacketIfRequired((int)len);
                }
                catch (IOException iOException) {
                    n3 = -1;
                    break block6;
                }
                System.arraycopy(this.buffer, this.pos, b, (int)off, (int)len);
                this.pos += len;
                n3 = len;
            }
        }
        int n6 = n3;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n6), joinPoint);
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    private final int readFully(byte[] byArray, int n, int n2) throws IOException {
        void len;
        byte[] byArray2 = byArray;
        int n3 = n;
        int n4 = n2;
        Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = 0;
        while (n5 < len) {
            void off;
            void b;
            int count = this.in.read((byte[])b, (int)(off + n5), (int)(len - n5));
            if (count < 0) {
                throw new EOFException();
            }
            n5 += count;
        }
        int n6 = n5;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n6), joinPoint);
        return n6;
    }

    /*
     * WARNING - void declaration
     */
    public long skip(long l) throws IOException {
        void n;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long count = 0L;
        long i = 0L;
        while (i < n) {
            int bytesRead = this.read();
            if (bytesRead == -1) break;
            ++count;
            ++i;
        }
        long l3 = count;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l3), joinPoint);
        return l3;
    }

    static {
        Factory factory = new Factory("CompressedInputStream.java", Class.forName("com.mysql.jdbc.CompressedInputStream"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-available-com.mysql.jdbc.CompressedInputStream---java.io.IOException:-int-"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-close-com.mysql.jdbc.CompressedInputStream---java.io.IOException:-void-"), 95);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getNextPacketFromServer-com.mysql.jdbc.CompressedInputStream---java.io.IOException:-void-"), 108);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getNextPacketIfRequired-com.mysql.jdbc.CompressedInputStream-int:-numBytes:-java.io.IOException:-void-"), 234);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.CompressedInputStream---java.io.IOException:-int-"), 245);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.CompressedInputStream-[B:-b:-java.io.IOException:-int-"), 257);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.CompressedInputStream-[B:int:int:-b:off:len:-java.io.IOException:-int-"), 264);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12-readFully-com.mysql.jdbc.CompressedInputStream-[B:int:int:-b:off:len:-java.io.IOException:-int-"), 288);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-skip-com.mysql.jdbc.CompressedInputStream-long:-n:-java.io.IOException:-long-"), 311);
    }
}

