/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ByteArrayBuffer;
import com.mysql.jdbc.ChannelBuffer;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

abstract class Buffer {
    static final int MAX_BYTES_TO_DUMP = 512;
    static final int NO_LENGTH_LIMIT = -1;
    static final long NULL_LENGTH = -1L;
    protected boolean wasMultiPacket = false;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    Buffer() {
    }

    /*
     * WARNING - void declaration
     */
    public static Buffer allocateDirect(int n, boolean bl) {
        int size;
        void useNewIo;
        int n2 = n;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n2), (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buffer = useNewIo == false ? Buffer.allocateNew(size, (boolean)useNewIo) : new ChannelBuffer(size, true);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public static Buffer allocateNew(byte[] byArray, boolean bl) {
        byte[] buf;
        void useNewIo;
        byte[] byArray2 = byArray;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)byArray2, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buffer = useNewIo == false ? new ByteArrayBuffer(buf) : new ChannelBuffer(buf);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public static Buffer allocateNew(int n, boolean bl) {
        int size;
        void useNewIo;
        int n2 = n;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)Conversions.intObject((int)n2), (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Buffer buffer = useNewIo == false ? new ByteArrayBuffer(size) : new ChannelBuffer(size, true);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(buffer, joinPoint);
        return buffer;
    }

    abstract void clear();

    final void dump() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.dump(this.getBufLength());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final String dump(int n) {
        void numBytes;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = StringUtils.dumpAsHex(this.getBytes(0, numBytes > this.getBufLength() ? this.getBufLength() : numBytes), numBytes > this.getBufLength() ? this.getBufLength() : numBytes);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    final String dumpClampedBytes(int n) {
        int numBytes;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int numBytesToDump = numBytes < 512 ? numBytes : 512;
        String dumped = StringUtils.dumpAsHex(this.getBytes(0, numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump), numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump);
        String string = numBytesToDump < numBytes ? String.valueOf(dumped) + " ....(packet exceeds max. dump length)" : dumped;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    final void dumpHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int i = 0;
        while (i < 4) {
            String hexVal = Integer.toHexString(this.readByte(i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(String.valueOf(hexVal) + " ");
            ++i;
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void dumpNBytes(int n, int n2) {
        void nBytes;
        void start;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer asciiBuf = new StringBuffer();
        void i = start;
        while (i < start + nBytes && i < this.getBufLength()) {
            String hexVal = Integer.toHexString(this.readByte((int)i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(String.valueOf(hexVal) + " ");
            if (this.readByte((int)i) > 32 && this.readByte((int)i) < 127) {
                asciiBuf.append((char)this.readByte((int)i));
            } else {
                asciiBuf.append(".");
            }
            asciiBuf.append(" ");
            ++i;
        }
        System.out.println("    " + asciiBuf.toString());
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    abstract void ensureCapacity(int var1) throws SQLException;

    public abstract int fastSkipLenString();

    abstract int getBufLength();

    public abstract byte[] getByteBuffer();

    abstract byte[] getBytes(int var1);

    abstract byte[] getBytes(int var1, int var2);

    abstract int getCapacity();

    public abstract ByteBuffer getNioBuffer();

    public abstract int getPosition();

    abstract boolean isLastDataPacket();

    abstract long newReadLength();

    abstract byte readByte();

    abstract byte readByte(int var1);

    abstract long readFieldLength();

    abstract int readInt();

    abstract int readIntAsLong();

    abstract byte[] readLenByteArray(int var1);

    abstract long readLength();

    abstract long readLong();

    abstract int readLongInt();

    abstract long readLongLong();

    abstract int readnBytes();

    abstract String readString();

    abstract String readString(String var1) throws SQLException;

    abstract void setBufLength(int var1);

    public abstract void setByteBuffer(byte[] var1);

    public abstract void setPosition(int var1);

    /*
     * WARNING - void declaration
     */
    public void setWasMultiPacket(boolean bl) {
        void flag;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.wasMultiPacket = flag;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.dumpClampedBytes(this.getPosition());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String toSuperString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = super.toString();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public boolean wasMultiPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.wasMultiPacket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    abstract void writeByte(byte var1) throws SQLException;

    abstract void writeBytesNoNull(byte[] var1) throws SQLException;

    abstract void writeBytesNoNull(byte[] var1, int var2, int var3) throws SQLException;

    abstract void writeDouble(double var1) throws SQLException;

    abstract void writeFieldLength(long var1) throws SQLException;

    abstract void writeFloat(float var1) throws SQLException;

    abstract void writeInt(int var1) throws SQLException;

    abstract void writeLenBytes(byte[] var1) throws SQLException;

    abstract void writeLenString(String var1, String var2, String var3, SingleByteCharsetConverter var4, boolean var5) throws UnsupportedEncodingException, SQLException;

    abstract void writeLong(long var1) throws SQLException;

    abstract void writeLongInt(int var1) throws SQLException;

    abstract void writeLongLong(long var1) throws SQLException;

    abstract void writeString(String var1) throws SQLException;

    abstract void writeStringNoNull(String var1) throws SQLException;

    abstract void writeStringNoNull(String var1, String var2, String var3, boolean var4) throws UnsupportedEncodingException, SQLException;

    static {
        Factory factory = new Factory("Buffer.java", Class.forName("com.mysql.jdbc.Buffer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-allocateDirect-com.mysql.jdbc.Buffer-int:boolean:-size:useNewIo:--com.mysql.jdbc.Buffer-"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-allocateNew-com.mysql.jdbc.Buffer-[B:boolean:-buf:useNewIo:--com.mysql.jdbc.Buffer-"), 55);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toSuperString-com.mysql.jdbc.Buffer----java.lang.String-"), 246);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-wasMultiPacket-com.mysql.jdbc.Buffer----boolean-"), 255);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-allocateNew-com.mysql.jdbc.Buffer-int:boolean:-size:useNewIo:--com.mysql.jdbc.Buffer-"), 63);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dump-com.mysql.jdbc.Buffer----void-"), 75);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dump-com.mysql.jdbc.Buffer-int:-numBytes:--java.lang.String-"), 79);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dumpClampedBytes-com.mysql.jdbc.Buffer-int:-numBytes:--java.lang.String-"), 85);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dumpHeader-com.mysql.jdbc.Buffer----void-"), 102);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dumpNBytes-com.mysql.jdbc.Buffer-int:int:-start:nBytes:--void-"), 114);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setWasMultiPacket-com.mysql.jdbc.Buffer-boolean:-flag:--void-"), 238);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.Buffer----java.lang.String-"), 242);
    }
}

