/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.matching.ClassFileMatchLocator;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchMatch;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatchSet;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.jdt.internal.core.util.HandleFactory;
import org.eclipse.jdt.internal.core.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.Util;

public class MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE = 500;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IJavaSearchScope scope;
    public IProgressMonitor progressMonitor;
    public ICompilationUnit[] workingCopies;
    public HandleFactory handleFactory;
    public char[][][] allSuperTypeNames;
    public MatchLocatorParser parser;
    private Parser basicParser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public HierarchyResolver hierarchyResolver;
    public CompilerOptions options;
    public int numberOfMatches;
    public PossibleMatch[] matchesToProcess;
    public PossibleMatch currentPossibleMatch;
    public long resultCollectorTime = 0L;

    public static ClassFileReader classFileReader(IType type) {
        IClassFile classFile = type.getClassFile();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (classFile.isOpen()) {
            return (ClassFileReader)manager.getInfo(type);
        }
        IPackageFragment pkg = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            IPath zipPath;
            if (!root.isArchive()) {
                return ClassFileReader.read(type.getPath().toOSString());
            }
            IPath iPath = zipPath = root.isExternal() ? root.getPath() : root.getResource().getLocation();
            if (zipPath == null) {
                return null;
            }
            ZipFile zipFile = null;
            try {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [MatchLocator.classFileReader()] Creating ZipFile on " + zipPath);
                }
                zipFile = manager.getZipFile(zipPath);
                char[] pkgPath = pkg.getElementName().toCharArray();
                CharOperation.replace(pkgPath, '.', '/');
                char[] classFileName = classFile.getElementName().toCharArray();
                char[] path = pkgPath.length == 0 ? classFileName : CharOperation.concat(pkgPath, classFileName, '/');
                ClassFileReader classFileReader = ClassFileReader.read(zipFile, new String(path));
                Object var10_14 = null;
                manager.closeZipFile(zipFile);
                return classFileReader;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                manager.closeZipFile(zipFile);
                throw throwable;
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IJavaSearchScope scope, ICompilationUnit[] workingCopies, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.workingCopies = workingCopies;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit) {
        block2: {
            CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block2;
                throw e;
            }
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
        }
        return this.basicParser;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void buildBindings(PossibleMatch possibleMatch) {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (SearchEngine.VERBOSE) {
                System.out.println("Parsing " + possibleMatch.openable.toStringWithAncestors());
            }
            this.parser.nodeSet = possibleMatch.nodeSet;
            CompilationResult unitResult = new CompilationResult(possibleMatch, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(possibleMatch, unitResult);
            if (parsedUnit != null) {
                if (!parsedUnit.isEmpty()) {
                    this.lookupEnvironment.buildTypeBindings(parsedUnit);
                }
                possibleMatch.parsedUnit = parsedUnit;
                int size = this.matchesToProcess.length;
                if (this.numberOfMatches == size) {
                    this.matchesToProcess = new PossibleMatch[size == 0 ? 1 : size * 2];
                    System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.numberOfMatches);
                }
                this.matchesToProcess[this.numberOfMatches++] = possibleMatch;
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(4);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.parser.nodeSet = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.parser.nodeSet = null;
            return;
        }
    }

    protected BinaryTypeBinding cacheBinaryType(IType type) throws JavaModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        IBinaryType binaryType;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType);
        }
        if ((binding = this.lookupEnvironment.cacheBinaryType(binaryType = (IBinaryType)((BinaryType)type).getElementInfo())) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    protected char[][][] computeSuperTypeNames(IType focusType) {
        String fullyQualifiedName = focusType.getFullyQualifiedName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        char[] qualification = lastDot == -1 ? CharOperation.NO_CHAR : fullyQualifiedName.substring(0, lastDot).toCharArray();
        char[] simpleName = focusType.getElementName().toCharArray();
        SuperTypeNamesCollector superTypeNamesCollector = new SuperTypeNamesCollector(this.pattern, simpleName, qualification, new MatchLocator(this.pattern, this.requestor, this.scope, this.workingCopies, this.progressMonitor), focusType, this.progressMonitor);
        try {
            this.allSuperTypeNames = superTypeNamesCollector.collect();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return this.allSuperTypeNames;
    }

    protected IJavaElement createHandle(AbstractMethodDeclaration method, IJavaElement parent) {
        int argCount;
        if (!(parent instanceof IType)) {
            return parent;
        }
        IType type = (IType)parent;
        Argument[] arguments = method.arguments;
        int n = argCount = arguments == null ? 0 : arguments.length;
        if (type.isBinary()) {
            IBinaryMethod[] methods;
            ClassFileReader reader = MatchLocator.classFileReader(type);
            if (reader != null && (methods = reader.getMethods()) != null) {
                boolean firstIsSynthetic = false;
                try {
                    if (type.isMember() && method.isConstructor() && !Flags.isStatic(type.getFlags())) {
                        firstIsSynthetic = true;
                        ++argCount;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                int i = 0;
                int methodsLength = methods.length;
                while (i < methodsLength) {
                    block15: {
                        char[][] parameterTypes;
                        char[] selector;
                        IBinaryMethod binaryMethod = methods[i];
                        char[] cArray = selector = binaryMethod.isConstructor() ? type.getElementName().toCharArray() : binaryMethod.getSelector();
                        if (CharOperation.equals(selector, method.selector) && argCount == (parameterTypes = Signature.getParameterTypes(binaryMethod.getMethodDescriptor())).length) {
                            int j = 0;
                            while (j < argCount) {
                                char[] typeName;
                                if (j == 0 && firstIsSynthetic) {
                                    typeName = type.getDeclaringType().getFullyQualifiedName().toCharArray();
                                } else {
                                    TypeReference typeRef = arguments[firstIsSynthetic ? j - 1 : j].type;
                                    typeName = CharOperation.concatWith(typeRef.getTypeName(), '.');
                                    int k = 0;
                                    int dim = typeRef.dimensions();
                                    while (k < dim) {
                                        typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                                        ++k;
                                    }
                                }
                                char[] parameterTypeName = ClassFileMatchLocator.convertClassFileFormat(parameterTypes[j]);
                                if (CharOperation.endsWith(Signature.toCharArray(parameterTypeName), typeName)) {
                                    parameterTypes[j] = parameterTypeName;
                                    ++j;
                                    continue;
                                }
                                break block15;
                            }
                            return type.getMethod(new String(selector), CharOperation.toStrings(parameterTypes));
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        String[] parameterTypeSignatures = new String[argCount];
        int i = 0;
        while (i < argCount) {
            TypeReference typeRef = arguments[i].type;
            char[] typeName = CharOperation.concatWith(typeRef.getTypeName(), '.');
            int j = 0;
            int dim = typeRef.dimensions();
            while (j < dim) {
                typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                ++j;
            }
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return type.getMethod(new String(method.selector), parameterTypeSignatures);
    }

    protected IJavaElement createHandle(FieldDeclaration fieldDeclaration, TypeDeclaration typeDeclaration, IJavaElement parent) {
        if (!(parent instanceof IType)) {
            return parent;
        }
        if (fieldDeclaration.isField()) {
            return ((IType)parent).getField(new String(fieldDeclaration.name));
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i = 0;
        int length = fields.length;
        while (i < length) {
            if (!fields[i].isField()) {
                ++occurrenceCount;
                if (fields[i].equals(fieldDeclaration)) break;
            }
            ++i;
        }
        return ((IType)parent).getInitializer(occurrenceCount);
    }

    protected boolean createHierarchyResolver(IType focusType, PossibleMatch[] possibleMatches) {
        char[][] compoundName = CharOperation.splitOn('.', focusType.getFullyQualifiedName().toCharArray());
        boolean isPossibleMatch = false;
        int i = 0;
        int length = possibleMatches.length;
        while (i < length) {
            if (CharOperation.equals(possibleMatches[i].compoundName, compoundName)) {
                isPossibleMatch = true;
                break;
            }
            ++i;
        }
        if (!isPossibleMatch) {
            if (focusType.isBinary()) {
                try {
                    this.cacheBinaryType(focusType);
                }
                catch (JavaModelException e) {
                    return false;
                }
            } else {
                this.accept((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)focusType.getCompilationUnit()));
            }
        }
        this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
        ReferenceBinding binding = this.hierarchyResolver.setFocusType(compoundName);
        return binding != null && binding.isValidBinding() && (binding.tagBits & 0x8000) == 0;
    }

    protected IJavaElement createImportHandle(ImportReference importRef) {
        Openable openable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if (importRef.onDemand) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((openable = this.currentPossibleMatch.openable) instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getImport(new String(importName));
        }
        IType binaryType = ((ClassFile)openable).getType();
        String typeName = binaryType.getElementName();
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDollar == -1) {
            return binaryType;
        }
        return this.createTypeHandle(typeName.substring(0, lastDollar));
    }

    protected IType createTypeHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getType(simpleTypeName);
        }
        IType binaryType = ((ClassFile)openable).getType();
        if (simpleTypeName.equals(binaryType.getTypeQualifiedName())) {
            return binaryType;
        }
        try {
            IClassFile classFile = binaryType.getPackageFragment().getClassFile(String.valueOf(simpleTypeName) + ".class");
            return classFile.getType();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            IJavaElement pkg = classFile.getParent();
            PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
            if (!root.isArchive()) {
                String osPath = resource.getLocation().toOSString();
                return ClassFileReader.read(osPath);
            }
            String pkgPath = pkg.getElementName().replace('.', '/');
            String classFilePath = pkgPath.length() > 0 ? String.valueOf(pkgPath) + "/" + classFile.getElementName() : classFile.getElementName();
            ZipFile zipFile = null;
            try {
                zipFile = ((JarPackageFragmentRoot)root).getJar();
                info = ClassFileReader.read(zipFile, classFilePath);
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                throw throwable;
            }
            {
                Object var10_15 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return info;
            }
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected IType getFocusType() {
        return this.scope instanceof HierarchyScope ? ((HierarchyScope)this.scope).focusType : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getMethodBodies(CompilationUnitDeclaration unit) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        int[] oldLineEnds = this.parser.scanner.lineEnds;
        int oldLinePtr = this.parser.scanner.linePtr;
        try {
            char[] contents = unit.compilationResult.compilationUnit.getContents();
            this.parser.scanner.setSource(contents);
            int[] lineSeparatorPositions = unit.compilationResult.lineSeparatorPositions;
            this.parser.scanner.lineEnds = lineSeparatorPositions;
            this.parser.scanner.linePtr = lineSeparatorPositions.length - 1;
            if (this.parser.javadocParser.checkJavadoc) {
                this.parser.javadocParser.scanner.setSource(contents);
            }
            this.parser.nodeSet = this.currentPossibleMatch.nodeSet;
            this.parser.parseBodies(unit);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            return;
        }
    }

    protected boolean hasAlreadyDefinedType(CompilationUnitDeclaration parsedUnit) {
        CompilationResult result = parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        int i = 0;
        while (i < result.problemCount) {
            if (result.problems[i].getID() == 16777539) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initialize(JavaProject project, int possibleMatchSize) throws JavaModelException {
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        this.nameEnvironment = possibleMatchSize == 1 ? (INameEnvironment)project.getSearchableNameEnvironment() : (INameEnvironment)new JavaSearchNameEnvironment(project);
        this.options = new CompilerOptions(project.getOptions(true));
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, this.nameEnvironment);
        this.parser = MatchLocatorParser.createParser(problemReporter, this);
        this.nameLookup = project.getNameLookup();
        this.numberOfMatches = 0;
        this.matchesToProcess = new PossibleMatch[possibleMatchSize];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void locateMatches(JavaProject javaProject, PossibleMatch[] possibleMatches, int start, int length) throws JavaModelException {
        this.initialize(javaProject, length);
        try {
            boolean bindingsWereCreated;
            block18: {
                this.nameLookup.setUnitsToLookInside(this.workingCopies);
                bindingsWereCreated = true;
                try {
                    IType focusType;
                    int i = start;
                    int maxUnits = start + length;
                    while (true) {
                        if (i >= maxUnits) {
                            this.lookupEnvironment.completeTypeBindings();
                            focusType = this.getFocusType();
                            if (focusType != null) break;
                            this.hierarchyResolver = null;
                            break block18;
                        }
                        this.buildBindings(possibleMatches[i]);
                        ++i;
                    }
                    if (this.createHierarchyResolver(focusType, possibleMatches) || this.computeSuperTypeNames(focusType) != null) break block18;
                    Object var11_12 = null;
                }
                catch (AbortCompilation e) {
                    bindingsWereCreated = false;
                    break block18;
                }
                this.nameLookup.setUnitsToLookInside(null);
                return;
            }
            int i = 0;
            while (i < this.numberOfMatches) {
                PossibleMatch possibleMatch;
                block19: {
                    Object var9_19;
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    possibleMatch = this.matchesToProcess[i];
                    this.matchesToProcess[i] = null;
                    try {
                        try {
                            this.process(possibleMatch, bindingsWereCreated);
                        }
                        catch (AbortCompilation e) {
                            bindingsWereCreated = false;
                        }
                        catch (JavaModelException e) {
                            bindingsWereCreated = false;
                        }
                        catch (CoreException e) {
                            throw new JavaModelException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        var9_19 = null;
                        if (this.options.verbose) {
                            System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                        }
                        possibleMatch.parsedUnit.cleanUp();
                        possibleMatch.parsedUnit = null;
                        throw throwable;
                    }
                    {
                        var9_19 = null;
                        if (!this.options.verbose) break block19;
                    }
                    System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                }
                possibleMatch.parsedUnit.cleanUp();
                possibleMatch.parsedUnit = null;
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(5);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.nameLookup.setUnitsToLookInside(null);
            throw throwable;
        }
        {
            Object var11_14 = null;
            this.nameLookup.setUnitsToLookInside(null);
            return;
        }
    }

    protected void locateMatches(JavaProject javaProject, PossibleMatchSet matchSet) throws JavaModelException {
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(javaProject.getPackageFragmentRoots());
        int index = 0;
        int length = possibleMatches.length;
        while (index < length) {
            int max = Math.min(500, length - index);
            this.locateMatches(javaProject, possibleMatches, index, max);
            index += max;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(SearchDocument[] searchDocuments) throws JavaModelException {
        if (SearchEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            int i = 0;
            int length = searchDocuments.length;
            while (i < length) {
                System.out.println("\t" + searchDocuments[i]);
                ++i;
            }
            System.out.println("]");
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            block27: {
                manager.cacheZipFiles();
                if (this.handleFactory == null) {
                    this.handleFactory = new HandleFactory();
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.beginTask("", searchDocuments.length * (this.pattern.mustResolve ? 10 : 5));
                }
                this.patternLocator.initializePolymorphicSearch(this);
                JavaProject previousJavaProject = null;
                PossibleMatchSet matchSet = new PossibleMatchSet();
                Util.sort((Object[])searchDocuments, new Util.Comparer(){

                    public int compare(Object a, Object b) {
                        return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                    }
                });
                int i = 0;
                int l = searchDocuments.length;
                while (i < l) {
                    block26: {
                        IResource resource;
                        Openable openable;
                        SearchDocument searchDocument;
                        block24: {
                            ICompilationUnit workingCopy;
                            block29: {
                                String pathString;
                                block28: {
                                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    searchDocument = searchDocuments[i];
                                    pathString = searchDocument.getPath();
                                    if (i > 0 && pathString.equals(searchDocuments[i - 1].getPath())) break block26;
                                    workingCopy = null;
                                    if (!(searchDocument instanceof JavaSearchParticipant.WorkingCopyDocument)) break block28;
                                    workingCopy = ((JavaSearchParticipant.WorkingCopyDocument)searchDocument).workingCopy;
                                    openable = (Openable)((Object)workingCopy);
                                    break block29;
                                }
                                openable = this.handleFactory.createOpenable(pathString, this.scope);
                                if (openable == null) break block26;
                            }
                            resource = null;
                            try {
                                JavaProject javaProject = (JavaProject)openable.getJavaProject();
                                IResource iResource = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                                if (resource == null) {
                                    resource = javaProject.getProject();
                                }
                                if (javaProject.equals(previousJavaProject)) break block24;
                                if (previousJavaProject != null) {
                                    block25: {
                                        try {
                                            this.locateMatches(previousJavaProject, matchSet);
                                        }
                                        catch (JavaModelException e) {
                                            if (!(e.getException() instanceof CoreException)) break block25;
                                            throw e;
                                        }
                                    }
                                    matchSet.reset();
                                }
                                previousJavaProject = javaProject;
                            }
                            catch (JavaModelException e) {
                                break block26;
                            }
                        }
                        matchSet.add(new PossibleMatch(this, resource, openable, searchDocument));
                        if (this.progressMonitor != null) {
                            this.progressMonitor.worked(1);
                        }
                    }
                    ++i;
                }
                if (previousJavaProject != null) {
                    try {
                        this.locateMatches(previousJavaProject, matchSet);
                    }
                    catch (JavaModelException e) {
                        if (!(e.getException() instanceof CoreException)) break block27;
                        throw e;
                    }
                }
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
            Object var14_20 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            return;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            throw throwable;
        }
    }

    public void locatePackageDeclarations(SearchParticipant participant) throws JavaModelException {
        this.locatePackageDeclarations(this.pattern, participant);
    }

    protected void locatePackageDeclarations(SearchPattern searchPattern, SearchParticipant participant) throws JavaModelException {
        block14: {
            block13: {
                if (!(searchPattern instanceof OrPattern)) break block13;
                SearchPattern[] patterns = ((OrPattern)searchPattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    this.locatePackageDeclarations(patterns[i], participant);
                    ++i;
                }
                break block14;
            }
            if (!(searchPattern instanceof PackageDeclarationPattern)) break block14;
            if (searchPattern.focus != null) {
                IResource resource = searchPattern.focus.getResource();
                SearchDocument document = participant.getDocument(resource.getFullPath().toString());
                this.currentPossibleMatch = new PossibleMatch(this, resource, null, document);
                try {
                    this.report(-1, -2, searchPattern.focus, 0);
                }
                catch (CoreException e) {
                    if (e instanceof JavaModelException) {
                        throw (JavaModelException)e;
                    }
                    throw new JavaModelException(e);
                }
                return;
            }
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject javaProject = projects[i];
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int j = 0;
                int rootsLength = roots.length;
                while (j < rootsLength) {
                    IJavaElement[] pkgs = roots[j].getChildren();
                    int k = 0;
                    int pksLength = pkgs.length;
                    while (k < pksLength) {
                        IPackageFragment pkg = (IPackageFragment)pkgs[k];
                        if (pkg.getChildren().length > 0 && pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) {
                            IResource resource = pkg.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            SearchDocument document = participant.getDocument(resource.getFullPath().toString());
                            this.currentPossibleMatch = new PossibleMatch(this, resource, null, document);
                            try {
                                this.report(-1, -2, (IJavaElement)pkg, 0);
                            }
                            catch (JavaModelException e) {
                                throw e;
                            }
                            catch (CoreException e) {
                                throw new JavaModelException(e);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected IType lookupType(ReferenceBinding typeBinding) {
        IType type;
        if (typeBinding == null) {
            return null;
        }
        char[] packageName = typeBinding.qualifiedPackageName();
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        char[] sourceName = typeBinding.qualifiedSourceName();
        String typeName = new String(sourceName);
        int i = 0;
        int length = pkgs == null ? 0 : pkgs.length;
        while (i < length) {
            type = this.nameLookup.findType(typeName, pkgs[i], false, typeBinding.isClass() ? 2 : 4);
            if (type != null) {
                return type;
            }
            ++i;
        }
        char[][] qualifiedName = CharOperation.splitOn('.', sourceName);
        length = qualifiedName.length;
        if (length == 0) {
            return null;
        }
        type = this.createTypeHandle(new String(qualifiedName[0]));
        if (type == null) {
            return null;
        }
        int i2 = 1;
        while (i2 < length) {
            if ((type = type.getType(new String(qualifiedName[i2]))) == null) {
                return null;
            }
            ++i2;
        }
        if (type.exists()) {
            return type;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(PossibleMatch possibleMatch, boolean bindingsWereCreated) throws CoreException {
        block15: {
            block14: {
                this.currentPossibleMatch = possibleMatch;
                CompilationUnitDeclaration unit = possibleMatch.parsedUnit;
                try {
                    block13: {
                        try {
                            if (unit.isEmpty()) {
                                ClassFile classFile;
                                IBinaryType info;
                                if (this.currentPossibleMatch.openable instanceof ClassFile && (info = this.getBinaryInfo(classFile = (ClassFile)this.currentPossibleMatch.openable, this.currentPossibleMatch.resource)) != null) {
                                    new ClassFileMatchLocator().locateMatches(this, classFile, info);
                                }
                                Object var6_7 = null;
                                break block13;
                            }
                            if (this.hasAlreadyDefinedType(unit)) {
                                break block14;
                            }
                            this.getMethodBodies(unit);
                            if (bindingsWereCreated && this.pattern.mustResolve && unit.types != null) {
                                if (SearchEngine.VERBOSE) {
                                    System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                                }
                                this.reduceParseTree(unit);
                                if (unit.scope != null) {
                                    unit.scope.faultInTypes();
                                }
                                unit.resolve();
                                this.reportMatching(unit, true);
                                break block15;
                            } else {
                                this.reportMatching(unit, this.pattern.mustResolve);
                            }
                            break block15;
                        }
                        catch (AbortCompilation e) {
                            this.reportMatching(unit, true);
                            if (!(e instanceof AbortCompilationUnit)) {
                                throw e;
                            }
                            break block15;
                        }
                    }
                    this.currentPossibleMatch.cleanUp();
                    this.currentPossibleMatch = null;
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.currentPossibleMatch.cleanUp();
                    this.currentPossibleMatch = null;
                    throw throwable;
                }
            }
            Object var6_8 = null;
            this.currentPossibleMatch.cleanUp();
            this.currentPossibleMatch = null;
            return;
        }
        Object var6_10 = null;
        this.currentPossibleMatch.cleanUp();
        this.currentPossibleMatch = null;
    }

    protected void purgeMethodStatements(TypeDeclaration type, boolean checkEachMethod) {
        TypeDeclaration[] memberTypes;
        checkEachMethod = checkEachMethod && this.currentPossibleMatch.nodeSet.hasPossibleNodes(type.declarationSourceStart, type.declarationSourceEnd);
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            int length;
            int j;
            if (checkEachMethod) {
                j = 0;
                length = methods.length;
                while (j < length) {
                    AbstractMethodDeclaration method = methods[j];
                    if (!this.currentPossibleMatch.nodeSet.hasPossibleNodes(method.declarationSourceStart, method.declarationSourceEnd)) {
                        method.statements = null;
                        method.javadoc = null;
                    }
                    ++j;
                }
            } else {
                j = 0;
                length = methods.length;
                while (j < length) {
                    methods[j].statements = null;
                    methods[j].javadoc = null;
                    ++j;
                }
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                this.purgeMethodStatements(memberTypes[i], checkEachMethod);
                ++i;
            }
        }
    }

    protected void reduceParseTree(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        int i = 0;
        int l = types.length;
        while (i < l) {
            this.purgeMethodStatements(types[i], true);
            ++i;
        }
    }

    protected void report(int sourceStart, int sourceEnd, IJavaElement element, int accuracy) throws CoreException {
        if (element != null && this.scope.encloses(element)) {
            if (SearchEngine.VERBOSE) {
                IResource res = this.currentPossibleMatch.resource;
                System.out.println("Reporting match");
                System.out.println("\tResource: " + (res == null ? " <unknown> " : res.getFullPath().toString()));
                System.out.println("\tPositions: [" + sourceStart + ", " + sourceEnd + "]");
                System.out.println("\tJava element: " + ((JavaElement)element).toStringWithAncestors());
                System.out.println(accuracy == 0 ? "\tAccuracy: EXACT_MATCH" : "\tAccuracy: POTENTIAL_MATCH");
            }
            this.report(this.currentPossibleMatch.resource, sourceStart, sourceEnd, element, accuracy, this.getParticipant());
        }
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    protected void report(IResource resource, int sourceStart, int sourceEnd, IJavaElement element, int accuracy, SearchParticipant participant) throws CoreException {
        long start = -1L;
        if (SearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
        }
        String documentPath = element.getPath().toString();
        JavaSearchMatch match = new JavaSearchMatch(resource, element, documentPath, accuracy, participant, sourceStart, sourceEnd + 1, -1);
        this.requestor.acceptSearchMatch(match);
        if (SearchEngine.VERBOSE) {
            this.resultCollectorTime += System.currentTimeMillis() - start;
        }
    }

    protected void report(long start, long end, IJavaElement element, int accuracy) throws CoreException {
        this.report((int)(start >>> 32), (int)end, element, accuracy);
    }

    protected void reportAccurateReference(int sourceStart, int sourceEnd, char[] name, IJavaElement element, int accuracy) throws CoreException {
        if (accuracy == -1) {
            return;
        }
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int token = -1;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (token != 24 || !this.pattern.matchesName(name, scanner.getCurrentTokenSource())) continue;
            this.report(currentPosition, scanner.currentPosition - 1, element, accuracy);
            return;
        } while (token != 75);
        this.report(sourceStart, sourceEnd, element, accuracy);
    }

    protected void reportAccurateReference(int sourceStart, int sourceEnd, char[][] tokens, IJavaElement element, int[] accuracies) throws CoreException {
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int accuracyIndex = 0;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (token != 75) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
            if (accuracies[accuracyIndex] != -1) {
                if (refSourceStart != -1) {
                    this.report(refSourceStart, refSourceEnd, element, accuracies[accuracyIndex]);
                } else {
                    this.report(sourceStart, sourceEnd, element, accuracies[accuracyIndex]);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (accuracyIndex >= accuracies.length - 1) continue;
            ++accuracyIndex;
        } while (token != 75);
    }

    protected void reportBinaryMatch(IResource resource, IMember binaryMember, IBinaryType info, int accuracy) throws CoreException {
        char[] contents;
        IType type;
        String sourceFileName;
        ClassFile classFile;
        SourceMapper mapper;
        ISourceRange range = binaryMember.getNameRange();
        if (range.getOffset() == -1 && (mapper = (classFile = (ClassFile)binaryMember.getClassFile()).getSourceMapper()) != null && (sourceFileName = mapper.findSourceFileName(type = classFile.getType(), info)) != null && (contents = mapper.findSource(type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, binaryMember);
        }
        int startIndex = range.getOffset();
        int endIndex = startIndex + range.getLength() - 1;
        if (resource == null) {
            this.report(startIndex, endIndex, (IJavaElement)binaryMember, accuracy);
        } else {
            this.report(resource, startIndex, endIndex, binaryMember, accuracy, this.getParticipant());
        }
    }

    protected void reportMatching(AbstractMethodDeclaration method, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IJavaElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(method, parent)) != null) {
            Scanner scanner = this.parser.scanner;
            int nameSourceStart = method.sourceStart;
            scanner.setSource(this.currentPossibleMatch.getContents());
            scanner.resetTo(nameSourceStart, method.sourceEnd);
            try {
                scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            int nameSourceEnd = scanner.currentPosition - 1;
            this.report(nameSourceStart, nameSourceEnd, enclosingElement, accuracy);
        }
        if ((method.bits & 2) != 0) {
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(method, parent);
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
            try {
                method.traverse((ASTVisitor)localDeclarationVisitor, (ClassScope)null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.declarationSourceStart, method.declarationSourceEnd)) != null) {
            int l;
            int i;
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (enclosingElement != null) {
                    i = 0;
                    l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        this.patternLocator.matchReportReference(node, enclosingElement, level, this);
                        ++i;
                    }
                    return;
                }
            }
            i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(CompilationUnitDeclaration unit, boolean mustResolve) throws CoreException {
        TypeDeclaration[] types;
        Integer level;
        int i;
        ImportReference[] imports;
        boolean matchedUnitContainer;
        ImportReference importRef;
        MatchingNodeSet nodeSet = this.currentPossibleMatch.nodeSet;
        if (mustResolve) {
            Object[] nodes = nodeSet.possibleMatchingNodesSet.values;
            int i2 = 0;
            int l = nodes.length;
            while (i2 < l) {
                ASTNode node = (ASTNode)nodes[i2];
                if (node != null) {
                    if (node instanceof ImportReference) {
                        if (this.hierarchyResolver == null) {
                            importRef = (ImportReference)node;
                            Binding binding = importRef.onDemand ? unit.scope.getTypeOrPackage(CharOperation.subarray(importRef.tokens, 0, importRef.tokens.length)) : unit.scope.getTypeOrPackage(importRef.tokens);
                            this.patternLocator.matchLevelAndReportImportRef(importRef, binding, this);
                        }
                    } else {
                        nodeSet.addMatch(node, this.patternLocator.resolveLevel(node));
                    }
                }
                ++i2;
            }
            nodeSet.possibleMatchingNodesSet = new SimpleSet();
        }
        if (nodeSet.matchingNodes.elementSize == 0) {
            return;
        }
        boolean bl = matchedUnitContainer = (this.matchContainer & 1) != 0;
        if (matchedUnitContainer && (imports = unit.imports) != null) {
            i = 0;
            int l = imports.length;
            while (i < l) {
                importRef = imports[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(importRef);
                if (level != null) {
                    this.patternLocator.matchReportImportRef(importRef, null, this.createImportHandle(importRef), level, this);
                }
                ++i;
            }
        }
        if ((types = unit.types) != null) {
            i = 0;
            int l = types.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration type = types[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(type);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(type, null, accuracy, nodeSet, 1);
                ++i;
            }
        }
    }

    protected void reportMatching(FieldDeclaration field, TypeDeclaration type, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        block10: {
            ASTNode[] nodes;
            IJavaElement enclosingElement = null;
            if (accuracy > -1) {
                enclosingElement = this.createHandle(field, type, parent);
                this.report(field.sourceStart, field.sourceEnd, enclosingElement, accuracy);
            }
            if ((field.bits & 2) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(field, type, parent);
                }
                LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
                try {
                    field.traverse((ASTVisitor)localDeclarationVisitor, null);
                }
                catch (WrappedCoreException e) {
                    throw e.coreException;
                }
            }
            if (!typeInHierarchy || (nodes = nodeSet.matchingNodes(field.declarationSourceStart, field.declarationSourceEnd)) == null) break block10;
            if ((this.matchContainer & 8) == 0) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(field, type, parent);
                }
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    this.patternLocator.matchReportReference(node, enclosingElement, level, this);
                    ++i;
                }
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, IJavaElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        TypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        Integer level;
        int i;
        ASTNode[] nodes;
        boolean matchedClassContainer;
        IJavaElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(new String(type.name));
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(new String(type.name));
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.isBinary() ? parent : member.getType(new String(type.name), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        if (accuracy > -1) {
            this.report(type.sourceStart, type.sourceEnd, enclosingElement, accuracy);
        }
        boolean bl = matchedClassContainer = (this.matchContainer & 2) != 0;
        if (type.javadoc != null && (nodes = nodeSet.matchingNodes(type.declarationSourceStart, type.sourceStart)) != null) {
            int l;
            int i2;
            if (!matchedClassContainer) {
                i2 = 0;
                l = nodes.length;
                while (i2 < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i2]);
                    ++i2;
                }
            } else {
                i2 = 0;
                l = nodes.length;
                while (i2 < l) {
                    ASTNode node = nodes[i2];
                    Integer level2 = (Integer)nodeSet.matchingNodes.removeKey(node);
                    this.patternLocator.matchReportReference(node, enclosingElement, level2, this);
                    ++i2;
                }
            }
        }
        if ((type.bits & 0x200) != 0) {
            Integer level3;
            TypeReference superType = type.allocation.type;
            if (superType != null && (level3 = (Integer)nodeSet.matchingNodes.removeKey(superType)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superType, enclosingElement, level3, this);
            }
        } else {
            TypeReference[] superInterfaces;
            Integer level4;
            TypeReference superClass = type.superclass;
            if (superClass != null && (level4 = (Integer)nodeSet.matchingNodes.removeKey(superClass)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superClass, enclosingElement, level4, this);
            }
            if ((superInterfaces = type.superInterfaces) != null) {
                i = 0;
                int l = superInterfaces.length;
                while (i < l) {
                    TypeReference superInterface = superInterfaces[i];
                    level = (Integer)nodeSet.matchingNodes.removeKey(superInterface);
                    if (level != null && matchedClassContainer) {
                        this.patternLocator.matchReportReference(superInterface, enclosingElement, level, this);
                    }
                    ++i;
                }
            }
        }
        boolean typeInHierarchy = type.binding == null || this.typeInHierarchy(type.binding);
        matchedClassContainer = matchedClassContainer && typeInHierarchy;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            i = 0;
            int l = fields.length;
            while (i < l) {
                FieldDeclaration field = fields[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(field);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(field, type, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i3 = 0;
            int l = methods.length;
            while (i3 < l) {
                AbstractMethodDeclaration method = methods[i3];
                Integer level5 = (Integer)nodeSet.matchingNodes.removeKey(method);
                int value = level5 != null && matchedClassContainer ? level5 : -1;
                this.reportMatching(method, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i3;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i4 = 0;
            int l = memberTypes.length;
            while (i4 < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration memberType = memberTypes[i4];
                Integer level6 = (Integer)nodeSet.matchingNodes.removeKey(memberType);
                int value = level6 != null && matchedClassContainer ? level6 : -1;
                this.reportMatching(memberType, enclosingElement, value, nodeSet, 1);
                ++i4;
            }
        }
    }

    protected boolean typeInHierarchy(ReferenceBinding binding) {
        if (this.hierarchyResolver == null) {
            return true;
        }
        if (this.hierarchyResolver.subOrSuperOfFocus(binding)) {
            return true;
        }
        if (this.allSuperTypeNames != null) {
            char[][] compoundName = binding.compoundName;
            int i = 0;
            int length = this.allSuperTypeNames.length;
            while (i < length) {
                if (CharOperation.equals(compoundName, this.allSuperTypeNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        IJavaElement enclosingElement;
        MatchingNodeSet nodeSet;
        HashMap occurrencesCounts = new HashMap();

        public LocalDeclarationVisitor(IJavaElement enclosingElement, MatchingNodeSet nodeSet) {
            this.enclosingElement = enclosingElement;
            this.nodeSet = nodeSet;
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope unused) {
            try {
                String simpleName = (typeDeclaration.bits & 0x200) != 0 ? "" : new String(typeDeclaration.name);
                Integer occurrenceCount = (Integer)this.occurrencesCounts.get(simpleName);
                occurrenceCount = occurrenceCount == null ? new Integer(1) : new Integer(occurrenceCount + 1);
                this.occurrencesCounts.put(simpleName, occurrenceCount);
                if ((typeDeclaration.bits & 0x200) != 0) {
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, -1, this.nodeSet, occurrenceCount);
                } else {
                    Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(typeDeclaration);
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, level != null ? level : -1, this.nodeSet, occurrenceCount);
                }
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
    }

    public class WrappedCoreException
    extends RuntimeException {
        public CoreException coreException;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }
}

