/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

public class LocalVariablePattern
extends VariablePattern {
    LocalVariable localVariable;

    public LocalVariablePattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, LocalVariable localVariable, int matchRule) {
        super(512, findDeclarations, readAccess, writeAccess, localVariable.getElementName().toCharArray(), matchRule);
        this.localVariable = localVariable;
    }

    public void decodeIndexKey(char[] key) {
    }

    public char[] encodeIndexKey() {
        return null;
    }

    public void findIndexMatches(IIndex index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        String path;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.localVariable.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.localVariable.getAncestor(7);
            String filePath = String.valueOf(type.getFullyQualifiedName('/').replace('.', '/')) + ".class";
            path = root.getPath() + "|" + filePath;
        } else {
            path = this.localVariable.getPath().toString();
        }
        if (scope.encloses(path) && !requestor.acceptIndexMatch(path, this, participant)) {
            throw new OperationCanceledException();
        }
    }

    public SearchPattern getIndexRecord() {
        return null;
    }

    public char[][] getMatchCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public boolean isMatchingIndexRecord() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "LocalVarCombinedPattern: " : "LocalVarDeclarationPattern: ");
        } else {
            buffer.append("LocalVarReferencePattern: ");
        }
        buffer.append(this.localVariable.toStringWithAncestors());
        buffer.append(", ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

