/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.search.matching.ClasspathSourceDirectory;

public class JavaSearchNameEnvironment
implements INameEnvironment,
SuffixConstants {
    ClasspathLocation[] locations;

    public JavaSearchNameEnvironment(IJavaProject javaProject) {
        this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject);
    }

    public void cleanup() {
        int i = 0;
        int length = this.locations.length;
        while (i < length) {
            this.locations[i].cleanup();
            ++i;
        }
    }

    private void computeClasspathLocations(IWorkspaceRoot workspaceRoot, JavaProject javaProject) {
        String encoding = null;
        IPackageFragmentRoot[] roots = null;
        try {
            roots = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            this.locations = new ClasspathLocation[0];
            return;
        }
        int length = roots.length;
        ClasspathLocation[] cpLocations = new ClasspathLocation[length];
        int index = 0;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            IPackageFragmentRoot root = roots[i];
            IPath path = root.getPath();
            try {
                if (root.isArchive()) {
                    ZipFile zipFile = manager.getZipFile(path);
                    cpLocations[index++] = new ClasspathJar(zipFile);
                } else {
                    Object target = JavaModel.getTarget(workspaceRoot, path, false);
                    if (root.getKind() == 1) {
                        if (encoding == null) {
                            encoding = javaProject.getOption("org.eclipse.jdt.core.encoding", true);
                        }
                        cpLocations[index++] = new ClasspathSourceDirectory((IContainer)target, encoding);
                    } else {
                        cpLocations[index++] = ClasspathLocation.forBinaryFolder((IContainer)target, false);
                    }
                }
            }
            catch (CoreException e1) {
                ClasspathLocation[] classpathLocationArray = cpLocations;
                cpLocations = new ClasspathLocation[cpLocations.length - 1];
                System.arraycopy(classpathLocationArray, 0, cpLocations, 0, index);
            }
            ++i;
        }
        this.locations = cpLocations;
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String binaryFileName = null;
        String qBinaryFileName = null;
        String sourceFileName = null;
        String qSourceFileName = null;
        String qPackageName = null;
        int i = 0;
        int length = this.locations.length;
        while (i < length) {
            NameEnvironmentAnswer answer;
            int typeNameStart;
            ClasspathLocation location = this.locations[i];
            if (location instanceof ClasspathSourceDirectory) {
                if (sourceFileName == null) {
                    sourceFileName = qSourceFileName = String.valueOf(qualifiedTypeName) + ".java";
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        typeNameStart = qSourceFileName.length() - typeName.length - 5;
                        qPackageName = qSourceFileName.substring(0, typeNameStart - 1);
                        sourceFileName = qSourceFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass(sourceFileName, qPackageName, qSourceFileName);
            } else {
                if (binaryFileName == null) {
                    binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        typeNameStart = qBinaryFileName.length() - typeName.length - 6;
                        qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
                        binaryFileName = qBinaryFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass(binaryFileName, qPackageName, qBinaryFileName);
            }
            if (answer != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith(compoundName, packageName, '/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        int i = 0;
        int length = this.locations.length;
        while (i < length) {
            if (this.locations[i].isPackage(qualifiedPackageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

