/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.IIndexer;
import org.eclipse.jdt.internal.core.index.IIndexerOutput;
import org.eclipse.jdt.internal.core.index.impl.Index;
import org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.jdt.internal.core.search.indexing.AddJarFileToIndex;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexAllProject;
import org.eclipse.jdt.internal.core.search.indexing.IndexBinaryFolder;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.jdt.internal.core.search.indexing.RemoveFromIndex;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public IWorkspace workspace;
    public SimpleLookupTable indexNames = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private Map monitors = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath javaPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getJavaPluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);
    static Hashtable indexerOutputs = new Hashtable();

    public synchronized void aboutToUpdateIndex(IPath path, Integer newIndexState) {
        Integer currentIndexState;
        String indexName = this.computeIndexName(path);
        Object state = this.getIndexStates().get(indexName);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexName, newIndexState);
        } else if (compare < 0 && this.indexes.get(path) == null) {
            this.rebuildIndex(indexName, path);
        }
    }

    public void addBinary(IFile resource, IPath indexedContainer) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        String indexPath = this.computeIndexName(indexedContainer);
        participant.scheduleDocumentIndexing(document, indexedContainer.toString(), indexPath);
    }

    public void addIndexEntry(char[] category, char[] key, SearchDocument document, String indexPath) {
        IIndexerOutput output = (IIndexerOutput)indexerOutputs.get(document);
        if (output == null) {
            return;
        }
        output.addRef(CharOperation.concat(category, key));
    }

    public void addSource(IFile resource, IPath indexedContainer) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        String indexPath = this.computeIndexName(indexedContainer);
        participant.scheduleDocumentIndexing(document, indexedContainer.toString(), indexPath);
    }

    String computeIndexName(IPath path) {
        String name = (String)this.indexNames.get(path);
        if (name == null) {
            String pathString = path.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> index name for " + pathString + " is " + fileName);
            }
            name = this.getJavaPluginWorkingLocation().append(fileName).toOSString();
            this.indexNames.put(path, name);
        }
        return name;
    }

    public synchronized IIndex getIndex(IPath path, boolean reuseExistingFile, boolean createIfMissing) {
        IIndex index = (IIndex)this.indexes.get(path);
        if (index == null) {
            Integer currentIndexState;
            String indexName = this.computeIndexName(path);
            Object state = this.getIndexStates().get(indexName);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexName, path);
                return null;
            }
            if (reuseExistingFile) {
                File indexFile = new File(indexName);
                if (indexFile.exists()) {
                    try {
                        index = new Index(indexName, "Index for " + path.toOSString(), true);
                        this.indexes.put(path, index);
                        this.monitors.put(index, new ReadWriteMonitor());
                        return index;
                    }
                    catch (IOException e) {
                        if (currentIndexState != REBUILDING_STATE) {
                            if (JobManager.VERBOSE) {
                                JobManager.verbose("-> cannot reuse existing index: " + indexName + " path: " + path.toOSString());
                            }
                            this.rebuildIndex(indexName, path);
                            return null;
                        }
                        index = null;
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexName, path);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("-> create empty index: " + indexName + " path: " + path.toOSString());
                    }
                    index = new Index(indexName, "Index for " + path.toOSString(), false);
                    this.indexes.put(path, index);
                    this.monitors.put(index, new ReadWriteMonitor());
                    return index;
                }
                catch (IOException e) {
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("-> unable to create empty index: " + indexName + " path: " + path.toOSString());
                    }
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized IIndex getIndexForUpdate(IPath path, boolean reuseExistingFile, boolean createIfMissing) {
        String indexName = this.computeIndexName(path);
        if (this.getIndexStates().get(indexName) == REBUILDING_STATE) {
            return this.getIndex(path, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        char[] savedIndexNames = this.readIndexState();
        if (savedIndexNames.length > 0) {
            char[][] names = CharOperation.splitOn('\n', savedIndexNames);
            int i = 0;
            int l = names.length;
            while (i < l) {
                char[] name = names[i];
                if (name.length > 0) {
                    this.indexStates.put(new String(name), SAVED_STATE);
                }
                ++i;
            }
        }
        return this.indexStates;
    }

    private IPath getJavaPluginWorkingLocation() {
        if (this.javaPluginLocation != null) {
            return this.javaPluginLocation;
        }
        this.javaPluginLocation = JavaCore.getPlugin().getStateLocation();
        return this.javaPluginLocation;
    }

    public ReadWriteMonitor getMonitorFor(IIndex index) {
        return (ReadWriteMonitor)this.monitors.get(index);
    }

    public void indexDocument(final SearchDocument searchDocument, final SearchParticipant searchParticipant, final IIndex index) throws IOException {
        index.add(searchDocument, new IIndexer(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void index(SearchDocument document, IIndexerOutput output) throws IOException {
                output.addDocument(document);
                String indexPath = index.getIndexFile().toString();
                try {
                    indexerOutputs.put(document, output);
                    searchParticipant.indexDocument(searchDocument, indexPath);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    indexerOutputs.remove(document);
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    indexerOutputs.remove(document);
                }
            }
        });
    }

    public void indexAll(IProject project) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject javaProject = model.getJavaProject(project);
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 1) {
                    this.indexLibrary(entry.getPath(), project);
                }
                ++i;
            }
        }
        catch (JavaModelException model) {
            // empty catch block
        }
        IndexAllProject request = new IndexAllProject(project, this);
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (((Object)request).equals(this.awaitingJobs[i])) {
                return;
            }
            --i;
        }
        this.request(request);
    }

    public void indexLibrary(IPath path, IProject requestingProject) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        Object target = JavaModel.getTarget(ResourcesPlugin.getWorkspace().getRoot(), path, true);
        IndexRequest request = null;
        if (target instanceof IFile) {
            request = new AddJarFileToIndex((IFile)target, this);
        } else if (target instanceof File) {
            request = new AddJarFileToIndex(path, this);
        } else if (target instanceof IFolder) {
            request = new IndexBinaryFolder((IFolder)target, this);
        } else {
            return;
        }
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request.equals(this.awaitingJobs[i])) {
                return;
            }
            --i;
        }
        this.request(request);
    }

    public void indexSourceFolder(JavaProject javaProject, IPath sourceFolder, char[][] exclusionPattern) {
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart) {
            IndexAllProject request = new IndexAllProject(project, this);
            int i = this.jobEnd;
            while (i > this.jobStart) {
                if (((Object)request).equals(this.awaitingJobs[i])) {
                    return;
                }
                --i;
            }
        }
        this.request(new AddFolderToIndex(sourceFolder, project, exclusionPattern, this));
    }

    public void jobWasCancelled(IPath path) {
        Object o = this.indexes.get(path);
        if (o instanceof IIndex) {
            this.monitors.remove(o);
            this.indexes.remove(path);
        }
        this.updateIndexState(this.computeIndexName(path), UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public IIndex peekAtIndex(IPath path) {
        return (IIndex)this.indexes.get(path);
    }

    public String processName() {
        return Util.bind("process.name");
    }

    private void rebuildIndex(String indexName, IPath path) {
        Object target = JavaModel.getTarget(ResourcesPlugin.getWorkspace().getRoot(), path, true);
        if (target == null) {
            return;
        }
        if (JobManager.VERBOSE) {
            JobManager.verbose("-> request to rebuild index: " + indexName + " path: " + path.toOSString());
        }
        this.updateIndexState(indexName, REBUILDING_STATE);
        IndexRequest request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (JavaProject.hasJavaNature(p)) {
                request = new IndexAllProject(p, this);
            }
        } else if (target instanceof IFolder) {
            request = new IndexBinaryFolder((IFolder)target, this);
        } else if (target instanceof IFile) {
            request = new AddJarFileToIndex((IFile)target, this);
        } else if (target instanceof File) {
            request = new AddJarFileToIndex(path, this);
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized IIndex recreateIndex(IPath path) {
        try {
            IIndex index = (IIndex)this.indexes.get(path);
            ReadWriteMonitor monitor = (ReadWriteMonitor)this.monitors.remove(index);
            String indexPath = this.computeIndexName(path);
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> recreating index: " + indexPath + " for path: " + path.toOSString());
            }
            index = new Index(indexPath, "Index for " + path.toOSString(), false);
            this.indexes.put(path, index);
            this.monitors.put(index, monitor);
            return index;
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> failed to recreate index for path: " + path.toOSString());
                e.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String resourceName, IPath indexedContainer) {
        this.request(new RemoveFromIndex(resourceName, indexedContainer, this));
    }

    public synchronized void removeIndex(IPath path) {
        Object o;
        String indexName;
        File indexFile;
        if (JobManager.VERBOSE) {
            JobManager.verbose("removing index " + path);
        }
        if ((indexFile = new File(indexName = this.computeIndexName(path))).exists()) {
            indexFile.delete();
        }
        if ((o = this.indexes.get(path)) instanceof IIndex) {
            this.monitors.remove(o);
        }
        this.indexes.remove(path);
        this.updateIndexState(indexName, null);
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        Iterator iterator = this.indexes.keySet().iterator();
        while (iterator.hasNext()) {
            IPath indexPath = (IPath)iterator.next();
            if (!path.isPrefixOf(indexPath)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<IPath>();
            }
            toRemove.add(indexPath);
        }
        if (toRemove != null) {
            int i = 0;
            int length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(JavaProject javaProject, IPath sourceFolder, char[][] exclusionPatterns) {
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart) {
            IndexAllProject request = new IndexAllProject(project, this);
            int i = this.jobEnd;
            while (i > this.jobStart) {
                if (((Object)request).equals(this.awaitingJobs[i])) {
                    return;
                }
                --i;
            }
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, exclusionPatterns, project, this));
    }

    public void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.monitors = new HashMap(5);
            this.indexStates = null;
        }
        this.indexNames = new SimpleLookupTable();
        this.javaPluginLocation = null;
    }

    public void saveIndex(IIndex index) throws IOException {
        Object indexPath;
        if (index.hasChanged()) {
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        String indexName = index.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (indexPath = this.indexNames.keyForValue(indexName)) != null) {
            int i = this.jobEnd;
            while (i > this.jobStart) {
                IJob job = this.awaitingJobs[i];
                if (job instanceof IndexRequest && ((IndexRequest)job).containerPath.equals(indexPath)) {
                    return;
                }
                --i;
            }
        }
        this.updateIndexState(indexName, SAVED_STATE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        ArrayList toSave = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Iterator iter = this.indexes.values().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof IIndex)) continue;
                toSave.add(o);
            }
        }
        int i = 0;
        int length = toSave.size();
        while (true) {
            if (i >= length) {
                this.needToSave = false;
                return;
            }
            IIndex index = (IIndex)toSave.get(i);
            ReadWriteMonitor monitor = this.getMonitorFor(index);
            if (monitor != null) {
                Object var7_9;
                try {
                    monitor.enterWrite();
                    try {
                        this.saveIndex(index);
                    }
                    catch (IOException e) {
                        if (JobManager.VERBOSE) {
                            JobManager.verbose("-> got the following exception while saving:");
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_9 = null;
                    monitor.exitWrite();
                    throw throwable;
                }
                {
                    var7_9 = null;
                    monitor.exitWrite();
                }
            }
            ++i;
        }
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, String containerPathString, String indexPath, final SearchParticipant searchParticipant) {
        Path myContainerPath = new Path(containerPathString);
        this.request(new IndexRequest(myContainerPath, this){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean execute(IProgressMonitor progressMonitor) {
                if (this.isCancelled) return true;
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                IIndex index = IndexManager.this.getIndex(this.containerPath, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor monitor = IndexManager.this.getMonitorFor(index);
                if (monitor == null) {
                    return true;
                }
                try {
                    try {
                        monitor.enterWrite();
                        IndexManager.this.indexDocument(searchDocument, searchParticipant, index);
                    }
                    catch (IOException e) {
                        if (JobManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + searchDocument.getPath() + " because of the following exception:");
                            e.printStackTrace();
                        }
                        Object var5_5 = null;
                        monitor.exitWrite();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.exitWrite();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    monitor.exitWrite();
                    return true;
                }
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }
        });
    }

    public void shutdown() {
        File[] indexesFiles;
        File indexesDirectory;
        if (JobManager.VERBOSE) {
            JobManager.verbose("Shutdown");
        }
        SimpleLookupTable knownPaths = new SimpleLookupTable();
        SearchParticipant[] participants = SearchEngine.getSearchParticipants();
        JavaWorkspaceScope scope = new JavaWorkspaceScope();
        int i = 0;
        int length = participants.length;
        while (i < length) {
            SearchParticipant participant = participants[i];
            TypeDeclarationPattern pattern = new TypeDeclarationPattern(null, null, null, ' ', 2);
            PatternSearchJob job = new PatternSearchJob(pattern, participant, scope, null);
            IIndex[] selectedIndexes = job.getIndexes(null);
            int j = 0;
            int max = selectedIndexes.length;
            while (j < max) {
                String path = selectedIndexes[j].getIndexFile().getAbsolutePath();
                knownPaths.put(path, path);
                ++j;
            }
            ++i;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            int i2 = 0;
            int l = keys.length;
            while (i2 < l) {
                String key = (String)keys[i2];
                if (key != null && !knownPaths.containsKey(key)) {
                    this.updateIndexState(key, null);
                }
                ++i2;
            }
        }
        if ((indexesDirectory = new File(this.getJavaPluginWorkingLocation().toOSString())).isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i3 = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i3 < indexesFilesLength) {
                String fileName = indexesFiles[i3].getAbsolutePath();
                if (!knownPaths.containsKey(fileName) && fileName.toLowerCase().endsWith(".index")) {
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("Deleting index file " + indexesFiles[i3]);
                    }
                    indexesFiles[i3].delete();
                }
                ++i3;
            }
        }
        super.shutdown();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Iterator iter = this.indexes.values().iterator();
        while (iter.hasNext()) {
            buffer.append(++count).append(" - ").append(iter.next().toString()).append('\n');
        }
        return buffer.toString();
    }

    private char[] readIndexState() {
        try {
            return org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException ignored) {
            if (JobManager.VERBOSE) {
                JobManager.verbose("Failed to read saved index file names");
            }
            return new char[0];
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateIndexState(String indexName, Integer indexState) {
        block22: {
            this.getIndexStates();
            if (indexState != null) {
                if (indexState.equals(this.indexStates.get(indexName))) {
                    return;
                }
                this.indexStates.put(indexName, indexState);
            } else {
                if (!this.indexStates.containsKey(indexName)) {
                    return;
                }
                this.indexStates.removeKey(indexName);
            }
            writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    keys = this.indexStates.keyTable;
                    states = this.indexStates.valueTable;
                    i = 0;
                    l = states.length;
                    while (i < l) {
                        if (states[i] == IndexManager.SAVED_STATE) {
                            writer.write((String)keys[i]);
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException ignored) {
                    if (JobManager.VERBOSE) {
                        JobManager.verbose("Failed to write saved index file names");
                    }
                }
            }
            catch (Throwable var9_9) {
                var8_10 = null;
                if (writer == null) throw var9_9;
                try {
                    writer.close();
                    throw var9_9;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var9_9;
            }
            {
                var8_11 = null;
                if (writer == null) break block22;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 182->189)] { 
lbl45:
            // 1 sources

            writer.close();
            break block22;
lbl47:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        if (JobManager.VERBOSE == false) return;
        state = "?";
        if (indexState == IndexManager.SAVED_STATE) {
            state = "SAVED";
        } else if (indexState == IndexManager.UPDATING_STATE) {
            state = "UPDATING";
        } else if (indexState == IndexManager.UNKNOWN_STATE) {
            state = "UNKNOWN";
        } else if (indexState == IndexManager.REBUILDING_STATE) {
            state = "REBUILDING";
        }
        JobManager.verbose("-> index state updated to: " + state + " for: " + indexName);
    }
}

