/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;
import org.eclipse.jdt.internal.core.util.Util;

public class SourceMapper
extends ReferenceInfoAdapter
implements ISourceElementRequestor,
SuffixConstants {
    public static boolean VERBOSE = false;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".JAVA") || name.endsWith(".java");
        }
    };
    protected HashSet rootPaths;
    protected BinaryType fType;
    protected IPath sourcePath;
    protected String rootPath;
    protected static String[] fgEmptyStringArray = new String[0];
    protected HashMap fParameterNames;
    protected HashMap fSourceRanges;
    protected static SourceRange fgUnknownRange = new SourceRange(-1, 0);
    protected int[] fMemberDeclarationStart;
    protected SourceRange[] fMemberNameRange;
    protected String[] fMemberName;
    protected char[][][] fMethodParameterNames;
    protected char[][][] fMethodParameterTypes;
    protected IJavaElement searchedElement;
    private HashMap importsTable;
    private HashMap importsCounterTable;
    IType[] types;
    int[] typeDeclarationStarts;
    SourceRange[] typeNameRanges;
    int typeDepth;
    int anonymousCounter;
    int anonymousClassName;
    String encoding;
    Map options;
    private boolean areRootPathsComputed = false;

    public SourceMapper() {
    }

    public SourceMapper(IPath sourcePath, String rootPath, Map options) {
        this.options = options;
        this.encoding = (String)options.get("org.eclipse.jdt.core.encoding");
        if (rootPath != null) {
            this.rootPaths = new HashSet();
            this.rootPaths.add(rootPath);
        }
        this.sourcePath = sourcePath;
        this.fSourceRanges = new HashMap();
        this.fParameterNames = new HashMap();
        this.importsTable = new HashMap();
        this.importsCounterTable = new HashMap();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        int importsCounter;
        char[][] imports = (char[][])this.importsTable.get(this.fType);
        if (imports == null) {
            imports = new char[5][];
            importsCounter = 0;
        } else {
            importsCounter = (Integer)this.importsCounterTable.get(this.fType);
        }
        if (imports.length == importsCounter) {
            char[][] cArray = imports;
            imports = new char[importsCounter * 2][];
            System.arraycopy(cArray, 0, imports, 0, importsCounter);
        }
        if (onDemand) {
            int nameLength = name.length;
            char[] cArray = name;
            name = new char[nameLength + 2];
            System.arraycopy(cArray, 0, name, 0, nameLength);
            name[nameLength] = 46;
            name[nameLength + 1] = 42;
        }
        imports[importsCounter++] = name;
        this.importsTable.put(this.fType, imports);
        this.importsCounterTable.put(this.fType, new Integer(importsCounter));
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    public void acceptProblem(IProblem problem) {
    }

    public void close() {
        this.fSourceRanges = null;
        this.fParameterNames = null;
    }

    private String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            String typeSig = Signature.createTypeSignature(typeNames[i], false);
            int lastIndex = typeSig.lastIndexOf(46);
            if (lastIndex == -1) {
                typeSigs[i] = typeSig;
            } else {
                int arrayEnd = 0;
                while (typeSig.charAt(arrayEnd) == '[') {
                    ++arrayEnd;
                }
                typeSigs[i] = String.valueOf(typeSig.substring(0, arrayEnd)) + 'Q' + typeSig.substring(lastIndex + 1, typeSig.length());
            }
            ++i;
        }
        return typeSigs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void computeAllRootPaths(IType type) {
        long time;
        block38: {
            File file;
            Object target;
            boolean containsADefaultPackage;
            HashSet<String> firstLevelPackageNames;
            block40: {
                Object var15_25;
                block37: {
                    IPackageFragmentRoot root;
                    block39: {
                        root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
                        if (this.rootPaths == null) {
                            this.rootPaths = new HashSet();
                        }
                        time = 0L;
                        if (VERBOSE) {
                            System.out.println("compute all root paths for " + root.getElementName());
                            time = System.currentTimeMillis();
                        }
                        firstLevelPackageNames = new HashSet<String>();
                        containsADefaultPackage = false;
                        if (!root.isArchive()) break block39;
                        JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
                        JavaModelManager manager = JavaModelManager.getJavaModelManager();
                        ZipFile zip = null;
                        try {
                            try {
                                zip = manager.getZipFile(jarPackageFragmentRoot.getPath());
                                Enumeration<? extends ZipEntry> entries = zip.entries();
                                while (entries.hasMoreElements()) {
                                    ZipEntry entry = entries.nextElement();
                                    String entryName = entry.getName();
                                    if (entry.isDirectory()) continue;
                                    int index = entryName.indexOf(47);
                                    if (index != -1 && org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
                                        String firstLevelPackageName = entryName.substring(0, index);
                                        IStatus status = JavaConventions.validatePackageName(firstLevelPackageName);
                                        if (!status.isOK() && status.getSeverity() != 2) continue;
                                        firstLevelPackageNames.add(firstLevelPackageName);
                                        continue;
                                    }
                                    if (!org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) continue;
                                    containsADefaultPackage = true;
                                }
                            }
                            catch (CoreException entries) {}
                        }
                        catch (Throwable throwable) {
                            Object var16_27 = null;
                            manager.closeZipFile(zip);
                            throw throwable;
                        }
                        {
                            Object var16_28 = null;
                            manager.closeZipFile(zip);
                            break block37;
                        }
                    }
                    target = JavaModel.getTarget(ResourcesPlugin.getWorkspace().getRoot(), root.getPath(), true);
                    if (target instanceof IFolder) {
                        IResource resource = root.getResource();
                        if (resource.getType() == 2) {
                            try {
                                IResource[] members = ((IFolder)resource).members();
                                int i = 0;
                                int max = members.length;
                                while (i < max) {
                                    IResource member = members[i];
                                    if (member.getType() == 2) {
                                        firstLevelPackageNames.add(member.getName());
                                    } else if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(member.getName())) {
                                        containsADefaultPackage = true;
                                    }
                                    ++i;
                                }
                            }
                            catch (CoreException e) {}
                        }
                    } else if (target instanceof File && (file = (File)target).isDirectory()) {
                        File[] files = file.listFiles();
                        int i = 0;
                        int max = files.length;
                        while (i < max) {
                            File currentFile = files[i];
                            if (currentFile.isDirectory()) {
                                firstLevelPackageNames.add(currentFile.getName());
                            } else if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(currentFile.getName())) {
                                containsADefaultPackage = true;
                            }
                            ++i;
                        }
                    }
                }
                if (!org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block40;
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                ZipFile zip = null;
                try {
                    try {
                        zip = manager.getZipFile(this.sourcePath);
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        block15: while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory()) continue;
                            Path path = new Path(entry.getName());
                            int segmentCount = path.segmentCount();
                            if (segmentCount > 1) {
                                int i = 0;
                                int max = path.segmentCount() - 1;
                                while (i < max) {
                                    if (firstLevelPackageNames.contains(path.segment(i))) {
                                        this.rootPaths.add(path.uptoSegment(i).toString());
                                        continue block15;
                                    }
                                    if (i == max - 1 && containsADefaultPackage) {
                                        this.rootPaths.add(path.uptoSegment(max).toString());
                                    }
                                    ++i;
                                }
                                continue;
                            }
                            if (!containsADefaultPackage) continue;
                            this.rootPaths.add("");
                        }
                    }
                    catch (CoreException coreException) {}
                }
                catch (Throwable throwable) {
                    var15_25 = null;
                    manager.closeZipFile(zip);
                    throw throwable;
                }
                {
                    var15_25 = null;
                    manager.closeZipFile(zip);
                    break block38;
                }
            }
            target = JavaModel.getTarget(ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
            if (target instanceof IFolder) {
                this.computeRootPath((IFolder)target, firstLevelPackageNames, containsADefaultPackage);
            } else if (target instanceof File && (file = (File)target).isDirectory()) {
                this.computeRootPath(file, firstLevelPackageNames, containsADefaultPackage);
            }
        }
        if (VERBOSE) {
            System.out.println("Found " + this.rootPaths.size() + " root paths");
            System.out.println("Spent " + (System.currentTimeMillis() - time) + "ms");
        }
        this.areRootPathsComputed = true;
    }

    private void computeRootPath(File directory, HashSet firstLevelPackageNames, boolean hasDefaultPackage) {
        File[] files = directory.listFiles();
        boolean hasSubDirectories = false;
        int i = 0;
        int max = files.length;
        while (i < max) {
            File parentDir;
            File file = files[i];
            if (file.isDirectory()) {
                hasSubDirectories = true;
                if (firstLevelPackageNames.contains(file.getName())) {
                    Path fullPath = new Path(file.getParentFile().getPath());
                    IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                    this.rootPaths.add(rootPathEntry.toString());
                    break;
                }
                this.computeRootPath(file, firstLevelPackageNames, hasDefaultPackage);
            } else if (i == max - 1 && !hasSubDirectories && hasDefaultPackage && (parentDir = file.getParentFile()).list(FILENAME_FILTER).length != 0) {
                Path fullPath = new Path(parentDir.getPath());
                IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                this.rootPaths.add(rootPathEntry.toString());
            }
            ++i;
        }
    }

    private void computeRootPath(IFolder directory, HashSet firstLevelPackageNames, boolean hasDefaultPackage) {
        try {
            IResource[] resources = directory.members();
            boolean hasSubDirectories = false;
            int i = 0;
            int max = resources.length;
            while (i < max) {
                IResource resource = resources[i];
                if (resource.getType() == 2) {
                    hasSubDirectories = true;
                    if (firstLevelPackageNames.contains(resource.getName())) {
                        IPath fullPath = resource.getParent().getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        this.rootPaths.add(rootPathEntry.toString());
                        break;
                    }
                    this.computeRootPath((IFolder)resource, firstLevelPackageNames, hasDefaultPackage);
                }
                if (i == max - 1 && !hasSubDirectories && hasDefaultPackage) {
                    IContainer container = resource.getParent();
                    IResource[] members = container.members();
                    boolean hasJavaSourceFile = false;
                    int j = 0;
                    int max2 = members.length;
                    while (j < max2) {
                        if (org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(members[i].getName())) {
                            hasJavaSourceFile = true;
                            break;
                        }
                        ++j;
                    }
                    if (hasJavaSourceFile) {
                        IPath fullPath = container.getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        this.rootPaths.add(rootPathEntry.toString());
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        ++this.typeDepth;
        if (this.typeDepth == this.types.length) {
            this.types = new IType[this.typeDepth * 2];
            System.arraycopy(this.types, 0, this.types, 0, this.typeDepth);
            this.typeNameRanges = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.typeNameRanges, 0, this.typeNameRanges, 0, this.typeDepth);
            this.typeDeclarationStarts = new int[this.typeDepth * 2];
            System.arraycopy(this.typeDeclarationStarts, 0, this.typeDeclarationStarts, 0, this.typeDepth);
            this.fMemberName = new String[this.typeDepth * 2];
            System.arraycopy(this.fMemberName, 0, this.fMemberName, 0, this.typeDepth);
            this.fMemberDeclarationStart = new int[this.typeDepth * 2];
            System.arraycopy(this.fMemberDeclarationStart, 0, this.fMemberDeclarationStart, 0, this.typeDepth);
            this.fMemberNameRange = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.fMemberNameRange, 0, this.fMemberNameRange, 0, this.typeDepth);
            this.fMethodParameterTypes = new char[this.typeDepth * 2][][];
            System.arraycopy(this.fMethodParameterTypes, 0, this.fMethodParameterTypes, 0, this.typeDepth);
            this.fMethodParameterNames = new char[this.typeDepth * 2][][];
            System.arraycopy(this.fMethodParameterNames, 0, this.fMethodParameterNames, 0, this.typeDepth);
        }
        if (name.length == 0) {
            ++this.anonymousCounter;
            this.types[this.typeDepth] = this.anonymousCounter == this.anonymousClassName ? this.getType(this.fType.getElementName()) : this.getType(new String(name));
        } else {
            this.types[this.typeDepth] = this.getType(new String(name));
        }
        this.typeNameRanges[this.typeDepth] = new SourceRange(nameSourceStart, nameSourceEnd - nameSourceStart + 1);
        this.typeDeclarationStarts[this.typeDepth] = declarationStart;
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, null, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes);
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        if (this.typeDepth >= 0) {
            this.fMemberDeclarationStart[this.typeDepth] = declarationStart;
            this.fMemberNameRange[this.typeDepth] = new SourceRange(nameSourceStart, nameSourceEnd - nameSourceStart + 1);
            this.fMemberName[this.typeDepth] = new String(name);
        }
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        this.enterClass(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, null, superinterfaces);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        if (this.typeDepth >= 0) {
            this.fMemberName[this.typeDepth] = new String(name);
            this.fMemberNameRange[this.typeDepth] = new SourceRange(nameSourceStart, nameSourceEnd - nameSourceStart + 1);
            this.fMemberDeclarationStart[this.typeDepth] = declarationStart;
            this.fMethodParameterTypes[this.typeDepth] = parameterTypes;
            this.fMethodParameterNames[this.typeDepth] = parameterNames;
        }
    }

    public void exitClass(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType, new SourceRange(this.typeDeclarationStarts[this.typeDepth], declarationEnd - this.typeDeclarationStarts[this.typeDepth] + 1), this.typeNameRanges[this.typeDepth]);
            --this.typeDepth;
        }
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMethod(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType.getField(this.fMemberName[this.typeDepth]), new SourceRange(this.fMemberDeclarationStart[this.typeDepth], declarationEnd - this.fMemberDeclarationStart[this.typeDepth] + 1), this.fMemberNameRange[this.typeDepth]);
        }
    }

    public void exitInitializer(int declarationEnd) {
    }

    public void exitInterface(int declarationEnd) {
        this.exitClass(declarationEnd);
    }

    public void exitMethod(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            SourceRange sourceRange = new SourceRange(this.fMemberDeclarationStart[this.typeDepth], declarationEnd - this.fMemberDeclarationStart[this.typeDepth] + 1);
            IMethod method = currentType.getMethod(this.fMemberName[this.typeDepth], this.convertTypeNamesToSigs(this.fMethodParameterTypes[this.typeDepth]));
            this.setSourceRange(method, sourceRange, this.fMemberNameRange[this.typeDepth]);
            this.setMethodParameterNames(method, this.fMethodParameterNames[this.typeDepth]);
        }
    }

    public char[] findSource(IType type) {
        if (!type.isBinary()) {
            return null;
        }
        BinaryType parent = (BinaryType)type.getDeclaringType();
        BinaryType declType = (BinaryType)type;
        while (parent != null) {
            declType = parent;
            parent = (BinaryType)declType.getDeclaringType();
        }
        IBinaryType info = null;
        try {
            info = (IBinaryType)declType.getElementInfo();
        }
        catch (JavaModelException e) {
            return null;
        }
        String simpleSourceFileName = this.findSourceFileName(type, info);
        if (simpleSourceFileName == null) {
            return null;
        }
        return this.findSource(type, simpleSourceFileName);
    }

    public char[] findSource(IType type, String simpleSourceFileName) {
        long time = 0L;
        if (VERBOSE) {
            time = System.currentTimeMillis();
        }
        String name = simpleSourceFileName;
        IPackageFragment pkgFrag = type.getPackageFragment();
        if (!pkgFrag.isDefaultPackage()) {
            String pkg = pkgFrag.getElementName().replace('.', '/');
            name = String.valueOf(pkg) + '/' + name;
        }
        char[] source = null;
        if (!this.areRootPathsComputed) {
            this.computeAllRootPaths(type);
        }
        if (this.rootPath != null) {
            source = this.getSourceForRootPath(this.rootPath, name);
        }
        if (source == null && this.rootPaths != null) {
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext()) {
                String currentRootPath = (String)iterator.next();
                if (currentRootPath.equals(this.rootPath) || (source = this.getSourceForRootPath(currentRootPath, name)) == null) continue;
                this.rootPath = currentRootPath;
                break;
            }
        }
        if (VERBOSE) {
            System.out.println("spent " + (System.currentTimeMillis() - time) + "ms for " + type.getElementName());
        }
        return source;
    }

    /*
     * Unable to fully structure code
     */
    public String findSourceFileName(IType type, IBinaryType info) {
        block6: {
            block4: {
                sourceFileName = info.sourceFileName();
                if (sourceFileName != null) break block4;
                try {
                    block5: {
                        if (!type.isMember()) break block5;
                        enclosingType = type.getDeclaringType();
                        if (enclosingType != null) ** GOTO lbl9
                        return null;
lbl-1000:
                        // 1 sources

                        {
                            enclosingType = enclosingType.getDeclaringType();
lbl9:
                            // 2 sources

                            ** while (enclosingType.getDeclaringType() != null)
                        }
lbl10:
                        // 1 sources

                        return String.valueOf(enclosingType.getElementName()) + ".java";
                    }
                    if (type.isLocal() || type.isAnonymous()) {
                        typeQualifiedName = type.getTypeQualifiedName();
                        return String.valueOf(typeQualifiedName.substring(0, typeQualifiedName.indexOf(36))) + ".java";
                    }
                    return String.valueOf(type.getElementName()) + ".java";
                }
                catch (JavaModelException e) {}
                break block6;
            }
            return new String(sourceFileName);
        }
        return null;
    }

    private char[] getSourceForRootPath(String currentRootPath, String name) {
        String newFullName = !currentRootPath.equals("") ? (currentRootPath.endsWith("/") ? String.valueOf(currentRootPath) + name : String.valueOf(currentRootPath) + '/' + name) : name;
        return this.findSource(newFullName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] findSource(String fullName) {
        char[] source;
        block11: {
            source = null;
            if (!org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) break block11;
            ZipEntry entry = null;
            ZipFile zip = null;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            try {
                try {
                    zip = manager.getZipFile(this.sourcePath);
                    entry = zip.getEntry(fullName);
                    if (entry != null) {
                        source = this.readSource(entry, zip);
                    }
                }
                catch (CoreException e) {
                    char[] cArray = null;
                    Object var7_15 = null;
                    manager.closeZipFile(zip);
                    return cArray;
                }
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                manager.closeZipFile(zip);
                throw throwable;
            }
            {
                Object var7_17 = null;
                manager.closeZipFile(zip);
                return source;
            }
        }
        Object target = JavaModel.getTarget(ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
        if (target instanceof IFolder) {
            IFolder folder = (IFolder)target;
            IResource res = folder.findMember(fullName);
            if (!(res instanceof IFile)) return source;
            try {
                return Util.getResourceContentsAsCharArray((IFile)res, this.encoding);
            }
            catch (JavaModelException e) {
                return source;
            }
        }
        if (!(target instanceof File)) return source;
        File file = (File)target;
        if (!file.isDirectory()) return source;
        File sourceFile = new File(file, fullName);
        try {
            return org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(sourceFile, this.encoding);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return source;
    }

    public SourceRange getNameRange(IJavaElement element) {
        SourceRange[] ranges;
        if (element.getElementType() == 9 && ((IMember)element).isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle((IMethod)element, false);
            element = el[1] != null && this.fSourceRanges.get(el[0]) == null ? this.getUnqualifiedMethodHandle((IMethod)element, true)[0] : el[0];
        }
        if ((ranges = (SourceRange[])this.fSourceRanges.get(element)) == null) {
            return fgUnknownRange;
        }
        return ranges[1];
    }

    public char[][] getMethodParameterNames(IMethod method) {
        char[][] parameterNames;
        if (method.isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle(method, false);
            method = el[1] != null && this.fParameterNames.get(el[0]) == null ? (IMethod)this.getUnqualifiedMethodHandle(method, true)[0] : (IMethod)el[0];
        }
        if ((parameterNames = (char[][])this.fParameterNames.get(method)) == null) {
            return null;
        }
        return parameterNames;
    }

    public SourceRange getSourceRange(IJavaElement element) {
        SourceRange[] ranges;
        if (element.getElementType() == 9 && ((IMember)element).isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle((IMethod)element, false);
            element = el[1] != null && this.fSourceRanges.get(el[0]) == null ? this.getUnqualifiedMethodHandle((IMethod)element, true)[0] : el[0];
        }
        if ((ranges = (SourceRange[])this.fSourceRanges.get(element)) == null) {
            return fgUnknownRange;
        }
        return ranges[0];
    }

    protected IType getType(String typeName) {
        if (this.fType.getElementName().equals(typeName)) {
            return this.fType;
        }
        return this.fType.getType(typeName);
    }

    protected IJavaElement[] getUnqualifiedMethodHandle(IMethod method, boolean noDollar) {
        boolean hasDollar = false;
        String[] qualifiedParameterTypes = method.getParameterTypes();
        String[] unqualifiedParameterTypes = new String[qualifiedParameterTypes.length];
        int i = 0;
        while (i < qualifiedParameterTypes.length) {
            StringBuffer unqualifiedName = new StringBuffer();
            String qualifiedName = qualifiedParameterTypes[i];
            int count = 0;
            while (qualifiedName.charAt(count) == '[') {
                unqualifiedName.append('[');
                ++count;
            }
            if (qualifiedName.charAt(count) == 'L') {
                unqualifiedName.append('Q');
                String simpleName = Signature.getSimpleName(qualifiedName.substring(count + 1));
                if (!noDollar) {
                    if (!hasDollar && simpleName.indexOf(36) != -1) {
                        hasDollar = true;
                    }
                    unqualifiedName.append(simpleName);
                } else {
                    unqualifiedName.append(CharOperation.lastSegment(simpleName.toCharArray(), '$'));
                }
            } else {
                unqualifiedName.append(qualifiedName.substring(count, qualifiedName.length()));
            }
            unqualifiedParameterTypes[i] = unqualifiedName.toString();
            ++i;
        }
        IJavaElement[] result = new IJavaElement[2];
        result[0] = ((IType)method.getParent()).getMethod(method.getElementName(), unqualifiedParameterTypes);
        if (hasDollar) {
            result[1] = result[0];
        }
        return result;
    }

    public void mapSource(IType type, char[] contents) {
        this.mapSource(type, contents, null);
    }

    public synchronized ISourceRange mapSource(IType type, char[] contents, IJavaElement elementToFind) {
        HashMap oldSourceRanges;
        block12: {
            this.fType = (BinaryType)type;
            if (this.fSourceRanges.get(type) != null) {
                return elementToFind != null ? this.getNameRange(elementToFind) : null;
            }
            this.importsTable.remove(this.fType);
            this.importsCounterTable.remove(this.fType);
            this.searchedElement = elementToFind;
            this.types = new IType[1];
            this.typeDeclarationStarts = new int[1];
            this.typeNameRanges = new SourceRange[1];
            this.typeDepth = -1;
            this.fMemberDeclarationStart = new int[1];
            this.fMemberName = new String[1];
            this.fMemberNameRange = new SourceRange[1];
            this.fMethodParameterTypes = new char[1][][];
            this.fMethodParameterNames = new char[1][][];
            this.anonymousCounter = 0;
            oldSourceRanges = (HashMap)this.fSourceRanges.clone();
            try {
                SourceRange range;
                DefaultProblemFactory factory = new DefaultProblemFactory();
                SourceElementParser parser = null;
                boolean isAnonymousClass = false;
                char[] fullName = null;
                this.anonymousClassName = 0;
                try {
                    IBinaryType binType = (IBinaryType)this.fType.getElementInfo();
                    isAnonymousClass = binType.isAnonymous();
                    fullName = binType.getName();
                }
                catch (JavaModelException binType) {
                    // empty catch block
                }
                if (isAnonymousClass) {
                    String eltName = this.fType.getElementName();
                    eltName = eltName.substring(eltName.lastIndexOf(36) + 1, eltName.length());
                    try {
                        this.anonymousClassName = Integer.parseInt(eltName);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                boolean doFullParse = this.hasToRetrieveSourceRangesForLocalClass(fullName);
                parser = new SourceElementParser(this, factory, new CompilerOptions(this.options), doFullParse);
                parser.parseCompilationUnit(new BasicCompilationUnit(contents, null, String.valueOf(type.getElementName()) + ".java", this.encoding), doFullParse);
                if (elementToFind == null) break block12;
                SourceRange sourceRange = range = this.getNameRange(elementToFind);
                Object var11_16 = null;
                if (elementToFind != null) {
                    this.fSourceRanges = oldSourceRanges;
                }
                this.fType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                return sourceRange;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                if (elementToFind != null) {
                    this.fSourceRanges = oldSourceRanges;
                }
                this.fType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                throw throwable;
            }
        }
        ISourceRange iSourceRange = null;
        Object var11_17 = null;
        if (elementToFind != null) {
            this.fSourceRanges = oldSourceRanges;
        }
        this.fType = null;
        this.searchedElement = null;
        this.types = null;
        this.typeDeclarationStarts = null;
        this.typeNameRanges = null;
        this.typeDepth = -1;
        return iSourceRange;
    }

    private char[] readSource(ZipEntry entry, ZipFile zip) {
        try {
            byte[] bytes = org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(entry, zip);
            if (bytes != null) {
                return org.eclipse.jdt.internal.compiler.util.Util.bytesToChar(bytes, this.encoding);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void setMethodParameterNames(IMethod method, char[][] parameterNames) {
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        this.fParameterNames.put(method, parameterNames);
    }

    protected void setSourceRange(IJavaElement element, SourceRange sourceRange, SourceRange nameRange) {
        this.fSourceRanges.put(element, new SourceRange[]{sourceRange, nameRange});
    }

    public char[][] getImports(BinaryType type) {
        char[][] imports = (char[][])this.importsTable.get(type);
        if (imports != null) {
            int importsCounter = (Integer)this.importsCounterTable.get(type);
            if (imports.length != importsCounter) {
                char[][] cArray = imports;
                imports = new char[importsCounter][];
                System.arraycopy(cArray, 0, imports, 0, importsCounter);
            }
            this.importsTable.put(type, imports);
        }
        return imports;
    }

    private boolean hasToRetrieveSourceRangesForLocalClass(char[] eltName) {
        if (eltName == null) {
            return false;
        }
        int index = 0;
        int dollarIndex = CharOperation.indexOf('$', eltName, index);
        if (dollarIndex != -1) {
            index = dollarIndex + 1;
            if ((dollarIndex = CharOperation.indexOf('$', eltName, index)) == -1) {
                dollarIndex = eltName.length;
            }
            if (dollarIndex != -1) {
                int i = index;
                while (i < dollarIndex) {
                    if (!Character.isDigit(eltName[i])) {
                        index = dollarIndex + 1;
                        i = dollarIndex;
                        if (index > eltName.length) {
                            return false;
                        }
                        dollarIndex = CharOperation.indexOf('$', eltName, index);
                        if (dollarIndex == -1) {
                            dollarIndex = eltName.length;
                        }
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

