/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class IfStatement
extends Statement {
    private Expression expression = null;
    private Statement thenStatement = null;
    private Statement optionalElseStatement = null;

    IfStatement(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 25;
    }

    ASTNode clone(AST target) {
        IfStatement result = new IfStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)this.getExpression().clone(target));
        result.setThenStatement((Statement)this.getThenStatement().clone(target));
        result.setElseStatement((Statement)ASTNode.copySubtree(target, this.getElseStatement()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getThenStatement());
            this.acceptChild(visitor, this.getElseStatement());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        if (this.expression == null) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.expression, expression, true);
        this.expression = expression;
    }

    public Statement getThenStatement() {
        if (this.thenStatement == null) {
            long count = this.getAST().modificationCount();
            this.setThenStatement(new Block(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.thenStatement;
    }

    public void setThenStatement(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.thenStatement, statement, true);
        this.thenStatement = statement;
    }

    public Statement getElseStatement() {
        return this.optionalElseStatement;
    }

    public void setElseStatement(Statement statement) {
        this.replaceChild(this.optionalElseStatement, statement, true);
        this.optionalElseStatement = statement;
    }

    int memSize() {
        return super.memSize() + 12;
    }

    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.thenStatement == null ? 0 : this.getThenStatement().treeSize()) + (this.optionalElseStatement == null ? 0 : this.getElseStatement().treeSize());
    }
}

