/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Map;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class Marker
extends PlatformObject
implements IMarker {
    protected long id;
    protected IResource resource;

    Marker(IResource resource, long id) {
        Assert.isLegal(resource != null);
        this.resource = resource;
        this.id = id;
    }

    private void checkInfo(MarkerInfo info) throws CoreException {
        if (info == null) {
            String message = Policy.bind("resources.markerNotFound", Long.toString(this.id));
            throw new ResourceException(new ResourceStatus(376, this.resource.getFullPath(), message));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete() throws CoreException {
        try {
            this.getWorkspace().prepareOperation(null, null);
            this.getWorkspace().beginOperation(true);
            this.getWorkspace().getMarkerManager().removeMarker(this.getResource(), this.getId());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.getWorkspace().endOperation(null, false, null);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.getWorkspace().endOperation(null, false, null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IMarker)) {
            return false;
        }
        IMarker other = (IMarker)object;
        return this.id == other.getId() && this.resource.equals(other.getResource());
    }

    public boolean exists() {
        return this.getInfo() != null;
    }

    public Object getAttribute(String attributeName) throws CoreException {
        Assert.isNotNull(attributeName);
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getAttribute(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Assert.isNotNull(attributeName);
        MarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        Assert.isNotNull(attributeName);
        MarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Assert.isNotNull(attributeName);
        MarkerInfo info = this.getInfo();
        if (info == null) {
            return defaultValue;
        }
        Object value = info.getAttribute(attributeName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public Map getAttributes() throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getAttributes();
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        Assert.isNotNull(attributeNames);
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getAttributes(attributeNames);
    }

    public long getCreationTime() throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getCreationTime();
    }

    public long getId() {
        return this.id;
    }

    protected MarkerInfo getInfo() {
        return this.getWorkspace().getMarkerManager().findMarkerInfo(this.resource, this.id);
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getType() throws CoreException {
        MarkerInfo info = this.getInfo();
        this.checkInfo(info);
        return info.getType();
    }

    private Workspace getWorkspace() {
        return this.resource == null ? null : (Workspace)this.resource.getWorkspace();
    }

    public int hashCode() {
        return (int)this.id + this.resource.hashCode();
    }

    public boolean isSubtypeOf(String type) throws CoreException {
        return this.getWorkspace().getMarkerManager().isSubtype(this.getType(), type);
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        this.setAttribute(attributeName, new Integer(value));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttribute(String attributeName, Object value) throws CoreException {
        Assert.isNotNull(attributeName);
        Workspace workspace = this.getWorkspace();
        MarkerManager manager = workspace.getMarkerManager();
        try {
            workspace.prepareOperation(null, null);
            workspace.beginOperation(true);
            MarkerInfo markerInfo = this.getInfo();
            this.checkInfo(markerInfo);
            boolean needDelta = !manager.hasDelta(this.resource.getFullPath(), this.id);
            MarkerInfo oldInfo = needDelta ? (MarkerInfo)markerInfo.clone() : null;
            markerInfo.setAttribute(attributeName, value);
            if (manager.isPersistent(markerInfo)) {
                ((Resource)this.resource).getResourceInfo(false, true).set(4096);
            }
            if (needDelta) {
                MarkerDelta delta = new MarkerDelta(4, this.resource, oldInfo);
                manager.changedMarkers(this.resource, new MarkerDelta[]{delta});
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            workspace.endOperation(null, false, null);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        workspace.endOperation(null, false, null);
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        this.setAttribute(attributeName, value ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        Assert.isNotNull(attributeNames);
        Assert.isNotNull(values);
        Workspace workspace = this.getWorkspace();
        MarkerManager manager = workspace.getMarkerManager();
        try {
            workspace.prepareOperation(null, null);
            workspace.beginOperation(true);
            MarkerInfo markerInfo = this.getInfo();
            this.checkInfo(markerInfo);
            boolean needDelta = !manager.hasDelta(this.resource.getFullPath(), this.id);
            MarkerInfo oldInfo = needDelta ? (MarkerInfo)markerInfo.clone() : null;
            markerInfo.setAttributes(attributeNames, values);
            if (manager.isPersistent(markerInfo)) {
                ((Resource)this.resource).getResourceInfo(false, true).set(4096);
            }
            if (needDelta) {
                MarkerDelta delta = new MarkerDelta(4, this.resource, oldInfo);
                manager.changedMarkers(this.resource, new MarkerDelta[]{delta});
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            workspace.endOperation(null, false, null);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        workspace.endOperation(null, false, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttributes(Map values) throws CoreException {
        Workspace workspace = this.getWorkspace();
        MarkerManager manager = workspace.getMarkerManager();
        try {
            workspace.prepareOperation(null, null);
            workspace.beginOperation(true);
            MarkerInfo markerInfo = this.getInfo();
            this.checkInfo(markerInfo);
            boolean needDelta = !manager.hasDelta(this.resource.getFullPath(), this.id);
            MarkerInfo oldInfo = needDelta ? (MarkerInfo)markerInfo.clone() : null;
            markerInfo.setAttributes(values);
            if (manager.isPersistent(markerInfo)) {
                ((Resource)this.resource).getResourceInfo(false, true).set(4096);
            }
            if (needDelta) {
                MarkerDelta delta = new MarkerDelta(4, this.resource, oldInfo);
                manager.changedMarkers(this.resource, new MarkerDelta[]{delta});
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            workspace.endOperation(null, false, null);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        workspace.endOperation(null, false, null);
    }

    void setId(int value) {
        this.id = value;
    }
}

