/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;

public abstract class RegistryModelObject {
    protected String name = null;
    private int flags = 0;
    static final int M_READ_ONLY = Integer.MIN_VALUE;
    private RegistryModelObject parent;

    protected void assertIsWriteable() {
        Assert.isTrue(!this.isReadOnly(), "Model is read-only");
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return (this.flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public void markReadOnly() {
        this.flags |= Integer.MIN_VALUE;
    }

    public void setName(String value) {
        this.assertIsWriteable();
        this.name = value;
    }

    public int getStartLine() {
        return (this.flags & Integer.MAX_VALUE) - 1;
    }

    public void setStartLine(int lineNumber) {
        if (this.getStartLine() == -1) {
            this.flags = lineNumber + 1 | this.flags & Integer.MIN_VALUE;
        }
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(RegistryModelObject value) {
        this.assertIsWriteable();
        this.parent = value;
    }

    public String toString() {
        return this.getClass() + ":" + this.getName() + "[" + super.toString() + "]";
    }

    public Object getAdapter(Class type) {
        return InternalPlatform.getDefault().getAdapterManager().getAdapter(this, type);
    }

    public RegistryModelObject getRegistry() {
        return this.parent == null ? this : this.parent.getRegistry();
    }

    public void setLocalizedName(String value) {
        this.name = value;
        ((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).setDirty(true);
    }
}

