/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;

public class Extension
extends RegistryModelObject
implements IExtension {
    private String extensionPoint;
    private String id;
    private IConfigurationElement[] elements;
    private int subElementsCacheOffset;
    private boolean fullyLoaded = true;

    public boolean equals(Object object) {
        if (object instanceof Extension) {
            Extension em = (Extension)object;
            return this.id == em.id && this.extensionPoint == em.extensionPoint;
        }
        return false;
    }

    public String getExtensionPointIdentifier() {
        return this.extensionPoint;
    }

    public String getSimpleIdentifier() {
        return this.id;
    }

    public String getUniqueIdentifier() {
        return this.id == null ? null : String.valueOf(this.getParentIdentifier()) + "." + this.id;
    }

    public String getParentIdentifier() {
        BundleModel parent = (BundleModel)this.getParent();
        return parent.isFragment() ? parent.getHostIdentifier() : parent.getName();
    }

    public IConfigurationElement[] getConfigurationElements() {
        Extension extension = this;
        synchronized (extension) {
            if (!this.fullyLoaded) {
                this.fullyLoaded = true;
                RegistryCacheReader reader = ((ExtensionRegistry)this.getRegistry()).getCacheReader();
                if (reader != null) {
                    this.elements = reader.loadConfigurationElements(this, this.subElementsCacheOffset);
                }
            } else if (this.elements == null) {
                return new IConfigurationElement[0];
            }
        }
        return this.elements;
    }

    public void markReadOnly() {
        super.markReadOnly();
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                ((ConfigurationElement)this.elements[i]).markReadOnly();
                ++i;
            }
        }
    }

    public void setExtensionPointIdentifier(String value) {
        this.assertIsWriteable();
        this.extensionPoint = value;
    }

    public void setSimpleIdentifier(String value) {
        this.assertIsWriteable();
        this.id = value;
    }

    public void setSubElements(IConfigurationElement[] value) {
        this.assertIsWriteable();
        this.elements = value;
    }

    public String getLabel() {
        String s = this.getName();
        if (s == null) {
            return "";
        }
        String localized = ((BundleModel)this.getParent()).getResourceString(s);
        if (localized != s) {
            this.setLocalizedName(localized);
        }
        return localized;
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + " -> " + this.getExtensionPointIdentifier();
    }

    void setSubElementsCacheOffset(int value) {
        this.subElementsCacheOffset = value;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean value) {
        this.fullyLoaded = value;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return CompatibilityHelper.getPluginDescriptor(((BundleModel)this.getParent()).getName());
    }

    public String getExtensionPointUniqueIdentifier() {
        return this.getExtensionPointIdentifier();
    }

    public void setLocalizedName(String value) {
        this.name = value;
        ((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).setDirty(true);
    }
}

