/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Log;
import org.eclipse.core.internal.indexing.Page;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.PageStoreException;

class LogReader {
    protected FileInputStream in;
    protected PageStore store;
    protected byte[] b4;
    protected byte[] pageBuffer;

    public static Map getModifiedPages(PageStore store) throws PageStoreException {
        LogReader reader = new LogReader(store);
        reader.open(store);
        Map modifiedPages = reader.getModifiedPages();
        reader.close();
        return modifiedPages;
    }

    public LogReader(PageStore store) {
        this.store = store;
        this.pageBuffer = new byte[8192];
        this.b4 = new byte[4];
    }

    protected void open(PageStore store) throws PageStoreException {
        String name = store.getName();
        if (!Log.exists(name)) {
            return;
        }
        try {
            this.in = new FileInputStream(Log.name(name));
        }
        catch (IOException e) {
            throw new PageStoreException(21, (Throwable)e);
        }
    }

    protected void close() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {}
        this.in = null;
    }

    protected Map getModifiedPages() throws PageStoreException {
        TreeMap<Integer, Page> modifiedPages = new TreeMap<Integer, Page>();
        if (this.in == null) {
            return modifiedPages;
        }
        Field f4 = new Field(this.b4);
        this.readBuffer(this.b4);
        int numberOfPages = f4.getInt();
        int recordSize = 8196;
        if (this.bytesAvailable() != numberOfPages * recordSize) {
            return modifiedPages;
        }
        int i = 0;
        while (i < numberOfPages) {
            this.readBuffer(this.b4);
            this.readBuffer(this.pageBuffer);
            int pageNumber = f4.getInt();
            Page page = this.store.getPolicy().createPage(pageNumber, this.pageBuffer, this.store);
            Integer key = new Integer(pageNumber);
            modifiedPages.put(key, page);
            ++i;
        }
        return modifiedPages;
    }

    public void readBuffer(byte[] buffer) throws PageStoreException {
        try {
            this.in.read(buffer);
        }
        catch (IOException e) {
            throw new PageStoreException(23, (Throwable)e);
        }
    }

    protected int bytesAvailable() throws PageStoreException {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            throw new PageStoreException(23, (Throwable)e);
        }
    }
}

