/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Map;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class InternalBuilder {
    private String label;
    private IProject project;
    private String natureId;
    private ElementTree oldState;
    private IPluginDescriptor pluginDescriptor;
    private IProject[] interestingProjects = ICoreConstants.EMPTY_PROJECT_ARRAY;
    private boolean forgetStateRequested = false;

    protected abstract IProject[] build(int var1, Map var2, IProgressMonitor var3) throws CoreException;

    final void clearForgetLastBuiltState() {
        this.forgetStateRequested = false;
    }

    protected void forgetLastBuiltState() {
        this.oldState = null;
        this.forgetStateRequested = true;
    }

    protected IResourceDelta getDelta(IProject project) {
        return ((Workspace)project.getWorkspace()).getBuildManager().getDelta(project);
    }

    final IProject[] getInterestingProjects() {
        return this.interestingProjects;
    }

    final String getLabel() {
        return this.label;
    }

    final ElementTree getLastBuiltTree() {
        return this.oldState;
    }

    final String getNatureId() {
        return this.natureId;
    }

    final IPluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    protected IProject getProject() {
        return this.project;
    }

    protected boolean hasBeenBuilt(IProject project) {
        return ((Workspace)project.getWorkspace()).getBuildManager().hasBeenBuilt(project);
    }

    public boolean isInterrupted() {
        return ((Workspace)this.project.getWorkspace()).getBuildManager().interrupted;
    }

    protected void needRebuild() {
        ((Workspace)this.project.getWorkspace()).getBuildManager().requestRebuild();
    }

    final void setInterestingProjects(IProject[] value) {
        this.interestingProjects = value;
    }

    final void setLastBuiltTree(ElementTree value) {
        this.oldState = value;
    }

    final void setNatureId(String id) {
        this.natureId = id;
    }

    final void setPluginDescriptor(IPluginDescriptor value) {
        this.pluginDescriptor = value;
    }

    final void setLabel(String value) {
        this.label = value;
    }

    final void setProject(IProject value) {
        Assert.isTrue(this.project == null);
        this.project = value;
    }

    protected abstract void startupOnInitialize();

    final boolean wasForgetStateRequested() {
        return this.forgetStateRequested;
    }
}

