/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.weaver.ExtensibleURLClassLoader;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.aspectj.weaver.tools.WeavingClassLoader;

public class WeavingURLClassLoader
extends ExtensibleURLClassLoader
implements WeavingClassLoader {
    public static final String WEAVING_CLASS_PATH = "aj.class.path";
    public static final String WEAVING_ASPECT_PATH = "aj.aspect.path";
    private URL[] aspectURLs;
    private WeavingAdaptor adaptor;
    private Map generatedClasses = new HashMap();

    public WeavingURLClassLoader(ClassLoader parent) {
        this(WeavingURLClassLoader.getURLs(WeavingURLClassLoader.getClassPath()), WeavingURLClassLoader.getURLs(WeavingURLClassLoader.getAspectPath()), parent);
    }

    public WeavingURLClassLoader(URL[] classURLs, URL[] aspectURLs, ClassLoader parent) {
        super(classURLs, parent);
        this.aspectURLs = aspectURLs;
        this.adaptor = new WeavingAdaptor(this);
    }

    private static String getAspectPath() {
        return System.getProperty(WEAVING_ASPECT_PATH, "");
    }

    private static String getClassPath() {
        return System.getProperty(WEAVING_CLASS_PATH, "");
    }

    private static URL[] getURLs(String path) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringTokenizer t = new StringTokenizer(path, File.pathSeparator);
        while (t.hasMoreTokens()) {
            File f = new File(t.nextToken().trim());
            try {
                URL url;
                if (!f.exists() || (url = f.toURL()) == null) continue;
                urlList.add(url);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        URL[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        return urls;
    }

    protected void addURL(URL url) {
        this.adaptor.addURL(url);
        super.addURL(url);
    }

    protected Class defineClass(String name, byte[] b, CodeSource cs) throws IOException {
        b = this.adaptor.weaveClass(name, b);
        return super.defineClass(name, b, cs);
    }

    protected byte[] getBytes(String name) throws IOException {
        byte[] bytes = super.getBytes(name);
        if (bytes == null) {
            return (byte[])this.generatedClasses.remove(name);
        }
        return bytes;
    }

    public URL[] getAspectURLs() {
        return this.aspectURLs;
    }

    public void acceptClass(String name, byte[] bytes) {
        this.generatedClasses.put(name, bytes);
    }
}

