/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class LineReader
extends LineNumberReader {
    public static final String RETURN = "\n\r";
    private static final String[] NONE = new String[0];
    private static final String cSCRIPT = "#";
    private static final String cJAVA = "//";
    private static final String[] TESTER_LEAD = new String[]{"#", "//"};
    private final File file;
    private final String[] eolComments;
    private final String[] leadComments;
    transient String lastLine;

    public static final LineReader createTester(File file) {
        return LineReader.create(file, TESTER_LEAD, null);
    }

    public static final LineReader create(File file, String[] leadComments, String[] eolComments) {
        try {
            FileReader reader = new FileReader(file);
            return new LineReader(reader, file, leadComments, eolComments);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public LineReader(FileReader reader, File file, String[] leadComments, String[] eolComments) {
        super(reader);
        this.file = file;
        this.eolComments = this.normalize(eolComments);
        this.leadComments = this.normalize(leadComments);
    }

    public LineReader(FileReader reader, File file) {
        this(reader, file, null, null);
    }

    public String toString() {
        return this.file.getPath() + ":" + this.getLineNumber();
    }

    public File getFile() {
        return this.file;
    }

    public String[] readLines(int first, int last) {
        ArrayList<String> list;
        block8: {
            if (0 > first) {
                first = 0;
            }
            if (first > last) {
                last = first;
            }
            list = new ArrayList<String>();
            try {
                String line = null;
                while (this.getLineNumber() < first) {
                    line = this.readLine();
                    if (null == line) break;
                }
                if (this.getLineNumber() > first) {
                    // empty if block
                }
                if (null == line || first != this.getLineNumber()) break block8;
                list.add(line);
                while (last >= this.getLineNumber()) {
                    line = this.readLine();
                    if (null != line) {
                        list.add(line);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                return NONE;
            }
        }
        return list.toArray(NONE);
    }

    /*
     * WARNING - void declaration
     */
    public String readToBlankLine() throws IOException {
        String input;
        StringBuffer sb = new StringBuffer();
        while (null != (input = this.nextLine(false))) {
            void var2_2;
            sb.append((String)var2_2);
            sb.append(RETURN);
        }
        return sb.toString();
    }

    public String lastLine() {
        return this.lastLine;
    }

    public String nextLine(boolean skipEmpties) throws IOException {
        String result;
        while (null != (result = this.readClippedLine()) && skipEmpties && 0 == result.length()) {
        }
        return result;
    }

    protected String readClippedLine() throws IOException {
        String result = this.readLine();
        if (result != null) {
            result = result.trim();
            int len = result.length();
            int i = 0;
            while (0 < len && i < this.leadComments.length) {
                if (result.startsWith(this.leadComments[i])) {
                    result = "";
                    len = 0;
                }
                ++i;
            }
            int i2 = 0;
            while (0 < len && i2 < this.eolComments.length) {
                int loc = result.indexOf(this.eolComments[i2]);
                if (-1 != loc) {
                    result = result.substring(0, loc);
                    len = result.length();
                }
                ++i2;
            }
        }
        this.lastLine = result;
        return result;
    }

    private String[] normalize(String[] input) {
        if (null == input || 0 == input.length) {
            return NONE;
        }
        String[] result = new String[input.length];
        System.arraycopy(input, 0, result, 0, result.length);
        int i = 0;
        while (i < result.length) {
            if (null == result[i] || 0 == result[i].length()) {
                throw new IllegalArgumentException("empty input at [" + i + "]");
            }
            ++i;
        }
        return result;
    }
}

