/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.ast.AccessForInlineVisitor;
import org.aspectj.ajdt.internal.compiler.ast.AspectClinit;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseScope;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceType;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.HelperInterfaceBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InlineAccessFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedHandler;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.TypePattern;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AspectDeclaration
extends TypeDeclaration {
    private AjAttribute.Aspect aspectAttribute;
    public PerClause perClause;
    public ResolvedMember aspectOfMethod;
    public ResolvedMember hasAspectMethod;
    public Map accessForInline = new HashMap();
    public Map superAccessForInline = new HashMap();
    public boolean isPrivileged;
    public EclipseSourceType concreteName;
    public ResolvedTypeX.Name typeX;
    public EclipseFactory factory;
    public int adviceCounter = 1;
    public TypePattern dominatesPattern;
    private FieldBinding initFailureField = null;

    public AspectDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public void resolve() {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        super.resolve();
    }

    public void checkSpec(ClassScope scope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.dominatesPattern != null) {
            scope.problemReporter().signalError(this.dominatesPattern.getStart(), this.dominatesPattern.getEnd(), "dominates has changed for 1.1, use 'declare precedence: " + new String(this.name) + ", " + this.dominatesPattern.toString() + ";' " + "in the body of the aspect instead");
        }
        if (!this.isAbstract()) {
            MethodBinding[] methods = this.binding.methods();
            int i = 0;
            int len = methods.length;
            while (i < len) {
                MethodBinding m = methods[i];
                if (m.isConstructor()) {
                    methods[i] = new MethodBinding(m, this.binding){

                        public boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
                            return false;
                        }
                    };
                    if (m.parameters != null && m.parameters.length != 0) {
                        scope.problemReporter().signalError(m.sourceStart(), m.sourceEnd(), "only zero-argument constructors allowed in concrete aspect");
                    }
                }
                ++i;
            }
        }
        if (this.enclosingType != null && !Modifier.isStatic(this.modifiers)) {
            scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "inner aspects must be static");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(scope);
        ResolvedTypeX.Name myType = this.typeX;
        ResolvedTypeX superType = ((ResolvedTypeX)myType).getSuperclass();
        if (!world.buildManager.buildConfig.isXserializableAspects()) {
            if (world.getWorld().resolve(TypeX.SERIALIZABLE).isAssignableFrom(myType)) {
                scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "aspects may not implement Serializable");
                this.ignoreFurtherInvestigation = true;
                return;
            }
            if (world.getWorld().resolve(TypeX.CLONEABLE).isAssignableFrom(myType)) {
                scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "aspects may not implement Cloneable");
                this.ignoreFurtherInvestigation = true;
                return;
            }
        }
        if (superType.isAspect() && !superType.isAbstract()) {
            scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can not extend a concrete aspect");
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void generateCode(ClassFile enclosingClassFile) {
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        this.modifiers = AstUtil.makePublic(this.modifiers);
        this.binding.modifiers = AstUtil.makePublic(this.binding.modifiers);
        if (!this.isAbstract()) {
            this.initFailureField = this.factory.makeFieldBinding(AjcMemberMaker.initFailureCauseField(this.typeX));
            this.binding.addField(this.initFailureField);
            if (this.perClause != null) {
                if (this.perClause.getKind() == PerClause.SINGLETON) {
                    this.binding.addField(this.factory.makeFieldBinding(AjcMemberMaker.perSingletonField(this.typeX)));
                    this.methods[0] = new AspectClinit((Clinit)this.methods[0], this.compilationResult, false, true, this.initFailureField);
                } else if (this.perClause.getKind() == PerClause.PERCFLOW) {
                    this.binding.addField(this.factory.makeFieldBinding(AjcMemberMaker.perCflowField(this.typeX)));
                    this.methods[0] = new AspectClinit((Clinit)this.methods[0], this.compilationResult, true, false, null);
                } else if (this.perClause.getKind() != PerClause.PEROBJECT) {
                    throw new RuntimeException("unimplemented");
                }
            }
        }
        if (EclipseFactory.DEBUG) {
            System.out.println(this.toString());
        }
        super.generateCode(enclosingClassFile);
    }

    public boolean needClassInitMethod() {
        return true;
    }

    protected void generateAttributes(ClassFile classFile) {
        if (!this.isAbstract()) {
            this.generatePerSupportMembers(classFile);
        }
        this.generateInlineAccessMembers(classFile);
        classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.Aspect(this.perClause)));
        if (this.binding.privilegedHandler != null) {
            ResolvedMember[] members = ((PrivilegedHandler)this.binding.privilegedHandler).getMembers();
            classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.PrivilegedAttribute(members)));
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.SourceContextAttribute(new String(this.compilationResult().getFileName()), this.compilationResult().lineSeparatorPositions)));
        super.generateAttributes(classFile);
    }

    private void generateInlineAccessMembers(ClassFile classFile) {
        Iterator i = this.superAccessForInline.values().iterator();
        while (i.hasNext()) {
            AccessForInlineVisitor.SuperAccessMethodPair pair = (AccessForInlineVisitor.SuperAccessMethodPair)i.next();
            this.generateSuperAccessMethod(classFile, pair.accessMethod, pair.originalMethod);
        }
        Iterator i2 = this.accessForInline.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry e = i2.next();
            this.generateInlineAccessMethod(classFile, (Binding)e.getValue(), (ResolvedMember)e.getKey());
        }
    }

    private void generatePerSupportMembers(ClassFile classFile) {
        if (this.isAbstract()) {
            return;
        }
        if (this.aspectOfMethod == null) {
            return;
        }
        if (this.perClause == null) {
            System.err.println("has null perClause: " + this);
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        if (this.perClause.getKind() == PerClause.SINGLETON) {
            this.generatePerSingletonAspectOfMethod(classFile);
            this.generatePerSingletonHasAspectMethod(classFile);
            this.generatePerSingletonAjcClinitMethod(classFile);
        } else if (this.perClause.getKind() == PerClause.PERCFLOW) {
            this.generatePerCflowAspectOfMethod(classFile);
            this.generatePerCflowHasAspectMethod(classFile);
            this.generatePerCflowPushMethod(classFile);
            this.generatePerCflowAjcClinitMethod(classFile);
        } else if (this.perClause.getKind() == PerClause.PEROBJECT) {
            TypeBinding interfaceType = this.generatePerObjectInterface(classFile);
            world.addTypeBinding(interfaceType);
            this.generatePerObjectAspectOfMethod(classFile, interfaceType);
            this.generatePerObjectHasAspectMethod(classFile, interfaceType);
            this.generatePerObjectBindMethod(classFile, interfaceType);
        } else {
            throw new RuntimeException("unimplemented");
        }
    }

    private void generateMethod(ClassFile classFile, ResolvedMember member, BodyGenerator gen) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(member), gen);
    }

    private void generateMethod(ClassFile classFile, MethodBinding methodBinding, BodyGenerator gen) {
        classFile.generateMethodInfoHeader(methodBinding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttribute(methodBinding, AstUtil.getAjSyntheticAttribute());
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        MethodDeclaration md = AstUtil.makeMethodDeclaration(methodBinding);
        md.scope = this.initializerScope;
        codeStream.reset(md, classFile);
        gen.generate(codeStream);
        classFile.completeCodeAttribute(codeAttributeOffset);
        classFile.completeMethodInfo(methodAttributeOffset, ++attributeNumber);
    }

    private void generatePerCflowAspectOfMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.getstatic(world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)));
                codeStream.invokevirtual(world.makeMethodBindingForCall(AjcMemberMaker.cflowStackPeekInstance()));
                codeStream.checkcast(AspectDeclaration.this.binding);
                codeStream.areturn();
            }
        });
    }

    private void generatePerCflowHasAspectMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.getstatic(world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)));
                codeStream.invokevirtual(world.makeMethodBindingForCall(AjcMemberMaker.cflowStackIsValid()));
                codeStream.ireturn();
            }
        });
    }

    private void generatePerCflowPushMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(AjcMemberMaker.perCflowPush(EclipseFactory.fromBinding(this.binding))), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.getstatic(world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)));
                codeStream.new_(AspectDeclaration.this.binding);
                codeStream.dup();
                codeStream.invokespecial(new MethodBinding(0, "<init>".toCharArray(), BaseTypes.VoidBinding, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding));
                codeStream.invokevirtual(world.makeMethodBindingForCall(AjcMemberMaker.cflowStackPushInstance()));
                codeStream.return_();
            }
        });
    }

    private void generatePerCflowAjcClinitMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(AjcMemberMaker.ajcPreClinitMethod(EclipseFactory.fromBinding(this.binding))), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.CFLOW_STACK_TYPE));
                codeStream.dup();
                codeStream.invokespecial(world.makeMethodBindingForCall(AjcMemberMaker.cflowStackInit()));
                codeStream.putstatic(world.makeFieldBinding(AjcMemberMaker.perCflowField(AspectDeclaration.this.typeX)));
                codeStream.return_();
            }
        });
    }

    private TypeBinding generatePerObjectInterface(ClassFile classFile) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        TypeX interfaceTypeX = AjcMemberMaker.perObjectInterfaceType(this.typeX);
        HelperInterfaceBinding interfaceType = new HelperInterfaceBinding(this.binding, interfaceTypeX);
        world.addTypeBinding(interfaceType);
        interfaceType.addMethod(world, AjcMemberMaker.perObjectInterfaceGet(this.typeX));
        interfaceType.addMethod(world, AjcMemberMaker.perObjectInterfaceSet(this.typeX));
        interfaceType.generateClass(this.compilationResult, classFile);
        return interfaceType;
    }

    private void generatePerObjectAspectOfMethod(ClassFile classFile, final TypeBinding interfaceType) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                Label wrongType = new Label(codeStream);
                Label popWrongType = new Label(codeStream);
                codeStream.aload_0();
                codeStream.instance_of(interfaceType);
                codeStream.ifeq(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.invokeinterface(world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceGet(AspectDeclaration.this.typeX)));
                codeStream.dup();
                codeStream.ifnull(popWrongType);
                codeStream.areturn();
                popWrongType.place();
                codeStream.pop();
                wrongType.place();
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.NO_ASPECT_BOUND_EXCEPTION));
                codeStream.dup();
                codeStream.invokespecial(world.makeMethodBindingForCall(AjcMemberMaker.noAspectBoundExceptionInit()));
                codeStream.athrow();
            }
        });
    }

    private void generatePerObjectHasAspectMethod(ClassFile classFile, final TypeBinding interfaceType) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                Label wrongType = new Label(codeStream);
                codeStream.aload_0();
                codeStream.instance_of(interfaceType);
                codeStream.ifeq(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.invokeinterface(world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceGet(AspectDeclaration.this.typeX)));
                codeStream.ifnull(wrongType);
                codeStream.iconst_1();
                codeStream.ireturn();
                wrongType.place();
                codeStream.iconst_0();
                codeStream.ireturn();
            }
        });
    }

    private void generatePerObjectBindMethod(ClassFile classFile, final TypeBinding interfaceType) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, AjcMemberMaker.perObjectBind(EclipseFactory.fromBinding(this.binding)), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                Label wrongType = new Label(codeStream);
                codeStream.aload_0();
                codeStream.instance_of(interfaceType);
                codeStream.ifeq(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.invokeinterface(world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceGet(AspectDeclaration.this.typeX)));
                codeStream.ifnonnull(wrongType);
                codeStream.aload_0();
                codeStream.checkcast(interfaceType);
                codeStream.new_(AspectDeclaration.this.binding);
                codeStream.dup();
                codeStream.invokespecial(new MethodBinding(0, "<init>".toCharArray(), BaseTypes.VoidBinding, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding));
                codeStream.invokeinterface(world.makeMethodBindingForCall(AjcMemberMaker.perObjectInterfaceSet(AspectDeclaration.this.typeX)));
                wrongType.place();
                codeStream.return_();
            }
        });
    }

    private void generatePerSingletonAspectOfMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.aspectOfMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.getstatic(world.makeFieldBinding(AjcMemberMaker.perSingletonField(AspectDeclaration.this.typeX)));
                Label isNull = new Label(codeStream);
                codeStream.dup();
                codeStream.ifnull(isNull);
                codeStream.areturn();
                isNull.place();
                codeStream.incrStackSize(1);
                codeStream.new_(world.makeTypeBinding(AjcMemberMaker.NO_ASPECT_BOUND_EXCEPTION));
                codeStream.dup();
                codeStream.ldc(AspectDeclaration.this.typeX.getNameAsIdentifier());
                codeStream.getstatic(AspectDeclaration.this.initFailureField);
                codeStream.invokespecial(world.makeMethodBindingForCall(AjcMemberMaker.noAspectBoundExceptionInitWithCause()));
                codeStream.athrow();
            }
        });
    }

    private void generatePerSingletonHasAspectMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, this.hasAspectMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.getstatic(world.makeFieldBinding(AjcMemberMaker.perSingletonField(AspectDeclaration.this.typeX)));
                Label isNull = new Label(codeStream);
                codeStream.ifnull(isNull);
                codeStream.iconst_1();
                codeStream.ireturn();
                isNull.place();
                codeStream.iconst_0();
                codeStream.ireturn();
            }
        });
    }

    private void generatePerSingletonAjcClinitMethod(ClassFile classFile) {
        final EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        this.generateMethod(classFile, world.makeMethodBinding(AjcMemberMaker.ajcPostClinitMethod(EclipseFactory.fromBinding(this.binding))), new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.new_(AspectDeclaration.this.binding);
                codeStream.dup();
                codeStream.invokespecial(new MethodBinding(0, "<init>".toCharArray(), BaseTypes.VoidBinding, new TypeBinding[0], new ReferenceBinding[0], AspectDeclaration.this.binding));
                codeStream.putstatic(world.makeFieldBinding(AjcMemberMaker.perSingletonField(AspectDeclaration.this.typeX)));
                codeStream.return_();
            }
        });
    }

    private void generateSuperAccessMethod(ClassFile classFile, final MethodBinding accessMethod, final ResolvedMember method) {
        this.generateMethod(classFile, accessMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                codeStream.aload_0();
                AstUtil.generateParameterLoads(accessMethod.parameters, codeStream);
                codeStream.invokespecial(AspectDeclaration.this.factory.makeMethodBinding(method));
                AstUtil.generateReturn(accessMethod.returnType, codeStream);
            }
        });
    }

    private void generateInlineAccessMethod(ClassFile classFile, Binding binding, ResolvedMember member) {
        if (binding instanceof InlineAccessFieldBinding) {
            this.generateInlineAccessors(classFile, (InlineAccessFieldBinding)binding, member);
        } else {
            this.generateInlineAccessMethod(classFile, (MethodBinding)binding, member);
        }
    }

    private void generateInlineAccessors(ClassFile classFile, final InlineAccessFieldBinding accessField, final ResolvedMember field) {
        final FieldBinding fieldBinding = this.factory.makeFieldBinding(field);
        this.generateMethod(classFile, accessField.reader, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                if (field.isStatic()) {
                    codeStream.getstatic(fieldBinding);
                } else {
                    codeStream.aload_0();
                    codeStream.getfield(fieldBinding);
                }
                AstUtil.generateReturn(accessField.reader.returnType, codeStream);
            }
        });
        this.generateMethod(classFile, accessField.writer, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                if (field.isStatic()) {
                    codeStream.load(fieldBinding.type, 0);
                    codeStream.putstatic(fieldBinding);
                } else {
                    codeStream.aload_0();
                    codeStream.load(fieldBinding.type, 1);
                    codeStream.putfield(fieldBinding);
                }
                codeStream.return_();
            }
        });
    }

    private void generateInlineAccessMethod(ClassFile classFile, final MethodBinding accessMethod, final ResolvedMember method) {
        this.generateMethod(classFile, accessMethod, new BodyGenerator(){

            public void generate(CodeStream codeStream) {
                AstUtil.generateParameterLoads(accessMethod.parameters, codeStream);
                if (method.isStatic()) {
                    codeStream.invokestatic(AspectDeclaration.this.factory.makeMethodBinding(method));
                } else {
                    codeStream.invokevirtual(AspectDeclaration.this.factory.makeMethodBinding(method));
                }
                AstUtil.generateReturn(accessMethod.returnType, codeStream);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PerClause.Kind lookupPerClauseKind(ReferenceBinding binding) {
        PerClause perClause;
        if (binding instanceof BinaryTypeBinding) {
            ResolvedTypeX superTypeX = this.factory.fromEclipse(binding);
            perClause = superTypeX.getPerClause();
        } else {
            if (!(binding instanceof SourceTypeBinding)) return null;
            SourceTypeBinding sourceSc = (SourceTypeBinding)binding;
            if (!(sourceSc.scope.referenceContext instanceof AspectDeclaration)) return null;
            perClause = ((AspectDeclaration)sourceSc.scope.referenceContext).perClause;
        }
        if (perClause != null) return perClause.getKind();
        return this.lookupPerClauseKind(binding.superclass());
    }

    private void buildPerClause(ClassScope scope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(scope);
        if (this.perClause == null) {
            PerClause.Kind kind = this.lookupPerClauseKind(this.binding.superclass);
            this.perClause = kind == null ? new PerSingleton() : new PerFromSuper(kind);
        }
        this.aspectAttribute = new AjAttribute.Aspect(this.perClause);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (!this.isAbstract()) {
            if (this.perClause.getKind() == PerClause.SINGLETON) {
                this.aspectOfMethod = AjcMemberMaker.perSingletonAspectOfMethod(this.typeX);
                this.hasAspectMethod = AjcMemberMaker.perSingletonHasAspectMethod(this.typeX);
            } else if (this.perClause.getKind() == PerClause.PERCFLOW) {
                this.aspectOfMethod = AjcMemberMaker.perCflowAspectOfMethod(this.typeX);
                this.hasAspectMethod = AjcMemberMaker.perCflowHasAspectMethod(this.typeX);
            } else if (this.perClause.getKind() == PerClause.PEROBJECT) {
                this.aspectOfMethod = AjcMemberMaker.perObjectAspectOfMethod(this.typeX);
                this.hasAspectMethod = AjcMemberMaker.perObjectHasAspectMethod(this.typeX);
            } else {
                throw new RuntimeException("bad per clause: " + this.perClause);
            }
            this.binding.addMethod(world.makeMethodBinding(this.aspectOfMethod));
            this.binding.addMethod(world.makeMethodBinding(this.hasAspectMethod));
        }
        this.resolvePerClause();
    }

    private PerClause resolvePerClause() {
        EclipseScope iscope = new EclipseScope(new FormalBinding[0], this.scope);
        this.perClause.resolve(iscope);
        return this.perClause;
    }

    public void buildInterTypeAndPerClause(ClassScope classScope) {
        this.factory = EclipseFactory.fromScopeLookupEnvironment(this.scope);
        if (this.isPrivileged) {
            this.binding.privilegedHandler = new PrivilegedHandler(this);
        }
        this.checkSpec(classScope);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        this.buildPerClause(this.scope);
        if (this.methods != null) {
            int i = 0;
            while (i < this.methods.length) {
                Declare d;
                if (this.methods[i] instanceof InterTypeDeclaration) {
                    EclipseTypeMunger m = ((InterTypeDeclaration)this.methods[i]).build(classScope);
                    if (m != null) {
                        this.concreteName.typeMungers.add(m);
                    }
                } else if (this.methods[i] instanceof DeclareDeclaration && (d = ((DeclareDeclaration)this.methods[i]).build(classScope)) != null) {
                    this.concreteName.declares.add(d);
                }
                ++i;
            }
        }
        this.concreteName.getDeclaredPointcuts();
    }

    public StringBuffer printHeader(int indent, StringBuffer output) {
        ASTNode.printModifiers(this.modifiers, output);
        output.append("aspect ");
        output.append(this.name);
        if (this.superclass != null) {
            output.append(" extends ");
            this.superclass.print(0, output);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            output.append(this.isInterface() ? " extends " : " implements ");
            int i = 0;
            while (i < this.superInterfaces.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.superInterfaces[i].print(0, output);
                ++i;
            }
        }
        return output;
    }

    private static interface BodyGenerator {
        public void generate(CodeStream var1);
    }
}

