/*
 * SH7757 (A0 step) Pinmux
 *
 *  Copyright (C) 2009  Renesas Solutions Corp.
 *
 *  Author : Yoshihiro Shimoda <shimoda.yoshihiro@renesas.com>
 *
 * Based on SH7757 Pinmux
 *  Copyright (C) 2008  Magnus Damm
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/gpio.h>
#include <cpu/sh7757.h>

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
	PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA,
	PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
	PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA,
	PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
	PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA,
	PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
	PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA,
	PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
	PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA,
	PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
	PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA,
	PTG7_DATA, PTG6_DATA, PTG5_DATA, PTG4_DATA,
	PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA,
	PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
	PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA,
	PTI7_DATA, PTI6_DATA, PTI5_DATA, PTI4_DATA,
	PTI3_DATA, PTI2_DATA, PTI1_DATA, PTI0_DATA,
	PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, PTJ4_DATA,
	PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA,
	PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
	PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA,
	PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
	PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA,
	PTM6_DATA, PTM5_DATA, PTM4_DATA,
	PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA,
	PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
	PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA,
	PTO7_DATA, PTO6_DATA, PTO5_DATA, PTO4_DATA,
	PTO3_DATA, PTO2_DATA, PTO1_DATA, PTO0_DATA,
	PTP6_DATA, PTP5_DATA, PTP4_DATA,
	PTP3_DATA, PTP2_DATA, PTP1_DATA, PTP0_DATA,
	PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
	PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA,
	PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
	PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA,
	PTS7_DATA, PTS6_DATA, PTS5_DATA, PTS4_DATA,
	PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA,
	PTT5_DATA, PTT4_DATA,
	PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA,
	PTU7_DATA, PTU6_DATA, PTU5_DATA, PTU4_DATA,
	PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA,
	PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
	PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA,
	PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
	PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA,
	PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
	PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA,
	PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
	PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA,
	PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
	PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PTA7_IN, PTA6_IN, PTA5_IN, PTA4_IN,
	PTA3_IN, PTA2_IN, PTA1_IN, PTA0_IN,
	PTB7_IN, PTB6_IN, PTB5_IN, PTB4_IN,
	PTB3_IN, PTB2_IN, PTB1_IN, PTB0_IN,
	PTC7_IN, PTC6_IN, PTC5_IN, PTC4_IN,
	PTC3_IN, PTC2_IN, PTC1_IN, PTC0_IN,
	PTD7_IN, PTD6_IN, PTD5_IN, PTD4_IN,
	PTD3_IN, PTD2_IN, PTD1_IN, PTD0_IN,
	PTE7_IN, PTE6_IN, PTE5_IN, PTE4_IN,
	PTE3_IN, PTE2_IN, PTE1_IN, PTE0_IN,
	PTF7_IN, PTF6_IN, PTF5_IN, PTF4_IN,
	PTF3_IN, PTF2_IN, PTF1_IN, PTF0_IN,
	PTG7_IN, PTG6_IN, PTG5_IN, PTG4_IN,
	PTG3_IN, PTG2_IN, PTG1_IN, PTG0_IN,
	PTH7_IN, PTH6_IN, PTH5_IN, PTH4_IN,
	PTH3_IN, PTH2_IN, PTH1_IN, PTH0_IN,
	PTI7_IN, PTI6_IN, PTI5_IN, PTI4_IN,
	PTI3_IN, PTI2_IN, PTI1_IN, PTI0_IN,
	PTJ7_IN, PTJ6_IN, PTJ5_IN, PTJ4_IN,
	PTJ3_IN, PTJ2_IN, PTJ1_IN, PTJ0_IN,
	PTK7_IN, PTK6_IN, PTK5_IN, PTK4_IN,
	PTK3_IN, PTK2_IN, PTK1_IN, PTK0_IN,
	PTL7_IN, PTL6_IN, PTL5_IN, PTL4_IN,
	PTL3_IN, PTL2_IN, PTL1_IN, PTL0_IN,
	PTM6_IN, PTM5_IN, PTM4_IN,
	PTM3_IN, PTM2_IN, PTM1_IN, PTM0_IN,
	PTN7_IN, PTN6_IN, PTN5_IN, PTN4_IN,
	PTN3_IN, PTN2_IN, PTN1_IN, PTN0_IN,
	PTO7_IN, PTO6_IN, PTO5_IN, PTO4_IN,
	PTO3_IN, PTO2_IN, PTO1_IN, PTO0_IN,
	PTP6_IN, PTP5_IN, PTP4_IN,
	PTP3_IN, PTP2_IN, PTP1_IN, PTP0_IN,
	PTQ6_IN, PTQ5_IN, PTQ4_IN,
	PTQ3_IN, PTQ2_IN, PTQ1_IN, PTQ0_IN,
	PTR7_IN, PTR6_IN, PTR5_IN, PTR4_IN,
	PTR3_IN, PTR2_IN, PTR1_IN, PTR0_IN,
	PTS7_IN, PTS6_IN, PTS5_IN, PTS4_IN,
	PTS3_IN, PTS2_IN, PTS1_IN, PTS0_IN,
	PTT5_IN, PTT4_IN,
	PTT3_IN, PTT2_IN, PTT1_IN, PTT0_IN,
	PTU7_IN, PTU6_IN, PTU5_IN, PTU4_IN,
	PTU3_IN, PTU2_IN, PTU1_IN, PTU0_IN,
	PTV7_IN, PTV6_IN, PTV5_IN, PTV4_IN,
	PTV3_IN, PTV2_IN, PTV1_IN, PTV0_IN,
	PTW7_IN, PTW6_IN, PTW5_IN, PTW4_IN,
	PTW3_IN, PTW2_IN, PTW1_IN, PTW0_IN,
	PTX7_IN, PTX6_IN, PTX5_IN, PTX4_IN,
	PTX3_IN, PTX2_IN, PTX1_IN, PTX0_IN,
	PTY7_IN, PTY6_IN, PTY5_IN, PTY4_IN,
	PTY3_IN, PTY2_IN, PTY1_IN, PTY0_IN,
	PTZ7_IN, PTZ6_IN, PTZ5_IN, PTZ4_IN,
	PTZ3_IN, PTZ2_IN, PTZ1_IN, PTZ0_IN,
	PINMUX_INPUT_END,

	PINMUX_INPUT_PULLUP_BEGIN,
	PTU7_IN_PU, PTU6_IN_PU, PTU5_IN_PU, PTU4_IN_PU,
	PTU3_IN_PU, PTU2_IN_PU, PTU1_IN_PU, PTU0_IN_PU,
	PTV7_IN_PU, PTV6_IN_PU, PTV5_IN_PU, PTV4_IN_PU,
	PTV3_IN_PU, PTV2_IN_PU, PTV1_IN_PU, PTV0_IN_PU,
	PTW7_IN_PU, PTW6_IN_PU, PTW5_IN_PU, PTW4_IN_PU,
	PTW3_IN_PU, PTW2_IN_PU, PTW1_IN_PU, PTW0_IN_PU,
	PTX7_IN_PU, PTX6_IN_PU, PTX5_IN_PU, PTX4_IN_PU,
	PTX3_IN_PU, PTX2_IN_PU, PTX1_IN_PU, PTX0_IN_PU,
	PTY7_IN_PU, PTY6_IN_PU, PTY5_IN_PU, PTY4_IN_PU,
	PTY3_IN_PU, PTY2_IN_PU, PTY1_IN_PU, PTY0_IN_PU,
	PINMUX_INPUT_PULLUP_END,

	PINMUX_OUTPUT_BEGIN,
	PTA7_OUT, PTA6_OUT, PTA5_OUT, PTA4_OUT,
	PTA3_OUT, PTA2_OUT, PTA1_OUT, PTA0_OUT,
	PTB7_OUT, PTB6_OUT, PTB5_OUT, PTB4_OUT,
	PTB3_OUT, PTB2_OUT, PTB1_OUT, PTB0_OUT,
	PTC7_OUT, PTC6_OUT, PTC5_OUT, PTC4_OUT,
	PTC3_OUT, PTC2_OUT, PTC1_OUT, PTC0_OUT,
	PTD7_OUT, PTD6_OUT, PTD5_OUT, PTD4_OUT,
	PTD3_OUT, PTD2_OUT, PTD1_OUT, PTD0_OUT,
	PTE7_OUT, PTE6_OUT, PTE5_OUT, PTE4_OUT,
	PTE3_OUT, PTE2_OUT, PTE1_OUT, PTE0_OUT,
	PTF7_OUT, PTF6_OUT, PTF5_OUT, PTF4_OUT,
	PTF3_OUT, PTF2_OUT, PTF1_OUT, PTF0_OUT,
	PTG7_OUT, PTG6_OUT, PTG5_OUT, PTG4_OUT,
	PTG3_OUT, PTG2_OUT, PTG1_OUT, PTG0_OUT,
	PTH7_OUT, PTH6_OUT, PTH5_OUT, PTH4_OUT,
	PTH3_OUT, PTH2_OUT, PTH1_OUT, PTH0_OUT,
	PTI7_OUT, PTI6_OUT, PTI5_OUT, PTI4_OUT,
	PTI3_OUT, PTI2_OUT, PTI1_OUT, PTI0_OUT,
	PTJ7_OUT, PTJ6_OUT, PTJ5_OUT, PTJ4_OUT,
	PTJ3_OUT, PTJ2_OUT, PTJ1_OUT, PTJ0_OUT,
	PTK7_OUT, PTK6_OUT, PTK5_OUT, PTK4_OUT,
	PTK3_OUT, PTK2_OUT, PTK1_OUT, PTK0_OUT,
	PTL7_OUT, PTL6_OUT, PTL5_OUT, PTL4_OUT,
	PTL3_OUT, PTL2_OUT, PTL1_OUT, PTL0_OUT,
	PTM6_OUT, PTM5_OUT, PTM4_OUT,
	PTM3_OUT, PTM2_OUT, PTM1_OUT, PTM0_OUT,
	PTN7_OUT, PTN6_OUT, PTN5_OUT, PTN4_OUT,
	PTN3_OUT, PTN2_OUT, PTN1_OUT, PTN0_OUT,
	PTO7_OUT, PTO6_OUT, PTO5_OUT, PTO4_OUT,
	PTO3_OUT, PTO2_OUT, PTO1_OUT, PTO0_OUT,
	PTP6_OUT, PTP5_OUT, PTP4_OUT,
	PTP3_OUT, PTP2_OUT, PTP1_OUT, PTP0_OUT,
	PTQ6_OUT, PTQ5_OUT, PTQ4_OUT,
	PTQ3_OUT, PTQ2_OUT, PTQ1_OUT, PTQ0_OUT,
	PTR7_OUT, PTR6_OUT, PTR5_OUT, PTR4_OUT,
	PTR3_OUT, PTR2_OUT, PTR1_OUT, PTR0_OUT,
	PTS7_OUT, PTS6_OUT, PTS5_OUT, PTS4_OUT,
	PTS3_OUT, PTS2_OUT, PTS1_OUT, PTS0_OUT,
	PTT5_OUT, PTT4_OUT,
	PTT3_OUT, PTT2_OUT, PTT1_OUT, PTT0_OUT,
	PTU7_OUT, PTU6_OUT, PTU5_OUT, PTU4_OUT,
	PTU3_OUT, PTU2_OUT, PTU1_OUT, PTU0_OUT,
	PTV7_OUT, PTV6_OUT, PTV5_OUT, PTV4_OUT,
	PTV3_OUT, PTV2_OUT, PTV1_OUT, PTV0_OUT,
	PTW7_OUT, PTW6_OUT, PTW5_OUT, PTW4_OUT,
	PTW3_OUT, PTW2_OUT, PTW1_OUT, PTW0_OUT,
	PTX7_OUT, PTX6_OUT, PTX5_OUT, PTX4_OUT,
	PTX3_OUT, PTX2_OUT, PTX1_OUT, PTX0_OUT,
	PTY7_OUT, PTY6_OUT, PTY5_OUT, PTY4_OUT,
	PTY3_OUT, PTY2_OUT, PTY1_OUT, PTY0_OUT,
	PTZ7_OUT, PTZ6_OUT, PTZ5_OUT, PTZ4_OUT,
	PTZ3_OUT, PTZ2_OUT, PTZ1_OUT, PTZ0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PTA7_FN, PTA6_FN, PTA5_FN, PTA4_FN,
	PTA3_FN, PTA2_FN, PTA1_FN, PTA0_FN,
	PTB7_FN, PTB6_FN, PTB5_FN, PTB4_FN,
	PTB3_FN, PTB2_FN, PTB1_FN, PTB0_FN,
	PTC7_FN, PTC6_FN, PTC5_FN, PTC4_FN,
	PTC3_FN, PTC2_FN, PTC1_FN, PTC0_FN,
	PTD7_FN, PTD6_FN, PTD5_FN, PTD4_FN,
	PTD3_FN, PTD2_FN, PTD1_FN, PTD0_FN,
	PTE7_FN, PTE6_FN, PTE5_FN, PTE4_FN,
	PTE3_FN, PTE2_FN, PTE1_FN, PTE0_FN,
	PTF7_FN, PTF6_FN, PTF5_FN, PTF4_FN,
	PTF3_FN, PTF2_FN, PTF1_FN, PTF0_FN,
	PTG7_FN, PTG6_FN, PTG5_FN, PTG4_FN,
	PTG3_FN, PTG2_FN, PTG1_FN, PTG0_FN,
	PTH7_FN, PTH6_FN, PTH5_FN, PTH4_FN,
	PTH3_FN, PTH2_FN, PTH1_FN, PTH0_FN,
	PTI7_FN, PTI6_FN, PTI5_FN, PTI4_FN,
	PTI3_FN, PTI2_FN, PTI1_FN, PTI0_FN,
	PTJ7_FN, PTJ6_FN, PTJ5_FN, PTJ4_FN,
	PTJ3_FN, PTJ2_FN, PTJ1_FN, PTJ0_FN,
	PTK7_FN, PTK6_FN, PTK5_FN, PTK4_FN,
	PTK3_FN, PTK2_FN, PTK1_FN, PTK0_FN,
	PTL7_FN, PTL6_FN, PTL5_FN, PTL4_FN,
	PTL3_FN, PTL2_FN, PTL1_FN, PTL0_FN,
	PTM6_FN, PTM5_FN, PTM4_FN,
	PTM3_FN, PTM2_FN, PTM1_FN, PTM0_FN,
	PTN7_FN, PTN6_FN, PTN5_FN, PTN4_FN,
	PTN3_FN, PTN2_FN, PTN1_FN, PTN0_FN,
	PTO7_FN, PTO6_FN, PTO5_FN, PTO4_FN,
	PTO3_FN, PTO2_FN, PTO1_FN, PTO0_FN,
	PTP6_FN, PTP5_FN, PTP4_FN,
	PTP3_FN, PTP2_FN, PTP1_FN, PTP0_FN,
	PTQ6_FN, PTQ5_FN, PTQ4_FN,
	PTQ3_FN, PTQ2_FN, PTQ1_FN, PTQ0_FN,
	PTR7_FN, PTR6_FN, PTR5_FN, PTR4_FN,
	PTR3_FN, PTR2_FN, PTR1_FN, PTR0_FN,
	PTS7_FN, PTS6_FN, PTS5_FN, PTS4_FN,
	PTS3_FN, PTS2_FN, PTS1_FN, PTS0_FN,
	PTT5_FN, PTT4_FN,
	PTT3_FN, PTT2_FN, PTT1_FN, PTT0_FN,
	PTU7_FN, PTU6_FN, PTU5_FN, PTU4_FN,
	PTU3_FN, PTU2_FN, PTU1_FN, PTU0_FN,
	PTV7_FN, PTV6_FN, PTV5_FN, PTV4_FN,
	PTV3_FN, PTV2_FN, PTV1_FN, PTV0_FN,
	PTW7_FN, PTW6_FN, PTW5_FN, PTW4_FN,
	PTW3_FN, PTW2_FN, PTW1_FN, PTW0_FN,
	PTX7_FN, PTX6_FN, PTX5_FN, PTX4_FN,
	PTX3_FN, PTX2_FN, PTX1_FN, PTX0_FN,
	PTY7_FN, PTY6_FN, PTY5_FN, PTY4_FN,
	PTY3_FN, PTY2_FN, PTY1_FN, PTY0_FN,
	PTZ7_FN, PTZ6_FN, PTZ5_FN, PTZ4_FN,
	PTZ3_FN, PTZ2_FN, PTZ1_FN, PTZ0_FN,

	PS0_15_FN1, PS0_15_FN3,
	PS0_14_FN1, PS0_14_FN3,
	PS0_13_FN1, PS0_13_FN3,
	PS0_12_FN1, PS0_12_FN3,
	PS0_7_FN1, PS0_7_FN2,
	PS0_6_FN1, PS0_6_FN2,
	PS0_5_FN1, PS0_5_FN2,
	PS0_4_FN1, PS0_4_FN2,
	PS0_3_FN1, PS0_3_FN2,
	PS0_2_FN1, PS0_2_FN2,
	PS0_1_FN1, PS0_1_FN2,

	PS1_7_FN1, PS1_7_FN3,
	PS1_6_FN1, PS1_6_FN3,

	PS2_13_FN1, PS2_13_FN3,
	PS2_12_FN1, PS2_12_FN3,
	PS2_1_FN1, PS2_1_FN2,
	PS2_0_FN1, PS2_0_FN2,

	PS4_15_FN1, PS4_15_FN2,
	PS4_14_FN1, PS4_14_FN2,
	PS4_13_FN1, PS4_13_FN2,
	PS4_12_FN1, PS4_12_FN2,
	PS4_11_FN1, PS4_11_FN2,
	PS4_10_FN1, PS4_10_FN2,
	PS4_9_FN1, PS4_9_FN2,
	PS4_3_FN1, PS4_3_FN2,
	PS4_2_FN1, PS4_2_FN2,
	PS4_1_FN1, PS4_1_FN2,
	PS4_0_FN1, PS4_0_FN2,

	PS5_9_FN1, PS5_9_FN2,
	PS5_8_FN1, PS5_8_FN2,
	PS5_7_FN1, PS5_7_FN2,
	PS5_6_FN1, PS5_6_FN2,
	PS5_5_FN1, PS5_5_FN2,
	PS5_4_FN1, PS5_4_FN2,

	/* AN15 to 8 : EVENT15 to 8 */
	PS6_7_FN_AN, PS6_7_FN_EV,
	PS6_6_FN_AN, PS6_6_FN_EV,
	PS6_5_FN_AN, PS6_5_FN_EV,
	PS6_4_FN_AN, PS6_4_FN_EV,
	PS6_3_FN_AN, PS6_3_FN_EV,
	PS6_2_FN_AN, PS6_2_FN_EV,
	PS6_1_FN_AN, PS6_1_FN_EV,
	PS6_0_FN_AN, PS6_0_FN_EV,

	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/* PTA (mobule: LBSC, CPG, LPC) */
	BS_MARK,	RDWR_MARK,	WE1_MARK,	RDY_MARK,
	MD10_MARK,	MD9_MARK,	MD8_MARK,
	LGPIO7_MARK,	LGPIO6_MARK,	LGPIO5_MARK,	LGPIO4_MARK,
	LGPIO3_MARK,	LGPIO2_MARK,	LGPIO1_MARK,	LGPIO0_MARK,

	/* PTB (mobule: LBSC, EtherC, SIM, LPC) */
	D15_MARK,	D14_MARK,	D13_MARK,	D12_MARK,
	D11_MARK,	D10_MARK,	D9_MARK,	D8_MARK,
	ET0_MDC_MARK,	ET0_MDIO_MARK,	ET1_MDC_MARK,	ET1_MDIO_MARK,
	SIM_D_MARK,	SIM_CLK_MARK,	SIM_RST_MARK,
	WPSZ1_MARK,	WPSZ0_MARK,	FWID_MARK,	FLSHSZ_MARK,
	LPC_SPIEN_MARK,	BASEL_MARK,

	/* PTC (mobule: SD) */
	SD_WP_MARK,	SD_CD_MARK,	SD_CLK_MARK,	SD_CMD_MARK,
	SD_D3_MARK,	SD_D2_MARK,	SD_D1_MARK,	SD_D0_MARK,

	/* PTD (mobule: INTC, SPI0, LBSC, CPG, ADC) */
	IRQ7_MARK,	IRQ6_MARK,	IRQ5_MARK,	IRQ4_MARK,
	IRQ3_MARK,	IRQ2_MARK,	IRQ1_MARK,	IRQ0_MARK,
	MD6_MARK,	MD5_MARK,	MD3_MARK,	MD2_MARK,
	MD1_MARK,	MD0_MARK,	ADTRG1_MARK,	ADTRG0_MARK,

	/* PTE (mobule: EtherC) */
	ET0_CRS_DV_MARK,	ET0_TXD1_MARK,
	ET0_TXD0_MARK,		ET0_TX_EN_MARK,
	ET0_REF_CLK_MARK,	ET0_RXD1_MARK,
	ET0_RXD0_MARK,		ET0_RX_ER_MARK,

	/* PTF (mobule: EtherC) */
	ET1_CRS_DV_MARK,	ET1_TXD1_MARK,
	ET1_TXD0_MARK,		ET1_TX_EN_MARK,
	ET1_REF_CLK_MARK,	ET1_RXD1_MARK,
	ET1_RXD0_MARK,		ET1_RX_ER_MARK,

	/* PTG (mobule: SYSTEM, PWMX, LPC) */
	STATUS0_MARK,	STATUS1_MARK,
	PWX0_MARK,	PWX1_MARK,	PWX2_MARK,	PWX3_MARK,
	SERIRQ_MARK,	CLKRUN_MARK,	LPCPD_MARK,	LDRQ_MARK,

	/* PTH (mobule: TMU, SCIF234, SPI1, SPI0) */
	TCLK_MARK,	RXD4_MARK,	TXD4_MARK,
	SP1_MOSI_MARK,	SP1_MISO_MARK,	SP1_SCK_MARK,	SP1_SCK_FB_MARK,
	SP1_SS0_MARK,	SP1_SS1_MARK,	SP0_SS1_MARK,

	/* PTI (mobule: INTC) */
	IRQ15_MARK,	IRQ14_MARK,	IRQ13_MARK,	IRQ12_MARK,
	IRQ11_MARK,	IRQ10_MARK,	IRQ9_MARK,	IRQ8_MARK,

	/* PTJ (mobule: SCIF234, SERMUX) */
	RXD3_MARK,	TXD3_MARK,	RXD2_MARK,	TXD2_MARK,
	COM1_TXD_MARK,	COM1_RXD_MARK,	COM1_RTS_MARK,	COM1_CTS_MARK,

	/* PTK (mobule: SERMUX) */
	COM2_TXD_MARK,	COM2_RXD_MARK,	COM2_RTS_MARK,	COM2_CTS_MARK,
	COM2_DTR_MARK,	COM2_DSR_MARK,	COM2_DCD_MARK,	COM2_RI_MARK,

	/* PTL (mobule: SERMUX) */
	RAC_TXD_MARK,	RAC_RXD_MARK,	RAC_RTS_MARK,	RAC_CTS_MARK,
	RAC_DTR_MARK,	RAC_DSR_MARK,	RAC_DCD_MARK,	RAC_RI_MARK,

	/* PTM (mobule: IIC, LPC) */
	SDA6_MARK,	SCL6_MARK,	SDA7_MARK,	SCL7_MARK,
	WP_MARK,	FMS0_MARK,	FMS1_MARK,

	/* PTN (mobule: SCIF234, EVC) */
	SCK2_MARK,	RTS4_MARK,	RTS3_MARK,	RTS2_MARK,
	CTS4_MARK,	CTS3_MARK,	CTS2_MARK,
	EVENT7_MARK,	EVENT6_MARK,	EVENT5_MARK,	EVENT4_MARK,
	EVENT3_MARK,	EVENT2_MARK,	EVENT1_MARK,	EVENT0_MARK,

	/* PTO (mobule: SGPIO) */
	SGPIO0_CLK_MARK,	SGPIO0_LOAD_MARK,
	SGPIO0_DI_MARK,		SGPIO0_DO_MARK,
	SGPIO1_CLK_MARK,	SGPIO1_LOAD_MARK,
	SGPIO1_DI_MARK,		SGPIO1_DO_MARK,

	/* PTP (mobule: JMC, SCIF234) */
	JMCTCK_MARK,	JMCTMS_MARK,	JMCTDO_MARK,	JMCTDI_MARK,
	JMCRST_MARK,	SCK4_MARK,	SCK3_MARK,

	/* PTQ (mobule: LPC) */
	LAD3_MARK,	LAD2_MARK,	LAD1_MARK,	LAD0_MARK,
	LFRAME_MARK,	LRESET_MARK,	LCLK_MARK,

	/* PTR (mobule: GRA, IIC) */
	DDC3_MARK,	DDC2_MARK,
	SDA8_MARK,	SCL8_MARK,	SDA2_MARK,	SCL2_MARK,
	SDA1_MARK,	SCL1_MARK,	SDA0_MARK,	SCL0_MARK,

	/* PTS (mobule: GRA, IIC) */
	DDC1_MARK,	DDC0_MARK,
	SDA9_MARK,	SCL9_MARK,	SDA5_MARK,	SCL5_MARK,
	SDA4_MARK,	SCL4_MARK,	SDA3_MARK,	SCL3_MARK,

	/* PTT (mobule: SYSTEM, PWMX) */
	AUDSYNC_MARK,		AUDCK_MARK,
	AUDATA3_MARK,		AUDATA2_MARK,
	AUDATA1_MARK,		AUDATA0_MARK,
	PWX7_MARK,	PWX6_MARK,	PWX5_MARK,	PWX4_MARK,

	/* PTU (mobule: LBSC, DMAC) */
	CS6_MARK,	CS5_MARK,	CS4_MARK,	CS0_MARK,
	RD_MARK,	WE0_MARK,	A25_MARK,	A24_MARK,
	DREQ0_MARK,	DACK0_MARK,

	/* PTV (mobule: LBSC, DMAC) */
	A23_MARK,	A22_MARK,	A21_MARK,	A20_MARK,
	A19_MARK,	A18_MARK,	A17_MARK,	A16_MARK,
	TEND0_MARK,	DREQ1_MARK,	DACK1_MARK,	TEND1_MARK,

	/* PTW (mobule: LBSC) */
	A15_MARK,	A14_MARK,	A13_MARK,	A12_MARK,
	A11_MARK,	A10_MARK,	A9_MARK,	A8_MARK,

	/* PTX (mobule: LBSC) */
	A7_MARK,	A6_MARK,	A5_MARK,	A4_MARK,
	A3_MARK,	A2_MARK,	A1_MARK,	A0_MARK,

	/* PTY (mobule: LBSC) */
	D7_MARK,	D6_MARK,	D5_MARK,	D4_MARK,
	D3_MARK,	D2_MARK,	D1_MARK,	D0_MARK,
	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {
	/* PTA GPIO */
	PINMUX_DATA(PTA7_DATA, PTA7_IN, PTA7_OUT),
	PINMUX_DATA(PTA6_DATA, PTA6_IN, PTA6_OUT),
	PINMUX_DATA(PTA5_DATA, PTA5_IN, PTA5_OUT),
	PINMUX_DATA(PTA4_DATA, PTA4_IN, PTA4_OUT),
	PINMUX_DATA(PTA3_DATA, PTA3_IN, PTA3_OUT),
	PINMUX_DATA(PTA2_DATA, PTA2_IN, PTA2_OUT),
	PINMUX_DATA(PTA1_DATA, PTA1_IN, PTA1_OUT),
	PINMUX_DATA(PTA0_DATA, PTA0_IN, PTA0_OUT),

	/* PTB GPIO */
	PINMUX_DATA(PTB7_DATA, PTB7_IN, PTB7_OUT),
	PINMUX_DATA(PTB6_DATA, PTB6_IN, PTB6_OUT),
	PINMUX_DATA(PTB5_DATA, PTB5_IN, PTB5_OUT),
	PINMUX_DATA(PTB4_DATA, PTB4_IN, PTB4_OUT),
	PINMUX_DATA(PTB3_DATA, PTB3_IN, PTB3_OUT),
	PINMUX_DATA(PTB2_DATA, PTB2_IN, PTB2_OUT),
	PINMUX_DATA(PTB1_DATA, PTB1_IN, PTB1_OUT),
	PINMUX_DATA(PTB0_DATA, PTB0_IN, PTB0_OUT),

	/* PTC GPIO */
	PINMUX_DATA(PTC7_DATA, PTC7_IN, PTC7_OUT),
	PINMUX_DATA(PTC6_DATA, PTC6_IN, PTC6_OUT),
	PINMUX_DATA(PTC5_DATA, PTC5_IN, PTC5_OUT),
	PINMUX_DATA(PTC4_DATA, PTC4_IN, PTC4_OUT),
	PINMUX_DATA(PTC3_DATA, PTC3_IN, PTC3_OUT),
	PINMUX_DATA(PTC2_DATA, PTC2_IN, PTC2_OUT),
	PINMUX_DATA(PTC1_DATA, PTC1_IN, PTC1_OUT),
	PINMUX_DATA(PTC0_DATA, PTC0_IN, PTC0_OUT),

	/* PTD GPIO */
	PINMUX_DATA(PTD7_DATA, PTD7_IN, PTD7_OUT),
	PINMUX_DATA(PTD6_DATA, PTD6_IN, PTD6_OUT),
	PINMUX_DATA(PTD5_DATA, PTD5_IN, PTD5_OUT),
	PINMUX_DATA(PTD4_DATA, PTD4_IN, PTD4_OUT),
	PINMUX_DATA(PTD3_DATA, PTD3_IN, PTD3_OUT),
	PINMUX_DATA(PTD2_DATA, PTD2_IN, PTD2_OUT),
	PINMUX_DATA(PTD1_DATA, PTD1_IN, PTD1_OUT),
	PINMUX_DATA(PTD0_DATA, PTD0_IN, PTD0_OUT),

	/* PTE GPIO */
	PINMUX_DATA(PTE5_DATA, PTE5_IN, PTE5_OUT),
	PINMUX_DATA(PTE4_DATA, PTE4_IN, PTE4_OUT),
	PINMUX_DATA(PTE3_DATA, PTE3_IN, PTE3_OUT),
	PINMUX_DATA(PTE2_DATA, PTE2_IN, PTE2_OUT),
	PINMUX_DATA(PTE1_DATA, PTE1_IN, PTE1_OUT),
	PINMUX_DATA(PTE0_DATA, PTE0_IN, PTE0_OUT),

	/* PTF GPIO */
	PINMUX_DATA(PTF7_DATA, PTF7_IN, PTF7_OUT),
	PINMUX_DATA(PTF6_DATA, PTF6_IN, PTF6_OUT),
	PINMUX_DATA(PTF5_DATA, PTF5_IN, PTF5_OUT),
	PINMUX_DATA(PTF4_DATA, PTF4_IN, PTF4_OUT),
	PINMUX_DATA(PTF3_DATA, PTF3_IN, PTF3_OUT),
	PINMUX_DATA(PTF2_DATA, PTF2_IN, PTF2_OUT),
	PINMUX_DATA(PTF1_DATA, PTF1_IN, PTF1_OUT),
	PINMUX_DATA(PTF0_DATA, PTF0_IN, PTF0_OUT),

	/* PTG GPIO */
	PINMUX_DATA(PTG7_DATA, PTG7_IN, PTG7_OUT),
	PINMUX_DATA(PTG6_DATA, PTG6_IN, PTG6_OUT),
	PINMUX_DATA(PTG5_DATA, PTG5_IN, PTG5_OUT),
	PINMUX_DATA(PTG4_DATA, PTG4_IN, PTG4_OUT),
	PINMUX_DATA(PTG3_DATA, PTG3_IN, PTG3_OUT),
	PINMUX_DATA(PTG2_DATA, PTG2_IN, PTG2_OUT),
	PINMUX_DATA(PTG1_DATA, PTG1_IN, PTG1_OUT),
	PINMUX_DATA(PTG0_DATA, PTG0_IN, PTG0_OUT),

	/* PTH GPIO */
	PINMUX_DATA(PTH7_DATA, PTH7_IN, PTH7_OUT),
	PINMUX_DATA(PTH6_DATA, PTH6_IN, PTH6_OUT),
	PINMUX_DATA(PTH5_DATA, PTH5_IN, PTH5_OUT),
	PINMUX_DATA(PTH4_DATA, PTH4_IN, PTH4_OUT),
	PINMUX_DATA(PTH3_DATA, PTH3_IN, PTH3_OUT),
	PINMUX_DATA(PTH2_DATA, PTH2_IN, PTH2_OUT),
	PINMUX_DATA(PTH1_DATA, PTH1_IN, PTH1_OUT),
	PINMUX_DATA(PTH0_DATA, PTH0_IN, PTH0_OUT),

	/* PTI GPIO */
	PINMUX_DATA(PTI7_DATA, PTI7_IN, PTI7_OUT),
	PINMUX_DATA(PTI6_DATA, PTI6_IN, PTI6_OUT),
	PINMUX_DATA(PTI5_DATA, PTI5_IN, PTI5_OUT),
	PINMUX_DATA(PTI4_DATA, PTI4_IN, PTI4_OUT),
	PINMUX_DATA(PTI3_DATA, PTI3_IN, PTI3_OUT),
	PINMUX_DATA(PTI2_DATA, PTI2_IN, PTI2_OUT),
	PINMUX_DATA(PTI1_DATA, PTI1_IN, PTI1_OUT),
	PINMUX_DATA(PTI0_DATA, PTI0_IN, PTI0_OUT),

	/* PTJ GPIO */
	PINMUX_DATA(PTJ7_DATA, PTJ7_IN, PTJ7_OUT),
	PINMUX_DATA(PTJ6_DATA, PTJ6_IN, PTJ6_OUT),
	PINMUX_DATA(PTJ5_DATA, PTJ5_IN, PTJ5_OUT),
	PINMUX_DATA(PTJ4_DATA, PTJ4_IN, PTJ4_OUT),
	PINMUX_DATA(PTJ3_DATA, PTJ3_IN, PTJ3_OUT),
	PINMUX_DATA(PTJ2_DATA, PTJ2_IN, PTJ2_OUT),
	PINMUX_DATA(PTJ1_DATA, PTJ1_IN, PTJ1_OUT),
	PINMUX_DATA(PTJ0_DATA, PTJ0_IN, PTJ0_OUT),

	/* PTK GPIO */
	PINMUX_DATA(PTK7_DATA, PTK7_IN, PTK7_OUT),
	PINMUX_DATA(PTK6_DATA, PTK6_IN, PTK6_OUT),
	PINMUX_DATA(PTK5_DATA, PTK5_IN, PTK5_OUT),
	PINMUX_DATA(PTK4_DATA, PTK4_IN, PTK4_OUT),
	PINMUX_DATA(PTK3_DATA, PTK3_IN, PTK3_OUT),
	PINMUX_DATA(PTK2_DATA, PTK2_IN, PTK2_OUT),
	PINMUX_DATA(PTK1_DATA, PTK1_IN, PTK1_OUT),
	PINMUX_DATA(PTK0_DATA, PTK0_IN, PTK0_OUT),

	/* PTL GPIO */
	PINMUX_DATA(PTL7_DATA, PTL7_IN, PTL7_OUT),
	PINMUX_DATA(PTL6_DATA, PTL6_IN, PTL6_OUT),
	PINMUX_DATA(PTL5_DATA, PTL5_IN, PTL5_OUT),
	PINMUX_DATA(PTL4_DATA, PTL4_IN, PTL4_OUT),
	PINMUX_DATA(PTL3_DATA, PTL3_IN, PTL3_OUT),
	PINMUX_DATA(PTL2_DATA, PTL2_IN, PTL2_OUT),
	PINMUX_DATA(PTL1_DATA, PTL1_IN, PTL1_OUT),
	PINMUX_DATA(PTL0_DATA, PTL0_IN, PTL0_OUT),

	/* PTM GPIO */
	PINMUX_DATA(PTM6_DATA, PTM6_IN, PTM6_OUT),
	PINMUX_DATA(PTM5_DATA, PTM5_IN, PTM5_OUT),
	PINMUX_DATA(PTM4_DATA, PTM4_IN, PTM4_OUT),
	PINMUX_DATA(PTM3_DATA, PTM3_IN, PTM3_OUT),
	PINMUX_DATA(PTM2_DATA, PTM2_IN, PTM2_OUT),
	PINMUX_DATA(PTM1_DATA, PTM1_IN, PTM1_OUT),
	PINMUX_DATA(PTM0_DATA, PTM0_IN, PTM0_OUT),

	/* PTN GPIO */
	PINMUX_DATA(PTN7_DATA, PTN7_IN, PTN7_OUT),
	PINMUX_DATA(PTN6_DATA, PTN6_IN, PTN6_OUT),
	PINMUX_DATA(PTN5_DATA, PTN5_IN, PTN5_OUT),
	PINMUX_DATA(PTN4_DATA, PTN4_IN, PTN4_OUT),
	PINMUX_DATA(PTN3_DATA, PTN3_IN, PTN3_OUT),
	PINMUX_DATA(PTN2_DATA, PTN2_IN, PTN2_OUT),
	PINMUX_DATA(PTN1_DATA, PTN1_IN, PTN1_OUT),
	PINMUX_DATA(PTN0_DATA, PTN0_IN, PTN0_OUT),

	/* PTO GPIO */
	PINMUX_DATA(PTO7_DATA, PTO7_IN, PTO7_OUT),
	PINMUX_DATA(PTO6_DATA, PTO6_IN, PTO6_OUT),
	PINMUX_DATA(PTO5_DATA, PTO5_IN, PTO5_OUT),
	PINMUX_DATA(PTO4_DATA, PTO4_IN, PTO4_OUT),
	PINMUX_DATA(PTO3_DATA, PTO3_IN, PTO3_OUT),
	PINMUX_DATA(PTO2_DATA, PTO2_IN, PTO2_OUT),
	PINMUX_DATA(PTO1_DATA, PTO1_IN, PTO1_OUT),
	PINMUX_DATA(PTO0_DATA, PTO0_IN, PTO0_OUT),

	/* PTQ GPIO */
	PINMUX_DATA(PTQ6_DATA, PTQ6_IN, PTQ6_OUT),
	PINMUX_DATA(PTQ5_DATA, PTQ5_IN, PTQ5_OUT),
	PINMUX_DATA(PTQ4_DATA, PTQ4_IN, PTQ4_OUT),
	PINMUX_DATA(PTQ3_DATA, PTQ3_IN, PTQ3_OUT),
	PINMUX_DATA(PTQ2_DATA, PTQ2_IN, PTQ2_OUT),
	PINMUX_DATA(PTQ1_DATA, PTQ1_IN, PTQ1_OUT),
	PINMUX_DATA(PTQ0_DATA, PTQ0_IN, PTQ0_OUT),

	/* PTR GPIO */
	PINMUX_DATA(PTR7_DATA, PTR7_IN, PTR7_OUT),
	PINMUX_DATA(PTR6_DATA, PTR6_IN, PTR6_OUT),
	PINMUX_DATA(PTR5_DATA, PTR5_IN, PTR5_OUT),
	PINMUX_DATA(PTR4_DATA, PTR4_IN, PTR4_OUT),
	PINMUX_DATA(PTR3_DATA, PTR3_IN, PTR3_OUT),
	PINMUX_DATA(PTR2_DATA, PTR2_IN, PTR2_OUT),
	PINMUX_DATA(PTR1_DATA, PTR1_IN, PTR1_OUT),
	PINMUX_DATA(PTR0_DATA, PTR0_IN, PTR0_OUT),

	/* PTS GPIO */
	PINMUX_DATA(PTS7_DATA, PTS7_IN, PTS7_OUT),
	PINMUX_DATA(PTS6_DATA, PTS6_IN, PTS6_OUT),
	PINMUX_DATA(PTS5_DATA, PTS5_IN, PTS5_OUT),
	PINMUX_DATA(PTS4_DATA, PTS4_IN, PTS4_OUT),
	PINMUX_DATA(PTS3_DATA, PTS3_IN, PTS3_OUT),
	PINMUX_DATA(PTS2_DATA, PTS2_IN, PTS2_OUT),
	PINMUX_DATA(PTS1_DATA, PTS1_IN, PTS1_OUT),
	PINMUX_DATA(PTS0_DATA, PTS0_IN, PTS0_OUT),

	/* PTT GPIO */
	PINMUX_DATA(PTT5_DATA, PTT5_IN, PTT5_OUT),
	PINMUX_DATA(PTT4_DATA, PTT4_IN, PTT4_OUT),
	PINMUX_DATA(PTT3_DATA, PTT3_IN, PTT3_OUT),
	PINMUX_DATA(PTT2_DATA, PTT2_IN, PTT2_OUT),
	PINMUX_DATA(PTT1_DATA, PTT1_IN, PTT1_OUT),
	PINMUX_DATA(PTT0_DATA, PTT0_IN, PTT0_OUT),

	/* PTU GPIO */
	PINMUX_DATA(PTU7_DATA, PTU7_IN, PTU7_OUT),
	PINMUX_DATA(PTU6_DATA, PTU6_IN, PTU6_OUT),
	PINMUX_DATA(PTU5_DATA, PTU5_IN, PTU5_OUT),
	PINMUX_DATA(PTU4_DATA, PTU4_IN, PTU4_OUT),
	PINMUX_DATA(PTU3_DATA, PTU3_IN, PTU3_OUT),
	PINMUX_DATA(PTU2_DATA, PTU2_IN, PTU2_OUT),
	PINMUX_DATA(PTU1_DATA, PTU1_IN, PTU1_OUT),
	PINMUX_DATA(PTU0_DATA, PTU0_IN, PTU0_OUT),

	/* PTV GPIO */
	PINMUX_DATA(PTV7_DATA, PTV7_IN, PTV7_OUT),
	PINMUX_DATA(PTV6_DATA, PTV6_IN, PTV6_OUT),
	PINMUX_DATA(PTV5_DATA, PTV5_IN, PTV5_OUT),
	PINMUX_DATA(PTV4_DATA, PTV4_IN, PTV4_OUT),
	PINMUX_DATA(PTV3_DATA, PTV3_IN, PTV3_OUT),
	PINMUX_DATA(PTV2_DATA, PTV2_IN, PTV2_OUT),
	PINMUX_DATA(PTV1_DATA, PTV1_IN, PTV1_OUT),
	PINMUX_DATA(PTV0_DATA, PTV0_IN, PTV0_OUT),

	/* PTW GPIO */
	PINMUX_DATA(PTW7_DATA, PTW7_IN, PTW7_OUT),
	PINMUX_DATA(PTW6_DATA, PTW6_IN, PTW6_OUT),
	PINMUX_DATA(PTW5_DATA, PTW5_IN, PTW5_OUT),
	PINMUX_DATA(PTW4_DATA, PTW4_IN, PTW4_OUT),
	PINMUX_DATA(PTW3_DATA, PTW3_IN, PTW3_OUT),
	PINMUX_DATA(PTW2_DATA, PTW2_IN, PTW2_OUT),
	PINMUX_DATA(PTW1_DATA, PTW1_IN, PTW1_OUT),
	PINMUX_DATA(PTW0_DATA, PTW0_IN, PTW0_OUT),

	/* PTX GPIO */
	PINMUX_DATA(PTX7_DATA, PTX7_IN, PTX7_OUT),
	PINMUX_DATA(PTX6_DATA, PTX6_IN, PTX6_OUT),
	PINMUX_DATA(PTX5_DATA, PTX5_IN, PTX5_OUT),
	PINMUX_DATA(PTX4_DATA, PTX4_IN, PTX4_OUT),
	PINMUX_DATA(PTX3_DATA, PTX3_IN, PTX3_OUT),
	PINMUX_DATA(PTX2_DATA, PTX2_IN, PTX2_OUT),
	PINMUX_DATA(PTX1_DATA, PTX1_IN, PTX1_OUT),
	PINMUX_DATA(PTX0_DATA, PTX0_IN, PTX0_OUT),

	/* PTY GPIO */
	PINMUX_DATA(PTY7_DATA, PTY7_IN, PTY7_OUT),
	PINMUX_DATA(PTY6_DATA, PTY6_IN, PTY6_OUT),
	PINMUX_DATA(PTY5_DATA, PTY5_IN, PTY5_OUT),
	PINMUX_DATA(PTY4_DATA, PTY4_IN, PTY4_OUT),
	PINMUX_DATA(PTY3_DATA, PTY3_IN, PTY3_OUT),
	PINMUX_DATA(PTY2_DATA, PTY2_IN, PTY2_OUT),
	PINMUX_DATA(PTY1_DATA, PTY1_IN, PTY1_OUT),
	PINMUX_DATA(PTY0_DATA, PTY0_IN, PTY0_OUT),

	/* PTZ GPIO */
	PINMUX_DATA(PTZ7_DATA, PTZ7_IN, PTZ7_OUT),
	PINMUX_DATA(PTZ6_DATA, PTZ6_IN, PTZ6_OUT),
	PINMUX_DATA(PTZ5_DATA, PTZ5_IN, PTZ5_OUT),
	PINMUX_DATA(PTZ4_DATA, PTZ4_IN, PTZ4_OUT),
	PINMUX_DATA(PTZ3_DATA, PTZ3_IN, PTZ3_OUT),
	PINMUX_DATA(PTZ2_DATA, PTZ2_IN, PTZ2_OUT),
	PINMUX_DATA(PTZ1_DATA, PTZ1_IN, PTZ1_OUT),
	PINMUX_DATA(PTZ0_DATA, PTZ0_IN, PTZ0_OUT),

	/* PTA FN */
	PINMUX_DATA(BS_MARK, PS0_15_FN1, PTA7_FN),
	PINMUX_DATA(LGPIO7_MARK, PS0_15_FN3, PTA7_FN),
	PINMUX_DATA(RDWR_MARK, PS0_14_FN1, PTA6_FN),
	PINMUX_DATA(LGPIO6_MARK, PS0_14_FN3, PTA6_FN),
	PINMUX_DATA(WE1_MARK, PS0_13_FN1, PTA5_FN),
	PINMUX_DATA(LGPIO5_MARK, PS0_13_FN3, PTA5_FN),
	PINMUX_DATA(RDY_MARK, PS0_12_FN1, PTA4_FN),
	PINMUX_DATA(LGPIO4_MARK, PS0_12_FN3, PTA4_FN),
	PINMUX_DATA(LGPIO3_MARK, PTA3_FN),
	PINMUX_DATA(LGPIO2_MARK, PTA2_FN),
	PINMUX_DATA(LGPIO1_MARK, PTA1_FN),
	PINMUX_DATA(LGPIO0_MARK, PTA0_FN),

	/* PTB FN */
	PINMUX_DATA(D15_MARK, PS0_7_FN1, PTB7_FN),
	PINMUX_DATA(ET0_MDC_MARK, PS0_7_FN2, PTB7_FN),
	PINMUX_DATA(D14_MARK, PS0_6_FN1, PTB6_FN),
	PINMUX_DATA(ET0_MDIO_MARK, PS0_6_FN2, PTB6_FN),
	PINMUX_DATA(D13_MARK, PS0_5_FN1, PTB5_FN),
	PINMUX_DATA(ET1_MDC_MARK, PS0_5_FN2, PTB5_FN),
	PINMUX_DATA(D12_MARK, PS0_4_FN1, PTB4_FN),
	PINMUX_DATA(ET1_MDIO_MARK, PS0_4_FN2, PTB4_FN),
	PINMUX_DATA(D11_MARK, PS0_3_FN1, PTB3_FN),
	PINMUX_DATA(SIM_D_MARK, PS0_3_FN2, PTB3_FN),
	PINMUX_DATA(D10_MARK, PS0_2_FN1, PTB2_FN),
	PINMUX_DATA(SIM_CLK_MARK, PS0_2_FN2, PTB2_FN),
	PINMUX_DATA(D9_MARK, PS0_1_FN1, PTB1_FN),
	PINMUX_DATA(SIM_RST_MARK, PS0_1_FN2, PTB1_FN),
	PINMUX_DATA(D8_MARK, PTB0_FN),

	/* PTC FN */
	PINMUX_DATA(SD_WP_MARK, PTC7_FN),
	PINMUX_DATA(SD_CD_MARK, PTC6_FN),
	PINMUX_DATA(SD_CLK_MARK, PTC5_FN),
	PINMUX_DATA(SD_CMD_MARK, PTC4_FN),
	PINMUX_DATA(SD_D3_MARK, PTC3_FN),
	PINMUX_DATA(SD_D2_MARK, PTC2_FN),
	PINMUX_DATA(SD_D1_MARK, PTC1_FN),
	PINMUX_DATA(SD_D0_MARK, PTC0_FN),

	/* PTD FN */
	PINMUX_DATA(IRQ7_MARK, PS1_7_FN1, PTD7_FN),
	PINMUX_DATA(ADTRG1_MARK, PS1_7_FN3, PTD7_FN),
	PINMUX_DATA(IRQ6_MARK, PS1_6_FN1, PTD6_FN),
	PINMUX_DATA(ADTRG0_MARK, PS1_6_FN3, PTD6_FN),
	PINMUX_DATA(IRQ5_MARK, PTD5_FN),
	PINMUX_DATA(IRQ4_MARK, PTD4_FN),
	PINMUX_DATA(IRQ3_MARK, PTD3_FN),
	PINMUX_DATA(IRQ2_MARK, PTD2_FN),
	PINMUX_DATA(IRQ1_MARK, PTD1_FN),
	PINMUX_DATA(IRQ0_MARK, PTD0_FN),

	/* PTE FN */
	PINMUX_DATA(ET0_CRS_DV_MARK, PTE7_FN),
	PINMUX_DATA(ET0_TXD1_MARK, PTE6_FN),
	PINMUX_DATA(ET0_TXD0_MARK, PTE5_FN),
	PINMUX_DATA(ET0_TX_EN_MARK, PTE4_FN),
	PINMUX_DATA(ET0_REF_CLK_MARK, PTE3_FN),
	PINMUX_DATA(ET0_RXD1_MARK, PTE2_FN),
	PINMUX_DATA(ET0_RXD0_MARK, PTE1_FN),
	PINMUX_DATA(ET0_RX_ER_MARK, PTE0_FN),

	/* PTF FN */
	PINMUX_DATA(ET1_CRS_DV_MARK, PTF7_FN),
	PINMUX_DATA(ET1_TXD1_MARK, PTF6_FN),
	PINMUX_DATA(ET1_TXD0_MARK, PTF5_FN),
	PINMUX_DATA(ET1_TX_EN_MARK, PTF4_FN),
	PINMUX_DATA(ET1_REF_CLK_MARK, PTF3_FN),
	PINMUX_DATA(ET1_RXD1_MARK, PTF2_FN),
	PINMUX_DATA(ET1_RXD0_MARK, PTF1_FN),
	PINMUX_DATA(ET1_RX_ER_MARK, PTF0_FN),

	/* PTG FN */
	PINMUX_DATA(PWX0_MARK, PTG7_FN),
	PINMUX_DATA(PWX1_MARK, PTG6_FN),
	PINMUX_DATA(STATUS0_MARK, PS2_13_FN1, PTG5_FN),
	PINMUX_DATA(PWX2_MARK, PS2_13_FN3, PTG5_FN),
	PINMUX_DATA(STATUS1_MARK, PS2_12_FN1, PTG4_FN),
	PINMUX_DATA(PWX3_MARK, PS2_12_FN3, PTG4_FN),
	PINMUX_DATA(SERIRQ_MARK, PTG3_FN),
	PINMUX_DATA(CLKRUN_MARK, PTG2_FN),
	PINMUX_DATA(LPCPD_MARK, PTG1_FN),
	PINMUX_DATA(LDRQ_MARK, PTG0_FN),

	/* PTH FN */
	PINMUX_DATA(SP1_MOSI_MARK, PTH7_FN),
	PINMUX_DATA(SP1_MISO_MARK, PTH6_FN),
	PINMUX_DATA(SP1_SCK_MARK, PTH5_FN),
	PINMUX_DATA(SP1_SCK_FB_MARK, PTH4_FN),
	PINMUX_DATA(SP1_SS0_MARK, PTH3_FN),
	PINMUX_DATA(TCLK_MARK, PTH2_FN),
	PINMUX_DATA(RXD4_MARK, PS2_1_FN1, PTH1_FN),
	PINMUX_DATA(SP1_SS1_MARK, PS2_1_FN2, PTH1_FN),
	PINMUX_DATA(TXD4_MARK, PS2_0_FN1, PTH0_FN),
	PINMUX_DATA(SP0_SS1_MARK, PS2_0_FN2, PTH0_FN),

	/* PTI FN */
	PINMUX_DATA(IRQ15_MARK, PTI7_FN),
	PINMUX_DATA(IRQ14_MARK, PTI6_FN),
	PINMUX_DATA(IRQ13_MARK, PTI5_FN),
	PINMUX_DATA(IRQ12_MARK, PTI4_FN),
	PINMUX_DATA(IRQ11_MARK, PTI3_FN),
	PINMUX_DATA(IRQ10_MARK, PTI2_FN),
	PINMUX_DATA(IRQ9_MARK, PTI1_FN),
	PINMUX_DATA(IRQ8_MARK, PTI0_FN),

	/* PTJ FN */
	PINMUX_DATA(RXD3_MARK, PTJ7_FN),
	PINMUX_DATA(TXD3_MARK, PTJ6_FN),
	PINMUX_DATA(RXD2_MARK, PTJ5_FN),
	PINMUX_DATA(TXD2_MARK, PTJ4_FN),
	PINMUX_DATA(COM1_TXD_MARK, PTJ3_FN),
	PINMUX_DATA(COM1_RXD_MARK, PTJ2_FN),
	PINMUX_DATA(COM1_RTS_MARK, PTJ1_FN),
	PINMUX_DATA(COM1_CTS_MARK, PTJ0_FN),

	/* PTK FN */
	PINMUX_DATA(COM2_TXD_MARK, PTK7_FN),
	PINMUX_DATA(COM2_RXD_MARK, PTK6_FN),
	PINMUX_DATA(COM2_RTS_MARK, PTK5_FN),
	PINMUX_DATA(COM2_CTS_MARK, PTK4_FN),
	PINMUX_DATA(COM2_DTR_MARK, PTK3_FN),
	PINMUX_DATA(COM2_DSR_MARK, PTK2_FN),
	PINMUX_DATA(COM2_DCD_MARK, PTK1_FN),
	PINMUX_DATA(COM2_RI_MARK, PTK0_FN),

	/* PTL FN */
	PINMUX_DATA(RAC_TXD_MARK, PTL7_FN),
	PINMUX_DATA(RAC_RXD_MARK, PTL6_FN),
	PINMUX_DATA(RAC_RTS_MARK, PTL5_FN),
	PINMUX_DATA(RAC_CTS_MARK, PTL4_FN),
	PINMUX_DATA(RAC_DTR_MARK, PTL3_FN),
	PINMUX_DATA(RAC_DSR_MARK, PTL2_FN),
	PINMUX_DATA(RAC_DCD_MARK, PTL1_FN),
	PINMUX_DATA(RAC_RI_MARK, PTL0_FN),

	/* PTM FN */
	PINMUX_DATA(WP_MARK, PTM6_FN),
	PINMUX_DATA(FMS0_MARK, PTM5_FN),
	PINMUX_DATA(FMS1_MARK, PTM4_FN),
	PINMUX_DATA(SDA6_MARK, PTM3_FN),
	PINMUX_DATA(SCL6_MARK, PTM2_FN),
	PINMUX_DATA(SDA7_MARK, PTM1_FN),
	PINMUX_DATA(SCL7_MARK, PTM0_FN),

	/* PTN FN */
	PINMUX_DATA(SCK2_MARK, PS4_15_FN1, PTN7_FN),
	PINMUX_DATA(EVENT7_MARK, PS4_15_FN2, PTN7_FN),
	PINMUX_DATA(RTS4_MARK, PS4_14_FN1, PTN6_FN),
	PINMUX_DATA(EVENT6_MARK, PS4_14_FN2, PTN6_FN),
	PINMUX_DATA(RTS3_MARK, PS4_13_FN1, PTN5_FN),
	PINMUX_DATA(EVENT5_MARK, PS4_13_FN2, PTN5_FN),
	PINMUX_DATA(RTS2_MARK, PS4_12_FN1, PTN4_FN),
	PINMUX_DATA(EVENT4_MARK, PS4_12_FN2, PTN4_FN),
	PINMUX_DATA(CTS4_MARK, PS4_11_FN1, PTN3_FN),
	PINMUX_DATA(EVENT3_MARK, PS4_11_FN2, PTN3_FN),
	PINMUX_DATA(CTS3_MARK, PS4_10_FN1, PTN2_FN),
	PINMUX_DATA(EVENT2_MARK, PS4_10_FN2, PTN2_FN),
	PINMUX_DATA(CTS2_MARK, PS4_9_FN1, PTN1_FN),
	PINMUX_DATA(EVENT1_MARK, PS4_9_FN2, PTN1_FN),
	PINMUX_DATA(EVENT0_MARK, PTN0_FN),

	/* PTO FN */
	PINMUX_DATA(SGPIO0_CLK_MARK, PTO7_FN),
	PINMUX_DATA(SGPIO0_LOAD_MARK, PTO6_FN),
	PINMUX_DATA(SGPIO0_DI_MARK, PTO5_FN),
	PINMUX_DATA(SGPIO0_DO_MARK, PTO4_FN),
	PINMUX_DATA(SGPIO1_CLK_MARK, PTO3_FN),
	PINMUX_DATA(SGPIO1_LOAD_MARK, PTO2_FN),
	PINMUX_DATA(SGPIO1_DI_MARK, PTO1_FN),
	PINMUX_DATA(SGPIO1_DO_MARK, PTO0_FN),

	/* PTP FN */
	PINMUX_DATA(JMCTCK_MARK, PTP6_FN),
	PINMUX_DATA(JMCTMS_MARK, PTP5_FN),
	PINMUX_DATA(JMCTDO_MARK, PTP4_FN),
	PINMUX_DATA(JMCTDI_MARK, PTP3_FN),
	PINMUX_DATA(JMCRST_MARK, PTP2_FN),
	PINMUX_DATA(SCK4_MARK, PTP1_FN),
	PINMUX_DATA(SCK3_MARK, PTP0_FN),

	/* PTQ FN */
	PINMUX_DATA(LAD3_MARK, PTQ6_FN),
	PINMUX_DATA(LAD2_MARK, PTQ5_FN),
	PINMUX_DATA(LAD1_MARK, PTQ4_FN),
	PINMUX_DATA(LAD0_MARK, PTQ3_FN),
	PINMUX_DATA(LFRAME_MARK, PTQ2_FN),
	PINMUX_DATA(SCK4_MARK, PTQ1_FN),
	PINMUX_DATA(SCK3_MARK, PTQ0_FN),

	/* PTR FN */
	PINMUX_DATA(SDA8_MARK, PTR7_FN),	/* DDC3? */
	PINMUX_DATA(SCL8_MARK, PTR6_FN),	/* DDC2? */
	PINMUX_DATA(SDA2_MARK, PTR5_FN),
	PINMUX_DATA(SCL2_MARK, PTR4_FN),
	PINMUX_DATA(SDA1_MARK, PTR3_FN),
	PINMUX_DATA(SCL1_MARK, PTR2_FN),
	PINMUX_DATA(SDA0_MARK, PTR1_FN),
	PINMUX_DATA(SCL0_MARK, PTR0_FN),

	/* PTS FN */
	PINMUX_DATA(SDA9_MARK, PTS7_FN),	/* DDC1? */
	PINMUX_DATA(SCL9_MARK, PTS6_FN),	/* DDC0? */
	PINMUX_DATA(SDA5_MARK, PTS5_FN),
	PINMUX_DATA(SCL5_MARK, PTS4_FN),
	PINMUX_DATA(SDA4_MARK, PTS3_FN),
	PINMUX_DATA(SCL4_MARK, PTS2_FN),
	PINMUX_DATA(SDA3_MARK, PTS1_FN),
	PINMUX_DATA(SCL3_MARK, PTS0_FN),

	/* PTT FN */
	PINMUX_DATA(AUDSYNC_MARK, PTS5_FN),
	PINMUX_DATA(AUDCK_MARK, PTS4_FN),
	PINMUX_DATA(AUDATA3_MARK, PS4_3_FN1, PTS3_FN),
	PINMUX_DATA(PWX7_MARK, PS4_3_FN2, PTS3_FN),
	PINMUX_DATA(AUDATA2_MARK, PS4_2_FN1, PTS2_FN),
	PINMUX_DATA(PWX6_MARK, PS4_2_FN2, PTS2_FN),
	PINMUX_DATA(AUDATA1_MARK, PS4_1_FN1, PTS1_FN),
	PINMUX_DATA(PWX5_MARK, PS4_1_FN2, PTS1_FN),
	PINMUX_DATA(AUDATA0_MARK, PS4_0_FN1, PTS0_FN),
	PINMUX_DATA(PWX4_MARK, PS4_0_FN2, PTS0_FN),

	/* PTU FN */
	PINMUX_DATA(CS6_MARK, PTU7_FN),
	PINMUX_DATA(CS5_MARK, PTU6_FN),
	PINMUX_DATA(CS4_MARK, PTU5_FN),
	PINMUX_DATA(CS0_MARK, PTU4_FN),
	PINMUX_DATA(RD_MARK, PTU3_FN),
	PINMUX_DATA(WE0_MARK, PTU2_FN),
	PINMUX_DATA(A25_MARK, PS5_9_FN1, PTU1_FN),
	PINMUX_DATA(DREQ0_MARK, PS5_9_FN2, PTU1_FN),
	PINMUX_DATA(A24_MARK, PS5_8_FN1, PTU0_FN),
	PINMUX_DATA(DACK0_MARK, PS5_8_FN2, PTU0_FN),

	/* PTV FN */
	PINMUX_DATA(A23_MARK, PS5_7_FN1, PTV7_FN),
	PINMUX_DATA(TEND0_MARK, PS5_7_FN2, PTV7_FN),
	PINMUX_DATA(A22_MARK, PS5_6_FN1, PTV6_FN),
	PINMUX_DATA(DREQ1_MARK, PS5_6_FN2, PTV6_FN),
	PINMUX_DATA(A21_MARK, PS5_5_FN1, PTV5_FN),
	PINMUX_DATA(DACK1_MARK, PS5_5_FN2, PTV5_FN),
	PINMUX_DATA(A20_MARK, PS5_4_FN1, PTV4_FN),
	PINMUX_DATA(TEND1_MARK, PS5_4_FN2, PTV4_FN),
	PINMUX_DATA(A19_MARK, PTV3_FN),
	PINMUX_DATA(A18_MARK, PTV2_FN),
	PINMUX_DATA(A17_MARK, PTV1_FN),
	PINMUX_DATA(A16_MARK, PTV0_FN),

	/* PTW FN */
	PINMUX_DATA(A15_MARK, PTW7_FN),
	PINMUX_DATA(A14_MARK, PTW6_FN),
	PINMUX_DATA(A13_MARK, PTW5_FN),
	PINMUX_DATA(A12_MARK, PTW4_FN),
	PINMUX_DATA(A11_MARK, PTW3_FN),
	PINMUX_DATA(A10_MARK, PTW2_FN),
	PINMUX_DATA(A9_MARK, PTW1_FN),
	PINMUX_DATA(A8_MARK, PTW0_FN),

	/* PTX FN */
	PINMUX_DATA(A7_MARK, PTX7_FN),
	PINMUX_DATA(A6_MARK, PTX6_FN),
	PINMUX_DATA(A5_MARK, PTX5_FN),
	PINMUX_DATA(A4_MARK, PTX4_FN),
	PINMUX_DATA(A3_MARK, PTX3_FN),
	PINMUX_DATA(A2_MARK, PTX2_FN),
	PINMUX_DATA(A1_MARK, PTX1_FN),
	PINMUX_DATA(A0_MARK, PTX0_FN),

	/* PTY FN */
	PINMUX_DATA(D7_MARK, PTY7_FN),
	PINMUX_DATA(D6_MARK, PTY6_FN),
	PINMUX_DATA(D5_MARK, PTY5_FN),
	PINMUX_DATA(D4_MARK, PTY4_FN),
	PINMUX_DATA(D3_MARK, PTY3_FN),
	PINMUX_DATA(D2_MARK, PTY2_FN),
	PINMUX_DATA(D1_MARK, PTY1_FN),
	PINMUX_DATA(D0_MARK, PTY0_FN),
};

static struct pinmux_gpio pinmux_gpios[] = {
	/* PTA */
	PINMUX_GPIO(GPIO_PTA7, PTA7_DATA),
	PINMUX_GPIO(GPIO_PTA6, PTA6_DATA),
	PINMUX_GPIO(GPIO_PTA5, PTA5_DATA),
	PINMUX_GPIO(GPIO_PTA4, PTA4_DATA),
	PINMUX_GPIO(GPIO_PTA3, PTA3_DATA),
	PINMUX_GPIO(GPIO_PTA2, PTA2_DATA),
	PINMUX_GPIO(GPIO_PTA1, PTA1_DATA),
	PINMUX_GPIO(GPIO_PTA0, PTA0_DATA),

	/* PTB */
	PINMUX_GPIO(GPIO_PTB7, PTB7_DATA),
	PINMUX_GPIO(GPIO_PTB6, PTB6_DATA),
	PINMUX_GPIO(GPIO_PTB5, PTB5_DATA),
	PINMUX_GPIO(GPIO_PTB4, PTB4_DATA),
	PINMUX_GPIO(GPIO_PTB3, PTB3_DATA),
	PINMUX_GPIO(GPIO_PTB2, PTB2_DATA),
	PINMUX_GPIO(GPIO_PTB1, PTB1_DATA),
	PINMUX_GPIO(GPIO_PTB0, PTB0_DATA),

	/* PTC */
	PINMUX_GPIO(GPIO_PTC7, PTC7_DATA),
	PINMUX_GPIO(GPIO_PTC6, PTC6_DATA),
	PINMUX_GPIO(GPIO_PTC5, PTC5_DATA),
	PINMUX_GPIO(GPIO_PTC4, PTC4_DATA),
	PINMUX_GPIO(GPIO_PTC3, PTC3_DATA),
	PINMUX_GPIO(GPIO_PTC2, PTC2_DATA),
	PINMUX_GPIO(GPIO_PTC1, PTC1_DATA),
	PINMUX_GPIO(GPIO_PTC0, PTC0_DATA),

	/* PTD */
	PINMUX_GPIO(GPIO_PTD7, PTD7_DATA),
	PINMUX_GPIO(GPIO_PTD6, PTD6_DATA),
	PINMUX_GPIO(GPIO_PTD5, PTD5_DATA),
	PINMUX_GPIO(GPIO_PTD4, PTD4_DATA),
	PINMUX_GPIO(GPIO_PTD3, PTD3_DATA),
	PINMUX_GPIO(GPIO_PTD2, PTD2_DATA),
	PINMUX_GPIO(GPIO_PTD1, PTD1_DATA),
	PINMUX_GPIO(GPIO_PTD0, PTD0_DATA),

	/* PTE */
	PINMUX_GPIO(GPIO_PTE7, PTE7_DATA),
	PINMUX_GPIO(GPIO_PTE6, PTE6_DATA),
	PINMUX_GPIO(GPIO_PTE5, PTE5_DATA),
	PINMUX_GPIO(GPIO_PTE4, PTE4_DATA),
	PINMUX_GPIO(GPIO_PTE3, PTE3_DATA),
	PINMUX_GPIO(GPIO_PTE2, PTE2_DATA),
	PINMUX_GPIO(GPIO_PTE1, PTE1_DATA),
	PINMUX_GPIO(GPIO_PTE0, PTE0_DATA),

	/* PTF */
	PINMUX_GPIO(GPIO_PTF7, PTF7_DATA),
	PINMUX_GPIO(GPIO_PTF6, PTF6_DATA),
	PINMUX_GPIO(GPIO_PTF5, PTF5_DATA),
	PINMUX_GPIO(GPIO_PTF4, PTF4_DATA),
	PINMUX_GPIO(GPIO_PTF3, PTF3_DATA),
	PINMUX_GPIO(GPIO_PTF2, PTF2_DATA),
	PINMUX_GPIO(GPIO_PTF1, PTF1_DATA),
	PINMUX_GPIO(GPIO_PTF0, PTF0_DATA),

	/* PTG */
	PINMUX_GPIO(GPIO_PTG7, PTG7_DATA),
	PINMUX_GPIO(GPIO_PTG6, PTG6_DATA),
	PINMUX_GPIO(GPIO_PTG5, PTG5_DATA),
	PINMUX_GPIO(GPIO_PTG4, PTG4_DATA),
	PINMUX_GPIO(GPIO_PTG3, PTG3_DATA),
	PINMUX_GPIO(GPIO_PTG2, PTG2_DATA),
	PINMUX_GPIO(GPIO_PTG1, PTG1_DATA),
	PINMUX_GPIO(GPIO_PTG0, PTG0_DATA),

	/* PTH */
	PINMUX_GPIO(GPIO_PTH7, PTH7_DATA),
	PINMUX_GPIO(GPIO_PTH6, PTH6_DATA),
	PINMUX_GPIO(GPIO_PTH5, PTH5_DATA),
	PINMUX_GPIO(GPIO_PTH4, PTH4_DATA),
	PINMUX_GPIO(GPIO_PTH3, PTH3_DATA),
	PINMUX_GPIO(GPIO_PTH2, PTH2_DATA),
	PINMUX_GPIO(GPIO_PTH1, PTH1_DATA),
	PINMUX_GPIO(GPIO_PTH0, PTH0_DATA),

	/* PTI */
	PINMUX_GPIO(GPIO_PTI7, PTI7_DATA),
	PINMUX_GPIO(GPIO_PTI6, PTI6_DATA),
	PINMUX_GPIO(GPIO_PTI5, PTI5_DATA),
	PINMUX_GPIO(GPIO_PTI4, PTI4_DATA),
	PINMUX_GPIO(GPIO_PTI3, PTI3_DATA),
	PINMUX_GPIO(GPIO_PTI2, PTI2_DATA),
	PINMUX_GPIO(GPIO_PTI1, PTI1_DATA),
	PINMUX_GPIO(GPIO_PTI0, PTI0_DATA),

	/* PTJ */
	PINMUX_GPIO(GPIO_PTJ7, PTJ7_DATA),
	PINMUX_GPIO(GPIO_PTJ6, PTJ6_DATA),
	PINMUX_GPIO(GPIO_PTJ5, PTJ5_DATA),
	PINMUX_GPIO(GPIO_PTJ4, PTJ4_DATA),
	PINMUX_GPIO(GPIO_PTJ3, PTJ3_DATA),
	PINMUX_GPIO(GPIO_PTJ2, PTJ2_DATA),
	PINMUX_GPIO(GPIO_PTJ1, PTJ1_DATA),
	PINMUX_GPIO(GPIO_PTJ0, PTJ0_DATA),

	/* PTK */
	PINMUX_GPIO(GPIO_PTK7, PTK7_DATA),
	PINMUX_GPIO(GPIO_PTK6, PTK6_DATA),
	PINMUX_GPIO(GPIO_PTK5, PTK5_DATA),
	PINMUX_GPIO(GPIO_PTK4, PTK4_DATA),
	PINMUX_GPIO(GPIO_PTK3, PTK3_DATA),
	PINMUX_GPIO(GPIO_PTK2, PTK2_DATA),
	PINMUX_GPIO(GPIO_PTK1, PTK1_DATA),
	PINMUX_GPIO(GPIO_PTK0, PTK0_DATA),

	/* PTL */
	PINMUX_GPIO(GPIO_PTL7, PTL7_DATA),
	PINMUX_GPIO(GPIO_PTL6, PTL6_DATA),
	PINMUX_GPIO(GPIO_PTL5, PTL5_DATA),
	PINMUX_GPIO(GPIO_PTL4, PTL4_DATA),
	PINMUX_GPIO(GPIO_PTL3, PTL3_DATA),
	PINMUX_GPIO(GPIO_PTL2, PTL2_DATA),
	PINMUX_GPIO(GPIO_PTL1, PTL1_DATA),
	PINMUX_GPIO(GPIO_PTL0, PTL0_DATA),

	/* PTM */
	PINMUX_GPIO(GPIO_PTM6, PTM6_DATA),
	PINMUX_GPIO(GPIO_PTM5, PTM5_DATA),
	PINMUX_GPIO(GPIO_PTM4, PTM4_DATA),
	PINMUX_GPIO(GPIO_PTM3, PTM3_DATA),
	PINMUX_GPIO(GPIO_PTM2, PTM2_DATA),
	PINMUX_GPIO(GPIO_PTM1, PTM1_DATA),
	PINMUX_GPIO(GPIO_PTM0, PTM0_DATA),

	/* PTN */
	PINMUX_GPIO(GPIO_PTN7, PTN7_DATA),
	PINMUX_GPIO(GPIO_PTN6, PTN6_DATA),
	PINMUX_GPIO(GPIO_PTN5, PTN5_DATA),
	PINMUX_GPIO(GPIO_PTN4, PTN4_DATA),
	PINMUX_GPIO(GPIO_PTN3, PTN3_DATA),
	PINMUX_GPIO(GPIO_PTN2, PTN2_DATA),
	PINMUX_GPIO(GPIO_PTN1, PTN1_DATA),
	PINMUX_GPIO(GPIO_PTN0, PTN0_DATA),

	/* PTO */
	PINMUX_GPIO(GPIO_PTO7, PTO7_DATA),
	PINMUX_GPIO(GPIO_PTO6, PTO6_DATA),
	PINMUX_GPIO(GPIO_PTO5, PTO5_DATA),
	PINMUX_GPIO(GPIO_PTO4, PTO4_DATA),
	PINMUX_GPIO(GPIO_PTO3, PTO3_DATA),
	PINMUX_GPIO(GPIO_PTO2, PTO2_DATA),
	PINMUX_GPIO(GPIO_PTO1, PTO1_DATA),
	PINMUX_GPIO(GPIO_PTO0, PTO0_DATA),

	/* PTP */
	PINMUX_GPIO(GPIO_PTP6, PTP6_DATA),
	PINMUX_GPIO(GPIO_PTP5, PTP5_DATA),
	PINMUX_GPIO(GPIO_PTP4, PTP4_DATA),
	PINMUX_GPIO(GPIO_PTP3, PTP3_DATA),
	PINMUX_GPIO(GPIO_PTP2, PTP2_DATA),
	PINMUX_GPIO(GPIO_PTP1, PTP1_DATA),
	PINMUX_GPIO(GPIO_PTP0, PTP0_DATA),

	/* PTQ */
	PINMUX_GPIO(GPIO_PTQ6, PTQ6_DATA),
	PINMUX_GPIO(GPIO_PTQ5, PTQ5_DATA),
	PINMUX_GPIO(GPIO_PTQ4, PTQ4_DATA),
	PINMUX_GPIO(GPIO_PTQ3, PTQ3_DATA),
	PINMUX_GPIO(GPIO_PTQ2, PTQ2_DATA),
	PINMUX_GPIO(GPIO_PTQ1, PTQ1_DATA),
	PINMUX_GPIO(GPIO_PTQ0, PTQ0_DATA),

	/* PTR */
	PINMUX_GPIO(GPIO_PTR7, PTR7_DATA),
	PINMUX_GPIO(GPIO_PTR6, PTR6_DATA),
	PINMUX_GPIO(GPIO_PTR5, PTR5_DATA),
	PINMUX_GPIO(GPIO_PTR4, PTR4_DATA),
	PINMUX_GPIO(GPIO_PTR3, PTR3_DATA),
	PINMUX_GPIO(GPIO_PTR2, PTR2_DATA),
	PINMUX_GPIO(GPIO_PTR1, PTR1_DATA),
	PINMUX_GPIO(GPIO_PTR0, PTR0_DATA),

	/* PTS */
	PINMUX_GPIO(GPIO_PTS7, PTS7_DATA),
	PINMUX_GPIO(GPIO_PTS6, PTS6_DATA),
	PINMUX_GPIO(GPIO_PTS5, PTS5_DATA),
	PINMUX_GPIO(GPIO_PTS4, PTS4_DATA),
	PINMUX_GPIO(GPIO_PTS3, PTS3_DATA),
	PINMUX_GPIO(GPIO_PTS2, PTS2_DATA),
	PINMUX_GPIO(GPIO_PTS1, PTS1_DATA),
	PINMUX_GPIO(GPIO_PTS0, PTS0_DATA),

	/* PTT */
	PINMUX_GPIO(GPIO_PTT5, PTT5_DATA),
	PINMUX_GPIO(GPIO_PTT4, PTT4_DATA),
	PINMUX_GPIO(GPIO_PTT3, PTT3_DATA),
	PINMUX_GPIO(GPIO_PTT2, PTT2_DATA),
	PINMUX_GPIO(GPIO_PTT1, PTT1_DATA),
	PINMUX_GPIO(GPIO_PTT0, PTT0_DATA),

	/* PTU */
	PINMUX_GPIO(GPIO_PTU7, PTU7_DATA),
	PINMUX_GPIO(GPIO_PTU6, PTU6_DATA),
	PINMUX_GPIO(GPIO_PTU5, PTU5_DATA),
	PINMUX_GPIO(GPIO_PTU4, PTU4_DATA),
	PINMUX_GPIO(GPIO_PTU3, PTU3_DATA),
	PINMUX_GPIO(GPIO_PTU2, PTU2_DATA),
	PINMUX_GPIO(GPIO_PTU1, PTU1_DATA),
	PINMUX_GPIO(GPIO_PTU0, PTU0_DATA),

	/* PTV */
	PINMUX_GPIO(GPIO_PTV7, PTV7_DATA),
	PINMUX_GPIO(GPIO_PTV6, PTV6_DATA),
	PINMUX_GPIO(GPIO_PTV5, PTV5_DATA),
	PINMUX_GPIO(GPIO_PTV4, PTV4_DATA),
	PINMUX_GPIO(GPIO_PTV3, PTV3_DATA),
	PINMUX_GPIO(GPIO_PTV2, PTV2_DATA),
	PINMUX_GPIO(GPIO_PTV1, PTV1_DATA),
	PINMUX_GPIO(GPIO_PTV0, PTV0_DATA),

	/* PTW */
	PINMUX_GPIO(GPIO_PTW7, PTW7_DATA),
	PINMUX_GPIO(GPIO_PTW6, PTW6_DATA),
	PINMUX_GPIO(GPIO_PTW5, PTW5_DATA),
	PINMUX_GPIO(GPIO_PTW4, PTW4_DATA),
	PINMUX_GPIO(GPIO_PTW3, PTW3_DATA),
	PINMUX_GPIO(GPIO_PTW2, PTW2_DATA),
	PINMUX_GPIO(GPIO_PTW1, PTW1_DATA),
	PINMUX_GPIO(GPIO_PTW0, PTW0_DATA),

	/* PTX */
	PINMUX_GPIO(GPIO_PTX7, PTX7_DATA),
	PINMUX_GPIO(GPIO_PTX6, PTX6_DATA),
	PINMUX_GPIO(GPIO_PTX5, PTX5_DATA),
	PINMUX_GPIO(GPIO_PTX4, PTX4_DATA),
	PINMUX_GPIO(GPIO_PTX3, PTX3_DATA),
	PINMUX_GPIO(GPIO_PTX2, PTX2_DATA),
	PINMUX_GPIO(GPIO_PTX1, PTX1_DATA),
	PINMUX_GPIO(GPIO_PTX0, PTX0_DATA),

	/* PTY */
	PINMUX_GPIO(GPIO_PTY7, PTY7_DATA),
	PINMUX_GPIO(GPIO_PTY6, PTY6_DATA),
	PINMUX_GPIO(GPIO_PTY5, PTY5_DATA),
	PINMUX_GPIO(GPIO_PTY4, PTY4_DATA),
	PINMUX_GPIO(GPIO_PTY3, PTY3_DATA),
	PINMUX_GPIO(GPIO_PTY2, PTY2_DATA),
	PINMUX_GPIO(GPIO_PTY1, PTY1_DATA),
	PINMUX_GPIO(GPIO_PTY0, PTY0_DATA),

	/* PTZ */
	PINMUX_GPIO(GPIO_PTZ7, PTZ7_DATA),
	PINMUX_GPIO(GPIO_PTZ6, PTZ6_DATA),
	PINMUX_GPIO(GPIO_PTZ5, PTZ5_DATA),
	PINMUX_GPIO(GPIO_PTZ4, PTZ4_DATA),
	PINMUX_GPIO(GPIO_PTZ3, PTZ3_DATA),
	PINMUX_GPIO(GPIO_PTZ2, PTZ2_DATA),
	PINMUX_GPIO(GPIO_PTZ1, PTZ1_DATA),
	PINMUX_GPIO(GPIO_PTZ0, PTZ0_DATA),

	/* PTA (mobule: LBSC, CPG, LPC) */
	PINMUX_GPIO(GPIO_FN_BS, BS_MARK),
	PINMUX_GPIO(GPIO_FN_RDWR, RDWR_MARK),
	PINMUX_GPIO(GPIO_FN_WE1, WE1_MARK),
	PINMUX_GPIO(GPIO_FN_RDY, RDY_MARK),
	PINMUX_GPIO(GPIO_FN_MD10, MD10_MARK),
	PINMUX_GPIO(GPIO_FN_MD9, MD9_MARK),
	PINMUX_GPIO(GPIO_FN_MD8, MD8_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO7, LGPIO7_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO6, LGPIO6_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO5, LGPIO5_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO4, LGPIO4_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO3, LGPIO3_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO2, LGPIO2_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO1, LGPIO1_MARK),
	PINMUX_GPIO(GPIO_FN_LGPIO0, LGPIO0_MARK),

	/* PTB (mobule: LBSC, EtherC, SIM, LPC) */
	PINMUX_GPIO(GPIO_FN_D15, D15_MARK),
	PINMUX_GPIO(GPIO_FN_D14, D14_MARK),
	PINMUX_GPIO(GPIO_FN_D13, D13_MARK),
	PINMUX_GPIO(GPIO_FN_D12, D12_MARK),
	PINMUX_GPIO(GPIO_FN_D11, D11_MARK),
	PINMUX_GPIO(GPIO_FN_D10, D10_MARK),
	PINMUX_GPIO(GPIO_FN_D9, D9_MARK),
	PINMUX_GPIO(GPIO_FN_D8, D8_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_MDC, ET0_MDC_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_MDIO, ET0_MDIO_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_MDC, ET1_MDC_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_MDIO, ET1_MDIO_MARK),
	PINMUX_GPIO(GPIO_FN_WPSZ1, WPSZ1_MARK),
	PINMUX_GPIO(GPIO_FN_WPSZ0, WPSZ0_MARK),
	PINMUX_GPIO(GPIO_FN_FWID, FWID_MARK),
	PINMUX_GPIO(GPIO_FN_FLSHSZ, FLSHSZ_MARK),
	PINMUX_GPIO(GPIO_FN_LPC_SPIEN, LPC_SPIEN_MARK),
	PINMUX_GPIO(GPIO_FN_BASEL, BASEL_MARK),

	/* PTC (mobule: SD) */
	PINMUX_GPIO(GPIO_FN_SD_WP, SD_WP_MARK),
	PINMUX_GPIO(GPIO_FN_SD_CD, SD_CD_MARK),
	PINMUX_GPIO(GPIO_FN_SD_CLK, SD_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_SD_CMD, SD_CMD_MARK),
	PINMUX_GPIO(GPIO_FN_SD_D3, SD_D3_MARK),
	PINMUX_GPIO(GPIO_FN_SD_D2, SD_D2_MARK),
	PINMUX_GPIO(GPIO_FN_SD_D1, SD_D1_MARK),
	PINMUX_GPIO(GPIO_FN_SD_D0, SD_D0_MARK),

	/* PTD (mobule: INTC, SPI0, LBSC, CPG, ADC) */
	PINMUX_GPIO(GPIO_FN_IRQ7, IRQ7_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6, IRQ6_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5, IRQ5_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4, IRQ4_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3, IRQ3_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2, IRQ2_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1, IRQ1_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0, IRQ0_MARK),
	PINMUX_GPIO(GPIO_FN_MD6, MD6_MARK),
	PINMUX_GPIO(GPIO_FN_MD5, MD5_MARK),
	PINMUX_GPIO(GPIO_FN_MD3, MD3_MARK),
	PINMUX_GPIO(GPIO_FN_MD2, MD2_MARK),
	PINMUX_GPIO(GPIO_FN_MD1, MD1_MARK),
	PINMUX_GPIO(GPIO_FN_MD0, MD0_MARK),
	PINMUX_GPIO(GPIO_FN_ADTRG1, ADTRG1_MARK),
	PINMUX_GPIO(GPIO_FN_ADTRG0, ADTRG0_MARK),

	/* PTE (mobule: EtherC) */
	PINMUX_GPIO(GPIO_FN_ET0_CRS_DV, ET0_CRS_DV_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_TXD1, ET0_TXD1_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_TXD0, ET0_TXD0_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_TX_EN, ET0_TX_EN_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_REF_CLK, ET0_REF_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_RXD1, ET0_RXD1_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_RXD0, ET0_RXD0_MARK),
	PINMUX_GPIO(GPIO_FN_ET0_RX_ER, ET0_RX_ER_MARK),

	/* PTF (mobule: EtherC) */
	PINMUX_GPIO(GPIO_FN_ET1_CRS_DV, ET1_CRS_DV_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_TXD1, ET1_TXD1_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_TXD0, ET1_TXD0_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_TX_EN, ET1_TX_EN_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_REF_CLK, ET1_REF_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_RXD1, ET1_RXD1_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_RXD0, ET1_RXD0_MARK),
	PINMUX_GPIO(GPIO_FN_ET1_RX_ER, ET1_RX_ER_MARK),

	/* PTG (mobule: SYSTEM, PWMX, LPC) */
	PINMUX_GPIO(GPIO_FN_STATUS0, STATUS0_MARK),
	PINMUX_GPIO(GPIO_FN_STATUS1, STATUS1_MARK),
	PINMUX_GPIO(GPIO_FN_PWX0, PWX0_MARK),
	PINMUX_GPIO(GPIO_FN_PWX1, PWX1_MARK),
	PINMUX_GPIO(GPIO_FN_PWX2, PWX2_MARK),
	PINMUX_GPIO(GPIO_FN_PWX3, PWX3_MARK),
	PINMUX_GPIO(GPIO_FN_SERIRQ, SERIRQ_MARK),
	PINMUX_GPIO(GPIO_FN_CLKRUN, CLKRUN_MARK),
	PINMUX_GPIO(GPIO_FN_LPCPD, LPCPD_MARK),
	PINMUX_GPIO(GPIO_FN_LDRQ, LDRQ_MARK),

	/* PTH (mobule: TMU, SCIF234, SPI1, SPI0) */
	PINMUX_GPIO(GPIO_FN_TCLK, TCLK_MARK),
	PINMUX_GPIO(GPIO_FN_RXD4, RXD4_MARK),
	PINMUX_GPIO(GPIO_FN_TXD4, TXD4_MARK),
	PINMUX_GPIO(GPIO_FN_SP1_MOSI, SP1_MOSI_MARK),
	PINMUX_GPIO(GPIO_FN_SP1_MISO, SP1_MISO_MARK),
	PINMUX_GPIO(GPIO_FN_SP1_SCK, SP1_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SP1_SCK_FB, SP1_SCK_FB_MARK),
	PINMUX_GPIO(GPIO_FN_SP1_SS0, SP1_SS0_MARK),
	PINMUX_GPIO(GPIO_FN_SP1_SS1, SP1_SS1_MARK),
	PINMUX_GPIO(GPIO_FN_SP0_SS1, SP0_SS1_MARK),

	/* PTI (mobule: INTC) */
	PINMUX_GPIO(GPIO_FN_IRQ15, IRQ15_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ14, IRQ14_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ13, IRQ13_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ12, IRQ12_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ11, IRQ11_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ10, IRQ10_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ9, IRQ9_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ8, IRQ8_MARK),

	/* PTJ (mobule: SCIF234, SERMUX) */
	PINMUX_GPIO(GPIO_FN_RXD3, RXD3_MARK),
	PINMUX_GPIO(GPIO_FN_TXD3, TXD3_MARK),
	PINMUX_GPIO(GPIO_FN_RXD2, RXD2_MARK),
	PINMUX_GPIO(GPIO_FN_TXD2, TXD2_MARK),
	PINMUX_GPIO(GPIO_FN_COM1_TXD, COM1_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_COM1_RXD, COM1_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_COM1_RTS, COM1_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_COM1_CTS, COM1_CTS_MARK),

	/* PTK (mobule: SERMUX) */
	PINMUX_GPIO(GPIO_FN_COM2_TXD, COM2_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_RXD, COM2_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_RTS, COM2_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_CTS, COM2_CTS_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_DTR, COM2_DTR_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_DSR, COM2_DSR_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_DCD, COM2_DCD_MARK),
	PINMUX_GPIO(GPIO_FN_COM2_RI, COM2_RI_MARK),

	/* PTL (mobule: SERMUX) */
	PINMUX_GPIO(GPIO_FN_RAC_TXD, RAC_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_RXD, RAC_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_RTS, RAC_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_CTS, RAC_CTS_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_DTR, RAC_DTR_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_DSR, RAC_DSR_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_DCD, RAC_DCD_MARK),
	PINMUX_GPIO(GPIO_FN_RAC_RI, RAC_RI_MARK),

	/* PTM (mobule: IIC, LPC) */
	PINMUX_GPIO(GPIO_FN_SDA6, SDA6_MARK),
	PINMUX_GPIO(GPIO_FN_SCL6, SCL6_MARK),
	PINMUX_GPIO(GPIO_FN_SDA7, SDA7_MARK),
	PINMUX_GPIO(GPIO_FN_SCL7, SCL7_MARK),
	PINMUX_GPIO(GPIO_FN_WP, WP_MARK),
	PINMUX_GPIO(GPIO_FN_FMS0, FMS0_MARK),
	PINMUX_GPIO(GPIO_FN_FMS1, FMS1_MARK),

	/* PTN (mobule: SCIF234, EVC) */
	PINMUX_GPIO(GPIO_FN_SCK2, SCK2_MARK),
	PINMUX_GPIO(GPIO_FN_RTS4, RTS4_MARK),
	PINMUX_GPIO(GPIO_FN_RTS3, RTS3_MARK),
	PINMUX_GPIO(GPIO_FN_RTS2, RTS2_MARK),
	PINMUX_GPIO(GPIO_FN_CTS4, CTS4_MARK),
	PINMUX_GPIO(GPIO_FN_CTS3, CTS3_MARK),
	PINMUX_GPIO(GPIO_FN_CTS2, CTS2_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT7, EVENT7_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT6, EVENT6_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT5, EVENT5_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT4, EVENT4_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT3, EVENT3_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT2, EVENT2_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT1, EVENT1_MARK),
	PINMUX_GPIO(GPIO_FN_EVENT0, EVENT0_MARK),

	/* PTO (mobule: SGPIO) */
	PINMUX_GPIO(GPIO_FN_SGPIO0_CLK, SGPIO0_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO0_LOAD, SGPIO0_LOAD_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO0_DI, SGPIO0_DI_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO0_DO, SGPIO0_DO_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO1_CLK, SGPIO1_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO1_LOAD, SGPIO1_LOAD_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO1_DI, SGPIO1_DI_MARK),
	PINMUX_GPIO(GPIO_FN_SGPIO1_DO, SGPIO1_DO_MARK),

	/* PTP (mobule: JMC, SCIF234) */
	PINMUX_GPIO(GPIO_FN_JMCTCK, JMCTCK_MARK),
	PINMUX_GPIO(GPIO_FN_JMCTMS, JMCTMS_MARK),
	PINMUX_GPIO(GPIO_FN_JMCTDO, JMCTDO_MARK),
	PINMUX_GPIO(GPIO_FN_JMCTDI, JMCTDI_MARK),
	PINMUX_GPIO(GPIO_FN_JMCRST, JMCRST_MARK),
	PINMUX_GPIO(GPIO_FN_SCK4, SCK4_MARK),
	PINMUX_GPIO(GPIO_FN_SCK3, SCK3_MARK),

	/* PTQ (mobule: LPC) */
	PINMUX_GPIO(GPIO_FN_LAD3, LAD3_MARK),
	PINMUX_GPIO(GPIO_FN_LAD2, LAD2_MARK),
	PINMUX_GPIO(GPIO_FN_LAD1, LAD1_MARK),
	PINMUX_GPIO(GPIO_FN_LAD0, LAD0_MARK),
	PINMUX_GPIO(GPIO_FN_LFRAME, LFRAME_MARK),
	PINMUX_GPIO(GPIO_FN_LRESET, LRESET_MARK),
	PINMUX_GPIO(GPIO_FN_LCLK, LCLK_MARK),

	/* PTR (mobule: GRA, IIC) */
	PINMUX_GPIO(GPIO_FN_DDC3, DDC3_MARK),
	PINMUX_GPIO(GPIO_FN_DDC2, DDC2_MARK),
	PINMUX_GPIO(GPIO_FN_SDA8, SDA8_MARK),
	PINMUX_GPIO(GPIO_FN_SCL8, SCL8_MARK),
	PINMUX_GPIO(GPIO_FN_SDA2, SDA2_MARK),
	PINMUX_GPIO(GPIO_FN_SCL2, SCL2_MARK),
	PINMUX_GPIO(GPIO_FN_SDA1, SDA1_MARK),
	PINMUX_GPIO(GPIO_FN_SCL1, SCL1_MARK),
	PINMUX_GPIO(GPIO_FN_SDA0, SDA0_MARK),
	PINMUX_GPIO(GPIO_FN_SCL0, SCL0_MARK),

	/* PTS (mobule: GRA, IIC) */
	PINMUX_GPIO(GPIO_FN_DDC1, DDC1_MARK),
	PINMUX_GPIO(GPIO_FN_DDC0, DDC0_MARK),
	PINMUX_GPIO(GPIO_FN_SDA9, SDA9_MARK),
	PINMUX_GPIO(GPIO_FN_SCL9, SCL9_MARK),
	PINMUX_GPIO(GPIO_FN_SDA5, SDA5_MARK),
	PINMUX_GPIO(GPIO_FN_SCL5, SCL5_MARK),
	PINMUX_GPIO(GPIO_FN_SDA4, SDA4_MARK),
	PINMUX_GPIO(GPIO_FN_SCL4, SCL4_MARK),
	PINMUX_GPIO(GPIO_FN_SDA3, SDA3_MARK),
	PINMUX_GPIO(GPIO_FN_SCL3, SCL3_MARK),

	/* PTT (mobule: SYSTEM, PWMX) */
	PINMUX_GPIO(GPIO_FN_AUDSYNC, AUDSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_AUDCK, AUDCK_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA3, AUDATA3_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA2, AUDATA2_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA1, AUDATA1_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA0, AUDATA0_MARK),
	PINMUX_GPIO(GPIO_FN_PWX7, PWX7_MARK),
	PINMUX_GPIO(GPIO_FN_PWX6, PWX6_MARK),
	PINMUX_GPIO(GPIO_FN_PWX5, PWX5_MARK),
	PINMUX_GPIO(GPIO_FN_PWX4, PWX4_MARK),

	/* PTU (mobule: LBSC, DMAC) */
	PINMUX_GPIO(GPIO_FN_CS6, CS6_MARK),
	PINMUX_GPIO(GPIO_FN_CS5, CS5_MARK),
	PINMUX_GPIO(GPIO_FN_CS4, CS4_MARK),
	PINMUX_GPIO(GPIO_FN_CS0, CS0_MARK),
	PINMUX_GPIO(GPIO_FN_RD, RD_MARK),
	PINMUX_GPIO(GPIO_FN_WE0, WE0_MARK),
	PINMUX_GPIO(GPIO_FN_A25, A25_MARK),
	PINMUX_GPIO(GPIO_FN_A24, A24_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ0, DREQ0_MARK),
	PINMUX_GPIO(GPIO_FN_DACK0, DACK0_MARK),

	/* PTV (mobule: LBSC, DMAC) */
	PINMUX_GPIO(GPIO_FN_A23, A23_MARK),
	PINMUX_GPIO(GPIO_FN_A22, A22_MARK),
	PINMUX_GPIO(GPIO_FN_A21, A21_MARK),
	PINMUX_GPIO(GPIO_FN_A20, A20_MARK),
	PINMUX_GPIO(GPIO_FN_A19, A19_MARK),
	PINMUX_GPIO(GPIO_FN_A18, A18_MARK),
	PINMUX_GPIO(GPIO_FN_A17, A17_MARK),
	PINMUX_GPIO(GPIO_FN_A16, A16_MARK),
	PINMUX_GPIO(GPIO_FN_TEND0, TEND0_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ1, DREQ1_MARK),
	PINMUX_GPIO(GPIO_FN_DACK1, DACK1_MARK),
	PINMUX_GPIO(GPIO_FN_TEND1, TEND1_MARK),

	/* PTW (mobule: LBSC) */
	PINMUX_GPIO(GPIO_FN_A16, A16_MARK),
	PINMUX_GPIO(GPIO_FN_A15, A15_MARK),
	PINMUX_GPIO(GPIO_FN_A14, A14_MARK),
	PINMUX_GPIO(GPIO_FN_A13, A13_MARK),
	PINMUX_GPIO(GPIO_FN_A12, A12_MARK),
	PINMUX_GPIO(GPIO_FN_A11, A11_MARK),
	PINMUX_GPIO(GPIO_FN_A10, A10_MARK),
	PINMUX_GPIO(GPIO_FN_A9, A9_MARK),
	PINMUX_GPIO(GPIO_FN_A8, A8_MARK),

	/* PTX (mobule: LBSC) */
	PINMUX_GPIO(GPIO_FN_A7, A7_MARK),
	PINMUX_GPIO(GPIO_FN_A6, A6_MARK),
	PINMUX_GPIO(GPIO_FN_A5, A5_MARK),
	PINMUX_GPIO(GPIO_FN_A4, A4_MARK),
	PINMUX_GPIO(GPIO_FN_A3, A3_MARK),
	PINMUX_GPIO(GPIO_FN_A2, A2_MARK),
	PINMUX_GPIO(GPIO_FN_A1, A1_MARK),
	PINMUX_GPIO(GPIO_FN_A0, A0_MARK),

	/* PTY (mobule: LBSC) */
	PINMUX_GPIO(GPIO_FN_D7, D7_MARK),
	PINMUX_GPIO(GPIO_FN_D6, D6_MARK),
	PINMUX_GPIO(GPIO_FN_D5, D5_MARK),
	PINMUX_GPIO(GPIO_FN_D4, D4_MARK),
	PINMUX_GPIO(GPIO_FN_D3, D3_MARK),
	PINMUX_GPIO(GPIO_FN_D2, D2_MARK),
	PINMUX_GPIO(GPIO_FN_D1, D1_MARK),
	PINMUX_GPIO(GPIO_FN_D0, D0_MARK),
 };

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PACR", 0xffec0000, 16, 2) {
		PTA7_FN, PTA7_OUT, PTA7_IN, 0,
		PTA6_FN, PTA6_OUT, PTA6_IN, 0,
		PTA5_FN, PTA5_OUT, PTA5_IN, 0,
		PTA4_FN, PTA4_OUT, PTA4_IN, 0,
		PTA3_FN, PTA3_OUT, PTA3_IN, 0,
		PTA2_FN, PTA2_OUT, PTA2_IN, 0,
		PTA1_FN, PTA1_OUT, PTA1_IN, 0,
		PTA0_FN, PTA0_OUT, PTA0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PBCR", 0xffec0002, 16, 2) {
		PTB7_FN, PTB7_OUT, PTB7_IN, 0,
		PTB6_FN, PTB6_OUT, PTB6_IN, 0,
		PTB5_FN, PTB5_OUT, PTB5_IN, 0,
		PTB4_FN, PTB4_OUT, PTB4_IN, 0,
		PTB3_FN, PTB3_OUT, PTB3_IN, 0,
		PTB2_FN, PTB2_OUT, PTB2_IN, 0,
		PTB1_FN, PTB1_OUT, PTB1_IN, 0,
		PTB0_FN, PTB0_OUT, PTB0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PCCR", 0xffec0004, 16, 2) {
		PTC7_FN, PTC7_OUT, PTC7_IN, 0,
		PTC6_FN, PTC6_OUT, PTC6_IN, 0,
		PTC5_FN, PTC5_OUT, PTC5_IN, 0,
		PTC4_FN, PTC4_OUT, PTC4_IN, 0,
		PTC3_FN, PTC3_OUT, PTC3_IN, 0,
		PTC2_FN, PTC2_OUT, PTC2_IN, 0,
		PTC1_FN, PTC1_OUT, PTC1_IN, 0,
		PTC0_FN, PTC0_OUT, PTC0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PDCR", 0xffec0006, 16, 2) {
		PTD7_FN, PTD7_OUT, PTD7_IN, 0,
		PTD6_FN, PTD6_OUT, PTD6_IN, 0,
		PTD5_FN, PTD5_OUT, PTD5_IN, 0,
		PTD4_FN, PTD4_OUT, PTD4_IN, 0,
		PTD3_FN, PTD3_OUT, PTD3_IN, 0,
		PTD2_FN, PTD2_OUT, PTD2_IN, 0,
		PTD1_FN, PTD1_OUT, PTD1_IN, 0,
		PTD0_FN, PTD0_OUT, PTD0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PECR", 0xffec0008, 16, 2) {
		PTE7_FN, PTE7_OUT, PTE7_IN, 0,
		PTE6_FN, PTE6_OUT, PTE6_IN, 0,
		PTE5_FN, PTE5_OUT, PTE5_IN, 0,
		PTE4_FN, PTE4_OUT, PTE4_IN, 0,
		PTE3_FN, PTE3_OUT, PTE3_IN, 0,
		PTE2_FN, PTE2_OUT, PTE2_IN, 0,
		PTE1_FN, PTE1_OUT, PTE1_IN, 0,
		PTE0_FN, PTE0_OUT, PTE0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PFCR", 0xffec000a, 16, 2) {
		PTF7_FN, PTF7_OUT, PTF7_IN, 0,
		PTF6_FN, PTF6_OUT, PTF6_IN, 0,
		PTF5_FN, PTF5_OUT, PTF5_IN, 0,
		PTF4_FN, PTF4_OUT, PTF4_IN, 0,
		PTF3_FN, PTF3_OUT, PTF3_IN, 0,
		PTF2_FN, PTF2_OUT, PTF2_IN, 0,
		PTF1_FN, PTF1_OUT, PTF1_IN, 0,
		PTF0_FN, PTF0_OUT, PTF0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PGCR", 0xffec000c, 16, 2) {
		PTG7_FN, PTG7_OUT, PTG7_IN, 0,
		PTG6_FN, PTG6_OUT, PTG6_IN, 0,
		PTG5_FN, PTG5_OUT, PTG5_IN, 0,
		PTG4_FN, PTG4_OUT, PTG4_IN, 0,
		PTG3_FN, PTG3_OUT, PTG3_IN, 0,
		PTG2_FN, PTG2_OUT, PTG2_IN, 0,
		PTG1_FN, PTG1_OUT, PTG1_IN, 0,
		PTG0_FN, PTG0_OUT, PTG0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PHCR", 0xffec000e, 16, 2) {
		PTH7_FN, PTH7_OUT, PTH7_IN, 0,
		PTH6_FN, PTH6_OUT, PTH6_IN, 0,
		PTH5_FN, PTH5_OUT, PTH5_IN, 0,
		PTH4_FN, PTH4_OUT, PTH4_IN, 0,
		PTH3_FN, PTH3_OUT, PTH3_IN, 0,
		PTH2_FN, PTH2_OUT, PTH2_IN, 0,
		PTH1_FN, PTH1_OUT, PTH1_IN, 0,
		PTH0_FN, PTH0_OUT, PTH0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PICR", 0xffec0010, 16, 2) {
		PTI7_FN, PTI7_OUT, PTI7_IN, 0,
		PTI6_FN, PTI6_OUT, PTI6_IN, 0,
		PTI5_FN, PTI5_OUT, PTI5_IN, 0,
		PTI4_FN, PTI4_OUT, PTI4_IN, 0,
		PTI3_FN, PTI3_OUT, PTI3_IN, 0,
		PTI2_FN, PTI2_OUT, PTI2_IN, 0,
		PTI1_FN, PTI1_OUT, PTI1_IN, 0,
		PTI0_FN, PTI0_OUT, PTI0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PJCR", 0xffec0012, 16, 2) {
		PTJ7_FN, PTJ7_OUT, PTJ7_IN, 0,
		PTJ6_FN, PTJ6_OUT, PTJ6_IN, 0,
		PTJ5_FN, PTJ5_OUT, PTJ5_IN, 0,
		PTJ4_FN, PTJ4_OUT, PTJ4_IN, 0,
		PTJ3_FN, PTJ3_OUT, PTJ3_IN, 0,
		PTJ2_FN, PTJ2_OUT, PTJ2_IN, 0,
		PTJ1_FN, PTJ1_OUT, PTJ1_IN, 0,
		PTJ0_FN, PTJ0_OUT, PTJ0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PKCR", 0xffec0014, 16, 2) {
		PTK7_FN, PTK7_OUT, PTK7_IN, 0,
		PTK6_FN, PTK6_OUT, PTK6_IN, 0,
		PTK5_FN, PTK5_OUT, PTK5_IN, 0,
		PTK4_FN, PTK4_OUT, PTK4_IN, 0,
		PTK3_FN, PTK3_OUT, PTK3_IN, 0,
		PTK2_FN, PTK2_OUT, PTK2_IN, 0,
		PTK1_FN, PTK1_OUT, PTK1_IN, 0,
		PTK0_FN, PTK0_OUT, PTK0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PLCR", 0xffec0016, 16, 2) {
		PTL7_FN, PTL7_OUT, PTL7_IN, 0,
		PTL6_FN, PTL6_OUT, PTL6_IN, 0,
		PTL5_FN, PTL5_OUT, PTL5_IN, 0,
		PTL4_FN, PTL4_OUT, PTL4_IN, 0,
		PTL3_FN, PTL3_OUT, PTL3_IN, 0,
		PTL2_FN, PTL2_OUT, PTL2_IN, 0,
		PTL1_FN, PTL1_OUT, PTL1_IN, 0,
		PTL0_FN, PTL0_OUT, PTL0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PMCR", 0xffec0018, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTM6_FN, PTM6_OUT, PTM6_IN, 0,
		PTM5_FN, PTM5_OUT, PTM5_IN, 0,
		PTM4_FN, PTM4_OUT, PTM4_IN, 0,
		PTM3_FN, PTM3_OUT, PTM3_IN, 0,
		PTM2_FN, PTM2_OUT, PTM2_IN, 0,
		PTM1_FN, PTM1_OUT, PTM1_IN, 0,
		PTM0_FN, PTM0_OUT, PTM0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PNCR", 0xffec001a, 16, 2) {
		PTN7_FN, PTN7_OUT, PTN7_IN, 0,
		PTN6_FN, PTN6_OUT, PTN6_IN, 0,
		PTN5_FN, PTN5_OUT, PTN5_IN, 0,
		PTN4_FN, PTN4_OUT, PTN4_IN, 0,
		PTN3_FN, PTN3_OUT, PTN3_IN, 0,
		PTN2_FN, PTN2_OUT, PTN2_IN, 0,
		PTN1_FN, PTN1_OUT, PTN1_IN, 0,
		PTN0_FN, PTN0_OUT, PTN0_IN, 0 }
	},
	{ PINMUX_CFG_REG("POCR", 0xffec001c, 16, 2) {
		PTO7_FN, PTO7_OUT, PTO7_IN, 0,
		PTO6_FN, PTO6_OUT, PTO6_IN, 0,
		PTO5_FN, PTO5_OUT, PTO5_IN, 0,
		PTO4_FN, PTO4_OUT, PTO4_IN, 0,
		PTO3_FN, PTO3_OUT, PTO3_IN, 0,
		PTO2_FN, PTO2_OUT, PTO2_IN, 0,
		PTO1_FN, PTO1_OUT, PTO1_IN, 0,
		PTO0_FN, PTO0_OUT, PTO0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PPCR", 0xffec001e, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTP6_FN, PTP6_OUT, PTP6_IN, 0,
		PTP5_FN, PTP5_OUT, PTP5_IN, 0,
		PTP4_FN, PTP4_OUT, PTP4_IN, 0,
		PTP3_FN, PTP3_OUT, PTP3_IN, 0,
		PTP2_FN, PTP2_OUT, PTP2_IN, 0,
		PTP1_FN, PTP1_OUT, PTP1_IN, 0,
		PTP0_FN, PTP0_OUT, PTP0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PQCR", 0xffec0020, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTQ6_FN, PTQ6_OUT, PTQ6_IN, 0,
		PTQ5_FN, PTQ5_OUT, PTQ5_IN, 0,
		PTQ4_FN, PTQ4_OUT, PTQ4_IN, 0,
		PTQ3_FN, PTQ3_OUT, PTQ3_IN, 0,
		PTQ2_FN, PTQ2_OUT, PTQ2_IN, 0,
		PTQ1_FN, PTQ1_OUT, PTQ1_IN, 0,
		PTQ0_FN, PTQ0_OUT, PTQ0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PRCR", 0xffec0022, 16, 2) {
		PTR7_FN, PTR7_OUT, PTR7_IN, 0,
		PTR6_FN, PTR6_OUT, PTR6_IN, 0,
		PTR5_FN, PTR5_OUT, PTR5_IN, 0,
		PTR4_FN, PTR4_OUT, PTR4_IN, 0,
		PTR3_FN, PTR3_OUT, PTR3_IN, 0,
		PTR2_FN, PTR2_OUT, PTR2_IN, 0,
		PTR1_FN, PTR1_OUT, PTR1_IN, 0,
		PTR0_FN, PTR0_OUT, PTR0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PSCR", 0xffec0024, 16, 2) {
		PTS7_FN, PTS7_OUT, PTS7_IN, 0,
		PTS6_FN, PTS6_OUT, PTS6_IN, 0,
		PTS5_FN, PTS5_OUT, PTS5_IN, 0,
		PTS4_FN, PTS4_OUT, PTS4_IN, 0,
		PTS3_FN, PTS3_OUT, PTS3_IN, 0,
		PTS2_FN, PTS2_OUT, PTS2_IN, 0,
		PTS1_FN, PTS1_OUT, PTS1_IN, 0,
		PTS0_FN, PTS0_OUT, PTS0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PTCR", 0xffec0026, 16, 2) {
		0, 0, 0, 0,	/* reserved: always set 1 */
		0, 0, 0, 0,	/* reserved: always set 1 */
		PTT5_FN, PTT5_OUT, PTT5_IN, 0,
		PTT4_FN, PTT4_OUT, PTT4_IN, 0,
		PTT3_FN, PTT3_OUT, PTT3_IN, 0,
		PTT2_FN, PTT2_OUT, PTT2_IN, 0,
		PTT1_FN, PTT1_OUT, PTT1_IN, 0,
		PTT0_FN, PTT0_OUT, PTT0_IN, 0 }
	},
	{ PINMUX_CFG_REG("PUCR", 0xffec0028, 16, 2) {
		PTU7_FN, PTU7_OUT, PTU7_IN, PTU7_IN_PU,
		PTU6_FN, PTU6_OUT, PTU6_IN, PTU6_IN_PU,
		PTU5_FN, PTU5_OUT, PTU5_IN, PTU5_IN_PU,
		PTU4_FN, PTU4_OUT, PTU4_IN, PTU4_IN_PU,
		PTU3_FN, PTU3_OUT, PTU3_IN, PTU3_IN_PU,
		PTU2_FN, PTU2_OUT, PTU2_IN, PTU2_IN_PU,
		PTU1_FN, PTU1_OUT, PTU1_IN, PTU1_IN_PU,
		PTU0_FN, PTU0_OUT, PTU0_IN, PTU0_IN_PU }
	},
	{ PINMUX_CFG_REG("PVCR", 0xffec002a, 16, 2) {
		PTV7_FN, PTV7_OUT, PTV7_IN, PTV7_IN_PU,
		PTV6_FN, PTV6_OUT, PTV6_IN, PTV6_IN_PU,
		PTV5_FN, PTV5_OUT, PTV5_IN, PTV5_IN_PU,
		PTV4_FN, PTV4_OUT, PTV4_IN, PTV4_IN_PU,
		PTV3_FN, PTV3_OUT, PTV3_IN, PTV3_IN_PU,
		PTV2_FN, PTV2_OUT, PTV2_IN, PTV2_IN_PU,
		PTV1_FN, PTV1_OUT, PTV1_IN, PTV1_IN_PU,
		PTV0_FN, PTV0_OUT, PTV0_IN, PTV0_IN_PU }
	},
	{ PINMUX_CFG_REG("PWCR", 0xffec002c, 16, 2) {
		PTW7_FN, PTW7_OUT, PTW7_IN, PTW7_IN_PU,
		PTW6_FN, PTW6_OUT, PTW6_IN, PTW6_IN_PU,
		PTW5_FN, PTW5_OUT, PTW5_IN, PTW5_IN_PU,
		PTW4_FN, PTW4_OUT, PTW4_IN, PTW4_IN_PU,
		PTW3_FN, PTW3_OUT, PTW3_IN, PTW3_IN_PU,
		PTW2_FN, PTW2_OUT, PTW2_IN, PTW2_IN_PU,
		PTW1_FN, PTW1_OUT, PTW1_IN, PTW1_IN_PU,
		PTW0_FN, PTW0_OUT, PTW0_IN, PTW0_IN_PU }
	},
	{ PINMUX_CFG_REG("PXCR", 0xffec002e, 16, 2) {
		PTX7_FN, PTX7_OUT, PTX7_IN, PTX7_IN_PU,
		PTX6_FN, PTX6_OUT, PTX6_IN, PTX6_IN_PU,
		PTX5_FN, PTX5_OUT, PTX5_IN, PTX5_IN_PU,
		PTX4_FN, PTX4_OUT, PTX4_IN, PTX4_IN_PU,
		PTX3_FN, PTX3_OUT, PTX3_IN, PTX3_IN_PU,
		PTX2_FN, PTX2_OUT, PTX2_IN, PTX2_IN_PU,
		PTX1_FN, PTX1_OUT, PTX1_IN, PTX1_IN_PU,
		PTX0_FN, PTX0_OUT, PTX0_IN, PTX0_IN_PU }
	},
	{ PINMUX_CFG_REG("PYCR", 0xffec0030, 16, 2) {
		PTY7_FN, PTY7_OUT, PTY7_IN, PTY7_IN_PU,
		PTY6_FN, PTY6_OUT, PTY6_IN, PTY6_IN_PU,
		PTY5_FN, PTY5_OUT, PTY5_IN, PTY5_IN_PU,
		PTY4_FN, PTY4_OUT, PTY4_IN, PTY4_IN_PU,
		PTY3_FN, PTY3_OUT, PTY3_IN, PTY3_IN_PU,
		PTY2_FN, PTY2_OUT, PTY2_IN, PTY2_IN_PU,
		PTY1_FN, PTY1_OUT, PTY1_IN, PTY1_IN_PU,
		PTY0_FN, PTY0_OUT, PTY0_IN, PTY0_IN_PU }
	},
	{ PINMUX_CFG_REG("PZCR", 0xffec0032, 16, 2) {
		0, PTZ7_OUT, PTZ7_IN, 0,
		0, PTZ6_OUT, PTZ6_IN, 0,
		0, PTZ5_OUT, PTZ5_IN, 0,
		0, PTZ4_OUT, PTZ4_IN, 0,
		0, PTZ3_OUT, PTZ3_IN, 0,
		0, PTZ2_OUT, PTZ2_IN, 0,
		0, PTZ1_OUT, PTZ1_IN, 0,
		0, PTZ0_OUT, PTZ0_IN, 0 }
	},

	{ PINMUX_CFG_REG("PSEL0", 0xffec0070, 16, 1) {
		PS0_15_FN3, PS0_15_FN1,
		PS0_14_FN3, PS0_14_FN1,
		PS0_13_FN3, PS0_13_FN1,
		PS0_12_FN3, PS0_12_FN1,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS0_7_FN2, PS0_7_FN1,
		PS0_6_FN2, PS0_6_FN1,
		PS0_5_FN2, PS0_5_FN1,
		PS0_4_FN2, PS0_4_FN1,
		PS0_3_FN2, PS0_3_FN1,
		PS0_2_FN2, PS0_2_FN1,
		PS0_1_FN2, PS0_1_FN1,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL1", 0xffec0072, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS1_7_FN1, PS1_7_FN3,
		PS1_6_FN1, PS1_6_FN3,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL2", 0xffec0074, 16, 1) {
		0, 0,
		0, 0,
		PS2_13_FN3, PS2_13_FN1,
		PS2_12_FN3, PS2_12_FN1,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS2_1_FN1, PS2_1_FN2,
		PS2_0_FN1, PS2_0_FN2, }
	},
	{ PINMUX_CFG_REG("PSEL4", 0xffec0078, 16, 1) {
		PS4_15_FN2, PS4_15_FN1,
		PS4_14_FN2, PS4_14_FN1,
		PS4_13_FN2, PS4_13_FN1,
		PS4_12_FN2, PS4_12_FN1,
		PS4_11_FN2, PS4_11_FN1,
		PS4_10_FN2, PS4_10_FN1,
		PS4_9_FN2, PS4_9_FN1,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS4_3_FN2, PS4_3_FN1,
		PS4_2_FN2, PS4_2_FN1,
		PS4_1_FN2, PS4_1_FN1,
		PS4_0_FN2, PS4_0_FN1, }
	},
	{ PINMUX_CFG_REG("PSEL5", 0xffec007a, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS5_9_FN1, PS5_9_FN2,
		PS5_8_FN1, PS5_8_FN2,
		PS5_7_FN1, PS5_7_FN2,
		PS5_6_FN1, PS5_6_FN2,
		PS5_5_FN1, PS5_5_FN2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0, }
	},
	{ PINMUX_CFG_REG("PSEL6", 0xffec007c, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PS6_7_FN_AN, PS6_7_FN_EV,
		PS6_6_FN_AN, PS6_6_FN_EV,
		PS6_5_FN_AN, PS6_5_FN_EV,
		PS6_4_FN_AN, PS6_4_FN_EV,
		PS6_3_FN_AN, PS6_3_FN_EV,
		PS6_2_FN_AN, PS6_2_FN_EV,
		PS6_1_FN_AN, PS6_1_FN_EV,
		PS6_0_FN_AN, PS6_0_FN_EV, }
	},
	{}
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR", 0xffec0034, 8) {
		PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
		PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDR", 0xffec0036, 8) {
		PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
		PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDR", 0xffec0038, 8) {
		PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
		PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDR", 0xffec003a, 8) {
		PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
		PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDR", 0xffec003c, 8) {
		PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
		PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDR", 0xffec003e, 8) {
		PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
		PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA }
	},
	{ PINMUX_DATA_REG("PGDR", 0xffec0040, 8) {
		PTG7_DATA, PTG6_DATA, PTG5_DATA, PTG4_DATA,
		PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA }
	},
	{ PINMUX_DATA_REG("PHDR", 0xffec0042, 8) {
		PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
		PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA }
	},
	{ PINMUX_DATA_REG("PIDR", 0xffec0044, 8) {
		PTI7_DATA, PTI6_DATA, PTI5_DATA, PTI4_DATA,
		PTI3_DATA, PTI2_DATA, PTI1_DATA, PTI0_DATA }
	},
	{ PINMUX_DATA_REG("PJDR", 0xffec0046, 8) {
		PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, PTJ4_DATA,
		PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA }
	},
	{ PINMUX_DATA_REG("PKDR", 0xffec0048, 8) {
		PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
		PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA }
	},
	{ PINMUX_DATA_REG("PLDR", 0xffec004a, 8) {
		PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
		PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA }
	},
	{ PINMUX_DATA_REG("PMDR", 0xffec004c, 8) {
		0, PTM6_DATA, PTM5_DATA, PTM4_DATA,
		PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA }
	},
	{ PINMUX_DATA_REG("PNDR", 0xffec004e, 8) {
		PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
		PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA }
	},
	{ PINMUX_DATA_REG("PODR", 0xffec0050, 8) {
		PTO7_DATA, PTO6_DATA, PTO5_DATA, PTO4_DATA,
		PTO3_DATA, PTO2_DATA, PTO1_DATA, PTO0_DATA }
	},
	{ PINMUX_DATA_REG("PPDR", 0xffec0052, 8) {
		0, PTP6_DATA, PTP5_DATA, PTP4_DATA,
		PTP3_DATA, PTP2_DATA, PTP1_DATA, PTP0_DATA }
	},
	{ PINMUX_DATA_REG("PQDR", 0xffec0054, 8) {
		0, PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
		PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA }
	},
	{ PINMUX_DATA_REG("PRDR", 0xffec0056, 8) {
		PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
		PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA }
	},
	{ PINMUX_DATA_REG("PSDR", 0xffec0058, 8) {
		PTS7_DATA, PTS6_DATA, PTS5_DATA, PTS4_DATA,
		PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA }
	},
	{ PINMUX_DATA_REG("PTDR", 0xffec005a, 8) {
		0, 0, PTT5_DATA, PTT4_DATA,
		PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA }
	},
	{ PINMUX_DATA_REG("PUDR", 0xffec005c, 8) {
		PTU7_DATA, PTU6_DATA, PTU5_DATA, PTU4_DATA,
		PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA }
	},
	{ PINMUX_DATA_REG("PVDR", 0xffec005e, 8) {
		PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
		PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA }
	},
	{ PINMUX_DATA_REG("PWDR", 0xffec0060, 8) {
		PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
		PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA }
	},
	{ PINMUX_DATA_REG("PXDR", 0xffec0062, 8) {
		PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
		PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA }
	},
	{ PINMUX_DATA_REG("PYDR", 0xffec0064, 8) {
		PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
		PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA }
	},
	{ PINMUX_DATA_REG("PZDR", 0xffec0066, 8) {
		PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
		PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA }
	},
	{ },
};

static struct pinmux_info sh7757_pinmux_info = {
	.name = "sh7757_pfc",
	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.input_pu = { PINMUX_INPUT_PULLUP_BEGIN, PINMUX_INPUT_PULLUP_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_PTA7,
	.last_gpio = GPIO_FN_D0,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

static int __init plat_pinmux_setup(void)
{
	return register_pinmux(&sh7757_pinmux_info);
}

arch_initcall(plat_pinmux_setup);
