/*
 * SPDX-License-Identifier: CC0-1.0
 * SPDX-FileCopyrightText: Wikidata contributors
 *
 * This code is auto-generated from Wikidata, do not edit!
 */

#include "knowledgedb.h"
#include "trainstationdb.h"

namespace KItinerary {
namespace KnowledgeDb {
static const TrainStation trainstation_table[] = {
    {Coordinate{19.0886, 47.4686}, CountryId{"HU"}}, // Ferencváros railway station
    {Coordinate{58.9815, 53.4383}, CountryId{"RU"}}, // Q100152795
    {Coordinate{12.2609, 47.4494}, CountryId{"AT"}}, // Brixen im Thale railway station
    {Coordinate{9.95913, 48.825}, CountryId{"DE"}}, // Mögglingen (Gmünd) station
    {Coordinate{8.33423, 49.74}, CountryId{"DE"}}, // Mettenheim
    {Coordinate{14.7376, 47.6078}, CountryId{"AT"}}, // Hieflau railway station
    {Coordinate{11.9424, 48.2426}, CountryId{"DE"}}, // Hörlkofen station
    {Coordinate{12.2499, 48.2732}, CountryId{"DE"}}, // Schwindegg station
    {Coordinate{12.5953, 48.2589}, CountryId{"DE"}}, // Töging (Inn) station
    {Coordinate{12.8525, 48.2566}, CountryId{"DE"}}, // Marktl station
    {Coordinate{28.5739, 60.7731}, CountryId{"RU"}}, // Kravtsovo
    {Coordinate{39.0956, 47.2921}, CountryId{"RU"}}, // Q100324331
    {Coordinate{10.9367, 47.793}, CountryId{"DE"}}, // Peiting Ost station
    {Coordinate{10.9267, 47.8016}, CountryId{"DE"}}, // Peiting Nord station
    {Coordinate{10.9993, 47.7888}, CountryId{"DE"}}, // Hohenpeißenberg station
    {Coordinate{11.0773, 47.8157}, CountryId{"DE"}}, // Peißenberg Nord station
    {Coordinate{16.928, 47.7826}, CountryId{"AT"}}, // Bahnhof St. Andrä am Zicksee
    {Coordinate{75.8931, 19.8308}, CountryId{"IN"}}, // Jalna railway station
    {Coordinate{12.2223, 51.4024}, CountryId{"DE"}}, // Schkeuditz station
    {Coordinate{39.7555, 47.1528}, CountryId{"RU"}}, // Elektrodepo railway station, Bataysk
    {Coordinate{73.2208, 19.1812}, CountryId{"IN"}}, // Chikhloli Halt railway station
    {Coordinate{88.3952, 22.9724}, CountryId{"IN"}}, // Islampara Halt railway station
    {Coordinate{16.0649, 48.3941}, CountryId{"AT"}}, // Gaisruck halt
    {Coordinate{16.1073, 48.3913}, CountryId{"AT"}}, // Hausleiten halt
    {Coordinate{16.5878, 47.6778}, CountryId{"HU"}}, // Sopron railway station
    {Coordinate{16.3473, 48.3164}, CountryId{"AT"}}, // Bisamberg halt
    {Coordinate{16.0748, 48.5149}, CountryId{"AT"}}, // Breitenwaida halt
    {Coordinate{16.1262, 48.4925}, CountryId{"AT"}}, // Göllersdorf station
    {Coordinate{16.0541, 48.6422}, CountryId{"AT"}}, // Guntersdorf station
    {Coordinate{16.0917, 48.6171}, CountryId{"AT"}}, // Hetzmannsdorf-Wullersdorf station
    {Coordinate{16.1731, 48.4484}, CountryId{"AT"}}, // Höbersdorf halt
    {Coordinate{16.0723, 48.563}, CountryId{"AT"}}, // Hollabrunn station
    {Coordinate{16.3287, 48.3438}, CountryId{"AT"}}, // Korneuburg station
    {Coordinate{16.3559, 48.3066}, CountryId{"AT"}}, // Langenzersdorf halt
    {Coordinate{16.3021, 48.3645}, CountryId{"AT"}}, // Leobendorf-Burg Kreuzenstein halt
    {Coordinate{16.174, 48.4137}, CountryId{"AT"}}, // Ober Olberndorf halt
    {Coordinate{16.1591, 48.4686}, CountryId{"AT"}}, // Schönborn-Mallebarn halt
    {Coordinate{16.1748, 48.4286}, CountryId{"AT"}}, // Sierndorf station
    {Coordinate{16.2571, 48.3757}, CountryId{"AT"}}, // Spillern halt
    {Coordinate{16.3959, 48.274}, CountryId{"AT"}}, // Wien Jedlersdorf station
    {Coordinate{16.3816, 48.2856}, CountryId{"AT"}}, // Wien Strebersdorf station
    {Coordinate{15.9684, 48.6955}, CountryId{"AT"}}, // Zellerndorf station
    {Coordinate{37.6269, 55.171}, CountryId{"RU"}}, // 298 km
    {Coordinate{16.599, 62.4197}, CountryId{"SE"}}, // Stöde
    {Coordinate{37.745, 55.1789}, CountryId{"RU"}}, // Povadino
    {Coordinate{37.7926, 55.1787}, CountryId{"RU"}}, // 309 km
    {Coordinate{10.6838, 43.6573}, CountryId{"IT"}}, // La Rotta railway halt
    {Coordinate{37.841, 55.1725}, CountryId{"RU"}}, // 312 km
    {Coordinate{16.3358, 62.4724}, CountryId{"SE"}}, // Torpshammar
    {Coordinate{16.1686, 62.4958}, CountryId{"SE"}}, // Fränsta
    {Coordinate{16.0678, 62.4956}, CountryId{"SE"}}, // Ljungaverk
    {Coordinate{15.9237, 62.5283}, CountryId{"SE"}}, // Erikslund
    {Coordinate{9.08011, 54.0879}, CountryId{"DE"}}, // Meldorf station
    {Coordinate{8.18173, 48.285}, CountryId{"DE"}}, // Hausach station
    {Coordinate{8.48647, 55.4744}, CountryId{"DK"}}, // Jerne Station
    {Coordinate{9.46286, 48.9815}, CountryId{"DE"}}, // Oppenweiler (Württ) station
    {Coordinate{12.3478, 48.4473}, CountryId{"DE"}}, // Bahnhof Vilsbiburg
    {Coordinate{18.3282, 49.844}, CountryId{"CZ"}}, // Josefova jáma
    {Coordinate{14.5588, 50.1072}, CountryId{"CZ"}}, // Q101433321
    {Coordinate{9.35637, 54.1253}, CountryId{"DE"}}, // Beldorf station
    {Coordinate{19.1154, 45.7862}, CountryId{"RS"}}, // Sombor railway station
    {Coordinate{37.6432, 55.7175}, CountryId{"RU"}}, // Derbenevskaya
    {Coordinate{18.8323, 46.8327}, CountryId{"HU"}}, // Q102108190
    {Coordinate{18.9126, 46.7931}, CountryId{"HU"}}, // Q102108352
    {Coordinate{18.9266, 46.7296}, CountryId{"HU"}}, // Q102108483
    {Coordinate{18.8806, 46.6686}, CountryId{"HU"}}, // Dunakömlőd railway station
    {Coordinate{19.1143, 47.3745}, CountryId{"HU"}}, // Q102109017
    {Coordinate{16.603, 46.9665}, CountryId{"HU"}}, // Q102109229
    {Coordinate{16.6027, 46.9094}, CountryId{"HU"}}, // Q102109242
    {Coordinate{18.2919, 47.2859}, CountryId{"HU"}}, // Q102144277
    {Coordinate{18.0066, 47.5182}, CountryId{"HU"}}, // Q102144646
    {Coordinate{18.0411, 47.5947}, CountryId{"HU"}}, // Q102145036
    {Coordinate{20.4801, 44.8195}, CountryId{"RS"}}, // Belgrade Dunav station
    {Coordinate{20.2393, 47.1799}, CountryId{"HU"}}, // Q102221162
    {Coordinate{19.2974, 46.8043}, CountryId{"HU"}}, // Q102242726
    {Coordinate{19.3412, 46.8116}, CountryId{"HU"}}, // Q102242921
    {Coordinate{19.3856, 46.8194}, CountryId{"HU"}}, // Q102243074
    {Coordinate{19.4183, 46.837}, CountryId{"HU"}}, // Q102243135
    {Coordinate{19.4563, 46.8442}, CountryId{"HU"}}, // Q102243173
    {Coordinate{19.5203, 46.8527}, CountryId{"HU"}}, // Q102243233
    {Coordinate{19.0239, 46.9709}, CountryId{"HU"}}, // Q102243278
    {Coordinate{19.6161, 46.8559}, CountryId{"HU"}}, // Q102243321
    {Coordinate{18.9803, 46.9203}, CountryId{"HU"}}, // Q102243583
    {Coordinate{18.9778, 46.8864}, CountryId{"HU"}}, // Q102243671
    {Coordinate{19.0044, 46.8449}, CountryId{"HU"}}, // Q102243729
    {Coordinate{19.011, 46.8017}, CountryId{"HU"}}, // Q102243801
    {Coordinate{19.0591, 46.7179}, CountryId{"HU"}}, // Állampuszta railway stop
    {Coordinate{19.0412, 46.6955}, CountryId{"HU"}}, // Q102244174
    {Coordinate{19.0088, 46.6466}, CountryId{"HU"}}, // Q102244336
    {Coordinate{20.2307, 47.7745}, CountryId{"HU"}}, // Q102245229
    {Coordinate{20.3934, 47.8788}, CountryId{"HU"}}, // Q102245359
    {Coordinate{20.3983, 48.1655}, CountryId{"HU"}}, // Q102245605
    {Coordinate{20.3826, 48.1854}, CountryId{"HU"}}, // Sáta railway station
    {Coordinate{20.3463, 48.217}, CountryId{"HU"}}, // Q102245724
    {Coordinate{20.38, 48.2443}, CountryId{"HU"}}, // Királd railway station
    {Coordinate{20.8932, 47.9371}, CountryId{"HU"}}, // Q102246120
    {Coordinate{20.9164, 47.9095}, CountryId{"HU"}}, // Q102246189
    {Coordinate{20.9221, 47.8639}, CountryId{"HU"}}, // Q102246289
    {Coordinate{-0.204444, 48.4578}, CountryId{"FR"}}, // Gare de Pré-en-Pail
    {Coordinate{37.5092, 55.8694}, CountryId{"RU"}}, // Grachyovskaya
    {Coordinate{20.6329, 45.3861}, CountryId{"RS"}}, // Banatski Despotovac railway halt
    {Coordinate{15.9466, 41.9359}, CountryId{"IT"}}, // Vico del Gargano-San Menaio train station
    {Coordinate{22.2728, 43.905}, CountryId{"RS"}}, // Zaječar railway station
    {Coordinate{38.0316, 55.1181}, CountryId{"RU"}}, // 328 km
    {Coordinate{38.0939, 55.1163}, CountryId{"RU"}}, // 332 km
    {Coordinate{38.2122, 55.1099}, CountryId{"RU"}}, // 341 km
    {Coordinate{38.0922, 55.0278}, CountryId{"RU"}}, // Kolychevo
    {Coordinate{38.0533, 55.0044}, CountryId{"RU"}}, // Shmatovo
    {Coordinate{38.528, 55.188}, CountryId{"RU"}}, // Osyonka
    {Coordinate{0.772811, 45.1721}, CountryId{"FR"}}, // Boulazac Isle Manoire railway station
    {Coordinate{15.1236, 50.1494}, CountryId{"CZ"}}, // Poděbrady (train station)
    {Coordinate{17.1507, 49.4828}, CountryId{"CZ"}}, // Vrahovice
    {Coordinate{-9.09953, 38.7777}, CountryId{"PT"}}, // Moscavide station
    {Coordinate{-8.3124, 41.3791}, CountryId{"PT"}}, // Vizela train station
    {Coordinate{141.962, 46.8694}, CountryId{"RU"}}, // Kalinino-Sakhalinskoye
    {Coordinate{-0.0209, 51.5051}, CountryId{"GB"}}, // Canary Wharf
    {Coordinate{0.00838889, 51.5139}, CountryId{"GB"}}, // Canning Town
    {Coordinate{12.5325, 57.9269}, CountryId{"SE"}}, // Alingsås railway station
    {Coordinate{10.6647, 47.5428}, CountryId{"AT"}}, // Ulrichsbrücke-Füssen
    {Coordinate{9.88177, 47.7936}, CountryId{"DE"}}, // Kißlegg station
    {Coordinate{12.8451, 50.2223}, CountryId{"CZ"}}, // Karlovy Vary-Aréna
    {Coordinate{12.1164, 55.8102}, CountryId{"DK"}}, // Vinge station
    {Coordinate{10.7779, 50.337}, CountryId{"DE"}}, // Bad Rodach (b Coburg)
    {Coordinate{-79.5356, 43.6376}, CountryId{"CA"}}, // Kipling
    {Coordinate{12.8697, 50.8744}, CountryId{"DE"}}, // Wittgensdorf Mitte
    {Coordinate{12.8424, 50.8808}, CountryId{"DE"}}, // Wittgensdorf Oberer Bahnhof
    {Coordinate{15.0618, 37.4757}, CountryId{"IT"}}, // Catania Aeroporto Fontanarossa railway halt
    {Coordinate{77.1188, 13.0552}, CountryId{"IN"}}, // Tippasandra railway station
    {Coordinate{77.2587, 13.0698}, CountryId{"IN"}}, // Solur railway station
    {Coordinate{77.3925, 13.1122}, CountryId{"IN"}}, // Nelamangala railway station
    {Coordinate{16.2164, 60.1294}, CountryId{"SE"}}, // Avesta Krylbo railway station
    {Coordinate{77.5163, 15.0134}, CountryId{"IN"}}, // Imampuram railway station
    {Coordinate{77.1948, 14.4149}, CountryId{"IN"}}, // Kadiridevarapalli railway station
    {Coordinate{77.1195, 14.5692}, CountryId{"IN"}}, // Kalyanadurga railway station
    {Coordinate{76.974, 14.6898}, CountryId{"IN"}}, // Avuladatla railway station
    {Coordinate{76.6089, 14.9762}, CountryId{"IN"}}, // Swamihalli railway station
    {Coordinate{76.5996, 15.0561}, CountryId{"IN"}}, // Ranjitpura railway station
    {Coordinate{76.5027, 15.0393}, CountryId{"IN"}}, // Yeshwanthnagar railway station
    {Coordinate{76.4492, 15.1171}, CountryId{"IN"}}, // Ramgad railway station
    {Coordinate{76.3826, 15.1642}, CountryId{"IN"}}, // Gunda Road railway station
    {Coordinate{76.3835, 15.1869}, CountryId{"IN"}}, // Vyasa Colony Junction railway station
    {Coordinate{76.3644, 15.2312}, CountryId{"IN"}}, // Vyasanakeri railway station
    {Coordinate{76.3542, 15.263}, CountryId{"IN"}}, // Tunga Bhadra Dam railway station
    {Coordinate{76.2972, 15.3957}, CountryId{"IN"}}, // Budagumpa railway station
    {Coordinate{76.3686, 15.4245}, CountryId{"IN"}}, // Jabbalguda railway station
    {Coordinate{76.4428, 15.4286}, CountryId{"IN"}}, // Chikkabenakal railway station
    {Coordinate{76.2087, 15.05}, CountryId{"IN"}}, // Hagari Bommanahalli railway station
    {Coordinate{76.119, 14.7876}, CountryId{"IN"}}, // Bennihalli railway station
    {Coordinate{75.9852, 14.7738}, CountryId{"IN"}}, // Harapanahalli railway station
    {Coordinate{75.8977, 14.6594}, CountryId{"IN"}}, // Telgi railway station
    {Coordinate{78.2507, 15.3223}, CountryId{"IN"}}, // Banaganapalli railway station
    {Coordinate{78.3072, 15.2212}, CountryId{"IN"}}, // Koilakuntla railway station
    {Coordinate{78.3157, 15.1575}, CountryId{"IN"}}, // Sanjamala railway station
    {Coordinate{78.3965, 14.9795}, CountryId{"IN"}}, // Nossam railway station
    {Coordinate{78.3872, 14.9066}, CountryId{"IN"}}, // S. Uppalapadu railway station
    {Coordinate{78.3792, 15.443}, CountryId{"IN"}}, // Madduru railway station
    {Coordinate{25.6481, 60.3964}, CountryId{"FI"}}, // Porvoo railway station
    {Coordinate{24.4895, 64.6837}, CountryId{"FI"}}, // Raahe railway station
    {Coordinate{14.4814, 56.0672}, CountryId{"SE"}}, // Bromölla railway station
    {Coordinate{38.4187, 54.7215}, CountryId{"RU"}}, // 131 km
    {Coordinate{38.4736, 54.7072}, CountryId{"RU"}}, // Topkanovo
    {Coordinate{38.4889, 54.6972}, CountryId{"RU"}}, // 137 km
    {Coordinate{31.4444, 52.1444}, CountryId{"BY"}}, // Kutok
    {Coordinate{38.5806, 54.6325}, CountryId{"RU"}}, // 146 km
    {Coordinate{38.5977, 54.6188}, CountryId{"RU"}}, // Korovino
    {Coordinate{38.6104, 54.5859}, CountryId{"RU"}}, // 152 km
    {Coordinate{38.647, 54.4961}, CountryId{"RU"}}, // Q104364001
    {Coordinate{38.6647, 54.4783}, CountryId{"RU"}}, // Q104364046
    {Coordinate{38.7677, 54.3957}, CountryId{"RU"}}, // Q104364349
    {Coordinate{38.8989, 54.2942}, CountryId{"RU"}}, // Q104364772
    {Coordinate{38.9467, 54.2599}, CountryId{"RU"}}, // Q104364941
    {Coordinate{39.0151, 54.2226}, CountryId{"RU"}}, // Q104365265
    {Coordinate{39.057, 54.1722}, CountryId{"RU"}}, // Q104365611
    {Coordinate{39.0771, 54.1009}, CountryId{"RU"}}, // Q104365807
    {Coordinate{39.1085, 54.0394}, CountryId{"RU"}}, // Q104365913
    {Coordinate{39.1403, 53.9711}, CountryId{"RU"}}, // Q104365980
    {Coordinate{39.1512, 53.9366}, CountryId{"RU"}}, // Q104366125
    {Coordinate{39.1865, 53.8545}, CountryId{"RU"}}, // Q104366278
    {Coordinate{31.6903, 52.1733}, CountryId{"BY"}}, // Kruhavyets
    {Coordinate{82.2029, 17.0065}, CountryId{"IN"}}, // Sarpavaram railway station
    {Coordinate{34.5181, 55.3808}, CountryId{"RU"}}, // 218 km
    {Coordinate{34.4521, 55.3474}, CountryId{"RU"}}, // Meshchyorskaya
    {Coordinate{34.4077, 55.3159}, CountryId{"RU"}}, // Podyolki
    {Coordinate{34.3761, 55.2727}, CountryId{"RU"}}, // Komyagino
    {Coordinate{34.362, 55.2443}, CountryId{"RU"}}, // Zubaryovka
    {Coordinate{34.2807, 55.1785}, CountryId{"RU"}}, // Staraya Derevnya
    {Coordinate{}, CountryId{"IN"}}, // Kakinada New Port railway station
    {Coordinate{9.21736, 48.2505}, CountryId{"DE"}}, // Gammertingen station
    {Coordinate{9.2926, 48.3925}, CountryId{"DE"}}, // Kleinengstingen Landesbahn station
    {Coordinate{28.4693, 56.3054}, CountryId{"RU"}}, // Sebezh
    {Coordinate{28.6711, 56.3319}, CountryId{"RU"}}, // Q104373095
    {Coordinate{84.5073, 26.1082}, CountryId{"IN"}}, // Maharajganj railway station
    {Coordinate{84.1707, 26.5669}, CountryId{"IN"}}, // Panchdeori Halt railway station
    {Coordinate{83.5135, 26.2684}, CountryId{"IN"}}, // Dohrighat railway station
    {Coordinate{83.2662, 27.0252}, CountryId{"IN"}}, // Campierganj railway station
    {Coordinate{12.9048, 56.4308}, CountryId{"SE"}}, // Båstad railway station
    {Coordinate{82.3893, 23.2403}, CountryId{"IN"}}, // Tiger Hill railway station
    {Coordinate{69.0215, 22.1977}, CountryId{"IN"}}, // Baradiya railway station
    {Coordinate{85.9081, 21.1144}, CountryId{"IN"}}, // Daitari railway station
    {Coordinate{9.33203, 49.5191}, CountryId{"DE"}}, // Haltestelle Buchen Ost
    {Coordinate{40.0492, 57.511}, CountryId{"RU"}}, // 296 km
    {Coordinate{3.2987, 46.3012}, CountryId{"FR"}}, // Gare De Saint Pourçain-sur-Sioule
    {Coordinate{72.5421, 23.7026}, CountryId{"IN"}}, // Visnagar railway station
    {Coordinate{71.7192, 23.1702}, CountryId{"IN"}}, // Kharaghoda railway station
    {Coordinate{69.8391, 22.4349}, CountryId{"IN"}}, // Sikka railway station
    {Coordinate{72.9169, 22.533}, CountryId{"IN"}}, // Karamsad railway station
    {Coordinate{72.9311, 22.5423}, CountryId{"IN"}}, // Vallabh Vidynagar railway station
    {Coordinate{72.9088, 22.4011}, CountryId{"IN"}}, // Borsad railway station
    {Coordinate{72.8915, 22.3568}, CountryId{"IN"}}, // Bhadran railway station
    {Coordinate{73.0635, 22.219}, CountryId{"IN"}}, // Latipura railway station
    {Coordinate{73.1535, 22.2752}, CountryId{"IN"}}, // Atladara railway station
    {Coordinate{24.9414, 60.171}, CountryId{"FI"}}, // Helsinki Central Railway Station
    {Coordinate{73.1916, 22.0673}, CountryId{"IN"}}, // Ganpatpura railway station
    {Coordinate{73.1682, 21.9913}, CountryId{"IN"}}, // Choranda Junction railway station
    {Coordinate{73.2908, 21.9856}, CountryId{"IN"}}, // Sadhli railway station
    {Coordinate{73.3363, 21.9114}, CountryId{"IN"}}, // Sinor railway station
    {Coordinate{73.2011, 21.8722}, CountryId{"IN"}}, // Nareshwar Road railway station
    {Coordinate{73.2045, 21.8352}, CountryId{"IN"}}, // Moti Koral railway station
    {Coordinate{73.1493, 21.7268}, CountryId{"IN"}}, // Jhagadiya railway station
    {Coordinate{9.28438, 48.384}, CountryId{"DE"}}, // Engstingen Schulzentrum railway stop
    {Coordinate{9.26173, 48.3612}, CountryId{"DE"}}, // Haidkapelle station
    {Coordinate{9.24601, 48.3288}, CountryId{"DE"}}, // Trochtelfingen ALB-GOLD railway stop
    {Coordinate{73.1537, 21.4615}, CountryId{"IN"}}, // Mota Miya Mangrol railway station
    {Coordinate{72.8144, 22.0463}, CountryId{"IN"}}, // Jambusar Junction railway station
    {Coordinate{72.8082, 22.056}, CountryId{"IN"}}, // Jambusar Road railway station
    {Coordinate{73.2272, 22.5559}, CountryId{"IN"}}, // Savli railway station
    {Coordinate{73.0749, 20.8063}, CountryId{"IN"}}, // Chikhli Road railway station
    {Coordinate{75.5163, 20.6279}, CountryId{"IN"}}, // Pimpalgaon railway station
    {Coordinate{75.4439, 20.6575}, CountryId{"IN"}}, // Varkhedi railway station
    {Coordinate{75.5975, 20.6574}, CountryId{"IN"}}, // Shendurni railway station
    {Coordinate{75.6837, 20.7154}, CountryId{"IN"}}, // Pahur railway station
    {Coordinate{75.7506, 20.7367}, CountryId{"IN"}}, // Bhagdara railway station
    {Coordinate{9.22203, 48.2878}, CountryId{"DE"}}, // Maegerkingen station
    {Coordinate{9.24625, 48.3076}, CountryId{"DE"}}, // Trochtelfingen (Hohenz) station
    {Coordinate{76.5709, 20.7081}, CountryId{"IN"}}, // Khamgaon railway station
    {Coordinate{80.0576, 21.7713}, CountryId{"IN"}}, // Waraseoni railway station
    {Coordinate{80.1093, 21.7953}, CountryId{"IN"}}, // Kaydi Halt railway station
    {Coordinate{80.1688, 22.424}, CountryId{"IN"}}, // Dhatura Alipur railway station
    {Coordinate{87.3966, 25.821}, CountryId{"IN"}}, // Kirtyanand Nagar railway station
    {Coordinate{87.5298, 25.8602}, CountryId{"IN"}}, // Kasba railway station
    {Coordinate{86.7379, 26.2934}, CountryId{"IN"}}, // Saraygarh railway station
    {Coordinate{85.409, 24.3031}, CountryId{"IN"}}, // Barhi railway station
    {Coordinate{85.3329, 22.1066}, CountryId{"IN"}}, // Bolanikhadan railway station
    {Coordinate{85.5933, 20.1581}, CountryId{"IN"}}, // Khurda Town railway station
    {Coordinate{85.4319, 20.1872}, CountryId{"IN"}}, // Begunia railway station
    {Coordinate{83.2521, 18.5436}, CountryId{"IN"}}, // Rompalle railway station
    {Coordinate{83.2066, 18.5273}, CountryId{"IN"}}, // Salur railway station
    {Coordinate{80.1139, 16.8919}, CountryId{"IN"}}, // Jaggayyapet Town railway station
    {Coordinate{81.2341, 16.5595}, CountryId{"IN"}}, // Vadarlapadu railway station
    {Coordinate{81.3218, 16.5782}, CountryId{"IN"}}, // Alapadu railway station
    {Coordinate{82.0412, 16.8365}, CountryId{"IN"}}, // Ramachandrapuram railway station
    {Coordinate{82.1793, 16.9276}, CountryId{"IN"}}, // Aratlakatta railway station
    {Coordinate{79.2792, 19.7574}, CountryId{"IN"}}, // Pandhar Pavani railway station
    {Coordinate{78.6382, 18.8544}, CountryId{"IN"}}, // Metpalli railway station
    {Coordinate{78.8875, 18.7825}, CountryId{"IN"}}, // Lingampet Jagityal railway station
    {Coordinate{78.9202, 18.7059}, CountryId{"IN"}}, // Nukanpalli Mallial railway station
    {Coordinate{82.5218, 27.6441}, CountryId{"IN"}}, // Jarwa railway station
    {Coordinate{79.8856, 28.0208}, CountryId{"IN"}}, // Areli railway station
    {Coordinate{79.8862, 27.9845}, CountryId{"IN"}}, // Khiria Khurd railway station
    {Coordinate{79.904, 27.8944}, CountryId{"IN"}}, // Shahjahanpur (Metre Gauge) railway station
    {Coordinate{80.7397, 27.5221}, CountryId{"IN"}}, // Khairabad Awadh railway station
    {Coordinate{78.9511, 26.7289}, CountryId{"IN"}}, // Udi More Junction railway station
    {Coordinate{78.6176, 26.866}, CountryId{"IN"}}, // Bah railway station
    {Coordinate{78.2997, 27.0193}, CountryId{"IN"}}, // Fatehabad railway station
    {Coordinate{78.1269, 27.025}, CountryId{"IN"}}, // Shamshabad Town railway station
    {Coordinate{77.7583, 27.3186}, CountryId{"IN"}}, // Deen Dayal Dham railway station
    {Coordinate{75.4098, 28.7648}, CountryId{"IN"}}, // Narwasi railway station
    {Coordinate{76.992, 30.8821}, CountryId{"IN"}}, // Jabli railway station
    {Coordinate{75.388, 31.8263}, CountryId{"IN"}}, // Qadian railway station
    {Coordinate{75.0142, 32.0249}, CountryId{"IN"}}, // Dera Baba Nanak railway station
    {Coordinate{74.9853, 31.9971}, CountryId{"IN"}}, // Ratar Chattar railway station
    {Coordinate{74.9269, 31.9632}, CountryId{"IN"}}, // Ramdas railway station
    {Coordinate{74.926, 31.9145}, CountryId{"IN"}}, // Hardorawal railway station
    {Coordinate{74.9415, 31.8636}, CountryId{"IN"}}, // Fatehgarh Churian railway station
    {Coordinate{74.9434, 31.8112}, CountryId{"IN"}}, // Kotla Gujran railway station
    {Coordinate{74.9491, 31.7585}, CountryId{"IN"}}, // Majitha railway station
    {Coordinate{74.8643, 31.6089}, CountryId{"IN"}}, // Bhagtanwala railway station
    {Coordinate{74.8555, 31.2878}, CountryId{"IN"}}, // Patti railway station
    {Coordinate{74.5535, 31.1398}, CountryId{"IN"}}, // Khem Karan railway station
    {Coordinate{75.6072, 31.2428}, CountryId{"IN"}}, // Jamsher Khas railway station
    {Coordinate{75.1921, 33.5675}, CountryId{"IN"}}, // Hiller Shahabad railway station
    {Coordinate{75.0386, 33.8464}, CountryId{"IN"}}, // Panzgom railway station
    {Coordinate{74.5122, 34.2226}, CountryId{"IN"}}, // Hamre railway station
    {Coordinate{74.5468, 28.1538}, CountryId{"IN"}}, // Golsar railway station
    {Coordinate{74.5346, 28.21}, CountryId{"IN"}}, // Melusar railway station
    {Coordinate{74.7037, 26.9809}, CountryId{"IN"}}, // Bidiyad railway station
    {Coordinate{73.617, 26.2255}, CountryId{"IN"}}, // Bhawi railway station
    {Coordinate{78.4841, 26.4984}, CountryId{"IN"}}, // Sondha Road railway station
    {Coordinate{74.4154, 18.0086}, CountryId{"IN"}}, // Phaltan railway station
    {Coordinate{7.0656, 49.3562}, CountryId{"DE"}}, // Merchweiler station
    {Coordinate{74.6174, 15.2729}, CountryId{"IN"}}, // Ambewadi railway station
    {Coordinate{76.6224, 15.1445}, CountryId{"IN"}}, // Bannihatti railway station
    {Coordinate{77.5778, 16.2479}, CountryId{"IN"}}, // Panduranga Swamy Road railway station
    {Coordinate{77.6073, 16.5783}, CountryId{"IN"}}, // Jaklair railway station
    {Coordinate{77.7286, 16.5952}, CountryId{"IN"}}, // Marikal railway station
    {Coordinate{78.6402, 14.4314}, CountryId{"IN"}}, // Pendlimarri railway station
    {Coordinate{78.7041, 14.4522}, CountryId{"IN"}}, // Ganganapalli railway station
    {Coordinate{79.9334, 14.294}, CountryId{"IN"}}, // Venkatachalam Road Junction railway station
    {Coordinate{79.6289, 10.6901}, CountryId{"IN"}}, // Mavur Road railway station
    {Coordinate{79.6365, 10.6531}, CountryId{"IN"}}, // Tirunellikaval railway station
    {Coordinate{79.7381, 10.4527}, CountryId{"IN"}}, // Kariyappattinam railway station
    {Coordinate{79.8554, 10.3776}, CountryId{"IN"}}, // Vedaranniyam railway station
    {Coordinate{79.8502, 10.355}, CountryId{"IN"}}, // Agastiyampalli railway station
    {Coordinate{79.4989, 10.4027}, CountryId{"IN"}}, // Mutupet railway station
    {Coordinate{79.0921, 10.2171}, CountryId{"IN"}}, // Ayingudi railway station
    {Coordinate{7.17141, 49.2636}, CountryId{"DE"}}, // Hassel (Saar) station
    {Coordinate{78.8384, 10.1058}, CountryId{"IN"}}, // Kandanur Puduvayal railway station
    {Coordinate{77.935, 9.94065}, CountryId{"IN"}}, // Karumattur railway station
    {Coordinate{77.1327, 10.6099}, CountryId{"IN"}}, // Gomangalam railway station
    {Coordinate{77.2504, 10.5793}, CountryId{"IN"}}, // Udumalaippettai railway station
    {Coordinate{77.3346, 10.5639}, CountryId{"IN"}}, // Maivadi Road railway station
    {Coordinate{77.4226, 10.5249}, CountryId{"IN"}}, // Pushpattur railway station
    {Coordinate{77.6253, 9.9956}, CountryId{"IN"}}, // Andipatti railway station
    {Coordinate{77.473, 10.0143}, CountryId{"IN"}}, // Teni railway station
    {Coordinate{76.4657, 12.8714}, CountryId{"IN"}}, // Shravanabelagola railway station
    {Coordinate{76.394, 12.8927}, CountryId{"IN"}}, // Channarayapatna railway station
    {Coordinate{76.2055, 12.9846}, CountryId{"IN"}}, // Shantigrama railway station
    {Coordinate{76.5745, 12.9472}, CountryId{"IN"}}, // Hirisave railway station
    {Coordinate{}, CountryId{"IN"}}, // B.G. Nagar railway station
    {Coordinate{76.8639, 12.979}, CountryId{"IN"}}, // Yediyur railway station
    {Coordinate{77.0111, 13.0166}, CountryId{"IN"}}, // Kunigal railway station
    {Coordinate{74.8536, 12.9596}, CountryId{"IN"}}, // Jokatte railway station
    {Coordinate{73.7741, 21.9708}, CountryId{"IN"}}, // Tankhala railway station
    {Coordinate{92.9232, 26.7916}, CountryId{"IN"}}, // Dhalai Beel railway station
    {Coordinate{93.1637, 26.7693}, CountryId{"IN"}}, // Nizchatia railway station
    {Coordinate{36.9485, 58.3566}, CountryId{"RU"}}, // Ovinishe-2 railway station
    {Coordinate{93.3023, 26.846}, CountryId{"IN"}}, // Nizbargang railway station
    {Coordinate{93.4528, 26.873}, CountryId{"IN"}}, // Helem railway station
    {Coordinate{93.6219, 26.897}, CountryId{"IN"}}, // Gohpur railway station
    {Coordinate{93.7202, 26.9196}, CountryId{"IN"}}, // Dubia railway station
    {Coordinate{93.8605, 27.119}, CountryId{"IN"}}, // Harmuti Junction railway station
    {Coordinate{93.9711, 27.1766}, CountryId{"IN"}}, // Kathalpukhari railway station
    {Coordinate{94.0312, 27.201}, CountryId{"IN"}}, // Silanibari railway station
    {Coordinate{94.075, 27.2983}, CountryId{"IN"}}, // Lilabari railway station
    {Coordinate{37.0209, 58.3394}, CountryId{"RU"}}, // Ovinishe-1 railway station
    {Coordinate{94.1825, 27.3992}, CountryId{"IN"}}, // Baginadi railway station
    {Coordinate{94.3196, 27.4416}, CountryId{"IN"}}, // Gogamukh railway station
    {Coordinate{94.4379, 27.4234}, CountryId{"IN"}}, // Bordoloni railway station
    {Coordinate{94.6326, 27.5587}, CountryId{"IN"}}, // Sripani railway station
    {Coordinate{94.6848, 27.5358}, CountryId{"IN"}}, // New Sisibargaon railway station
    {Coordinate{94.718, 27.5928}, CountryId{"IN"}}, // Silapathar railway station
    {Coordinate{94.7798, 27.6557}, CountryId{"IN"}}, // Archipathar railway station
    {Coordinate{94.8869, 27.7237}, CountryId{"IN"}}, // Simen Chapori railway station
    {Coordinate{95.0039, 27.766}, CountryId{"IN"}}, // Telem Railway Station railway station
    {Coordinate{95.0761, 27.7508}, CountryId{"IN"}}, // Laimekuri railway station
    {Coordinate{94.7149, 27.4523}, CountryId{"IN"}}, // Tangni railway station
    {Coordinate{94.6131, 26.7365}, CountryId{"IN"}}, // Tuli railway station
    {Coordinate{95.5396, 27.5543}, CountryId{"IN"}}, // Hansara railway station
    {Coordinate{95.557, 27.5998}, CountryId{"IN"}}, // Rupai railway station
    {Coordinate{95.5632, 27.6732}, CountryId{"IN"}}, // Talap railway station
    {Coordinate{95.568, 27.7093}, CountryId{"IN"}}, // Dangari railway station
    {Coordinate{13.7661, 47.9332}, CountryId{"AT"}}, // Pinsdorf railway station
    {Coordinate{13.7454, 47.9681}, CountryId{"AT"}}, // Aurachkirchen railway station
    {Coordinate{13.7583, 47.8912}, CountryId{"AT"}}, // Altmünster railway station
    {Coordinate{85.2233, 20.1693}, CountryId{"IN"}}, // Bolagarh Road railway station
    {Coordinate{85.344, 20.1646}, CountryId{"IN"}}, // Rajsunakhala railway station
    {Coordinate{13.7771, 47.8552}, CountryId{"AT"}}, // Traunkirchen railway station
    {Coordinate{13.787, 47.8428}, CountryId{"AT"}}, // Traunkirchen Ort railway station
    {Coordinate{24.8639, 60.2467}, CountryId{"FI"}}, // Malminkartano railway station
    {Coordinate{86.1543, 22.5027}, CountryId{"IN"}}, // Sidhirsai railway station
    {Coordinate{86.3653, 26.4415}, CountryId{"IN"}}, // Barhara railway station
    {Coordinate{81.8806, 25.4444}, CountryId{"IN"}}, // Prayagraj Sangam Terminal railway station
    {Coordinate{81.6503, 25.1846}, CountryId{"IN"}}, // Bevara railway station
    {Coordinate{78.8817, 26.6558}, CountryId{"IN"}}, // Phoop railway station
    {Coordinate{13.7745, 47.8127}, CountryId{"AT"}}, // Ebensee Landungsplatz railway station
    {Coordinate{13.7715, 47.8043}, CountryId{"AT"}}, // Ebensee railway station
    {Coordinate{13.7414, 47.7872}, CountryId{"AT"}}, // Steinkogel railway station
    {Coordinate{13.7311, 47.7745}, CountryId{"AT"}}, // Lahnstein
    {Coordinate{13.706, 47.7574}, CountryId{"AT"}}, // Langwies railway station
    {Coordinate{14.1065, 47.5295}, CountryId{"AT"}}, // Stainach-Irdning railway station
    {Coordinate{13.6163, 47.6741}, CountryId{"AT"}}, // Lauffen railway station
    {Coordinate{13.6088, 47.6585}, CountryId{"AT"}}, // Bad Goisern Jodschwefelbad railway station
    {Coordinate{13.6129, 47.6399}, CountryId{"AT"}}, // Bad Goisern railway station
    {Coordinate{78.8884, 26.7493}, CountryId{"IN"}}, // Jaitpura railway station
    {Coordinate{78.7773, 26.809}, CountryId{"IN"}}, // Man Singh Ka Pura railway station
    {Coordinate{78.7105, 26.8349}, CountryId{"IN"}}, // Jaitpur Kalan railway station
    {Coordinate{78.4821, 26.8942}, CountryId{"IN"}}, // Bhadrauli railway station
    {Coordinate{78.3904, 26.9366}, CountryId{"IN"}}, // Manikpura railway station
    {Coordinate{78.2003, 27.0295}, CountryId{"IN"}}, // Dhimsiri railway station
    {Coordinate{78.0246, 27.0408}, CountryId{"IN"}}, // Karaundhana railway station
    {Coordinate{76.7947, 25.845}, CountryId{"IN"}}, // Durgapuri railway station
    {Coordinate{74.1785, 26.2995}, CountryId{"IN"}}, // Ras railway station
    {Coordinate{73.5649, 26.3023}, CountryId{"IN"}}, // Silari railway station
    {Coordinate{75.0513, 23.3394}, CountryId{"IN"}}, // Ratlam New railway station
    {Coordinate{73.3856, 22.7728}, CountryId{"IN"}}, // Tulsigam railway station
    {Coordinate{73.3534, 22.7426}, CountryId{"IN"}}, // Wejpur railway station
    {Coordinate{73.3284, 22.712}, CountryId{"IN"}}, // Desar Road railway station
    {Coordinate{73.3639, 22.669}, CountryId{"IN"}}, // Pandu Mewas railway station
    {Coordinate{73.3599, 22.6392}, CountryId{"IN"}}, // Sandasal railway station
    {Coordinate{73.3239, 22.6119}, CountryId{"IN"}}, // Mevli railway station
    {Coordinate{73.2549, 22.5725}, CountryId{"IN"}}, // Muval Tank railway station
    {Coordinate{73.2488, 22.518}, CountryId{"IN"}}, // Karchiya railway station
    {Coordinate{73.3381, 22.4413}, CountryId{"IN"}}, // Jarod railway station
    {Coordinate{73.3704, 22.4106}, CountryId{"IN"}}, // Vyankatpura railway station
    {Coordinate{73.3849, 22.3588}, CountryId{"IN"}}, // Ajwa railway station
    {Coordinate{73.4376, 22.2279}, CountryId{"IN"}}, // Karmaliyapura railway station
    {Coordinate{73.4242, 22.1877}, CountryId{"IN"}}, // Prayagpura railway station
    {Coordinate{73.3183, 22.0952}, CountryId{"IN"}}, // Baripur Mandala railway station
    {Coordinate{73.2497, 22.0779}, CountryId{"IN"}}, // Kayavarohan railway station
    {Coordinate{73.6092, 22.1411}, CountryId{"IN"}}, // Khunvad railway station
    {Coordinate{73.6474, 22.1383}, CountryId{"IN"}}, // Bhatpur railway station
    {Coordinate{74.0737, 22.3741}, CountryId{"IN"}}, // Padaliya Road railway station
    {Coordinate{74.1842, 22.3826}, CountryId{"IN"}}, // Moti Sadhli railway station
    {Coordinate{74.2722, 22.3195}, CountryId{"IN"}}, // Ambari Richhavi railway station
    {Coordinate{9.12814, 48.136}, CountryId{"DE"}}, // Bahnhof Storzingen
    {Coordinate{71.1626, 21.4823}, CountryId{"IN"}}, // Sajiyavadar railway station
    {Coordinate{72.275, 23.3359}, CountryId{"IN"}}, // Devsana railway station
    {Coordinate{72.3865, 23.2814}, CountryId{"IN"}}, // Karan Nagar railway station
    {Coordinate{49.4218, 62.0908}, CountryId{"RU"}}, // Mezhog railway station
    {Coordinate{72.4101, 23.2765}, CountryId{"IN"}}, // Anakhol railway station
    {Coordinate{72.4934, 23.4574}, CountryId{"IN"}}, // Langhnaj railway station
    {Coordinate{72.5565, 23.4829}, CountryId{"IN"}}, // Gojhariya railway station
    {Coordinate{72.5755, 23.5304}, CountryId{"IN"}}, // Vasai Dabhla railway station
    {Coordinate{72.62, 23.5533}, CountryId{"IN"}}, // Kukarvada railway station
    {Coordinate{72.669, 23.5763}, CountryId{"IN"}}, // Gerita Kolvada railway station
    {Coordinate{72.6995, 23.5785}, CountryId{"IN"}}, // Gawada Malosan railway station
    {Coordinate{72.7314, 23.5166}, CountryId{"IN"}}, // Pilwai Road railway station
    {Coordinate{72.714, 23.4604}, CountryId{"IN"}}, // Lodra railway station
    {Coordinate{72.6975, 23.4175}, CountryId{"IN"}}, // Makakhad railway station
    {Coordinate{72.6786, 23.3748}, CountryId{"IN"}}, // Limbodra railway station
    {Coordinate{72.6589, 23.33}, CountryId{"IN"}}, // Unava Vasan railway station
    {Coordinate{72.6338, 23.2971}, CountryId{"IN"}}, // Randheja railway station
    {Coordinate{72.5475, 23.2478}, CountryId{"IN"}}, // Tintoda railway station
    {Coordinate{10.0703, 54.31}, CountryId{"DE"}}, // Kiel-Russee
    {Coordinate{70.2847, 21.1053}, CountryId{"IN"}}, // Bhanduri railway station
    {Coordinate{71.4703, 21.0874}, CountryId{"IN"}}, // Charodia railway station
    {Coordinate{72.7288, 21.7988}, CountryId{"IN"}}, // Pakhajan railway station
    {Coordinate{72.8447, 21.8495}, CountryId{"IN"}}, // Vagara railway station
    {Coordinate{72.9415, 21.7397}, CountryId{"IN"}}, // Tham railway station
    {Coordinate{73.0644, 21.4589}, CountryId{"IN"}}, // Asarma railway station
    {Coordinate{73.0913, 21.4597}, CountryId{"IN"}}, // Simodara railway station
    {Coordinate{73.0386, 21.4395}, CountryId{"IN"}}, // Limbara railway station
    {Coordinate{73.0124, 21.4332}, CountryId{"IN"}}, // Velachha railway station
    {Coordinate{73.4751, 21.4584}, CountryId{"IN"}}, // Umarpada railway station
    {Coordinate{73.4562, 21.4912}, CountryId{"IN"}}, // Kevedi railway station
    {Coordinate{73.398, 21.4741}, CountryId{"IN"}}, // Chitalda railway station
    {Coordinate{73.3394, 20.8524}, CountryId{"IN"}}, // Unai and Vansda Road railway station
    {Coordinate{72.6441, 22.3571}, CountryId{"IN"}}, // Kalitalavadi railway station
    {Coordinate{72.7441, 22.4717}, CountryId{"IN"}}, // Pandori railway station
    {Coordinate{72.7325, 22.5814}, CountryId{"IN"}}, // Dabhou railway station
    {Coordinate{72.4704, 22.9645}, CountryId{"IN"}}, // Sanathal railway station
    {Coordinate{72.3977, 22.7848}, CountryId{"IN"}}, // Saljida railway station
    {Coordinate{72.4381, 23.6467}, CountryId{"IN"}}, // Piludra railway station
    {Coordinate{72.6592, 23.9209}, CountryId{"IN"}}, // Kadarpur railway station
    {Coordinate{72.6283, 23.827}, CountryId{"IN"}}, // Kesimpa railway station
    {Coordinate{72.9629, 23.7903}, CountryId{"IN"}}, // Sur Road railway station
    {Coordinate{9.29132, 49.6247}, CountryId{"DE"}}, // Rippberg
    {Coordinate{21.8798, 55.0827}, CountryId{"RU"}}, // Sovetsk train station
    {Coordinate{76.4207, 29.8006}, CountryId{"IN"}}, // New Kaithal Halt railway station
    {Coordinate{9.3387, 49.441}, CountryId{"DE"}}, // Seckach
    {Coordinate{75.7704, 31.1674}, CountryId{"IN"}}, // Mauli Block Hut railway station
    {Coordinate{11.5794, 58.5292}, CountryId{"SE"}}, // Dingle railway station
    {Coordinate{9.2354, 48.0997}, CountryId{"DE"}}, // Hanfertal station
    {Coordinate{18.1489, 49.6112}, CountryId{"CZ"}}, // Q104776000
    {Coordinate{14.704, 49.4045}, CountryId{"CZ"}}, // Q104808828
    {Coordinate{15.9813, 48.1734}, CountryId{"AT"}}, // Eichgraben-Altlengbach railway station
    {Coordinate{16.0619, 48.1785}, CountryId{"AT"}}, // Dürrwien railway station
    {Coordinate{16.0777, 48.1813}, CountryId{"AT"}}, // Pressbaum railway station
    {Coordinate{16.0929, 48.1861}, CountryId{"AT"}}, // Tullnerbach-Pressbaum railway station
    {Coordinate{16.128, 48.1916}, CountryId{"AT"}}, // Unter Tullnerbach railway station
    {Coordinate{16.1755, 48.206}, CountryId{"AT"}}, // Purkersdorf Zentrum railway station
    {Coordinate{8.01711, 46.6255}, CountryId{"CH"}}, // Grindelwald Terminal railway station
    {Coordinate{77.3669, 20.7271}, CountryId{"IN"}}, // Murtajapur Town railway station
    {Coordinate{77.4087, 20.6528}, CountryId{"IN"}}, // Kinkhed railway station
    {Coordinate{77.4362, 20.592}, CountryId{"IN"}}, // Vilegaon railway station
    {Coordinate{77.4527, 20.551}, CountryId{"IN"}}, // Bhadsivni railway station
    {Coordinate{77.4695, 20.5295}, CountryId{"IN"}}, // Pohe railway station
    {Coordinate{}, CountryId{"IN"}}, // Ranippet railway station
    {Coordinate{39.8464, 59.2278}, CountryId{"RU"}}, // Vologda II railway station
    {Coordinate{39.8978, 59.265}, CountryId{"RU"}}, // Rybkino railway station
    {Coordinate{37.6056, 47.1369}, CountryId{"UA"}}, // Azovstal railway station
    {Coordinate{54.6061, 53.9166}, CountryId{"RU"}}, // Aksyonovo railway station
    {Coordinate{-0.41392, 48.5583}, CountryId{"FR"}}, // Gare de Bagnoles-de-l'Orne
    {Coordinate{15.9341, 48.1881}, CountryId{"AT"}}, // Maria Anzbach railway station
    {Coordinate{15.9064, 48.1963}, CountryId{"AT"}}, // Neulengbach Stadt railway station
    {Coordinate{15.892, 48.1997}, CountryId{"AT"}}, // Neulengbach railway station
    {Coordinate{12.256, 53.4604}, CountryId{"DE"}}, // Plau am See railway station
    {Coordinate{12.2653, 53.3413}, CountryId{"DE"}}, // Wendisch Priborn railway station
    {Coordinate{12.2473, 53.3112}, CountryId{"DE"}}, // Meyenburg railway station
    {Coordinate{-119.386, 35.864}, CountryId{"US"}}, // Allensworth station
    {Coordinate{24.1858, 56.9189}, CountryId{"LV"}}, // Jāņavārti
    {Coordinate{12.0042, 57.7272}, CountryId{"SE"}}, // Gamlestaden station
    {Coordinate{6.95482, 46.0637}, CountryId{"CH"}}, // Giétroz railway station
    {Coordinate{6.95828, 46.0618}, CountryId{"CH"}}, // Le Châtelard VS Funiculaire railway station
    {Coordinate{76.9333, 24.0494}, CountryId{"IN"}}, // Pench railway station
    {Coordinate{13.0995, 47.6852}, CountryId{"AT"}}, // Hallein railway station
    {Coordinate{13.239, 47.9668}, CountryId{"AT"}}, // Steindorf bei Straßwalchen railway station
    {Coordinate{91.9463, 26.0907}, CountryId{"IN"}}, // Kamalajari railway station
    {Coordinate{90.2352, 26.2425}, CountryId{"IN"}}, // Bilasipara railway station
    {Coordinate{90.1206, 26.2045}, CountryId{"IN"}}, // Bagribari railway station
    {Coordinate{90.0256, 26.119}, CountryId{"IN"}}, // Alamganj railway station
    {Coordinate{89.9556, 26.0772}, CountryId{"IN"}}, // Gauripur railway station
    {Coordinate{15.1633, 50.9397}, CountryId{"CZ"}}, // Řasnice zastávka
    {Coordinate{25.4064, 65.1961}, CountryId{"FI"}}, // Haukipudas railway station
    {Coordinate{25.5547, 60.4081}, CountryId{"FI"}}, // Q10518700
    {Coordinate{9.96278, 53.4656}, CountryId{"DE"}}, // Heimfeld station
    {Coordinate{10.6142, 47.779}, CountryId{"DE"}}, // Marktoberdorf station
    {Coordinate{79.286, 24.8358}, CountryId{"IN"}}, // Tila railway station
    {Coordinate{79.3515, 24.8446}, CountryId{"IN"}}, // Rampura railway station
    {Coordinate{37.4914, 53.8482}, CountryId{"RU"}}, // Lazarevo
    {Coordinate{78.3387, 20.7693}, CountryId{"IN"}}, // Sorta railway station
    {Coordinate{78.3387, 20.8036}, CountryId{"IN"}}, // Virul railway station
    {Coordinate{78.3292, 20.849}, CountryId{"IN"}}, // Rohna railway station
    {Coordinate{78.324, 20.8543}, CountryId{"IN"}}, // Rohna Town railway station
    {Coordinate{78.2909, 20.8793}, CountryId{"IN"}}, // Dhanori railway station
    {Coordinate{78.2878, 20.9041}, CountryId{"IN"}}, // Pargothan railway station
    {Coordinate{78.2518, 20.9417}, CountryId{"IN"}}, // Pachegaon railway station
    {Coordinate{78.2393, 20.963}, CountryId{"IN"}}, // Khubagaon railway station
    {Coordinate{78.0158, 20.4}, CountryId{"IN"}}, // Lasina railway station
    {Coordinate{77.9202, 20.3414}, CountryId{"IN"}}, // Ladkhed railway station
    {Coordinate{77.8645, 20.342}, CountryId{"IN"}}, // Tapona railway station
    {Coordinate{77.6981, 20.3416}, CountryId{"IN"}}, // Bhandegaon railway station
    {Coordinate{77.6197, 20.3884}, CountryId{"IN"}}, // Warudkhed railway station
    {Coordinate{77.6019, 20.419}, CountryId{"IN"}}, // Sangvi railway station
    {Coordinate{77.5768, 20.4388}, CountryId{"IN"}}, // Somthan railway station
    {Coordinate{77.5327, 20.452}, CountryId{"IN"}}, // Dadgaon railway station
    {Coordinate{77.4917, 20.4863}, CountryId{"IN"}}, // Karanja Town railway station
    {Coordinate{77.3562, 20.8408}, CountryId{"IN"}}, // Lakhpuri railway station
    {Coordinate{77.3546, 20.8599}, CountryId{"IN"}}, // Bhujvad railway station
    {Coordinate{77.3294, 20.9826}, CountryId{"IN"}}, // Lehgaon railway station
    {Coordinate{77.3355, 21.0354}, CountryId{"IN"}}, // Kokalda railway station
    {Coordinate{77.3421, 21.0936}, CountryId{"IN"}}, // Kapustalni railway station
    {Coordinate{77.398, 21.1857}, CountryId{"IN"}}, // Pathrot railway station
    {Coordinate{77.4497, 21.1997}, CountryId{"IN"}}, // Khusta Buxarg railway station
    {Coordinate{77.4715, 21.2188}, CountryId{"IN"}}, // Chamak railway station
    {Coordinate{77.4935, 21.2524}, CountryId{"IN"}}, // Nowbagh railway station
    {Coordinate{78.0678, 21.4056}, CountryId{"IN"}}, // Hiwarkhed railway station
    {Coordinate{78.9098, 20.1061}, CountryId{"IN"}}, // Rajur railway station
    {Coordinate{25.4411, 65.3186}, CountryId{"FI"}}, // Ii railway station
    {Coordinate{79.1752, 19.7397}, CountryId{"IN"}}, // Gadchandur railway station
    {Coordinate{4.84807, 45.7281}, CountryId{"FR"}}, // Q105384286
    {Coordinate{79.3022, 19.7597}, CountryId{"IN"}}, // New Pandarpawani railway station
    {Coordinate{22.7147, 63.6744}, CountryId{"FI"}}, // Pietarsaari railway station
    {Coordinate{79.3696, 19.7712}, CountryId{"IN"}}, // Rajura railway station
    {Coordinate{79.3316, 18.5204}, CountryId{"IN"}}, // Sultanabad railway station
    {Coordinate{78.9894, 18.5821}, CountryId{"IN"}}, // Gangadhara railway station
    {Coordinate{78.9522, 18.6186}, CountryId{"IN"}}, // Poduru railway station
    {Coordinate{78.8237, 18.8175}, CountryId{"IN"}}, // Katlakunta Medipally railway station
    {Coordinate{78.4531, 18.8206}, CountryId{"IN"}}, // Mortad railway station
    {Coordinate{78.3112, 18.7808}, CountryId{"IN"}}, // Armur railway station
    {Coordinate{78.2824, 17.5102}, CountryId{"IN"}}, // Ramachandrapuram TS railway station
    {Coordinate{79.7038, 16.7248}, CountryId{"IN"}}, // Janpahad railway station
    {Coordinate{79.8563, 16.7827}, CountryId{"IN"}}, // Mattampally railway station
    {Coordinate{14.1625, 57.7847}, CountryId{"SE"}}, // Jönköping central station
    {Coordinate{4.91083, 45.6958}, CountryId{"FR"}}, // Q105422211
    {Coordinate{75.9863, 24.6026}, CountryId{"IN"}}, // Julmi railway station
    {Coordinate{76.1966, 24.5334}, CountryId{"IN"}}, // Jhalarapatan railway station
    {Coordinate{75.8594, 25.249}, CountryId{"IN"}}, // Tirath railway station
    {Coordinate{75.4792, 25.3094}, CountryId{"IN"}}, // Nim-ka-Khera railway station
    {Coordinate{16.36, 56.6615}, CountryId{"SE"}}, // Kalmar central station
    {Coordinate{18.5132, 49.8386}, CountryId{"CZ"}}, // Karviná-Doly
    {Coordinate{11.1921, 48.1474}, CountryId{"DE"}}, // Schöngeising railway station
    {Coordinate{78.9245, 24.7903}, CountryId{"IN"}}, // Mawai railway station
    {Coordinate{79.064, 24.8232}, CountryId{"IN"}}, // Sarkanpur railway station
    {Coordinate{79.3937, 24.854}, CountryId{"IN"}}, // Ishanagar railway station
    {Coordinate{25.6136, 60.4067}, CountryId{"FI"}}, // Kiiala train stop
    {Coordinate{41.9636, 44.6306}, CountryId{"RU"}}, // Nevinnomyskaya railway station
    {Coordinate{12.0189, 57.6557}, CountryId{"SE"}}, // Mölndal railway station
    {Coordinate{6.59336, 50.4418}, CountryId{"DE"}}, // Blankenheim (Wald) railway station
    {Coordinate{12.1753, 47.6526}, CountryId{"DE"}}, // Oberaudorf railway station
    {Coordinate{11.3065, 47.962}, CountryId{"DE"}}, // Possenhofen station
    {Coordinate{11.3719, 47.7492}, CountryId{"DE"}}, // Penzberg railway station
    {Coordinate{10.5979, 48.0059}, CountryId{"DE"}}, // Bad Wörishofen railway station
    {Coordinate{77.6711, 27.5183}, CountryId{"IN"}}, // Masani railway station
    {Coordinate{12.7985, 50.8114}, CountryId{"DE"}}, // Bahnhof Grüna
    {Coordinate{22.6919, 63.5214}, CountryId{"FI"}}, // Kovjoki railway station
    {Coordinate{17.7783, 62.9289}, CountryId{"SE"}}, // Kramfors
    {Coordinate{76.6177, 28.2468}, CountryId{"IN"}}, // Gokulgarh railway station
    {Coordinate{76.6434, 28.4864}, CountryId{"IN"}}, // Machhrauli railway station
    {Coordinate{29.2917, 46.8917}, CountryId{"MD"}}, // Bulboaca railway station
    {Coordinate{76.6297, 28.3596}, CountryId{"IN"}}, // Palhawas railway station
    {Coordinate{76.8553, 29.043}, CountryId{"IN"}}, // Mohana railway station
    {Coordinate{76.5507, 29.2391}, CountryId{"IN"}}, // Bhambewa railway station
    {Coordinate{75.0229, 30.2003}, CountryId{"IN"}}, // Bhatinda Cantt. Jn. Cabin railway station
    {Coordinate{73.6476, 29.3078}, CountryId{"IN"}}, // Raghunathgarh railway station
    {Coordinate{74.5871, 29.5118}, CountryId{"IN"}}, // Talwara Jhil railway station
    {Coordinate{12.0798, 57.4905}, CountryId{"SE"}}, // Kungsbacka railway station
    {Coordinate{25.1016, 60.457}, CountryId{"FI"}}, // Ainola railway station
    {Coordinate{13.1114, 55.7944}, CountryId{"SE"}}, // Kävlinge railway station
    {Coordinate{12.8572, 55.8791}, CountryId{"SE"}}, // Landskrona railway station
    {Coordinate{5.35917, 43.3265}, CountryId{"FR"}}, // Gare de Marseille-Arenc
    {Coordinate{23.2369, 59.9041}, CountryId{"FI"}}, // Lappohja railway station
    {Coordinate{12.4601, 51.3694}, CountryId{"DE"}}, // Leipzig-Heiterblick railway station
    {Coordinate{14.6164, 58.9892}, CountryId{"SE"}}, // Laxå railway station
    {Coordinate{71.8167, 23.9667}, CountryId{"IN"}}, // Shihori Railway Station
    {Coordinate{72.0341, 24.0237}, CountryId{"IN"}}, // Wayad railway station
    {Coordinate{72.065, 23.93}, CountryId{"IN"}}, // Kansa railway station
    {Coordinate{72.1449, 23.7285}, CountryId{"IN"}}, // Jitoda railway station
    {Coordinate{72.2383, 23.7316}, CountryId{"IN"}}, // Manund railway station
    {Coordinate{72.0804, 23.6575}, CountryId{"IN"}}, // Brahmanvada railway station
    {Coordinate{72.0293, 23.5161}, CountryId{"IN"}}, // Sankhalpur railway station
    {Coordinate{70.5423, 22.9481}, CountryId{"IN"}}, // Lavanpur railway station
    {Coordinate{70.4497, 22.9583}, CountryId{"IN"}}, // Navlakhi railway station
    {Coordinate{69.9808, 23.1583}, CountryId{"IN"}}, // Sapda railway station
    {Coordinate{69.3282, 23.2241}, CountryId{"IN"}}, // Sukhpur Roha railway station
    {Coordinate{69.2066, 23.2139}, CountryId{"IN"}}, // Sanosara railway station
    {Coordinate{69.1099, 23.19}, CountryId{"IN"}}, // Mothala railway station
    {Coordinate{69.0283, 23.154}, CountryId{"IN"}}, // Dhanvala Vada railway station
    {Coordinate{68.944, 23.1264}, CountryId{"IN"}}, // Kothara railway station
    {Coordinate{69.5576, 22.7638}, CountryId{"IN"}}, // West Port railway station
    {Coordinate{69.6024, 22.8089}, CountryId{"IN"}}, // Navinal railway station
    {Coordinate{69.6724, 22.7968}, CountryId{"IN"}}, // Dhrub railway station
    {Coordinate{69.7591, 22.8353}, CountryId{"IN"}}, // Mundra Airport Road railway station
    {Coordinate{69.8343, 22.8825}, CountryId{"IN"}}, // Bhadreshwar Road railway station
    {Coordinate{69.9173, 22.9623}, CountryId{"IN"}}, // Vasai Third Road railway station
    {Coordinate{70.0419, 22.5045}, CountryId{"IN"}}, // Bedeshwar Windmill railway station
    {Coordinate{69.8636, 22.3848}, CountryId{"IN"}}, // Moti Khawdi railway station
    {Coordinate{75.2395, 31.4866}, CountryId{"IN"}}, // Bhalojala railway station
    {Coordinate{75.1868, 31.4559}, CountryId{"IN"}}, // Saidpur Jalalabad railway station
    {Coordinate{75.1166, 31.4158}, CountryId{"IN"}}, // Khadur Sahib railway station
    {Coordinate{75.1101, 31.3707}, CountryId{"IN"}}, // Govindwal Sahib railway station
    {Coordinate{12.2728, 57.7694}, CountryId{"SE"}}, // Lerum railway station
    {Coordinate{76.0107, 27.9665}, CountryId{"IN"}}, // Nizampur railway station
    {Coordinate{75.6018, 28.1862}, CountryId{"IN"}}, // Nari Khetri railway station
    {Coordinate{75.7973, 28.3835}, CountryId{"IN"}}, // Bhavdhari railway station
    {Coordinate{74.5545, 30.9879}, CountryId{"IN"}}, // Husainiwala railway station
    {Coordinate{74.6118, 31.1677}, CountryId{"IN"}}, // Rattoke Gurdwara railway station
    {Coordinate{74.6677, 31.1973}, CountryId{"IN"}}, // Valtoha railway station
    {Coordinate{74.733, 31.2233}, CountryId{"IN"}}, // Gharyala railway station
    {Coordinate{74.7822, 31.2431}, CountryId{"IN"}}, // Boparai railway station
    {Coordinate{74.8687, 31.336}, CountryId{"IN"}}, // Kairon railway station
    {Coordinate{74.885, 31.3783}, CountryId{"IN"}}, // Jandoke railway station
    {Coordinate{74.9112, 31.4114}, CountryId{"IN"}}, // Rure Asal railway station
    {Coordinate{74.909, 31.4998}, CountryId{"IN"}}, // Dukhnawaran railway station
    {Coordinate{74.8994, 31.5327}, CountryId{"IN"}}, // Gohlwar Varpal railway station
    {Coordinate{75.2892, 31.83}, CountryId{"IN"}}, // Vadala Granthian railway station
    {Coordinate{75.5871, 31.1821}, CountryId{"IN"}}, // Thabalke railway station
    {Coordinate{76.1277, 31.1678}, CountryId{"IN"}}, // Alachor railway station
    {Coordinate{8.9388, 49.8945}, CountryId{"DE"}}, // Groß-Umstadt Klein-Umstadt railway station
    {Coordinate{8.9243, 49.8648}, CountryId{"DE"}}, // Groß-Umstadt Mitte railway station
    {Coordinate{8.6876, 49.8608}, CountryId{"DE"}}, // Darmstadt TU-Lichtwiese railway station
    {Coordinate{79.8647, 23.1414}, CountryId{"IN"}}, // Garha railway station
    {Coordinate{11.56, 48.1413}, CountryId{"DE"}}, // München Hbf (tief) station
    {Coordinate{94.752, 26.917}, CountryId{"IN"}}, // Simaluguri Junction railway station
    {Coordinate{76.8307, 17.3821}, CountryId{"IN"}}, // Taj Sultanpur railway station
    {Coordinate{76.8954, 17.476}, CountryId{"IN"}}, // Kurukotta railway station
    {Coordinate{76.9797, 17.5868}, CountryId{"IN"}}, // Kamalapur railway station
    {Coordinate{77.0686, 17.6711}, CountryId{"IN"}}, // Hallikhed K. railway station
    {Coordinate{10.7324, 48.3337}, CountryId{"DE"}}, // Gessertshausen station
    {Coordinate{76.0084, 31.7711}, CountryId{"IN"}}, // Daulatpur Chauk railway station
    {Coordinate{78.2781, 30.11}, CountryId{"IN"}}, // Yog Nagari Rishikesh railway station
    {Coordinate{77.1144, 30.9292}, CountryId{"IN"}}, // Solan Brewery railway station
    {Coordinate{7.37835, 49.252}, CountryId{"DE"}}, // Zweibrücken Rosengarten
    {Coordinate{7.81086, 48.0288}, CountryId{"DE"}}, // Freiburg-Landwasser station
    {Coordinate{11.3943, 50.95}, CountryId{"DE"}}, // Mellingen
    {Coordinate{45.4103, 50.0928}, CountryId{"RU"}}, // Q105708044
    {Coordinate{79.3027, 14.055}, CountryId{"IN"}}, // Mangampet Road railway station
    {Coordinate{79.3993, 14.1421}, CountryId{"IN"}}, // Cherlopalli railway station
    {Coordinate{79.559, 14.2299}, CountryId{"IN"}}, // Rapuru railway station
    {Coordinate{79.6134, 14.2759}, CountryId{"IN"}}, // Adurupalli railway station
    {Coordinate{79.8438, 14.3193}, CountryId{"IN"}}, // Kasumuru railway station
    {Coordinate{79.9365, 16.8126}, CountryId{"IN"}}, // Mellacheruvu railway station
    {Coordinate{80.0068, 16.852}, CountryId{"IN"}}, // Revur Ramapuram railway station
    {Coordinate{80.1894, 16.9128}, CountryId{"IN"}}, // Makkapeta railway station
    {Coordinate{83.6163, 20.7355}, CountryId{"IN"}}, // Bichhupali railway station
    {Coordinate{75.1719, 29.0067}, CountryId{"IN"}}, // Kalana railway station
    {Coordinate{18.9611, 47.5358}, CountryId{"HU"}}, // Hárshegy
    {Coordinate{74.564, 28.0606}, CountryId{"IN"}}, // Payli railway station
    {Coordinate{71.9749, 24.176}, CountryId{"IN"}}, // Khemana railway station
    {Coordinate{7.8333, 47.6539}, CountryId{"DE"}}, // Schopfheim-Schlattholz station
    {Coordinate{71.7906, 23.1826}, CountryId{"IN"}}, // Patdi railway station
    {Coordinate{76.6406, 18.9296}, CountryId{"IN"}}, // Vadgaon Nila railway station
    {Coordinate{76.3174, 12.9428}, CountryId{"IN"}}, // Samudhravalli railway station
    {Coordinate{74.7694, 30.6706}, CountryId{"IN"}}, // Faridnagar railway station
    {Coordinate{74.6841, 31.606}, CountryId{"IN"}}, // Gurusar Sutlani railway station
    {Coordinate{17.1675, 59.2486}, CountryId{"SE"}}, // Läggesta railway station
    {Coordinate{61.365, 54.4442}, CountryId{"RU"}}, // Q105751765
    {Coordinate{10.0058, 57.4549}, CountryId{"DK"}}, // Hjørring East station
    {Coordinate{92.772, 26.8192}, CountryId{"IN"}}, // Balipara railway station
    {Coordinate{72.711, 23.9591}, CountryId{"IN"}}, // Taranga Hill railway station
    {Coordinate{75.7341, 22.6192}, CountryId{"IN"}}, // Tihi railway station
    {Coordinate{76.6401, 28.7415}, CountryId{"IN"}}, // Dighal railway station
    {Coordinate{79.5605, 10.4434}, CountryId{"IN"}}, // Tillaivilagam railway station
    {Coordinate{78.8731, 10.1216}, CountryId{"IN"}}, // Periyakottai railway station
    {Coordinate{71.4742, 20.9318}, CountryId{"IN"}}, // Pipavav railway station
    {Coordinate{71.3919, 23.1356}, CountryId{"IN"}}, // Kuda railway station
    {Coordinate{75.6509, 16.1228}, CountryId{"IN"}}, // Sulikeri railway station
    {Coordinate{80.006, 14.2644}, CountryId{"IN"}}, // Nidiguntapalem railway station
    {Coordinate{77.582, 27.5114}, CountryId{"IN"}}, // Mora railway station
    {Coordinate{79.6402, 10.6052}, CountryId{"IN"}}, // Alattambadi railway station
    {Coordinate{79.6154, 10.4771}, CountryId{"IN"}}, // Pandi railway station
    {Coordinate{75.468, 16.1643}, CountryId{"IN"}}, // Kajjidoni railway station
    {Coordinate{31.1444, 54.9156}, CountryId{"RU"}}, // 450 km
    {Coordinate{12.223, 47.4414}, CountryId{"AT"}}, // Westendorf in Tirol railway station
    {Coordinate{7.61168, 47.6128}, CountryId{"DE"}}, // Haltingen station
    {Coordinate{11.4136, 48.1053}, CountryId{"DE"}}, // Planegg station
    {Coordinate{11.3761, 48.0707}, CountryId{"DE"}}, // Gauting station
    {Coordinate{11.4008, 48.0933}, CountryId{"DE"}}, // Stockdorf station
    {Coordinate{11.4256, 48.1198}, CountryId{"DE"}}, // Gräfelfing station
    {Coordinate{11.4309, 48.1282}, CountryId{"DE"}}, // Lochham station
    {Coordinate{28.7883, 61.1702}, CountryId{"FI"}}, // Imatrankoski railway station
    {Coordinate{12.7793, 50.1585}, CountryId{"CZ"}}, // Horní Slavkov zastávka
    {Coordinate{12.7722, 50.1718}, CountryId{"CZ"}}, // Q105853472
    {Coordinate{27.5792, 64.0647}, CountryId{"FI"}}, // Murtomäki railway station
    {Coordinate{12.6492, 55.6308}, CountryId{"DK"}}, // Lufthavnen Metro Station
    {Coordinate{126.624, 45.7585}, CountryId{"CN"}}, // Harbin railway station
    {Coordinate{142.745, 46.8866}, CountryId{"RU"}}, // Q105947229
    {Coordinate{142.728, 46.9441}, CountryId{"RU"}}, // Pedinstitut
    {Coordinate{142.771, 46.622}, CountryId{"RU"}}, // Pyat Uglov railway station
    {Coordinate{142.77, 46.6251}, CountryId{"RU"}}, // Q105947504
    {Coordinate{38.6851, 55.0701}, CountryId{"RU"}}, // Lystsovskaya
    {Coordinate{38.6565, 55.0619}, CountryId{"RU"}}, // Semyonovsky
    {Coordinate{143.021, 49.243}, CountryId{"RU"}}, // Q105955519
    {Coordinate{142.936, 49.2478}, CountryId{"RU"}}, // Q105955524
    {Coordinate{38.6224, 55.0313}, CountryId{"RU"}}, // 18 km
    {Coordinate{38.606, 54.9868}, CountryId{"RU"}}, // Kudryavtsevo
    {Coordinate{38.582, 54.9464}, CountryId{"RU"}}, // Danilovskaya
    {Coordinate{38.5561, 54.9244}, CountryId{"RU"}}, // 30 km
    {Coordinate{13.7649, 51.374}, CountryId{"DE"}}, // Bahnhof Ortrand
    {Coordinate{17.9426, 58.9139}, CountryId{"SE"}}, // Nynäsgård railway station
    {Coordinate{12.7944, 52.9266}, CountryId{"DE"}}, // Neuruppin West railway station
    {Coordinate{34.7086, 48.4853}, CountryId{"UA"}}, // 11 km
    {Coordinate{15.3047, 62.8299}, CountryId{"SE"}}, // Stavre
    {Coordinate{15.2287, 62.9113}, CountryId{"SE"}}, // Gällö
    {Coordinate{13.3766, 52.5094}, CountryId{"DE"}}, // Potsdamer Platz S-Bahn station
    {Coordinate{15.0408, 62.9548}, CountryId{"SE"}}, // Pilgrimstad
    {Coordinate{7.14385, 50.5474}, CountryId{"DE"}}, // Bahnhof Bad Neuenahr
    {Coordinate{11.1794, 48.8936}, CountryId{"DE"}}, // Eichstätt Stadt
    {Coordinate{11.168, 48.8754}, CountryId{"DE"}}, // Wasserzell (b Eichstätt)
    {Coordinate{11.1695, 48.8922}, CountryId{"DE"}}, // Rebdorf-Hofmühle
    {Coordinate{16.4575, 57.2631}, CountryId{"SE"}}, // Oskarshamn railway station
    {Coordinate{7.66268, 46.5574}, CountryId{"CH"}}, // Kandergrund railway station
    {Coordinate{8.62248, 46.7294}, CountryId{"CH"}}, // Gurtnellen railway station
    {Coordinate{8.67211, 46.781}, CountryId{"CH"}}, // Amsteg-Silenen railway station
    {Coordinate{37.6553, 55.7763}, CountryId{"RU"}}, // Moscow Oktyabrskaya station
    {Coordinate{8.74056, 46.4902}, CountryId{"CH"}}, // Rodi-Fiesso railway station
    {Coordinate{7.05695, 49.2436}, CountryId{"DE"}}, // Scheidt (Saar) station
    {Coordinate{3.46114, 46.0618}, CountryId{"FR"}}, // Gare de Saint-Yorre
    {Coordinate{18.6274, 46.2361}, CountryId{"HU"}}, // Q106303576
    {Coordinate{33.1247, 57.1338}, CountryId{"RU"}}, // Ostashkov
    {Coordinate{9.01696, 46.2532}, CountryId{"CH"}}, // Claro railway station
    {Coordinate{8.9944, 46.2992}, CountryId{"CH"}}, // Osogna-Cresciano railway station
    {Coordinate{13.6577, 63.3086}, CountryId{"SE"}}, // Mörsil
    {Coordinate{24.147, 41.1404}, CountryId{"GR"}}, // Drama railway station
    {Coordinate{8.65052, 46.7601}, CountryId{"CH"}}, // Intschi railway station
    {Coordinate{34.1121, 57.8569}, CountryId{"RU"}}, // Bologoe-Polotskoye
    {Coordinate{-1.56606, 48.5298}, CountryId{"FR"}}, // Pleine-Fougères railway station
    {Coordinate{9.52691, 49.202}, CountryId{"DE"}}, // Öhringen-Cappel
    {Coordinate{8.77518, 49.1362}, CountryId{"DE"}}, // Menzingen (Baden)
    {Coordinate{8.10606, 47.9063}, CountryId{"DE"}}, // Hinterzarten
    {Coordinate{9.28621, 49.1482}, CountryId{"DE"}}, // Bahnhof Weinsberg
    {Coordinate{8.55052, 48.7486}, CountryId{"DE"}}, // Bad Wildbad Kurpark
    {Coordinate{28.2942, 53.0803}, CountryId{"BY"}}, // Alyaksandrawka
    {Coordinate{10.0899, 46.6977}, CountryId{"CH"}}, // Zernez railway station
    {Coordinate{9.90568, 46.4856}, CountryId{"CH"}}, // Surovas railway station
    {Coordinate{10.0543, 46.3248}, CountryId{"CH"}}, // Poschiavo railway station
    {Coordinate{10.0996, 46.2731}, CountryId{"CH"}}, // Miralago railway station
    {Coordinate{8.40432, 46.5672}, CountryId{"CH"}}, // Muttbach-Belvédère railway station
    {Coordinate{8.76977, 46.6811}, CountryId{"CH"}}, // Sedrun railway station
    {Coordinate{8.508, 47.3647}, CountryId{"CH"}}, // Zürich Friesenberg railway station
    {Coordinate{8.62075, 46.9493}, CountryId{"CH"}}, // Sisikon railway station
    {Coordinate{7.95892, 46.7366}, CountryId{"CH"}}, // Oberried am Brienzersee railway station
    {Coordinate{7.99002, 46.7526}, CountryId{"CH"}}, // Ebligen railway station
    {Coordinate{8.31016, 46.9826}, CountryId{"CH"}}, // Hergiswil railway station
    {Coordinate{8.3033, 47.0351}, CountryId{"CH"}}, // Lucerne Allmend/Messe railway station
    {Coordinate{8.54448, 47.2867}, CountryId{"CH"}}, // Langnau-Gattikon railway station
    {Coordinate{8.53508, 47.2967}, CountryId{"CH"}}, // Wildpark-Höfli railway station
    {Coordinate{8.52522, 47.3032}, CountryId{"CH"}}, // Sihlau railway station
    {Coordinate{8.5215, 47.3197}, CountryId{"CH"}}, // Sood-Oberleimbach railway station
    {Coordinate{8.87823, 47.3688}, CountryId{"CH"}}, // Bauma railway station
    {Coordinate{8.75207, 47.2359}, CountryId{"CH"}}, // Uerikon railway station
    {Coordinate{9.3103, 46.8074}, CountryId{"CH"}}, // Versam-Safien railway station
    {Coordinate{9.70333, 46.7978}, CountryId{"CH"}}, // Litzirüti railway station
    {Coordinate{3.71896, 45.2763}, CountryId{"FR"}}, // Gare de Sembadel
    {Coordinate{29.9498, 56.039}, CountryId{"RU"}}, // Nevel I
    {Coordinate{11.0611, 50.561}, CountryId{"DE"}}, // Katzhütte
    {Coordinate{8.59615, 47.3973}, CountryId{"CH"}}, // Stettbach, Bahnhof
    {Coordinate{9.11748, 51.4079}, CountryId{"DE"}}, // Volkmarsen
    {Coordinate{5.36634, 43.305}, CountryId{"FR"}}, // Q106452859
    {Coordinate{10.8696, 48.0542}, CountryId{"DE"}}, // Landsberg (Lech) Schule station
    {Coordinate{10.1036, 48.8586}, CountryId{"DE"}}, // Wasseralfingen station
    {Coordinate{12.7275, 56.0236}, CountryId{"SE"}}, // Ramlösa railway station
    {Coordinate{39.3626, 54.7159}, CountryId{"RU"}}, // Zhitovo
    {Coordinate{39.7372, 47.1065}, CountryId{"RU"}}, // Stroydetal railway station
    {Coordinate{33.9465, 54.0121}, CountryId{"RU"}}, // Betlitsa
    {Coordinate{11.043, 47.481}, CountryId{"DE"}}, // Untergrainau train station
    {Coordinate{11.2801, 50.9004}, CountryId{"DE"}}, // Bad Berka Zeughausplatz
    {Coordinate{9.96922, 53.5644}, CountryId{"DE"}}, // Sternschanze
    {Coordinate{9.38146, 50.0224}, CountryId{"DE"}}, // Heigenbrücken
    {Coordinate{16.0952, 38.4194}, CountryId{"IT"}}, // Stazione di Cinquefrondi
    {Coordinate{9.33798, 47.3214}, CountryId{"CH"}}, // Gonten Alpsteinblick railway station
    {Coordinate{23.3211, 41.0425}, CountryId{"GR"}}, // Rodopoli railway station
    {Coordinate{16.0932, 38.3905}, CountryId{"IT"}}, // San Giorgio Morgeto railway station
    {Coordinate{16.0756, 38.3561}, CountryId{"IT"}}, // Cittanova railway station
    {Coordinate{16.0107, 38.3502}, CountryId{"IT"}}, // Q106611014
    {Coordinate{}, CountryId{"IT"}}, // Q106611016
    {Coordinate{}, CountryId{"IT"}}, // Q106611020
    {Coordinate{39.6114, 47.2484}, CountryId{"RU"}}, // Rostov-Zapadnyi
    {Coordinate{39.2436, 54.7111}, CountryId{"RU"}}, // Kostyonkovo
    {Coordinate{16.4602, 47.834}, CountryId{"AT"}}, // Bahnhof Müllendorf
    {Coordinate{10.8326, 48.1554}, CountryId{"DE"}}, // Klosterlechfeld station
    {Coordinate{10.8442, 48.1829}, CountryId{"DE"}}, // Lagerlechfeld station
    {Coordinate{10.8518, 48.2359}, CountryId{"DE"}}, // Oberottmarshausen station
    {Coordinate{10.8524, 48.1991}, CountryId{"DE"}}, // Graben (Lechfeld) Gewerbepark station
    {Coordinate{-0.94483, 43.3915}, CountryId{"FR"}}, // Q106660716
    {Coordinate{39.2305, 54.7087}, CountryId{"RU"}}, // Latygory
    {Coordinate{6.89185, 49.4073}, CountryId{"DE"}}, // Lebach-Jabach station
    {Coordinate{4.78328, 44.8059}, CountryId{"FR"}}, // Q106686055
    {Coordinate{13.755, 50.636}, CountryId{"CZ"}}, // Jeníkov-Oldřichov
    {Coordinate{14.1521, 49.3021}, CountryId{"CZ"}}, // Písek jih
    {Coordinate{14.0011, 49.6741}, CountryId{"CZ"}}, // Příbram sídliště
    {Coordinate{13.8522, 58.3894}, CountryId{"SE"}}, // Skövde Central Station
    {Coordinate{36.0409, 54.467}, CountryId{"RU"}}, // Vorotynsk
    {Coordinate{39.0499, 54.6438}, CountryId{"RU"}}, // 35 km
    {Coordinate{0.747761, 47.8302}, CountryId{"FR"}}, // Q106764524
    {Coordinate{16.9397, 48.7839}, CountryId{"CZ"}}, // Hrušky
    {Coordinate{39.0051, 54.6269}, CountryId{"RU"}}, // Vereykino
    {Coordinate{38.9643, 54.6025}, CountryId{"RU"}}, // Zhokovo
    {Coordinate{35.7391, 54.3881}, CountryId{"RU"}}, // Babynino
    {Coordinate{15.5408, 48.7484}, CountryId{"AT"}}, // Bahnhof Irnfritz
    {Coordinate{17.0281, 59.3703}, CountryId{"SE"}}, // Strängnäs railway station
    {Coordinate{38.9126, 54.5835}, CountryId{"RU"}}, // 24 km
    {Coordinate{13.8007, 48.0789}, CountryId{"AT"}}, // Breitenschützing railway station
    {Coordinate{14.1554, 47.833}, CountryId{"AT"}}, // Bahnhof Klaus
    {Coordinate{14.7244, 50.9523}, CountryId{"DE"}}, // railway stop Niederoderwitz
    {Coordinate{38.8788, 54.5705}, CountryId{"RU"}}, // 22 km
    {Coordinate{14.6787, 50.9739}, CountryId{"DE"}}, // railway stop Oberoderwitz Oberdorf
    {Coordinate{38.8339, 54.5747}, CountryId{"RU"}}, // 18 km
    {Coordinate{7.12088, 49.9516}, CountryId{"DE"}}, // Traben-Trarbach
    {Coordinate{38.7767, 54.5411}, CountryId{"RU"}}, // 12 km
    {Coordinate{13.8383, 46.6087}, CountryId{"AT"}}, // Villach Westbahnhof
    {Coordinate{17.3156, 62.3863}, CountryId{"SE"}}, // Sundsvall central station
    {Coordinate{17.2923, 62.3896}, CountryId{"SE"}}, // Sundsvall West
    {Coordinate{2.94991, 50.5332}, CountryId{"FR"}}, // Q106855089
    {Coordinate{11.0486, 51.8826}, CountryId{"DE"}}, // Bahnhof Halberstadt-Spiegelsberge
    {Coordinate{35.5432, 54.2504}, CountryId{"RU"}}, // Kudrinskaya
    {Coordinate{9.23206, 48.8037}, CountryId{"DE"}}, // Ebitzweg
    {Coordinate{15.7527, 50.0935}, CountryId{"CZ"}}, // Stéblová obec
    {Coordinate{15.2025, 59.2697}, CountryId{"SE"}}, // Örebro southern station
    {Coordinate{14.5834, 56.0495}, CountryId{"SE"}}, // Sölvesborgs station
    {Coordinate{2.88274, 47.5187}, CountryId{"FR"}}, // Neuvy-sur-Loire Train Station
    {Coordinate{34.7892, 53.6089}, CountryId{"RU"}}, // Sudimir
    {Coordinate{33.2451, 57.9698}, CountryId{"RU"}}, // Valday train station
    {Coordinate{33.3107, 57.9525}, CountryId{"RU"}}, // Chernushki
    {Coordinate{10.376, 48.4818}, CountryId{"DE"}}, // Offingen station
    {Coordinate{10.4079, 48.456}, CountryId{"DE"}}, // Mindelaltheim station
    {Coordinate{10.427, 48.4248}, CountryId{"DE"}}, // Burgau (Schwab) station
    {Coordinate{10.4455, 48.3991}, CountryId{"DE"}}, // Jettingen station
    {Coordinate{10.5022, 48.3847}, CountryId{"DE"}}, // Freihalden station
    {Coordinate{10.6963, 48.3348}, CountryId{"DE"}}, // Kutzenhausen station
    {Coordinate{10.0479, 48.433}, CountryId{"DE"}}, // Thalfingen (b Ulm) station
    {Coordinate{10.7768, 48.3561}, CountryId{"DE"}}, // Diedorf (Schwab)
    {Coordinate{10.8182, 48.386}, CountryId{"DE"}}, // Westheim (Schwab) station
    {Coordinate{10.8335, 48.3944}, CountryId{"DE"}}, // Neusäß station
    {Coordinate{34.7201, 53.4997}, CountryId{"RU"}}, // Berezovsky
    {Coordinate{-0.3958, 51.6635}, CountryId{"GB"}}, // Watford Junction railway station
    {Coordinate{11.2008, 49.4716}, CountryId{"DE"}}, // Schwaig
    {Coordinate{11.2307, 49.4793}, CountryId{"DE"}}, // Röthenbach (Pegnitz)
    {Coordinate{11.2461, 49.4834}, CountryId{"DE"}}, // Röthenbach-Steinberg
    {Coordinate{11.2615, 49.4916}, CountryId{"DE"}}, // Röthenbach-Seespitze
    {Coordinate{11.278, 49.5013}, CountryId{"DE"}}, // Lauf West
    {Coordinate{11.2859, 49.507}, CountryId{"DE"}}, // Lauf (links Pegnitz)
    {Coordinate{11.3395, 49.5078}, CountryId{"DE"}}, // Ottensoos
    {Coordinate{2.30889, 48.8911}, CountryId{"FR"}}, // Gare de Paris-Batignolles
    {Coordinate{13.6836, 47.5575}, CountryId{"AT"}}, // Obertraun-Dachsteinhöhlen railway station
    {Coordinate{11.0444, 49.338}, CountryId{"DE"}}, // Schwabach-Limbach
    {Coordinate{9.07148, 48.8705}, CountryId{"DE"}}, // Schwieberdingen
    {Coordinate{12.0599, 48.0829}, CountryId{"DE"}}, // Tulling
    {Coordinate{13.1611, 49.0208}, CountryId{"DE"}}, // Langdorf
    {Coordinate{11.0638, 49.3039}, CountryId{"DE"}}, // Rednitzhembach
    {Coordinate{11.0743, 49.2676}, CountryId{"DE"}}, // Büchenbach
    {Coordinate{11.4137, 49.2883}, CountryId{"DE"}}, // Pölling
    {Coordinate{}, CountryId{"IT"}}, // Q107034035
    {Coordinate{-0.244167, 51.5319}, CountryId{"GB"}}, // Willesden Junction
    {Coordinate{17.9036, 59.2053}, CountryId{"SE"}}, // Tullinge railway station
    {Coordinate{39.7453, 47.1005}, CountryId{"RU"}}, // Tehnikum railway station
    {Coordinate{39.6351, 47.1904}, CountryId{"RU"}}, // Gnilovskaya railway station
    {Coordinate{11.923, 58.354}, CountryId{"SE"}}, // Uddevalla central station
    {Coordinate{10.413, 49.5066}, CountryId{"DE"}}, // Bad Windsheim
    {Coordinate{10.5882, 49.5767}, CountryId{"DE"}}, // Neustadt (Aisch) Bahnhof
    {Coordinate{10.6097, 49.5743}, CountryId{"DE"}}, // Neustadt (Aisch) Mitte
    {Coordinate{10.8855, 49.9292}, CountryId{"DE"}}, // Hallstadt (b Bamberg)
    {Coordinate{12.1643, 53.1446}, CountryId{"DE"}}, // Pritzwalk West
    {Coordinate{12.3175, 58.3775}, CountryId{"SE"}}, // Vänersborg railway station
    {Coordinate{4.54806, 47.8736}, CountryId{"FR"}}, // Gare de Sainte-Colombe-sur-Seine
    {Coordinate{10.7802, 51.834}, CountryId{"DE"}}, // Bahnhof Wernigerode Westerntor
    {Coordinate{12.8537, 56.246}, CountryId{"SE"}}, // Ängelholm station
    {Coordinate{18.7052, 63.2879}, CountryId{"SE"}}, // Örnsköldsvik Central station
    {Coordinate{14.0928, 51.4471}, CountryId{"DE"}}, // Lauta (Niederlausitz)
    {Coordinate{16.3194, 57.99}, CountryId{"SE"}}, // Överums Bruk railway station
    {Coordinate{9.00614, 47.85}, CountryId{"DE"}}, // Stockach station
    {Coordinate{-2.45519, 36.8352}, CountryId{"ES"}}, // Almería Intermodal Station
    {Coordinate{39.6593, 55.474}, CountryId{"RU"}}, // Osanovo
    {Coordinate{9.75221, 47.925}, CountryId{"DE"}}, // Bad Waldsee station
    {Coordinate{9.3441, 47.9228}, CountryId{"DE"}}, // Burgweiler station
    {Coordinate{33.8454, 61.877}, CountryId{"RU"}}, // 509 km railway halt, Pryazhinsky District
    {Coordinate{9.03516, 48.6704}, CountryId{"DE"}}, // Böblingen Zimmerschlag
    {Coordinate{9.01079, 48.6772}, CountryId{"DE"}}, // Böblingen Südbahnhof
    {Coordinate{9.00861, 48.6445}, CountryId{"DE"}}, // Holzgerlingen Hülben
    {Coordinate{17.561, 46.6821}, CountryId{"HU"}}, // Csisztafürdő railway station
    {Coordinate{52.0089, 55.3127}, CountryId{"RU"}}, // Zäy
    {Coordinate{9.3789, 47.9465}, CountryId{"DE"}}, // Ostrach station
    {Coordinate{9.25573, 47.9229}, CountryId{"DE"}}, // Pfullendorf railway stop
    {Coordinate{39.6734, 55.4006}, CountryId{"RU"}}, // Pozhoga
    {Coordinate{8.86091, 48.4491}, CountryId{"DE"}}, // Bieringen (b Horb) station
    {Coordinate{8.89668, 48.4606}, CountryId{"DE"}}, // Bad Niedernau station
    {Coordinate{39.645, 55.3333}, CountryId{"RU"}}, // 29 km
    {Coordinate{8.97405, 48.4795}, CountryId{"DE"}}, // Kiebingen railway stop
    {Coordinate{9.03034, 48.3956}, CountryId{"DE"}}, // Bad Sebastiansweiler-Belsen railway stop
    {Coordinate{6.55706, 49.6061}, CountryId{"DE"}}, // Saarburg train station
    {Coordinate{7.18825, 43.7207}, CountryId{"FR"}}, // Gare de Lingostière
    {Coordinate{6.8912, 43.9547}, CountryId{"FR"}}, // Category:Gare de Puget-Théniers
    {Coordinate{7.19667, 43.8575}, CountryId{"FR"}}, // Plan-du-Var railway station
    {Coordinate{0.869225, 47.758}, CountryId{"FR"}}, // railway station of Montoire-sur-le-Loir
    {Coordinate{8.99723, 48.6789}, CountryId{"DE"}}, // Böblingen Danziger Straße
    {Coordinate{8.98236, 48.6792}, CountryId{"DE"}}, // Haltepunkt Böblingen-Hulb
    {Coordinate{9.02563, 48.6756}, CountryId{"DE"}}, // Böblingen Heusteigstraße
    {Coordinate{9.02445, 48.6268}, CountryId{"DE"}}, // Holzgerlingen Buch
    {Coordinate{9.04263, 48.6202}, CountryId{"DE"}}, // Weil im Schönbuch Troppel
    {Coordinate{9.04999, 48.6208}, CountryId{"DE"}}, // Weil im Schönbuch Röte
    {Coordinate{9.06235, 48.6204}, CountryId{"DE"}}, // Weil im Schönbuch Untere Halde
    {Coordinate{9.09326, 48.6067}, CountryId{"DE"}}, // Dettenhausen
    {Coordinate{4.70585, 49.3895}, CountryId{"FR"}}, // Gare ferroviaire de Vouziers
    {Coordinate{39.6496, 55.2634}, CountryId{"RU"}}, // Barmino
    {Coordinate{9.62132, 47.8307}, CountryId{"DE"}}, // Niederbiegen station
    {Coordinate{9.59462, 47.7659}, CountryId{"DE"}}, // Weißenau railway stop
    {Coordinate{39.6632, 55.2243}, CountryId{"RU"}}, // Sazonovo
    {Coordinate{12.0178, 41.9973}, CountryId{"IT"}}, // Furbara railway station
    {Coordinate{12.6483, 37.9766}, CountryId{"IT"}}, // Dattilo-Napola railway station
    {Coordinate{14.7479, 47.1896}, CountryId{"AT"}}, // Zeltweg railway station
    {Coordinate{39.753, 47.1113}, CountryId{"RU"}}, // VCD railway station
    {Coordinate{14.309, 47.7243}, CountryId{"AT"}}, // Bahnhof Roßleithen
    {Coordinate{12.5942, 51.2771}, CountryId{"DE"}}, // Naunhof
    {Coordinate{60.4565, 55.9122}, CountryId{"RU"}}, // Category:Mauk railway station
    {Coordinate{2.63222, 48.0425}, CountryId{"FR"}}, // Gare de Mignères - Gondreville
    {Coordinate{2.55139, 48.0661}, CountryId{"FR"}}, // Gare de Lorcy-Corbeilles
    {Coordinate{2.23778, 48.2364}, CountryId{"FR"}}, // Gare d'Engenville
    {Coordinate{9.61697, 47.817}, CountryId{"DE"}}, // Weingarten/Berg railway stop
    {Coordinate{7.45997, 51.4967}, CountryId{"DE"}}, // Westfalenhallen station
    {Coordinate{12.4963, 49.6397}, CountryId{"DE"}}, // Waidhaus
    {Coordinate{12.0613, 49.6313}, CountryId{"DE"}}, // Weiherhammer
    {Coordinate{39.6207, 55.1898}, CountryId{"RU"}}, // 47 km
    {Coordinate{7.96325, 51.1535}, CountryId{"DE"}}, // Heggen station
    {Coordinate{15.9851, 41.9366}, CountryId{"IT"}}, // Peschici Calenella railway station
    {Coordinate{-3.51128, 43.0799}, CountryId{"ES"}}, // Quintana de los Prados railway station
    {Coordinate{11.9942, 57.6975}, CountryId{"SE"}}, // Liseberg station
    {Coordinate{10.7435, 51.8201}, CountryId{"DE"}}, // Q108053440
    {Coordinate{15.986, 47.3903}, CountryId{"AT"}}, // Rohrbach-Vorau railway station
    {Coordinate{35.2174, 54.0231}, CountryId{"RU"}}, // Zhivodovka
    {Coordinate{1.515, 48.4258}, CountryId{"FR"}}, // Q108112580
    {Coordinate{1.6687, 48.3223}, CountryId{"FR"}}, // Q108112779
    {Coordinate{7.19321, 49.2442}, CountryId{"DE"}}, // Würzbach (Saar) station
    {Coordinate{1.27528, 48.6019}, CountryId{"FR"}}, // Gare de Saint-Sauveur-Châteauneuf
    {Coordinate{34.8833, 53.7352}, CountryId{"RU"}}, // Zykeyevo
    {Coordinate{34.8256, 53.6606}, CountryId{"RU"}}, // Ozerskaya
    {Coordinate{34.9289, 53.7913}, CountryId{"RU"}}, // Solonovka
    {Coordinate{12.2148, 48.8961}, CountryId{"DE"}}, // Hagelstadt
    {Coordinate{12.2087, 48.9317}, CountryId{"DE"}}, // Köfering
    {Coordinate{12.17, 48.9675}, CountryId{"DE"}}, // Obertraubling
    {Coordinate{12.1467, 48.9904}, CountryId{"DE"}}, // Regensburg-Burgweinting
    {Coordinate{12.0377, 48.9908}, CountryId{"DE"}}, // Sinzing
    {Coordinate{7.01467, 50.6272}, CountryId{"DE"}}, // Meckenheim train station
    {Coordinate{10.0602, 53.5694}, CountryId{"DE"}}, // Wandsbeker Chaussee
    {Coordinate{14.0358, 57.1863}, CountryId{"SE"}}, // Värnamo station
    {Coordinate{13.7353, 57.3584}, CountryId{"SE"}}, // Gnosjö station
    {Coordinate{11.1958, 47.6787}, CountryId{"DE"}}, // Murnau Ort station
    {Coordinate{8.895, 52.0225}, CountryId{"DE"}}, // Lemgo railway station
    {Coordinate{8.84524, 52.0126}, CountryId{"DE"}}, // Hörstmar (Lippe) railway station
    {Coordinate{8.87788, 50.0528}, CountryId{"DE"}}, // Rodgau-Weiskirchen
    {Coordinate{8.74078, 51.981}, CountryId{"DE"}}, // Ehlenbruch railway station
    {Coordinate{8.71466, 51.9773}, CountryId{"DE"}}, // Helpup railway station
    {Coordinate{8.6661, 51.9788}, CountryId{"DE"}}, // Oerlinghausen railway station
    {Coordinate{8.63753, 51.9884}, CountryId{"DE"}}, // Ubbedissen railway station
    {Coordinate{8.5909, 52.0103}, CountryId{"DE"}}, // Oldentrup railway station
    {Coordinate{11.2803, 44.5212}, CountryId{"IT"}}, // Bologna Borgo Panigale Scala railway station
    {Coordinate{8.76543, 52.0272}, CountryId{"DE"}}, // Bad Salzuflen-Sylbach railway station
    {Coordinate{12.9355, 50.7951}, CountryId{"DE"}}, // Chemnitz-Reichenhain
    {Coordinate{12.5712, 55.6838}, CountryId{"DK"}}, // Nørreport Station
    {Coordinate{3.13966, 43.3191}, CountryId{"FR"}}, // Gare de Colombiers
    {Coordinate{}, CountryId{"FR"}}, // Q108337741
    {Coordinate{16.3314, 56.9809}, CountryId{"SE"}}, // Blomstermåla station
    {Coordinate{8.75494, 52.0698}, CountryId{"DE"}}, // Schötmar railway station
    {Coordinate{8.74045, 52.0816}, CountryId{"DE"}}, // Bad Salzuflen railway station
    {Coordinate{15.8581, 57.6632}, CountryId{"SE"}}, // Vimmerby station
    {Coordinate{15.5185, 41.7195}, CountryId{"IT"}}, // San Marco in Lamis railway station
    {Coordinate{5.73543, 44.962}, CountryId{"FR"}}, // La Motte-d'Aveillans railway station
    {Coordinate{10.7337, 51.0898}, CountryId{"DE"}}, // Gräfentonna railway halt
    {Coordinate{15.6819, 58.1356}, CountryId{"SE"}}, // Rimforsa station
    {Coordinate{16.0274, 57.1659}, CountryId{"SE"}}, // Högsby station
    {Coordinate{12.1806, 49.4473}, CountryId{"DE"}}, // Nabburg
    {Coordinate{13.0506, 49.1916}, CountryId{"DE"}}, // Lam
    {Coordinate{35.1401, 53.8961}, CountryId{"RU"}}, // Duminichi
    {Coordinate{12.8523, 49.173}, CountryId{"DE"}}, // Bad Kötzting
    {Coordinate{12.7432, 48.7405}, CountryId{"DE"}}, // Wallersdorf
    {Coordinate{11.9866, 47.6878}, CountryId{"DE"}}, // Osterhofen (Oberbay)
    {Coordinate{13.0187, 48.6955}, CountryId{"DE"}}, // Osterhofen (Niederbay)
    {Coordinate{12.0112, 47.6756}, CountryId{"DE"}}, // Bayrischzell
    {Coordinate{8.41571, 49.1295}, CountryId{"DE"}}, // Hochstetten Grenzstraße
    {Coordinate{13.4533, 48.6899}, CountryId{"DE"}}, // Kalteneck
    {Coordinate{7.27604, 50.5693}, CountryId{"DE"}}, // Linz (Rhein) train station
    {Coordinate{11.462, 50.2923}, CountryId{"DE"}}, // Steinwiesen
    {Coordinate{11.4947, 50.3235}, CountryId{"DE"}}, // Kronach Mauthaus
    {Coordinate{8.94454, 50.2833}, CountryId{"DE"}}, // Altenstadt (Hess) railway station
    {Coordinate{8.78945, 50.3526}, CountryId{"DE"}}, // Dorheim (Wetterau) railway station
    {Coordinate{8.8114, 50.3793}, CountryId{"DE"}}, // Melbach railway station
    {Coordinate{22.5789, 54.6286}, CountryId{"RU"}}, // Nesterov Railway Station
    {Coordinate{22.4008, 54.6056}, CountryId{"RU"}}, // Divnoye
    {Coordinate{22.0118, 54.5882}, CountryId{"RU"}}, // Veselovka Railway stop
    {Coordinate{21.6536, 54.6149}, CountryId{"RU"}}, // Pastukhovo Railway Station
    {Coordinate{21.5437, 54.6196}, CountryId{"RU"}}, // Mezhdurech'ye Railway Station
    {Coordinate{7.87303, 51.1087}, CountryId{"DE"}}, // Kraghammer railway halt
    {Coordinate{21.3795, 54.6219}, CountryId{"RU"}}, // Pushkarevo Railway stop
    {Coordinate{21.2149, 54.615}, CountryId{"RU"}}, // Znamensk Railway Station
    {Coordinate{0.248972, 44.0593}, CountryId{"FR"}}, // Gare de Mézin, Lot-et-Garonne
    {Coordinate{20.8956, 54.6305}, CountryId{"RU"}}, // Ozerki-Novye Railway Station
    {Coordinate{6.56976, 51.067}, CountryId{"DE"}}, // Gustorf train station
    {Coordinate{20.7555, 54.6245}, CountryId{"RU"}}, // Komsomol'sk Railway stop
    {Coordinate{20.6233, 54.6519}, CountryId{"RU"}}, // Lugovoye Novoye Railway station
    {Coordinate{20.5699, 54.673}, CountryId{"RU"}}, // Ayvazovskiy Railway Stop
    {Coordinate{6.62217, 51.1303}, CountryId{"DE"}}, // Kapellen-Wevelinghoven train stop
    {Coordinate{6.56655, 51.0461}, CountryId{"DE"}}, // Frimmersdorf train stop
    {Coordinate{9.78776, 48.6611}, CountryId{"DE"}}, // Gingen (Fils) station
    {Coordinate{9.73683, 48.6895}, CountryId{"DE"}}, // Salach Stop
    {Coordinate{8.49039, 47.9294}, CountryId{"DE"}}, // Hüfingen Mitte railway station
    {Coordinate{8.45891, 47.9315}, CountryId{"DE"}}, // Bräunlingen railway station
    {Coordinate{10.6096, 54.1355}, CountryId{"DE"}}, // Eutin station
    {Coordinate{6.90935, 49.4083}, CountryId{"DE"}}, // Lebach railway station
    {Coordinate{7.03476, 49.3991}, CountryId{"DE"}}, // Wustweiler railway station
    {Coordinate{7.01254, 49.4153}, CountryId{"DE"}}, // Dirmingen railway station
    {Coordinate{6.96729, 49.4084}, CountryId{"DE"}}, // Eppelborn railway station
    {Coordinate{6.94881, 49.4107}, CountryId{"DE"}}, // Bubach railway halt
    {Coordinate{7.14308, 49.5812}, CountryId{"DE"}}, // Nohfelden Süd railway halt
    {Coordinate{13.1822, 53.3791}, CountryId{"DE"}}, // Thurow (Meckl) railway station
    {Coordinate{13.4321, 53.3306}, CountryId{"DE"}}, // Feldberg (Meckl) railway station
    {Coordinate{13.4739, 52.7561}, CountryId{"DE"}}, // Wandlitzsee railway halt
    {Coordinate{13.4882, 52.7913}, CountryId{"DE"}}, // Klosterfelde railway station
    {Coordinate{13.556, 52.8778}, CountryId{"DE"}}, // Klandorf railway station
    {Coordinate{14.0714, 52.2706}, CountryId{"DE"}}, // Bad Saarow-Pieskow railway halt
    {Coordinate{33.7542, 48.104}, CountryId{"UA"}}, // Devladove railway station
    {Coordinate{12.1952, 51.403}, CountryId{"DE"}}, // Schkeuditz West railway stop
    {Coordinate{14.7536, 50.8622}, CountryId{"DE"}}, // Kurort Oybin-Niederdorf railway station
    {Coordinate{14.7517, 50.8531}, CountryId{"DE"}}, // Teufelsmühle railway halt
    {Coordinate{14.7456, 50.8434}, CountryId{"DE"}}, // Kurort Oybin railway station
    {Coordinate{14.7254, 50.862}, CountryId{"DE"}}, // Kurort Jonsdorf Hst railway halt
    {Coordinate{12.0256, 53.4668}, CountryId{"DE"}}, // Lübz
    {Coordinate{12.7824, 50.7281}, CountryId{"DE"}}, // Niederdorf (Erzgeb)
    {Coordinate{8.88975, 48.62}, CountryId{"DE"}}, // Haltepunkt Nufringen
    {Coordinate{8.86768, 48.585}, CountryId{"DE"}}, // Haltepunkt Herrenberg Zwerchweg
    {Coordinate{21.218, 55.664}, CountryId{"LT"}}, // Rimkai train station
    {Coordinate{21.18, 55.835}, CountryId{"LT"}}, // Kretingalė train station
    {Coordinate{23.258, 55.952}, CountryId{"LT"}}, // Voveriškiai train station
    {Coordinate{23.122, 55.979}, CountryId{"LT"}}, // Kužiai train station
    {Coordinate{22.726, 55.999}, CountryId{"LT"}}, // Raudėnai train station
    {Coordinate{22.46, 55.978}, CountryId{"LT"}}, // Dūseikiai train station
    {Coordinate{12.2059, 53.1701}, CountryId{"DE"}}, // Pritzwalk Hainholz
    {Coordinate{34.2374, 48.4825}, CountryId{"UA"}}, // Verkhivtseve Railway Station
    {Coordinate{12.4216, 51.8379}, CountryId{"DE"}}, // Wörlitz
    {Coordinate{11.0584, 50.3027}, CountryId{"DE"}}, // Mönchröden
    {Coordinate{24.221, 54.902}, CountryId{"LT"}}, // Pravieniškės train station
    {Coordinate{24.27, 54.892}, CountryId{"LT"}}, // Pamieris train station
    {Coordinate{24.36, 54.878}, CountryId{"LT"}}, // Pagiriai train station
    {Coordinate{24.589, 54.836}, CountryId{"LT"}}, // Žasliai train station
    {Coordinate{24.881, 54.762}, CountryId{"LT"}}, // Baltamiškis train station
    {Coordinate{24.713, 54.815}, CountryId{"LT"}}, // Kaugonys train station
    {Coordinate{24.942, 54.749}, CountryId{"LT"}}, // Lazdėnai train station
    {Coordinate{25.006, 54.675}, CountryId{"LT"}}, // Kariotiškės train station
    {Coordinate{24.994, 54.701}, CountryId{"LT"}}, // Sausiai train station
    {Coordinate{8.9794, 48.7275}, CountryId{"DE"}}, // Maichingen Nord
    {Coordinate{14.1728, 50.6696}, CountryId{"CZ"}}, // Q108639367
    {Coordinate{14.1976, 50.6588}, CountryId{"CZ"}}, // Q108639368
    {Coordinate{12.1069, 47.7411}, CountryId{"DE"}}, // Brannenburg
    {Coordinate{23.694, 54.774}, CountryId{"LT"}}, // Pabališkiai train station
    {Coordinate{23.512, 55.823}, CountryId{"LT"}}, // Durpynas train station
    {Coordinate{23.476, 55.832}, CountryId{"LT"}}, // Kutiškiai train station
    {Coordinate{23.437, 55.844}, CountryId{"LT"}}, // Mankiškiai train station
    {Coordinate{23.392, 55.88}, CountryId{"LT"}}, // Sodai train station
    {Coordinate{13.0489, 51.9316}, CountryId{"DE"}}, // Oehna
    {Coordinate{13.0851, 51.853}, CountryId{"DE"}}, // Linda (Elster)
    {Coordinate{13.1142, 51.7804}, CountryId{"DE"}}, // Holzdorf (Elster) station
    {Coordinate{10.2361, 53.6694}, CountryId{"DE"}}, // Ahrensburg railway station
    {Coordinate{12.4688, 51.2838}, CountryId{"DE"}}, // Leipzig-Liebertwolkwitz station
    {Coordinate{12.5065, 51.2578}, CountryId{"DE"}}, // Oberholz halt
    {Coordinate{12.6195, 51.175}, CountryId{"DE"}}, // Lauterbach-Steinbach halt
    {Coordinate{12.6626, 51.1057}, CountryId{"DE"}}, // Hopfgarten (Sachs) halt
    {Coordinate{12.6794, 51.0899}, CountryId{"DE"}}, // Tautenhain halt
    {Coordinate{12.5593, 51.0691}, CountryId{"DE"}}, // Frohburg station
    {Coordinate{12.5336, 51.0877}, CountryId{"DE"}}, // Neukirchen-Wyhra halt
    {Coordinate{12.503, 51.0986}, CountryId{"DE"}}, // Petergrube halt
    {Coordinate{12.384, 51.1847}, CountryId{"DE"}}, // Böhlen Werke
    {Coordinate{12.4196, 51.1145}, CountryId{"DE"}}, // Deutzen
    {Coordinate{12.3833, 51.2318}, CountryId{"DE"}}, // Großdeuben
    {Coordinate{14.4241, 51.8186}, CountryId{"DE"}}, // Teichland railway halt
    {Coordinate{14.5017, 51.8665}, CountryId{"DE"}}, // Jänschwalde station
    {Coordinate{14.5411, 51.8777}, CountryId{"DE"}}, // Jänschwalde Ost
    {Coordinate{14.2233, 51.6552}, CountryId{"DE"}}, // Drebkau station
    {Coordinate{10.4889, 48.5812}, CountryId{"DE"}}, // Dillingen (Donau) railway station
    {Coordinate{10.4247, 48.5744}, CountryId{"DE"}}, // Lauingen railway station
    {Coordinate{10.2159, 48.4504}, CountryId{"DE"}}, // Leipheim railway halt
    {Coordinate{74.5535, 18.4671}, CountryId{"IN"}}, // Daund Chord Line railway station
    {Coordinate{10.0373, 48.3513}, CountryId{"DE"}}, // Gerlenhofen railway station
    {Coordinate{10.0503, 48.3239}, CountryId{"DE"}}, // Senden railway station
    {Coordinate{7.77135, 50.4863}, CountryId{"DE"}}, // Siershahn railway station
    {Coordinate{8.95515, 51.8816}, CountryId{"DE"}}, // Horn-Bad Meinberg station
    {Coordinate{10.0904, 48.2547}, CountryId{"DE"}}, // Bellenberg railway halt
    {Coordinate{10.1, 48.2227}, CountryId{"DE"}}, // Illertissen railway station
    {Coordinate{10.11, 48.1612}, CountryId{"DE"}}, // Altenstadt (Iller) railway station
    {Coordinate{8.9711, 51.8445}, CountryId{"DE"}}, // Leopoldstal station
    {Coordinate{10.0834, 48.4477}, CountryId{"DE"}}, // Oberelchingen railway halt
    {Coordinate{9.82911, 48.1894}, CountryId{"DE"}}, // Schemmerberg railway halt
    {Coordinate{9.80156, 48.1298}, CountryId{"DE"}}, // Warthausen railway station
    {Coordinate{9.08733, 45.5198}, CountryId{"IT"}}, // Rho Fiera metro station
    {Coordinate{9.80388, 48.6402}, CountryId{"DE"}}, // Kuchen (Fils) railway halt
    {Coordinate{9.82163, 48.6309}, CountryId{"DE"}}, // Geislingen West railway station
    {Coordinate{9.89479, 48.55}, CountryId{"DE"}}, // Urspring railway halt
    {Coordinate{9.91728, 48.5451}, CountryId{"DE"}}, // Lonsee railway station
    {Coordinate{9.94942, 48.5199}, CountryId{"DE"}}, // Westerstetten railway station
    {Coordinate{9.97681, 48.4813}, CountryId{"DE"}}, // Beimerstetten railway station
    {Coordinate{9.80571, 48.3998}, CountryId{"DE"}}, // Gerhausen railway stop
    {Coordinate{9.8977, 48.4178}, CountryId{"DE"}}, // Herrlingen railway station
    {Coordinate{9.91906, 48.4147}, CountryId{"DE"}}, // Blaustein railway stop
    {Coordinate{16.5438, 49.1651}, CountryId{"CZ"}}, // Ostopovice
    {Coordinate{9.79301, 47.8413}, CountryId{"DE"}}, // Alttann railway halt
    {Coordinate{9.80867, 47.8242}, CountryId{"DE"}}, // Wolfegg railway halt
    {Coordinate{10.0751, 47.8879}, CountryId{"DE"}}, // Aichstetten station
    {Coordinate{10.0802, 47.9436}, CountryId{"DE"}}, // Marstetten-Aitrach railway halt
    {Coordinate{10.2906, 47.8129}, CountryId{"DE"}}, // Dietmannsried station
    {Coordinate{9.90202, 47.6289}, CountryId{"DE"}}, // Heimenkirch station
    {Coordinate{9.5745, 47.7517}, CountryId{"DE"}}, // Oberzell railway halt
    {Coordinate{10.276, 47.4367}, CountryId{"DE"}}, // Langenwang (Schwab) railway station
    {Coordinate{11.2595, 48.5654}, CountryId{"DE"}}, // Schrobenhausen station
    {Coordinate{11.1622, 48.5146}, CountryId{"DE"}}, // Radersdorf station
    {Coordinate{0.0332472, 43.4614}, CountryId{"FR"}}, // Gare de Maubourguet
    {Coordinate{10.8612, 48.4232}, CountryId{"DE"}}, // Gersthofen station
    {Coordinate{5.66952, 48.7176}, CountryId{"FR"}}, // Sorcy-gare
    {Coordinate{10.98, 47.2818}, CountryId{"AT"}}, // Bahnhof Stams
    {Coordinate{10.9716, 48.274}, CountryId{"DE"}}, // Mering-Sankt Afra station
    {Coordinate{11.159, 47.7201}, CountryId{"DE"}}, // Uffing am Staffelsee station
    {Coordinate{11.1406, 47.7767}, CountryId{"DE"}}, // Huglfing station
    {Coordinate{11.1393, 47.5593}, CountryId{"DE"}}, // Oberau station
    {Coordinate{11.1149, 47.531}, CountryId{"DE"}}, // Farchant station
    {Coordinate{10.9461, 47.4782}, CountryId{"DE"}}, // Griesen (Oberbay) station
    {Coordinate{11.0392, 47.6702}, CountryId{"DE"}}, // Bad Kohlgrub Kurhaus station
    {Coordinate{11.1374, 47.667}, CountryId{"DE"}}, // Grafenaschau station
    {Coordinate{11.0582, 47.668}, CountryId{"DE"}}, // Bad Kohlgrub station
    {Coordinate{10.6185, 47.8148}, CountryId{"DE"}}, // Ebenhofen railway halt
    {Coordinate{10.6098, 47.7741}, CountryId{"DE"}}, // Marktoberdorf Schule railway halt
    {Coordinate{10.5812, 47.7457}, CountryId{"DE"}}, // Leuterschach railway halt
    {Coordinate{10.6013, 47.6972}, CountryId{"DE"}}, // Lengenwang station
    {Coordinate{10.6137, 47.6559}, CountryId{"DE"}}, // Seeg railway halt
    {Coordinate{10.6205, 47.6146}, CountryId{"DE"}}, // Weizern-Hopferau station
    {Coordinate{10.5894, 48.0525}, CountryId{"DE"}}, // Rammingen (Bay) railway halt
    {Coordinate{10.4376, 48.0281}, CountryId{"DE"}}, // Stetten (Schwab) station
    {Coordinate{10.3462, 48.012}, CountryId{"DE"}}, // Sontheim (Schwab) station
    {Coordinate{10.5038, 48.0782}, CountryId{"DE"}}, // Nassenbeuren railway halt
    {Coordinate{10.483, 48.1008}, CountryId{"DE"}}, // Hausen (Schwab) railway halt
    {Coordinate{10.452, 48.1177}, CountryId{"DE"}}, // Pfaffenhausen station
    {Coordinate{10.2981, 48.389}, CountryId{"DE"}}, // Hochwang railway halt
    {Coordinate{10.3021, 48.3701}, CountryId{"DE"}}, // Ichenhausen station
    {Coordinate{10.8248, 48.6609}, CountryId{"DE"}}, // Mertingen station
    {Coordinate{9.17333, 45.4617}, CountryId{"IT"}}, // Sant’Ambrogio metro station
    {Coordinate{-0.250551, 45.6592}, CountryId{"FR"}}, // Gare de Gensac-la-Pallue
    {Coordinate{10.848, 48.491}, CountryId{"DE"}}, // Langweid (Lech) halt
    {Coordinate{10.8481, 48.5299}, CountryId{"DE"}}, // Herbertshofen railway stop
    {Coordinate{12.421, 51.4993}, CountryId{"DE"}}, // Hohenroda halt
    {Coordinate{12.4611, 51.4906}, CountryId{"DE"}}, // Krensitz station
    {Coordinate{12.8195, 51.5056}, CountryId{"DE"}}, // Mockrehna station
    {Coordinate{13.1539, 51.5797}, CountryId{"DE"}}, // Rehfeld (Falkenberg/Elster) station
    {Coordinate{13.3606, 51.5902}, CountryId{"DE"}}, // Beutersitz station
    {Coordinate{13.8869, 51.7047}, CountryId{"DE"}}, // Gollmitz station
    {Coordinate{12.3719, 51.8945}, CountryId{"DE"}}, // Klieken station
    {Coordinate{12.9718, 50.4212}, CountryId{"DE"}}, // Oberwiesenthal station
    {Coordinate{12.9991, 50.5669}, CountryId{"DE"}}, // Annaberg-Buchholz Mitte railway stop
    {Coordinate{13.0299, 50.5078}, CountryId{"DE"}}, // Bärenstein (Kr Annaberg) railway stop
    {Coordinate{8.98704, 51.8184}, CountryId{"DE"}}, // Sandebeck station
    {Coordinate{12.5876, 51.3539}, CountryId{"DE"}}, // Gerichshain railway stop
    {Coordinate{13.0905, 50.7625}, CountryId{"DE"}}, // Waldkirchen (Erzgeb)
    {Coordinate{12.9241, 50.777}, CountryId{"DE"}}, // Chemnitz-Harthau
    {Coordinate{12.9255, 50.7855}, CountryId{"DE"}}, // Chemnitz Riemenschneiderstraße railway stop
    {Coordinate{12.9195, 50.7729}, CountryId{"DE"}}, // Chemnitz Friedrichstraße railway stop
    {Coordinate{13.1761, 50.8573}, CountryId{"DE"}}, // Oederan railway station
    {Coordinate{13.2285, 50.9029}, CountryId{"DE"}}, // Frankenstein (Sachs) railway stop
    {Coordinate{13.2817, 50.9027}, CountryId{"DE"}}, // Kleinschirma railway stop
    {Coordinate{13.3798, 50.8682}, CountryId{"DE"}}, // Berthelsdorf (Erzgeb) Ort railway stop
    {Coordinate{13.4036, 50.84}, CountryId{"DE"}}, // Lichtenberg (Erzgeb) railway stop
    {Coordinate{33.187, 67.4596}, CountryId{"RU"}}, // Pitkul
    {Coordinate{12.6824, 51.3559}, CountryId{"DE"}}, // Altenbach railway stop
    {Coordinate{12.7086, 51.3559}, CountryId{"DE"}}, // Bennewitz railway stop
    {Coordinate{12.8337, 51.3494}, CountryId{"DE"}}, // Kühren railway stop
    {Coordinate{12.9838, 51.351}, CountryId{"DE"}}, // Dahlen (Sachs) railway station
    {Coordinate{13.5615, 51.1591}, CountryId{"DE"}}, // Weinböhla railway stop
    {Coordinate{12.0509, 51.4506}, CountryId{"DE"}}, // Dieskau railway stop
    {Coordinate{12.0992, 51.5511}, CountryId{"DE"}}, // Niemberg railway station
    {Coordinate{12.0286, 51.6703}, CountryId{"DE"}}, // Weißandt-Gölzau railway stop
    {Coordinate{13.1814, 50.7588}, CountryId{"DE"}}, // Floßmühle railway stop
    {Coordinate{13.215, 50.6785}, CountryId{"DE"}}, // Strobelmühle railway halt
    {Coordinate{13.1642, 50.6484}, CountryId{"DE"}}, // Marienberg (Sachs) railway station
    {Coordinate{13.3649, 50.6498}, CountryId{"DE"}}, // Olbernhau-Grünthal railway station
    {Coordinate{13.9901, 50.9497}, CountryId{"DE"}}, // Obervogelgesang station
    {Coordinate{6.3289, 51.1481}, CountryId{"DE"}}, // Mönchengladbach-Genhausen
    {Coordinate{7.74172, 48.1245}, CountryId{"DE"}}, // Bahlingen am Kaiserstuhl station
    {Coordinate{7.76014, 48.1058}, CountryId{"DE"}}, // Nimburg (Baden) railway station
    {Coordinate{7.74804, 48.0929}, CountryId{"DE"}}, // Eichstetten am Kaiserstuhl station
    {Coordinate{7.7282, 48.0758}, CountryId{"DE"}}, // Bötzingen Mühle station
    {Coordinate{7.72151, 48.0701}, CountryId{"DE"}}, // Bötzingen station
    {Coordinate{7.69993, 48.1443}, CountryId{"DE"}}, // Endingen am Kaiserstuhl station
    {Coordinate{7.65816, 48.1373}, CountryId{"DE"}}, // Königschaffhausen station
    {Coordinate{7.62035, 48.1387}, CountryId{"DE"}}, // Sasbach am Kaiserstuhl railway station
    {Coordinate{7.61069, 48.1197}, CountryId{"DE"}}, // Jechtingen station
    {Coordinate{7.61193, 48.104}, CountryId{"DE"}}, // Burkheim-Bischoffingen station
    {Coordinate{7.62104, 48.09}, CountryId{"DE"}}, // Oberrotweil station
    {Coordinate{7.60801, 48.0596}, CountryId{"DE"}}, // Achkarren station
    {Coordinate{}, CountryId{"IN"}}, // Molvom Railway Station
    {Coordinate{93.7125, 25.7604}, CountryId{"IN"}}, // Shokhuvi Railway Station
    {Coordinate{10.0307, 54.3128}, CountryId{"DE"}}, // Melsdorf station
    {Coordinate{88.4561, 27.0906}, CountryId{"IN"}}, // Melli Railway Station
    {Coordinate{88.4138, 26.9926}, CountryId{"IN"}}, // Riyang Railway Station
    {Coordinate{88.43, 27.06}, CountryId{"IN"}}, // Tista Bazaar Railway Station
    {Coordinate{9.23211, 50.0666}, CountryId{"DE"}}, // Blankenbach
    {Coordinate{9.2439, 50.0855}, CountryId{"DE"}}, // Schöllkrippen
    {Coordinate{9.19556, 45.4561}, CountryId{"IT"}}, // Crocetta metro station
    {Coordinate{9.0309, 51.7303}, CountryId{"DE"}}, // Bad Driburg (Westf)
    {Coordinate{82.9523, 55.0048}, CountryId{"RU"}}, // Novosibirsk-Yuzhny
    {Coordinate{9.18286, 51.712}, CountryId{"DE"}}, // Brakel (Höxter)
    {Coordinate{41.0752, 56.3627}, CountryId{"RU"}}, // Q108915834
    {Coordinate{40.5816, 56.2085}, CountryId{"RU"}}, // Q108915877
    {Coordinate{40.6416, 56.2344}, CountryId{"RU"}}, // Q108915957
    {Coordinate{40.6773, 56.2445}, CountryId{"RU"}}, // Q108916204
    {Coordinate{40.7866, 56.269}, CountryId{"RU"}}, // Q108916239
    {Coordinate{40.8694, 56.2857}, CountryId{"RU"}}, // Q108916266
    {Coordinate{40.9309, 56.3148}, CountryId{"RU"}}, // Q108916288
    {Coordinate{40.9899, 56.3432}, CountryId{"RU"}}, // Q108916309
    {Coordinate{41.1172, 56.3721}, CountryId{"RU"}}, // Q108916376
    {Coordinate{41.1131, 56.3854}, CountryId{"RU"}}, // Q108916381
    {Coordinate{41.1822, 56.3784}, CountryId{"RU"}}, // Q108916420
    {Coordinate{41.2238, 56.3752}, CountryId{"RU"}}, // Q108916431
    {Coordinate{41.275, 56.3674}, CountryId{"RU"}}, // Q108916438
    {Coordinate{89.97, 26.08}, CountryId{"IN"}}, // Gauripur railway station
    {Coordinate{41.363, 56.3842}, CountryId{"RU"}}, // Q108920213
    {Coordinate{41.4036, 56.3925}, CountryId{"RU"}}, // Q108920219
    {Coordinate{41.5146, 56.3662}, CountryId{"RU"}}, // Q108920396
    {Coordinate{41.5529, 56.3448}, CountryId{"RU"}}, // Q108920441
    {Coordinate{41.6327, 56.3138}, CountryId{"RU"}}, // Q108920469
    {Coordinate{8.25284, 51.0206}, CountryId{"DE"}}, // Birkelbach railway station
    {Coordinate{8.08684, 51.0879}, CountryId{"DE"}}, // Kirchhundem-Flape railway station
    {Coordinate{8.07171, 51.1045}, CountryId{"DE"}}, // Lennestadt-Altenhundem railway station
    {Coordinate{-73.1698, 44.0177}, CountryId{"US"}}, // Middlebury
    {Coordinate{132.871, 42.7796}, CountryId{"RU"}}, // Arsenyeva
    {Coordinate{18.3004, 49.8261}, CountryId{"CZ"}}, // Zárubek
    {Coordinate{9.51271, 46.8499}, CountryId{"CH"}}, // Chur West railway station
    {Coordinate{41.7087, 56.2985}, CountryId{"RU"}}, // Q108982622
    {Coordinate{41.7631, 56.2854}, CountryId{"RU"}}, // Q108983110
    {Coordinate{42.2689, 56.142}, CountryId{"RU"}}, // Q108986255
    {Coordinate{42.337, 56.1064}, CountryId{"RU"}}, // Q108986647
    {Coordinate{42.4158, 56.1069}, CountryId{"RU"}}, // Q108986829
    {Coordinate{42.5195, 56.1094}, CountryId{"RU"}}, // Q108987208
    {Coordinate{42.6534, 56.1173}, CountryId{"RU"}}, // Q108987457
    {Coordinate{42.814, 56.1593}, CountryId{"RU"}}, // Q109025639
    {Coordinate{42.8457, 56.18}, CountryId{"RU"}}, // Q109026075
    {Coordinate{42.9165, 56.2307}, CountryId{"RU"}}, // Ilyino railway station
    {Coordinate{1.85528, 42.9403}, CountryId{"FR"}}, // Q109037573
    {Coordinate{42.9655, 56.2234}, CountryId{"RU"}}, // Q109087366
    {Coordinate{43.0646, 56.2141}, CountryId{"RU"}}, // Q109087825
    {Coordinate{43.174, 56.2249}, CountryId{"RU"}}, // Seima
    {Coordinate{13.0334, 51.7264}, CountryId{"DE"}}, // Annaburg West railway station
    {Coordinate{43.2053, 56.2251}, CountryId{"RU"}}, // Q109100392
    {Coordinate{43.2899, 56.2233}, CountryId{"RU"}}, // Reshetikha railway station
    {Coordinate{43.3208, 56.2227}, CountryId{"RU"}}, // Q109101291
    {Coordinate{43.5234, 56.2416}, CountryId{"RU"}}, // Q109101867
    {Coordinate{}, CountryId{"RU"}}, // Q109104543
    {Coordinate{43.7995, 56.2521}, CountryId{"RU"}}, // Q109104825
    {Coordinate{43.8289, 56.3669}, CountryId{"RU"}}, // Q109123386
    {Coordinate{43.8739, 56.3521}, CountryId{"RU"}}, // Sormovo railway station
    {Coordinate{43.8114, 56.3737}, CountryId{"RU"}}, // Q109126316
    {Coordinate{43.7859, 56.3787}, CountryId{"RU"}}, // Q109126547
    {Coordinate{43.7614, 56.3827}, CountryId{"RU"}}, // Q109126882
    {Coordinate{43.7379, 56.3898}, CountryId{"RU"}}, // Q109127146
    {Coordinate{43.7113, 56.4041}, CountryId{"RU"}}, // Q109133518
    {Coordinate{-73.2489, 44.1809}, CountryId{"US"}}, // Ferrisburgh–Vergennes
    {Coordinate{43.6483, 56.4216}, CountryId{"RU"}}, // Q109136669
    {Coordinate{43.6229, 56.4368}, CountryId{"RU"}}, // Q109136671
    {Coordinate{43.5772, 56.4843}, CountryId{"RU"}}, // Q109136673
    {Coordinate{43.5426, 56.5203}, CountryId{"RU"}}, // Pravdinsk railway station
    {Coordinate{43.5317, 56.5309}, CountryId{"RU"}}, // Q109136677
    {Coordinate{43.5116, 56.544}, CountryId{"RU"}}, // Mogilitsy railway station
    {Coordinate{43.4653, 56.5785}, CountryId{"RU"}}, // Q109136682
    {Coordinate{43.4268, 56.6089}, CountryId{"RU"}}, // Q109136684
    {Coordinate{43.4022, 56.6416}, CountryId{"RU"}}, // Q109136687
    {Coordinate{43.9821, 56.4063}, CountryId{"RU"}}, // Tolokontsevo railway station
    {Coordinate{10.6726, 47.5316}, CountryId{"AT"}}, // Musau
    {Coordinate{44.0503, 56.5213}, CountryId{"RU"}}, // Q109191707
    {Coordinate{44.5704, 56.8575}, CountryId{"RU"}}, // Q109191720
    {Coordinate{44.061, 56.5459}, CountryId{"RU"}}, // Q109192046
    {Coordinate{44.3458, 56.7332}, CountryId{"RU"}}, // Q109196485
    {Coordinate{44.4511, 56.781}, CountryId{"RU"}}, // Q109196488
    {Coordinate{44.6211, 56.9163}, CountryId{"RU"}}, // Q109196492
    {Coordinate{44.6914, 56.9625}, CountryId{"RU"}}, // Q109196495
    {Coordinate{44.7525, 56.9831}, CountryId{"RU"}}, // Q109196499
    {Coordinate{44.8894, 57.0449}, CountryId{"RU"}}, // Q109196502
    {Coordinate{44.8627, 57.1427}, CountryId{"RU"}}, // Q109208996
    {Coordinate{44.7904, 57.2041}, CountryId{"RU"}}, // Q109209000
    {Coordinate{44.7395, 57.2517}, CountryId{"RU"}}, // Q109209003
    {Coordinate{44.7309, 57.2728}, CountryId{"RU"}}, // Q109209006
    {Coordinate{44.6531, 57.3659}, CountryId{"RU"}}, // Q109209016
    {Coordinate{44.5936, 57.4763}, CountryId{"RU"}}, // Q109209019
    {Coordinate{44.578, 57.4855}, CountryId{"RU"}}, // Q109209022
    {Coordinate{45.0318, 57.1068}, CountryId{"RU"}}, // Q109218239
    {Coordinate{45.2508, 57.2387}, CountryId{"RU"}}, // Q109218241
    {Coordinate{45.3847, 57.3026}, CountryId{"RU"}}, // Q109218242
    {Coordinate{45.5288, 57.3635}, CountryId{"RU"}}, // Q109218243
    {Coordinate{45.6646, 57.4287}, CountryId{"RU"}}, // Q109218244
    {Coordinate{45.7938, 57.4634}, CountryId{"RU"}}, // Q109218245
    {Coordinate{45.9619, 57.4929}, CountryId{"RU"}}, // Q109218246
    {Coordinate{46.0743, 57.5255}, CountryId{"RU"}}, // Q109218247
    {Coordinate{46.3439, 57.5978}, CountryId{"RU"}}, // Q109218248
    {Coordinate{46.4816, 57.6438}, CountryId{"RU"}}, // Q109218249
    {Coordinate{46.7545, 57.7151}, CountryId{"RU"}}, // Q109225147
    {Coordinate{46.8583, 57.773}, CountryId{"RU"}}, // Q109225148
    {Coordinate{47.102, 57.8625}, CountryId{"RU"}}, // Q109225150
    {Coordinate{47.356, 57.9448}, CountryId{"RU"}}, // Q109225151
    {Coordinate{47.4458, 57.9747}, CountryId{"RU"}}, // Q109225152
    {Coordinate{47.5256, 58.0095}, CountryId{"RU"}}, // Q109225153
    {Coordinate{47.6088, 58.0406}, CountryId{"RU"}}, // Q109225154
    {Coordinate{47.6958, 58.0775}, CountryId{"RU"}}, // Q109225155
    {Coordinate{47.8626, 58.1399}, CountryId{"RU"}}, // Q109225158
    {Coordinate{47.9688, 58.1749}, CountryId{"RU"}}, // Q109225159
    {Coordinate{47.9985, 58.1847}, CountryId{"RU"}}, // Q109225160
    {Coordinate{48.034, 58.1964}, CountryId{"RU"}}, // Q109225161
    {Coordinate{48.1079, 58.2206}, CountryId{"RU"}}, // Q109225162
    {Coordinate{48.1548, 58.2339}, CountryId{"RU"}}, // Q109225163
    {Coordinate{48.2011, 58.2479}, CountryId{"RU"}}, // Q109225164
    {Coordinate{48.2862, 58.304}, CountryId{"RU"}}, // Q109225165
    {Coordinate{22.252, 55.993}, CountryId{"LT"}}, // Telšiai train station
    {Coordinate{12.9537, 50.8843}, CountryId{"DE"}}, // Chemnitz Kinderwaldstätte
    {Coordinate{48.2501, 58.3273}, CountryId{"RU"}}, // Q109247975
    {Coordinate{48.2237, 58.3244}, CountryId{"RU"}}, // Q109247976
    {Coordinate{48.17, 58.3058}, CountryId{"RU"}}, // Q109247977
    {Coordinate{48.1261, 58.2956}, CountryId{"RU"}}, // Q109247978
    {Coordinate{47.9885, 58.2787}, CountryId{"RU"}}, // Q109247979
    {Coordinate{47.927, 58.2798}, CountryId{"RU"}}, // Q109247980
    {Coordinate{47.8674, 58.2817}, CountryId{"RU"}}, // Q109247982
    {Coordinate{47.7795, 58.2767}, CountryId{"RU"}}, // Q109247983
    {Coordinate{47.6391, 58.2792}, CountryId{"RU"}}, // Q109247984
    {Coordinate{47.5793, 58.2809}, CountryId{"RU"}}, // Q109247985
    {Coordinate{48.3937, 58.292}, CountryId{"RU"}}, // Q109251699
    {Coordinate{48.4368, 58.2953}, CountryId{"RU"}}, // Q109251700
    {Coordinate{48.4976, 58.3001}, CountryId{"RU"}}, // Q109251702
    {Coordinate{48.6379, 58.3116}, CountryId{"RU"}}, // Q109251703
    {Coordinate{48.7017, 58.324}, CountryId{"RU"}}, // Q109251705
    {Coordinate{48.8423, 58.3489}, CountryId{"RU"}}, // Q109251707
    {Coordinate{48.8798, 58.3579}, CountryId{"RU"}}, // Q109251708
    {Coordinate{48.9396, 58.3741}, CountryId{"RU"}}, // Q109251710
    {Coordinate{49.1455, 58.4291}, CountryId{"RU"}}, // Q109251711
    {Coordinate{49.2525, 58.4626}, CountryId{"RU"}}, // Q109251713
    {Coordinate{49.2835, 58.4672}, CountryId{"RU"}}, // Q109251714
    {Coordinate{49.3095, 58.4708}, CountryId{"RU"}}, // Q109251715
    {Coordinate{49.3614, 58.4879}, CountryId{"RU"}}, // Q109251717
    {Coordinate{49.4211, 58.5048}, CountryId{"RU"}}, // Q109251719
    {Coordinate{11.9391, 49.7641}, CountryId{"DE"}}, // Pressath
    {Coordinate{11.9929, 49.7247}, CountryId{"DE"}}, // Schwarzenbach (b Pressath)
    {Coordinate{11.8946, 49.8014}, CountryId{"DE"}}, // Trabitz
    {Coordinate{11.8623, 49.8439}, CountryId{"DE"}}, // Kemnath-Neustadt
    {Coordinate{11.7056, 49.8944}, CountryId{"DE"}}, // Seybothenreuth
    {Coordinate{11.6667, 49.9197}, CountryId{"DE"}}, // Stockau
    {Coordinate{21.852, 55.9191}, CountryId{"LT"}}, // Plungė train station
    {Coordinate{11.972, 49.9339}, CountryId{"DE"}}, // Neusorg
    {Coordinate{132.855, 42.7807}, CountryId{"RU"}}, // Gorbolnitsa
    {Coordinate{49.4894, 58.5307}, CountryId{"RU"}}, // Q109274576
    {Coordinate{49.5862, 58.558}, CountryId{"RU"}}, // Q109274577
    {Coordinate{41.1527, 55.5007}, CountryId{"RU"}}, // Q109290552
    {Coordinate{41.2172, 55.506}, CountryId{"RU"}}, // Q109290553
    {Coordinate{41.3232, 55.505}, CountryId{"RU"}}, // Q109290554
    {Coordinate{41.4132, 55.5026}, CountryId{"RU"}}, // Q109290556
    {Coordinate{41.5067, 55.5063}, CountryId{"RU"}}, // Q109290557
    {Coordinate{41.59, 55.5245}, CountryId{"RU"}}, // Q109290559
    {Coordinate{41.6329, 55.5339}, CountryId{"RU"}}, // Q109290561
    {Coordinate{41.6925, 55.5469}, CountryId{"RU"}}, // Q109290562
    {Coordinate{41.741, 55.5488}, CountryId{"RU"}}, // Q109290563
    {Coordinate{41.7813, 55.5496}, CountryId{"RU"}}, // Q109290564
    {Coordinate{41.8163, 55.5498}, CountryId{"RU"}}, // Q109290565
    {Coordinate{41.8874, 55.5522}, CountryId{"RU"}}, // Q109290566
    {Coordinate{41.9267, 55.5626}, CountryId{"RU"}}, // Q109290567
    {Coordinate{41.9459, 55.5645}, CountryId{"RU"}}, // Q109290568
    {Coordinate{88.3535, 22.7695}, CountryId{"IN"}}, // Barrackpore Racecourse railway station
    {Coordinate{132.87, 42.7945}, CountryId{"RU"}}, // Rybny Port
    {Coordinate{41.996, 55.6}, CountryId{"RU"}}, // Q109302989
    {Coordinate{41.9545, 55.629}, CountryId{"RU"}}, // Q109302990
    {Coordinate{41.8794, 55.6499}, CountryId{"RU"}}, // Q109302991
    {Coordinate{41.8509, 55.6642}, CountryId{"RU"}}, // Q109302992
    {Coordinate{41.7984, 55.704}, CountryId{"RU"}}, // Q109302993
    {Coordinate{41.7681, 55.7468}, CountryId{"RU"}}, // Q109302994
    {Coordinate{41.7362, 55.771}, CountryId{"RU"}}, // Q109302996
    {Coordinate{41.7312, 55.7956}, CountryId{"RU"}}, // Q109302997
    {Coordinate{41.7588, 55.8379}, CountryId{"RU"}}, // Q109302998
    {Coordinate{41.7367, 55.8904}, CountryId{"RU"}}, // Q109302999
    {Coordinate{41.6211, 55.9743}, CountryId{"RU"}}, // Q109303001
    {Coordinate{41.5862, 56.024}, CountryId{"RU"}}, // Q109303002
    {Coordinate{41.5398, 56.089}, CountryId{"RU"}}, // Q109303003
    {Coordinate{41.5016, 56.1426}, CountryId{"RU"}}, // Q109303004
    {Coordinate{41.4744, 56.1805}, CountryId{"RU"}}, // Q109303005
    {Coordinate{41.4483, 56.217}, CountryId{"RU"}}, // Q109303006
    {Coordinate{41.4299, 56.2425}, CountryId{"RU"}}, // Q109303007
    {Coordinate{41.3846, 56.3048}, CountryId{"RU"}}, // Q109303008
    {Coordinate{21.0951, 55.7692}, CountryId{"LT"}}, // Giruliai train station
    {Coordinate{11.8651, 51.4676}, CountryId{"DE"}}, // Zscherben train station
    {Coordinate{132.875, 42.8003}, CountryId{"RU"}}, // Zavodskaya
    {Coordinate{11.763, 51.7237}, CountryId{"DE"}}, // Bebitz railway station
    {Coordinate{8.52066, 51.9649}, CountryId{"DE"}}, // Bielefeld-Senne station
    {Coordinate{42.0592, 55.5637}, CountryId{"RU"}}, // Q109332440
    {Coordinate{42.2831, 55.5373}, CountryId{"RU"}}, // Q109332442
    {Coordinate{42.3531, 55.5368}, CountryId{"RU"}}, // Q109332443
    {Coordinate{42.438, 55.5354}, CountryId{"RU"}}, // Q109332444
    {Coordinate{42.5225, 55.5354}, CountryId{"RU"}}, // Q109332445
    {Coordinate{42.543, 55.5269}, CountryId{"RU"}}, // Q109332446
    {Coordinate{42.5779, 55.5182}, CountryId{"RU"}}, // Q109332447
    {Coordinate{42.6716, 55.5128}, CountryId{"RU"}}, // Q109332448
    {Coordinate{42.8157, 55.5129}, CountryId{"RU"}}, // Q109332449
    {Coordinate{42.9844, 55.4991}, CountryId{"RU"}}, // Q109332450
    {Coordinate{43.0979, 55.4806}, CountryId{"RU"}}, // Q109332451
    {Coordinate{43.2011, 55.4642}, CountryId{"RU"}}, // Q109332452
    {Coordinate{43.2695, 55.4654}, CountryId{"RU"}}, // Q109332453
    {Coordinate{43.365, 55.4791}, CountryId{"RU"}}, // Q109332454
    {Coordinate{43.4479, 55.4756}, CountryId{"RU"}}, // Q109332455
    {Coordinate{43.4952, 55.4761}, CountryId{"RU"}}, // Q109332456
    {Coordinate{43.5572, 55.4764}, CountryId{"RU"}}, // Q109332457
    {Coordinate{43.6516, 55.4697}, CountryId{"RU"}}, // Q109332460
    {Coordinate{43.7255, 55.4638}, CountryId{"RU"}}, // Q109332461
    {Coordinate{43.7753, 55.4477}, CountryId{"RU"}}, // Q109332462
    {Coordinate{43.8142, 55.4294}, CountryId{"RU"}}, // Q109332463
    {Coordinate{43.8236, 55.4215}, CountryId{"RU"}}, // Q109332465
    {Coordinate{42.1299, 55.5616}, CountryId{"RU"}}, // Q109332468
    {Coordinate{43.8135, 56.1566}, CountryId{"RU"}}, // Q109336495
    {Coordinate{43.8352, 56.1173}, CountryId{"RU"}}, // Q109336496
    {Coordinate{43.8374, 56.0744}, CountryId{"RU"}}, // Q109336497
    {Coordinate{43.8366, 56.0207}, CountryId{"RU"}}, // Q109336498
    {Coordinate{43.8453, 55.9739}, CountryId{"RU"}}, // Q109336500
    {Coordinate{43.8183, 55.9578}, CountryId{"RU"}}, // Q109336501
    {Coordinate{43.7771, 55.9169}, CountryId{"RU"}}, // Q109336503
    {Coordinate{43.8479, 55.8244}, CountryId{"RU"}}, // Q109336504
    {Coordinate{43.8646, 55.7984}, CountryId{"RU"}}, // Q109336505
    {Coordinate{43.8991, 55.7634}, CountryId{"RU"}}, // Q109336506
    {Coordinate{43.8715, 55.7284}, CountryId{"RU"}}, // Q109336507
    {Coordinate{43.8222, 55.6699}, CountryId{"RU"}}, // Q109336508
    {Coordinate{43.7912, 55.6009}, CountryId{"RU"}}, // Q109336509
    {Coordinate{43.8095, 55.5277}, CountryId{"RU"}}, // Lomovka railway station
    {Coordinate{43.8165, 55.4992}, CountryId{"RU"}}, // Q109336512
    {Coordinate{43.806, 55.4465}, CountryId{"RU"}}, // Q109336513
    {Coordinate{43.8719, 56.1658}, CountryId{"RU"}}, // Q109348985
    {Coordinate{44.0821, 56.2223}, CountryId{"RU"}}, // Q109348987
    {Coordinate{44.0403, 56.2377}, CountryId{"RU"}}, // Q109348988
    {Coordinate{43.7926, 56.1397}, CountryId{"RU"}}, // Q109349544
    {Coordinate{43.7561, 56.1228}, CountryId{"RU"}}, // Q109349545
    {Coordinate{43.6853, 56.1006}, CountryId{"RU"}}, // Q109349546
    {Coordinate{43.6406, 56.1013}, CountryId{"RU"}}, // Q109349547
    {Coordinate{43.5231, 56.1146}, CountryId{"RU"}}, // Q109349548
    {Coordinate{43.4379, 56.1037}, CountryId{"RU"}}, // Q109349549
    {Coordinate{43.2313, 56.0487}, CountryId{"RU"}}, // Q109349552
    {Coordinate{43.1565, 56.0342}, CountryId{"RU"}}, // Q109349553
    {Coordinate{43.37, 56.0899}, CountryId{"RU"}}, // Ubezhitsy railway station
    {Coordinate{43.8054, 56.1717}, CountryId{"RU"}}, // Q109350158
    {Coordinate{13.1672, 53.0011}, CountryId{"DE"}}, // Gransee railway station
    {Coordinate{40.3846, 56.028}, CountryId{"RU"}}, // Q109352473
    {Coordinate{40.4185, 55.9987}, CountryId{"RU"}}, // Q109352474
    {Coordinate{40.4434, 55.9503}, CountryId{"RU"}}, // Q109352475
    {Coordinate{40.4865, 55.9044}, CountryId{"RU"}}, // Q109352476
    {Coordinate{40.5199, 55.8425}, CountryId{"RU"}}, // Q109352477
    {Coordinate{40.5547, 55.7995}, CountryId{"RU"}}, // Q109352478
    {Coordinate{40.575, 55.7686}, CountryId{"RU"}}, // Q109352479
    {Coordinate{40.6159, 55.7075}, CountryId{"RU"}}, // Q109352480
    {Coordinate{40.6325, 55.6823}, CountryId{"RU"}}, // Q109352481
    {Coordinate{40.6101, 55.49}, CountryId{"RU"}}, // Q109352482
    {Coordinate{40.6196, 55.4482}, CountryId{"RU"}}, // Q109352483
    {Coordinate{40.6139, 55.3314}, CountryId{"RU"}}, // Q109352484
    {Coordinate{40.6564, 55.2403}, CountryId{"RU"}}, // Q109352486
    {Coordinate{40.6206, 55.2024}, CountryId{"RU"}}, // Q109352487
    {Coordinate{40.3686, 56.058}, CountryId{"RU"}}, // Q109352488
    {Coordinate{10.6716, 51.9}, CountryId{"DE"}}, // Stapelburg train station
    {Coordinate{132.892, 42.8196}, CountryId{"RU"}}, // Torgovy Port
    {Coordinate{43.823, 55.0232}, CountryId{"RU"}}, // Q109368049
    {Coordinate{43.8016, 54.8773}, CountryId{"RU"}}, // Q109368050
    {Coordinate{44.4592, 55.03}, CountryId{"RU"}}, // Lukoyanov railway station
    {Coordinate{44.9092, 54.7926}, CountryId{"RU"}}, // Q109368052
    {Coordinate{45.1231, 54.7632}, CountryId{"RU"}}, // Q109368053
    {Coordinate{45.1903, 54.7163}, CountryId{"RU"}}, // Q109368054
    {Coordinate{45.2466, 54.6988}, CountryId{"RU"}}, // Q109368055
    {Coordinate{45.278, 54.6891}, CountryId{"RU"}}, // Q109368056
    {Coordinate{45.3206, 54.6724}, CountryId{"RU"}}, // Q109368057
    {Coordinate{45.3598, 54.6351}, CountryId{"RU"}}, // Q109368058
    {Coordinate{45.383, 54.5854}, CountryId{"RU"}}, // Q109368059
    {Coordinate{45.3607, 54.5029}, CountryId{"RU"}}, // Q109368060
    {Coordinate{45.3618, 54.4693}, CountryId{"RU"}}, // Q109368061
    {Coordinate{44.111, 55.1896}, CountryId{"RU"}}, // Q109368063
    {Coordinate{15.1, 37.5067}, CountryId{"IT"}}, // Catania Centrale railway station
    {Coordinate{45.3201, 54.3829}, CountryId{"RU"}}, // Q109371160
    {Coordinate{45.2979, 54.2965}, CountryId{"RU"}}, // Q109371161
    {Coordinate{45.2351, 54.2155}, CountryId{"RU"}}, // Q109371162
    {Coordinate{45.1164, 54.0964}, CountryId{"RU"}}, // Q109371163
    {Coordinate{45.087, 54.0796}, CountryId{"RU"}}, // Q109371164
    {Coordinate{45.0608, 54.0622}, CountryId{"RU"}}, // Q109371165
    {Coordinate{45.0225, 54.0553}, CountryId{"RU"}}, // Q109371166
    {Coordinate{44.9959, 54.0539}, CountryId{"RU"}}, // Q109371167
    {Coordinate{45.0152, 53.9246}, CountryId{"RU"}}, // Q109375547
    {Coordinate{44.9896, 53.8553}, CountryId{"RU"}}, // Q109375548
    {Coordinate{45.013, 53.8243}, CountryId{"RU"}}, // Q109375549
    {Coordinate{45.1332, 53.6043}, CountryId{"RU"}}, // Q109375550
    {Coordinate{45.2137, 53.602}, CountryId{"RU"}}, // Q109375552
    {Coordinate{45.2123, 53.5738}, CountryId{"RU"}}, // Q109375553
    {Coordinate{45.199, 53.5582}, CountryId{"RU"}}, // Q109375554
    {Coordinate{45.1435, 53.5112}, CountryId{"RU"}}, // Q109375555
    {Coordinate{45.134, 53.4916}, CountryId{"RU"}}, // Q109375556
    {Coordinate{45.0828, 53.4312}, CountryId{"RU"}}, // Q109375558
    {Coordinate{45.0759, 53.4075}, CountryId{"RU"}}, // Q109375559
    {Coordinate{45.0604, 53.3346}, CountryId{"RU"}}, // Q109375560
    {Coordinate{45.021, 53.2363}, CountryId{"RU"}}, // Q109375561
    {Coordinate{10.8904, 54.2193}, CountryId{"DE"}}, // Lensahn station
    {Coordinate{10.7458, 54.0188}, CountryId{"DE"}}, // Scharbeutz station
    {Coordinate{132.924, 42.839}, CountryId{"RU"}}, // Avtobaza
    {Coordinate{10.7347, 53.9111}, CountryId{"DE"}}, // Lübeck-Dänischburg IKEA station
    {Coordinate{10.7034, 53.9808}, CountryId{"DE"}}, // Pansdorf station
    {Coordinate{10.2759, 54.2336}, CountryId{"DE"}}, // Preetz station
    {Coordinate{10.2437, 54.2809}, CountryId{"DE"}}, // Raisdorf station
    {Coordinate{8.53391, 51.9556}, CountryId{"DE"}}, // Bielefeld-Windelsbleiche station
    {Coordinate{8.43377, 54.8721}, CountryId{"DE"}}, // Morsum station
    {Coordinate{8.94637, 54.686}, CountryId{"DE"}}, // Langenhorn (Schleswig) station
    {Coordinate{8.97038, 54.6211}, CountryId{"DE"}}, // Bredstedt station
    {Coordinate{43.994, 55.4486}, CountryId{"RU"}}, // Q109380182
    {Coordinate{44.0932, 55.4924}, CountryId{"RU"}}, // Q109380183
    {Coordinate{44.2102, 55.5151}, CountryId{"RU"}}, // Q109380184
    {Coordinate{44.2859, 55.5177}, CountryId{"RU"}}, // Q109380185
    {Coordinate{44.3711, 55.5459}, CountryId{"RU"}}, // Q109380186
    {Coordinate{44.5203, 55.5927}, CountryId{"RU"}}, // Q109380188
    {Coordinate{44.716, 55.5918}, CountryId{"RU"}}, // Q109380189
    {Coordinate{44.8582, 55.57}, CountryId{"RU"}}, // Q109380191
    {Coordinate{45.0075, 55.5563}, CountryId{"RU"}}, // Q109380192
    {Coordinate{45.0705, 55.5554}, CountryId{"RU"}}, // Q109380193
    {Coordinate{45.1985, 55.5239}, CountryId{"RU"}}, // Q109380194
    {Coordinate{45.2816, 55.5123}, CountryId{"RU"}}, // Q109380195
    {Coordinate{46.5396, 55.477}, CountryId{"RU"}}, // Q109380196
    {Coordinate{46.5752, 55.4748}, CountryId{"RU"}}, // Q109380197
    {Coordinate{46.6134, 55.4837}, CountryId{"RU"}}, // Q109380198
    {Coordinate{46.6708, 55.4975}, CountryId{"RU"}}, // Q109380199
    {Coordinate{46.7402, 55.4837}, CountryId{"RU"}}, // Q109380200
    {Coordinate{46.825, 55.4798}, CountryId{"RU"}}, // Q109380201
    {Coordinate{46.872, 55.4878}, CountryId{"RU"}}, // Q109380202
    {Coordinate{46.9487, 55.4879}, CountryId{"RU"}}, // Q109380203
    {Coordinate{47.0015, 55.4752}, CountryId{"RU"}}, // Q109380204
    {Coordinate{47.0967, 55.4705}, CountryId{"RU"}}, // Q109380205
    {Coordinate{47.1374, 55.4798}, CountryId{"RU"}}, // Q109380206
    {Coordinate{47.1836, 55.4914}, CountryId{"RU"}}, // Q109380207
    {Coordinate{47.2274, 55.4992}, CountryId{"RU"}}, // Q109380208
    {Coordinate{47.2967, 55.5078}, CountryId{"RU"}}, // Q109380209
    {Coordinate{47.349, 55.5032}, CountryId{"RU"}}, // Q109380210
    {Coordinate{47.3944, 55.492}, CountryId{"RU"}}, // Q109380211
    {Coordinate{9.03084, 54.3305}, CountryId{"DE"}}, // Lunden station
    {Coordinate{8.99832, 54.3858}, CountryId{"DE"}}, // Witzwort station
    {Coordinate{8.75874, 54.3257}, CountryId{"DE"}}, // Sandwehle station
    {Coordinate{47.3804, 55.4667}, CountryId{"RU"}}, // Q109380774
    {Coordinate{47.3239, 55.4235}, CountryId{"RU"}}, // Q109380775
    {Coordinate{47.1119, 55.3481}, CountryId{"RU"}}, // Q109380776
    {Coordinate{46.9915, 55.2555}, CountryId{"RU"}}, // Q109380777
    {Coordinate{47.0551, 55.1973}, CountryId{"RU"}}, // Q109380778
    {Coordinate{46.9885, 55.1544}, CountryId{"RU"}}, // Q109380779
    {Coordinate{46.8602, 55.0817}, CountryId{"RU"}}, // Q109380780
    {Coordinate{46.7047, 55.0031}, CountryId{"RU"}}, // Q109380781
    {Coordinate{46.6919, 54.9092}, CountryId{"RU"}}, // Q109380782
    {Coordinate{46.3886, 54.8171}, CountryId{"RU"}}, // Q109380783
    {Coordinate{46.3386, 54.7841}, CountryId{"RU"}}, // Q109380784
    {Coordinate{46.268, 54.7595}, CountryId{"RU"}}, // Q109380785
    {Coordinate{46.1713, 54.7399}, CountryId{"RU"}}, // Q109380786
    {Coordinate{46.1095, 54.6991}, CountryId{"RU"}}, // Q109380787
    {Coordinate{46.0609, 54.6658}, CountryId{"RU"}}, // Q109380788
    {Coordinate{46.0839, 54.5842}, CountryId{"RU"}}, // Q109380789
    {Coordinate{45.9953, 54.5507}, CountryId{"RU"}}, // Q109380790
    {Coordinate{45.905, 54.4805}, CountryId{"RU"}}, // Q109380791
    {Coordinate{45.8531, 54.4497}, CountryId{"RU"}}, // Q109380792
    {Coordinate{45.834, 54.4367}, CountryId{"RU"}}, // Q109380793
    {Coordinate{45.7821, 54.4037}, CountryId{"RU"}}, // Q109380794
    {Coordinate{45.6158, 54.381}, CountryId{"RU"}}, // Q109380795
    {Coordinate{45.5508, 54.3714}, CountryId{"RU"}}, // Q109380796
    {Coordinate{45.4658, 54.3839}, CountryId{"RU"}}, // Q109380797
    {Coordinate{45.4488, 54.4082}, CountryId{"RU"}}, // Q109380798
    {Coordinate{45.4141, 54.4189}, CountryId{"RU"}}, // Q109380799
    {Coordinate{45.3731, 54.4261}, CountryId{"RU"}}, // Q109380800
    {Coordinate{9.48218, 53.8351}, CountryId{"DE"}}, // Krempe station
    {Coordinate{9.48413, 53.7836}, CountryId{"DE"}}, // Herzhorn station
    {Coordinate{9.18029, 54.1689}, CountryId{"DE"}}, // Nordhastedt station
    {Coordinate{9.29247, 54.1462}, CountryId{"DE"}}, // Albersdorf station
    {Coordinate{9.41513, 54.1228}, CountryId{"DE"}}, // Hademarschen station
    {Coordinate{9.01921, 54.2194}, CountryId{"DE"}}, // Tiebensee station
    {Coordinate{8.96311, 54.2121}, CountryId{"DE"}}, // Jarrenwisch station
    {Coordinate{8.93281, 54.2072}, CountryId{"DE"}}, // Wesselburen station
    {Coordinate{11.1555, 52.1768}, CountryId{"DE"}}, // Wefensleben railway station
    {Coordinate{11.3426, 52.1439}, CountryId{"DE"}}, // Dreileben-Drackenstedt railway station
    {Coordinate{11.382, 52.1445}, CountryId{"DE"}}, // Ochtmersleben railway stop
    {Coordinate{11.5023, 52.13}, CountryId{"DE"}}, // Niederndodeleben railway station
    {Coordinate{47.5443, 55.5577}, CountryId{"RU"}}, // Q109386853
    {Coordinate{47.5999, 55.5995}, CountryId{"RU"}}, // Q109386854
    {Coordinate{47.6426, 55.6138}, CountryId{"RU"}}, // Q109386855
    {Coordinate{47.8227, 55.658}, CountryId{"RU"}}, // Q109386856
    {Coordinate{47.8663, 55.6645}, CountryId{"RU"}}, // Q109386858
    {Coordinate{47.9441, 55.6865}, CountryId{"RU"}}, // Q109386859
    {Coordinate{48.081, 55.7485}, CountryId{"RU"}}, // Q109386860
    {Coordinate{48.143, 55.7575}, CountryId{"RU"}}, // Q109386862
    {Coordinate{48.3348, 55.7959}, CountryId{"RU"}}, // Warabiä
    {Coordinate{48.3687, 55.7687}, CountryId{"RU"}}, // Şırdan
    {Coordinate{11.6382, 52.0976}, CountryId{"DE"}}, // Magdeburg SKET Industriepark railway stop
    {Coordinate{11.6309, 52.0608}, CountryId{"DE"}}, // Beyendorf railway stop
    {Coordinate{11.6565, 52.0807}, CountryId{"DE"}}, // Magdeburg-Salbke railway stop
    {Coordinate{11.6128, 52.049}, CountryId{"DE"}}, // Dodendorf railway station
    {Coordinate{48.5215, 55.8106}, CountryId{"RU"}}, // Q109388403
    {Coordinate{48.5026, 55.8423}, CountryId{"RU"}}, // Q109389087
    {Coordinate{48.6468, 55.8484}, CountryId{"RU"}}, // Altaş
    {Coordinate{48.7402, 55.8426}, CountryId{"RU"}}, // Q109394182
    {Coordinate{48.809, 55.8291}, CountryId{"RU"}}, // Q109394183
    {Coordinate{48.8621, 55.8229}, CountryId{"RU"}}, // WRD
    {Coordinate{48.9792, 55.8327}, CountryId{"RU"}}, // Lifçinkı
    {Coordinate{11.8561, 51.7569}, CountryId{"DE"}}, // Biendorf railway stop
    {Coordinate{11.6335, 51.6736}, CountryId{"DE"}}, // Belleben railway stop
    {Coordinate{11.544, 51.7024}, CountryId{"DE"}}, // Freckleben railway stop
    {Coordinate{11.5158, 51.7218}, CountryId{"DE"}}, // Drohndorf-Mehringen railway station
    {Coordinate{48.9714, 55.8018}, CountryId{"RU"}}, // İske Uraqçı
    {Coordinate{49.0116, 55.8013}, CountryId{"RU"}}, // Lagir
    {Coordinate{49.0656, 55.8021}, CountryId{"RU"}}, // Bişbalta
    {Coordinate{11.5213, 51.7515}, CountryId{"DE"}}, // Schierstedt railway stop
    {Coordinate{11.5676, 51.7639}, CountryId{"DE"}}, // Giersleben railway stop
    {Coordinate{11.8993, 51.7491}, CountryId{"DE"}}, // Frenz railway stop
    {Coordinate{11.5937, 51.8249}, CountryId{"DE"}}, // Neundorf (Anhalt) railway stop
    {Coordinate{11.677, 51.9468}, CountryId{"DE"}}, // Eickendorf railway station
    {Coordinate{11.696, 51.9751}, CountryId{"DE"}}, // Eggersdorf railway stop
    {Coordinate{11.8842, 51.6087}, CountryId{"DE"}}, // Nauendorf (Saalkr) railway stop
    {Coordinate{11.9215, 51.5816}, CountryId{"DE"}}, // Wallwitz (Saalkr) railway station
    {Coordinate{11.9594, 51.5553}, CountryId{"DE"}}, // Teicha railway stop
    {Coordinate{11.9648, 51.5173}, CountryId{"DE"}}, // Halle Wohnstadt Nord railway stop
    {Coordinate{36.0802, 54.4886}, CountryId{"RU"}}, // Q109412325
    {Coordinate{35.997, 54.4479}, CountryId{"RU"}}, // Q109412326
    {Coordinate{35.9345, 54.444}, CountryId{"RU"}}, // Q109412327
    {Coordinate{35.8661, 54.4313}, CountryId{"RU"}}, // Q109412328
    {Coordinate{35.7185, 54.3694}, CountryId{"RU"}}, // Q109412329
    {Coordinate{35.6371, 54.3402}, CountryId{"RU"}}, // Q109412330
    {Coordinate{35.6204, 54.309}, CountryId{"RU"}}, // Lipitsy
    {Coordinate{35.4693, 54.1859}, CountryId{"RU"}}, // Q109412333
    {Coordinate{35.4394, 54.164}, CountryId{"RU"}}, // Q109412334
    {Coordinate{35.1754, 53.9501}, CountryId{"RU"}}, // Q109415541
    {Coordinate{35.0634, 53.8714}, CountryId{"RU"}}, // Q109415542
    {Coordinate{34.8093, 53.6382}, CountryId{"RU"}}, // Q109415543
    {Coordinate{34.7672, 53.5623}, CountryId{"RU"}}, // Q109415544
    {Coordinate{34.7006, 53.4788}, CountryId{"RU"}}, // Q109415545
    {Coordinate{34.6677, 53.4447}, CountryId{"RU"}}, // Q109415546
    {Coordinate{34.6236, 53.3987}, CountryId{"RU"}}, // Batagovo
    {Coordinate{34.5837, 53.3613}, CountryId{"RU"}}, // 359 km
    {Coordinate{34.393, 53.1987}, CountryId{"RU"}}, // Zapadnyi Park
    {Coordinate{34.4254, 53.1385}, CountryId{"RU"}}, // 387 km
    {Coordinate{34.4281, 53.1135}, CountryId{"RU"}}, // Styazhnoye
    {Coordinate{34.4395, 53.0234}, CountryId{"RU"}}, // Sinezyorki
    {Coordinate{34.4628, 52.9828}, CountryId{"RU"}}, // Chichkovo
    {Coordinate{34.4576, 52.9282}, CountryId{"RU"}}, // Klyukovniki
    {Coordinate{34.4653, 52.8701}, CountryId{"RU"}}, // Kaligayevka
    {Coordinate{11.3329, 51.803}, CountryId{"DE"}}, // Nachterstedt-Hoym railway station
    {Coordinate{11.2913, 51.8281}, CountryId{"DE"}}, // Gatersleben railway stop
    {Coordinate{11.1686, 51.8715}, CountryId{"DE"}}, // Wegeleben railway station
    {Coordinate{11.1867, 51.8334}, CountryId{"DE"}}, // Ditfurt railway stop
    {Coordinate{11.0852, 51.7524}, CountryId{"DE"}}, // Neinstedt railway stop
    {Coordinate{11.3246, 52.0073}, CountryId{"DE"}}, // Hadmersleben railway stop
    {Coordinate{11.5757, 52.0491}, CountryId{"DE"}}, // Osterweddingen railway stop
    {Coordinate{34.4523, 52.7584}, CountryId{"RU"}}, // Q109418912
    {Coordinate{34.3653, 52.6756}, CountryId{"RU"}}, // Q109418913
    {Coordinate{34.3307, 52.6372}, CountryId{"RU"}}, // Q109418914
    {Coordinate{34.2869, 52.5885}, CountryId{"RU"}}, // Q109418915
    {Coordinate{34.2445, 52.541}, CountryId{"RU"}}, // Q109418916
    {Coordinate{34.2112, 52.5035}, CountryId{"RU"}}, // Q109418917
    {Coordinate{34.1006, 52.3555}, CountryId{"RU"}}, // Q109418918
    {Coordinate{132.941, 42.8417}, CountryId{"RU"}}, // Ugolbaza
    {Coordinate{10.7698, 51.8388}, CountryId{"DE"}}, // Wernigerode Elmowerk railway stop
    {Coordinate{10.7328, 51.8491}, CountryId{"DE"}}, // Darlingerode railway stop
    {Coordinate{11.2642, 52.8366}, CountryId{"DE"}}, // Pretzier railway stop
    {Coordinate{11.3781, 52.791}, CountryId{"DE"}}, // Fleetmark railway stop
    {Coordinate{11.4838, 52.7515}, CountryId{"DE"}}, // Brunau-Packebusch railway station
    {Coordinate{11.7292, 52.6147}, CountryId{"DE"}}, // Steinfeld railway stop
    {Coordinate{11.7892, 52.3945}, CountryId{"DE"}}, // Mahlwinkel railway stop
    {Coordinate{11.6803, 52.2964}, CountryId{"DE"}}, // Zielitz railway station
    {Coordinate{11.6763, 52.2883}, CountryId{"DE"}}, // Zielitz Ort railway stop
    {Coordinate{11.6409, 52.2142}, CountryId{"DE"}}, // Barleber See railway stop
    {Coordinate{11.6479, 52.1866}, CountryId{"DE"}}, // Magdeburg-Rothensee railway stop
    {Coordinate{12.047, 53.1228}, CountryId{"DE"}}, // Groß Pankow railway station
    {Coordinate{12.3426, 53.1501}, CountryId{"DE"}}, // Heiligengrabe railway stop
    {Coordinate{12.3924, 53.1512}, CountryId{"DE"}}, // Liebenthal (Prignitz) railway stop
    {Coordinate{10.6092, 51.4533}, CountryId{"DE"}}, // Bleicherode Ost railway station
    {Coordinate{36.3074, 54.5552}, CountryId{"RU"}}, // Perspektivnaya
    {Coordinate{36.3338, 54.5847}, CountryId{"RU"}}, // 174 km
    {Coordinate{36.389, 54.6008}, CountryId{"RU"}}, // Q109444461
    {Coordinate{36.4593, 54.6058}, CountryId{"RU"}}, // Q109444463
    {Coordinate{36.4951, 54.6074}, CountryId{"RU"}}, // Q109444466
    {Coordinate{36.5243, 54.5961}, CountryId{"RU"}}, // Q109444468
    {Coordinate{36.5864, 54.5685}, CountryId{"RU"}}, // Q109444469
    {Coordinate{36.6279, 54.5295}, CountryId{"RU"}}, // Q109444471
    {Coordinate{36.8443, 54.4928}, CountryId{"RU"}}, // Q109444474
    {Coordinate{36.886, 54.5014}, CountryId{"RU"}}, // Q109444476
    {Coordinate{36.9662, 54.5097}, CountryId{"RU"}}, // Q109444478
    {Coordinate{36.9923, 54.5029}, CountryId{"RU"}}, // Q109444480
    {Coordinate{37.0246, 54.4915}, CountryId{"RU"}}, // Q109444482
    {Coordinate{37.0597, 54.5009}, CountryId{"RU"}}, // Q109444484
    {Coordinate{37.1007, 54.4841}, CountryId{"RU"}}, // Q109444486
    {Coordinate{37.1795, 54.4552}, CountryId{"RU"}}, // Rurikovo
    {Coordinate{37.3539, 54.4385}, CountryId{"RU"}}, // Q109444489
    {Coordinate{37.4563, 54.4009}, CountryId{"RU"}}, // Q109444491
    {Coordinate{37.4953, 54.36}, CountryId{"RU"}}, // Q109444493
    {Coordinate{37.4743, 54.3312}, CountryId{"RU"}}, // Q109444495
    {Coordinate{37.4677, 54.2871}, CountryId{"RU"}}, // Q109444497
    {Coordinate{37.4874, 54.255}, CountryId{"RU"}}, // Q109444499
    {Coordinate{10.7091, 50.9976}, CountryId{"DE"}}, // Bufleben railway station
    {Coordinate{34.4295, 55.1702}, CountryId{"RU"}}, // Q109462192
    {Coordinate{34.487, 55.1696}, CountryId{"RU"}}, // Q109462193
    {Coordinate{34.5343, 55.1696}, CountryId{"RU"}}, // Q109462195
    {Coordinate{34.6017, 55.1773}, CountryId{"RU"}}, // Q109462197
    {Coordinate{34.6634, 55.1819}, CountryId{"RU"}}, // Q109462200
    {Coordinate{34.7308, 55.1638}, CountryId{"RU"}}, // Q109462202
    {Coordinate{34.7893, 55.1492}, CountryId{"RU"}}, // Q109462203
    {Coordinate{34.8452, 55.1399}, CountryId{"RU"}}, // Q109462205
    {Coordinate{34.9024, 55.1352}, CountryId{"RU"}}, // Q109462207
    {Coordinate{35.0639, 55.0583}, CountryId{"RU"}}, // 57 km
    {Coordinate{35.1419, 55.0189}, CountryId{"RU"}}, // Ugryumovo
    {Coordinate{35.2213, 55.0054}, CountryId{"RU"}}, // 69 km
    {Coordinate{35.3347, 54.9822}, CountryId{"RU"}}, // Q109462215
    {Coordinate{35.399, 54.9677}, CountryId{"RU"}}, // Q109462218
    {Coordinate{35.4338, 54.9504}, CountryId{"RU"}}, // Q109462221
    {Coordinate{35.5952, 54.9304}, CountryId{"RU"}}, // Q109462222
    {Coordinate{35.738, 54.846}, CountryId{"RU"}}, // Q109462223
    {Coordinate{35.7898, 54.8184}, CountryId{"RU"}}, // Q109462225
    {Coordinate{35.9721, 54.7289}, CountryId{"RU"}}, // Q109462227
    {Coordinate{35.975, 54.6951}, CountryId{"RU"}}, // Shanya railway station
    {Coordinate{36.0207, 54.69}, CountryId{"RU"}}, // Q109462229
    {Coordinate{36.0725, 54.6906}, CountryId{"RU"}}, // Q109462230
    {Coordinate{36.0998, 54.6772}, CountryId{"RU"}}, // Q109462231
    {Coordinate{36.1384, 54.6341}, CountryId{"RU"}}, // Q109462233
    {Coordinate{34.3167, 55.1732}, CountryId{"RU"}}, // Q109463349
    {Coordinate{34.344, 55.1723}, CountryId{"RU"}}, // Q109463350
    {Coordinate{10.9829, 50.4055}, CountryId{"DE"}}, // Bachfeld
    {Coordinate{11.0015, 50.4006}, CountryId{"DE"}}, // Schalkau railway station
    {Coordinate{11.064, 50.3871}, CountryId{"DE"}}, // Seltendorf railway halt
    {Coordinate{11.2002, 50.3524}, CountryId{"DE"}}, // Sonneberg (Thür) Ost
    {Coordinate{11.2075, 50.3655}, CountryId{"DE"}}, // Sonneberg (Thür) Nord
    {Coordinate{11.2, 50.3788}, CountryId{"DE"}}, // Hüttengrund
    {Coordinate{11.2035, 50.3972}, CountryId{"DE"}}, // Blechhammer (Thür)
    {Coordinate{11.159, 50.4325}, CountryId{"DE"}}, // Steinach (Thür)
    {Coordinate{11.2821, 50.3068}, CountryId{"DE"}}, // Stockheim (Oberfr)
    {Coordinate{11.957, 50.7663}, CountryId{"DE"}}, // Niederpöllnitz
    {Coordinate{34.407, 55.1448}, CountryId{"RU"}}, // Q109468939
    {Coordinate{34.3841, 55.1119}, CountryId{"RU"}}, // Q109468940
    {Coordinate{34.3563, 55.0585}, CountryId{"RU"}}, // Q109468941
    {Coordinate{34.3416, 54.9891}, CountryId{"RU"}}, // Q109468943
    {Coordinate{34.3312, 54.9125}, CountryId{"RU"}}, // Q109468944
    {Coordinate{34.3273, 54.8366}, CountryId{"RU"}}, // Q109468945
    {Coordinate{34.3438, 54.6919}, CountryId{"RU"}}, // Q109468947
    {Coordinate{34.3424, 54.6108}, CountryId{"RU"}}, // Q109468948
    {Coordinate{34.3414, 54.5725}, CountryId{"RU"}}, // Q109468949
    {Coordinate{34.3294, 54.5278}, CountryId{"RU"}}, // Q109468951
    {Coordinate{34.2993, 54.4842}, CountryId{"RU"}}, // Q109468952
    {Coordinate{34.2951, 54.4384}, CountryId{"RU"}}, // Q109468953
    {Coordinate{34.3406, 55.0017}, CountryId{"RU"}}, // Q109469013
    {Coordinate{34.3404, 54.3108}, CountryId{"RU"}}, // Q109471476
    {Coordinate{34.3401, 54.292}, CountryId{"RU"}}, // Q109471478
    {Coordinate{34.3617, 54.2321}, CountryId{"RU"}}, // Q109471482
    {Coordinate{34.3462, 54.1913}, CountryId{"RU"}}, // Q109471483
    {Coordinate{34.3515, 54.1332}, CountryId{"RU"}}, // Q109471484
    {Coordinate{34.3649, 54.0993}, CountryId{"RU"}}, // Q109471485
    {Coordinate{34.4152, 53.3175}, CountryId{"RU"}}, // Uritskiy
    {Coordinate{-0.518264, 38.8457}, CountryId{"ES"}}, // Agullent
    {Coordinate{-0.518264, 38.8457}, CountryId{"ES"}}, // Albaida
    {Coordinate{6.39971, 46.4757}, CountryId{"CH"}}, // Allaman railway station
    {Coordinate{34.4171, 54.0199}, CountryId{"RU"}}, // Q109474150
    {Coordinate{34.3993, 53.9693}, CountryId{"RU"}}, // Ivanovo-Sergiyevsky railway station
    {Coordinate{34.3996, 53.9301}, CountryId{"RU"}}, // Kosyaki railway station
    {Coordinate{34.4096, 53.7868}, CountryId{"RU"}}, // Kosichino railway station
    {Coordinate{34.4081, 53.7506}, CountryId{"RU"}}, // Kuyava railway station
    {Coordinate{34.3951, 53.6985}, CountryId{"RU"}}, // Pren
    {Coordinate{34.3232, 53.5892}, CountryId{"RU"}}, // 190 km
    {Coordinate{34.3817, 53.5025}, CountryId{"RU"}}, // Lyubokhna
    {Coordinate{34.3931, 53.4895}, CountryId{"RU"}}, // 204 km
    {Coordinate{34.4036, 53.4545}, CountryId{"RU"}}, // 207 km
    {Coordinate{34.4021, 53.4426}, CountryId{"RU"}}, // Fokino
    {Coordinate{34.4473, 53.4018}, CountryId{"RU"}}, // 214 km
    {Coordinate{34.4797, 53.3717}, CountryId{"RU"}}, // Punka
    {Coordinate{34.4971, 53.3382}, CountryId{"RU"}}, // Bryansk-Severnyi
    {Coordinate{-0.510475, 38.8674}, CountryId{"ES"}}, // Bufali railway station
    {Coordinate{6.87711, 46.4479}, CountryId{"CH"}}, // Burier railway station
    {Coordinate{32.3544, 54.7717}, CountryId{"RU"}}, // Q109479847
    {Coordinate{32.5947, 54.7264}, CountryId{"RU"}}, // Q109479848
    {Coordinate{32.8758, 54.6401}, CountryId{"RU"}}, // Q109479851
    {Coordinate{32.9761, 54.6181}, CountryId{"RU"}}, // Q109479852
    {Coordinate{33.6697, 54.4921}, CountryId{"RU"}}, // Q109479854
    {Coordinate{33.8139, 54.4668}, CountryId{"RU"}}, // Q109479855
    {Coordinate{33.9181, 54.4485}, CountryId{"RU"}}, // Q109479856
    {Coordinate{34.1974, 54.3879}, CountryId{"RU"}}, // Q109479857
    {Coordinate{34.2599, 54.3659}, CountryId{"RU"}}, // Q109479858
    {Coordinate{34.4335, 54.3341}, CountryId{"RU"}}, // Q109480228
    {Coordinate{34.6786, 54.2637}, CountryId{"RU"}}, // Q109480229
    {Coordinate{34.8162, 54.2216}, CountryId{"RU"}}, // Q109480232
    {Coordinate{34.913, 54.2034}, CountryId{"RU"}}, // Q109480233
    {Coordinate{35.0357, 54.1844}, CountryId{"RU"}}, // Q109480234
    {Coordinate{35.1137, 54.1677}, CountryId{"RU"}}, // Q109480235
    {Coordinate{35.195, 54.1525}, CountryId{"RU"}}, // Q109480236
    {Coordinate{34.7605, 54.2367}, CountryId{"RU"}}, // Q109480247
    {Coordinate{6.89577, 46.4427}, CountryId{"CH"}}, // Clarens railway station
    {Coordinate{6.82477, 46.4704}, CountryId{"CH"}}, // Corseaux-Cornalles railway station
    {Coordinate{6.72715, 46.4886}, CountryId{"CH"}}, // Cully railway station
    {Coordinate{6.74517, 46.4893}, CountryId{"CH"}}, // Épesses railway station
    {Coordinate{7.02552, 46.1693}, CountryId{"CH"}}, // Evionnaz railway station
    {Coordinate{34.4695, 54.0779}, CountryId{"RU"}}, // Q109486246
    {Coordinate{34.5384, 54.0957}, CountryId{"RU"}}, // Q109486248
    {Coordinate{34.6215, 54.0993}, CountryId{"RU"}}, // Q109486250
    {Coordinate{34.6742, 54.1022}, CountryId{"RU"}}, // Q109486253
    {Coordinate{34.7131, 54.0996}, CountryId{"RU"}}, // Q109486255
    {Coordinate{34.7631, 54.096}, CountryId{"RU"}}, // Q109486257
    {Coordinate{34.8099, 54.0861}, CountryId{"RU"}}, // Q109486259
    {Coordinate{34.9119, 54.0674}, CountryId{"RU"}}, // Q109486261
    {Coordinate{34.9539, 54.0448}, CountryId{"RU"}}, // Voymirovo railway station
    {Coordinate{34.9609, 54.037}, CountryId{"RU"}}, // Q109486266
    {Coordinate{35.0369, 54.0434}, CountryId{"RU"}}, // Q109486268
    {Coordinate{35.0794, 54.0571}, CountryId{"RU"}}, // Q109486270
    {Coordinate{35.116, 54.0678}, CountryId{"RU"}}, // Q109486272
    {Coordinate{35.1597, 54.0908}, CountryId{"RU"}}, // Q109486274
    {Coordinate{35.2093, 54.0821}, CountryId{"RU"}}, // Q109486276
    {Coordinate{35.2555, 54.0722}, CountryId{"RU"}}, // Q109486278
    {Coordinate{35.3037, 54.0736}, CountryId{"RU"}}, // Q109486280
    {Coordinate{34.4382, 54.0653}, CountryId{"RU"}}, // Q109486411
    {Coordinate{6.85952, 46.4554}, CountryId{"CH"}}, // La Tour-de-Peilz railway station
    {Coordinate{6.69062, 46.5038}, CountryId{"CH"}}, // Lutry railway station
    {Coordinate{-0.491567, 38.8841}, CountryId{"ES"}}, // Montaverner
    {Coordinate{-0.602522, 38.8095}, CountryId{"ES"}}, // Ontinyent
    {Coordinate{35.4074, 54.1117}, CountryId{"RU"}}, // Q109496965
    {Coordinate{35.5399, 54.0871}, CountryId{"RU"}}, // Q109496966
    {Coordinate{35.6894, 54.0481}, CountryId{"RU"}}, // Q109496969
    {Coordinate{36.3797, 54.1144}, CountryId{"RU"}}, // Q109496970
    {Coordinate{36.429, 54.1186}, CountryId{"RU"}}, // Q109496971
    {Coordinate{36.4793, 54.1275}, CountryId{"RU"}}, // Q109496972
    {Coordinate{36.809, 54.2105}, CountryId{"RU"}}, // Q109496974
    {Coordinate{36.8571, 54.2103}, CountryId{"RU"}}, // Q109496975
    {Coordinate{36.925, 54.2104}, CountryId{"RU"}}, // Q109496976
    {Coordinate{37.0497, 54.2073}, CountryId{"RU"}}, // Q109496977
    {Coordinate{37.1228, 54.2263}, CountryId{"RU"}}, // Q109496978
    {Coordinate{37.1978, 54.2582}, CountryId{"RU"}}, // Q109496980
    {Coordinate{32.9535, 53.9089}, CountryId{"RU"}}, // Pletni
    {Coordinate{33.0577, 53.8531}, CountryId{"RU"}}, // Lyubestovo
    {Coordinate{33.1467, 53.815}, CountryId{"RU"}}, // Prigor'ye
    {Coordinate{33.226, 53.7797}, CountryId{"RU"}}, // Uzkoe
    {Coordinate{33.3347, 53.7367}, CountryId{"RU"}}, // Seshchinskaya
    {Coordinate{33.4015, 53.7078}, CountryId{"RU"}}, // 222 km
    {Coordinate{33.6681, 53.6215}, CountryId{"RU"}}, // 202 km
    {Coordinate{33.7127, 53.5598}, CountryId{"RU"}}, // 193 km
    {Coordinate{33.7714, 53.4849}, CountryId{"RU"}}, // 183 km
    {Coordinate{33.7929, 53.4768}, CountryId{"RU"}}, // Trosna
    {Coordinate{33.8631, 53.4501}, CountryId{"RU"}}, // 176 km
    {Coordinate{34.0436, 53.3819}, CountryId{"RU"}}, // 162 km
    {Coordinate{34.1496, 53.3549}, CountryId{"RU"}}, // Khotylyovo
    {Coordinate{6.65947, 46.5109}, CountryId{"CH"}}, // Pully railway station
    {Coordinate{6.78458, 46.4742}, CountryId{"CH"}}, // Rivaz railway station
    {Coordinate{6.79703, 46.4726}, CountryId{"CH"}}, // St-Saphorin railway station
    {Coordinate{7.00204, 46.2164}, CountryId{"CH"}}, // St-Maurice railway station
    {Coordinate{132.988, 42.8606}, CountryId{"RU"}}, // Radiostantsiya
    {Coordinate{36.0285, 52.9262}, CountryId{"RU"}}, // Q109521591
    {Coordinate{6.92269, 46.4264}, CountryId{"CH"}}, // Territet railway station
    {Coordinate{34.9175, 53.1377}, CountryId{"RU"}}, // Q109526580
    {Coordinate{35.1049, 53.1373}, CountryId{"RU"}}, // Q109526583
    {Coordinate{35.2352, 53.1424}, CountryId{"RU"}}, // Q109526584
    {Coordinate{35.4608, 53.0729}, CountryId{"RU"}}, // Q109526585
    {Coordinate{35.547, 53.0259}, CountryId{"RU"}}, // Q109526586
    {Coordinate{35.7233, 52.9634}, CountryId{"RU"}}, // Q109526589
    {Coordinate{35.8162, 52.9485}, CountryId{"RU"}}, // Q109526590
    {Coordinate{35.6139, 52.9817}, CountryId{"RU"}}, // Q109526610
    {Coordinate{7.03836, 46.1385}, CountryId{"CH"}}, // Vernayaz railway station
    {Coordinate{6.83543, 46.4683}, CountryId{"CH"}}, // Vevey-Funi railway station
    {Coordinate{6.92786, 46.4176}, CountryId{"CH"}}, // Veytaux-Chillon railway station
    {Coordinate{6.70728, 46.4953}, CountryId{"CH"}}, // Villette railway station
    {Coordinate{8.61142, 51.9078}, CountryId{"DE"}}, // Schloß Holte station
    {Coordinate{34.4006, 53.1791}, CountryId{"RU"}}, // Bryansk-Yuzhnyi
    {Coordinate{34.312, 53.1514}, CountryId{"RU"}}, // 18 km
    {Coordinate{34.075, 53.0969}, CountryId{"RU"}}, // Vygonichi
    {Coordinate{34.0548, 53.0763}, CountryId{"RU"}}, // 39 km
    {Coordinate{34.0012, 53.0775}, CountryId{"RU"}}, // 43 km
    {Coordinate{33.9455, 53.0705}, CountryId{"RU"}}, // Pil'shino
    {Coordinate{33.9156, 53.0607}, CountryId{"RU"}}, // 50 km
    {Coordinate{33.8536, 53.0386}, CountryId{"RU"}}, // Khmelevo
    {Coordinate{33.7456, 53.0035}, CountryId{"RU"}}, // Krasny Rog
    {Coordinate{33.6088, 52.9605}, CountryId{"RU"}}, // Panikovka
    {Coordinate{33.5648, 52.947}, CountryId{"RU"}}, // 76 km
    {Coordinate{33.3923, 52.8882}, CountryId{"RU"}}, // 90 km
    {Coordinate{33.3174, 52.8842}, CountryId{"RU"}}, // Nemolodva
    {Coordinate{33.2062, 52.8831}, CountryId{"RU"}}, // 103 km
    {Coordinate{33.0487, 52.8769}, CountryId{"RU"}}, // 113 km
    {Coordinate{32.9742, 52.8628}, CountryId{"RU"}}, // Q109540462
    {Coordinate{32.9155, 52.8527}, CountryId{"RU"}}, // 123 km
    {Coordinate{32.8382, 52.8556}, CountryId{"RU"}}, // Korobonichi
    {Coordinate{33.2615, 52.8879}, CountryId{"RU"}}, // 99 km
    {Coordinate{34.4979, 52.7957}, CountryId{"RU"}}, // 427 km
    {Coordinate{34.4829, 52.7346}, CountryId{"RU"}}, // Devich'ye
    {Coordinate{34.5109, 52.6952}, CountryId{"RU"}}, // 439 km
    {Coordinate{34.5173, 52.6631}, CountryId{"RU"}}, // Pogreby
    {Coordinate{34.5779, 52.5876}, CountryId{"RU"}}, // Brasovo
    {Coordinate{34.665, 52.5459}, CountryId{"RU"}}, // Rassoshka
    {Coordinate{34.6819, 52.5181}, CountryId{"RU"}}, // 463 km
    {Coordinate{34.7017, 52.4913}, CountryId{"RU"}}, // Arkino
    {Coordinate{34.7844, 52.4156}, CountryId{"RU"}}, // Komarichi
    {Coordinate{34.833, 52.3763}, CountryId{"RU"}}, // 482 km
    {Coordinate{34.837, 52.3386}, CountryId{"RU"}}, // Usozha
    {Coordinate{34.8519, 52.2732}, CountryId{"RU"}}, // Yevdokimovka
    {Coordinate{34.9072, 52.2489}, CountryId{"RU"}}, // 499 km
    {Coordinate{35.0032, 52.1734}, CountryId{"RU"}}, // Q109544971
    {Coordinate{35.0624, 52.1241}, CountryId{"RU"}}, // Dmitriev-Lgovsky
    {Coordinate{35.0616, 52.077}, CountryId{"RU"}}, // Q109544974
    {Coordinate{35.0832, 52.0561}, CountryId{"RU"}}, // Q109544975
    {Coordinate{32.2251, 54.7305}, CountryId{"RU"}}, // 368 km
    {Coordinate{32.3632, 54.6148}, CountryId{"RU"}}, // 349 km
    {Coordinate{32.6183, 52.8296}, CountryId{"RU"}}, // 143 km
    {Coordinate{32.5507, 52.8095}, CountryId{"RU"}}, // Peschaniki
    {Coordinate{32.4957, 52.7866}, CountryId{"RU"}}, // 153 km
    {Coordinate{32.4015, 52.7674}, CountryId{"RU"}}, // Robchik
    {Coordinate{32.3463, 52.76}, CountryId{"RU"}}, // Q109555967
    {Coordinate{32.1748, 52.657}, CountryId{"RU"}}, // Q109555968
    {Coordinate{32.1267, 52.6086}, CountryId{"RU"}}, // Q109555969
    {Coordinate{32.0936, 52.5551}, CountryId{"RU"}}, // Q109555970
    {Coordinate{31.6652, 52.4747}, CountryId{"RU"}}, // Zlynka
    {Coordinate{32.1903, 52.3703}, CountryId{"RU"}}, // Q109555973
    {Coordinate{32.0137, 52.5306}, CountryId{"RU"}}, // Q109555975
    {Coordinate{133, 42.8744}, CountryId{"RU"}}, // Golubovka
    {Coordinate{3.43502, 43.4942}, CountryId{"FR"}}, // Gare de Lézignan-la-Cèbe
    {Coordinate{38.1159, 54.0083}, CountryId{"RU"}}, // Q109562464
    {Coordinate{37.5568, 54.1693}, CountryId{"RU"}}, // Q109562785
    {Coordinate{37.5632, 54.1268}, CountryId{"RU"}}, // Q109562786
    {Coordinate{37.5457, 54.0527}, CountryId{"RU"}}, // Q109562788
    {Coordinate{37.501, 54.0097}, CountryId{"RU"}}, // Q109562789
    {Coordinate{37.4991, 53.9256}, CountryId{"RU"}}, // Q109562790
    {Coordinate{37.5053, 53.8873}, CountryId{"RU"}}, // Q109562791
    {Coordinate{37.4367, 53.8042}, CountryId{"RU"}}, // Q109562792
    {Coordinate{37.3471, 53.7518}, CountryId{"RU"}}, // Q109562794
    {Coordinate{37.3138, 53.7071}, CountryId{"RU"}}, // Q109562795
    {Coordinate{37.2277, 53.652}, CountryId{"RU"}}, // Q109562796
    {Coordinate{37.2093, 53.6272}, CountryId{"RU"}}, // Q109562797
    {Coordinate{37.6938, 54.1829}, CountryId{"RU"}}, // Q109563004
    {Coordinate{37.7434, 54.1557}, CountryId{"RU"}}, // Q109563005
    {Coordinate{37.784, 54.1262}, CountryId{"RU"}}, // Q109563006
    {Coordinate{37.8119, 54.1197}, CountryId{"RU"}}, // Q109563007
    {Coordinate{37.8527, 54.1139}, CountryId{"RU"}}, // Q109563008
    {Coordinate{37.9066, 54.11}, CountryId{"RU"}}, // Q109563009
    {Coordinate{37.9852, 54.0717}, CountryId{"RU"}}, // Q109563011
    {Coordinate{38.046, 54.0221}, CountryId{"RU"}}, // Q109563012
    {Coordinate{38.1424, 54.0712}, CountryId{"RU"}}, // Q109563087
    {Coordinate{8.64198, 51.8649}, CountryId{"DE"}}, // Hövelriege station
    {Coordinate{36.8821, 53.51}, CountryId{"RU"}}, // Q109564661
    {Coordinate{36.7891, 53.4337}, CountryId{"RU"}}, // Q109564665
    {Coordinate{36.6959, 53.3693}, CountryId{"RU"}}, // Q109564668
    {Coordinate{36.6654, 53.3497}, CountryId{"RU"}}, // Q109564670
    {Coordinate{36.6233, 53.3215}, CountryId{"RU"}}, // Q109564671
    {Coordinate{36.5749, 53.3195}, CountryId{"RU"}}, // Q109564674
    {Coordinate{36.3824, 53.202}, CountryId{"RU"}}, // Q109564676
    {Coordinate{36.2906, 53.114}, CountryId{"RU"}}, // Q109564678
    {Coordinate{36.1901, 53.058}, CountryId{"RU"}}, // Q109564680
    {Coordinate{36.164, 53.0489}, CountryId{"RU"}}, // Q109564682
    {Coordinate{36.134, 53.0377}, CountryId{"RU"}}, // Q109564684
    {Coordinate{36.9555, 53.5391}, CountryId{"RU"}}, // Q109564698
    {Coordinate{36.7274, 53.3957}, CountryId{"RU"}}, // Q109564718
    {Coordinate{23.792, 55.525}, CountryId{"LT"}}, // Gudžiūnai train station
    {Coordinate{36.1548, 52.9179}, CountryId{"RU"}}, // Q109574970
    {Coordinate{36.1727, 52.8763}, CountryId{"RU"}}, // Q109574972
    {Coordinate{36.1998, 52.8575}, CountryId{"RU"}}, // Q109574973
    {Coordinate{36.2615, 52.8242}, CountryId{"RU"}}, // Q109574974
    {Coordinate{36.3031, 52.7863}, CountryId{"RU"}}, // Q109574976
    {Coordinate{36.3103, 52.7409}, CountryId{"RU"}}, // Q109574977
    {Coordinate{36.3198, 52.7079}, CountryId{"RU"}}, // Q109574978
    {Coordinate{36.3713, 52.6656}, CountryId{"RU"}}, // Q109574980
    {Coordinate{36.376, 52.6204}, CountryId{"RU"}}, // Q109574981
    {Coordinate{36.3661, 52.5571}, CountryId{"RU"}}, // Q109574982
    {Coordinate{36.3302, 52.4978}, CountryId{"RU"}}, // Q109574983
    {Coordinate{36.2584, 52.4304}, CountryId{"RU"}}, // Q109574984
    {Coordinate{36.3072, 52.3881}, CountryId{"RU"}}, // Q109574986
    {Coordinate{36.2704, 52.2555}, CountryId{"RU"}}, // Q109574987
    {Coordinate{36.2966, 52.1494}, CountryId{"RU"}}, // Q109574988
    {Coordinate{36.3252, 52.1177}, CountryId{"RU"}}, // Q109574989
    {Coordinate{36.3744, 52.0831}, CountryId{"RU"}}, // Zolotukhino railway station
    {Coordinate{36.3743, 52.0542}, CountryId{"RU"}}, // Q109574992
    {Coordinate{36.376, 52.0229}, CountryId{"RU"}}, // Q109574993
    {Coordinate{36.3813, 51.9858}, CountryId{"RU"}}, // Q109574994
    {Coordinate{36.3648, 51.9466}, CountryId{"RU"}}, // Q109574996
    {Coordinate{36.3253, 51.9052}, CountryId{"RU"}}, // Q109574997
    {Coordinate{36.2978, 51.876}, CountryId{"RU"}}, // Q109574999
    {Coordinate{36.2723, 51.8492}, CountryId{"RU"}}, // Q109575000
    {Coordinate{36.2527, 51.8007}, CountryId{"RU"}}, // Q109575002
    {Coordinate{2.19348, 49.8316}, CountryId{"FR"}}, // Gare de Bacouel-sur-Selle
    {Coordinate{36.1109, 52.9549}, CountryId{"RU"}}, // Q109581526
    {Coordinate{36.1234, 52.9694}, CountryId{"RU"}}, // Q109581527
    {Coordinate{36.2705, 52.9287}, CountryId{"RU"}}, // Q109581528
    {Coordinate{36.2985, 52.9482}, CountryId{"RU"}}, // Q109581529
    {Coordinate{36.3358, 52.9494}, CountryId{"RU"}}, // Q109581530
    {Coordinate{36.3926, 52.9452}, CountryId{"RU"}}, // Q109581531
    {Coordinate{36.4799, 52.9483}, CountryId{"RU"}}, // Q109581532
    {Coordinate{36.5706, 52.949}, CountryId{"RU"}}, // Q109581533
    {Coordinate{36.7294, 52.9191}, CountryId{"RU"}}, // Q109581535
    {Coordinate{36.9916, 52.8773}, CountryId{"RU"}}, // Q109581536
    {Coordinate{37.0932, 52.8264}, CountryId{"RU"}}, // Q109581537
    {Coordinate{2.22684, 49.8626}, CountryId{"FR"}}, // Gare de Saleux
    {Coordinate{35.1256, 52.0428}, CountryId{"RU"}}, // Q109583998
    {Coordinate{35.1594, 52.0647}, CountryId{"RU"}}, // Q109583999
    {Coordinate{35.2741, 52.1421}, CountryId{"RU"}}, // Q109584002
    {Coordinate{35.3185, 52.162}, CountryId{"RU"}}, // Q109584003
    {Coordinate{35.3499, 52.1802}, CountryId{"RU"}}, // Q109584004
    {Coordinate{35.3974, 52.2078}, CountryId{"RU"}}, // Q109584005
    {Coordinate{35.4433, 52.254}, CountryId{"RU"}}, // Q109584006
    {Coordinate{35.4253, 52.2727}, CountryId{"RU"}}, // Q109584007
    {Coordinate{35.398, 52.2924}, CountryId{"RU"}}, // Q109584008
    {Coordinate{35.3958, 52.3445}, CountryId{"RU"}}, // Q109584009
    {Coordinate{35.4243, 52.3658}, CountryId{"RU"}}, // Q109584010
    {Coordinate{35.4734, 52.382}, CountryId{"RU"}}, // Q109584011
    {Coordinate{35.497, 52.3966}, CountryId{"RU"}}, // Q109584014
    {Coordinate{35.6231, 52.4926}, CountryId{"RU"}}, // Q109584017
    {Coordinate{35.6546, 52.529}, CountryId{"RU"}}, // Q109584018
    {Coordinate{35.6751, 52.5568}, CountryId{"RU"}}, // Q109584019
    {Coordinate{35.8121, 52.6647}, CountryId{"RU"}}, // Q109584020
    {Coordinate{35.8627, 52.7027}, CountryId{"RU"}}, // Q109584021
    {Coordinate{35.8954, 52.7267}, CountryId{"RU"}}, // Q109584022
    {Coordinate{35.9237, 52.7552}, CountryId{"RU"}}, // Q109584023
    {Coordinate{35.95, 52.7975}, CountryId{"RU"}}, // Q109584024
    {Coordinate{35.9601, 52.8419}, CountryId{"RU"}}, // Q109584025
    {Coordinate{35.2087, 52.1112}, CountryId{"RU"}}, // Q109584398
    {Coordinate{35.1436, 51.9957}, CountryId{"RU"}}, // Q109587204
    {Coordinate{35.1854, 51.9772}, CountryId{"RU"}}, // Q109587205
    {Coordinate{35.2336, 51.9558}, CountryId{"RU"}}, // Q109587206
    {Coordinate{35.2722, 51.9356}, CountryId{"RU"}}, // Q109587207
    {Coordinate{35.3118, 51.897}, CountryId{"RU"}}, // Q109587208
    {Coordinate{35.2916, 51.8405}, CountryId{"RU"}}, // Konyshevka Train Station
    {Coordinate{35.3011, 51.7938}, CountryId{"RU"}}, // Q109587210
    {Coordinate{35.2563, 51.7627}, CountryId{"RU"}}, // Q109587211
    {Coordinate{35.2469, 51.6914}, CountryId{"RU"}}, // Sherekino railway station
    {Coordinate{35.246, 51.6474}, CountryId{"RU"}}, // Q109587213
    {Coordinate{34.7313, 51.2884}, CountryId{"RU"}}, // Q109588384
    {Coordinate{34.8021, 51.3103}, CountryId{"RU"}}, // Q109588386
    {Coordinate{34.8317, 51.3254}, CountryId{"RU"}}, // Q109588387
    {Coordinate{34.8648, 51.3422}, CountryId{"RU"}}, // Q109588388
    {Coordinate{34.8951, 51.3759}, CountryId{"RU"}}, // Q109588389
    {Coordinate{34.9094, 51.4375}, CountryId{"RU"}}, // Q109588390
    {Coordinate{35.0181, 51.4543}, CountryId{"RU"}}, // Q109588391
    {Coordinate{35.0806, 51.5004}, CountryId{"RU"}}, // Q109588392
    {Coordinate{35.1166, 51.5319}, CountryId{"RU"}}, // Q109588393
    {Coordinate{35.1225, 51.5625}, CountryId{"RU"}}, // Q109588394
    {Coordinate{35.1576, 51.6116}, CountryId{"RU"}}, // Q109588395
    {Coordinate{35.1967, 51.6342}, CountryId{"RU"}}, // Q109588396
    {Coordinate{16.5057, 59.3692}, CountryId{"SE"}}, // Eskilstuna Central Station
    {Coordinate{35.327, 51.6316}, CountryId{"RU"}}, // Q109593157
    {Coordinate{35.3591, 51.6119}, CountryId{"RU"}}, // Q109593158
    {Coordinate{35.409, 51.5978}, CountryId{"RU"}}, // Q109593159
    {Coordinate{35.4644, 51.6108}, CountryId{"RU"}}, // Q109593160
    {Coordinate{35.4987, 51.6214}, CountryId{"RU"}}, // Q109593161
    {Coordinate{35.5843, 51.6487}, CountryId{"RU"}}, // Q109593162
    {Coordinate{35.7337, 51.6537}, CountryId{"RU"}}, // Q109593164
    {Coordinate{35.8406, 51.6366}, CountryId{"RU"}}, // Q109593165
    {Coordinate{35.9568, 51.6482}, CountryId{"RU"}}, // Diakonovo Train Station
    {Coordinate{36.0458, 51.6466}, CountryId{"RU"}}, // Q109593167
    {Coordinate{36.0877, 51.6482}, CountryId{"RU"}}, // Q109593168
    {Coordinate{36.1969, 51.6699}, CountryId{"RU"}}, // Q109593169
    {Coordinate{36.219, 51.7043}, CountryId{"RU"}}, // Q109593170
    {Coordinate{36.2255, 51.7295}, CountryId{"RU"}}, // Q109593171
    {Coordinate{97.6356, 56.0409}, CountryId{"RU"}}, // Yurty
    {Coordinate{36.2447, 51.7738}, CountryId{"RU"}}, // Q109607399
    {Coordinate{36.3708, 51.7837}, CountryId{"RU"}}, // Q109607400
    {Coordinate{36.5687, 51.8152}, CountryId{"RU"}}, // Q109607403
    {Coordinate{36.6093, 51.8593}, CountryId{"RU"}}, // Q109607404
    {Coordinate{36.8139, 51.8828}, CountryId{"RU"}}, // Q109607405
    {Coordinate{37.103, 51.8857}, CountryId{"RU"}}, // Q109607406
    {Coordinate{37.4169, 51.8897}, CountryId{"RU"}}, // Q109607409
    {Coordinate{37.4791, 51.8785}, CountryId{"RU"}}, // Q109607410
    {Coordinate{36.434, 51.7926}, CountryId{"RU"}}, // Q109607419
    {Coordinate{36.7493, 51.9404}, CountryId{"RU"}}, // Q109607609
    {Coordinate{36.7716, 52.0077}, CountryId{"RU"}}, // Q109607610
    {Coordinate{36.7458, 52.0981}, CountryId{"RU"}}, // Q109607611
    {Coordinate{36.7935, 52.1831}, CountryId{"RU"}}, // Q109607612
    {Coordinate{36.8678, 52.2}, CountryId{"RU"}}, // Q109607613
    {Coordinate{36.9066, 52.2074}, CountryId{"RU"}}, // Q109607614
    {Coordinate{37.806, 51.8241}, CountryId{"RU"}}, // Q109610719
    {Coordinate{37.924, 51.8022}, CountryId{"RU"}}, // Q109610720
    {Coordinate{38.0229, 51.8086}, CountryId{"RU"}}, // Q109610721
    {Coordinate{37.3276, 52.764}, CountryId{"RU"}}, // Q109614979
    {Coordinate{37.3186, 52.7184}, CountryId{"RU"}}, // Q109614980
    {Coordinate{37.3222, 52.6645}, CountryId{"RU"}}, // Q109614981
    {Coordinate{37.3629, 52.6027}, CountryId{"RU"}}, // Q109614984
    {Coordinate{37.4092, 52.612}, CountryId{"RU"}}, // Q109614985
    {Coordinate{37.4804, 52.5403}, CountryId{"RU"}}, // Q109614987
    {Coordinate{37.5274, 52.4864}, CountryId{"RU"}}, // Q109614989
    {Coordinate{37.5988, 52.4278}, CountryId{"RU"}}, // Livny I railway station
    {Coordinate{37.5463, 52.4085}, CountryId{"RU"}}, // Q109614992
    {Coordinate{37.5436, 52.395}, CountryId{"RU"}}, // Q109614993
    {Coordinate{37.5193, 52.3398}, CountryId{"RU"}}, // Q109614994
    {Coordinate{37.5401, 52.263}, CountryId{"RU"}}, // Q109614996
    {Coordinate{37.5669, 52.1783}, CountryId{"RU"}}, // Q109614997
    {Coordinate{37.5677, 52.1213}, CountryId{"RU"}}, // Q109614998
    {Coordinate{37.5374, 52.0564}, CountryId{"RU"}}, // Q109614999
    {Coordinate{37.5062, 51.958}, CountryId{"RU"}}, // Q109615000
    {Coordinate{37.522, 51.913}, CountryId{"RU"}}, // Q109615001
    {Coordinate{37.5322, 52.293}, CountryId{"RU"}}, // Q109615571
    {Coordinate{36.2843, 51.6988}, CountryId{"RU"}}, // Q109617011
    {Coordinate{36.3497, 51.671}, CountryId{"RU"}}, // Q109617012
    {Coordinate{36.3832, 51.6516}, CountryId{"RU"}}, // Q109617013
    {Coordinate{36.4215, 51.6364}, CountryId{"RU"}}, // Q109617014
    {Coordinate{36.5057, 51.6064}, CountryId{"RU"}}, // Q109617015
    {Coordinate{36.5675, 51.5821}, CountryId{"RU"}}, // Q109617016
    {Coordinate{36.5902, 51.5685}, CountryId{"RU"}}, // Q109617017
    {Coordinate{36.6063, 51.5457}, CountryId{"RU"}}, // Q109617018
    {Coordinate{36.7014, 51.4561}, CountryId{"RU"}}, // Q109617020
    {Coordinate{36.7442, 51.414}, CountryId{"RU"}}, // Q109617021
    {Coordinate{36.7771, 51.3712}, CountryId{"RU"}}, // Q109617022
    {Coordinate{36.7917, 51.3456}, CountryId{"RU"}}, // Q109617024
    {Coordinate{36.6555, 51.5012}, CountryId{"RU"}}, // Q109617027
    {Coordinate{23.2, 54.725}, CountryId{"LT"}}, // Pilviškiai train station
    {Coordinate{8.66165, 51.824}, CountryId{"DE"}}, // Hövelhof station
    {Coordinate{38.5901, 52.6065}, CountryId{"RU"}}, // Q109628332
    {Coordinate{38.6595, 52.578}, CountryId{"RU"}}, // Q109628333
    {Coordinate{38.6822, 52.5437}, CountryId{"RU"}}, // Q109628334
    {Coordinate{38.655, 52.5146}, CountryId{"RU"}}, // Q109628335
    {Coordinate{38.5992, 52.4587}, CountryId{"RU"}}, // Q109628336
    {Coordinate{38.5457, 52.3981}, CountryId{"RU"}}, // Q109628337
    {Coordinate{38.5038, 52.3714}, CountryId{"RU"}}, // Q109628338
    {Coordinate{38.4042, 52.3369}, CountryId{"RU"}}, // Q109628339
    {Coordinate{38.3446, 52.2821}, CountryId{"RU"}}, // Q109628340
    {Coordinate{38.1717, 52.0464}, CountryId{"RU"}}, // Q109628341
    {Coordinate{38.1331, 52.0212}, CountryId{"RU"}}, // Q109628342
    {Coordinate{38.1336, 51.9352}, CountryId{"RU"}}, // Q109628344
    {Coordinate{38.1368, 51.9148}, CountryId{"RU"}}, // Q109628345
    {Coordinate{38.1468, 51.9015}, CountryId{"RU"}}, // Q109628346
    {Coordinate{38.1202, 51.8288}, CountryId{"RU"}}, // Q109628349
    {Coordinate{38.2312, 54.0772}, CountryId{"RU"}}, // Q109631680
    {Coordinate{38.2247, 54.7465}, CountryId{"RU"}}, // Q109638339
    {Coordinate{38.2097, 54.7118}, CountryId{"RU"}}, // Q109638340
    {Coordinate{38.2121, 54.6604}, CountryId{"RU"}}, // Q109638341
    {Coordinate{38.223, 54.6246}, CountryId{"RU"}}, // Q109638342
    {Coordinate{38.2229, 54.5749}, CountryId{"RU"}}, // Q109638343
    {Coordinate{38.2218, 54.5026}, CountryId{"RU"}}, // Q109638344
    {Coordinate{38.2282, 54.4693}, CountryId{"RU"}}, // Q109638345
    {Coordinate{38.2134, 54.4464}, CountryId{"RU"}}, // Q109638346
    {Coordinate{38.2312, 54.4214}, CountryId{"RU"}}, // Q109638347
    {Coordinate{38.2336, 54.3995}, CountryId{"RU"}}, // Q109638348
    {Coordinate{38.2486, 54.3004}, CountryId{"RU"}}, // Q109638349
    {Coordinate{38.2402, 54.2577}, CountryId{"RU"}}, // Q109638350
    {Coordinate{38.2286, 54.1887}, CountryId{"RU"}}, // Q109638351
    {Coordinate{38.179, 54.1318}, CountryId{"RU"}}, // Q109638352
    {Coordinate{38.2314, 54.0852}, CountryId{"RU"}}, // Q109639320
    {Coordinate{38.1685, 54.0784}, CountryId{"RU"}}, // Q109639351
    {Coordinate{38.2161, 54.0412}, CountryId{"RU"}}, // Q109642939
    {Coordinate{38.2705, 54.0108}, CountryId{"RU"}}, // Q109642940
    {Coordinate{38.2959, 53.9912}, CountryId{"RU"}}, // Q109642942
    {Coordinate{38.3161, 53.9701}, CountryId{"RU"}}, // Q109642944
    {Coordinate{38.312, 53.9631}, CountryId{"RU"}}, // Q109642946
    {Coordinate{38.2244, 53.9647}, CountryId{"RU"}}, // Q109646568
    {Coordinate{38.402, 53.9563}, CountryId{"RU"}}, // Q109646569
    {Coordinate{38.5364, 53.9652}, CountryId{"RU"}}, // Q109646571
    {Coordinate{38.6212, 53.9598}, CountryId{"RU"}}, // Q109646572
    {Coordinate{38.7096, 53.9307}, CountryId{"RU"}}, // Q109646573
    {Coordinate{38.7787, 53.9133}, CountryId{"RU"}}, // Q109646575
    {Coordinate{38.8806, 53.892}, CountryId{"RU"}}, // Q109646577
    {Coordinate{39.0371, 53.8418}, CountryId{"RU"}}, // Q109646579
    {Coordinate{38.112, 53.7793}, CountryId{"RU"}}, // Q109646610
    {Coordinate{38.1657, 53.9473}, CountryId{"RU"}}, // Q109647098
    {Coordinate{38.1606, 53.8804}, CountryId{"RU"}}, // Q109647100
    {Coordinate{38.1296, 53.8431}, CountryId{"RU"}}, // Q109647101
    {Coordinate{38.1208, 53.7411}, CountryId{"RU"}}, // Q109647103
    {Coordinate{38.1717, 53.689}, CountryId{"RU"}}, // Q109647105
    {Coordinate{38.1556, 53.6485}, CountryId{"RU"}}, // Q109647106
    {Coordinate{38.1224, 53.6112}, CountryId{"RU"}}, // Q109647108
    {Coordinate{38.0572, 53.5979}, CountryId{"RU"}}, // Q109647109
    {Coordinate{37.9939, 53.5584}, CountryId{"RU"}}, // Q109647111
    {Coordinate{37.9656, 53.5277}, CountryId{"RU"}}, // Q109647112
    {Coordinate{37.9993, 53.5046}, CountryId{"RU"}}, // Q109647114
    {Coordinate{38.0334, 53.4801}, CountryId{"RU"}}, // Q109647116
    {Coordinate{38.0441, 53.4119}, CountryId{"RU"}}, // Q109647117
    {Coordinate{38.0759, 53.3651}, CountryId{"RU"}}, // Q109647119
    {Coordinate{38.1045, 53.3521}, CountryId{"RU"}}, // 313 km railway station
    {Coordinate{38.0987, 53.3195}, CountryId{"RU"}}, // Q109647122
    {Coordinate{38.0949, 53.2797}, CountryId{"RU"}}, // Q109647123
    {Coordinate{38.075, 53.2552}, CountryId{"RU"}}, // Q109647125
    {Coordinate{38.0498, 53.235}, CountryId{"RU"}}, // Q109647126
    {Coordinate{38.0656, 53.2105}, CountryId{"RU"}}, // Q109647128
    {Coordinate{38.0954, 53.1972}, CountryId{"RU"}}, // Q109647129
    {Coordinate{3.1158, 49.3966}, CountryId{"FR"}}, // Gare de Vic-sur-Aisne - Ressons
    {Coordinate{8.71378, 51.7704}, CountryId{"DE"}}, // Paderborn-Sennelager station
    {Coordinate{}, CountryId{"FR"}}, // Gare d'Haulchin - Thiant
    {Coordinate{39.313, 53.8497}, CountryId{"RU"}}, // Q109663927
    {Coordinate{39.3912, 53.8662}, CountryId{"RU"}}, // Q109663930
    {Coordinate{39.4966, 53.8496}, CountryId{"RU"}}, // Q109663932
    {Coordinate{39.576, 53.8251}, CountryId{"RU"}}, // Skopin railway station
    {Coordinate{39.6092, 53.7921}, CountryId{"RU"}}, // Q109663938
    {Coordinate{39.7094, 53.7822}, CountryId{"RU"}}, // Q109663940
    {Coordinate{39.8088, 53.7691}, CountryId{"RU"}}, // Q109663943
    {Coordinate{39.9407, 53.7437}, CountryId{"RU"}}, // Q109663945
    {Coordinate{40.0058, 54.4831}, CountryId{"RU"}}, // Q109673554
    {Coordinate{40.0327, 54.4505}, CountryId{"RU"}}, // Q109673556
    {Coordinate{40.0604, 54.4202}, CountryId{"RU"}}, // Q109673557
    {Coordinate{40.1175, 54.3671}, CountryId{"RU"}}, // Q109673558
    {Coordinate{40.1872, 54.3402}, CountryId{"RU"}}, // Q109673559
    {Coordinate{40.2208, 54.3106}, CountryId{"RU"}}, // Q109673560
    {Coordinate{40.6728, 54.2906}, CountryId{"RU"}}, // Q109673567
    {Coordinate{40.795, 54.2937}, CountryId{"RU"}}, // Krutitsy railway station
    {Coordinate{40.9628, 54.3255}, CountryId{"RU"}}, // Q109673571
    {Coordinate{40.991, 54.3229}, CountryId{"RU"}}, // Q109673572
    {Coordinate{41.0506, 54.3328}, CountryId{"RU"}}, // Q109673573
    {Coordinate{41.2961, 54.3015}, CountryId{"RU"}}, // Q109673575
    {Coordinate{41.4323, 54.2823}, CountryId{"RU"}}, // Q109673576
    {Coordinate{41.688, 54.2742}, CountryId{"RU"}}, // Q109673578
    {Coordinate{41.7341, 54.2822}, CountryId{"RU"}}, // Q109673579
    {Coordinate{41.7965, 54.2945}, CountryId{"RU"}}, // Q109673580
    {Coordinate{41.8523, 54.3118}, CountryId{"RU"}}, // 376 km
    {Coordinate{41.9619, 54.3505}, CountryId{"RU"}}, // 383 km
    {Coordinate{41.9835, 54.3377}, CountryId{"RU"}}, // 385 km
    {Coordinate{42.046, 54.323}, CountryId{"RU"}}, // 390 km
    {Coordinate{42.0971, 54.3029}, CountryId{"RU"}}, // 395 km
    {Coordinate{42.1619, 54.2861}, CountryId{"RU"}}, // Tairovka
    {Coordinate{42.2265, 54.273}, CountryId{"RU"}}, // 404 km
    {Coordinate{40.0371, 54.512}, CountryId{"RU"}}, // Q109676312
    {Coordinate{40.0764, 54.5178}, CountryId{"RU"}}, // Q109676314
    {Coordinate{40.1317, 54.5068}, CountryId{"RU"}}, // Q109676315
    {Coordinate{40.195, 54.3673}, CountryId{"RU"}}, // Q109676383
    {Coordinate{40.2241, 54.3934}, CountryId{"RU"}}, // Q109676384
    {Coordinate{41.2083, 54.3567}, CountryId{"RU"}}, // Q109676551
    {Coordinate{41.248, 54.4183}, CountryId{"RU"}}, // Q109676552
    {Coordinate{41.2744, 54.4374}, CountryId{"RU"}}, // Q109676553
    {Coordinate{41.2945, 54.484}, CountryId{"RU"}}, // Q109676555
    {Coordinate{41.3033, 54.522}, CountryId{"RU"}}, // Q109676556
    {Coordinate{41.2882, 54.6017}, CountryId{"RU"}}, // Q109676557
    {Coordinate{41.2986, 54.6469}, CountryId{"RU"}}, // Q109676558
    {Coordinate{41.3043, 54.6783}, CountryId{"RU"}}, // Q109676559
    {Coordinate{41.3137, 54.7305}, CountryId{"RU"}}, // Q109676560
    {Coordinate{41.3194, 54.8121}, CountryId{"RU"}}, // Q109676561
    {Coordinate{41.3217, 54.8548}, CountryId{"RU"}}, // Q109676562
    {Coordinate{15.0955, 60.6742}, CountryId{"SE"}}, // Insjön station
    {Coordinate{16.1721, 61.7158}, CountryId{"SE"}}, // Järvsö station
    {Coordinate{16.3628, 58.6738}, CountryId{"SE"}}, // Kolmården station
    {Coordinate{16.1029, 59.4278}, CountryId{"SE"}}, // Kungsör station
    {Coordinate{16.0044, 59.507}, CountryId{"SE"}}, // Köping station
    {Coordinate{15.0029, 60.7342}, CountryId{"SE"}}, // Leksand station
    {Coordinate{17.4336, 59.1822}, CountryId{"SE"}}, // Nykvarn station
    {Coordinate{16.721, 60.8915}, CountryId{"SE"}}, // Ockelbo station
    {Coordinate{16.6055, 59.9253}, CountryId{"SE"}}, // Sala station
    {Coordinate{15.66, 58.4005}, CountryId{"SE"}}, // Tannefors station
    {Coordinate{17.5142, 60.3452}, CountryId{"SE"}}, // Tierp station
    {Coordinate{16.6307, 57.7528}, CountryId{"SE"}}, // Tjustskolan station
    {Coordinate{16.0021, 58.2037}, CountryId{"SE"}}, // Åtvidaberg station
    {Coordinate{14.0292, 56.0608}, CountryId{"SE"}}, // Önnestad station
    {Coordinate{39.7095, 54.56}, CountryId{"RU"}}, // 208 km
    {Coordinate{39.7374, 54.5343}, CountryId{"RU"}}, // Q109688671
    {Coordinate{39.7459, 54.4941}, CountryId{"RU"}}, // Q109688673
    {Coordinate{39.7921, 54.4727}, CountryId{"RU"}}, // Q109688674
    {Coordinate{39.8599, 54.4417}, CountryId{"RU"}}, // Q109688676
    {Coordinate{39.8674, 54.3748}, CountryId{"RU"}}, // Q109688678
    {Coordinate{39.9297, 54.2808}, CountryId{"RU"}}, // Q109688683
    {Coordinate{39.9918, 54.1745}, CountryId{"RU"}}, // Q109688686
    {Coordinate{39.9852, 54.0869}, CountryId{"RU"}}, // Q109688687
    {Coordinate{39.9967, 53.958}, CountryId{"RU"}}, // Q109688691
    {Coordinate{40.0181, 53.9211}, CountryId{"RU"}}, // Korablino railway station
    {Coordinate{40.0256, 53.8718}, CountryId{"RU"}}, // Q109688696
    {Coordinate{40.0657, 53.8292}, CountryId{"RU"}}, // Q109688697
    {Coordinate{40.0993, 53.7971}, CountryId{"RU"}}, // Q109688699
    {Coordinate{40.1203, 53.7487}, CountryId{"RU"}}, // Q109688700
    {Coordinate{39.9977, 54.0153}, CountryId{"RU"}}, // Q109688771
    {Coordinate{40.1361, 53.7054}, CountryId{"RU"}}, // Q109689634
    {Coordinate{42.3333, 54.2007}, CountryId{"RU"}}, // Q109717293
    {Coordinate{42.373, 54.1586}, CountryId{"RU"}}, // Q109717294
    {Coordinate{42.4166, 54.0706}, CountryId{"RU"}}, // Q109717295
    {Coordinate{42.4303, 54.0073}, CountryId{"RU"}}, // Q109717296
    {Coordinate{42.377, 53.8523}, CountryId{"RU"}}, // Q109717297
    {Coordinate{42.3188, 53.7352}, CountryId{"RU"}}, // Q109717298
    {Coordinate{42.4145, 53.6523}, CountryId{"RU"}}, // Q109717299
    {Coordinate{42.4799, 53.6005}, CountryId{"RU"}}, // Q109717300
    {Coordinate{42.5362, 53.5604}, CountryId{"RU"}}, // Q109717301
    {Coordinate{42.534, 53.4402}, CountryId{"RU"}}, // Q109717302
    {Coordinate{42.4764, 53.4085}, CountryId{"RU"}}, // Q109717303
    {Coordinate{42.4424, 53.3609}, CountryId{"RU"}}, // Q109717304
    {Coordinate{8.53621, 47.5239}, CountryId{"CH"}}, // Bülach railway station
    {Coordinate{33.6206, 55.1411}, CountryId{"RU"}}, // Q109730845
    {Coordinate{32.4096, 54.8353}, CountryId{"RU"}}, // Q109730861
    {Coordinate{33.7014, 55.1453}, CountryId{"RU"}}, // Q109734918
    {Coordinate{33.5327, 55.1461}, CountryId{"RU"}}, // Q109734919
    {Coordinate{32.9101, 55.0786}, CountryId{"RU"}}, // Q109734921
    {Coordinate{32.7873, 55.0683}, CountryId{"RU"}}, // Q109734923
    {Coordinate{32.5741, 55.0405}, CountryId{"RU"}}, // Q109734925
    {Coordinate{32.4538, 54.9586}, CountryId{"RU"}}, // Q109734926
    {Coordinate{32.447, 54.8891}, CountryId{"RU"}}, // Q109734927
    {Coordinate{32.351, 54.8124}, CountryId{"RU"}}, // Q109734928
    {Coordinate{34.2921, 55.8434}, CountryId{"RU"}}, // Sychyovka
    {Coordinate{34.3219, 56.031}, CountryId{"RU"}}, // Osuga
    {Coordinate{34.3203, 55.2264}, CountryId{"RU"}}, // Vyazma-Novotorzhskaya
    {Coordinate{34.326, 55.2631}, CountryId{"RU"}}, // Q109735434
    {Coordinate{34.3257, 55.2946}, CountryId{"RU"}}, // Q109735435
    {Coordinate{34.3448, 55.3225}, CountryId{"RU"}}, // Q109735436
    {Coordinate{34.3591, 55.3678}, CountryId{"RU"}}, // Q109735437
    {Coordinate{34.3288, 55.3936}, CountryId{"RU"}}, // Category:Kasnya train station
    {Coordinate{34.3262, 55.4288}, CountryId{"RU"}}, // Q109735439
    {Coordinate{34.3236, 55.5034}, CountryId{"RU"}}, // Q109735440
    {Coordinate{34.3118, 55.546}, CountryId{"RU"}}, // Q109735441
    {Coordinate{34.3066, 55.5845}, CountryId{"RU"}}, // Q109735442
    {Coordinate{34.296, 55.6319}, CountryId{"RU"}}, // Novodugino railway station
    {Coordinate{34.2966, 55.7118}, CountryId{"RU"}}, // Q109735445
    {Coordinate{34.2909, 55.8109}, CountryId{"RU"}}, // Q109735446
    {Coordinate{34.3204, 55.938}, CountryId{"RU"}}, // Pomelnitsa
    {Coordinate{34.3196, 55.9964}, CountryId{"RU"}}, // 168 km
    {Coordinate{31.6609, 54.7616}, CountryId{"RU"}}, // Q109736693
    {Coordinate{31.539, 54.7517}, CountryId{"RU"}}, // Q109736698
    {Coordinate{31.8681, 54.7963}, CountryId{"RU"}}, // Q109743493
    {Coordinate{31.3304, 54.7195}, CountryId{"RU"}}, // Q109743495
    {Coordinate{31.276, 54.7128}, CountryId{"RU"}}, // Q109743497
    {Coordinate{31.1885, 54.6925}, CountryId{"RU"}}, // Q109743498
    {Coordinate{31.9322, 54.7852}, CountryId{"RU"}}, // Dachnaya I
    {Coordinate{31.912, 54.7838}, CountryId{"RU"}}, // Dachnaya II
    {Coordinate{31.7649, 54.7913}, CountryId{"RU"}}, // 406 km
    {Coordinate{31.6376, 54.8329}, CountryId{"RU"}}, // 416 km
    {Coordinate{31.4463, 54.8538}, CountryId{"RU"}}, // Poselkovaya
    {Coordinate{31.3878, 54.8682}, CountryId{"RU"}}, // Golynki
    {Coordinate{31.3034, 54.8837}, CountryId{"RU"}}, // 439 km
    {Coordinate{31.2569, 54.8847}, CountryId{"RU"}}, // Ploskaya
    {Coordinate{47.4568, 55.5997}, CountryId{"RU"}}, // Q109757446
    {Coordinate{47.3358, 55.6228}, CountryId{"RU"}}, // Q109757447
    {Coordinate{47.3064, 55.6614}, CountryId{"RU"}}, // Q109757449
    {Coordinate{47.2926, 55.7286}, CountryId{"RU"}}, // Q109757450
    {Coordinate{47.387, 55.8271}, CountryId{"RU"}}, // Q109757451
    {Coordinate{47.3416, 55.8601}, CountryId{"RU"}}, // Q109757453
    {Coordinate{47.3139, 55.8786}, CountryId{"RU"}}, // Q109757454
    {Coordinate{47.2492, 55.8938}, CountryId{"RU"}}, // Q109757456
    {Coordinate{47.2212, 55.9063}, CountryId{"RU"}}, // Q109757458
    {Coordinate{47.2122, 55.9372}, CountryId{"RU"}}, // Q109757460
    {Coordinate{47.2028, 55.968}, CountryId{"RU"}}, // Q109757461
    {Coordinate{47.1534, 55.9849}, CountryId{"RU"}}, // Q109757463
    {Coordinate{47.1136, 56.0072}, CountryId{"RU"}}, // Q109757464
    {Coordinate{47.0952, 56.0503}, CountryId{"RU"}}, // Q109757466
    {Coordinate{133.046, 42.9117}, CountryId{"RU"}}, // Yekaterinovka
    {Coordinate{8.72094, 51.7493}, CountryId{"DE"}}, // Paderborn-Schloß Neuhaus station
    {Coordinate{48.4482, 55.6956}, CountryId{"RU"}}, // Bişbatman
    {Coordinate{48.3803, 55.6774}, CountryId{"RU"}}, // Q109771936
    {Coordinate{48.3471, 55.5753}, CountryId{"RU"}}, // Ötäşkä
    {Coordinate{48.3714, 55.4948}, CountryId{"RU"}}, // Şüşirmä
    {Coordinate{48.4711, 55.4037}, CountryId{"RU"}}, // Q109771939
    {Coordinate{48.2632, 55.1069}, CountryId{"RU"}}, // Q109771943
    {Coordinate{47.6492, 56.7069}, CountryId{"RU"}}, // Q109772862
    {Coordinate{47.6497, 56.7518}, CountryId{"RU"}}, // Q109772863
    {Coordinate{47.6294, 56.8035}, CountryId{"RU"}}, // Q109772864
    {Coordinate{47.6613, 56.9188}, CountryId{"RU"}}, // Q109772865
    {Coordinate{47.6938, 57.03}, CountryId{"RU"}}, // Q109772866
    {Coordinate{47.7082, 57.0746}, CountryId{"RU"}}, // Q109772867
    {Coordinate{75.6982, 23.0757}, CountryId{"IN"}}, // Osra railway station
    {Coordinate{53.1135, 56.555}, CountryId{"RU"}}, // Q109796196
    {Coordinate{53.21, 56.5125}, CountryId{"RU"}}, // Q109796197
    {Coordinate{53.3064, 56.5165}, CountryId{"RU"}}, // Q109796198
    {Coordinate{53.383, 56.5001}, CountryId{"RU"}}, // Q109796199
    {Coordinate{53.4369, 56.4923}, CountryId{"RU"}}, // Q109796200
    {Coordinate{53.527, 56.488}, CountryId{"RU"}}, // Q109796201
    {Coordinate{53.5669, 56.4762}, CountryId{"RU"}}, // Q109796202
    {Coordinate{53.621, 56.468}, CountryId{"RU"}}, // Q109796203
    {Coordinate{53.6678, 56.459}, CountryId{"RU"}}, // Q109796204
    {Coordinate{53.9316, 56.4108}, CountryId{"RU"}}, // Q109796205
    {Coordinate{53.957, 56.5769}, CountryId{"RU"}}, // Q109796210
    {Coordinate{54.1392, 56.7725}, CountryId{"RU"}}, // Q109796211
    {Coordinate{54.3818, 56.2391}, CountryId{"RU"}}, // Q109796410
    {Coordinate{7.35007, 47.362}, CountryId{"CH"}}, // Delémont railway station
    {Coordinate{54.5522, 56.2405}, CountryId{"RU"}}, // Q109818114
    {Coordinate{54.7223, 56.2538}, CountryId{"RU"}}, // Q109818116
    {Coordinate{54.8171, 56.2603}, CountryId{"RU"}}, // Q109818117
    {Coordinate{55.0161, 56.2942}, CountryId{"RU"}}, // Q109818119
    {Coordinate{55.0747, 56.3074}, CountryId{"RU"}}, // Q109818120
    {Coordinate{55.2563, 56.3471}, CountryId{"RU"}}, // Q109818123
    {Coordinate{55.3202, 56.3619}, CountryId{"RU"}}, // Q109818124
    {Coordinate{55.3801, 56.3747}, CountryId{"RU"}}, // Q109818126
    {Coordinate{55.4334, 56.387}, CountryId{"RU"}}, // Q109818127
    {Coordinate{55.5967, 56.4283}, CountryId{"RU"}}, // Q109818129
    {Coordinate{55.7097, 56.4442}, CountryId{"RU"}}, // Q109818130
    {Coordinate{55.7434, 56.4538}, CountryId{"RU"}}, // Q109818132
    {Coordinate{55.7694, 56.4633}, CountryId{"RU"}}, // Q109818133
    {Coordinate{55.879, 56.4959}, CountryId{"RU"}}, // Q109818134
    {Coordinate{55.9794, 56.5016}, CountryId{"RU"}}, // Q109818137
    {Coordinate{56.079, 56.498}, CountryId{"RU"}}, // Chernushka railway station
    {Coordinate{56.2472, 56.4677}, CountryId{"RU"}}, // Q109818142
    {Coordinate{56.3276, 56.4531}, CountryId{"RU"}}, // Q109818143
    {Coordinate{56.4138, 56.4586}, CountryId{"RU"}}, // Q109818144
    {Coordinate{56.5046, 56.4561}, CountryId{"RU"}}, // Q109818146
    {Coordinate{56.6378, 56.4716}, CountryId{"RU"}}, // Q109818147
    {Coordinate{56.7638, 56.4782}, CountryId{"RU"}}, // Q109818149
    {Coordinate{56.7939, 56.4735}, CountryId{"RU"}}, // Q109818150
    {Coordinate{56.8878, 56.4712}, CountryId{"RU"}}, // Q109818152
    {Coordinate{56.9453, 56.4586}, CountryId{"RU"}}, // Q109818153
    {Coordinate{57.013, 56.4781}, CountryId{"RU"}}, // Q109818154
    {Coordinate{57.0602, 56.4702}, CountryId{"RU"}}, // Q109818156
    {Coordinate{57.1109, 56.4784}, CountryId{"RU"}}, // Q109818157
    {Coordinate{57.2051, 56.5088}, CountryId{"RU"}}, // Q109818158
    {Coordinate{57.3071, 56.5247}, CountryId{"RU"}}, // Q109818160
    {Coordinate{57.4341, 56.5425}, CountryId{"RU"}}, // Q109818161
    {Coordinate{57.4882, 56.5376}, CountryId{"RU"}}, // Q109818163
    {Coordinate{57.4971, 56.5202}, CountryId{"RU"}}, // Q109818164
    {Coordinate{57.5424, 56.4999}, CountryId{"RU"}}, // Pudlingovyy
    {Coordinate{57.6204, 56.5023}, CountryId{"RU"}}, // Q109818167
    {Coordinate{57.6657, 56.5063}, CountryId{"RU"}}, // Q109818168
    {Coordinate{57.6925, 56.5285}, CountryId{"RU"}}, // Q109818170
    {Coordinate{57.7233, 56.5536}, CountryId{"RU"}}, // Q109818171
    {Coordinate{75.2542, 22.9134}, CountryId{"IN"}}, // Runija railway station
    {Coordinate{75.155, 23.2497}, CountryId{"IN"}}, // Nauganwan railway station
    {Coordinate{75.4739, 23.0437}, CountryId{"IN"}}, // Pirjhalar railway station
    {Coordinate{75.311, 23.1252}, CountryId{"IN"}}, // Sunderabad railway station
    {Coordinate{57.7521, 56.6231}, CountryId{"RU"}}, // Q109829717
    {Coordinate{57.7852, 56.6438}, CountryId{"RU"}}, // Q109829718
    {Coordinate{57.8516, 56.6638}, CountryId{"RU"}}, // Q109829719
    {Coordinate{57.8747, 56.6708}, CountryId{"RU"}}, // Q109829720
    {Coordinate{57.9742, 56.6906}, CountryId{"RU"}}, // Q109829721
    {Coordinate{58.038, 56.7035}, CountryId{"RU"}}, // Q109829722
    {Coordinate{58.1465, 56.7654}, CountryId{"RU"}}, // Q109829723
    {Coordinate{58.1894, 56.7878}, CountryId{"RU"}}, // Q109829724
    {Coordinate{58.2367, 56.7938}, CountryId{"RU"}}, // Q109829725
    {Coordinate{58.2791, 56.8223}, CountryId{"RU"}}, // Q109829726
    {Coordinate{58.3025, 56.8464}, CountryId{"RU"}}, // Q109829728
    {Coordinate{58.3393, 56.8481}, CountryId{"RU"}}, // Q109829729
    {Coordinate{58.406, 56.8481}, CountryId{"RU"}}, // Q109829730
    {Coordinate{58.4947, 56.8296}, CountryId{"RU"}}, // Q109829731
    {Coordinate{58.6935, 56.8331}, CountryId{"RU"}}, // Q109829733
    {Coordinate{58.7465, 56.8432}, CountryId{"RU"}}, // Q109829734
    {Coordinate{58.7707, 56.8456}, CountryId{"RU"}}, // Q109829735
    {Coordinate{58.8117, 56.8589}, CountryId{"RU"}}, // Q109829736
    {Coordinate{59.0665, 56.8448}, CountryId{"RU"}}, // Q109829739
    {Coordinate{59.1369, 56.8532}, CountryId{"RU"}}, // Q109829740
    {Coordinate{59.152, 56.8426}, CountryId{"RU"}}, // Q109829741
    {Coordinate{59.2431, 56.8834}, CountryId{"RU"}}, // Q109829742
    {Coordinate{59.283, 56.865}, CountryId{"RU"}}, // Q109829743
    {Coordinate{59.2996, 56.8479}, CountryId{"RU"}}, // Q109829744
    {Coordinate{59.3883, 56.8139}, CountryId{"RU"}}, // Q109829745
    {Coordinate{52.5639, 56.1145}, CountryId{"RU"}}, // Alnashi railway station
    {Coordinate{52.9725, 56.484}, CountryId{"RU"}}, // İj-Bubıy
    {Coordinate{52.9732, 56.4585}, CountryId{"RU"}}, // Q109836595
    {Coordinate{52.9186, 56.3814}, CountryId{"RU"}}, // Q109836598
    {Coordinate{52.8778, 56.3329}, CountryId{"RU"}}, // Tirsä
    {Coordinate{52.6905, 56.236}, CountryId{"RU"}}, // Moqşır
    {Coordinate{133.071, 42.9572}, CountryId{"RU"}}, // Kuznetsovo
    {Coordinate{53.2735, 57.8728}, CountryId{"RU"}}, // Pibanshur
    {Coordinate{53.0375, 56.55}, CountryId{"RU"}}, // Q109849645
    {Coordinate{53.0651, 56.5982}, CountryId{"RU"}}, // Q109849647
    {Coordinate{53.1272, 56.6923}, CountryId{"RU"}}, // Q109849648
    {Coordinate{52.9722, 57.0037}, CountryId{"RU"}}, // Q109849649
    {Coordinate{53.0194, 57.2957}, CountryId{"RU"}}, // Q109849652
    {Coordinate{-5.91041, 37.2781}, CountryId{"ES"}}, // Q10985919
    {Coordinate{24.9378, 58.7569}, CountryId{"EE"}}, // Eidapere railway station
    {Coordinate{49.8132, 58.4704}, CountryId{"RU"}}, // Q109877922
    {Coordinate{49.9111, 58.4714}, CountryId{"RU"}}, // Q109877923
    {Coordinate{50.353, 58.4165}, CountryId{"RU"}}, // Q109877924
    {Coordinate{50.4766, 58.4454}, CountryId{"RU"}}, // Q109877925
    {Coordinate{50.5187, 58.4511}, CountryId{"RU"}}, // Q109877926
    {Coordinate{50.5837, 58.4485}, CountryId{"RU"}}, // Q109877927
    {Coordinate{50.6369, 58.4629}, CountryId{"RU"}}, // Q109877928
    {Coordinate{50.7077, 58.4801}, CountryId{"RU"}}, // Q109877929
    {Coordinate{50.8323, 58.4569}, CountryId{"RU"}}, // Q109877931
    {Coordinate{50.9912, 58.4343}, CountryId{"RU"}}, // Q109877933
    {Coordinate{51.0265, 58.4209}, CountryId{"RU"}}, // Q109877934
    {Coordinate{51.1342, 58.4039}, CountryId{"RU"}}, // Zuyevka railway station
    {Coordinate{51.2835, 58.4165}, CountryId{"RU"}}, // Q109877936
    {Coordinate{51.3952, 58.404}, CountryId{"RU"}}, // Q109877937
    {Coordinate{51.5116, 58.3978}, CountryId{"RU"}}, // Q109877938
    {Coordinate{51.6466, 58.3361}, CountryId{"RU"}}, // Q109877939
    {Coordinate{51.7041, 58.3306}, CountryId{"RU"}}, // Q109877940
    {Coordinate{51.7347, 58.3195}, CountryId{"RU"}}, // Q109877941
    {Coordinate{51.8386, 58.2963}, CountryId{"RU"}}, // Q109886074
    {Coordinate{51.9207, 58.2888}, CountryId{"RU"}}, // Q109886077
    {Coordinate{51.9592, 58.2872}, CountryId{"RU"}}, // Q109886078
    {Coordinate{52.1284, 58.2375}, CountryId{"RU"}}, // Q109886081
    {Coordinate{52.1552, 58.22}, CountryId{"RU"}}, // Q109886083
    {Coordinate{52.2518, 58.1975}, CountryId{"RU"}}, // Q109886084
    {Coordinate{52.4228, 58.1593}, CountryId{"RU"}}, // Q109886087
    {Coordinate{52.4617, 58.1524}, CountryId{"RU"}}, // Q109886088
    {Coordinate{52.5082, 58.1564}, CountryId{"RU"}}, // Q109886091
    {Coordinate{52.8376, 58.1027}, CountryId{"RU"}}, // Q109886093
    {Coordinate{52.8924, 58.0844}, CountryId{"RU"}}, // Q109886096
    {Coordinate{52.9296, 58.0559}, CountryId{"RU"}}, // Q109886097
    {Coordinate{52.964, 58.0202}, CountryId{"RU"}}, // Q109886100
    {Coordinate{52.997, 57.9989}, CountryId{"RU"}}, // Q109886101
    {Coordinate{52.7689, 58.1133}, CountryId{"RU"}}, // Q109886214
    {Coordinate{52.1995, 58.3606}, CountryId{"RU"}}, // Q109891884
    {Coordinate{52.127, 58.3988}, CountryId{"RU"}}, // Q109891887
    {Coordinate{52.179, 58.4443}, CountryId{"RU"}}, // Q109891889
    {Coordinate{52.2092, 58.5604}, CountryId{"RU"}}, // Q109891893
    {Coordinate{52.2951, 58.7741}, CountryId{"RU"}}, // Q109891896
    {Coordinate{52.3444, 58.8709}, CountryId{"RU"}}, // Q109891898
    {Coordinate{52.3679, 58.9288}, CountryId{"RU"}}, // Q109891900
    {Coordinate{52.404, 58.9974}, CountryId{"RU"}}, // Q109891903
    {Coordinate{52.1708, 58.3047}, CountryId{"RU"}}, // Q109891987
    {Coordinate{49.5189, 58.6459}, CountryId{"RU"}}, // Q109894303
    {Coordinate{49.6322, 58.6217}, CountryId{"RU"}}, // Q109899974
    {Coordinate{47.061, 60.8176}, CountryId{"RU"}}, // Q109900274
    {Coordinate{25.5467, 58.5453}, CountryId{"EE"}}, // Olustvere railway station
    {Coordinate{49.5621, 58.7313}, CountryId{"RU"}}, // Q109907497
    {Coordinate{49.5109, 58.8389}, CountryId{"RU"}}, // Q109907499
    {Coordinate{49.5033, 58.8557}, CountryId{"RU"}}, // Q109907500
    {Coordinate{49.4897, 58.8718}, CountryId{"RU"}}, // Q109907501
    {Coordinate{49.4262, 58.9216}, CountryId{"RU"}}, // Q109907502
    {Coordinate{49.3918, 58.9483}, CountryId{"RU"}}, // Q109907503
    {Coordinate{49.3504, 58.976}, CountryId{"RU"}}, // Q109907504
    {Coordinate{49.3107, 58.997}, CountryId{"RU"}}, // Q109907505
    {Coordinate{49.188, 59.1063}, CountryId{"RU"}}, // Q109907506
    {Coordinate{49.1108, 59.3077}, CountryId{"RU"}}, // Q109907507
    {Coordinate{49.0467, 59.3633}, CountryId{"RU"}}, // Q109907508
    {Coordinate{48.9049, 59.4445}, CountryId{"RU"}}, // Q109907509
    {Coordinate{48.6752, 59.5818}, CountryId{"RU"}}, // Q109907510
    {Coordinate{48.6198, 59.6282}, CountryId{"RU"}}, // Q109907511
    {Coordinate{48.5051, 59.6832}, CountryId{"RU"}}, // Q109907512
    {Coordinate{48.417, 59.7273}, CountryId{"RU"}}, // Q109907513
    {Coordinate{48.3754, 59.7605}, CountryId{"RU"}}, // Q109907515
    {Coordinate{48.172, 59.9481}, CountryId{"RU"}}, // Q109910080
    {Coordinate{48.0429, 60.0523}, CountryId{"RU"}}, // Q109910081
    {Coordinate{47.8945, 60.1319}, CountryId{"RU"}}, // Q109910082
    {Coordinate{47.8866, 60.1929}, CountryId{"RU"}}, // Q109910083
    {Coordinate{47.7858, 60.2515}, CountryId{"RU"}}, // Q109910084
    {Coordinate{47.6997, 60.331}, CountryId{"RU"}}, // Q109910085
    {Coordinate{47.616, 60.3805}, CountryId{"RU"}}, // Q109910086
    {Coordinate{47.5333, 60.4047}, CountryId{"RU"}}, // Q109910087
    {Coordinate{47.4876, 60.4691}, CountryId{"RU"}}, // Q109910088
    {Coordinate{47.3341, 60.5568}, CountryId{"RU"}}, // Q109910089
    {Coordinate{47.2257, 60.7037}, CountryId{"RU"}}, // Q109910090
    {Coordinate{47.1786, 60.7477}, CountryId{"RU"}}, // Q109910091
    {Coordinate{47.0781, 60.3567}, CountryId{"RU"}}, // Q109910093
    {Coordinate{47.2563, 60.895}, CountryId{"RU"}}, // Q109910094
    {Coordinate{18.3445, 48.1028}, CountryId{"SK"}}, // Q109911980
    {Coordinate{53.3276, 57.8631}, CountryId{"RU"}}, // Q109912287
    {Coordinate{18.7709, 48.5397}, CountryId{"SK"}}, // Railway station Hliník nad Hronom
    {Coordinate{133.093, 42.9959}, CountryId{"RU"}}, // 151 km
    {Coordinate{59.8557, 58.3576}, CountryId{"RU"}}, // Q109919887
    {Coordinate{40.2073, 53.7393}, CountryId{"RU"}}, // Q109923426
    {Coordinate{40.2557, 53.7484}, CountryId{"RU"}}, // Q109923427
    {Coordinate{40.3524, 53.7545}, CountryId{"RU"}}, // Q109923428
    {Coordinate{40.4271, 53.7448}, CountryId{"RU"}}, // Q109923429
    {Coordinate{40.5834, 53.7105}, CountryId{"RU"}}, // Q109923430
    {Coordinate{40.7281, 53.6888}, CountryId{"RU"}}, // Q109923431
    {Coordinate{40.8671, 53.6998}, CountryId{"RU"}}, // Q109923433
    {Coordinate{40.9891, 53.7086}, CountryId{"RU"}}, // Q109923434
    {Coordinate{41.1207, 53.6418}, CountryId{"RU"}}, // Q109923436
    {Coordinate{41.2236, 53.6039}, CountryId{"RU"}}, // Q109923437
    {Coordinate{41.2974, 53.5563}, CountryId{"RU"}}, // Q109923438
    {Coordinate{41.4293, 53.5057}, CountryId{"RU"}}, // Q109923439
    {Coordinate{41.6608, 53.4686}, CountryId{"RU"}}, // Q109923441
    {Coordinate{41.723, 53.4514}, CountryId{"RU"}}, // Q109923442
    {Coordinate{41.7808, 53.4402}, CountryId{"RU"}}, // Q109923443
    {Coordinate{41.8046, 53.4581}, CountryId{"RU"}}, // Q109923444
    {Coordinate{41.8251, 53.4623}, CountryId{"RU"}}, // Q109923445
    {Coordinate{41.8479, 53.4591}, CountryId{"RU"}}, // Q109923446
    {Coordinate{41.9462, 53.4257}, CountryId{"RU"}}, // Q109923447
    {Coordinate{42.0495, 53.4099}, CountryId{"RU"}}, // Q109923448
    {Coordinate{40.8164, 53.6945}, CountryId{"RU"}}, // Q109923456
    {Coordinate{43.5538, 53.2961}, CountryId{"RU"}}, // Q109923764
    {Coordinate{8.76145, 51.7162}, CountryId{"DE"}}, // Paderborn Kasseler Tor station
    {Coordinate{133.114, 43.0188}, CountryId{"RU"}}, // Novaya Sila
    {Coordinate{42.4823, 53.2398}, CountryId{"RU"}}, // Q109924127
    {Coordinate{42.6623, 53.2316}, CountryId{"RU"}}, // Q109924128
    {Coordinate{42.7988, 53.224}, CountryId{"RU"}}, // Q109924129
    {Coordinate{42.908, 53.2026}, CountryId{"RU"}}, // Q109924130
    {Coordinate{43.1667, 53.2451}, CountryId{"RU"}}, // Q109924131
    {Coordinate{43.2604, 53.2917}, CountryId{"RU"}}, // Q109924132
    {Coordinate{43.394, 53.3303}, CountryId{"RU"}}, // Q109924133
    {Coordinate{43.669, 53.274}, CountryId{"RU"}}, // Q109924134
    {Coordinate{43.7554, 53.2727}, CountryId{"RU"}}, // Q109924135
    {Coordinate{43.849, 53.2365}, CountryId{"RU"}}, // Q109924136
    {Coordinate{43.9517, 53.2258}, CountryId{"RU"}}, // Q109924137
    {Coordinate{44.1595, 53.1308}, CountryId{"RU"}}, // Q109924138
    {Coordinate{44.2775, 53.1534}, CountryId{"RU"}}, // Q109924139
    {Coordinate{44.3957, 53.2005}, CountryId{"RU"}}, // Q109924140
    {Coordinate{88.8685, 23.0368}, CountryId{"IN"}}, // Petrapole railway station
    {Coordinate{45.1532, 53.21}, CountryId{"RU"}}, // Q109930250
    {Coordinate{45.197, 53.2044}, CountryId{"RU"}}, // Q109930251
    {Coordinate{45.2085, 53.1747}, CountryId{"RU"}}, // Q109930252
    {Coordinate{45.236, 53.1293}, CountryId{"RU"}}, // Q109930253
    {Coordinate{45.3216, 53.1373}, CountryId{"RU"}}, // Q109930254
    {Coordinate{45.3517, 53.1339}, CountryId{"RU"}}, // Q109930256
    {Coordinate{45.4832, 53.1116}, CountryId{"RU"}}, // Q109930257
    {Coordinate{45.5494, 53.1045}, CountryId{"RU"}}, // Q109930258
    {Coordinate{45.5818, 53.1056}, CountryId{"RU"}}, // Q109930259
    {Coordinate{45.6892, 53.1085}, CountryId{"RU"}}, // Q109930260
    {Coordinate{45.8152, 53.1067}, CountryId{"RU"}}, // Q109930261
    {Coordinate{45.9193, 53.1404}, CountryId{"RU"}}, // Q109930262
    {Coordinate{45.984, 53.1431}, CountryId{"RU"}}, // Q109930263
    {Coordinate{46.0093, 53.1504}, CountryId{"RU"}}, // Q109930264
    {Coordinate{46.1223, 53.1488}, CountryId{"RU"}}, // Q109930265
    {Coordinate{46.1868, 53.1459}, CountryId{"RU"}}, // Q109930266
    {Coordinate{46.3804, 53.1036}, CountryId{"RU"}}, // Q109930267
    {Coordinate{46.4872, 53.1109}, CountryId{"RU"}}, // Q109930268
    {Coordinate{46.5695, 53.1172}, CountryId{"RU"}}, // Q109930269
    {Coordinate{46.7488, 53.0981}, CountryId{"RU"}}, // Q109930270
    {Coordinate{46.8897, 53.1167}, CountryId{"RU"}}, // Q109930271
    {Coordinate{46.9691, 53.1295}, CountryId{"RU"}}, // Q109930273
    {Coordinate{47.0205, 53.1442}, CountryId{"RU"}}, // Q109930274
    {Coordinate{47.1166, 53.1189}, CountryId{"RU"}}, // Q109930275
    {Coordinate{47.3002, 53.1362}, CountryId{"RU"}}, // Q109930276
    {Coordinate{47.5427, 53.1528}, CountryId{"RU"}}, // Q109930277
    {Coordinate{47.5987, 53.1515}, CountryId{"RU"}}, // Q109930278
    {Coordinate{47.6539, 53.1452}, CountryId{"RU"}}, // Q109930279
    {Coordinate{47.8727, 53.1669}, CountryId{"RU"}}, // Q109930280
    {Coordinate{47.9138, 53.1714}, CountryId{"RU"}}, // Q109930281
    {Coordinate{47.9543, 53.1724}, CountryId{"RU"}}, // Q109930282
    {Coordinate{47.9997, 53.1745}, CountryId{"RU"}}, // Q109930283
    {Coordinate{48.0957, 53.171}, CountryId{"RU"}}, // Q109930284
    {Coordinate{48.1909, 53.169}, CountryId{"RU"}}, // Q109930285
    {Coordinate{48.2392, 53.1676}, CountryId{"RU"}}, // Q109930286
    {Coordinate{48.269, 53.1663}, CountryId{"RU"}}, // Q109930287
    {Coordinate{48.3006, 53.1637}, CountryId{"RU"}}, // Q109930289
    {Coordinate{-130.176, 54.178}, CountryId{"CA"}}, // Cassiar Cannery
    {Coordinate{133.145, 43.0619}, CountryId{"RU"}}, // Lozovy
    {Coordinate{133.161, 43.1143}, CountryId{"RU"}}, // 135 km
    {Coordinate{43.0295, 54.0942}, CountryId{"RU"}}, // Q109936605
    {Coordinate{43.7435, 54.0112}, CountryId{"RU"}}, // Q109936606
    {Coordinate{43.97, 54.0513}, CountryId{"RU"}}, // Q109936607
    {Coordinate{44.0504, 54.075}, CountryId{"RU"}}, // Q109936608
    {Coordinate{44.1528, 54.1047}, CountryId{"RU"}}, // Q109936609
    {Coordinate{44.2036, 54.0969}, CountryId{"RU"}}, // Q109936610
    {Coordinate{44.2503, 54.0893}, CountryId{"RU"}}, // Q109936611
    {Coordinate{44.6533, 54.0971}, CountryId{"RU"}}, // Q109936612
    {Coordinate{44.7529, 54.0794}, CountryId{"RU"}}, // Q109936613
    {Coordinate{44.7931, 54.0735}, CountryId{"RU"}}, // Q109936614
    {Coordinate{44.8983, 54.0589}, CountryId{"RU"}}, // Q109936615
    {Coordinate{8.64557, 51.7122}, CountryId{"DE"}}, // Scharmede station
    {Coordinate{45.169, 54.0447}, CountryId{"RU"}}, // Q109944210
    {Coordinate{45.23, 53.9905}, CountryId{"RU"}}, // Q109944211
    {Coordinate{45.2632, 53.9802}, CountryId{"RU"}}, // Q109944212
    {Coordinate{45.3451, 53.9526}, CountryId{"RU"}}, // Q109944213
    {Coordinate{45.478, 53.9328}, CountryId{"RU"}}, // Q109944214
    {Coordinate{45.5536, 53.9267}, CountryId{"RU"}}, // Q109944215
    {Coordinate{45.6156, 53.9405}, CountryId{"RU"}}, // Q109944216
    {Coordinate{45.6461, 53.9323}, CountryId{"RU"}}, // Q109944217
    {Coordinate{45.6732, 53.932}, CountryId{"RU"}}, // Q109944218
    {Coordinate{45.6843, 53.9003}, CountryId{"RU"}}, // Q109944219
    {Coordinate{45.811, 53.8865}, CountryId{"RU"}}, // Q109944220
    {Coordinate{45.9541, 53.8709}, CountryId{"RU"}}, // Q109944222
    {Coordinate{46.0235, 53.879}, CountryId{"RU"}}, // Q109944223
    {Coordinate{}, CountryId{"FR"}}, // Gare de Mortagne-au-Perche
    {Coordinate{46.4269, 53.8349}, CountryId{"RU"}}, // Q109947634
    {Coordinate{46.4521, 53.8196}, CountryId{"RU"}}, // Q109947636
    {Coordinate{46.5005, 53.799}, CountryId{"RU"}}, // Q109947637
    {Coordinate{46.591, 53.7553}, CountryId{"RU"}}, // Q109947639
    {Coordinate{46.7162, 53.7482}, CountryId{"RU"}}, // Q109947640
    {Coordinate{46.7564, 53.7448}, CountryId{"RU"}}, // Q109947641
    {Coordinate{46.8305, 53.6752}, CountryId{"RU"}}, // Q109947642
    {Coordinate{46.9227, 53.6762}, CountryId{"RU"}}, // Q109947643
    {Coordinate{46.9641, 53.6734}, CountryId{"RU"}}, // Q109947645
    {Coordinate{47.0294, 53.6917}, CountryId{"RU"}}, // Q109947646
    {Coordinate{47.0648, 53.6892}, CountryId{"RU"}}, // Q109947647
    {Coordinate{47.0737, 53.6717}, CountryId{"RU"}}, // Q109947648
    {Coordinate{47.1061, 53.6552}, CountryId{"RU"}}, // Q109947650
    {Coordinate{47.1456, 53.6292}, CountryId{"RU"}}, // Q109947651
    {Coordinate{47.1943, 53.6233}, CountryId{"RU"}}, // Q109947652
    {Coordinate{47.3684, 53.6109}, CountryId{"RU"}}, // Q109947653
    {Coordinate{47.6049, 53.5471}, CountryId{"RU"}}, // Q109947654
    {Coordinate{47.686, 53.5481}, CountryId{"RU"}}, // Q109947655
    {Coordinate{47.816, 53.5506}, CountryId{"RU"}}, // Q109947656
    {Coordinate{47.9322, 53.4978}, CountryId{"RU"}}, // Q109947658
    {Coordinate{47.9877, 53.4094}, CountryId{"RU"}}, // Q109947659
    {Coordinate{48.0176, 53.3859}, CountryId{"RU"}}, // Q109947660
    {Coordinate{48.0211, 53.327}, CountryId{"RU"}}, // Q109947661
    {Coordinate{48.0913, 53.2836}, CountryId{"RU"}}, // Q109947662
    {Coordinate{48.137, 53.2238}, CountryId{"RU"}}, // Q109947663
    {Coordinate{48.1971, 53.1934}, CountryId{"RU"}}, // Q109947664
    {Coordinate{48.2781, 53.1755}, CountryId{"RU"}}, // Q109947665
    {Coordinate{48.4381, 53.1673}, CountryId{"RU"}}, // Q109949983
    {Coordinate{133.074, 43.1984}, CountryId{"RU"}}, // Narechnoye
    {Coordinate{8.60091, 51.6731}, CountryId{"DE"}}, // Salzkotten station
    {Coordinate{46.4624, 53.9056}, CountryId{"RU"}}, // Q110004889
    {Coordinate{46.6115, 53.891}, CountryId{"RU"}}, // Q110004891
    {Coordinate{46.6655, 53.902}, CountryId{"RU"}}, // Q110004893
    {Coordinate{46.696, 53.9527}, CountryId{"RU"}}, // Q110004895
    {Coordinate{46.8584, 53.9712}, CountryId{"RU"}}, // Q110004896
    {Coordinate{47.1254, 54.0474}, CountryId{"RU"}}, // Q110004898
    {Coordinate{47.3502, 54.0974}, CountryId{"RU"}}, // Q110004900
    {Coordinate{47.3976, 54.102}, CountryId{"RU"}}, // Q110004902
    {Coordinate{47.4529, 54.096}, CountryId{"RU"}}, // Q110004904
    {Coordinate{47.6222, 54.1171}, CountryId{"RU"}}, // Q110004906
    {Coordinate{47.7509, 54.1246}, CountryId{"RU"}}, // Q110004908
    {Coordinate{47.7898, 54.1289}, CountryId{"RU"}}, // Q110004910
    {Coordinate{47.866, 54.1709}, CountryId{"RU"}}, // Q110004912
    {Coordinate{47.9254, 54.1755}, CountryId{"RU"}}, // Q110004914
    {Coordinate{48.014, 54.1932}, CountryId{"RU"}}, // Q110004916
    {Coordinate{48.0815, 54.2128}, CountryId{"RU"}}, // Q110004917
    {Coordinate{48.1249, 54.2172}, CountryId{"RU"}}, // Q110004919
    {Coordinate{48.1541, 54.2175}, CountryId{"RU"}}, // Q110004921
    {Coordinate{48.1919, 54.2282}, CountryId{"RU"}}, // Q110004923
    {Coordinate{48.2691, 54.2536}, CountryId{"RU"}}, // Studencheskaya
    {Coordinate{50.8038, 54.424}, CountryId{"RU"}}, // Norlat
    {Coordinate{48.5368, 54.3353}, CountryId{"RU"}}, // Verkhnyaya Terrasa
    {Coordinate{48.7046, 54.3454}, CountryId{"RU"}}, // Sovkhozny
    {Coordinate{48.8525, 54.3415}, CountryId{"RU"}}, // Cherdakly railway station
    {Coordinate{49.067, 54.3485}, CountryId{"RU"}}, // Urenbash
    {Coordinate{49.2213, 54.3342}, CountryId{"RU"}}, // Putevoy
    {Coordinate{49.3527, 54.339}, CountryId{"RU"}}, // Bryandino railway station
    {Coordinate{49.482, 54.3029}, CountryId{"RU"}}, // Tiinsk
    {Coordinate{50.4418, 54.2309}, CountryId{"RU"}}, // Pogruznaya
    {Coordinate{51.0963, 54.4064}, CountryId{"RU"}}, // Q110008152
    {Coordinate{51.4665, 54.4355}, CountryId{"RU"}}, // Q110008153
    {Coordinate{52.0225, 54.2591}, CountryId{"RU"}}, // Q110008154
    {Coordinate{53.4477, 54.599}, CountryId{"RU"}}, // Urıssu
    {Coordinate{53.7093, 54.6076}, CountryId{"RU"}}, // Q110013662
    {Coordinate{54.0993, 54.5532}, CountryId{"RU"}}, // Q110013663
    {Coordinate{54.1672, 54.5868}, CountryId{"RU"}}, // Q110013664
    {Coordinate{54.202, 54.5982}, CountryId{"RU"}}, // Q110013666
    {Coordinate{54.3508, 54.5868}, CountryId{"RU"}}, // Q110013667
    {Coordinate{54.3943, 54.5768}, CountryId{"RU"}}, // Q110013668
    {Coordinate{54.444, 54.5951}, CountryId{"RU"}}, // Q110013669
    {Coordinate{54.5199, 54.5697}, CountryId{"RU"}}, // Q110013670
    {Coordinate{54.7201, 54.5645}, CountryId{"RU"}}, // Q110013671
    {Coordinate{54.7988, 54.5595}, CountryId{"RU"}}, // Q110013672
    {Coordinate{54.9259, 54.5797}, CountryId{"RU"}}, // Q110013673
    {Coordinate{55.0085, 54.5998}, CountryId{"RU"}}, // Q110013674
    {Coordinate{55.0807, 54.5822}, CountryId{"RU"}}, // Q110013675
    {Coordinate{55.1467, 54.5609}, CountryId{"RU"}}, // Q110013676
    {Coordinate{55.2072, 54.5637}, CountryId{"RU"}}, // Q110013677
    {Coordinate{55.3457, 54.5811}, CountryId{"RU"}}, // Q110013678
    {Coordinate{12.1897, 56.0329}, CountryId{"DK"}}, // Troldebakkerne railway station
    {Coordinate{-72.9218, 41.3058}, CountryId{"US"}}, // New Haven State Street station
    {Coordinate{52.447, 54.5712}, CountryId{"RU"}}, // Pesmän
    {Coordinate{52.1388, 54.9194}, CountryId{"RU"}}, // Älmät
    {Coordinate{52.1114, 54.9941}, CountryId{"RU"}}, // Aqtaş
    {Coordinate{52.0697, 55.0813}, CountryId{"RU"}}, // Q110020277
    {Coordinate{52.0055, 55.1831}, CountryId{"RU"}}, // Yaqtı Kül
    {Coordinate{51.9744, 55.3893}, CountryId{"RU"}}, // Q110020280
    {Coordinate{51.9796, 55.4115}, CountryId{"RU"}}, // Ziçä
    {Coordinate{52.0209, 55.4454}, CountryId{"RU"}}, // Q110020282
    {Coordinate{51.9892, 55.5043}, CountryId{"RU"}}, // Bägiş
    {Coordinate{52.0084, 55.5398}, CountryId{"RU"}}, // Q110020284
    {Coordinate{52.0718, 55.5637}, CountryId{"RU"}}, // Q110020285
    {Coordinate{52.1732, 55.6194}, CountryId{"RU"}}, // Tügäräk Qır
    {Coordinate{52.3127, 55.8859}, CountryId{"RU"}}, // Mİndälä
    {Coordinate{52.3424, 55.9111}, CountryId{"RU"}}, // Q110020289
    {Coordinate{52.363, 55.9524}, CountryId{"RU"}}, // Q110020290
    {Coordinate{52.4091, 55.9846}, CountryId{"RU"}}, // Tuyma
    {Coordinate{52.5206, 56.0239}, CountryId{"RU"}}, // Q110020293
    {Coordinate{52.5595, 56.0747}, CountryId{"RU"}}, // Q110020294
    {Coordinate{51.9704, 55.5914}, CountryId{"RU"}}, // Biklän
    {Coordinate{51.8105, 55.6176}, CountryId{"RU"}}, // Tübän Kama
    {Coordinate{7.4788, 51.3511}, CountryId{"DE"}}, // Bahnhof Hagen-Oberhagen
    {Coordinate{49.5145, 53.3974}, CountryId{"RU"}}, // Q110038266
    {Coordinate{49.4926, 53.4058}, CountryId{"RU"}}, // Q110038267
    {Coordinate{50.1204, 53.4327}, CountryId{"RU"}}, // Q110038270
    {Coordinate{50.1634, 53.4384}, CountryId{"RU"}}, // Q110038271
    {Coordinate{50.196, 53.4199}, CountryId{"RU"}}, // Q110038272
    {Coordinate{50.2971, 53.4036}, CountryId{"RU"}}, // Q110038273
    {Coordinate{50.327, 53.3859}, CountryId{"RU"}}, // Q110038274
    {Coordinate{50.341, 53.3718}, CountryId{"RU"}}, // Q110038275
    {Coordinate{50.3575, 53.3629}, CountryId{"RU"}}, // Q110038276
    {Coordinate{50.3163, 53.3163}, CountryId{"RU"}}, // Q110038279
    {Coordinate{50.3017, 53.3021}, CountryId{"RU"}}, // Q110038281
    {Coordinate{50.3086, 53.2879}, CountryId{"RU"}}, // Q110038283
    {Coordinate{50.3172, 53.2705}, CountryId{"RU"}}, // Q110038285
    {Coordinate{50.3058, 53.2564}, CountryId{"RU"}}, // Q110038286
    {Coordinate{50.2886, 53.2339}, CountryId{"RU"}}, // Q110038287
    {Coordinate{50.238, 53.1995}, CountryId{"RU"}}, // Q110038289
    {Coordinate{50.2155, 53.185}, CountryId{"RU"}}, // Q110038290
    {Coordinate{50.1875, 53.174}, CountryId{"RU"}}, // Q110038291
    {Coordinate{50.1551, 53.1752}, CountryId{"RU"}}, // Q110038292
    {Coordinate{50.1364, 53.182}, CountryId{"RU"}}, // Q110038294
    {Coordinate{48.5219, 53.1749}, CountryId{"RU"}}, // Q110042404
    {Coordinate{48.537, 53.1748}, CountryId{"RU"}}, // Q110042405
    {Coordinate{48.6041, 53.1568}, CountryId{"RU"}}, // Oktyabrsk-Pristan
    {Coordinate{48.6278, 53.1549}, CountryId{"RU"}}, // Puteiskaya
    {Coordinate{48.6517, 53.1582}, CountryId{"RU"}}, // Lokomotivnaya railway station, Samara Oblast
    {Coordinate{48.6694, 53.1611}, CountryId{"RU"}}, // Oktyabrsk
    {Coordinate{48.6869, 53.1649}, CountryId{"RU"}}, // 977 km
    {Coordinate{48.7113, 53.1689}, CountryId{"RU"}}, // Rabochaya
    {Coordinate{48.7342, 53.1748}, CountryId{"RU"}}, // Zeleznodoroznaya
    {Coordinate{48.7854, 53.1838}, CountryId{"RU"}}, // Pravaya Volga
    {Coordinate{48.839, 53.1385}, CountryId{"RU"}}, // Dubovaya Rosha
    {Coordinate{48.8762, 53.1142}, CountryId{"RU"}}, // Obsharovka
    {Coordinate{49.0003, 53.0677}, CountryId{"RU"}}, // Q110042416
    {Coordinate{49.0825, 53.0488}, CountryId{"RU"}}, // Q110042417
    {Coordinate{49.1838, 53.0233}, CountryId{"RU"}}, // Q110042419
    {Coordinate{49.3114, 52.9911}, CountryId{"RU"}}, // Maytuga
    {Coordinate{49.4317, 52.9787}, CountryId{"RU"}}, // Bezenchuk
    {Coordinate{49.519, 52.9687}, CountryId{"RU"}}, // Vostok
    {Coordinate{49.6844, 52.9626}, CountryId{"RU"}}, // Q110043363
    {Coordinate{49.7028, 52.9773}, CountryId{"RU"}}, // Q110043364
    {Coordinate{49.7135, 52.9878}, CountryId{"RU"}}, // Stroitelnaya
    {Coordinate{49.7743, 53.036}, CountryId{"RU"}}, // Q110043366
    {Coordinate{49.8159, 53.0544}, CountryId{"RU"}}, // Q110043367
    {Coordinate{49.8424, 53.0701}, CountryId{"RU"}}, // Q110043368
    {Coordinate{49.8646, 53.0882}, CountryId{"RU"}}, // Q110043369
    {Coordinate{49.9299, 53.1208}, CountryId{"RU"}}, // Q110043371
    {Coordinate{49.985, 53.1015}, CountryId{"RU"}}, // Lipyagi railway station
    {Coordinate{50.0091, 53.0928}, CountryId{"RU"}}, // Q110043373
    {Coordinate{50.0387, 53.1032}, CountryId{"RU"}}, // Q110043375
    {Coordinate{50.0604, 53.1149}, CountryId{"RU"}}, // Q110043376
    {Coordinate{50.0912, 53.133}, CountryId{"RU"}}, // Q110043377
    {Coordinate{12.5039, 52.4277}, CountryId{"DE"}}, // Görden station
    {Coordinate{133.027, 43.1875}, CountryId{"RU"}}, // Krasnoarmeysky
    {Coordinate{8.5103, 51.6452}, CountryId{"DE"}}, // Geseke station
    {Coordinate{50.2854, 53.2193}, CountryId{"RU"}}, // Q110061973
    {Coordinate{50.3383, 53.2412}, CountryId{"RU"}}, // Q110061974
    {Coordinate{50.3841, 53.2599}, CountryId{"RU"}}, // Q110061975
    {Coordinate{50.4193, 53.25}, CountryId{"RU"}}, // Q110061976
    {Coordinate{50.4874, 53.2358}, CountryId{"RU"}}, // Q110061977
    {Coordinate{50.5352, 53.2493}, CountryId{"RU"}}, // Sovety
    {Coordinate{132.979, 43.2201}, CountryId{"RU"}}, // Fridman
    {Coordinate{132.945, 43.1763}, CountryId{"RU"}}, // 98 km
    {Coordinate{132.903, 43.192}, CountryId{"RU"}}, // 94 km
    {Coordinate{9.37156, 49.4306}, CountryId{"DE"}}, // Haltepunkt Zimmern bei Seckach
    {Coordinate{132.884, 43.1792}, CountryId{"RU"}}, // Tigrovy
    {Coordinate{50.7093, 53.2325}, CountryId{"RU"}}, // 1144 km
    {Coordinate{50.7399, 53.2388}, CountryId{"RU"}}, // Q110072060
    {Coordinate{50.837, 53.2519}, CountryId{"RU"}}, // Q110072063
    {Coordinate{50.9529, 53.2589}, CountryId{"RU"}}, // Q110072064
    {Coordinate{51.0017, 53.264}, CountryId{"RU"}}, // Q110072065
    {Coordinate{51.0681, 53.2709}, CountryId{"RU"}}, // Q110072066
    {Coordinate{51.1742, 53.2804}, CountryId{"RU"}}, // Q110072067
    {Coordinate{51.3474, 53.3591}, CountryId{"RU"}}, // Q110072068
    {Coordinate{51.431, 53.4052}, CountryId{"RU"}}, // Q110072069
    {Coordinate{51.5289, 53.4583}, CountryId{"RU"}}, // Tolkay railway station
    {Coordinate{51.6354, 53.5325}, CountryId{"RU"}}, // Q110072073
    {Coordinate{51.7263, 53.5627}, CountryId{"RU"}}, // Q110072074
    {Coordinate{51.8818, 53.6168}, CountryId{"RU"}}, // Q110072076
    {Coordinate{51.9276, 53.6315}, CountryId{"RU"}}, // Q110072077
    {Coordinate{52.013, 53.6394}, CountryId{"RU"}}, // Q110072078
    {Coordinate{52.2249, 53.6385}, CountryId{"RU"}}, // Q110072079
    {Coordinate{52.2888, 53.6395}, CountryId{"RU"}}, // Q110072080
    {Coordinate{52.501, 53.608}, CountryId{"RU"}}, // Q110072081
    {Coordinate{52.577, 53.5896}, CountryId{"RU"}}, // Q110072082
    {Coordinate{52.6247, 53.5785}, CountryId{"RU"}}, // Q110072083
    {Coordinate{52.7325, 53.5539}, CountryId{"RU"}}, // Q110072084
    {Coordinate{52.8126, 53.5733}, CountryId{"RU"}}, // Q110072085
    {Coordinate{52.8737, 53.5843}, CountryId{"RU"}}, // Q110072087
    {Coordinate{52.9351, 53.5904}, CountryId{"RU"}}, // Q110072088
    {Coordinate{52.999, 53.5799}, CountryId{"RU"}}, // Q110072089
    {Coordinate{53.0366, 53.5761}, CountryId{"RU"}}, // Q110072090
    {Coordinate{53.0956, 53.587}, CountryId{"RU"}}, // Q110072091
    {Coordinate{53.1446, 53.6068}, CountryId{"RU"}}, // Q110072094
    {Coordinate{53.1791, 53.5822}, CountryId{"RU"}}, // Q110072095
    {Coordinate{53.2006, 53.5755}, CountryId{"RU"}}, // Q110072096
    {Coordinate{53.2448, 53.5864}, CountryId{"RU"}}, // Q110072097
    {Coordinate{53.2879, 53.5864}, CountryId{"RU"}}, // Q110072098
    {Coordinate{53.3292, 53.5802}, CountryId{"RU"}}, // Q110072099
    {Coordinate{53.3773, 53.6025}, CountryId{"RU"}}, // Q110072100
    {Coordinate{53.4328, 53.6093}, CountryId{"RU"}}, // Q110072101
    {Coordinate{53.5087, 53.6108}, CountryId{"RU"}}, // Q110072102
    {Coordinate{53.5611, 53.6353}, CountryId{"RU"}}, // Q110072103
    {Coordinate{53.584, 53.6567}, CountryId{"RU"}}, // Q110072104
    {Coordinate{53.7328, 53.7448}, CountryId{"RU"}}, // Q110072105
    {Coordinate{53.8147, 53.7387}, CountryId{"RU"}}, // Q110072106
    {Coordinate{53.8149, 53.7718}, CountryId{"RU"}}, // Q110072108
    {Coordinate{53.8232, 53.8058}, CountryId{"RU"}}, // Q110072110
    {Coordinate{53.8491, 53.8353}, CountryId{"RU"}}, // Q110072111
    {Coordinate{53.8682, 53.8529}, CountryId{"RU"}}, // Q110072112
    {Coordinate{53.8881, 53.8714}, CountryId{"RU"}}, // Q110072113
    {Coordinate{54.036, 53.9489}, CountryId{"RU"}}, // Q110072114
    {Coordinate{54.1066, 53.9821}, CountryId{"RU"}}, // Q110072116
    {Coordinate{54.3126, 54.0334}, CountryId{"RU"}}, // Q110072117
    {Coordinate{54.3643, 54.0129}, CountryId{"RU"}}, // Q110072118
    {Coordinate{54.3797, 53.9972}, CountryId{"RU"}}, // Q110072119
    {Coordinate{54.3847, 53.9634}, CountryId{"RU"}}, // Q110072120
    {Coordinate{54.442, 53.9285}, CountryId{"RU"}}, // Q110072121
    {Coordinate{54.507, 53.9113}, CountryId{"RU"}}, // Q110072122
    {Coordinate{54.5465, 53.9207}, CountryId{"RU"}}, // Q110072123
    {Coordinate{54.7775, 53.9849}, CountryId{"RU"}}, // Q110072126
    {Coordinate{54.823, 53.9969}, CountryId{"RU"}}, // Q110072127
    {Coordinate{54.9065, 53.991}, CountryId{"RU"}}, // Q110072128
    {Coordinate{54.9886, 54.1532}, CountryId{"RU"}}, // Q110072129
    {Coordinate{54.9855, 54.1756}, CountryId{"RU"}}, // Q110072131
    {Coordinate{55.0664, 54.2337}, CountryId{"RU"}}, // Q110072133
    {Coordinate{55.0984, 54.2679}, CountryId{"RU"}}, // Q110072134
    {Coordinate{55.1274, 54.2947}, CountryId{"RU"}}, // Q110072135
    {Coordinate{55.1507, 54.3146}, CountryId{"RU"}}, // Q110072136
    {Coordinate{55.2014, 54.3647}, CountryId{"RU"}}, // Q110072137
    {Coordinate{55.2123, 54.3864}, CountryId{"RU"}}, // Q110072138
    {Coordinate{55.2503, 54.4508}, CountryId{"RU"}}, // Q110072139
    {Coordinate{55.269, 54.4785}, CountryId{"RU"}}, // Q110072140
    {Coordinate{55.3019, 54.5229}, CountryId{"RU"}}, // Q110072141
    {Coordinate{55.3324, 54.5474}, CountryId{"RU"}}, // Q110072142
    {Coordinate{8.44964, 51.6626}, CountryId{"DE"}}, // Ehringhausen (Kr Lippst)
    {Coordinate{6.82358, 49.9074}, CountryId{"DE"}}, // Sehlem (Kr. Wittlich) railway station
    {Coordinate{2.40472, 41.6379}, CountryId{"ES"}}, // Llinars del Vallès station
    {Coordinate{55.4672, 54.6142}, CountryId{"RU"}}, // Q110085450
    {Coordinate{55.5013, 54.6251}, CountryId{"RU"}}, // Q110085451
    {Coordinate{55.5274, 54.6346}, CountryId{"RU"}}, // Q110085452
    {Coordinate{55.5933, 54.6258}, CountryId{"RU"}}, // Q110085453
    {Coordinate{55.6913, 54.6238}, CountryId{"RU"}}, // Q110085454
    {Coordinate{55.7322, 54.6403}, CountryId{"RU"}}, // Q110085455
    {Coordinate{55.7917, 54.6567}, CountryId{"RU"}}, // Q110085456
    {Coordinate{49.7518, 54.1969}, CountryId{"RU"}}, // Obamza
    {Coordinate{132.803, 43.1837}, CountryId{"RU"}}, // 82 km
    {Coordinate{2.24549, 41.5497}, CountryId{"ES"}}, // Montmeló station
    {Coordinate{55.8326, 54.6511}, CountryId{"RU"}}, // Q110088628
    {Coordinate{55.8634, 54.6252}, CountryId{"RU"}}, // Q110088630
    {Coordinate{55.9636, 54.5577}, CountryId{"RU"}}, // Q110088631
    {Coordinate{56.0098, 54.5454}, CountryId{"RU"}}, // Q110088635
    {Coordinate{56.1404, 54.4977}, CountryId{"RU"}}, // Q110088636
    {Coordinate{56.1942, 54.4738}, CountryId{"RU"}}, // Q110088637
    {Coordinate{132.775, 43.1716}, CountryId{"RU"}}, // Anisimovka
    {Coordinate{1.45532, 41.1864}, CountryId{"ES"}}, // Roda de Mar
    {Coordinate{10.4839, 59.875}, CountryId{"NO"}}, // Billingstad Station
    {Coordinate{132.714, 43.176}, CountryId{"RU"}}, // Lukyanovka
    {Coordinate{132.607, 43.218}, CountryId{"RU"}}, // Novonezhino
    {Coordinate{11.3195, 48.8159}, CountryId{"DE"}}, // Eitensheim
    {Coordinate{11.2756, 48.8193}, CountryId{"DE"}}, // Tauberfeld
    {Coordinate{132.523, 43.2322}, CountryId{"RU"}}, // Romanovka
    {Coordinate{11.2115, 48.8407}, CountryId{"DE"}}, // Adelschlag
    {Coordinate{10.964, 48.9264}, CountryId{"DE"}}, // Pappenheim
    {Coordinate{10.6534, 48.8037}, CountryId{"DE"}}, // Q110125717
    {Coordinate{10.5992, 48.9445}, CountryId{"DE"}}, // Oettingen (Bay)
    {Coordinate{10.6073, 49.0438}, CountryId{"DE"}}, // Wassertrüdingen
    {Coordinate{10.6329, 49.072}, CountryId{"DE"}}, // Unterschwaningen
    {Coordinate{10.8593, 49.1187}, CountryId{"DE"}}, // Langlau
    {Coordinate{56.8777, 54.8756}, CountryId{"RU"}}, // Q110140212
    {Coordinate{56.9185, 54.8783}, CountryId{"RU"}}, // Q110140214
    {Coordinate{56.9513, 54.8877}, CountryId{"RU"}}, // Q110140216
    {Coordinate{57.02, 54.9247}, CountryId{"RU"}}, // Q110140218
    {Coordinate{57.0714, 54.9324}, CountryId{"RU"}}, // Q110140221
    {Coordinate{57.0904, 54.9482}, CountryId{"RU"}}, // 1710 км
    {Coordinate{57.1024, 54.9573}, CountryId{"RU"}}, // Q110140225
    {Coordinate{57.1352, 54.9747}, CountryId{"RU"}}, // Q110140227
    {Coordinate{57.2108, 54.9986}, CountryId{"RU"}}, // Q110140228
    {Coordinate{57.3071, 55.0154}, CountryId{"RU"}}, // Q110140230
    {Coordinate{57.3489, 55.0206}, CountryId{"RU"}}, // Q110140232
    {Coordinate{57.4184, 55.0477}, CountryId{"RU"}}, // Q110140234
    {Coordinate{57.4519, 55.0509}, CountryId{"RU"}}, // Q110140237
    {Coordinate{57.5851, 55.066}, CountryId{"RU"}}, // Q110140240
    {Coordinate{57.623, 55.0724}, CountryId{"RU"}}, // Q110140241
    {Coordinate{57.6679, 55.0665}, CountryId{"RU"}}, // Q110140244
    {Coordinate{57.7528, 55.0482}, CountryId{"RU"}}, // Q110140246
    {Coordinate{57.8047, 55.0397}, CountryId{"RU"}}, // Q110140248
    {Coordinate{57.9168, 55.0354}, CountryId{"RU"}}, // Q110140250
    {Coordinate{57.9819, 55.0303}, CountryId{"RU"}}, // Q110140254
    {Coordinate{10.9255, 49.1118}, CountryId{"DE"}}, // Ramsberg
    {Coordinate{10.9598, 49.0664}, CountryId{"DE"}}, // Ellingen (Bay)
    {Coordinate{11.0077, 49.1512}, CountryId{"DE"}}, // Mühlstetten
    {Coordinate{10.7205, 49.1544}, CountryId{"DE"}}, // Muhr am See
    {Coordinate{10.2428, 49.5513}, CountryId{"DE"}}, // Uffenheim
    {Coordinate{10.1459, 49.6639}, CountryId{"DE"}}, // Marktbreit
    {Coordinate{10.0248, 49.6853}, CountryId{"DE"}}, // Goßmannsdorf
    {Coordinate{8.39818, 51.6723}, CountryId{"DE"}}, // Dedinghausen station
    {Coordinate{10.0112, 49.7089}, CountryId{"DE"}}, // Winterhausen
    {Coordinate{11.0556, 49.2133}, CountryId{"DE"}}, // Unterheckenhofen
    {Coordinate{44.9828, 53.1424}, CountryId{"RU"}}, // Q110142824
    {Coordinate{44.9617, 53.1261}, CountryId{"RU"}}, // Q110142825
    {Coordinate{56.4629, 54.4204}, CountryId{"RU"}}, // Q110147368
    {Coordinate{56.5443, 54.4212}, CountryId{"RU"}}, // Q110147369
    {Coordinate{56.6555, 54.4323}, CountryId{"RU"}}, // Q110147370
    {Coordinate{56.7473, 54.4492}, CountryId{"RU"}}, // Q110147371
    {Coordinate{56.8488, 54.4697}, CountryId{"RU"}}, // Q110147372
    {Coordinate{56.919, 54.4866}, CountryId{"RU"}}, // Q110147373
    {Coordinate{56.9679, 54.502}, CountryId{"RU"}}, // Q110147374
    {Coordinate{57.0432, 54.482}, CountryId{"RU"}}, // Q110147375
    {Coordinate{57.0897, 54.4621}, CountryId{"RU"}}, // Q110147376
    {Coordinate{57.1744, 54.4537}, CountryId{"RU"}}, // Q110147377
    {Coordinate{57.275, 54.4853}, CountryId{"RU"}}, // Q110147378
    {Coordinate{57.2779, 54.4617}, CountryId{"RU"}}, // Q110147379
    {Coordinate{57.3749, 54.4084}, CountryId{"RU"}}, // Q110147380
    {Coordinate{57.4949, 54.3826}, CountryId{"RU"}}, // Q110147381
    {Coordinate{57.5532, 54.3709}, CountryId{"RU"}}, // Q110147382
    {Coordinate{57.5907, 54.3043}, CountryId{"RU"}}, // Q110147383
    {Coordinate{57.5929, 54.2712}, CountryId{"RU"}}, // Q110147384
    {Coordinate{57.5845, 54.2235}, CountryId{"RU"}}, // Q110147385
    {Coordinate{57.6217, 54.181}, CountryId{"RU"}}, // Q110147386
    {Coordinate{57.6957, 54.1257}, CountryId{"RU"}}, // Q110147387
    {Coordinate{57.7485, 54.0687}, CountryId{"RU"}}, // Q110147389
    {Coordinate{57.7776, 54.0258}, CountryId{"RU"}}, // Q110147390
    {Coordinate{57.8684, 53.9558}, CountryId{"RU"}}, // Q110147391
    {Coordinate{55.9129, 53.314}, CountryId{"RU"}}, // Q110152573
    {Coordinate{132.395, 43.1544}, CountryId{"RU"}}, // Petrovka
    {Coordinate{55.9225, 53.449}, CountryId{"RU"}}, // Q110155574
    {Coordinate{55.9093, 53.2442}, CountryId{"RU"}}, // Q110155575
    {Coordinate{55.9081, 53.2195}, CountryId{"RU"}}, // Q110155576
    {Coordinate{55.9293, 53.001}, CountryId{"RU"}}, // Q110155579
    {Coordinate{55.8996, 52.9223}, CountryId{"RU"}}, // Q110155580
    {Coordinate{55.7669, 52.8385}, CountryId{"RU"}}, // Q110155581
    {Coordinate{55.9056, 53.1698}, CountryId{"RU"}}, // Q110155596
    {Coordinate{35.3884, 57.1684}, CountryId{"RU"}}, // Lokotsy (station)
    {Coordinate{35.3346, 57.2033}, CountryId{"RU"}}, // Baranovka (station)
    {Coordinate{35.2759, 57.2413}, CountryId{"RU"}}, // Mutashelikha (station)
    {Coordinate{132.343, 42.8761}, CountryId{"RU"}}, // Dunay
    {Coordinate{-1.95177, 43.32}, CountryId{"ES"}}, // Intxaurrondo
    {Coordinate{132.332, 42.9293}, CountryId{"RU"}}, // Yuzhnorechensk
    {Coordinate{8.16246, 51.5872}, CountryId{"DE"}}, // Bad Sassendorf station
    {Coordinate{132.335, 43.0022}, CountryId{"RU"}}, // Strelkovaya
    {Coordinate{35.1606, 57.3155}, CountryId{"RU"}}, // Bukhalovsky Pereezd railway station
    {Coordinate{35.103, 57.3527}, CountryId{"RU"}}, // Levoshinka railway station
    {Coordinate{132.294, 43.3752}, CountryId{"RU"}}, // Artyom-Primorsky 3
    {Coordinate{7.99147, 47.9586}, CountryId{"DE"}}, // Himmelreich
    {Coordinate{34.915, 57.4723}, CountryId{"RU"}}, // Lubinka station
    {Coordinate{34.8337, 57.5243}, CountryId{"RU"}}, // Industriya station
    {Coordinate{10.8759, 49.5064}, CountryId{"DE"}}, // Siegelsdorf
    {Coordinate{10.9568, 49.475}, CountryId{"DE"}}, // Fürth-Unterfürberg
    {Coordinate{12.7271, 47.9315}, CountryId{"DE"}}, // Waging
    {Coordinate{132.191, 43.3798}, CountryId{"RU"}}, // Artyom-Primorsky 1
    {Coordinate{34.7307, 57.5651}, CountryId{"RU"}}, // Terelesovskaya station
    {Coordinate{34.6606, 57.5793}, CountryId{"RU"}}, // Yelizarovka station
    {Coordinate{34.497, 57.6197}, CountryId{"RU"}}, // Q110189657
    {Coordinate{34.4544, 57.6478}, CountryId{"RU"}}, // Q110189658
    {Coordinate{34.3956, 57.6866}, CountryId{"RU"}}, // Q110189659
    {Coordinate{34.3445, 57.7174}, CountryId{"RU"}}, // Q110189660
    {Coordinate{34.3142, 57.7355}, CountryId{"RU"}}, // Q110189661
    {Coordinate{34.2912, 57.7638}, CountryId{"RU"}}, // Q110189662
    {Coordinate{34.2328, 57.8054}, CountryId{"RU"}}, // Q110189663
    {Coordinate{34.2027, 57.8234}, CountryId{"RU"}}, // Q110189664
    {Coordinate{34.1519, 57.8539}, CountryId{"RU"}}, // Q110189665
    {Coordinate{8.03179, 51.5983}, CountryId{"DE"}}, // Borgeln station
    {Coordinate{33.9532, 57.9551}, CountryId{"RU"}}, // Q110200975
    {Coordinate{33.8521, 58.0197}, CountryId{"RU"}}, // Q110200976
    {Coordinate{33.756, 58.0771}, CountryId{"RU"}}, // Q110200977
    {Coordinate{33.6691, 58.1282}, CountryId{"RU"}}, // Q110200979
    {Coordinate{33.6225, 58.1514}, CountryId{"RU"}}, // Q110200981
    {Coordinate{33.5916, 58.1716}, CountryId{"RU"}}, // Q110200982
    {Coordinate{33.5517, 58.2014}, CountryId{"RU"}}, // Q110200984
    {Coordinate{33.4238, 58.2947}, CountryId{"RU"}}, // Q110200989
    {Coordinate{33.3769, 58.3267}, CountryId{"RU"}}, // Q110200990
    {Coordinate{33.7303, 58.3224}, CountryId{"RU"}}, // Q110200991
    {Coordinate{61.4655, 55.1516}, CountryId{"RU"}}, // Traktorstroy railway station
    {Coordinate{11.0655, 50.2229}, CountryId{"DE"}}, // Ebersdorf (b Coburg)
    {Coordinate{11.0259, 50.2275}, CountryId{"DE"}}, // Grub am Forst
    {Coordinate{10.995, 50.1087}, CountryId{"DE"}}, // Bad Staffelstein
    {Coordinate{11.1162, 50.1551}, CountryId{"DE"}}, // Michelau (Oberfr)
    {Coordinate{32.8806, 58.582}, CountryId{"RU"}}, // Q110213408
    {Coordinate{33.1698, 58.4317}, CountryId{"RU"}}, // Q110218588
    {Coordinate{32.9703, 58.5385}, CountryId{"RU"}}, // Q110218591
    {Coordinate{32.8162, 58.6108}, CountryId{"RU"}}, // Q110218596
    {Coordinate{32.5919, 58.6858}, CountryId{"RU"}}, // Q110218602
    {Coordinate{32.3697, 58.7743}, CountryId{"RU"}}, // Q110218606
    {Coordinate{35.0782, 57.0669}, CountryId{"RU"}}, // Kolodezi railway station
    {Coordinate{35.2004, 57.0819}, CountryId{"RU"}}, // Tereshkino (station)
    {Coordinate{35.3218, 57.0868}, CountryId{"RU"}}, // Lazari (station)
    {Coordinate{35.4163, 57.1253}, CountryId{"RU"}}, // Vinokoly
    {Coordinate{11.6758, 51.0087}, CountryId{"DE"}}, // Dornburg (Saale) station
    {Coordinate{11.5797, 51.0645}, CountryId{"DE"}}, // Niedertrebra station
    {Coordinate{11.2211, 50.9843}, CountryId{"DE"}}, // Hopfgarten (Kr Weimar) station
    {Coordinate{11.1387, 50.9928}, CountryId{"DE"}}, // Vieselbach station
    {Coordinate{12.4263, 51.083}, CountryId{"DE"}}, // Regis-Breitingen
    {Coordinate{8.0651, 51.1229}, CountryId{"DE"}}, // Lennestadt-Meggen station
    {Coordinate{7.79043, 48.2741}, CountryId{"DE"}}, // Orschweier station
    {Coordinate{7.77295, 48.2485}, CountryId{"DE"}}, // Ringsheim station
    {Coordinate{10.2364, 48.5325}, CountryId{"DE"}}, // Niederstotzingen train station
    {Coordinate{10.2848, 48.5593}, CountryId{"DE"}}, // Sontheim-Brenz train station
    {Coordinate{10.2729, 48.5761}, CountryId{"DE"}}, // Bergenweiler railway stop
    {Coordinate{10.2582, 48.5947}, CountryId{"DE"}}, // Hermaringen train station
    {Coordinate{10.1701, 48.6257}, CountryId{"DE"}}, // Herbrechtingen train station
    {Coordinate{10.1609, 48.6532}, CountryId{"DE"}}, // Heidenheim-Mergelstetten train station
    {Coordinate{10.156, 48.6695}, CountryId{"DE"}}, // Heidenheim Voithwerk railway stop
    {Coordinate{10.1588, 48.7083}, CountryId{"DE"}}, // Heidenheim-Schnaitheim train station
    {Coordinate{10.1363, 48.7307}, CountryId{"DE"}}, // Itzelberg railway stop
    {Coordinate{10.1265, 48.815}, CountryId{"DE"}}, // Unterkochen train station
    {Coordinate{38.1508, 51.7886}, CountryId{"RU"}}, // Q110243407
    {Coordinate{38.165, 51.7773}, CountryId{"RU"}}, // Q110243408
    {Coordinate{38.1818, 51.7262}, CountryId{"RU"}}, // Q110243409
    {Coordinate{38.3745, 51.6845}, CountryId{"RU"}}, // Q110243410
    {Coordinate{38.414, 51.6812}, CountryId{"RU"}}, // Q110243411
    {Coordinate{38.4416, 51.6669}, CountryId{"RU"}}, // Q110243412
    {Coordinate{38.4724, 51.649}, CountryId{"RU"}}, // Q110243413
    {Coordinate{38.5554, 51.6527}, CountryId{"RU"}}, // Q110243414
    {Coordinate{38.5839, 51.6467}, CountryId{"RU"}}, // Q110243415
    {Coordinate{38.6075, 51.6503}, CountryId{"RU"}}, // Q110243416
    {Coordinate{38.6948, 51.6599}, CountryId{"RU"}}, // Q110243417
    {Coordinate{38.7279, 51.6744}, CountryId{"RU"}}, // Q110243418
    {Coordinate{38.7564, 51.669}, CountryId{"RU"}}, // Q110243419
    {Coordinate{38.8132, 51.6514}, CountryId{"RU"}}, // Q110243420
    {Coordinate{38.9541, 51.6843}, CountryId{"RU"}}, // Q110243421
    {Coordinate{39.0342, 51.6814}, CountryId{"RU"}}, // Semiluki railway station
    {Coordinate{39.0598, 51.6854}, CountryId{"RU"}}, // Q110243423
    {Coordinate{39.0856, 51.667}, CountryId{"RU"}}, // Q110243424
    {Coordinate{39.116, 51.6627}, CountryId{"RU"}}, // 239 km railway station, Voronezh
    {Coordinate{39.1865, 51.6768}, CountryId{"RU"}}, // Q110243426
    {Coordinate{39.2335, 51.6997}, CountryId{"RU"}}, // Q110243427
    {Coordinate{38.1168, 51.7663}, CountryId{"RU"}}, // Q110245436
    {Coordinate{38.1079, 51.7067}, CountryId{"RU"}}, // Q110245437
    {Coordinate{38.1292, 51.6728}, CountryId{"RU"}}, // Q110245438
    {Coordinate{38.1341, 51.6368}, CountryId{"RU"}}, // Q110245439
    {Coordinate{38.1122, 51.5946}, CountryId{"RU"}}, // Q110245440
    {Coordinate{38.0748, 51.5758}, CountryId{"RU"}}, // Q110245441
    {Coordinate{38.0167, 51.4691}, CountryId{"RU"}}, // Q110245442
    {Coordinate{37.9652, 51.4389}, CountryId{"RU"}}, // Q110245443
    {Coordinate{37.9281, 51.4281}, CountryId{"RU"}}, // Q110245444
    {Coordinate{37.9044, 51.4021}, CountryId{"RU"}}, // Q110245445
    {Coordinate{37.8745, 51.3841}, CountryId{"RU"}}, // Q110245446
    {Coordinate{37.8655, 51.3601}, CountryId{"RU"}}, // Q110245447
    {Coordinate{36.8642, 51.3331}, CountryId{"RU"}}, // Q110247778
    {Coordinate{36.9402, 51.3338}, CountryId{"RU"}}, // Q110247779
    {Coordinate{37.0716, 51.3437}, CountryId{"RU"}}, // Q110247780
    {Coordinate{37.1009, 51.3436}, CountryId{"RU"}}, // Q110247781
    {Coordinate{37.3094, 51.3089}, CountryId{"RU"}}, // Q110247782
    {Coordinate{37.5447, 51.2751}, CountryId{"RU"}}, // Q110247783
    {Coordinate{37.5739, 51.2794}, CountryId{"RU"}}, // Q110247784
    {Coordinate{36.8243, 51.3322}, CountryId{"RU"}}, // Q110247795
    {Coordinate{34.4463, 61.3208}, CountryId{"RU"}}, // 342 km
    {Coordinate{36.7246, 51.2729}, CountryId{"RU"}}, // Q110250194
    {Coordinate{36.677, 51.1951}, CountryId{"RU"}}, // Q110250195
    {Coordinate{36.7075, 51.1616}, CountryId{"RU"}}, // Q110250196
    {Coordinate{36.7597, 51.1258}, CountryId{"RU"}}, // Elnikovo railway station
    {Coordinate{36.7671, 51.0861}, CountryId{"RU"}}, // Q110250198
    {Coordinate{36.7528, 51.0645}, CountryId{"RU"}}, // Q110250199
    {Coordinate{36.6291, 50.9889}, CountryId{"RU"}}, // Q110250201
    {Coordinate{36.6223, 50.9405}, CountryId{"RU"}}, // Q110250202
    {Coordinate{36.6218, 50.869}, CountryId{"RU"}}, // Q110250203
    {Coordinate{36.6313, 50.8323}, CountryId{"RU"}}, // Q110250204
    {Coordinate{36.6575, 50.8028}, CountryId{"RU"}}, // Q110250205
    {Coordinate{36.6577, 50.7766}, CountryId{"RU"}}, // Q110250207
    {Coordinate{36.6403, 50.7615}, CountryId{"RU"}}, // Q110250208
    {Coordinate{36.6229, 50.7528}, CountryId{"RU"}}, // Q110250210
    {Coordinate{36.6158, 50.7286}, CountryId{"RU"}}, // Q110250211
    {Coordinate{36.6228, 50.7069}, CountryId{"RU"}}, // Q110250212
    {Coordinate{36.6295, 50.6774}, CountryId{"RU"}}, // Q110250213
    {Coordinate{36.6332, 50.6529}, CountryId{"RU"}}, // Q110250214
    {Coordinate{36.6297, 50.6346}, CountryId{"RU"}}, // Q110250215
    {Coordinate{36.6193, 50.6146}, CountryId{"RU"}}, // Q110250216
    {Coordinate{34.4434, 61.2682}, CountryId{"RU"}}, // Tarzhepol
    {Coordinate{36.5854, 50.586}, CountryId{"RU"}}, // Q110252714
    {Coordinate{36.5412, 50.5761}, CountryId{"RU"}}, // Q110252715
    {Coordinate{36.5194, 50.5677}, CountryId{"RU"}}, // Q110252716
    {Coordinate{36.4021, 50.5159}, CountryId{"RU"}}, // Q110252717
    {Coordinate{36.3913, 50.4976}, CountryId{"RU"}}, // Q110252718
    {Coordinate{36.3422, 50.4266}, CountryId{"RU"}}, // Q110252720
    {Coordinate{36.3582, 50.4487}, CountryId{"RU"}}, // Q110252722
    {Coordinate{34.4471, 61.2036}, CountryId{"RU"}}, // Pay
    {Coordinate{12.4416, 50.6785}, CountryId{"DE"}}, // Stenn railway stop
    {Coordinate{12.4202, 50.6994}, CountryId{"DE"}}, // Lichtentanne (Sachs) railway station
    {Coordinate{12.3941, 50.709}, CountryId{"DE"}}, // Steinpleis
    {Coordinate{-3.52259, 50.731}, CountryId{"GB"}}, // St James Park railway station
    {Coordinate{31.1056, 69.3997}, CountryId{"RU"}}, // Loustary
    {Coordinate{40.2475, 61.9328}, CountryId{"RU"}}, // Q110259500
    {Coordinate{42.2781, 51.1392}, CountryId{"RU"}}, // Q110259501
    {Coordinate{114.547, 51.4808}, CountryId{"RU"}}, // Q110259503
    {Coordinate{31.6988, 69.1908}, CountryId{"RU"}}, // Mokket
    {Coordinate{28.4769, 60.806}, CountryId{"RU"}}, // Luzhayka
    {Coordinate{116.591, 50.2527}, CountryId{"RU"}}, // Soktuy railway station
    {Coordinate{116.464, 50.4344}, CountryId{"RU"}}, // Q110259512
    {Coordinate{63.745, 57.0622}, CountryId{"RU"}}, // Q110259514
    {Coordinate{34.0833, 59.5567}, CountryId{"RU"}}, // Q110259517
    {Coordinate{28.3714, 57.7467}, CountryId{"RU"}}, // Q110259519
    {Coordinate{28.8956, 56.327}, CountryId{"RU"}}, // Idritsa
    {Coordinate{28.7345, 56.3505}, CountryId{"RU"}}, // Zavaruyka
    {Coordinate{29.0695, 56.3188}, CountryId{"RU"}}, // Nashchyokino
    {Coordinate{28.357, 56.3308}, CountryId{"RU"}}, // Garneya
    {Coordinate{32.4956, 59.8767}, CountryId{"RU"}}, // Q110259524
    {Coordinate{132.885, 44.1764}, CountryId{"RU"}}, // Q110259525
    {Coordinate{59.4414, 57.0217}, CountryId{"RU"}}, // Q110259526
    {Coordinate{59.1445, 58.4468}, CountryId{"RU"}}, // Q110259531
    {Coordinate{59.0674, 58.5292}, CountryId{"RU"}}, // Q110259532
    {Coordinate{59.5289, 58.3532}, CountryId{"RU"}}, // Q110259533
    {Coordinate{59.7209, 58.1837}, CountryId{"RU"}}, // Baranchinskaya
    {Coordinate{59.8623, 58.0513}, CountryId{"RU"}}, // Q110259535
    {Coordinate{60.2002, 57.4142}, CountryId{"RU"}}, // Shurala
    {Coordinate{60.2222, 57.0385}, CountryId{"RU"}}, // Ayat
    {Coordinate{135.107, 48.1008}, CountryId{"RU"}}, // Q110259539
    {Coordinate{32.9649, 66.2662}, CountryId{"RU"}}, // Chupa
    {Coordinate{39.4944, 59.2453}, CountryId{"RU"}}, // Q110259545
    {Coordinate{36.7547, 59.2367}, CountryId{"RU"}}, // Q110259547
    {Coordinate{36.1539, 59.3831}, CountryId{"RU"}}, // Q110259548
    {Coordinate{60.4818, 56.9204}, CountryId{"RU"}}, // Shuvakish
    {Coordinate{36.4287, 59.2833}, CountryId{"RU"}}, // Q110259550
    {Coordinate{37.3639, 59.1692}, CountryId{"RU"}}, // Komariha railway station
    {Coordinate{132.635, 44.5164}, CountryId{"RU"}}, // Q110259552
    {Coordinate{132.451, 44.2722}, CountryId{"RU"}}, // Q110259553
    {Coordinate{38.9415, 46.0869}, CountryId{"RU"}}, // Q110259554
    {Coordinate{133.833, 44.2225}, CountryId{"RU"}}, // Novochuguyevka railway station
    {Coordinate{35.6308, 59.4825}, CountryId{"RU"}}, // Q110259556
    {Coordinate{38.08, 59.1357}, CountryId{"RU"}}, // Q110259557
    {Coordinate{40.2133, 58.5423}, CountryId{"RU"}}, // Q110259558
    {Coordinate{85.0361, 55.0308}, CountryId{"RU"}}, // Q110259559
    {Coordinate{40.151, 59.1162}, CountryId{"RU"}}, // Q110259560
    {Coordinate{81.4275, 53.79}, CountryId{"RU"}}, // Q110259561
    {Coordinate{92.8285, 56.0252}, CountryId{"RU"}}, // Q110259564
    {Coordinate{29.6114, 61.4986}, CountryId{"RU"}}, // Syuvyaoro
    {Coordinate{48.5358, 50.1338}, CountryId{"RU"}}, // Q110259567
    {Coordinate{93.065, 56.0219}, CountryId{"RU"}}, // Q110259568
    {Coordinate{33.2587, 67.8524}, CountryId{"RU"}}, // Imandra
    {Coordinate{93.1564, 55.9319}, CountryId{"RU"}}, // Q110259572
    {Coordinate{59.2283, 56.5228}, CountryId{"RU"}}, // Q110259573
    {Coordinate{91.9814, 56.0747}, CountryId{"RU"}}, // Q110259575
    {Coordinate{92.2222, 56.1006}, CountryId{"RU"}}, // Kacha railway station
    {Coordinate{92.7761, 55.9728}, CountryId{"RU"}}, // Q110259577
    {Coordinate{44.4039, 64.0417}, CountryId{"RU"}}, // Q110259578
    {Coordinate{92.0731, 56.1108}, CountryId{"RU"}}, // Q110259579
    {Coordinate{92.1936, 56.0956}, CountryId{"RU"}}, // Q110259580
    {Coordinate{92.1569, 56.1003}, CountryId{"RU"}}, // Q110259581
    {Coordinate{93.1139, 56.02}, CountryId{"RU"}}, // Q110259583
    {Coordinate{92.1267, 56.1108}, CountryId{"RU"}}, // Q110259585
    {Coordinate{60.759, 58.0877}, CountryId{"RU"}}, // Nizhnyaya Salda
    {Coordinate{59.8557, 58.3576}, CountryId{"RU"}}, // Q110259587
    {Coordinate{59.7228, 58.2837}, CountryId{"RU"}}, // Kushva
    {Coordinate{34.0406, 56.9314}, CountryId{"RU"}}, // Rantsevo
    {Coordinate{59.9729, 58.5795}, CountryId{"RU"}}, // Vyja railway station
    {Coordinate{60.1887, 58.6433}, CountryId{"RU"}}, // Q110259593
    {Coordinate{36.5754, 50.588}, CountryId{"RU"}}, // Q110259970
    {Coordinate{36.5388, 50.6016}, CountryId{"RU"}}, // Q110259973
    {Coordinate{36.5015, 50.6179}, CountryId{"RU"}}, // Q110259974
    {Coordinate{36.4717, 50.628}, CountryId{"RU"}}, // Q110259975
    {Coordinate{36.447, 50.6274}, CountryId{"RU"}}, // Q110259976
    {Coordinate{36.417, 50.6232}, CountryId{"RU"}}, // Q110259977
    {Coordinate{36.3709, 50.6196}, CountryId{"RU"}}, // Q110259978
    {Coordinate{36.3267, 50.6254}, CountryId{"RU"}}, // Q110259981
    {Coordinate{36.2382, 50.6716}, CountryId{"RU"}}, // Q110259984
    {Coordinate{36.1744, 50.6973}, CountryId{"RU"}}, // Q110259985
    {Coordinate{36.0728, 50.7513}, CountryId{"RU"}}, // Q110259986
    {Coordinate{36.0176, 50.7517}, CountryId{"RU"}}, // Q110259987
    {Coordinate{35.9023, 50.7889}, CountryId{"RU"}}, // Q110259988
    {Coordinate{36.852, 50.3722}, CountryId{"RU"}}, // Q110260118
    {Coordinate{36.6402, 50.5935}, CountryId{"RU"}}, // Q110260376
    {Coordinate{36.6517, 50.5808}, CountryId{"RU"}}, // Q110260377
    {Coordinate{36.6554, 50.566}, CountryId{"RU"}}, // Q110260378
    {Coordinate{36.6619, 50.5399}, CountryId{"RU"}}, // Q110260379
    {Coordinate{36.6813, 50.5177}, CountryId{"RU"}}, // Q110260380
    {Coordinate{36.7024, 50.4974}, CountryId{"RU"}}, // Q110260381
    {Coordinate{36.7405, 50.4623}, CountryId{"RU"}}, // Q110260382
    {Coordinate{36.7612, 50.4423}, CountryId{"RU"}}, // Q110260383
    {Coordinate{36.7957, 50.4068}, CountryId{"RU"}}, // Q110260384
    {Coordinate{36.8306, 50.3889}, CountryId{"RU"}}, // Q110260385
    {Coordinate{39.4677, 52.6236}, CountryId{"RU"}}, // Q110263348
    {Coordinate{34.9437, 56.9011}, CountryId{"RU"}}, // L'nyanaya
    {Coordinate{34.9539, 56.8247}, CountryId{"RU"}}, // Pozhitovo
    {Coordinate{34.838, 56.6349}, CountryId{"RU"}}, // 83 km
    {Coordinate{39.2766, 53.7446}, CountryId{"RU"}}, // Q110265040
    {Coordinate{39.3059, 53.7116}, CountryId{"RU"}}, // Q110265041
    {Coordinate{39.3701, 53.6213}, CountryId{"RU"}}, // Q110265042
    {Coordinate{39.4415, 53.5742}, CountryId{"RU"}}, // Q110265043
    {Coordinate{39.5272, 53.5333}, CountryId{"RU"}}, // Q110265046
    {Coordinate{39.5894, 53.5094}, CountryId{"RU"}}, // Q110265047
    {Coordinate{39.667, 53.4528}, CountryId{"RU"}}, // Q110265048
    {Coordinate{40.0348, 53.2527}, CountryId{"RU"}}, // Q110265168
    {Coordinate{12.4756, 50.7636}, CountryId{"DE"}}, // Oberrothenbach station
    {Coordinate{12.4168, 50.8581}, CountryId{"DE"}}, // Ponitz
    {Coordinate{12.3696, 50.7871}, CountryId{"DE"}}, // Schweinsburg-Culten
    {Coordinate{12.4271, 50.9355}, CountryId{"DE"}}, // Lehndorf (Kr Altenburg)
    {Coordinate{12.4409, 51.0469}, CountryId{"DE"}}, // Treben-Lehma
    {Coordinate{12.0774, 50.8705}, CountryId{"DE"}}, // Gera Süd
    {Coordinate{12.0826, 50.8506}, CountryId{"DE"}}, // Gera-Zwötzen
    {Coordinate{40.146, 53.641}, CountryId{"RU"}}, // Q110268288
    {Coordinate{40.1745, 53.5825}, CountryId{"RU"}}, // Q110268289
    {Coordinate{40.1945, 53.5403}, CountryId{"RU"}}, // Q110268290
    {Coordinate{40.2127, 53.4757}, CountryId{"RU"}}, // Q110268291
    {Coordinate{40.2268, 53.4385}, CountryId{"RU"}}, // Q110268292
    {Coordinate{40.2433, 53.3925}, CountryId{"RU"}}, // Q110268293
    {Coordinate{40.2498, 53.3722}, CountryId{"RU"}}, // Q110268294
    {Coordinate{40.2561, 53.3524}, CountryId{"RU"}}, // Q110268295
    {Coordinate{40.2757, 53.291}, CountryId{"RU"}}, // Q110268296
    {Coordinate{12.074, 50.8169}, CountryId{"DE"}}, // Wolfsgefärth
    {Coordinate{12.078, 50.8174}, CountryId{"DE"}}, // Wünschendorf (Elster) Nord
    {Coordinate{11.8722, 50.7409}, CountryId{"DE"}}, // Triptis
    {Coordinate{11.7576, 50.7348}, CountryId{"DE"}}, // Neustadt (Orla)
    {Coordinate{40.3185, 53.1963}, CountryId{"RU"}}, // Q110268396
    {Coordinate{-0.377125, 39.467}, CountryId{"ES"}}, // Estació del Nord
    {Coordinate{40.3369, 53.1589}, CountryId{"RU"}}, // Q110268534
    {Coordinate{40.3478, 53.1367}, CountryId{"RU"}}, // Q110268535
    {Coordinate{40.3612, 53.112}, CountryId{"RU"}}, // Q110268536
    {Coordinate{40.3839, 53.0727}, CountryId{"RU"}}, // Q110268537
    {Coordinate{40.394, 53.0562}, CountryId{"RU"}}, // Q110268538
    {Coordinate{40.4145, 53.0436}, CountryId{"RU"}}, // Q110268539
    {Coordinate{40.4336, 53.0332}, CountryId{"RU"}}, // Q110268540
    {Coordinate{40.451, 53.021}, CountryId{"RU"}}, // Q110268541
    {Coordinate{40.4819, 52.9908}, CountryId{"RU"}}, // Q110268542
    {Coordinate{40.4825, 52.9805}, CountryId{"RU"}}, // Q110268543
    {Coordinate{40.4822, 52.9672}, CountryId{"RU"}}, // Q110268544
    {Coordinate{40.4817, 52.9489}, CountryId{"RU"}}, // Q110268725
    {Coordinate{40.4813, 52.9313}, CountryId{"RU"}}, // Q110268726
    {Coordinate{40.4811, 52.9207}, CountryId{"RU"}}, // Q110268728
    {Coordinate{40.4821, 52.9085}, CountryId{"RU"}}, // Q110268729
    {Coordinate{40.4644, 52.9067}, CountryId{"RU"}}, // Q110268963
    {Coordinate{40.4139, 52.8765}, CountryId{"RU"}}, // Q110268964
    {Coordinate{40.4065, 52.8566}, CountryId{"RU"}}, // Q110268966
    {Coordinate{40.4103, 52.8401}, CountryId{"RU"}}, // Q110268967
    {Coordinate{40.3781, 52.7697}, CountryId{"RU"}}, // Q110268968
    {Coordinate{40.3567, 52.7397}, CountryId{"RU"}}, // Q110268969
    {Coordinate{40.3213, 52.7028}, CountryId{"RU"}}, // Q110268970
    {Coordinate{40.2826, 52.6641}, CountryId{"RU"}}, // Q110268971
    {Coordinate{40.216, 52.6144}, CountryId{"RU"}}, // Q110268972
    {Coordinate{40.1759, 52.5958}, CountryId{"RU"}}, // Q110268973
    {Coordinate{40.064, 52.5444}, CountryId{"RU"}}, // Q110268974
    {Coordinate{40.0302, 52.5289}, CountryId{"RU"}}, // Q110268975
    {Coordinate{40.52, 52.9152}, CountryId{"RU"}}, // Q110270577
    {Coordinate{40.6426, 52.9147}, CountryId{"RU"}}, // Q110270578
    {Coordinate{41.1684, 52.8186}, CountryId{"RU"}}, // Q110270579
    {Coordinate{41.2321, 52.7946}, CountryId{"RU"}}, // Q110270580
    {Coordinate{41.3033, 52.7722}, CountryId{"RU"}}, // Q110270581
    {Coordinate{39.913, 52.4711}, CountryId{"RU"}}, // 474 km railway station track post
    {Coordinate{39.7983, 52.3613}, CountryId{"RU"}}, // Q110271353
    {Coordinate{39.7873, 52.3304}, CountryId{"RU"}}, // Q110271354
    {Coordinate{39.7845, 52.2314}, CountryId{"RU"}}, // Q110271355
    {Coordinate{39.7689, 52.1809}, CountryId{"RU"}}, // Q110271356
    {Coordinate{39.7013, 52.0416}, CountryId{"RU"}}, // Q110271358
    {Coordinate{39.6782, 51.9658}, CountryId{"RU"}}, // Q110271360
    {Coordinate{39.5731, 51.8128}, CountryId{"RU"}}, // Q110271361
    {Coordinate{39.5599, 51.7905}, CountryId{"RU"}}, // Q110271362
    {Coordinate{39.5224, 51.7634}, CountryId{"RU"}}, // Q110271363
    {Coordinate{39.4864, 51.756}, CountryId{"RU"}}, // Q110271364
    {Coordinate{39.4233, 51.757}, CountryId{"RU"}}, // Q110271365
    {Coordinate{39.373, 51.7444}, CountryId{"RU"}}, // Q110271366
    {Coordinate{39.3487, 51.7368}, CountryId{"RU"}}, // Somovo railway station
    {Coordinate{39.3154, 51.7357}, CountryId{"RU"}}, // Borovskaya railway station
    {Coordinate{39.8724, 52.4352}, CountryId{"RU"}}, // Q110271378
    {Coordinate{39.7434, 52.1082}, CountryId{"RU"}}, // Q110271379
    {Coordinate{39.6956, 52.0229}, CountryId{"RU"}}, // Q110271380
    {Coordinate{39.3724, 51.9072}, CountryId{"RU"}}, // Q110271622
    {Coordinate{39.5692, 51.8951}, CountryId{"RU"}}, // Q110271693
    {Coordinate{39.4799, 51.9034}, CountryId{"RU"}}, // Q110271694
    {Coordinate{39.4567, 51.9061}, CountryId{"RU"}}, // Q110271695
    {Coordinate{39.4062, 51.9092}, CountryId{"RU"}}, // Q110271696
    {Coordinate{39.277, 51.7016}, CountryId{"RU"}}, // Q110272080
    {Coordinate{39.2698, 51.6686}, CountryId{"RU"}}, // Q110272081
    {Coordinate{39.2508, 51.5976}, CountryId{"RU"}}, // Q110272082
    {Coordinate{39.2461, 51.5612}, CountryId{"RU"}}, // Q110272083
    {Coordinate{39.2438, 51.5422}, CountryId{"RU"}}, // Q110272084
    {Coordinate{39.2408, 51.5055}, CountryId{"RU"}}, // Q110272085
    {Coordinate{39.241, 51.4809}, CountryId{"RU"}}, // Q110272087
    {Coordinate{39.2334, 51.4506}, CountryId{"RU"}}, // Q110272088
    {Coordinate{39.2368, 51.426}, CountryId{"RU"}}, // Q110272090
    {Coordinate{39.2639, 51.3926}, CountryId{"RU"}}, // Q110272091
    {Coordinate{39.3174, 51.3274}, CountryId{"RU"}}, // Q110272092
    {Coordinate{39.3366, 51.2825}, CountryId{"RU"}}, // Q110272093
    {Coordinate{39.3522, 51.2462}, CountryId{"RU"}}, // Q110272094
    {Coordinate{39.422, 51.1565}, CountryId{"RU"}}, // Q110272095
    {Coordinate{39.4864, 51.0575}, CountryId{"RU"}}, // Bodeevo
    {Coordinate{39.5066, 51.0203}, CountryId{"RU"}}, // Q110272097
    {Coordinate{39.5091, 50.9921}, CountryId{"RU"}}, // Q110272098
    {Coordinate{15.6117, 48.0399}, CountryId{"AT"}}, // Traisen Markt railway station
    {Coordinate{12.2931, 50.2597}, CountryId{"DE"}}, // Raun railway stop
    {Coordinate{12.2827, 50.2752}, CountryId{"DE"}}, // Sohl railway stop
    {Coordinate{12.0761, 50.4276}, CountryId{"DE"}}, // Pirk railway stop
    {Coordinate{12.0697, 50.4626}, CountryId{"DE"}}, // Kürbitz railway stop
    {Coordinate{12.0921, 50.4801}, CountryId{"DE"}}, // Plauen (Vogtl)-Straßberg railway stop
    {Coordinate{12.0858, 50.5441}, CountryId{"DE"}}, // Syrau
    {Coordinate{12.1398, 50.5376}, CountryId{"DE"}}, // Jößnitz
    {Coordinate{12.17, 50.5552}, CountryId{"DE"}}, // Jocketa
    {Coordinate{12.1763, 50.575}, CountryId{"DE"}}, // Ruppertsgrün
    {Coordinate{12.2533, 50.5871}, CountryId{"DE"}}, // Limbach (Vogtl)
    {Coordinate{12.3821, 50.5193}, CountryId{"DE"}}, // Auerbach (V) ob Bf railway stop
    {Coordinate{12.3793, 50.507}, CountryId{"DE"}}, // Auerbach(Vogtl) Hp
    {Coordinate{12.3846, 50.4881}, CountryId{"DE"}}, // Ellefeld railway stop
    {Coordinate{12.3915, 50.5117}, CountryId{"DE"}}, // Auerbach(V) unt Bf
    {Coordinate{12.3432, 50.3958}, CountryId{"DE"}}, // Schöneck (Vogtl) railway stop
    {Coordinate{12.1477, 50.4929}, CountryId{"DE"}}, // Plauen Mitte railway stop
    {Coordinate{12.1599, 50.6051}, CountryId{"DE"}}, // Elsterberg Kunstseidenwerk railway stop
    {Coordinate{12.1589, 50.7473}, CountryId{"DE"}}, // Berga (Elster) station
    {Coordinate{40.5854, 52.1118}, CountryId{"RU"}}, // Q110280003
    {Coordinate{41.5811, 51.6843}, CountryId{"RU"}}, // Q110280007
    {Coordinate{41.6455, 51.6076}, CountryId{"RU"}}, // Q110280009
    {Coordinate{41.7885, 51.5836}, CountryId{"RU"}}, // Q110280010
    {Coordinate{41.8061, 51.5695}, CountryId{"RU"}}, // Q110280011
    {Coordinate{41.9288, 51.4483}, CountryId{"RU"}}, // Q110280012
    {Coordinate{42.0403, 51.3544}, CountryId{"RU"}}, // Q110280013
    {Coordinate{42.0915, 51.3569}, CountryId{"RU"}}, // Q110280014
    {Coordinate{42.1244, 51.3585}, CountryId{"RU"}}, // Q110280015
    {Coordinate{42.1991, 51.3528}, CountryId{"RU"}}, // Q110280017
    {Coordinate{42.2281, 51.3317}, CountryId{"RU"}}, // Q110280018
    {Coordinate{42.2389, 51.2686}, CountryId{"RU"}}, // Q110280019
    {Coordinate{42.2384, 51.2415}, CountryId{"RU"}}, // Q110280020
    {Coordinate{42.2458, 51.2246}, CountryId{"RU"}}, // Q110280022
    {Coordinate{10.689, 53.8305}, CountryId{"DE"}}, // Lübeck Hochschulstadtteil station
    {Coordinate{34.6909, 56.4867}, CountryId{"RU"}}, // Zarubino
    {Coordinate{34.5671, 56.4191}, CountryId{"RU"}}, // Panino
    {Coordinate{12.3953, 50.5287}, CountryId{"DE"}}, // Rodewisch railway stop
    {Coordinate{19.0911, 47.4908}, CountryId{"HU"}}, // Józsefváros railway station
    {Coordinate{41.7634, 51.0792}, CountryId{"RU"}}, // Q110288688
    {Coordinate{42.2111, 51.2021}, CountryId{"RU"}}, // Q110289794
    {Coordinate{42.1766, 51.1923}, CountryId{"RU"}}, // Q110289795
    {Coordinate{42.0681, 51.1631}, CountryId{"RU"}}, // Q110289796
    {Coordinate{41.6862, 51.0606}, CountryId{"RU"}}, // Q110289798
    {Coordinate{41.6642, 51.0616}, CountryId{"RU"}}, // Q110289799
    {Coordinate{41.631, 51.0613}, CountryId{"RU"}}, // Q110289801
    {Coordinate{41.4751, 51.1379}, CountryId{"RU"}}, // Q110289802
    {Coordinate{41.3797, 51.1312}, CountryId{"RU"}}, // Q110289803
    {Coordinate{41.3329, 51.129}, CountryId{"RU"}}, // Q110289804
    {Coordinate{41.2672, 51.1497}, CountryId{"RU"}}, // Q110289805
    {Coordinate{41.2311, 51.1598}, CountryId{"RU"}}, // Q110289806
    {Coordinate{41.1673, 51.1722}, CountryId{"RU"}}, // Q110289807
    {Coordinate{41.1157, 51.1843}, CountryId{"RU"}}, // Q110289808
    {Coordinate{41.069, 51.1748}, CountryId{"RU"}}, // Q110289809
    {Coordinate{41.0133, 51.1845}, CountryId{"RU"}}, // Abramovka railway station
    {Coordinate{40.9317, 51.1747}, CountryId{"RU"}}, // Q110289811
    {Coordinate{40.8861, 51.1622}, CountryId{"RU"}}, // Q110289812
    {Coordinate{40.68, 51.1129}, CountryId{"RU"}}, // Q110289813
    {Coordinate{40.6083, 51.1092}, CountryId{"RU"}}, // Q110289814
    {Coordinate{40.5662, 51.1086}, CountryId{"RU"}}, // Q110289815
    {Coordinate{40.5357, 51.1094}, CountryId{"RU"}}, // Q110289817
    {Coordinate{40.4812, 51.1149}, CountryId{"RU"}}, // Q110289818
    {Coordinate{40.4445, 51.1209}, CountryId{"RU"}}, // Q110289819
    {Coordinate{40.3795, 51.1184}, CountryId{"RU"}}, // Q110289820
    {Coordinate{40.2619, 51.1179}, CountryId{"RU"}}, // Q110289821
    {Coordinate{40.0977, 51.1179}, CountryId{"RU"}}, // Q110289822
    {Coordinate{39.7925, 51.0569}, CountryId{"RU"}}, // Q110289823
    {Coordinate{39.5612, 51.0374}, CountryId{"RU"}}, // Q110289824
    {Coordinate{39.5285, 51.0256}, CountryId{"RU"}}, // Q110289825
    {Coordinate{39.5102, 50.9899}, CountryId{"RU"}}, // Q110289826
    {Coordinate{34.4488, 56.3404}, CountryId{"RU"}}, // Yesipovskaya
    {Coordinate{43.7892, 52.2397}, CountryId{"RU"}}, // Q110295056
    {Coordinate{43.7737, 52.229}, CountryId{"RU"}}, // Q110295057
    {Coordinate{43.756, 52.223}, CountryId{"RU"}}, // Q110295058
    {Coordinate{43.6641, 52.1028}, CountryId{"RU"}}, // Q110295059
    {Coordinate{43.5948, 52.0618}, CountryId{"RU"}}, // Q110295060
    {Coordinate{43.5666, 52.044}, CountryId{"RU"}}, // Q110295061
    {Coordinate{43.5241, 52.0221}, CountryId{"RU"}}, // Q110295062
    {Coordinate{43.5105, 51.9848}, CountryId{"RU"}}, // Q110295063
    {Coordinate{43.4375, 51.9183}, CountryId{"RU"}}, // Q110295064
    {Coordinate{43.4009, 51.9193}, CountryId{"RU"}}, // Q110295065
    {Coordinate{43.2729, 51.8238}, CountryId{"RU"}}, // Q110295066
    {Coordinate{43.2168, 51.7865}, CountryId{"RU"}}, // Q110295067
    {Coordinate{43.1492, 51.7489}, CountryId{"RU"}}, // Q110295068
    {Coordinate{43.1114, 51.6743}, CountryId{"RU"}}, // Q110295069
    {Coordinate{43.111, 51.6448}, CountryId{"RU"}}, // Krasnaya Zarya railway station
    {Coordinate{43.1159, 51.5997}, CountryId{"RU"}}, // Q110295071
    {Coordinate{44.9259, 53.1027}, CountryId{"RU"}}, // Q110306215
    {Coordinate{44.8914, 53.0744}, CountryId{"RU"}}, // Q110306216
    {Coordinate{44.8652, 53.0466}, CountryId{"RU"}}, // Q110306217
    {Coordinate{44.8407, 52.9726}, CountryId{"RU"}}, // Q110306218
    {Coordinate{44.8054, 52.9065}, CountryId{"RU"}}, // Q110306219
    {Coordinate{44.7569, 52.8754}, CountryId{"RU"}}, // Q110306220
    {Coordinate{44.7288, 52.8214}, CountryId{"RU"}}, // Q110306221
    {Coordinate{44.6802, 52.7877}, CountryId{"RU"}}, // Q110306222
    {Coordinate{44.6382, 52.7714}, CountryId{"RU"}}, // Q110306223
    {Coordinate{44.6088, 52.7601}, CountryId{"RU"}}, // Q110306224
    {Coordinate{44.5711, 52.7406}, CountryId{"RU"}}, // Q110306225
    {Coordinate{44.4867, 52.6835}, CountryId{"RU"}}, // Q110306226
    {Coordinate{44.4882, 52.6659}, CountryId{"RU"}}, // Q110306227
    {Coordinate{44.371, 52.5587}, CountryId{"RU"}}, // Q110306228
    {Coordinate{44.3195, 52.5117}, CountryId{"RU"}}, // Q110306229
    {Coordinate{44.3043, 52.5016}, CountryId{"RU"}}, // Q110306230
    {Coordinate{44.2785, 52.4845}, CountryId{"RU"}}, // Q110306231
    {Coordinate{44.2486, 52.4739}, CountryId{"RU"}}, // Q110306232
    {Coordinate{44.2102, 52.4884}, CountryId{"RU"}}, // Q110306234
    {Coordinate{44.1732, 52.442}, CountryId{"RU"}}, // Q110306235
    {Coordinate{44.0314, 52.3251}, CountryId{"RU"}}, // Q110306236
    {Coordinate{43.9669, 52.2671}, CountryId{"RU"}}, // Q110306237
    {Coordinate{43.9176, 52.2605}, CountryId{"RU"}}, // Q110306238
    {Coordinate{43.8525, 52.2321}, CountryId{"RU"}}, // Q110306239
    {Coordinate{34.308, 56.1832}, CountryId{"RU"}}, // 147 km
    {Coordinate{34.3149, 56.1461}, CountryId{"RU"}}, // Rozhdestveno
    {Coordinate{35.3702, 56.05}, CountryId{"RU"}}, // 165 km
    {Coordinate{35.3237, 56.0561}, CountryId{"RU"}}, // 167 km
    {Coordinate{44.8164, 51.9801}, CountryId{"RU"}}, // Q110319182
    {Coordinate{28.5486, 56.3146}, CountryId{"RU"}}, // Kuznetsovka
    {Coordinate{28.2484, 56.3418}, CountryId{"RU"}}, // Posin'
    {Coordinate{60.0917, 57.6384}, CountryId{"RU"}}, // Tavolgi
    {Coordinate{81.217, 51.5376}, CountryId{"RU"}}, // Q110319418
    {Coordinate{81.2261, 51.5516}, CountryId{"RU"}}, // Q110319419
    {Coordinate{81.192, 51.4995}, CountryId{"RU"}}, // Q110319420
    {Coordinate{31.0286, 59.7925}, CountryId{"RU"}}, // Q110319495
    {Coordinate{31.0298, 59.7793}, CountryId{"RU"}}, // Q110319496
    {Coordinate{59.9266, 58.4731}, CountryId{"RU"}}, // Q110319556
    {Coordinate{12.4432, 50.6514}, CountryId{"DE"}}, // Ebersbrunn railway stop
    {Coordinate{11.7144, 50.7243}, CountryId{"DE"}}, // Neunhofen
    {Coordinate{11.6508, 50.7059}, CountryId{"DE"}}, // Oppurg
    {Coordinate{11.5881, 50.6903}, CountryId{"DE"}}, // Pößneck ob Bf
    {Coordinate{11.5924, 50.7308}, CountryId{"DE"}}, // Langenorla Ost railway stop
    {Coordinate{11.5798, 50.7419}, CountryId{"DE"}}, // Langenorla West railway stop
    {Coordinate{11.5401, 50.7714}, CountryId{"DE"}}, // Freienorla railway stop
    {Coordinate{11.6094, 50.8515}, CountryId{"DE"}}, // Rothenstein (Saale) station
    {Coordinate{12.2411, 51.166}, CountryId{"DE"}}, // Pegau
    {Coordinate{12.2713, 51.2084}, CountryId{"DE"}}, // Zwenkau-Großdalzig
    {Coordinate{12.3091, 51.2781}, CountryId{"DE"}}, // Leipzig-Knauthain
    {Coordinate{13.2401, 51.2703}, CountryId{"DE"}}, // Seerhausen railway stop
    {Coordinate{13.2119, 51.2429}, CountryId{"DE"}}, // Stauchitz station
    {Coordinate{13.1665, 51.2006}, CountryId{"DE"}}, // Ostrau station
    {Coordinate{13.1567, 51.1688}, CountryId{"DE"}}, // Zschaitz railway stop
    {Coordinate{13.4075, 49.7349}, CountryId{"CZ"}}, // Q110335606
    {Coordinate{13.023, 51.1038}, CountryId{"DE"}}, // Steina station
    {Coordinate{12.943, 51.0089}, CountryId{"DE"}}, // Erlau (Sachs)
    {Coordinate{12.9597, 50.969}, CountryId{"DE"}}, // Altmittweida railway stop
    {Coordinate{12.953, 50.9347}, CountryId{"DE"}}, // Ottendorf (b Mittweida) station
    {Coordinate{12.9592, 50.9081}, CountryId{"DE"}}, // Oberlichtenau railway stop
    {Coordinate{12.848, 51.1616}, CountryId{"DE"}}, // Tanndorf railway stop
    {Coordinate{12.9382, 51.1602}, CountryId{"DE"}}, // Leisnig railway station
    {Coordinate{13.0039, 51.1577}, CountryId{"DE"}}, // Klosterbuch railway stop
    {Coordinate{13.028, 51.1376}, CountryId{"DE"}}, // Westewitz-Hochweitzschen railway stop
    {Coordinate{12.4979, 50.7041}, CountryId{"DE"}}, // Zwickau Stadthalle
    {Coordinate{11.9553, 50.4761}, CountryId{"DE"}}, // Reuth (b Plauen/Vogtl)
    {Coordinate{11.9438, 50.4324}, CountryId{"DE"}}, // Grobau
    {Coordinate{11.6246, 50.4697}, CountryId{"DE"}}, // Unterlemnitz
    {Coordinate{11.4478, 50.5649}, CountryId{"DE"}}, // Leutenberg
    {Coordinate{11.4343, 50.5978}, CountryId{"DE"}}, // Hockeroda
    {Coordinate{11.4337, 50.6114}, CountryId{"DE"}}, // Kaulsdorf (Saale)
    {Coordinate{11.3921, 50.5804}, CountryId{"DE"}}, // Unterloquitz
    {Coordinate{11.406, 50.6164}, CountryId{"DE"}}, // Breternitz
    {Coordinate{11.4351, 50.6593}, CountryId{"DE"}}, // Unterwellenborn
    {Coordinate{11.4871, 50.6602}, CountryId{"DE"}}, // Könitz (Thür)
    {Coordinate{11.5434, 50.6771}, CountryId{"DE"}}, // Krölpa-Ranis
    {Coordinate{12.0127, 51.0084}, CountryId{"DE"}}, // Wetterzeube
    {Coordinate{12.0477, 50.9165}, CountryId{"DE"}}, // Gera-Langenberg
    {Coordinate{16.2179, 50.7275}, CountryId{"PL"}}, // Q110390570
    {Coordinate{35.0679, 56.1083}, CountryId{"RU"}}, // Obovrazhiye
    {Coordinate{24.8142, 59.065}, CountryId{"EE"}}, // Q11039999
    {Coordinate{9.47092, 49.4573}, CountryId{"DE"}}, // Q110401045
    {Coordinate{34.7952, 56.1372}, CountryId{"RU"}}, // Kurkovo
    {Coordinate{34.6644, 56.1493}, CountryId{"RU"}}, // Bartenevo
    {Coordinate{11.1707, 50.6895}, CountryId{"DE"}}, // Rottenbach station
    {Coordinate{11.106, 50.7011}, CountryId{"DE"}}, // Paulinzella railway stop
    {Coordinate{11.0709, 50.767}, CountryId{"DE"}}, // Stadtilm station
    {Coordinate{11.0386, 50.7755}, CountryId{"DE"}}, // Niederwillingen railway stop
    {Coordinate{11.0101, 50.8193}, CountryId{"DE"}}, // Marlishausen railway stop
    {Coordinate{34.4603, 56.1926}, CountryId{"RU"}}, // Aristovo
    {Coordinate{12.4, 50.3511}, CountryId{"DE"}}, // Zwota-Zechenbach
    {Coordinate{12.4278, 50.3526}, CountryId{"DE"}}, // Zwota
    {Coordinate{24.7011, 59.3381}, CountryId{"EE"}}, // Männiku railway halt
    {Coordinate{24.6767, 59.2736}, CountryId{"EE"}}, // Kasemetsa railway station
    {Coordinate{14.1621, 51.6065}, CountryId{"DE"}}, // Bahnhof Neupetershain
    {Coordinate{9.13711, 49.3169}, CountryId{"DE"}}, // Q110440796
    {Coordinate{10.9135, 47.4102}, CountryId{"AT"}}, // Ehrwald Zugspitzbahn train station
    {Coordinate{25.1444, 58.8341}, CountryId{"EE"}}, // Käru railway station
    {Coordinate{24.6961, 59.2205}, CountryId{"EE"}}, // Q11048360
    {Coordinate{24.744, 59.1705}, CountryId{"EE"}}, // Kohila railway station
    {Coordinate{25.5185, 58.7247}, CountryId{"EE"}}, // Q11049439
    {Coordinate{34.2286, 56.2329}, CountryId{"RU"}}, // Muravyovo
    {Coordinate{34.1137, 56.2242}, CountryId{"RU"}}, // Mohchalovo
    {Coordinate{33.7955, 56.1958}, CountryId{"RU"}}, // Loshaki
    {Coordinate{24.8988, 58.9427}, CountryId{"EE"}}, // Keava railway station
    {Coordinate{37.9055, 51.2246}, CountryId{"RU"}}, // Q110523166
    {Coordinate{37.9095, 51.2068}, CountryId{"RU"}}, // Q110523169
    {Coordinate{37.9109, 51.1835}, CountryId{"RU"}}, // Q110523172
    {Coordinate{37.9086, 51.1521}, CountryId{"RU"}}, // Q110523175
    {Coordinate{37.8986, 51.1141}, CountryId{"RU"}}, // Q110523177
    {Coordinate{37.8881, 51.0684}, CountryId{"RU"}}, // Q110523180
    {Coordinate{37.8733, 51.033}, CountryId{"RU"}}, // Q110523182
    {Coordinate{37.8232, 50.9749}, CountryId{"RU"}}, // Q110523185
    {Coordinate{37.815, 50.9424}, CountryId{"RU"}}, // Q110523186
    {Coordinate{37.8236, 50.8488}, CountryId{"RU"}}, // Q110523187
    {Coordinate{37.8546, 50.8217}, CountryId{"RU"}}, // Q110523188
    {Coordinate{37.87, 50.7608}, CountryId{"RU"}}, // Q110523189
    {Coordinate{37.829, 50.7037}, CountryId{"RU"}}, // Q110523192
    {Coordinate{37.794, 50.6677}, CountryId{"RU"}}, // Q110523193
    {Coordinate{37.81, 50.6424}, CountryId{"RU"}}, // Q110523194
    {Coordinate{37.8081, 50.6173}, CountryId{"RU"}}, // Q110523195
    {Coordinate{37.8043, 50.5645}, CountryId{"RU"}}, // Q110523196
    {Coordinate{37.8173, 50.5447}, CountryId{"RU"}}, // Q110523198
    {Coordinate{37.8247, 50.5095}, CountryId{"RU"}}, // Q110523199
    {Coordinate{37.8535, 50.4915}, CountryId{"RU"}}, // Q110523200
    {Coordinate{37.8451, 50.4243}, CountryId{"RU"}}, // Q110523201
    {Coordinate{37.861, 50.3852}, CountryId{"RU"}}, // Q110523202
    {Coordinate{37.908, 50.3454}, CountryId{"RU"}}, // Q110523204
    {Coordinate{37.9528, 50.3115}, CountryId{"RU"}}, // Q110523205
    {Coordinate{37.9834, 50.2887}, CountryId{"RU"}}, // Q110523207
    {Coordinate{38.0154, 50.2627}, CountryId{"RU"}}, // Q110523208
    {Coordinate{38.0689, 50.2247}, CountryId{"RU"}}, // Q110523209
    {Coordinate{38.0831, 50.2029}, CountryId{"RU"}}, // Q110523210
    {Coordinate{12.7869, 50.5197}, CountryId{"DE"}}, // Erla railway stop
    {Coordinate{33.668, 56.1931}, CountryId{"RU"}}, // Makherovo
    {Coordinate{33.4879, 56.2045}, CountryId{"RU"}}, // Olenino
    {Coordinate{33.2866, 56.2207}, CountryId{"RU"}}, // Ilmanovka
    {Coordinate{6.81282, 47.0914}, CountryId{"CH"}}, // La Chaux-de-Fonds Les Forges railway station
    {Coordinate{38.1135, 50.172}, CountryId{"RU"}}, // Q110529504
    {Coordinate{0.0236111, 45.2206}, CountryId{"FR"}}, // Q110532619
    {Coordinate{7.63381, 48.9524}, CountryId{"FR"}}, // Gare de Niederbronn
    {Coordinate{39.5125, 50.9546}, CountryId{"RU"}}, // Q110539524
    {Coordinate{39.5001, 50.9621}, CountryId{"RU"}}, // Q110539526
    {Coordinate{39.46, 50.9653}, CountryId{"RU"}}, // Q110539527
    {Coordinate{39.425, 50.9685}, CountryId{"RU"}}, // Q110539529
    {Coordinate{39.4063, 50.976}, CountryId{"RU"}}, // Q110539531
    {Coordinate{39.3656, 50.9892}, CountryId{"RU"}}, // Q110539532
    {Coordinate{39.3144, 50.9795}, CountryId{"RU"}}, // Q110539533
    {Coordinate{39.2924, 50.966}, CountryId{"RU"}}, // Q110539535
    {Coordinate{39.2501, 50.9449}, CountryId{"RU"}}, // Q110539536
    {Coordinate{39.2179, 50.9143}, CountryId{"RU"}}, // Q110539537
    {Coordinate{39.1762, 50.8817}, CountryId{"RU"}}, // Q110539538
    {Coordinate{39.1543, 50.8592}, CountryId{"RU"}}, // Q110539540
    {Coordinate{39.0575, 50.8121}, CountryId{"RU"}}, // Q110539542
    {Coordinate{38.9805, 50.7657}, CountryId{"RU"}}, // Q110539544
    {Coordinate{38.9232, 50.7473}, CountryId{"RU"}}, // Q110539545
    {Coordinate{38.8982, 50.7103}, CountryId{"RU"}}, // Q110539546
    {Coordinate{38.8704, 50.6707}, CountryId{"RU"}}, // Q110539548
    {Coordinate{38.8314, 50.6434}, CountryId{"RU"}}, // Q110539549
    {Coordinate{38.6338, 50.6245}, CountryId{"RU"}}, // Q110539550
    {Coordinate{38.5865, 50.63}, CountryId{"RU"}}, // Q110539552
    {Coordinate{38.5557, 50.6078}, CountryId{"RU"}}, // Q110539554
    {Coordinate{38.5353, 50.5605}, CountryId{"RU"}}, // Q110539555
    {Coordinate{38.473, 50.5565}, CountryId{"RU"}}, // Q110539556
    {Coordinate{38.4218, 50.5296}, CountryId{"RU"}}, // Q110539558
    {Coordinate{38.3919, 50.5106}, CountryId{"RU"}}, // Q110539559
    {Coordinate{38.3572, 50.4928}, CountryId{"RU"}}, // Q110539560
    {Coordinate{38.2993, 50.4416}, CountryId{"RU"}}, // Q110539562
    {Coordinate{38.2678, 50.3839}, CountryId{"RU"}}, // Q110539563
    {Coordinate{38.256, 50.3033}, CountryId{"RU"}}, // Q110539565
    {Coordinate{38.2352, 50.2595}, CountryId{"RU"}}, // Q110539566
    {Coordinate{38.2219, 50.2462}, CountryId{"RU"}}, // Q110539568
    {Coordinate{38.1883, 50.2223}, CountryId{"RU"}}, // Q110539569
    {Coordinate{38.1518, 50.2102}, CountryId{"RU"}}, // Q110539570
    {Coordinate{38.1068, 50.1795}, CountryId{"RU"}}, // Q110539572
    {Coordinate{33.1431, 56.2195}, CountryId{"RU"}}, // Mostovaya
    {Coordinate{32.9535, 56.2285}, CountryId{"RU"}}, // Paniklya
    {Coordinate{-0.53357, 44.8772}, CountryId{"FR"}}, // Q110549900
    {Coordinate{32.5828, 56.2299}, CountryId{"RU"}}, // Podsosenka
    {Coordinate{32.3788, 56.2455}, CountryId{"RU"}}, // Zemtsy
    {Coordinate{32.2363, 56.2674}, CountryId{"RU"}}, // Zamoshye
    {Coordinate{32.0738, 56.2624}, CountryId{"RU"}}, // Zapadnaya Dvina station
    {Coordinate{39.9731, 49.6061}, CountryId{"RU"}}, // Q110561171
    {Coordinate{8.06476, 48.345}, CountryId{"DE"}}, // Zell am Harmersbach railway station
    {Coordinate{8.07975, 48.3494}, CountryId{"DE"}}, // Birach station
    {Coordinate{8.08995, 48.3541}, CountryId{"DE"}}, // Unterharmersbach station
    {Coordinate{8.10563, 48.3619}, CountryId{"DE"}}, // Kirnbach-Grün station
    {Coordinate{142.853, 49.3891}, CountryId{"RU"}}, // Vozvrashcheniye railway station
    {Coordinate{16.8265, 48.3847}, CountryId{"AT"}}, // Angern an der March railway station
    {Coordinate{31.9477, 56.2847}, CountryId{"RU"}}, // Ulin
    {Coordinate{39.5017, 50.95}, CountryId{"RU"}}, // Q110577158
    {Coordinate{39.4871, 50.9466}, CountryId{"RU"}}, // Q110577159
    {Coordinate{39.445, 50.9474}, CountryId{"RU"}}, // Q110577160
    {Coordinate{39.3915, 50.8814}, CountryId{"RU"}}, // Q110577161
    {Coordinate{39.4181, 50.8551}, CountryId{"RU"}}, // Q110577162
    {Coordinate{39.47, 50.7975}, CountryId{"RU"}}, // Q110577164
    {Coordinate{39.4348, 50.7737}, CountryId{"RU"}}, // Q110577165
    {Coordinate{39.3888, 50.7508}, CountryId{"RU"}}, // Q110577166
    {Coordinate{39.4883, 50.6783}, CountryId{"RU"}}, // Q110577167
    {Coordinate{39.5539, 50.6745}, CountryId{"RU"}}, // Q110577168
    {Coordinate{39.6262, 50.6584}, CountryId{"RU"}}, // Q110577170
    {Coordinate{39.6141, 50.6023}, CountryId{"RU"}}, // Q110577171
    {Coordinate{39.6163, 50.5716}, CountryId{"RU"}}, // Q110577172
    {Coordinate{39.6543, 50.5089}, CountryId{"RU"}}, // Q110577173
    {Coordinate{39.6484, 50.4823}, CountryId{"RU"}}, // Q110577174
    {Coordinate{39.6431, 50.45}, CountryId{"RU"}}, // Q110577175
    {Coordinate{39.6298, 50.3404}, CountryId{"RU"}}, // Q110577176
    {Coordinate{39.6277, 50.3157}, CountryId{"RU"}}, // Q110577177
    {Coordinate{39.6167, 50.2823}, CountryId{"RU"}}, // Q110577178
    {Coordinate{39.5927, 50.2567}, CountryId{"RU"}}, // Q110577179
    {Coordinate{39.5877, 50.2336}, CountryId{"RU"}}, // Q110577180
    {Coordinate{39.5887, 50.2092}, CountryId{"RU"}}, // Q110577181
    {Coordinate{39.6123, 50.152}, CountryId{"RU"}}, // Q110577182
    {Coordinate{39.6176, 50.1362}, CountryId{"RU"}}, // Q110577183
    {Coordinate{39.6208, 50.1193}, CountryId{"RU"}}, // Q110577184
    {Coordinate{39.6274, 50.0997}, CountryId{"RU"}}, // Q110577185
    {Coordinate{39.6249, 50.0841}, CountryId{"RU"}}, // Q110577186
    {Coordinate{39.6627, 50.0536}, CountryId{"RU"}}, // Raynovskaya railway station
    {Coordinate{39.6924, 49.9849}, CountryId{"RU"}}, // Q110577188
    {Coordinate{39.7232, 49.9285}, CountryId{"RU"}}, // Q110577190
    {Coordinate{39.7399, 49.8973}, CountryId{"RU"}}, // Q110577191
    {Coordinate{39.7301, 49.8617}, CountryId{"RU"}}, // Q110577192
    {Coordinate{39.7735, 49.8046}, CountryId{"RU"}}, // Q110577193
    {Coordinate{39.839, 49.7673}, CountryId{"RU"}}, // Q110577194
    {Coordinate{39.8544, 49.7293}, CountryId{"RU"}}, // Q110577195
    {Coordinate{8.23682, 51.8801}, CountryId{"DE"}}, // Herzebrock station
    {Coordinate{7.27637, 47.7581}, CountryId{"FR"}}, // Lutterbach Gare
    {Coordinate{41.5967, 52.7051}, CountryId{"RU"}}, // Q110602368
    {Coordinate{31.7776, 56.2894}, CountryId{"RU"}}, // Barsovo
    {Coordinate{31.6666, 56.2797}, CountryId{"RU"}}, // Staraya Toropa
    {Coordinate{31.5103, 56.2879}, CountryId{"RU"}}, // Rusanovo
    {Coordinate{41.4693, 52.6871}, CountryId{"RU"}}, // Q110623416
    {Coordinate{41.6803, 52.7045}, CountryId{"RU"}}, // Q110623417
    {Coordinate{41.7535, 52.706}, CountryId{"RU"}}, // Q110623418
    {Coordinate{41.855, 52.7083}, CountryId{"RU"}}, // Q110623420
    {Coordinate{42.0068, 52.7197}, CountryId{"RU"}}, // Q110623421
    {Coordinate{42.1265, 52.7063}, CountryId{"RU"}}, // Q110623422
    {Coordinate{42.1952, 52.6849}, CountryId{"RU"}}, // Q110623423
    {Coordinate{42.2761, 52.6665}, CountryId{"RU"}}, // Q110623424
    {Coordinate{42.4598, 52.6388}, CountryId{"RU"}}, // Q110623425
    {Coordinate{42.5333, 52.6568}, CountryId{"RU"}}, // Q110623426
    {Coordinate{42.5743, 52.646}, CountryId{"RU"}}, // Q110623427
    {Coordinate{42.6608, 52.6365}, CountryId{"RU"}}, // Q110623429
    {Coordinate{42.8778, 52.6036}, CountryId{"RU"}}, // Q110623430
    {Coordinate{43.0143, 52.5512}, CountryId{"RU"}}, // Q110623431
    {Coordinate{43.5435, 52.389}, CountryId{"RU"}}, // Q110623432
    {Coordinate{43.8519, 52.23}, CountryId{"RU"}}, // Q110623433
    {Coordinate{42.6288, 52.6357}, CountryId{"RU"}}, // Q110623453
    {Coordinate{31.3494, 56.2815}, CountryId{"RU"}}, // Zhizhitsa
    {Coordinate{41.4408, 52.6473}, CountryId{"RU"}}, // Q110629574
    {Coordinate{41.4464, 52.5878}, CountryId{"RU"}}, // Q110629575
    {Coordinate{41.4527, 52.5748}, CountryId{"RU"}}, // Q110629577
    {Coordinate{41.4692, 52.5365}, CountryId{"RU"}}, // Q110629578
    {Coordinate{41.4952, 52.5124}, CountryId{"RU"}}, // Q110629579
    {Coordinate{41.4915, 52.4641}, CountryId{"RU"}}, // Q110629580
    {Coordinate{41.5129, 52.4306}, CountryId{"RU"}}, // Q110629581
    {Coordinate{41.6744, 52.3779}, CountryId{"RU"}}, // Q110629582
    {Coordinate{41.7722, 52.3303}, CountryId{"RU"}}, // Q110629583
    {Coordinate{41.8217, 52.3114}, CountryId{"RU"}}, // Q110629584
    {Coordinate{41.9527, 52.237}, CountryId{"RU"}}, // Q110629585
    {Coordinate{41.9742, 52.2006}, CountryId{"RU"}}, // Q110629586
    {Coordinate{42.0206, 52.1366}, CountryId{"RU"}}, // Q110629587
    {Coordinate{42.0678, 52.0748}, CountryId{"RU"}}, // Q110629589
    {Coordinate{42.2523, 51.9655}, CountryId{"RU"}}, // Q110629590
    {Coordinate{42.3368, 51.8627}, CountryId{"RU"}}, // Q110629591
    {Coordinate{42.432, 51.8567}, CountryId{"RU"}}, // Q110629592
    {Coordinate{42.48, 51.8477}, CountryId{"RU"}}, // Q110629593
    {Coordinate{42.7425, 51.7483}, CountryId{"RU"}}, // Q110629594
    {Coordinate{44.558, 50.8276}, CountryId{"RU"}}, // Q110629678
    {Coordinate{31.2199, 56.2909}, CountryId{"RU"}}, // 434 km
    {Coordinate{31.1581, 56.2836}, CountryId{"RU"}}, // Artyomovo
    {Coordinate{15.9658, 48.6747}, CountryId{"AT"}}, // Platt station
    {Coordinate{43.2188, 51.5289}, CountryId{"RU"}}, // Q110638035
    {Coordinate{43.356, 51.4378}, CountryId{"RU"}}, // Stepnoye railway station
    {Coordinate{43.3745, 51.408}, CountryId{"RU"}}, // Q110638037
    {Coordinate{43.4245, 51.3224}, CountryId{"RU"}}, // Q110638038
    {Coordinate{43.4647, 51.3154}, CountryId{"RU"}}, // Q110638039
    {Coordinate{43.4647, 51.3154}, CountryId{"RU"}}, // Q110638040
    {Coordinate{43.6978, 51.1604}, CountryId{"RU"}}, // Q110638041
    {Coordinate{43.7278, 51.0536}, CountryId{"RU"}}, // Q110638042
    {Coordinate{43.7885, 50.9585}, CountryId{"RU"}}, // Elan-Kamyshinskaya railway station
    {Coordinate{43.9764, 50.8981}, CountryId{"RU"}}, // Q110638044
    {Coordinate{44.2084, 52.0709}, CountryId{"RU"}}, // Q110640310
    {Coordinate{30.9829, 56.2948}, CountryId{"RU"}}, // Kunya
    {Coordinate{30.8709, 56.3237}, CountryId{"RU"}}, // Tabory
    {Coordinate{45.0985, 51.8392}, CountryId{"RU"}}, // Q110641961
    {Coordinate{45.3338, 51.7359}, CountryId{"RU"}}, // Q110641964
    {Coordinate{45.3933, 51.7174}, CountryId{"RU"}}, // Q110641965
    {Coordinate{45.4088, 51.7115}, CountryId{"RU"}}, // Q110641967
    {Coordinate{45.4335, 51.6993}, CountryId{"RU"}}, // Q110641969
    {Coordinate{45.5179, 51.6779}, CountryId{"RU"}}, // Q110641971
    {Coordinate{45.6134, 51.6693}, CountryId{"RU"}}, // Q110641973
    {Coordinate{45.65, 51.6722}, CountryId{"RU"}}, // Q110641974
    {Coordinate{45.6856, 51.6744}, CountryId{"RU"}}, // Q110641976
    {Coordinate{45.7007, 51.6614}, CountryId{"RU"}}, // Q110641978
    {Coordinate{45.8065, 51.6341}, CountryId{"RU"}}, // Q110641979
    {Coordinate{45.8308, 51.5948}, CountryId{"RU"}}, // Q110641981
    {Coordinate{45.8462, 51.5894}, CountryId{"RU"}}, // Zhasminnaya railway station
    {Coordinate{45.8747, 51.5974}, CountryId{"RU"}}, // Q110641984
    {Coordinate{45.8934, 51.5918}, CountryId{"RU"}}, // Q110641986
    {Coordinate{45.9176, 51.5938}, CountryId{"RU"}}, // Q110641987
    {Coordinate{44.4565, 51.499}, CountryId{"RU"}}, // Q110642463
    {Coordinate{44.9852, 51.7894}, CountryId{"RU"}}, // Q110646796
    {Coordinate{44.9468, 51.7516}, CountryId{"RU"}}, // Q110646797
    {Coordinate{44.8646, 51.6139}, CountryId{"RU"}}, // Q110646798
    {Coordinate{44.8314, 51.5506}, CountryId{"RU"}}, // Q110646800
    {Coordinate{45.9912, 51.5267}, CountryId{"RU"}}, // Q110647038
    {Coordinate{45.9584, 51.5899}, CountryId{"RU"}}, // Q110647114
    {Coordinate{45.9747, 51.5807}, CountryId{"RU"}}, // Q110647115
    {Coordinate{45.9924, 51.5717}, CountryId{"RU"}}, // Q110647116
    {Coordinate{45.9992, 51.5659}, CountryId{"RU"}}, // Q110647117
    {Coordinate{45.9849, 51.5129}, CountryId{"RU"}}, // Q110647190
    {Coordinate{45.9626, 51.5105}, CountryId{"RU"}}, // Q110647191
    {Coordinate{46.8836, 51.2634}, CountryId{"RU"}}, // Q110647493
    {Coordinate{45.9607, 51.5004}, CountryId{"RU"}}, // Q110647716
    {Coordinate{45.9546, 51.4728}, CountryId{"RU"}}, // Q110647717
    {Coordinate{45.9695, 51.4351}, CountryId{"RU"}}, // Q110647718
    {Coordinate{45.9702, 51.4249}, CountryId{"RU"}}, // Q110647719
    {Coordinate{45.9626, 51.4179}, CountryId{"RU"}}, // Q110647720
    {Coordinate{46.0151, 51.4085}, CountryId{"RU"}}, // Q110647726
    {Coordinate{45.9359, 51.5029}, CountryId{"RU"}}, // Q110648128
    {Coordinate{45.9384, 51.4887}, CountryId{"RU"}}, // Q110648130
    {Coordinate{47.5097, 51.2409}, CountryId{"RU"}}, // Q110648171
    {Coordinate{48.526, 51.3173}, CountryId{"RU"}}, // Q110648284
    {Coordinate{48.7568, 51.2414}, CountryId{"RU"}}, // Q110648285
    {Coordinate{49.1232, 51.2018}, CountryId{"RU"}}, // Demyas railway station
    {Coordinate{49.4534, 51.2047}, CountryId{"RU"}}, // Q110648287
    {Coordinate{}, CountryId{"FR"}}, // Q110655300
    {Coordinate{47.0602, 52.1579}, CountryId{"RU"}}, // Q110656837
    {Coordinate{47.2269, 52.1277}, CountryId{"RU"}}, // Q110656838
    {Coordinate{47.3071, 52.087}, CountryId{"RU"}}, // Q110656839
    {Coordinate{47.5272, 52.0819}, CountryId{"RU"}}, // Q110656840
    {Coordinate{47.8066, 51.989}, CountryId{"RU"}}, // Q110656842
    {Coordinate{47.9286, 51.9334}, CountryId{"RU"}}, // Q110656843
    {Coordinate{48.5002, 51.9411}, CountryId{"RU"}}, // Q110656844
    {Coordinate{49.9564, 51.9724}, CountryId{"RU"}}, // Q110657086
    {Coordinate{49.0752, 52.3007}, CountryId{"RU"}}, // Q110657507
    {Coordinate{48.7209, 51.8135}, CountryId{"RU"}}, // Q110657672
    {Coordinate{48.6484, 51.663}, CountryId{"RU"}}, // Q110657674
    {Coordinate{48.5351, 51.5776}, CountryId{"RU"}}, // Q110657675
    {Coordinate{48.7854, 51.9094}, CountryId{"RU"}}, // Q110657685
    {Coordinate{48.4382, 51.5127}, CountryId{"RU"}}, // Q110657686
    {Coordinate{48.3596, 51.4154}, CountryId{"RU"}}, // Q110657687
    {Coordinate{1.73113, 48.3917}, CountryId{"FR"}}, // Category:Gare de Santeuil
    {Coordinate{34.0682, 57.7895}, CountryId{"RU"}}, // 14 km
    {Coordinate{33.9758, 57.7272}, CountryId{"RU"}}, // Kuzhenkino
    {Coordinate{33.8978, 57.6628}, CountryId{"RU"}}, // Shlina
    {Coordinate{33.8556, 57.5967}, CountryId{"RU"}}, // Batalino
    {Coordinate{14.735, 49.2993}, CountryId{"CZ"}}, // Myslkovice
    {Coordinate{33.7828, 57.5323}, CountryId{"RU"}}, // 48 km
    {Coordinate{33.699, 57.4832}, CountryId{"RU"}}, // Firovo
    {Coordinate{12.2525, 53.4203}, CountryId{"DE"}}, // Silbermühle railway station
    {Coordinate{12.2589, 53.5063}, CountryId{"DE"}}, // Plau-Quetzin railway station
    {Coordinate{12.3554, 53.5121}, CountryId{"DE"}}, // Alt Schwerin railway station
    {Coordinate{46.9288, 52.1329}, CountryId{"RU"}}, // Q110728118
    {Coordinate{46.7524, 52.0206}, CountryId{"RU"}}, // Q110728119
    {Coordinate{46.6803, 52.0077}, CountryId{"RU"}}, // Q110728120
    {Coordinate{46.5459, 52.0278}, CountryId{"RU"}}, // Q110728121
    {Coordinate{46.4037, 52.0068}, CountryId{"RU"}}, // Q110728122
    {Coordinate{46.3425, 51.9629}, CountryId{"RU"}}, // Q110728123
    {Coordinate{46.281, 51.9557}, CountryId{"RU"}}, // Q110728125
    {Coordinate{46.2185, 51.8435}, CountryId{"RU"}}, // Q110728126
    {Coordinate{46.1929, 51.8182}, CountryId{"RU"}}, // Q110728127
    {Coordinate{46.1933, 51.7956}, CountryId{"RU"}}, // Q110728128
    {Coordinate{46.2112, 51.778}, CountryId{"RU"}}, // Q110728129
    {Coordinate{46.2128, 51.7515}, CountryId{"RU"}}, // Q110728132
    {Coordinate{46.2126, 51.7433}, CountryId{"RU"}}, // Q110728133
    {Coordinate{46.2061, 51.7316}, CountryId{"RU"}}, // Q110728134
    {Coordinate{46.1899, 51.7225}, CountryId{"RU"}}, // Q110728135
    {Coordinate{46.1467, 51.7196}, CountryId{"RU"}}, // Q110728137
    {Coordinate{46.1182, 51.716}, CountryId{"RU"}}, // Q110728138
    {Coordinate{46.0719, 51.7113}, CountryId{"RU"}}, // Q110728139
    {Coordinate{46.0508, 51.7031}, CountryId{"RU"}}, // Q110728140
    {Coordinate{46.0299, 51.6848}, CountryId{"RU"}}, // Q110728142
    {Coordinate{45.9595, 51.6142}, CountryId{"RU"}}, // Q110728143
    {Coordinate{45.9587, 51.6052}, CountryId{"RU"}}, // Q110728144
    {Coordinate{45.9341, 51.598}, CountryId{"RU"}}, // Q110728145
    {Coordinate{33.5158, 57.3725}, CountryId{"RU"}}, // Gorovastitsa
    {Coordinate{45.9233, 51.4986}, CountryId{"RU"}}, // Q110737989
    {Coordinate{45.9146, 51.4819}, CountryId{"RU"}}, // Q110737991
    {Coordinate{45.9099, 51.4739}, CountryId{"RU"}}, // Q110737993
    {Coordinate{45.88, 51.4616}, CountryId{"RU"}}, // Q110737994
    {Coordinate{45.8433, 51.4487}, CountryId{"RU"}}, // Q110737995
    {Coordinate{45.8253, 51.4494}, CountryId{"RU"}}, // Q110737996
    {Coordinate{45.7964, 51.4415}, CountryId{"RU"}}, // Q110737997
    {Coordinate{45.7165, 51.4228}, CountryId{"RU"}}, // Q110737998
    {Coordinate{45.6894, 51.3934}, CountryId{"RU"}}, // Q110737999
    {Coordinate{45.6797, 51.3626}, CountryId{"RU"}}, // Q110738001
    {Coordinate{45.6778, 51.3444}, CountryId{"RU"}}, // Q110738002
    {Coordinate{45.6504, 51.2932}, CountryId{"RU"}}, // Q110738003
    {Coordinate{45.5753, 51.2509}, CountryId{"RU"}}, // Q110738004
    {Coordinate{45.5355, 51.23}, CountryId{"RU"}}, // Q110738008
    {Coordinate{45.5285, 51.0738}, CountryId{"RU"}}, // Q110738009
    {Coordinate{45.5311, 51.0345}, CountryId{"RU"}}, // Q110738012
    {Coordinate{45.4455, 50.8993}, CountryId{"RU"}}, // Q110738014
    {Coordinate{45.4771, 50.7921}, CountryId{"RU"}}, // Q110738015
    {Coordinate{45.4492, 50.7376}, CountryId{"RU"}}, // Q110738018
    {Coordinate{45.4292, 50.7015}, CountryId{"RU"}}, // Q110738020
    {Coordinate{45.5537, 51.2406}, CountryId{"RU"}}, // Q110738100
    {Coordinate{42.564, 50.7634}, CountryId{"RU"}}, // Q110754809
    {Coordinate{42.6065, 50.6122}, CountryId{"RU"}}, // Q110754811
    {Coordinate{43.6415, 49.7909}, CountryId{"RU"}}, // Q110754813
    {Coordinate{44.71, 50.7823}, CountryId{"RU"}}, // Q110755260
    {Coordinate{44.7476, 50.681}, CountryId{"RU"}}, // Adadurovo railway station
    {Coordinate{45.1329, 50.1813}, CountryId{"RU"}}, // Q110755263
    {Coordinate{45.1437, 50.1722}, CountryId{"RU"}}, // Q110755266
    {Coordinate{33.317, 57.2488}, CountryId{"RU"}}, // Chyornyi Dor
    {Coordinate{33.1938, 57.1675}, CountryId{"RU"}}, // 104 km
    {Coordinate{46.9926, 51.1632}, CountryId{"RU"}}, // Q110755455
    {Coordinate{46.9758, 50.9566}, CountryId{"RU"}}, // Q110755459
    {Coordinate{47.0864, 50.8029}, CountryId{"RU"}}, // Q110756092
    {Coordinate{47.4308, 50.6161}, CountryId{"RU"}}, // Q110756093
    {Coordinate{47.6715, 50.5183}, CountryId{"RU"}}, // Q110756094
    {Coordinate{48.1326, 50.4234}, CountryId{"RU"}}, // Q110756095
    {Coordinate{46.9038, 50.3758}, CountryId{"RU"}}, // Q110763012
    {Coordinate{46.8722, 50.0474}, CountryId{"RU"}}, // Q110763014
    {Coordinate{46.845, 49.7439}, CountryId{"RU"}}, // Kaysatskaya railway station
    {Coordinate{46.8378, 49.1302}, CountryId{"RU"}}, // Q110763017
    {Coordinate{35.3124, 59.1599}, CountryId{"RU"}}, // Chagoda railway station
    {Coordinate{35.2064, 59.0931}, CountryId{"RU"}}, // Ogaryovo railway station
    {Coordinate{33.0198, 57.0821}, CountryId{"RU"}}, // 122 km
    {Coordinate{9.41148, 49.784}, CountryId{"DE"}}, // Stadtprozelten
    {Coordinate{48.0264, 46.7319}, CountryId{"RU"}}, // Q110785744
    {Coordinate{48.0228, 46.6995}, CountryId{"RU"}}, // Q110785745
    {Coordinate{48.0753, 46.547}, CountryId{"RU"}}, // Q110785747
    {Coordinate{48.0781, 46.5255}, CountryId{"RU"}}, // Q110785749
    {Coordinate{48.0756, 46.5148}, CountryId{"RU"}}, // Q110785750
    {Coordinate{48.0681, 46.4652}, CountryId{"RU"}}, // Q110785752
    {Coordinate{48.0716, 46.4431}, CountryId{"RU"}}, // Q110785753
    {Coordinate{48.0723, 46.3343}, CountryId{"RU"}}, // Q110796767
    {Coordinate{48.0095, 46.3276}, CountryId{"RU"}}, // Q110796768
    {Coordinate{47.988, 46.3385}, CountryId{"RU"}}, // Q110796769
    {Coordinate{47.5916, 46.2992}, CountryId{"RU"}}, // Q110796770
    {Coordinate{47.4148, 46.2585}, CountryId{"RU"}}, // Q110796771
    {Coordinate{47.2976, 46.1989}, CountryId{"RU"}}, // Q110796773
    {Coordinate{47.1764, 46.1356}, CountryId{"RU"}}, // Q110796774
    {Coordinate{47.1128, 46.0491}, CountryId{"RU"}}, // Q110796775
    {Coordinate{47.0485, 45.9341}, CountryId{"RU"}}, // Q110796777
    {Coordinate{46.95, 45.6908}, CountryId{"RU"}}, // Q110796778
    {Coordinate{-0.998217, 44.6233}, CountryId{"FR"}}, // Gare de Lamothe
    {Coordinate{44.0533, 49.1847}, CountryId{"RU"}}, // Q110800719
    {Coordinate{44.0891, 49.0538}, CountryId{"RU"}}, // Q110800720
    {Coordinate{44.0986, 49.0446}, CountryId{"RU"}}, // Q110800721
    {Coordinate{44.5111, 48.7683}, CountryId{"RU"}}, // Q110807351
    {Coordinate{32.4412, 56.7691}, CountryId{"RU"}}, // Okhvat
    {Coordinate{44.5766, 48.7764}, CountryId{"RU"}}, // Barrikady railway station
    {Coordinate{32.3572, 56.6991}, CountryId{"RU"}}, // 183 km
    {Coordinate{32.2634, 56.6463}, CountryId{"RU"}}, // Andreapol
    {Coordinate{44.5269, 48.7701}, CountryId{"RU"}}, // Q110808779
    {Coordinate{44.4232, 48.6954}, CountryId{"RU"}}, // Q110811479
    {Coordinate{44.4046, 48.6952}, CountryId{"RU"}}, // Q110811482
    {Coordinate{44.4517, 48.6555}, CountryId{"RU"}}, // Q110815148
    {Coordinate{44.4442, 48.6434}, CountryId{"RU"}}, // Q110815149
    {Coordinate{44.4354, 48.6252}, CountryId{"RU"}}, // Q110815150
    {Coordinate{44.4337, 48.6112}, CountryId{"RU"}}, // Q110815151
    {Coordinate{44.434, 48.5986}, CountryId{"RU"}}, // Q110815152
    {Coordinate{44.4485, 48.5713}, CountryId{"RU"}}, // Q110815153
    {Coordinate{44.4599, 48.5574}, CountryId{"RU"}}, // Q110815154
    {Coordinate{44.4756, 48.539}, CountryId{"RU"}}, // Q110815156
    {Coordinate{44.4934, 48.529}, CountryId{"RU"}}, // Q110815157
    {Coordinate{44.5299, 48.5084}, CountryId{"RU"}}, // Q110815158
    {Coordinate{44.5182, 48.475}, CountryId{"RU"}}, // Q110815159
    {Coordinate{44.5015, 48.4523}, CountryId{"RU"}}, // Q110815161
    {Coordinate{44.474, 48.4368}, CountryId{"RU"}}, // Q110815163
    {Coordinate{44.4359, 48.4437}, CountryId{"RU"}}, // Q110815164
    {Coordinate{44.4096, 48.4432}, CountryId{"RU"}}, // Q110815165
    {Coordinate{44.386, 48.4239}, CountryId{"RU"}}, // Q110815166
    {Coordinate{44.2722, 48.2867}, CountryId{"RU"}}, // Q110815167
    {Coordinate{43.6513, 47.9636}, CountryId{"RU"}}, // Q110815170
    {Coordinate{43.4955, 47.84}, CountryId{"RU"}}, // Q110815171
    {Coordinate{44.6707, 48.4808}, CountryId{"RU"}}, // Q110815476
    {Coordinate{44.5267, 48.5122}, CountryId{"RU"}}, // Sudoverf
    {Coordinate{44.5371, 48.5088}, CountryId{"RU"}}, // Q110815577
    {Coordinate{44.5708, 48.5169}, CountryId{"RU"}}, // Q110815578
    {Coordinate{44.5844, 48.5245}, CountryId{"RU"}}, // Q110815579
    {Coordinate{44.6011, 48.5286}, CountryId{"RU"}}, // Q110815580
    {Coordinate{44.6432, 48.4999}, CountryId{"RU"}}, // Q110815583
    {Coordinate{44.6519, 48.4939}, CountryId{"RU"}}, // Q110815585
    {Coordinate{42.6612, 48.6064}, CountryId{"RU"}}, // Q110816390
    {Coordinate{42.8937, 48.6}, CountryId{"RU"}}, // Q110816393
    {Coordinate{42.9857, 48.5454}, CountryId{"RU"}}, // Q110816394
    {Coordinate{43.035, 48.5232}, CountryId{"RU"}}, // Q110816396
    {Coordinate{43.1924, 48.477}, CountryId{"RU"}}, // Q110816397
    {Coordinate{43.2739, 48.4678}, CountryId{"RU"}}, // Q110816398
    {Coordinate{43.3276, 48.4595}, CountryId{"RU"}}, // Q110816399
    {Coordinate{43.3798, 48.44}, CountryId{"RU"}}, // Q110816400
    {Coordinate{43.4977, 48.4937}, CountryId{"RU"}}, // Q110816401
    {Coordinate{43.5799, 48.5688}, CountryId{"RU"}}, // Q110816402
    {Coordinate{43.6106, 48.5982}, CountryId{"RU"}}, // Q110816403
    {Coordinate{43.6325, 48.6099}, CountryId{"RU"}}, // Q110816404
    {Coordinate{43.6524, 48.6163}, CountryId{"RU"}}, // Q110816405
    {Coordinate{43.7189, 48.6338}, CountryId{"RU"}}, // Q110816406
    {Coordinate{43.7828, 48.6595}, CountryId{"RU"}}, // Q110816407
    {Coordinate{43.8269, 48.6718}, CountryId{"RU"}}, // Q110816409
    {Coordinate{43.862, 48.6752}, CountryId{"RU"}}, // Q110816410
    {Coordinate{43.9067, 48.6811}, CountryId{"RU"}}, // Q110816411
    {Coordinate{43.9836, 48.6867}, CountryId{"RU"}}, // Q110816412
    {Coordinate{44.2463, 48.6719}, CountryId{"RU"}}, // Q110816413
    {Coordinate{44.2808, 48.6769}, CountryId{"RU"}}, // Q110816414
    {Coordinate{44.3191, 48.6818}, CountryId{"RU"}}, // Q110816417
    {Coordinate{43.4992, 48.6924}, CountryId{"RU"}}, // Q110816589
    {Coordinate{43.6243, 48.6502}, CountryId{"RU"}}, // Q110816627
    {Coordinate{43.5572, 48.672}, CountryId{"RU"}}, // Q110816628
    {Coordinate{43.5414, 48.6772}, CountryId{"RU"}}, // Q110816629
    {Coordinate{32.0731, 56.5869}, CountryId{"RU"}}, // Gladkiy Log
    {Coordinate{32.0033, 56.5772}, CountryId{"RU"}}, // 210 km
    {Coordinate{45.2127, 48.7237}, CountryId{"RU"}}, // Q110821458
    {Coordinate{45.7525, 48.5891}, CountryId{"RU"}}, // Q110821459
    {Coordinate{45.8123, 48.5604}, CountryId{"RU"}}, // Q110821460
    {Coordinate{46.0073, 48.4873}, CountryId{"RU"}}, // Q110821462
    {Coordinate{31.9094, 56.5741}, CountryId{"RU"}}, // Martisovo
    {Coordinate{31.6477, 56.5141}, CountryId{"RU"}}, // Toropets
    {Coordinate{40.2904, 49.1364}, CountryId{"RU"}}, // Q110830068
    {Coordinate{40.2786, 49.1549}, CountryId{"RU"}}, // Q110830070
    {Coordinate{40.3293, 48.6815}, CountryId{"RU"}}, // Q110831585
    {Coordinate{40.3396, 48.6357}, CountryId{"RU"}}, // Q110831586
    {Coordinate{40.3044, 48.4552}, CountryId{"RU"}}, // Q110831589
    {Coordinate{40.0933, 48.1396}, CountryId{"RU"}}, // Q110833331
    {Coordinate{40.1959, 47.8175}, CountryId{"RU"}}, // Q110844752
    {Coordinate{40.0622, 47.945}, CountryId{"RU"}}, // Q110845101
    {Coordinate{40.141, 47.8806}, CountryId{"RU"}}, // Q110845103
    {Coordinate{40.1861, 47.8667}, CountryId{"RU"}}, // Q110845105
    {Coordinate{40.2179, 47.8547}, CountryId{"RU"}}, // Q110845106
    {Coordinate{40.3114, 47.8605}, CountryId{"RU"}}, // Q110845952
    {Coordinate{40.4446, 47.8498}, CountryId{"RU"}}, // Q110845953
    {Coordinate{40.5761, 47.83}, CountryId{"RU"}}, // Q110845954
    {Coordinate{40.6402, 47.787}, CountryId{"RU"}}, // Q110845955
    {Coordinate{40.7089, 47.7097}, CountryId{"RU"}}, // Q110845956
    {Coordinate{40.7381, 47.6925}, CountryId{"RU"}}, // Q110845957
    {Coordinate{40.7818, 47.6756}, CountryId{"RU"}}, // Q110845958
    {Coordinate{40.8245, 47.6534}, CountryId{"RU"}}, // Q110845960
    {Coordinate{40.8492, 47.6384}, CountryId{"RU"}}, // Q110845961
    {Coordinate{31.4468, 56.4776}, CountryId{"RU"}}, // 252 km
    {Coordinate{31.3503, 56.4559}, CountryId{"RU"}}, // Skvortsovo
    {Coordinate{31.2356, 56.4432}, CountryId{"RU"}}, // 265 km
    {Coordinate{40.2065, 47.7928}, CountryId{"RU"}}, // Q110847372
    {Coordinate{40.1944, 47.7832}, CountryId{"RU"}}, // Q110847432
    {Coordinate{40.2052, 47.7522}, CountryId{"RU"}}, // Q110847440
    {Coordinate{40.1762, 47.6979}, CountryId{"RU"}}, // Q110848428
    {Coordinate{7.8552, 51.09}, CountryId{"DE"}}, // Attendorn-Hohen Hagen railway station
    {Coordinate{40.1832, 47.6354}, CountryId{"RU"}}, // Q110853485
    {Coordinate{40.1617, 47.597}, CountryId{"RU"}}, // Q110853486
    {Coordinate{40.1253, 47.5551}, CountryId{"RU"}}, // Q110853488
    {Coordinate{40.0749, 47.3794}, CountryId{"RU"}}, // Q110853489
    {Coordinate{40.0543, 47.3611}, CountryId{"RU"}}, // Q110853490
    {Coordinate{40.0074, 47.3242}, CountryId{"RU"}}, // Q110853492
    {Coordinate{39.9552, 47.298}, CountryId{"RU"}}, // Q110853493
    {Coordinate{39.8981, 47.268}, CountryId{"RU"}}, // Q110853495
    {Coordinate{39.787, 47.2294}, CountryId{"RU"}}, // Q110859210
    {Coordinate{39.7643, 47.2549}, CountryId{"RU"}}, // Q110859211
    {Coordinate{39.7054, 47.2055}, CountryId{"RU"}}, // Q110859365
    {Coordinate{39.6584, 47.25}, CountryId{"RU"}}, // Q110859666
    {Coordinate{39.6481, 47.2539}, CountryId{"RU"}}, // Q110859667
    {Coordinate{39.5499, 47.2478}, CountryId{"RU"}}, // Q110859669
    {Coordinate{39.6933, 47.2054}, CountryId{"RU"}}, // Q110859827
    {Coordinate{39.6064, 47.1995}, CountryId{"RU"}}, // Pervomayskaya railway station, Rostov-on-Don
    {Coordinate{39.5797, 47.2128}, CountryId{"RU"}}, // Q110859829
    {Coordinate{39.5352, 47.2396}, CountryId{"RU"}}, // Q110859832
    {Coordinate{31.1307, 56.4026}, CountryId{"RU"}}, // Bubnovo
    {Coordinate{31.0471, 56.3977}, CountryId{"RU"}}, // Nazimovo
    {Coordinate{30.9887, 56.4059}, CountryId{"RU"}}, // 282 km
    {Coordinate{17.6852, 49.0328}, CountryId{"CZ"}}, // Újezdec u Luhačovic
    {Coordinate{40.3199, 48.1859}, CountryId{"RU"}}, // Q110864158
    {Coordinate{40.5601, 48.1772}, CountryId{"RU"}}, // Q110864159
    {Coordinate{40.643, 48.1578}, CountryId{"RU"}}, // Q110864160
    {Coordinate{40.7124, 48.1585}, CountryId{"RU"}}, // Q110864161
    {Coordinate{40.7636, 48.1663}, CountryId{"RU"}}, // Q110864162
    {Coordinate{40.8269, 48.1452}, CountryId{"RU"}}, // Q110864163
    {Coordinate{40.9202, 48.1423}, CountryId{"RU"}}, // Q110864164
    {Coordinate{41.0471, 48.2007}, CountryId{"RU"}}, // Q110864165
    {Coordinate{41.116, 48.1762}, CountryId{"RU"}}, // Q110864166
    {Coordinate{41.1494, 48.1974}, CountryId{"RU"}}, // Q110864167
    {Coordinate{41.1882, 48.1889}, CountryId{"RU"}}, // Q110864168
    {Coordinate{41.414, 48.2192}, CountryId{"RU"}}, // Q110864170
    {Coordinate{41.4785, 48.2413}, CountryId{"RU"}}, // Q110864171
    {Coordinate{41.5883, 48.3046}, CountryId{"RU"}}, // Q110864173
    {Coordinate{41.6473, 48.3483}, CountryId{"RU"}}, // Q110864174
    {Coordinate{41.7036, 48.3472}, CountryId{"RU"}}, // Q110864175
    {Coordinate{41.7754, 48.3495}, CountryId{"RU"}}, // Q110864176
    {Coordinate{18.4246, 47.1832}, CountryId{"HU"}}, // Székesfehérvár railway station
    {Coordinate{30.9498, 56.394}, CountryId{"RU"}}, // 285 km
    {Coordinate{30.8939, 56.3688}, CountryId{"RU"}}, // 290 km
    {Coordinate{30.8207, 56.3568}, CountryId{"RU"}}, // Velikopolye
    {Coordinate{39.9922, 45.8109}, CountryId{"RU"}}, // Q110883469
    {Coordinate{39.9922, 45.8109}, CountryId{"RU"}}, // Q110883470
    {Coordinate{39.8587, 45.701}, CountryId{"RU"}}, // Q110883471
    {Coordinate{39.7599, 45.647}, CountryId{"RU"}}, // Q110883472
    {Coordinate{39.5667, 45.5288}, CountryId{"RU"}}, // Q110883473
    {Coordinate{39.5476, 45.5044}, CountryId{"RU"}}, // Q110883474
    {Coordinate{39.4075, 45.3776}, CountryId{"RU"}}, // Q110883476
    {Coordinate{39.3049, 45.2884}, CountryId{"RU"}}, // Q110883477
    {Coordinate{39.1828, 45.1362}, CountryId{"RU"}}, // Q110883480
    {Coordinate{39.1653, 45.1209}, CountryId{"RU"}}, // Q110883481
    {Coordinate{39.1139, 45.0886}, CountryId{"RU"}}, // Loris (railway station)
    {Coordinate{39.0999, 45.0797}, CountryId{"RU"}}, // 661 km
    {Coordinate{30.775, 56.3566}, CountryId{"RU"}}, // 297 km
    {Coordinate{38.8338, 44.891}, CountryId{"RU"}}, // Q110886397
    {Coordinate{38.6914, 44.8714}, CountryId{"RU"}}, // Q110886400
    {Coordinate{38.5532, 44.8619}, CountryId{"RU"}}, // Q110886401
    {Coordinate{38.4895, 44.8672}, CountryId{"RU"}}, // Q110886402
    {Coordinate{38.4895, 44.8672}, CountryId{"RU"}}, // Q110886403
    {Coordinate{38.3395, 44.8705}, CountryId{"RU"}}, // Q110886404
    {Coordinate{38.2548, 44.8672}, CountryId{"RU"}}, // Q110886406
    {Coordinate{37.9606, 44.8941}, CountryId{"RU"}}, // Q110886729
    {Coordinate{37.8628, 44.8693}, CountryId{"RU"}}, // Q110886733
    {Coordinate{46.7641, 45.2125}, CountryId{"RU"}}, // Q110890566
    {Coordinate{46.6055, 44.674}, CountryId{"RU"}}, // Q110890567
    {Coordinate{46.5949, 44.3867}, CountryId{"RU"}}, // Q110890568
    {Coordinate{46.6648, 44.0978}, CountryId{"RU"}}, // Q110890569
    {Coordinate{46.7382, 43.5575}, CountryId{"RU"}}, // Q110891735
    {Coordinate{46.7668, 43.369}, CountryId{"RU"}}, // Q110891737
    {Coordinate{46.8959, 45.5528}, CountryId{"RU"}}, // Q110891887
    {Coordinate{46.6233, 44.8175}, CountryId{"RU"}}, // Q110891888
    {Coordinate{46.5878, 44.5305}, CountryId{"RU"}}, // Q110891889
    {Coordinate{46.6304, 44.2406}, CountryId{"RU"}}, // Q110891890
    {Coordinate{46.6963, 43.9673}, CountryId{"RU"}}, // Q110891891
    {Coordinate{7.5956, 47.6279}, CountryId{"DE"}}, // Eimeldingen station
    {Coordinate{45.8793, 43.4936}, CountryId{"RU"}}, // Q110892281
    {Coordinate{45.5767, 43.6015}, CountryId{"RU"}}, // Q110892282
    {Coordinate{45.3586, 43.674}, CountryId{"RU"}}, // Q110892283
    {Coordinate{45.2452, 43.6957}, CountryId{"RU"}}, // Q110892284
    {Coordinate{45.1223, 43.7243}, CountryId{"RU"}}, // Q110892285
    {Coordinate{7.56392, 47.6556}, CountryId{"DE"}}, // Efringen-Kirchen station
    {Coordinate{7.54294, 47.6609}, CountryId{"DE"}}, // Istein station
    {Coordinate{7.52466, 47.6861}, CountryId{"DE"}}, // Kleinkems station
    {Coordinate{38.7001, 47.6497}, CountryId{"RU"}}, // Q110892620
    {Coordinate{38.7401, 47.607}, CountryId{"RU"}}, // Q110892621
    {Coordinate{38.7732, 47.5723}, CountryId{"RU"}}, // Q110892622
    {Coordinate{38.8058, 47.5704}, CountryId{"RU"}}, // Q110892623
    {Coordinate{38.8834, 47.5372}, CountryId{"RU"}}, // Q110892624
    {Coordinate{38.8893, 47.5121}, CountryId{"RU"}}, // Q110892625
    {Coordinate{38.9121, 47.4799}, CountryId{"RU"}}, // Q110892626
    {Coordinate{38.9053, 47.429}, CountryId{"RU"}}, // Q110892627
    {Coordinate{38.9206, 47.4051}, CountryId{"RU"}}, // Q110892628
    {Coordinate{38.9536, 47.3619}, CountryId{"RU"}}, // Q110892629
    {Coordinate{38.9376, 47.329}, CountryId{"RU"}}, // Q110892630
    {Coordinate{7.53164, 47.7095}, CountryId{"DE"}}, // Rheinweiler station
    {Coordinate{39.0956, 47.2921}, CountryId{"RU"}}, // Morskaya
    {Coordinate{7.64619, 47.8799}, CountryId{"DE"}}, // Heitersheim station
    {Coordinate{30.6903, 56.3512}, CountryId{"RU"}}, // 303 km
    {Coordinate{30.6129, 56.3428}, CountryId{"RU"}}, // 308 km
    {Coordinate{76.1481, 28.2808}, CountryId{"IN"}}, // Mahendragarh railway station
    {Coordinate{38.9541, 47.2731}, CountryId{"RU"}}, // Q110898086
    {Coordinate{38.9714, 47.2769}, CountryId{"RU"}}, // Q110898087
    {Coordinate{38.9892, 47.2786}, CountryId{"RU"}}, // Bessergenovka railway station
    {Coordinate{39.02, 47.2807}, CountryId{"RU"}}, // Q110898089
    {Coordinate{39.0552, 47.2834}, CountryId{"RU"}}, // Primorka railway station
    {Coordinate{39.1819, 47.2893}, CountryId{"RU"}}, // Q110898092
    {Coordinate{39.2154, 47.2864}, CountryId{"RU"}}, // Q110898093
    {Coordinate{39.3362, 47.2666}, CountryId{"RU"}}, // Tanais Station
    {Coordinate{39.3588, 47.2666}, CountryId{"RU"}}, // Nedvigovka Station
    {Coordinate{39.3799, 47.2658}, CountryId{"RU"}}, // Q110898096
    {Coordinate{39.4388, 47.2643}, CountryId{"RU"}}, // Safyanovo railway station
    {Coordinate{39.4642, 47.2622}, CountryId{"RU"}}, // Mokry Chaltyr Station
    {Coordinate{-91.5506, 40.9713}, CountryId{"US"}}, // Mount Pleasant
    {Coordinate{40.1614, 46.9461}, CountryId{"RU"}}, // Q110899655
    {Coordinate{40.1705, 46.9325}, CountryId{"RU"}}, // Q110899656
    {Coordinate{7.7262, 47.9393}, CountryId{"DE"}}, // Norsingen station
    {Coordinate{7.75389, 47.9559}, CountryId{"DE"}}, // Schallstadt station
    {Coordinate{7.76818, 47.9604}, CountryId{"DE"}}, // Ebringen station
    {Coordinate{7.80301, 47.9755}, CountryId{"DE"}}, // Freiburg-St Georgen station
    {Coordinate{39.7192, 47.0783}, CountryId{"RU"}}, // Q110900550
    {Coordinate{39.6732, 47.0264}, CountryId{"RU"}}, // Q110900559
    {Coordinate{39.6631, 47.0087}, CountryId{"RU"}}, // Q110900560
    {Coordinate{39.6566, 46.9926}, CountryId{"RU"}}, // Q110900562
    {Coordinate{39.6569, 46.9749}, CountryId{"RU"}}, // Q110900563
    {Coordinate{39.6767, 46.9355}, CountryId{"RU"}}, // Kayala railway station
    {Coordinate{39.6546, 46.8979}, CountryId{"RU"}}, // Q110900566
    {Coordinate{39.5704, 46.8468}, CountryId{"RU"}}, // Q110900567
    {Coordinate{39.5648, 46.7848}, CountryId{"RU"}}, // Q110900568
    {Coordinate{39.5801, 46.6511}, CountryId{"RU"}}, // Q110900570
    {Coordinate{39.5956, 46.6047}, CountryId{"RU"}}, // Q110900572
    {Coordinate{39.5819, 46.4739}, CountryId{"RU"}}, // Q110900573
    {Coordinate{39.6043, 46.394}, CountryId{"RU"}}, // Q110900574
    {Coordinate{39.8065, 46.2833}, CountryId{"RU"}}, // Q110900575
    {Coordinate{39.8047, 46.2288}, CountryId{"RU"}}, // Q110900576
    {Coordinate{39.8104, 46.1562}, CountryId{"RU"}}, // Q110900577
    {Coordinate{39.8365, 46.1251}, CountryId{"RU"}}, // Q110900578
    {Coordinate{39.8752, 46.0723}, CountryId{"RU"}}, // Q110900579
    {Coordinate{39.9226, 46.0095}, CountryId{"RU"}}, // Q110900580
    {Coordinate{39.9483, 45.9989}, CountryId{"RU"}}, // Q110900581
    {Coordinate{39.9937, 45.9394}, CountryId{"RU"}}, // Q110900583
    {Coordinate{40.0291, 45.9139}, CountryId{"RU"}}, // Q110900584
    {Coordinate{40.0537, 45.896}, CountryId{"RU"}}, // Q110900585
    {Coordinate{40.0668, 45.8865}, CountryId{"RU"}}, // Q110900586
    {Coordinate{40.0985, 45.8633}, CountryId{"RU"}}, // Q110900587
    {Coordinate{40.144, 45.8193}, CountryId{"RU"}}, // Q110901263
    {Coordinate{40.1708, 45.7924}, CountryId{"RU"}}, // Q110901264
    {Coordinate{40.2003, 45.7792}, CountryId{"RU"}}, // Q110901266
    {Coordinate{40.2143, 45.7649}, CountryId{"RU"}}, // Q110901267
    {Coordinate{40.2391, 45.7442}, CountryId{"RU"}}, // Q110901269
    {Coordinate{40.2504, 45.7173}, CountryId{"RU"}}, // Q110901270
    {Coordinate{40.2869, 45.6898}, CountryId{"RU"}}, // Q110901271
    {Coordinate{40.328, 45.6187}, CountryId{"RU"}}, // Q110901273
    {Coordinate{40.4043, 45.5373}, CountryId{"RU"}}, // Q110901275
    {Coordinate{40.4578, 45.4752}, CountryId{"RU"}}, // Q110901277
    {Coordinate{40.4759, 45.4702}, CountryId{"RU"}}, // Q110901279
    {Coordinate{32.7726, 56.8939}, CountryId{"RU"}}, // Zhukopa
    {Coordinate{32.9022, 56.8787}, CountryId{"RU"}}, // Lokhovo
    {Coordinate{-122.353, 37.9367}, CountryId{"US"}}, // Richmond station
    {Coordinate{33.0472, 56.8486}, CountryId{"RU"}}, // Shuvayevo
    {Coordinate{33.1742, 56.864}, CountryId{"RU"}}, // Goritsy
    {Coordinate{33.3391, 56.8596}, CountryId{"RU"}}, // Skakulino
    {Coordinate{33.4647, 56.8573}, CountryId{"RU"}}, // Selizharovo
    {Coordinate{65.2588, 55.4253}, CountryId{"RU"}}, // Kurganka railway station
    {Coordinate{8.6291, 53.1695}, CountryId{"DE"}}, // Bremen-Vegesack station
    {Coordinate{33.6089, 56.8567}, CountryId{"RU"}}, // Slavotino
    {Coordinate{33.7602, 56.8632}, CountryId{"RU"}}, // Krasitsy
    {Coordinate{40.6517, 45.3985}, CountryId{"RU"}}, // Q110917523
    {Coordinate{40.6997, 45.3598}, CountryId{"RU"}}, // Gulkevichi railway station
    {Coordinate{40.7772, 45.296}, CountryId{"RU"}}, // Q110917525
    {Coordinate{40.7995, 45.2768}, CountryId{"RU"}}, // Q110917526
    {Coordinate{40.836, 45.2457}, CountryId{"RU"}}, // Otrado-Kubanskaya train station
    {Coordinate{40.8703, 45.2162}, CountryId{"RU"}}, // Q110917528
    {Coordinate{40.9225, 45.1711}, CountryId{"RU"}}, // Q110917529
    {Coordinate{40.9768, 45.1242}, CountryId{"RU"}}, // Q110917530
    {Coordinate{33.9383, 56.892}, CountryId{"RU"}}, // Brylyovo
    {Coordinate{41.9134, 44.6264}, CountryId{"RU"}}, // Q110917644
    {Coordinate{41.2268, 44.9226}, CountryId{"RU"}}, // Q110930341
    {Coordinate{41.2588, 44.8973}, CountryId{"RU"}}, // Q110930342
    {Coordinate{41.3304, 44.8427}, CountryId{"RU"}}, // Q110930343
    {Coordinate{41.379, 44.8217}, CountryId{"RU"}}, // Q110930344
    {Coordinate{41.4684, 44.791}, CountryId{"RU"}}, // Q110930345
    {Coordinate{41.4887, 44.7848}, CountryId{"RU"}}, // Q110930346
    {Coordinate{41.6037, 44.75}, CountryId{"RU"}}, // Q110930347
    {Coordinate{41.8821, 44.6491}, CountryId{"RU"}}, // Q110930348
    {Coordinate{41.9143, 44.6118}, CountryId{"RU"}}, // Q110933832
    {Coordinate{41.9256, 44.5771}, CountryId{"RU"}}, // Q110933833
    {Coordinate{41.9245, 44.5343}, CountryId{"RU"}}, // Q110933834
    {Coordinate{41.9203, 44.4891}, CountryId{"RU"}}, // Q110933835
    {Coordinate{41.9141, 44.4396}, CountryId{"RU"}}, // Q110933837
    {Coordinate{41.9364, 44.3964}, CountryId{"RU"}}, // Q110933838
    {Coordinate{41.9597, 44.3756}, CountryId{"RU"}}, // Q110933839
    {Coordinate{42.0246, 44.3144}, CountryId{"RU"}}, // Q110933840
    {Coordinate{42.0379, 44.3018}, CountryId{"RU"}}, // Q110933841
    {Coordinate{42.0154, 44.6278}, CountryId{"RU"}}, // Q110938969
    {Coordinate{42.1557, 44.5894}, CountryId{"RU"}}, // Q110938971
    {Coordinate{42.2114, 44.5754}, CountryId{"RU"}}, // Q110938972
    {Coordinate{42.2757, 44.5579}, CountryId{"RU"}}, // Q110938973
    {Coordinate{42.3617, 44.5096}, CountryId{"RU"}}, // Q110938975
    {Coordinate{42.4663, 44.4666}, CountryId{"RU"}}, // Q110938976
    {Coordinate{42.499, 44.4552}, CountryId{"RU"}}, // Q110938977
    {Coordinate{42.5385, 44.4478}, CountryId{"RU"}}, // Q110938978
    {Coordinate{42.5719, 44.4442}, CountryId{"RU"}}, // Q110938980
    {Coordinate{42.729, 44.4076}, CountryId{"RU"}}, // Q110938981
    {Coordinate{42.7904, 44.3819}, CountryId{"RU"}}, // Q110938982
    {Coordinate{42.9202, 44.3101}, CountryId{"RU"}}, // Q110938983
    {Coordinate{43.0134, 44.2557}, CountryId{"RU"}}, // Q110938986
    {Coordinate{43.0311, 44.2497}, CountryId{"RU"}}, // Q110938987
    {Coordinate{43.0592, 44.2439}, CountryId{"RU"}}, // Q110938988
    {Coordinate{43.0939, 44.231}, CountryId{"RU"}}, // Q110938989
    {Coordinate{34.3041, 57.0104}, CountryId{"RU"}}, // Puzakovo
    {Coordinate{34.6013, 57.0199}, CountryId{"RU"}}, // Shcherbovo
    {Coordinate{39.7002, 47.0996}, CountryId{"RU"}}, // Q110942163
    {Coordinate{39.6581, 47.0918}, CountryId{"RU"}}, // Q110942164
    {Coordinate{39.5544, 47.0737}, CountryId{"RU"}}, // Q110942165
    {Coordinate{39.5087, 47.0722}, CountryId{"RU"}}, // Q110942167
    {Coordinate{39.4644, 47.0872}, CountryId{"RU"}}, // Q110942168
    {Coordinate{39.0523, 46.5092}, CountryId{"RU"}}, // Q110944061
    {Coordinate{39.6404, 47.0352}, CountryId{"RU"}}, // Q110944408
    {Coordinate{39.5696, 46.9918}, CountryId{"RU"}}, // Q110944411
    {Coordinate{39.5453, 46.9691}, CountryId{"RU"}}, // Q110944412
    {Coordinate{39.4685, 46.9304}, CountryId{"RU"}}, // Q110944414
    {Coordinate{39.3134, 46.807}, CountryId{"RU"}}, // Q110944416
    {Coordinate{39.2704, 46.769}, CountryId{"RU"}}, // Q110944418
    {Coordinate{39.2361, 46.726}, CountryId{"RU"}}, // Q110944419
    {Coordinate{39.2271, 46.6784}, CountryId{"RU"}}, // Q110944420
    {Coordinate{39.2502, 46.618}, CountryId{"RU"}}, // Q110944422
    {Coordinate{39.2331, 46.5858}, CountryId{"RU"}}, // Q110944423
    {Coordinate{38.85, 46.574}, CountryId{"RU"}}, // Q110945265
    {Coordinate{38.6599, 46.6198}, CountryId{"RU"}}, // Q110945266
    {Coordinate{38.5071, 46.6375}, CountryId{"RU"}}, // Q110945268
    {Coordinate{38.4486, 46.6428}, CountryId{"RU"}}, // Q110945269
    {Coordinate{38.4074, 46.6512}, CountryId{"RU"}}, // Q110945270
    {Coordinate{38.3431, 46.6613}, CountryId{"RU"}}, // Q110945271
    {Coordinate{38.2996, 46.6886}, CountryId{"RU"}}, // Q110945272
    {Coordinate{38.9585, 46.1527}, CountryId{"RU"}}, // Q110946506
    {Coordinate{38.978, 45.9913}, CountryId{"RU"}}, // Q110946507
    {Coordinate{38.9992, 45.9304}, CountryId{"RU"}}, // Q110946508
    {Coordinate{38.978, 45.5543}, CountryId{"RU"}}, // Q110946745
    {Coordinate{39.0106, 45.2488}, CountryId{"RU"}}, // Q110946747
    {Coordinate{39.0035, 45.1519}, CountryId{"RU"}}, // Q110946749
    {Coordinate{38.9979, 45.1247}, CountryId{"RU"}}, // Q110946750
    {Coordinate{11.2473, 42.4514}, CountryId{"IT"}}, // Orbetello-Monte Argentario railway station
    {Coordinate{34.7422, 57.015}, CountryId{"RU"}}, // Tryasenka
    {Coordinate{34.872, 57.0057}, CountryId{"RU"}}, // Skripkovo
    {Coordinate{38.9073, 44.9103}, CountryId{"RU"}}, // Enem II
    {Coordinate{38.9412, 44.8949}, CountryId{"RU"}}, // Q110950780
    {Coordinate{38.954, 44.8914}, CountryId{"RU"}}, // Q110950781
    {Coordinate{39.1727, 44.8362}, CountryId{"RU"}}, // Q110950783
    {Coordinate{39.2064, 44.7119}, CountryId{"RU"}}, // Q110950786
    {Coordinate{39.0911, 44.5988}, CountryId{"RU"}}, // Q110950787
    {Coordinate{39.1365, 44.5328}, CountryId{"RU"}}, // Fanagoriyskaya railway station
    {Coordinate{39.1455, 44.4379}, CountryId{"RU"}}, // Q110950792
    {Coordinate{39.1907, 44.385}, CountryId{"RU"}}, // Q110950794
    {Coordinate{39.2244, 44.2849}, CountryId{"RU"}}, // Chilipsi railway station
    {Coordinate{41.8995, 45.1953}, CountryId{"RU"}}, // Q110954211
    {Coordinate{41.8453, 45.2677}, CountryId{"RU"}}, // Q110954212
    {Coordinate{41.3272, 45.4609}, CountryId{"RU"}}, // Q110954213
    {Coordinate{41.0375, 45.4476}, CountryId{"RU"}}, // Q110954214
    {Coordinate{40.9413, 45.4452}, CountryId{"RU"}}, // Q110954215
    {Coordinate{40.8407, 45.4591}, CountryId{"RU"}}, // Q110954216
    {Coordinate{40.6801, 45.4558}, CountryId{"RU"}}, // Q110954217
    {Coordinate{41.9751, 45.1194}, CountryId{"RU"}}, // Q110954367
    {Coordinate{41.9718, 45.0923}, CountryId{"RU"}}, // Q110954368
    {Coordinate{41.9624, 45.0902}, CountryId{"RU"}}, // Q110954369
    {Coordinate{41.9654, 45.0841}, CountryId{"RU"}}, // Q110954370
    {Coordinate{41.9729, 45.0776}, CountryId{"RU"}}, // Q110954371
    {Coordinate{41.9702, 45.0638}, CountryId{"RU"}}, // Q110954372
    {Coordinate{40.4942, 45.4387}, CountryId{"RU"}}, // Q110954983
    {Coordinate{40.4346, 45.425}, CountryId{"RU"}}, // Q110954984
    {Coordinate{40.3027, 45.3961}, CountryId{"RU"}}, // Q110954985
    {Coordinate{40.0411, 45.3568}, CountryId{"RU"}}, // Q110954986
    {Coordinate{39.9192, 45.3115}, CountryId{"RU"}}, // Q110954987
    {Coordinate{39.7972, 45.2643}, CountryId{"RU"}}, // Q110954988
    {Coordinate{39.5584, 45.2124}, CountryId{"RU"}}, // Q110954990
    {Coordinate{39.4715, 45.1649}, CountryId{"RU"}}, // Q110954991
    {Coordinate{39.3794, 45.1143}, CountryId{"RU"}}, // Q110954992
    {Coordinate{39.2564, 45.0741}, CountryId{"RU"}}, // Q110954999
    {Coordinate{39.2171, 45.0618}, CountryId{"RU"}}, // Q110955002
    {Coordinate{39.1231, 45.0448}, CountryId{"RU"}}, // Q110955006
    {Coordinate{8.54782, 48.4538}, CountryId{"DE"}}, // Schopfloch (b Freudenstadt) train station
    {Coordinate{38.2194, 45.345}, CountryId{"RU"}}, // Q110963186
    {Coordinate{29.2178, 56.3301}, CountryId{"RU"}}, // Brykanovo
    {Coordinate{37.4355, 45.1206}, CountryId{"RU"}}, // Q110964278
    {Coordinate{37.2872, 45.1888}, CountryId{"RU"}}, // Q110964279
    {Coordinate{37.2872, 45.1888}, CountryId{"RU"}}, // Q110964280
    {Coordinate{37.3282, 45.0348}, CountryId{"RU"}}, // Q110964356
    {Coordinate{43.1409, 44.1944}, CountryId{"RU"}}, // Q110965558
    {Coordinate{43.1334, 44.1735}, CountryId{"RU"}}, // Q110965559
    {Coordinate{43.1256, 44.1391}, CountryId{"RU"}}, // Q110965560
    {Coordinate{43.0828, 44.101}, CountryId{"RU"}}, // Q110965562
    {Coordinate{43.0803, 44.0804}, CountryId{"RU"}}, // Q110965563
    {Coordinate{43.0157, 44.0449}, CountryId{"RU"}}, // Q110965564
    {Coordinate{42.9955, 44.0502}, CountryId{"RU"}}, // Q110965565
    {Coordinate{42.9103, 44.0559}, CountryId{"RU"}}, // Q110965566
    {Coordinate{42.8155, 44.0167}, CountryId{"RU"}}, // Q110965567
    {Coordinate{42.7246, 43.9227}, CountryId{"RU"}}, // Q110965570
    {Coordinate{43.1719, 44.2079}, CountryId{"RU"}}, // Q110965923
    {Coordinate{43.1964, 44.2103}, CountryId{"RU"}}, // Q110965924
    {Coordinate{43.2645, 44.2247}, CountryId{"RU"}}, // Q110965925
    {Coordinate{43.3164, 44.2152}, CountryId{"RU"}}, // Q110965926
    {Coordinate{43.3383, 44.2143}, CountryId{"RU"}}, // Q110965927
    {Coordinate{43.3613, 44.2057}, CountryId{"RU"}}, // Q110965928
    {Coordinate{43.3924, 44.1974}, CountryId{"RU"}}, // Q110965929
    {Coordinate{43.4158, 44.1896}, CountryId{"RU"}}, // Q110965930
    {Coordinate{43.5782, 44.1951}, CountryId{"RU"}}, // Q110966261
    {Coordinate{43.6615, 44.2325}, CountryId{"RU"}}, // Q110966263
    {Coordinate{43.7278, 44.2819}, CountryId{"RU"}}, // Q110966264
    {Coordinate{43.9382, 44.4945}, CountryId{"RU"}}, // Q110966265
    {Coordinate{44.011, 44.5709}, CountryId{"RU"}}, // Q110966266
    {Coordinate{44.0234, 44.6241}, CountryId{"RU"}}, // Q110966267
    {Coordinate{44.0539, 44.6861}, CountryId{"RU"}}, // Q110966269
    {Coordinate{43.5048, 44.136}, CountryId{"RU"}}, // Q110969046
    {Coordinate{43.5511, 44.0941}, CountryId{"RU"}}, // Q110969047
    {Coordinate{43.5783, 44.0241}, CountryId{"RU"}}, // Q110969048
    {Coordinate{43.8389, 43.8427}, CountryId{"RU"}}, // Q110969049
    {Coordinate{44.0821, 43.5908}, CountryId{"RU"}}, // Q110969853
    {Coordinate{44.2059, 43.3463}, CountryId{"RU"}}, // Q110969855
    {Coordinate{44.2173, 43.3267}, CountryId{"RU"}}, // Q110969856
    {Coordinate{44.2928, 43.2673}, CountryId{"RU"}}, // Q110969858
    {Coordinate{44.5486, 43.1771}, CountryId{"RU"}}, // Q110971818
    {Coordinate{44.5717, 43.159}, CountryId{"RU"}}, // Q110971819
    {Coordinate{44.5949, 43.141}, CountryId{"RU"}}, // Q110971820
    {Coordinate{44.6232, 43.1079}, CountryId{"RU"}}, // Q110971821
    {Coordinate{44.6353, 43.1015}, CountryId{"RU"}}, // Q110971822
    {Coordinate{44.6495, 43.0921}, CountryId{"RU"}}, // Q110971823
    {Coordinate{44.667, 43.073}, CountryId{"RU"}}, // Q110971824
    {Coordinate{44.6794, 43.0596}, CountryId{"RU"}}, // Q110971825
    {Coordinate{44.6822, 43.0441}, CountryId{"RU"}}, // Q110971826
    {Coordinate{45.883, 43.3016}, CountryId{"RU"}}, // Q110972857
    {Coordinate{45.9842, 43.3229}, CountryId{"RU"}}, // Dzhalka
    {Coordinate{30.034, 56.3538}, CountryId{"RU"}}, // Vydumka
    {Coordinate{12.1043, 47.8663}, CountryId{"DE"}}, // Rosenheim Hochschule station
    {Coordinate{46.3049, 43.3138}, CountryId{"RU"}}, // Q110974944
    {Coordinate{46.6284, 43.2568}, CountryId{"RU"}}, // Q110974945
    {Coordinate{46.719, 43.2499}, CountryId{"RU"}}, // Q110974947
    {Coordinate{12.1267, 47.9269}, CountryId{"DE"}}, // Schechen station
    {Coordinate{12.1362, 47.9884}, CountryId{"DE"}}, // Rott (Inn) station
    {Coordinate{12.1467, 48.0196}, CountryId{"DE"}}, // Ramerberg station
    {Coordinate{13.2994, 52.5303}, CountryId{"DE"}}, // S-Bahnhof Jungfernheide
    {Coordinate{12.2087, 48.107}, CountryId{"DE"}}, // Soyen station
    {Coordinate{46.9025, 43.2023}, CountryId{"RU"}}, // Q110979265
    {Coordinate{46.9347, 43.198}, CountryId{"RU"}}, // Q110979266
    {Coordinate{46.967, 43.1899}, CountryId{"RU"}}, // Q110979267
    {Coordinate{46.9825, 43.1847}, CountryId{"RU"}}, // Q110979268
    {Coordinate{47.0172, 43.173}, CountryId{"RU"}}, // Q110979269
    {Coordinate{47.0553, 43.1602}, CountryId{"RU"}}, // Q110979270
    {Coordinate{47.2866, 43.075}, CountryId{"RU"}}, // Q110979272
    {Coordinate{47.4205, 43.0212}, CountryId{"RU"}}, // Q110979273
    {Coordinate{47.4491, 43.0111}, CountryId{"RU"}}, // Q110979274
    {Coordinate{47.5262, 42.9494}, CountryId{"RU"}}, // Q110979275
    {Coordinate{47.5754, 42.8677}, CountryId{"RU"}}, // Q110979276
    {Coordinate{47.596, 42.8448}, CountryId{"RU"}}, // Q110979277
    {Coordinate{47.7036, 42.6896}, CountryId{"RU"}}, // Q110979278
    {Coordinate{30.2252, 56.3177}, CountryId{"RU"}}, // 500 km
    {Coordinate{30.2925, 56.3177}, CountryId{"RU"}}, // Gushchino
    {Coordinate{30.3845, 56.3232}, CountryId{"RU"}}, // 489 km
    {Coordinate{30.5162, 56.3319}, CountryId{"RU"}}, // 481 km
    {Coordinate{47.9993, 42.3657}, CountryId{"RU"}}, // Q110980187
    {Coordinate{48.0525, 42.2492}, CountryId{"RU"}}, // Q110980188
    {Coordinate{48.0903, 42.1987}, CountryId{"RU"}}, // Q110980190
    {Coordinate{48.1497, 42.1396}, CountryId{"RU"}}, // Q110980191
    {Coordinate{48.2605, 42.1018}, CountryId{"RU"}}, // Q110980194
    {Coordinate{48.2869, 42.0845}, CountryId{"RU"}}, // Q110980195
    {Coordinate{48.298, 42.0717}, CountryId{"RU"}}, // Q110980196
    {Coordinate{48.3271, 42.0227}, CountryId{"RU"}}, // Q110980197
    {Coordinate{48.3308, 41.9988}, CountryId{"RU"}}, // Q110980199
    {Coordinate{48.3313, 41.9864}, CountryId{"RU"}}, // Q110980200
    {Coordinate{48.3481, 41.9363}, CountryId{"RU"}}, // Q110980201
    {Coordinate{48.3677, 41.9076}, CountryId{"RU"}}, // Q110980202
    {Coordinate{48.382, 41.8895}, CountryId{"RU"}}, // Q110980203
    {Coordinate{48.4068, 41.8619}, CountryId{"RU"}}, // Q110980205
    {Coordinate{48.4333, 41.8441}, CountryId{"RU"}}, // Q110980206
    {Coordinate{48.4452, 41.826}, CountryId{"RU"}}, // Q110980207
    {Coordinate{48.509, 41.8136}, CountryId{"RU"}}, // Q110980208
    {Coordinate{48.5186, 41.8057}, CountryId{"RU"}}, // Q110980209
    {Coordinate{12.2982, 48.1475}, CountryId{"DE"}}, // Gars (Inn) station
    {Coordinate{12.3332, 48.1504}, CountryId{"DE"}}, // Mittergars station
    {Coordinate{12.367, 48.1715}, CountryId{"DE"}}, // Jettenbach station
    {Coordinate{12.408, 48.2029}, CountryId{"DE"}}, // Waldkraiburg-Kraiburg
    {Coordinate{9.57522, 45.1692}, CountryId{"IT"}}, // Ospedaletto Lodigiano railway station
    {Coordinate{40.9566, 44.9724}, CountryId{"RU"}}, // Q110989588
    {Coordinate{40.8465, 44.9518}, CountryId{"RU"}}, // Q110989590
    {Coordinate{40.7335, 44.9342}, CountryId{"RU"}}, // Q110989591
    {Coordinate{40.4204, 44.9004}, CountryId{"RU"}}, // Q110989592
    {Coordinate{40.2674, 44.8968}, CountryId{"RU"}}, // Q110989593
    {Coordinate{40.2272, 44.8885}, CountryId{"RU"}}, // Q110989594
    {Coordinate{40.1948, 44.8784}, CountryId{"RU"}}, // Q110989595
    {Coordinate{39.9583, 44.805}, CountryId{"RU"}}, // Q110989596
    {Coordinate{39.9443, 44.7237}, CountryId{"RU"}}, // Q110989822
    {Coordinate{39.9811, 44.6907}, CountryId{"RU"}}, // Q110989825
    {Coordinate{39.7816, 44.7183}, CountryId{"RU"}}, // Q110990397
    {Coordinate{39.6794, 44.6756}, CountryId{"RU"}}, // Q110990398
    {Coordinate{39.6222, 44.6107}, CountryId{"RU"}}, // Q110990399
    {Coordinate{39.5384, 44.5489}, CountryId{"RU"}}, // Q110990402
    {Coordinate{39.4771, 44.4366}, CountryId{"RU"}}, // Q110990405
    {Coordinate{39.4099, 44.4052}, CountryId{"RU"}}, // Q110990407
    {Coordinate{39.3362, 44.3199}, CountryId{"RU"}}, // Q110990411
    {Coordinate{39.2965, 44.3052}, CountryId{"RU"}}, // Q110990412
    {Coordinate{39.2496, 44.2539}, CountryId{"RU"}}, // Q110990414
    {Coordinate{59.5089, 58.7003}, CountryId{"RU"}}, // Kachkanar train station
    {Coordinate{39.2015, 44.1658}, CountryId{"RU"}}, // Q110996277
    {Coordinate{39.1813, 44.1571}, CountryId{"RU"}}, // Q110996279
    {Coordinate{39.1764, 44.1427}, CountryId{"RU"}}, // Q110996280
    {Coordinate{13.4883, 48.2005}, CountryId{"AT"}}, // Ried im Innkreis railway station
    {Coordinate{58.039, 54.9818}, CountryId{"RU"}}, // Q111011359
    {Coordinate{58.0811, 54.9611}, CountryId{"RU"}}, // Q111011360
    {Coordinate{58.1266, 54.9576}, CountryId{"RU"}}, // Q111011362
    {Coordinate{58.1252, 54.937}, CountryId{"RU"}}, // Q111011363
    {Coordinate{58.1561, 54.9374}, CountryId{"RU"}}, // Q111011364
    {Coordinate{58.2579, 54.9378}, CountryId{"RU"}}, // Q111011365
    {Coordinate{58.3888, 54.9087}, CountryId{"RU"}}, // Q111011366
    {Coordinate{58.4672, 54.9724}, CountryId{"RU"}}, // Q111011367
    {Coordinate{58.5596, 55.0373}, CountryId{"RU"}}, // Q111011368
    {Coordinate{58.6352, 55.0616}, CountryId{"RU"}}, // Q111011369
    {Coordinate{58.7198, 55.0926}, CountryId{"RU"}}, // Q111011370
    {Coordinate{58.7566, 55.1013}, CountryId{"RU"}}, // Q111011371
    {Coordinate{58.8593, 55.1259}, CountryId{"RU"}}, // Q111011372
    {Coordinate{59.0079, 55.1907}, CountryId{"RU"}}, // Q111011373
    {Coordinate{59.0527, 55.2065}, CountryId{"RU"}}, // Q111011374
    {Coordinate{59.1038, 55.1766}, CountryId{"RU"}}, // Q111011376
    {Coordinate{60.1338, 55.0238}, CountryId{"RU"}}, // Q111011765
    {Coordinate{59.2055, 55.1673}, CountryId{"RU"}}, // Q111015326
    {Coordinate{59.3105, 55.175}, CountryId{"RU"}}, // Q111015327
    {Coordinate{59.4006, 55.181}, CountryId{"RU"}}, // Q111015328
    {Coordinate{59.444, 55.2193}, CountryId{"RU"}}, // Q111015329
    {Coordinate{59.4964, 55.2243}, CountryId{"RU"}}, // Q111015330
    {Coordinate{59.5318, 55.2069}, CountryId{"RU"}}, // Q111015331
    {Coordinate{59.5801, 55.205}, CountryId{"RU"}}, // Q111015332
    {Coordinate{59.6028, 55.1927}, CountryId{"RU"}}, // Q111015333
    {Coordinate{59.6208, 55.1908}, CountryId{"RU"}}, // Q111015334
    {Coordinate{59.6582, 55.1967}, CountryId{"RU"}}, // Q111015335
    {Coordinate{59.7783, 55.1596}, CountryId{"RU"}}, // Q111015336
    {Coordinate{59.9719, 55.0801}, CountryId{"RU"}}, // Q111015337
    {Coordinate{60.665, 54.9979}, CountryId{"RU"}}, // Q111015338
    {Coordinate{60.7183, 54.9923}, CountryId{"RU"}}, // Q111015339
    {Coordinate{60.8888, 54.9974}, CountryId{"RU"}}, // Q111015340
    {Coordinate{60.9138, 55.0034}, CountryId{"RU"}}, // Q111015341
    {Coordinate{60.965, 55.0081}, CountryId{"RU"}}, // Q111015342
    {Coordinate{61.0123, 55.0153}, CountryId{"RU"}}, // Q111015343
    {Coordinate{61.0501, 55.0224}, CountryId{"RU"}}, // Q111015344
    {Coordinate{61.1358, 55.0076}, CountryId{"RU"}}, // Q111017245
    {Coordinate{61.1689, 54.9493}, CountryId{"RU"}}, // Q111017246
    {Coordinate{61.199, 54.884}, CountryId{"RU"}}, // Q111017248
    {Coordinate{61.1415, 55.0314}, CountryId{"RU"}}, // Q111017510
    {Coordinate{61.293, 55.0584}, CountryId{"RU"}}, // Q111017511
    {Coordinate{61.3349, 55.0869}, CountryId{"RU"}}, // Q111017512
    {Coordinate{61.3519, 55.0936}, CountryId{"RU"}}, // Q111017513
    {Coordinate{61.3666, 55.1035}, CountryId{"RU"}}, // Q111017514
    {Coordinate{61.388, 55.118}, CountryId{"RU"}}, // Q111017515
    {Coordinate{61.3969, 55.124}, CountryId{"RU"}}, // Q111017516
    {Coordinate{61.1239, 55.0264}, CountryId{"RU"}}, // Q111017619
    {Coordinate{61.5178, 55.1566}, CountryId{"RU"}}, // Q111017654
    {Coordinate{61.2752, 54.8628}, CountryId{"RU"}}, // Q111020095
    {Coordinate{61.4023, 55.1229}, CountryId{"RU"}}, // Q111020413
    {Coordinate{61.403, 55.1095}, CountryId{"RU"}}, // Q111020414
    {Coordinate{61.3979, 55.0997}, CountryId{"RU"}}, // Q111020415
    {Coordinate{61.389, 55.0834}, CountryId{"RU"}}, // Q111020416
    {Coordinate{61.3772, 55.0612}, CountryId{"RU"}}, // Q111020417
    {Coordinate{61.2628, 54.845}, CountryId{"RU"}}, // Q111020419
    {Coordinate{61.2467, 54.738}, CountryId{"RU"}}, // Q111021320
    {Coordinate{61.2459, 54.7024}, CountryId{"RU"}}, // Q111021321
    {Coordinate{61.245, 54.6725}, CountryId{"RU"}}, // Q111021322
    {Coordinate{61.2528, 54.6408}, CountryId{"RU"}}, // Q111021323
    {Coordinate{61.307, 54.5301}, CountryId{"RU"}}, // Q111021324
    {Coordinate{61.342, 54.4705}, CountryId{"RU"}}, // Q111021325
    {Coordinate{61.4078, 54.3785}, CountryId{"RU"}}, // Q111021327
    {Coordinate{61.4221, 54.3574}, CountryId{"RU"}}, // Q111021329
    {Coordinate{61.4694, 54.2876}, CountryId{"RU"}}, // Q111021330
    {Coordinate{61.4781, 54.2747}, CountryId{"RU"}}, // Q111021331
    {Coordinate{61.5377, 54.1864}, CountryId{"RU"}}, // Q111021332
    {Coordinate{61.5602, 54.1603}, CountryId{"RU"}}, // Q111021333
    {Coordinate{60.8846, 53.2741}, CountryId{"RU"}}, // Q111021774
    {Coordinate{60.8079, 53.21}, CountryId{"RU"}}, // Q111021775
    {Coordinate{58.5645, 51.2485}, CountryId{"RU"}}, // Q111022132
    {Coordinate{60.5038, 52.7106}, CountryId{"RU"}}, // Q111022278
    {Coordinate{60.3436, 52.4109}, CountryId{"RU"}}, // Q111022279
    {Coordinate{60.0321, 52.083}, CountryId{"RU"}}, // Q111022280
    {Coordinate{59.9046, 51.9671}, CountryId{"RU"}}, // Q111022281
    {Coordinate{59.7649, 51.8176}, CountryId{"RU"}}, // Q111022282
    {Coordinate{59.7649, 51.8176}, CountryId{"RU"}}, // Q111022283
    {Coordinate{59.5657, 51.6986}, CountryId{"RU"}}, // Q111022284
    {Coordinate{59.534, 51.6416}, CountryId{"RU"}}, // Q111022285
    {Coordinate{59.5053, 51.5994}, CountryId{"RU"}}, // Q111022286
    {Coordinate{59.1511, 51.4076}, CountryId{"RU"}}, // Q111022287
    {Coordinate{59.0307, 51.3632}, CountryId{"RU"}}, // Q111022288
    {Coordinate{58.8794, 51.3151}, CountryId{"RU"}}, // Q111022289
    {Coordinate{58.7934, 51.2692}, CountryId{"RU"}}, // Q111022290
    {Coordinate{13.2344, 47.9971}, CountryId{"AT"}}, // Bahnhof Friedburg
    {Coordinate{13.1288, 48.1917}, CountryId{"AT"}}, // Bahnhof Mauerkirchen
    {Coordinate{13.1803, 48.0731}, CountryId{"AT"}}, // Bahnhof Munderfing
    {Coordinate{33.9892, 60.8377}, CountryId{"RU"}}, // Yandeba
    {Coordinate{55.0864, 51.8176}, CountryId{"RU"}}, // Q111023101
    {Coordinate{55.1098, 51.8337}, CountryId{"RU"}}, // Q111023102
    {Coordinate{55.1262, 51.845}, CountryId{"RU"}}, // Q111023103
    {Coordinate{55.215, 51.905}, CountryId{"RU"}}, // Q111023104
    {Coordinate{55.2821, 51.9365}, CountryId{"RU"}}, // Q111023105
    {Coordinate{55.2946, 51.9416}, CountryId{"RU"}}, // Q111023106
    {Coordinate{55.3189, 51.9407}, CountryId{"RU"}}, // Q111023107
    {Coordinate{55.3466, 51.9475}, CountryId{"RU"}}, // Q111023108
    {Coordinate{32.785, 59.7892}, CountryId{"RU"}}, // Q111029941
    {Coordinate{33.8302, 60.7674}, CountryId{"RU"}}, // Tenikonda
    {Coordinate{33.7132, 60.7497}, CountryId{"RU"}}, // Yanega
    {Coordinate{83.0581, 54.9625}, CountryId{"RU"}}, // Sibirskaya railway station
    {Coordinate{33.4362, 60.6895}, CountryId{"RU"}}, // Shamoksha
    {Coordinate{9.39507, 49.403}, CountryId{"DE"}}, // Adelsheim Ost
    {Coordinate{55.3797, 51.9612}, CountryId{"RU"}}, // Q111038694
    {Coordinate{55.4088, 51.9684}, CountryId{"RU"}}, // Q111038695
    {Coordinate{55.4504, 51.9673}, CountryId{"RU"}}, // Q111038697
    {Coordinate{55.5247, 51.9583}, CountryId{"RU"}}, // Q111038698
    {Coordinate{55.6992, 51.9408}, CountryId{"RU"}}, // Q111038699
    {Coordinate{55.7995, 51.9312}, CountryId{"RU"}}, // Q111038700
    {Coordinate{55.9978, 51.8796}, CountryId{"RU"}}, // Q111038701
    {Coordinate{56.0397, 51.8713}, CountryId{"RU"}}, // Q111038702
    {Coordinate{56.1087, 51.858}, CountryId{"RU"}}, // Q111038704
    {Coordinate{56.1445, 51.8474}, CountryId{"RU"}}, // Q111038705
    {Coordinate{56.173, 51.8412}, CountryId{"RU"}}, // Q111038706
    {Coordinate{56.2298, 51.8269}, CountryId{"RU"}}, // Q111038707
    {Coordinate{56.2912, 51.8049}, CountryId{"RU"}}, // Q111038708
    {Coordinate{56.356, 51.7775}, CountryId{"RU"}}, // Q111038709
    {Coordinate{56.4192, 51.747}, CountryId{"RU"}}, // Q111038710
    {Coordinate{56.5973, 51.6146}, CountryId{"RU"}}, // Q111038711
    {Coordinate{56.6896, 51.5192}, CountryId{"RU"}}, // Q111038712
    {Coordinate{56.8406, 51.5274}, CountryId{"RU"}}, // Q111038713
    {Coordinate{56.8923, 51.5338}, CountryId{"RU"}}, // Q111038715
    {Coordinate{56.9593, 51.5222}, CountryId{"RU"}}, // Q111038716
    {Coordinate{57.0485, 51.5215}, CountryId{"RU"}}, // Q111038717
    {Coordinate{57.0992, 51.522}, CountryId{"RU"}}, // Q111038719
    {Coordinate{57.1618, 51.4955}, CountryId{"RU"}}, // Q111038720
    {Coordinate{57.2244, 51.4811}, CountryId{"RU"}}, // Q111038721
    {Coordinate{57.3161, 51.4765}, CountryId{"RU"}}, // Q111038722
    {Coordinate{57.3499, 51.475}, CountryId{"RU"}}, // Q111038723
    {Coordinate{57.3707, 51.4682}, CountryId{"RU"}}, // Q111038724
    {Coordinate{57.4476, 51.3922}, CountryId{"RU"}}, // Q111038725
    {Coordinate{57.4627, 51.3866}, CountryId{"RU"}}, // Q111038726
    {Coordinate{57.5237, 51.3731}, CountryId{"RU"}}, // Q111038727
    {Coordinate{57.5859, 51.4063}, CountryId{"RU"}}, // Q111038728
    {Coordinate{57.6054, 51.3983}, CountryId{"RU"}}, // Q111038729
    {Coordinate{57.6292, 51.3919}, CountryId{"RU"}}, // Q111038730
    {Coordinate{57.6541, 51.3941}, CountryId{"RU"}}, // Q111038731
    {Coordinate{57.7161, 51.3966}, CountryId{"RU"}}, // Q111038732
    {Coordinate{57.8295, 51.4539}, CountryId{"RU"}}, // Q111038734
    {Coordinate{57.9084, 51.4676}, CountryId{"RU"}}, // Q111038735
    {Coordinate{58.1275, 51.3995}, CountryId{"RU"}}, // Q111038736
    {Coordinate{58.1803, 51.2858}, CountryId{"RU"}}, // Q111038737
    {Coordinate{58.2526, 51.2821}, CountryId{"RU"}}, // Q111038738
    {Coordinate{58.3403, 51.2023}, CountryId{"RU"}}, // Novotroitsk railway station
    {Coordinate{58.4294, 51.2037}, CountryId{"RU"}}, // Q111038740
    {Coordinate{58.494, 51.2167}, CountryId{"RU"}}, // Q111038741
    {Coordinate{60.8836, 50.8308}, CountryId{"RU"}}, // Q111040908
    {Coordinate{14.0364, 48.5206}, CountryId{"AT"}}, // Q111044667
    {Coordinate{10.8176, 47.2158}, CountryId{"AT"}}, // Q111044668
    {Coordinate{10.7181, 47.514}, CountryId{"AT"}}, // Q111044669
    {Coordinate{33.0472, 60.3963}, CountryId{"RU"}}, // Pasha
    {Coordinate{11.0957, 47.302}, CountryId{"AT"}}, // Q111044830
    {Coordinate{11.1707, 47.2813}, CountryId{"AT"}}, // Q111044831
    {Coordinate{11.677, 47.3239}, CountryId{"AT"}}, // Pill-Vomperbach railway station
    {Coordinate{10.8904, 47.2534}, CountryId{"AT"}}, // Q111044833
    {Coordinate{11.7268, 47.3655}, CountryId{"AT"}}, // Stans bei Schwaz railway station
    {Coordinate{11.1431, 47.289}, CountryId{"AT"}}, // Q111044835
    {Coordinate{12.1093, 47.5458}, CountryId{"AT"}}, // Langkampfen railway station
    {Coordinate{11.5634, 47.2957}, CountryId{"AT"}}, // Volders-Baumkirchen railway station
    {Coordinate{11.6345, 47.316}, CountryId{"AT"}}, // Terfens-Weer railway station
    {Coordinate{11.1987, 47.278}, CountryId{"AT"}}, // Q111044842
    {Coordinate{10.96, 47.2752}, CountryId{"AT"}}, // Q111044843
    {Coordinate{11.4744, 47.2771}, CountryId{"AT"}}, // Hall in Tirol-Thaur railway station
    {Coordinate{11.8519, 47.3627}, CountryId{"AT"}}, // Q111044845
    {Coordinate{12.1253, 47.5588}, CountryId{"AT"}}, // Schaftenau railway station
    {Coordinate{12.1077, 47.4873}, CountryId{"AT"}}, // Wörgl Süd-Bruckhäusl railway station
    {Coordinate{12.4811, 47.2836}, CountryId{"AT"}}, // Bahnhof Mittersill
    {Coordinate{11.82, 47.4034}, CountryId{"AT"}}, // Münster-Wiesing railway station
    {Coordinate{12.7931, 46.8271}, CountryId{"AT"}}, // Lienz in Osttirol Peggetz railway station
    {Coordinate{12.4658, 46.7468}, CountryId{"AT"}}, // Q111044942
    {Coordinate{10.7765, 47.4277}, CountryId{"AT"}}, // Q111044943
    {Coordinate{10.7249, 47.4897}, CountryId{"AT"}}, // Q111044944
    {Coordinate{12.3908, 47.4973}, CountryId{"AT"}}, // Oberndorf in Tirol railway station
    {Coordinate{12.1867, 47.4389}, CountryId{"AT"}}, // Windau im Brixental railway station
    {Coordinate{12.5807, 47.4685}, CountryId{"AT"}}, // Pfaffenschwendt railway station
    {Coordinate{12.529, 47.4912}, CountryId{"AT"}}, // Fieberbrunn railway station
    {Coordinate{10.8335, 47.4197}, CountryId{"AT"}}, // Q111045645
    {Coordinate{12.895, 46.7792}, CountryId{"AT"}}, // Nikolsdorf railway station
    {Coordinate{12.8273, 47.3902}, CountryId{"AT"}}, // Gerling im Pinzgau railway station
    {Coordinate{12.8906, 47.288}, CountryId{"AT"}}, // Gries im Pinzgau railway station
    {Coordinate{12.7685, 47.4449}, CountryId{"AT"}}, // Leogang-Steinberge railway station
    {Coordinate{12.8103, 47.3587}, CountryId{"AT"}}, // Maishofen-Saalbach railway station
    {Coordinate{12.9474, 47.2928}, CountryId{"AT"}}, // Taxenbach-Rauris railway station
    {Coordinate{12.8296, 47.4269}, CountryId{"AT"}}, // Saalfelden railway station
    {Coordinate{12.8289, 47.2846}, CountryId{"AT"}}, // Bruck-Fusch railway station
    {Coordinate{12.7965, 47.3205}, CountryId{"AT"}}, // Zell am See railway station
    {Coordinate{13.0913, 47.8578}, CountryId{"AT"}}, // Hallwang-Elixhausen railway station
    {Coordinate{12.9441, 47.9415}, CountryId{"AT"}}, // Oberndorf bei Salzburg railway station
    {Coordinate{13.1952, 47.4729}, CountryId{"AT"}}, // Werfen railway station
    {Coordinate{13.0804, 47.7609}, CountryId{"AT"}}, // Elsbethen railway station
    {Coordinate{13.1593, 47.9192}, CountryId{"AT"}}, // Wallersee railway station
    {Coordinate{13.1416, 47.6257}, CountryId{"AT"}}, // Kuchl railway station
    {Coordinate{12.6707, 46.7841}, CountryId{"AT"}}, // train station Thal/Drau
    {Coordinate{13.0414, 47.8187}, CountryId{"AT"}}, // Salzburg Itzling railway station
    {Coordinate{13.2596, 46.7526}, CountryId{"AT"}}, // Steinfeld im Drautal railway station
    {Coordinate{13.0368, 47.8266}, CountryId{"AT"}}, // Salzburg Maria Plain-Plainbrücke railway station
    {Coordinate{13.2645, 47.9721}, CountryId{"AT"}}, // Straßwalchen railway station
    {Coordinate{13.1302, 47.8995}, CountryId{"AT"}}, // Seekirchen am Wallersee railway station
    {Coordinate{13.0212, 47.8391}, CountryId{"AT"}}, // Bergheim bei Salzburg railway station
    {Coordinate{13.1761, 46.9816}, CountryId{"AT"}}, // Mallnitz-Obervellach railway station
    {Coordinate{13.3218, 46.8783}, CountryId{"AT"}}, // Kolbnitz railway station
    {Coordinate{13.367, 46.8514}, CountryId{"AT"}}, // Mühldorf-Möllbrücke railway station
    {Coordinate{13.1997, 47.4614}, CountryId{"AT"}}, // Pfarrwerfen railway station
    {Coordinate{13.4368, 46.6317}, CountryId{"AT"}}, // Q111045841
    {Coordinate{13.4221, 48.37}, CountryId{"AT"}}, // Dietrichshofen railway station
    {Coordinate{13.4293, 47.3822}, CountryId{"AT"}}, // Bahnhof Altenmarkt im Pongau
    {Coordinate{13.4326, 47.9831}, CountryId{"AT"}}, // Frankenmarkt railway station
    {Coordinate{13.4426, 48.4635}, CountryId{"AT"}}, // Schärding railway station
    {Coordinate{58.8294, 51.2115}, CountryId{"RU"}}, // Q111045859
    {Coordinate{59.1082, 51.0692}, CountryId{"RU"}}, // Q111045861
    {Coordinate{59.1137, 51.0525}, CountryId{"RU"}}, // Q111045862
    {Coordinate{59.345, 50.8715}, CountryId{"RU"}}, // Q111045865
    {Coordinate{59.5293, 50.7748}, CountryId{"RU"}}, // Q111045866
    {Coordinate{59.7269, 50.8252}, CountryId{"RU"}}, // Q111045867
    {Coordinate{59.7721, 50.8193}, CountryId{"RU"}}, // Q111045868
    {Coordinate{60.465, 50.8513}, CountryId{"RU"}}, // Q111045869
    {Coordinate{59.0757, 51.1559}, CountryId{"RU"}}, // Q111045892
    {Coordinate{60.7152, 50.8498}, CountryId{"RU"}}, // Q111045894
    {Coordinate{60.8518, 50.831}, CountryId{"RU"}}, // Q111045895
    {Coordinate{26.3247, 55.5197}, CountryId{"LT"}}, // Dūkštas train station
    {Coordinate{58.474, 53.9334}, CountryId{"RU"}}, // Q111062330
    {Coordinate{58.5682, 53.9762}, CountryId{"RU"}}, // Ural-Tau railway station
    {Coordinate{58.6453, 53.8115}, CountryId{"RU"}}, // Novoabzakovo railway station
    {Coordinate{58.8006, 53.6411}, CountryId{"RU"}}, // Tashbulatovo railway station
    {Coordinate{58.9055, 53.5856}, CountryId{"RU"}}, // Q111062339
    {Coordinate{59.0042, 53.4823}, CountryId{"RU"}}, // Q111062341
    {Coordinate{59.0777, 53.4618}, CountryId{"RU"}}, // Q111062345
    {Coordinate{59.0991, 53.4732}, CountryId{"RU"}}, // Q111062348
    {Coordinate{59.1934, 53.45}, CountryId{"RU"}}, // Q111062349
    {Coordinate{59.2611, 53.4557}, CountryId{"RU"}}, // Q111062351
    {Coordinate{59.3026, 53.3971}, CountryId{"RU"}}, // Burannaya
    {Coordinate{59.4389, 53.3289}, CountryId{"RU"}}, // Gumbeyka
    {Coordinate{59.5178, 53.2977}, CountryId{"RU"}}, // Q111062357
    {Coordinate{59.5701, 53.2381}, CountryId{"RU"}}, // Q111062359
    {Coordinate{59.7498, 53.2003}, CountryId{"RU"}}, // Q111062363
    {Coordinate{59.8776, 53.1977}, CountryId{"RU"}}, // Q111062365
    {Coordinate{59.9647, 53.1639}, CountryId{"RU"}}, // Q111062367
    {Coordinate{60.0383, 53.1101}, CountryId{"RU"}}, // Q111062368
    {Coordinate{60.1426, 53.1264}, CountryId{"RU"}}, // Q111062371
    {Coordinate{60.2352, 53.1052}, CountryId{"RU"}}, // Q111062373
    {Coordinate{60.3735, 53.1151}, CountryId{"RU"}}, // Q111062375
    {Coordinate{60.5385, 53.0672}, CountryId{"RU"}}, // Q111062379
    {Coordinate{60.5814, 53.0526}, CountryId{"RU"}}, // Q111062381
    {Coordinate{58.9869, 53.475}, CountryId{"RU"}}, // Q111065580
    {Coordinate{58.7664, 53.0135}, CountryId{"RU"}}, // Q111065589
    {Coordinate{52.3578, 52.6766}, CountryId{"RU"}}, // Q111067806
    {Coordinate{50.7732, 53.1947}, CountryId{"RU"}}, // Spiridonovka railway station
    {Coordinate{50.8894, 53.1595}, CountryId{"RU"}}, // Q111070360
    {Coordinate{51.0843, 53.1207}, CountryId{"RU"}}, // Q111070362
    {Coordinate{51.1662, 53.1061}, CountryId{"RU"}}, // Q111070365
    {Coordinate{51.3255, 53.0668}, CountryId{"RU"}}, // Q111070367
    {Coordinate{51.3649, 53.0782}, CountryId{"RU"}}, // Q111070369
    {Coordinate{51.5443, 53.0631}, CountryId{"RU"}}, // Q111070373
    {Coordinate{51.5905, 53.06}, CountryId{"RU"}}, // Q111070375
    {Coordinate{51.7125, 53.041}, CountryId{"RU"}}, // Neprik railway station
    {Coordinate{51.8686, 53.0294}, CountryId{"RU"}}, // Q111070378
    {Coordinate{51.9539, 52.9854}, CountryId{"RU"}}, // Q111070381
    {Coordinate{52.0285, 52.9387}, CountryId{"RU"}}, // Q111070383
    {Coordinate{52.066, 52.8706}, CountryId{"RU"}}, // Q111070385
    {Coordinate{52.1287, 52.8365}, CountryId{"RU"}}, // Q111070387
    {Coordinate{52.2706, 52.7686}, CountryId{"RU"}}, // Q111070389
    {Coordinate{32.9508, 60.3241}, CountryId{"RU"}}, // Iyevkovo
    {Coordinate{32.8695, 60.2969}, CountryId{"RU"}}, // Sidorovo
    {Coordinate{52.4916, 52.6161}, CountryId{"RU"}}, // Q111082836
    {Coordinate{52.618, 52.568}, CountryId{"RU"}}, // Q111082838
    {Coordinate{52.8166, 52.5075}, CountryId{"RU"}}, // Q111082840
    {Coordinate{52.9818, 52.5013}, CountryId{"RU"}}, // Q111082842
    {Coordinate{53.0171, 52.4988}, CountryId{"RU"}}, // Q111082843
    {Coordinate{53.1486, 52.4284}, CountryId{"RU"}}, // Q111082844
    {Coordinate{53.2082, 52.3955}, CountryId{"RU"}}, // Q111082845
    {Coordinate{53.234, 52.3889}, CountryId{"RU"}}, // Q111082846
    {Coordinate{53.3274, 52.3292}, CountryId{"RU"}}, // Q111082847
    {Coordinate{53.3691, 52.3032}, CountryId{"RU"}}, // Q111082848
    {Coordinate{53.4231, 52.2665}, CountryId{"RU"}}, // Q111082849
    {Coordinate{53.4931, 52.1867}, CountryId{"RU"}}, // Q111082851
    {Coordinate{53.5178, 52.1677}, CountryId{"RU"}}, // Q111082852
    {Coordinate{53.6445, 52.0808}, CountryId{"RU"}}, // Q111082853
    {Coordinate{53.7221, 52.033}, CountryId{"RU"}}, // Q111082854
    {Coordinate{53.8034, 52.0063}, CountryId{"RU"}}, // Q111082855
    {Coordinate{53.867, 51.9881}, CountryId{"RU"}}, // Q111082856
    {Coordinate{53.9091, 51.9712}, CountryId{"RU"}}, // Q111082857
    {Coordinate{53.9808, 51.9389}, CountryId{"RU"}}, // Q111082859
    {Coordinate{54.0425, 51.9169}, CountryId{"RU"}}, // Q111082860
    {Coordinate{54.1827, 51.8753}, CountryId{"RU"}}, // Q111082862
    {Coordinate{54.2116, 51.8671}, CountryId{"RU"}}, // Q111082863
    {Coordinate{54.4136, 51.8572}, CountryId{"RU"}}, // Q111082864
    {Coordinate{54.5222, 51.8705}, CountryId{"RU"}}, // Q111082865
    {Coordinate{54.8628, 51.8881}, CountryId{"RU"}}, // Q111082866
    {Coordinate{54.9233, 51.8836}, CountryId{"RU"}}, // Q111082867
    {Coordinate{54.9559, 51.8722}, CountryId{"RU"}}, // Q111082868
    {Coordinate{55.0158, 51.8503}, CountryId{"RU"}}, // Q111082869
    {Coordinate{55.0609, 51.8237}, CountryId{"RU"}}, // Q111082870
    {Coordinate{52.742, 52.5179}, CountryId{"RU"}}, // Q111082905
    {Coordinate{52.8983, 52.5184}, CountryId{"RU"}}, // Q111082906
    {Coordinate{54.986, 51.1712}, CountryId{"RU"}}, // Q111083087
    {Coordinate{32.804, 60.2407}, CountryId{"RU"}}, // Yugi
    {Coordinate{32.6925, 60.1499}, CountryId{"RU"}}, // Telzhevo
    {Coordinate{55.0892, 51.7187}, CountryId{"RU"}}, // Q111083135
    {Coordinate{55.0352, 51.6586}, CountryId{"RU"}}, // Q111083136
    {Coordinate{55.0206, 51.5955}, CountryId{"RU"}}, // Q111083137
    {Coordinate{55.0084, 51.5342}, CountryId{"RU"}}, // Q111083138
    {Coordinate{54.9586, 51.3245}, CountryId{"RU"}}, // Q111083139
    {Coordinate{54.9064, 51.2788}, CountryId{"RU"}}, // Q111083140
    {Coordinate{54.9089, 51.214}, CountryId{"RU"}}, // Q111083141
    {Coordinate{7.8816, 44.5984}, CountryId{"IT"}}, // Narzole railway station
    {Coordinate{51.5681, 52.1975}, CountryId{"RU"}}, // Q111095288
    {Coordinate{52.0552, 52.5097}, CountryId{"RU"}}, // Q111095290
    {Coordinate{61.8991, 56.1222}, CountryId{"RU"}}, // Q111095503
    {Coordinate{61.87, 56.0804}, CountryId{"RU"}}, // Q111108316
    {Coordinate{61.8399, 56.0367}, CountryId{"RU"}}, // Q111108317
    {Coordinate{61.8192, 56.0066}, CountryId{"RU"}}, // Q111108318
    {Coordinate{61.8057, 55.9867}, CountryId{"RU"}}, // Q111108319
    {Coordinate{61.7647, 55.9269}, CountryId{"RU"}}, // Q111108320
    {Coordinate{61.7398, 55.89}, CountryId{"RU"}}, // Q111108322
    {Coordinate{61.6947, 55.8253}, CountryId{"RU"}}, // Q111108323
    {Coordinate{61.6576, 55.7766}, CountryId{"RU"}}, // Q111108325
    {Coordinate{61.6237, 55.6761}, CountryId{"RU"}}, // Q111108327
    {Coordinate{61.5971, 55.5853}, CountryId{"RU"}}, // Q111108329
    {Coordinate{61.6002, 55.4817}, CountryId{"RU"}}, // Q111108331
    {Coordinate{61.6011, 55.4321}, CountryId{"RU"}}, // Q111108332
    {Coordinate{61.5846, 55.3979}, CountryId{"RU"}}, // Q111108334
    {Coordinate{61.5571, 55.336}, CountryId{"RU"}}, // Q111108336
    {Coordinate{61.5457, 55.3147}, CountryId{"RU"}}, // Q111108338
    {Coordinate{61.5492, 55.2976}, CountryId{"RU"}}, // Q111108339
    {Coordinate{61.5552, 55.2312}, CountryId{"RU"}}, // Q111108341
    {Coordinate{61.5557, 55.2186}, CountryId{"RU"}}, // Q111108343
    {Coordinate{11.1054, 47.9641}, CountryId{"DE"}}, // St. Alban station
    {Coordinate{61.6217, 55.184}, CountryId{"RU"}}, // Q111130868
    {Coordinate{61.7015, 55.193}, CountryId{"RU"}}, // Q111130869
    {Coordinate{61.7311, 55.1991}, CountryId{"RU"}}, // Q111130870
    {Coordinate{61.8005, 55.2113}, CountryId{"RU"}}, // Q111130872
    {Coordinate{61.8388, 55.2149}, CountryId{"RU"}}, // Q111130873
    {Coordinate{61.8768, 55.2184}, CountryId{"RU"}}, // Q111130874
    {Coordinate{61.9343, 55.2182}, CountryId{"RU"}}, // Q111130875
    {Coordinate{61.9818, 55.2132}, CountryId{"RU"}}, // Q111130876
    {Coordinate{62.0608, 55.2046}, CountryId{"RU"}}, // Q111130878
    {Coordinate{62.1002, 55.2021}, CountryId{"RU"}}, // Q111130879
    {Coordinate{62.2406, 55.2051}, CountryId{"RU"}}, // Q111130880
    {Coordinate{62.3874, 55.2054}, CountryId{"RU"}}, // Q111130882
    {Coordinate{62.5178, 55.2081}, CountryId{"RU"}}, // Q111130883
    {Coordinate{62.6356, 55.2019}, CountryId{"RU"}}, // Q111130884
    {Coordinate{62.8972, 55.2074}, CountryId{"RU"}}, // Q111130885
    {Coordinate{62.9632, 55.2095}, CountryId{"RU"}}, // Q111130886
    {Coordinate{63.2233, 55.2138}, CountryId{"RU"}}, // Q111130888
    {Coordinate{63.4919, 55.2685}, CountryId{"RU"}}, // Q111130889
    {Coordinate{63.6065, 55.2938}, CountryId{"RU"}}, // Q111130890
    {Coordinate{63.9161, 55.3314}, CountryId{"RU"}}, // Mishkino railway station
    {Coordinate{64.0764, 55.3463}, CountryId{"RU"}}, // Q111130892
    {Coordinate{64.1296, 55.3491}, CountryId{"RU"}}, // Q111130893
    {Coordinate{64.4575, 55.3697}, CountryId{"RU"}}, // Q111130895
    {Coordinate{64.6463, 55.3855}, CountryId{"RU"}}, // Q111130896
    {Coordinate{64.7518, 55.3926}, CountryId{"RU"}}, // Q111130897
    {Coordinate{64.9544, 55.4253}, CountryId{"RU"}}, // Q111130899
    {Coordinate{65.0232, 55.4312}, CountryId{"RU"}}, // Q111130901
    {Coordinate{65.1155, 55.4264}, CountryId{"RU"}}, // Q111130902
    {Coordinate{61.7716, 55.2076}, CountryId{"RU"}}, // Q111130908
    {Coordinate{62.0262, 55.2072}, CountryId{"RU"}}, // Q111130909
    {Coordinate{64.4204, 55.3669}, CountryId{"RU"}}, // Q111130910
    {Coordinate{65.1367, 55.4276}, CountryId{"RU"}}, // Q111130912
    {Coordinate{64.9142, 55.4111}, CountryId{"RU"}}, // Q111130914
    {Coordinate{65.3353, 55.4465}, CountryId{"RU"}}, // Q111145035
    {Coordinate{65.4202, 55.4355}, CountryId{"RU"}}, // Q111145036
    {Coordinate{65.4304, 55.4118}, CountryId{"RU"}}, // Q111145037
    {Coordinate{65.4443, 55.3967}, CountryId{"RU"}}, // Q111145038
    {Coordinate{65.5533, 55.4053}, CountryId{"RU"}}, // Q111145040
    {Coordinate{65.5765, 55.4075}, CountryId{"RU"}}, // Q111145041
    {Coordinate{65.6052, 55.415}, CountryId{"RU"}}, // Q111145042
    {Coordinate{65.641, 55.4}, CountryId{"RU"}}, // Q111145043
    {Coordinate{65.6721, 55.3895}, CountryId{"RU"}}, // Q111145044
    {Coordinate{65.7185, 55.3842}, CountryId{"RU"}}, // Q111145046
    {Coordinate{65.9672, 55.3573}, CountryId{"RU"}}, // Q111145047
    {Coordinate{66.1157, 55.3251}, CountryId{"RU"}}, // Q111145049
    {Coordinate{66.2215, 55.3009}, CountryId{"RU"}}, // Q111145050
    {Coordinate{66.2928, 55.2906}, CountryId{"RU"}}, // Q111145052
    {Coordinate{66.3435, 55.2806}, CountryId{"RU"}}, // Q111145053
    {Coordinate{66.4899, 55.2674}, CountryId{"RU"}}, // Q111145055
    {Coordinate{66.747, 55.2605}, CountryId{"RU"}}, // Q111145056
    {Coordinate{66.9589, 55.2587}, CountryId{"RU"}}, // Q111145059
    {Coordinate{67.2187, 55.2223}, CountryId{"RU"}}, // Q111145060
    {Coordinate{67.2609, 55.2164}, CountryId{"RU"}}, // Q111145061
    {Coordinate{67.4402, 55.1796}, CountryId{"RU"}}, // Q111145063
    {Coordinate{67.5686, 55.1359}, CountryId{"RU"}}, // Q111145064
    {Coordinate{67.5686, 55.1359}, CountryId{"RU"}}, // Q111145066
    {Coordinate{67.7985, 55.0894}, CountryId{"RU"}}, // Q111145067
    {Coordinate{67.9337, 55.0623}, CountryId{"RU"}}, // Q111145069
    {Coordinate{68.049, 55.039}, CountryId{"RU"}}, // Q111145070
    {Coordinate{68.1903, 55.0102}, CountryId{"RU"}}, // Q111145072
    {Coordinate{60.3119, 56.4397}, CountryId{"RU"}}, // Q111145475
    {Coordinate{32.6528, 60.1168}, CountryId{"RU"}}, // Lungachi
    {Coordinate{32.6008, 60.0444}, CountryId{"RU"}}, // Kolchanovo
    {Coordinate{32.561, 60.0128}, CountryId{"RU"}}, // Khamontovo
    {Coordinate{7.45468, 51.6934}, CountryId{"DE"}}, // Selm-Beifang railway station
    {Coordinate{60.2761, 56.2987}, CountryId{"RU"}}, // Q111154067
    {Coordinate{60.2386, 56.2282}, CountryId{"RU"}}, // Q111154068
    {Coordinate{60.1861, 56.1631}, CountryId{"RU"}}, // Q111154069
    {Coordinate{60.2286, 56.1313}, CountryId{"RU"}}, // Q111154070
    {Coordinate{60.2473, 56.1147}, CountryId{"RU"}}, // Q111154071
    {Coordinate{60.2447, 56.0639}, CountryId{"RU"}}, // Q111154072
    {Coordinate{60.3289, 56.0457}, CountryId{"RU"}}, // Q111154074
    {Coordinate{60.3908, 56.0173}, CountryId{"RU"}}, // Q111154075
    {Coordinate{60.4272, 55.9914}, CountryId{"RU"}}, // Q111154076
    {Coordinate{60.4667, 55.8485}, CountryId{"RU"}}, // Q111154077
    {Coordinate{60.4694, 55.8227}, CountryId{"RU"}}, // Q111154078
    {Coordinate{60.4867, 55.7615}, CountryId{"RU"}}, // Q111154079
    {Coordinate{60.6453, 55.6664}, CountryId{"RU"}}, // Q111154080
    {Coordinate{60.7285, 55.5941}, CountryId{"RU"}}, // Q111154081
    {Coordinate{60.7634, 55.5621}, CountryId{"RU"}}, // Q111154082
    {Coordinate{60.8036, 55.5282}, CountryId{"RU"}}, // Q111154083
    {Coordinate{60.8724, 55.4878}, CountryId{"RU"}}, // Q111154084
    {Coordinate{60.9211, 55.4575}, CountryId{"RU"}}, // Q111154085
    {Coordinate{60.9979, 55.4098}, CountryId{"RU"}}, // Q111154086
    {Coordinate{61.1089, 55.3393}, CountryId{"RU"}}, // Q111154088
    {Coordinate{61.2074, 55.2967}, CountryId{"RU"}}, // Q111154089
    {Coordinate{61.2398, 55.2741}, CountryId{"RU"}}, // Q111154090
    {Coordinate{61.2887, 55.2367}, CountryId{"RU"}}, // Q111154091
    {Coordinate{61.3306, 55.2064}, CountryId{"RU"}}, // Q111154092
    {Coordinate{61.373, 55.1974}, CountryId{"RU"}}, // Q111154093
    {Coordinate{61.4056, 55.199}, CountryId{"RU"}}, // Q111154094
    {Coordinate{61.4198, 55.1784}, CountryId{"RU"}}, // Q111154095
    {Coordinate{61.4281, 55.1675}, CountryId{"RU"}}, // Q111154096
    {Coordinate{62.2114, 56.3828}, CountryId{"RU"}}, // Q111154417
    {Coordinate{62.3147, 56.3806}, CountryId{"RU"}}, // Q111154633
    {Coordinate{62.4777, 56.3387}, CountryId{"RU"}}, // Q111154634
    {Coordinate{62.5961, 56.2886}, CountryId{"RU"}}, // Q111154635
    {Coordinate{62.6694, 56.2822}, CountryId{"RU"}}, // Q111154636
    {Coordinate{62.7961, 56.2773}, CountryId{"RU"}}, // Q111154637
    {Coordinate{62.9382, 56.2633}, CountryId{"RU"}}, // Q111154638
    {Coordinate{63.0691, 56.2394}, CountryId{"RU"}}, // Q111154639
    {Coordinate{63.129, 56.2222}, CountryId{"RU"}}, // Q111154640
    {Coordinate{63.2025, 56.203}, CountryId{"RU"}}, // Q111154641
    {Coordinate{63.2702, 56.1865}, CountryId{"RU"}}, // Q111154642
    {Coordinate{63.3499, 56.1624}, CountryId{"RU"}}, // Q111154643
    {Coordinate{63.4148, 56.1431}, CountryId{"RU"}}, // Q111154644
    {Coordinate{63.453, 56.1357}, CountryId{"RU"}}, // Q111154645
    {Coordinate{63.5374, 56.1139}, CountryId{"RU"}}, // Q111154646
    {Coordinate{63.6694, 56.0962}, CountryId{"RU"}}, // Q111154647
    {Coordinate{63.7273, 56.0726}, CountryId{"RU"}}, // Q111154649
    {Coordinate{63.7853, 56.0557}, CountryId{"RU"}}, // Q111154650
    {Coordinate{63.8222, 56.0463}, CountryId{"RU"}}, // Q111154651
    {Coordinate{63.8257, 56.0143}, CountryId{"RU"}}, // Q111154652
    {Coordinate{63.8262, 56}, CountryId{"RU"}}, // Q111154653
    {Coordinate{63.8614, 55.992}, CountryId{"RU"}}, // Q111154654
    {Coordinate{63.9564, 55.936}, CountryId{"RU"}}, // Q111154655
    {Coordinate{64.0177, 55.9094}, CountryId{"RU"}}, // Q111154656
    {Coordinate{64.0772, 55.885}, CountryId{"RU"}}, // Q111154657
    {Coordinate{64.2076, 55.8633}, CountryId{"RU"}}, // Q111154658
    {Coordinate{64.3027, 55.8352}, CountryId{"RU"}}, // Q111154659
    {Coordinate{64.3108, 55.8184}, CountryId{"RU"}}, // Q111154660
    {Coordinate{64.5011, 55.7478}, CountryId{"RU"}}, // Q111154661
    {Coordinate{64.6759, 55.7118}, CountryId{"RU"}}, // Q111154662
    {Coordinate{64.7629, 55.6826}, CountryId{"RU"}}, // Q111154663
    {Coordinate{64.813, 55.6603}, CountryId{"RU"}}, // Kosobrodsk railway station
    {Coordinate{64.9495, 55.6104}, CountryId{"RU"}}, // Q111154665
    {Coordinate{65.0714, 55.5703}, CountryId{"RU"}}, // Q111154666
    {Coordinate{65.1234, 55.561}, CountryId{"RU"}}, // Q111154667
    {Coordinate{65.1775, 55.5052}, CountryId{"RU"}}, // Q111154668
    {Coordinate{32.5263, 59.9938}, CountryId{"RU"}}, // Georgiyevskii
    {Coordinate{32.4865, 59.9763}, CountryId{"RU"}}, // 135 km
    {Coordinate{32.3552, 59.9178}, CountryId{"RU"}}, // Volkhovstroy-II
    {Coordinate{32.2496, 59.915}, CountryId{"RU"}}, // 119 km
    {Coordinate{32.177, 59.9099}, CountryId{"RU"}}, // 115 km
    {Coordinate{12.9423, 47.9378}, CountryId{"AT"}}, // Oberndorf-Laufen railway station
    {Coordinate{13.0084, 47.3068}, CountryId{"AT"}}, // Eschenau/Salzach railway station
    {Coordinate{13.0554, 47.2975}, CountryId{"AT"}}, // Lend/Salzach railway station
    {Coordinate{13.0652, 47.8391}, CountryId{"AT"}}, // Salzburg Kasern railway station
    {Coordinate{13.073, 47.7993}, CountryId{"AT"}}, // Salzburg Parsch railway station
    {Coordinate{13.0932, 47.6998}, CountryId{"AT"}}, // Oberalm railway station
    {Coordinate{13.1141, 47.676}, CountryId{"AT"}}, // Hallein Burgfried railway station
    {Coordinate{13.1143, 48.2652}, CountryId{"AT"}}, // Hagenau im Innkreis railway station
    {Coordinate{13.117, 47.8735}, CountryId{"AT"}}, // Eugendorf railway station
    {Coordinate{13.1754, 47.9368}, CountryId{"AT"}}, // Köstendorf Weng railway station
    {Coordinate{13.1789, 47.4943}, CountryId{"AT"}}, // Tenneck railway station
    {Coordinate{13.0882, 47.7242}, CountryId{"AT"}}, // Puch b.Hallein Urstein railway station
    {Coordinate{13.1241, 47.6641}, CountryId{"AT"}}, // Bad Vigaun railway station
    {Coordinate{13.1278, 46.7424}, CountryId{"AT"}}, // Berg im Drautal railway station
    {Coordinate{13.1282, 47.6517}, CountryId{"AT"}}, // Kuchl Garnei railway station
    {Coordinate{13.1713, 48.2713}, CountryId{"AT"}}, // Mining railway station
    {Coordinate{13.2209, 48.2697}, CountryId{"AT"}}, // Mühlheim/Inn railway station
    {Coordinate{13.2224, 47.3954}, CountryId{"AT"}}, // Mitterberghütten railway station
    {Coordinate{13.2547, 47.4303}, CountryId{"AT"}}, // Q111166268
    {Coordinate{13.2583, 48.2704}, CountryId{"AT"}}, // Obernberg-Altheim railway station
    {Coordinate{13.2912, 48.2663}, CountryId{"AT"}}, // Geinberg railway station
    {Coordinate{13.3015, 47.9589}, CountryId{"AT"}}, // Oberhofen-Zell am Moos railway station
    {Coordinate{13.3206, 47.4156}, CountryId{"AT"}}, // train station Hüttau
    {Coordinate{13.3483, 46.8256}, CountryId{"AT"}}, // Sachsenburg Markt railway station
    {Coordinate{13.3558, 47.9867}, CountryId{"AT"}}, // Pöndorf railway station
    {Coordinate{13.3681, 46.8308}, CountryId{"AT"}}, // Möllbrücke-Sachsenburg railway station
    {Coordinate{13.4021, 48.3474}, CountryId{"AT"}}, // Antiesenhofen railway station
    {Coordinate{13.4046, 46.8352}, CountryId{"AT"}}, // Pusarnitz railway station
    {Coordinate{13.4192, 46.8275}, CountryId{"AT"}}, // Lendorf im Drautal railway station
    {Coordinate{13.4331, 48.4028}, CountryId{"AT"}}, // Suben railway station
    {Coordinate{13.4337, 48.2888}, CountryId{"AT"}}, // St. Martin im Innkreis railway station
    {Coordinate{13.4554, 48.504}, CountryId{"AT"}}, // Wernstein railway station
    {Coordinate{13.458, 48.2491}, CountryId{"AT"}}, // Aurolzmünster railway station
    {Coordinate{13.4686, 47.3844}, CountryId{"AT"}}, // Bahnhof Radstadt
    {Coordinate{13.4875, 46.7957}, CountryId{"AT"}}, // Spittal-Millstättersee railway station
    {Coordinate{13.2576, 46.9121}, CountryId{"AT"}}, // Bahnhof Penk
    {Coordinate{13.3346, 48.2438}, CountryId{"AT"}}, // Gurten OÖ railway station
    {Coordinate{13.4776, 48.2123}, CountryId{"AT"}}, // Ried im Innkreis Bad railway station
    {Coordinate{13.5367, 48.1518}, CountryId{"AT"}}, // Eberschwang railway station
    {Coordinate{13.5657, 48.3696}, CountryId{"AT"}}, // Andorf railway station
    {Coordinate{13.6057, 47.9595}, CountryId{"AT"}}, // Q111166800
    {Coordinate{13.6066, 48.1135}, CountryId{"AT"}}, // Holzleithen am Hausruck railway station
    {Coordinate{13.6067, 47.9717}, CountryId{"AT"}}, // Q111166804
    {Coordinate{13.6136, 47.9832}, CountryId{"AT"}}, // Q111166805
    {Coordinate{13.6238, 48.0018}, CountryId{"AT"}}, // Oberthalheim-Timelkam train stop
    {Coordinate{13.6241, 48.3173}, CountryId{"AT"}}, // Zell/Pram railway station
    {Coordinate{13.6252, 46.5887}, CountryId{"AT"}}, // Nötsch railway station
    {Coordinate{13.6266, 48.3041}, CountryId{"AT"}}, // Riedau railway station
    {Coordinate{13.632, 47.6162}, CountryId{"AT"}}, // Steeg-Gosau railway station
    {Coordinate{13.6621, 47.5677}, CountryId{"AT"}}, // Hallstatt railway station
    {Coordinate{13.6649, 48.0921}, CountryId{"AT"}}, // Ottnang-Wolfsegg railway station
    {Coordinate{13.6737, 46.7076}, CountryId{"AT"}}, // Paternion-Feistritz railway station
    {Coordinate{13.7077, 46.5515}, CountryId{"AT"}}, // Arnoldstein railway station
    {Coordinate{13.7204, 47.5643}, CountryId{"AT"}}, // Obertraun-Koppenbrüllerhöhle railway station
    {Coordinate{13.7465, 46.5519}, CountryId{"AT"}}, // Pöckau railway station
    {Coordinate{13.7681, 48.0541}, CountryId{"AT"}}, // Schwanenstadt railway station
    {Coordinate{13.7705, 48.3377}, CountryId{"AT"}}, // Peuerbach railway station
    {Coordinate{13.7801, 46.5551}, CountryId{"AT"}}, // Neuhaus an der Gail railway station
    {Coordinate{13.8013, 47.417}, CountryId{"AT"}}, // Q111166824
    {Coordinate{13.808, 47.1299}, CountryId{"AT"}}, // Tamsweg railway station
    {Coordinate{13.8136, 46.5632}, CountryId{"AT"}}, // Fürnitz railway station
    {Coordinate{13.8698, 48.0944}, CountryId{"AT"}}, // Lambach Markt railway station
    {Coordinate{13.3447, 47.4213}, CountryId{"AT"}}, // Q111167423
    {Coordinate{13.3739, 48.2272}, CountryId{"AT"}}, // Neuratting railway station
    {Coordinate{13.4081, 46.6312}, CountryId{"AT"}}, // Q111167426
    {Coordinate{13.4152, 48.316}, CountryId{"AT"}}, // Hart im Innkreis railway station
    {Coordinate{13.4584, 48.4408}, CountryId{"AT"}}, // Gopperding railway station
    {Coordinate{13.4708, 46.6232}, CountryId{"AT"}}, // Q111167429
    {Coordinate{13.5132, 48.171}, CountryId{"AT"}}, // Oberbrunn im Innkreis railway station
    {Coordinate{13.5227, 48.4068}, CountryId{"AT"}}, // Taufkirchen/Pram railway station
    {Coordinate{13.5682, 47.4042}, CountryId{"AT"}}, // Bahnhof Mandling
    {Coordinate{13.5716, 48.1296}, CountryId{"AT"}}, // Hausruck railway station
    {Coordinate{13.5727, 46.5953}, CountryId{"AT"}}, // Emmersdorf im Gailtal railway station
    {Coordinate{13.5804, 46.7603}, CountryId{"AT"}}, // Rothenthurn railway station
    {Coordinate{13.6171, 48.2317}, CountryId{"AT"}}, // Q111167436
    {Coordinate{13.6203, 48.2694}, CountryId{"AT"}}, // Kumpfmühl railway station
    {Coordinate{13.6502, 48.2464}, CountryId{"AT"}}, // Q111167438
    {Coordinate{13.6633, 47.7388}, CountryId{"AT"}}, // Mitterweißenbach railway station
    {Coordinate{13.6815, 48.0529}, CountryId{"AT"}}, // Wolfshütte railway station
    {Coordinate{13.7199, 46.6795}, CountryId{"AT"}}, // Weißenstein-Kellerberg railway station
    {Coordinate{13.8101, 48.323}, CountryId{"AT"}}, // Niederspaching railway station
    {Coordinate{13.8208, 47.4204}, CountryId{"AT"}}, // Q111167444
    {Coordinate{13.8331, 48.0951}, CountryId{"AT"}}, // Neukirchen bei Lambach railway station
    {Coordinate{13.8538, 48.3308}, CountryId{"AT"}}, // Waizenkirchen railway station
    {Coordinate{13.8685, 48.2238}, CountryId{"AT"}}, // Schlüßlberg railway station
    {Coordinate{13.8745, 46.6209}, CountryId{"AT"}}, // Villach Seebach railway station
    {Coordinate{13.8764, 46.641}, CountryId{"AT"}}, // Q111167449
    {Coordinate{13.8834, 48.0843}, CountryId{"AT"}}, // Stadl-Paura railway station
    {Coordinate{13.8885, 48.094}, CountryId{"AT"}}, // Lambach railway station
    {Coordinate{13.9009, 47.4269}, CountryId{"AT"}}, // Q111167453
    {Coordinate{13.9165, 46.6628}, CountryId{"AT"}}, // Bahnhof Sattendorf
    {Coordinate{13.9214, 47.9974}, CountryId{"AT"}}, // Vorchdorf-Eggenberg railway station
    {Coordinate{13.9223, 48.2287}, CountryId{"AT"}}, // Bad Schallerbach-Wallern railway station
    {Coordinate{13.9255, 47.5511}, CountryId{"AT"}}, // Bad Mitterndorf-Heilbrunn railway station
    {Coordinate{13.9419, 47.4373}, CountryId{"AT"}}, // Q111167458
    {Coordinate{13.9454, 48.1321}, CountryId{"AT"}}, // Gunskirchen railway station
    {Coordinate{13.9461, 47.5503}, CountryId{"AT"}}, // Bad Mitterndorf railway station
    {Coordinate{13.959, 46.6021}, CountryId{"AT"}}, // Föderlach railway station
    {Coordinate{13.9595, 46.6745}, CountryId{"AT"}}, // Bahnhof St. Urban am Ossiachersee
    {Coordinate{13.9604, 48.5999}, CountryId{"AT"}}, // Q111167464
    {Coordinate{13.9651, 46.5629}, CountryId{"AT"}}, // Q111167465
    {Coordinate{13.8389, 48.231}, CountryId{"AT"}}, // Grieskirchen-Gallspach railway station
    {Coordinate{13.9713, 47.9155}, CountryId{"AT"}}, // Viechtwang railway station
    {Coordinate{13.9742, 46.6826}, CountryId{"AT"}}, // Bahnhof Ossiach-Bodensdorf
    {Coordinate{13.9749, 48.6426}, CountryId{"AT"}}, // Q111167722
    {Coordinate{13.975, 48.2473}, CountryId{"AT"}}, // Q111167723
    {Coordinate{13.9871, 48.5819}, CountryId{"AT"}}, // Bahnhof Rohrbach-Berg
    {Coordinate{13.9876, 47.4607}, CountryId{"AT"}}, // Q111167725
    {Coordinate{13.9981, 48.3392}, CountryId{"AT"}}, // Bahnhof Pupping
    {Coordinate{14.0051, 48.4837}, CountryId{"AT"}}, // Bahnhof Neufelden
    {Coordinate{14.0068, 48.2869}, CountryId{"AT"}}, // Q111167728
    {Coordinate{14.0103, 48.3219}, CountryId{"AT"}}, // Q111167730
    {Coordinate{14.0113, 47.5515}, CountryId{"AT"}}, // Tauplitz railway station
    {Coordinate{14.0115, 47.9622}, CountryId{"AT"}}, // Pettenbach railway station
    {Coordinate{14.0141, 48.3633}, CountryId{"AT"}}, // Bahnhof Aschach an der Donau
    {Coordinate{14.0141, 46.6982}, CountryId{"AT"}}, // Bahnhof Steindorf am Ossiacher See
    {Coordinate{14.0143, 47.4817}, CountryId{"AT"}}, // Q111167737
    {Coordinate{14.0173, 48.1566}, CountryId{"AT"}}, // Wels Lokalbahn railway station
    {Coordinate{14.0179, 48.1193}, CountryId{"AT"}}, // Steinhaus bei Wels railway station
    {Coordinate{14.0196, 48.1525}, CountryId{"AT"}}, // Bahnhof Wels Messe
    {Coordinate{14.022, 47.9681}, CountryId{"AT"}}, // Diensthubersiedlung railway station
    {Coordinate{14.0309, 48.5545}, CountryId{"AT"}}, // Haslach/Mühl railway station
    {Coordinate{14.0321, 48.4585}, CountryId{"AT"}}, // Bahnhof Kleinzell
    {Coordinate{14.0448, 46.62}, CountryId{"AT"}}, // Velden am Wörther See railway station
    {Coordinate{14.0471, 48.0124}, CountryId{"AT"}}, // Voitsdorf railway station
    {Coordinate{14.058, 48.0741}, CountryId{"AT"}}, // Sattledt railway station
    {Coordinate{14.06, 46.7014}, CountryId{"AT"}}, // Q111167748
    {Coordinate{14.0646, 47.5286}, CountryId{"AT"}}, // Pürgg railway station
    {Coordinate{14.099, 46.7215}, CountryId{"AT"}}, // Q111167751
    {Coordinate{14.1112, 47.9369}, CountryId{"AT"}}, // Q111167752
    {Coordinate{14.1162, 47.9062}, CountryId{"AT"}}, // Bahnhof Kirchdorf/Krems
    {Coordinate{14.1216, 47.989}, CountryId{"AT"}}, // Q111167754
    {Coordinate{14.123, 47.9721}, CountryId{"AT"}}, // Q111167755
    {Coordinate{14.1264, 47.8831}, CountryId{"AT"}}, // Bahnhof Micheldorf
    {Coordinate{14.1375, 48.3602}, CountryId{"AT"}}, // Bahnhof Rottenegg
    {Coordinate{14.1398, 47.5455}, CountryId{"AT"}}, // Bahnhof Wörschach Schwefelbad
    {Coordinate{14.1414, 48.0536}, CountryId{"AT"}}, // Bahnhof Kremsmünster
    {Coordinate{14.1463, 46.6362}, CountryId{"AT"}}, // Q111167761
    {Coordinate{14.1511, 48.2276}, CountryId{"AT"}}, // Oftering railway station
    {Coordinate{14.1536, 48.3484}, CountryId{"AT"}}, // Bahnhof Walding
    {Coordinate{14.1637, 47.8017}, CountryId{"AT"}}, // Bahnhof Steyrling
    {Coordinate{14.1771, 48.3378}, CountryId{"AT"}}, // Bahnhof Ottensheim
    {Coordinate{14.179, 47.7746}, CountryId{"AT"}}, // Bahnhof Hinterstoder
    {Coordinate{14.1862, 48.2457}, CountryId{"AT"}}, // Hörsching railway station
    {Coordinate{14.1912, 48.0696}, CountryId{"AT"}}, // Bahnhof Rohr-Bad Hall
    {Coordinate{14.203, 48.113}, CountryId{"AT"}}, // Bahnhof Kematen an der Krems
    {Coordinate{14.2089, 48.2573}, CountryId{"AT"}}, // Pasching railway station
    {Coordinate{14.2107, 46.7165}, CountryId{"AT"}}, // Q111167777
    {Coordinate{14.2214, 46.6263}, CountryId{"AT"}}, // Q111167778
    {Coordinate{14.2224, 48.3125}, CountryId{"AT"}}, // Bahnhof Puchenau West
    {Coordinate{14.2365, 46.7282}, CountryId{"AT"}}, // Q111167780
    {Coordinate{14.2384, 48.3116}, CountryId{"AT"}}, // Q111167781
    {Coordinate{14.2385, 48.136}, CountryId{"AT"}}, // Q111167783
    {Coordinate{14.2419, 47.5627}, CountryId{"AT"}}, // Bahnhof Liezen
    {Coordinate{14.2435, 46.5393}, CountryId{"AT"}}, // Bahnhof Weizelsdorf
    {Coordinate{14.2465, 48.164}, CountryId{"AT"}}, // Q111167786
    {Coordinate{14.2538, 48.2256}, CountryId{"AT"}}, // Bahnhof Traun
    {Coordinate{14.2611, 48.2089}, CountryId{"AT"}}, // Bahnhof Ansfelden
    {Coordinate{16.0263, 47.8787}, CountryId{"AT"}}, // Bahnhof Oed
    {Coordinate{14.284, 46.6215}, CountryId{"AT"}}, // Q111167790
    {Coordinate{14.2931, 46.7364}, CountryId{"AT"}}, // Q111167793
    {Coordinate{14.3273, 47.7154}, CountryId{"AT"}}, // Bahnhof Windischgarsten
    {Coordinate{14.3475, 47.6731}, CountryId{"AT"}}, // Bahnhof Spital am Pyhrn
    {Coordinate{14.355, 47.9492}, CountryId{"AT"}}, // Ternberg railway station
    {Coordinate{14.3623, 48.2845}, CountryId{"AT"}}, // Bahnhof Steyregg
    {Coordinate{14.3671, 47.5273}, CountryId{"AT"}}, // Stadt Rottenmann railway station
    {Coordinate{14.4083, 48.0238}, CountryId{"AT"}}, // Garsten railway station
    {Coordinate{14.4103, 46.9537}, CountryId{"AT"}}, // Friesach railway station
    {Coordinate{14.4232, 48.0382}, CountryId{"AT"}}, // Steyr railway station
    {Coordinate{14.4233, 46.7619}, CountryId{"AT"}}, // Q111167804
    {Coordinate{14.4315, 46.9143}, CountryId{"AT"}}, // Q111167805
    {Coordinate{14.4404, 48.2652}, CountryId{"AT"}}, // Q111167806
    {Coordinate{14.4423, 47.2011}, CountryId{"AT"}}, // Unzmarkt railway station
    {Coordinate{14.4596, 46.6189}, CountryId{"AT"}}, // train station Grafenstein
    {Coordinate{14.4656, 46.8685}, CountryId{"AT"}}, // train station Treibach-Althofen
    {Coordinate{13.8415, 47.5707}, CountryId{"AT"}}, // Kainisch railway station
    {Coordinate{13.9383, 47.8772}, CountryId{"AT"}}, // Traxenbichl railway station
    {Coordinate{13.9873, 48.2733}, CountryId{"AT"}}, // Q111171336
    {Coordinate{13.9931, 47.9324}, CountryId{"AT"}}, // Steinbachbrücke railway station
    {Coordinate{13.9958, 47.5521}, CountryId{"AT"}}, // Tauplitz Schiflugschanze Kulm railway station
    {Coordinate{14.0001, 46.6059}, CountryId{"AT"}}, // Lind-Rosegg railway station
    {Coordinate{14.315, 46.6506}, CountryId{"AT"}}, // Q111171342
    {Coordinate{14.322, 46.6216}, CountryId{"AT"}}, // Q111171343
    {Coordinate{14.362, 46.7625}, CountryId{"AT"}}, // Q111171345
    {Coordinate{14.4149, 47.0735}, CountryId{"AT"}}, // Neumarkt in Steiermark railway station
    {Coordinate{14.4171, 47.1491}, CountryId{"AT"}}, // Scheifling railway station
    {Coordinate{14.4667, 48.2212}, CountryId{"AT"}}, // Enns railway station
    {Coordinate{14.4684, 47.5733}, CountryId{"AT"}}, // Admont railway station
    {Coordinate{14.4727, 47.8915}, CountryId{"AT"}}, // Bahnhof Reichraming
    {Coordinate{14.48, 48.1266}, CountryId{"AT"}}, // Ernsthofen railway station
    {Coordinate{14.4815, 48.4952}, CountryId{"AT"}}, // Bahnhof Freistadt
    {Coordinate{14.4893, 47.4892}, CountryId{"AT"}}, // Trieben railway station
    {Coordinate{14.4902, 48.3121}, CountryId{"AT"}}, // Bahnhof Katsdorf
    {Coordinate{14.4961, 48.2165}, CountryId{"AT"}}, // Ennsdorf railway station
    {Coordinate{14.5035, 48.1614}, CountryId{"AT"}}, // Herzograd railway station
    {Coordinate{14.5108, 47.893}, CountryId{"AT"}}, // Bahnhof Großraming Kraftwerk
    {Coordinate{14.5327, 48.2429}, CountryId{"AT"}}, // Bahnhof Mauthausen
    {Coordinate{14.5381, 48.4369}, CountryId{"AT"}}, // Bahnhof Kefermarkt
    {Coordinate{14.5466, 47.4891}, CountryId{"AT"}}, // Gaishorn am See railway station
    {Coordinate{14.5511, 47.8822}, CountryId{"AT"}}, // Bahnhof Großraming
    {Coordinate{14.5661, 48.1157}, CountryId{"AT"}}, // Stadt Haag railway station
    {Coordinate{14.5886, 47.1966}, CountryId{"AT"}}, // Thalheim-Pöls railway station
    {Coordinate{14.5959, 47.5824}, CountryId{"AT"}}, // Johnsbach im Nationalpark railway station
    {Coordinate{14.6275, 48.2475}, CountryId{"AT"}}, // Bahnhof Perg
    {Coordinate{14.6299, 46.6221}, CountryId{"AT"}}, // Q111171368
    {Coordinate{14.6336, 47.5914}, CountryId{"AT"}}, // Gstatterboden im Nationalpark railway station
    {Coordinate{14.6599, 47.1747}, CountryId{"AT"}}, // Judenburg railway station
    {Coordinate{14.667, 47.8616}, CountryId{"AT"}}, // railway station Weyer
    {Coordinate{14.6708, 47.4504}, CountryId{"AT"}}, // Wald am Schoberpaß railway station
    {Coordinate{14.7011, 48.2269}, CountryId{"AT"}}, // Bahnhof Arbing
    {Coordinate{14.738, 47.9927}, CountryId{"AT"}}, // Bahnhof Sonntagberg
    {Coordinate{14.7469, 47.4237}, CountryId{"AT"}}, // Kalwang railway station
    {Coordinate{14.7477, 48.2087}, CountryId{"AT"}}, // Bahnhof Baumgartenberg
    {Coordinate{14.7653, 47.9681}, CountryId{"AT"}}, // railway station Waidhofen an der ybbs
    {Coordinate{14.7678, 47.9584}, CountryId{"AT"}}, // Q111171378
    {Coordinate{14.7895, 48.2054}, CountryId{"AT"}}, // Bahnhof Saxen
    {Coordinate{14.8114, 46.6301}, CountryId{"AT"}}, // Q111171380
    {Coordinate{14.8252, 46.6628}, CountryId{"AT"}}, // Q111171381
    {Coordinate{14.8361, 47.3968}, CountryId{"AT"}}, // Mautern railway station
    {Coordinate{14.8376, 47.2153}, CountryId{"AT"}}, // Knittelfeld railway station
    {Coordinate{14.8382, 46.6851}, CountryId{"AT"}}, // Q111171384
    {Coordinate{14.8384, 46.8426}, CountryId{"AT"}}, // Q111171385
    {Coordinate{14.856, 48.23}, CountryId{"AT"}}, // Bahnhof Grein Stadt
    {Coordinate{14.8677, 46.7065}, CountryId{"AT"}}, // Q111171387
    {Coordinate{14.8685, 46.6964}, CountryId{"AT"}}, // Q111171388
    {Coordinate{14.9091, 48.2335}, CountryId{"AT"}}, // Bahnhof St. Nikola-Struden
    {Coordinate{14.944, 48.2296}, CountryId{"AT"}}, // Bahnhof Sarmingstein
    {Coordinate{14.9455, 47.306}, CountryId{"AT"}}, // Kraubath an der Mur railway station
    {Coordinate{14.9796, 48.1251}, CountryId{"AT"}}, // Blindenmarkt bei Amstetten railway station
    {Coordinate{15.0092, 47.3467}, CountryId{"AT"}}, // St. Michael railway station
    {Coordinate{14.7237, 47.8938}, CountryId{"AT"}}, // Bahnhof Gaflenz
    {Coordinate{14.8461, 46.8067}, CountryId{"AT"}}, // Q111171448
    {Coordinate{15.1311, 48.059}, CountryId{"AT"}}, // Q111171451
    {Coordinate{15.1555, 47.3939}, CountryId{"AT"}}, // train station Niklasdorf
    {Coordinate{15.157, 48.1435}, CountryId{"AT"}}, // Bahnhof Petzenkirchen
    {Coordinate{15.1643, 48.0053}, CountryId{"AT"}}, // Bahnhof Scheibbs
    {Coordinate{15.1821, 48.1838}, CountryId{"AT"}}, // Bahnhof Erlauf
    {Coordinate{15.2921, 47.4452}, CountryId{"AT"}}, // Kapfenberg railway station
    {Coordinate{15.343, 47.3595}, CountryId{"AT"}}, // Pernegg railway station
    {Coordinate{15.4483, 47.5011}, CountryId{"AT"}}, // Kindberg railway station
    {Coordinate{15.477, 46.9164}, CountryId{"AT"}}, // Werndorf railway station
    {Coordinate{15.4831, 47.5273}, CountryId{"AT"}}, // Wartberg im Mürztal railway station
    {Coordinate{15.496, 47.0301}, CountryId{"AT"}}, // Raaba railway station
    {Coordinate{15.56, 47.5472}, CountryId{"AT"}}, // Krieglach railway station
    {Coordinate{15.5856, 46.7277}, CountryId{"AT"}}, // Ehrenhausen railway station
    {Coordinate{15.9489, 46.7238}, CountryId{"AT"}}, // Bahnhof Halbenrain
    {Coordinate{16.0034, 46.9794}, CountryId{"AT"}}, // Hatzendorf railway station
    {Coordinate{16.1428, 47.7033}, CountryId{"AT"}}, // Seebenstein railway station
    {Coordinate{16.1756, 47.9294}, CountryId{"AT"}}, // Bahnhof Hirtenberg
    {Coordinate{16.4196, 48.1024}, CountryId{"AT"}}, // Maria Lanzendorf railway station
    {Coordinate{16.5388, 48.3617}, CountryId{"AT"}}, // Pillichsdorf railway station
    {Coordinate{16.6032, 48.3578}, CountryId{"AT"}}, // Bockfließ railway station
    {Coordinate{16.6152, 48.1165}, CountryId{"AT"}}, // Bahnhof Fischamend
    {Coordinate{16.7476, 48.248}, CountryId{"AT"}}, // Bahnhof Untersiebenbrunn
    {Coordinate{17.0062, 48.1356}, CountryId{"AT"}}, // Bahnhof Wolfsthal
    {Coordinate{15.3433, 47.2072}, CountryId{"AT"}}, // Peggau-Deutschfeistritz railway station
    {Coordinate{14.4556, 46.7689}, CountryId{"AT"}}, // Q111171554
    {Coordinate{16.9009, 48.5983}, CountryId{"AT"}}, // Hohenau/March railway station
    {Coordinate{15.999, 47.1889}, CountryId{"AT"}}, // Sebersdorf railway station
    {Coordinate{16.0353, 47.2806}, CountryId{"AT"}}, // St. Johann in der Haide railway station
    {Coordinate{16.0996, 47.5624}, CountryId{"AT"}}, // Aspang railway station
    {Coordinate{15.5884, 47.0789}, CountryId{"AT"}}, // Laßnitzhöhe railway station
    {Coordinate{16.6605, 47.8886}, CountryId{"AT"}}, // Bahnhof Donnerskirchen
    {Coordinate{16.8958, 48.5401}, CountryId{"AT"}}, // Drösing railway station
    {Coordinate{16.3625, 47.8776}, CountryId{"AT"}}, // Bahnhof Ebenfurth
    {Coordinate{16.9159, 47.84}, CountryId{"AT"}}, // train station Frauenkirchen
    {Coordinate{16.7462, 47.9411}, CountryId{"AT"}}, // Bahnhof Breitenbrunn/Neusiedler See
    {Coordinate{16.4088, 47.7359}, CountryId{"AT"}}, // Bahnhof Mattersburg
    {Coordinate{16.619, 47.8481}, CountryId{"AT"}}, // Bahnhof Schützen am Gebirge
    {Coordinate{16.8242, 47.9561}, CountryId{"AT"}}, // train station Neusiedl am See
    {Coordinate{16.1796, 47.7172}, CountryId{"AT"}}, // Pitten railway station
    {Coordinate{15.7089, 47.0994}, CountryId{"AT"}}, // Gleisdorf railway station
    {Coordinate{16.377, 48.0821}, CountryId{"AT"}}, // Bahnhof Achau
    {Coordinate{16.4947, 47.7478}, CountryId{"AT"}}, // Bahnhof Draßburg
    {Coordinate{16.4089, 47.9612}, CountryId{"AT"}}, // Bahnhof Ebreichsdorf
    {Coordinate{16.5298, 47.8396}, CountryId{"AT"}}, // Bahnhof Eisenstadt
    {Coordinate{16.9055, 47.8916}, CountryId{"AT"}}, // train station Gols
    {Coordinate{16.4815, 48.1436}, CountryId{"AT"}}, // Bahnhof Schwechat
    {Coordinate{16.9392, 48.1488}, CountryId{"AT"}}, // Q111171651
    {Coordinate{16.7907, 47.9567}, CountryId{"AT"}}, // train station Jois
    {Coordinate{16.2669, 47.7928}, CountryId{"AT"}}, // Bahnhof Katzelsdorf
    {Coordinate{15.7034, 47.1054}, CountryId{"AT"}}, // Q111171655
    {Coordinate{16.3213, 47.8614}, CountryId{"AT"}}, // Bahnhof Untereggendorf
    {Coordinate{16.9305, 47.7335}, CountryId{"AT"}}, // Bahnhof Wallern im Burgenland
    {Coordinate{16.4169, 47.9307}, CountryId{"AT"}}, // Bahnhof Wampersdorf
    {Coordinate{16.8638, 47.9257}, CountryId{"AT"}}, // Bahnhof Weiden am See
    {Coordinate{16.4128, 47.9521}, CountryId{"AT"}}, // Bahnhof Weigelsdorf
    {Coordinate{15.1425, 48.1321}, CountryId{"AT"}}, // Q111171662
    {Coordinate{16.759, 47.947}, CountryId{"AT"}}, // Bahnhof Winden
    {Coordinate{16.4906, 47.7893}, CountryId{"AT"}}, // Bahnhof Wulkaprodersdorf
    {Coordinate{15.3232, 47.129}, CountryId{"AT"}}, // Gratwein-Gratkorn railway station
    {Coordinate{16.3251, 48.0443}, CountryId{"AT"}}, // Guntramsdorf-Kaiserau railway station
    {Coordinate{16.3863, 48.0325}, CountryId{"AT"}}, // Bahnhof Münchendorf
    {Coordinate{16.0139, 47.0287}, CountryId{"AT"}}, // Söchau railway station
    {Coordinate{16.0137, 47.1703}, CountryId{"AT"}}, // Bad Waltersdorf railway station
    {Coordinate{16.3247, 47.7741}, CountryId{"AT"}}, // Bahnhof Bad Sauerbrunn
    {Coordinate{15.771, 46.7113}, CountryId{"AT"}}, // Bahnhof Mureck
    {Coordinate{16.3813, 47.8685}, CountryId{"AT"}}, // Bahnhof Neufeld/Leitha
    {Coordinate{16.8512, 47.9921}, CountryId{"AT"}}, // train station Parndorf Ort
    {Coordinate{16.8677, 48.1059}, CountryId{"AT"}}, // Bahnhof Petronell-Carnuntum
    {Coordinate{16.3962, 47.9054}, CountryId{"AT"}}, // Bahnhof Pottendorf-Landegg
    {Coordinate{16.6986, 47.9063}, CountryId{"AT"}}, // Bahnhof Purbach/Neusiedler See
    {Coordinate{16.6881, 48.1097}, CountryId{"AT"}}, // Bahnhof Maria Ellend a.d. Donau
    {Coordinate{16.9108, 48.1328}, CountryId{"AT"}}, // Bahnhof Bad Deutsch Altenburg
    {Coordinate{15.9109, 47.8769}, CountryId{"AT"}}, // Bahnhof Gutenstein
    {Coordinate{16.1731, 47.8268}, CountryId{"AT"}}, // Bad Fischau-Brunn railway station
    {Coordinate{16.1715, 47.8314}, CountryId{"AT"}}, // Bad Fischau railway station
    {Coordinate{15.7537, 48.2004}, CountryId{"AT"}}, // Böheimkirchen railway station
    {Coordinate{16.0566, 47.1234}, CountryId{"AT"}}, // Bad Blumau railway station
    {Coordinate{13.9678, 48.2231}, CountryId{"AT"}}, // Q111171693
    {Coordinate{16.1874, 47.9213}, CountryId{"AT"}}, // Bahnhof Enzesfeld-Lindabrunn
    {Coordinate{15.6674, 47.1793}, CountryId{"AT"}}, // Q111171695
    {Coordinate{16.5122, 48.6434}, CountryId{"AT"}}, // Bahnhof Frättingsdorf
    {Coordinate{16.5697, 48.3541}, CountryId{"AT"}}, // Q111171698
    {Coordinate{16.0611, 47.4405}, CountryId{"AT"}}, // Pinggau Markt railway station
    {Coordinate{15.7749, 46.9988}, CountryId{"AT"}}, // Studenzen-Fladnitz railway station
    {Coordinate{16.4919, 47.7007}, CountryId{"AT"}}, // Bahnhof Loipersbach-Schattendorf
    {Coordinate{16.2972, 47.8499}, CountryId{"AT"}}, // Bahnhof Obereggendorf
    {Coordinate{16.8454, 47.9426}, CountryId{"AT"}}, // train station Neusiedl am See Bad
    {Coordinate{14.8416, 46.7638}, CountryId{"AT"}}, // train station St.Andrä im Lavanttal
    {Coordinate{16.6423, 48.368}, CountryId{"AT"}}, // Auersthal railway station
    {Coordinate{16.0219, 47.4186}, CountryId{"AT"}}, // Dechantskirchen railway station
    {Coordinate{16.8601, 48.4698}, CountryId{"AT"}}, // Dürnkrut railway station
    {Coordinate{16.1288, 47.6792}, CountryId{"AT"}}, // Gleißenfeld railway station
    {Coordinate{16.6395, 48.2421}, CountryId{"AT"}}, // Bahnhof Glinzendorf
    {Coordinate{15.8532, 46.9618}, CountryId{"AT"}}, // Gniebing railway station
    {Coordinate{16.4837, 48.2933}, CountryId{"AT"}}, // Gerasdorf railway station
    {Coordinate{15.9979, 47.7975}, CountryId{"AT"}}, // Bahnhof Grünbach am Schneeberg
    {Coordinate{15.7976, 46.7244}, CountryId{"AT"}}, // Bahnhof Gosdorf
    {Coordinate{16.0603, 46.9442}, CountryId{"AT"}}, // Hohenbrugg an der Raab railway station
    {Coordinate{16.7104, 48.1097}, CountryId{"AT"}}, // Bahnhof Haslau
    {Coordinate{15.3439, 47.1185}, CountryId{"AT"}}, // Judendorf-Straßengel railway station
    {Coordinate{16.8783, 48.495}, CountryId{"AT"}}, // Jedenspeigen railway station
    {Coordinate{16.4951, 48.3168}, CountryId{"AT"}}, // Bahnhof Kapellerfeld
    {Coordinate{16.4643, 48.7035}, CountryId{"AT"}}, // Bahnhof Kottingneusiedl
    {Coordinate{15.593, 48.0138}, CountryId{"AT"}}, // Bahnhof Lilienfeld
    {Coordinate{15.6563, 47.0881}, CountryId{"AT"}}, // Laßnitzthal railway station
    {Coordinate{15.9455, 46.9547}, CountryId{"AT"}}, // Lödersdorf railway station
    {Coordinate{16.4027, 48.7237}, CountryId{"AT"}}, // Bahnhof Laa an der Thaya
    {Coordinate{15.497, 48.1964}, CountryId{"AT"}}, // Markersdorf an der Pielach railway station
    {Coordinate{15.9341, 48.2965}, CountryId{"AT"}}, // Michelhausen train station
    {Coordinate{15.1355, 48.111}, CountryId{"AT"}}, // Bahnhof Mühling
    {Coordinate{16.5636, 48.5657}, CountryId{"AT"}}, // Bahnhof Mistelbach
    {Coordinate{16.4798, 48.478}, CountryId{"AT"}}, // Bahnhof Niederkreuzstetten
    {Coordinate{14.7448, 47.9023}, CountryId{"AT"}}, // Bahnhof Oberland
    {Coordinate{16.0972, 47.8745}, CountryId{"AT"}}, // Q111172012
    {Coordinate{15.9793, 47.8934}, CountryId{"AT"}}, // Bahnhof Ortmann
    {Coordinate{16.0895, 47.9614}, CountryId{"AT"}}, // Q111172014
    {Coordinate{15.9103, 47.7904}, CountryId{"AT"}}, // Bahnhof Puchberg am Schneeberg
    {Coordinate{16.5819, 48.239}, CountryId{"AT"}}, // Bahnhof Raasdorf
    {Coordinate{16.8947, 48.6519}, CountryId{"AT"}}, // Rabensburg railway station
    {Coordinate{16.6673, 48.3996}, CountryId{"AT"}}, // Raggendorf railway station
    {Coordinate{15.137, 48.079}, CountryId{"AT"}}, // Bahnhof Schauboden
    {Coordinate{16.3059, 47.9555}, CountryId{"AT"}}, // Tattendorf railway station
    {Coordinate{16.6435, 48.0242}, CountryId{"AT"}}, // Bahnhof Trautmannsdorf an der Leitha
    {Coordinate{16.2898, 47.9425}, CountryId{"AT"}}, // Teesdorf railway station
    {Coordinate{16.3323, 47.9925}, CountryId{"AT"}}, // Trumau railway station
    {Coordinate{16.0743, 47.098}, CountryId{"AT"}}, // Bierbaum railway station
    {Coordinate{16.0035, 47.3466}, CountryId{"AT"}}, // Grafendorf railway station
    {Coordinate{16.1279, 47.6169}, CountryId{"AT"}}, // Edlitz-Grimmenstein railway station
    {Coordinate{14.5061, 48.3303}, CountryId{"AT"}}, // Bahnhof Gaisbach-Wartberg
    {Coordinate{13.9748, 48.2098}, CountryId{"AT"}}, // Haiding railway station
    {Coordinate{13.9589, 47.9006}, CountryId{"AT"}}, // Scharnstein-Mühldorf railway station
    {Coordinate{16.9494, 47.8735}, CountryId{"AT"}}, // train station Mönchhof-Halbturn
    {Coordinate{16.3006, 47.7938}, CountryId{"AT"}}, // Bahnhof Neudörfl
    {Coordinate{14.0556, 48.0387}, CountryId{"AT"}}, // Großendorf railway station
    {Coordinate{15.6001, 48.0215}, CountryId{"AT"}}, // Haltestelle Marktl
    {Coordinate{15.3224, 47.1775}, CountryId{"AT"}}, // Stübing railway station
    {Coordinate{14.7564, 48.0697}, CountryId{"AT"}}, // Aschbach railway station
    {Coordinate{15.2559, 47.219}, CountryId{"AT"}}, // Guggenbach railway station
    {Coordinate{15.2517, 47.2194}, CountryId{"AT"}}, // Guggenbach Warthkogelsiedlung railway station
    {Coordinate{16.2423, 47.7507}, CountryId{"AT"}}, // Lanzenkirchen railway station
    {Coordinate{16.5101, 48.5362}, CountryId{"AT"}}, // Bahnhof Ladendorf
    {Coordinate{16.8336, 48.3064}, CountryId{"AT"}}, // Bahnhof Oberweiden
    {Coordinate{16.5352, 48.5468}, CountryId{"AT"}}, // Bahnhof Paasdorf
    {Coordinate{16.6058, 48.4485}, CountryId{"AT"}}, // Bad Pirawarth railway station
    {Coordinate{16.1241, 47.8746}, CountryId{"AT"}}, // Bahnhof Piesting
    {Coordinate{15.7428, 48.0478}, CountryId{"AT"}}, // Q111172096
    {Coordinate{16.5312, 48.6114}, CountryId{"AT"}}, // Bahnhof Siebenhirten
    {Coordinate{16.891, 48.5111}, CountryId{"AT"}}, // Sierndorf an der March railway station
    {Coordinate{14.6132, 48.075}, CountryId{"AT"}}, // St. Johann-Weistrach railway station
    {Coordinate{16.8072, 48.251}, CountryId{"AT"}}, // Bahnhof Schönfeld-Lassee
    {Coordinate{15.668, 47.1518}, CountryId{"AT"}}, // Q111172102
    {Coordinate{16.6344, 48.3186}, CountryId{"AT"}}, // Bahnhof Strasshof
    {Coordinate{16.4926, 48.6997}, CountryId{"AT"}}, // Bahnhof Staatz
    {Coordinate{15.5785, 48.009}, CountryId{"AT"}}, // Bahnhof Lilienfeld Krankenhaus
    {Coordinate{15.6718, 48.0451}, CountryId{"AT"}}, // Q111172107
    {Coordinate{16.1491, 47.9332}, CountryId{"AT"}}, // Bahnhof St. Veit an der Triesting
    {Coordinate{16.7862, 48.3636}, CountryId{"AT"}}, // Tallesbrunn railway station
    {Coordinate{16.4881, 48.4021}, CountryId{"AT"}}, // Bahnhof Ulrichskirchen
    {Coordinate{16.0585, 47.8689}, CountryId{"AT"}}, // Q111172111
    {Coordinate{16.7633, 48.3388}, CountryId{"AT"}}, // Bahnhof Weikendorf
    {Coordinate{15.3243, 47.2069}, CountryId{"AT"}}, // Zitoll railway station
    {Coordinate{17.0238, 47.9681}, CountryId{"AT"}}, // train station Zurndorf
    {Coordinate{53.5304, 57.9199}, CountryId{"RU"}}, // Q111172120
    {Coordinate{53.5894, 57.8992}, CountryId{"RU"}}, // Q111172121
    {Coordinate{53.6415, 57.9078}, CountryId{"RU"}}, // Q111172122
    {Coordinate{53.9721, 57.9555}, CountryId{"RU"}}, // Q111172123
    {Coordinate{54.1452, 57.9572}, CountryId{"RU"}}, // Q111172125
    {Coordinate{54.2243, 57.9588}, CountryId{"RU"}}, // Q111172126
    {Coordinate{54.2758, 57.9615}, CountryId{"RU"}}, // Q111172128
    {Coordinate{54.3866, 57.9992}, CountryId{"RU"}}, // Q111172129
    {Coordinate{54.4529, 58.0401}, CountryId{"RU"}}, // Q111172130
    {Coordinate{54.6107, 58.0333}, CountryId{"RU"}}, // Q111172131
    {Coordinate{54.6365, 58.0607}, CountryId{"RU"}}, // Q111172132
    {Coordinate{54.7312, 58.1276}, CountryId{"RU"}}, // Q111172134
    {Coordinate{54.7793, 58.1279}, CountryId{"RU"}}, // Q111172135
    {Coordinate{54.848, 58.1479}, CountryId{"RU"}}, // Q111172136
    {Coordinate{54.9259, 58.1462}, CountryId{"RU"}}, // Q111172138
    {Coordinate{54.9936, 58.1662}, CountryId{"RU"}}, // Q111172139
    {Coordinate{55.0609, 58.2311}, CountryId{"RU"}}, // Q111172140
    {Coordinate{55.1565, 58.2515}, CountryId{"RU"}}, // Q111172141
    {Coordinate{55.1947, 58.2434}, CountryId{"RU"}}, // Q111172143
    {Coordinate{55.2566, 58.2339}, CountryId{"RU"}}, // Q111172144
    {Coordinate{55.3064, 58.216}, CountryId{"RU"}}, // Q111172145
    {Coordinate{55.3715, 58.1873}, CountryId{"RU"}}, // Q111172146
    {Coordinate{55.3894, 58.1792}, CountryId{"RU"}}, // Q111172147
    {Coordinate{55.4245, 58.1704}, CountryId{"RU"}}, // Q111172148
    {Coordinate{55.4711, 58.1503}, CountryId{"RU"}}, // Q111172149
    {Coordinate{55.5245, 58.1336}, CountryId{"RU"}}, // Chaykovskaya railway station
    {Coordinate{55.5833, 58.131}, CountryId{"RU"}}, // Q111172151
    {Coordinate{55.6466, 58.1365}, CountryId{"RU"}}, // Q111172152
    {Coordinate{55.683, 58.1377}, CountryId{"RU"}}, // Q111172153
    {Coordinate{55.725, 58.1402}, CountryId{"RU"}}, // Q111172154
    {Coordinate{55.8142, 58.1201}, CountryId{"RU"}}, // Q111172155
    {Coordinate{55.8336, 58.113}, CountryId{"RU"}}, // Q111172156
    {Coordinate{55.8683, 58.0861}, CountryId{"RU"}}, // Q111172157
    {Coordinate{55.9078, 58.059}, CountryId{"RU"}}, // Q111172158
    {Coordinate{55.9589, 58.0711}, CountryId{"RU"}}, // Q111172159
    {Coordinate{16.6783, 48.3283}, CountryId{"AT"}}, // Bahnhof Silberwald
    {Coordinate{15.6952, 47.1231}, CountryId{"AT"}}, // Q111172225
    {Coordinate{14.5904, 48.2562}, CountryId{"AT"}}, // Bahnhof Aisthofen
    {Coordinate{13.9785, 48.2608}, CountryId{"AT"}}, // Q111172228
    {Coordinate{16.1338, 47.9403}, CountryId{"AT"}}, // Bahnhof Berndorf Fabrik
    {Coordinate{16.1087, 47.9448}, CountryId{"AT"}}, // Bahnhof Berndorf Stadt
    {Coordinate{13.6313, 48.1009}, CountryId{"AT"}}, // Bergern am Hausruck railway station
    {Coordinate{16.1883, 47.7225}, CountryId{"AT"}}, // Brunn an der Pitten railway station
    {Coordinate{16.1573, 47.8256}, CountryId{"AT"}}, // Bahnhof Brunn an der Schneebergbahn
    {Coordinate{16.5366, 47.8438}, CountryId{"AT"}}, // Bahnhof Eisenstadt Schule
    {Coordinate{16.3586, 48.1127}, CountryId{"AT"}}, // Bahnhof Hennersdorf
    {Coordinate{14.5054, 48.3417}, CountryId{"AT"}}, // Bahnhof Schloss Haus
    {Coordinate{15.4029, 47.482}, CountryId{"AT"}}, // Allerheiligen-Mürzhofen railway station
    {Coordinate{16.8776, 48.2548}, CountryId{"AT"}}, // Breitensee NÖ train station
    {Coordinate{14.7541, 47.9831}, CountryId{"AT"}}, // Q111172305
    {Coordinate{16.511, 48.6728}, CountryId{"AT"}}, // Bahnhof Enzersdorf bei Staatz
    {Coordinate{14.893, 47.2517}, CountryId{"AT"}}, // Fentsch-St. Lorenzen railway station
    {Coordinate{16.4202, 48.2707}, CountryId{"AT"}}, // Wien Siemensstraße railway station
    {Coordinate{14.8512, 48.2207}, CountryId{"AT"}}, // Bahnhof Grein-Bad Kreuzen
    {Coordinate{15.9719, 47.7982}, CountryId{"AT"}}, // Bahnhof Grünbach Kohlenwerk
    {Coordinate{16.4451, 48.0823}, CountryId{"AT"}}, // Bahnhof Himberg
    {Coordinate{15.7686, 48.0394}, CountryId{"AT"}}, // Q111172313
    {Coordinate{16.4392, 48.1333}, CountryId{"AT"}}, // Kledering railway station
    {Coordinate{15.3082, 47.2129}, CountryId{"AT"}}, // Prenning railway station
    {Coordinate{16.73, 48.3824}, CountryId{"AT"}}, // Prottes railway station
    {Coordinate{15.5261, 48.2031}, CountryId{"AT"}}, // Prinzersdorf railway station
    {Coordinate{14.4595, 48.0677}, CountryId{"AT"}}, // Ramingdorf-Haidershofen railway station
    {Coordinate{14.7418, 48.0105}, CountryId{"AT"}}, // Bahnhof Rosenau
    {Coordinate{15.1138, 48.1926}, CountryId{"AT"}}, // Säusenstein railway station
    {Coordinate{14.8201, 48.1919}, CountryId{"AT"}}, // Dornach bei Grein
    {Coordinate{16.1101, 47.8725}, CountryId{"AT"}}, // Bahnhof Dreistetten
    {Coordinate{14.3538, 47.9784}, CountryId{"AT"}}, // Dürnbach/Enns railway station
    {Coordinate{14.1923, 48.3315}, CountryId{"AT"}}, // Q111172385
    {Coordinate{14.3985, 47.57}, CountryId{"AT"}}, // Q111172386
    {Coordinate{14.3235, 48.2859}, CountryId{"AT"}}, // Bahnhof Linz Franckstraße
    {Coordinate{14.8385, 48.108}, CountryId{"AT"}}, // Bahnhof Greinsfurth
    {Coordinate{15.2658, 47.2186}, CountryId{"AT"}}, // Guggenbach Pulverwerksiedlung railway station
    {Coordinate{14.7617, 48.0225}, CountryId{"AT"}}, // Q111172390
    {Coordinate{16.9322, 48.1448}, CountryId{"AT"}}, // Q111172392
    {Coordinate{16.9481, 48.1483}, CountryId{"AT"}}, // Bahnhof Hainburg Ungartor
    {Coordinate{16.4929, 48.4513}, CountryId{"AT"}}, // Bahnhof Hautzendorf
    {Coordinate{16.5167, 48.3623}, CountryId{"AT"}}, // Obersdorf NÖ railway station
    {Coordinate{15.5747, 48.0014}, CountryId{"AT"}}, // Bahnhof Schrambach
    {Coordinate{14.4492, 48.0476}, CountryId{"AT"}}, // Steyr Münichholz railway station
    {Coordinate{16.3031, 48.0174}, CountryId{"AT"}}, // Traiskirchen Aspangbahn railway station
    {Coordinate{15.6124, 48.0568}, CountryId{"AT"}}, // Q111172399
    {Coordinate{15.2741, 47.2184}, CountryId{"AT"}}, // Himberg bei Übelbach railway station
    {Coordinate{15.47, 46.9643}, CountryId{"AT"}}, // Kalsdorf railway station
    {Coordinate{13.9938, 48.3521}, CountryId{"AT"}}, // Q111172616
    {Coordinate{15.6079, 48.1006}, CountryId{"AT"}}, // Bahnhof Kreisbach
    {Coordinate{14.638, 47.8507}, CountryId{"AT"}}, // Bahnhof Kastenreith
    {Coordinate{15.1598, 48.2078}, CountryId{"AT"}}, // Krummnußbaum railway station
    {Coordinate{14.6992, 48.0552}, CountryId{"AT"}}, // Krenstetten-Biberbach railway station
    {Coordinate{14.6109, 47.8583}, CountryId{"AT"}}, // Q111172621
    {Coordinate{15.405, 48.1948}, CountryId{"AT"}}, // Loosdorf bei Melk railway station
    {Coordinate{14.4784, 48.2887}, CountryId{"AT"}}, // Bahnhof Lungitz
    {Coordinate{14.0998, 48.2011}, CountryId{"AT"}}, // Marchtrenk railway station
    {Coordinate{15.8481, 48.1916}, CountryId{"AT"}}, // Ollersbach railway station
    {Coordinate{15.7019, 48.2237}, CountryId{"AT"}}, // Pottenbrunn railway station
    {Coordinate{14.3937, 48.2783}, CountryId{"AT"}}, // Q111172628
    {Coordinate{16.7807, 48.107}, CountryId{"AT"}}, // Bahnhof Regelsbrunn
    {Coordinate{16.6545, 48.3898}, CountryId{"AT"}}, // Raggendorf Markt railway station
    {Coordinate{15.6144, 48.1378}, CountryId{"AT"}}, // Q111172631
    {Coordinate{10.7683, 48.1787}, CountryId{"DE"}}, // Schwabmünchen station
    {Coordinate{55.7709, 58.0747}, CountryId{"RU"}}, // Q111177132
    {Coordinate{24.992, 55.826}, CountryId{"LT"}}, // Kupiškis train station
    {Coordinate{59.3381, 57.0865}, CountryId{"RU"}}, // Q111183612
    {Coordinate{56.7835, 57.4563}, CountryId{"RU"}}, // Q111193503
    {Coordinate{56.8913, 57.4564}, CountryId{"RU"}}, // Q111193504
    {Coordinate{56.9211, 57.4231}, CountryId{"RU"}}, // Q111193505
    {Coordinate{56.9589, 57.4209}, CountryId{"RU"}}, // Q111193506
    {Coordinate{57.1129, 57.381}, CountryId{"RU"}}, // Q111193507
    {Coordinate{57.1545, 57.3521}, CountryId{"RU"}}, // Q111193508
    {Coordinate{57.2447, 57.3618}, CountryId{"RU"}}, // Q111193509
    {Coordinate{57.2842, 57.3754}, CountryId{"RU"}}, // Q111193511
    {Coordinate{57.3093, 57.3935}, CountryId{"RU"}}, // Q111193512
    {Coordinate{57.3602, 57.3751}, CountryId{"RU"}}, // Q111193513
    {Coordinate{57.4194, 57.3801}, CountryId{"RU"}}, // Q111193514
    {Coordinate{57.4532, 57.3916}, CountryId{"RU"}}, // Q111193515
    {Coordinate{57.5079, 57.4145}, CountryId{"RU"}}, // Q111193516
    {Coordinate{57.6241, 57.433}, CountryId{"RU"}}, // Q111193517
    {Coordinate{57.7628, 57.4035}, CountryId{"RU"}}, // Q111193518
    {Coordinate{57.9213, 57.4115}, CountryId{"RU"}}, // Q111193519
    {Coordinate{57.9868, 57.3764}, CountryId{"RU"}}, // Q111193520
    {Coordinate{58.0623, 57.3444}, CountryId{"RU"}}, // Q111193521
    {Coordinate{58.1344, 57.3258}, CountryId{"RU"}}, // Q111193522
    {Coordinate{58.2237, 57.3497}, CountryId{"RU"}}, // Q111193523
    {Coordinate{58.3714, 57.3436}, CountryId{"RU"}}, // Q111193525
    {Coordinate{58.5256, 57.3327}, CountryId{"RU"}}, // Q111193526
    {Coordinate{58.6388, 57.2713}, CountryId{"RU"}}, // Q111193527
    {Coordinate{58.7337, 57.2474}, CountryId{"RU"}}, // Q111193528
    {Coordinate{58.8607, 57.2291}, CountryId{"RU"}}, // Q111193529
    {Coordinate{58.9414, 57.1975}, CountryId{"RU"}}, // Q111193530
    {Coordinate{59.1177, 57.1454}, CountryId{"RU"}}, // Q111193531
    {Coordinate{59.194, 57.1116}, CountryId{"RU"}}, // Q111193532
    {Coordinate{8.34243, 49.7651}, CountryId{"DE"}}, // Alsheim
    {Coordinate{11.48, 48.0187}, CountryId{"DE"}}, // Baierbrunn station
    {Coordinate{11.4974, 48.0313}, CountryId{"DE"}}, // Buchenhain station
    {Coordinate{59.5824, 57.0076}, CountryId{"RU"}}, // Q111204096
    {Coordinate{59.7288, 56.937}, CountryId{"RU"}}, // Q111204098
    {Coordinate{60.4051, 56.8807}, CountryId{"RU"}}, // Q111204099
    {Coordinate{6.91389, 46.4789}, CountryId{"CH"}}, // Lally railway station
    {Coordinate{57.7298, 58.1901}, CountryId{"RU"}}, // Q111206053
    {Coordinate{57.7809, 58.1118}, CountryId{"RU"}}, // Q111206055
    {Coordinate{57.7818, 58.0867}, CountryId{"RU"}}, // Q111206057
    {Coordinate{57.8086, 58.0601}, CountryId{"RU"}}, // Q111206059
    {Coordinate{58.0265, 57.868}, CountryId{"RU"}}, // Q111206064
    {Coordinate{58.355, 57.8627}, CountryId{"RU"}}, // Q111206066
    {Coordinate{58.5137, 57.7982}, CountryId{"RU"}}, // Q111206068
    {Coordinate{58.6277, 57.6862}, CountryId{"RU"}}, // Q111206070
    {Coordinate{58.6081, 57.638}, CountryId{"RU"}}, // Q111206072
    {Coordinate{58.6872, 57.5862}, CountryId{"RU"}}, // Q111206074
    {Coordinate{58.8123, 57.4567}, CountryId{"RU"}}, // Q111206076
    {Coordinate{58.958, 57.3658}, CountryId{"RU"}}, // Q111206078
    {Coordinate{59.0143, 57.2749}, CountryId{"RU"}}, // Q111206080
    {Coordinate{59.0641, 57.2488}, CountryId{"RU"}}, // Q111206083
    {Coordinate{59.2663, 57.1854}, CountryId{"RU"}}, // Q111206085
    {Coordinate{59.3433, 57.1649}, CountryId{"RU"}}, // Q111206087
    {Coordinate{59.6014, 56.7749}, CountryId{"RU"}}, // Q111206690
    {Coordinate{59.6925, 56.817}, CountryId{"RU"}}, // Q111206691
    {Coordinate{59.7188, 56.8047}, CountryId{"RU"}}, // Q111206693
    {Coordinate{59.7686, 56.7699}, CountryId{"RU"}}, // Q111206694
    {Coordinate{59.7686, 56.7699}, CountryId{"RU"}}, // Q111206696
    {Coordinate{59.9554, 56.8196}, CountryId{"RU"}}, // Q111206697
    {Coordinate{59.979, 56.8206}, CountryId{"RU"}}, // Q111206698
    {Coordinate{60.0348, 56.8115}, CountryId{"RU"}}, // Q111206699
    {Coordinate{60.1489, 56.8338}, CountryId{"RU"}}, // Q111206701
    {Coordinate{60.2207, 56.837}, CountryId{"RU"}}, // Q111206702
    {Coordinate{60.2546, 56.8464}, CountryId{"RU"}}, // Q111206703
    {Coordinate{60.3255, 56.8565}, CountryId{"RU"}}, // Q111206704
    {Coordinate{60.3714, 56.8626}, CountryId{"RU"}}, // Q111206705
    {Coordinate{60.1033, 56.8242}, CountryId{"RU"}}, // Q111206715
    {Coordinate{61.9673, 56.399}, CountryId{"RU"}}, // Q111219330
    {Coordinate{61.9553, 56.3785}, CountryId{"RU"}}, // Q111219331
    {Coordinate{61.945, 56.3538}, CountryId{"RU"}}, // Q111219332
    {Coordinate{61.9027, 56.3001}, CountryId{"RU"}}, // Q111219333
    {Coordinate{61.9002, 56.2931}, CountryId{"RU"}}, // Q111219335
    {Coordinate{61.8965, 56.2412}, CountryId{"RU"}}, // Q111219336
    {Coordinate{61.8874, 56.1944}, CountryId{"RU"}}, // Q111219337
    {Coordinate{61.9114, 56.1522}, CountryId{"RU"}}, // Q111219357
    {Coordinate{13.3869, 52.5203}, CountryId{"DE"}}, // S-Bahnhof Friedrichstraße
    {Coordinate{60.698, 56.8175}, CountryId{"RU"}}, // Putyovka
    {Coordinate{60.7277, 56.7949}, CountryId{"RU"}}, // Q111222291
    {Coordinate{60.7754, 56.7871}, CountryId{"RU"}}, // Q111222292
    {Coordinate{60.9899, 56.7137}, CountryId{"RU"}}, // Q111222295
    {Coordinate{61.0452, 56.6812}, CountryId{"RU"}}, // Q111222296
    {Coordinate{61.1355, 56.6604}, CountryId{"RU"}}, // Q111222297
    {Coordinate{61.1841, 56.6419}, CountryId{"RU"}}, // Q111222298
    {Coordinate{61.2244, 56.632}, CountryId{"RU"}}, // Q111222299
    {Coordinate{61.2558, 56.6233}, CountryId{"RU"}}, // Q111222300
    {Coordinate{61.2868, 56.6143}, CountryId{"RU"}}, // Q111222301
    {Coordinate{61.3125, 56.594}, CountryId{"RU"}}, // Q111222303
    {Coordinate{61.3559, 56.5857}, CountryId{"RU"}}, // Q111222304
    {Coordinate{61.3987, 56.5627}, CountryId{"RU"}}, // Q111222306
    {Coordinate{61.4469, 56.5499}, CountryId{"RU"}}, // Q111222307
    {Coordinate{61.5328, 56.5199}, CountryId{"RU"}}, // Q111222308
    {Coordinate{61.5789, 56.4975}, CountryId{"RU"}}, // Q111222310
    {Coordinate{61.634, 56.4848}, CountryId{"RU"}}, // Q111222311
    {Coordinate{61.6914, 56.471}, CountryId{"RU"}}, // Q111222312
    {Coordinate{61.7613, 56.4618}, CountryId{"RU"}}, // Q111222314
    {Coordinate{61.8295, 56.4529}, CountryId{"RU"}}, // Q111222315
    {Coordinate{61.8906, 56.4327}, CountryId{"RU"}}, // Q111222316
    {Coordinate{61.9569, 56.4226}, CountryId{"RU"}}, // Q111222908
    {Coordinate{62.0442, 56.4126}, CountryId{"RU"}}, // Q111222909
    {Coordinate{62.1512, 56.3938}, CountryId{"RU"}}, // Q111222910
    {Coordinate{19.9675, 46.4661}, CountryId{"HU"}}, // Kistelek railway station
    {Coordinate{23.135, 54.71}, CountryId{"LT"}}, // Alksnėnai train station
    {Coordinate{22.9823, 56.0345}, CountryId{"LT"}}, // Kuršėnai train station
    {Coordinate{23.34, 54.727}, CountryId{"LT"}}, // Bagotoji train station
    {Coordinate{23.022, 54.686}, CountryId{"LT"}}, // Vilkaviškis train station
    {Coordinate{13.3894, 52.5486}, CountryId{"DE"}}, // S-Bahnhof Berlin-Gesundbrunnen
    {Coordinate{57.281, 58.1037}, CountryId{"RU"}}, // Q111239744
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // S-Bahnhof Berlin-Hauptbahnhof
    {Coordinate{33.0346, 68.8787}, CountryId{"RU"}}, // 1437 km
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // Berlin Hauptbahnhof (tief)
    {Coordinate{33.0247, 68.852}, CountryId{"RU"}}, // 1434 km
    {Coordinate{33.0815, 68.8366}, CountryId{"RU"}}, // Vykhodnoy
    {Coordinate{13.3694, 52.5251}, CountryId{"DE"}}, // Berlin Hauptbahnhof (Stadtbahn)
    {Coordinate{13.4747, 52.5142}, CountryId{"DE"}}, // S-Bahnhof Frankfurter Allee
    {Coordinate{13.4689, 52.5031}, CountryId{"DE"}}, // S-Bahnhof Ostkreuz
    {Coordinate{13.3326, 52.5782}, CountryId{"DE"}}, // S-Bahnhof Karl-Bonhoeffer-Nervenklinik
    {Coordinate{57.4093, 58.1415}, CountryId{"RU"}}, // Q111261549
    {Coordinate{57.476, 58.1723}, CountryId{"RU"}}, // Q111261550
    {Coordinate{57.5693, 58.1988}, CountryId{"RU"}}, // Q111261551
    {Coordinate{33.0986, 68.7942}, CountryId{"RU"}}, // 1425 km
    {Coordinate{13.4311, 52.4675}, CountryId{"DE"}}, // S-Bahnhof Hermannstraße
    {Coordinate{13.3439, 52.4786}, CountryId{"DE"}}, // S-Bahnhof Innsbrucker Platz
    {Coordinate{13.3216, 52.4562}, CountryId{"DE"}}, // S-Bahnhof Rathaus Steglitz
    {Coordinate{13.3343, 52.597}, CountryId{"DE"}}, // S-Bahnhof Berlin-Wittenau
    {Coordinate{13.3854, 52.4708}, CountryId{"DE"}}, // S-Bahnhof Berlin-Tempelhof
    {Coordinate{13.4137, 52.5493}, CountryId{"DE"}}, // S-Bahnhof Schönhauser Allee
    {Coordinate{57.9142, 58.3475}, CountryId{"RU"}}, // Q111265677
    {Coordinate{57.973, 58.3623}, CountryId{"RU"}}, // Q111265678
    {Coordinate{58.0624, 58.3608}, CountryId{"RU"}}, // Q111265679
    {Coordinate{58.2132, 58.3942}, CountryId{"RU"}}, // Q111265680
    {Coordinate{58.3237, 58.3801}, CountryId{"RU"}}, // Q111265681
    {Coordinate{58.4954, 58.4182}, CountryId{"RU"}}, // Q111265682
    {Coordinate{58.6569, 58.473}, CountryId{"RU"}}, // Q111265683
    {Coordinate{58.7779, 58.5034}, CountryId{"RU"}}, // Q111265685
    {Coordinate{58.88, 58.5144}, CountryId{"RU"}}, // Q111265686
    {Coordinate{59.4651, 58.4102}, CountryId{"RU"}}, // Q111265687
    {Coordinate{59.6617, 58.3159}, CountryId{"RU"}}, // Q111265688
    {Coordinate{33.16, 68.7538}, CountryId{"RU"}}, // Shonguy
    {Coordinate{33.1348, 68.7375}, CountryId{"RU"}}, // 1417 km
    {Coordinate{33.1221, 68.6991}, CountryId{"RU"}}, // 1410 km
    {Coordinate{33.1265, 68.68}, CountryId{"RU"}}, // Magnetity
    {Coordinate{33.2188, 68.6368}, CountryId{"RU"}}, // Loparskaya
    {Coordinate{14.0355, 46.5309}, CountryId{"AT"}}, // Q111267099
    {Coordinate{16.391, 48.1779}, CountryId{"AT"}}, // Q111267113
    {Coordinate{13.9133, 46.5644}, CountryId{"AT"}}, // Q111267114
    {Coordinate{16.5179, 47.7278}, CountryId{"AT"}}, // Bahnhof Baumgarten-Schattendorf
    {Coordinate{15.7579, 47.0457}, CountryId{"AT"}}, // Takern-St. Margarethen railway station
    {Coordinate{16.9812, 48.0106}, CountryId{"AT"}}, // Bahnhof Gattendorf
    {Coordinate{13.1335, 48.1608}, CountryId{"AT"}}, // Q111267118
    {Coordinate{16.3698, 47.7534}, CountryId{"AT"}}, // Bahnhof Wiesen-Sigleß
    {Coordinate{17.0715, 48.0814}, CountryId{"AT"}}, // Bahnhof Kittsee
    {Coordinate{16.9383, 48.0089}, CountryId{"AT"}}, // Haltstelle Neudorf
    {Coordinate{13.1524, 48.1087}, CountryId{"AT"}}, // Bahnhof Mattighofen
    {Coordinate{12.5951, 46.7696}, CountryId{"AT"}}, // Q111267124
    {Coordinate{14.716, 46.5986}, CountryId{"AT"}}, // Q111267125
    {Coordinate{14.4311, 47.9241}, CountryId{"AT"}}, // Bahnhof Losenstein
    {Coordinate{14.5223, 48.356}, CountryId{"AT"}}, // Bahnhof Pregarten
    {Coordinate{17.0414, 48.0421}, CountryId{"AT"}}, // Bahnhof Pama
    {Coordinate{15.4496, 46.9977}, CountryId{"AT"}}, // Flughafen Graz-Feldkirchen railway station
    {Coordinate{13.1978, 48.0458}, CountryId{"AT"}}, // Q111267130
    {Coordinate{9.83892, 47.1363}, CountryId{"AT"}}, // Q111267131
    {Coordinate{14.4731, 48.0914}, CountryId{"AT"}}, // Dorf/Enns railway station
    {Coordinate{13.6285, 46.7329}, CountryId{"AT"}}, // Ferndorf in Kärnten railway station
    {Coordinate{13.8679, 46.5688}, CountryId{"AT"}}, // Q111267134
    {Coordinate{13.1398, 48.1319}, CountryId{"AT"}}, // Q111267136
    {Coordinate{14.3811, 46.7499}, CountryId{"AT"}}, // Q111267137
    {Coordinate{13.8469, 46.5684}, CountryId{"AT"}}, // Q111267138
    {Coordinate{14.0771, 48.3973}, CountryId{"AT"}}, // Q111267139
    {Coordinate{15.4576, 48.1881}, CountryId{"AT"}}, // Q111267140
    {Coordinate{15.9184, 48.1919}, CountryId{"AT"}}, // Bahnhof Hofstatt
    {Coordinate{16.5163, 48.6203}, CountryId{"AT"}}, // Bahnhof Hörersdorf
    {Coordinate{15.3291, 47.4547}, CountryId{"AT"}}, // Kapfenberg Fachhochschule railway station
    {Coordinate{13.6698, 48.2666}, CountryId{"AT"}}, // Kimpling railway station
    {Coordinate{15.8215, 48.1902}, CountryId{"AT"}}, // Kirchstetten railway station
    {Coordinate{14.9036, 47.3899}, CountryId{"AT"}}, // Kammern im Liesingtal railway station
    {Coordinate{13.9406, 47.8867}, CountryId{"AT"}}, // Kothmühle railway station
    {Coordinate{14.4756, 46.8376}, CountryId{"AT"}}, // Q111267149
    {Coordinate{14.789, 48.0426}, CountryId{"AT"}}, // Bahnhof Kröllendorf
    {Coordinate{14.3335, 46.6166}, CountryId{"AT"}}, // Q111267151
    {Coordinate{9.62448, 47.3086}, CountryId{"AT"}}, // Q111267153
    {Coordinate{14.0914, 48.3859}, CountryId{"AT"}}, // Q111267154
    {Coordinate{14.3738, 47.9948}, CountryId{"AT"}}, // Lahrndorf bei Garsten railway station
    {Coordinate{16.3555, 48.0769}, CountryId{"AT"}}, // Laxenburg-Biedermannsdorf railway station
    {Coordinate{14.3472, 48.2521}, CountryId{"AT"}}, // Linz/Donau Ebelsberg railway station
    {Coordinate{15.5322, 46.8549}, CountryId{"AT"}}, // Lebring railway station
    {Coordinate{15.6983, 46.7139}, CountryId{"AT"}}, // Bahnhof Lichendorf
    {Coordinate{14.254, 48.274}, CountryId{"AT"}}, // Leonding railway station
    {Coordinate{16.4475, 48.1132}, CountryId{"AT"}}, // Q111267162
    {Coordinate{14.5215, 48.4609}, CountryId{"AT"}}, // Bahnhof Lasberg-St. Oswald
    {Coordinate{13.6424, 46.7252}, CountryId{"AT"}}, // Paternion Markt railway station
    {Coordinate{14.3391, 46.6828}, CountryId{"AT"}}, // Maria Saal
    {Coordinate{15.3733, 47.4733}, CountryId{"AT"}}, // St. Marein im Mürztal-St. Lorenzen railway station
    {Coordinate{14.3742, 47.1043}, CountryId{"AT"}}, // Mariahof-St. Lambrecht railway station
    {Coordinate{14.2585, 48.1895}, CountryId{"AT"}}, // Bahnhof Nettingsdorf
    {Coordinate{16.1324, 47.6338}, CountryId{"AT"}}, // Petersbaumgarten railway station
    {Coordinate{15.9239, 47.7957}, CountryId{"AT"}}, // Q111267171
    {Coordinate{13.6133, 47.3884}, CountryId{"AT"}}, // Q111267172
    {Coordinate{14.38, 48.2426}, CountryId{"AT"}}, // Linz/Donau Pichling railway station
    {Coordinate{15.9581, 47.8959}, CountryId{"AT"}}, // Bahnhof Pernitz-Muggendorf
    {Coordinate{14.8462, 46.825}, CountryId{"AT"}}, // Q111267175
    {Coordinate{13.8748, 47.4234}, CountryId{"AT"}}, // Q111267176
    {Coordinate{14.4694, 46.8069}, CountryId{"AT"}}, // Q111267178
    {Coordinate{13.5494, 48.2339}, CountryId{"AT"}}, // Bahnhof Peterskirchen
    {Coordinate{13.0905, 47.7131}, CountryId{"AT"}}, // Puch bei Hallein railway station
    {Coordinate{11.0247, 47.2921}, CountryId{"AT"}}, // Q111267181
    {Coordinate{15.1525, 48.0217}, CountryId{"AT"}}, // Bahnhof Saffen
    {Coordinate{16.6771, 48.0232}, CountryId{"AT"}}, // Q111267183
    {Coordinate{14.7509, 46.5823}, CountryId{"AT"}}, // Q111267184
    {Coordinate{16.5018, 48.3308}, CountryId{"AT"}}, // Bahnhof Seyring
    {Coordinate{14.4988, 47.2122}, CountryId{"AT"}}, // St. Georgen ob Judenburg railway station
    {Coordinate{13.9754, 48.6366}, CountryId{"AT"}}, // Q111267187
    {Coordinate{16.4899, 48.4221}, CountryId{"AT"}}, // Bahnhof Schleinbach
    {Coordinate{13.2129, 48.0198}, CountryId{"AT"}}, // Q111267190
    {Coordinate{15.521, 46.8842}, CountryId{"AT"}}, // Wildon railway station
    {Coordinate{16.5075, 48.1365}, CountryId{"AT"}}, // Bahnhof Mannswörth
    {Coordinate{13.7597, 46.6631}, CountryId{"AT"}}, // Puch bei Villach railway station
    {Coordinate{15.5424, 46.8022}, CountryId{"AT"}}, // Kaindorf an der Sulm railway station
    {Coordinate{16.1362, 47.8765}, CountryId{"AT"}}, // Bahnhof Piesting Harzwerk
    {Coordinate{16.0515, 47.8676}, CountryId{"AT"}}, // Bahnhof Waldegg-Dürnbach
    {Coordinate{16.5688, 48.5707}, CountryId{"AT"}}, // Bahnhof Mistelbach Stadt
    {Coordinate{13.2198, 48.0085}, CountryId{"AT"}}, // Q111267199
    {Coordinate{16.4026, 47.7414}, CountryId{"AT"}}, // Bahnhof Mattersburg Nord
    {Coordinate{14.6404, 48.2425}, CountryId{"AT"}}, // Bahnhof Perg Schulzentrum
    {Coordinate{15.5075, 47.0418}, CountryId{"AT"}}, // Hart bei Graz railway station
    {Coordinate{13.2454, 47.9767}, CountryId{"AT"}}, // Q111267205
    {Coordinate{12.4444, 46.7459}, CountryId{"AT"}}, // Q111267206
    {Coordinate{16.1893, 47.8488}, CountryId{"AT"}}, // Feuerwerksanstalt railway station
    {Coordinate{13.701, 48.0354}, CountryId{"AT"}}, // Lehen-Altensam railway station
    {Coordinate{15.6139, 47.5681}, CountryId{"AT"}}, // Langenwang/Mürz railway station
    {Coordinate{14.2755, 48.2495}, CountryId{"AT"}}, // Q111267371
    {Coordinate{14.1892, 46.7213}, CountryId{"AT"}}, // Q111267373
    {Coordinate{15.3603, 47.3316}, CountryId{"AT"}}, // Mixnitz-Bärenschützklamm railway station
    {Coordinate{14.5802, 48.2687}, CountryId{"AT"}}, // Bahnhof Schwertberg
    {Coordinate{16.0329, 47.7907}, CountryId{"AT"}}, // Q111267377
    {Coordinate{16.0605, 47.7892}, CountryId{"AT"}}, // Bahnhof Willendorf
    {Coordinate{16.0511, 47.7892}, CountryId{"AT"}}, // Q111267379
    {Coordinate{15.9468, 47.8923}, CountryId{"AT"}}, // Bahnhof Pernitz Raimundviertel
    {Coordinate{16.2098, 47.8119}, CountryId{"AT"}}, // Wiener Neustadt Anemonensee railway station
    {Coordinate{13.1629, 48.096}, CountryId{"AT"}}, // Q111267382
    {Coordinate{15.4405, 47.0126}, CountryId{"AT"}}, // Feldkirchen-Seiersberg railway station
    {Coordinate{15.4631, 47.0399}, CountryId{"AT"}}, // Graz Liebenau Murpark railway station
    {Coordinate{14.3024, 46.6103}, CountryId{"AT"}}, // Klagenfurt Süd
    {Coordinate{13.8757, 46.6301}, CountryId{"AT"}}, // Villach-Landskron railway station
    {Coordinate{16.4288, 47.7176}, CountryId{"AT"}}, // Bahnhof Marz-Rohrbach
    {Coordinate{14.1524, 46.7321}, CountryId{"AT"}}, // Q111267449
    {Coordinate{16.0053, 47.8776}, CountryId{"AT"}}, // Bahnhof Miesenbach-Waidmannsfeld
    {Coordinate{15.5124, 47.5366}, CountryId{"AT"}}, // Mitterdorf-Veitsch railway station
    {Coordinate{14.8009, 48.095}, CountryId{"AT"}}, // Mauer-Öhling railway station
    {Coordinate{16.3126, 48.029}, CountryId{"AT"}}, // Möllersdorf Aspangbahn railway station
    {Coordinate{16.5007, 48.4973}, CountryId{"AT"}}, // Bahnhof Neubau-Kreuzstetten
    {Coordinate{15.051, 48.1423}, CountryId{"AT"}}, // Q111267456
    {Coordinate{14.0392, 48.104}, CountryId{"AT"}}, // Oberhart bei Steinhaus railway station
    {Coordinate{13.7669, 48.2459}, CountryId{"AT"}}, // Obertrattnach-Markt Hofkirchen railway station
    {Coordinate{14.17, 46.6282}, CountryId{"AT"}}, // Q111267459
    {Coordinate{15.9034, 46.7316}, CountryId{"AT"}}, // Bahnhof Purkla
    {Coordinate{15.8125, 46.9763}, CountryId{"AT"}}, // Rohr/Raab railway station
    {Coordinate{16.8465, 48.412}, CountryId{"AT"}}, // Stillfried railway station
    {Coordinate{14.6461, 48.0547}, CountryId{"AT"}}, // St. Peter-Seitenstetten railway station
    {Coordinate{14.8157, 48.0749}, CountryId{"AT"}}, // Bahnhof Ulmerfeld-Hausmening
    {Coordinate{14.0426, 48.0891}, CountryId{"AT"}}, // Unterhart bei Sattledt railway station
    {Coordinate{16.7589, 48.3495}, CountryId{"AT"}}, // Weikendorf-Dörfles railway station
    {Coordinate{14.0437, 48.0219}, CountryId{"AT"}}, // Wiesmühle railway station
    {Coordinate{16.8019, 48.108}, CountryId{"AT"}}, // Q111267469
    {Coordinate{16.2199, 47.9203}, CountryId{"AT"}}, // Wittmannsdorf railway station
    {Coordinate{16.2554, 47.8336}, CountryId{"AT"}}, // Bahnhof Wiener Neustadt Civitas Nova
    {Coordinate{16.0768, 47.8737}, CountryId{"AT"}}, // Bahnhof Wopfing
    {Coordinate{15.9683, 47.8957}, CountryId{"AT"}}, // Bahnhof Pernitz Wipfelhofstraße
    {Coordinate{14.2057, 48.3215}, CountryId{"AT"}}, // Q111267476
    {Coordinate{16.1655, 47.8648}, CountryId{"AT"}}, // Bahnhof Wöllersdorf Marchgraben
    {Coordinate{14.0513, 48.442}, CountryId{"AT"}}, // Q111267505
    {Coordinate{13.6657, 47.5917}, CountryId{"AT"}}, // Obersee OÖ railway station
    {Coordinate{15.7074, 48.0506}, CountryId{"AT"}}, // Q111267507
    {Coordinate{14.4509, 48.2709}, CountryId{"AT"}}, // Q111267508
    {Coordinate{16.0898, 47.7974}, CountryId{"AT"}}, // Q111267510
    {Coordinate{15.7198, 46.7147}, CountryId{"AT"}}, // Bahnhof Weitersfeld/Mur
    {Coordinate{15.6084, 48.1114}, CountryId{"AT"}}, // Q111267513
    {Coordinate{16.1113, 47.8107}, CountryId{"AT"}}, // Q111267515
    {Coordinate{16.178, 47.8615}, CountryId{"AT"}}, // Wöllersdorf railway station
    {Coordinate{14.6355, 47.7143}, CountryId{"AT"}}, // railway station Weißenbach-St.Gallen
    {Coordinate{14.0291, 47.9806}, CountryId{"AT"}}, // Wilfling railway station
    {Coordinate{13.0988, 48.2164}, CountryId{"AT"}}, // Q111267553
    {Coordinate{14.2647, 48.2365}, CountryId{"AT"}}, // Q111267554
    {Coordinate{14.5286, 48.2276}, CountryId{"AT"}}, // St. Pantaleon railway station
    {Coordinate{13.5335, 46.6003}, CountryId{"AT"}}, // Q111267556
    {Coordinate{16.1563, 47.7074}, CountryId{"AT"}}, // Sautern-Schiltern railway station
    {Coordinate{14.1104, 46.6331}, CountryId{"AT"}}, // Q111267559
    {Coordinate{14.3547, 47.9303}, CountryId{"AT"}}, // Q111267560
    {Coordinate{16.0536, 47.0269}, CountryId{"AT"}}, // Übersbach railway station
    {Coordinate{15.9577, 48.1818}, CountryId{"AT"}}, // Q111267563
    {Coordinate{16.2388, 47.835}, CountryId{"AT"}}, // Q111267564
    {Coordinate{15.6486, 48.0513}, CountryId{"AT"}}, // Bahnhof Wiesenfeld-Schwarzenbach
    {Coordinate{15.9815, 47.8014}, CountryId{"AT"}}, // Bahnhof Grünbach Schule
    {Coordinate{15.1327, 48.1032}, CountryId{"AT"}}, // Q111267568
    {Coordinate{15.1404, 48.039}, CountryId{"AT"}}, // Q111267569
    {Coordinate{14.0087, 48.1359}, CountryId{"AT"}}, // Schauersberg railway station
    {Coordinate{15.6142, 48.1474}, CountryId{"AT"}}, // Bahnhof Hart-Wörth
    {Coordinate{14.4278, 48.2272}, CountryId{"AT"}}, // Asten-Fisching railway station
    {Coordinate{12.2926, 44.3144}, CountryId{"IT"}}, // Lido di Classe-Lido di Savio railway station
    {Coordinate{13.4111, 52.5667}, CountryId{"DE"}}, // S-Bahnhof Pankow
    {Coordinate{59.4619, 58.4134}, CountryId{"RU"}}, // Q111276228
    {Coordinate{59.4564, 58.4865}, CountryId{"RU"}}, // Q111276230
    {Coordinate{59.4897, 58.5987}, CountryId{"RU"}}, // Q111276232
    {Coordinate{59.4997, 58.6142}, CountryId{"RU"}}, // Q111276235
    {Coordinate{59.5077, 58.6294}, CountryId{"RU"}}, // Q111276237
    {Coordinate{59.5058, 58.6534}, CountryId{"RU"}}, // Q111276239
    {Coordinate{59.51, 58.6821}, CountryId{"RU"}}, // Q111276242
    {Coordinate{33.1845, 68.5128}, CountryId{"RU"}}, // Kitsa
    {Coordinate{33.3469, 68.4357}, CountryId{"RU"}}, // Taybola
    {Coordinate{59.7187, 58.1668}, CountryId{"RU"}}, // Q111281391
    {Coordinate{59.7276, 58.1558}, CountryId{"RU"}}, // Q111281393
    {Coordinate{59.7684, 58.1079}, CountryId{"RU"}}, // Q111281396
    {Coordinate{59.8001, 58.091}, CountryId{"RU"}}, // Q111281399
    {Coordinate{59.8814, 58.0394}, CountryId{"RU"}}, // Q111281401
    {Coordinate{59.9581, 58.0083}, CountryId{"RU"}}, // Q111281402
    {Coordinate{59.9559, 57.9905}, CountryId{"RU"}}, // Q111281404
    {Coordinate{11.407, 47.2728}, CountryId{"AT"}}, // Innsbruck Messe railway station
    {Coordinate{60.0214, 57.8238}, CountryId{"RU"}}, // Q111286400
    {Coordinate{60.4273, 56.9428}, CountryId{"RU"}}, // Q111286456
    {Coordinate{60.0156, 57.8921}, CountryId{"RU"}}, // Q111286778
    {Coordinate{60.0407, 57.7824}, CountryId{"RU"}}, // Q111286782
    {Coordinate{60.077, 57.743}, CountryId{"RU"}}, // Q111286785
    {Coordinate{60.1102, 57.6928}, CountryId{"RU"}}, // Q111286787
    {Coordinate{60.0978, 57.668}, CountryId{"RU"}}, // Q111286788
    {Coordinate{60.1103, 57.5849}, CountryId{"RU"}}, // Q111286790
    {Coordinate{60.1976, 57.4362}, CountryId{"RU"}}, // Q111286792
    {Coordinate{60.1739, 57.0551}, CountryId{"RU"}}, // Q111286794
    {Coordinate{60.2512, 57.0338}, CountryId{"RU"}}, // Q111286795
    {Coordinate{60.353, 57.0055}, CountryId{"RU"}}, // Q111286798
    {Coordinate{60.4583, 56.9027}, CountryId{"RU"}}, // Q111286800
    {Coordinate{20.5317, 54.7453}, CountryId{"RU"}}, // Kutuzovo-Novoye railway station
    {Coordinate{59.8282, 58.6323}, CountryId{"RU"}}, // Nizhnyaya Tura railway station
    {Coordinate{38.2619, 57.4483}, CountryId{"RU"}}, // Q111287053
    {Coordinate{38.1987, 57.4054}, CountryId{"RU"}}, // Q111287060
    {Coordinate{38.1849, 57.3772}, CountryId{"RU"}}, // Q111287063
    {Coordinate{38.1006, 57.3214}, CountryId{"RU"}}, // Q111287067
    {Coordinate{59.8925, 58.618}, CountryId{"RU"}}, // Q111287068
    {Coordinate{59.8482, 58.6362}, CountryId{"RU"}}, // Q111287071
    {Coordinate{60.3979, 58.7085}, CountryId{"RU"}}, // Q111287072
    {Coordinate{38.0244, 57.3}, CountryId{"RU"}}, // Q111287074
    {Coordinate{60.721, 58.8818}, CountryId{"RU"}}, // Verkhoturie train station
    {Coordinate{60.6091, 59.0511}, CountryId{"RU"}}, // Q111287101
    {Coordinate{60.4889, 59.1791}, CountryId{"RU"}}, // Q111287105
    {Coordinate{60.4746, 59.262}, CountryId{"RU"}}, // Q111287112
    {Coordinate{37.9228, 57.2592}, CountryId{"RU"}}, // Q111287466
    {Coordinate{60.5399, 58.7487}, CountryId{"RU"}}, // Q111287468
    {Coordinate{134.628, 48.5358}, CountryId{"RU"}}, // Q111287483
    {Coordinate{133.979, 48.5948}, CountryId{"RU"}}, // Q111287484
    {Coordinate{31.3443, 58.0002}, CountryId{"RU"}}, // Staraya Russa train station
    {Coordinate{60.6152, 56.7675}, CountryId{"RU"}}, // Q111293396
    {Coordinate{60.6087, 56.7505}, CountryId{"RU"}}, // Q111293397
    {Coordinate{60.5871, 56.711}, CountryId{"RU"}}, // Q111293398
    {Coordinate{60.5777, 56.6772}, CountryId{"RU"}}, // Q111293399
    {Coordinate{60.5519, 56.646}, CountryId{"RU"}}, // Q111293400
    {Coordinate{60.5099, 56.6209}, CountryId{"RU"}}, // Q111293401
    {Coordinate{60.4873, 56.6048}, CountryId{"RU"}}, // Q111293402
    {Coordinate{60.3949, 56.5361}, CountryId{"RU"}}, // Q111293403
    {Coordinate{60.3455, 56.4795}, CountryId{"RU"}}, // Q111293404
    {Coordinate{60.7583, 56.8056}, CountryId{"RU"}}, // Q111301108
    {Coordinate{60.7881, 56.7874}, CountryId{"RU"}}, // Q111301109
    {Coordinate{60.8211, 56.7714}, CountryId{"RU"}}, // Q111301111
    {Coordinate{60.9124, 56.7634}, CountryId{"RU"}}, // Q111301112
    {Coordinate{60.9391, 56.7728}, CountryId{"RU"}}, // Q111301114
    {Coordinate{60.9724, 56.7537}, CountryId{"RU"}}, // Q111301115
    {Coordinate{61.0379, 56.7477}, CountryId{"RU"}}, // Q111301116
    {Coordinate{61.0664, 56.7497}, CountryId{"RU"}}, // Q111301118
    {Coordinate{61.1264, 56.7501}, CountryId{"RU"}}, // Q111301119
    {Coordinate{61.1968, 56.7471}, CountryId{"RU"}}, // Q111301120
    {Coordinate{61.2614, 56.7406}, CountryId{"RU"}}, // Q111301121
    {Coordinate{61.507, 56.7349}, CountryId{"RU"}}, // Q111301122
    {Coordinate{61.6117, 56.7401}, CountryId{"RU"}}, // Q111301124
    {Coordinate{61.8755, 56.7664}, CountryId{"RU"}}, // Q111301126
    {Coordinate{61.9241, 56.7723}, CountryId{"RU"}}, // Q111301127
    {Coordinate{13.5746, 52.4122}, CountryId{"DE"}}, // S-Bahnhof Grünau
    {Coordinate{62.201, 56.7893}, CountryId{"RU"}}, // Q111309907
    {Coordinate{62.2873, 56.7985}, CountryId{"RU"}}, // Q111309908
    {Coordinate{62.3867, 56.8088}, CountryId{"RU"}}, // Q111309909
    {Coordinate{62.4881, 56.8128}, CountryId{"RU"}}, // Q111309910
    {Coordinate{62.9729, 56.9055}, CountryId{"RU"}}, // Q111309911
    {Coordinate{63.2662, 56.9764}, CountryId{"RU"}}, // Q111309912
    {Coordinate{63.3967, 57.0194}, CountryId{"RU"}}, // Q111309913
    {Coordinate{63.4658, 57.0315}, CountryId{"RU"}}, // Q111309914
    {Coordinate{63.6676, 57.0644}, CountryId{"RU"}}, // Q111309915
    {Coordinate{63.866, 57.0744}, CountryId{"RU"}}, // Q111309916
    {Coordinate{63.9437, 57.0777}, CountryId{"RU"}}, // Q111309917
    {Coordinate{64.0652, 57.0753}, CountryId{"RU"}}, // Q111309918
    {Coordinate{64.0652, 57.0753}, CountryId{"RU"}}, // Q111309919
    {Coordinate{64.2647, 57.0739}, CountryId{"RU"}}, // Q111309920
    {Coordinate{64.6239, 57.0655}, CountryId{"RU"}}, // Q111309921
    {Coordinate{64.8547, 57.0956}, CountryId{"RU"}}, // Q111309922
    {Coordinate{64.9202, 57.1051}, CountryId{"RU"}}, // Q111309923
    {Coordinate{65.008, 57.1121}, CountryId{"RU"}}, // Q111309925
    {Coordinate{65.0311, 57.1138}, CountryId{"RU"}}, // Q111309926
    {Coordinate{65.164, 57.1237}, CountryId{"RU"}}, // Q111309927
    {Coordinate{65.187, 57.1253}, CountryId{"RU"}}, // Q111309928
    {Coordinate{65.2264, 57.1284}, CountryId{"RU"}}, // Q111309929
    {Coordinate{65.2679, 57.1325}, CountryId{"RU"}}, // Q111309931
    {Coordinate{65.3566, 57.1411}, CountryId{"RU"}}, // Q111309932
    {Coordinate{65.4428, 57.1494}, CountryId{"RU"}}, // Q111309933
    {Coordinate{65.4757, 57.152}, CountryId{"RU"}}, // Q111309935
    {Coordinate{33.2972, 68.3584}, CountryId{"RU"}}, // Pulozero
    {Coordinate{33.3253, 68.2727}, CountryId{"RU"}}, // Laplandiya
    {Coordinate{13.3289, 52.43}, CountryId{"DE"}}, // S-Bahnhof Berlin Lichterfelde-Ost
    {Coordinate{13.3289, 52.43}, CountryId{"DE"}}, // Berlin Lichterfelde East Regional Station
    {Coordinate{33.3539, 68.0581}, CountryId{"RU"}}, // Yagelny Bor
    {Coordinate{33.3949, 67.9968}, CountryId{"RU"}}, // Kuna
    {Coordinate{13.3644, 52.4756}, CountryId{"DE"}}, // S-Bahnhof Berlin Südkreuz
    {Coordinate{13.366, 52.4766}, CountryId{"DE"}}, // Long-distance and regional railway station Berlin-Südkreuz
    {Coordinate{13.5094, 52.455}, CountryId{"DE"}}, // S-Bahnhof Berlin Schöneweide
    {Coordinate{13.5094, 52.455}, CountryId{"DE"}}, // Berlin-Schöneweide
    {Coordinate{13.4119, 52.5214}, CountryId{"DE"}}, // S-Bahnhof Berlin Alexanderplatz
    {Coordinate{13.4119, 52.5214}, CountryId{"DE"}}, // Berlin Alexanderplatz Regional Station
    {Coordinate{13.4347, 52.51}, CountryId{"DE"}}, // S-Bahnhof Berlin Ostbahnhof
    {Coordinate{33.335, 67.9429}, CountryId{"RU"}}, // Rudny
    {Coordinate{13.2994, 52.5303}, CountryId{"DE"}}, // Regionalbahnhof Berlin Jungfernheide
    {Coordinate{59.9755, 57.9515}, CountryId{"RU"}}, // Q111327809
    {Coordinate{60.2519, 57.9731}, CountryId{"RU"}}, // Q111327811
    {Coordinate{60.2744, 57.976}, CountryId{"RU"}}, // Q111327812
    {Coordinate{60.38, 58.0195}, CountryId{"RU"}}, // Q111327813
    {Coordinate{60.5573, 58.0597}, CountryId{"RU"}}, // Q111327814
    {Coordinate{60.579, 58.0716}, CountryId{"RU"}}, // Q111327815
    {Coordinate{60.6422, 58.0806}, CountryId{"RU"}}, // Q111327816
    {Coordinate{60.7266, 58.0874}, CountryId{"RU"}}, // Q111327818
    {Coordinate{60.9252, 58.0088}, CountryId{"RU"}}, // Q111327819
    {Coordinate{61.1786, 57.9438}, CountryId{"RU"}}, // Q111327820
    {Coordinate{61.4, 57.9134}, CountryId{"RU"}}, // Q111327821
    {Coordinate{61.5536, 57.8845}, CountryId{"RU"}}, // Q111327822
    {Coordinate{7.1393, 50.0909}, CountryId{"DE"}}, // Neef railway station
    {Coordinate{61.7037, 57.8377}, CountryId{"RU"}}, // Q111336137
    {Coordinate{61.7097, 57.7853}, CountryId{"RU"}}, // Q111336138
    {Coordinate{61.7474, 57.6821}, CountryId{"RU"}}, // Q111336139
    {Coordinate{61.7647, 57.6544}, CountryId{"RU"}}, // Q111336140
    {Coordinate{61.7785, 57.606}, CountryId{"RU"}}, // Q111336141
    {Coordinate{61.8174, 57.4935}, CountryId{"RU"}}, // Q111336142
    {Coordinate{61.8666, 57.3964}, CountryId{"RU"}}, // Q111336143
    {Coordinate{61.8884, 57.3412}, CountryId{"RU"}}, // Q111336209
    {Coordinate{61.8856, 57.2975}, CountryId{"RU"}}, // Q111336210
    {Coordinate{61.8951, 57.2151}, CountryId{"RU"}}, // Q111336211
    {Coordinate{61.9082, 57.1512}, CountryId{"RU"}}, // Q111336212
    {Coordinate{61.952, 57.0747}, CountryId{"RU"}}, // Q111336213
    {Coordinate{61.9866, 56.9919}, CountryId{"RU"}}, // Q111336215
    {Coordinate{62.0007, 56.958}, CountryId{"RU"}}, // Q111336216
    {Coordinate{62.0447, 56.8895}, CountryId{"RU"}}, // Q111336218
    {Coordinate{62.0584, 56.8113}, CountryId{"RU"}}, // Q111336219
    {Coordinate{33.189, 67.7665}, CountryId{"RU"}}, // Nefelinovye Peski
    {Coordinate{33.212, 67.673}, CountryId{"RU"}}, // Khibiny
    {Coordinate{32.9996, 67.4313}, CountryId{"RU"}}, // Khabozero
    {Coordinate{62.0161, 56.7594}, CountryId{"RU"}}, // Q111366202
    {Coordinate{61.9889, 56.704}, CountryId{"RU"}}, // Q111366203
    {Coordinate{61.9706, 56.6486}, CountryId{"RU"}}, // Q111366204
    {Coordinate{61.9684, 56.6216}, CountryId{"RU"}}, // Q111366205
    {Coordinate{61.9563, 56.5918}, CountryId{"RU"}}, // Q111366206
    {Coordinate{61.9411, 56.5591}, CountryId{"RU"}}, // Q111366207
    {Coordinate{61.9305, 56.5364}, CountryId{"RU"}}, // Q111366208
    {Coordinate{61.9047, 56.4808}, CountryId{"RU"}}, // Q111366209
    {Coordinate{61.8997, 56.4391}, CountryId{"RU"}}, // Q111366210
    {Coordinate{14.8727, 40.6403}, CountryId{"IT"}}, // Pontecagnano railway station
    {Coordinate{56.518, 58.2095}, CountryId{"RU"}}, // Q111371040
    {Coordinate{57.3657, 58.8391}, CountryId{"RU"}}, // Q111372260
    {Coordinate{57.182, 58.8328}, CountryId{"RU"}}, // Q111372261
    {Coordinate{57.1665, 58.7923}, CountryId{"RU"}}, // Q111372262
    {Coordinate{57.1404, 58.7775}, CountryId{"RU"}}, // Q111372263
    {Coordinate{57.1053, 58.7688}, CountryId{"RU"}}, // Q111372264
    {Coordinate{57.0602, 58.7486}, CountryId{"RU"}}, // Q111372265
    {Coordinate{56.9577, 58.6944}, CountryId{"RU"}}, // Q111372266
    {Coordinate{56.9474, 58.6844}, CountryId{"RU"}}, // Q111372267
    {Coordinate{56.9474, 58.6219}, CountryId{"RU"}}, // Q111372270
    {Coordinate{56.7761, 58.5121}, CountryId{"RU"}}, // Q111372272
    {Coordinate{56.756, 58.4868}, CountryId{"RU"}}, // Q111372273
    {Coordinate{56.6904, 58.437}, CountryId{"RU"}}, // Q111372274
    {Coordinate{56.7057, 58.3856}, CountryId{"RU"}}, // Q111372275
    {Coordinate{56.6712, 58.3543}, CountryId{"RU"}}, // Q111372277
    {Coordinate{56.6623, 58.3119}, CountryId{"RU"}}, // Q111372278
    {Coordinate{56.6222, 58.303}, CountryId{"RU"}}, // Q111372280
    {Coordinate{56.6163, 58.265}, CountryId{"RU"}}, // Q111372281
    {Coordinate{32.7781, 67.4425}, CountryId{"RU"}}, // Afrikanda
    {Coordinate{32.6108, 67.4105}, CountryId{"RU"}}, // Vostochnaya Guba
    {Coordinate{56.7324, 59.6334}, CountryId{"RU"}}, // Q111382377
    {Coordinate{57.1985, 59.3194}, CountryId{"RU"}}, // Q111382557
    {Coordinate{57.2627, 59.3275}, CountryId{"RU"}}, // Q111382558
    {Coordinate{57.4473, 59.2262}, CountryId{"RU"}}, // Q111382559
    {Coordinate{57.4784, 59.1878}, CountryId{"RU"}}, // Q111382560
    {Coordinate{57.5694, 59.1558}, CountryId{"RU"}}, // Q111382561
    {Coordinate{57.5605, 59.0587}, CountryId{"RU"}}, // Q111382562
    {Coordinate{57.6048, 59.049}, CountryId{"RU"}}, // Q111382563
    {Coordinate{57.6503, 59.0544}, CountryId{"RU"}}, // Q111382564
    {Coordinate{57.6655, 59.0292}, CountryId{"RU"}}, // Q111382565
    {Coordinate{57.0153, 59.3352}, CountryId{"RU"}}, // Q111382645
    {Coordinate{57.0726, 59.3302}, CountryId{"RU"}}, // Q111382647
    {Coordinate{57.1331, 59.3283}, CountryId{"RU"}}, // Q111382649
    {Coordinate{57.5385, 58.7713}, CountryId{"RU"}}, // Q111382872
    {Coordinate{57.5947, 58.6876}, CountryId{"RU"}}, // Usva
    {Coordinate{57.6278, 58.6546}, CountryId{"RU"}}, // Q111382874
    {Coordinate{57.674, 58.617}, CountryId{"RU"}}, // Q111382875
    {Coordinate{57.7579, 58.5756}, CountryId{"RU"}}, // Q111382876
    {Coordinate{57.7406, 58.5091}, CountryId{"RU"}}, // Q111382877
    {Coordinate{57.7603, 58.4727}, CountryId{"RU"}}, // Q111382878
    {Coordinate{57.7491, 58.4335}, CountryId{"RU"}}, // Q111382879
    {Coordinate{57.7435, 58.3489}, CountryId{"RU"}}, // Q111382880
    {Coordinate{57.7868, 58.327}, CountryId{"RU"}}, // Q111382881
    {Coordinate{60.6365, 59.6148}, CountryId{"RU"}}, // Q111382992
    {Coordinate{11.3968, 45.2304}, CountryId{"IT"}}, // Bevilacqua railway station
    {Coordinate{60.5923, 59.56}, CountryId{"RU"}}, // Q111397223
    {Coordinate{60.588, 59.5367}, CountryId{"RU"}}, // Q111397224
    {Coordinate{60.5373, 59.4811}, CountryId{"RU"}}, // Q111397225
    {Coordinate{60.5196, 59.428}, CountryId{"RU"}}, // Q111397226
    {Coordinate{60.4757, 59.3643}, CountryId{"RU"}}, // Vagranskaya
    {Coordinate{60.4746, 59.3157}, CountryId{"RU"}}, // Q111397228
    {Coordinate{60.5081, 59.1242}, CountryId{"RU"}}, // Q111397229
    {Coordinate{60.6849, 58.8616}, CountryId{"RU"}}, // Q111397230
    {Coordinate{60.6022, 58.7879}, CountryId{"RU"}}, // Q111397231
    {Coordinate{59.9585, 58.5138}, CountryId{"RU"}}, // Q111397232
    {Coordinate{59.9267, 58.4104}, CountryId{"RU"}}, // Q111397233
    {Coordinate{61.5124, 57.0048}, CountryId{"RU"}}, // Q111420846
    {Coordinate{61.3429, 56.7699}, CountryId{"RU"}}, // Q111421109
    {Coordinate{61.3534, 56.7857}, CountryId{"RU"}}, // Q111421110
    {Coordinate{61.3933, 56.8567}, CountryId{"RU"}}, // Q111421111
    {Coordinate{61.4625, 56.9671}, CountryId{"RU"}}, // Q111421114
    {Coordinate{61.4269, 56.917}, CountryId{"RU"}}, // Q111421133
    {Coordinate{61.6765, 57.0982}, CountryId{"RU"}}, // Q111421185
    {Coordinate{61.7179, 57.13}, CountryId{"RU"}}, // Q111421242
    {Coordinate{61.825, 57.1493}, CountryId{"RU"}}, // Q111421247
    {Coordinate{65.9202, 59.5696}, CountryId{"RU"}}, // Q111427171
    {Coordinate{63.5517, 57.9279}, CountryId{"RU"}}, // Q111427182
    {Coordinate{66.0128, 59.3222}, CountryId{"RU"}}, // Q111434227
    {Coordinate{66.0777, 59.0656}, CountryId{"RU"}}, // Q111434228
    {Coordinate{65.9787, 58.8053}, CountryId{"RU"}}, // Q111434230
    {Coordinate{65.677, 58.4391}, CountryId{"RU"}}, // Q111434231
    {Coordinate{65.5199, 58.2434}, CountryId{"RU"}}, // Q111434232
    {Coordinate{65.1123, 58.0478}, CountryId{"RU"}}, // Q111434233
    {Coordinate{64.7885, 58.0424}, CountryId{"RU"}}, // Q111434235
    {Coordinate{64.4285, 58.0158}, CountryId{"RU"}}, // Q111434236
    {Coordinate{64.162, 58.043}, CountryId{"RU"}}, // Q111434238
    {Coordinate{63.9915, 58.0334}, CountryId{"RU"}}, // Q111434239
    {Coordinate{63.7485, 58.0455}, CountryId{"RU"}}, // Q111434241
    {Coordinate{63.6961, 58.0084}, CountryId{"RU"}}, // Q111434242
    {Coordinate{63.4115, 57.8595}, CountryId{"RU"}}, // Q111434243
    {Coordinate{63.3765, 57.844}, CountryId{"RU"}}, // Q111434244
    {Coordinate{63.2245, 57.7647}, CountryId{"RU"}}, // Q111434246
    {Coordinate{63.0442, 57.6713}, CountryId{"RU"}}, // Q111434247
    {Coordinate{63.0086, 57.6698}, CountryId{"RU"}}, // Q111434248
    {Coordinate{62.8927, 57.6113}, CountryId{"RU"}}, // Q111434249
    {Coordinate{62.8479, 57.5805}, CountryId{"RU"}}, // Q111434250
    {Coordinate{62.7315, 57.5433}, CountryId{"RU"}}, // Q111434252
    {Coordinate{62.6503, 57.5139}, CountryId{"RU"}}, // Q111434254
    {Coordinate{62.5286, 57.4688}, CountryId{"RU"}}, // Q111434257
    {Coordinate{62.4605, 57.4452}, CountryId{"RU"}}, // Q111434258
    {Coordinate{62.3083, 57.3859}, CountryId{"RU"}}, // Q111434259
    {Coordinate{62.1326, 57.3818}, CountryId{"RU"}}, // Q111434260
    {Coordinate{61.8309, 57.3585}, CountryId{"RU"}}, // Q111434805
    {Coordinate{61.7995, 57.3604}, CountryId{"RU"}}, // Q111434806
    {Coordinate{61.7258, 57.3724}, CountryId{"RU"}}, // Q111434807
    {Coordinate{61.6859, 57.3702}, CountryId{"RU"}}, // Q111434808
    {Coordinate{61.6434, 57.3639}, CountryId{"RU"}}, // Q111434809
    {Coordinate{61.4952, 57.3569}, CountryId{"RU"}}, // Q111434810
    {Coordinate{61.3332, 57.3125}, CountryId{"RU"}}, // Q111434811
    {Coordinate{61.2286, 57.2656}, CountryId{"RU"}}, // Q111434812
    {Coordinate{61.1045, 57.2137}, CountryId{"RU"}}, // Q111434813
    {Coordinate{61.0478, 57.1447}, CountryId{"RU"}}, // Q111434814
    {Coordinate{60.9604, 57.1188}, CountryId{"RU"}}, // Q111434815
    {Coordinate{60.7744, 57.0071}, CountryId{"RU"}}, // Q111434817
    {Coordinate{60.723, 56.9536}, CountryId{"RU"}}, // Q111434818
    {Coordinate{60.9306, 57.1}, CountryId{"RU"}}, // Q111434826
    {Coordinate{65.6402, 57.1018}, CountryId{"RU"}}, // Q111435066
    {Coordinate{32.498, 67.3173}, CountryId{"RU"}}, // Pinozero
    {Coordinate{32.4751, 67.2999}, CountryId{"RU"}}, // 1189 km
    {Coordinate{32.4532, 67.278}, CountryId{"RU"}}, // 1186 km
    {Coordinate{32.4279, 67.2426}, CountryId{"RU"}}, // Plesozero
    {Coordinate{32.4575, 67.1983}, CountryId{"RU"}}, // 1178 km
    {Coordinate{32.46, 67.1867}, CountryId{"RU"}}, // 1176 km
    {Coordinate{65.5834, 57.1236}, CountryId{"RU"}}, // Q111443718
    {Coordinate{65.6081, 57.1141}, CountryId{"RU"}}, // Q111443720
    {Coordinate{32.2766, 67.1466}, CountryId{"RU"}}, // Prolivy
    {Coordinate{32.2645, 67.0802}, CountryId{"RU"}}, // Beloye More
    {Coordinate{32.2037, 67.0363}, CountryId{"RU"}}, // 1147 km
    {Coordinate{65.6487, 57.0985}, CountryId{"RU"}}, // Q111453895
    {Coordinate{65.7313, 57.0389}, CountryId{"RU"}}, // Q111453898
    {Coordinate{65.7788, 56.9691}, CountryId{"RU"}}, // Q111453901
    {Coordinate{65.8192, 56.9368}, CountryId{"RU"}}, // Q111453904
    {Coordinate{65.8939, 56.8919}, CountryId{"RU"}}, // Q111453906
    {Coordinate{65.9528, 56.8524}, CountryId{"RU"}}, // Q111453909
    {Coordinate{65.9774, 56.836}, CountryId{"RU"}}, // Q111453911
    {Coordinate{66.0657, 56.7779}, CountryId{"RU"}}, // Q111453912
    {Coordinate{66.1914, 56.7018}, CountryId{"RU"}}, // Q111453914
    {Coordinate{66.2631, 56.6693}, CountryId{"RU"}}, // Q111453916
    {Coordinate{66.3099, 56.6615}, CountryId{"RU"}}, // Yalutorovsk
    {Coordinate{66.3689, 56.6439}, CountryId{"RU"}}, // Q111453922
    {Coordinate{66.4248, 56.5688}, CountryId{"RU"}}, // Q111453925
    {Coordinate{66.5426, 56.5132}, CountryId{"RU"}}, // Q111453928
    {Coordinate{66.6561, 56.4981}, CountryId{"RU"}}, // Q111453930
    {Coordinate{66.7023, 56.4943}, CountryId{"RU"}}, // Q111453933
    {Coordinate{66.8886, 56.4801}, CountryId{"RU"}}, // Q111453935
    {Coordinate{66.9525, 56.4754}, CountryId{"RU"}}, // Q111453937
    {Coordinate{67.0807, 56.4795}, CountryId{"RU"}}, // Q111453938
    {Coordinate{67.3063, 56.4742}, CountryId{"RU"}}, // Q111453939
    {Coordinate{67.5096, 56.4665}, CountryId{"RU"}}, // Q111453940
    {Coordinate{67.6687, 56.4627}, CountryId{"RU"}}, // Q111453942
    {Coordinate{67.9857, 56.4315}, CountryId{"RU"}}, // Q111453944
    {Coordinate{68.3773, 56.3899}, CountryId{"RU"}}, // Q111453947
    {Coordinate{68.5446, 56.3699}, CountryId{"RU"}}, // Q111453950
    {Coordinate{68.9277, 56.283}, CountryId{"RU"}}, // Q111453951
    {Coordinate{69.2738, 56.1933}, CountryId{"RU"}}, // Q111453954
    {Coordinate{69.547, 56.0996}, CountryId{"RU"}}, // Q111453956
    {Coordinate{69.5639, 56.0784}, CountryId{"RU"}}, // Q111453957
    {Coordinate{69.6797, 56.0767}, CountryId{"RU"}}, // Q111453958
    {Coordinate{69.793, 56.0269}, CountryId{"RU"}}, // Q111453959
    {Coordinate{69.9526, 55.9829}, CountryId{"RU"}}, // Q111453960
    {Coordinate{70.1166, 55.9375}, CountryId{"RU"}}, // Q111453961
    {Coordinate{70.1384, 55.9315}, CountryId{"RU"}}, // Q111453964
    {Coordinate{70.2837, 55.8908}, CountryId{"RU"}}, // Q111453966
    {Coordinate{70.4472, 55.8577}, CountryId{"RU"}}, // Q111453969
    {Coordinate{70.6077, 55.8163}, CountryId{"RU"}}, // Q111453973
    {Coordinate{70.7603, 55.7767}, CountryId{"RU"}}, // Q111453975
    {Coordinate{70.8083, 55.7556}, CountryId{"RU"}}, // Q111453977
    {Coordinate{70.9109, 55.7231}, CountryId{"RU"}}, // Q111453978
    {Coordinate{71.0615, 55.6698}, CountryId{"RU"}}, // Q111453979
    {Coordinate{71.1298, 55.6399}, CountryId{"RU"}}, // Q111453980
    {Coordinate{71.217, 55.6068}, CountryId{"RU"}}, // Q111453981
    {Coordinate{60.4789, 60.657}, CountryId{"RU"}}, // Q111462179
    {Coordinate{60.401, 60.6549}, CountryId{"RU"}}, // Q111462320
    {Coordinate{60.3929, 60.4408}, CountryId{"RU"}}, // Q111462321
    {Coordinate{60.4077, 60.4095}, CountryId{"RU"}}, // Q111462322
    {Coordinate{60.4213, 60.2931}, CountryId{"RU"}}, // Q111462323
    {Coordinate{60.4118, 60.2096}, CountryId{"RU"}}, // Q111462324
    {Coordinate{60.4569, 60.1097}, CountryId{"RU"}}, // Q111462325
    {Coordinate{60.4708, 60.0478}, CountryId{"RU"}}, // Q111462326
    {Coordinate{60.5745, 59.9233}, CountryId{"RU"}}, // Q111462327
    {Coordinate{60.639, 59.8486}, CountryId{"RU"}}, // Q111462328
    {Coordinate{60.6256, 59.7565}, CountryId{"RU"}}, // Q111462329
    {Coordinate{60.6023, 59.5968}, CountryId{"RU"}}, // Q111462377
    {Coordinate{61.7552, 59.1385}, CountryId{"RU"}}, // Q111462495
    {Coordinate{60.6677, 59.6118}, CountryId{"RU"}}, // Q111463772
    {Coordinate{60.7138, 59.6017}, CountryId{"RU"}}, // Q111463773
    {Coordinate{60.7563, 59.605}, CountryId{"RU"}}, // Q111463774
    {Coordinate{60.8082, 59.5638}, CountryId{"RU"}}, // Q111463775
    {Coordinate{60.8327, 59.5373}, CountryId{"RU"}}, // Q111463776
    {Coordinate{60.9112, 59.4991}, CountryId{"RU"}}, // Q111463777
    {Coordinate{61.0315, 59.4805}, CountryId{"RU"}}, // Q111463778
    {Coordinate{61.0703, 59.4703}, CountryId{"RU"}}, // Q111463779
    {Coordinate{61.2087, 59.3978}, CountryId{"RU"}}, // Q111463781
    {Coordinate{61.2612, 59.3796}, CountryId{"RU"}}, // Q111463782
    {Coordinate{61.5861, 59.2153}, CountryId{"RU"}}, // Q111463783
    {Coordinate{61.6358, 59.2047}, CountryId{"RU"}}, // Q111463784
    {Coordinate{61.8031, 59.0988}, CountryId{"RU"}}, // Q111463785
    {Coordinate{61.7868, 58.9282}, CountryId{"RU"}}, // Q111463787
    {Coordinate{61.799, 58.8045}, CountryId{"RU"}}, // Q111463788
    {Coordinate{61.7889, 58.7534}, CountryId{"RU"}}, // Q111463789
    {Coordinate{61.7997, 58.7183}, CountryId{"RU"}}, // Q111463792
    {Coordinate{61.783, 58.6323}, CountryId{"RU"}}, // Q111463795
    {Coordinate{61.7542, 58.5225}, CountryId{"RU"}}, // Q111463798
    {Coordinate{61.7477, 58.4433}, CountryId{"RU"}}, // Q111463801
    {Coordinate{61.7689, 58.4064}, CountryId{"RU"}}, // Q111463806
    {Coordinate{61.7637, 58.3438}, CountryId{"RU"}}, // Q111463810
    {Coordinate{61.7296, 58.2418}, CountryId{"RU"}}, // Q111463815
    {Coordinate{61.729, 58.1572}, CountryId{"RU"}}, // Q111463819
    {Coordinate{61.7251, 58.1284}, CountryId{"RU"}}, // Q111463823
    {Coordinate{61.7204, 58.0355}, CountryId{"RU"}}, // Q111463828
    {Coordinate{61.7154, 57.9953}, CountryId{"RU"}}, // Q111463833
    {Coordinate{61.7961, 59.0724}, CountryId{"RU"}}, // Q111463976
    {Coordinate{61.8219, 59.1657}, CountryId{"RU"}}, // Q111464797
    {Coordinate{32.1911, 67.0048}, CountryId{"RU"}}, // Ruchyi-Karelskiye
    {Coordinate{32.2089, 66.9215}, CountryId{"RU"}}, // Zhemchuzhnaya
    {Coordinate{32.3551, 66.8195}, CountryId{"RU"}}, // Knyazhaya
    {Coordinate{74.2043, 61.4989}, CountryId{"RU"}}, // Q111465505
    {Coordinate{74.0177, 61.4509}, CountryId{"RU"}}, // Q111474304
    {Coordinate{73.8052, 61.414}, CountryId{"RU"}}, // Q111474305
    {Coordinate{73.7423, 61.3696}, CountryId{"RU"}}, // Q111474306
    {Coordinate{73.6741, 61.3465}, CountryId{"RU"}}, // Q111474307
    {Coordinate{73.1777, 61.2523}, CountryId{"RU"}}, // Q111474308
    {Coordinate{73.1681, 61.1584}, CountryId{"RU"}}, // Q111474309
    {Coordinate{73.1701, 61.124}, CountryId{"RU"}}, // Q111474310
    {Coordinate{73.1426, 61.0582}, CountryId{"RU"}}, // Q111474312
    {Coordinate{73.14, 61.0319}, CountryId{"RU"}}, // Q111474313
    {Coordinate{73.0901, 60.9247}, CountryId{"RU"}}, // Q111474314
    {Coordinate{72.9625, 60.8306}, CountryId{"RU"}}, // Q111474315
    {Coordinate{72.8451, 60.7549}, CountryId{"RU"}}, // Q111474316
    {Coordinate{72.7244, 60.6956}, CountryId{"RU"}}, // Q111474318
    {Coordinate{72.6293, 60.6271}, CountryId{"RU"}}, // Q111474319
    {Coordinate{72.4713, 60.5501}, CountryId{"RU"}}, // Q111474320
    {Coordinate{72.3688, 60.4741}, CountryId{"RU"}}, // Q111474321
    {Coordinate{72.0292, 60.3276}, CountryId{"RU"}}, // Q111474322
    {Coordinate{71.4623, 60.058}, CountryId{"RU"}}, // Q111474323
    {Coordinate{69.9967, 59.5459}, CountryId{"RU"}}, // Q111474324
    {Coordinate{69.1213, 58.9276}, CountryId{"RU"}}, // Q111474325
    {Coordinate{68.7643, 58.6076}, CountryId{"RU"}}, // Q111474327
    {Coordinate{68.1829, 58.2253}, CountryId{"RU"}}, // Q111474328
    {Coordinate{67.7996, 58.0261}, CountryId{"RU"}}, // Q111474329
    {Coordinate{67.4357, 57.8941}, CountryId{"RU"}}, // Q111474330
    {Coordinate{67.1559, 57.7772}, CountryId{"RU"}}, // Q111474331
    {Coordinate{66.8556, 57.5439}, CountryId{"RU"}}, // Q111474332
    {Coordinate{66.5838, 57.5073}, CountryId{"RU"}}, // Q111474333
    {Coordinate{66.3895, 57.4739}, CountryId{"RU"}}, // Q111474334
    {Coordinate{66.2572, 57.4111}, CountryId{"RU"}}, // Q111474335
    {Coordinate{65.8713, 57.1743}, CountryId{"RU"}}, // Q111474336
    {Coordinate{65.7656, 57.0984}, CountryId{"RU"}}, // Q111474337
    {Coordinate{32.6369, 66.7131}, CountryId{"RU"}}, // Kovda
    {Coordinate{32.6638, 66.6855}, CountryId{"RU"}}, // 1093 km
    {Coordinate{32.7498, 66.6372}, CountryId{"RU"}}, // Lesnoy
    {Coordinate{32.8082, 66.5851}, CountryId{"RU"}}, // Poyakonda
    {Coordinate{32.8503, 66.4358}, CountryId{"RU"}}, // Polyarnyj Krug
    {Coordinate{76.4581, 61.0022}, CountryId{"RU"}}, // Q111488314
    {Coordinate{76.3309, 61.0618}, CountryId{"RU"}}, // Q111488315
    {Coordinate{75.9995, 61.142}, CountryId{"RU"}}, // Q111488316
    {Coordinate{75.4589, 61.2436}, CountryId{"RU"}}, // Q111488317
    {Coordinate{75.219, 61.2753}, CountryId{"RU"}}, // Q111488318
    {Coordinate{74.8579, 61.4012}, CountryId{"RU"}}, // Q111488319
    {Coordinate{74.545, 62.2587}, CountryId{"RU"}}, // Q111488620
    {Coordinate{75.9361, 63.723}, CountryId{"RU"}}, // Q111488622
    {Coordinate{76.7094, 64.4858}, CountryId{"RU"}}, // Q111488624
    {Coordinate{77.5654, 64.9382}, CountryId{"RU"}}, // Q111488625
    {Coordinate{77.7457, 65.2662}, CountryId{"RU"}}, // Q111488626
    {Coordinate{78.1774, 65.9303}, CountryId{"RU"}}, // Q111488627
    {Coordinate{32.9271, 66.308}, CountryId{"RU"}}, // Katozero
    {Coordinate{32.9009, 66.1966}, CountryId{"RU"}}, // Keret'
    {Coordinate{65.5979, 62.4624}, CountryId{"RU"}}, // Q111507902
    {Coordinate{65.5231, 62.2589}, CountryId{"RU"}}, // Q111507903
    {Coordinate{65.3867, 62.1356}, CountryId{"RU"}}, // Q111507904
    {Coordinate{64.9482, 61.9448}, CountryId{"RU"}}, // Q111507905
    {Coordinate{64.7834, 61.8615}, CountryId{"RU"}}, // Q111507906
    {Coordinate{64.484, 61.6748}, CountryId{"RU"}}, // Q111507907
    {Coordinate{64.0554, 61.4723}, CountryId{"RU"}}, // Q111507908
    {Coordinate{63.8479, 61.3982}, CountryId{"RU"}}, // Q111507909
    {Coordinate{63.5757, 61.3585}, CountryId{"RU"}}, // Q111507910
    {Coordinate{63.3289, 61.3087}, CountryId{"RU"}}, // Q111507911
    {Coordinate{63.0965, 61.2495}, CountryId{"RU"}}, // Q111507912
    {Coordinate{62.8548, 61.2029}, CountryId{"RU"}}, // Q111507914
    {Coordinate{62.6707, 61.1601}, CountryId{"RU"}}, // Q111507915
    {Coordinate{62.2798, 61.0668}, CountryId{"RU"}}, // Q111507916
    {Coordinate{61.9962, 61.0147}, CountryId{"RU"}}, // Q111507917
    {Coordinate{61.7659, 60.9697}, CountryId{"RU"}}, // Q111507918
    {Coordinate{61.5039, 60.8929}, CountryId{"RU"}}, // Q111507919
    {Coordinate{61.2634, 60.8371}, CountryId{"RU"}}, // Q111507920
    {Coordinate{61.0242, 60.7804}, CountryId{"RU"}}, // Q111507921
    {Coordinate{60.7883, 60.7231}, CountryId{"RU"}}, // Q111507922
    {Coordinate{60.5029, 60.6613}, CountryId{"RU"}}, // Q111507923
    {Coordinate{63.545, 61.4155}, CountryId{"RU"}}, // Q111508082
    {Coordinate{63.3886, 61.5721}, CountryId{"RU"}}, // Q111508084
    {Coordinate{63.0014, 61.9277}, CountryId{"RU"}}, // Q111508085
    {Coordinate{10.3537, 50.7214}, CountryId{"DE"}}, // Wernshausen
    {Coordinate{10.3757, 50.7166}, CountryId{"DE"}}, // Niederschmalkalden
    {Coordinate{11.6606, 43.4965}, CountryId{"IT"}}, // Laterina railway station
    {Coordinate{33.3545, 65.9623}, CountryId{"RU"}}, // Boyarskaya
    {Coordinate{33.4315, 65.9485}, CountryId{"RU"}}, // 981 km
    {Coordinate{33.7102, 65.8977}, CountryId{"RU"}}, // Ambarnyj
    {Coordinate{33.9448, 65.7898}, CountryId{"RU"}}, // Engozero
    {Coordinate{33.8578, 65.8283}, CountryId{"RU"}}, // 957 km
    {Coordinate{41.6887, 58.4268}, CountryId{"RU"}}, // Q111539229
    {Coordinate{41.749, 58.4221}, CountryId{"RU"}}, // Q111539230
    {Coordinate{41.8864, 58.4235}, CountryId{"RU"}}, // Q111539231
    {Coordinate{41.971, 58.4277}, CountryId{"RU"}}, // Q111539232
    {Coordinate{42.1144, 58.406}, CountryId{"RU"}}, // Q111539234
    {Coordinate{42.2073, 58.3675}, CountryId{"RU"}}, // Q111539235
    {Coordinate{42.2619, 58.3709}, CountryId{"RU"}}, // Q111539236
    {Coordinate{42.407, 58.3654}, CountryId{"RU"}}, // Q111541244
    {Coordinate{42.4549, 58.3498}, CountryId{"RU"}}, // Q111541245
    {Coordinate{42.5347, 58.3498}, CountryId{"RU"}}, // Q111541246
    {Coordinate{42.5959, 58.3417}, CountryId{"RU"}}, // Q111541247
    {Coordinate{42.6677, 58.3383}, CountryId{"RU"}}, // Q111541248
    {Coordinate{42.722, 58.3499}, CountryId{"RU"}}, // Q111541249
    {Coordinate{42.8503, 58.38}, CountryId{"RU"}}, // Q111541250
    {Coordinate{43.0039, 58.4006}, CountryId{"RU"}}, // Q111541251
    {Coordinate{43.0879, 58.3881}, CountryId{"RU"}}, // Q111541252
    {Coordinate{43.2648, 58.3651}, CountryId{"RU"}}, // Q111541253
    {Coordinate{43.5715, 58.3048}, CountryId{"RU"}}, // Q111541254
    {Coordinate{43.7358, 58.2987}, CountryId{"RU"}}, // Q111541255
    {Coordinate{43.8592, 58.2927}, CountryId{"RU"}}, // Q111541256
    {Coordinate{43.9575, 58.2923}, CountryId{"RU"}}, // Q111541257
    {Coordinate{44.1202, 58.3158}, CountryId{"RU"}}, // Q111541258
    {Coordinate{44.3244, 58.3148}, CountryId{"RU"}}, // Q111541260
    {Coordinate{44.4318, 58.3243}, CountryId{"RU"}}, // Q111541261
    {Coordinate{44.5697, 58.3264}, CountryId{"RU"}}, // Q111541262
    {Coordinate{44.7428, 58.3341}, CountryId{"RU"}}, // Q111541263
    {Coordinate{44.8268, 58.3403}, CountryId{"RU"}}, // Q111541265
    {Coordinate{44.9416, 58.3473}, CountryId{"RU"}}, // Q111541266
    {Coordinate{45.0709, 58.3405}, CountryId{"RU"}}, // Q111541267
    {Coordinate{45.182, 58.3441}, CountryId{"RU"}}, // Q111541269
    {Coordinate{45.3414, 58.3699}, CountryId{"RU"}}, // Q111541270
    {Coordinate{45.3866, 58.3783}, CountryId{"RU"}}, // Q111541271
    {Coordinate{45.4376, 58.3783}, CountryId{"RU"}}, // Q111541272
    {Coordinate{45.491, 58.372}, CountryId{"RU"}}, // Q111541273
    {Coordinate{45.5688, 58.3662}, CountryId{"RU"}}, // Q111541274
    {Coordinate{45.6455, 58.3721}, CountryId{"RU"}}, // Q111541275
    {Coordinate{45.7405, 58.3707}, CountryId{"RU"}}, // Q111541276
    {Coordinate{45.921, 58.3607}, CountryId{"RU"}}, // Q111541278
    {Coordinate{46.1132, 58.349}, CountryId{"RU"}}, // Q111541279
    {Coordinate{46.2079, 58.3568}, CountryId{"RU"}}, // Q111541280
    {Coordinate{46.3151, 58.3547}, CountryId{"RU"}}, // Ponazyrevo railway station
    {Coordinate{46.6879, 58.3333}, CountryId{"RU"}}, // Q111541282
    {Coordinate{47.1089, 58.3024}, CountryId{"RU"}}, // Q111541283
    {Coordinate{47.3093, 58.2964}, CountryId{"RU"}}, // Q111541284
    {Coordinate{47.3471, 58.2923}, CountryId{"RU"}}, // Q111541285
    {Coordinate{47.4016, 58.2864}, CountryId{"RU"}}, // Q111541286
    {Coordinate{12.4925, 55.687}, CountryId{"DK"}}, // Vanløse Station
    {Coordinate{34.1216, 65.6864}, CountryId{"RU"}}, // 935 km
    {Coordinate{34.2019, 65.573}, CountryId{"RU"}}, // Sig
    {Coordinate{34.1884, 65.5044}, CountryId{"RU"}}, // 912 km
    {Coordinate{34.2227, 65.4693}, CountryId{"RU"}}, // 908 km
    {Coordinate{34.2683, 65.4238}, CountryId{"RU"}}, // Von'ga
    {Coordinate{34.266, 65.3533}, CountryId{"RU"}}, // Kuzema
    {Coordinate{34.3376, 65.3276}, CountryId{"RU"}}, // 883 km
    {Coordinate{34.4662, 65.2431}, CountryId{"RU"}}, // Pon'goma
    {Coordinate{34.5828, 65.09}, CountryId{"RU"}}, // Lambino
    {Coordinate{34.627, 65.028}, CountryId{"RU"}}, // 846 km
    {Coordinate{30.0895, 55.356}, CountryId{"BY"}}, // Q111585571
    {Coordinate{13.5854, 54.486}, CountryId{"DE"}}, // Sassnitz Fährhafen railway station
    {Coordinate{34.6704, 64.863}, CountryId{"RU"}}, // Myagreka
    {Coordinate{34.6995, 64.7392}, CountryId{"RU"}}, // Shuyeretskaya
    {Coordinate{34.8007, 64.6626}, CountryId{"RU"}}, // Zalivy
    {Coordinate{14.8302, 38.1593}, CountryId{"IT"}}, // Brolo-Ficarra railway station
    {Coordinate{34.4692, 64.431}, CountryId{"RU"}}, // Sosnovets
    {Coordinate{34.4293, 64.367}, CountryId{"RU"}}, // Kilbo
    {Coordinate{34.3044, 64.2282}, CountryId{"RU"}}, // Tunguda
    {Coordinate{34.2458, 64.1368}, CountryId{"RU"}}, // Idel'
    {Coordinate{33.0595, 64.0968}, CountryId{"RU"}}, // Pertozero
    {Coordinate{15.6526, 38.1264}, CountryId{"IT"}}, // Reggio di Calabria Santa Caterina railway station
    {Coordinate{14.2709, 51.0844}, CountryId{"DE"}}, // Neukirch West railway station
    {Coordinate{40.1831, 57.4806}, CountryId{"RU"}}, // Q111621868
    {Coordinate{40.2599, 57.4574}, CountryId{"RU"}}, // Q111621869
    {Coordinate{40.3762, 57.4371}, CountryId{"RU"}}, // Q111621871
    {Coordinate{34.2361, 63.9448}, CountryId{"RU"}}, // Shavan'
    {Coordinate{34.2685, 63.8937}, CountryId{"RU"}}, // Nadvoitsy
    {Coordinate{34.253, 63.8156}, CountryId{"RU"}}, // May-Guba
    {Coordinate{34.2818, 63.661}, CountryId{"RU"}}, // Shpalovoy
    {Coordinate{40.1647, 58.0644}, CountryId{"RU"}}, // Q111634116
    {Coordinate{34.2975, 63.6028}, CountryId{"RU"}}, // Rigozero
    {Coordinate{34.2664, 63.5205}, CountryId{"RU"}}, // Suglitsa
    {Coordinate{34.2445, 63.4378}, CountryId{"RU"}}, // Urosozero
    {Coordinate{34.3258, 63.3467}, CountryId{"RU"}}, // Sumerichi
    {Coordinate{34.3172, 63.2768}, CountryId{"RU"}}, // Ramentsy
    {Coordinate{34.3462, 63.2209}, CountryId{"RU"}}, // Bystryagi
    {Coordinate{34.389, 63.1044}, CountryId{"RU"}}, // Vanzozero
    {Coordinate{34.4309, 63.0484}, CountryId{"RU"}}, // Malyga
    {Coordinate{34.4995, 62.9847}, CountryId{"RU"}}, // Lumbushozero
    {Coordinate{34.5491, 62.9313}, CountryId{"RU"}}, // Vichka
    {Coordinate{38.7241, 58.025}, CountryId{"RU"}}, // Q111652214
    {Coordinate{38.6838, 58.0154}, CountryId{"RU"}}, // Q111652215
    {Coordinate{38.614, 57.9986}, CountryId{"RU"}}, // Q111652216
    {Coordinate{38.4838, 57.9717}, CountryId{"RU"}}, // Q111652217
    {Coordinate{37.9639, 57.8751}, CountryId{"RU"}}, // Q111652218
    {Coordinate{37.8479, 57.8501}, CountryId{"RU"}}, // Q111652219
    {Coordinate{37.7576, 57.8304}, CountryId{"RU"}}, // Q111652220
    {Coordinate{37.6288, 57.8182}, CountryId{"RU"}}, // Q111652221
    {Coordinate{37.5067, 57.8246}, CountryId{"RU"}}, // Q111652222
    {Coordinate{37.3665, 57.8196}, CountryId{"RU"}}, // Q111652223
    {Coordinate{34.4394, 62.8544}, CountryId{"RU"}}, // Predmedgorsky
    {Coordinate{34.4571, 62.8037}, CountryId{"RU"}}, // Perguba
    {Coordinate{34.3613, 62.7391}, CountryId{"RU"}}, // Unitsa
    {Coordinate{7.5411, 45.2556}, CountryId{"IT"}}, // Mathi railway station
    {Coordinate{34.2696, 62.6742}, CountryId{"RU"}}, // Kyappeselga
    {Coordinate{34.2563, 62.6506}, CountryId{"RU"}}, // 522 km
    {Coordinate{34.2843, 62.5906}, CountryId{"RU"}}, // Vikshozero
    {Coordinate{34.3516, 62.4892}, CountryId{"RU"}}, // Novy Posyolok
    {Coordinate{46.924, 60.8727}, CountryId{"RU"}}, // Q111660325
    {Coordinate{46.8408, 60.9071}, CountryId{"RU"}}, // Q111660326
    {Coordinate{46.7871, 60.9427}, CountryId{"RU"}}, // Q111660327
    {Coordinate{46.7846, 60.996}, CountryId{"RU"}}, // Q111660328
    {Coordinate{46.7799, 61.0592}, CountryId{"RU"}}, // Q111660329
    {Coordinate{46.7491, 61.0873}, CountryId{"RU"}}, // Q111660330
    {Coordinate{46.7383, 61.0971}, CountryId{"RU"}}, // Q111660332
    {Coordinate{46.7262, 61.1081}, CountryId{"RU"}}, // Q111660333
    {Coordinate{46.6897, 61.1411}, CountryId{"RU"}}, // Q111660334
    {Coordinate{46.675, 61.1543}, CountryId{"RU"}}, // Q111660335
    {Coordinate{46.6334, 61.1931}, CountryId{"RU"}}, // Q111660336
    {Coordinate{46.6251, 61.2113}, CountryId{"RU"}}, // Q111660467
    {Coordinate{34.471, 62.3882}, CountryId{"RU"}}, // 489 km
    {Coordinate{34.4872, 62.3628}, CountryId{"RU"}}, // Kedrozero
    {Coordinate{34.5163, 62.2999}, CountryId{"RU"}}, // Ilemselga
    {Coordinate{34.4486, 62.261}, CountryId{"RU"}}, // Myanselga
    {Coordinate{34.4373, 62.2399}, CountryId{"RU"}}, // 468 km
    {Coordinate{34.3428, 62.2239}, CountryId{"RU"}}, // Nigozero
    {Coordinate{46.8792, 61.2449}, CountryId{"RU"}}, // Solvychegodsk railway station
    {Coordinate{46.6222, 61.2462}, CountryId{"RU"}}, // Q111662678
    {Coordinate{46.6487, 61.2593}, CountryId{"RU"}}, // Q111662679
    {Coordinate{46.6816, 61.2573}, CountryId{"RU"}}, // Q111662680
    {Coordinate{46.708, 61.2539}, CountryId{"RU"}}, // Q111662681
    {Coordinate{46.8505, 61.2478}, CountryId{"RU"}}, // Q111662682
    {Coordinate{34.2286, 62.2068}, CountryId{"RU"}}, // 454 km
    {Coordinate{34.2056, 62.1681}, CountryId{"RU"}}, // Zadeliye
    {Coordinate{34.231, 62.0644}, CountryId{"RU"}}, // 437 km
    {Coordinate{34.214, 62.0382}, CountryId{"RU"}}, // Luchevoy
    {Coordinate{34.2456, 61.9797}, CountryId{"RU"}}, // 427 km
    {Coordinate{40.2, 58.209}, CountryId{"RU"}}, // Q111668436
    {Coordinate{40.3508, 58.2483}, CountryId{"RU"}}, // Q111668437
    {Coordinate{40.4712, 58.272}, CountryId{"RU"}}, // Q111668438
    {Coordinate{40.6181, 58.3153}, CountryId{"RU"}}, // Q111668439
    {Coordinate{40.791, 58.3451}, CountryId{"RU"}}, // Q111668440
    {Coordinate{40.8586, 58.3379}, CountryId{"RU"}}, // Q111668441
    {Coordinate{41.0438, 58.3455}, CountryId{"RU"}}, // Q111668443
    {Coordinate{41.1001, 58.3627}, CountryId{"RU"}}, // Q111668444
    {Coordinate{41.1817, 58.3939}, CountryId{"RU"}}, // Q111668445
    {Coordinate{41.2415, 58.4077}, CountryId{"RU"}}, // Q111668446
    {Coordinate{41.298, 58.4249}, CountryId{"RU"}}, // Q111668447
    {Coordinate{41.3391, 58.4397}, CountryId{"RU"}}, // Q111668448
    {Coordinate{41.3751, 58.455}, CountryId{"RU"}}, // Q111668449
    {Coordinate{41.4185, 58.4658}, CountryId{"RU"}}, // Q111668450
    {Coordinate{40.2607, 58.6129}, CountryId{"RU"}}, // Q111668800
    {Coordinate{34.2499, 61.8858}, CountryId{"RU"}}, // Shuysky Most
    {Coordinate{33.3771, 69.0556}, CountryId{"RU"}}, // Vaenga
    {Coordinate{14.5844, 49.601}, CountryId{"CZ"}}, // Heřmaničky
    {Coordinate{14.597, 49.5777}, CountryId{"CZ"}}, // Ješetice
    {Coordinate{14.6137, 49.5602}, CountryId{"CZ"}}, // Červený Újezd u Votic zastávka
    {Coordinate{14.6149, 49.5568}, CountryId{"CZ"}}, // Červený Újezd u Votic
    {Coordinate{14.6213, 49.5437}, CountryId{"CZ"}}, // Střezimíř
    {Coordinate{14.6545, 49.5366}, CountryId{"CZ"}}, // Mezno
    {Coordinate{32.4539, 68.9693}, CountryId{"RU"}}, // Pyayve
    {Coordinate{32.1231, 69.0784}, CountryId{"RU"}}, // Nyal
    {Coordinate{18.1446, 49.184}, CountryId{"SK"}}, // Strelenka railway station
    {Coordinate{117.398, 53.0337}, CountryId{"RU"}}, // Q111695980
    {Coordinate{113.546, 51.9895}, CountryId{"RU"}}, // Q111696033
    {Coordinate{113.631, 51.9289}, CountryId{"RU"}}, // Q111696039
    {Coordinate{109.863, 51.3875}, CountryId{"RU"}}, // Q111696042
    {Coordinate{110.173, 51.451}, CountryId{"RU"}}, // Q111696052
    {Coordinate{117.271, 52.8252}, CountryId{"RU"}}, // Q111696060
    {Coordinate{112.528, 51.8169}, CountryId{"RU"}}, // Q111696065
    {Coordinate{109.331, 51.2072}, CountryId{"RU"}}, // Q111696070
    {Coordinate{112.643, 51.8427}, CountryId{"RU"}}, // Q111696078
    {Coordinate{111.425, 51.6354}, CountryId{"RU"}}, // Q111696087
    {Coordinate{110.928, 51.438}, CountryId{"RU"}}, // Q111696096
    {Coordinate{109.573, 51.2852}, CountryId{"RU"}}, // Q111696099
    {Coordinate{40.1904, 58.2653}, CountryId{"RU"}}, // Q111697593
    {Coordinate{40.2222, 58.3099}, CountryId{"RU"}}, // Q111697594
    {Coordinate{40.2768, 58.3663}, CountryId{"RU"}}, // Q111697595
    {Coordinate{40.3326, 58.3903}, CountryId{"RU"}}, // Q111697596
    {Coordinate{40.3529, 58.4199}, CountryId{"RU"}}, // Q111697597
    {Coordinate{40.3406, 58.4891}, CountryId{"RU"}}, // Q111697598
    {Coordinate{40.3068, 58.5053}, CountryId{"RU"}}, // Q111697600
    {Coordinate{40.2194, 58.5318}, CountryId{"RU"}}, // Q111697601
    {Coordinate{40.2291, 58.5768}, CountryId{"RU"}}, // Q111697602
    {Coordinate{40.1841, 58.6519}, CountryId{"RU"}}, // Q111697603
    {Coordinate{40.126, 58.7175}, CountryId{"RU"}}, // Q111697604
    {Coordinate{40.1832, 58.8105}, CountryId{"RU"}}, // Q111697605
    {Coordinate{40.2217, 58.9269}, CountryId{"RU"}}, // Q111697606
    {Coordinate{40.2173, 58.9507}, CountryId{"RU"}}, // Q111697607
    {Coordinate{40.2254, 59.0044}, CountryId{"RU"}}, // Q111697608
    {Coordinate{40.2393, 59.0367}, CountryId{"RU"}}, // Q111697609
    {Coordinate{40.2216, 59.0624}, CountryId{"RU"}}, // Q111697611
    {Coordinate{40.1981, 59.0744}, CountryId{"RU"}}, // Q111697612
    {Coordinate{40.0857, 59.1471}, CountryId{"RU"}}, // Q111697613
    {Coordinate{40.0472, 59.1567}, CountryId{"RU"}}, // Q111697614
    {Coordinate{40.0032, 59.1645}, CountryId{"RU"}}, // Q111697615
    {Coordinate{39.9737, 59.178}, CountryId{"RU"}}, // Q111697616
    {Coordinate{39.9266, 59.1958}, CountryId{"RU"}}, // Q111697617
    {Coordinate{40.2243, 59.0815}, CountryId{"RU"}}, // Q111698086
    {Coordinate{40.3051, 59.0618}, CountryId{"RU"}}, // Q111698087
    {Coordinate{40.377, 59.0427}, CountryId{"RU"}}, // Q111698088
    {Coordinate{40.4589, 59.0213}, CountryId{"RU"}}, // Q111698089
    {Coordinate{40.5839, 58.9891}, CountryId{"RU"}}, // Q111698090
    {Coordinate{40.6157, 58.9835}, CountryId{"RU"}}, // Q111698091
    {Coordinate{40.6439, 58.9745}, CountryId{"RU"}}, // Q111698092
    {Coordinate{40.6953, 58.9562}, CountryId{"RU"}}, // Q111698093
    {Coordinate{40.7655, 58.9307}, CountryId{"RU"}}, // Q111698094
    {Coordinate{40.8511, 58.8966}, CountryId{"RU"}}, // Q111698095
    {Coordinate{40.918, 58.8696}, CountryId{"RU"}}, // Q111698096
    {Coordinate{40.9935, 58.8386}, CountryId{"RU"}}, // Q111698097
    {Coordinate{41.1354, 58.7573}, CountryId{"RU"}}, // Q111698098
    {Coordinate{41.1758, 58.7297}, CountryId{"RU"}}, // Q111698099
    {Coordinate{41.2871, 58.6519}, CountryId{"RU"}}, // Q111698101
    {Coordinate{41.3444, 58.609}, CountryId{"RU"}}, // Q111698102
    {Coordinate{41.4049, 58.5515}, CountryId{"RU"}}, // Q111698103
    {Coordinate{41.4732, 58.5086}, CountryId{"RU"}}, // Q111698104
    {Coordinate{18.1962, 49.1954}, CountryId{"SK"}}, // Lysá pod Makytou railway station
    {Coordinate{18.2275, 49.1909}, CountryId{"SK"}}, // Lúky pod Makytou railway station
    {Coordinate{9.11234, 48.2899}, CountryId{"DE"}}, // Burladingen station
    {Coordinate{9.03761, 48.3264}, CountryId{"DE"}}, // Jungingen (Hohenz) station
    {Coordinate{9.02515, 48.3435}, CountryId{"DE"}}, // Schlatt (Hohenz) railway stop
    {Coordinate{9.06811, 48.3016}, CountryId{"DE"}}, // Hausen-Starzeln railway stop
    {Coordinate{9.16319, 48.2762}, CountryId{"DE"}}, // Gauselfingen railway stop
    {Coordinate{40.6101, 57.4889}, CountryId{"RU"}}, // Q111698915
    {Coordinate{40.6731, 57.5136}, CountryId{"RU"}}, // Q111698916
    {Coordinate{40.814, 57.6456}, CountryId{"RU"}}, // Q111698917
    {Coordinate{41.0709, 57.7869}, CountryId{"RU"}}, // Q111698918
    {Coordinate{41.1766, 57.8003}, CountryId{"RU"}}, // Q111698919
    {Coordinate{41.2393, 57.7996}, CountryId{"RU"}}, // Q111698920
    {Coordinate{41.4089, 57.8101}, CountryId{"RU"}}, // Q111698921
    {Coordinate{41.4936, 57.8303}, CountryId{"RU"}}, // Q111698922
    {Coordinate{41.5587, 57.8393}, CountryId{"RU"}}, // Q111698923
    {Coordinate{41.6022, 57.8745}, CountryId{"RU"}}, // Q111698924
    {Coordinate{41.6533, 57.8909}, CountryId{"RU"}}, // Q111698925
    {Coordinate{41.7384, 57.9737}, CountryId{"RU"}}, // Q111698926
    {Coordinate{41.8049, 57.998}, CountryId{"RU"}}, // Q111698927
    {Coordinate{41.9317, 58.037}, CountryId{"RU"}}, // Q111698928
    {Coordinate{42.0584, 58.1095}, CountryId{"RU"}}, // Q111698929
    {Coordinate{42.1443, 58.1682}, CountryId{"RU"}}, // Q111698930
    {Coordinate{42.1849, 58.1926}, CountryId{"RU"}}, // Q111698931
    {Coordinate{42.2293, 58.2496}, CountryId{"RU"}}, // Q111698932
    {Coordinate{42.2477, 58.3379}, CountryId{"RU"}}, // Q111698933
    {Coordinate{40.6917, 57.4063}, CountryId{"RU"}}, // Q111699218
    {Coordinate{40.838, 57.3465}, CountryId{"RU"}}, // Q111699220
    {Coordinate{40.9154, 57.2824}, CountryId{"RU"}}, // Q111699221
    {Coordinate{41.2064, 57.1543}, CountryId{"RU"}}, // Q111699222
    {Coordinate{31.2454, 69.2681}, CountryId{"RU"}}, // Titovka
    {Coordinate{15.3108, 47.8651}, CountryId{"AT"}}, // railway station Annaberg
    {Coordinate{15.2864, 47.9511}, CountryId{"AT"}}, // Laubenbachmühle
    {Coordinate{14.3122, 47.55}, CountryId{"AT"}}, // Selzthal railway station
    {Coordinate{14.2311, 48.2741}, CountryId{"AT"}}, // Am Dürrweg railway station
    {Coordinate{14.166, 48.2751}, CountryId{"AT"}}, // Kirchberg-Thürnau railway station
    {Coordinate{13.9013, 48.315}, CountryId{"AT"}}, // Prambachkirchen-Bad Weinberg railway station
    {Coordinate{14.1853, 48.2691}, CountryId{"AT"}}, // Thurnharting railway station
    {Coordinate{9.17562, 48.4963}, CountryId{"DE"}}, // Reutlingen-Betzingen station
    {Coordinate{9.23685, 48.5153}, CountryId{"DE"}}, // Reutlingen-Sondelfingen station
    {Coordinate{9.37632, 48.4993}, CountryId{"DE"}}, // Bad Urach Wasserfall railway stop
    {Coordinate{9.34424, 48.528}, CountryId{"DE"}}, // Dettingen-Mitte railway stop
    {Coordinate{9.39659, 48.4916}, CountryId{"DE"}}, // Bad Urach station
    {Coordinate{41.7526, 57.1938}, CountryId{"RU"}}, // Q111709136
    {Coordinate{41.9244, 57.2217}, CountryId{"RU"}}, // Q111709137
    {Coordinate{42.0208, 57.3215}, CountryId{"RU"}}, // Q111709138
    {Coordinate{41.0641, 56.9832}, CountryId{"RU"}}, // Q111709377
    {Coordinate{41.139, 56.9519}, CountryId{"RU"}}, // Q111709378
    {Coordinate{41.2375, 56.8946}, CountryId{"RU"}}, // Q111709379
    {Coordinate{41.3068, 56.7265}, CountryId{"RU"}}, // Q111709380
    {Coordinate{41.2637, 56.6598}, CountryId{"RU"}}, // Q111709381
    {Coordinate{41.212, 56.5894}, CountryId{"RU"}}, // Q111709382
    {Coordinate{41.197, 56.4898}, CountryId{"RU"}}, // Q111709383
    {Coordinate{41.1992, 56.4569}, CountryId{"RU"}}, // Q111709384
    {Coordinate{41.1642, 56.4429}, CountryId{"RU"}}, // Q111709385
    {Coordinate{41.147, 56.4102}, CountryId{"RU"}}, // Q111709386
    {Coordinate{32.2898, 67.3493}, CountryId{"RU"}}, // Chervas
    {Coordinate{32.0871, 67.4115}, CountryId{"RU"}}, // Pasma
    {Coordinate{31.9058, 67.4933}, CountryId{"RU"}}, // Upoloksha
    {Coordinate{31.3919, 67.5751}, CountryId{"RU"}}, // Kolyuzhny
    {Coordinate{9.60582, 47.7848}, CountryId{"DE"}}, // Bahnhof Ravensburg
    {Coordinate{31.1418, 67.5812}, CountryId{"RU"}}, // Yona
    {Coordinate{30.8409, 67.4885}, CountryId{"RU"}}, // Kuropta
    {Coordinate{30.4815, 67.5489}, CountryId{"RU"}}, // Kovdor
    {Coordinate{31.4552, 66.9625}, CountryId{"RU"}}, // Nyam-Ozero
    {Coordinate{30.3436, 66.9636}, CountryId{"RU"}}, // Alakurti
    {Coordinate{34.788, 64.4715}, CountryId{"RU"}}, // Shizhnya
    {Coordinate{35.0057, 64.3904}, CountryId{"RU"}}, // Sukhoye
    {Coordinate{42.1499, 61.0526}, CountryId{"RU"}}, // Q111731860
    {Coordinate{42.1972, 61.0404}, CountryId{"RU"}}, // Q111731863
    {Coordinate{42.2126, 61.0364}, CountryId{"RU"}}, // Q111731866
    {Coordinate{42.2822, 61.0239}, CountryId{"RU"}}, // Q111731869
    {Coordinate{42.3408, 61.0215}, CountryId{"RU"}}, // Q111731872
    {Coordinate{42.4556, 61.0346}, CountryId{"RU"}}, // Q111731876
    {Coordinate{42.7792, 61.0697}, CountryId{"RU"}}, // Q111731880
    {Coordinate{42.8414, 61.0727}, CountryId{"RU"}}, // Q111731883
    {Coordinate{42.8647, 61.0742}, CountryId{"RU"}}, // Q111731886
    {Coordinate{42.9623, 61.0832}, CountryId{"RU"}}, // Q111731889
    {Coordinate{43.0957, 61.0912}, CountryId{"RU"}}, // Q111731892
    {Coordinate{43.1671, 61.0758}, CountryId{"RU"}}, // Q111731895
    {Coordinate{43.2962, 61.0756}, CountryId{"RU"}}, // Q111731898
    {Coordinate{43.3621, 61.0615}, CountryId{"RU"}}, // Q111731900
    {Coordinate{43.4207, 61.0438}, CountryId{"RU"}}, // Q111731903
    {Coordinate{43.5017, 61.0368}, CountryId{"RU"}}, // Q111731905
    {Coordinate{43.6549, 61.0337}, CountryId{"RU"}}, // Q111731907
    {Coordinate{43.7366, 61.0298}, CountryId{"RU"}}, // Q111731909
    {Coordinate{43.9061, 61.0532}, CountryId{"RU"}}, // Q111731911
    {Coordinate{43.968, 61.0591}, CountryId{"RU"}}, // Q111731914
    {Coordinate{44.1017, 61.0567}, CountryId{"RU"}}, // Q111731917
    {Coordinate{44.1585, 61.0608}, CountryId{"RU"}}, // Q111731920
    {Coordinate{44.2362, 61.0664}, CountryId{"RU"}}, // Q111731922
    {Coordinate{44.3158, 61.072}, CountryId{"RU"}}, // Q111731924
    {Coordinate{44.3887, 61.0772}, CountryId{"RU"}}, // Q111731926
    {Coordinate{44.6124, 61.0826}, CountryId{"RU"}}, // Q111731928
    {Coordinate{44.8201, 61.116}, CountryId{"RU"}}, // Q111731930
    {Coordinate{44.8398, 61.1168}, CountryId{"RU"}}, // Q111731932
    {Coordinate{44.9812, 61.1377}, CountryId{"RU"}}, // Q111731933
    {Coordinate{45.1171, 61.1426}, CountryId{"RU"}}, // Q111731934
    {Coordinate{45.2803, 61.1339}, CountryId{"RU"}}, // Q111731936
    {Coordinate{45.3401, 61.1474}, CountryId{"RU"}}, // Q111731937
    {Coordinate{45.3805, 61.1442}, CountryId{"RU"}}, // Q111731938
    {Coordinate{45.4203, 61.1474}, CountryId{"RU"}}, // Q111731939
    {Coordinate{45.5108, 61.1333}, CountryId{"RU"}}, // Q111731940
    {Coordinate{45.7371, 61.1471}, CountryId{"RU"}}, // Q111731941
    {Coordinate{45.7861, 61.1505}, CountryId{"RU"}}, // Q111731942
    {Coordinate{45.9204, 61.1429}, CountryId{"RU"}}, // Q111731943
    {Coordinate{46.1418, 61.161}, CountryId{"RU"}}, // Q111731945
    {Coordinate{46.2081, 61.166}, CountryId{"RU"}}, // Q111731946
    {Coordinate{46.3499, 61.1522}, CountryId{"RU"}}, // Q111731947
    {Coordinate{46.4535, 61.1829}, CountryId{"RU"}}, // Q111731949
    {Coordinate{46.5114, 61.1974}, CountryId{"RU"}}, // Q111731950
    {Coordinate{46.589, 61.2052}, CountryId{"RU"}}, // Q111731951
    {Coordinate{46.3981, 61.165}, CountryId{"RU"}}, // Q111731976
    {Coordinate{12.2988, 45.8848}, CountryId{"IT"}}, // Conegliano railway station
    {Coordinate{35.9175, 64.0467}, CountryId{"RU"}}, // Ukhtitsa
    {Coordinate{36.004, 64.013}, CountryId{"RU"}}, // Virandozero
    {Coordinate{36.1124, 63.9702}, CountryId{"RU"}}, // Ruyga
    {Coordinate{36.2573, 63.9101}, CountryId{"RU"}}, // Nyukhcha
    {Coordinate{36.6355, 63.7872}, CountryId{"RU"}}, // Unezhma
    {Coordinate{36.9159, 63.735}, CountryId{"RU"}}, // Sulozero
    {Coordinate{37.0518, 63.7244}, CountryId{"RU"}}, // Kusha
    {Coordinate{37.2934, 63.7409}, CountryId{"RU"}}, // Shundanets
    {Coordinate{37.4428, 63.7169}, CountryId{"RU"}}, // 183 km
    {Coordinate{37.465, 63.7058}, CountryId{"RU"}}, // Maloshuyka
    {Coordinate{37.8222, 63.705}, CountryId{"RU"}}, // 205 km
    {Coordinate{7.64878, 48.0404}, CountryId{"DE"}}, // Ihringen station
    {Coordinate{7.68681, 48.0466}, CountryId{"DE"}}, // Wasenweiler
    {Coordinate{7.78393, 48.0482}, CountryId{"DE"}}, // Hugstetten station
    {Coordinate{7.83267, 48.0129}, CountryId{"DE"}}, // Freiburg Messe/Universität station
    {Coordinate{7.84275, 48.0056}, CountryId{"DE"}}, // Freiburg Klinikum station
    {Coordinate{7.74996, 48.1542}, CountryId{"DE"}}, // Riegel am Kaiserstuhl Ort station
    {Coordinate{7.74778, 48.118}, CountryId{"DE"}}, // Bahlingen Riedlen station
    {Coordinate{}, CountryId{"FR"}}, // Q111792777
    {Coordinate{3.21862, 46.9709}, CountryId{"FR"}}, // Q111792796
    {Coordinate{3.92618, 47.0719}, CountryId{"FR"}}, // Q111792814
    {Coordinate{5.4155, 47.0424}, CountryId{"FR"}}, // Q111792835
    {Coordinate{38.3545, 63.8029}, CountryId{"RU"}}, // Gribanikha
    {Coordinate{38.4713, 63.8399}, CountryId{"RU"}}, // 243 km
    {Coordinate{38.5374, 63.8451}, CountryId{"RU"}}, // Vonguda
    {Coordinate{38.7646, 63.8132}, CountryId{"RU"}}, // Tyosovka
    {Coordinate{39.0074, 63.7893}, CountryId{"RU"}}, // Glazanikha
    {Coordinate{39.2535, 63.7765}, CountryId{"RU"}}, // Mudyuga
    {Coordinate{8.07689, 48.529}, CountryId{"DE"}}, // Oberkirch station
    {Coordinate{8.08944, 48.5248}, CountryId{"DE"}}, // Oberkirch-Köhlersiedlung station
    {Coordinate{8.11607, 48.5195}, CountryId{"DE"}}, // Lautenbach (Baden) station
    {Coordinate{8.13569, 48.5074}, CountryId{"DE"}}, // Hubacker station
    {Coordinate{8.13936, 48.4949}, CountryId{"DE"}}, // Ramsbach Höfle station
    {Coordinate{8.14567, 48.4883}, CountryId{"DE"}}, // Ramsbach Birkhof station
    {Coordinate{8.15976, 48.472}, CountryId{"DE"}}, // Oppenau station
    {Coordinate{8.16274, 48.4551}, CountryId{"DE"}}, // Ibach station
    {Coordinate{8.17225, 48.4347}, CountryId{"DE"}}, // Löcherberg station
    {Coordinate{8.20195, 48.4289}, CountryId{"DE"}}, // Bad Peterstal station
    {Coordinate{8.05647, 48.299}, CountryId{"DE"}}, // Steinach (Baden) station
    {Coordinate{8.08797, 48.28}, CountryId{"DE"}}, // Haslach station
    {Coordinate{8.19857, 48.2717}, CountryId{"DE"}}, // Gutach Freilichtmuseum station
    {Coordinate{39.4195, 63.7599}, CountryId{"RU"}}, // Kostrinsky Ruchey
    {Coordinate{39.6651, 63.7227}, CountryId{"RU"}}, // Kodino
    {Coordinate{39.885, 63.6685}, CountryId{"RU"}}, // Moshnoye
    {Coordinate{38.096, 63.9255}, CountryId{"RU"}}, // Onega
    {Coordinate{8.23294, 48.2119}, CountryId{"DE"}}, // Hornberg (Schwarzw) station
    {Coordinate{8.46915, 48.0313}, CountryId{"DE"}}, // Marbach West (Villingen-Schwenningen) station
    {Coordinate{8.46781, 48.0143}, CountryId{"DE"}}, // Brigachtal Kirchdorf station
    {Coordinate{8.46578, 48.0074}, CountryId{"DE"}}, // Brigachtal Klengen station
    {Coordinate{8.47182, 47.9831}, CountryId{"DE"}}, // Donaueschingen Grüningen station
    {Coordinate{8.47562, 47.9634}, CountryId{"DE"}}, // Donaueschingen Aufen station
    {Coordinate{8.48895, 47.9525}, CountryId{"DE"}}, // Donaueschingen Mitte/Siedlung station
    {Coordinate{8.65395, 47.9213}, CountryId{"DE"}}, // Geisingen station
    {Coordinate{8.71405, 47.9329}, CountryId{"DE"}}, // Immendingen Zimmern station
    {Coordinate{8.76922, 47.834}, CountryId{"DE"}}, // Welschingen-Neuhausen station
    {Coordinate{8.80439, 47.8137}, CountryId{"DE"}}, // Mühlhausen (b Engen) station
    {Coordinate{8.82705, 47.7607}, CountryId{"DE"}}, // Singen Landesgartenschau station
    {Coordinate{46.9045, 61.2419}, CountryId{"RU"}}, // Q111845130
    {Coordinate{46.9491, 61.2398}, CountryId{"RU"}}, // Q111845131
    {Coordinate{46.9914, 61.2504}, CountryId{"RU"}}, // Q111845132
    {Coordinate{47.1039, 61.261}, CountryId{"RU"}}, // Q111845134
    {Coordinate{47.2514, 61.2739}, CountryId{"RU"}}, // Cheremukha railway station
    {Coordinate{47.3257, 61.2804}, CountryId{"RU"}}, // Q111845136
    {Coordinate{47.4205, 61.2886}, CountryId{"RU"}}, // Q111845137
    {Coordinate{47.4831, 61.2933}, CountryId{"RU"}}, // Q111845138
    {Coordinate{47.5305, 61.312}, CountryId{"RU"}}, // Q111845139
    {Coordinate{47.6548, 61.3617}, CountryId{"RU"}}, // Q111845140
    {Coordinate{47.7162, 61.3898}, CountryId{"RU"}}, // Q111845141
    {Coordinate{47.8153, 61.4352}, CountryId{"RU"}}, // Q111845142
    {Coordinate{47.8808, 61.4533}, CountryId{"RU"}}, // Q111845143
    {Coordinate{47.9507, 61.4713}, CountryId{"RU"}}, // Q111845144
    {Coordinate{48.0058, 61.4855}, CountryId{"RU"}}, // Q111845145
    {Coordinate{48.064, 61.5069}, CountryId{"RU"}}, // Q111845146
    {Coordinate{48.141, 61.5366}, CountryId{"RU"}}, // Q111845147
    {Coordinate{48.2007, 61.5597}, CountryId{"RU"}}, // Q111845149
    {Coordinate{48.228, 61.5732}, CountryId{"RU"}}, // Q111845150
    {Coordinate{48.2416, 61.5878}, CountryId{"RU"}}, // Q111845152
    {Coordinate{48.2771, 61.6178}, CountryId{"RU"}}, // Q111845153
    {Coordinate{48.3584, 61.6718}, CountryId{"RU"}}, // Q111845154
    {Coordinate{48.5468, 61.7556}, CountryId{"RU"}}, // Q111845156
    {Coordinate{49.3144, 62.0275}, CountryId{"RU"}}, // Q111845157
    {Coordinate{49.7935, 62.2145}, CountryId{"RU"}}, // Q111845159
    {Coordinate{39.8611, 59.2222}, CountryId{"RU"}}, // Q111846324
    {Coordinate{39.867, 59.2363}, CountryId{"RU"}}, // Q111846325
    {Coordinate{39.9259, 59.317}, CountryId{"RU"}}, // Q111846329
    {Coordinate{39.9931, 59.3637}, CountryId{"RU"}}, // Q111846330
    {Coordinate{40.0276, 59.38}, CountryId{"RU"}}, // Q111846331
    {Coordinate{40.0644, 59.4172}, CountryId{"RU"}}, // Q111846332
    {Coordinate{40.1433, 59.5074}, CountryId{"RU"}}, // Q111846333
    {Coordinate{40.1754, 59.5713}, CountryId{"RU"}}, // Q111846334
    {Coordinate{40.1882, 59.6193}, CountryId{"RU"}}, // Q111846335
    {Coordinate{40.1792, 59.6692}, CountryId{"RU"}}, // Q111846336
    {Coordinate{40.1778, 59.694}, CountryId{"RU"}}, // Q111846338
    {Coordinate{40.1707, 59.7291}, CountryId{"RU"}}, // Q111846339
    {Coordinate{40.1633, 59.7656}, CountryId{"RU"}}, // Q111846341
    {Coordinate{40.1656, 59.8127}, CountryId{"RU"}}, // Q111846342
    {Coordinate{40.1671, 59.8766}, CountryId{"RU"}}, // Q111846343
    {Coordinate{40.1779, 59.9786}, CountryId{"RU"}}, // Q111846344
    {Coordinate{40.1899, 60.0118}, CountryId{"RU"}}, // Q111846345
    {Coordinate{40.203, 60.0785}, CountryId{"RU"}}, // Q111846347
    {Coordinate{40.2044, 60.1309}, CountryId{"RU"}}, // Q111846348
    {Coordinate{40.2565, 60.2372}, CountryId{"RU"}}, // Q111846349
    {Coordinate{40.2664, 60.274}, CountryId{"RU"}}, // Q111846350
    {Coordinate{40.2369, 60.3807}, CountryId{"RU"}}, // Q111846352
    {Coordinate{40.2189, 60.4203}, CountryId{"RU"}}, // Q111846353
    {Coordinate{40.219, 60.5298}, CountryId{"RU"}}, // Q111846355
    {Coordinate{40.1571, 60.6066}, CountryId{"RU"}}, // Q111846356
    {Coordinate{40.159, 60.6305}, CountryId{"RU"}}, // Q111846357
    {Coordinate{40.1469, 60.6384}, CountryId{"RU"}}, // Q111846358
    {Coordinate{40.1443, 60.6644}, CountryId{"RU"}}, // Q111846359
    {Coordinate{40.1405, 60.7027}, CountryId{"RU"}}, // Q111846360
    {Coordinate{40.1197, 60.7491}, CountryId{"RU"}}, // Q111846361
    {Coordinate{40.091, 60.8279}, CountryId{"RU"}}, // Q111846362
    {Coordinate{40.0948, 60.8619}, CountryId{"RU"}}, // Q111846363
    {Coordinate{40.1155, 60.8788}, CountryId{"RU"}}, // Q111846364
    {Coordinate{40.1181, 60.9016}, CountryId{"RU"}}, // Q111846366
    {Coordinate{40.1671, 60.9301}, CountryId{"RU"}}, // Q111846367
    {Coordinate{39.9084, 59.2924}, CountryId{"RU"}}, // Q111846393
    {Coordinate{40.2151, 60.4993}, CountryId{"RU"}}, // Q111846395
    {Coordinate{37.751, 59.1417}, CountryId{"RU"}}, // Q111846724
    {Coordinate{8.22185, 48.2937}, CountryId{"DE"}}, // Wolfach station
    {Coordinate{10.0503, 45.6564}, CountryId{"IT"}}, // Iseo railway station
    {Coordinate{17.6101, 40.4372}, CountryId{"IT"}}, // Sava railway station
    {Coordinate{15.4279, 40.8865}, CountryId{"IT"}}, // Calitri-Pescopagano railway station
    {Coordinate{8.27045, 48.2907}, CountryId{"DE"}}, // Halbmeil station
    {Coordinate{8.34477, 48.2913}, CountryId{"DE"}}, // Schiltach Mitte station
    {Coordinate{8.37189, 48.3084}, CountryId{"DE"}}, // Schenkenzell station
    {Coordinate{8.39825, 48.3438}, CountryId{"DE"}}, // Alpirsbach station
    {Coordinate{8.45319, 48.4181}, CountryId{"DE"}}, // Loßburg-Rodt station
    {Coordinate{22.9346, 55.9793}, CountryId{"LT"}}, // Pavenčiai train station
    {Coordinate{-3.14281, 51.6658}, CountryId{"GB"}}, // Newbridge railway station
    {Coordinate{37.8833, 59.1526}, CountryId{"RU"}}, // Q111970496
    {Coordinate{37.9862, 59.1372}, CountryId{"RU"}}, // Q111970497
    {Coordinate{38.1376, 59.1249}, CountryId{"RU"}}, // Q111970498
    {Coordinate{38.1673, 59.1333}, CountryId{"RU"}}, // Q111970499
    {Coordinate{38.1853, 59.1528}, CountryId{"RU"}}, // Q111970500
    {Coordinate{38.2357, 59.1683}, CountryId{"RU"}}, // Q111970501
    {Coordinate{38.3125, 59.1754}, CountryId{"RU"}}, // Q111970502
    {Coordinate{38.3734, 59.1895}, CountryId{"RU"}}, // Q111970503
    {Coordinate{38.4263, 59.2014}, CountryId{"RU"}}, // Q111970504
    {Coordinate{38.4674, 59.1949}, CountryId{"RU"}}, // Q111970505
    {Coordinate{38.6016, 59.204}, CountryId{"RU"}}, // Q111970506
    {Coordinate{38.6756, 59.2064}, CountryId{"RU"}}, // Q111970507
    {Coordinate{38.7132, 59.1954}, CountryId{"RU"}}, // Q111970508
    {Coordinate{38.7714, 59.1934}, CountryId{"RU"}}, // Q111970509
    {Coordinate{38.9678, 59.2199}, CountryId{"RU"}}, // Q111970510
    {Coordinate{39.0374, 59.2294}, CountryId{"RU"}}, // Q111970511
    {Coordinate{39.321, 59.2551}, CountryId{"RU"}}, // Q111970512
    {Coordinate{39.321, 59.2551}, CountryId{"RU"}}, // Q111970513
    {Coordinate{39.3875, 59.2507}, CountryId{"RU"}}, // Q111970514
    {Coordinate{39.4177, 59.2501}, CountryId{"RU"}}, // Q111970515
    {Coordinate{39.6574, 59.2569}, CountryId{"RU"}}, // Q111970516
    {Coordinate{39.7413, 59.245}, CountryId{"RU"}}, // Q111970517
    {Coordinate{10.9019, 43.0574}, CountryId{"IT"}}, // Massa Marittima railway station
    {Coordinate{40.6569, 61.0391}, CountryId{"RU"}}, // Q111976822
    {Coordinate{40.761, 61.0472}, CountryId{"RU"}}, // Q111976824
    {Coordinate{40.8504, 61.0457}, CountryId{"RU"}}, // Q111976825
    {Coordinate{40.8869, 61.0457}, CountryId{"RU"}}, // Q111976826
    {Coordinate{40.9682, 61.0456}, CountryId{"RU"}}, // Q111976827
    {Coordinate{41.1318, 61.0556}, CountryId{"RU"}}, // Q111976828
    {Coordinate{41.3011, 61.0584}, CountryId{"RU"}}, // Q111976829
    {Coordinate{41.3384, 61.0564}, CountryId{"RU"}}, // Q111976830
    {Coordinate{41.4651, 61.0573}, CountryId{"RU"}}, // Q111976831
    {Coordinate{41.6267, 61.0346}, CountryId{"RU"}}, // Q111976832
    {Coordinate{41.6393, 61.0328}, CountryId{"RU"}}, // Q111976833
    {Coordinate{41.8636, 61.0234}, CountryId{"RU"}}, // Q111976834
    {Coordinate{41.9254, 61.0383}, CountryId{"RU"}}, // Q111976835
    {Coordinate{42.0167, 61.0552}, CountryId{"RU"}}, // Q111976836
    {Coordinate{8.5828, 49.5355}, CountryId{"DE"}}, // Q111985914
    {Coordinate{40.6567, 61.0393}, CountryId{"RU"}}, // Q111988147
    {Coordinate{40.7354, 61.0532}, CountryId{"RU"}}, // Q111988148
    {Coordinate{40.8735, 61.0971}, CountryId{"RU"}}, // Q111988149
    {Coordinate{41.1517, 61.1469}, CountryId{"RU"}}, // Q111988150
    {Coordinate{41.2584, 61.1447}, CountryId{"RU"}}, // Q111988151
    {Coordinate{41.3734, 61.1382}, CountryId{"RU"}}, // Q111988152
    {Coordinate{41.4299, 61.1056}, CountryId{"RU"}}, // Q111988153
    {Coordinate{41.5896, 61.086}, CountryId{"RU"}}, // Q111988154
    {Coordinate{41.7591, 61.0792}, CountryId{"RU"}}, // Q111988155
    {Coordinate{41.9636, 61.078}, CountryId{"RU"}}, // Q111988156
    {Coordinate{41.9917, 61.0689}, CountryId{"RU"}}, // Q111988157
    {Coordinate{14.1581, 46.3604}, CountryId{"SI"}}, // Lesce - Bled train station
    {Coordinate{50.2349, 62.4344}, CountryId{"RU"}}, // Q112005518
    {Coordinate{50.7361, 62.5522}, CountryId{"RU"}}, // Q112005521
    {Coordinate{50.8824, 62.5998}, CountryId{"RU"}}, // Knyazhpogost railway station
    {Coordinate{51.2747, 62.7034}, CountryId{"RU"}}, // Q112005526
    {Coordinate{51.4837, 62.756}, CountryId{"RU"}}, // Q112005528
    {Coordinate{51.8784, 62.8624}, CountryId{"RU"}}, // Q112005530
    {Coordinate{52.2757, 63.0259}, CountryId{"RU"}}, // Q112005534
    {Coordinate{52.6888, 63.2131}, CountryId{"RU"}}, // Q112005536
    {Coordinate{52.8909, 63.2401}, CountryId{"RU"}}, // Q112005537
    {Coordinate{53.6077, 63.4288}, CountryId{"RU"}}, // Q112005541
    {Coordinate{51.8784, 62.8624}, CountryId{"RU"}}, // Q112005603
    {Coordinate{53.0712, 63.2742}, CountryId{"RU"}}, // Q112005605
    {Coordinate{63.6492, 67.2829}, CountryId{"RU"}}, // Q112008933
    {Coordinate{14.6225, 49.1409}, CountryId{"CZ"}}, // Dynín zastávka
    {Coordinate{95.1611, 27.7847}, CountryId{"IN"}}, // Jonekarang
    {Coordinate{53.9639, 63.5929}, CountryId{"RU"}}, // Q112066149
    {Coordinate{54.0636, 63.6365}, CountryId{"RU"}}, // Q112066150
    {Coordinate{54.1632, 63.6852}, CountryId{"RU"}}, // Q112066151
    {Coordinate{54.1925, 63.7216}, CountryId{"RU"}}, // Q112066152
    {Coordinate{54.4434, 63.9224}, CountryId{"RU"}}, // Q112066154
    {Coordinate{54.7012, 64.0808}, CountryId{"RU"}}, // Q112066155
    {Coordinate{54.836, 64.1796}, CountryId{"RU"}}, // Q112066156
    {Coordinate{54.9894, 64.25}, CountryId{"RU"}}, // Q112066157
    {Coordinate{55.1979, 64.4055}, CountryId{"RU"}}, // Q112066158
    {Coordinate{55.3148, 64.4828}, CountryId{"RU"}}, // Q112066159
    {Coordinate{55.4777, 64.5538}, CountryId{"RU"}}, // Q112066160
    {Coordinate{55.6922, 64.6179}, CountryId{"RU"}}, // Q112066161
    {Coordinate{55.875, 64.6836}, CountryId{"RU"}}, // Q112066162
    {Coordinate{55.9176, 64.6967}, CountryId{"RU"}}, // Q112066163
    {Coordinate{56.0585, 64.7528}, CountryId{"RU"}}, // Q112066164
    {Coordinate{56.2435, 64.8349}, CountryId{"RU"}}, // Q112066165
    {Coordinate{56.4287, 64.8987}, CountryId{"RU"}}, // Q112066166
    {Coordinate{56.6319, 64.9678}, CountryId{"RU"}}, // Q112066167
    {Coordinate{56.7579, 65.025}, CountryId{"RU"}}, // Q112066168
    {Coordinate{56.912, 65.0733}, CountryId{"RU"}}, // Q112066169
    {Coordinate{56.9946, 65.1061}, CountryId{"RU"}}, // Q112066170
    {Coordinate{57.044, 65.1223}, CountryId{"RU"}}, // Q112066171
    {Coordinate{57.0867, 65.129}, CountryId{"RU"}}, // Q112066172
    {Coordinate{57.1623, 65.1387}, CountryId{"RU"}}, // Q112066173
    {Coordinate{57.2127, 65.1497}, CountryId{"RU"}}, // Q112066174
    {Coordinate{57.6359, 65.2717}, CountryId{"RU"}}, // Q112066175
    {Coordinate{58.0346, 65.3725}, CountryId{"RU"}}, // Q112066176
    {Coordinate{58.1893, 65.4241}, CountryId{"RU"}}, // Q112066177
    {Coordinate{58.3862, 65.4895}, CountryId{"RU"}}, // Q112066178
    {Coordinate{58.5312, 65.5377}, CountryId{"RU"}}, // Q112066179
    {Coordinate{58.596, 65.5511}, CountryId{"RU"}}, // Q112066180
    {Coordinate{58.7732, 65.5728}, CountryId{"RU"}}, // Q112066181
    {Coordinate{58.964, 65.6143}, CountryId{"RU"}}, // Q112066182
    {Coordinate{59.0564, 65.6268}, CountryId{"RU"}}, // Q112066183
    {Coordinate{59.1593, 65.6403}, CountryId{"RU"}}, // Q112066184
    {Coordinate{59.424, 65.7001}, CountryId{"RU"}}, // Q112066185
    {Coordinate{59.548, 65.7337}, CountryId{"RU"}}, // Q112066186
    {Coordinate{59.6549, 65.7487}, CountryId{"RU"}}, // Q112066187
    {Coordinate{59.8691, 65.8224}, CountryId{"RU"}}, // Q112066188
    {Coordinate{60.1017, 65.9029}, CountryId{"RU"}}, // Q112066189
    {Coordinate{60.3244, 65.9925}, CountryId{"RU"}}, // Q112066190
    {Coordinate{60.3922, 66.0337}, CountryId{"RU"}}, // Q112066191
    {Coordinate{60.4717, 66.0723}, CountryId{"RU"}}, // Q112066192
    {Coordinate{60.5776, 66.128}, CountryId{"RU"}}, // Q112066193
    {Coordinate{60.6612, 66.1404}, CountryId{"RU"}}, // Q112066194
    {Coordinate{60.7838, 66.1824}, CountryId{"RU"}}, // Kochmes
    {Coordinate{60.893, 66.2273}, CountryId{"RU"}}, // Q112066196
    {Coordinate{61.068, 66.2764}, CountryId{"RU"}}, // Q112066197
    {Coordinate{61.2121, 66.3297}, CountryId{"RU"}}, // Q112066198
    {Coordinate{61.4136, 66.4102}, CountryId{"RU"}}, // Q112066199
    {Coordinate{61.6687, 66.5162}, CountryId{"RU"}}, // Q112066200
    {Coordinate{61.7504, 66.5284}, CountryId{"RU"}}, // Q112066201
    {Coordinate{61.9017, 66.538}, CountryId{"RU"}}, // Q112066202
    {Coordinate{62.4046, 66.6158}, CountryId{"RU"}}, // Q112066203
    {Coordinate{62.5675, 66.6748}, CountryId{"RU"}}, // Q112066204
    {Coordinate{62.7004, 66.739}, CountryId{"RU"}}, // Q112066205
    {Coordinate{62.8291, 66.8177}, CountryId{"RU"}}, // Q112066207
    {Coordinate{62.8647, 66.8993}, CountryId{"RU"}}, // Q112066208
    {Coordinate{63.3919, 67.136}, CountryId{"RU"}}, // Q112066209
    {Coordinate{63.5819, 67.2089}, CountryId{"RU"}}, // Q112066210
    {Coordinate{63.9199, 67.3729}, CountryId{"RU"}}, // Q112066211
    {Coordinate{58.0636, 65.8156}, CountryId{"RU"}}, // Q112066445
    {Coordinate{57.5474, 66.0244}, CountryId{"RU"}}, // Q112066447
    {Coordinate{73.5899, 21.9694}, CountryId{"IN"}}, // Tilakwada Railway Station
    {Coordinate{48.667, 63.4446}, CountryId{"RU"}}, // Koslan railway station
    {Coordinate{50.0725, 62.3736}, CountryId{"RU"}}, // Q112085959
    {Coordinate{49.737, 62.5559}, CountryId{"RU"}}, // Q112085960
    {Coordinate{49.5556, 62.7049}, CountryId{"RU"}}, // Q112085961
    {Coordinate{49.3031, 62.8453}, CountryId{"RU"}}, // Q112085962
    {Coordinate{49.1793, 62.9345}, CountryId{"RU"}}, // Q112085963
    {Coordinate{48.8633, 63.0586}, CountryId{"RU"}}, // Q112085965
    {Coordinate{48.5775, 63.2363}, CountryId{"RU"}}, // Q112085966
    {Coordinate{48.5296, 63.3025}, CountryId{"RU"}}, // Q112085967
    {Coordinate{50.2236, 62.2911}, CountryId{"RU"}}, // Q112091353
    {Coordinate{50.4013, 62.2273}, CountryId{"RU"}}, // Q112091354
    {Coordinate{50.4331, 62.2076}, CountryId{"RU"}}, // Q112091356
    {Coordinate{50.5109, 62.1459}, CountryId{"RU"}}, // Q112091358
    {Coordinate{50.5746, 62.061}, CountryId{"RU"}}, // Q112091360
    {Coordinate{50.602, 62.0061}, CountryId{"RU"}}, // Q112091362
    {Coordinate{50.6159, 61.9559}, CountryId{"RU"}}, // Q112091364
    {Coordinate{50.6823, 61.8489}, CountryId{"RU"}}, // Q112091366
    {Coordinate{50.7324, 61.8014}, CountryId{"RU"}}, // Ezhva railway station
    {Coordinate{50.7747, 61.7302}, CountryId{"RU"}}, // Chovyu railway station
    {Coordinate{40.3097, 62.897}, CountryId{"RU"}}, // Q112095373
    {Coordinate{40.3353, 63.0738}, CountryId{"RU"}}, // Yomtsa railway station
    {Coordinate{40.2838, 61.0161}, CountryId{"RU"}}, // Q112106642
    {Coordinate{40.2995, 61.0619}, CountryId{"RU"}}, // Q112106643
    {Coordinate{40.3091, 61.1512}, CountryId{"RU"}}, // Q112106644
    {Coordinate{40.298, 61.2367}, CountryId{"RU"}}, // Q112106645
    {Coordinate{40.2483, 61.4}, CountryId{"RU"}}, // Q112106647
    {Coordinate{40.2331, 61.4388}, CountryId{"RU"}}, // Q112106648
    {Coordinate{40.1811, 61.4893}, CountryId{"RU"}}, // Q112106649
    {Coordinate{40.2159, 61.5083}, CountryId{"RU"}}, // Q112106650
    {Coordinate{40.1999, 61.5779}, CountryId{"RU"}}, // Q112106651
    {Coordinate{40.2005, 61.6287}, CountryId{"RU"}}, // Q112106653
    {Coordinate{40.2043, 61.7241}, CountryId{"RU"}}, // Q112106655
    {Coordinate{40.1835, 61.7617}, CountryId{"RU"}}, // Q112106656
    {Coordinate{40.2098, 61.8064}, CountryId{"RU"}}, // Q112106657
    {Coordinate{40.228, 61.8286}, CountryId{"RU"}}, // Q112106659
    {Coordinate{40.2404, 61.8715}, CountryId{"RU"}}, // Q112106660
    {Coordinate{40.2638, 62.0064}, CountryId{"RU"}}, // Q112106661
    {Coordinate{40.2439, 62.0423}, CountryId{"RU"}}, // Lelma railway station
    {Coordinate{40.212, 62.0711}, CountryId{"RU"}}, // Q112106663
    {Coordinate{40.1985, 62.12}, CountryId{"RU"}}, // Q112106664
    {Coordinate{40.2228, 62.159}, CountryId{"RU"}}, // Q112106665
    {Coordinate{40.2636, 62.2246}, CountryId{"RU"}}, // Q112106666
    {Coordinate{40.3142, 62.3057}, CountryId{"RU"}}, // Q112106667
    {Coordinate{40.3282, 62.328}, CountryId{"RU"}}, // Lepsha railway station
    {Coordinate{40.352, 62.3659}, CountryId{"RU"}}, // Q112106669
    {Coordinate{40.3823, 62.4139}, CountryId{"RU"}}, // Q112106670
    {Coordinate{40.4323, 62.4973}, CountryId{"RU"}}, // Q112106671
    {Coordinate{40.3849, 62.5602}, CountryId{"RU"}}, // Q112106672
    {Coordinate{40.3033, 62.8023}, CountryId{"RU"}}, // Q112106673
    {Coordinate{40.3156, 62.9566}, CountryId{"RU"}}, // Q112106674
    {Coordinate{40.3265, 62.9882}, CountryId{"RU"}}, // Q112106675
    {Coordinate{40.3519, 63.1773}, CountryId{"RU"}}, // Q112106676
    {Coordinate{40.3519, 63.1773}, CountryId{"RU"}}, // Q112106677
    {Coordinate{40.3401, 63.3729}, CountryId{"RU"}}, // Q112106679
    {Coordinate{40.2796, 61.2855}, CountryId{"RU"}}, // Q112106698
    {Coordinate{40.357, 63.3314}, CountryId{"RU"}}, // Q112106699
    {Coordinate{56.0462, 62.7491}, CountryId{"RU"}}, // Q112106916
    {Coordinate{53.9685, 63.5566}, CountryId{"RU"}}, // Q112106939
    {Coordinate{54.4759, 63.2052}, CountryId{"RU"}}, // Q112106940
    {Coordinate{54.7735, 63.0105}, CountryId{"RU"}}, // Q112106942
    {Coordinate{55.0497, 62.9074}, CountryId{"RU"}}, // Q112106943
    {Coordinate{9.21381, 48.1389}, CountryId{"DE"}}, // Jungnau station
    {Coordinate{9.19919, 48.1604}, CountryId{"DE"}}, // Veringendorf railway stop
    {Coordinate{9.21093, 48.1812}, CountryId{"DE"}}, // Veringenstat station
    {Coordinate{9.21737, 48.2009}, CountryId{"DE"}}, // Hermentingen railway stop
    {Coordinate{9.22949, 48.2172}, CountryId{"DE"}}, // Hettingen (Hohenz) station
    {Coordinate{9.21026, 48.2422}, CountryId{"DE"}}, // Gammertingen Europastrasse railway stop
    {Coordinate{9.0989, 48.2923}, CountryId{"DE"}}, // Burladingen-West railway stop
    {Coordinate{63.3604, 67.1079}, CountryId{"RU"}}, // Q112111680
    {Coordinate{63.7731, 67.054}, CountryId{"RU"}}, // Q112111681
    {Coordinate{64.2187, 67.0432}, CountryId{"RU"}}, // Q112111683
    {Coordinate{64.6474, 67.059}, CountryId{"RU"}}, // Q112111684
    {Coordinate{64.6474, 67.059}, CountryId{"RU"}}, // Q112111685
    {Coordinate{65.5106, 67.0559}, CountryId{"RU"}}, // Q112111686
    {Coordinate{65.6936, 66.9967}, CountryId{"RU"}}, // Q112111687
    {Coordinate{65.6909, 66.956}, CountryId{"RU"}}, // Q112111688
    {Coordinate{65.7419, 66.9061}, CountryId{"RU"}}, // Q112111689
    {Coordinate{65.8127, 66.8099}, CountryId{"RU"}}, // Q112111690
    {Coordinate{66.0198, 66.7627}, CountryId{"RU"}}, // Q112111691
    {Coordinate{66.1748, 66.7118}, CountryId{"RU"}}, // Q112111692
    {Coordinate{64.4117, 67.0167}, CountryId{"RU"}}, // Q112111711
    {Coordinate{40.6948, 64.5223}, CountryId{"RU"}}, // Q112112816
    {Coordinate{40.7088, 64.5096}, CountryId{"RU"}}, // Q112112817
    {Coordinate{40.8169, 64.4857}, CountryId{"RU"}}, // Q112112818
    {Coordinate{40.8969, 64.4786}, CountryId{"RU"}}, // Q112112819
    {Coordinate{40.929, 64.4798}, CountryId{"RU"}}, // Q112112820
    {Coordinate{41.1444, 64.4628}, CountryId{"RU"}}, // Q112112822
    {Coordinate{41.2262, 64.4434}, CountryId{"RU"}}, // Q112112823
    {Coordinate{41.4301, 64.3971}, CountryId{"RU"}}, // Q112112824
    {Coordinate{41.5446, 64.3788}, CountryId{"RU"}}, // Q112112825
    {Coordinate{41.8155, 64.3316}, CountryId{"RU"}}, // Q112112826
    {Coordinate{41.9219, 64.3032}, CountryId{"RU"}}, // Q112112827
    {Coordinate{42.2603, 64.1833}, CountryId{"RU"}}, // Q112112828
    {Coordinate{42.3198, 64.1572}, CountryId{"RU"}}, // Q112112829
    {Coordinate{42.6735, 64.0554}, CountryId{"RU"}}, // Q112112830
    {Coordinate{43.158, 64.0354}, CountryId{"RU"}}, // Q112112831
    {Coordinate{44.0104, 64.0389}, CountryId{"RU"}}, // Q112112832
    {Coordinate{44.0895, 64.0412}, CountryId{"RU"}}, // Q112112833
    {Coordinate{41.048, 64.4779}, CountryId{"RU"}}, // Q112112837
    {Coordinate{85.4886, 56.2825}, CountryId{"RU"}}, // Q112113945
    {Coordinate{40.6106, 64.4416}, CountryId{"RU"}}, // Q112122289
    {Coordinate{40.6084, 64.4694}, CountryId{"RU"}}, // Q112122290
    {Coordinate{40.5959, 64.4927}, CountryId{"RU"}}, // Q112122291
    {Coordinate{40.5778, 64.505}, CountryId{"RU"}}, // Q112122292
    {Coordinate{40.5703, 64.533}, CountryId{"RU"}}, // Q112122293
    {Coordinate{40.3297, 63.5275}, CountryId{"RU"}}, // Q112122818
    {Coordinate{40.542, 63.671}, CountryId{"RU"}}, // Q112122820
    {Coordinate{40.6175, 63.7548}, CountryId{"RU"}}, // Q112122821
    {Coordinate{40.6484, 63.9016}, CountryId{"RU"}}, // Q112122823
    {Coordinate{40.6399, 63.9337}, CountryId{"RU"}}, // Q112122824
    {Coordinate{40.6556, 64.0126}, CountryId{"RU"}}, // Q112122826
    {Coordinate{40.6278, 64.0834}, CountryId{"RU"}}, // Q112122827
    {Coordinate{40.6514, 64.2882}, CountryId{"RU"}}, // Q112122829
    {Coordinate{40.6283, 64.3338}, CountryId{"RU"}}, // Q112122830
    {Coordinate{40.5965, 64.357}, CountryId{"RU"}}, // Q112122831
    {Coordinate{40.5999, 64.3805}, CountryId{"RU"}}, // Q112122832
    {Coordinate{40.604, 64.3908}, CountryId{"RU"}}, // Q112122833
    {Coordinate{40.628, 64.2498}, CountryId{"RU"}}, // Q112122837
    {Coordinate{40.0264, 63.5805}, CountryId{"RU"}}, // Q112135626
    {Coordinate{39.8189, 63.7056}, CountryId{"RU"}}, // Q112135685
    {Coordinate{9.06054, 48.3164}, CountryId{"DE"}}, // Killer railway stop
    {Coordinate{38.1272, 63.9216}, CountryId{"RU"}}, // Q112148494
    {Coordinate{9.28686, 45.6456}, CountryId{"IT"}}, // Macherio-Canonica railway halt
    {Coordinate{40.5381, 64.4156}, CountryId{"RU"}}, // Q112158133
    {Coordinate{40.4752, 64.409}, CountryId{"RU"}}, // Q112158134
    {Coordinate{40.2333, 64.4106}, CountryId{"RU"}}, // Q112158135
    {Coordinate{40.1673, 64.438}, CountryId{"RU"}}, // Q112158136
    {Coordinate{40.1421, 64.4444}, CountryId{"RU"}}, // Q112158137
    {Coordinate{40.0409, 64.4707}, CountryId{"RU"}}, // Q112158138
    {Coordinate{39.9904, 64.4972}, CountryId{"RU"}}, // Q112158140
    {Coordinate{40.0183, 64.4809}, CountryId{"RU"}}, // Q112158144
    {Coordinate{39.229, 64.6354}, CountryId{"RU"}}, // Q112163846
    {Coordinate{39.7775, 64.5427}, CountryId{"RU"}}, // Morskoy Prospekt railway station
    {Coordinate{39.7201, 64.5355}, CountryId{"RU"}}, // Q112163910
    {Coordinate{39.6991, 64.535}, CountryId{"RU"}}, // Q112163911
    {Coordinate{39.6444, 64.5334}, CountryId{"RU"}}, // Q112163912
    {Coordinate{39.5333, 64.5447}, CountryId{"RU"}}, // Q112163913
    {Coordinate{71.4314, 54.9202}, CountryId{"RU"}}, // Q112164520
    {Coordinate{71.5364, 54.9237}, CountryId{"RU"}}, // Q112164522
    {Coordinate{71.6083, 54.926}, CountryId{"RU"}}, // Q112164523
    {Coordinate{71.8353, 54.933}, CountryId{"RU"}}, // Q112164524
    {Coordinate{72.1236, 54.9431}, CountryId{"RU"}}, // Q112164526
    {Coordinate{72.3072, 54.9492}, CountryId{"RU"}}, // Q112164527
    {Coordinate{72.4392, 54.9534}, CountryId{"RU"}}, // Q112164528
    {Coordinate{72.4629, 54.9541}, CountryId{"RU"}}, // Q112164529
    {Coordinate{72.6398, 54.9577}, CountryId{"RU"}}, // Q112164530
    {Coordinate{72.7645, 54.96}, CountryId{"RU"}}, // Q112164531
    {Coordinate{72.8653, 54.9617}, CountryId{"RU"}}, // Q112164532
    {Coordinate{73.0425, 54.9533}, CountryId{"RU"}}, // Q112164533
    {Coordinate{73.1352, 54.9484}, CountryId{"RU"}}, // Q112164534
    {Coordinate{73.1701, 54.9464}, CountryId{"RU"}}, // Q112164535
    {Coordinate{73.189, 54.9454}, CountryId{"RU"}}, // Q112164536
    {Coordinate{73.233, 54.9429}, CountryId{"RU"}}, // Q112164538
    {Coordinate{73.2638, 54.9412}, CountryId{"RU"}}, // Q112164539
    {Coordinate{73.2829, 54.943}, CountryId{"RU"}}, // Q112164540
    {Coordinate{73.3706, 54.9282}, CountryId{"RU"}}, // Trud
    {Coordinate{73.4108, 54.9435}, CountryId{"RU"}}, // Q112166682
    {Coordinate{73.4228, 54.9329}, CountryId{"RU"}}, // Q112166683
    {Coordinate{73.4465, 54.9264}, CountryId{"RU"}}, // Q112166684
    {Coordinate{73.4647, 54.929}, CountryId{"RU"}}, // Depovskaya railway station
    {Coordinate{71.5272, 55.5086}, CountryId{"RU"}}, // Q112187971
    {Coordinate{71.693, 55.4542}, CountryId{"RU"}}, // Q112187974
    {Coordinate{71.8021, 55.4232}, CountryId{"RU"}}, // Q112187976
    {Coordinate{71.8857, 55.3957}, CountryId{"RU"}}, // Q112187978
    {Coordinate{72.0571, 55.3486}, CountryId{"RU"}}, // Q112187980
    {Coordinate{72.2172, 55.3043}, CountryId{"RU"}}, // Q112187982
    {Coordinate{72.3581, 55.2592}, CountryId{"RU"}}, // Q112187985
    {Coordinate{72.4302, 55.2355}, CountryId{"RU"}}, // Q112187988
    {Coordinate{72.5247, 55.2042}, CountryId{"RU"}}, // Q112187990
    {Coordinate{72.6903, 55.1529}, CountryId{"RU"}}, // Q112187992
    {Coordinate{72.8376, 55.1074}, CountryId{"RU"}}, // Q112187995
    {Coordinate{72.8728, 55.0941}, CountryId{"RU"}}, // Q112187997
    {Coordinate{72.9454, 55.0663}, CountryId{"RU"}}, // Q112188000
    {Coordinate{72.9748, 55.0551}, CountryId{"RU"}}, // Q112188002
    {Coordinate{73.0143, 55.04}, CountryId{"RU"}}, // Q112188004
    {Coordinate{73.0454, 55.0286}, CountryId{"RU"}}, // Q112188006
    {Coordinate{73.1726, 54.9836}, CountryId{"RU"}}, // Q112188008
    {Coordinate{8.81246, 50.3049}, CountryId{"DE"}}, // Assenheim station
    {Coordinate{74.9043, 53.9119}, CountryId{"RU"}}, // Q112211033
    {Coordinate{73.3392, 54.7841}, CountryId{"RU"}}, // Q112218355
    {Coordinate{73.3759, 54.7617}, CountryId{"RU"}}, // Q112218357
    {Coordinate{73.4001, 54.7469}, CountryId{"RU"}}, // Q112218358
    {Coordinate{73.4653, 54.7067}, CountryId{"RU"}}, // Q112218361
    {Coordinate{73.4871, 54.6933}, CountryId{"RU"}}, // Q112218363
    {Coordinate{73.5109, 54.6786}, CountryId{"RU"}}, // Q112218366
    {Coordinate{73.6555, 54.5933}, CountryId{"RU"}}, // Q112218368
    {Coordinate{73.8962, 54.4619}, CountryId{"RU"}}, // Q112218370
    {Coordinate{74.2675, 54.2568}, CountryId{"RU"}}, // Q112218373
    {Coordinate{74.5759, 54.0844}, CountryId{"RU"}}, // Q112218375
    {Coordinate{74.618, 54.0608}, CountryId{"RU"}}, // Q112218376
    {Coordinate{74.6806, 54.0229}, CountryId{"RU"}}, // Q112218377
    {Coordinate{10.4728, 45.1072}, CountryId{"IT"}}, // Bozzolo railway station
    {Coordinate{9.32473, 48.8593}, CountryId{"DE"}}, // Neustadt-Hohenacker
    {Coordinate{9.24847, 48.8152}, CountryId{"DE"}}, // Stuttgart-Sommerrain
    {Coordinate{9.327, 48.73}, CountryId{"DE"}}, // Oberesslingen
    {Coordinate{9.35969, 48.7244}, CountryId{"DE"}}, // Esslingen-Zell
    {Coordinate{9.43956, 48.8053}, CountryId{"DE"}}, // Geradstetten station
    {Coordinate{2.6582, 45.2812}, CountryId{"FR"}}, // Gare de Riom-ès-Montagnes
    {Coordinate{10.9676, 49.4824}, CountryId{"DE"}}, // Fürth-Klinikum
    {Coordinate{11.7691, 47.9691}, CountryId{"DE"}}, // Aying station
    {Coordinate{11.6987, 48.0467}, CountryId{"DE"}}, // Hohenbrunn station
    {Coordinate{16.8671, 48.7379}, CountryId{"CZ"}}, // station Boří les
    {Coordinate{28.9477, 60.8604}, CountryId{"RU"}}, // Vozrozhdeniye
    {Coordinate{26.7658, 57.1828}, CountryId{"LV"}}, // Gulbene
    {Coordinate{29.0759, 60.9604}, CountryId{"RU"}}, // 38 km
    {Coordinate{29.0045, 60.938}, CountryId{"RU"}}, // Nikiforovskoye
    {Coordinate{28.9501, 60.8344}, CountryId{"RU"}}, // 21 km
    {Coordinate{28.9525, 60.8045}, CountryId{"RU"}}, // Pionerlager
    {Coordinate{28.8836, 60.7635}, CountryId{"RU"}}, // Paltsevo
    {Coordinate{15.8097, 50.2147}, CountryId{"CZ"}}, // Hradec Králové hlavní nádraží
    {Coordinate{12.2631, 51.5706}, CountryId{"DE"}}, // Roitzsch (Kr Bitterfeld)
    {Coordinate{8.35574, 48.623}, CountryId{"DE"}}, // Kirschbaumwasen railway station
    {Coordinate{8.41822, 49.0088}, CountryId{"DE"}}, // Durlacher Tor/KIT-Campus Süd
    {Coordinate{8.4352, 48.4645}, CountryId{"DE"}}, // Freudenstadt Industriegebiet
    {Coordinate{74.1597, 55.0037}, CountryId{"RU"}}, // Q112624419
    {Coordinate{74.2286, 55.0106}, CountryId{"RU"}}, // Q112624420
    {Coordinate{74.2877, 55.0164}, CountryId{"RU"}}, // Q112624421
    {Coordinate{74.3609, 55.0236}, CountryId{"RU"}}, // Q112624422
    {Coordinate{74.4722, 55.0344}, CountryId{"RU"}}, // Q112624423
    {Coordinate{74.6979, 55.0576}, CountryId{"RU"}}, // Q112624424
    {Coordinate{74.8078, 55.072}, CountryId{"RU"}}, // Q112624425
    {Coordinate{74.9153, 55.086}, CountryId{"RU"}}, // Q112624426
    {Coordinate{75.0062, 55.0977}, CountryId{"RU"}}, // Q112624427
    {Coordinate{75.1321, 55.1138}, CountryId{"RU"}}, // Q112624428
    {Coordinate{75.399, 55.1472}, CountryId{"RU"}}, // Q112624429
    {Coordinate{75.4994, 55.1596}, CountryId{"RU"}}, // Q112624430
    {Coordinate{75.6047, 55.1724}, CountryId{"RU"}}, // Q112624431
    {Coordinate{75.7044, 55.1844}, CountryId{"RU"}}, // Q112624432
    {Coordinate{75.9141, 55.2094}, CountryId{"RU"}}, // Q112624433
    {Coordinate{8.42124, 48.4674}, CountryId{"DE"}}, // Freudenstadt Schulzentrum
    {Coordinate{75.9964, 55.219}, CountryId{"RU"}}, // Q112632104
    {Coordinate{76.1774, 55.2398}, CountryId{"RU"}}, // Q112632105
    {Coordinate{76.2093, 55.2434}, CountryId{"RU"}}, // Q112632107
    {Coordinate{76.6714, 55.2947}, CountryId{"RU"}}, // Q112632108
    {Coordinate{77.0867, 55.3603}, CountryId{"RU"}}, // Q112632109
    {Coordinate{77.1581, 55.3632}, CountryId{"RU"}}, // Q112632110
    {Coordinate{77.3987, 55.358}, CountryId{"RU"}}, // Q112632111
    {Coordinate{77.4749, 55.3572}, CountryId{"RU"}}, // Q112632112
    {Coordinate{77.9567, 55.3414}, CountryId{"RU"}}, // Q112632113
    {Coordinate{78.1227, 55.3331}, CountryId{"RU"}}, // Q112632114
    {Coordinate{78.1714, 55.3389}, CountryId{"RU"}}, // Q112632115
    {Coordinate{78.4654, 55.3572}, CountryId{"RU"}}, // Q112632116
    {Coordinate{78.53, 55.3583}, CountryId{"RU"}}, // Q112632117
    {Coordinate{78.7515, 55.3424}, CountryId{"RU"}}, // Q112632118
    {Coordinate{79.0298, 55.3393}, CountryId{"RU"}}, // Q112632119
    {Coordinate{79.3396, 55.3245}, CountryId{"RU"}}, // Q112632120
    {Coordinate{79.6255, 55.3082}, CountryId{"RU"}}, // Q112632121
    {Coordinate{79.6632, 55.3034}, CountryId{"RU"}}, // Q112632122
    {Coordinate{79.7491, 55.2904}, CountryId{"RU"}}, // Q112632123
    {Coordinate{79.8369, 55.2806}, CountryId{"RU"}}, // Q112632124
    {Coordinate{80.0046, 55.2521}, CountryId{"RU"}}, // Q112632125
    {Coordinate{80.0507, 55.2429}, CountryId{"RU"}}, // Q112632126
    {Coordinate{80.1328, 55.2265}, CountryId{"RU"}}, // Q112632127
    {Coordinate{80.4551, 55.1623}, CountryId{"RU"}}, // Q112632128
    {Coordinate{80.631, 55.1477}, CountryId{"RU"}}, // Q112632129
    {Coordinate{80.8231, 55.1153}, CountryId{"RU"}}, // Q112632130
    {Coordinate{81.3004, 55.0966}, CountryId{"RU"}}, // Q112632131
    {Coordinate{81.4365, 55.0868}, CountryId{"RU"}}, // Q112632132
    {Coordinate{81.547, 55.0806}, CountryId{"RU"}}, // Q112632133
    {Coordinate{81.6178, 55.0831}, CountryId{"RU"}}, // Q112632135
    {Coordinate{81.7818, 55.0651}, CountryId{"RU"}}, // Q112632136
    {Coordinate{81.8826, 55.0525}, CountryId{"RU"}}, // Q112632137
    {Coordinate{81.9364, 55.0456}, CountryId{"RU"}}, // Q112632138
    {Coordinate{82.0062, 55.0367}, CountryId{"RU"}}, // Q112632139
    {Coordinate{82.0732, 55.0281}, CountryId{"RU"}}, // Q112632140
    {Coordinate{82.2081, 55.0119}, CountryId{"RU"}}, // Q112632141
    {Coordinate{82.2744, 55.0046}, CountryId{"RU"}}, // Q112632142
    {Coordinate{82.316, 55.0034}, CountryId{"RU"}}, // Q112632143
    {Coordinate{82.3869, 55.0012}, CountryId{"RU"}}, // Q112632144
    {Coordinate{82.4434, 55.001}, CountryId{"RU"}}, // Q112632145
    {Coordinate{82.5371, 54.9982}, CountryId{"RU"}}, // Q112632146
    {Coordinate{82.6024, 54.9962}, CountryId{"RU"}}, // Q112632147
    {Coordinate{82.6299, 54.9955}, CountryId{"RU"}}, // Q112632148
    {Coordinate{82.6827, 54.9939}, CountryId{"RU"}}, // Aeroflot railway station
    {Coordinate{77.9547, 53.7783}, CountryId{"RU"}}, // Q112634475
    {Coordinate{75.0034, 53.8963}, CountryId{"RU"}}, // Q112635506
    {Coordinate{75.3328, 53.8572}, CountryId{"KZ"}}, // Q112635507
    {Coordinate{75.5884, 53.8331}, CountryId{"KZ"}}, // Q112635508
    {Coordinate{75.5884, 53.8331}, CountryId{"KZ"}}, // Q112635509
    {Coordinate{76.1093, 53.8016}, CountryId{"KZ"}}, // Q112635510
    {Coordinate{76.3756, 53.7842}, CountryId{"KZ"}}, // Q112635511
    {Coordinate{76.6218, 53.759}, CountryId{"KZ"}}, // Q112635512
    {Coordinate{76.9127, 53.7486}, CountryId{"KZ"}}, // Q112635513
    {Coordinate{77.1787, 53.7683}, CountryId{"RU"}}, // Q112635514
    {Coordinate{77.4282, 53.7814}, CountryId{"RU"}}, // Q112635515
    {Coordinate{77.7061, 53.7885}, CountryId{"RU"}}, // Q112635516
    {Coordinate{83.6406, 53.7407}, CountryId{"RU"}}, // Q112635972
    {Coordinate{78.2143, 53.7593}, CountryId{"RU"}}, // Q112657128
    {Coordinate{78.2857, 53.7577}, CountryId{"RU"}}, // Q112657129
    {Coordinate{78.3503, 53.7375}, CountryId{"RU"}}, // Q112657130
    {Coordinate{78.4968, 53.7251}, CountryId{"RU"}}, // Q112657131
    {Coordinate{78.6269, 53.7274}, CountryId{"RU"}}, // Q112657132
    {Coordinate{78.8307, 53.7305}, CountryId{"RU"}}, // Q112657133
    {Coordinate{78.9491, 53.7321}, CountryId{"RU"}}, // Q112657134
    {Coordinate{79.2415, 53.7355}, CountryId{"RU"}}, // Q112657135
    {Coordinate{79.4701, 53.7512}, CountryId{"RU"}}, // Q112657136
    {Coordinate{79.6638, 53.7628}, CountryId{"RU"}}, // Q112657137
    {Coordinate{79.8591, 53.7628}, CountryId{"RU"}}, // Q112657139
    {Coordinate{80.122, 53.7564}, CountryId{"RU"}}, // Q112657140
    {Coordinate{80.2603, 53.7565}, CountryId{"RU"}}, // Q112657142
    {Coordinate{80.6489, 53.7257}, CountryId{"RU"}}, // Q112657143
    {Coordinate{81.0325, 53.7138}, CountryId{"RU"}}, // Q112657144
    {Coordinate{81.5332, 53.8025}, CountryId{"RU"}}, // Q112657145
    {Coordinate{81.6146, 53.8023}, CountryId{"RU"}}, // Q112657146
    {Coordinate{81.813, 53.8179}, CountryId{"RU"}}, // Q112657147
    {Coordinate{82.0791, 53.8114}, CountryId{"RU"}}, // Q112657148
    {Coordinate{82.3084, 53.8084}, CountryId{"RU"}}, // Q112657149
    {Coordinate{82.551, 53.8236}, CountryId{"RU"}}, // Q112657150
    {Coordinate{82.551, 53.8236}, CountryId{"RU"}}, // Q112657151
    {Coordinate{83.0559, 53.7786}, CountryId{"RU"}}, // Q112657152
    {Coordinate{83.2542, 53.7784}, CountryId{"RU"}}, // Q112657153
    {Coordinate{83.4086, 53.7716}, CountryId{"RU"}}, // Q112657154
    {Coordinate{83.4456, 53.7678}, CountryId{"RU"}}, // Q112657155
    {Coordinate{83.4828, 53.7655}, CountryId{"RU"}}, // Q112657156
    {Coordinate{83.6824, 53.6959}, CountryId{"RU"}}, // Q112657624
    {Coordinate{83.6915, 53.6697}, CountryId{"RU"}}, // Q112657627
    {Coordinate{83.723, 53.6295}, CountryId{"RU"}}, // Q112657628
    {Coordinate{83.7619, 53.5775}, CountryId{"RU"}}, // Q112657629
    {Coordinate{83.772, 53.5657}, CountryId{"RU"}}, // Q112657630
    {Coordinate{83.7954, 53.5526}, CountryId{"RU"}}, // Q112657631
    {Coordinate{83.8518, 53.5336}, CountryId{"RU"}}, // Q112657632
    {Coordinate{83.8713, 53.5149}, CountryId{"RU"}}, // Q112657633
    {Coordinate{83.8958, 53.4944}, CountryId{"RU"}}, // Q112657634
    {Coordinate{83.9134, 53.482}, CountryId{"RU"}}, // Q112657635
    {Coordinate{83.9283, 53.4555}, CountryId{"RU"}}, // Q112657636
    {Coordinate{83.9231, 53.4434}, CountryId{"RU"}}, // Q112657637
    {Coordinate{83.9213, 53.4235}, CountryId{"RU"}}, // Q112657638
    {Coordinate{83.9247, 53.4066}, CountryId{"RU"}}, // Q112657639
    {Coordinate{83.7953, 53.5503}, CountryId{"RU"}}, // Q112657640
    {Coordinate{83.8271, 53.5276}, CountryId{"RU"}}, // Q112657641
    {Coordinate{83.8437, 53.5074}, CountryId{"RU"}}, // Q112657642
    {Coordinate{83.8768, 53.4699}, CountryId{"RU"}}, // Q112657643
    {Coordinate{83.8912, 53.4536}, CountryId{"RU"}}, // Q112657644
    {Coordinate{83.8992, 53.4444}, CountryId{"RU"}}, // Q112657645
    {Coordinate{83.9134, 53.4208}, CountryId{"RU"}}, // Q112657646
    {Coordinate{76.0036, 55.2085}, CountryId{"RU"}}, // Q112663747
    {Coordinate{76.1658, 55.0692}, CountryId{"RU"}}, // Q112663748
    {Coordinate{76.4388, 54.8194}, CountryId{"RU"}}, // Q112663749
    {Coordinate{76.8526, 54.531}, CountryId{"RU"}}, // Q112663750
    {Coordinate{77.2775, 54.3576}, CountryId{"RU"}}, // Q112663751
    {Coordinate{77.3724, 54.2814}, CountryId{"RU"}}, // Q112663752
    {Coordinate{77.6547, 54.0956}, CountryId{"RU"}}, // Q112663753
    {Coordinate{77.8966, 53.903}, CountryId{"RU"}}, // Q112663754
    {Coordinate{78.0367, 53.7305}, CountryId{"RU"}}, // Q112663887
    {Coordinate{78.1432, 53.5153}, CountryId{"RU"}}, // Q112663888
    {Coordinate{78.3293, 53.3324}, CountryId{"RU"}}, // Q112663889
    {Coordinate{78.5148, 53.1294}, CountryId{"RU"}}, // Q112663890
    {Coordinate{78.6438, 52.9777}, CountryId{"RU"}}, // Q112663892
    {Coordinate{78.7844, 52.7694}, CountryId{"RU"}}, // Q112663893
    {Coordinate{77.6411, 12.9996}, CountryId{"IN"}}, // Sir M. Visvesvaraya Terminal
    {Coordinate{82.7999, 54.9931}, CountryId{"RU"}}, // Q112678985
    {Coordinate{82.8321, 54.9945}, CountryId{"RU"}}, // Q112678986
    {Coordinate{82.8846, 54.9977}, CountryId{"RU"}}, // Q112678987
    {Coordinate{82.9117, 55.0044}, CountryId{"RU"}}, // Q112678988
    {Coordinate{82.9218, 55.019}, CountryId{"RU"}}, // Q112678989
    {Coordinate{83.3213, 55.2097}, CountryId{"RU"}}, // Q112679037
    {Coordinate{82.9405, 55.0538}, CountryId{"RU"}}, // Q112679124
    {Coordinate{83.0042, 55.1105}, CountryId{"RU"}}, // Q112679125
    {Coordinate{83.0824, 55.142}, CountryId{"RU"}}, // Q112679126
    {Coordinate{83.1184, 55.1557}, CountryId{"RU"}}, // Q112679127
    {Coordinate{83.2125, 55.1755}, CountryId{"RU"}}, // Q112679132
    {Coordinate{11.8096, 43.6933}, CountryId{"IT"}}, // Bibbiena railway station
    {Coordinate{11.3059, 49.7755}, CountryId{"DE"}}, // Gößweinstein
    {Coordinate{83.3671, 55.2278}, CountryId{"RU"}}, // Q112776269
    {Coordinate{83.4273, 55.2384}, CountryId{"RU"}}, // Q112776271
    {Coordinate{83.4929, 55.2549}, CountryId{"RU"}}, // Q112776273
    {Coordinate{83.5445, 55.2778}, CountryId{"RU"}}, // Q112776275
    {Coordinate{83.6164, 55.3007}, CountryId{"RU"}}, // Moshkovo railway station
    {Coordinate{83.7209, 55.3565}, CountryId{"RU"}}, // Q112776278
    {Coordinate{83.7434, 55.3774}, CountryId{"RU"}}, // Q112776279
    {Coordinate{83.7676, 55.4121}, CountryId{"RU"}}, // Q112776280
    {Coordinate{83.7797, 55.4319}, CountryId{"RU"}}, // Q112776281
    {Coordinate{83.8199, 55.4621}, CountryId{"RU"}}, // Q112776283
    {Coordinate{83.919, 55.5044}, CountryId{"RU"}}, // Q112776284
    {Coordinate{84.0687, 55.5555}, CountryId{"RU"}}, // Chebula
    {Coordinate{84.2233, 55.617}, CountryId{"RU"}}, // Q112776286
    {Coordinate{84.5256, 55.6917}, CountryId{"RU"}}, // Q112776954
    {Coordinate{84.6532, 55.6984}, CountryId{"RU"}}, // Q112776956
    {Coordinate{84.7762, 55.704}, CountryId{"RU"}}, // Q112776958
    {Coordinate{84.8849, 55.735}, CountryId{"RU"}}, // Q112778594
    {Coordinate{84.9175, 55.756}, CountryId{"RU"}}, // Q112778596
    {Coordinate{84.9886, 55.7554}, CountryId{"RU"}}, // Q112778598
    {Coordinate{85.1148, 55.7896}, CountryId{"RU"}}, // Q112778600
    {Coordinate{85.1969, 55.8047}, CountryId{"RU"}}, // Q112778602
    {Coordinate{85.2836, 55.8209}, CountryId{"RU"}}, // Q112778604
    {Coordinate{85.352, 55.8401}, CountryId{"RU"}}, // Q112778606
    {Coordinate{85.4207, 55.8715}, CountryId{"RU"}}, // Q112778609
    {Coordinate{85.4437, 55.8897}, CountryId{"RU"}}, // Q112778611
    {Coordinate{85.4528, 55.9409}, CountryId{"RU"}}, // Q112778613
    {Coordinate{85.5417, 56.0118}, CountryId{"RU"}}, // Q112778616
    {Coordinate{85.5963, 56.0531}, CountryId{"RU"}}, // Q112778618
    {Coordinate{85.6606, 56.0624}, CountryId{"RU"}}, // Q112802710
    {Coordinate{85.7259, 56.0711}, CountryId{"RU"}}, // Q112802711
    {Coordinate{85.8473, 56.0478}, CountryId{"RU"}}, // Q112802713
    {Coordinate{85.9947, 56.0634}, CountryId{"RU"}}, // Q112802714
    {Coordinate{86.0893, 56.0917}, CountryId{"RU"}}, // Q112802716
    {Coordinate{86.1664, 56.1112}, CountryId{"RU"}}, // Q112802717
    {Coordinate{86.2722, 56.1727}, CountryId{"RU"}}, // Q112802718
    {Coordinate{86.4235, 56.2005}, CountryId{"RU"}}, // Q112802720
    {Coordinate{86.5235, 56.2083}, CountryId{"RU"}}, // Q112802721
    {Coordinate{86.6381, 56.1897}, CountryId{"RU"}}, // Q112802724
    {Coordinate{86.9053, 56.1568}, CountryId{"RU"}}, // Q112802725
    {Coordinate{87.0052, 56.1591}, CountryId{"RU"}}, // Q112802727
    {Coordinate{87.0794, 56.1589}, CountryId{"RU"}}, // Q112802728
    {Coordinate{87.2307, 56.171}, CountryId{"RU"}}, // Q112802730
    {Coordinate{87.3965, 56.1858}, CountryId{"RU"}}, // Q112802731
    {Coordinate{87.6275, 56.1893}, CountryId{"RU"}}, // Q112802734
    {Coordinate{-6.47718, 38.9154}, CountryId{"ES"}}, // Garrovilla-Las Vegas train station
    {Coordinate{}, CountryId{"IT"}}, // Gagliano railway station
    {Coordinate{16.5304, 38.9725}, CountryId{"IT"}}, // Gimigliano railway station
    {Coordinate{16.5049, 39.004}, CountryId{"IT"}}, // Cicala ralway halt
    {Coordinate{16.3054, 39.1492}, CountryId{"IT"}}, // Carpanzano railway station
    {Coordinate{16.3954, 39.1191}, CountryId{"IT"}}, // Colosimi railway station
    {Coordinate{16.3491, 39.0517}, CountryId{"IT"}}, // San Bernardo railway halt
    {Coordinate{16.36, 39.0401}, CountryId{"IT"}}, // Decollatura railway station
    {Coordinate{82.9207, 55.0188}, CountryId{"RU"}}, // Tsentr railway station
    {Coordinate{82.9396, 55.0096}, CountryId{"RU"}}, // Rechnoy Vokzal railway station, Novosibirsk
    {Coordinate{82.9795, 54.996}, CountryId{"RU"}}, // Q112845316
    {Coordinate{82.995, 54.9879}, CountryId{"RU"}}, // Q112845317
    {Coordinate{83.0381, 54.974}, CountryId{"RU"}}, // Q112845318
    {Coordinate{83.0694, 54.9737}, CountryId{"RU"}}, // Q112845319
    {Coordinate{83.0854, 54.9708}, CountryId{"RU"}}, // Q112845320
    {Coordinate{11.3975, 61.0131}, CountryId{"NO"}}, // Rudstad Station
    {Coordinate{83.1847, 54.9549}, CountryId{"RU"}}, // Q112861201
    {Coordinate{83.2071, 54.9743}, CountryId{"RU"}}, // Q112861203
    {Coordinate{83.2141, 54.9997}, CountryId{"RU"}}, // Q112861204
    {Coordinate{83.2401, 55.0287}, CountryId{"RU"}}, // Q112861205
    {Coordinate{83.2424, 55.0412}, CountryId{"RU"}}, // Q112861206
    {Coordinate{83.2355, 55.0713}, CountryId{"RU"}}, // Q112861207
    {Coordinate{83.239, 55.0835}, CountryId{"RU"}}, // Q112861209
    {Coordinate{83.2712, 55.1153}, CountryId{"RU"}}, // Q112861210
    {Coordinate{83.2596, 55.168}, CountryId{"RU"}}, // Q112861211
    {Coordinate{86.239, 54.5453}, CountryId{"RU"}}, // Q112861438
    {Coordinate{83.2229, 54.9681}, CountryId{"RU"}}, // Q112861965
    {Coordinate{83.2611, 54.9741}, CountryId{"RU"}}, // Q112861966
    {Coordinate{83.2822, 54.9823}, CountryId{"RU"}}, // Q112861967
    {Coordinate{83.332, 54.9847}, CountryId{"RU"}}, // Q112861968
    {Coordinate{83.3661, 54.9957}, CountryId{"RU"}}, // Q112861969
    {Coordinate{83.3901, 55.0108}, CountryId{"RU"}}, // Q112861971
    {Coordinate{83.4305, 55.0382}, CountryId{"RU"}}, // Q112861972
    {Coordinate{83.4645, 55.0605}, CountryId{"RU"}}, // Q112861973
    {Coordinate{83.5061, 55.0743}, CountryId{"RU"}}, // Q112861974
    {Coordinate{83.5293, 55.0948}, CountryId{"RU"}}, // Q112861975
    {Coordinate{83.5887, 55.1185}, CountryId{"RU"}}, // Q112861976
    {Coordinate{83.632, 55.1235}, CountryId{"RU"}}, // Q112861977
    {Coordinate{83.6845, 55.1415}, CountryId{"RU"}}, // Q112861978
    {Coordinate{83.7187, 55.1397}, CountryId{"RU"}}, // Q112861979
    {Coordinate{83.7631, 55.1477}, CountryId{"RU"}}, // Q112861980
    {Coordinate{83.803, 55.1509}, CountryId{"RU"}}, // Q112861981
    {Coordinate{83.8671, 55.1811}, CountryId{"RU"}}, // Q112861982
    {Coordinate{83.9816, 55.2115}, CountryId{"RU"}}, // Q112861985
    {Coordinate{84.0831, 55.2357}, CountryId{"RU"}}, // Q112861986
    {Coordinate{84.1192, 55.2462}, CountryId{"RU"}}, // Q112861987
    {Coordinate{84.198, 55.2434}, CountryId{"RU"}}, // Q112861988
    {Coordinate{84.198, 55.2434}, CountryId{"RU"}}, // Q112861989
    {Coordinate{84.4014, 55.2314}, CountryId{"RU"}}, // Toguchin railway station
    {Coordinate{84.4872, 55.1825}, CountryId{"RU"}}, // Q112861992
    {Coordinate{84.5589, 55.1637}, CountryId{"RU"}}, // Q112861993
    {Coordinate{84.6021, 55.1433}, CountryId{"RU"}}, // Q112861994
    {Coordinate{84.7239, 55.1107}, CountryId{"RU"}}, // Q112861995
    {Coordinate{84.7391, 55.0909}, CountryId{"RU"}}, // Q112861996
    {Coordinate{84.7784, 55.0567}, CountryId{"RU"}}, // Q112861997
    {Coordinate{85.6424, 54.9138}, CountryId{"RU"}}, // Promyshlennaya railway station
    {Coordinate{86.0792, 54.6866}, CountryId{"RU"}}, // Q112862000
    {Coordinate{83.0675, 54.949}, CountryId{"RU"}}, // Q112874067
    {Coordinate{83.074, 54.9396}, CountryId{"RU"}}, // Q112874068
    {Coordinate{83.0772, 54.9257}, CountryId{"RU"}}, // Q112874069
    {Coordinate{83.0752, 54.9136}, CountryId{"RU"}}, // Q112874070
    {Coordinate{83.0781, 54.8847}, CountryId{"RU"}}, // Q112874071
    {Coordinate{83.0789, 54.8339}, CountryId{"RU"}}, // Q112874072
    {Coordinate{83.0874, 54.8087}, CountryId{"RU"}}, // Q112874073
    {Coordinate{83.0825, 54.7872}, CountryId{"RU"}}, // Q112874074
    {Coordinate{83.1786, 54.7398}, CountryId{"RU"}}, // Q112874075
    {Coordinate{83.1999, 54.7161}, CountryId{"RU"}}, // Q112874076
    {Coordinate{83.2181, 54.6962}, CountryId{"RU"}}, // Q112874077
    {Coordinate{83.2397, 54.6764}, CountryId{"RU"}}, // Q112874078
    {Coordinate{83.2775, 54.6575}, CountryId{"RU"}}, // Q112874079
    {Coordinate{83.2947, 54.6426}, CountryId{"RU"}}, // Q112874080
    {Coordinate{83.2988, 54.6203}, CountryId{"RU"}}, // Q112874081
    {Coordinate{83.3094, 54.5916}, CountryId{"RU"}}, // Q112874082
    {Coordinate{83.3192, 54.5731}, CountryId{"RU"}}, // Q112874083
    {Coordinate{83.327, 54.5619}, CountryId{"RU"}}, // Q112874084
    {Coordinate{83.3311, 54.5464}, CountryId{"RU"}}, // Q112874085
    {Coordinate{83.3619, 54.4625}, CountryId{"RU"}}, // Q112874088
    {Coordinate{83.3528, 54.4391}, CountryId{"RU"}}, // Q112874090
    {Coordinate{83.3102, 54.362}, CountryId{"RU"}}, // Q112874091
    {Coordinate{83.3249, 54.2973}, CountryId{"RU"}}, // Q112874092
    {Coordinate{83.3779, 54.2296}, CountryId{"RU"}}, // Q112874093
    {Coordinate{83.485, 53.8679}, CountryId{"RU"}}, // Q112874095
    {Coordinate{83.5981, 53.7847}, CountryId{"RU"}}, // Q112874096
    {Coordinate{83.3505, 54.5104}, CountryId{"RU"}}, // Q112874110
    {Coordinate{83.4293, 54.011}, CountryId{"RU"}}, // Q112874111
    {Coordinate{11.6094, 48.0798}, CountryId{"DE"}}, // Haltepunkt Fasanenpark
    {Coordinate{11.8328, 48.0896}, CountryId{"DE"}}, // Q112878739
    {Coordinate{85.9881, 25.4622}, CountryId{"IN"}}, // New Barauni Junction
    {Coordinate{17.8056, 51.6492}, CountryId{"PL"}}, // Ostrów Wielkopolski
    {Coordinate{17.9081, 49.9344}, CountryId{"CZ"}}, // Opava východ
    {Coordinate{14.8654, 50.0766}, CountryId{"CZ"}}, // Český Brod train station
    {Coordinate{11.8492, 52.6166}, CountryId{"DE"}}, // Stendal Hochschule
    {Coordinate{116.075, 56.3229}, CountryId{"RU"}}, // Kuanda Station
    {Coordinate{12.955, 52.2038}, CountryId{"DE"}}, // Elsholz
    {Coordinate{12.9205, 52.1657}, CountryId{"DE"}}, // Buchholz (Zauche)
    {Coordinate{12.8808, 52.0807}, CountryId{"DE"}}, // Treuenbrietzen Süd
    {Coordinate{26.7529, 62.3094}, CountryId{"FI"}}, // Q112999599
    {Coordinate{84.0992, 53.3388}, CountryId{"RU"}}, // Q113053839
    {Coordinate{84.1259, 53.3248}, CountryId{"RU"}}, // Q113053842
    {Coordinate{84.2228, 53.3037}, CountryId{"RU"}}, // Q113053845
    {Coordinate{84.2477, 53.2979}, CountryId{"RU"}}, // Q113053848
    {Coordinate{84.2641, 53.2941}, CountryId{"RU"}}, // Q113053851
    {Coordinate{84.2958, 53.2866}, CountryId{"RU"}}, // Q113053854
    {Coordinate{84.3149, 53.2821}, CountryId{"RU"}}, // Q113053855
    {Coordinate{84.4015, 53.2618}, CountryId{"RU"}}, // Q113053857
    {Coordinate{84.4429, 53.2491}, CountryId{"RU"}}, // Q113053858
    {Coordinate{84.4963, 53.2274}, CountryId{"RU"}}, // Q113053859
    {Coordinate{84.6003, 53.1999}, CountryId{"RU"}}, // Ovchinnikovo railway station
    {Coordinate{84.6742, 53.1094}, CountryId{"RU"}}, // Q113053862
    {Coordinate{84.6661, 52.9821}, CountryId{"RU"}}, // Q113053865
    {Coordinate{84.6761, 52.8933}, CountryId{"RU"}}, // Q113053867
    {Coordinate{84.8146, 52.7964}, CountryId{"RU"}}, // Q113053868
    {Coordinate{84.9329, 52.6633}, CountryId{"RU"}}, // Q113053869
    {Coordinate{83.9204, 53.3752}, CountryId{"RU"}}, // Q113055614
    {Coordinate{83.8742, 53.3715}, CountryId{"RU"}}, // Q113055615
    {Coordinate{83.7693, 53.3663}, CountryId{"RU"}}, // Q113055617
    {Coordinate{117.332, 49.6394}, CountryId{"RU"}}, // Zabaykalsk
    {Coordinate{83.74, 53.3393}, CountryId{"RU"}}, // Q113091856
    {Coordinate{83.6853, 53.2954}, CountryId{"RU"}}, // Q113091859
    {Coordinate{83.6525, 53.2602}, CountryId{"RU"}}, // Q113091861
    {Coordinate{83.626, 53.2296}, CountryId{"RU"}}, // Q113091862
    {Coordinate{83.4886, 53.1744}, CountryId{"RU"}}, // Q113091865
    {Coordinate{83.4652, 53.1649}, CountryId{"RU"}}, // Q113091866
    {Coordinate{83.3938, 53.11}, CountryId{"RU"}}, // Q113091867
    {Coordinate{83.3691, 53.0885}, CountryId{"RU"}}, // Q113091869
    {Coordinate{83.3419, 53.0217}, CountryId{"RU"}}, // Q113091871
    {Coordinate{83.3066, 52.9477}, CountryId{"RU"}}, // Q113091872
    {Coordinate{83.2828, 52.9218}, CountryId{"RU"}}, // Q113091874
    {Coordinate{83.2235, 52.8743}, CountryId{"RU"}}, // Q113091875
    {Coordinate{83.1164, 52.8164}, CountryId{"RU"}}, // Q113091877
    {Coordinate{83.0304, 52.7051}, CountryId{"RU"}}, // Q113091878
    {Coordinate{82.9984, 52.664}, CountryId{"RU"}}, // Q113091879
    {Coordinate{82.844, 52.5177}, CountryId{"RU"}}, // Q113091880
    {Coordinate{82.6633, 52.4243}, CountryId{"RU"}}, // Q113091882
    {Coordinate{82.5331, 52.3652}, CountryId{"RU"}}, // Q113091883
    {Coordinate{82.2605, 52.2161}, CountryId{"RU"}}, // Q113091885
    {Coordinate{81.9894, 52.0687}, CountryId{"RU"}}, // Q113091886
    {Coordinate{81.8246, 51.9922}, CountryId{"RU"}}, // Q113091887
    {Coordinate{81.7034, 51.9367}, CountryId{"RU"}}, // Q113091889
    {Coordinate{81.546, 51.8465}, CountryId{"RU"}}, // Q113091890
    {Coordinate{81.3992, 51.7503}, CountryId{"RU"}}, // Q113091891
    {Coordinate{81.2891, 51.6355}, CountryId{"RU"}}, // Q113091893
    {Coordinate{81.2443, 51.5794}, CountryId{"RU"}}, // Traktorny railway station
    {Coordinate{81.1781, 51.4784}, CountryId{"RU"}}, // Q113091895
    {Coordinate{81.1676, 51.4624}, CountryId{"RU"}}, // Q113091896
    {Coordinate{81.15, 51.4239}, CountryId{"RU"}}, // Q113091898
    {Coordinate{81.1399, 51.3959}, CountryId{"RU"}}, // Q113091899
    {Coordinate{81.131, 51.3645}, CountryId{"RU"}}, // Q113091900
    {Coordinate{81.1107, 51.3089}, CountryId{"RU"}}, // Q113091901
    {Coordinate{-81.8822, 31.6058}, CountryId{"US"}}, // Jesup
    {Coordinate{14.5753, 52.2627}, CountryId{"DE"}}, // Kraftwerk Finkenheerd
    {Coordinate{14.5696, 52.2495}, CountryId{"DE"}}, // Finkenheerd
    {Coordinate{14.6166, 52.199}, CountryId{"DE"}}, // Ziltendorf
    {Coordinate{14.6487, 52.0992}, CountryId{"DE"}}, // Neuzelle
    {Coordinate{14.7186, 52.0202}, CountryId{"DE"}}, // Coschen
    {Coordinate{9.91278, 48.8222}, CountryId{"DE"}}, // Böbingen (Rems) station
    {Coordinate{86.2581, 54.1156}, CountryId{"RU"}}, // Q113165008
    {Coordinate{85.6602, 53.9471}, CountryId{"RU"}}, // Q113165090
    {Coordinate{12.2379, 54.1596}, CountryId{"DE"}}, // Rövershagen Karls Erlebnisdorf railway station
    {Coordinate{83.9325, 53.4406}, CountryId{"RU"}}, // Q113180108
    {Coordinate{83.9712, 53.4498}, CountryId{"RU"}}, // Q113180109
    {Coordinate{84.0135, 53.4576}, CountryId{"RU"}}, // Q113180112
    {Coordinate{84.0644, 53.4692}, CountryId{"RU"}}, // Q113180113
    {Coordinate{84.1038, 53.4763}, CountryId{"RU"}}, // Q113180115
    {Coordinate{84.1285, 53.4805}, CountryId{"RU"}}, // Q113180116
    {Coordinate{84.1995, 53.4949}, CountryId{"RU"}}, // Q113180117
    {Coordinate{84.4068, 53.5247}, CountryId{"RU"}}, // Q113180118
    {Coordinate{84.5229, 53.5464}, CountryId{"RU"}}, // Q113180121
    {Coordinate{84.6725, 53.5944}, CountryId{"RU"}}, // Q113180123
    {Coordinate{84.8114, 53.657}, CountryId{"RU"}}, // Q113180124
    {Coordinate{84.9407, 53.7045}, CountryId{"RU"}}, // Q113180126
    {Coordinate{84.9719, 53.7332}, CountryId{"RU"}}, // Q113180127
    {Coordinate{85.0378, 53.7532}, CountryId{"RU"}}, // Q113180128
    {Coordinate{85.1184, 53.7908}, CountryId{"RU"}}, // Q113180131
    {Coordinate{85.2034, 53.8371}, CountryId{"RU"}}, // Q113180132
    {Coordinate{85.4321, 53.8472}, CountryId{"RU"}}, // Q113180133
    {Coordinate{85.5578, 53.8953}, CountryId{"RU"}}, // Q113180134
    {Coordinate{85.7833, 53.9585}, CountryId{"RU"}}, // Q113180136
    {Coordinate{85.8818, 54.0251}, CountryId{"RU"}}, // Q113180139
    {Coordinate{86.0164, 54.0617}, CountryId{"RU"}}, // Q113180140
    {Coordinate{86.134, 54.1038}, CountryId{"RU"}}, // Q113180141
    {Coordinate{84.4426, 53.5349}, CountryId{"RU"}}, // Q113180179
    {Coordinate{87.6014, 53.7633}, CountryId{"RU"}}, // Q113181694
    {Coordinate{87.1861, 53.9982}, CountryId{"RU"}}, // Q113182214
    {Coordinate{87.1995, 53.9989}, CountryId{"RU"}}, // Q113182216
    {Coordinate{87.2427, 53.9896}, CountryId{"RU"}}, // Q113182218
    {Coordinate{87.2519, 53.9816}, CountryId{"RU"}}, // Q113182219
    {Coordinate{87.2679, 53.9779}, CountryId{"RU"}}, // Q113182221
    {Coordinate{87.3425, 53.9684}, CountryId{"RU"}}, // Q113182223
    {Coordinate{87.341, 53.9373}, CountryId{"RU"}}, // Q113182224
    {Coordinate{87.4344, 53.8998}, CountryId{"RU"}}, // Q113182226
    {Coordinate{87.4737, 53.9037}, CountryId{"RU"}}, // Q113182228
    {Coordinate{87.5018, 53.903}, CountryId{"RU"}}, // Q113182229
    {Coordinate{87.523, 53.8905}, CountryId{"RU"}}, // Q113182230
    {Coordinate{87.5222, 53.8577}, CountryId{"RU"}}, // Q113182231
    {Coordinate{87.5074, 53.8452}, CountryId{"RU"}}, // Q113182232
    {Coordinate{87.4808, 53.8214}, CountryId{"RU"}}, // Q113182233
    {Coordinate{20.327, 48.0088}, CountryId{"HU"}}, // Tardosi kőbányák railway station
    {Coordinate{14.7417, 50.9225}, CountryId{"DE"}}, // Mittelherwigsdorf
    {Coordinate{12.0916, 48.0819}, CountryId{"DE"}}, // Forsting
    {Coordinate{12.1102, 47.7885}, CountryId{"DE"}}, // Raubling
    {Coordinate{12.1281, 47.7241}, CountryId{"DE"}}, // Flintsbach
    {Coordinate{12.1631, 48.0585}, CountryId{"DE"}}, // Edling
    {Coordinate{12.6865, 48.9107}, CountryId{"DE"}}, // Bogen
    {Coordinate{12.2019, 48.6939}, CountryId{"DE"}}, // Ergoldsbach
    {Coordinate{12.2182, 48.7555}, CountryId{"DE"}}, // Oberlindhart
    {Coordinate{12.5926, 48.8765}, CountryId{"DE"}}, // Straubing Ost
    {Coordinate{25.045, 60.2939}, CountryId{"FI"}}, // Tikkurila railway station
    {Coordinate{79.1245, 52.6153}, CountryId{"RU"}}, // Q113308592
    {Coordinate{79.2488, 52.6482}, CountryId{"RU"}}, // Q113308593
    {Coordinate{79.5186, 52.7221}, CountryId{"RU"}}, // Q113308594
    {Coordinate{79.6086, 52.7503}, CountryId{"RU"}}, // Q113308595
    {Coordinate{80.4621, 52.9287}, CountryId{"RU"}}, // Q113308597
    {Coordinate{80.8204, 52.9631}, CountryId{"RU"}}, // Q113308598
    {Coordinate{81.2533, 52.9686}, CountryId{"RU"}}, // Q113308599
    {Coordinate{81.2533, 52.9686}, CountryId{"RU"}}, // Q113308600
    {Coordinate{81.91, 52.9886}, CountryId{"RU"}}, // Q113308602
    {Coordinate{82.1229, 53.0016}, CountryId{"RU"}}, // Q113308603
    {Coordinate{82.3019, 53.0101}, CountryId{"RU"}}, // Q113308604
    {Coordinate{82.4246, 53.0205}, CountryId{"RU"}}, // Q113308606
    {Coordinate{82.4652, 53.0211}, CountryId{"RU"}}, // Q113308607
    {Coordinate{82.6293, 53.0483}, CountryId{"RU"}}, // Q113308608
    {Coordinate{82.7259, 53.0709}, CountryId{"RU"}}, // Q113308609
    {Coordinate{82.8035, 53.0829}, CountryId{"RU"}}, // Q113308610
    {Coordinate{82.9169, 53.0936}, CountryId{"RU"}}, // Q113308611
    {Coordinate{83.0267, 53.1127}, CountryId{"RU"}}, // Q113308612
    {Coordinate{83.1479, 53.1465}, CountryId{"RU"}}, // Q113308613
    {Coordinate{83.2038, 53.1656}, CountryId{"RU"}}, // Q113308615
    {Coordinate{83.2315, 53.1777}, CountryId{"RU"}}, // Q113308616
    {Coordinate{83.2583, 53.1894}, CountryId{"RU"}}, // Q113308618
    {Coordinate{83.3326, 53.2118}, CountryId{"RU"}}, // Q113308619
    {Coordinate{83.3624, 53.2227}, CountryId{"RU"}}, // Q113308620
    {Coordinate{83.4021, 53.2312}, CountryId{"RU"}}, // Q113308623
    {Coordinate{83.4149, 53.2354}, CountryId{"RU"}}, // Q113308624
    {Coordinate{83.4323, 53.2425}, CountryId{"RU"}}, // Q113308625
    {Coordinate{83.4797, 53.2584}, CountryId{"RU"}}, // Q113308626
    {Coordinate{83.4973, 53.262}, CountryId{"RU"}}, // Q113308627
    {Coordinate{83.5216, 53.2669}, CountryId{"RU"}}, // Q113308628
    {Coordinate{83.6226, 53.29}, CountryId{"RU"}}, // Q113308629
    {Coordinate{83.1727, 53.1544}, CountryId{"RU"}}, // Q113308679
    {Coordinate{-77.4287, 37.2419}, CountryId{"US"}}, // Petersburg station
    {Coordinate{85.615, 55.278}, CountryId{"RU"}}, // Topki Railway Station
    {Coordinate{84.7704, 55.6734}, CountryId{"RU"}}, // Q113330179
    {Coordinate{84.7527, 55.6128}, CountryId{"RU"}}, // Q113330180
    {Coordinate{84.7828, 55.5363}, CountryId{"RU"}}, // Q113330181
    {Coordinate{84.7579, 55.4689}, CountryId{"RU"}}, // Q113330182
    {Coordinate{84.7693, 55.4429}, CountryId{"RU"}}, // Q113330183
    {Coordinate{84.8423, 55.4307}, CountryId{"RU"}}, // Q113330184
    {Coordinate{84.9473, 55.4275}, CountryId{"RU"}}, // Q113330185
    {Coordinate{85.0424, 55.4668}, CountryId{"RU"}}, // Q113330186
    {Coordinate{85.1653, 55.4181}, CountryId{"RU"}}, // Q113330187
    {Coordinate{85.2215, 55.362}, CountryId{"RU"}}, // Q113330188
    {Coordinate{85.313, 55.3142}, CountryId{"RU"}}, // Q113330189
    {Coordinate{85.313, 55.3142}, CountryId{"RU"}}, // Q113330190
    {Coordinate{85.4525, 55.2497}, CountryId{"RU"}}, // Q113330191
    {Coordinate{85.4958, 55.2478}, CountryId{"RU"}}, // Q113330192
    {Coordinate{-75.8317, 48.2003}, CountryId{"CA"}}, // Bourmont railway station
    {Coordinate{-72.2164, 47.7331}, CountryId{"CA"}}, // Caribou railway station
    {Coordinate{-72.1881, 47.7561}, CountryId{"CA"}}, // Club Grégoire railway station
    {Coordinate{-72.2317, 47.4192}, CountryId{"CA"}}, // Iroquois Club railway station
    {Coordinate{-72.2117, 47.3189}, CountryId{"CA"}}, // Jacques Cartier Club railway station
    {Coordinate{-72.2439, 47.6131}, CountryId{"CA"}}, // Triton Club railway station
    {Coordinate{-75.4814, 48.1197}, CountryId{"CA"}}, // Coquar railway station
    {Coordinate{-72.9408, 47.64}, CountryId{"CA"}}, // Cressman
    {Coordinate{-73.6414, 47.8858}, CountryId{"CA"}}, // Dessane
    {Coordinate{-76.1461, 48.2531}, CountryId{"CA"}}, // Dix
    {Coordinate{-72.2008, 47.3422}, CountryId{"CA"}}, // Falrie railway station
    {Coordinate{-73.4181, 47.8144}, CountryId{"CA"}}, // Ferguson
    {Coordinate{-74.9781, 48.1192}, CountryId{"CA"}}, // Greening
    {Coordinate{-72.1825, 48.0217}, CountryId{"CA"}}, // Kondiaronk railway station
    {Coordinate{-72.235, 47.5319}, CountryId{"CA"}}, // Pearl Lake railway station
    {Coordinate{-72.2242, 47.3947}, CountryId{"CA"}}, // Lac Malouin railway station
    {Coordinate{-75.9736, 48.2306}, CountryId{"CA"}}, // Langlade
    {Coordinate{-74.3553, 47.8689}, CountryId{"CA"}}, // McCarthy
    {Coordinate{-77.0867, 48.3339}, CountryId{"CA"}}, // Mégiscane
    {Coordinate{-72.2547, 47.2192}, CountryId{"CA"}}, // Miquick railway station
    {Coordinate{-73.0422, 47.6783}, CountryId{"CA"}}, // Rapide-Blanc-Station
    {Coordinate{-76.8314, 48.2967}, CountryId{"CA"}}, // Signai
    {Coordinate{-74.8744, 48.0406}, CountryId{"CA"}}, // Strachan
    {Coordinate{-72.1881, 47.8194}, CountryId{"CA"}}, // Summit railway station
    {Coordinate{-74.7642, 47.9678}, CountryId{"CA"}}, // Timbrell
    {Coordinate{85.7342, 55.2461}, CountryId{"RU"}}, // Q113336362
    {Coordinate{85.7404, 55.1833}, CountryId{"RU"}}, // Q113336364
    {Coordinate{85.7682, 55.1668}, CountryId{"RU"}}, // Q113336365
    {Coordinate{85.7958, 55.1418}, CountryId{"RU"}}, // Q113336366
    {Coordinate{85.847, 55.0898}, CountryId{"RU"}}, // Q113336367
    {Coordinate{85.9398, 55.0212}, CountryId{"RU"}}, // Plotnikovo railway station
    {Coordinate{86.1726, 54.6796}, CountryId{"RU"}}, // Q113336369
    {Coordinate{86.278, 54.1286}, CountryId{"RU"}}, // Q113336527
    {Coordinate{86.3132, 54.4115}, CountryId{"RU"}}, // Belovo railway station
    {Coordinate{86.327, 54.3879}, CountryId{"RU"}}, // Q113336953
    {Coordinate{86.3078, 54.3735}, CountryId{"RU"}}, // Q113336954
    {Coordinate{86.2952, 54.3627}, CountryId{"RU"}}, // Q113336955
    {Coordinate{86.2373, 54.3267}, CountryId{"RU"}}, // Q113336957
    {Coordinate{86.2176, 54.3042}, CountryId{"RU"}}, // Q113336958
    {Coordinate{86.2112, 54.286}, CountryId{"RU"}}, // Q113336960
    {Coordinate{86.2174, 54.2524}, CountryId{"RU"}}, // Bochaty railway station
    {Coordinate{86.2279, 54.229}, CountryId{"RU"}}, // Q113336963
    {Coordinate{86.2485, 54.1935}, CountryId{"RU"}}, // Q113336964
    {Coordinate{86.2456, 54.1595}, CountryId{"RU"}}, // Q113336966
    {Coordinate{85.5852, 56.0599}, CountryId{"RU"}}, // Q113342261
    {Coordinate{85.5951, 56.0782}, CountryId{"RU"}}, // Q113342263
    {Coordinate{85.5066, 56.1031}, CountryId{"RU"}}, // Q113342265
    {Coordinate{85.4346, 56.1243}, CountryId{"RU"}}, // Q113342266
    {Coordinate{85.4345, 56.1703}, CountryId{"RU"}}, // Q113342268
    {Coordinate{85.4332, 56.2119}, CountryId{"RU"}}, // Q113342269
    {Coordinate{85.4552, 56.2341}, CountryId{"RU"}}, // Q113342271
    {Coordinate{85.4613, 56.2526}, CountryId{"RU"}}, // Q113342272
    {Coordinate{85.4829, 56.3073}, CountryId{"RU"}}, // Q113342273
    {Coordinate{85.4145, 56.342}, CountryId{"RU"}}, // Q113342275
    {Coordinate{85.2404, 56.3562}, CountryId{"RU"}}, // Q113342276
    {Coordinate{85.091, 56.3936}, CountryId{"RU"}}, // Q113342277
    {Coordinate{84.9952, 56.4353}, CountryId{"RU"}}, // Q113342279
    {Coordinate{85.0311, 56.4934}, CountryId{"RU"}}, // Q113342280
    {Coordinate{85.0541, 56.5412}, CountryId{"RU"}}, // Q113355524
    {Coordinate{85.1275, 56.5794}, CountryId{"RU"}}, // Q113355526
    {Coordinate{85.1716, 56.5928}, CountryId{"RU"}}, // Q113355529
    {Coordinate{85.192, 56.6068}, CountryId{"RU"}}, // Q113355530
    {Coordinate{85.2287, 56.6358}, CountryId{"RU"}}, // Q113355533
    {Coordinate{85.2953, 56.6736}, CountryId{"RU"}}, // Q113355534
    {Coordinate{85.4051, 56.7217}, CountryId{"RU"}}, // Q113355537
    {Coordinate{85.4395, 56.733}, CountryId{"RU"}}, // Q113355540
    {Coordinate{85.4896, 56.7549}, CountryId{"RU"}}, // Q113355541
    {Coordinate{85.56, 56.7873}, CountryId{"RU"}}, // Q113355543
    {Coordinate{85.6079, 56.8222}, CountryId{"RU"}}, // Q113355546
    {Coordinate{85.7798, 56.878}, CountryId{"RU"}}, // Q113355548
    {Coordinate{85.8872, 56.9089}, CountryId{"RU"}}, // Q113355550
    {Coordinate{85.9665, 56.9309}, CountryId{"RU"}}, // Q113355552
    {Coordinate{86.0823, 56.9513}, CountryId{"RU"}}, // Q113355553
    {Coordinate{86.1577, 56.9965}, CountryId{"RU"}}, // Q113355556
    {Coordinate{85.8601, 57.5896}, CountryId{"RU"}}, // Q113355559
    {Coordinate{85.7842, 57.7111}, CountryId{"RU"}}, // Q113355561
    {Coordinate{85.4188, 58.0271}, CountryId{"RU"}}, // Q113355563
    {Coordinate{85.1817, 58.278}, CountryId{"RU"}}, // Q113355565
    {Coordinate{59.2489, 56.4061}, CountryId{"RU"}}, // Q113360450
    {Coordinate{59.4435, 56.6779}, CountryId{"RU"}}, // Q113360508
    {Coordinate{59.286, 56.6444}, CountryId{"RU"}}, // Q113360509
    {Coordinate{59.2262, 56.558}, CountryId{"RU"}}, // Q113360510
    {Coordinate{59.2228, 56.4429}, CountryId{"RU"}}, // Q113360511
    {Coordinate{86.0477, 55.3293}, CountryId{"RU"}}, // Q113361101
    {Coordinate{86.0395, 55.3235}, CountryId{"RU"}}, // Q113361102
    {Coordinate{85.9696, 55.3223}, CountryId{"RU"}}, // Q113361104
    {Coordinate{85.8685, 55.3587}, CountryId{"RU"}}, // Q113361105
    {Coordinate{85.8489, 55.3566}, CountryId{"RU"}}, // Q113361106
    {Coordinate{85.8306, 55.3581}, CountryId{"RU"}}, // Q113361107
    {Coordinate{85.7996, 55.3613}, CountryId{"RU"}}, // Q113361108
    {Coordinate{85.7866, 55.3509}, CountryId{"RU"}}, // Q113361110
    {Coordinate{85.7587, 55.339}, CountryId{"RU"}}, // Q113361111
    {Coordinate{85.7388, 55.3387}, CountryId{"RU"}}, // Q113361112
    {Coordinate{85.6708, 55.3173}, CountryId{"RU"}}, // Q113361113
    {Coordinate{85.6574, 55.3069}, CountryId{"RU"}}, // Q113361114
    {Coordinate{85.7866, 55.3509}, CountryId{"RU"}}, // Q113361124
    {Coordinate{87.1995, 53.715}, CountryId{"RU"}}, // Q113361746
    {Coordinate{86.3136, 54.1245}, CountryId{"RU"}}, // Q113362925
    {Coordinate{86.3499, 54.1315}, CountryId{"RU"}}, // Q113362926
    {Coordinate{86.403, 54.1271}, CountryId{"RU"}}, // Q113362927
    {Coordinate{86.4241, 54.1175}, CountryId{"RU"}}, // Q113362928
    {Coordinate{86.464, 54.0711}, CountryId{"RU"}}, // Q113362929
    {Coordinate{86.4863, 54.0427}, CountryId{"RU"}}, // Q113362930
    {Coordinate{86.5374, 54.0054}, CountryId{"RU"}}, // Q113362931
    {Coordinate{86.6475, 54.0106}, CountryId{"RU"}}, // Q113362932
    {Coordinate{86.688, 53.9988}, CountryId{"RU"}}, // Q113362933
    {Coordinate{86.7465, 53.978}, CountryId{"RU"}}, // Q113362934
    {Coordinate{86.7555, 53.9601}, CountryId{"RU"}}, // Q113362935
    {Coordinate{86.7466, 53.9373}, CountryId{"RU"}}, // Q113362936
    {Coordinate{86.7473, 53.9069}, CountryId{"RU"}}, // Q113362937
    {Coordinate{86.7548, 53.8729}, CountryId{"RU"}}, // Q113362938
    {Coordinate{86.7662, 53.8251}, CountryId{"RU"}}, // Q113362940
    {Coordinate{86.7879, 53.8106}, CountryId{"RU"}}, // Q113362941
    {Coordinate{86.8407, 53.7831}, CountryId{"RU"}}, // Q113362942
    {Coordinate{86.8796, 53.7821}, CountryId{"RU"}}, // Q113362943
    {Coordinate{86.9241, 53.7884}, CountryId{"RU"}}, // Q113362944
    {Coordinate{86.9706, 53.7841}, CountryId{"RU"}}, // Q113362945
    {Coordinate{87.0015, 53.7622}, CountryId{"RU"}}, // Q113362946
    {Coordinate{87.0112, 53.7506}, CountryId{"RU"}}, // Q113362947
    {Coordinate{87.0588, 53.7439}, CountryId{"RU"}}, // Q113362948
    {Coordinate{87.0791, 53.7451}, CountryId{"RU"}}, // Q113362949
    {Coordinate{87.1736, 53.7262}, CountryId{"RU"}}, // Q113362950
    {Coordinate{87.2517, 53.7257}, CountryId{"RU"}}, // Q113366070
    {Coordinate{87.282, 53.7384}, CountryId{"RU"}}, // Q113366071
    {Coordinate{87.322, 53.7471}, CountryId{"RU"}}, // Q113366072
    {Coordinate{87.41, 53.7577}, CountryId{"RU"}}, // Q113366073
    {Coordinate{87.5011, 53.7614}, CountryId{"RU"}}, // Q113366074
    {Coordinate{87.6484, 53.7566}, CountryId{"RU"}}, // Q113366376
    {Coordinate{87.7442, 53.7428}, CountryId{"RU"}}, // Q113366377
    {Coordinate{87.8116, 53.733}, CountryId{"RU"}}, // Q113366378
    {Coordinate{87.835, 53.7329}, CountryId{"RU"}}, // Q113366379
    {Coordinate{87.9324, 53.7245}, CountryId{"RU"}}, // Q113366382
    {Coordinate{87.9817, 53.7085}, CountryId{"RU"}}, // Q113366383
    {Coordinate{88.0673, 53.6811}, CountryId{"RU"}}, // Q113366458
    {Coordinate{87.2658, 53.8969}, CountryId{"RU"}}, // Q113366931
    {Coordinate{87.2498, 53.8902}, CountryId{"RU"}}, // Q113366932
    {Coordinate{87.2335, 53.8839}, CountryId{"RU"}}, // Q113366933
    {Coordinate{87.1802, 53.8302}, CountryId{"RU"}}, // 16 km railway station, Novokuznetsk
    {Coordinate{87.1687, 53.8193}, CountryId{"RU"}}, // Ostrovskaya railway station
    {Coordinate{87.1425, 53.7828}, CountryId{"RU"}}, // Q113366938
    {Coordinate{87.1815, 53.7683}, CountryId{"RU"}}, // Q113366939
    {Coordinate{87.166, 53.7474}, CountryId{"RU"}}, // Q113366940
    {Coordinate{87.2115, 53.8662}, CountryId{"RU"}}, // Q113366945
    {Coordinate{87.9058, 52.7695}, CountryId{"RU"}}, // Tashtagol railway station
    {Coordinate{87.2187, 53.7008}, CountryId{"RU"}}, // Q113367955
    {Coordinate{87.2215, 53.687}, CountryId{"RU"}}, // Q113367956
    {Coordinate{87.1967, 53.6582}, CountryId{"RU"}}, // Q113367958
    {Coordinate{87.2234, 53.6489}, CountryId{"RU"}}, // Q113367959
    {Coordinate{87.2519, 53.6407}, CountryId{"RU"}}, // Q113367960
    {Coordinate{87.2687, 53.6287}, CountryId{"RU"}}, // Q113367961
    {Coordinate{87.326, 53.6026}, CountryId{"RU"}}, // Q113367963
    {Coordinate{87.2888, 53.5731}, CountryId{"RU"}}, // Q113367964
    {Coordinate{87.2775, 53.544}, CountryId{"RU"}}, // Q113367967
    {Coordinate{87.2696, 53.4959}, CountryId{"RU"}}, // Q113367968
    {Coordinate{87.253, 53.4573}, CountryId{"RU"}}, // Q113367969
    {Coordinate{87.2743, 53.4092}, CountryId{"RU"}}, // Q113367970
    {Coordinate{87.27, 53.3588}, CountryId{"RU"}}, // Q113367971
    {Coordinate{87.1741, 53.2998}, CountryId{"RU"}}, // Q113367972
    {Coordinate{87.3079, 53.6233}, CountryId{"RU"}}, // Q113367985
    {Coordinate{87.2458, 53.3381}, CountryId{"RU"}}, // Q113367986
    {Coordinate{87.2052, 53.2818}, CountryId{"RU"}}, // Q113367987
    {Coordinate{87.2676, 53.2728}, CountryId{"RU"}}, // Q113367988
    {Coordinate{87.2637, 53.2452}, CountryId{"RU"}}, // Q113367989
    {Coordinate{87.2188, 53.6778}, CountryId{"RU"}}, // 11 km railway station, Kemerovo Oblast
    {Coordinate{87.2741, 53.5252}, CountryId{"RU"}}, // Q113368000
    {Coordinate{87.3003, 53.456}, CountryId{"RU"}}, // Q113368001
    {Coordinate{87.3216, 53.4427}, CountryId{"RU"}}, // Q113368002
    {Coordinate{87.3045, 53.4252}, CountryId{"RU"}}, // Q113368003
    {Coordinate{87.2682, 53.3918}, CountryId{"RU"}}, // Q113368004
    {Coordinate{87.2709, 53.2106}, CountryId{"RU"}}, // Q113368667
    {Coordinate{87.2973, 53.2059}, CountryId{"RU"}}, // Mundybash railway station
    {Coordinate{87.3067, 53.187}, CountryId{"RU"}}, // Q113368669
    {Coordinate{87.3803, 53.1419}, CountryId{"RU"}}, // Q113368670
    {Coordinate{87.4311, 53.1271}, CountryId{"RU"}}, // Q113368671
    {Coordinate{87.4727, 53.1287}, CountryId{"RU"}}, // Q113368672
    {Coordinate{87.5121, 53.0929}, CountryId{"RU"}}, // Q113368673
    {Coordinate{87.5427, 53.0146}, CountryId{"RU"}}, // Q113368675
    {Coordinate{87.5182, 52.9978}, CountryId{"RU"}}, // Q113368676
    {Coordinate{87.4586, 52.9835}, CountryId{"RU"}}, // Q113368677
    {Coordinate{87.4461, 52.9477}, CountryId{"RU"}}, // Q113368678
    {Coordinate{87.4984, 52.9177}, CountryId{"RU"}}, // Q113368679
    {Coordinate{87.5619, 52.9188}, CountryId{"RU"}}, // Q113368680
    {Coordinate{87.5946, 52.9303}, CountryId{"RU"}}, // Q113368681
    {Coordinate{87.6387, 52.9235}, CountryId{"RU"}}, // Q113368682
    {Coordinate{87.7351, 52.9261}, CountryId{"RU"}}, // Q113368683
    {Coordinate{87.7769, 52.886}, CountryId{"RU"}}, // Q113368684
    {Coordinate{87.8591, 52.7893}, CountryId{"RU"}}, // Q113368685
    {Coordinate{87.8515, 52.7663}, CountryId{"RU"}}, // Q113368686
    {Coordinate{87.4316, 53.1339}, CountryId{"RU"}}, // Q113368863
    {Coordinate{87.4582, 53.1417}, CountryId{"RU"}}, // Q113368865
    {Coordinate{20.8006, 48.093}, CountryId{"HU"}}, // Q113394123
    {Coordinate{-77.4292, 37.5347}, CountryId{"US"}}, // Richmond Main Street Station
    {Coordinate{10.3256, 47.7085}, CountryId{"DE"}}, // St Mang
    {Coordinate{10.3638, 47.6751}, CountryId{"DE"}}, // Sulzberg
    {Coordinate{10.4109, 47.6783}, CountryId{"DE"}}, // Bodelsberg
    {Coordinate{10.4184, 47.6657}, CountryId{"DE"}}, // Zollhaus-Petersthal
    {Coordinate{10.458, 47.6463}, CountryId{"DE"}}, // Oy-Mittelberg
    {Coordinate{10.4602, 47.6288}, CountryId{"DE"}}, // Wertach-Haslach
    {Coordinate{10.48, 47.6326}, CountryId{"DE"}}, // Maria Rain
    {Coordinate{10.5045, 47.6239}, CountryId{"DE"}}, // Nesselwang
    {Coordinate{10.5575, 47.5958}, CountryId{"DE"}}, // Pfronten-Weißbach
    {Coordinate{11.5477, 49.7589}, CountryId{"DE"}}, // Pegnitz
    {Coordinate{16.3394, 50.5808}, CountryId{"CZ"}}, // Broumov (train station)
    {Coordinate{-79.3853, 40.3183}, CountryId{"US"}}, // Latrobe station
    {Coordinate{88.1064, 56.2138}, CountryId{"RU"}}, // Q113483270
    {Coordinate{88.5168, 56.1148}, CountryId{"RU"}}, // Tyazhin railway station
    {Coordinate{89.0121, 56.074}, CountryId{"RU"}}, // Q113483272
    {Coordinate{89.5548, 56.2223}, CountryId{"RU"}}, // Q113483273
    {Coordinate{89.6496, 56.2339}, CountryId{"RU"}}, // Q113483274
    {Coordinate{89.7787, 56.2074}, CountryId{"RU"}}, // Q113483275
    {Coordinate{89.8501, 56.2065}, CountryId{"RU"}}, // Q113483276
    {Coordinate{89.9226, 56.2205}, CountryId{"RU"}}, // Q113483277
    {Coordinate{90.0018, 56.2398}, CountryId{"RU"}}, // Q113483278
    {Coordinate{90.0833, 56.2704}, CountryId{"RU"}}, // Q113483279
    {Coordinate{90.1218, 56.2844}, CountryId{"RU"}}, // Q113483280
    {Coordinate{90.1774, 56.299}, CountryId{"RU"}}, // Q113483281
    {Coordinate{90.2761, 56.3008}, CountryId{"RU"}}, // Q113483282
    {Coordinate{90.2881, 56.2974}, CountryId{"RU"}}, // Q113483283
    {Coordinate{90.3168, 56.2929}, CountryId{"RU"}}, // Q113483284
    {Coordinate{90.3908, 56.2956}, CountryId{"RU"}}, // Q113483285
    {Coordinate{90.4261, 56.2946}, CountryId{"RU"}}, // Q113483286
    {Coordinate{90.4602, 56.295}, CountryId{"RU"}}, // Q113483287
    {Coordinate{10.3222, 50.7529}, CountryId{"DE"}}, // Breitungen (Werra)
    {Coordinate{88.0425, 53.6905}, CountryId{"RU"}}, // Q113496398
    {Coordinate{88.0712, 53.6788}, CountryId{"RU"}}, // Q113496399
    {Coordinate{88.0945, 53.6677}, CountryId{"RU"}}, // Q113496400
    {Coordinate{88.1426, 53.6483}, CountryId{"RU"}}, // Q113496402
    {Coordinate{88.1699, 53.6408}, CountryId{"RU"}}, // Q113496403
    {Coordinate{88.2451, 53.6477}, CountryId{"RU"}}, // Q113496406
    {Coordinate{88.2801, 53.6655}, CountryId{"RU"}}, // Q113496407
    {Coordinate{88.323, 53.665}, CountryId{"RU"}}, // Q113496408
    {Coordinate{88.396, 53.674}, CountryId{"RU"}}, // Q113496409
    {Coordinate{88.4596, 53.6611}, CountryId{"RU"}}, // Q113496410
    {Coordinate{88.5135, 53.6514}, CountryId{"RU"}}, // Q113496411
    {Coordinate{88.5476, 53.6431}, CountryId{"RU"}}, // Q113496412
    {Coordinate{88.7108, 53.6737}, CountryId{"RU"}}, // Q113496414
    {Coordinate{88.7702, 53.6564}, CountryId{"RU"}}, // Q113496415
    {Coordinate{88.8741, 53.658}, CountryId{"RU"}}, // Q113496416
    {Coordinate{88.9121, 53.6427}, CountryId{"RU"}}, // Q113496417
    {Coordinate{88.9552, 53.6159}, CountryId{"RU"}}, // Q113496418
    {Coordinate{89, 53.5867}, CountryId{"RU"}}, // Q113496419
    {Coordinate{89.134, 53.4223}, CountryId{"RU"}}, // Q113496420
    {Coordinate{89.2795, 53.4221}, CountryId{"RU"}}, // Q113496421
    {Coordinate{89.4048, 53.4317}, CountryId{"RU"}}, // Q113496422
    {Coordinate{89.4299, 53.4375}, CountryId{"RU"}}, // Q113496423
    {Coordinate{89.5605, 53.4614}, CountryId{"RU"}}, // Q113496424
    {Coordinate{89.6038, 53.4583}, CountryId{"RU"}}, // Q113496425
    {Coordinate{89.6779, 53.4622}, CountryId{"RU"}}, // Q113496426
    {Coordinate{89.7137, 53.4392}, CountryId{"RU"}}, // Q113496427
    {Coordinate{89.7881, 53.382}, CountryId{"RU"}}, // Q113496428
    {Coordinate{89.8067, 53.379}, CountryId{"RU"}}, // Q113496429
    {Coordinate{89.8856, 53.3318}, CountryId{"RU"}}, // Q113496430
    {Coordinate{89.9778, 53.2573}, CountryId{"RU"}}, // Q113496431
    {Coordinate{90.0304, 53.22}, CountryId{"RU"}}, // Q113496432
    {Coordinate{90.0981, 53.1891}, CountryId{"RU"}}, // Q113496433
    {Coordinate{90.1793, 53.1601}, CountryId{"RU"}}, // Q113496434
    {Coordinate{90.2404, 53.1513}, CountryId{"RU"}}, // Q113496435
    {Coordinate{90.4389, 53.1326}, CountryId{"RU"}}, // Q113496436
    {Coordinate{90.5081, 53.1407}, CountryId{"RU"}}, // Q113496437
    {Coordinate{90.5617, 53.1632}, CountryId{"RU"}}, // Q113496438
    {Coordinate{90.7786, 53.3243}, CountryId{"RU"}}, // Q113496439
    {Coordinate{90.7786, 53.3243}, CountryId{"RU"}}, // Q113496440
    {Coordinate{90.8348, 53.3693}, CountryId{"RU"}}, // Q113496441
    {Coordinate{91.0035, 53.462}, CountryId{"RU"}}, // Q113496442
    {Coordinate{91.0594, 53.518}, CountryId{"RU"}}, // Q113496444
    {Coordinate{91.0722, 53.535}, CountryId{"RU"}}, // Q113496445
    {Coordinate{88.1274, 53.6545}, CountryId{"RU"}}, // Q113496448
    {Coordinate{90.1189, 52.655}, CountryId{"RU"}}, // Q113496553
    {Coordinate{90.379, 53.0537}, CountryId{"RU"}}, // Q113496709
    {Coordinate{90.3065, 53.0137}, CountryId{"RU"}}, // Q113496710
    {Coordinate{90.2449, 52.9571}, CountryId{"RU"}}, // Q113496711
    {Coordinate{90.2441, 52.8739}, CountryId{"RU"}}, // Q113496712
    {Coordinate{90.2558, 52.8253}, CountryId{"RU"}}, // Q113496714
    {Coordinate{90.265, 52.7111}, CountryId{"RU"}}, // Q113496715
    {Coordinate{90.221, 52.6846}, CountryId{"RU"}}, // Q113496716
    {Coordinate{91.1944, 53.6266}, CountryId{"RU"}}, // Q113529161
    {Coordinate{91.2275, 53.642}, CountryId{"RU"}}, // Q113529162
    {Coordinate{91.2634, 53.6586}, CountryId{"RU"}}, // Q113529163
    {Coordinate{91.2982, 53.6751}, CountryId{"RU"}}, // Q113529164
    {Coordinate{91.3124, 53.6808}, CountryId{"RU"}}, // Q113529165
    {Coordinate{91.374, 53.7004}, CountryId{"RU"}}, // Q113529166
    {Coordinate{91.3906, 53.7058}, CountryId{"RU"}}, // Q113529167
    {Coordinate{91.4956, 53.701}, CountryId{"RU"}}, // Q113553390
    {Coordinate{91.5226, 53.6794}, CountryId{"RU"}}, // Q113553391
    {Coordinate{91.5404, 53.6531}, CountryId{"RU"}}, // Q113553392
    {Coordinate{91.807, 53.6409}, CountryId{"RU"}}, // Q113553394
    {Coordinate{92.0696, 53.6894}, CountryId{"RU"}}, // Q113553395
    {Coordinate{92.1771, 53.7211}, CountryId{"RU"}}, // Q113553396
    {Coordinate{92.2338, 53.74}, CountryId{"RU"}}, // Q113553397
    {Coordinate{92.3462, 53.7731}, CountryId{"RU"}}, // Q113553398
    {Coordinate{92.4306, 53.7841}, CountryId{"RU"}}, // Q113553399
    {Coordinate{92.5633, 53.8219}, CountryId{"RU"}}, // Q113553400
    {Coordinate{92.6072, 53.8289}, CountryId{"RU"}}, // Q113553401
    {Coordinate{92.6778, 53.8384}, CountryId{"RU"}}, // Q113553402
    {Coordinate{92.7084, 53.8667}, CountryId{"RU"}}, // Q113553403
    {Coordinate{92.9074, 53.9736}, CountryId{"RU"}}, // Q113553404
    {Coordinate{93.0646, 54.065}, CountryId{"RU"}}, // Q113553405
    {Coordinate{93.1623, 54.0702}, CountryId{"RU"}}, // Q113553406
    {Coordinate{93.2641, 54.0895}, CountryId{"RU"}}, // Q113553407
    {Coordinate{93.2585, 54.1243}, CountryId{"RU"}}, // Q113553408
    {Coordinate{93.253, 54.1617}, CountryId{"RU"}}, // Q113553409
    {Coordinate{93.2729, 54.2002}, CountryId{"RU"}}, // Q113553410
    {Coordinate{93.2949, 54.2251}, CountryId{"RU"}}, // Q113553411
    {Coordinate{93.3132, 54.2528}, CountryId{"RU"}}, // Q113553412
    {Coordinate{93.3696, 54.4272}, CountryId{"RU"}}, // Q113553413
    {Coordinate{93.4313, 54.4859}, CountryId{"RU"}}, // Q113553414
    {Coordinate{93.3943, 54.6229}, CountryId{"RU"}}, // Q113553415
    {Coordinate{93.5164, 54.6987}, CountryId{"RU"}}, // Q113553416
    {Coordinate{93.623, 54.7566}, CountryId{"RU"}}, // Q113553417
    {Coordinate{93.6733, 54.8393}, CountryId{"RU"}}, // Q113553418
    {Coordinate{94.0761, 55.1029}, CountryId{"RU"}}, // Q113553419
    {Coordinate{94.0687, 55.1329}, CountryId{"RU"}}, // Q113553420
    {Coordinate{94.159, 55.2277}, CountryId{"RU"}}, // Q113553421
    {Coordinate{94.2342, 55.2717}, CountryId{"RU"}}, // Q113553422
    {Coordinate{94.2754, 55.3065}, CountryId{"RU"}}, // Q113553423
    {Coordinate{94.3308, 55.383}, CountryId{"RU"}}, // Q113553424
    {Coordinate{94.5048, 55.4972}, CountryId{"RU"}}, // Q113553425
    {Coordinate{94.6271, 55.5321}, CountryId{"RU"}}, // Q113553426
    {Coordinate{94.9574, 55.58}, CountryId{"RU"}}, // Q113553778
    {Coordinate{95.0937, 55.596}, CountryId{"RU"}}, // Q113553779
    {Coordinate{95.1763, 55.5979}, CountryId{"RU"}}, // Q113553780
    {Coordinate{95.3874, 55.6371}, CountryId{"RU"}}, // Q113553781
    {Coordinate{95.5996, 55.6727}, CountryId{"RU"}}, // Q113553782
    {Coordinate{95.8295, 55.7529}, CountryId{"RU"}}, // Q113553783
    {Coordinate{96.0179, 55.7883}, CountryId{"RU"}}, // Q113553784
    {Coordinate{96.1845, 55.7903}, CountryId{"RU"}}, // Q113553786
    {Coordinate{96.4281, 55.744}, CountryId{"RU"}}, // Q113553787
    {Coordinate{96.6076, 55.7842}, CountryId{"RU"}}, // Q113553788
    {Coordinate{96.8472, 55.8107}, CountryId{"RU"}}, // Q113553789
    {Coordinate{97.0172, 55.8121}, CountryId{"RU"}}, // Q113553790
    {Coordinate{97.2157, 55.8205}, CountryId{"RU"}}, // Q113553791
    {Coordinate{97.2978, 55.8241}, CountryId{"RU"}}, // Q113553792
    {Coordinate{97.449, 55.8827}, CountryId{"RU"}}, // Q113553793
    {Coordinate{97.4758, 55.9224}, CountryId{"RU"}}, // Q113553794
    {Coordinate{97.5349, 55.9394}, CountryId{"RU"}}, // Q113553795
    {Coordinate{97.6181, 55.9667}, CountryId{"RU"}}, // Q113553796
    {Coordinate{97.7019, 55.9327}, CountryId{"RU"}}, // Q113553797
    {Coordinate{97.7467, 55.945}, CountryId{"RU"}}, // Q113553798
    {Coordinate{97.7874, 55.9452}, CountryId{"RU"}}, // Q113553799
    {Coordinate{97.8388, 55.942}, CountryId{"RU"}}, // Q113553801
    {Coordinate{97.9647, 55.9419}, CountryId{"RU"}}, // Q113553802
    {Coordinate{92.4711, 58.2289}, CountryId{"RU"}}, // Lesosibirsk train station
    {Coordinate{92.6379, 58.0838}, CountryId{"RU"}}, // Q113555242
    {Coordinate{92.3795, 57.944}, CountryId{"RU"}}, // Q113555243
    {Coordinate{92.1789, 57.8195}, CountryId{"RU"}}, // Q113555245
    {Coordinate{92.1612, 57.7803}, CountryId{"RU"}}, // Q113555246
    {Coordinate{91.9339, 57.6441}, CountryId{"RU"}}, // Q113555247
    {Coordinate{91.8972, 57.5927}, CountryId{"RU"}}, // Q113555248
    {Coordinate{91.8707, 57.5687}, CountryId{"RU"}}, // Q113555249
    {Coordinate{91.702, 57.4344}, CountryId{"RU"}}, // Q113555250
    {Coordinate{91.6519, 57.3258}, CountryId{"RU"}}, // Q113555251
    {Coordinate{91.4839, 57.0958}, CountryId{"RU"}}, // Q113555252
    {Coordinate{91.3964, 56.9862}, CountryId{"RU"}}, // Q113555253
    {Coordinate{91.3416, 56.9324}, CountryId{"RU"}}, // Q113555254
    {Coordinate{91.2947, 56.8891}, CountryId{"RU"}}, // Q113555255
    {Coordinate{91.2074, 56.8017}, CountryId{"RU"}}, // Q113555256
    {Coordinate{91.105, 56.7112}, CountryId{"RU"}}, // Q113555257
    {Coordinate{90.9983, 56.6233}, CountryId{"RU"}}, // Q113555258
    {Coordinate{90.9316, 56.5442}, CountryId{"RU"}}, // Q113555259
    {Coordinate{90.8641, 56.4903}, CountryId{"RU"}}, // Q113555261
    {Coordinate{90.7614, 56.4471}, CountryId{"RU"}}, // Q113555262
    {Coordinate{90.654, 56.3686}, CountryId{"RU"}}, // Q113555263
    {Coordinate{90.373, 55.9996}, CountryId{"RU"}}, // Q113559313
    {Coordinate{90.1366, 55.7735}, CountryId{"RU"}}, // Q113559314
    {Coordinate{90.0466, 55.698}, CountryId{"RU"}}, // Q113559315
    {Coordinate{90.0021, 55.5698}, CountryId{"RU"}}, // Q113559316
    {Coordinate{89.8302, 55.3048}, CountryId{"RU"}}, // Q113559318
    {Coordinate{89.8302, 55.3048}, CountryId{"RU"}}, // Q113559319
    {Coordinate{89.8279, 54.9913}, CountryId{"RU"}}, // Q113559320
    {Coordinate{89.7716, 54.7011}, CountryId{"RU"}}, // Q113559321
    {Coordinate{90.0333, 54.2852}, CountryId{"RU"}}, // Q113559322
    {Coordinate{90.3306, 54.0913}, CountryId{"RU"}}, // Q113559323
    {Coordinate{90.31, 53.9784}, CountryId{"RU"}}, // Q113559325
    {Coordinate{90.2354, 53.8334}, CountryId{"RU"}}, // Q113559328
    {Coordinate{90.3612, 53.7246}, CountryId{"RU"}}, // Q113559330
    {Coordinate{90.5412, 56.3084}, CountryId{"RU"}}, // Q113564725
    {Coordinate{90.6138, 56.3047}, CountryId{"RU"}}, // Q113564726
    {Coordinate{90.6706, 56.3205}, CountryId{"RU"}}, // Q113564727
    {Coordinate{90.6706, 56.3205}, CountryId{"RU"}}, // Q113564728
    {Coordinate{90.7531, 56.326}, CountryId{"RU"}}, // Q113564729
    {Coordinate{90.7719, 56.3143}, CountryId{"RU"}}, // Q113564730
    {Coordinate{90.8405, 56.2986}, CountryId{"RU"}}, // Q113564731
    {Coordinate{90.9171, 56.3057}, CountryId{"RU"}}, // Q113564732
    {Coordinate{90.9628, 56.3068}, CountryId{"RU"}}, // Q113564733
    {Coordinate{90.988, 56.308}, CountryId{"RU"}}, // Q113564734
    {Coordinate{91.0066, 56.3084}, CountryId{"RU"}}, // Q113564735
    {Coordinate{91.0434, 56.3004}, CountryId{"RU"}}, // Q113564736
    {Coordinate{91.0914, 56.2728}, CountryId{"RU"}}, // Chernorechenskaya railway station
    {Coordinate{91.1182, 56.2589}, CountryId{"RU"}}, // Q113564738
    {Coordinate{91.146, 56.2359}, CountryId{"RU"}}, // Q113564739
    {Coordinate{91.1793, 56.2139}, CountryId{"RU"}}, // Q113564740
    {Coordinate{91.2416, 56.21}, CountryId{"RU"}}, // Q113564741
    {Coordinate{91.2788, 56.1887}, CountryId{"RU"}}, // Q113564742
    {Coordinate{91.3581, 56.1682}, CountryId{"RU"}}, // Q113564743
    {Coordinate{91.3897, 56.1633}, CountryId{"RU"}}, // Q113564744
    {Coordinate{91.4648, 56.1575}, CountryId{"RU"}}, // Q113564745
    {Coordinate{91.5135, 56.1339}, CountryId{"RU"}}, // Q113564746
    {Coordinate{91.5501, 56.1294}, CountryId{"RU"}}, // Q113564747
    {Coordinate{91.632, 56.1361}, CountryId{"RU"}}, // Q113564748
    {Coordinate{91.673, 56.1164}, CountryId{"RU"}}, // Q113564749
    {Coordinate{91.7082, 56.0949}, CountryId{"RU"}}, // Kemchug train station
    {Coordinate{91.773, 56.0733}, CountryId{"RU"}}, // Q113564751
    {Coordinate{91.8291, 56.0588}, CountryId{"RU"}}, // Q113564752
    {Coordinate{91.8696, 56.0783}, CountryId{"RU"}}, // Q113564753
    {Coordinate{92.2948, 56.1097}, CountryId{"RU"}}, // Q113564756
    {Coordinate{92.3509, 56.1218}, CountryId{"RU"}}, // Q113564757
    {Coordinate{92.3833, 56.1114}, CountryId{"RU"}}, // Q113564759
    {Coordinate{92.4044, 56.0894}, CountryId{"RU"}}, // Q113564760
    {Coordinate{92.4751, 56.0712}, CountryId{"RU"}}, // Q113564761
    {Coordinate{92.5013, 56.0503}, CountryId{"RU"}}, // Q113564762
    {Coordinate{92.5297, 56.0512}, CountryId{"RU"}}, // Q113564763
    {Coordinate{92.5755, 56.0472}, CountryId{"RU"}}, // Q113564764
    {Coordinate{92.6141, 56.0484}, CountryId{"RU"}}, // Q113564765
    {Coordinate{92.6576, 56.0376}, CountryId{"RU"}}, // Q113564766
    {Coordinate{92.7355, 56.0529}, CountryId{"RU"}}, // Q113564767
    {Coordinate{93.0117, 56.0116}, CountryId{"RU"}}, // Q113565326
    {Coordinate{93.029, 56.015}, CountryId{"RU"}}, // Q113565327
    {Coordinate{93.1161, 55.9944}, CountryId{"RU"}}, // Q113565331
    {Coordinate{93.1711, 55.9132}, CountryId{"RU"}}, // Q113572869
    {Coordinate{93.1857, 55.8982}, CountryId{"RU"}}, // Q113572870
    {Coordinate{93.2305, 55.8754}, CountryId{"RU"}}, // Q113572871
    {Coordinate{93.2614, 55.8725}, CountryId{"RU"}}, // Q113572872
    {Coordinate{93.3009, 55.8798}, CountryId{"RU"}}, // Shushun railway station
    {Coordinate{93.313, 55.8734}, CountryId{"RU"}}, // Q113572874
    {Coordinate{93.3593, 55.8689}, CountryId{"RU"}}, // Q113572875
    {Coordinate{93.3965, 55.8803}, CountryId{"RU"}}, // Q113572876
    {Coordinate{93.4281, 55.8811}, CountryId{"RU"}}, // Q113572877
    {Coordinate{93.4639, 55.8616}, CountryId{"RU"}}, // Q113572878
    {Coordinate{93.4862, 55.8286}, CountryId{"RU"}}, // Q113572879
    {Coordinate{93.5272, 55.8084}, CountryId{"RU"}}, // Q113572880
    {Coordinate{93.551, 55.8004}, CountryId{"RU"}}, // Q113572881
    {Coordinate{93.6095, 55.7929}, CountryId{"RU"}}, // Q113572882
    {Coordinate{93.6784, 55.8095}, CountryId{"RU"}}, // Kamarchaga train station
    {Coordinate{93.7629, 55.8398}, CountryId{"RU"}}, // Q113572884
    {Coordinate{93.8243, 55.8508}, CountryId{"RU"}}, // Q113572885
    {Coordinate{93.9047, 55.8748}, CountryId{"RU"}}, // Q113572886
    {Coordinate{94.0838, 55.8391}, CountryId{"RU"}}, // Q113572888
    {Coordinate{94.1091, 55.8319}, CountryId{"RU"}}, // Q113572889
    {Coordinate{94.1314, 55.8219}, CountryId{"RU"}}, // Q113572890
    {Coordinate{94.1314, 55.8219}, CountryId{"RU"}}, // Q113572891
    {Coordinate{94.2656, 55.8008}, CountryId{"RU"}}, // Q113572892
    {Coordinate{94.2908, 55.8017}, CountryId{"RU"}}, // Q113572893
    {Coordinate{92.4894, 55.9464}, CountryId{"RU"}}, // Q113573487
    {Coordinate{92.5325, 55.9587}, CountryId{"RU"}}, // Q113573488
    {Coordinate{92.5606, 55.9602}, CountryId{"RU"}}, // Q113573489
    {Coordinate{92.5999, 55.9593}, CountryId{"RU"}}, // Sliznevo railway station
    {Coordinate{92.7424, 55.9698}, CountryId{"RU"}}, // Turbaza railway station
    {Coordinate{92.8923, 56.0609}, CountryId{"RU"}}, // Q113573755
    {Coordinate{4.62694, 44.1617}, CountryId{"FR"}}, // Bagnols-sur-Cèze station
    {Coordinate{94.472, 55.846}, CountryId{"RU"}}, // Q113574110
    {Coordinate{94.6003, 55.8007}, CountryId{"RU"}}, // Q113574111
    {Coordinate{94.6747, 55.7562}, CountryId{"RU"}}, // Q113574112
    {Coordinate{94.7261, 55.6716}, CountryId{"RU"}}, // Q113574113
    {Coordinate{94.7463, 55.5976}, CountryId{"RU"}}, // Q113574114
    {Coordinate{94.3486, 55.8236}, CountryId{"RU"}}, // Q113574580
    {Coordinate{94.4107, 55.8988}, CountryId{"RU"}}, // Q113574581
    {Coordinate{94.5287, 55.9115}, CountryId{"RU"}}, // Q113574582
    {Coordinate{94.6028, 55.9163}, CountryId{"RU"}}, // Q113574583
    {Coordinate{94.652, 55.9478}, CountryId{"RU"}}, // Q113574584
    {Coordinate{94.7863, 55.9525}, CountryId{"RU"}}, // Q113574585
    {Coordinate{94.8502, 55.9583}, CountryId{"RU"}}, // Q113574586
    {Coordinate{94.9065, 55.96}, CountryId{"RU"}}, // Q113574587
    {Coordinate{94.9819, 55.9685}, CountryId{"RU"}}, // Q113574588
    {Coordinate{95.0326, 55.9737}, CountryId{"RU"}}, // Q113574589
    {Coordinate{95.0326, 55.9737}, CountryId{"RU"}}, // Q113574590
    {Coordinate{95.1443, 55.9834}, CountryId{"RU"}}, // Q113574591
    {Coordinate{95.2049, 56.0034}, CountryId{"RU"}}, // Q113574592
    {Coordinate{95.2753, 56.0354}, CountryId{"RU"}}, // Q113574593
    {Coordinate{95.3018, 56.0755}, CountryId{"RU"}}, // Q113574594
    {Coordinate{95.3331, 56.1124}, CountryId{"RU"}}, // Q113574595
    {Coordinate{95.3681, 56.1358}, CountryId{"RU"}}, // Q113574596
    {Coordinate{95.421, 56.1488}, CountryId{"RU"}}, // Q113574597
    {Coordinate{95.4541, 56.196}, CountryId{"RU"}}, // Q113574598
    {Coordinate{95.5156, 56.1978}, CountryId{"RU"}}, // Q113574599
    {Coordinate{95.604, 56.1976}, CountryId{"RU"}}, // Q113574600
    {Coordinate{95.6414, 56.198}, CountryId{"RU"}}, // Q113574601
    {Coordinate{95.737, 56.2129}, CountryId{"RU"}}, // Q113574602
    {Coordinate{95.7514, 56.2305}, CountryId{"RU"}}, // Q113574603
    {Coordinate{95.7583, 56.2418}, CountryId{"RU"}}, // Q113574604
    {Coordinate{95.7832, 56.2706}, CountryId{"RU"}}, // Q113574605
    {Coordinate{95.8557, 56.2821}, CountryId{"RU"}}, // Q113574606
    {Coordinate{95.909, 56.281}, CountryId{"RU"}}, // Q113574607
    {Coordinate{95.9484, 56.2781}, CountryId{"RU"}}, // Q113574608
    {Coordinate{96.0468, 56.2493}, CountryId{"RU"}}, // Q113574609
    {Coordinate{96.1971, 56.2368}, CountryId{"RU"}}, // Q113574611
    {Coordinate{96.2131, 56.2364}, CountryId{"RU"}}, // Q113574612
    {Coordinate{96.2826, 56.2287}, CountryId{"RU"}}, // Q113574613
    {Coordinate{96.3899, 56.2073}, CountryId{"RU"}}, // Q113574614
    {Coordinate{96.4472, 56.2046}, CountryId{"RU"}}, // Q113574615
    {Coordinate{96.4472, 56.2046}, CountryId{"RU"}}, // Ingashskaya station
    {Coordinate{96.5387, 56.2002}, CountryId{"RU"}}, // Q113574617
    {Coordinate{96.5731, 56.1976}, CountryId{"RU"}}, // Q113574618
    {Coordinate{96.6225, 56.1801}, CountryId{"RU"}}, // Q113574619
    {Coordinate{96.7155, 56.1725}, CountryId{"RU"}}, // Q113574621
    {Coordinate{96.8395, 56.1528}, CountryId{"RU"}}, // Q113574622
    {Coordinate{96.9141, 56.1476}, CountryId{"RU"}}, // Q113574623
    {Coordinate{96.9693, 56.1507}, CountryId{"RU"}}, // Q113574624
    {Coordinate{97.0435, 56.1376}, CountryId{"RU"}}, // Q113574625
    {Coordinate{97.0631, 56.1405}, CountryId{"RU"}}, // Q113574626
    {Coordinate{97.1582, 56.1541}, CountryId{"RU"}}, // Q113574627
    {Coordinate{97.4231, 57.756}, CountryId{"RU"}}, // Q113579336
    {Coordinate{97.4989, 57.4453}, CountryId{"RU"}}, // Q113579338
    {Coordinate{97.7351, 57.2701}, CountryId{"RU"}}, // Q113579339
    {Coordinate{97.7496, 57.1859}, CountryId{"RU"}}, // Q113579340
    {Coordinate{97.7153, 56.9601}, CountryId{"RU"}}, // Q113579341
    {Coordinate{97.6836, 56.9299}, CountryId{"RU"}}, // Q113579342
    {Coordinate{97.6837, 56.8755}, CountryId{"RU"}}, // Q113579343
    {Coordinate{97.7205, 56.7804}, CountryId{"RU"}}, // Q113579344
    {Coordinate{97.7212, 56.6766}, CountryId{"RU"}}, // Q113579345
    {Coordinate{97.7047, 56.5484}, CountryId{"RU"}}, // Q113579346
    {Coordinate{97.6715, 56.5175}, CountryId{"RU"}}, // Q113579347
    {Coordinate{97.5468, 56.4539}, CountryId{"RU"}}, // Q113579348
    {Coordinate{97.398, 56.3637}, CountryId{"RU"}}, // Q113579349
    {Coordinate{97.3424, 56.2608}, CountryId{"RU"}}, // Q113579350
    {Coordinate{104.569, 51.8008}, CountryId{"RU"}}, // Q113581525
    {Coordinate{104.133, 51.7663}, CountryId{"RU"}}, // Q113581530
    {Coordinate{103.877, 51.7332}, CountryId{"RU"}}, // Q113581532
    {Coordinate{98.0221, 55.9268}, CountryId{"RU"}}, // 4518 km
    {Coordinate{98.084, 55.9092}, CountryId{"RU"}}, // Q113588658
    {Coordinate{98.1014, 55.8916}, CountryId{"RU"}}, // Q113588659
    {Coordinate{98.1248, 55.8594}, CountryId{"RU"}}, // Q113588660
    {Coordinate{98.1868, 55.7922}, CountryId{"RU"}}, // Q113588661
    {Coordinate{98.2579, 55.737}, CountryId{"RU"}}, // Q113588662
    {Coordinate{98.3955, 55.7131}, CountryId{"RU"}}, // Q113588663
    {Coordinate{98.4571, 55.6684}, CountryId{"RU"}}, // Q113588664
    {Coordinate{98.6774, 55.5724}, CountryId{"RU"}}, // Q113588665
    {Coordinate{98.6484, 55.5264}, CountryId{"RU"}}, // Q113588666
    {Coordinate{98.623, 55.4658}, CountryId{"RU"}}, // Q113588667
    {Coordinate{98.6472, 55.3705}, CountryId{"RU"}}, // Q113588668
    {Coordinate{98.6868, 55.3001}, CountryId{"RU"}}, // Q113588669
    {Coordinate{98.7389, 55.2753}, CountryId{"RU"}}, // Q113588670
    {Coordinate{98.8008, 55.2043}, CountryId{"RU"}}, // Q113588671
    {Coordinate{98.8634, 55.0799}, CountryId{"RU"}}, // Q113588672
    {Coordinate{98.8581, 54.9961}, CountryId{"RU"}}, // Q113588673
    {Coordinate{98.9599, 54.942}, CountryId{"RU"}}, // Q113588674
    {Coordinate{99.0123, 54.9019}, CountryId{"RU"}}, // Q113588675
    {Coordinate{99.088, 54.866}, CountryId{"RU"}}, // Q113588676
    {Coordinate{99.1222, 54.843}, CountryId{"RU"}}, // Q113588677
    {Coordinate{99.4186, 54.764}, CountryId{"RU"}}, // Q113588678
    {Coordinate{99.7662, 54.6513}, CountryId{"RU"}}, // Q113588679
    {Coordinate{99.8241, 54.6314}, CountryId{"RU"}}, // Q113588680
    {Coordinate{99.846, 54.6255}, CountryId{"RU"}}, // Q113588681
    {Coordinate{99.8898, 54.6258}, CountryId{"RU"}}, // Q113588682
    {Coordinate{99.9763, 54.6378}, CountryId{"RU"}}, // Q113588683
    {Coordinate{100.132, 54.6304}, CountryId{"RU"}}, // Q113588684
    {Coordinate{100.2, 54.6175}, CountryId{"RU"}}, // Q113588685
    {Coordinate{100.326, 54.6356}, CountryId{"RU"}}, // Q113588686
    {Coordinate{100.457, 54.6431}, CountryId{"RU"}}, // Q113588687
    {Coordinate{100.516, 54.6328}, CountryId{"RU"}}, // Q113588688
    {Coordinate{100.59, 54.5715}, CountryId{"RU"}}, // Q113588689
    {Coordinate{100.605, 54.5677}, CountryId{"RU"}}, // Q113588690
    {Coordinate{100.655, 54.5338}, CountryId{"RU"}}, // Q113588691
    {Coordinate{100.76, 54.5095}, CountryId{"RU"}}, // Q113588692
    {Coordinate{100.892, 54.4544}, CountryId{"RU"}}, // Q113588693
    {Coordinate{101.047, 54.4548}, CountryId{"RU"}}, // Q113588694
    {Coordinate{101.165, 54.4712}, CountryId{"RU"}}, // Q113588695
    {Coordinate{101.301, 54.4317}, CountryId{"RU"}}, // Q113588696
    {Coordinate{101.38, 54.3892}, CountryId{"RU"}}, // Q113588697
    {Coordinate{101.503, 54.3248}, CountryId{"RU"}}, // Q113588698
    {Coordinate{101.648, 54.2438}, CountryId{"RU"}}, // Q113588699
    {Coordinate{101.716, 54.196}, CountryId{"RU"}}, // Q113588700
    {Coordinate{101.844, 54.1365}, CountryId{"RU"}}, // Q113588701
    {Coordinate{101.88, 54.1002}, CountryId{"RU"}}, // Q113588702
    {Coordinate{101.959, 54.0405}, CountryId{"RU"}}, // Q113588703
    {Coordinate{102.01, 53.9865}, CountryId{"RU"}}, // Q113588705
    {Coordinate{102.091, 53.8977}, CountryId{"RU"}}, // Q113611686
    {Coordinate{102.118, 53.8797}, CountryId{"RU"}}, // Q113611687
    {Coordinate{102.147, 53.8516}, CountryId{"RU"}}, // Q113611688
    {Coordinate{102.31, 53.6751}, CountryId{"RU"}}, // Q113611690
    {Coordinate{102.331, 53.6616}, CountryId{"RU"}}, // Q113611691
    {Coordinate{102.409, 53.615}, CountryId{"RU"}}, // Q113611692
    {Coordinate{102.518, 53.5676}, CountryId{"RU"}}, // Q113611693
    {Coordinate{102.638, 53.4735}, CountryId{"RU"}}, // Q113611694
    {Coordinate{102.675, 53.4271}, CountryId{"RU"}}, // Q113611695
    {Coordinate{102.724, 53.3872}, CountryId{"RU"}}, // Q113611696
    {Coordinate{102.756, 53.359}, CountryId{"RU"}}, // Q113611697
    {Coordinate{102.78, 53.3463}, CountryId{"RU"}}, // Q113611698
    {Coordinate{102.836, 53.2711}, CountryId{"RU"}}, // Q113611699
    {Coordinate{102.93, 53.221}, CountryId{"RU"}}, // Q113611700
    {Coordinate{103.074, 53.1589}, CountryId{"RU"}}, // Q113611702
    {Coordinate{103.085, 53.149}, CountryId{"RU"}}, // Cheremkhovo
    {Coordinate{103.141, 53.1019}, CountryId{"RU"}}, // Q113611704
    {Coordinate{103.165, 53.057}, CountryId{"RU"}}, // Q113611705
    {Coordinate{103.19, 53.0295}, CountryId{"RU"}}, // Vostochnaya
    {Coordinate{103.218, 52.9971}, CountryId{"RU"}}, // Vitukh
    {Coordinate{103.283, 52.9561}, CountryId{"RU"}}, // Polovina
    {Coordinate{103.486, 52.8685}, CountryId{"RU"}}, // Belaya
    {Coordinate{103.492, 52.8538}, CountryId{"RU"}}, // Q113611710
    {Coordinate{103.523, 52.8261}, CountryId{"RU"}}, // Malta
    {Coordinate{103.576, 52.7896}, CountryId{"RU"}}, // Q113611713
    {Coordinate{103.595, 52.7741}, CountryId{"RU"}}, // Q113611714
    {Coordinate{103.622, 52.7535}, CountryId{"RU"}}, // Q113611715
    {Coordinate{103.691, 52.6911}, CountryId{"RU"}}, // Q113611716
    {Coordinate{103.731, 52.6673}, CountryId{"RU"}}, // Q113611718
    {Coordinate{103.846, 52.612}, CountryId{"RU"}}, // Q113611719
    {Coordinate{102.241, 53.7542}, CountryId{"RU"}}, // Q113611723
    {Coordinate{103.899, 52.5755}, CountryId{"RU"}}, // Q113612533
    {Coordinate{103.928, 52.528}, CountryId{"RU"}}, // Q113612534
    {Coordinate{103.987, 52.4816}, CountryId{"RU"}}, // Q113612536
    {Coordinate{104.03, 52.4582}, CountryId{"RU"}}, // Q113612537
    {Coordinate{104.056, 52.4203}, CountryId{"RU"}}, // Q113612538
    {Coordinate{104.092, 52.4038}, CountryId{"RU"}}, // Q113612539
    {Coordinate{104.118, 52.3948}, CountryId{"RU"}}, // Q113612540
    {Coordinate{104.118, 52.3948}, CountryId{"RU"}}, // Q113612541
    {Coordinate{104.168, 52.3702}, CountryId{"RU"}}, // Q113612542
    {Coordinate{104.18, 52.3619}, CountryId{"RU"}}, // Q113612543
    {Coordinate{104.202, 52.3462}, CountryId{"RU"}}, // Q113612544
    {Coordinate{104.247, 52.2941}, CountryId{"RU"}}, // Q113612545
    {Coordinate{98.1085, 55.9569}, CountryId{"RU"}}, // Q113636549
    {Coordinate{98.2078, 56.0186}, CountryId{"RU"}}, // Q113636551
    {Coordinate{98.2399, 56.0492}, CountryId{"RU"}}, // Q113636552
    {Coordinate{98.2819, 56.1034}, CountryId{"RU"}}, // Q113636554
    {Coordinate{98.4033, 56.1698}, CountryId{"RU"}}, // Q113636556
    {Coordinate{98.4268, 56.1427}, CountryId{"RU"}}, // Q113636557
    {Coordinate{98.488, 56.1182}, CountryId{"RU"}}, // Q113636559
    {Coordinate{98.538, 56.1185}, CountryId{"RU"}}, // Q113636560
    {Coordinate{98.6207, 56.1473}, CountryId{"RU"}}, // Q113636561
    {Coordinate{98.7198, 56.1752}, CountryId{"RU"}}, // Q113636562
    {Coordinate{99.0305, 56.1633}, CountryId{"RU"}}, // Q113636563
    {Coordinate{99.1493, 56.1628}, CountryId{"RU"}}, // Q113636566
    {Coordinate{99.1846, 56.159}, CountryId{"RU"}}, // Q113636567
    {Coordinate{99.2753, 56.116}, CountryId{"RU"}}, // Q113636568
    {Coordinate{99.3066, 56.1034}, CountryId{"RU"}}, // Q113636569
    {Coordinate{99.3608, 56.0837}, CountryId{"RU"}}, // Q113636570
    {Coordinate{99.3911, 56.0814}, CountryId{"RU"}}, // Q113636571
    {Coordinate{99.445, 56.0667}, CountryId{"RU"}}, // Q113636572
    {Coordinate{99.5487, 56.0707}, CountryId{"RU"}}, // Q113636574
    {Coordinate{99.6383, 56.0831}, CountryId{"RU"}}, // Q113636575
    {Coordinate{99.6655, 56.0852}, CountryId{"RU"}}, // Q113636576
    {Coordinate{99.7712, 56.1242}, CountryId{"RU"}}, // Q113636577
    {Coordinate{99.8246, 56.1525}, CountryId{"RU"}}, // Q113636579
    {Coordinate{99.9452, 56.1705}, CountryId{"RU"}}, // Q113636582
    {Coordinate{100.238, 56.1222}, CountryId{"RU"}}, // Q113636583
    {Coordinate{100.258, 56.1337}, CountryId{"RU"}}, // Q113636584
    {Coordinate{100.431, 56.2475}, CountryId{"RU"}}, // Q113636585
    {Coordinate{100.77, 56.2331}, CountryId{"RU"}}, // Q113636587
    {Coordinate{100.882, 56.191}, CountryId{"RU"}}, // Q113636589
    {Coordinate{101.021, 56.1438}, CountryId{"RU"}}, // Q113636590
    {Coordinate{101.169, 56.1179}, CountryId{"RU"}}, // Vikhorevka railway station
    {Coordinate{101.193, 56.1137}, CountryId{"RU"}}, // Q113636592
    {Coordinate{101.21, 56.1106}, CountryId{"RU"}}, // Q113636593
    {Coordinate{101.264, 56.1005}, CountryId{"RU"}}, // Q113636594
    {Coordinate{101.368, 56.1287}, CountryId{"RU"}}, // Q113636595
    {Coordinate{101.476, 56.1524}, CountryId{"RU"}}, // Q113636596
    {Coordinate{101.589, 56.225}, CountryId{"RU"}}, // Q113636597
    {Coordinate{101.692, 56.3021}, CountryId{"RU"}}, // Q113636598
    {Coordinate{101.724, 56.3083}, CountryId{"RU"}}, // Q113636600
    {Coordinate{101.75, 56.3019}, CountryId{"RU"}}, // Q113636601
    {Coordinate{101.895, 56.2742}, CountryId{"RU"}}, // Q113636602
    {Coordinate{102.053, 56.2931}, CountryId{"RU"}}, // Q113636603
    {Coordinate{102.12, 56.3808}, CountryId{"RU"}}, // Q113636604
    {Coordinate{102.251, 56.4413}, CountryId{"RU"}}, // Q113636605
    {Coordinate{102.44, 56.5621}, CountryId{"RU"}}, // Q113636606
    {Coordinate{102.634, 56.575}, CountryId{"RU"}}, // Q113636607
    {Coordinate{102.872, 56.5264}, CountryId{"RU"}}, // Q113636608
    {Coordinate{103.111, 56.4049}, CountryId{"RU"}}, // Q113636610
    {Coordinate{103.64, 56.4143}, CountryId{"RU"}}, // Q113636611
    {Coordinate{103.913, 56.3943}, CountryId{"RU"}}, // Q113636613
    {Coordinate{103.925, 56.4147}, CountryId{"RU"}}, // Q113636614
    {Coordinate{103.951, 56.4725}, CountryId{"RU"}}, // Q113636615
    {Coordinate{103.954, 56.487}, CountryId{"RU"}}, // Q113636616
    {Coordinate{103.964, 56.4981}, CountryId{"RU"}}, // Q113636617
    {Coordinate{104.415, 56.7261}, CountryId{"RU"}}, // Q113636619
    {Coordinate{104.669, 56.6885}, CountryId{"RU"}}, // Q113636620
    {Coordinate{104.719, 56.7625}, CountryId{"RU"}}, // Q113636621
    {Coordinate{104.935, 56.8325}, CountryId{"RU"}}, // Q113636622
    {Coordinate{104.935, 56.8325}, CountryId{"RU"}}, // Q113636624
    {Coordinate{105.25, 56.8431}, CountryId{"RU"}}, // Q113636625
    {Coordinate{105.275, 56.8272}, CountryId{"RU"}}, // Q113636627
    {Coordinate{105.284, 56.8082}, CountryId{"RU"}}, // Q113636628
    {Coordinate{105.369, 56.7495}, CountryId{"RU"}}, // Q113636630
    {Coordinate{105.401, 56.7373}, CountryId{"RU"}}, // Q113636631
    {Coordinate{105.436, 56.7469}, CountryId{"RU"}}, // Q113636632
    {Coordinate{105.461, 56.7429}, CountryId{"RU"}}, // Q113636633
    {Coordinate{105.496, 56.7298}, CountryId{"RU"}}, // Q113636634
    {Coordinate{105.533, 56.7464}, CountryId{"RU"}}, // Q113636635
    {Coordinate{105.553, 56.7709}, CountryId{"RU"}}, // Q113636636
    {Coordinate{105.582, 56.7922}, CountryId{"RU"}}, // Q113636637
    {Coordinate{105.647, 56.7675}, CountryId{"RU"}}, // Q113636638
    {Coordinate{98.3128, 56.1669}, CountryId{"RU"}}, // Q113636749
    {Coordinate{99.1194, 56.1763}, CountryId{"RU"}}, // Q113636750
    {Coordinate{99.7975, 56.1333}, CountryId{"RU"}}, // Q113636751
    {Coordinate{100.06, 56.1323}, CountryId{"RU"}}, // Q113636752
    {Coordinate{100.619, 56.2754}, CountryId{"RU"}}, // Q113636753
    {Coordinate{101.657, 56.2695}, CountryId{"RU"}}, // Q113638926
    {Coordinate{103.347, 56.4283}, CountryId{"RU"}}, // Q113638929
    {Coordinate{103.947, 56.4596}, CountryId{"RU"}}, // Q113639130
    {Coordinate{104.895, 56.8306}, CountryId{"RU"}}, // Q113639132
    {Coordinate{105.794, 56.7992}, CountryId{"RU"}}, // Q113639135
    {Coordinate{101.613, 56.1466}, CountryId{"RU"}}, // Novobratsk railway station
    {Coordinate{101.429, 56.1328}, CountryId{"RU"}}, // Q113639498
    {Coordinate{101.446, 56.1244}, CountryId{"RU"}}, // Q113639499
    {Coordinate{101.457, 56.1163}, CountryId{"RU"}}, // Q113639500
    {Coordinate{101.545, 56.1219}, CountryId{"RU"}}, // Q113639501
    {Coordinate{106.807, 56.5584}, CountryId{"RU"}}, // Q113639601
    {Coordinate{106.229, 56.8442}, CountryId{"RU"}}, // Q113640030
    {Coordinate{106.71, 56.6806}, CountryId{"RU"}}, // Q113640031
    {Coordinate{106.845, 56.4663}, CountryId{"RU"}}, // Q113640032
    {Coordinate{107.257, 56.3106}, CountryId{"RU"}}, // Q113640033
    {Coordinate{107.339, 56.2465}, CountryId{"RU"}}, // Q113640034
    {Coordinate{4.44642, 43.8563}, CountryId{"FR"}}, // Gare de Marguerittes
    {Coordinate{108.007, 55.8539}, CountryId{"RU"}}, // Q113655226
    {Coordinate{108.142, 55.7991}, CountryId{"RU"}}, // Q113655227
    {Coordinate{108.671, 55.7523}, CountryId{"RU"}}, // Q113655229
    {Coordinate{108.752, 55.7617}, CountryId{"RU"}}, // Q113655230
    {Coordinate{109.313, 55.7359}, CountryId{"RU"}}, // Q113655232
    {Coordinate{109.316, 55.6295}, CountryId{"RU"}}, // Q113655233
    {Coordinate{116.425, 56.3895}, CountryId{"RU"}}, // Q113655923
    {Coordinate{116.871, 56.4675}, CountryId{"RU"}}, // Q113655924
    {Coordinate{117.14, 56.528}, CountryId{"RU"}}, // Q113655926
    {Coordinate{117.298, 56.5889}, CountryId{"RU"}}, // Q113655927
    {Coordinate{117.704, 56.6822}, CountryId{"RU"}}, // Q113655928
    {Coordinate{117.971, 56.7414}, CountryId{"RU"}}, // Q113655929
    {Coordinate{131.16, 34.0533}, CountryId{"JP"}}, // Asa Station
    {Coordinate{104.116, 52.228}, CountryId{"RU"}}, // Q113660133
    {Coordinate{104.107, 52.182}, CountryId{"RU"}}, // Q113664497
    {Coordinate{104.107, 52.1628}, CountryId{"RU"}}, // Q113664498
    {Coordinate{104.075, 52.1539}, CountryId{"RU"}}, // Q113664499
    {Coordinate{104.07, 52.1379}, CountryId{"RU"}}, // Q113664501
    {Coordinate{104.084, 52.1222}, CountryId{"RU"}}, // Q113664502
    {Coordinate{104.104, 52.1119}, CountryId{"RU"}}, // Q113664503
    {Coordinate{104.076, 52.0528}, CountryId{"RU"}}, // Q113664504
    {Coordinate{104.081, 52.0295}, CountryId{"RU"}}, // Q113664505
    {Coordinate{104.086, 52.0124}, CountryId{"RU"}}, // Q113664506
    {Coordinate{104.055, 52.0096}, CountryId{"RU"}}, // Q113664507
    {Coordinate{104.043, 52.0123}, CountryId{"RU"}}, // Q113664508
    {Coordinate{104.018, 52.0122}, CountryId{"RU"}}, // Q113664509
    {Coordinate{104.001, 51.998}, CountryId{"RU"}}, // Q113664510
    {Coordinate{103.985, 51.9922}, CountryId{"RU"}}, // Q113664511
    {Coordinate{103.961, 51.9968}, CountryId{"RU"}}, // Q113664512
    {Coordinate{103.948, 51.9864}, CountryId{"RU"}}, // Q113664513
    {Coordinate{103.907, 51.9678}, CountryId{"RU"}}, // Q113664514
    {Coordinate{103.884, 51.9467}, CountryId{"RU"}}, // Q113664515
    {Coordinate{103.889, 51.9245}, CountryId{"RU"}}, // Q113664516
    {Coordinate{103.884, 51.9031}, CountryId{"RU"}}, // Q113664517
    {Coordinate{103.856, 51.879}, CountryId{"RU"}}, // Q113664518
    {Coordinate{12.3083, 45.442}, CountryId{"IT"}}, // Tronchetto
    {Coordinate{21.908, 55.132}, CountryId{"LT"}}, // Pagėgiai train station
    {Coordinate{108.016, 51.908}, CountryId{"RU"}}, // Q113674700
    {Coordinate{108.185, 51.9109}, CountryId{"RU"}}, // Q113674701
    {Coordinate{108.222, 51.9003}, CountryId{"RU"}}, // Q113674702
    {Coordinate{103.165, 57.7985}, CountryId{"RU"}}, // Q113675019
    {Coordinate{103.289, 57.6455}, CountryId{"RU"}}, // Q113675020
    {Coordinate{103.435, 57.5797}, CountryId{"RU"}}, // Q113675021
    {Coordinate{103.763, 57.2749}, CountryId{"RU"}}, // Q113675022
    {Coordinate{103.892, 57.1273}, CountryId{"RU"}}, // Q113675023
    {Coordinate{104.056, 57.0019}, CountryId{"RU"}}, // Q113675024
    {Coordinate{104.252, 56.8531}, CountryId{"RU"}}, // Q113675025
    {Coordinate{107.261, 51.5203}, CountryId{"RU"}}, // Q113675418
    {Coordinate{108.831, 51.2511}, CountryId{"RU"}}, // Q113678272
    {Coordinate{108.853, 51.2216}, CountryId{"RU"}}, // Q113678273
    {Coordinate{108.868, 51.1944}, CountryId{"RU"}}, // Q113678274
    {Coordinate{108.902, 51.1759}, CountryId{"RU"}}, // Q113678275
    {Coordinate{109.033, 51.1523}, CountryId{"RU"}}, // Q113678276
    {Coordinate{109.188, 51.2098}, CountryId{"RU"}}, // Q113678277
    {Coordinate{109.287, 51.2074}, CountryId{"RU"}}, // Q113678278
    {Coordinate{109.421, 51.234}, CountryId{"RU"}}, // Q113678279
    {Coordinate{109.469, 51.2307}, CountryId{"RU"}}, // Q113678280
    {Coordinate{109.642, 51.3191}, CountryId{"RU"}}, // Q113678281
    {Coordinate{109.703, 51.3427}, CountryId{"RU"}}, // Q113678282
    {Coordinate{109.74, 51.3564}, CountryId{"RU"}}, // Q113678283
    {Coordinate{109.791, 51.3754}, CountryId{"RU"}}, // Q113678284
    {Coordinate{109.971, 51.4041}, CountryId{"RU"}}, // Q113678286
    {Coordinate{110.049, 51.4211}, CountryId{"RU"}}, // Q113678287
    {Coordinate{110.266, 51.4339}, CountryId{"RU"}}, // Q113678288
    {Coordinate{110.543, 51.3739}, CountryId{"RU"}}, // Q113678289
    {Coordinate{110.808, 51.4156}, CountryId{"RU"}}, // Q113678290
    {Coordinate{111.059, 51.489}, CountryId{"RU"}}, // Q113678291
    {Coordinate{111.291, 51.611}, CountryId{"RU"}}, // Q113678292
    {Coordinate{111.567, 51.6624}, CountryId{"RU"}}, // Q113678293
    {Coordinate{111.794, 51.6927}, CountryId{"RU"}}, // Q113678294
    {Coordinate{112.684, 51.8548}, CountryId{"RU"}}, // Q113678295
    {Coordinate{112.916, 51.7992}, CountryId{"RU"}}, // Q113678296
    {Coordinate{113.003, 51.8019}, CountryId{"RU"}}, // Q113679238
    {Coordinate{113.255, 51.991}, CountryId{"RU"}}, // Q113679239
    {Coordinate{113.28, 51.996}, CountryId{"RU"}}, // Q113679240
    {Coordinate{113.417, 52.0354}, CountryId{"RU"}}, // Q113679241
    {Coordinate{113.56, 51.9831}, CountryId{"RU"}}, // Q113679242
    {Coordinate{113.608, 51.9448}, CountryId{"RU"}}, // Q113679243
    {Coordinate{113.645, 51.9092}, CountryId{"RU"}}, // Q113679244
    {Coordinate{113.65, 51.8835}, CountryId{"RU"}}, // Q113679245
    {Coordinate{113.659, 51.8744}, CountryId{"RU"}}, // Q113679246
    {Coordinate{113.678, 51.8638}, CountryId{"RU"}}, // Q113679247
    {Coordinate{113.717, 51.8485}, CountryId{"RU"}}, // Q113679249
    {Coordinate{113.748, 51.8367}, CountryId{"RU"}}, // Q113679250
    {Coordinate{113.744, 51.7767}, CountryId{"RU"}}, // Q113679251
    {Coordinate{113.826, 51.7557}, CountryId{"RU"}}, // Q113679252
    {Coordinate{113.848, 51.7444}, CountryId{"RU"}}, // Q113679254
    {Coordinate{113.918, 51.7569}, CountryId{"RU"}}, // Q113679255
    {Coordinate{113.988, 51.6977}, CountryId{"RU"}}, // Q113679256
    {Coordinate{114.02, 51.6435}, CountryId{"RU"}}, // Q113679257
    {Coordinate{114.088, 51.6301}, CountryId{"RU"}}, // Q113679258
    {Coordinate{114.255, 51.6132}, CountryId{"RU"}}, // Q113679259
    {Coordinate{114.32, 51.6223}, CountryId{"RU"}}, // Q113679260
    {Coordinate{115.867, 51.7757}, CountryId{"RU"}}, // Q113680349
    {Coordinate{114.439, 51.6199}, CountryId{"RU"}}, // Q113680515
    {Coordinate{114.533, 51.6229}, CountryId{"RU"}}, // Q113680516
    {Coordinate{114.565, 51.632}, CountryId{"RU"}}, // Q113680517
    {Coordinate{114.576, 51.6548}, CountryId{"RU"}}, // Q113680518
    {Coordinate{114.69, 51.6788}, CountryId{"RU"}}, // Q113680519
    {Coordinate{114.755, 51.715}, CountryId{"RU"}}, // Q113680520
    {Coordinate{114.974, 51.7492}, CountryId{"RU"}}, // Q113680521
    {Coordinate{115.186, 51.7738}, CountryId{"RU"}}, // Q113680522
    {Coordinate{115.322, 51.8024}, CountryId{"RU"}}, // Q113680523
    {Coordinate{115.385, 51.7849}, CountryId{"RU"}}, // Q113680524
    {Coordinate{115.588, 51.7685}, CountryId{"RU"}}, // Q113680525
    {Coordinate{115.858, 51.7615}, CountryId{"RU"}}, // Q113680526
    {Coordinate{115.949, 51.8233}, CountryId{"RU"}}, // Q113680527
    {Coordinate{116.151, 51.8879}, CountryId{"RU"}}, // Q113680529
    {Coordinate{116.314, 51.8825}, CountryId{"RU"}}, // Q113680531
    {Coordinate{116.359, 51.8534}, CountryId{"RU"}}, // Q113680532
    {Coordinate{116.441, 51.8554}, CountryId{"RU"}}, // Q113680533
    {Coordinate{116.477, 51.8679}, CountryId{"RU"}}, // Q113680534
    {Coordinate{116.769, 51.9593}, CountryId{"RU"}}, // Q113680779
    {Coordinate{116.833, 51.9796}, CountryId{"RU"}}, // Q113680780
    {Coordinate{117.695, 52.251}, CountryId{"RU"}}, // Q113681814
    {Coordinate{117.083, 52.0719}, CountryId{"RU"}}, // Q113681847
    {Coordinate{117.235, 52.0818}, CountryId{"RU"}}, // Q113681848
    {Coordinate{117.303, 52.1043}, CountryId{"RU"}}, // Q113681849
    {Coordinate{117.36, 52.1243}, CountryId{"RU"}}, // Q113681850
    {Coordinate{117.457, 52.1621}, CountryId{"RU"}}, // Q113681851
    {Coordinate{117.57, 52.2131}, CountryId{"RU"}}, // Q113681853
    {Coordinate{117.628, 52.214}, CountryId{"RU"}}, // Q113681854
    {Coordinate{117.663, 52.2205}, CountryId{"RU"}}, // Q113681855
    {Coordinate{117.676, 52.2305}, CountryId{"RU"}}, // Q113681856
    {Coordinate{117.019, 52.3456}, CountryId{"RU"}}, // Ukurey railway station
    {Coordinate{117.93, 53.1565}, CountryId{"RU"}}, // Q113686089
    {Coordinate{118.51, 53.3118}, CountryId{"RU"}}, // Q113686092
    {Coordinate{119.288, 53.7799}, CountryId{"RU"}}, // Q113686099
    {Coordinate{117.029, 52.0902}, CountryId{"RU"}}, // Q113688186
    {Coordinate{117.055, 52.1234}, CountryId{"RU"}}, // Q113688187
    {Coordinate{117.013, 52.2987}, CountryId{"RU"}}, // Q113688188
    {Coordinate{117.022, 52.4629}, CountryId{"RU"}}, // Q113688189
    {Coordinate{117.004, 52.5015}, CountryId{"RU"}}, // Q113688190
    {Coordinate{117.155, 52.6484}, CountryId{"RU"}}, // Q113688191
    {Coordinate{117.657, 53.0861}, CountryId{"RU"}}, // Q113688192
    {Coordinate{118.389, 53.2642}, CountryId{"RU"}}, // Q113688193
    {Coordinate{118.446, 53.2818}, CountryId{"RU"}}, // Q113688194
    {Coordinate{118.517, 53.3963}, CountryId{"RU"}}, // Q113688196
    {Coordinate{119.221, 53.7765}, CountryId{"RU"}}, // Q113688197
    {Coordinate{119.286, 53.7862}, CountryId{"RU"}}, // Q113688199
    {Coordinate{122.91, 54.0335}, CountryId{"RU"}}, // Q113702428
    {Coordinate{123.134, 54.032}, CountryId{"RU"}}, // Q113702429
    {Coordinate{123.523, 54.0846}, CountryId{"RU"}}, // Q113702431
    {Coordinate{123.591, 54.1111}, CountryId{"RU"}}, // Q113702432
    {Coordinate{116.913, 52.9772}, CountryId{"RU"}}, // Q113702818
    {Coordinate{117.026, 52.5292}, CountryId{"RU"}}, // Q113703147
    {Coordinate{117.021, 52.5358}, CountryId{"RU"}}, // Q113703148
    {Coordinate{116.987, 52.5835}, CountryId{"RU"}}, // Q113703149
    {Coordinate{116.921, 52.6573}, CountryId{"RU"}}, // Q113703151
    {Coordinate{116.896, 52.7079}, CountryId{"RU"}}, // Q113703152
    {Coordinate{116.852, 52.7661}, CountryId{"RU"}}, // Q113703154
    {Coordinate{116.728, 52.8202}, CountryId{"RU"}}, // Q113703155
    {Coordinate{116.817, 52.9216}, CountryId{"RU"}}, // Q113703156
    {Coordinate{116.895, 52.9477}, CountryId{"RU"}}, // Q113703158
    {Coordinate{114.518, 51.5668}, CountryId{"RU"}}, // Q113708684
    {Coordinate{114.539, 51.4941}, CountryId{"RU"}}, // Q113708685
    {Coordinate{114.633, 51.4665}, CountryId{"RU"}}, // Q113708687
    {Coordinate{114.712, 51.4476}, CountryId{"RU"}}, // Q113708688
    {Coordinate{114.825, 51.3911}, CountryId{"RU"}}, // Q113708690
    {Coordinate{114.924, 51.2812}, CountryId{"RU"}}, // Q113708691
    {Coordinate{115.052, 51.2083}, CountryId{"RU"}}, // Q113708692
    {Coordinate{115.196, 51.0939}, CountryId{"RU"}}, // Q113708695
    {Coordinate{115.34, 51.0345}, CountryId{"RU"}}, // Q113708696
    {Coordinate{115.394, 51.0034}, CountryId{"RU"}}, // Q113708697
    {Coordinate{115.461, 50.9684}, CountryId{"RU"}}, // Q113708698
    {Coordinate{115.587, 50.9441}, CountryId{"RU"}}, // Q113708699
    {Coordinate{115.687, 50.8686}, CountryId{"RU"}}, // Q113708700
    {Coordinate{115.785, 50.8267}, CountryId{"RU"}}, // Q113708701
    {Coordinate{115.951, 50.7404}, CountryId{"RU"}}, // Q113708702
    {Coordinate{116.051, 50.7472}, CountryId{"RU"}}, // Q113708703
    {Coordinate{116.177, 50.7324}, CountryId{"RU"}}, // Q113708705
    {Coordinate{116.301, 50.6462}, CountryId{"RU"}}, // Q113708706
    {Coordinate{116.349, 50.5787}, CountryId{"RU"}}, // Q113708707
    {Coordinate{116.385, 50.5181}, CountryId{"RU"}}, // Q113708708
    {Coordinate{-6.09485, 36.9117}, CountryId{"ES"}}, // Q113750085
    {Coordinate{123.765, 54.112}, CountryId{"RU"}}, // Gorely railway station
    {Coordinate{123.937, 53.987}, CountryId{"RU"}}, // Q113785689
    {Coordinate{124.144, 53.9787}, CountryId{"RU"}}, // Q113785690
    {Coordinate{124.198, 53.8974}, CountryId{"RU"}}, // Q113785692
    {Coordinate{124.211, 53.8418}, CountryId{"RU"}}, // Q113785693
    {Coordinate{124.412, 53.8268}, CountryId{"RU"}}, // Q113785694
    {Coordinate{124.532, 53.7311}, CountryId{"RU"}}, // Q113785695
    {Coordinate{124.823, 53.6935}, CountryId{"RU"}}, // Q113785696
    {Coordinate{125.236, 53.687}, CountryId{"RU"}}, // Gudachi railway station
    {Coordinate{125.379, 53.5821}, CountryId{"RU"}}, // Q113785699
    {Coordinate{125.585, 53.5302}, CountryId{"RU"}}, // Q113785700
    {Coordinate{126.014, 53.4457}, CountryId{"RU"}}, // Q113785701
    {Coordinate{126.124, 53.3817}, CountryId{"RU"}}, // Q113785703
    {Coordinate{126.171, 53.3361}, CountryId{"RU"}}, // Q113785705
    {Coordinate{126.205, 53.2574}, CountryId{"RU"}}, // Q113785707
    {Coordinate{126.432, 52.9517}, CountryId{"RU"}}, // Q113785711
    {Coordinate{126.54, 52.788}, CountryId{"RU"}}, // Q113785712
    {Coordinate{126.966, 52.4676}, CountryId{"RU"}}, // Q113785715
    {Coordinate{126.333, 53.1128}, CountryId{"RU"}}, // Q113785769
    {Coordinate{127.213, 52.2727}, CountryId{"RU"}}, // Q113785770
    {Coordinate{127.468, 52.1626}, CountryId{"RU"}}, // Q113787348
    {Coordinate{127.572, 52.0854}, CountryId{"RU"}}, // Q113787349
    {Coordinate{127.683, 52.0035}, CountryId{"RU"}}, // Q113787350
    {Coordinate{128.146, 51.6505}, CountryId{"RU"}}, // Q113787351
    {Coordinate{128.138, 51.3925}, CountryId{"RU"}}, // Svobodny railway station
    {Coordinate{128.243, 51.2764}, CountryId{"RU"}}, // Q113787353
    {Coordinate{128.38, 51.0916}, CountryId{"RU"}}, // Seryshevo railway station
    {Coordinate{128.241, 50.7804}, CountryId{"RU"}}, // Q113790080
    {Coordinate{128.009, 50.6602}, CountryId{"RU"}}, // Q113790082
    {Coordinate{127.867, 50.5704}, CountryId{"RU"}}, // Q113790083
    {Coordinate{127.651, 50.5081}, CountryId{"RU"}}, // Q113790085
    {Coordinate{127.698, 50.4457}, CountryId{"RU"}}, // Q113790086
    {Coordinate{128.718, 50.733}, CountryId{"RU"}}, // Q113791838
    {Coordinate{128.89, 50.5889}, CountryId{"RU"}}, // Q113791839
    {Coordinate{129.105, 50.3723}, CountryId{"RU"}}, // Q113791840
    {Coordinate{129.451, 50.1171}, CountryId{"RU"}}, // Q113791841
    {Coordinate{129.811, 49.8111}, CountryId{"RU"}}, // Q113791843
    {Coordinate{116.687, 50.1177}, CountryId{"RU"}}, // Kharanor railway station
    {Coordinate{116.842, 49.9289}, CountryId{"RU"}}, // Dauriya railway station
    {Coordinate{117.094, 49.8342}, CountryId{"RU"}}, // Bilyutuj railway station
    {Coordinate{119.081, 50.3686}, CountryId{"RU"}}, // Priargunsk railway station
    {Coordinate{117.069, 50.1594}, CountryId{"RU"}}, // Q113818398
    {Coordinate{117.606, 50.3835}, CountryId{"RU"}}, // Q113818399
    {Coordinate{117.896, 50.4046}, CountryId{"RU"}}, // Q113818400
    {Coordinate{118.118, 50.2674}, CountryId{"RU"}}, // Urulyunguy railway station
    {Coordinate{118.356, 50.274}, CountryId{"RU"}}, // Q113818402
    {Coordinate{118.443, 50.332}, CountryId{"RU"}}, // Q113818403
    {Coordinate{118.629, 50.3976}, CountryId{"RU"}}, // Q113818404
    {Coordinate{118.061, 50.1493}, CountryId{"RU"}}, // Q113818578
    {Coordinate{121.885, 56.5628}, CountryId{"RU"}}, // Q113832876
    {Coordinate{121.974, 56.39}, CountryId{"RU"}}, // Q113832877
    {Coordinate{122.144, 56.1947}, CountryId{"RU"}}, // Unkur railway passing loop
    {Coordinate{122.623, 55.9086}, CountryId{"RU"}}, // Q113832880
    {Coordinate{122.868, 55.6382}, CountryId{"RU"}}, // Q113832882
    {Coordinate{123.469, 55.501}, CountryId{"RU"}}, // Loembir
    {Coordinate{124.051, 55.3012}, CountryId{"RU"}}, // Koetikan
    {Coordinate{124.547, 55.1445}, CountryId{"RU"}}, // Koerjan
    {Coordinate{5.34833, 45.9075}, CountryId{"FR"}}, // Q113836000
    {Coordinate{12.339, 47.8358}, CountryId{"DE"}}, // Urschalling station
    {Coordinate{12.3217, 47.8268}, CountryId{"DE"}}, // Q113840294
    {Coordinate{12.327, 47.8057}, CountryId{"DE"}}, // Umrathshausen Ort station
    {Coordinate{125.04, 55.2553}, CountryId{"RU"}}, // Bestoezjevo
    {Coordinate{132.61, 51.078}, CountryId{"RU"}}, // Noviy Oergal
    {Coordinate{125.268, 55.3037}, CountryId{"RU"}}, // Dzjelingra
    {Coordinate{125.622, 55.2794}, CountryId{"RU"}}, // Amoet
    {Coordinate{125.894, 55.3124}, CountryId{"RU"}}, // Marevaja
    {Coordinate{126.19, 55.2364}, CountryId{"RU"}}, // Zmeyka
    {Coordinate{126.332, 55.1999}, CountryId{"RU"}}, // Koedoeli
    {Coordinate{126.586, 55.1491}, CountryId{"RU"}}, // Oenacha
    {Coordinate{126.787, 55.1311}, CountryId{"RU"}}, // Q113882553
    {Coordinate{126.959, 55.1306}, CountryId{"RU"}}, // Dess
    {Coordinate{127.268, 55.0744}, CountryId{"RU"}}, // Oetsjoegey
    {Coordinate{127.461, 55.0249}, CountryId{"RU"}}, // Toetaoel
    {Coordinate{127.599, 54.9194}, CountryId{"RU"}}, // Klepikovo
    {Coordinate{127.719, 54.8774}, CountryId{"RU"}}, // Q113882560
    {Coordinate{127.938, 54.7836}, CountryId{"RU"}}, // Imeni Generala Milko
    {Coordinate{128.074, 54.7943}, CountryId{"RU"}}, // Moelmoega
    {Coordinate{128.466, 54.7046}, CountryId{"RU"}}, // Oelak
    {Coordinate{128.541, 54.6196}, CountryId{"RU"}}, // Verchnezeysk
    {Coordinate{129.142, 53.9593}, CountryId{"RU"}}, // Ogoron
    {Coordinate{129.996, 53.3528}, CountryId{"RU"}}, // Doegda
    {Coordinate{130.197, 53.1757}, CountryId{"RU"}}, // Nora
    {Coordinate{130.341, 53.0224}, CountryId{"RU"}}, // Meoen
    {Coordinate{130.417, 52.8795}, CountryId{"RU"}}, // Q113882569
    {Coordinate{130.619, 52.7059}, CountryId{"RU"}}, // Skalistiy
    {Coordinate{130.739, 52.5675}, CountryId{"RU"}}, // Tsjervinka
    {Coordinate{130.911, 52.2962}, CountryId{"RU"}}, // Zvonkoe
    {Coordinate{130.934, 52.0852}, CountryId{"RU"}}, // Demtsjenko
    {Coordinate{131.003, 51.9089}, CountryId{"RU"}}, // Isakan
    {Coordinate{131.026, 51.7534}, CountryId{"RU"}}, // Isa
    {Coordinate{131.174, 51.6372}, CountryId{"RU"}}, // Moestach
    {Coordinate{131.366, 51.5334}, CountryId{"RU"}}, // Q113883684
    {Coordinate{131.528, 51.5186}, CountryId{"RU"}}, // Etirken
    {Coordinate{131.72, 51.4397}, CountryId{"RU"}}, // Amgan
    {Coordinate{131.899, 51.4101}, CountryId{"RU"}}, // Sjoegara
    {Coordinate{132.068, 51.3608}, CountryId{"RU"}}, // Toejun
    {Coordinate{132.326, 51.388}, CountryId{"RU"}}, // Stlanik
    {Coordinate{132.444, 51.3676}, CountryId{"RU"}}, // Q113883692
    {Coordinate{132.46, 51.2692}, CountryId{"RU"}}, // Kitsjiranki
    {Coordinate{132.44, 51.2105}, CountryId{"RU"}}, // Tsjebangda
    {Coordinate{132.479, 51.1304}, CountryId{"RU"}}, // Boereinsk
    {Coordinate{132.752, 51.0824}, CountryId{"RU"}}, // Oergal I
    {Coordinate{132.946, 51.1315}, CountryId{"RU"}}, // Tsjegdomin
    {Coordinate{136.905, 50.4461}, CountryId{"RU"}}, // Komsomolsk-Sortirovotsjniy
    {Coordinate{133.227, 50.8251}, CountryId{"RU"}}, // Soloni
    {Coordinate{133.419, 50.7471}, CountryId{"RU"}}, // Doesse-Alin
    {Coordinate{133.592, 50.6547}, CountryId{"RU"}}, // Soeloek
    {Coordinate{133.798, 50.5922}, CountryId{"RU"}}, // Mogdi
    {Coordinate{134.121, 50.8032}, CountryId{"RU"}}, // Gerbi
    {Coordinate{134.397, 50.9274}, CountryId{"RU"}}, // Oerkaltoe
    {Coordinate{134.646, 51.1202}, CountryId{"RU"}}, // Dzjamkoe
    {Coordinate{134.853, 51.3235}, CountryId{"RU"}}, // Eanga
    {Coordinate{135.098, 51.4171}, CountryId{"RU"}}, // Amgoen
    {Coordinate{135.321, 51.4499}, CountryId{"RU"}}, // Sonach
    {Coordinate{135.478, 51.5548}, CountryId{"RU"}}, // Ebgoen
    {Coordinate{135.679, 51.6645}, CountryId{"RU"}}, // Postisjevo
    {Coordinate{135.883, 51.5643}, CountryId{"RU"}}, // Bolen
    {Coordinate{136.128, 51.4727}, CountryId{"RU"}}, // Moni
    {Coordinate{136.338, 51.3961}, CountryId{"RU"}}, // Evoron
    {Coordinate{136.539, 51.273}, CountryId{"RU"}}, // Harpitsjan
    {Coordinate{136.67, 51.2041}, CountryId{"RU"}}, // Gorin
    {Coordinate{136.878, 51.085}, CountryId{"RU"}}, // Mavrinskiy
    {Coordinate{136.899, 51.0078}, CountryId{"RU"}}, // Hoermoeli
    {Coordinate{136.937, 50.8214}, CountryId{"RU"}}, // Lian
    {Coordinate{136.901, 50.6981}, CountryId{"RU"}}, // Halgaso
    {Coordinate{136.92, 50.6451}, CountryId{"RU"}}, // Silinka
    {Coordinate{137.091, 50.4816}, CountryId{"RU"}}, // Q113907716
    {Coordinate{137.23, 50.3713}, CountryId{"RU"}}, // Q113907717
    {Coordinate{137.379, 50.3841}, CountryId{"RU"}}, // Q113907718
    {Coordinate{137.636, 50.3428}, CountryId{"RU"}}, // Q113907719
    {Coordinate{137.791, 50.266}, CountryId{"RU"}}, // Q113907721
    {Coordinate{137.915, 50.267}, CountryId{"RU"}}, // Q113907722
    {Coordinate{138.103, 50.3187}, CountryId{"RU"}}, // Q113907723
    {Coordinate{138.254, 50.355}, CountryId{"RU"}}, // Q113907724
    {Coordinate{138.447, 50.3395}, CountryId{"RU"}}, // Q113907725
    {Coordinate{138.484, 50.2784}, CountryId{"RU"}}, // Q113907726
    {Coordinate{138.593, 50.2004}, CountryId{"RU"}}, // Q113907727
    {Coordinate{138.855, 50.2057}, CountryId{"RU"}}, // Q113907729
    {Coordinate{139.125, 50.1004}, CountryId{"RU"}}, // Q113907731
    {Coordinate{139.343, 50.0799}, CountryId{"RU"}}, // Q113907732
    {Coordinate{139.588, 50.1277}, CountryId{"RU"}}, // Q113907734
    {Coordinate{139.872, 49.999}, CountryId{"RU"}}, // Q113907735
    {Coordinate{139.949, 49.8902}, CountryId{"RU"}}, // Q113907737
    {Coordinate{140.093, 49.8204}, CountryId{"RU"}}, // Q113907739
    {Coordinate{140.101, 49.6675}, CountryId{"RU"}}, // Q113907741
    {Coordinate{140.006, 49.4684}, CountryId{"RU"}}, // Q113907743
    {Coordinate{140.051, 49.3819}, CountryId{"RU"}}, // Q113907744
    {Coordinate{140.053, 49.3507}, CountryId{"RU"}}, // Q113907745
    {Coordinate{140.17, 49.3168}, CountryId{"RU"}}, // Q113907747
    {Coordinate{140.252, 49.267}, CountryId{"RU"}}, // Q113907748
    {Coordinate{140.306, 49.2602}, CountryId{"RU"}}, // Q113907749
    {Coordinate{140.317, 49.1953}, CountryId{"RU"}}, // Q113907750
    {Coordinate{140.322, 49.1186}, CountryId{"RU"}}, // Q113907751
    {Coordinate{131.558, 48.9823}, CountryId{"RU"}}, // Q113908994
    {Coordinate{130.16, 49.349}, CountryId{"RU"}}, // Q113925091
    {Coordinate{130.189, 49.3178}, CountryId{"RU"}}, // Q113925094
    {Coordinate{130.261, 49.2842}, CountryId{"RU"}}, // Q113925097
    {Coordinate{130.362, 49.2656}, CountryId{"RU"}}, // Q113925099
    {Coordinate{130.478, 49.2288}, CountryId{"RU"}}, // Q113925102
    {Coordinate{130.658, 49.1908}, CountryId{"RU"}}, // Q113925105
    {Coordinate{130.713, 49.1648}, CountryId{"RU"}}, // Q113925108
    {Coordinate{130.755, 49.1077}, CountryId{"RU"}}, // Q113925111
    {Coordinate{130.826, 49.0541}, CountryId{"RU"}}, // Q113925113
    {Coordinate{131.021, 48.9775}, CountryId{"RU"}}, // Q113925117
    {Coordinate{131.06, 49.0111}, CountryId{"RU"}}, // Q113925120
    {Coordinate{131.133, 48.9897}, CountryId{"RU"}}, // Q113925122
    {Coordinate{131.233, 49.006}, CountryId{"RU"}}, // Q113925124
    {Coordinate{131.42, 48.9893}, CountryId{"RU"}}, // Q113925126
    {Coordinate{131.722, 48.9926}, CountryId{"RU"}}, // Q113928805
    {Coordinate{131.881, 49.0016}, CountryId{"RU"}}, // Q113928806
    {Coordinate{131.943, 49.0078}, CountryId{"RU"}}, // Q113928808
    {Coordinate{132, 49.0116}, CountryId{"RU"}}, // Q113928809
    {Coordinate{132.237, 49.0156}, CountryId{"RU"}}, // Q113928810
    {Coordinate{132.462, 48.9996}, CountryId{"RU"}}, // Q113928811
    {Coordinate{132.6, 48.9564}, CountryId{"RU"}}, // Q113928813
    {Coordinate{132.714, 48.9192}, CountryId{"RU"}}, // Q113928814
    {Coordinate{132.857, 48.8675}, CountryId{"RU"}}, // Q113928815
    {Coordinate{132.567, 48.9606}, CountryId{"RU"}}, // Q113928845
    {Coordinate{134.481, 48.5613}, CountryId{"RU"}}, // Volochayevka-1
    {Coordinate{133.616, 48.5935}, CountryId{"RU"}}, // Q113931928
    {Coordinate{133.725, 48.5893}, CountryId{"RU"}}, // Q113931929
    {Coordinate{134.16, 48.6085}, CountryId{"RU"}}, // Q113931931
    {Coordinate{134.387, 48.5812}, CountryId{"RU"}}, // Q113931933
    {Coordinate{134.559, 48.5476}, CountryId{"RU"}}, // Q113933662
    {Coordinate{134.699, 48.5311}, CountryId{"RU"}}, // Q113937553
    {Coordinate{134.731, 48.5295}, CountryId{"RU"}}, // Q113937554
    {Coordinate{134.773, 48.531}, CountryId{"RU"}}, // Q113937556
    {Coordinate{134.873, 48.5272}, CountryId{"RU"}}, // Q113937558
    {Coordinate{134.903, 48.5233}, CountryId{"RU"}}, // Q113937560
    {Coordinate{134.944, 48.5273}, CountryId{"RU"}}, // Q113937562
    {Coordinate{134.964, 48.5297}, CountryId{"RU"}}, // Q113937564
    {Coordinate{135.021, 48.5362}, CountryId{"RU"}}, // Q113937566
    {Coordinate{135.038, 48.5191}, CountryId{"RU"}}, // Q113937567
    {Coordinate{135.11, 48.4794}, CountryId{"RU"}}, // Q113951412
    {Coordinate{135.121, 48.4479}, CountryId{"RU"}}, // Q113951414
    {Coordinate{135.123, 48.4378}, CountryId{"RU"}}, // Q113951415
    {Coordinate{135.116, 48.3745}, CountryId{"RU"}}, // Q113951416
    {Coordinate{135.089, 48.3535}, CountryId{"RU"}}, // Q113951417
    {Coordinate{135.097, 48.3344}, CountryId{"RU"}}, // Q113951418
    {Coordinate{135.099, 48.2932}, CountryId{"RU"}}, // Q113951420
    {Coordinate{135.072, 48.2536}, CountryId{"RU"}}, // Q113951421
    {Coordinate{135.08, 48.2217}, CountryId{"RU"}}, // Q113951422
    {Coordinate{135.119, 48.1662}, CountryId{"RU"}}, // Q113951423
    {Coordinate{135.053, 47.9767}, CountryId{"RU"}}, // Q113951426
    {Coordinate{134.963, 47.8899}, CountryId{"RU"}}, // Q113951427
    {Coordinate{134.944, 47.8423}, CountryId{"RU"}}, // Q113951429
    {Coordinate{134.911, 47.7711}, CountryId{"RU"}}, // Q113951431
    {Coordinate{134.906, 47.7189}, CountryId{"RU"}}, // Q113951432
    {Coordinate{134.861, 47.6418}, CountryId{"RU"}}, // Q113951433
    {Coordinate{134.806, 47.552}, CountryId{"RU"}}, // Q113951434
    {Coordinate{134.75, 47.5379}, CountryId{"RU"}}, // Q113951436
    {Coordinate{134.306, 47.1584}, CountryId{"RU"}}, // Q113951437
    {Coordinate{134.306, 47.1584}, CountryId{"RU"}}, // Q113951438
    {Coordinate{134.344, 46.7327}, CountryId{"RU"}}, // Zven'yevoy
    {Coordinate{134.259, 46.5584}, CountryId{"RU"}}, // Burlit-Volochayevskiy
    {Coordinate{134.19, 46.4766}, CountryId{"RU"}}, // Q113951441
    {Coordinate{134.116, 46.3987}, CountryId{"RU"}}, // Q113951442
    {Coordinate{133.951, 46.2032}, CountryId{"RU"}}, // Q113951443
    {Coordinate{133.724, 45.9355}, CountryId{"RU"}}, // Dalnerechensk I railway station
    {Coordinate{133.645, 45.8763}, CountryId{"RU"}}, // Q113951445
    {Coordinate{133.612, 45.8216}, CountryId{"RU"}}, // Q113952137
    {Coordinate{133.505, 45.5681}, CountryId{"RU"}}, // Q113952138
    {Coordinate{133.378, 45.4547}, CountryId{"RU"}}, // Q113952139
    {Coordinate{133.364, 45.3153}, CountryId{"RU"}}, // Q113952140
    {Coordinate{133.307, 45.1261}, CountryId{"RU"}}, // Q113952141
    {Coordinate{132.533, 44.3397}, CountryId{"RU"}}, // Q113952142
    {Coordinate{133.602, 44.3998}, CountryId{"RU"}}, // Q113952283
    {Coordinate{133.344, 44.2061}, CountryId{"RU"}}, // Q113952284
    {Coordinate{133.147, 44.2074}, CountryId{"RU"}}, // Q113952285
    {Coordinate{133.147, 44.2074}, CountryId{"RU"}}, // Q113952286
    {Coordinate{132.748, 44.1658}, CountryId{"RU"}}, // Q113952287
    {Coordinate{132.648, 44.1459}, CountryId{"RU"}}, // Vassianovka
    {Coordinate{132.028, 43.9427}, CountryId{"RU"}}, // Dubininskiy
    {Coordinate{132.274, 44.0524}, CountryId{"RU"}}, // Ippolitovka
    {Coordinate{132.167, 44.03}, CountryId{"RU"}}, // Q113952425
    {Coordinate{131.966, 43.6668}, CountryId{"RU"}}, // Q113952705
    {Coordinate{131.953, 43.6338}, CountryId{"RU"}}, // Q113954886
    {Coordinate{131.97, 43.595}, CountryId{"RU"}}, // Q113954887
    {Coordinate{131.896, 43.5318}, CountryId{"RU"}}, // Q113954888
    {Coordinate{124.917, 56.2809}, CountryId{"RU"}}, // Q113956385
    {Coordinate{132.531, 50.9908}, CountryId{"RU"}}, // Q113967464
    {Coordinate{132.404, 50.9469}, CountryId{"RU"}}, // Q113967466
    {Coordinate{132.309, 50.8369}, CountryId{"RU"}}, // Q113967467
    {Coordinate{132.405, 50.5945}, CountryId{"RU"}}, // Q113967470
    {Coordinate{132.268, 50.412}, CountryId{"RU"}}, // Q113967473
    {Coordinate{132.287, 50.3248}, CountryId{"RU"}}, // Q113967474
    {Coordinate{132.138, 50.0348}, CountryId{"RU"}}, // Q113967477
    {Coordinate{132.016, 49.9523}, CountryId{"RU"}}, // Q113967478
    {Coordinate{131.92, 49.7884}, CountryId{"RU"}}, // Q113967480
    {Coordinate{131.819, 49.7134}, CountryId{"RU"}}, // Q113967481
    {Coordinate{131.588, 49.6131}, CountryId{"RU"}}, // Q113967482
    {Coordinate{131.553, 49.4594}, CountryId{"RU"}}, // Q113967483
    {Coordinate{131.662, 49.3178}, CountryId{"RU"}}, // Q113967484
    {Coordinate{131.634, 49.1958}, CountryId{"RU"}}, // Q113967486
    {Coordinate{131.583, 49.1165}, CountryId{"RU"}}, // Q113967487
    {Coordinate{136.876, 50.4083}, CountryId{"RU"}}, // Q113970891
    {Coordinate{136.657, 50.2619}, CountryId{"RU"}}, // Q113970892
    {Coordinate{136.649, 50.2156}, CountryId{"RU"}}, // Q113970893
    {Coordinate{136.494, 50.0816}, CountryId{"RU"}}, // Q113970895
    {Coordinate{136.423, 50.0194}, CountryId{"RU"}}, // Q113970896
    {Coordinate{136.321, 49.9879}, CountryId{"RU"}}, // Q113970898
    {Coordinate{136.135, 49.8984}, CountryId{"RU"}}, // Q113970899
    {Coordinate{135.939, 49.8223}, CountryId{"RU"}}, // Q113970901
    {Coordinate{135.766, 49.7181}, CountryId{"RU"}}, // Q113970902
    {Coordinate{135.633, 49.693}, CountryId{"RU"}}, // Q113970904
    {Coordinate{135.419, 49.5857}, CountryId{"RU"}}, // Q113970905
    {Coordinate{135.293, 49.4862}, CountryId{"RU"}}, // Q113970906
    {Coordinate{135.189, 49.3638}, CountryId{"RU"}}, // Q113970908
    {Coordinate{135.181, 49.2403}, CountryId{"RU"}}, // Q113970909
    {Coordinate{135.175, 49.1807}, CountryId{"RU"}}, // Q113970911
    {Coordinate{135.165, 49.0828}, CountryId{"RU"}}, // Q113970912
    {Coordinate{135.098, 48.985}, CountryId{"RU"}}, // Q113970913
    {Coordinate{134.969, 48.9275}, CountryId{"RU"}}, // Q113970915
    {Coordinate{134.864, 48.8032}, CountryId{"RU"}}, // Q113970916
    {Coordinate{134.666, 48.7174}, CountryId{"RU"}}, // Q113970917
    {Coordinate{134.605, 48.6463}, CountryId{"RU"}}, // Q113970919
    {Coordinate{7.49073, 44.8902}, CountryId{"IT"}}, // Scalenghe railway station
    {Coordinate{7.49564, 44.8628}, CountryId{"IT"}}, // Cercenasco railway halt
    {Coordinate{7.50996, 44.7867}, CountryId{"IT"}}, // Villafranca Piemonte railway halt
    {Coordinate{7.52541, 44.7371}, CountryId{"IT"}}, // Torre San Giorgio railway halt
    {Coordinate{131.865, 43.5853}, CountryId{"RU"}}, // Olenevod
    {Coordinate{131.752, 43.4187}, CountryId{"RU"}}, // Vinevitino
    {Coordinate{131.717, 43.2929}, CountryId{"RU"}}, // Provalovo
    {Coordinate{131.641, 43.1788}, CountryId{"RU"}}, // Q113977240
    {Coordinate{131.597, 43.1032}, CountryId{"RU"}}, // Primorskaya
    {Coordinate{131.531, 43.0378}, CountryId{"RU"}}, // Kedrovyy
    {Coordinate{131.433, 43.0078}, CountryId{"RU"}}, // Pozharsky railway station
    {Coordinate{131.321, 42.9372}, CountryId{"RU"}}, // Bamburovo
    {Coordinate{131.251, 42.8065}, CountryId{"RU"}}, // Ryazanovka railway station, Primorsky Krai
    {Coordinate{131.124, 42.7219}, CountryId{"RU"}}, // Sukhanovka
    {Coordinate{130.906, 42.6929}, CountryId{"RU"}}, // Gvozdevo
    {Coordinate{130.777, 42.7034}, CountryId{"RU"}}, // Makhalino railway station
    {Coordinate{19.9539, 54.4813}, CountryId{"RU"}}, // Q114011696
    {Coordinate{20.0034, 54.5121}, CountryId{"RU"}}, // Q114011699
    {Coordinate{20.0603, 54.5445}, CountryId{"RU"}}, // Q114011702
    {Coordinate{20.1132, 54.5569}, CountryId{"RU"}}, // Q114011704
    {Coordinate{20.1769, 54.5708}, CountryId{"RU"}}, // Q114011707
    {Coordinate{20.2213, 54.5725}, CountryId{"RU"}}, // Q114011732
    {Coordinate{20.2849, 54.5627}, CountryId{"RU"}}, // Q114011734
    {Coordinate{20.3262, 54.5656}, CountryId{"RU"}}, // Q114011736
    {Coordinate{20.3561, 54.579}, CountryId{"RU"}}, // Q114011744
    {Coordinate{20.3935, 54.6005}, CountryId{"RU"}}, // Q114011748
    {Coordinate{20.4087, 54.6156}, CountryId{"RU"}}, // Q114011752
    {Coordinate{20.4703, 54.682}, CountryId{"RU"}}, // Kievskaya railway station, Kaliningrad
    {Coordinate{20.5318, 54.674}, CountryId{"RU"}}, // Q114013368
    {Coordinate{20.702, 54.6385}, CountryId{"RU"}}, // Q114013484
    {Coordinate{20.9824, 54.6332}, CountryId{"RU"}}, // 1252 km railway station, Kaliningrad Oblast
    {Coordinate{20.5498, 54.6167}, CountryId{"RU"}}, // Q114017465
    {Coordinate{20.5622, 54.5848}, CountryId{"RU"}}, // Q114017466
    {Coordinate{20.5617, 54.5506}, CountryId{"RU"}}, // Q114017468
    {Coordinate{20.5696, 54.5301}, CountryId{"RU"}}, // Q114017470
    {Coordinate{20.5747, 54.5179}, CountryId{"RU"}}, // Q114017471
    {Coordinate{20.5821, 54.5073}, CountryId{"RU"}}, // Q114017472
    {Coordinate{19.9186, 54.6599}, CountryId{"RU"}}, // Q114029580
    {Coordinate{19.9322, 54.6828}, CountryId{"RU"}}, // Q114029581
    {Coordinate{20.0037, 54.7321}, CountryId{"RU"}}, // Primorsk-Novy railway station
    {Coordinate{20.0277, 54.7375}, CountryId{"RU"}}, // Q114029584
    {Coordinate{20.0786, 54.7408}, CountryId{"RU"}}, // Q114029585
    {Coordinate{20.1878, 54.741}, CountryId{"RU"}}, // Q114029586
    {Coordinate{20.2996, 54.7365}, CountryId{"RU"}}, // Q114029589
    {Coordinate{20.3294, 54.7371}, CountryId{"RU"}}, // Q114029590
    {Coordinate{20.3647, 54.7283}, CountryId{"RU"}}, // Lesnoye-Novoye railway station
    {Coordinate{20.4571, 54.7107}, CountryId{"RU"}}, // Q114029594
    {Coordinate{20.2629, 54.7346}, CountryId{"RU"}}, // Q114029609
    {Coordinate{20.7582, 54.8092}, CountryId{"RU"}}, // Q114030942
    {Coordinate{20.795, 54.8131}, CountryId{"RU"}}, // Q114030943
    {Coordinate{20.8694, 54.8136}, CountryId{"RU"}}, // Dobrino railway station
    {Coordinate{20.9745, 54.8392}, CountryId{"RU"}}, // Q114030945
    {Coordinate{21.1007, 54.8555}, CountryId{"RU"}}, // Q114030946
    {Coordinate{21.2101, 54.8427}, CountryId{"RU"}}, // Q114030948
    {Coordinate{21.2769, 54.8398}, CountryId{"RU"}}, // Q114030949
    {Coordinate{21.3473, 54.8448}, CountryId{"RU"}}, // Q114030950
    {Coordinate{21.6597, 55.0431}, CountryId{"RU"}}, // Q114030952
    {Coordinate{21.6504, 55.0792}, CountryId{"RU"}}, // Q114030954
    {Coordinate{21.7274, 55.0737}, CountryId{"RU"}}, // Q114030955
    {Coordinate{21.7835, 55.0723}, CountryId{"RU"}}, // Q114030956
    {Coordinate{20.5183, 54.8019}, CountryId{"RU"}}, // Q114032377
    {Coordinate{20.5074, 54.8275}, CountryId{"RU"}}, // Q114032379
    {Coordinate{20.493, 54.8686}, CountryId{"RU"}}, // Q114032380
    {Coordinate{20.4871, 54.895}, CountryId{"RU"}}, // Muromskoye
    {Coordinate{20.49, 54.9332}, CountryId{"RU"}}, // Sosnovka
    {Coordinate{20.4403, 54.9496}, CountryId{"RU"}}, // Q114032385
    {Coordinate{20.4133, 54.9435}, CountryId{"RU"}}, // Q114032386
    {Coordinate{20.3969, 54.9389}, CountryId{"RU"}}, // Q114032387
    {Coordinate{20.3629, 54.9288}, CountryId{"RU"}}, // Q114032388
    {Coordinate{20.3236, 54.9301}, CountryId{"RU"}}, // Q114032389
    {Coordinate{20.2252, 54.9491}, CountryId{"RU"}}, // Pionersky Kurort railway station
    {Coordinate{20.4456, 54.7648}, CountryId{"RU"}}, // Q114032879
    {Coordinate{20.3503, 54.781}, CountryId{"RU"}}, // Q114032880
    {Coordinate{20.3037, 54.8019}, CountryId{"RU"}}, // Q114032881
    {Coordinate{20.2521, 54.8407}, CountryId{"RU"}}, // Pereslavskoe-Zapadnoe railway station
    {Coordinate{20.2388, 54.898}, CountryId{"RU"}}, // Q114032887
    {Coordinate{20.2806, 54.8185}, CountryId{"RU"}}, // Q114032902
    {Coordinate{14.7204, 49.3213}, CountryId{"CZ"}}, // Doubí u Tábora
    {Coordinate{142.85, 49.6847}, CountryId{"RU"}}, // Yelniki-Sakhalinskiye
    {Coordinate{37.5896, 57.3528}, CountryId{"RU"}}, // Q114100333
    {Coordinate{37.6689, 57.274}, CountryId{"RU"}}, // Q114101710
    {Coordinate{37.6175, 57.3154}, CountryId{"RU"}}, // Q114101711
    {Coordinate{37.4536, 57.4606}, CountryId{"RU"}}, // Q114101712
    {Coordinate{37.2355, 57.6813}, CountryId{"RU"}}, // Q114101713
    {Coordinate{37.1995, 57.7288}, CountryId{"RU"}}, // Q114101715
    {Coordinate{12.6469, 55.6358}, CountryId{"DK"}}, // Kastrup Station
    {Coordinate{13.4913, 49.7915}, CountryId{"CZ"}}, // Q114154371
    {Coordinate{7.61006, 43.7927}, CountryId{"IT"}}, // Ventimiglia railway station
    {Coordinate{12.4544, 41.8964}, CountryId{"IT"}}, // Roma San Pietro railway station
    {Coordinate{36.964, 58.3945}, CountryId{"RU"}}, // Q114163310
    {Coordinate{37.0322, 58.4478}, CountryId{"RU"}}, // Q114163313
    {Coordinate{37.0636, 58.5445}, CountryId{"RU"}}, // Q114163316
    {Coordinate{37.087, 58.5771}, CountryId{"RU"}}, // Q114163318
    {Coordinate{37.1332, 58.6011}, CountryId{"RU"}}, // Q114163319
    {Coordinate{35.0292, 58.8044}, CountryId{"RU"}}, // Kabozha railway station
    {Coordinate{37.088, 57.9103}, CountryId{"RU"}}, // Q114169084
    {Coordinate{37.0913, 58.1271}, CountryId{"RU"}}, // Q114169087
    {Coordinate{37.0624, 58.2055}, CountryId{"RU"}}, // Q114169089
    {Coordinate{-101.379, 54.584}, CountryId{"CA"}}, // Cranberry Portage railway station
    {Coordinate{-101.09, 55.1256}, CountryId{"CA"}}, // Sherridon railway station
    {Coordinate{-101.14, 54.8757}, CountryId{"CA"}}, // Heming Lake
    {Coordinate{-100.941, 55.2674}, CountryId{"CA"}}, // Ruddock
    {Coordinate{-101.012, 55.5375}, CountryId{"CA"}}, // Charles railway station
    {Coordinate{-101.212, 55.6978}, CountryId{"CA"}}, // Pawistik
    {Coordinate{35.1654, 58.7859}, CountryId{"RU"}}, // Q114179407
    {Coordinate{35.2509, 58.76}, CountryId{"RU"}}, // Q114179409
    {Coordinate{35.4347, 58.7109}, CountryId{"RU"}}, // Q114179410
    {Coordinate{35.4923, 58.6923}, CountryId{"RU"}}, // Q114179411
    {Coordinate{35.6147, 58.6523}, CountryId{"RU"}}, // Q114179413
    {Coordinate{35.7262, 58.6224}, CountryId{"RU"}}, // Q114179414
    {Coordinate{35.8068, 58.6013}, CountryId{"RU"}}, // Pestovo railway station
    {Coordinate{36.0987, 58.5437}, CountryId{"RU"}}, // Q114179418
    {Coordinate{36.2213, 58.4915}, CountryId{"RU"}}, // Q114179420
    {Coordinate{36.7343, 58.3701}, CountryId{"RU"}}, // Q114179421
    {Coordinate{31.8964, 59.4721}, CountryId{"RU"}}, // Q114180250
    {Coordinate{7.25278, 50.9105}, CountryId{"DE"}}, // Honrath
    {Coordinate{31.9459, 59.4688}, CountryId{"RU"}}, // Q114206430
    {Coordinate{32.2567, 59.3836}, CountryId{"RU"}}, // Q114206432
    {Coordinate{32.3295, 59.3571}, CountryId{"RU"}}, // Q114206433
    {Coordinate{32.3814, 59.3293}, CountryId{"RU"}}, // Q114206435
    {Coordinate{32.6508, 59.2367}, CountryId{"RU"}}, // Q114206436
    {Coordinate{33.0095, 59.1725}, CountryId{"RU"}}, // Q114206438
    {Coordinate{33.1211, 59.1517}, CountryId{"RU"}}, // Q114206440
    {Coordinate{33.2458, 59.1507}, CountryId{"RU"}}, // Q114206441
    {Coordinate{8.51806, 49.5097}, CountryId{"DE"}}, // Bahnhof Mannheim-Käfertal OEG
    {Coordinate{33.5024, 59.0645}, CountryId{"RU"}}, // Q114213033
    {Coordinate{33.5407, 59.0525}, CountryId{"RU"}}, // Q114213035
    {Coordinate{33.6435, 59.0191}, CountryId{"RU"}}, // Q114213036
    {Coordinate{33.7532, 58.992}, CountryId{"RU"}}, // Q114213038
    {Coordinate{33.8213, 58.9892}, CountryId{"RU"}}, // Q114213039
    {Coordinate{33.9935, 58.9597}, CountryId{"RU"}}, // Q114213041
    {Coordinate{34.183, 58.9386}, CountryId{"RU"}}, // Q114213043
    {Coordinate{34.3381, 58.9119}, CountryId{"RU"}}, // Q114213044
    {Coordinate{34.5036, 58.893}, CountryId{"RU"}}, // Q114213045
    {Coordinate{34.6658, 58.8684}, CountryId{"RU"}}, // Q114213046
    {Coordinate{-73.1094, 46.2736}, CountryId{"CA"}}, // Saint-Justin railway station
    {Coordinate{-73.016, 46.4011}, CountryId{"CA"}}, // Saint-Paulin railway station
    {Coordinate{-72.9223, 46.4418}, CountryId{"CA"}}, // Charette railway station
    {Coordinate{-72.6382, 46.6402}, CountryId{"CA"}}, // Garneau railway station
    {Coordinate{-72.2869, 46.9337}, CountryId{"CA"}}, // Rousseau railway station
    {Coordinate{-72.1868, 47.7835}, CountryId{"CA"}}, // Sommet Club railway station
    {Coordinate{-72.2298, 47.7244}, CountryId{"CA"}}, // Cherokee railway station
    {Coordinate{-72.1789, 48.1003}, CountryId{"CA"}}, // Lizotte Club railway station
    {Coordinate{-72.1999, 47.3555}, CountryId{"CA"}}, // Pont Beaudet railway station
    {Coordinate{-72.211, 47.3664}, CountryId{"CA"}}, // Saint-Hilaire de Portneuf railway station
    {Coordinate{-72.2213, 47.3814}, CountryId{"CA"}}, // Bima railway station
    {Coordinate{-72.1835, 47.9998}, CountryId{"CA"}}, // Lac des Roches railway station
    {Coordinate{-72.1502, 47.9367}, CountryId{"CA"}}, // Van Bruyssels railway station
    {Coordinate{-72.2491, 47.4414}, CountryId{"CA"}}, // Stadacona railway station
    {Coordinate{-72.2186, 47.4824}, CountryId{"CA"}}, // Sanford railway station
    {Coordinate{-72.1464, 47.9316}, CountryId{"CA"}}, // Kiskisink railway station
    {Coordinate{-72.2431, 47.5365}, CountryId{"CA"}}, // Hirondelle railway station
    {Coordinate{-72.2405, 47.5756}, CountryId{"CA"}}, // Club Nicol railway station
    {Coordinate{-72.156, 47.8538}, CountryId{"CA"}}, // Brooks railway station
    {Coordinate{-84.9541, 48.483}, CountryId{"CA"}}, // Amyot railway station
    {Coordinate{-84.5347, 48.4827}, CountryId{"CA"}}, // Swanson railway station
    {Coordinate{-81.9604, 47.1465}, CountryId{"CA"}}, // Sinker railway station
    {Coordinate{-81.8665, 47.0527}, CountryId{"CA"}}, // Forks railway station
    {Coordinate{-72.9839, 47.6622}, CountryId{"CA"}}, // Club Vermillon railway station
    {Coordinate{-73.1401, 47.6709}, CountryId{"CA"}}, // Lac Darey railway station
    {Coordinate{-73.208, 47.7004}, CountryId{"CA"}}, // Duplessis railway station
    {Coordinate{-73.3341, 47.7713}, CountryId{"CA"}}, // Windigo railway station
    {Coordinate{-73.4679, 47.8533}, CountryId{"CA"}}, // Wigwam Club railway station
    {Coordinate{-73.5562, 47.8575}, CountryId{"CA"}}, // Vandry railway station
    {Coordinate{-73.7529, 47.8991}, CountryId{"CA"}}, // Saint-Maurice Rivière Boom railway station
    {Coordinate{-73.7752, 47.8982}, CountryId{"CA"}}, // Weymont railway station
    {Coordinate{-73.7931, 47.8939}, CountryId{"CA"}}, // Sanmaur railway station
    {Coordinate{-73.8812, 47.902}, CountryId{"CA"}}, // Cann railway station
    {Coordinate{-73.9336, 47.924}, CountryId{"CA"}}, // Club Bélanger railway station
    {Coordinate{-74.044, 47.8661}, CountryId{"CA"}}, // Hibbard railway station
    {Coordinate{-74.1804, 47.8877}, CountryId{"CA"}}, // Casey railway station
    {Coordinate{11.2367, 43.8003}, CountryId{"IT"}}, // Firenze Rifredi railway station
    {Coordinate{30.4481, 56.2768}, CountryId{"RU"}}, // Q114309577
    {Coordinate{30.3638, 56.2347}, CountryId{"RU"}}, // Q114309579
    {Coordinate{30.3009, 56.1774}, CountryId{"RU"}}, // Q114309580
    {Coordinate{-74.3737, 47.8791}, CountryId{"CA"}}, // Sisco Club railway station
    {Coordinate{-74.4702, 47.8726}, CountryId{"CA"}}, // Manjobagues railway station
    {Coordinate{-74.848, 48.0066}, CountryId{"CA"}}, // Club Rita railway station
    {Coordinate{-74.8953, 48.0674}, CountryId{"CA"}}, // Maniwawa Club railway station
    {Coordinate{-75.0566, 48.1112}, CountryId{"CA"}}, // Oskelaneo Lodge railway station
    {Coordinate{-75.2051, 48.1082}, CountryId{"CA"}}, // Oskelaneo River railway station
    {Coordinate{-75.6417, 48.1682}, CountryId{"CA"}}, // Monet railway station
    {Coordinate{-75.7492, 48.1944}, CountryId{"CA"}}, // Consolidated Bathurst railway station
    {Coordinate{-75.8086, 48.1965}, CountryId{"CA"}}, // Kapitachuan railway station
    {Coordinate{-75.8966, 48.211}, CountryId{"CA"}}, // Club Beaudin railway station
    {Coordinate{-75.9984, 48.2297}, CountryId{"CA"}}, // Da-Rou-Lac Lodge railway station
    {Coordinate{-76.1134, 48.2495}, CountryId{"CA"}}, // Gagnon railway station
    {Coordinate{-76.3202, 48.2525}, CountryId{"CA"}}, // Bolger railway station
    {Coordinate{-76.4288, 48.2353}, CountryId{"CA"}}, // Forsythe railway station
    {Coordinate{-76.7334, 48.2424}, CountryId{"CA"}}, // Press railway station
    {Coordinate{36.8453, 57.8084}, CountryId{"RU"}}, // Q114339742
    {Coordinate{36.5966, 57.7853}, CountryId{"RU"}}, // Q114339743
    {Coordinate{36.4726, 57.7878}, CountryId{"RU"}}, // Q114339744
    {Coordinate{36.1874, 57.7835}, CountryId{"RU"}}, // Q114339747
    {Coordinate{36.0516, 57.7739}, CountryId{"RU"}}, // Q114339748
    {Coordinate{35.8601, 57.7971}, CountryId{"RU"}}, // Q114339750
    {Coordinate{35.7399, 57.8185}, CountryId{"RU"}}, // Q114339751
    {Coordinate{35.626, 57.8315}, CountryId{"RU"}}, // Q114339752
    {Coordinate{35.4133, 57.8542}, CountryId{"RU"}}, // Q114339755
    {Coordinate{35.268, 57.8599}, CountryId{"RU"}}, // Q114339756
    {Coordinate{35.1727, 57.8649}, CountryId{"RU"}}, // Q114339757
    {Coordinate{35.0074, 57.8801}, CountryId{"RU"}}, // Q114339759
    {Coordinate{34.8912, 57.8982}, CountryId{"RU"}}, // Q114339760
    {Coordinate{34.7657, 57.9069}, CountryId{"RU"}}, // Q114339762
    {Coordinate{34.6576, 57.9239}, CountryId{"RU"}}, // Q114339763
    {Coordinate{34.5683, 57.9231}, CountryId{"RU"}}, // Q114339765
    {Coordinate{34.5251, 57.918}, CountryId{"RU"}}, // Q114339766
    {Coordinate{34.4246, 57.9229}, CountryId{"RU"}}, // Q114339767
    {Coordinate{34.3941, 57.9234}, CountryId{"RU"}}, // Q114339768
    {Coordinate{34.3053, 57.9358}, CountryId{"RU"}}, // Q114339769
    {Coordinate{34.2493, 57.9308}, CountryId{"RU"}}, // Q114339770
    {Coordinate{34.2105, 57.909}, CountryId{"RU"}}, // Q114339771
    {Coordinate{34.185, 57.897}, CountryId{"RU"}}, // Q114339772
    {Coordinate{32.399, 57.9215}, CountryId{"RU"}}, // Lychkovo railway station
    {Coordinate{33.9872, 57.9068}, CountryId{"RU"}}, // Q114349213
    {Coordinate{33.9105, 57.9099}, CountryId{"RU"}}, // Q114349214
    {Coordinate{33.8824, 57.9104}, CountryId{"RU"}}, // Q114349215
    {Coordinate{33.7426, 57.9093}, CountryId{"RU"}}, // Q114349217
    {Coordinate{33.6343, 57.9188}, CountryId{"RU"}}, // Q114349218
    {Coordinate{33.5476, 57.9259}, CountryId{"RU"}}, // Q114349219
    {Coordinate{33.0712, 57.9456}, CountryId{"RU"}}, // Q114349221
    {Coordinate{32.9889, 57.9395}, CountryId{"RU"}}, // Q114349222
    {Coordinate{32.8028, 57.9696}, CountryId{"RU"}}, // Q114349224
    {Coordinate{32.6987, 57.9696}, CountryId{"RU"}}, // Q114349225
    {Coordinate{32.5541, 57.9343}, CountryId{"RU"}}, // Q114349228
    {Coordinate{32.3044, 57.9256}, CountryId{"RU"}}, // Q114349229
    {Coordinate{32.2216, 57.9241}, CountryId{"RU"}}, // Q114349230
    {Coordinate{32.0565, 57.9258}, CountryId{"RU"}}, // Q114349231
    {Coordinate{31.9716, 57.9322}, CountryId{"RU"}}, // Q114349232
    {Coordinate{31.8301, 57.9417}, CountryId{"RU"}}, // Q114349233
    {Coordinate{31.6396, 57.9534}, CountryId{"RU"}}, // Q114349234
    {Coordinate{31.6095, 57.9631}, CountryId{"RU"}}, // Q114349235
    {Coordinate{31.4685, 57.9915}, CountryId{"RU"}}, // Q114349237
    {Coordinate{31.2137, 57.979}, CountryId{"RU"}}, // Q114349239
    {Coordinate{31.1477, 57.9691}, CountryId{"RU"}}, // Q114349240
    {Coordinate{31.0582, 57.9556}, CountryId{"RU"}}, // Q114349241
    {Coordinate{30.9731, 57.9427}, CountryId{"RU"}}, // Q114349242
    {Coordinate{30.9028, 57.9402}, CountryId{"RU"}}, // Q114349243
    {Coordinate{30.8476, 57.9398}, CountryId{"RU"}}, // Q114349244
    {Coordinate{30.7079, 57.9313}, CountryId{"RU"}}, // Q114349245
    {Coordinate{30.556, 57.9183}, CountryId{"RU"}}, // Q114349246
    {Coordinate{30.4191, 57.9035}, CountryId{"RU"}}, // Q114349247
    {Coordinate{29.5639, 57.7743}, CountryId{"RU"}}, // Q114349682
    {Coordinate{29.5304, 57.7661}, CountryId{"RU"}}, // Porkhov railway station
    {Coordinate{29.4146, 57.7487}, CountryId{"RU"}}, // Q114349684
    {Coordinate{29.36, 57.7414}, CountryId{"RU"}}, // Q114349685
    {Coordinate{29.2589, 57.7288}, CountryId{"RU"}}, // Q114349686
    {Coordinate{29.1614, 57.7282}, CountryId{"RU"}}, // Q114349687
    {Coordinate{29.0472, 57.7449}, CountryId{"RU"}}, // Q114349688
    {Coordinate{28.9567, 57.7466}, CountryId{"RU"}}, // Q114349689
    {Coordinate{28.8721, 57.7511}, CountryId{"RU"}}, // Q114349690
    {Coordinate{28.7607, 57.7602}, CountryId{"RU"}}, // Q114349692
    {Coordinate{28.6519, 57.7656}, CountryId{"RU"}}, // Q114349693
    {Coordinate{28.5462, 57.7734}, CountryId{"RU"}}, // Q114349695
    {Coordinate{28.5256, 57.784}, CountryId{"RU"}}, // Q114349696
    {Coordinate{28.1674, 57.7828}, CountryId{"RU"}}, // Q114350137
    {Coordinate{33.4761, 58.5438}, CountryId{"RU"}}, // Q114356765
    {Coordinate{33.4273, 58.6065}, CountryId{"RU"}}, // Q114356766
    {Coordinate{33.429, 58.6428}, CountryId{"RU"}}, // Q114356767
    {Coordinate{33.4526, 58.669}, CountryId{"RU"}}, // Q114356768
    {Coordinate{33.4232, 58.7647}, CountryId{"RU"}}, // Q114356770
    {Coordinate{33.4227, 58.7918}, CountryId{"RU"}}, // Q114356771
    {Coordinate{33.4034, 58.8142}, CountryId{"RU"}}, // Q114356772
    {Coordinate{33.3313, 58.8476}, CountryId{"RU"}}, // Q114356773
    {Coordinate{33.2904, 58.9395}, CountryId{"RU"}}, // Q114356775
    {Coordinate{33.2866, 58.9904}, CountryId{"RU"}}, // Q114356776
    {Coordinate{33.3563, 59.1006}, CountryId{"RU"}}, // Q114356778
    {Coordinate{32.3272, 59.9124}, CountryId{"RU"}}, // Q114358077
    {Coordinate{32.3289, 59.9067}, CountryId{"RU"}}, // Q114358078
    {Coordinate{32.3212, 59.888}, CountryId{"RU"}}, // Q114358079
    {Coordinate{32.3188, 59.8766}, CountryId{"RU"}}, // Q114358081
    {Coordinate{32.3341, 59.8518}, CountryId{"RU"}}, // Q114358082
    {Coordinate{32.3579, 59.8236}, CountryId{"RU"}}, // Q114358084
    {Coordinate{32.234, 59.7477}, CountryId{"RU"}}, // Q114358087
    {Coordinate{32.1903, 59.7073}, CountryId{"RU"}}, // Q114358089
    {Coordinate{32.1359, 59.6776}, CountryId{"RU"}}, // Q114358090
    {Coordinate{31.8104, 59.2955}, CountryId{"RU"}}, // Q114390748
    {Coordinate{31.8101, 59.2801}, CountryId{"RU"}}, // Q114390749
    {Coordinate{9.13392, 49.3466}, CountryId{"DE"}}, // Q114414392
    {Coordinate{9.16369, 49.3783}, CountryId{"DE"}}, // Q114414882
    {Coordinate{14.9446, 50.3212}, CountryId{"CZ"}}, // Q114429281
    {Coordinate{9.46069, 51.3543}, CountryId{"DE"}}, // Q114437100
    {Coordinate{9.45228, 51.3245}, CountryId{"DE"}}, // Kassel-Kirchditmold station
    {Coordinate{9.46332, 51.3391}, CountryId{"DE"}}, // Kassel-Jungfernkopf station
    {Coordinate{9.29155, 51.3675}, CountryId{"DE"}}, // Q114437206
    {Coordinate{9.48204, 51.2044}, CountryId{"DE"}}, // Q114437218
    {Coordinate{9.4687, 51.2549}, CountryId{"DE"}}, // Baunatal-Rengershausen
    {Coordinate{9.54916, 51.1545}, CountryId{"DE"}}, // Melsungen-Röhrenfurth station
    {Coordinate{9.45558, 51.3908}, CountryId{"DE"}}, // Espenau-Mönchehof station
    {Coordinate{9.46424, 51.4276}, CountryId{"DE"}}, // Q114437228
    {Coordinate{9.43392, 51.3629}, CountryId{"DE"}}, // Q114437241
    {Coordinate{9.51273, 51.1717}, CountryId{"DE"}}, // Q114437242
    {Coordinate{9.5484, 51.1324}, CountryId{"DE"}}, // Melsungen-Bartenwetzerbrücke station
    {Coordinate{9.30488, 51.365}, CountryId{"DE"}}, // Q114437248
    {Coordinate{9.043, 49.4158}, CountryId{"DE"}}, // Zwingenberg (Baden) station
    {Coordinate{9.07471, 49.3983}, CountryId{"DE"}}, // Neckargerach station
    {Coordinate{9.08391, 49.3722}, CountryId{"DE"}}, // Binau station
    {Coordinate{9.15802, 49.2829}, CountryId{"DE"}}, // Train station in Gundelsheim
    {Coordinate{7.40088, 49.7356}, CountryId{"DE"}}, // Fischbach-Weierbach station
    {Coordinate{10.4945, 53.8304}, CountryId{"DE"}}, // Reinfeld (Holst) station
    {Coordinate{35.0393, 59.5076}, CountryId{"RU"}}, // Q114562180
    {Coordinate{32.4485, 59.8921}, CountryId{"RU"}}, // Q114563738
    {Coordinate{32.5508, 59.8588}, CountryId{"RU"}}, // Q114563739
    {Coordinate{32.5909, 59.8458}, CountryId{"RU"}}, // Q114563741
    {Coordinate{32.6838, 59.8204}, CountryId{"RU"}}, // Q114563743
    {Coordinate{33.0079, 59.6863}, CountryId{"RU"}}, // Q114563744
    {Coordinate{33.0779, 59.6612}, CountryId{"RU"}}, // Q114563745
    {Coordinate{33.2145, 59.646}, CountryId{"RU"}}, // Q114563747
    {Coordinate{33.3769, 59.6408}, CountryId{"RU"}}, // Q114563749
    {Coordinate{33.6312, 59.6138}, CountryId{"RU"}}, // Q114563751
    {Coordinate{33.7778, 59.5872}, CountryId{"RU"}}, // Q114563753
    {Coordinate{33.9491, 59.603}, CountryId{"RU"}}, // Q114563754
    {Coordinate{34.252, 59.5128}, CountryId{"RU"}}, // Q114563755
    {Coordinate{34.3621, 59.5049}, CountryId{"RU"}}, // Q114563756
    {Coordinate{34.8448, 59.493}, CountryId{"RU"}}, // Q114563757
    {Coordinate{35.2219, 59.5147}, CountryId{"RU"}}, // Q114570870
    {Coordinate{35.4337, 59.5144}, CountryId{"RU"}}, // Q114570871
    {Coordinate{35.8222, 59.4138}, CountryId{"RU"}}, // Q114570872
    {Coordinate{37.5514, 59.1524}, CountryId{"RU"}}, // Q114570873
    {Coordinate{11.9921, 51.3891}, CountryId{"DE"}}, // Schkopau railway station
    {Coordinate{0.0258944, 51.5096}, CountryId{"GB"}}, // Custom House station
    {Coordinate{32.4114, 56.1733}, CountryId{"RU"}}, // Q114627254
    {Coordinate{32.3697, 56.0893}, CountryId{"RU"}}, // Q114627255
    {Coordinate{32.3239, 55.9842}, CountryId{"RU"}}, // Q114627256
    {Coordinate{10.9235, 49.4911}, CountryId{"DE"}}, // Fürth-Burgfarrnbach
    {Coordinate{10.8284, 49.5207}, CountryId{"DE"}}, // Puschendorf
    {Coordinate{10.7678, 49.5363}, CountryId{"DE"}}, // Hagenbüchach
    {Coordinate{10.7099, 49.555}, CountryId{"DE"}}, // Emskirchen
    {Coordinate{10.9616, 49.8455}, CountryId{"DE"}}, // Strullendorf
    {Coordinate{11.0135, 49.7996}, CountryId{"DE"}}, // Buttenheim
    {Coordinate{11.0361, 49.7755}, CountryId{"DE"}}, // Eggolsheim
    {Coordinate{-0.0103, 51.4815}, CountryId{"GB"}}, // Cutty Sark
    {Coordinate{11.0596, 49.6852}, CountryId{"DE"}}, // Kersbach
    {Coordinate{11.037, 49.6563}, CountryId{"DE"}}, // Baiersdorf
    {Coordinate{11.012, 49.6295}, CountryId{"DE"}}, // Bubenreuth
    {Coordinate{10.9993, 49.5793}, CountryId{"DE"}}, // Erlangen Paul-Gossen-Straße
    {Coordinate{10.9971, 49.5698}, CountryId{"DE"}}, // Erlangen-Bruck
    {Coordinate{30.3421, 59.4027}, CountryId{"RU"}}, // Q114670019
    {Coordinate{30.322, 59.3926}, CountryId{"RU"}}, // Q114670020
    {Coordinate{30.3036, 59.3826}, CountryId{"RU"}}, // Q114670021
    {Coordinate{30.0429, 57.8693}, CountryId{"RU"}}, // Q114680126
    {Coordinate{14.2765, 48.2647}, CountryId{"AT"}}, // Bahnhof Linz Oed
    {Coordinate{29.9497, 57.6704}, CountryId{"RU"}}, // Q114687148
    {Coordinate{29.8998, 57.2859}, CountryId{"RU"}}, // Q114687149
    {Coordinate{29.8963, 57.1078}, CountryId{"RU"}}, // Q114687151
    {Coordinate{29.9926, 56.9388}, CountryId{"RU"}}, // Q114687153
    {Coordinate{30.0785, 56.8933}, CountryId{"RU"}}, // Q114687154
    {Coordinate{30.1902, 56.7456}, CountryId{"RU"}}, // Q114687156
    {Coordinate{30.1856, 56.6543}, CountryId{"RU"}}, // Q114687160
    {Coordinate{30.1999, 56.5073}, CountryId{"RU"}}, // Q114687165
    {Coordinate{30.1038, 56.2578}, CountryId{"RU"}}, // Q114688805
    {Coordinate{30.0676, 56.1663}, CountryId{"RU"}}, // Q114688808
    {Coordinate{30.0062, 56.1354}, CountryId{"RU"}}, // Q114688810
    {Coordinate{29.9592, 56.0967}, CountryId{"RU"}}, // Q114688814
    {Coordinate{29.9287, 56.0616}, CountryId{"RU"}}, // Q114688815
    {Coordinate{32.9401, 59.4123}, CountryId{"RU"}}, // Q114704031
    {Coordinate{33.128, 59.4857}, CountryId{"RU"}}, // Q114704034
    {Coordinate{33.3464, 59.5714}, CountryId{"RU"}}, // Q114704436
    {Coordinate{10.3826, 49.4797}, CountryId{"DE"}}, // Illesheim
    {Coordinate{10.4856, 49.5254}, CountryId{"DE"}}, // Ipsheim
    {Coordinate{10.523, 49.5476}, CountryId{"DE"}}, // Dottenheim
    {Coordinate{30.1036, 59.544}, CountryId{"RU"}}, // Q114705509
    {Coordinate{10.1907, 49.3767}, CountryId{"DE"}}, // Rothenburg ob der Tauber
    {Coordinate{10.2423, 49.4167}, CountryId{"DE"}}, // Hartershofen
    {Coordinate{10.2272, 49.4008}, CountryId{"DE"}}, // Schweinsdorf
    {Coordinate{29.5619, 59.4551}, CountryId{"RU"}}, // Q114706013
    {Coordinate{28.9446, 59.3943}, CountryId{"RU"}}, // Q114706015
    {Coordinate{28.7453, 59.389}, CountryId{"RU"}}, // Q114706034
    {Coordinate{10.9715, 49.4691}, CountryId{"DE"}}, // Fürth Westvorstadt
    {Coordinate{10.9703, 49.4604}, CountryId{"DE"}}, // Fürth-Dambach
    {Coordinate{10.9724, 49.4543}, CountryId{"DE"}}, // Alte Veste
    {Coordinate{10.9587, 49.4439}, CountryId{"DE"}}, // Zirndorf
    {Coordinate{10.9453, 49.45}, CountryId{"DE"}}, // Zirndorf Kneippallee
    {Coordinate{10.9279, 49.4601}, CountryId{"DE"}}, // Weiherhof
    {Coordinate{10.8867, 49.4647}, CountryId{"DE"}}, // Egersdorf
    {Coordinate{10.8459, 49.5042}, CountryId{"DE"}}, // Raindorf
    {Coordinate{10.8011, 49.4968}, CountryId{"DE"}}, // Langenzenn
    {Coordinate{10.7848, 49.4969}, CountryId{"DE"}}, // Hardhof
    {Coordinate{10.7524, 49.4943}, CountryId{"DE"}}, // Laubendorf
    {Coordinate{10.7165, 49.48}, CountryId{"DE"}}, // Wilhermsdorf Mitte
    {Coordinate{10.6871, 49.4748}, CountryId{"DE"}}, // Adelsdorf (Mittelfr)
    {Coordinate{10.6715, 49.4822}, CountryId{"DE"}}, // Eschenbach (b Markt Erlbach)
    {Coordinate{9.8597, 51.8201}, CountryId{"DE"}}, // Einbeck PS-Speicher railway station
    {Coordinate{-0.398611, 51.5564}, CountryId{"GB"}}, // South Ruislip railway station
    {Coordinate{-0.437781, 51.5694}, CountryId{"GB"}}, // West Ruislip railway station
    {Coordinate{29.7693, 61.1834}, CountryId{"RU"}}, // 165 km railway halt
    {Coordinate{10.397, 49.0254}, CountryId{"DE"}}, // Wilburgstetten
    {Coordinate{30.1332, 59.5535}, CountryId{"RU"}}, // Q114802069
    {Coordinate{29.7818, 58.6896}, CountryId{"RU"}}, // Q114814142
    {Coordinate{29.6936, 58.6416}, CountryId{"RU"}}, // Q114814147
    {Coordinate{29.612, 58.5838}, CountryId{"RU"}}, // Q114814148
    {Coordinate{29.4796, 58.5083}, CountryId{"RU"}}, // Lyamtsevo railway station
    {Coordinate{29.2092, 58.3326}, CountryId{"RU"}}, // Q114814157
    {Coordinate{29.1114, 58.2661}, CountryId{"RU"}}, // Q114814159
    {Coordinate{29.0565, 58.2283}, CountryId{"RU"}}, // Q114814160
    {Coordinate{28.9885, 58.1811}, CountryId{"RU"}}, // Q114814161
    {Coordinate{28.8754, 58.1118}, CountryId{"RU"}}, // Q114814163
    {Coordinate{28.7353, 58.028}, CountryId{"RU"}}, // Q114814167
    {Coordinate{28.6714, 57.9899}, CountryId{"RU"}}, // Q114814168
    {Coordinate{28.5951, 57.9347}, CountryId{"RU"}}, // Q114814170
    {Coordinate{28.5336, 57.8969}, CountryId{"RU"}}, // Q114814173
    {Coordinate{28.5025, 57.8792}, CountryId{"RU"}}, // Q114814175
    {Coordinate{28.4819, 57.8675}, CountryId{"RU"}}, // Q114814177
    {Coordinate{28.361, 57.7847}, CountryId{"RU"}}, // Q114827654
    {Coordinate{28.311, 57.6561}, CountryId{"RU"}}, // Q114827656
    {Coordinate{28.314, 57.5849}, CountryId{"RU"}}, // Q114827658
    {Coordinate{28.3338, 57.4882}, CountryId{"RU"}}, // Q114827662
    {Coordinate{28.2133, 57.2611}, CountryId{"RU"}}, // Bryanchaninovo railway station
    {Coordinate{28.1318, 57.2179}, CountryId{"RU"}}, // Q114827665
    {Coordinate{28.0726, 57.1546}, CountryId{"RU"}}, // Q114827667
    {Coordinate{1.60779, 49.3024}, CountryId{"FR"}}, // Q114836112
    {Coordinate{1.26986, 48.9056}, CountryId{"FR"}}, // Q114836178
    {Coordinate{0.920511, 48.8315}, CountryId{"FR"}}, // Q114836193
    {Coordinate{6.50359, 51.3034}, CountryId{"DE"}}, // Krefeld-Forsthaus train station
    {Coordinate{-73.5668, 45.4996}, CountryId{"CA"}}, // Montreal Central Station
    {Coordinate{10.5431, 49.5569}, CountryId{"DE"}}, // Dietersheim
    {Coordinate{29.8343, 58.7091}, CountryId{"RU"}}, // Q114878748
    {Coordinate{29.8946, 58.6911}, CountryId{"RU"}}, // Q114878749
    {Coordinate{30.005, 58.6678}, CountryId{"RU"}}, // Q114878751
    {Coordinate{30.1843, 58.6503}, CountryId{"RU"}}, // Q114878754
    {Coordinate{30.2183, 58.6507}, CountryId{"RU"}}, // Q114878755
    {Coordinate{30.4298, 58.6279}, CountryId{"RU"}}, // Q114894378
    {Coordinate{30.5589, 58.6195}, CountryId{"RU"}}, // Q114894380
    {Coordinate{30.6255, 58.6223}, CountryId{"RU"}}, // Q114894381
    {Coordinate{30.6803, 58.6213}, CountryId{"RU"}}, // Q114894382
    {Coordinate{30.7515, 58.6225}, CountryId{"RU"}}, // Q114894385
    {Coordinate{30.8327, 58.6122}, CountryId{"RU"}}, // Q114894386
    {Coordinate{31.0667, 58.5873}, CountryId{"RU"}}, // Q114894389
    {Coordinate{31.1803, 58.5689}, CountryId{"RU"}}, // Q114894391
    {Coordinate{31.2344, 58.5517}, CountryId{"RU"}}, // Novgorod-Luzhsky railway station
    {Coordinate{30.9317, 58.6024}, CountryId{"RU"}}, // Q114894413
    {Coordinate{30.57, 59.9248}, CountryId{"RU"}}, // Q114895966
    {Coordinate{30.6379, 59.8796}, CountryId{"RU"}}, // Q114895967
    {Coordinate{30.7086, 59.861}, CountryId{"RU"}}, // Q114895968
    {Coordinate{30.7332, 59.8542}, CountryId{"RU"}}, // Q114895969
    {Coordinate{30.7727, 59.8431}, CountryId{"RU"}}, // Q114895970
    {Coordinate{30.8247, 59.8286}, CountryId{"RU"}}, // Q114895971
    {Coordinate{21.4807, 47.5686}, CountryId{"HU"}}, // Q114985144
    {Coordinate{18.9947, 46.5348}, CountryId{"HU"}}, // Q114985146
    {Coordinate{18.9272, 46.1836}, CountryId{"HU"}}, // Q114985222
    {Coordinate{18.2035, 47.0135}, CountryId{"HU"}}, // Q114985230
    {Coordinate{21.4591, 47.5759}, CountryId{"HU"}}, // Q114985231
    {Coordinate{19.0697, 46.5261}, CountryId{"HU"}}, // Q114985232
    {Coordinate{30.1033, 59.5597}, CountryId{"RU"}}, // Q114987447
    {Coordinate{10.4255, 49.6461}, CountryId{"DE"}}, // Markt Bibart
    {Coordinate{10.255, 49.6968}, CountryId{"DE"}}, // Iphofen
    {Coordinate{10.1454, 49.7629}, CountryId{"DE"}}, // Buchbrunn-Mainstockheim
    {Coordinate{28.7018, 59.315}, CountryId{"RU"}}, // Q115058463
    {Coordinate{28.6728, 59.2822}, CountryId{"RU"}}, // Q115058464
    {Coordinate{28.5441, 59.2446}, CountryId{"RU"}}, // Q115058465
    {Coordinate{28.437, 59.2132}, CountryId{"RU"}}, // Q115058466
    {Coordinate{28.3869, 59.1945}, CountryId{"RU"}}, // Q115058467
    {Coordinate{28.2534, 59.1406}, CountryId{"RU"}}, // Q115058468
    {Coordinate{28.1851, 59.1168}, CountryId{"RU"}}, // Q115058469
    {Coordinate{11.8803, 45.4175}, CountryId{"IT"}}, // Padova railway station
    {Coordinate{11.1401, 49.5585}, CountryId{"DE"}}, // Kalchreuth
    {Coordinate{28.6255, 60.7586}, CountryId{"RU"}}, // Q115095318
    {Coordinate{28.5392, 60.7852}, CountryId{"RU"}}, // Q115095319
    {Coordinate{11.1722, 49.565}, CountryId{"DE"}}, // Großgeschaidt
    {Coordinate{11.2217, 49.5919}, CountryId{"DE"}}, // Forth
    {Coordinate{11.2317, 49.6086}, CountryId{"DE"}}, // Rüsselbach
    {Coordinate{11.2491, 49.629}, CountryId{"DE"}}, // Weißenohe
    {Coordinate{1.00428, 49.2841}, CountryId{"FR"}}, // Q115119062
    {Coordinate{1.03704, 49.412}, CountryId{"FR"}}, // Q115119079
    {Coordinate{1.02348, 49.3822}, CountryId{"FR"}}, // Q115119133
    {Coordinate{1.03641, 49.2682}, CountryId{"FR"}}, // Q115119193
    {Coordinate{20.0804, 46.2227}, CountryId{"HU"}}, // Q115121167
    {Coordinate{8.65851, 50.0054}, CountryId{"DE"}}, // Langen Flugsicherung station
    {Coordinate{8.56074, 50.1437}, CountryId{"DE"}}, // Eschborn
    {Coordinate{8.53446, 50.1598}, CountryId{"DE"}}, // Schwalbach (Taunus) Nord
    {Coordinate{8.52804, 50.1545}, CountryId{"DE"}}, // Schwalbach (Taunus) Limes
    {Coordinate{8.51756, 50.1387}, CountryId{"DE"}}, // Sulzbach (Taunus) Nord
    {Coordinate{8.45672, 50.0395}, CountryId{"DE"}}, // Q115124384
    {Coordinate{8.8288, 50.0817}, CountryId{"DE"}}, // Offenbach-Waldhof
    {Coordinate{8.87584, 50.0388}, CountryId{"DE"}}, // Q115125054
    {Coordinate{8.88423, 50.0112}, CountryId{"DE"}}, // Rodgau-Dudenhofen station
    {Coordinate{8.84656, 49.988}, CountryId{"DE"}}, // Rodgau-Rollwald station
    {Coordinate{8.86983, 49.9969}, CountryId{"DE"}}, // Rodgau-Nieder-Roden station
    {Coordinate{8.4937, 49.8773}, CountryId{"DE"}}, // Groß Gerau-Dornheim
    {Coordinate{8.36457, 50.1409}, CountryId{"DE"}}, // Eppstein-Bremthal station
    {Coordinate{8.47528, 50.0823}, CountryId{"DE"}}, // Q115126696
    {Coordinate{15.239, 66.4935}, CountryId{"NO"}}, // Bolna Station
    {Coordinate{9.38153, 49.3788}, CountryId{"DE"}}, // Sennfeld station
    {Coordinate{8.64862, 49.5913}, CountryId{"DE"}}, // Q115205658
    {Coordinate{8.64463, 49.6117}, CountryId{"DE"}}, // Laudenbach (Bergstraße)
    {Coordinate{8.76743, 50.2802}, CountryId{"DE"}}, // Nieder-Wöllstadt station
    {Coordinate{8.75338, 50.2527}, CountryId{"DE"}}, // Q115209774
    {Coordinate{8.75117, 50.2075}, CountryId{"DE"}}, // Q115209792
    {Coordinate{142.731, 46.8058}, CountryId{"RU"}}, // Mitsulyovka railway station
    {Coordinate{142.763, 46.6444}, CountryId{"RU"}}, // Q11541243
    {Coordinate{10.3591, 50.663}, CountryId{"DE"}}, // Wasungen
    {Coordinate{14.0218, 48.3021}, CountryId{"AT"}}, // Eferding Gewerbegebiet railway station
    {Coordinate{14.0284, 48.2928}, CountryId{"AT"}}, // Unterhillinglah railway station
    {Coordinate{14.2802, 48.2801}, CountryId{"AT"}}, // Untergaumberg railway station
    {Coordinate{14.2546, 48.2745}, CountryId{"AT"}}, // Leonding Lokalbahn railway station
    {Coordinate{14.2458, 48.2746}, CountryId{"AT"}}, // Leonding Straßfeld railway station
    {Coordinate{8.16025, 47.3532}, CountryId{"CH"}}, // Seon Nord railway station
    {Coordinate{10.6552, 44.7244}, CountryId{"IT"}}, // Reggio Emilia AV Mediopadana railway station
    {Coordinate{-87.6403, 41.8786}, CountryId{"US"}}, // Chicago Union Station
    {Coordinate{18.2747, 49.8429}, CountryId{"CZ"}}, // Q115599772
    {Coordinate{8.65011, 49.528}, CountryId{"DE"}}, // Q115604783
    {Coordinate{8.63366, 49.5093}, CountryId{"DE"}}, // Q115604791
    {Coordinate{18.4585, 49.8462}, CountryId{"CZ"}}, // Doubrava
    {Coordinate{13.7398, 42.1434}, CountryId{"IT"}}, // Molina-Castelvecchio Subequo railway station
    {Coordinate{9.36247, 47.4173}, CountryId{"CH"}}, // St. Gallen Güterbahnhof
    {Coordinate{17.0767, 49.8126}, CountryId{"CZ"}}, // Q115708964
    {Coordinate{11.3357, 49.775}, CountryId{"DE"}}, // Behringersmühle
    {Coordinate{11.1417, 49.7355}, CountryId{"DE"}}, // Kirchehrenbach
    {Coordinate{11.2579, 49.8027}, CountryId{"DE"}}, // Muggendorf
    {Coordinate{11.1999, 49.7958}, CountryId{"DE"}}, // Gasseldorf
    {Coordinate{11.2176, 49.8081}, CountryId{"DE"}}, // Streitberg
    {Coordinate{11.2855, 49.7832}, CountryId{"DE"}}, // Burggaillenreuth
    {Coordinate{11.0971, 49.6988}, CountryId{"DE"}}, // Pinzberg
    {Coordinate{11.1095, 49.7047}, CountryId{"DE"}}, // Gosberg
    {Coordinate{11.1267, 49.7134}, CountryId{"DE"}}, // Wiesenthau
    {Coordinate{11.1701, 49.7573}, CountryId{"DE"}}, // Pretzfeld
    {Coordinate{7.79136, 47.0434}, CountryId{"CH"}}, // Wasen i.E., Bahnhof
    {Coordinate{19.6598, 48.2586}, CountryId{"SK"}}, // Kalonda railway station
    {Coordinate{19.6772, 48.276}, CountryId{"SK"}}, // Rapovce railway station
    {Coordinate{19.6791, 48.3002}, CountryId{"SK"}}, // Mikušovce railway station
    {Coordinate{7.77476, 46.0745}, CountryId{"CH"}}, // Täsch monte rosa railway station
    {Coordinate{22.696, 56.196}, CountryId{"LT"}}, // Akmenė train station
    {Coordinate{13.3975, 56.1364}, CountryId{"SE"}}, // Perstorp railway station
    {Coordinate{15.4058, 60.1363}, CountryId{"SE"}}, // Smedjebacken station
    {Coordinate{12.6799, 52.9467}, CountryId{"DE"}}, // Walsleben station
    {Coordinate{13.0217, 52.8044}, CountryId{"DE"}}, // Beetz-Sommerfeld station
    {Coordinate{2.7775, 47.6092}, CountryId{"FR"}}, // Gare de Châtillon-sur-Loire
    {Coordinate{141.943, 46.8456}, CountryId{"RU"}}, // Q11584599
    {Coordinate{10.3623, 48.2898}, CountryId{"DE"}}, // Hirschfelden railway station
    {Coordinate{9.70076, 48.9873}, CountryId{"DE"}}, // Fichtenberg railway station
    {Coordinate{12.9644, 47.8149}, CountryId{"DE"}}, // Ainring station
    {Coordinate{15.2806, 37.0689}, CountryId{"IT"}}, // Syracuse railway station
    {Coordinate{12.2292, 53.2563}, CountryId{"DE"}}, // Brügge (Prignitz)
    {Coordinate{12.2127, 53.2136}, CountryId{"DE"}}, // Falkenhagen Gewerbepark Prignitz
    {Coordinate{12.2695, 53.1074}, CountryId{"DE"}}, // Bölzke
    {Coordinate{12.3432, 53.0382}, CountryId{"DE"}}, // Rosenwinkel
    {Coordinate{12.3528, 53.0042}, CountryId{"DE"}}, // Wutike
    {Coordinate{12.3299, 52.5601}, CountryId{"DE"}}, // Mögelin station
    {Coordinate{12.3335, 52.536}, CountryId{"DE"}}, // Premnitz Nord
    {Coordinate{12.3431, 52.5292}, CountryId{"DE"}}, // Premnitz Zentrum station
    {Coordinate{14.1123, 51.5818}, CountryId{"DE"}}, // Bahnsdorf
    {Coordinate{13.8908, 51.4736}, CountryId{"DE"}}, // Schwarzheide Ost station
    {Coordinate{14.1337, 51.4432}, CountryId{"DE"}}, // Schwarzkollm station
    {Coordinate{12.8275, 51.8324}, CountryId{"DE"}}, // Elster (Elbe) station
    {Coordinate{12.7482, 51.8557}, CountryId{"DE"}}, // Mühlanger station
    {Coordinate{12.6941, 51.8715}, CountryId{"DE"}}, // Lutherstadt Wittenberg-Labetz station
    {Coordinate{12.5237, 51.8805}, CountryId{"DE"}}, // Griebo station
    {Coordinate{15.1141, 47.3854}, CountryId{"AT"}}, // Leoben Lerchenfeld railway station
    {Coordinate{13.5157, 51.3486}, CountryId{"DE"}}, // Zabeltitz station
    {Coordinate{13.5036, 51.3844}, CountryId{"DE"}}, // Frauenhain station
    {Coordinate{13.5009, 51.4259}, CountryId{"DE"}}, // Prösen Ost station
    {Coordinate{20.6715, 48.8121}, CountryId{"SK"}}, // Stará Voda railway station
    {Coordinate{13.6802, 51.3085}, CountryId{"DE"}}, // Lampertswalde station
    {Coordinate{15.5371, 60.0725}, CountryId{"SE"}}, // Söderbärke railway station
    {Coordinate{14.474, 57.6978}, CountryId{"SE"}}, // Forserum
    {Coordinate{16.2082, 59.7698}, CountryId{"SE"}}, // Ramnäs station
    {Coordinate{12.3372, 63.29}, CountryId{"SE"}}, // Enafors
    {Coordinate{14.9757, 57.6638}, CountryId{"SE"}}, // Eksjö
    {Coordinate{15.082, 57.4258}, CountryId{"SE"}}, // Vetlanda
    {Coordinate{15.2288, 59.5946}, CountryId{"SE"}}, // Lindesberg
    {Coordinate{11.9211, 58.2247}, CountryId{"SE"}}, // Ljungskile
    {Coordinate{12.9123, 56.0831}, CountryId{"SE"}}, // Bjuv
    {Coordinate{13.0083, 57.8269}, CountryId{"SE"}}, // Fristad
    {Coordinate{13.1284, 56.1308}, CountryId{"SE"}}, // Klippan
    {Coordinate{16.0094, 59.9585}, CountryId{"SE"}}, // Ängelsberg
    {Coordinate{13.0149, 57.8832}, CountryId{"SE"}}, // Borgstena
    {Coordinate{14.4536, 56.787}, CountryId{"SE"}}, // Vislanda
    {Coordinate{12.9492, 56.134}, CountryId{"SE"}}, // Aastorp Station
    {Coordinate{12.8437, 57.6286}, CountryId{"SE"}}, // Viskafors railway station
    {Coordinate{14.3264, 57.7052}, CountryId{"SE"}}, // Tenhult
    {Coordinate{13.9169, 56.1049}, CountryId{"SE"}}, // Vinslöv
    {Coordinate{12.3004, 57.1735}, CountryId{"SE"}}, // Tofta (Varberg kn) station
    {Coordinate{14.0768, 57.9066}, CountryId{"SE"}}, // Habo
    {Coordinate{12.5004, 57.6546}, CountryId{"SE"}}, // Rävlanda
    {Coordinate{12.5688, 57.6672}, CountryId{"SE"}}, // Bollebygd
    {Coordinate{13.5934, 56.4589}, CountryId{"SE"}}, // Markaryd
    {Coordinate{12.3198, 57.2304}, CountryId{"SE"}}, // Derome station
    {Coordinate{14.9869, 59.8727}, CountryId{"SE"}}, // Kopparberg
    {Coordinate{12.6697, 57.4948}, CountryId{"SE"}}, // Assberg station
    {Coordinate{13.5982, 56.1598}, CountryId{"SE"}}, // Tyringe
    {Coordinate{15.1386, 60.5602}, CountryId{"SE"}}, // Djuraas station
    {Coordinate{12.6486, 57.4882}, CountryId{"SE"}}, // Skene
    {Coordinate{11.9357, 58.1449}, CountryId{"SE"}}, // Svenshögen
    {Coordinate{16.2325, 59.5638}, CountryId{"SE"}}, // Kolbäck
    {Coordinate{15.0814, 60.5988}, CountryId{"SE"}}, // Gagnef
    {Coordinate{12.5984, 57.467}, CountryId{"SE"}}, // Berghem (Mark kn) station
    {Coordinate{14.3114, 56.9863}, CountryId{"SE"}}, // Rydaholm
    {Coordinate{16.5704, 61.231}, CountryId{"SE"}}, // Kilafors
    {Coordinate{14.2714, 59.5332}, CountryId{"SE"}}, // Storfors
    {Coordinate{12.7899, 57.5578}, CountryId{"SE"}}, // Fritsla station
    {Coordinate{12.3376, 57.2669}, CountryId{"SE"}}, // Veddige
    {Coordinate{14.8108, 57.8362}, CountryId{"SE"}}, // Aneby station
    {Coordinate{14.6448, 56.8701}, CountryId{"SE"}}, // Gemla
    {Coordinate{17.7061, 59.9561}, CountryId{"SE"}}, // Storvreta
    {Coordinate{12.4773, 57.3533}, CountryId{"SE"}}, // Horred
    {Coordinate{16.4102, 57.897}, CountryId{"SE"}}, // Gamleby
    {Coordinate{13.6633, 56.3421}, CountryId{"SE"}}, // Vittsjö
    {Coordinate{17.7372, 60.0797}, CountryId{"SE"}}, // Skyttorp station
    {Coordinate{11.851, 57.9444}, CountryId{"SE"}}, // Kode
    {Coordinate{17.7311, 60.0257}, CountryId{"SE"}}, // Vattholma station
    {Coordinate{16.2079, 58.1434}, CountryId{"SE"}}, // Falerum
    {Coordinate{15.0193, 57.4897}, CountryId{"SE"}}, // Ekenässjön
    {Coordinate{12.8171, 56.0293}, CountryId{"SE"}}, // Påarp
    {Coordinate{14.1155, 57.7045}, CountryId{"SE"}}, // Norrahammar station
    {Coordinate{14.0869, 57.6788}, CountryId{"SE"}}, // Taberg station
    {Coordinate{13.0228, 57.906}, CountryId{"SE"}}, // Mollaryd station
    {Coordinate{14.8333, 57.6648}, CountryId{"SE"}}, // Ormaryd
    {Coordinate{13.0295, 57.9406}, CountryId{"SE"}}, // Torpaakra station
    {Coordinate{12.6982, 57.506}, CountryId{"SE"}}, // Kinna station
    {Coordinate{16.38, 61.4703}, CountryId{"SE"}}, // Arbrå
    {Coordinate{17.4306, 60.4909}, CountryId{"SE"}}, // Marma station
    {Coordinate{16.4132, 60.2959}, CountryId{"SE"}}, // Horndals Bruk station
    {Coordinate{16.6728, 61.0448}, CountryId{"SE"}}, // Lingbo
    {Coordinate{16.2194, 59.6159}, CountryId{"SE"}}, // Hallstahammar
    {Coordinate{16.853, 59.9405}, CountryId{"SE"}}, // Heby
    {Coordinate{16.3205, 59.4509}, CountryId{"SE"}}, // Kvicksund
    {Coordinate{16.6401, 59.81}, CountryId{"SE"}}, // Ransta
    {Coordinate{15.6423, 60.0323}, CountryId{"SE"}}, // Vad station
    {Coordinate{16.3142, 60.2083}, CountryId{"SE"}}, // Fors
    {Coordinate{16.9616, 59.9328}, CountryId{"SE"}}, // Morgongaava station
    {Coordinate{16.3677, 61.5175}, CountryId{"SE"}}, // Vallsta
    {Coordinate{13.2002, 55.7512}, CountryId{"SE"}}, // Staangby station
    {Coordinate{11.8355, 58.0183}, CountryId{"SE"}}, // Stora Höga
    {Coordinate{16.0728, 60.0366}, CountryId{"SE"}}, // Karbenning
    {Coordinate{12.9956, 55.884}, CountryId{"SE"}}, // Billeberga
    {Coordinate{12.9766, 56.0565}, CountryId{"SE"}}, // Billesholm
    {Coordinate{13.3949, 55.9008}, CountryId{"SE"}}, // Stehag
    {Coordinate{13.244, 55.7789}, CountryId{"SE"}}, // Örtofta
    {Coordinate{14.9178, 57.5208}, CountryId{"SE"}}, // Björköby station
    {Coordinate{14.6933, 57.5041}, CountryId{"SE"}}, // Bodafors station
    {Coordinate{14.8229, 57.5825}, CountryId{"SE"}}, // Stensjön (Nässjö kn) station
    {Coordinate{14.129, 57.8609}, CountryId{"SE"}}, // Bankeryd
    {Coordinate{12.5235, 57.4277}, CountryId{"SE"}}, // Björketorp station
    {Coordinate{15.9744, 58.2056}, CountryId{"SE"}}, // Basthagen station
    {Coordinate{14.1694, 57.1159}, CountryId{"SE"}}, // Bor
    {Coordinate{13.2473, 58.4933}, CountryId{"SE"}}, // Filsbäck station
    {Coordinate{13.147, 58.5085}, CountryId{"SE"}}, // Framnäs City station
    {Coordinate{17.3318, 60.6512}, CountryId{"SE"}}, // Furuvik station
    {Coordinate{14.1242, 57.7351}, CountryId{"SE"}}, // Hovslätt station
    {Coordinate{12.8732, 56.0557}, CountryId{"SE"}}, // Mörarp
    {Coordinate{17.6361, 60.2584}, CountryId{"SE"}}, // Tobo
    {Coordinate{13.3475, 58.5945}, CountryId{"SE"}}, // Trolmen station
    {Coordinate{13.5597, 58.634}, CountryId{"SE"}}, // Österäng station
    {Coordinate{12.9426, 57.7337}, CountryId{"SE"}}, // Knalleland
    {Coordinate{13.8489, 56.2145}, CountryId{"SE"}}, // Ballingslov Station
    {Coordinate{14.7024, 57.6696}, CountryId{"SE"}}, // Nässjö Brinellskolan station
    {Coordinate{13.0834, 55.9995}, CountryId{"SE"}}, // Kaegeröd st
    {Coordinate{12.7447, 56.1049}, CountryId{"SE"}}, // Ödaakra station
    {Coordinate{12.7784, 56.1444}, CountryId{"SE"}}, // Kattarp
    {Coordinate{12.9117, 55.8609}, CountryId{"SE"}}, // Häljarp station
    {Coordinate{12.9527, 55.9265}, CountryId{"SE"}}, // Taagarp (Svalöv kn) station
    {Coordinate{12.7836, 55.9659}, CountryId{"SE"}}, // Rydebäck station
    {Coordinate{12.8121, 55.9456}, CountryId{"SE"}}, // Glumslöv station
    {Coordinate{16.4892, 60.5141}, CountryId{"SE"}}, // Torsaker
    {Coordinate{17.4005, 60.4501}, CountryId{"SE"}}, // Mehedeby station
    {Coordinate{17.4278, 60.5553}, CountryId{"SE"}}, // Älvkarleby station
    {Coordinate{14.0984, 56.4748}, CountryId{"SE"}}, // Killeberg station
    {Coordinate{13.7069, 56.2914}, CountryId{"SE"}}, // Bjärnum
    {Coordinate{13.0469, 56.1372}, CountryId{"SE"}}, // Kvidinge
    {Coordinate{13.1326, 55.4678}, CountryId{"SE"}}, // Ö Grevie station
    {Coordinate{13.159, 55.8647}, CountryId{"SE"}}, // Marieholm station
    {Coordinate{17.3773, 62.2684}, CountryId{"SE"}}, // Njurundabommen
    {Coordinate{14.2153, 56.6342}, CountryId{"SE"}}, // Diö station
    {Coordinate{13.1102, 55.9113}, CountryId{"SE"}}, // Svalöv
    {Coordinate{12.8617, 55.9638}, CountryId{"SE"}}, // Vallaakra station
    {Coordinate{13.7721, 57.9884}, CountryId{"SE"}}, // Sandhem
    {Coordinate{14.0652, 57.172}, CountryId{"SE"}}, // Rörstorp station
    {Coordinate{14.3593, 62.4793}, CountryId{"SE"}}, // Röjan
    {Coordinate{14.5854, 57.171}, CountryId{"SE"}}, // Lammhult station
    {Coordinate{15.9718, 58.5461}, CountryId{"SE"}}, // Kimstad
    {Coordinate{7.07824, 46.099}, CountryId{"CH"}}, // Martigny-Expo
    {Coordinate{6.90654, 46.4617}, CountryId{"CH"}}, // Chantemerle-près-Blonay
    {Coordinate{6.85313, 46.469}, CountryId{"CH"}}, // Vevey Vignerons
    {Coordinate{14.172, 50.7795}, CountryId{"CZ"}}, // Q116008668
    {Coordinate{-3.85844, 42.9964}, CountryId{"ES"}}, // Cabañas de Virtus
    {Coordinate{23.1442, 39.3271}, CountryId{"GR"}}, // Milee
    {Coordinate{18.7305, 45.23}, CountryId{"HR"}}, // Andrijasevci
    {Coordinate{18.6701, 45.4837}, CountryId{"HR"}}, // Antunovac
    {Coordinate{17.2085, 45.5029}, CountryId{"HR"}}, // Badljevina
    {Coordinate{16.1885, 43.6416}, CountryId{"HR"}}, // Bakovici
    {Coordinate{15.9982, 46.0417}, CountryId{"HR"}}, // Bedekovcina
    {Coordinate{15.479, 45.4222}, CountryId{"HR"}}, // Belavici
    {Coordinate{17.2609, 45.5739}, CountryId{"HR"}}, // Bijela
    {Coordinate{18.859, 45.5132}, CountryId{"HR"}}, // Bijelo Brdo
    {Coordinate{18.453, 45.5872}, CountryId{"HR"}}, // Bizovac
    {Coordinate{16.8447, 45.8941}, CountryId{"HR"}}, // Bjelovar
    {Coordinate{17.7573, 45.3357}, CountryId{"HR"}}, // Blacko-Jaksic
    {Coordinate{16.4577, 45.4158}, CountryId{"HR"}}, // Blinjski Kut
    {Coordinate{14.0523, 45.3044}, CountryId{"HR"}}, // Borut
    {Coordinate{16.3071, 45.8223}, CountryId{"HR"}}, // Bozjakovina
    {Coordinate{16.4946, 45.383}, CountryId{"HR"}}, // Brdani Krajiski
    {Coordinate{16.2016, 43.6293}, CountryId{"HR"}}, // Brdasce
    {Coordinate{15.7664, 45.8638}, CountryId{"HR"}}, // Brdovec
    {Coordinate{16.8919, 46.1267}, CountryId{"HR"}}, // Bregi
    {Coordinate{17.0342, 45.4448}, CountryId{"HR"}}, // Brezine Bujavica
    {Coordinate{16.5679, 45.9512}, CountryId{"HR"}}, // Brezovljani
    {Coordinate{18.6721, 45.5171}, CountryId{"HR"}}, // Brijest
    {Coordinate{15.3832, 45.638}, CountryId{"HR"}}, // Brlog Grad
    {Coordinate{14.9613, 45.465}, CountryId{"HR"}}, // Brod Moravice
    {Coordinate{17.7952, 45.1606}, CountryId{"HR"}}, // Brodski Stupnik
    {Coordinate{18.8903, 45.3557}, CountryId{"HR"}}, // Bršadin
    {Coordinate{18.9165, 45.3677}, CountryId{"HR"}}, // Brsadin-Lipovaca
    {Coordinate{17.7576, 45.2472}, CountryId{"HR"}}, // Bucje-Koprivnica
    {Coordinate{16.2138, 46.1283}, CountryId{"HR"}}, // Budinšćina railway station
    {Coordinate{18.4207, 45.261}, CountryId{"HR"}}, // Budrovci
    {Coordinate{15.7406, 43.98}, CountryId{"HR"}}, // Bulić
    {Coordinate{15.9984, 45.7434}, CountryId{"HR"}}, // Buzin
    {Coordinate{13.8649, 45.0309}, CountryId{"HR"}}, // Čabrunići Selo railway stop
    {Coordinate{13.866, 45.0416}, CountryId{"HR"}}, // Čabrunići railway stop
    {Coordinate{17.5814, 45.7581}, CountryId{"HR"}}, // Cabuna
    {Coordinate{17.869, 45.5986}, CountryId{"HR"}}, // Cacinci
    {Coordinate{17.9899, 45.3484}, CountryId{"HR"}}, // Caglin
    {Coordinate{16.6471, 46.0655}, CountryId{"HR"}}, // Carevdar
    {Coordinate{16.6165, 46.3703}, CountryId{"HR"}}, // Cehovec
    {Coordinate{18.6556, 45.6857}, CountryId{"HR"}}, // Ceminac
    {Coordinate{18.5779, 45.5222}, CountryId{"HR"}}, // Cepin
    {Coordinate{16.1769, 43.7048}, CountryId{"HR"}}, // Cera
    {Coordinate{16.2187, 46.2597}, CountryId{"HR"}}, // Cerje Tužno
    {Coordinate{18.699, 45.1942}, CountryId{"HR"}}, // Cerna
    {Coordinate{16.773, 45.2226}, CountryId{"HR"}}, // Cerovljani
    {Coordinate{14.0139, 45.2765}, CountryId{"HR"}}, // Cerovilje
    {Coordinate{17.9171, 45.3341}, CountryId{"HR"}}, // Ciglenik
    {Coordinate{16.6591, 45.9403}, CountryId{"HR"}}, // Cirkvena
    {Coordinate{18.4098, 45.5736}, CountryId{"HR"}}, // Cret
    {Coordinate{16.666, 46.236}, CountryId{"HR"}}, // Cukovec
    {Coordinate{16.0635, 45.8208}, CountryId{"HR"}}, // Čulinec
    {Coordinate{16.0106, 43.6727}, CountryId{"HR"}}, // Dabar
    {Coordinate{18.4217, 45.3136}, CountryId{"HR"}}, // Đakovo
    {Coordinate{18.9672, 45.5004}, CountryId{"HR"}}, // Dalj
    {Coordinate{18.6992, 45.634}, CountryId{"HR"}}, // Darda
    {Coordinate{16.46, 45.6895}, CountryId{"HR"}}, // Deanovec
    {Coordinate{14.7965, 45.3922}, CountryId{"HR"}}, // Delnice
    {Coordinate{15.7089, 45.673}, CountryId{"HR"}}, // Desinec
    {Coordinate{15.8626, 43.9627}, CountryId{"HR"}}, // Đevreske
    {Coordinate{15.8632, 46.1716}, CountryId{"HR"}}, // Dolice
    {Coordinate{15.6326, 45.6332}, CountryId{"HR"}}, // Domagovic
    {Coordinate{15.966, 45.9831}, CountryId{"HR"}}, // Donja Stubica
    {Coordinate{18.1215, 45.1636}, CountryId{"HR"}}, // Donja Vrba
    {Coordinate{17.2726, 45.6465}, CountryId{"HR"}}, // Donja Vrijeska
    {Coordinate{15.3627, 45.312}, CountryId{"HR"}}, // Donje Dubrave
    {Coordinate{16.1266, 43.6518}, CountryId{"HR"}}, // Donji Dolac
    {Coordinate{16.6451, 46.3679}, CountryId{"HR"}}, // Donji Kraljevec
    {Coordinate{16.1357, 46.0479}, CountryId{"HR"}}, // Donji Lipovec
    {Coordinate{16.7239, 46.3611}, CountryId{"HR"}}, // Donji Mihaljevec
    {Coordinate{18.5503, 45.4631}, CountryId{"HR"}}, // Dopsin
    {Coordinate{17.2882, 45.2526}, CountryId{"HR"}}, // Dragalic
    {Coordinate{17.7064, 45.2146}, CountryId{"HR"}}, // Dragovci
    {Coordinate{18.859, 44.9198}, CountryId{"HR"}}, // Drenovci
    {Coordinate{14.6913, 45.2672}, CountryId{"HR"}}, // Drivenik
    {Coordinate{16.1703, 43.8617}, CountryId{"HR"}}, // Drnis
    {Coordinate{15.9526, 46.0209}, CountryId{"HR"}}, // Dubrava Zabocka
    {Coordinate{15.896, 46.0961}, CountryId{"HR"}}, // Dukovec
    {Coordinate{17.4313, 45.6643}, CountryId{"HR"}}, // Djulovac
    {Coordinate{15.8432, 46.1937}, CountryId{"HR"}}, // Djurmanec
    {Coordinate{19.0491, 45.5074}, CountryId{"HR"}}, // Erdut
    {Coordinate{18.6676, 45.4451}, CountryId{"HR"}}, // Ernestinovo
    {Coordinate{17.9809, 45.5382}, CountryId{"HR"}}, // Fericanci
    {Coordinate{14.7155, 45.3027}, CountryId{"HR"}}, // Fuzine
    {Coordinate{18.7432, 45.3542}, CountryId{"HR"}}, // Gabos
    {Coordinate{15.8728, 45.8136}, CountryId{"HR"}}, // Gajnice
    {Coordinate{15.3758, 45.3456}, CountryId{"HR"}}, // Generalski Stol
    {Coordinate{15.9836, 46.1737}, CountryId{"HR"}}, // Golubovec
    {Coordinate{15.1284, 45.3428}, CountryId{"HR"}}, // Gomirje
    {Coordinate{16.0041, 45.9833}, CountryId{"HR"}}, // Gornja Stubica
    {Coordinate{15.3075, 45.279}, CountryId{"HR"}}, // Gornje Dubrave
    {Coordinate{15.4124, 45.376}, CountryId{"HR"}}, // Gornji Zvecaj
    {Coordinate{15.3844, 44.5415}, CountryId{"HR"}}, // Gospic
    {Coordinate{16.5415, 45.2805}, CountryId{"HR"}}, // Grabostani
    {Coordinate{15.8337, 44.2982}, CountryId{"HR"}}, // Gracac
    {Coordinate{16.4844, 45.913}, CountryId{"HR"}}, // Gradec
    {Coordinate{18.7033, 45.1469}, CountryId{"HR"}}, // Gradiste
    {Coordinate{16.2931, 45.5306}, CountryId{"HR"}}, // Greda
    {Coordinate{16.9082, 45.9138}, CountryId{"HR"}}, // Grginac Novi
    {Coordinate{16.8931, 45.9094}, CountryId{"HR"}}, // Grginac
    {Coordinate{18.8444, 44.8828}, CountryId{"HR"}}, // Gunja
    {Coordinate{16.5865, 45.9267}, CountryId{"HR"}}, // Haganj
    {Coordinate{15.6858, 45.8915}, CountryId{"HR"}}, // Harmica
    {Coordinate{13.8872, 45.2155}, CountryId{"HR"}}, // Heki
    {Coordinate{15.8175, 45.7137}, CountryId{"HR"}}, // Horvati
    {Coordinate{16.1997, 46.1055}, CountryId{"HR"}}, // Hrascina-Trgovisce
    {Coordinate{18.5399, 45.4433}, CountryId{"HR"}}, // Hrastovac Vucki
    {Coordinate{16.5466, 45.3115}, CountryId{"HR"}}, // Hrastovac
    {Coordinate{15.8082, 46.2067}, CountryId{"HR"}}, // Hromec
    {Coordinate{16.6877, 45.9363}, CountryId{"HR"}}, // Hrsovo
    {Coordinate{16.8062, 45.2217}, CountryId{"HR"}}, // Hrvatska Dubica
    {Coordinate{16.5275, 45.2354}, CountryId{"HR"}}, // Hrvatska Kostajnica
    {Coordinate{15.892, 45.7444}, CountryId{"HR"}}, // Hrvatski Leskovac
    {Coordinate{14.073, 45.3438}, CountryId{"HR"}}, // Hum u Istri
    {Coordinate{15.9263, 46.0209}, CountryId{"HR"}}, // Hum-Lug
    {Coordinate{16.8343, 45.4507}, CountryId{"HR"}}, // Ilova
    {Coordinate{16.3972, 45.7074}, CountryId{"HR"}}, // Ivanic Grad
    {Coordinate{16.4717, 46.2685}, CountryId{"HR"}}, // Jalzabet
    {Coordinate{16.9105, 45.276}, CountryId{"HR"}}, // Jasenovac
    {Coordinate{15.6492, 45.6645}, CountryId{"HR"}}, // Jastrebarsko
    {Coordinate{18.1548, 45.5234}, CountryId{"HR"}}, // Jelisavac
    {Coordinate{15.2871, 45.1933}, CountryId{"HR"}}, // Josipdol
    {Coordinate{13.8652, 45.025}, CountryId{"HR"}}, // Juršići railway stop
    {Coordinate{16.2059, 43.9726}, CountryId{"HR"}}, // Kaldrma
    {Coordinate{17.0959, 46.0128}, CountryId{"HR"}}, // Kalinovac
    {Coordinate{15.4081, 45.6453}, CountryId{"HR"}}, // Kamanje
    {Coordinate{15.5492, 45.4881}, CountryId{"HR"}}, // Karlovac Centar
    {Coordinate{16.4002, 43.5535}, CountryId{"HR"}}, // Kastel Gomilica
    {Coordinate{16.3857, 43.5555}, CountryId{"HR"}}, // Kastel Kambelovac
    {Coordinate{16.43, 43.5489}, CountryId{"HR"}}, // Kastel Sucurac
    {Coordinate{16.7752, 45.9101}, CountryId{"HR"}}, // Klokocevac
    {Coordinate{17.8979, 45.3368}, CountryId{"HR"}}, // Knezci
    {Coordinate{16.179, 46.0506}, CountryId{"HR"}}, // Konjscina
    {Coordinate{16.8171, 46.1652}, CountryId{"HR"}}, // Koprivnica
    {Coordinate{16.1485, 43.6898}, CountryId{"HR"}}, // Koprno
    {Coordinate{17.3581, 45.6542}, CountryId{"HR"}}, // Korenicani
    {Coordinate{15.3288, 45.2206}, CountryId{"HR"}}, // Kosare
    {Coordinate{18.2954, 45.5415}, CountryId{"HR"}}, // Koska
    {Coordinate{16.2096, 43.9497}, CountryId{"HR"}}, // Kosovo
    {Coordinate{16.8084, 46.3537}, CountryId{"HR"}}, // Kotoriba
    {Coordinate{13.8626, 45.1601}, CountryId{"HR"}}, // Krajcar Brijeg
    {Coordinate{15.8724, 46.1595}, CountryId{"HR"}}, // Krapina
    {Coordinate{16.5434, 46.0064}, CountryId{"HR"}}, // Krizevci
    {Coordinate{14.3997, 45.3382}, CountryId{"HR"}}, // Krnjevo
    {Coordinate{16.3215, 46.2249}, CountryId{"HR"}}, // Krusljevec
    {Coordinate{15.3334, 45.234}, CountryId{"HR"}}, // Kukaca
    {Coordinate{17.0827, 45.4352}, CountryId{"HR"}}, // Kukunjevac
    {Coordinate{16.0936, 46.2281}, CountryId{"HR"}}, // Kuljevcica
    {Coordinate{16.7566, 46.1937}, CountryId{"HR"}}, // Kunovec-Subotica
    {Coordinate{14.8906, 45.4001}, CountryId{"HR"}}, // Kupjak
    {Coordinate{15.9264, 45.8106}, CountryId{"HR"}}, // Kustosija
    {Coordinate{17.8131, 45.1637}, CountryId{"HR"}}, // Kuti
    {Coordinate{16.233, 43.5838}, CountryId{"HR"}}, // Labin Dalmatinski
    {Coordinate{15.7199, 45.8784}, CountryId{"HR"}}, // Laduc
    {Coordinate{18.7071, 45.4147}, CountryId{"HR"}}, // Laslovo-Korod
    {Coordinate{15.3624, 45.1122}, CountryId{"HR"}}, // Latin
    {Coordinate{17.957, 45.3371}, CountryId{"HR"}}, // Latinovac
    {Coordinate{15.6253, 45.6065}, CountryId{"HR"}}, // Lazina
    {Coordinate{16.6852, 46.0979}, CountryId{"HR"}}, // Lepavina
    {Coordinate{16.0435, 46.2131}, CountryId{"HR"}}, // Lepoglava
    {Coordinate{15.7174, 43.9908}, CountryId{"HR"}}, // Lepuri
    {Coordinate{14.7151, 45.2816}, CountryId{"HR"}}, // Lic
    {Coordinate{15.3545, 45.1327}, CountryId{"HR"}}, // Licki Podhum
    {Coordinate{15.3585, 44.7734}, CountryId{"HR"}}, // Licko Lesce
    {Coordinate{17.1605, 45.4121}, CountryId{"HR"}}, // Lipik
    {Coordinate{18.5237, 45.4215}, CountryId{"HR"}}, // Lipovac-Koritna
    {Coordinate{15.1705, 45.3284}, CountryId{"HR"}}, // Ljubošina
    {Coordinate{14.7608, 45.3572}, CountryId{"HR"}}, // Lokve
    {Coordinate{16.5141, 45.9236}, CountryId{"HR"}}, // Lubena
    {Coordinate{16.6139, 46.2549}, CountryId{"HR"}}, // Ludbreg
    {Coordinate{16.5695, 45.6007}, CountryId{"HR"}}, // Ludina
    {Coordinate{15.8211, 45.9537}, CountryId{"HR"}}, // Luka
    {Coordinate{17.7168, 45.1705}, CountryId{"HR"}}, // Luzani - Malino
    {Coordinate{16.3099, 46.1696}, CountryId{"HR"}}, // Madarevo
    {Coordinate{15.5341, 45.5509}, CountryId{"HR"}}, // Mahićno
    {Coordinate{16.528, 45.2574}, CountryId{"HR"}}, // Majur
    {Coordinate{16.5902, 46.0267}, CountryId{"HR"}}, // Majurec
    {Coordinate{16.0242, 45.8141}, CountryId{"HR"}}, // Maksimir
    {Coordinate{16.5361, 46.3772}, CountryId{"HR"}}, // Mala Subotica
    {Coordinate{15.9069, 43.7201}, CountryId{"HR"}}, // Mandalina
    {Coordinate{18.7337, 45.3811}, CountryId{"HR"}}, // Markusica-Antin
    {Coordinate{16.5326, 46.2614}, CountryId{"HR"}}, // Martijanec
    {Coordinate{15.7984, 45.6973}, CountryId{"HR"}}, // Mavracici
    {Coordinate{16.9111, 45.4455}, CountryId{"HR"}}, // Meduric
    {Coordinate{14.6176, 45.2769}, CountryId{"HR"}}, // Melnice
    {Coordinate{17.8122, 45.6168}, CountryId{"HR"}}, // Mikleus
    {Coordinate{16.9449, 45.9347}, CountryId{"HR"}}, // Misulinovac
    {Coordinate{16.6892, 45.514}, CountryId{"HR"}}, // Moslav. Gracenica
    {Coordinate{16.1022, 45.6687}, CountryId{"HR"}}, // Mraclin
    {Coordinate{15.5359, 45.4665}, CountryId{"HR"}}, // Mrzlo Polje
    {Coordinate{16.7621, 46.1239}, CountryId{"HR"}}, // Mucna Reka
    {Coordinate{18.0882, 45.4874}, CountryId{"HR"}}, // Nasice Grad
    {Coordinate{18.1098, 45.4956}, CountryId{"HR"}}, // Nasice
    {Coordinate{18.1908, 45.5315}, CountryId{"HR"}}, // Nasicka Breznica
    {Coordinate{18.2345, 45.5428}, CountryId{"HR"}}, // Niza
    {Coordinate{18.3665, 45.5573}, CountryId{"HR"}}, // Normanci
    {Coordinate{17.7773, 45.6626}, CountryId{"HR"}}, // Nova Bukovica
    {Coordinate{13.9895, 45.259}, CountryId{"HR"}}, // Novaki
    {Coordinate{16.4966, 46.2642}, CountryId{"HR"}}, // Novakovec
    {Coordinate{15.8131, 45.8797}, CountryId{"HR"}}, // Novi Dvori
    {Coordinate{16.3369, 46.1719}, CountryId{"HR"}}, // Novi Marof
    {Coordinate{16.955, 46.0846}, CountryId{"HR"}}, // Novigrad Podravski
    {Coordinate{17.7797, 45.3239}, CountryId{"HR"}}, // Novoselci
    {Coordinate{16.5301, 45.6492}, CountryId{"HR"}}, // Novoselec
    {Coordinate{14.0194, 45.4123}, CountryId{"HR"}}, // Nugla
    {Coordinate{18.8413, 45.3363}, CountryId{"HR"}}, // Nuštar
    {Coordinate{16.011, 45.7343}, CountryId{"HR"}}, // Odra
    {Coordinate{15.1782, 45.296}, CountryId{"HR"}}, // Ogulinski Hreljin
    {Coordinate{15.9289, 46.0015}, CountryId{"HR"}}, // Oroslavje
    {Coordinate{18.7213, 45.5523}, CountryId{"HR"}}, // Osijek Donji grad
    {Coordinate{18.7037, 45.5588}, CountryId{"HR"}}, // Osijek Dravski Most
    {Coordinate{18.7677, 45.5366}, CountryId{"HR"}}, // Osijek Luka
    {Coordinate{18.7055, 45.5541}, CountryId{"HR"}}, // Osijek OLT
    {Coordinate{15.2774, 45.2188}, CountryId{"HR"}}, // Ostarije Ravnice
    {Coordinate{16.2711, 45.7941}, CountryId{"HR"}}, // Ostrna
    {Coordinate{18.7775, 45.3357}, CountryId{"HR"}}, // Ostrovo
    {Coordinate{18.872, 45.1456}, CountryId{"HR"}}, // Otok
    {Coordinate{15.4825, 45.612}, CountryId{"HR"}}, // Ozalj
    {Coordinate{17.189, 45.4371}, CountryId{"HR"}}, // Pakrac Grad
    {Coordinate{16.6345, 45.3079}, CountryId{"HR"}}, // Papici
    {Coordinate{16.9745, 45.9384}, CountryId{"HR"}}, // Paulovac
    {Coordinate{17.5255, 45.7802}, CountryId{"HR"}}, // Pcelic
    {Coordinate{17.4913, 45.7394}, CountryId{"HR"}}, // Pepelana
    {Coordinate{18.3496, 45.2086}, CountryId{"HR"}}, // Perkovci
    {Coordinate{14.3032, 45.4121}, CountryId{"HR"}}, // Permani
    {Coordinate{15.3858, 44.6529}, CountryId{"HR"}}, // Perušić
    {Coordinate{16.1772, 45.6145}, CountryId{"HR"}}, // Pescenica
    {Coordinate{17.2311, 45.9462}, CountryId{"HR"}}, // Pitomaca
    {Coordinate{17.4832, 45.7081}, CountryId{"HR"}}, // Pivnica
    {Coordinate{16.1835, 43.7668}, CountryId{"HR"}}, // Planjane
    {Coordinate{14.6291, 45.2835}, CountryId{"HR"}}, // Plase
    {Coordinate{15.3681, 45.0783}, CountryId{"HR"}}, // Plaski
    {Coordinate{17.8098, 45.2869}, CountryId{"HR"}}, // Pleternica
    {Coordinate{17.609, 45.7427}, CountryId{"HR"}}, // Podravska Bistrica
    {Coordinate{16.2627, 46.1487}, CountryId{"HR"}}, // Podrute
    {Coordinate{15.8082, 45.9094}, CountryId{"HR"}}, // Pojatno
    {Coordinate{16.979, 45.463}, CountryId{"HR"}}, // Poljana
    {Coordinate{16.5447, 45.9748}, CountryId{"HR"}}, // Poljanka
    {Coordinate{16.6253, 45.565}, CountryId{"HR"}}, // Popovaca
    {Coordinate{17.3931, 45.6501}, CountryId{"HR"}}, // Potocani-Katinac
    {Coordinate{17.6833, 45.3375}, CountryId{"HR"}}, // Pozega
    {Coordinate{16.0295, 46.0497}, CountryId{"HR"}}, // Poznanovec
    {Coordinate{16.3506, 45.7597}, CountryId{"HR"}}, // Precec stajaliste
    {Coordinate{16.2139, 43.6296}, CountryId{"HR"}}, // Preslo
    {Coordinate{16.2261, 43.6103}, CountryId{"HR"}}, // Prgomet
    {Coordinate{16.1588, 43.6367}, CountryId{"HR"}}, // Primorski Dolac
    {Coordinate{15.9468, 43.6963}, CountryId{"HR"}}, // Primorski Sv. Juraj
    {Coordinate{15.982, 43.6785}, CountryId{"HR"}}, // Primorsko Vrpolje
    {Coordinate{15.8776, 46.1372}, CountryId{"HR"}}, // Pristava Krapinska
    {Coordinate{18.8485, 45.1984}, CountryId{"HR"}}, // Privlaka
    {Coordinate{17.1028, 45.2959}, CountryId{"HR"}}, // Rajic
    {Coordinate{16.7207, 46.2059}, CountryId{"HR"}}, // Rasinja
    {Coordinate{17.7315, 45.2306}, CountryId{"HR"}}, // Ratkovica
    {Coordinate{15.9232, 43.7054}, CountryId{"HR"}}, // Razine
    {Coordinate{16.5382, 45.9241}, CountryId{"HR"}}, // Remetinec Krizevacki
    {Coordinate{15.9457, 45.7664}, CountryId{"HR"}}, // Remetinec
    {Coordinate{16.5052, 45.9497}, CountryId{"HR"}}, // Repinec
    {Coordinate{16.7291, 45.4892}, CountryId{"HR"}}, // Repusnica
    {Coordinate{16.0518, 43.6696}, CountryId{"HR"}}, // Ripiste
    {Coordinate{14.0389, 45.4004}, CountryId{"HR"}}, // Roc
    {Coordinate{14.0799, 45.3739}, CountryId{"HR"}}, // Rocko Polje
    {Coordinate{18.7316, 45.2413}, CountryId{"HR"}}, // Rokovci
    {Coordinate{16.7185, 45.9321}, CountryId{"HR"}}, // Rovisce
    {Coordinate{14.304, 45.3699}, CountryId{"HR"}}, // Rukavac
    {Coordinate{16.2987, 43.5634}, CountryId{"HR"}}, // Sadine
    {Coordinate{18.5026, 45.5908}, CountryId{"HR"}}, // Samatovci
    {Coordinate{18.8341, 45.521}, CountryId{"HR"}}, // Sarvas
    {Coordinate{16.6684, 45.285}, CountryId{"HR"}}, // Sas
    {Coordinate{13.8588, 45.0658}, CountryId{"HR"}}, // Savičenta railway stop
    {Coordinate{16.1588, 43.7952}, CountryId{"HR"}}, // Sedramic
    {Coordinate{16.1099, 45.8276}, CountryId{"HR"}}, // Sesvete
    {Coordinate{16.1689, 45.8107}, CountryId{"HR"}}, // Sesv. Kraljevec
    {Coordinate{13.8661, 44.8885}, CountryId{"HR"}}, // Šijana railway stop
    {Coordinate{17.241, 45.5299}, CountryId{"HR"}}, // Sirac
    {Coordinate{16.4909, 45.6714}, CountryId{"HR"}}, // Sirinec
    {Coordinate{17.0683, 45.9592}, CountryId{"HR"}}, // Sirova
    {Coordinate{16.1968, 43.8742}, CountryId{"HR"}}, // Siveric
    {Coordinate{17.3171, 45.6349}, CountryId{"HR"}}, // Skodinovac
    {Coordinate{14.903, 45.425}, CountryId{"HR"}}, // Skrad
    {Coordinate{16.5933, 45.9371}, CountryId{"HR"}}, // Skrinjari
    {Coordinate{17.6388, 45.7269}, CountryId{"HR"}}, // Sladojevci
    {Coordinate{17.7054, 45.706}, CountryId{"HR"}}, // Slatina
    {Coordinate{17.9274, 45.177}, CountryId{"HR"}}, // Slobodnica
    {Coordinate{13.8445, 45.0918}, CountryId{"HR"}}, // Smoljanci railway stop
    {Coordinate{16.7119, 46.101}, CountryId{"HR"}}, // Sokolovac
    {Coordinate{18.9042, 45.0412}, CountryId{"HR"}}, // Spacva
    {Coordinate{15.9703, 46.0317}, CountryId{"HR"}}, // Spickovina
    {Coordinate{17.2988, 45.8459}, CountryId{"HR"}}, // Špišić Bukovica
    {Coordinate{18.7422, 45.5453}, CountryId{"HR"}}, // Standard
    {Coordinate{16.9114, 45.3641}, CountryId{"HR"}}, // Stara Subocka
    {Coordinate{16.81, 45.8994}, CountryId{"HR"}}, // Stare Plavnice
    {Coordinate{18.2472, 45.1829}, CountryId{"HR"}}, // Staro Toplje
    {Coordinate{16.6036, 45.3286}, CountryId{"HR"}}, // Staza
    {Coordinate{16.1741, 46.2417}, CountryId{"HR"}}, // Staznjevec
    {Coordinate{15.9117, 46.0564}, CountryId{"HR"}}, // Strucljevo
    {Coordinate{15.9414, 45.9749}, CountryId{"HR"}}, // Stubicke Toplice
    {Coordinate{16.332, 45.5022}, CountryId{"HR"}}, // Stupno
    {Coordinate{17.4869, 45.794}, CountryId{"HR"}}, // Suhopolje
    {Coordinate{17.776, 45.259}, CountryId{"HR"}}, // Sulkovci
    {Coordinate{16.5506, 45.3555}, CountryId{"HR"}}, // Sunja
    {Coordinate{15.2832, 45.2103}, CountryId{"HR"}}, // Susnjevo Selo
    {Coordinate{15.6951, 45.8861}, CountryId{"HR"}}, // Sutla
    {Coordinate{16.3364, 46.2443}, CountryId{"HR"}}, // Sveti Ilija
    {Coordinate{16.6209, 45.9451}, CountryId{"HR"}}, // Sveti Ivan Zabno
    {Coordinate{15.9032, 46.0769}, CountryId{"HR"}}, // Sveti Kriz Zacretje
    {Coordinate{13.8672, 45.1851}, CountryId{"HR"}}, // Sveti Petar u Sumi
    {Coordinate{16.2105, 43.8938}, CountryId{"HR"}}, // Tepljuh
    {Coordinate{15.3202, 45.2506}, CountryId{"HR"}}, // Tounj
    {Coordinate{17.6626, 45.4009}, CountryId{"HR"}}, // Trenkovo
    {Coordinate{16.3591, 46.2566}, CountryId{"HR"}}, // Turcin
    {Coordinate{16.1314, 45.6477}, CountryId{"HR"}}, // Turopolje
    {Coordinate{16.1815, 43.7417}, CountryId{"HR"}}, // Unesic
    {Coordinate{16.0469, 45.7086}, CountryId{"HR"}}, // Velika Gorica
    {Coordinate{15.8876, 46.1153}, CountryId{"HR"}}, // Velika Ves
    {Coordinate{17.6656, 45.4389}, CountryId{"HR"}}, // Velika
    {Coordinate{15.8468, 45.9946}, CountryId{"HR"}}, // Veliko Trgovisce
    {Coordinate{16.925, 45.9322}, CountryId{"HR"}}, // Veliko Trojstvo
    {Coordinate{18.0951, 45.5126}, CountryId{"HR"}}, // Velimirovac
    {Coordinate{16.252, 46.2649}, CountryId{"HR"}}, // Vidovec
    {Coordinate{18.7815, 45.29}, CountryId{"HR"}}, // Vinkovačko Novo Selo
    {Coordinate{18.8226, 45.2924}, CountryId{"HR"}}, // Vinkovci Bolnica
    {Coordinate{17.0037, 46.0691}, CountryId{"HR"}}, // Virje
    {Coordinate{17.386, 45.8269}, CountryId{"HR"}}, // Virovitica grad
    {Coordinate{17.3987, 45.8251}, CountryId{"HR"}}, // Virovitica
    {Coordinate{18.4266, 45.3464}, CountryId{"HR"}}, // Viskovci
    {Coordinate{18.6198, 45.5614}, CountryId{"HR"}}, // Visnjevac
    {Coordinate{16.8804, 45.2565}, CountryId{"HR"}}, // Visnjica
    {Coordinate{18.5586, 45.4755}, CountryId{"HR"}}, // Vladislavci
    {Coordinate{18.6138, 45.2697}, CountryId{"HR"}}, // Vođinci
    {Coordinate{13.8558, 44.9608}, CountryId{"HR"}}, // Vodnjan Mjesto
    {Coordinate{13.8558, 44.9667}, CountryId{"HR"}}, // Vodnjan railway station
    {Coordinate{16.6212, 46.0492}, CountryId{"HR"}}, // Vojakovacki Klostar
    {Coordinate{15.3343, 45.15}, CountryId{"HR"}}, // Vojnovac
    {Coordinate{16.4862, 45.2024}, CountryId{"HR"}}, // Volinja
    {Coordinate{16.6579, 45.5376}, CountryId{"HR"}}, // Voloder
    {Coordinate{15.8966, 45.8123}, CountryId{"HR"}}, // Vrapce
    {Coordinate{14.7321, 45.3177}, CountryId{"HR"}}, // Vrata
    {Coordinate{18.8854, 44.983}, CountryId{"HR"}}, // Vrbanja
    {Coordinate{17.5833, 45.2096}, CountryId{"HR"}}, // Vrbova
    {Coordinate{16.4117, 45.8797}, CountryId{"HR"}}, // Vrbovec
    {Coordinate{15.074, 45.373}, CountryId{"HR"}}, // Vrbovsko
    {Coordinate{15.4276, 44.8489}, CountryId{"HR"}}, // Vrhovi-Plitvi Jezera
    {Coordinate{17.2538, 45.8749}, CountryId{"HR"}}, // Vukosavljevica
    {Coordinate{16.7318, 45.927}, CountryId{"HR"}}, // Zabjak
    {Coordinate{15.2425, 44.106}, CountryId{"HR"}}, // Zadar
    {Coordinate{18.1533, 45.1685}, CountryId{"HR"}}, // Zadubravlje
    {Coordinate{15.9783, 45.7579}, CountryId{"HR"}}, // Zagreb Klara
    {Coordinate{14.8589, 45.3982}, CountryId{"HR"}}, // Zalesina
    {Coordinate{17.4629, 45.2356}, CountryId{"HR"}}, // Zapolje
    {Coordinate{15.7948, 45.855}, CountryId{"HR"}}, // Zaprešić Savska
    {Coordinate{17.8765, 45.3343}, CountryId{"HR"}}, // Zarilac
    {Coordinate{16.3991, 46.2814}, CountryId{"HR"}}, // Zbelava
    {Coordinate{17.9292, 45.5686}, CountryId{"HR"}}, // Zdenci Orahovica
    {Coordinate{15.7499, 45.6837}, CountryId{"HR"}}, // Zdencina
    {Coordinate{17.0394, 45.9465}, CountryId{"HR"}}, // Zid Katalena
    {Coordinate{16.1458, 43.8319}, CountryId{"HR"}}, // Zitnic
    {Coordinate{16.7276, 45.247}, CountryId{"HR"}}, // Zivaja
    {Coordinate{16.0817, 46.0442}, CountryId{"HR"}}, // Zlatar Bistrica
    {Coordinate{14.6512, 45.2882}, CountryId{"HR"}}, // Zlobin
    {Coordinate{13.8555, 45.1463}, CountryId{"HR"}}, // Zminj railway station
    {Coordinate{15.5302, 45.5912}, CountryId{"HR"}}, // Zorkovac
    {Coordinate{14.9375, 45.4499}, CountryId{"HR"}}, // Zrnovac
    {Coordinate{18.6955, 45.0777}, CountryId{"HR"}}, // Zupanja
    {Coordinate{15.8536, 46.1822}, CountryId{"HR"}}, // Zutnica
    {Coordinate{15.431, 45.3958}, CountryId{"HR"}}, // Zvecaj
    {Coordinate{18.4861, 54.3783}, CountryId{"PL"}}, // Gdańsk Firoga
    {Coordinate{23.2046, 50.7077}, CountryId{"PL"}}, // Mokre
    {Coordinate{19.8074, 49.9364}, CountryId{"PL"}}, // Radziszow Centrum
    {Coordinate{17.0687, 51.0537}, CountryId{"PL"}}, // Iwiny
    {Coordinate{19.794, 49.9105}, CountryId{"PL"}}, // Wola Radziszowska Lipki
    {Coordinate{21.1881, 51.4119}, CountryId{"PL"}}, // Radom Golebiow
    {Coordinate{20.4504, 53.783}, CountryId{"PL"}}, // Olsztyn Jezioro Ukiel
    {Coordinate{21.1775, 51.781}, CountryId{"PL"}}, // Warka Miasto
    {Coordinate{19.7589, 50.3799}, CountryId{"PL"}}, // Wolbrom Zachodni
    {Coordinate{15.518, 53.0909}, CountryId{"PL"}}, // Slonice
    {Coordinate{22.4266, 51.1484}, CountryId{"PL"}}, // Majdan
    {Coordinate{25.7622, 44.3601}, CountryId{"RO"}}, // Zorile h.
    {Coordinate{23.5456, 44.5321}, CountryId{"RO"}}, // Canton 282
    {Coordinate{24.824, 44.6094}, CountryId{"RO"}}, // Fâlfani Hm.
    {Coordinate{24.1392, 44.3355}, CountryId{"RO"}}, // Canton 217
    {Coordinate{25.569, 44.7425}, CountryId{"RO"}}, // Banesti
    {Coordinate{25.4437, 44.9407}, CountryId{"RO"}}, // TEIŞ Hm.
    {Coordinate{24.8838, 44.8822}, CountryId{"RO"}}, // Gropeni
    {Coordinate{24.9111, 44.9524}, CountryId{"RO"}}, // Mioveni
    {Coordinate{24.9447, 44.9804}, CountryId{"RO"}}, // Clucereasa
    {Coordinate{24.9665, 45.0165}, CountryId{"RO"}}, // Bucsenesti
    {Coordinate{24.8375, 44.8839}, CountryId{"RO"}}, // C.i.l.
    {Coordinate{24.7725, 44.9414}, CountryId{"RO"}}, // Borlesti Arges
    {Coordinate{24.3711, 44.1068}, CountryId{"RO"}}, // Canton 239+700
    {Coordinate{24.3945, 44.0579}, CountryId{"RO"}}, // Deveselu
    {Coordinate{24.4217, 44.0018}, CountryId{"RO"}}, // Frasinet
    {Coordinate{24.4321, 43.9744}, CountryId{"RO"}}, // Studinita
    {Coordinate{24.4244, 43.9398}, CountryId{"RO"}}, // Studina
    {Coordinate{24.4356, 43.8866}, CountryId{"RO"}}, // Visina
    {Coordinate{24.4415, 43.8649}, CountryId{"RO"}}, // Visina Veche
    {Coordinate{23.6872, 44.0607}, CountryId{"RO"}}, // Cerat
    {Coordinate{23.2745, 44.0343}, CountryId{"RO"}}, // Horticola
    {Coordinate{21.8277, 45.1444}, CountryId{"RO"}}, // Gârliste Hm.
    {Coordinate{23.2748, 44.859}, CountryId{"RO"}}, // Bâlteni h.
    {Coordinate{24.9999, 44.8287}, CountryId{"RO"}}, // Canton 97+770
    {Coordinate{25.3112, 45.7509}, CountryId{"RO"}}, // Valea Homorod
    {Coordinate{24.0247, 45.7766}, CountryId{"RO"}}, // Cristian Sibiu
    {Coordinate{22.0887, 46.0308}, CountryId{"RO"}}, // Valea Muresului
    {Coordinate{25.4404, 45.5891}, CountryId{"RO"}}, // Râşnov h.
    {Coordinate{24.3447, 45.0715}, CountryId{"RO"}}, // Rastoaca
    {Coordinate{24.3402, 45.2506}, CountryId{"RO"}}, // Păuşa h.
    {Coordinate{24.2694, 45.5478}, CountryId{"RO"}}, // Valea Fratelui
    {Coordinate{23.1283, 45.4949}, CountryId{"RO"}}, // Livadia
    {Coordinate{22.3699, 45.8974}, CountryId{"RO"}}, // Costeiu
    {Coordinate{21.0827, 45.902}, CountryId{"RO"}}, // Hodoni
    {Coordinate{21.0513, 45.9461}, CountryId{"RO"}}, // Chinezu
    {Coordinate{21.0688, 45.9802}, CountryId{"RO"}}, // Barateaz
    {Coordinate{21.0442, 46.0026}, CountryId{"RO"}}, // Gelu
    {Coordinate{20.9653, 46.0162}, CountryId{"RO"}}, // Varias
    {Coordinate{20.6416, 46.0542}, CountryId{"RO"}}, // Sânnicolau Mare
    {Coordinate{23.2392, 46.1047}, CountryId{"RO"}}, // Zlatna h.
    {Coordinate{24.9337, 44.8276}, CountryId{"RO"}}, // Ram. Golesti
    {Coordinate{25.1035, 46.2768}, CountryId{"RO"}}, // Porumbenii Mici
    {Coordinate{21.6652, 46.2992}, CountryId{"RO"}}, // Masca Maderat
    {Coordinate{21.6784, 46.3217}, CountryId{"RO"}}, // Pancota
    {Coordinate{21.8097, 46.3892}, CountryId{"RO"}}, // Mocrea
    {Coordinate{21.918, 46.4437}, CountryId{"RO"}}, // Tamand
    {Coordinate{21.9653, 46.4392}, CountryId{"RO"}}, // Bocsig
    {Coordinate{22.0245, 46.4231}, CountryId{"RO"}}, // Rapsig
    {Coordinate{22.1569, 46.3294}, CountryId{"RO"}}, // Paulian
    {Coordinate{22.181, 46.3027}, CountryId{"RO"}}, // Joia Mare
    {Coordinate{22.2475, 46.2962}, CountryId{"RO"}}, // Almas
    {Coordinate{22.3091, 46.2802}, CountryId{"RO"}}, // Bontesti
    {Coordinate{22.4024, 46.2916}, CountryId{"RO"}}, // Romanita
    {Coordinate{22.4341, 46.2941}, CountryId{"RO"}}, // Aciuta
    {Coordinate{22.4803, 46.2774}, CountryId{"RO"}}, // Talagiu
    {Coordinate{22.5404, 46.2666}, CountryId{"RO"}}, // Cariera Leasa
    {Coordinate{22.5598, 46.2228}, CountryId{"RO"}}, // Ocisor
    {Coordinate{22.5718, 46.2094}, CountryId{"RO"}}, // Ociu
    {Coordinate{22.5995, 46.1841}, CountryId{"RO"}}, // Vata
    {Coordinate{22.638, 46.1766}, CountryId{"RO"}}, // Birtin
    {Coordinate{22.6813, 46.1802}, CountryId{"RO"}}, // Lunca Motilor
    {Coordinate{22.7116, 46.1797}, CountryId{"RO"}}, // Baia de Cris
    {Coordinate{22.7363, 46.1712}, CountryId{"RO"}}, // Tebea
    {Coordinate{22.7632, 46.1638}, CountryId{"RO"}}, // Ribita
    {Coordinate{21.7716, 45.1018}, CountryId{"RO"}}, // Dobrei hcv.
    {Coordinate{24.4528, 47.1018}, CountryId{"RO"}}, // Viisoara (Linie 406)
    {Coordinate{22.2956, 47.3339}, CountryId{"RO"}}, // Petreu
    {Coordinate{22.2328, 47.3515}, CountryId{"RO"}}, // Bolcas
    {Coordinate{22.1693, 47.3754}, CountryId{"RO"}}, // Targusor Bihor
    {Coordinate{25.3844, 47.4894}, CountryId{"RO"}}, // Valea Putnei
    {Coordinate{25.6233, 47.915}, CountryId{"RO"}}, // Gura Putnei
    {Coordinate{26.575, 47.2654}, CountryId{"RO"}}, // Cristesti Pascani
    {Coordinate{27.3746, 47.2679}, CountryId{"RO"}}, // Movileni h.
    {Coordinate{27.3856, 47.3168}, CountryId{"RO"}}, // Biserica Larga Jijia h.
    {Coordinate{26.5182, 47.9278}, CountryId{"RO"}}, // Carasa h.
    {Coordinate{26.866, 44.649}, CountryId{"RO"}}, // Km. 74+600
    {Coordinate{27.3226, 44.2071}, CountryId{"RO"}}, // Km. 25+700
    {Coordinate{13.8386, 50.9252}, CountryId{"DE"}}, // Burkhardswalde-Maxen
    {Coordinate{7.611, 51.7357}, CountryId{"DE"}}, // Capelle (Westf)
    {Coordinate{7.30058, 51.5533}, CountryId{"DE"}}, // Castrop-Rauxel Süd
    {Coordinate{7.32402, 51.5282}, CountryId{"DE"}}, // Castrop-Rauxel-Merklinde
    {Coordinate{12.6568, 49.2218}, CountryId{"DE"}}, // Cham (Oberpf)
    {Coordinate{12.7452, 49.1967}, CountryId{"DE"}}, // Chamerau
    {Coordinate{8.20099, 51.8984}, CountryId{"DE"}}, // Clarholz
    {Coordinate{13.4986, 50.7559}, CountryId{"DE"}}, // Clausnitz
    {Coordinate{10.9511, 50.2781}, CountryId{"DE"}}, // Coburg-Neuses
    {Coordinate{7.99206, 50.7838}, CountryId{"DE"}}, // Altenseelbach
    {Coordinate{11.6283, 49.8499}, CountryId{"DE"}}, // Creußen (Oberfr)
    {Coordinate{10.4428, 51.2693}, CountryId{"DE"}}, // Dachrieden
    {Coordinate{10.85, 51.0724}, CountryId{"DE"}}, // Dachwig
    {Coordinate{7.52788, 51.3035}, CountryId{"DE"}}, // Dahl
    {Coordinate{8.05371, 50.9704}, CountryId{"DE"}}, // Dahlbruch
    {Coordinate{6.5503, 50.3857}, CountryId{"DE"}}, // Dahlem (Eifel)
    {Coordinate{11.7775, 47.8707}, CountryId{"DE"}}, // Darching
    {Coordinate{6.63992, 49.876}, CountryId{"DE"}}, // Daufenbach train station
    {Coordinate{10.5443, 50.7007}, CountryId{"DE"}}, // Altersbach
    {Coordinate{7.75822, 50.3269}, CountryId{"DE"}}, // Dausenau
    {Coordinate{7.46919, 49.2278}, CountryId{"DE"}}, // Dellfeld
    {Coordinate{7.47802, 49.2387}, CountryId{"DE"}}, // Dellfeld Ort
    {Coordinate{6.60034, 50.124}, CountryId{"DE"}}, // Densborn
    {Coordinate{6.81677, 50.705}, CountryId{"DE"}}, // Derkum
    {Coordinate{7.04164, 50.5297}, CountryId{"DE"}}, // Dernau
    {Coordinate{11.9825, 51.5001}, CountryId{"DE"}}, // Dessauer Brücke station
    {Coordinate{9.03689, 50.0426}, CountryId{"DE"}}, // Dettingen (Main)
    {Coordinate{9.45489, 48.6164}, CountryId{"DE"}}, // Dettingen (Teck)
    {Coordinate{12.0689, 51.1106}, CountryId{"DE"}}, // Deuben (b Zeitz)
    {Coordinate{11.9149, 49.0416}, CountryId{"DE"}}, // Deuerling
    {Coordinate{8.89148, 49.9236}, CountryId{"DE"}}, // Altheim (Hess)
    {Coordinate{9.83843, 50.1287}, CountryId{"DE"}}, // Diebach
    {Coordinate{10.5969, 50.5994}, CountryId{"DE"}}, // Dietzhausen
    {Coordinate{8.0186, 50.3702}, CountryId{"DE"}}, // Diez
    {Coordinate{13.0688, 50.9268}, CountryId{"DE"}}, // Dittersbach
    {Coordinate{8.44114, 47.8936}, CountryId{"DE"}}, // Döggingen
    {Coordinate{9.61076, 51.0673}, CountryId{"DE"}}, // Altmorschen
    {Coordinate{13.8555, 50.9611}, CountryId{"DE"}}, // Dohna (Sachs)
    {Coordinate{10.9972, 50.2826}, CountryId{"DE"}}, // Dörfles-Esbach
    {Coordinate{8.49897, 48.4708}, CountryId{"DE"}}, // Dornstetten
    {Coordinate{6.84927, 49.9257}, CountryId{"DE"}}, // Salmtal
    {Coordinate{8.70883, 49.9984}, CountryId{"DE"}}, // Dreieich-Dreieichenhain
    {Coordinate{7.73359, 51.7992}, CountryId{"DE"}}, // Drensteinfurt
    {Coordinate{8.27268, 48.929}, CountryId{"DE"}}, // Durmersheim
    {Coordinate{11.7194, 51.4636}, CountryId{"DE"}}, // Amsdorf
    {Coordinate{10.669, 49.9828}, CountryId{"DE"}}, // Ebelsbach-Eltmann
    {Coordinate{10.9138, 50.0015}, CountryId{"DE"}}, // Ebing
    {Coordinate{8.89124, 50.3907}, CountryId{"DE"}}, // Echzell
    {Coordinate{10.6812, 51.0665}, CountryId{"DE"}}, // Eckardtsleben
    {Coordinate{9.9367, 49.1524}, CountryId{"DE"}}, // Eckartshausen-Ilshofen station
    {Coordinate{8.13934, 49.2635}, CountryId{"DE"}}, // Edesheim (Pfalz)
    {Coordinate{7.13941, 50.1043}, CountryId{"DE"}}, // Ediger-Eller train station
    {Coordinate{9.00752, 50.3382}, CountryId{"DE"}}, // Effolderbach
    {Coordinate{7.57141, 50.1758}, CountryId{"DE"}}, // Ehr
    {Coordinate{7.97818, 50.9738}, CountryId{"DE"}}, // Eichen (Kr Siegen)
    {Coordinate{9.44727, 50.6308}, CountryId{"DE"}}, // Angersbach
    {Coordinate{9.69461, 50.494}, CountryId{"DE"}}, // Eichenzell station
    {Coordinate{7.6622, 49.431}, CountryId{"DE"}}, // Einsiedlerhof
    {Coordinate{10.2835, 50.9793}, CountryId{"DE"}}, // Eisenach Opelwerk
    {Coordinate{7.98679, 50.8472}, CountryId{"DE"}}, // Eiserfeld (Sieg)
    {Coordinate{9.96912, 50.1405}, CountryId{"DE"}}, // Elfershausen-Trimberg
    {Coordinate{10.85, 50.706}, CountryId{"DE"}}, // Elgersburg
    {Coordinate{9.31597, 49.15}, CountryId{"DE"}}, // Ellhofen
    {Coordinate{10.6694, 51.5798}, CountryId{"DE"}}, // Ellrich railway station
    {Coordinate{10.3383, 48.3422}, CountryId{"DE"}}, // Ellzee
    {Coordinate{10.9468, 51.0432}, CountryId{"DE"}}, // Elxleben
    {Coordinate{8.07094, 48.1712}, CountryId{"DE"}}, // Elzach
    {Coordinate{7.88233, 50.6164}, CountryId{"DE"}}, // Enspel
    {Coordinate{8.41933, 49.3336}, CountryId{"DE"}}, // Speyer Nord-West
    {Coordinate{8.79969, 48.9338}, CountryId{"DE"}}, // Enzberg
    {Coordinate{8.84246, 49.9452}, CountryId{"DE"}}, // Eppertshausen
    {Coordinate{8.09464, 50.0233}, CountryId{"DE"}}, // Erbach (Rheingau)
    {Coordinate{11.6369, 51.4688}, CountryId{"DE"}}, // Erdeborn train stop
    {Coordinate{8.68333, 50.5713}, CountryId{"DE"}}, // Gießen Erdkauter Weg
    {Coordinate{8.80999, 48.4896}, CountryId{"DE"}}, // Ergenzingen
    {Coordinate{8.85958, 50.8457}, CountryId{"DE"}}, // Anzefahr
    {Coordinate{7.57755, 51.4247}, CountryId{"DE"}}, // Ergste
    {Coordinate{12.1415, 50.1867}, CountryId{"DE"}}, // Erkersreuth
    {Coordinate{11.5731, 48.7333}, CountryId{"DE"}}, // Ernsgaden
    {Coordinate{11.1643, 50.4964}, CountryId{"DE"}}, // Ernstthal am Rennsteig
    {Coordinate{7.24146, 50.582}, CountryId{"DE"}}, // Erpel (Rhein)
    {Coordinate{7.72725, 51.4813}, CountryId{"DE"}}, // Ardey
    {Coordinate{10.0852, 49.9427}, CountryId{"DE"}}, // Eßleben
    {Coordinate{9.96854, 51.3751}, CountryId{"DE"}}, // Arenshausen
    {Coordinate{10.2323, 50.8746}, CountryId{"DE"}}, // Ettenhausen
    {Coordinate{11.9783, 49.0305}, CountryId{"DE"}}, // Etterzhausen
    {Coordinate{8.38782, 48.9471}, CountryId{"DE"}}, // Ettlingen West
    {Coordinate{7.68861, 50.7813}, CountryId{"DE"}}, // Etzbach
    {Coordinate{11.5868, 49.5256}, CountryId{"DE"}}, // Etzelwang
    {Coordinate{12.0983, 49.6288}, CountryId{"DE"}}, // Etzenricht
    {Coordinate{10.0279, 50.1498}, CountryId{"DE"}}, // Euerdorf
    {Coordinate{7.99257, 50.3618}, CountryId{"DE"}}, // Fachingen (Lahn)
    {Coordinate{9.61605, 48.7108}, CountryId{"DE"}}, // Faurndau
    {Coordinate{12.8116, 49.2746}, CountryId{"DE"}}, // Arnschwang
    {Coordinate{7.58346, 50.2388}, CountryId{"DE"}}, // Filsen
    {Coordinate{9.37905, 49.1378}, CountryId{"DE"}}, // Affaltrach
    {Coordinate{11.9337, 47.7057}, CountryId{"DE"}}, // Fischbachau
    {Coordinate{11.2613, 52.348}, CountryId{"DE"}}, // Flechtingen
    {Coordinate{7.57774, 50.198}, CountryId{"DE"}}, // Boppard-Fleckertshöhe
    {Coordinate{10.955, 50.8313}, CountryId{"DE"}}, // Arnstadt Süd train stop
    {Coordinate{6.76215, 49.8608}, CountryId{"DE"}}, // Föhren
    {Coordinate{11.9104, 50.2075}, CountryId{"DE"}}, // Förbau
    {Coordinate{9.64072, 48.9754}, CountryId{"DE"}}, // Fornsbach
    {Coordinate{11.3499, 50.3935}, CountryId{"DE"}}, // Förtschendorf
    {Coordinate{13.0433, 50.9113}, CountryId{"DE"}}, // Frankenberg (Sachs)
    {Coordinate{13.0303, 50.9016}, CountryId{"DE"}}, // Frankenberg (Sachs) Süd
    {Coordinate{12.1977, 50.0546}, CountryId{"DE"}}, // Arzberg (Oberfr)
    {Coordinate{11.9377, 51.3097}, CountryId{"DE"}}, // Frankleben
    {Coordinate{13.3, 48.9877}, CountryId{"DE"}}, // Frauenau
    {Coordinate{11.8245, 47.7656}, CountryId{"DE"}}, // Agatharied
    {Coordinate{7.86366, 48.0242}, CountryId{"DE"}}, // Freiburg-Zähringen
    {Coordinate{8.16943, 51.3664}, CountryId{"DE"}}, // Freienohl
    {Coordinate{11.9029, 49.6272}, CountryId{"DE"}}, // Freihung
    {Coordinate{10.3907, 53.8423}, CountryId{"DE"}}, // Fresenburg station
    {Coordinate{7.89668, 50.8161}, CountryId{"DE"}}, // Freusburg Siedlung
    {Coordinate{8.03064, 50.5049}, CountryId{"DE"}}, // Frickhofen
    {Coordinate{8.71097, 50.6716}, CountryId{"DE"}}, // Friedelhausen
    {Coordinate{9.74329, 50.8969}, CountryId{"DE"}}, // Ludwigsau-Friedlos station
    {Coordinate{7.15938, 50.8021}, CountryId{"DE"}}, // Friedrich Wilhelmshütte
    {Coordinate{7.65073, 50.3122}, CountryId{"DE"}}, // Friedrichssegen
    {Coordinate{7.73602, 51.4988}, CountryId{"DE"}}, // Frömern
    {Coordinate{8.87229, 48.244}, CountryId{"DE"}}, // Frommern
    {Coordinate{8.16119, 49.5761}, CountryId{"DE"}}, // Asselheim
    {Coordinate{8.69891, 50.7063}, CountryId{"DE"}}, // Fronhausen (Lahn)
    {Coordinate{8.25314, 50.4305}, CountryId{"DE"}}, // Fürfurt
    {Coordinate{8.46239, 50.5888}, CountryId{"DE"}}, // Aßlar
    {Coordinate{11.5754, 47.7375}, CountryId{"DE"}}, // Gaißach
    {Coordinate{10.9548, 51.1916}, CountryId{"DE"}}, // Gangloffsömmern
    {Coordinate{7.83993, 51.321}, CountryId{"DE"}}, // Garbeck
    {Coordinate{7.86738, 49.9853}, CountryId{"DE"}}, // Assmannshausen
    {Coordinate{8.01605, 49.9614}, CountryId{"DE"}}, // Gau Algesheim
    {Coordinate{8.01993, 49.8403}, CountryId{"DE"}}, // Gau Bickelheim
    {Coordinate{9.85452, 49.6342}, CountryId{"DE"}}, // Gaubüttelbrunn
    {Coordinate{10.5954, 51.4272}, CountryId{"DE"}}, // Gebra (Hainleite)
    {Coordinate{10.7691, 50.6838}, CountryId{"DE"}}, // Gehlberg
    {Coordinate{7.6387, 50.7715}, CountryId{"DE"}}, // Geilhausen
    {Coordinate{12.3922, 48.8224}, CountryId{"DE"}}, // Geiselhöring
    {Coordinate{13.7865, 50.7606}, CountryId{"DE"}}, // Geising
    {Coordinate{11.9661, 47.6939}, CountryId{"DE"}}, // Geitau
    {Coordinate{9.43566, 51.1312}, CountryId{"DE"}}, // Felsberg-Gensungen
    {Coordinate{8.28993, 51.0519}, CountryId{"DE"}}, // Aue-Wingeshausen
    {Coordinate{10.4166, 50.7197}, CountryId{"DE"}}, // Auehütte
    {Coordinate{10.8572, 50.7156}, CountryId{"DE"}}, // Geraberg
    {Coordinate{8.49, 49.7543}, CountryId{"DE"}}, // Gernsheim train station
    {Coordinate{9.90388, 49.6872}, CountryId{"DE"}}, // Geroldshausen
    {Coordinate{8.13452, 47.8331}, CountryId{"DE"}}, // Aha
    {Coordinate{9.91459, 50.4494}, CountryId{"DE"}}, // Gersfeld (Rhön)
    {Coordinate{8.8858, 50.3792}, CountryId{"DE"}}, // Gettenau-Bingenheim
    {Coordinate{7.90285, 50.4544}, CountryId{"DE"}}, // Girod
    {Coordinate{11.5903, 51.1021}, CountryId{"DE"}}, // Auerstedt
    {Coordinate{6.58964, 50.9713}, CountryId{"DE"}}, // Glesch
    {Coordinate{10.8284, 51.3897}, CountryId{"DE"}}, // Glückauf
    {Coordinate{8.0759, 49.2069}, CountryId{"DE"}}, // Godramstein
    {Coordinate{9.46916, 54.119}, CountryId{"DE"}}, // Gokels station
    {Coordinate{7.87307, 50.4614}, CountryId{"DE"}}, // Goldhausen train station
    {Coordinate{14.9706, 51.1289}, CountryId{"DE"}}, // Görlitz-Weinhübel
    {Coordinate{10.9418, 51.4558}, CountryId{"DE"}}, // Görsbach
    {Coordinate{8.73177, 49.9943}, CountryId{"DE"}}, // Dreieich-Götzehain
    {Coordinate{13.3935, 48.8562}, CountryId{"DE"}}, // Grafenau
    {Coordinate{9.42022, 51.4475}, CountryId{"DE"}}, // Grebenstein
    {Coordinate{9.44889, 51.21}, CountryId{"DE"}}, // Edermünde-Grifte
    {Coordinate{13.4395, 51.4114}, CountryId{"DE"}}, // Gröditz (b Riesa)
    {Coordinate{8.78314, 50.1916}, CountryId{"DE"}}, // Bad Vilbel-Gronau
    {Coordinate{11.5257, 52.2355}, CountryId{"DE"}}, // Groß Ammensleben
    {Coordinate{13.1818, 49.0157}, CountryId{"DE"}}, // Außenried
    {Coordinate{6.6146, 49.9036}, CountryId{"DE"}}, // Auw an der Kyll train station
    {Coordinate{13.3759, 48.8859}, CountryId{"DE"}}, // Großarmschlag
    {Coordinate{6.81619, 50.6867}, CountryId{"DE"}}, // Euskirchen-Großbüllesheim
    {Coordinate{8.66201, 50.5281}, CountryId{"DE"}}, // Großen Linden
    {Coordinate{10.5561, 51.1445}, CountryId{"DE"}}, // Großengottern
    {Coordinate{7.98324, 49.5164}, CountryId{"DE"}}, // Eiswoog
    {Coordinate{9.54999, 50.5929}, CountryId{"DE"}}, // Großenlüder
    {Coordinate{10.8028, 51.3989}, CountryId{"DE"}}, // Großfurra
    {Coordinate{8.98241, 50.0879}, CountryId{"DE"}}, // Großkrotzenburg
    {Coordinate{14.0175, 51.1487}, CountryId{"DE"}}, // Großröhrsdorf
    {Coordinate{11.0911, 51.0956}, CountryId{"DE"}}, // Großrudestedt
    {Coordinate{10.8494, 50.3272}, CountryId{"DE"}}, // Großwalbur
    {Coordinate{9.06072, 49.2402}, CountryId{"DE"}}, // Babstadt
    {Coordinate{7.02, 50.7112}, CountryId{"DE"}}, // Alfter-Impekoven
    {Coordinate{7.90233, 50.7772}, CountryId{"DE"}}, // Grünebach Ort
    {Coordinate{7.76958, 50.0562}, CountryId{"DE"}}, // Bacharach
    {Coordinate{7.54909, 50.3406}, CountryId{"DE"}}, // Koblenz-Güls
    {Coordinate{11.3011, 50.2806}, CountryId{"DE"}}, // Gundelsdorf
    {Coordinate{12.0036, 48.9449}, CountryId{"DE"}}, // Gundelshausen
    {Coordinate{12.0339, 48.5263}, CountryId{"DE"}}, // Gündlkofen
    {Coordinate{8.35124, 49.7919}, CountryId{"DE"}}, // Guntersblum
    {Coordinate{8.39941, 47.8621}, CountryId{"DE"}}, // Bachheim
    {Coordinate{7.98858, 48.1132}, CountryId{"DE"}}, // Gutach (Breisgau) train station
    {Coordinate{11.3658, 51.1324}, CountryId{"DE"}}, // Guthmannshausen
    {Coordinate{10.9057, 50.8675}, CountryId{"DE"}}, // Haarhausen
    {Coordinate{7.82291, 50.664}, CountryId{"DE"}}, // Hachenburg train station
    {Coordinate{8.04348, 50.4472}, CountryId{"DE"}}, // Hadamar
    {Coordinate{11.9944, 48.9227}, CountryId{"DE"}}, // Bad Abbach
    {Coordinate{14.8567, 51.3641}, CountryId{"DE"}}, // Hähnichen
    {Coordinate{11.82, 49.8858}, CountryId{"DE"}}, // Haidenaab-Göppmannsbühl
    {Coordinate{8.20193, 50.7412}, CountryId{"DE"}}, // Haiger Obertor
    {Coordinate{9.15059, 50.1897}, CountryId{"DE"}}, // Hailer-Meerholz
    {Coordinate{8.93816, 50.0781}, CountryId{"DE"}}, // Hainburg Hainstadt
    {Coordinate{9.22682, 50.2086}, CountryId{"DE"}}, // Haitz-Höchst
    {Coordinate{11.0655, 51.885}, CountryId{"DE"}}, // Halberstadt Oststr
    {Coordinate{9.88332, 50.12}, CountryId{"DE"}}, // Hammelburg
    {Coordinate{10.8572, 50.4132}, CountryId{"DE"}}, // Harras (Thür)
    {Coordinate{11.5662, 50.0277}, CountryId{"DE"}}, // Harsdorf
    {Coordinate{7.21721, 50.5563}, CountryId{"DE"}}, // Bad Bodendorf train station
    {Coordinate{8.25331, 49.372}, CountryId{"DE"}}, // Hassloch (Pfalz)
    {Coordinate{7.7752, 50.6762}, CountryId{"DE"}}, // Hattert
    {Coordinate{7.41371, 50.2277}, CountryId{"DE"}}, // Hatzenport
    {Coordinate{7.83013, 49.2014}, CountryId{"DE"}}, // Hauenstein (Pfalz)
    {Coordinate{10.3824, 48.1805}, CountryId{"DE"}}, // Haupeltshofen
    {Coordinate{10.3793, 51.3825}, CountryId{"DE"}}, // Hausen
    {Coordinate{8.93911, 50.4186}, CountryId{"DE"}}, // Häuserhof
    {Coordinate{11.8401, 47.7507}, CountryId{"DE"}}, // Hausham
    {Coordinate{11.3387, 49.5694}, CountryId{"DE"}}, // Hedersdorf
    {Coordinate{10.4581, 51.2333}, CountryId{"DE"}}, // Ammern
    {Coordinate{9.22057, 49.1516}, CountryId{"DE"}}, // Heilbronn Sülmertor
    {Coordinate{11.8137, 51.3039}, CountryId{"DE"}}, // Mücheln (Geiseltal) - Stadt railway station
    {Coordinate{8.39377, 49.2857}, CountryId{"DE"}}, // Heiligenstein (Pfalz)
    {Coordinate{7.23095, 49.6176}, CountryId{"DE"}}, // Heimbach (Nahe)
    {Coordinate{7.6077, 49.6255}, CountryId{"DE"}}, // Heinzenhausen
    {Coordinate{11.7245, 50.2337}, CountryId{"DE"}}, // Helmbrechts
    {Coordinate{14.0466, 51.0341}, CountryId{"DE"}}, // Helmsdorf (b Pirna)
    {Coordinate{7.80348, 51.5539}, CountryId{"DE"}}, // Hemmerde
    {Coordinate{7.64765, 51.4371}, CountryId{"DE"}}, // Hennen
    {Coordinate{9.43342, 48.0536}, CountryId{"DE"}}, // Herbertingen Ort
    {Coordinate{7.76774, 48.2238}, CountryId{"DE"}}, // Herbolzheim (Breisg)
    {Coordinate{9.2598, 49.2814}, CountryId{"DE"}}, // Herbolzheim (Jagst)
    {Coordinate{8.9156, 49.9362}, CountryId{"DE"}}, // Hergershausen
    {Coordinate{10.8753, 51.4515}, CountryId{"DE"}}, // Heringen (Helme)
    {Coordinate{10.1718, 51.0027}, CountryId{"DE"}}, // Herleshausen
    {Coordinate{7.70597, 50.3308}, CountryId{"DE"}}, // Bad Ems West
    {Coordinate{7.2651, 51.5543}, CountryId{"DE"}}, // Herne-Börnig
    {Coordinate{8.19002, 49.5094}, CountryId{"DE"}}, // Herxheim am Berg
    {Coordinate{8.98321, 49.8076}, CountryId{"DE"}}, // Höchst Hetschbach
    {Coordinate{11.2982, 50.9128}, CountryId{"DE"}}, // Hetschburg
    {Coordinate{9.81454, 50.4483}, CountryId{"DE"}}, // Hettenhausen
    {Coordinate{8.99273, 49.5949}, CountryId{"DE"}}, // Beerfelden Hetzbach
    {Coordinate{6.79731, 49.8781}, CountryId{"DE"}}, // Hetzerath
    {Coordinate{8.10649, 50.9917}, CountryId{"DE"}}, // Hilchenbach
    {Coordinate{11.7283, 50.2104}, CountryId{"DE"}}, // Hildbrandsgrün
    {Coordinate{10.7175, 50.4253}, CountryId{"DE"}}, // Hildburghausen
    {Coordinate{8.07137, 50.9728}, CountryId{"DE"}}, // Hilchenbach Hillnhütten
    {Coordinate{9.80822, 49.9237}, CountryId{"DE"}}, // Himmelstadt
    {Coordinate{9.21131, 49.2182}, CountryId{"DE"}}, // Bad Friedrichshall-Kochendorf
    {Coordinate{8.73678, 48.734}, CountryId{"DE"}}, // Hirsau
    {Coordinate{7.68102, 49.5156}, CountryId{"DE"}}, // Hirschhorn (Pfalz)
    {Coordinate{7.64815, 50.1753}, CountryId{"DE"}}, // Boppard-Hirzenach
    {Coordinate{11.1727, 50.1532}, CountryId{"DE"}}, // Hochstadt-Marktzeuln
    {Coordinate{7.82914, 49.7632}, CountryId{"DE"}}, // Hochstätten (Pfalz)
    {Coordinate{7.51093, 49.7987}, CountryId{"DE"}}, // Hochstetten (Nahe)
    {Coordinate{7.16004, 49.5117}, CountryId{"DE"}}, // Hofeld
    {Coordinate{7.64234, 50.7648}, CountryId{"DE"}}, // Hohegrete
    {Coordinate{10.8092, 51.3062}, CountryId{"DE"}}, // Hohenebra Ort train stop
    {Coordinate{12.0364, 50.7029}, CountryId{"DE"}}, // Hohenleuben
    {Coordinate{7.31089, 50.5137}, CountryId{"DE"}}, // Bad Hönningen
    {Coordinate{9.6539, 54.0866}, CountryId{"DE"}}, // Hohenwestedt station
    {Coordinate{7.5261, 49.2439}, CountryId{"DE"}}, // Höhmühlbach
    {Coordinate{11.6839, 50.3638}, CountryId{"DE"}}, // Höllenthal
    {Coordinate{11.2766, 50.942}, CountryId{"DE"}}, // Holzdorf (b Weimar)
    {Coordinate{13.5916, 50.7341}, CountryId{"DE"}}, // Holzhau
    {Coordinate{8.64016, 51.3781}, CountryId{"DE"}}, // Hoppecke railway station
    {Coordinate{7.19493, 49.6155}, CountryId{"DE"}}, // Hoppstädten (Nahe)
    {Coordinate{9.00165, 49.7388}, CountryId{"DE"}}, // Bad König
    {Coordinate{10.2331, 51.0078}, CountryId{"DE"}}, // Hörschel
    {Coordinate{8.47271, 49.1971}, CountryId{"DE"}}, // Huttenheim
    {Coordinate{8.01436, 50.9156}, CountryId{"DE"}}, // Siegen-Geisweid
    {Coordinate{8.25741, 50.2159}, CountryId{"DE"}}, // Idstein (Taunus)
    {Coordinate{9.52623, 51.3486}, CountryId{"DE"}}, // Fuldatal-Ihringshausen
    {Coordinate{10.9228, 50.6947}, CountryId{"DE"}}, // Ilmenau Pörlitzer Höhe
    {Coordinate{10.8891, 50.6973}, CountryId{"DE"}}, // Ilmenau-Roda
    {Coordinate{11.8667, 49.9097}, CountryId{"DE"}}, // Immenreuth
    {Coordinate{7.8082, 49.5974}, CountryId{"DE"}}, // Imsweiler
    {Coordinate{7.72622, 50.6889}, CountryId{"DE"}}, // Ingelbach
    {Coordinate{9.78585, 54.0824}, CountryId{"DE"}}, // Aukrug station
    {Coordinate{8.15215, 49.1574}, CountryId{"DE"}}, // Insheim
    {Coordinate{7.69219, 51.3999}, CountryId{"DE"}}, // Iserlohnerheide
    {Coordinate{8.93458, 49.1871}, CountryId{"DE"}}, // Ittlingen
    {Coordinate{8.73416, 48.7727}, CountryId{"DE"}}, // Bad Liebenzell
    {Coordinate{7.75117, 49.4348}, CountryId{"DE"}}, // Kaiserslautern Pf
    {Coordinate{7.67241, 51.425}, CountryId{"DE"}}, // Kalthof (Iserlohn)
    {Coordinate{7.61281, 51.5673}, CountryId{"DE"}}, // Kamen-Methler
    {Coordinate{7.61847, 50.2276}, CountryId{"DE"}}, // Kamp-Bornhofen
    {Coordinate{7.10701, 50.5465}, CountryId{"DE"}}, // Ahrweiler train station
    {Coordinate{8.5486, 49.1443}, CountryId{"DE"}}, // Karlsdorf
    {Coordinate{8.34125, 49.0266}, CountryId{"DE"}}, // Karlsruhe-Knielingen
    {Coordinate{7.43919, 50.2544}, CountryId{"DE"}}, // Kattenes
    {Coordinate{8.34284, 50.616}, CountryId{"DE"}}, // Katzenfurt
    {Coordinate{7.76847, 50.0834}, CountryId{"DE"}}, // Kaub
    {Coordinate{7.7331, 49.441}, CountryId{"DE"}}, // Kaiserslautern Kennelgarten
    {Coordinate{7.76414, 48.1944}, CountryId{"DE"}}, // Kenzingen
    {Coordinate{8.13607, 50.4019}, CountryId{"DE"}}, // Kerkerbach
    {Coordinate{7.6478, 50.187}, CountryId{"DE"}}, // Kestert
    {Coordinate{11.2037, 51.181}, CountryId{"DE"}}, // Kiebitzhöhe
    {Coordinate{7.05256, 50.7217}, CountryId{"DE"}}, // Bonn Helmholtzstraße
    {Coordinate{7.61281, 49.4193}, CountryId{"DE"}}, // Kindsbach
    {Coordinate{8.66684, 50.4734}, CountryId{"DE"}}, // Kirch Göns
    {Coordinate{11.986, 50.1654}, CountryId{"DE"}}, // Kirchenlamitz Ost
    {Coordinate{9.13949, 48.5287}, CountryId{"DE"}}, // Kirchentellinsfurt Station
    {Coordinate{9.4519, 48.6402}, CountryId{"DE"}}, // Kirchheim (Teck) Süd
    {Coordinate{7.09402, 50.5441}, CountryId{"DE"}}, // Ahrweiler Markt train stop
    {Coordinate{11.6626, 51.2447}, CountryId{"DE"}}, // Kirchscheidungen
    {Coordinate{7.46432, 49.7857}, CountryId{"DE"}}, // Kirn
    {Coordinate{7.43548, 49.7623}, CountryId{"DE"}}, // Kirnsulzbach
    {Coordinate{8.51673, 49.9198}, CountryId{"DE"}}, // Klein Gerau
    {Coordinate{8.20704, 49.9397}, CountryId{"DE"}}, // Klein Winternheim-Ober Olm
    {Coordinate{10.7631, 51.4174}, CountryId{"DE"}}, // Kleinfurra
    {Coordinate{11.7812, 51.1803}, CountryId{"DE"}}, // Kleinjena
    {Coordinate{13.9901, 51.1343}, CountryId{"DE"}}, // Kleinröhrsdorf
    {Coordinate{13.3361, 48.9447}, CountryId{"DE"}}, // Klingenbrunn
    {Coordinate{7.66854, 50.7386}, CountryId{"DE"}}, // Hilgenroth Kloster Marienthal
    {Coordinate{7.20327, 50.1653}, CountryId{"DE"}}, // Klotten train station
    {Coordinate{8.14825, 49.2376}, CountryId{"DE"}}, // Knöringen-Essingen
    {Coordinate{7.46072, 50.3006}, CountryId{"DE"}}, // Kobern-Gondorf
    {Coordinate{7.63552, 50.2052}, CountryId{"DE"}}, // Boppard-Bad Salz.
    {Coordinate{7.56043, 50.3493}, CountryId{"DE"}}, // Koblenz-Moselweiß
    {Coordinate{7.88712, 48.0982}, CountryId{"DE"}}, // Kollmarsreute
    {Coordinate{7.97392, 48.1011}, CountryId{"DE"}}, // Kollnau
    {Coordinate{9.12376, 48.9553}, CountryId{"DE"}}, // Bietigheim-Bissingen Ellental
    {Coordinate{7.80301, 48.1374}, CountryId{"DE"}}, // Köndringen
    {Coordinate{7.93414, 50.7764}, CountryId{"DE"}}, // Königsstollen train stop
    {Coordinate{6.63502, 49.8362}, CountryId{"DE"}}, // Kordel
    {Coordinate{12.7294, 49.243}, CountryId{"DE"}}, // Kothmaißling
    {Coordinate{7.24892, 50.3489}, CountryId{"DE"}}, // Kottenheim
    {Coordinate{13.8599, 50.9451}, CountryId{"DE"}}, // Köttewitz
    {Coordinate{12.1239, 51.3045}, CountryId{"DE"}}, // Kötzschau
    {Coordinate{8.04242, 50.963}, CountryId{"DE"}}, // Kredenbach
    {Coordinate{7.63153, 49.5513}, CountryId{"DE"}}, // Kreimbach-Kaulbach
    {Coordinate{6.97855, 50.5064}, CountryId{"DE"}}, // Kreuzberg (Ahr) train station
    {Coordinate{7.26207, 49.6551}, CountryId{"DE"}}, // Kronweiler
    {Coordinate{7.33866, 50.3906}, CountryId{"DE"}}, // Kruft
    {Coordinate{10.3609, 48.2355}, CountryId{"DE"}}, // Krumbach (Schw) Schule
    {Coordinate{11.8548, 51.2894}, CountryId{"DE"}}, // Krumpa station
    {Coordinate{6.83408, 50.6555}, CountryId{"DE"}}, // Euskirchen-Kuchenheim
    {Coordinate{7.81523, 51.2934}, CountryId{"DE"}}, // Küntrop
    {Coordinate{10.3266, 53.7623}, CountryId{"DE"}}, // Kupfermühle station
    {Coordinate{11.2677, 50.1956}, CountryId{"DE"}}, // Küps
    {Coordinate{9.96867, 51.2681}, CountryId{"DE"}}, // Bad Sooden-Allendorf
    {Coordinate{6.597, 50.0419}, CountryId{"DE"}}, // Kyllburg train station
    {Coordinate{11.8844, 49.07}, CountryId{"DE"}}, // Laaber
    {Coordinate{12.3151, 48.7968}, CountryId{"DE"}}, // Laberweinting
    {Coordinate{8.10679, 49.1958}, CountryId{"DE"}}, // Landau (Pfalz) West
    {Coordinate{11.6469, 50.3651}, CountryId{"DE"}}, // Bad Steben
    {Coordinate{7.11928, 49.3524}, CountryId{"DE"}}, // Landsweiler-Reden
    {Coordinate{8.66705, 50.4977}, CountryId{"DE"}}, // Lang Göns
    {Coordinate{11.9593, 51.1815}, CountryId{"DE"}}, // Langendorf
    {Coordinate{11.7558, 51.3472}, CountryId{"DE"}}, // Langeneichstädt
    {Coordinate{11.6282, 51.0974}, CountryId{"DE"}}, // Bad Sulza Nord
    {Coordinate{7.91461, 50.5875}, CountryId{"DE"}}, // Langenhahn train station
    {Coordinate{9.6614, 50.0615}, CountryId{"DE"}}, // Langenprozelten
    {Coordinate{8.7273, 48.6781}, CountryId{"DE"}}, // Bad Teinach-Neubulach train station
    {Coordinate{10.9794, 51.8606}, CountryId{"DE"}}, // Langenstein railway station
    {Coordinate{14.1539, 51.0363}, CountryId{"DE"}}, // Langenwolmsdorf
    {Coordinate{14.1271, 51.0386}, CountryId{"DE"}}, // Langenwolmsdorf Mitte
    {Coordinate{8.94573, 49.9223}, CountryId{"DE"}}, // Babenhausen Langstadt
    {Coordinate{7.89704, 49.9189}, CountryId{"DE"}}, // Laubenheim (Nahe)
    {Coordinate{10.2366, 48.8689}, CountryId{"DE"}}, // Lauchheim station
    {Coordinate{13.8143, 50.7864}, CountryId{"DE"}}, // Lauenstein (Sachs)
    {Coordinate{11.2777, 49.5126}, CountryId{"DE"}}, // Lauf (rechts Pegnitz)
    {Coordinate{7.90573, 50.3295}, CountryId{"DE"}}, // Laurenburg (Lahn)
    {Coordinate{11.2884, 50.9269}, CountryId{"DE"}}, // Legefeld
    {Coordinate{7.45526, 50.2848}, CountryId{"DE"}}, // Lehmen
    {Coordinate{9.139, 49.2426}, CountryId{"DE"}}, // Bad Wimpfen-Hohenstadt
    {Coordinate{7.0255, 51.7512}, CountryId{"DE"}}, // Lembeck
    {Coordinate{7.82641, 51.4106}, CountryId{"DE"}}, // Lendringsen
    {Coordinate{8.90295, 49.8395}, CountryId{"DE"}}, // Otzberg Lengfeld
    {Coordinate{7.6442, 51.3654}, CountryId{"DE"}}, // Letmathe Dechenh.
    {Coordinate{7.2861, 50.5473}, CountryId{"DE"}}, // Leubsdorf (Rhein)
    {Coordinate{12.001, 51.3204}, CountryId{"DE"}}, // Leuna Werke Nord station
    {Coordinate{12.0066, 51.3066}, CountryId{"DE"}}, // Leuna Werke Süd station
    {Coordinate{7.39209, 50.4477}, CountryId{"DE"}}, // Leutesdorf (Rhein)
    {Coordinate{12.6264, 50.7577}, CountryId{"DE"}}, // Lichtenstein (Sachs)
    {Coordinate{13.2467, 49.0088}, CountryId{"DE"}}, // Lichtenthal
    {Coordinate{9.14403, 50.2071}, CountryId{"DE"}}, // Lieblos
    {Coordinate{7.279, 49.312}, CountryId{"DE"}}, // Limbach (b Homburg Saar) station
    {Coordinate{9.00652, 49.4169}, CountryId{"DE"}}, // Lindach
    {Coordinate{8.34952, 49.2527}, CountryId{"DE"}}, // Lingenfeld
    {Coordinate{9.76659, 50.9903}, CountryId{"DE"}}, // Lispenhausen station
    {Coordinate{7.84977, 51.1084}, CountryId{"DE"}}, // Listerscheid
    {Coordinate{7.98716, 51.0072}, CountryId{"DE"}}, // Kreuztal-Littfeld
    {Coordinate{11.6421, 50.4521}, CountryId{"DE"}}, // Lobenstein (Thür)
    {Coordinate{7.44358, 50.2307}, CountryId{"DE"}}, // Löf
    {Coordinate{13.9878, 50.9891}, CountryId{"DE"}}, // Lohmen
    {Coordinate{7.5997, 49.6358}, CountryId{"DE"}}, // Lohnweiler
    {Coordinate{9.58073, 50.0043}, CountryId{"DE"}}, // Lohr Bahnhof
    {Coordinate{12.0485, 50.7341}, CountryId{"DE"}}, // Loitsch-Hohenleuben
    {Coordinate{10.3909, 48.1626}, CountryId{"DE"}}, // Loppenhausen
    {Coordinate{7.81283, 50.0403}, CountryId{"DE"}}, // Lorch (Rhein)
    {Coordinate{7.78095, 50.0542}, CountryId{"DE"}}, // Lorchhausen
    {Coordinate{8.76468, 49.6388}, CountryId{"DE"}}, // Lörzenbach-Fahrenbach
    {Coordinate{12.6831, 49.2904}, CountryId{"DE"}}, // Balbersdorf
    {Coordinate{12.0779, 51.094}, CountryId{"DE"}}, // Luckenau
    {Coordinate{11.5577, 50.1216}, CountryId{"DE"}}, // Ludwigschorgast
    {Coordinate{11.7385, 51.2083}, CountryId{"DE"}}, // Balgstädt
    {Coordinate{11.2486, 49.4995}, CountryId{"DE"}}, // Ludwigshöhe
    {Coordinate{13.2369, 49.0606}, CountryId{"DE"}}, // Ludwigsthal
    {Coordinate{12.1395, 49.5799}, CountryId{"DE"}}, // Luhe
    {Coordinate{7.76087, 51.5434}, CountryId{"DE"}}, // Lünern
    {Coordinate{8.84642, 48.269}, CountryId{"DE"}}, // Balingen Süd
    {Coordinate{9.76589, 50.4809}, CountryId{"DE"}}, // Lütter
    {Coordinate{8.17414, 50.967}, CountryId{"DE"}}, // Lützel
    {Coordinate{8.14707, 49.3054}, CountryId{"DE"}}, // Maikammer-Kirrweiler
    {Coordinate{9.08602, 49.9824}, CountryId{"DE"}}, // Mainaschaff
    {Coordinate{11.38, 50.0997}, CountryId{"DE"}}, // Mainleus
    {Coordinate{7.1668, 49.4935}, CountryId{"DE"}}, // Baltersweiler
    {Coordinate{12.2572, 48.7682}, CountryId{"DE"}}, // Mallersdorf
    {Coordinate{7.86295, 51.3326}, CountryId{"DE"}}, // Balve
    {Coordinate{10.8346, 50.0383}, CountryId{"DE"}}, // Manndorf
    {Coordinate{8.78368, 49.3596}, CountryId{"DE"}}, // Bammental
    {Coordinate{7.09817, 51.8393}, CountryId{"DE"}}, // Maria Veen
    {Coordinate{10.2246, 50.9084}, CountryId{"DE"}}, // Marksuhl
    {Coordinate{12.0131, 50.1308}, CountryId{"DE"}}, // Marktleuthen
    {Coordinate{8.85488, 51.4628}, CountryId{"DE"}}, // Marsberg
    {Coordinate{11.9504, 50.2153}, CountryId{"DE"}}, // Martinlamitz
    {Coordinate{10.881, 50.7332}, CountryId{"DE"}}, // Martinroda
    {Coordinate{7.5389, 49.8032}, CountryId{"DE"}}, // Martinstein
    {Coordinate{8.79487, 49.3361}, CountryId{"DE"}}, // Mauer (b Heidelberg)
    {Coordinate{11.7666, 49.1213}, CountryId{"DE"}}, // Mausheim
    {Coordinate{10.5214, 50.9438}, CountryId{"DE"}}, // Mechterstädt
    {Coordinate{10.9073, 50.3152}, CountryId{"DE"}}, // Meeder
    {Coordinate{13.7719, 50.8273}, CountryId{"DE"}}, // Bärenhecke-Johnsbach
    {Coordinate{10.848, 48.546}, CountryId{"DE"}}, // Meitingen
    {Coordinate{11.559, 52.2094}, CountryId{"DE"}}, // Meitzendorf
    {Coordinate{7.80807, 51.4281}, CountryId{"DE"}}, // Menden (Sauerland) Süd
    {Coordinate{13.7947, 50.8097}, CountryId{"DE"}}, // Bärenstein (b Glashütte Sachs)
    {Coordinate{7.73739, 51.7621}, CountryId{"DE"}}, // Mersch (Westf)
    {Coordinate{11.9894, 51.3368}, CountryId{"DE"}}, // Merseburg Bergmannsring station
    {Coordinate{8.13425, 49.5692}, CountryId{"DE"}}, // Mertesheim
    {Coordinate{8.67981, 51.3932}, CountryId{"DE"}}, // Messinghausen
    {Coordinate{6.59831, 49.4955}, CountryId{"DE"}}, // Mettlach
    {Coordinate{9.76799, 50.1167}, CountryId{"DE"}}, // Michelaubrück
    {Coordinate{11.6206, 52.2089}, CountryId{"DE"}}, // Barleben station
    {Coordinate{12.7683, 49.164}, CountryId{"DE"}}, // Miltach
    {Coordinate{9.11992, 50.2309}, CountryId{"DE"}}, // Mittel Gründau
    {Coordinate{10.3998, 50.7177}, CountryId{"DE"}}, // Mittelschmalkalden
    {Coordinate{9.62336, 50.1914}, CountryId{"DE"}}, // Mittelsinn station
    {Coordinate{7.58875, 49.7935}, CountryId{"DE"}}, // Monzingen
    {Coordinate{9.79882, 50.1171}, CountryId{"DE"}}, // Morlesau
    {Coordinate{7.37139, 50.1956}, CountryId{"DE"}}, // Moselkern
    {Coordinate{11.8043, 51.3077}, CountryId{"DE"}}, // Mücheln (Geiseltal) station
    {Coordinate{7.3405, 50.185}, CountryId{"DE"}}, // Müden (Mosel)
    {Coordinate{7.95165, 50.8275}, CountryId{"DE"}}, // Mudersbach
    {Coordinate{8.27442, 48.8768}, CountryId{"DE"}}, // Muggensturm
    {Coordinate{13.8183, 50.9141}, CountryId{"DE"}}, // Mühlbach (b Pirna)
    {Coordinate{7.12951, 50.2321}, CountryId{"DE"}}, // Kaisersesch train station
    {Coordinate{8.98562, 49.7718}, CountryId{"DE"}}, // Höchst Mümling-Grumbach
    {Coordinate{11.2547, 50.8701}, CountryId{"DE"}}, // München (b Bad Berka)
    {Coordinate{7.94084, 48.0889}, CountryId{"DE"}}, // Batzenhäusle
    {Coordinate{11.5927, 49.1917}, CountryId{"DE"}}, // Batzhausen
    {Coordinate{11.6875, 48.7584}, CountryId{"DE"}}, // Münchsmünster
    {Coordinate{7.70038, 49.2213}, CountryId{"DE"}}, // Münchweiler (Rodalb)
    {Coordinate{10.1887, 50.25}, CountryId{"DE"}}, // Münnerstadt
    {Coordinate{8.85385, 49.9237}, CountryId{"DE"}}, // Münster (b Dieburg)
    {Coordinate{7.89805, 49.9474}, CountryId{"DE"}}, // Münster-Sarmsheim
    {Coordinate{6.60155, 50.1488}, CountryId{"DE"}}, // Mürlenbach
    {Coordinate{9.57777, 48.9828}, CountryId{"DE"}}, // Murrhardt
    {Coordinate{8.16849, 49.3719}, CountryId{"DE"}}, // Mußbach
    {Coordinate{8.34187, 49.9191}, CountryId{"DE"}}, // Nackenheim
    {Coordinate{7.1462, 49.5242}, CountryId{"DE"}}, // Namborn
    {Coordinate{7.36175, 50.4571}, CountryId{"DE"}}, // Namedy
    {Coordinate{13.4859, 50.7696}, CountryId{"DE"}}, // Nassau (Erzgeb)
    {Coordinate{7.80075, 50.3115}, CountryId{"DE"}}, // Nassau (Lahn)
    {Coordinate{11.5701, 51.2835}, CountryId{"DE"}}, // Nebra
    {Coordinate{9.06667, 48.4239}, CountryId{"DE"}}, // Nehren
    {Coordinate{11.66, 51.3581}, CountryId{"DE"}}, // Nemsdorf-Göhrendorf
    {Coordinate{8.13069, 49.1208}, CountryId{"DE"}}, // Steinweiler
    {Coordinate{12.4365, 49.2398}, CountryId{"DE"}}, // Neubäu
    {Coordinate{10.3656, 48.3027}, CountryId{"DE"}}, // Neuburg (Kammel)
    {Coordinate{9.27079, 49.2884}, CountryId{"DE"}}, // Neudenau
    {Coordinate{7.79355, 51.2845}, CountryId{"DE"}}, // Neuenrade
    {Coordinate{9.58545, 49.2059}, CountryId{"DE"}}, // Neuenstein
    {Coordinate{8.11659, 49.7714}, CountryId{"DE"}}, // Albig
    {Coordinate{11.6268, 49.5244}, CountryId{"DE"}}, // Neukirchen (b Sulzbach-Rosenberg)
    {Coordinate{9.6926, 50.7709}, CountryId{"DE"}}, // Haunetal-Neukirchen
    {Coordinate{7.22684, 49.3495}, CountryId{"DE"}}, // Neunkirchen (Saar) Wellesweiler
    {Coordinate{11.3068, 50.2172}, CountryId{"DE"}}, // Neuses (b Kronach)
    {Coordinate{11.1216, 50.3328}, CountryId{"DE"}}, // Neustadt (b Coburg)
    {Coordinate{9.03403, 50.6452}, CountryId{"DE"}}, // Nieder Ohmen
    {Coordinate{8.20495, 49.9055}, CountryId{"DE"}}, // Nieder Olm
    {Coordinate{8.80858, 50.1931}, CountryId{"DE"}}, // Niederdorfelden
    {Coordinate{8.13629, 50.7213}, CountryId{"DE"}}, // Niederdresselndorf
    {Coordinate{7.97687, 50.4251}, CountryId{"DE"}}, // Niedererbach
    {Coordinate{8.03691, 50.4327}, CountryId{"DE"}}, // Niederhadamar
    {Coordinate{7.80553, 50.036}, CountryId{"DE"}}, // Niederheimbach
    {Coordinate{8.11615, 51.9293}, CountryId{"DE"}}, // Beelen
    {Coordinate{7.78851, 50.7863}, CountryId{"DE"}}, // Niederhövels
    {Coordinate{7.16059, 49.4322}, CountryId{"DE"}}, // Niederlinxweiler
    {Coordinate{9.10863, 50.1784}, CountryId{"DE"}}, // Niedermittlau
    {Coordinate{7.47157, 49.4584}, CountryId{"DE"}}, // Niedermohr
    {Coordinate{10.4166, 51.3832}, CountryId{"DE"}}, // Gernrode-Niederorschel
    {Coordinate{10.3745, 48.2213}, CountryId{"DE"}}, // Niederraunau
    {Coordinate{10.7639, 51.5451}, CountryId{"DE"}}, // Niedersachswerfen
    {Coordinate{7.96549, 50.8392}, CountryId{"DE"}}, // Niederschelden
    {Coordinate{7.97067, 50.8442}, CountryId{"DE"}}, // Niederschelden Nord
    {Coordinate{13.8109, 50.8898}, CountryId{"DE"}}, // Niederschlottwitz
    {Coordinate{10.8482, 51.2901}, CountryId{"DE"}}, // Niederspier
    {Coordinate{8.15912, 50.0366}, CountryId{"DE"}}, // Niederwalluf
    {Coordinate{8.02281, 48.1396}, CountryId{"DE"}}, // Niederwinden
    {Coordinate{12.7543, 50.7182}, CountryId{"DE"}}, // Niederwürschnitz
    {Coordinate{8.03969, 50.4681}, CountryId{"DE"}}, // Niederzeuzheim
    {Coordinate{8.76951, 48.9202}, CountryId{"DE"}}, // Niefern
    {Coordinate{7.68188, 50.3374}, CountryId{"DE"}}, // Nievern
    {Coordinate{7.24205, 49.6394}, CountryId{"DE"}}, // Nohen
    {Coordinate{11.2676, 50.9696}, CountryId{"DE"}}, // Nohra (b Weimar)
    {Coordinate{10.6989, 51.443}, CountryId{"DE"}}, // Nohra (Wipper)
    {Coordinate{7.74202, 51.6156}, CountryId{"DE"}}, // Bönen-Nordbögge
    {Coordinate{10.8373, 48.5934}, CountryId{"DE"}}, // Nordendorf station
    {Coordinate{10.7732, 51.5151}, CountryId{"DE"}}, // Nordhausen-Salza
    {Coordinate{7.81191, 49.8087}, CountryId{"DE"}}, // Norheim
    {Coordinate{8.93383, 50.4295}, CountryId{"DE"}}, // Ober Widdersheim
    {Coordinate{6.63838, 50.2829}, CountryId{"DE"}}, // Oberbettingen-Hillesheim
    {Coordinate{9.3642, 48.6479}, CountryId{"DE"}}, // Oberboihingen
    {Coordinate{11.1968, 49.481}, CountryId{"DE"}}, // Behringersdorf
    {Coordinate{7.65945, 50.7199}, CountryId{"DE"}}, // Obererbach
    {Coordinate{11.5635, 47.7075}, CountryId{"DE"}}, // Obergries
    {Coordinate{11.2707, 50.9555}, CountryId{"DE"}}, // Obergrunstedt
    {Coordinate{10.8176, 49.9295}, CountryId{"DE"}}, // Oberhaid
    {Coordinate{7.95838, 50.4499}, CountryId{"DE"}}, // Dreikirchen
    {Coordinate{11.1563, 50.485}, CountryId{"DE"}}, // Oberlauscha
    {Coordinate{9.47075, 48.5544}, CountryId{"DE"}}, // Oberlenningen
    {Coordinate{7.15058, 49.4502}, CountryId{"DE"}}, // Oberlinxweiler
    {Coordinate{7.50127, 49.4563}, CountryId{"DE"}}, // Obermohr
    {Coordinate{7.85268, 50.3159}, CountryId{"DE"}}, // Obernhof (Lahn)
    {Coordinate{11.2971, 51.4411}, CountryId{"DE"}}, // Oberröblingen
    {Coordinate{10.2144, 50.8499}, CountryId{"DE"}}, // Oberrohn
    {Coordinate{13.8145, 50.8705}, CountryId{"DE"}}, // Oberschlottwitz
    {Coordinate{9.55309, 51.0831}, CountryId{"DE"}}, // Malsfeld-Beiseförth station
    {Coordinate{9.618, 50.2087}, CountryId{"DE"}}, // Obersinn station
    {Coordinate{10.0269, 50.9506}, CountryId{"DE"}}, // Wildeck-Obersuhl
    {Coordinate{10.1529, 50.0718}, CountryId{"DE"}}, // Oberwerrn
    {Coordinate{6.88035, 50.651}, CountryId{"DE"}}, // Odendorf
    {Coordinate{12.694, 50.7342}, CountryId{"DE"}}, // Oelsnitz (Erzgeb)
    {Coordinate{8.01888, 50.0026}, CountryId{"DE"}}, // Oestrich-Winkel
    {Coordinate{8.13223, 51.3922}, CountryId{"DE"}}, // Oeventrop
    {Coordinate{9.16539, 49.2461}, CountryId{"DE"}}, // Offenau
    {Coordinate{8.74965, 49.9818}, CountryId{"DE"}}, // Dreieich-Offenthal
    {Coordinate{8.5791, 49.3736}, CountryId{"DE"}}, // Oftersheim
    {Coordinate{8.48422, 51.3605}, CountryId{"DE"}}, // Olsberg railway station
    {Coordinate{7.61504, 50.2451}, CountryId{"DE"}}, // Osterspai
    {Coordinate{9.5755, 54.1021}, CountryId{"DE"}}, // Osterstedt station
    {Coordinate{8.67525, 50.4066}, CountryId{"DE"}}, // Ostheim (b Butzbach)
    {Coordinate{7.05804, 50.0104}, CountryId{"DE"}}, // Bengel
    {Coordinate{10.168, 53.9991}, CountryId{"DE"}}, // Rickling station
    {Coordinate{8.24043, 48.8884}, CountryId{"DE"}}, // Ötigheim
    {Coordinate{9.44775, 48.587}, CountryId{"DE"}}, // Owen (Teck)
    {Coordinate{6.60701, 50.9617}, CountryId{"DE"}}, // Paffendorf
    {Coordinate{11.4873, 48.4427}, CountryId{"DE"}}, // Paindorf
    {Coordinate{12.8998, 48.7999}, CountryId{"DE"}}, // Pankofen
    {Coordinate{11.1229, 51.464}, CountryId{"DE"}}, // Bennungen
    {Coordinate{9.52523, 50.038}, CountryId{"DE"}}, // Partenstein
    {Coordinate{10.6022, 50.657}, CountryId{"DE"}}, // Benshausen
    {Coordinate{12.4372, 48.8573}, CountryId{"DE"}}, // Perkam
    {Coordinate{8.9165, 48.2232}, CountryId{"DE"}}, // Albstadt-Laufen Ort
    {Coordinate{11.8085, 49.0925}, CountryId{"DE"}}, // Beratzhausen
    {Coordinate{10.4372, 48.8491}, CountryId{"DE"}}, // Pflaumloch
    {Coordinate{6.62574, 49.9535}, CountryId{"DE"}}, // Philippsheim
    {Coordinate{7.39364, 50.3952}, CountryId{"DE"}}, // Plaidt
    {Coordinate{9.59581, 48.7967}, CountryId{"DE"}}, // Plüderhausen station
    {Coordinate{12.0141, 48.9319}, CountryId{"DE"}}, // Poikam
    {Coordinate{7.26997, 50.1693}, CountryId{"DE"}}, // Pommern (Mosel)
    {Coordinate{10.1387, 50.1006}, CountryId{"DE"}}, // Poppenhausen
    {Coordinate{8.95456, 48.2136}, CountryId{"DE"}}, // Albstadt-Lautlingen
    {Coordinate{12.5431, 49.2292}, CountryId{"DE"}}, // Pösing
    {Coordinate{11.3113, 50.3491}, CountryId{"DE"}}, // Pressig-Rothenkirchen
    {Coordinate{7.53954, 51.5882}, CountryId{"DE"}}, // Lünen Preußen railway station
    {Coordinate{8.35019, 51.0332}, CountryId{"DE"}}, // Berghausen
    {Coordinate{13.4885, 51.4351}, CountryId{"DE"}}, // Prösen
    {Coordinate{13.4701, 51.4249}, CountryId{"DE"}}, // Prösen West
    {Coordinate{8.40618, 49.2954}, CountryId{"DE"}}, // Berghausen (Pfalz)
    {Coordinate{14.2357, 51.1031}, CountryId{"DE"}}, // Putzkau
    {Coordinate{6.64629, 50.9517}, CountryId{"DE"}}, // Bergheim (Erft)
    {Coordinate{11.5936, 50.0078}, CountryId{"DE"}}, // Ramsenthal
    {Coordinate{7.55666, 49.4488}, CountryId{"DE"}}, // Ramstein
    {Coordinate{8.98304, 50.3569}, CountryId{"DE"}}, // Ranstadt
    {Coordinate{7.13129, 50.2562}, CountryId{"DE"}}, // Urmersbach train stop
    {Coordinate{11.1235, 52.409}, CountryId{"DE"}}, // Rätzlingen railway station
    {Coordinate{8.36813, 51.0341}, CountryId{"DE"}}, // Raumland-Markhausen
    {Coordinate{7.03645, 50.5154}, CountryId{"DE"}}, // Rech
    {Coordinate{13.5597, 50.7339}, CountryId{"DE"}}, // Rechenberg
    {Coordinate{10.0766, 49.899}, CountryId{"DE"}}, // Bergtheim
    {Coordinate{7.60915, 49.6071}, CountryId{"DE"}}, // Reckweilerhof
    {Coordinate{11.2069, 50.1688}, CountryId{"DE"}}, // Redwitz (Rodach)
    {Coordinate{13.1364, 48.9686}, CountryId{"DE"}}, // Regen
    {Coordinate{12.1251, 49.1221}, CountryId{"DE"}}, // Regenstauf
    {Coordinate{8.87482, 50.3602}, CountryId{"DE"}}, // Reichelsheim (Wett)
    {Coordinate{9.46403, 48.708}, CountryId{"DE"}}, // Reichenbach (Fils)
    {Coordinate{9.98591, 51.1541}, CountryId{"DE"}}, // Wehretal-Reichensachsen
    {Coordinate{11.636, 47.7746}, CountryId{"DE"}}, // Reichersbeuern
    {Coordinate{11.5102, 48.4711}, CountryId{"DE"}}, // Reichertshausen (Ilm)
    {Coordinate{8.92059, 49.2165}, CountryId{"DE"}}, // Reihen
    {Coordinate{7.11295, 50.0252}, CountryId{"DE"}}, // Reil
    {Coordinate{8.77872, 49.3537}, CountryId{"DE"}}, // Reilsheim
    {Coordinate{10.3836, 48.2013}, CountryId{"DE"}}, // Aletshausen
    {Coordinate{8.75142, 51.4078}, CountryId{"DE"}}, // Beringhausen
    {Coordinate{9.53834, 54.1135}, CountryId{"DE"}}, // Beringstedt station
    {Coordinate{7.07913, 49.2598}, CountryId{"DE"}}, // Rentrisch
    {Coordinate{10.8142, 50.06}, CountryId{"DE"}}, // Rentweinsdorf
    {Coordinate{10.4323, 50.4552}, CountryId{"DE"}}, // Rentwertshausen
    {Coordinate{9.81416, 49.9054}, CountryId{"DE"}}, // Retzbach-Zellingen
    {Coordinate{10.6533, 50.4602}, CountryId{"DE"}}, // Reurieth
    {Coordinate{12.1184, 49.84}, CountryId{"DE"}}, // Reuth (b Erbendorf)
    {Coordinate{9.20156, 48.4925}, CountryId{"DE"}}, // Reutlingen West
    {Coordinate{7.33342, 50.4895}, CountryId{"DE"}}, // Rheinbrohl
    {Coordinate{8.41595, 49.2291}, CountryId{"DE"}}, // Rheinsheim
    {Coordinate{7.62051, 50.2815}, CountryId{"DE"}}, // Rhens
    {Coordinate{8.93662, 49.1678}, CountryId{"DE"}}, // Richen (b Eppingen)
    {Coordinate{9.76979, 50.4593}, CountryId{"DE"}}, // Ried
    {Coordinate{8.49681, 49.6476}, CountryId{"DE"}}, // Riedrode
    {Coordinate{9.66472, 50.0912}, CountryId{"DE"}}, // Rieneck station
    {Coordinate{7.50744, 49.2448}, CountryId{"DE"}}, // Rieschweiler
    {Coordinate{11.3799, 51.484}, CountryId{"DE"}}, // Riestedt
    {Coordinate{8.75705, 49.6272}, CountryId{"DE"}}, // Rimbach
    {Coordinate{10.958, 51.1042}, CountryId{"DE"}}, // Ringleben-Gebesee
    {Coordinate{7.81726, 49.6281}, CountryId{"DE"}}, // Rockenhausen
    {Coordinate{7.63224, 49.2391}, CountryId{"DE"}}, // Rodalben
    {Coordinate{11.0312, 50.2884}, CountryId{"DE"}}, // Rödental
    {Coordinate{12.5159, 49.2145}, CountryId{"DE"}}, // Roding
    {Coordinate{12.654, 50.7422}, CountryId{"DE"}}, // Rödlitz-Hohndorf
    {Coordinate{9.34177, 49.3609}, CountryId{"DE"}}, // Roigheim
    {Coordinate{9.85493, 50.9459}, CountryId{"DE"}}, // Ronshausen
    {Coordinate{9.74371, 50.4784}, CountryId{"DE"}}, // Rönshausen
    {Coordinate{13.4086, 48.8742}, CountryId{"DE"}}, // Rosenau (b Grafenau)
    {Coordinate{11.9942, 50.0751}, CountryId{"DE"}}, // Röslau
    {Coordinate{7.15912, 50.8987}, CountryId{"DE"}}, // Rösrath-Stümpen
    {Coordinate{7.62319, 49.5722}, CountryId{"DE"}}, // Roßbach (Pfalz)
    {Coordinate{11.0657, 51.4629}, CountryId{"DE"}}, // Roßla
    {Coordinate{8.65221, 49.2434}, CountryId{"DE"}}, // Rot-Malsch
    {Coordinate{9.73332, 50.9979}, CountryId{"DE"}}, // Rotenburg (Fulda) station
    {Coordinate{7.89337, 50.6016}, CountryId{"DE"}}, // Rotenhain
    {Coordinate{11.9956, 49.6236}, CountryId{"DE"}}, // Röthenbach (Oberpf)
    {Coordinate{11.7731, 50.3106}, CountryId{"DE"}}, // Rothenbürg
    {Coordinate{10.1663, 50.1662}, CountryId{"DE"}}, // Rottershausen
    {Coordinate{9.05671, 50.0202}, CountryId{"DE"}}, // Rückersbacher Schlucht
    {Coordinate{11.2318, 49.4912}, CountryId{"DE"}}, // Rückersdorf (Mittelfr)
    {Coordinate{8.72205, 49.0094}, CountryId{"DE"}}, // Bretten-Ruit
    {Coordinate{7.52823, 51.2778}, CountryId{"DE"}}, // Rummenohl
    {Coordinate{6.60752, 49.5164}, CountryId{"DE"}}, // Saarhölzbach
    {Coordinate{12.3605, 48.8112}, CountryId{"DE"}}, // Sallach
    {Coordinate{7.87891, 51.3537}, CountryId{"DE"}}, // Sanssouci
    {Coordinate{7.91562, 50.7715}, CountryId{"DE"}}, // Sassenroth
    {Coordinate{10.4803, 50.9459}, CountryId{"DE"}}, // Sättelstädt
    {Coordinate{6.71295, 50.6229}, CountryId{"DE"}}, // Satzvey
    {Coordinate{8.15428, 49.8738}, CountryId{"DE"}}, // Saulheim
    {Coordinate{6.59225, 50.5597}, CountryId{"DE"}}, // Scheven train stop
    {Coordinate{8.37716, 49.3743}, CountryId{"DE"}}, // Schifferstadt Süd
    {Coordinate{7.12946, 49.3635}, CountryId{"DE"}}, // Schiffweiler
    {Coordinate{14.4266, 51.08}, CountryId{"DE"}}, // Schirgiswalde-Kirschau
    {Coordinate{9.20127, 50.9687}, CountryId{"DE"}}, // Schlierbach (Kr Schwalm-Eder)
    {Coordinate{8.76095, 49.4152}, CountryId{"DE"}}, // Heidelberg-Schlierbach-Ziegelhausen
    {Coordinate{8.17747, 47.8167}, CountryId{"DE"}}, // Schluchsee
    {Coordinate{9.78828, 50.4559}, CountryId{"DE"}}, // Schmalnau
    {Coordinate{6.55199, 50.4132}, CountryId{"DE"}}, // Schmidtheim train station
    {Coordinate{14.228, 51.1198}, CountryId{"DE"}}, // Schmölln (Oberlausitz)
    {Coordinate{6.58111, 49.6365}, CountryId{"DE"}}, // Schoden-Ockfen
    {Coordinate{10.5856, 51.1208}, CountryId{"DE"}}, // Schönstedt
    {Coordinate{10.1175, 48.9514}, CountryId{"DE"}}, // Schrezheim
    {Coordinate{12.0297, 50.723}, CountryId{"DE"}}, // Schüptitz
    {Coordinate{10.1389, 48.925}, CountryId{"DE"}}, // Schwabsberg
    {Coordinate{10.3466, 50.6889}, CountryId{"DE"}}, // Schwallungen
    {Coordinate{11.9359, 50.2204}, CountryId{"DE"}}, // Schwarzenbach (Saale)
    {Coordinate{12.1306, 49.3928}, CountryId{"DE"}}, // Schwarzenfeld (Oberpf)
    {Coordinate{8.25266, 50.7489}, CountryId{"DE"}}, // Sechshelden
    {Coordinate{8.16964, 48.7707}, CountryId{"DE"}}, // Sinzheim (b Bühl) Nord
    {Coordinate{10.48, 51.4055}, CountryId{"DE"}}, // Bernterode
    {Coordinate{11.7474, 50.3165}, CountryId{"DE"}}, // Selbitz
    {Coordinate{10.1025, 49.8544}, CountryId{"DE"}}, // Seligenstadt (b Würzburg)
    {Coordinate{7.45328, 51.7073}, CountryId{"DE"}}, // Selm
    {Coordinate{6.56993, 49.5771}, CountryId{"DE"}}, // Serrig
    {Coordinate{11.6281, 49.1676}, CountryId{"DE"}}, // Seubersdorf
    {Coordinate{11.8685, 50.2101}, CountryId{"DE"}}, // Seulbitz
    {Coordinate{8.47382, 51.258}, CountryId{"DE"}}, // Siedlinghausen railway station
    {Coordinate{8.00608, 50.5399}, CountryId{"DE"}}, // Berzhahn
    {Coordinate{9.30514, 49.2973}, CountryId{"DE"}}, // Siglingen
    {Coordinate{8.48113, 51.2235}, CountryId{"DE"}}, // Silbach railway station
    {Coordinate{10.3424, 51.3194}, CountryId{"DE"}}, // Silberhausen
    {Coordinate{9.32385, 51.0587}, CountryId{"DE"}}, // Singlis
    {Coordinate{8.32504, 50.6497}, CountryId{"DE"}}, // Sinn
    {Coordinate{10.5298, 51.4137}, CountryId{"DE"}}, // Sollstedt
    {Coordinate{8.40673, 50.5456}, CountryId{"DE"}}, // Solms
    {Coordinate{7.84238, 51.0727}, CountryId{"DE"}}, // Sondern
    {Coordinate{8.39774, 51.3619}, CountryId{"DE"}}, // Bestwig
    {Coordinate{7.64548, 50.2555}, CountryId{"DE"}}, // Spay
    {Coordinate{6.61585, 49.9291}, CountryId{"DE"}}, // Speicher train station
    {Coordinate{11.337, 49.5287}, CountryId{"DE"}}, // Speikern
    {Coordinate{8.68869, 50.0153}, CountryId{"DE"}}, // Dreieich-Sprendlingen
    {Coordinate{7.71462, 50.1501}, CountryId{"DE"}}, // Sint Goar
    {Coordinate{7.71422, 50.156}, CountryId{"DE"}}, // Sint Goarshausen
    {Coordinate{6.60106, 50.0698}, CountryId{"DE"}}, // St Thomas
    {Coordinate{13.1863, 48.9977}, CountryId{"DE"}}, // Bettmannsäge
    {Coordinate{11.7969, 50.3163}, CountryId{"DE"}}, // Stegenwaldhaus
    {Coordinate{7.65163, 49.3163}, CountryId{"DE"}}, // Steinalben
    {Coordinate{9.44311, 50.3143}, CountryId{"DE"}}, // Steinau (Straße)
    {Coordinate{10.5581, 50.6932}, CountryId{"DE"}}, // Steinbach-Hallenberg
    {Coordinate{7.93921, 50.4482}, CountryId{"DE"}}, // Steinefrenz train station
    {Coordinate{7.5245, 49.4542}, CountryId{"DE"}}, // Steinwenden
    {Coordinate{9.62541, 50.3129}, CountryId{"DE"}}, // Sterbfritz
    {Coordinate{8.09193, 50.9778}, CountryId{"DE"}}, // Stift Keppel Allenbach
    {Coordinate{11.9627, 51.3228}, CountryId{"DE"}}, // Beuna (Geiseltal)
    {Coordinate{9.06353, 49.9767}, CountryId{"DE"}}, // Stockstadt (Main)
    {Coordinate{10.279, 51.3772}, CountryId{"DE"}}, // Beuren
    {Coordinate{9.08773, 48.1787}, CountryId{"DE"}}, // Straßberg-Winterlingen
    {Coordinate{12.7213, 48.8335}, CountryId{"DE"}}, // Straßkirchen
    {Coordinate{7.97405, 50.7814}, CountryId{"DE"}}, // Struthütten
    {Coordinate{11.9512, 51.4478}, CountryId{"DE"}}, // Halle Südstadt station
    {Coordinate{10.6383, 50.6021}, CountryId{"DE"}}, // Suhl-Heinrichs
    {Coordinate{9.34053, 49.1485}, CountryId{"DE"}}, // Sülzbach
    {Coordinate{9.50042, 48.9995}, CountryId{"DE"}}, // Sulzbach (Murr)
    {Coordinate{7.07869, 49.3117}, CountryId{"DE"}}, // Sulzbach (Saar) Altenwald
    {Coordinate{11.7393, 49.4995}, CountryId{"DE"}}, // Sulzbach-Rosenberg
    {Coordinate{11.7752, 49.489}, CountryId{"DE"}}, // Sulzbach-Rosenberg Hütte
    {Coordinate{10.8959, 50.8874}, CountryId{"DE"}}, // Sülzenbrücken
    {Coordinate{12.3568, 48.8841}, CountryId{"DE"}}, // Sünching
    {Coordinate{7.22632, 51.7716}, CountryId{"DE"}}, // Sythen
    {Coordinate{6.60089, 49.5526}, CountryId{"DE"}}, // Taben
    {Coordinate{11.2469, 50.8623}, CountryId{"DE"}}, // Tannroda
    {Coordinate{10.4444, 50.4688}, CountryId{"DE"}}, // Bibra
    {Coordinate{7.82475, 48.1286}, CountryId{"DE"}}, // Teningen-Mund.
    {Coordinate{11.82, 51.4658}, CountryId{"DE"}}, // Teutschenthal Ost
    {Coordinate{7.57841, 49.2613}, CountryId{"DE"}}, // Thaleischweiler-Fröschen
    {Coordinate{8.47415, 49.782}, CountryId{"DE"}}, // Biebesheim
    {Coordinate{11.9379, 49.6223}, CountryId{"DE"}}, // Thansüß
    {Coordinate{12.107, 51.0905}, CountryId{"DE"}}, // Theißen
    {Coordinate{10.6175, 50.5068}, CountryId{"DE"}}, // Themar
    {Coordinate{9.84016, 49.8783}, CountryId{"DE"}}, // Thüngersheim
    {Coordinate{7.27718, 50.3588}, CountryId{"DE"}}, // Thür
    {Coordinate{13.4139, 51.3906}, CountryId{"DE"}}, // Tiefenau
    {Coordinate{8.9111, 50.4504}, CountryId{"DE"}}, // Trais-Horloff
    {Coordinate{8.14658, 48.7338}, CountryId{"DE"}}, // Baden-Baden Rebland
    {Coordinate{8.86043, 48.9564}, CountryId{"DE"}}, // Mühlacker Rößlesweg
    {Coordinate{11.5522, 50.0657}, CountryId{"DE"}}, // Trebgast
    {Coordinate{7.85236, 50.009}, CountryId{"DE"}}, // Trechtingshausen
    {Coordinate{7.29967, 50.18}, CountryId{"DE"}}, // Treis-Karden train station
    {Coordinate{12.0233, 50.688}, CountryId{"DE"}}, // Triebes
    {Coordinate{10.4016, 48.8384}, CountryId{"DE"}}, // Trochtelfingen (b Bopfingen)
    {Coordinate{11.4812, 51.1185}, CountryId{"DE"}}, // Tromsdorf
    {Coordinate{9.0505, 48.5036}, CountryId{"DE"}}, // Tübingen-Derendingen
    {Coordinate{9.09467, 48.5239}, CountryId{"DE"}}, // Tübingen-Lustnau
    {Coordinate{8.80948, 47.9856}, CountryId{"DE"}}, // Tuttlingen Zentrum
    {Coordinate{12.0556, 50.7765}, CountryId{"DE"}}, // Weida Mitte
    {Coordinate{10.0623, 51.3671}, CountryId{"DE"}}, // Uder
    {Coordinate{9.58505, 48.7087}, CountryId{"DE"}}, // Uhingen
    {Coordinate{8.14255, 50.0107}, CountryId{"DE"}}, // Uhlerborn
    {Coordinate{14.8944, 51.3282}, CountryId{"DE"}}, // Uhsmannsdorf
    {Coordinate{8.39792, 47.8812}, CountryId{"DE"}}, // Unadingen
    {Coordinate{11.9391, 49.0271}, CountryId{"DE"}}, // Undorf
    {Coordinate{11.7526, 50.1995}, CountryId{"DE"}}, // Unfriedsdorf
    {Coordinate{7.88884, 50.6542}, CountryId{"DE"}}, // Unnau-Korb train stop
    {Coordinate{9.22288, 49.265}, CountryId{"DE"}}, // Untergriesheim
    {Coordinate{9.46057, 48.5653}, CountryId{"DE"}}, // Unterlenningen
    {Coordinate{10.4154, 50.5367}, CountryId{"DE"}}, // Untermaßfeld
    {Coordinate{7.66366, 49.5225}, CountryId{"DE"}}, // Sulzbachtal
    {Coordinate{9.57444, 48.805}, CountryId{"DE"}}, // Urbach (b Schorndorf)
    {Coordinate{8.7984, 49.975}, CountryId{"DE"}}, // Rödermark-Urberach
    {Coordinate{7.50878, 50.4026}, CountryId{"DE"}}, // Mülheim-Kärlich
    {Coordinate{7.0049, 49.996}, CountryId{"DE"}}, // Ürzig (DB) train station
    {Coordinate{6.60289, 50.1027}, CountryId{"DE"}}, // Usch-Zendscheid
    {Coordinate{10.539, 50.5293}, CountryId{"DE"}}, // Vachdorf
    {Coordinate{8.47528, 51.3583}, CountryId{"DE"}}, // Bigge railway station
    {Coordinate{7.60997, 50.3996}, CountryId{"DE"}}, // Vallendar
    {Coordinate{7.0943, 49.3373}, CountryId{"DE"}}, // Bildstock
    {Coordinate{10.814, 50.4153}, CountryId{"DE"}}, // Veilsdorf
    {Coordinate{11.5189, 49.611}, CountryId{"DE"}}, // Velden (b Hersbruck)
    {Coordinate{10.559, 50.6671}, CountryId{"DE"}}, // Viernau
    {Coordinate{8.18694, 50.3956}, CountryId{"DE"}}, // Villmar
    {Coordinate{10.3582, 48.2756}, CountryId{"DE"}}, // Billenhausen
    {Coordinate{11.8011, 49.6157}, CountryId{"DE"}}, // Vilseck
    {Coordinate{7.70603, 49.4386}, CountryId{"DE"}}, // Vogelweh
    {Coordinate{11.608, 48.7392}, CountryId{"DE"}}, // Vohburg
    {Coordinate{7.8723, 51.3594}, CountryId{"DE"}}, // Volkringhausen
    {Coordinate{8.14342, 50.9803}, CountryId{"DE"}}, // Vormwald
    {Coordinate{8.12735, 50.9898}, CountryId{"DE"}}, // Vormwald Dorf
    {Coordinate{11.4945, 49.5639}, CountryId{"DE"}}, // Vorra (Pegnitz)
    {Coordinate{8.19115, 49.4393}, CountryId{"DE"}}, // Wachenheim (Pfalz)
    {Coordinate{12.675, 49.2616}, CountryId{"DE"}}, // Waffenbrunn
    {Coordinate{8.23514, 50.0149}, CountryId{"DE"}}, // Mainz Waggonfabrik
    {Coordinate{8.05354, 50.7584}, CountryId{"DE"}}, // Wahlbach (Kr Siegen)
    {Coordinate{10.1158, 49.9672}, CountryId{"DE"}}, // Waigolshausen
    {Coordinate{10.3657, 53.8663}, CountryId{"DE"}}, // Wakendorf station
    {Coordinate{9.90228, 50.1159}, CountryId{"DE"}}, // Hammelburg Ost
    {Coordinate{12.0571, 49.9827}, CountryId{"DE"}}, // Waldershof
    {Coordinate{7.65179, 49.2884}, CountryId{"DE"}}, // Waldfischbach train station
    {Coordinate{9.63806, 48.7892}, CountryId{"DE"}}, // Waldhausen (b Schorndorf)
    {Coordinate{10.2296, 53.9612}, CountryId{"DE"}}, // Wahlstedt station
    {Coordinate{7.12938, 49.5588}, CountryId{"DE"}}, // Walhausen (Saar)
    {Coordinate{8.04946, 49.8326}, CountryId{"DE"}}, // Wallertheim
    {Coordinate{7.95098, 49.9671}, CountryId{"DE"}}, // Bingen-Gaulsheim
    {Coordinate{10.9558, 51.0682}, CountryId{"DE"}}, // Walschleben
    {Coordinate{7.85951, 51.3719}, CountryId{"DE"}}, // Binolen
    {Coordinate{10.5637, 50.901}, CountryId{"DE"}}, // Waltershausen
    {Coordinate{10.5761, 50.8839}, CountryId{"DE"}}, // Waltershausen Schnepfenthal  train stop
    {Coordinate{10.8525, 50.9067}, CountryId{"DE"}}, // Wandersleben
    {Coordinate{9.15064, 48.5123}, CountryId{"DE"}}, // Station Wannweil
    {Coordinate{11.7467, 51.4624}, CountryId{"DE"}}, // Wansleben am See
    {Coordinate{7.98486, 51.95}, CountryId{"DE"}}, // Warendorf
    {Coordinate{7.15307, 50.2966}, CountryId{"DE"}}, // Monreal train stop
    {Coordinate{11.7095, 47.8336}, CountryId{"DE"}}, // Warngau
    {Coordinate{9.8971, 54.0754}, CountryId{"DE"}}, // Wasbek station
    {Coordinate{8.70838, 49.561}, CountryId{"DE"}}, // Birkenau
    {Coordinate{10.8901, 51.2586}, CountryId{"DE"}}, // Wasserthaleben
    {Coordinate{8.72377, 50.5454}, CountryId{"DE"}}, // Watzenborn-Steinberg
    {Coordinate{8.84393, 50.3595}, CountryId{"DE"}}, // Weckesheim
    {Coordinate{13.8627, 50.9362}, CountryId{"DE"}}, // Weesenstein
    {Coordinate{9.7815, 50.1065}, CountryId{"DE"}}, // Weickersgrüben
    {Coordinate{12.0586, 50.7678}, CountryId{"DE"}}, // Weida Altstadt
    {Coordinate{12.7771, 49.2557}, CountryId{"DE"}}, // Weiding
    {Coordinate{10.3307, 51.3665}, CountryId{"DE"}}, // Birkungen
    {Coordinate{6.62882, 50.1764}, CountryId{"DE"}}, // Birresborn
    {Coordinate{11.9443, 51.1945}, CountryId{"DE"}}, // Weißenfels West
    {Coordinate{7.45088, 50.4213}, CountryId{"DE"}}, // Weißenthurm
    {Coordinate{14.0456, 51.2285}, CountryId{"DE"}}, // Bischheim-Gersdorf
    {Coordinate{7.95665, 49.8786}, CountryId{"DE"}}, // Welgesheim-Zotzenheim
    {Coordinate{9.72465, 50.4804}, CountryId{"DE"}}, // Welkers station
    {Coordinate{8.41637, 50.5927}, CountryId{"DE"}}, // Werdorf
    {Coordinate{7.91385, 51.5581}, CountryId{"DE"}}, // Werl
    {Coordinate{12.1464, 49.5388}, CountryId{"DE"}}, // Wernberg
    {Coordinate{7.62292, 51.6692}, CountryId{"DE"}}, // Werne (a d Lippe)
    {Coordinate{10.742, 51.4699}, CountryId{"DE"}}, // Werther
    {Coordinate{10.8434, 48.5718}, CountryId{"DE"}}, // Westendorf
    {Coordinate{10.1836, 48.8815}, CountryId{"DE"}}, // Westhausen station
    {Coordinate{9.93268, 50.1259}, CountryId{"DE"}}, // Westheim-Langendorf
    {Coordinate{7.9601, 51.5575}, CountryId{"DE"}}, // Westönnen
    {Coordinate{7.86974, 51.4932}, CountryId{"DE"}}, // Wickede (Ruhr)
    {Coordinate{7.17567, 49.3711}, CountryId{"DE"}}, // Wiebelskirchen
    {Coordinate{8.92106, 48.3128}, CountryId{"DE"}}, // Bisingen railway station
    {Coordinate{9.13644, 50.8819}, CountryId{"DE"}}, // Schwalmstadt-Wiera
    {Coordinate{10.9119, 50.301}, CountryId{"DE"}}, // Wiesenfeld (b Coburg)
    {Coordinate{8.50243, 49.2257}, CountryId{"DE"}}, // Wiesental
    {Coordinate{9.44096, 50.0169}, CountryId{"DE"}}, // Wiesthal
    {Coordinate{8.74294, 48.6253}, CountryId{"DE"}}, // Wildberg (Württ)
    {Coordinate{7.98579, 50.5394}, CountryId{"DE"}}, // Willmenrod
    {Coordinate{12.669, 49.2464}, CountryId{"DE"}}, // Willmering
    {Coordinate{9.35836, 49.1425}, CountryId{"DE"}}, // Willsbach
    {Coordinate{8.03275, 50.5311}, CountryId{"DE"}}, // Wilsenroth
    {Coordinate{6.59016, 49.6613}, CountryId{"DE"}}, // Wiltingen (Saar)
    {Coordinate{8.58909, 48.4444}, CountryId{"DE"}}, // Bittelbronn
    {Coordinate{8.87586, 50.225}, CountryId{"DE"}}, // Nidderau-Windecken
    {Coordinate{12.1652, 49.7947}, CountryId{"DE"}}, // Windischeschenbach
    {Coordinate{10.2406, 51.3897}, CountryId{"DE"}}, // Wingerode
    {Coordinate{7.52334, 50.3156}, CountryId{"DE"}}, // Winningen (Mosel)
    {Coordinate{12.808, 49.1641}, CountryId{"DE"}}, // Blaibach (Oberpf)
    {Coordinate{10.6611, 51.453}, CountryId{"DE"}}, // Wipperdorf
    {Coordinate{7.78525, 50.4685}, CountryId{"DE"}}, // Wirges train stop
    {Coordinate{9.25887, 50.2258}, CountryId{"DE"}}, // Wirtheim station
    {Coordinate{7.44542, 51.42}, CountryId{"DE"}}, // Wittbräucke
    {Coordinate{10.7218, 51.5557}, CountryId{"DE"}}, // Woffleben
    {Coordinate{11.5087, 51.5122}, CountryId{"DE"}}, // Wolferode
    {Coordinate{9.45008, 51.1866}, CountryId{"DE"}}, // Felsberg-Wolfershausen
    {Coordinate{10.4366, 50.4915}, CountryId{"DE"}}, // Wölfershausen
    {Coordinate{8.95624, 50.1226}, CountryId{"DE"}}, // Wolfgang (Kr Hanau)
    {Coordinate{9.73451, 50.0949}, CountryId{"DE"}}, // Wolfsmünster
    {Coordinate{11.1664, 50.4232}, CountryId{"DE"}}, // Steinach (Thür) Süd
    {Coordinate{11.4262, 51.5028}, CountryId{"DE"}}, // Blankenheim (Kr Sangerhausen)
    {Coordinate{8.24932, 50.2448}, CountryId{"DE"}}, // Wörsdorf
    {Coordinate{13.3892, 51.369}, CountryId{"DE"}}, // Wülknitz
    {Coordinate{8.46471, 49.0664}, CountryId{"DE"}}, // Blankenloch
    {Coordinate{8.14158, 50.76}, CountryId{"DE"}}, // Würgendorf
    {Coordinate{8.12662, 50.7569}, CountryId{"DE"}}, // Würgendorf (Ort)
    {Coordinate{11.9891, 50.2531}, CountryId{"DE"}}, // Wurlitz
    {Coordinate{9.88463, 49.8049}, CountryId{"DE"}}, // Würzburg-Zell
    {Coordinate{11.7096, 50.2184}, CountryId{"DE"}}, // Wüstenselbitz
    {Coordinate{10.9299, 50.0183}, CountryId{"DE"}}, // Zapfendorf
    {Coordinate{9.19979, 50.7272}, CountryId{"DE"}}, // Zell-Romrod
    {Coordinate{10.6495, 50.6585}, CountryId{"DE"}}, // Zella-Mehlis West
    {Coordinate{8.96997, 50.0161}, CountryId{"DE"}}, // Mainhausen Zellhausen
    {Coordinate{8.00489, 48.1241}, CountryId{"DE"}}, // Bleibach
    {Coordinate{11.5082, 50.7549}, CountryId{"DE"}}, // Zeutsch
    {Coordinate{12.6733, 49.3455}, CountryId{"DE"}}, // Zillendorf
    {Coordinate{9.22522, 51.0081}, CountryId{"DE"}}, // Zimmersrode
    {Coordinate{8.7533, 49.6098}, CountryId{"DE"}}, // Zotzenbach
    {Coordinate{9.32918, 49.2917}, CountryId{"DE"}}, // Züttlingen
    {Coordinate{8.82134, 49.2975}, CountryId{"DE"}}, // Zuzenhausen
    {Coordinate{13.277, 49.0066}, CountryId{"DE"}}, // Zwieselau
    {Coordinate{8.50188, 47.9407}, CountryId{"DE"}}, // Donaueschingen Allmendshofen
    {Coordinate{11.3116, 50.9881}, CountryId{"DE"}}, // Weimar West
    {Coordinate{8.65094, 48.1599}, CountryId{"DE"}}, // Rottweil Göllsdorf
    {Coordinate{8.64558, 48.1488}, CountryId{"DE"}}, // Rottweil Saline
    {Coordinate{8.67039, 48.1268}, CountryId{"DE"}}, // Rottweil Neufra
    {Coordinate{8.52857, 48.0527}, CountryId{"DE"}}, // Villingen-Eis
    {Coordinate{8.50602, 48.041}, CountryId{"DE"}}, // Zollhaus (Villingen-Schwenningen)
    {Coordinate{7.09394, 49.3272}, CountryId{"DE"}}, // Friedrichsthal (Saar) Mitte
    {Coordinate{7.05004, 49.37}, CountryId{"DE"}}, // Gennweiler
    {Coordinate{8.20901, 48.8119}, CountryId{"DE"}}, // Baden-Baden Haueneberstein
    {Coordinate{11.1461, 50.501}, CountryId{"DE"}}, // Neuhaus-Igelshieb
    {Coordinate{8.15851, 48.7599}, CountryId{"DE"}}, // Sinzheim
    {Coordinate{8.07034, 49.1041}, CountryId{"DE"}}, // Barbelroth train station
    {Coordinate{8.03081, 49.1056}, CountryId{"DE"}}, // Kapellen-Drusweiler
    {Coordinate{8.07964, 49.0612}, CountryId{"DE"}}, // Schaidt
    {Coordinate{8.18814, 49.6069}, CountryId{"DE"}}, // Bockenheim-Kindenheim
    {Coordinate{8.02184, 49.5351}, CountryId{"DE"}}, // Ramsen
    {Coordinate{8.45174, 49.6633}, CountryId{"DE"}}, // Bobstadt
    {Coordinate{9.96408, 54.315}, CountryId{"DE"}}, // Achterwehr station
    {Coordinate{9.74756, 54.2988}, CountryId{"DE"}}, // Schülldorf station
    {Coordinate{7.77451, 51.7048}, CountryId{"DE"}}, // Bockum-Hövel
    {Coordinate{8.98994, 48.383}, CountryId{"DE"}}, // Bodelshausen
    {Coordinate{13.1008, 49.0705}, CountryId{"DE"}}, // Bodenmais
    {Coordinate{10.2085, 51.3935}, CountryId{"DE"}}, // Bodenrode
    {Coordinate{8.48257, 48.4734}, CountryId{"DE"}}, // Dornstetten-Aach
    {Coordinate{9.45321, 49.1872}, CountryId{"DE"}}, // Bitzfeld
    {Coordinate{9.43425, 49.1617}, CountryId{"DE"}}, // Scheppach
    {Coordinate{8.03948, 49.0447}, CountryId{"DE"}}, // Steinfeld (Pfalz)
    {Coordinate{9.42215, 49.1498}, CountryId{"DE"}}, // Wieslensdorf
    {Coordinate{13.1109, 49.0521}, CountryId{"DE"}}, // Böhmhof
    {Coordinate{8.11878, 49.7381}, CountryId{"DE"}}, // Alzey Süd
    {Coordinate{9.4858, 49.2002}, CountryId{"DE"}}, // Öhringen West
    {Coordinate{7.75729, 51.598}, CountryId{"DE"}}, // Bonen
    {Coordinate{9.27357, 49.1512}, CountryId{"DE"}}, // Weinsberg West
    {Coordinate{8.6587, 48.4672}, CountryId{"DE"}}, // Horb Heiligenfeld
    {Coordinate{9.30548, 49.1487}, CountryId{"DE"}}, // Ellhofen Gewerbegebiet
    {Coordinate{8.21407, 49.6216}, CountryId{"DE"}}, // Hohensülzen
    {Coordinate{8.56326, 49.1412}, CountryId{"DE"}}, // Bruchsal am Mantel
    {Coordinate{10.3517, 48.8552}, CountryId{"DE"}}, // Bopfingen
    {Coordinate{8.72857, 48.7989}, CountryId{"DE"}}, // Monbach-Neuhausen
    {Coordinate{8.75347, 48.9858}, CountryId{"DE"}}, // Ölbronn-Dürrn
    {Coordinate{7.02714, 50.6435}, CountryId{"DE"}}, // Meckenheim Industriepark
    {Coordinate{7.6162, 51.1301}, CountryId{"DE"}}, // Kierspe
    {Coordinate{7.57962, 51.924}, CountryId{"DE"}}, // Mecklenbeck
    {Coordinate{7.45643, 51.6696}, CountryId{"DE"}}, // Bork (Westf)
    {Coordinate{9.27686, 51.0507}, CountryId{"DE"}}, // Borken (Hess)
    {Coordinate{7.74411, 49.4355}, CountryId{"DE"}}, // Galgenschanze
    {Coordinate{7.96573, 49.9505}, CountryId{"DE"}}, // Ockenheim
    {Coordinate{8.03617, 49.3912}, CountryId{"DE"}}, // Neidenfels station
    {Coordinate{8.99701, 48.2114}, CountryId{"DE"}}, // Albstadt Ebingen West
    {Coordinate{8.72589, 48.5315}, CountryId{"DE"}}, // Nagold-Iselshausen
    {Coordinate{8.71305, 48.0959}, CountryId{"DE"}}, // Aldingen
    {Coordinate{10.5779, 50.9234}, CountryId{"DE"}}, // Hörselgau
    {Coordinate{7.88786, 49.5506}, CountryId{"DE"}}, // Münchweiler (Alsenz)
    {Coordinate{8.66919, 50.5885}, CountryId{"DE"}}, // Gießen Oswaldsgarten
    {Coordinate{7.59536, 50.2301}, CountryId{"DE"}}, // Boppard Süd
    {Coordinate{8.8232, 47.9917}, CountryId{"DE"}}, // Tuttlingen Nord
    {Coordinate{7.48731, 51.907}, CountryId{"DE"}}, // Bösensell
    {Coordinate{8.70155, 49.0329}, CountryId{"DE"}}, // Bretten Rechberg
    {Coordinate{9.69712, 49.1373}, CountryId{"DE"}}, // Wackershofen
    {Coordinate{8.28059, 48.9378}, CountryId{"DE"}}, // Durmersheim Nord
    {Coordinate{9.94718, 54.3099}, CountryId{"DE"}}, // Felde
    {Coordinate{7.77419, 51.4586}, CountryId{"DE"}}, // Bösperde
    {Coordinate{9.99319, 50.9458}, CountryId{"DE"}}, // Wildeck-Bosserode
    {Coordinate{13.9356, 50.9778}, CountryId{"DE"}}, // Pirna-Copitz Nord
    {Coordinate{8.31611, 48.8876}, CountryId{"DE"}}, // Malsch Süd
    {Coordinate{8.28667, 48.88}, CountryId{"DE"}}, // Muggensturm Badesee
    {Coordinate{8.7285, 48.5513}, CountryId{"DE"}}, // Nagold Stadtmitte
    {Coordinate{8.4605, 48.4754}, CountryId{"DE"}}, // Grüntal-Wittlensweiler
    {Coordinate{8.75979, 48.0659}, CountryId{"DE"}}, // Balgheim
    {Coordinate{8.73509, 47.9371}, CountryId{"DE"}}, // Immendingen Mitte
    {Coordinate{8.7704, 47.958}, CountryId{"DE"}}, // Möhringen Bahnhof
    {Coordinate{8.76326, 47.9572}, CountryId{"DE"}}, // Möhringen Rathaus
    {Coordinate{8.7305, 48.0785}, CountryId{"DE"}}, // Spaichingen Mitte
    {Coordinate{8.80138, 47.9871}, CountryId{"DE"}}, // Tuttlingen Schulen
    {Coordinate{8.78133, 47.9647}, CountryId{"DE"}}, // Tuttlingen Gänsäcker
    {Coordinate{8.77599, 48.025}, CountryId{"DE"}}, // Rietheim-Weilheim
    {Coordinate{8.77793, 48.0017}, CountryId{"DE"}}, // Wurmlingen Mitte
    {Coordinate{8.77533, 48.0086}, CountryId{"DE"}}, // Wurmlingen Nord
    {Coordinate{11.0086, 50.3966}, CountryId{"DE"}}, // Schalkau Mitte
    {Coordinate{8.78258, 48.0391}, CountryId{"DE"}}, // Rietheim
    {Coordinate{11.0509, 50.2961}, CountryId{"DE"}}, // Rödental Mitte
    {Coordinate{10.9649, 50.2715}, CountryId{"DE"}}, // Coburg Nord
    {Coordinate{8.61176, 48.1085}, CountryId{"DE"}}, // Deißlingen Mitte
    {Coordinate{9.96282, 54.0834}, CountryId{"DE"}}, // Neumünster Stadtwald station
    {Coordinate{7.94152, 50.822}, CountryId{"DE"}}, // Brachbach
    {Coordinate{7.54837, 49.4564}, CountryId{"DE"}}, // Miesenbach
    {Coordinate{7.52799, 50.4184}, CountryId{"DE"}}, // Urmitz Rheinbrücke
    {Coordinate{9.16032, 49.9742}, CountryId{"DE"}}, // Aschaffenburg Hochschule
    {Coordinate{8.73269, 48.542}, CountryId{"DE"}}, // Nagold-Steinberg
    {Coordinate{8.86782, 49.3239}, CountryId{"DE"}}, // Eschelbronn
    {Coordinate{8.89015, 49.3203}, CountryId{"DE"}}, // Neidenstein
    {Coordinate{8.975, 49.32}, CountryId{"DE"}}, // Helmstadt (Baden)
    {Coordinate{10.2517, 53.6886}, CountryId{"DE"}}, // Ahrensburg-Gartenholz
    {Coordinate{8.25207, 49.055}, CountryId{"DE"}}, // Wörth (Rhein) Mozartstraße
    {Coordinate{7.45686, 49.2389}, CountryId{"DE"}}, // Contwig-Stambach
    {Coordinate{7.84953, 49.1992}, CountryId{"DE"}}, // Hauenstein Mitte
    {Coordinate{8.29763, 49.1926}, CountryId{"DE"}}, // Bellheim am Mühlbuckel
    {Coordinate{8.27935, 49.1516}, CountryId{"DE"}}, // Rülzheim Freizeitzentrum
    {Coordinate{8.27326, 49.1146}, CountryId{"DE"}}, // Rheinzabern Rappengasse
    {Coordinate{8.2622, 49.0529}, CountryId{"DE"}}, // Wörth (Rhein) Zügelstraße
    {Coordinate{8.37364, 49.2083}, CountryId{"DE"}}, // Germersheim Süd
    {Coordinate{9.68795, 50.063}, CountryId{"DE"}}, // Kleingemünden
    {Coordinate{7.69947, 49.4159}, CountryId{"DE"}}, // Hohenecken
    {Coordinate{7.93723, 49.2086}, CountryId{"DE"}}, // Annweiler-Sarnstall
    {Coordinate{8.37936, 49.2202}, CountryId{"DE"}}, // Germersheim Mitte
    {Coordinate{7.89453, 51.9614}, CountryId{"DE"}}, // Warendorf-Einen-Müssingen
    {Coordinate{8.35719, 49.8416}, CountryId{"DE"}}, // Dienheim
    {Coordinate{12.9733, 48.8897}, CountryId{"DE"}}, // Grafling-Arzting
    {Coordinate{9.22294, 49.1934}, CountryId{"DE"}}, // Neckarsulm Mitte
    {Coordinate{9.18726, 49.2299}, CountryId{"DE"}}, // Bad Wimpfen im Tal
    {Coordinate{9.11353, 49.2404}, CountryId{"DE"}}, // Bad Rappenau Kurpark
    {Coordinate{11.4606, 48.6743}, CountryId{"DE"}}, // Baar-Ebenhausen
    {Coordinate{11.602, 51.2979}, CountryId{"DE"}}, // Reinsdorf (b Nebra)
    {Coordinate{7.03524, 51.7871}, CountryId{"DE"}}, // Klein Reken station
    {Coordinate{7.64319, 50.2741}, CountryId{"DE"}}, // Braubach
    {Coordinate{14.0076, 51.1802}, CountryId{"DE"}}, // Pulsnitz Süd
    {Coordinate{9.86702, 54.3151}, CountryId{"DE"}}, // Bredenbek station
    {Coordinate{11.8846, 51.2888}, CountryId{"DE"}}, // Braunsbedra station
    {Coordinate{11.9028, 51.29}, CountryId{"DE"}}, // Braunsbedra Ost station
    {Coordinate{13.012, 50.88}, CountryId{"DE"}}, // Braunsdorf-Lichtenwalde
    {Coordinate{8.75311, 48.4848}, CountryId{"DE"}}, // Eutingen im Gäu Nord
    {Coordinate{7.83073, 49.7869}, CountryId{"DE"}}, // Altenbamberg
    {Coordinate{8.77668, 51.4192}, CountryId{"DE"}}, // Bredelar
    {Coordinate{12.2218, 51.5545}, CountryId{"DE"}}, // Brehna train station
    {Coordinate{10.4085, 48.1386}, CountryId{"DE"}}, // Breitenbrunn (Schwab)
    {Coordinate{7.66244, 50.7482}, CountryId{"DE"}}, // Breitscheidt (Altenkirchen Ww)
    {Coordinate{11.2408, 51.3407}, CountryId{"DE"}}, // Bretleben
    {Coordinate{9.4455, 51.1655}, CountryId{"DE"}}, // Felsberg-Altenbrunslar
    {Coordinate{7.89868, 49.8745}, CountryId{"DE"}}, // Bretzenheim (Nahe)
    {Coordinate{9.4403, 49.1726}, CountryId{"DE"}}, // Bretzfeld
    {Coordinate{8.37376, 48.9238}, CountryId{"DE"}}, // Bruchhausen (b Ettlingen)
    {Coordinate{8.9193, 50.1862}, CountryId{"DE"}}, // Bruchköbel
    {Coordinate{7.44399, 49.3853}, CountryId{"DE"}}, // Bruchmühlbach-Miesau
    {Coordinate{6.97217, 50.4893}, CountryId{"DE"}}, // Ahrbrück train stop
    {Coordinate{11.998, 48.5161}, CountryId{"DE"}}, // Bruckberg
    {Coordinate{9.45309, 48.5739}, CountryId{"DE"}}, // Brucken
    {Coordinate{9.06664, 50.2974}, CountryId{"DE"}}, // Büches-Düdelsheim
    {Coordinate{7.55478, 50.2108}, CountryId{"DE"}}, // Boppard-Buchholz
    {Coordinate{9.84949, 50.4508}, CountryId{"DE"}}, // Altenfeld (Rhön)
    {Coordinate{8.17392, 50.0268}, CountryId{"DE"}}, // Budenheim
    {Coordinate{8.1293, 48.6966}, CountryId{"DE"}}, // Bühl (Baden)
    {Coordinate{7.37049, 51.8631}, CountryId{"DE"}}, // Buldern
    {Coordinate{8.81712, 50.8537}, CountryId{"DE"}}, // Bürgeln
    {Coordinate{11.2418, 50.1382}, CountryId{"DE"}}, // Burgkunstadt
    {Coordinate{10.1846, 50.2737}, CountryId{"DE"}}, // Burglauer
    {Coordinate{9.65597, 50.1506}, CountryId{"DE"}}, // Burgsinn
    {Coordinate{7.96825, 49.9855}, CountryId{"DE"}}, // Geisenheim
    {Coordinate{16.2855, 48.123}, CountryId{"AT"}}, // Perchtoldsdorf railway station
    {Coordinate{25.0067, 46.2802}, CountryId{"RO"}}, // Sântămaria h.
    {Coordinate{27.3538, 47.3246}, CountryId{"RO"}}, // Potângeni h.
    {Coordinate{26.7473, 47.9061}, CountryId{"RO"}}, // Mândreşti h.
    {Coordinate{4.85045, 44.9478}, CountryId{"FR"}}, // Saint-Péray
    {Coordinate{11.5155, 49.204}, CountryId{"DE"}}, // Deining (Oberpf)
    {Coordinate{8.92667, 45.5694}, CountryId{"IT"}}, // Canegrate railway station
    {Coordinate{21.1866, 51.4195}, CountryId{"PL"}}, // Radom Brzustowka
    {Coordinate{22.3318, 50.8534}, CountryId{"PL"}}, // Szastarka
    {Coordinate{17.5463, 51.1285}, CountryId{"PL"}}, // Bierutow
    {Coordinate{14.1555, 50.78}, CountryId{"CZ"}}, // Decin-Bynov
    {Coordinate{14.1244, 50.7704}, CountryId{"CZ"}}, // Martineves u Dec. z
    {Coordinate{23.0538, 39.3255}, CountryId{"GR"}}, // Ano Lechonia station
    {Coordinate{17.2261, 45.589}, CountryId{"HR"}}, // Daruvar
    {Coordinate{15.6093, 45.5694}, CountryId{"HR"}}, // Draganici
    {Coordinate{18.0381, 45.5374}, CountryId{"HR"}}, // Djurdjenovac
    {Coordinate{7.78388, 50.4566}, CountryId{"DE"}}, // Dernbach (Westerw) train station
    {Coordinate{7.02722, 49.2773}, CountryId{"DE"}}, // Dudweiler
    {Coordinate{8.32306, 50.632}, CountryId{"DE"}}, // Edingen (Kr Wetzlar)
    {Coordinate{8.38384, 50.5951}, CountryId{"DE"}}, // Ehringshausen (Kr Wetzlar)
    {Coordinate{6.68836, 49.8094}, CountryId{"DE"}}, // Ehrang Ort
    {Coordinate{8.03845, 50.4143}, CountryId{"DE"}}, // Elz (Kr Limburg/Lahn)
    {Coordinate{8.03248, 50.4086}, CountryId{"DE"}}, // Elz (Kr Limburg/Lahn) Süd
    {Coordinate{8.16288, 49.7001}, CountryId{"DE"}}, // Eppelsheim (Rheinhess)
    {Coordinate{25.9419, 44.433}, CountryId{"RO"}}, // Chiajna Parc Divertisment
    {Coordinate{25.3524, 44.705}, CountryId{"RO"}}, // Gaesti Sud
    {Coordinate{24.8924, 44.7043}, CountryId{"RO"}}, // Suseni h.
    {Coordinate{21.788, 45.1282}, CountryId{"RO"}}, // Ciudanoviţa Pam.
    {Coordinate{25.3283, 45.5626}, CountryId{"RO"}}, // Zărneşti
    {Coordinate{22.4998, 45.9051}, CountryId{"RO"}}, // Lapugiu
    {Coordinate{14.0818, 50.7581}, CountryId{"CZ"}}, // Modra u Decina
    {Coordinate{16.1244, 46.2314}, CountryId{"HR"}}, // Ivanec
    {Coordinate{17.1393, 45.9814}, CountryId{"HR"}}, // Klostar
    {Coordinate{15.8162, 45.9328}, CountryId{"HR"}}, // Kupljenovo
    {Coordinate{16.2188, 45.5844}, CountryId{"HR"}}, // Lekenik
    {Coordinate{17.2961, 45.6426}, CountryId{"HR"}}, // Maslenjaca
    {Coordinate{17.6721, 45.3793}, CountryId{"HR"}}, // Mihaljevci
    {Coordinate{15.2963, 45.2344}, CountryId{"HR"}}, // Ostarije
    {Coordinate{15.8358, 45.8156}, CountryId{"HR"}}, // Podsused Stajaliste
    {Coordinate{16.3905, 45.4581}, CountryId{"HR"}}, // Sisak Caprag
    {Coordinate{16.3733, 45.492}, CountryId{"HR"}}, // Sisak
    {Coordinate{15.4596, 45.6271}, CountryId{"HR"}}, // Zaluka
    {Coordinate{15.845, 45.9764}, CountryId{"HR"}}, // Zeinci
    {Coordinate{8.00915, 50.9595}, CountryId{"DE"}}, // Ferndorf (Kr Siegen)
    {Coordinate{8.33379, 49.5139}, CountryId{"DE"}}, // Flomersheim
    {Coordinate{8.55357, 50.1151}, CountryId{"DE"}}, // Frankfurt-Sossenh
    {Coordinate{11.3232, 51.5978}, CountryId{"DE"}}, // Friesdorf Ost
    {Coordinate{11.4042, 51.6021}, CountryId{"DE"}}, // Gräfenstuhl-Klippmühle
    {Coordinate{11.1366, 51.2303}, CountryId{"DE"}}, // Griefstedt
    {Coordinate{7.89135, 50.7816}, CountryId{"DE"}}, // Alsdorf Grünebacherhütte
    {Coordinate{8.19675, 49.6901}, CountryId{"DE"}}, // Gundersheim (Rheinhess)
    {Coordinate{8.60657, 49.7396}, CountryId{"DE"}}, // Hähnlein-Alsbach
    {Coordinate{11.6749, 50.4291}, CountryId{"DE"}}, // Harra Nord
    {Coordinate{7.17483, 50.5474}, CountryId{"DE"}}, // Heimersheim train stop
    {Coordinate{11.1831, 51.3022}, CountryId{"DE"}}, // Heldrungen
    {Coordinate{8.98856, 49.7945}, CountryId{"DE"}}, // Höchst (Odenw)
    {Coordinate{8.13571, 50.7396}, CountryId{"DE"}}, // Holzhausen (Kr Siegen)
    {Coordinate{6.66462, 51.1656}, CountryId{"DE"}}, // Holzheim (b Neuss)
    {Coordinate{12.6381, 48.8849}, CountryId{"DE"}}, // Ittling
    {Coordinate{8.84044, 50.2015}, CountryId{"DE"}}, // Schöneck-Kilianstädten
    {Coordinate{12.1269, 49.5987}, CountryId{"DE"}}, // Luhe-Wildenau
    {Coordinate{11.8307, 47.7905}, CountryId{"DE"}}, // Miesbach
    {Coordinate{8.73094, 49.5972}, CountryId{"DE"}}, // Mörlenbach
    {Coordinate{14.4128, 51.687}, CountryId{"DE"}}, // Neuhausen (b Cottbus) train station
    {Coordinate{8.00613, 50.7846}, CountryId{"DE"}}, // Neunkirchen (Kr Siegen)
    {Coordinate{8.20428, 49.6569}, CountryId{"DE"}}, // Nieder Flörsheim-Dalsheim
    {Coordinate{8.3033, 50.7177}, CountryId{"DE"}}, // Niederscheld (Dillkr) Süd
    {Coordinate{8.82309, 50.1961}, CountryId{"DE"}}, // Schöneck-Oberdorfelden
    {Coordinate{8.57555, 48.2954}, CountryId{"DE"}}, // Oberndorf (Neckar)
    {Coordinate{8.81366, 48.9665}, CountryId{"DE"}}, // Ötisheim
    {Coordinate{12.4431, 48.8746}, CountryId{"DE"}}, // Radldorf (Niederbay)
    {Coordinate{14.7839, 51.3987}, CountryId{"DE"}}, // Rietschen
    {Coordinate{8.2053, 50.7742}, CountryId{"DE"}}, // Rodenbach (Dillkr)
    {Coordinate{9.01191, 50.147}, CountryId{"DE"}}, // Rodenbach (b Hanau)
    {Coordinate{10.5168, 50.5716}, CountryId{"DE"}}, // Rohr (Thür)
    {Coordinate{8.14399, 50.8391}, CountryId{"DE"}}, // Rudersdorf (Siegen)
    {Coordinate{12.6726, 48.8972}, CountryId{"DE"}}, // Sand (Niederbay)
    {Coordinate{10.5209, 51.1708}, CountryId{"DE"}}, // Seebach (Kr Mühlhausen)
    {Coordinate{6.60276, 49.4758}, CountryId{"DE"}}, // Besseringen
    {Coordinate{7.98182, 49.8589}, CountryId{"DE"}}, // Sprendlingen (Rheinh)
    {Coordinate{8.32535, 50.5405}, CountryId{"DE"}}, // Stockhausen (Lahn)
    {Coordinate{8.47254, 49.8095}, CountryId{"DE"}}, // Stockstadt (Rhein)
    {Coordinate{11.7631, 51.705}, CountryId{"DE"}}, // Trebitz (b Könnern)
    {Coordinate{8.25801, 48.9106}, CountryId{"DE"}}, // Bietigheim (Baden)
    {Coordinate{11.3068, 51.3916}, CountryId{"DE"}}, // Voigtstedt
    {Coordinate{9.65865, 49.2025}, CountryId{"DE"}}, // Waldenburg (Württ)
    {Coordinate{9.15201, 49.0109}, CountryId{"DE"}}, // Walheim (Württ)
    {Coordinate{11.2047, 51.4619}, CountryId{"DE"}}, // Wallhausen (Helme)
    {Coordinate{8.99416, 49.7204}, CountryId{"DE"}}, // Bad König Zell
    {Coordinate{6.62574, 50.9493}, CountryId{"DE"}}, // Zieverich
    {Coordinate{7.2582, 49.2492}, CountryId{"DE"}}, // Blieskastel-Lautzkirchen
    {Coordinate{9.35142, 49.145}, CountryId{"DE"}}, // Sülzbach Schule
    {Coordinate{9.2526, 49.1403}, CountryId{"DE"}}, // Heilbronn Trappen
    {Coordinate{11.4122, 51.5981}, CountryId{"DE"}}, // Vatteröder Teich
    {Coordinate{7.669, 51.3019}, CountryId{"DE"}}, // Altena (Westf)
    {Coordinate{11.4985, 51.591}, CountryId{"DE"}}, // Klostermansfeld Randsiedlung
    {Coordinate{8.27307, 49.1094}, CountryId{"DE"}}, // Rheinzabern Alte Römerstraße
    {Coordinate{14.3086, 45.3924}, CountryId{"HR"}}, // Jurdani train station
    {Coordinate{33.0634, 68.9671}, CountryId{"RU"}}, // 1448 km
    {Coordinate{14.2399, 48.2739}, CountryId{"AT"}}, // Bergham railway station
    {Coordinate{14.2263, 48.275}, CountryId{"AT"}}, // Rufling railway station
    {Coordinate{14.2012, 48.2713}, CountryId{"AT"}}, // Dörnbach-Hitzing railway station
    {Coordinate{14.1479, 48.2837}, CountryId{"AT"}}, // Straßham-Schönering railway station
    {Coordinate{11.1324, 50.592}, CountryId{"DE"}}, // Bahnhof Lichtenhain an der Bergbahn
    {Coordinate{14.1439, 48.2889}, CountryId{"AT"}}, // Wehrgasse railway station
    {Coordinate{14.1166, 48.2882}, CountryId{"AT"}}, // Alkoven railway station
    {Coordinate{14.1038, 48.2863}, CountryId{"AT"}}, // Alkoven Schule railway station
    {Coordinate{14.0818, 48.2878}, CountryId{"AT"}}, // Straß-Emling railway station
    {Coordinate{14.0402, 48.2876}, CountryId{"AT"}}, // Fraham b. Eferding railway station
    {Coordinate{13.9938, 48.2913}, CountryId{"AT"}}, // Sperneck b. Eferding railway station
    {Coordinate{13.9801, 48.2964}, CountryId{"AT"}}, // Wackersbach railway station
    {Coordinate{13.963, 48.3011}, CountryId{"AT"}}, // Kirnberg b. Eferding railway station
    {Coordinate{13.9556, 48.3063}, CountryId{"AT"}}, // Gstocket railway station
    {Coordinate{13.939, 48.3116}, CountryId{"AT"}}, // Gschnarret railway station
    {Coordinate{13.9291, 48.3151}, CountryId{"AT"}}, // Prattsdorf-Dachsberg railway station
    {Coordinate{13.8886, 48.3318}, CountryId{"AT"}}, // Manzing-Prambach railway station
    {Coordinate{13.8758, 48.3423}, CountryId{"AT"}}, // Schurrerprambach railway station
    {Coordinate{13.8596, 48.3339}, CountryId{"AT"}}, // Hochscharten railway station
    {Coordinate{13.8321, 48.3255}, CountryId{"AT"}}, // Willersdorf an der Aschach railway station
    {Coordinate{13.7949, 48.3129}, CountryId{"AT"}}, // Itzling railway station
    {Coordinate{13.7908, 48.3069}, CountryId{"AT"}}, // Stefansdorf railway station
    {Coordinate{13.782, 48.2912}, CountryId{"AT"}}, // Prambeckenhof railway station
    {Coordinate{13.7679, 48.2852}, CountryId{"AT"}}, // Pötting im Hausruckkreis railway station
    {Coordinate{13.7578, 48.279}, CountryId{"AT"}}, // Oberaschach railway station
    {Coordinate{13.7535, 48.2774}, CountryId{"AT"}}, // Straßhof/Aschach railway station
    {Coordinate{13.7396, 48.2739}, CountryId{"AT"}}, // Kledt railway station
    {Coordinate{46.0605, 55.5527}, CountryId{"RU"}}, // Knyazhikha railway station
    {Coordinate{13.9033, 48.065}, CountryId{"AT"}}, // Bad Wimsbach-Neydharting railway station
    {Coordinate{13.9052, 48.0617}, CountryId{"AT"}}, // Bad Wimsbach Steinfeld railway station
    {Coordinate{13.9071, 48.0474}, CountryId{"AT"}}, // Au b. Bad Wimsbach-Neydharting railway station
    {Coordinate{13.9105, 48.0387}, CountryId{"AT"}}, // Mittlere Au railway station
    {Coordinate{13.9078, 48.0331}, CountryId{"AT"}}, // Blankenberg b. Vorchdorf railway station
    {Coordinate{13.9078, 48.0276}, CountryId{"AT"}}, // Waldl railway station
    {Coordinate{13.9088, 48.023}, CountryId{"AT"}}, // Kößlwang railway station
    {Coordinate{13.9125, 48.0146}, CountryId{"AT"}}, // Feldham railway station
    {Coordinate{13.9142, 48.0101}, CountryId{"AT"}}, // Vorchdorf Gewerbegebiet railway station
    {Coordinate{13.9173, 48.004}, CountryId{"AT"}}, // Vorchdorf Schule railway station
    {Coordinate{13.9185, 47.9942}, CountryId{"AT"}}, // Vorchdorf Schloss Eggenberg railway station
    {Coordinate{13.9084, 47.9898}, CountryId{"AT"}}, // Weidach b. Vorchdorf railway station
    {Coordinate{13.9037, 47.9874}, CountryId{"AT"}}, // Falkenohren railway station
    {Coordinate{13.8989, 47.9753}, CountryId{"AT"}}, // Kirchham b. Vorchdorf railway station
    {Coordinate{7.74765, 49.2014}, CountryId{"DE"}}, // Hinterweidenthal
    {Coordinate{8.12617, 49.198}, CountryId{"DE"}}, // Landau (Pfalz) Hauptbahnhof
    {Coordinate{142.68, 46.9931}, CountryId{"RU"}}, // Q11627144
    {Coordinate{-4.0552, 57.5335}, CountryId{"GB"}}, // Inverness Airport railway station
    {Coordinate{19.2419, 46.5525}, CountryId{"HU"}}, // Q116337070
    {Coordinate{19.1946, 46.5219}, CountryId{"HU"}}, // Q116337072
    {Coordinate{19.1176, 46.5236}, CountryId{"HU"}}, // Q116337074
    {Coordinate{9.47769, 51.3513}, CountryId{"DE"}}, // Vellmar-Niedervellmar station
    {Coordinate{8.11413, 47.8593}, CountryId{"DE"}}, // Altglashütten-Falkau
    {Coordinate{10.7879, 51.5846}, CountryId{"DE"}}, // Ilfeld Neanderklinik railway station
    {Coordinate{10.7885, 51.4939}, CountryId{"DE"}}, // Nordhausen Nord railway station
    {Coordinate{59.9473, 60.0998}, CountryId{"RU"}}, // Q116688824
    {Coordinate{60.5671, 59.6717}, CountryId{"RU"}}, // Q116688896
    {Coordinate{60.4724, 59.6928}, CountryId{"RU"}}, // Q116688897
    {Coordinate{60.31, 59.7061}, CountryId{"RU"}}, // Q116688898
    {Coordinate{60.2042, 59.7321}, CountryId{"RU"}}, // Q116688899
    {Coordinate{60.1586, 59.7584}, CountryId{"RU"}}, // Q116688900
    {Coordinate{60.126, 59.8052}, CountryId{"RU"}}, // Q116688901
    {Coordinate{60.1397, 59.8451}, CountryId{"RU"}}, // Q116688902
    {Coordinate{60.0951, 59.9182}, CountryId{"RU"}}, // Q116688903
    {Coordinate{60.0744, 59.9978}, CountryId{"RU"}}, // Q116688904
    {Coordinate{59.9858, 60.0896}, CountryId{"RU"}}, // Q116688913
    {Coordinate{60.0198, 59.7522}, CountryId{"RU"}}, // Q116688965
    {Coordinate{10.1142, 48.8725}, CountryId{"DE"}}, // Hofen (b Aalen) station
    {Coordinate{75.0319, 12.8782}, CountryId{"IN"}}, // Bantwala railway station
    {Coordinate{10.5989, 50.005}, CountryId{"DE"}}, // Zeil
    {Coordinate{10.3054, 50.0488}, CountryId{"DE"}}, // Schonungen
    {Coordinate{-0.450597, 39.1531}, CountryId{"ES"}}, // Alzira
    {Coordinate{-2.09723, 43.1018}, CountryId{"ES"}}, // Alegría de Orio train station
    {Coordinate{-2.02041, 43.2155}, CountryId{"ES"}}, // Andoain-Centro
    {Coordinate{0.0575861, 40.0582}, CountryId{"ES"}}, // Benicàssim railway station
    {Coordinate{-4.62403, 36.5418}, CountryId{"ES"}}, // Fuengirola train station
    {Coordinate{-1.97336, 43.2656}, CountryId{"ES"}}, // Hernani-Centro
    {Coordinate{0.912611, 40.9993}, CountryId{"ES"}}, // L'Hospitalet de l'Infant station
    {Coordinate{2.29452, 41.6176}, CountryId{"ES"}}, // Les Franqueses - Granollers Nord station
    {Coordinate{-1.8995, 43.3159}, CountryId{"ES"}}, // Lezo-Rentería railway station
    {Coordinate{-8.44784, 43.038}, CountryId{"ES"}}, // Ordes
    {Coordinate{-2.25642, 43.0403}, CountryId{"ES"}}, // Ormaiztegi railway station
    {Coordinate{-4.53391, 42.0157}, CountryId{"ES"}}, // Palencia railway station
    {Coordinate{-8.63597, 42.4216}, CountryId{"ES"}}, // Pontevedra train station
    {Coordinate{2.96461, 42.0683}, CountryId{"ES"}}, // Sant Jordi Desvalls station
    {Coordinate{0.455697, 40.4717}, CountryId{"ES"}}, // Vinaròs station
    {Coordinate{9.06885, 47.7145}, CountryId{"DE"}}, // Allensbach station
    {Coordinate{11.4915, 49.5183}, CountryId{"DE"}}, // Hohenstadt (Mittelfr)
    {Coordinate{11.4806, 49.5975}, CountryId{"DE"}}, // Rupprechtstegen
    {Coordinate{11.5734, 47.7606}, CountryId{"DE"}}, // Bad Tölz railway station
    {Coordinate{28.6134, 49.8894}, CountryId{"UA"}}, // Berdychiv
    {Coordinate{7.94266, 52.5511}, CountryId{"DE"}}, // Bersenbrück railway station
    {Coordinate{40.6872, 53.3081}, CountryId{"RU"}}, // Staroye Yuryevo railway station
    {Coordinate{18.0731, 49.9633}, CountryId{"CZ"}}, // Bolatice (train station)
    {Coordinate{17.8781, 49.8892}, CountryId{"CZ"}}, // Branka u Opavy
    {Coordinate{8.88791, 53.061}, CountryId{"DE"}}, // Bremen-Sebaldsbrück
    {Coordinate{18.7176, 49.6363}, CountryId{"CZ"}}, // Bystřice
    {Coordinate{17.4044, 49.9175}, CountryId{"CZ"}}, // Q11689283
    {Coordinate{77.7173, 22.7527}, CountryId{"IN"}}, // Hoshangabad railway station
    {Coordinate{7.1668, 50.1531}, CountryId{"DE"}}, // Bahnhof Cochem
    {Coordinate{}, CountryId{"GB"}}, // Sale
    {Coordinate{24.7917, 62.2397}, CountryId{"FI"}}, // Q116927004
    {Coordinate{5.97194, 43.125}, CountryId{"FR"}}, // Q116938148
    {Coordinate{7.8817, 48.0687}, CountryId{"DE"}}, // Denzlingen station
    {Coordinate{18.4728, 49.6697}, CountryId{"CZ"}}, // Dobratice-Vojkovice
    {Coordinate{13.7904, 51.0214}, CountryId{"DE"}}, // Dresden-Reick station
    {Coordinate{13.8086, 51.0117}, CountryId{"DE"}}, // Dresden-Dobritz station
    {Coordinate{18.1714, 49.8806}, CountryId{"CZ"}}, // Děhylov (train station)
    {Coordinate{19.42, 54.1503}, CountryId{"PL"}}, // Elblag
    {Coordinate{9.6653, 47.5642}, CountryId{"DE"}}, // Enzisweiler
    {Coordinate{21.867, 47.7094}, CountryId{"HU"}}, // Q116978570
    {Coordinate{18.3395, 46.6309}, CountryId{"HU"}}, // Q116978571
    {Coordinate{22.4298, 47.7759}, CountryId{"HU"}}, // Q116978572
    {Coordinate{18.4014, 46.6093}, CountryId{"HU"}}, // Q116978573
    {Coordinate{}, CountryId{"HU"}}, // Q116978574
    {Coordinate{17.3219, 47.6233}, CountryId{"HU"}}, // Q116978575
    {Coordinate{}, CountryId{"HU"}}, // Q116978576
    {Coordinate{21.849, 47.7715}, CountryId{"HU"}}, // Q116978577
    {Coordinate{}, CountryId{"HU"}}, // Q116978578
    {Coordinate{}, CountryId{"HU"}}, // Q116978579
    {Coordinate{20.353, 48.0576}, CountryId{"HU"}}, // Q116978581
    {Coordinate{18.395, 45.8322}, CountryId{"HU"}}, // Q116978582
    {Coordinate{18.1293, 47.1048}, CountryId{"HU"}}, // Berhida railway stop
    {Coordinate{21.8486, 47.8153}, CountryId{"HU"}}, // Q116978584
    {Coordinate{18.5101, 47.0724}, CountryId{"HU"}}, // Q116978585
    {Coordinate{20.6773, 46.5407}, CountryId{"HU"}}, // Q116978586
    {Coordinate{17.7821, 45.8694}, CountryId{"HU"}}, // Q116978588
    {Coordinate{}, CountryId{"HU"}}, // Q116978589
    {Coordinate{}, CountryId{"HU"}}, // Q116978590
    {Coordinate{}, CountryId{"HU"}}, // Q116978591
    {Coordinate{}, CountryId{"HU"}}, // Q116978592
    {Coordinate{20.685, 47.8699}, CountryId{"HU"}}, // Q116978593
    {Coordinate{17.1694, 47.2481}, CountryId{"HU"}}, // Q116978594
    {Coordinate{20.3449, 48.2527}, CountryId{"HU"}}, // Q116978595
    {Coordinate{20.3571, 48.2624}, CountryId{"HU"}}, // Q116978596
    {Coordinate{21.8472, 47.7586}, CountryId{"HU"}}, // Q116978597
    {Coordinate{17.9099, 45.8843}, CountryId{"HU"}}, // Q116978598
    {Coordinate{21.7153, 47.8884}, CountryId{"HU"}}, // Q116978599
    {Coordinate{18.1526, 46.3371}, CountryId{"HU"}}, // Q116978600
    {Coordinate{18.2204, 47.1741}, CountryId{"HU"}}, // Q116978601
    {Coordinate{20.7505, 48.0911}, CountryId{"HU"}}, // Q116978602
    {Coordinate{21.454, 46.9753}, CountryId{"HU"}}, // Q116978603
    {Coordinate{}, CountryId{"HU"}}, // Q116978604
    {Coordinate{17.2774, 47.6108}, CountryId{"HU"}}, // Q116978605
    {Coordinate{18.1323, 45.839}, CountryId{"HU"}}, // Q116978606
    {Coordinate{17.7519, 45.8877}, CountryId{"HU"}}, // Q116978607
    {Coordinate{17.5793, 45.9626}, CountryId{"HU"}}, // Q116978608
    {Coordinate{18.9434, 46.9772}, CountryId{"HU"}}, // Q116978609
    {Coordinate{18.258, 46.9229}, CountryId{"HU"}}, // Q116978610
    {Coordinate{}, CountryId{"HU"}}, // Q116978611
    {Coordinate{22.168, 48.3547}, CountryId{"HU"}}, // Q116978612
    {Coordinate{17.5792, 46.7196}, CountryId{"HU"}}, // Q116978613
    {Coordinate{19.3294, 46.6041}, CountryId{"HU"}}, // Q116978614
    {Coordinate{18.5959, 46.9396}, CountryId{"HU"}}, // Q116978615
    {Coordinate{}, CountryId{"HU"}}, // Q116978616
    {Coordinate{19.0914, 47.4648}, CountryId{"HU"}}, // Q116978617
    {Coordinate{}, CountryId{"HU"}}, // Q116978618
    {Coordinate{21.1387, 47.8029}, CountryId{"HU"}}, // Q116978619
    {Coordinate{20.4883, 46.3137}, CountryId{"HU"}}, // Földeák railway station
    {Coordinate{}, CountryId{"HU"}}, // Q116978621
    {Coordinate{17.768, 47.7307}, CountryId{"HU"}}, // Q116978622
    {Coordinate{21.8504, 47.7918}, CountryId{"HU"}}, // Q116978623
    {Coordinate{21.0061, 47.6177}, CountryId{"HU"}}, // Q116978624
    {Coordinate{17.6299, 47.6724}, CountryId{"HU"}}, // Q116978625
    {Coordinate{17.6451, 47.6857}, CountryId{"HU"}}, // Q116978627
    {Coordinate{21.2103, 46.6593}, CountryId{"HU"}}, // Q116978629
    {Coordinate{21.6625, 47.4028}, CountryId{"HU"}}, // Q116978630
    {Coordinate{18.0392, 47.1478}, CountryId{"HU"}}, // Q116978632
    {Coordinate{19.8226, 46.6743}, CountryId{"HU"}}, // Q116978633
    {Coordinate{18.2248, 45.8547}, CountryId{"HU"}}, // Q116978634
    {Coordinate{}, CountryId{"HU"}}, // Q116978635
    {Coordinate{}, CountryId{"HU"}}, // Q116978636
    {Coordinate{20.3617, 46.4073}, CountryId{"HU"}}, // Q116978637
    {Coordinate{19.9569, 48.0251}, CountryId{"HU"}}, // Q116978638
    {Coordinate{21.7292, 47.3993}, CountryId{"HU"}}, // Q116978639
    {Coordinate{}, CountryId{"HU"}}, // Q116978640
    {Coordinate{18.1712, 47.1974}, CountryId{"HU"}}, // Q116978641
    {Coordinate{20.652, 48.3108}, CountryId{"HU"}}, // Q116978643
    {Coordinate{}, CountryId{"HU"}}, // Q116978644
    {Coordinate{}, CountryId{"HU"}}, // Q116978645
    {Coordinate{17.9532, 47.126}, CountryId{"HU"}}, // Q116978647
    {Coordinate{18.6503, 46.5891}, CountryId{"HU"}}, // Q116978648
    {Coordinate{20.5939, 46.5307}, CountryId{"HU"}}, // Q116978649
    {Coordinate{}, CountryId{"HU"}}, // Q116978650
    {Coordinate{18.3114, 46.2773}, CountryId{"HU"}}, // Q116978651
    {Coordinate{20.8892, 47.3376}, CountryId{"HU"}}, // Q116978652
    {Coordinate{}, CountryId{"HU"}}, // Q116978653
    {Coordinate{17.6196, 45.9612}, CountryId{"HU"}}, // Q116978654
    {Coordinate{18.097, 45.8293}, CountryId{"HU"}}, // Q116978657
    {Coordinate{21.0009, 47.0012}, CountryId{"HU"}}, // Q116978658
    {Coordinate{17.7204, 45.9701}, CountryId{"HU"}}, // Q116978660
    {Coordinate{16.984, 46.637}, CountryId{"HU"}}, // Q116978661
    {Coordinate{21.555, 47.5485}, CountryId{"HU"}}, // Q116978662
    {Coordinate{21.1087, 47.724}, CountryId{"HU"}}, // Q116978663
    {Coordinate{20.8287, 48.0309}, CountryId{"HU"}}, // Q116978664
    {Coordinate{17.4768, 47.0891}, CountryId{"HU"}}, // Q116978665
    {Coordinate{21.4913, 46.976}, CountryId{"HU"}}, // Q116978666
    {Coordinate{18.1254, 47.7486}, CountryId{"HU"}}, // Q116978667
    {Coordinate{20.7907, 46.7556}, CountryId{"HU"}}, // Q116978668
    {Coordinate{20.2521, 46.3809}, CountryId{"HU"}}, // Q116978669
    {Coordinate{}, CountryId{"HU"}}, // Q116978670
    {Coordinate{21.3351, 46.9593}, CountryId{"HU"}}, // Q116978671
    {Coordinate{18.1892, 45.8373}, CountryId{"HU"}}, // Q116978672
    {Coordinate{19.1223, 47.4778}, CountryId{"HU"}}, // Q116978673
    {Coordinate{19.156, 47.4627}, CountryId{"HU"}}, // Q116978674
    {Coordinate{19.1215, 47.4916}, CountryId{"HU"}}, // Q116978675
    {Coordinate{18.6729, 46.539}, CountryId{"HU"}}, // Q116978676
    {Coordinate{21.641, 47.0128}, CountryId{"HU"}}, // Q116978677
    {Coordinate{21.3958, 46.9676}, CountryId{"HU"}}, // Q116978678
    {Coordinate{21.6061, 47.0081}, CountryId{"HU"}}, // Q116978679
    {Coordinate{18.1686, 47.0704}, CountryId{"HU"}}, // Küngös railway stop
    {Coordinate{}, CountryId{"HU"}}, // Q116978681
    {Coordinate{21.499, 47.5587}, CountryId{"HU"}}, // Q116978682
    {Coordinate{17.3786, 46.8756}, CountryId{"HU"}}, // Q116978683
    {Coordinate{21.879, 47.3936}, CountryId{"HU"}}, // Q116978684
    {Coordinate{18.5592, 47.3036}, CountryId{"HU"}}, // Q116978685
    {Coordinate{16.9809, 46.5495}, CountryId{"HU"}}, // Q116978686
    {Coordinate{20.496, 46.2313}, CountryId{"HU"}}, // Makó-Újváros railway station
    {Coordinate{18.2705, 45.866}, CountryId{"HU"}}, // Q116978688
    {Coordinate{19.9698, 48.0337}, CountryId{"HU"}}, // Q116978689
    {Coordinate{21.6201, 47.436}, CountryId{"HU"}}, // Q116978690
    {Coordinate{20.7888, 48.1339}, CountryId{"HU"}}, // Q116978691
    {Coordinate{21.7747, 47.3906}, CountryId{"HU"}}, // Q116978692
    {Coordinate{18.6623, 46.2218}, CountryId{"HU"}}, // Q116978693
    {Coordinate{17.9464, 45.8771}, CountryId{"HU"}}, // Q116978694
    {Coordinate{}, CountryId{"HU"}}, // Q116978695
    {Coordinate{}, CountryId{"HU"}}, // Q116978696
    {Coordinate{18.38, 45.848}, CountryId{"HU"}}, // Q116978697
    {Coordinate{20.9866, 47.6536}, CountryId{"HU"}}, // Q116978698
    {Coordinate{16.7852, 47.4783}, CountryId{"HU"}}, // Q116978699
    {Coordinate{}, CountryId{"HU"}}, // Q116978700
    {Coordinate{19.2559, 46.1148}, CountryId{"HU"}}, // Q116978701
    {Coordinate{19.2641, 47.2861}, CountryId{"HU"}}, // Q116978702
    {Coordinate{20.917, 48.1443}, CountryId{"HU"}}, // Q116978703
    {Coordinate{}, CountryId{"HU"}}, // Q116978704
    {Coordinate{20.6487, 48.3333}, CountryId{"HU"}}, // Q116978705
    {Coordinate{19.1185, 46.5237}, CountryId{"HU"}}, // Q116978706
    {Coordinate{19.7357, 46.5383}, CountryId{"HU"}}, // Q116978707
    {Coordinate{18.3717, 46.6224}, CountryId{"HU"}}, // Q116978708
    {Coordinate{}, CountryId{"HU"}}, // Q116978709
    {Coordinate{18.0899, 47.0982}, CountryId{"HU"}}, // Papkeszi railway station
    {Coordinate{22.6134, 47.8492}, CountryId{"HU"}}, // Q116978712
    {Coordinate{16.7214, 47.5878}, CountryId{"HU"}}, // Q116978713
    {Coordinate{}, CountryId{"HU"}}, // Q116978714
    {Coordinate{21.1306, 47.8616}, CountryId{"HU"}}, // Q116978715
    {Coordinate{}, CountryId{"HU"}}, // Q116978716
    {Coordinate{20.1265, 47.9283}, CountryId{"HU"}}, // Q116978717
    {Coordinate{21.2022, 47.982}, CountryId{"HU"}}, // Q116978718
    {Coordinate{20.6294, 48.3676}, CountryId{"HU"}}, // Q116978719
    {Coordinate{20.6328, 48.3641}, CountryId{"HU"}}, // Q116978720
    {Coordinate{20.7233, 48.1673}, CountryId{"HU"}}, // Q116978721
    {Coordinate{18.0392, 45.8446}, CountryId{"HU"}}, // Q116978722
    {Coordinate{18.5527, 47.0092}, CountryId{"HU"}}, // Q116978723
    {Coordinate{17.1685, 46.7099}, CountryId{"HU"}}, // Q116978724
    {Coordinate{18.3604, 47.1689}, CountryId{"HU"}}, // Q116978725
    {Coordinate{18.7207, 46.2436}, CountryId{"HU"}}, // Q116978726
    {Coordinate{18.5696, 46.9775}, CountryId{"HU"}}, // Q116978727
    {Coordinate{18.3148, 47.1701}, CountryId{"HU"}}, // Q116978728
    {Coordinate{18.3058, 45.859}, CountryId{"HU"}}, // Q116978729
    {Coordinate{18.2863, 45.8632}, CountryId{"HU"}}, // Q116978730
    {Coordinate{18.0611, 46.9102}, CountryId{"HU"}}, // Q116978731
    {Coordinate{18.0378, 47.13}, CountryId{"HU"}}, // Sóly railway stop
    {Coordinate{16.5994, 47.669}, CountryId{"HU"}}, // Q116978733
    {Coordinate{}, CountryId{"HU"}}, // Q116978735
    {Coordinate{21.1229, 46.6076}, CountryId{"HU"}}, // Q116978736
    {Coordinate{18.1873, 47.5169}, CountryId{"HU"}}, // Q116978737
    {Coordinate{}, CountryId{"HU"}}, // Q116978738
    {Coordinate{18.7172, 46.4785}, CountryId{"HU"}}, // Q116978739
    {Coordinate{20.1252, 46.2303}, CountryId{"HU"}}, // Q116978740
    {Coordinate{21.5986, 47.4783}, CountryId{"HU"}}, // Q116978741
    {Coordinate{21.6126, 47.4538}, CountryId{"HU"}}, // Q116978742
    {Coordinate{}, CountryId{"HU"}}, // Q116978743
    {Coordinate{}, CountryId{"HU"}}, // Q116978744
    {Coordinate{}, CountryId{"HU"}}, // Q116978745
    {Coordinate{16.6372, 47.2293}, CountryId{"HU"}}, // Q116978746
    {Coordinate{17.6799, 45.9719}, CountryId{"HU"}}, // Q116978747
    {Coordinate{20.6564, 48.2816}, CountryId{"HU"}}, // Q116978748
    {Coordinate{17.7335, 45.9576}, CountryId{"HU"}}, // Q116978749
    {Coordinate{}, CountryId{"HU"}}, // Q116978750
    {Coordinate{21.0085, 47.6936}, CountryId{"HU"}}, // Q116978751
    {Coordinate{21.2473, 48.0192}, CountryId{"HU"}}, // Q116978752
    {Coordinate{21.2078, 47.9949}, CountryId{"HU"}}, // Q116978753
    {Coordinate{21.3153, 48.0179}, CountryId{"HU"}}, // Q116978754
    {Coordinate{}, CountryId{"HU"}}, // Q116978756
    {Coordinate{}, CountryId{"HU"}}, // Q116978757
    {Coordinate{20.7916, 46.311}, CountryId{"HU"}}, // Q116978758
    {Coordinate{21.114, 47.7445}, CountryId{"HU"}}, // Q116978759
    {Coordinate{21.1752, 47.9162}, CountryId{"HU"}}, // Q116978760
    {Coordinate{17.3359, 46.8934}, CountryId{"HU"}}, // Q116978761
    {Coordinate{17.9885, 45.8617}, CountryId{"HU"}}, // Q116978762
    {Coordinate{19.0956, 47.5419}, CountryId{"HU"}}, // Q116978763
    {Coordinate{17.7386, 45.9338}, CountryId{"HU"}}, // Q116978764
    {Coordinate{19.8064, 48.0401}, CountryId{"HU"}}, // Q116978765
    {Coordinate{17.6577, 45.9694}, CountryId{"HU"}}, // Q116978767
    {Coordinate{22.1733, 48.3919}, CountryId{"HU"}}, // Q116978768
    {Coordinate{17.4515, 46.9129}, CountryId{"HU"}}, // Q116978769
    {Coordinate{20.7774, 48.2404}, CountryId{"HU"}}, // Q116978770
    {Coordinate{9.4095, 47.6883}, CountryId{"DE"}}, // Friedrichshafen-Kluftern
    {Coordinate{9.4291, 47.6643}, CountryId{"DE"}}, // Friedrichshafen-Manzell
    {Coordinate{11.84, 51.6353}, CountryId{"DE"}}, // Domnitz (Saalkr) station
    {Coordinate{19.3589, 47.5924}, CountryId{"HU"}}, // Gödöllő railway station
    {Coordinate{8.03083, 44.6978}, CountryId{"IT"}}, // Alba railway station
    {Coordinate{15.2056, 50.8761}, CountryId{"CZ"}}, // Bílý Potok pod Smrkem
    {Coordinate{10.1237, 49.8644}, CountryId{"DE"}}, // Prosselsheim
    {Coordinate{10.1022, 49.857}, CountryId{"DE"}}, // Seligenstadt Mainschleifenbahn
    {Coordinate{10.1538, 49.8694}, CountryId{"DE"}}, // Eisenheim
    {Coordinate{10.1655, 49.8668}, CountryId{"DE"}}, // Escherndorf
    {Coordinate{10.2183, 49.8644}, CountryId{"DE"}}, // Volkach-Astheim
    {Coordinate{19.115, 47.5005}, CountryId{"HU"}}, // Q117081716
    {Coordinate{11.9661, 51.445}, CountryId{"DE"}}, // Halle-Silberhöhe
    {Coordinate{12.4938, 64.5686}, CountryId{"NO"}}, // Harran Station
    {Coordinate{26.0459, 61.2028}, CountryId{"FI"}}, // Heinola railway station
    {Coordinate{11.0105, 52.2221}, CountryId{"DE"}}, // Helmstedt railway station
    {Coordinate{10.2133, 47.5592}, CountryId{"DE"}}, // Immenstadt
    {Coordinate{10.7621, 47.219}, CountryId{"AT"}}, // Imst-Pitztal railway station
    {Coordinate{18.24, 52.8014}, CountryId{"PL"}}, // Inowrocław railway station
    {Coordinate{17.6917, 49.9175}, CountryId{"CZ"}}, // Q11716284
    {Coordinate{17.3181, 49.9342}, CountryId{"CZ"}}, // Q11716730
    {Coordinate{17.4946, 51.9687}, CountryId{"PL"}}, // Jarocin
    {Coordinate{17.0156, 50.395}, CountryId{"CZ"}}, // Javorník ve Slezsku (train station)
    {Coordinate{17.9019, 49.6152}, CountryId{"CZ"}}, // Jeseník nad Odrou
    {Coordinate{17.1935, 50.2277}, CountryId{"CZ"}}, // Jeseník
    {Coordinate{18.1414, 49.8978}, CountryId{"CZ"}}, // Jilešovice
    {Coordinate{17.5383, 50.2483}, CountryId{"CZ"}}, // Q11727217
    {Coordinate{18.1509, 49.749}, CountryId{"CZ"}}, // Jistebník
    {Coordinate{9.40273, 49.1438}, CountryId{"DE"}}, // Eschenau (b Heilbronn)
    {Coordinate{}, CountryId{"DE"}}, // Hesseneck-Schöllenbach
    {Coordinate{8.49296, 49.8538}, CountryId{"DE"}}, // Riedstadt-Wolfskehlen
    {Coordinate{16.4051, 50.7322}, CountryId{"PL"}}, // Train station in Jugowice
    {Coordinate{12.1675, 49.4858}, CountryId{"DE"}}, // Pfreimd
    {Coordinate{11.8007, 48.4107}, CountryId{"DE"}}, // Marzling
    {Coordinate{9.9129, 49.7313}, CountryId{"DE"}}, // Reichenberg (Unterfr)
    {Coordinate{25.1739, 61.8649}, CountryId{"FI"}}, // Jämsä railway station
    {Coordinate{17.4419, 49.7103}, CountryId{"CZ"}}, // Q11729826
    {Coordinate{4.62794, 49.7932}, CountryId{"FR"}}, // Tournes station
    {Coordinate{13.0544, 51.9976}, CountryId{"DE"}}, // Jüterbog station
    {Coordinate{22.874, 54.655}, CountryId{"LT"}}, // Alvitas train station
    {Coordinate{24.886, 55.77}, CountryId{"LT"}}, // Radžiūnai train station
    {Coordinate{24.16, 55.744}, CountryId{"LT"}}, // Gustonys train station
    {Coordinate{25.459, 55.916}, CountryId{"LT"}}, // Tindžiuliai train station
    {Coordinate{23.664, 55.726}, CountryId{"LT"}}, // Gimbogala train station
    {Coordinate{23.414, 55.864}, CountryId{"LT"}}, // Šilėnai train station
    {Coordinate{22.588, 55.991}, CountryId{"LT"}}, // Tryškiai train station
    {Coordinate{21.971, 55.947}, CountryId{"LT"}}, // Tarvainiai train station
    {Coordinate{21.647, 55.961}, CountryId{"LT"}}, // Šateikiai train station
    {Coordinate{22.099, 55.972}, CountryId{"LT"}}, // Lieplaukė train station
    {Coordinate{17.4394, 50.105}, CountryId{"CZ"}}, // Q11735892
    {Coordinate{17.4281, 50.1075}, CountryId{"CZ"}}, // Q11735893
    {Coordinate{8.3629, 49.0021}, CountryId{"DE"}}, // Karlsruhe West station
    {Coordinate{17.6836, 50.0889}, CountryId{"CZ"}}, // Krnov (train station)
    {Coordinate{18.5397, 49.8347}, CountryId{"CZ"}}, // Karviná-Darkov
    {Coordinate{18.5272, 49.8558}, CountryId{"CZ"}}, // Karviná Main Station
    {Coordinate{9.4519, 51.3319}, CountryId{"DE"}}, // Kassel-Harleshausen station
    {Coordinate{9.454, 51.2763}, CountryId{"DE"}}, // Kassel-Oberzwehren railway station
    {Coordinate{9.54806, 47.6828}, CountryId{"DE"}}, // Kehlen station
    {Coordinate{20.6178, 50.8742}, CountryId{"PL"}}, // Kielce train station
    {Coordinate{17.6989, 50.2281}, CountryId{"CZ"}}, // Q11740482
    {Coordinate{17.1256, 50.3383}, CountryId{"CZ"}}, // Q11740588
    {Coordinate{18.5981, 49.7814}, CountryId{"CZ"}}, // Chotěbuz (Kocobędz)
    {Coordinate{13.4986, 52.8151}, CountryId{"DE"}}, // Lottschesee
    {Coordinate{16.345, 50.7208}, CountryId{"PL"}}, // Q117425950
    {Coordinate{9.16285, 47.6775}, CountryId{"DE"}}, // Konstanz Fürstenberg station
    {Coordinate{9.17347, 47.6741}, CountryId{"DE"}}, // Konstanz-Petershausen station
    {Coordinate{9.14733, 47.6825}, CountryId{"DE"}}, // Konstanz-Wollmatingen station
    {Coordinate{13.9993, 54.0452}, CountryId{"DE"}}, // Koserow railway station
    {Coordinate{14.6472, 52.5915}, CountryId{"PL"}}, // Kostrzyn station
    {Coordinate{18.1539, 49.9106}, CountryId{"CZ"}}, // Kozmice
    {Coordinate{15.5697, 54.1822}, CountryId{"PL"}}, // Train station in Kołobrzeg
    {Coordinate{12.129, 53.5166}, CountryId{"DE"}}, // Gallin
    {Coordinate{12.0539, 53.5081}, CountryId{"DE"}}, // Passow (Meckl)
    {Coordinate{1.16988, 46.9922}, CountryId{"FR"}}, // gare de Châtillon-sur-Indre
    {Coordinate{18.0392, 49.9308}, CountryId{"CZ"}}, // Kravaře-Kouty
    {Coordinate{18.01, 49.935}, CountryId{"CZ"}}, // Kravaře ve Slezsku
    {Coordinate{6.6295, 51.3373}, CountryId{"DE"}}, // Krefeld-Linn station
    {Coordinate{6.6459, 51.3575}, CountryId{"DE"}}, // Krefeld-Uerdingen station
    {Coordinate{17.7128, 50.0939}, CountryId{"CZ"}}, // Krnov-Cvilín
    {Coordinate{14.9396, 51.0154}, CountryId{"PL"}}, // Krzewina Zgorzelecka train station
    {Coordinate{15.9706, 50.6731}, CountryId{"CZ"}}, // Královec
    {Coordinate{17.6381, 50.1256}, CountryId{"CZ"}}, // Krásné Loučky
    {Coordinate{16.2445, 50.4298}, CountryId{"PL"}}, // Kudowa-Zdrój
    {Coordinate{17.5158, 50.0372}, CountryId{"CZ"}}, // Kunov
    {Coordinate{18.2951, 49.535}, CountryId{"CZ"}}, // Kunčice pod Ondřejníkem
    {Coordinate{17.9089, 49.925}, CountryId{"CZ"}}, // Q11751788
    {Coordinate{14.0667, 54}, CountryId{"DE"}}, // Kölpinsee railway station
    {Coordinate{14.608, 52.5684}, CountryId{"DE"}}, // Küstrin-Kietz station
    {Coordinate{12.7142, 64.6961}, CountryId{"NO"}}, // Lassemoen Station
    {Coordinate{12.4299, 51.3716}, CountryId{"DE"}}, // Leipzig-Thekla railway station
    {Coordinate{12.3894, 51.3962}, CountryId{"DE"}}, // Leipzig Messe railway station
    {Coordinate{12.3744, 51.3629}, CountryId{"DE"}}, // Leipzig-Gohlis railway station
    {Coordinate{12.4438, 51.3442}, CountryId{"DE"}}, // Leipzig-Paunsdorf station
    {Coordinate{23.7542, 61.3133}, CountryId{"FI"}}, // Lempäälä railway station
    {Coordinate{16.5656, 51.8469}, CountryId{"PL"}}, // Leszno
    {Coordinate{18.0472, 49.9072}, CountryId{"CZ"}}, // Lhota u Opavy
    {Coordinate{15.0456, 50.7614}, CountryId{"CZ"}}, // Liberec (train station)
    {Coordinate{16.6589, 50.0973}, CountryId{"CZ"}}, // Lichkov (train station)
    {Coordinate{9.68472, 47.5593}, CountryId{"DE"}}, // Lindau-Aeschach
    {Coordinate{17.6142, 50.1364}, CountryId{"CZ"}}, // Linhartovy
    {Coordinate{17.5729, 49.5292}, CountryId{"CZ"}}, // Lipník nad Bečvou (train station)
    {Coordinate{17.1311, 50.2283}, CountryId{"CZ"}}, // Lipová Lázně
    {Coordinate{17.1431, 50.2447}, CountryId{"CZ"}}, // Lipová Lázně jeskyně
    {Coordinate{17.1606, 50.2294}, CountryId{"CZ"}}, // Lipová Lázně zastávka
    {Coordinate{17.6086, 50.2236}, CountryId{"CZ"}}, // Liptaň
    {Coordinate{8.72952, 54.7303}, CountryId{"DE"}}, // Dagebüll Kirche  station
    {Coordinate{8.81841, 54.7771}, CountryId{"DE"}}, // Deezbüll  station
    {Coordinate{17.7342, 49.8875}, CountryId{"CZ"}}, // Q11761999
    {Coordinate{17.4192, 49.8733}, CountryId{"CZ"}}, // Lomnice u Rýmařova
    {Coordinate{9.05294, 47.8156}, CountryId{"DE"}}, // Ludwigshafen (Bodensee)
    {Coordinate{16.9167, 49.8252}, CountryId{"CZ"}}, // Lukavice na Moravě
    {Coordinate{16.8415, 49.868}, CountryId{"CZ"}}, // Lupěné
    {Coordinate{18.4144, 49.9125}, CountryId{"CZ"}}, // Dolní Lutyně
    {Coordinate{18.3281, 49.6981}, CountryId{"CZ"}}, // Lískovec u Frýdku
    {Coordinate{9.4993, 47.6615}, CountryId{"DE"}}, // Löwental station
    {Coordinate{13.961, 51.8622}, CountryId{"DE"}}, // Lübbenau railway station
    {Coordinate{16.8612, 50.3419}, CountryId{"PL"}}, // Train station in Lądek-Zdrój
    {Coordinate{11.6578, 52.1665}, CountryId{"DE"}}, // Magdeburg-Eichenweiler railway station
    {Coordinate{8.3141, 49.9612}, CountryId{"DE"}}, // Mainz-Laubenheim station
    {Coordinate{17.3169, 50.01}, CountryId{"CZ"}}, // Malá Morávka (train station)
    {Coordinate{17.9458, 49.9322}, CountryId{"CZ"}}, // Q11766896
    {Coordinate{19.9288, 54.4615}, CountryId{"RU"}}, // Mamonovo railway station
    {Coordinate{8.4541, 49.4933}, CountryId{"DE"}}, // Mannheim-Handelshafen station
    {Coordinate{8.53514, 49.4238}, CountryId{"DE"}}, // Mannheim-Rheinau station
    {Coordinate{9.36987, 47.4232}, CountryId{"CH"}}, // St. Gallen railway station
    {Coordinate{9.00277, 47.7394}, CountryId{"DE"}}, // Markelfingen station
    {Coordinate{9.3884, 47.7168}, CountryId{"DE"}}, // Markdorf (Baden)
    {Coordinate{9.5584, 47.6996}, CountryId{"DE"}}, // Meckenbeuren
    {Coordinate{15.3353, 50.7641}, CountryId{"CZ"}}, // Desná-Pustinská
    {Coordinate{15.3141, 50.7592}, CountryId{"CZ"}}, // Q11774649
    {Coordinate{11.1431, 47.8449}, CountryId{"DE"}}, // Weilheim (Oberbay) station
    {Coordinate{6.6353, 49.4436}, CountryId{"DE"}}, // Merzig (Saar) Stadtmitte station
    {Coordinate{11.6105, 49.8856}, CountryId{"DE"}}, // Neuenreuth (b Creußen)
    {Coordinate{16.2436, 50.6266}, CountryId{"CZ"}}, // Meziměstí railway station
    {Coordinate{12.1649, 49.7153}, CountryId{"DE"}}, // Altenstadt (Waldnaab)
    {Coordinate{11.5947, 49.958}, CountryId{"DE"}}, // Bayreuth-St Georgen
    {Coordinate{27.2776, 61.6879}, CountryId{"FI"}}, // Mikkeli railway station
    {Coordinate{17.3206, 50.3025}, CountryId{"CZ"}}, // Mikulovice (train station)
    {Coordinate{15.1086, 51.0951}, CountryId{"PL"}}, // Mikułowa station
    {Coordinate{17.5578, 50.0142}, CountryId{"CZ"}}, // Milotice nad Opavou
    {Coordinate{11.7232, 49.9437}, CountryId{"DE"}}, // Weidenberg
    {Coordinate{12.9598, 50.9872}, CountryId{"DE"}}, // Mittweida railway station
    {Coordinate{17.7122, 49.8944}, CountryId{"CZ"}}, // Q11784196
    {Coordinate{16.9429, 49.7768}, CountryId{"CZ"}}, // Mohelnice
    {Coordinate{18.0308, 49.9094}, CountryId{"CZ"}}, // Mokré Lazce
    {Coordinate{16.9685, 49.7583}, CountryId{"CZ"}}, // Moravičany
    {Coordinate{17.4325, 49.7847}, CountryId{"CZ"}}, // Moravský Beroun
    {Coordinate{18.7514, 49.5078}, CountryId{"CZ"}}, // Mosty u Jablunkova station
    {Coordinate{18.7515, 49.5241}, CountryId{"CZ"}}, // Mosty u Jablunkova
    {Coordinate{14.5581, 67.2839}, CountryId{"NO"}}, // Mørkved Station
    {Coordinate{11.4283, 48.1546}, CountryId{"DE"}}, // München Leienfelsstraße station
    {Coordinate{11.4439, 48.149}, CountryId{"DE"}}, // München-Westkreuz station
    {Coordinate{17.5783, 50.1681}, CountryId{"CZ"}}, // Q11787946
    {Coordinate{12.8864, 52.6125}, CountryId{"DE"}}, // Nauen railway station
    {Coordinate{14.0667, 54}, CountryId{"DE"}}, // Neu Pudagla railway station
    {Coordinate{13.2617, 53.5622}, CountryId{"DE"}}, // Neubrandenburg railway station
    {Coordinate{8.61171, 47.6829}, CountryId{"CH"}}, // Neuhausen Badischer Bahnhof
    {Coordinate{8.49481, 47.6892}, CountryId{"CH"}}, // Neunkirch railway station
    {Coordinate{88.4427, 26.6824}, CountryId{"IN"}}, // New Jalpaiguri Junction railway station
    {Coordinate{11.6282, 49.9626}, CountryId{"DE"}}, // Friedrichsthal (b Bayreuth)
    {Coordinate{11.6167, 49.9596}, CountryId{"DE"}}, // Laineck
    {Coordinate{9.6125, 47.5753}, CountryId{"DE"}}, // Nonnenhorn railway station
    {Coordinate{17.5269, 50.0247}, CountryId{"CZ"}}, // Q11793340
    {Coordinate{20.7025, 49.6067}, CountryId{"PL"}}, // Nowy Sącz train station
    {Coordinate{18.7545, 49.5902}, CountryId{"CZ"}}, // Návsí
    {Coordinate{11.048, 49.4101}, CountryId{"DE"}}, // Nürnberg-Eibach
    {Coordinate{11.0547, 49.4296}, CountryId{"DE"}}, // Nürnberg-Sandreuth
    {Coordinate{11.1113, 49.4445}, CountryId{"DE"}}, // Nürnberg-Gleißhammer
    {Coordinate{11.0681, 49.4428}, CountryId{"DE"}}, // Nürnberg-Steinbühl
    {Coordinate{11.1207, 49.4638}, CountryId{"DE"}}, // Nürnberg Ost
    {Coordinate{10.3667, 55.3814}, CountryId{"DK"}}, // Odense Sygehus Station
    {Coordinate{17.2784, 49.5926}, CountryId{"CZ"}}, // Olomouc hlavní nádraží
    {Coordinate{17.3436, 50.2725}, CountryId{"CZ"}}, // Q11798302
    {Coordinate{17.3539, 50.2631}, CountryId{"CZ"}}, // Q11798303
    {Coordinate{17.9594, 49.9178}, CountryId{"CZ"}}, // Opava-Komarov
    {Coordinate{17.9342, 49.9292}, CountryId{"CZ"}}, // Q11798471
    {Coordinate{17.8889, 49.9386}, CountryId{"CZ"}}, // Opava západ
    {Coordinate{10.4979, 48.8507}, CountryId{"DE"}}, // Nördlingen
    {Coordinate{17.5235, 49.5171}, CountryId{"CZ"}}, // Osek nad Bečvou
    {Coordinate{17.7222, 50.2683}, CountryId{"CZ"}}, // Osoblaha (train station)
    {Coordinate{18.34, 49.7786}, CountryId{"CZ"}}, // Q11800679
    {Coordinate{18.2897, 49.8633}, CountryId{"CZ"}}, // Ostrava-Hrušov
    {Coordinate{18.2908, 49.7908}, CountryId{"CZ"}}, // Ostrava-Kunčice
    {Coordinate{18.2968, 49.8096}, CountryId{"CZ"}}, // Ostrava-Kunčičky
    {Coordinate{18.2803, 49.835}, CountryId{"CZ"}}, // Ostrava-Stodolní
    {Coordinate{18.2399, 49.8373}, CountryId{"CZ"}}, // Ostrava-Mariánské Hory (train station)
    {Coordinate{18.2101, 49.8213}, CountryId{"CZ"}}, // Ostrava-Svinov station
    {Coordinate{18.2622, 49.8011}, CountryId{"CZ"}}, // Ostrava-Vítkovice
    {Coordinate{18.1958, 49.8422}, CountryId{"CZ"}}, // Ostrava-Třebovice
    {Coordinate{18.3936, 49.5378}, CountryId{"CZ"}}, // Ostravice
    {Coordinate{18.2825, 49.8291}, CountryId{"CZ"}}, // Ostrava střed
    {Coordinate{18.3803, 49.5503}, CountryId{"CZ"}}, // Ostravice zastávka
    {Coordinate{17.8694, 49.9189}, CountryId{"CZ"}}, // Otice
    {Coordinate{11.8308, 53.4301}, CountryId{"DE"}}, // Parchim railway station
    {Coordinate{11.7241, 49.1642}, CountryId{"DE"}}, // Parsberg
    {Coordinate{9.22245, 49.646}, CountryId{"DE"}}, // Amorbach
    {Coordinate{9.13632, 49.9343}, CountryId{"DE"}}, // Aschaffenburg-Obernau
    {Coordinate{21.5191, 47.5631}, CountryId{"HU"}}, // Q118125500
    {Coordinate{21.5245, 47.5577}, CountryId{"HU"}}, // Q118125501
    {Coordinate{18.3036, 49.7358}, CountryId{"CZ"}}, // Paskov
    {Coordinate{13.0142, 49.0534}, CountryId{"DE"}}, // Böbrach
    {Coordinate{14.6469, 50.5733}, CountryId{"CZ"}}, // Doksy
    {Coordinate{10.2316, 52.319}, CountryId{"DE"}}, // Peine station
    {Coordinate{15.6544, 50.9688}, CountryId{"PL"}}, // Pilchowice Zapora
    {Coordinate{18.5484, 49.8934}, CountryId{"CZ"}}, // Petrovice u Karviné
    {Coordinate{20.8514, 49.2686}, CountryId{"SK"}}, // Q11819505
    {Coordinate{17.4481, 50.075}, CountryId{"CZ"}}, // Q11819964
    {Coordinate{18.1898, 49.7787}, CountryId{"CZ"}}, // Polanka nad Odrou (train station)
    {Coordinate{17.8555, 49.5743}, CountryId{"CZ"}}, // Polom
    {Coordinate{21.7875, 61.4772}, CountryId{"FI"}}, // Pori railway station
    {Coordinate{13.0367, 52.3928}, CountryId{"DE"}}, // Potsdam Charlottenhof railway station
    {Coordinate{14.3997, 50.097}, CountryId{"CZ"}}, // Praha-Dejvice
    {Coordinate{14.3486, 50.0329}, CountryId{"CZ"}}, // Praha-Holyně
    {Coordinate{14.5359, 50.055}, CountryId{"CZ"}}, // Praha-Hostivař
    {Coordinate{14.4043, 49.9903}, CountryId{"CZ"}}, // Praha-Komořany
    {Coordinate{14.3644, 49.9858}, CountryId{"CZ"}}, // Praha-Radotín
    {Coordinate{14.3937, 50.1324}, CountryId{"CZ"}}, // Praha-Sedlec
    {Coordinate{14.3995, 49.9706}, CountryId{"CZ"}}, // Praha-Zbraslav
    {Coordinate{14.3081, 50.0324}, CountryId{"CZ"}}, // Praha-Řeporyje
    {Coordinate{17.4849, 49.5032}, CountryId{"CZ"}}, // Prosenice
    {Coordinate{12.9499, 48.8394}, CountryId{"DE"}}, // Deggendorf Central Station
    {Coordinate{22.7767, 49.7839}, CountryId{"PL"}}, // Przemyśl Główny
    {Coordinate{17.4449, 49.447}, CountryId{"CZ"}}, // Přerov
    {Coordinate{18.3619, 49.6169}, CountryId{"CZ"}}, // Pržno
    {Coordinate{17.26, 50.2786}, CountryId{"CZ"}}, // Q11832244
    {Coordinate{18.3028, 49.7706}, CountryId{"CZ"}}, // Vratimov (train station)
    {Coordinate{8.97531, 47.7445}, CountryId{"DE"}}, // Radolfzell-Haselbrunn station
    {Coordinate{8.96898, 47.7359}, CountryId{"DE"}}, // Radolfzell station
    {Coordinate{19.1003, 49.5069}, CountryId{"PL"}}, // Rajcza Centrum railway station
    {Coordinate{17.3739, 49.4608}, CountryId{"CZ"}}, // Rokytnice u Přerova
    {Coordinate{17.1567, 49.6973}, CountryId{"CZ"}}, // Střeň
    {Coordinate{9.2483, 47.737}, CountryId{"DE"}}, // Uhldingen-Mühlhofen
    {Coordinate{17.0325, 51.1256}, CountryId{"PL"}}, // Wrocław Nadodrze
    {Coordinate{12.3453, 51.5242}, CountryId{"DE"}}, // Delitzsch unt Bf
    {Coordinate{11.5171, 50.3572}, CountryId{"DE"}}, // Dürrenwaid
    {Coordinate{11.5179, 50.3684}, CountryId{"DE"}}, // Nordhalben
    {Coordinate{9.22514, 49.6908}, CountryId{"DE"}}, // Miltenberg-Breitendiel
    {Coordinate{18.8289, 68.3492}, CountryId{"SE"}}, // Abisko östra
    {Coordinate{}, CountryId{"FI"}}, // Ajos rail yard
    {Coordinate{22.6958, 63.7069}, CountryId{"FI"}}, // Alholma (Leppäluoto) harbor track railway station
    {Coordinate{11.6566, 49.9615}, CountryId{"DE"}}, // Döhlau
    {Coordinate{9.3826, 49.7792}, CountryId{"DE"}}, // Dorfprozelten
    {Coordinate{29.0247, 64.4508}, CountryId{"FI"}}, // Arola railway station
    {Coordinate{24.9568, 60.3041}, CountryId{"FI"}}, // Aviapolis railway station
    {Coordinate{20.0414, 64.7897}, CountryId{"SE"}}, // Bastuträsk
    {Coordinate{18.6853, 68.4065}, CountryId{"SE"}}, // Björkliden
    {Coordinate{21.7078, 65.8289}, CountryId{"SE"}}, // Boden Central Station
    {Coordinate{14.8323, 63.0761}, CountryId{"SE"}}, // Brunflo
    {Coordinate{9.1546, 49.8046}, CountryId{"DE"}}, // Erlenbach (Main)
    {Coordinate{9.43763, 49.7871}, CountryId{"DE"}}, // Faulbach (Main)
    {Coordinate{10.1505, 50.5199}, CountryId{"DE"}}, // Fladungen
    {Coordinate{13.4409, 48.6553}, CountryId{"DE"}}, // Fischhaus
    {Coordinate{13.0274, 49.1912}, CountryId{"DE"}}, // Frahelsbruck
    {Coordinate{23.0808, 59.8656}, CountryId{"FI"}}, // Dynamitväxel
    {Coordinate{24.1908, 62.5411}, CountryId{"FI"}}, // Eläinpuisto-Zoo
    {Coordinate{13.4699, 48.7184}, CountryId{"DE"}}, // Fürsteneck
    {Coordinate{23.1835, 60.2233}, CountryId{"FI"}}, // Ervelä railway station
    {Coordinate{24.1508, 63.915}, CountryId{"FI"}}, // Eskola railway station
    {Coordinate{12.8783, 49.2027}, CountryId{"DE"}}, // Grafenwiesen
    {Coordinate{9.72542, 50.0261}, CountryId{"DE"}}, // Wernfeld
    {Coordinate{11.7002, 49.9574}, CountryId{"DE"}}, // Görschnitz
    {Coordinate{13.0023, 49.071}, CountryId{"DE"}}, // Gumpenried-Asbach
    {Coordinate{24.1309, 65.828}, CountryId{"FI"}}, // Haparanda railway station
    {Coordinate{25.5086, 60.9208}, CountryId{"FI"}}, // Q11861183
    {Coordinate{21.3458, 60.7961}, CountryId{"FI"}}, // Hangonsaari railway station
    {Coordinate{22.1336, 61.31}, CountryId{"FI"}}, // Harjavalta railway station
    {Coordinate{30.1933, 62.5567}, CountryId{"FI"}}, // Heinävaara railway station
    {Coordinate{25.4728, 60.8958}, CountryId{"FI"}}, // Herrala railway station
    {Coordinate{24.9231, 60.7536}, CountryId{"FI"}}, // Hikiä railway station
    {Coordinate{9.07205, 50.0029}, CountryId{"DE"}}, // Kleinostheim
    {Coordinate{25.2258, 64.7336}, CountryId{"FI"}}, // Hirvineva railway station
    {Coordinate{23.8491, 53.6865}, CountryId{"BY"}}, // Hrodna
    {Coordinate{28.4631, 64.6838}, CountryId{"FI"}}, // Hyrynsalmi railway station
    {Coordinate{11.689, 49.9694}, CountryId{"DE"}}, // Untersteinach (b Bayreuth)
    {Coordinate{29.4442, 63.4547}, CountryId{"FI"}}, // Q11864162
    {Coordinate{28.7767, 61.1958}, CountryId{"FI"}}, // Imatra railway station
    {Coordinate{24.1453, 62.5507}, CountryId{"FI"}}, // Inha railway station
    {Coordinate{26.8395, 60.6968}, CountryId{"FI"}}, // Inkeroinen railway station
    {Coordinate{22.3948, 62.9513}, CountryId{"FI"}}, // Isokyrö railway station
    {Coordinate{22.9542, 62.4719}, CountryId{"FI"}}, // Q11865685
    {Coordinate{9.25241, 49.6413}, CountryId{"DE"}}, // Schneeberg (Odenwald)
    {Coordinate{28.4892, 61.1203}, CountryId{"FI"}}, // Joutseno station
    {Coordinate{26.9378, 60.604}, CountryId{"FI"}}, // Juurikorpi railway station
    {Coordinate{20.6514, 67.1336}, CountryId{"SE"}}, // Gällivare Central Station
    {Coordinate{25.2744, 60.8675}, CountryId{"FI"}}, // Järvelä railway station
    {Coordinate{23.0222, 62.0269}, CountryId{"FI"}}, // Q11869011
    {Coordinate{27.3476, 60.9108}, CountryId{"FI"}}, // Q11869035
    {Coordinate{23.9147, 63.8986}, CountryId{"FI"}}, // Kannus railway station
    {Coordinate{23.3883, 61.7511}, CountryId{"FI"}}, // Karhejärvi railway station
    {Coordinate{24.44, 64.0244}, CountryId{"FI"}}, // Karhukangas railway station
    {Coordinate{22.2119, 62.4599}, CountryId{"FI"}}, // Q11870457
    {Coordinate{23.0356, 63.0997}, CountryId{"FI"}}, // Kauhava railway station
    {Coordinate{23.6833, 66.4483}, CountryId{"FI"}}, // Q11870545
    {Coordinate{27.2281, 63.7094}, CountryId{"FI"}}, // Q11870623
    {Coordinate{26.3303, 60.8853}, CountryId{"FI"}}, // Kausala railway station
    {Coordinate{25.5139, 64.9128}, CountryId{"FI"}}, // Kempele railway station
    {Coordinate{25.69, 54.639}, CountryId{"LT"}}, // Kena train station
    {Coordinate{29.8035, 61.8876}, CountryId{"FI"}}, // Q11871170
    {Coordinate{24.7069, 62.2555}, CountryId{"FI"}}, // Keuruu railway station
    {Coordinate{26.6117, 63.6411}, CountryId{"FI"}}, // Kiuruvesi railway station
    {Coordinate{27.4717, 64.4686}, CountryId{"FI"}}, // Kivesjärvi railway station
    {Coordinate{30.0646, 64.5496}, CountryId{"RU"}}, // Kiviyarvi
    {Coordinate{24.8458, 60.314}, CountryId{"FI"}}, // Kivistö railway station
    {Coordinate{13.6068, 48.7371}, CountryId{"DE"}}, // Waldkirchen (Niederbay)
    {Coordinate{22.3033, 61.2544}, CountryId{"FI"}}, // Kokemäki railway station
    {Coordinate{24.5069, 62.1281}, CountryId{"FI"}}, // Kolho railway station
    {Coordinate{29.8571, 62.7325}, CountryId{"FI"}}, // Kontiolahti railway station
    {Coordinate{28.1133, 64.3386}, CountryId{"FI"}}, // Kontiomäki railway station
    {Coordinate{12.8998, 49.2067}, CountryId{"DE"}}, // Watzelsteg
    {Coordinate{22.4622, 62.6881}, CountryId{"FI"}}, // Q11872739
    {Coordinate{23.0367, 62.1744}, CountryId{"FI"}}, // Kuivasjärvi railway station
    {Coordinate{12.8904, 49.0781}, CountryId{"DE"}}, // Viechtach
    {Coordinate{13.0525, 48.9699}, CountryId{"DE"}}, // Triefenried
    {Coordinate{13.423, 48.6143}, CountryId{"DE"}}, // Tiefenbach (b Passau)
    {Coordinate{12.9937, 49.0398}, CountryId{"DE"}}, // Teisnach
    {Coordinate{9.14662, 49.9177}, CountryId{"DE"}}, // Sulzbach (Main)
    {Coordinate{10.2715, 50.4599}, CountryId{"DE"}}, // Stockheim (Unterfr)
    {Coordinate{27.5171, 62.7719}, CountryId{"FI"}}, // Kurkimäki railway station
    {Coordinate{12.9446, 49.0645}, CountryId{"DE"}}, // Gstadt
    {Coordinate{26.9066, 60.539}, CountryId{"FI"}}, // Kymi railway station
    {Coordinate{26.8976, 60.5076}, CountryId{"FI"}}, // Kyminlinna railway station
    {Coordinate{25.11, 60.4244}, CountryId{"FI"}}, // Kytömaa railway station
    {Coordinate{}, CountryId{"FI"}}, // Q11874094
    {Coordinate{28.0711, 64.1186}, CountryId{"FI"}}, // Q11874402
    {Coordinate{22.0032, 62.9902}, CountryId{"FI"}}, // Q11874419
    {Coordinate{27.7103, 64.2314}, CountryId{"FI"}}, // Q11874538
    {Coordinate{26.1267, 60.5992}, CountryId{"FI"}}, // Q11874637
    {Coordinate{12.9914, 48.9897}, CountryId{"DE"}}, // Ruhmannsfelden
    {Coordinate{25.1739, 60.8489}, CountryId{"FI"}}, // Lappila railway station
    {Coordinate{24.5356, 65.7961}, CountryId{"FI"}}, // Laurila railway station
    {Coordinate{25.0391, 60.3227}, CountryId{"FI"}}, // Leinelä railway station
    {Coordinate{24.969, 60.316}, CountryId{"FI"}}, // Helsinki Airport railway station
    {Coordinate{26.2472, 60.4194}, CountryId{"FI"}}, // Loviisa Port railyard
    {Coordinate{14.3474, 50.0959}, CountryId{"CZ"}}, // Nádraží Veleslavín
    {Coordinate{9.33003, 49.771}, CountryId{"DE"}}, // Collenberg
    {Coordinate{29.3219, 61.8003}, CountryId{"FI"}}, // Lusto railway station
    {Coordinate{12.1656, 49.9695}, CountryId{"DE"}}, // Pechbrunn
    {Coordinate{12.9934, 49.0131}, CountryId{"DE"}}, // Patersdorf
    {Coordinate{10.2348, 50.4558}, CountryId{"DE"}}, // Ostheim v d Rhön
    {Coordinate{28.5, 63.8817}, CountryId{"FI"}}, // Maanselkä railway station
    {Coordinate{23.3375, 63.8414}, CountryId{"FI"}}, // Q11881499
    {Coordinate{27.655, 64.4133}, CountryId{"FI"}}, // Melalahti railway station
    {Coordinate{9.15429, 49.8406}, CountryId{"DE"}}, // Obernburg-Elsenfeld
    {Coordinate{23.885, 61.2333}, CountryId{"FI"}}, // Q11882289
    {Coordinate{13.3944, 48.5668}, CountryId{"DE"}}, // Neustift (b Passau)
    {Coordinate{25.08, 60.8231}, CountryId{"FI"}}, // Mommila railway station
    {Coordinate{20.8806, 66.4844}, CountryId{"SE"}}, // Murjek
    {Coordinate{}, CountryId{"FI"}}, // Svartå järnvägsstation
    {Coordinate{25.2711, 65.5367}, CountryId{"FI"}}, // Myllykangas railway station
    {Coordinate{26.7883, 60.77}, CountryId{"FI"}}, // Myllykoski railway station
    {Coordinate{24.2789, 62.525}, CountryId{"FI"}}, // Myllymäki railway station
    {Coordinate{25.9897, 61.1636}, CountryId{"FI"}}, // Q11883670
    {Coordinate{21.9642, 60.6507}, CountryId{"FI"}}, // Q11883684
    {Coordinate{26.8814, 61.4214}, CountryId{"FI"}}, // Mäntyharju railway station
    {Coordinate{22.4817, 61.8447}, CountryId{"FI"}}, // Niinisalo railway station
    {Coordinate{25.2661, 60.3825}, CountryId{"FI"}}, // Nikkilä railway station
    {Coordinate{}, CountryId{"FI"}}, // Q11884566
    {Coordinate{12.9648, 49.0707}, CountryId{"DE"}}, // Nußberg-Schönau
    {Coordinate{24.3172, 60.3292}, CountryId{"FI"}}, // Nummela railway station
    {Coordinate{25.7486, 60.8156}, CountryId{"FI"}}, // Q11885783
    {Coordinate{}, CountryId{"FI"}}, // Q11885792
    {Coordinate{24.3706, 61.6744}, CountryId{"FI"}}, // Orivesi center railway stop
    {Coordinate{27.0897, 64.1139}, CountryId{"FI"}}, // Otanmäki rail yard
    {Coordinate{9.1792, 49.7423}, CountryId{"DE"}}, // Laudenbach am Main
    {Coordinate{26.9189, 60.475}, CountryId{"FI"}}, // Q11886387
    {Coordinate{22.6864, 60.4592}, CountryId{"FI"}}, // Paimio railway station
    {Coordinate{9.16812, 49.8747}, CountryId{"DE"}}, // Kleinwallstadt
    {Coordinate{27.8222, 64.4008}, CountryId{"FI"}}, // Paltamo railway station
    {Coordinate{29.5022, 61.5586}, CountryId{"FI"}}, // Parikkala railway station
    {Coordinate{9.17663, 49.7811}, CountryId{"DE"}}, // Klingenberg (Main)
    {Coordinate{9.20748, 49.7214}, CountryId{"DE"}}, // Kleinheubach
    {Coordinate{12.9432, 49.2054}, CountryId{"DE"}}, // Hohenwarth (Niederbay)
    {Coordinate{12.9255, 49.2049}, CountryId{"DE"}}, // Hohenwarth (Niederbay) Campingplatz
    {Coordinate{76.2397, 15.3453}, CountryId{"IN"}}, // Ginigera Junction railway station
    {Coordinate{76.5436, 15.442}, CountryId{"IN"}}, // Gangavathi railway station
    {Coordinate{11.9485, 49.542}, CountryId{"DE"}}, // Hirschau
    {Coordinate{9.48236, 49.7894}, CountryId{"DE"}}, // Hasloch (Main)
    {Coordinate{23.5522, 60.0981}, CountryId{"FI"}}, // Pohjankuru railway station
    {Coordinate{22.9411, 62.6483}, CountryId{"FI"}}, // Q11888470
    {Coordinate{29.9742, 62.0878}, CountryId{"FI"}}, // Puhos railway station
    {Coordinate{12.9831, 48.9578}, CountryId{"DE"}}, // Gotteszell
    {Coordinate{9.15232, 49.8284}, CountryId{"DE"}}, // Glanzstoffwerke
    {Coordinate{23.5367, 55.8056}, CountryId{"LT"}}, // Radviliškis train station
    {Coordinate{22.129, 60.4858}, CountryId{"FI"}}, // Raisio railway station
    {Coordinate{24.7617, 60.5322}, CountryId{"FI"}}, // Rajamäki railway station
    {Coordinate{16.4794, 50.8599}, CountryId{"PL"}}, // Q118902228
    {Coordinate{29.2944, 61.8031}, CountryId{"FI"}}, // Q11890618
    {Coordinate{22.9967, 62.9033}, CountryId{"FI"}}, // Ruha railway station
    {Coordinate{26.8861, 63.6019}, CountryId{"FI"}}, // Q11891384
    {Coordinate{25.0983, 64.6608}, CountryId{"FI"}}, // Ruukki railway station
    {Coordinate{24.7575, 60.8175}, CountryId{"FI"}}, // Ryttylä railway station
    {Coordinate{27.345, 56.5197}, CountryId{"LV"}}, // Rezekne II
    {Coordinate{29.6619, 61.6958}, CountryId{"FI"}}, // Q11891820
    {Coordinate{24.2822, 63.9794}, CountryId{"FI"}}, // Sievi railway station
    {Coordinate{27.4061, 62.2897}, CountryId{"FI"}}, // Q11893387
    {Coordinate{27.6661, 63.0753}, CountryId{"FI"}}, // Siilinjärvi railway station
    {Coordinate{23.3115, 59.9262}, CountryId{"FI"}}, // Skogby Stop
    {Coordinate{25.5403, 60.3003}, CountryId{"FI"}}, // Sköldvik railway station
    {Coordinate{27.21, 63.6317}, CountryId{"FI"}}, // Soinlahti railway station
    {Coordinate{27.4222, 63.8647}, CountryId{"FI"}}, // Sukeva railway station
    {Coordinate{28.3672, 62.3561}, CountryId{"FI"}}, // Q11895634
    {Coordinate{29.0606, 62.717}, CountryId{"FI"}}, // Sysmäjärvi railway station
    {Coordinate{27.998, 63.9777}, CountryId{"FI"}}, // Talvivaara rail yard
    {Coordinate{21.7419, 62.475}, CountryId{"FI"}}, // Q11897075
    {Coordinate{30.3558, 62.2433}, CountryId{"FI"}}, // Tohmajärvi railway station
    {Coordinate{18.054, 47.1121}, CountryId{"HU"}}, // Q118978441
    {Coordinate{27.7251, 62.997}, CountryId{"FI"}}, // Q11897875
    {Coordinate{24.6383, 60.9183}, CountryId{"FI"}}, // Turenki railway station
    {Coordinate{26.465, 55.7}, CountryId{"LT"}}, // Turmantas train station
    {Coordinate{24.6305, 65.8959}, CountryId{"FI"}}, // Törmä railway station
    {Coordinate{30.2417, 62.9122}, CountryId{"FI"}}, // Uimaharju railway station
    {Coordinate{26.9326, 60.8775}, CountryId{"FI"}}, // Q11899737
    {Coordinate{21.4272, 60.7972}, CountryId{"FI"}}, // Uusikaupunki railway station
    {Coordinate{26.0156, 60.9278}, CountryId{"FI"}}, // Uusikylä railway station
    {Coordinate{26.8425, 64.5581}, CountryId{"FI"}}, // Vaala railway station
    {Coordinate{25.8744, 66.5189}, CountryId{"FI"}}, // Vaarala rail yard
    {Coordinate{28.3053, 60.8642}, CountryId{"FI"}}, // Vainikkala railway station
    {Coordinate{24.0167, 61.2742}, CountryId{"FI"}}, // Valkeakoski railway station
    {Coordinate{30.1639, 62.305}, CountryId{"FI"}}, // Q11900131
    {Coordinate{22.8875, 61.3492}, CountryId{"FI"}}, // Vammala Railway Station
    {Coordinate{29.9486, 64.5397}, CountryId{"FI"}}, // Vartius railway station
    {Coordinate{29.6117, 63.4215}, CountryId{"FI"}}, // Q11901166
    {Coordinate{23.77, 61.2125}, CountryId{"FI"}}, // Viiala railway station
    {Coordinate{25.8248, 60.9466}, CountryId{"FI"}}, // Villähde railway station
    {Coordinate{24.5072, 62.0258}, CountryId{"FI"}}, // Vilppula railway station
    {Coordinate{22.8236, 63.2864}, CountryId{"FI"}}, // Q11901889
    {Coordinate{28.2733, 64.1475}, CountryId{"FI"}}, // Vuokatti Railway Station
    {Coordinate{30.6443, 62.1671}, CountryId{"RU"}}, // Vyartsilya (railway station)
    {Coordinate{22.9594, 62.4}, CountryId{"FI"}}, // Q11902887
    {Coordinate{29.5653, 62.6206}, CountryId{"FI"}}, // Ylämylly railway station
    {Coordinate{29.4689, 64.4794}, CountryId{"FI"}}, // Ypykkävaara railway station
    {Coordinate{24.0636, 62.5536}, CountryId{"FI"}}, // Ähtäri railway station
    {Coordinate{28.8906, 64.8867}, CountryId{"FI"}}, // Ämmänsaari railway station
    {Coordinate{23.4443, 54.3612}, CountryId{"LT"}}, // Šeštokai train station
    {Coordinate{53.9513, 56.9545}, CountryId{"RU"}}, // Kvarsa station
    {Coordinate{-0.022222, 51.4744}, CountryId{"GB"}}, // Deptford Bridge
    {Coordinate{20.668, 48.2424}, CountryId{"HU"}}, // Q119302673
    {Coordinate{14.3811, 49.9386}, CountryId{"CZ"}}, // Vrané nad Vltavou
    {Coordinate{13.3594, 48.9177}, CountryId{"DE"}}, // Spiegelau
    {Coordinate{12.5314, 64.2828}, CountryId{"NO"}}, // Agle Station
    {Coordinate{12.9149, 49.0694}, CountryId{"DE"}}, // Schnitzmühle
    {Coordinate{14.5572, 56.8989}, CountryId{"SE"}}, // Alvesta railway station
    {Coordinate{12.5911, 59.6535}, CountryId{"SE"}}, // Arvika Station
    {Coordinate{11.4829, 59.059}, CountryId{"NO"}}, // Aspedammen Station
    {Coordinate{10.3881, 59.3183}, CountryId{"NO"}}, // Barkåker Station
    {Coordinate{9.24833, 60.4761}, CountryId{"NO"}}, // Bergheim Station
    {Coordinate{16.3918, 61.3499}, CountryId{"SE"}}, // Bollnäs railway station
    {Coordinate{9.00833, 62.1036}, CountryId{"NO"}}, // Bottheim Station
    {Coordinate{9.20111, 60.4908}, CountryId{"NO"}}, // Bromma Station
    {Coordinate{10.5589, 61.0078}, CountryId{"NO"}}, // Brøttum Station
    {Coordinate{11.5147, 59.0214}, CountryId{"NO"}}, // Buer Station
    {Coordinate{9.88611, 59.8069}, CountryId{"NO"}}, // Burud Station
    {Coordinate{9.32977, 59.3864}, CountryId{"NO"}}, // Dalsvatn Station
    {Coordinate{14.44, 59.2292}, CountryId{"SE"}}, // Degerfors station
    {Coordinate{12.9181, 63.3898}, CountryId{"SE"}}, // Duved
    {Coordinate{13.2428, 65.7008}, CountryId{"NO"}}, // Eiterstraum Station
    {Coordinate{11.2711, 60.5817}, CountryId{"NO"}}, // Espa station
    {Coordinate{9.76972, 60.815}, CountryId{"NO"}}, // Etna Station
    {Coordinate{8.23278, 58.5225}, CountryId{"NO"}}, // Fidjetun Station
    {Coordinate{17.945, 59.2169}, CountryId{"SE"}}, // Flemingsberg railway station
    {Coordinate{16.5855, 59.0569}, CountryId{"SE"}}, // Flen station
    {Coordinate{12.0208, 60.5984}, CountryId{"NO"}}, // Flisa Station
    {Coordinate{9.2766, 62.1188}, CountryId{"NO"}}, // Fokstua Station
    {Coordinate{12.5404, 55.6737}, CountryId{"DK"}}, // Frederiksberg Allé Station
    {Coordinate{12.5791, 55.6776}, CountryId{"DK"}}, // Gammel Strand Station
    {Coordinate{5.47031, 60.4468}, CountryId{"NO"}}, // Garnes Station
    {Coordinate{12.3919, 64.5339}, CountryId{"NO"}}, // Gartland Station
    {Coordinate{11.2982, 59.3799}, CountryId{"NO"}}, // Gautestad Station
    {Coordinate{17.3108, 59.0486}, CountryId{"SE"}}, // Gnesta station
    {Coordinate{11.037, 59.2649}, CountryId{"NO"}}, // Greåker Station
    {Coordinate{10.4894, 60.2961}, CountryId{"NO"}}, // Grindvoll Station
    {Coordinate{9.60694, 60.3828}, CountryId{"NO"}}, // Gulsvik Station
    {Coordinate{39.4801, 54.7443}, CountryId{"RU"}}, // Q119736640
    {Coordinate{12.8646, 56.6691}, CountryId{"SE"}}, // Halmstad Central Station
    {Coordinate{8.5225, 58.6286}, CountryId{"NO"}}, // Helldalsmo Station
    {Coordinate{10.2256, 60.2186}, CountryId{"NO"}}, // Hen Station
    {Coordinate{6.36333, 58.4736}, CountryId{"NO"}}, // Heskestad station
    {Coordinate{8.36694, 60.5761}, CountryId{"NO"}}, // Hol Station
    {Coordinate{10.3497, 60.7072}, CountryId{"NO"}}, // Hov Station
    {Coordinate{9.9675, 61.5475}, CountryId{"NO"}}, // Hundorp Station
    {Coordinate{11.2389, 59.1589}, CountryId{"NO"}}, // Ingedal Station
    {Coordinate{11.2196, 59.3002}, CountryId{"NO"}}, // Ise Station
    {Coordinate{10.985, 60.8289}, CountryId{"NO"}}, // Jessnes Station
    {Coordinate{10.4042, 60.2403}, CountryId{"NO"}}, // Jevnaker Station
    {Coordinate{13.4721, 63.3424}, CountryId{"SE"}}, // Järpen
    {Coordinate{20.0304, 65.0544}, CountryId{"SE"}}, // Jörn station
    {Coordinate{16.2077, 58.9966}, CountryId{"SE"}}, // Katrineholm central station
    {Coordinate{18.1612, 68.4198}, CountryId{"SE"}}, // Katterjåkk
    {Coordinate{9.83916, 60.0869}, CountryId{"NO"}}, // Kløftefoss Station
    {Coordinate{9.76694, 59.6694}, CountryId{"NO"}}, // Krekling Station
    {Coordinate{14.4481, 63.3259}, CountryId{"SE"}}, // Krokom
    {Coordinate{9.78087, 60.1268}, CountryId{"NO"}}, // Krøderen Station
    {Coordinate{10.9017, 63.5475}, CountryId{"NO"}}, // Langstein Station
    {Coordinate{10.151, 59.0615}, CountryId{"NO"}}, // Lauve Station
    {Coordinate{10.2411, 59.787}, CountryId{"NO"}}, // Lier Station
    {Coordinate{13.3704, 48.5177}, CountryId{"DE"}}, // Neukirchen (Inn)
    {Coordinate{12.503, 48.3614}, CountryId{"DE"}}, // Neumarkt-Sankt Veit
    {Coordinate{18.3263, 68.4235}, CountryId{"SE"}}, // Låktatjåkka
    {Coordinate{12.2019, 59.9514}, CountryId{"NO"}}, // Magnor stasjon
    {Coordinate{12.589, 55.6851}, CountryId{"DK"}}, // Marmorkirken Station
    {Coordinate{7.83368, 62.4476}, CountryId{"NO"}}, // Marstein Station
    {Coordinate{12.1248, 60.0273}, CountryId{"NO"}}, // Matrand Station
    {Coordinate{10.2728, 63.2894}, CountryId{"NO"}}, // Melhus Station
    {Coordinate{10.7303, 63.4319}, CountryId{"NO"}}, // Midtsandan Station
    {Coordinate{11.2308, 60.3953}, CountryId{"NO"}}, // Minnesund Station
    {Coordinate{7.92389, 58.2156}, CountryId{"NO"}}, // Mosby Station
    {Coordinate{12.5426, 55.6886}, CountryId{"DK"}}, // Nuuks Plads station
    {Coordinate{10.3828, 59.4248}, CountryId{"NO"}}, // Nykirke Station
    {Coordinate{10.3369, 63.3167}, CountryId{"NO"}}, // Nypan Station
    {Coordinate{14.6943, 57.6521}, CountryId{"SE"}}, // Nässjö station
    {Coordinate{12.5488, 55.6936}, CountryId{"DK"}}, // Nørrebros Runddel Station
    {Coordinate{8.11139, 58.4442}, CountryId{"NO"}}, // Oggevatn Station
    {Coordinate{11.14, 60.7469}, CountryId{"NO"}}, // Ottestad Station
    {Coordinate{6.4675, 60.6347}, CountryId{"NO"}}, // Palmafoss Station
    {Coordinate{12.5763, 55.7094}, CountryId{"DK"}}, // Poul Henningsens Plads station
    {Coordinate{9.80333, 60.2689}, CountryId{"NO"}}, // Rallerud Station
    {Coordinate{10.8653, 62.9622}, CountryId{"NO"}}, // Reitstøa Station
    {Coordinate{7.76079, 62.4843}, CountryId{"NO"}}, // Romsdalshorn Station
    {Coordinate{11.3275, 62.7283}, CountryId{"NO"}}, // Rugldalen Station
    {Coordinate{12.5681, 55.6764}, CountryId{"DK"}}, // Rådhuspladsen Station
    {Coordinate{12.8655, 49.1753}, CountryId{"DE"}}, // Zellertal
    {Coordinate{9.60528, 59.6331}, CountryId{"NO"}}, // Saggrenda Station
    {Coordinate{9.41618, 61.8388}, CountryId{"NO"}}, // Sel Station
    {Coordinate{8.60083, 58.7083}, CountryId{"NO"}}, // Simonstad Station
    {Coordinate{12.5492, 55.7037}, CountryId{"DK"}}, // Skjolds Plads station
    {Coordinate{10.3986, 60.6411}, CountryId{"NO"}}, // Skrukli Station
    {Coordinate{9.92694, 60.2408}, CountryId{"NO"}}, // Sokna Station
    {Coordinate{10.1778, 62.955}, CountryId{"NO"}}, // Soknedal Station
    {Coordinate{11.2236, 60.6583}, CountryId{"NO"}}, // Steinsrud Station
    {Coordinate{11.2308, 62.8558}, CountryId{"NO"}}, // Stensli Station
    {Coordinate{11.7329, 64.1205}, CountryId{"NO"}}, // Stod Station
    {Coordinate{11.2408, 60.5203}, CountryId{"NO"}}, // Strandlykkja Station
    {Coordinate{11.6308, 64.0792}, CountryId{"NO"}}, // Sunnan Station
    {Coordinate{9.9165, 59.9942}, CountryId{"NO"}}, // Sysle Station
    {Coordinate{10.8964, 62.3419}, CountryId{"NO"}}, // Telneset Station
    {Coordinate{9.21324, 49.669}, CountryId{"DE"}}, // Weilbach (Unterfr)
    {Coordinate{9.62056, 60.8442}, CountryId{"NO"}}, // Tonsåsen Station
    {Coordinate{8.71611, 60.66}, CountryId{"NO"}}, // Torpo Station
    {Coordinate{12.5756, 55.6992}, CountryId{"DK"}}, // Trianglen station
    {Coordinate{14.7467, 67.3019}, CountryId{"NO"}}, // Tverlandet Station
    {Coordinate{6.34306, 58.5286}, CountryId{"NO"}}, // Ualand Station
    {Coordinate{9.98472, 62.7492}, CountryId{"NO"}}, // Ulsberg Station
    {Coordinate{13.2411, 63.3144}, CountryId{"SE"}}, // Undersåker
    {Coordinate{9.96866, 57.4804}, CountryId{"DK"}}, // Vellingshøj station
    {Coordinate{8.05843, 62.3471}, CountryId{"NO"}}, // Verma Station
    {Coordinate{19.7129, 64.203}, CountryId{"SE"}}, // Vindeln
    {Coordinate{8.56213, 60.6262}, CountryId{"NO"}}, // Ål Station
    {Coordinate{9.91333, 59.8914}, CountryId{"NO"}}, // Åmot Station
    {Coordinate{12.5391, 63.3213}, CountryId{"SE"}}, // Ånn
    {Coordinate{11.3517, 61.0783}, CountryId{"NO"}}, // Åsta Station
    {Coordinate{14.6312, 63.178}, CountryId{"SE"}}, // Östersund western station
    {Coordinate{10.8919, 59.3051}, CountryId{"NO"}}, // Ørmen Station
    {Coordinate{6.2317, 51.008}, CountryId{"DE"}}, // Brachelen railway station
    {Coordinate{7.0752, 51.4503}, CountryId{"DE"}}, // Essen-Steele station
    {Coordinate{6.85219, 51.052}, CountryId{"DE"}}, // Köln-Worringen station
    {Coordinate{-88.2412, 40.1159}, CountryId{"US"}}, // Illinois Terminal
    {Coordinate{15.0734, 50.9188}, CountryId{"CZ"}}, // Frýdlant v Čechách
    {Coordinate{15.0765, 50.9268}, CountryId{"CZ"}}, // Frýdlant v Čechách předměstí
    {Coordinate{15.1973, 50.9288}, CountryId{"CZ"}}, // Hajniště
    {Coordinate{15.5877, 49.5987}, CountryId{"CZ"}}, // Havlíčkův Brod
    {Coordinate{17.6201, 49.0326}, CountryId{"CZ"}}, // Havřice
    {Coordinate{15.185, 50.8795}, CountryId{"CZ"}}, // Hejnice
    {Coordinate{14.5229, 50.6824}, CountryId{"CZ"}}, // Česká Lípa-Holý vrch railway station
    {Coordinate{15.1978, 50.952}, CountryId{"CZ"}}, // Horní Řasnice
    {Coordinate{18.0166, 49.521}, CountryId{"CZ"}}, // Hostašovice
    {Coordinate{13.8931, 49.1873}, CountryId{"CZ"}}, // Hoštice u Volyně
    {Coordinate{15.8654, 49.0942}, CountryId{"CZ"}}, // Jaroměřice nad Rokytnou
    {Coordinate{12.8669, 50.2353}, CountryId{"CZ"}}, // Karlovy Vary
    {Coordinate{12.8642, 50.2297}, CountryId{"CZ"}}, // Karlovy Vary dolní nádraží
    {Coordinate{15.1286, 50.9378}, CountryId{"CZ"}}, // Krásný Les
    {Coordinate{15.1092, 50.9308}, CountryId{"CZ"}}, // Krásný Les bažantnice
    {Coordinate{15.1519, 50.8917}, CountryId{"CZ"}}, // Luh pod Smrkem (train station)
    {Coordinate{15.1649, 50.8864}, CountryId{"CZ"}}, // Lužec pod Smrkem (train station)
    {Coordinate{13.3139, 48.4063}, CountryId{"DE"}}, // Pocking
    {Coordinate{15.0292, 50.9508}, CountryId{"CZ"}}, // Minkovice
    {Coordinate{18.0442, 49.5383}, CountryId{"CZ"}}, // Mořkov
    {Coordinate{18.0684, 49.5288}, CountryId{"CZ"}}, // Mořkov hlavní trať
    {Coordinate{15.0328, 50.7533}, CountryId{"CZ"}}, // Liberec-Horní Růžodol
    {Coordinate{14.4047, 49.9976}, CountryId{"CZ"}}, // Praha-Modřany
    {Coordinate{14.6767, 49.4139}, CountryId{"CZ"}}, // Tábor (train station)
    {Coordinate{15.9395, 49.5542}, CountryId{"CZ"}}, // Žďár nad Sázavou
    {Coordinate{14.4761, 50.0853}, CountryId{"CZ"}}, // Nákladové nádraží Žižkov
    {Coordinate{14.4733, 50.0511}, CountryId{"CZ"}}, // Praha jih
    {Coordinate{13.3961, 49.8039}, CountryId{"CZ"}}, // Q12045677
    {Coordinate{14.4374, 50.1062}, CountryId{"CZ"}}, // Praha-Holešovice railway stop
    {Coordinate{14.5653, 50.0481}, CountryId{"CZ"}}, // Praha-Horní Měcholupy
    {Coordinate{14.4614, 50.0417}, CountryId{"CZ"}}, // Praha-Kačerov
    {Coordinate{14.403, 50.0039}, CountryId{"CZ"}}, // Praha-Modřany zastávka
    {Coordinate{14.4053, 50.0678}, CountryId{"CZ"}}, // Praha-Smíchov Na Knížecí
    {Coordinate{14.4071, 50.0617}, CountryId{"CZ"}}, // Praha-Smíchov severní nástupiště
    {Coordinate{15.1306, 50.8964}, CountryId{"CZ"}}, // Raspenava
    {Coordinate{16.6275, 49.4086}, CountryId{"CZ"}}, // Rájec-Jestřebí
    {Coordinate{15.1578, 49.0661}, CountryId{"CZ"}}, // Senotín
    {Coordinate{8.44944, 52.2044}, CountryId{"DE"}}, // Bruchmühlen station
    {Coordinate{15.2283, 50.9592}, CountryId{"CZ"}}, // Srbská
    {Coordinate{6.94911, 51.4728}, CountryId{"DE"}}, // Essen-Borbeck station
    {Coordinate{13.8292, 50.6464}, CountryId{"CZ"}}, // Teplice v Čechách
    {Coordinate{15.8529, 49.2089}, CountryId{"CZ"}}, // Třebíč-Borovina
    {Coordinate{15.8844, 49.2115}, CountryId{"CZ"}}, // Třebíč train station
    {Coordinate{22.7347, 38.014}, CountryId{"GR"}}, // Kiato railway station
    {Coordinate{-0.458625, 51.9052}, CountryId{"GB"}}, // Leagrave railway station
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12061636
    {Coordinate{34.5294, 47.6237}, CountryId{"UA"}}, // Q12061666
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12061675
    {Coordinate{34.2442, 48.4961}, CountryId{"UA"}}, // Q12061689
    {Coordinate{33.7319, 46.8081}, CountryId{"UA"}}, // Q12061704
    {Coordinate{32.4676, 50.1162}, CountryId{"UA"}}, // 136 km
    {Coordinate{36.3958, 49.8481}, CountryId{"UA"}}, // Q12061729
    {Coordinate{36.2989, 49.9809}, CountryId{"UA"}}, // 13 km
    {Coordinate{32.5957, 50.0967}, CountryId{"UA"}}, // 143 km
    {Coordinate{34.7261, 48.4658}, CountryId{"UA"}}, // Q12061768
    {Coordinate{34.7378, 48.4586}, CountryId{"UA"}}, // Q12061769
    {Coordinate{34.7761, 48.4411}, CountryId{"UA"}}, // Q12061778
    {Coordinate{34.8508, 48.4433}, CountryId{"UA"}}, // Q12061784
    {Coordinate{34.8794, 48.4597}, CountryId{"UA"}}, // Q12061786
    {Coordinate{36.3494, 49.9614}, CountryId{"UA"}}, // Q12061803
    {Coordinate{35.005, 48.3553}, CountryId{"UA"}}, // Q12061894
    {Coordinate{34.8628, 48.3033}, CountryId{"UA"}}, // 233 km
    {Coordinate{34.6967, 48.2097}, CountryId{"UA"}}, // Q12061923
    {Coordinate{36.2694, 49.8772}, CountryId{"UA"}}, // Q12062006
    {Coordinate{27.1001, 50.1971}, CountryId{"UA"}}, // 4 km
    {Coordinate{36.2822, 49.8689}, CountryId{"UA"}}, // Q12062096
    {Coordinate{29.1722, 50.1317}, CountryId{"UA"}}, // 62 km
    {Coordinate{33.642, 48.0442}, CountryId{"UA"}}, // Q12062161
    {Coordinate{33.7751, 48.4236}, CountryId{"UA"}}, // 79 km
    {Coordinate{35.232, 49.8772}, CountryId{"UA"}}, // 80 km
    {Coordinate{28.9006, 50.1681}, CountryId{"UA"}}, // 82 km
    {Coordinate{12.5033, 52.5994}, CountryId{"DE"}}, // Nennhausen railway station
    {Coordinate{-1.825, 50.731}, CountryId{"GB"}}, // Pokesdown railway station
    {Coordinate{7.07925, 50.8581}, CountryId{"DE"}}, // Porz-Wahn station
    {Coordinate{-1.3765, 50.9411}, CountryId{"GB"}}, // Swaythling railway station
    {Coordinate{8.27944, 52.2364}, CountryId{"DE"}}, // Westerhausen station
    {Coordinate{24.3669, 50.635}, CountryId{"UA"}}, // Q12073651
    {Coordinate{26.9289, 49.4894}, CountryId{"UA"}}, // Q12073663
    {Coordinate{28.6704, 49.8599}, CountryId{"UA"}}, // Ivankivtsi
    {Coordinate{32.7239, 50.0827}, CountryId{"UA"}}, // Ivanivka
    {Coordinate{26.3613, 50.4616}, CountryId{"UA"}}, // Ivachkove
    {Coordinate{29.0392, 50.1369}, CountryId{"UA"}}, // Ivnytsia
    {Coordinate{35.1897, 48.4706}, CountryId{"UA"}}, // Q12073915
    {Coordinate{28.8125, 45.36}, CountryId{"UA"}}, // Izmail
    {Coordinate{37.3011, 49.216}, CountryId{"UA"}}, // Izium railway station
    {Coordinate{26.8322, 50.1073}, CountryId{"UA"}}, // Iziaslav
    {Coordinate{35.2803, 48.4014}, CountryId{"UA"}}, // Ilarionove
    {Coordinate{35.1283, 47.8531}, CountryId{"UA"}}, // Imeni Anatoliya Alimova
    {Coordinate{31.6649, 51.367}, CountryId{"UA"}}, // Borys Oliinyk Station
    {Coordinate{38.4719, 48.3947}, CountryId{"UA"}}, // Q12074337
    {Coordinate{37.6823, 49.4734}, CountryId{"UA"}}, // Q12074338
    {Coordinate{27.06, 50.1328}, CountryId{"UA"}}, // Imeni Piaskorskoho
    {Coordinate{31.8944, 49.2033}, CountryId{"UA"}}, // Taras Shevchenko station
    {Coordinate{33.1419, 47.6786}, CountryId{"UA"}}, // Inhulets
    {Coordinate{29.4517, 50.7211}, CountryId{"UA"}}, // Irsha
    {Coordinate{32.4082, 50.8422}, CountryId{"UA"}}, // Ichnia
    {Coordinate{29.2622, 47.9792}, CountryId{"UA"}}, // Abamelykove
    {Coordinate{1.34594, 48.7033}, CountryId{"FR"}}, // Q120756792
    {Coordinate{1.64769, 48.2238}, CountryId{"FR"}}, // Q120756806
    {Coordinate{1.58254, 48.4894}, CountryId{"FR"}}, // Q120756842
    {Coordinate{1.31522, 48.6752}, CountryId{"FR"}}, // Q120756847
    {Coordinate{1.87462, 48.2063}, CountryId{"FR"}}, // Q120756849
    {Coordinate{1.67921, 48.1457}, CountryId{"FR"}}, // railway station Orgères
    {Coordinate{1.47939, 48.0659}, CountryId{"FR"}}, // Q120756852
    {Coordinate{6.12909, 49.4555}, CountryId{"FR"}}, // Q120756855
    {Coordinate{7.4761, 49.0489}, CountryId{"FR"}}, // Q120756856
    {Coordinate{6.11376, 49.3304}, CountryId{"FR"}}, // Q120756860
    {Coordinate{6.85514, 49.1523}, CountryId{"FR"}}, // Q120756895
    {Coordinate{1.41841, 46.8849}, CountryId{"FR"}}, // Q120756899
    {Coordinate{1.23872, 46.9452}, CountryId{"FR"}}, // Q120756900
    {Coordinate{1.10883, 47.0214}, CountryId{"FR"}}, // railway station Fléré-la-Rivière
    {Coordinate{1.19331, 47.7509}, CountryId{"FR"}}, // railway station Selommes
    {Coordinate{1.2927, 47.638}, CountryId{"FR"}}, // railway station Fossé-Marolles
    {Coordinate{0.892339, 47.9843}, CountryId{"FR"}}, // railway station Mondoubleau
    {Coordinate{0.335219, 44.1314}, CountryId{"FR"}}, // railway station Nérac
    {Coordinate{0.558789, 44.2278}, CountryId{"FR"}}, // railway station Colayrac
    {Coordinate{0.367189, 44.0656}, CountryId{"FR"}}, // railway station Lasserre
    {Coordinate{5.68758, 48.4013}, CountryId{"FR"}}, // railway station Coussey
    {Coordinate{5.8389, 48.3016}, CountryId{"FR"}}, // railway station Châtenois - Dolaincourt
    {Coordinate{5.92148, 48.3105}, CountryId{"FR"}}, // railway station Gironcourt - Houécourt
    {Coordinate{4.83301, 43.9377}, CountryId{"FR"}}, // railway station Avignon-Fontcouverte
    {Coordinate{5.04666, 43.8254}, CountryId{"FR"}}, // Q120757148
    {Coordinate{2.20334, 43.9429}, CountryId{"FR"}}, // Q120757155
    {Coordinate{5.78897, 49.1636}, CountryId{"FR"}}, // Q120757159
    {Coordinate{5.87385, 49.4598}, CountryId{"FR"}}, // Q120757163
    {Coordinate{3.85547, 48.4991}, CountryId{"FR"}}, // Q120757166
    {Coordinate{4.80213, 48.1583}, CountryId{"FR"}}, // Q120757167
    {Coordinate{4.38435, 48.0731}, CountryId{"FR"}}, // Q120757168
    {Coordinate{4.12868, 48.5327}, CountryId{"FR"}}, // Q120757170
    {Coordinate{4.58606, 48.5083}, CountryId{"FR"}}, // Q120757172
    {Coordinate{4.05828, 48.1953}, CountryId{"FR"}}, // Q120757174
    {Coordinate{4.38186, 48.1172}, CountryId{"FR"}}, // Q120757175
    {Coordinate{3.64021, 48.5152}, CountryId{"FR"}}, // Q120757176
    {Coordinate{3.9256, 48.4386}, CountryId{"FR"}}, // Q120757178
    {Coordinate{4.17883, 48.6749}, CountryId{"FR"}}, // Q120757180
    {Coordinate{4.58327, 48.2846}, CountryId{"FR"}}, // Q120757181
    {Coordinate{4.17376, 48.4032}, CountryId{"FR"}}, // Q120757183
    {Coordinate{4.13262, 48.2317}, CountryId{"FR"}}, // Q120757185
    {Coordinate{3.80241, 48.2743}, CountryId{"FR"}}, // Q120757187
    {Coordinate{4.54502, 48.3477}, CountryId{"FR"}}, // Q120757190
    {Coordinate{0.618406, 43.7579}, CountryId{"FR"}}, // Q120757191
    {Coordinate{0.656386, 43.8524}, CountryId{"FR"}}, // Q120757193
    {Coordinate{-0.619239, 47.8733}, CountryId{"FR"}}, // Q120757195
    {Coordinate{5.90047, 47.8372}, CountryId{"FR"}}, // Q120757196
    {Coordinate{5.70066, 47.5413}, CountryId{"FR"}}, // Q120757199
    {Coordinate{5.48329, 47.475}, CountryId{"FR"}}, // Q120757201
    {Coordinate{5.30842, 49.1355}, CountryId{"FR"}}, // Q120757203
    {Coordinate{5.17081, 49.4938}, CountryId{"FR"}}, // Q120757205
    {Coordinate{5.5067, 48.5091}, CountryId{"FR"}}, // Q120757208
    {Coordinate{5.16413, 49.6768}, CountryId{"FR"}}, // Q120757243
    {Coordinate{3.27143, 45.3824}, CountryId{"FR"}}, // Q120757246
    {Coordinate{-0.315247, 46.9079}, CountryId{"FR"}}, // Q120757247
    {Coordinate{5.33284, 48.2639}, CountryId{"FR"}}, // Q120757250
    {Coordinate{5.28308, 47.9487}, CountryId{"FR"}}, // Q120757252
    {Coordinate{5.29366, 47.6575}, CountryId{"FR"}}, // Q120757254
    {Coordinate{5.3647, 48.2742}, CountryId{"FR"}}, // Q120757257
    {Coordinate{1.30027, 45.8515}, CountryId{"FR"}}, // Q120757259
    {Coordinate{1.37707, 46.1266}, CountryId{"FR"}}, // Q120757260
    {Coordinate{1.89688, 45.6216}, CountryId{"FR"}}, // Viam
    {Coordinate{2.41648, 47.1191}, CountryId{"FR"}}, // Q120757284
    {Coordinate{0.844719, 49.824}, CountryId{"FR"}}, // Q120757366
    {Coordinate{2.4369, 47.4931}, CountryId{"FR"}}, // Q120757373
    {Coordinate{2.36946, 47.7598}, CountryId{"FR"}}, // Q120757374
    {Coordinate{1.69994, 48.0494}, CountryId{"FR"}}, // Q120757375
    {Coordinate{2.0589, 48.0708}, CountryId{"FR"}}, // Q120757376
    {Coordinate{1.77793, 47.9948}, CountryId{"FR"}}, // Q120757377
    {Coordinate{-1.24791, 48.143}, CountryId{"FR"}}, // Q120757378
    {Coordinate{-2.72229, 48.5272}, CountryId{"FR"}}, // Q120757379
    {Coordinate{1.21073, 48.9983}, CountryId{"FR"}}, // Q120757380
    {Coordinate{4.85055, 44.9478}, CountryId{"FR"}}, // Q120757381
    {Coordinate{4.76558, 44.6559}, CountryId{"FR"}}, // Q120757382
    {Coordinate{1.70033, 48.0896}, CountryId{"FR"}}, // Q120757383
    {Coordinate{4.62385, 43.8077}, CountryId{"FR"}}, // Q120757384
    {Coordinate{1.62711, 46.8027}, CountryId{"FR"}}, // Q120757385
    {Coordinate{5.97185, 49.1663}, CountryId{"FR"}}, // Q120757388
    {Coordinate{0.361661, 43.0823}, CountryId{"FR"}}, // Q120757389
    {Coordinate{5.38551, 49.1107}, CountryId{"FR"}}, // Q120757390
    {Coordinate{5.01123, 48.6162}, CountryId{"FR"}}, // Q120757391
    {Coordinate{5.32068, 48.6861}, CountryId{"FR"}}, // Q120757392
    {Coordinate{5.70066, 48.6517}, CountryId{"FR"}}, // Q120757393
    {Coordinate{5.71111, 49.1721}, CountryId{"FR"}}, // Q120757394
    {Coordinate{-1.03998, 49.0513}, CountryId{"FR"}}, // Q120757395
    {Coordinate{-0.0962056, 48.8162}, CountryId{"FR"}}, // Q120757396
    {Coordinate{0.101372, 45.6049}, CountryId{"FR"}}, // Q120757397
    {Coordinate{0.162308, 45.4986}, CountryId{"FR"}}, // Q120757398
    {Coordinate{4.87425, 44.8795}, CountryId{"FR"}}, // Q120757399
    {Coordinate{4.98841, 45.0021}, CountryId{"FR"}}, // Q120757400
    {Coordinate{4.98641, 45.3123}, CountryId{"FR"}}, // Q120757402
    {Coordinate{-0.0885722, 48.9782}, CountryId{"FR"}}, // Q120757403
    {Coordinate{-1.48377, 43.4975}, CountryId{"FR"}}, // Q120757404
    {Coordinate{-0.436133, 43.3242}, CountryId{"FR"}}, // Q120757406
    {Coordinate{-0.627147, 43.4119}, CountryId{"FR"}}, // Q120757408
    {Coordinate{-0.845911, 43.5103}, CountryId{"FR"}}, // Q120757409
    {Coordinate{-0.256344, 43.7072}, CountryId{"FR"}}, // Q120757410
    {Coordinate{-0.325047, 44.0393}, CountryId{"FR"}}, // Q120757411
    {Coordinate{-0.583486, 43.6592}, CountryId{"FR"}}, // Q120757412
    {Coordinate{-0.535264, 43.8327}, CountryId{"FR"}}, // Q120757413
    {Coordinate{1.05542, 49.4272}, CountryId{"FR"}}, // Q120757414
    {Coordinate{1.11382, 49.8949}, CountryId{"FR"}}, // Q120757415
    {Coordinate{0.453481, 49.7479}, CountryId{"FR"}}, // Q120757417
    {Coordinate{-0.424886, 43.7773}, CountryId{"FR"}}, // Q120757419
    {Coordinate{1.01081, 49.6408}, CountryId{"FR"}}, // Q120757422
    {Coordinate{-0.0633806, 47.3313}, CountryId{"FR"}}, // Q120757424
    {Coordinate{-0.617519, 47.5254}, CountryId{"FR"}}, // Q120757425
    {Coordinate{-0.113931, 47.3869}, CountryId{"FR"}}, // Q120757426
    {Coordinate{2.51728, 47.0825}, CountryId{"FR"}}, // Q120757428
    {Coordinate{0.581928, 47.7406}, CountryId{"FR"}}, // Q120757429
    {Coordinate{0.747761, 47.8302}, CountryId{"FR"}}, // Q120757430
    {Coordinate{2.94616, 43.2624}, CountryId{"FR"}}, // Q120757431
    {Coordinate{3.43452, 43.3887}, CountryId{"FR"}}, // Q120757432
    {Coordinate{3.13334, 50.0079}, CountryId{"FR"}}, // Q120757433
    {Coordinate{2.43469, 43.2055}, CountryId{"FR"}}, // Q120757987
    {Coordinate{4.4425, 45.435}, CountryId{"FR"}}, // Q120758034
    {Coordinate{4.62503, 45.5295}, CountryId{"FR"}}, // Q120758050
    {Coordinate{4.42003, 45.4441}, CountryId{"FR"}}, // Q120758072
    {Coordinate{5.8237, 45.9149}, CountryId{"FR"}}, // Q120758081
    {Coordinate{5.97994, 46.231}, CountryId{"FR"}}, // Q120758086
    {Coordinate{5.28513, 45.9365}, CountryId{"FR"}}, // Q120758092
    {Coordinate{5.69533, 45.7312}, CountryId{"FR"}}, // Q120758105
    {Coordinate{3.48577, 49.8387}, CountryId{"FR"}}, // Q120758112
    {Coordinate{4.01638, 49.6979}, CountryId{"FR"}}, // Q120758119
    {Coordinate{3.9403, 49.6622}, CountryId{"FR"}}, // Q120758126
    {Coordinate{3.46729, 49.3703}, CountryId{"FR"}}, // Q120758138
    {Coordinate{3.84193, 49.6375}, CountryId{"FR"}}, // Q120758150
    {Coordinate{3.68061, 49.5777}, CountryId{"FR"}}, // Q120758155
    {Coordinate{3.39666, 49.3675}, CountryId{"FR"}}, // Q120758163
    {Coordinate{3.5398, 49.3331}, CountryId{"FR"}}, // Q120758176
    {Coordinate{3.54234, 48.9266}, CountryId{"FR"}}, // Q120758185
    {Coordinate{2.59196, 46.3617}, CountryId{"FR"}}, // Q120758196
    {Coordinate{2.42021, 46.3683}, CountryId{"FR"}}, // Q120758208
    {Coordinate{3.35444, 46.3902}, CountryId{"FR"}}, // Q120758222
    {Coordinate{4.03924, 49.0276}, CountryId{"FR"}}, // Q120758244
    {Coordinate{-0.579997, 45.0226}, CountryId{"FR"}}, // Q120758258
    {Coordinate{-0.531111, 44.8847}, CountryId{"FR"}}, // Q120758290
    {Coordinate{1.99206, 48.77}, CountryId{"FR"}}, // Q120758301
    {Coordinate{4.69952, 44.0963}, CountryId{"FR"}}, // Q120758311
    {Coordinate{4.80485, 45.564}, CountryId{"FR"}}, // Q120758317
    {Coordinate{4.86469, 45.5274}, CountryId{"FR"}}, // Q120758321
    {Coordinate{4.6865, 43.895}, CountryId{"FR"}}, // Q120758323
    {Coordinate{4.77404, 44.0495}, CountryId{"FR"}}, // Q120758330
    {Coordinate{4.79248, 43.9567}, CountryId{"FR"}}, // Q120758333
    {Coordinate{-1.49167, 47.2769}, CountryId{"FR"}}, // Q120758344
    {Coordinate{7.29868, 47.7502}, CountryId{"FR"}}, // Q120758348
    {Coordinate{7.31732, 47.7435}, CountryId{"FR"}}, // Q120758352
    {Coordinate{2.31617, 48.8375}, CountryId{"FR"}}, // Q120758487
    {Coordinate{2.37096, 48.8952}, CountryId{"FR"}}, // Q120758491
    {Coordinate{5.03107, 47.3084}, CountryId{"FR"}}, // Q120769257
    {Coordinate{3.93064, 50.2751}, CountryId{"FR"}}, // Q120769287
    {Coordinate{3.00686, 50.6406}, CountryId{"FR"}}, // Q120769291
    {Coordinate{2.27692, 51.0324}, CountryId{"FR"}}, // Q120769303
    {Coordinate{1.42797, 43.5695}, CountryId{"FR"}}, // Q120769307
    {Coordinate{-1.22161, 46.1599}, CountryId{"FR"}}, // Q120769315
    {Coordinate{4.80436, 43.3989}, CountryId{"FR"}}, // Q120769320
    {Coordinate{5.3996, 43.2787}, CountryId{"FR"}}, // Q120769323
    {Coordinate{2.41114, 48.9437}, CountryId{"FR"}}, // Q120769327
    {Coordinate{22.808, 56.149}, CountryId{"LT"}}, // Papilė train station
    {Coordinate{30.3796, 50.4673}, CountryId{"UA"}}, // Akademmistechko
    {Coordinate{33.2219, 51.4531}, CountryId{"UA"}}, // Altynivka
    {Coordinate{29.0109, 50.0246}, CountryId{"UA"}}, // Andrushivka
    {Coordinate{26.9831, 49.7928}, CountryId{"UA"}}, // Antoniny Railway Station
    {Coordinate{33.6906, 47.6594}, CountryId{"UA"}}, // Apostolove
    {Coordinate{29.4228, 45.9961}, CountryId{"UA"}}, // Artsyz
    {Coordinate{21.408, 55.519}, CountryId{"LT"}}, // Vilkyčiai train station
    {Coordinate{36.2983, 45.3747}, CountryId{"RU"}}, // Bagerovo
    {Coordinate{34.6467, 48.4819}, CountryId{"UA"}}, // Zaporizhzhia-Kamianske
    {Coordinate{32.4606, 50.1292}, CountryId{"UA"}}, // Baza
    {Coordinate{35.5874, 49.362}, CountryId{"UA"}}, // Q12080652
    {Coordinate{29.625, 47.8744}, CountryId{"UA"}}, // Balta
    {Coordinate{34.8381, 48.5936}, CountryId{"UA"}}, // Balivka
    {Coordinate{35.6193, 49.9261}, CountryId{"UA"}}, // Baranove
    {Coordinate{27.8328, 50.5036}, CountryId{"UA"}}, // Barvynivka
    {Coordinate{31.32, 50.3461}, CountryId{"UA"}}, // Baryshivka
    {Coordinate{28.1231, 50.8233}, CountryId{"UA"}}, // Baskaky
    {Coordinate{33.4844, 47.8728}, CountryId{"UA"}}, // Baturynska
    {Coordinate{32.7987, 51.181}, CountryId{"UA"}}, // Bakhmach-Kyivskyi
    {Coordinate{33.8492, 44.7556}, CountryId{"UA"}}, // Bakhchysarai Railway Station
    {Coordinate{36.2491, 49.8885}, CountryId{"UA"}}, // Bezlyudivka
    {Coordinate{36.1337, 50.1658}, CountryId{"UA"}}, // Bezrukivka Railway Halt
    {Coordinate{31.5019, 50.3282}, CountryId{"UA"}}, // Berezan
    {Coordinate{32.5527, 50.1011}, CountryId{"UA"}}, // Besidivshchyna
    {Coordinate{28.7427, 50.2293}, CountryId{"UA"}}, // Bystra
    {Coordinate{31.0372, 50.6468}, CountryId{"UA"}}, // Bobryk
    {Coordinate{31.3714, 50.7636}, CountryId{"UA"}}, // Bobrovytsia
    {Coordinate{33.3856, 51.8591}, CountryId{"UA"}}, // Q12083236
    {Coordinate{32.0083, 50.1919}, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{27.1394, 49.3739}, CountryId{"UA"}}, // Bohdanivtsi
    {Coordinate{35.4898, 50.1565}, CountryId{"UA"}}, // Bohodukhiv
    {Coordinate{28.5794, 50.3186}, CountryId{"UA"}}, // Bohunskyi
    {Coordinate{34.1228, 48.3553}, CountryId{"UA"}}, // Bozhedarivka
    {Coordinate{30.9456, 50.3767}, CountryId{"UA"}}, // Boryspil
    {Coordinate{29.8942, 50.6287}, CountryId{"UA"}}, // Borodianka
    {Coordinate{30.4091, 50.4261}, CountryId{"UA"}}, // Borshchahivka-Technichna
    {Coordinate{29.4931, 47.8661}, CountryId{"UA"}}, // Borshchi
    {Coordinate{30.2994, 50.3211}, CountryId{"UA"}}, // Boiarka
    {Coordinate{106.07, 51.8489}, CountryId{"RU"}}, // Q12084491
    {Coordinate{39.1458, 48.3989}, CountryId{"UA"}}, // Q12084546
    {Coordinate{33.8531, 46.8314}, CountryId{"UA"}}, // Q12084628
    {Coordinate{36.9325, 49.4259}, CountryId{"UA"}}, // Q12084642
    {Coordinate{33.4859, 51.8032}, CountryId{"UA"}}, // Q12084850
    {Coordinate{25.1561, 50.0697}, CountryId{"UA"}}, // Brody Railway Station
    {Coordinate{33.44, 51.6472}, CountryId{"UA"}}, // Bryulovetskyi
    {Coordinate{23.9369, 49.9042}, CountryId{"UA"}}, // Briukhovychi
    {Coordinate{29.2125, 49.9243}, CountryId{"UA"}}, // Brivky
    {Coordinate{36.4445, 49.6594}, CountryId{"UA"}}, // Q12085277
    {Coordinate{37.3941, 49.1314}, CountryId{"UA"}}, // Q12085501
    {Coordinate{30.2214, 50.5489}, CountryId{"UA"}}, // Bucha train station
    {Coordinate{30.1098, 49.8121}, CountryId{"UA"}}, // Bila Tserkva
    {Coordinate{30.3392, 46.1847}, CountryId{"UA"}}, // Bilhorod-Dnistrovskyi
    {Coordinate{30.3347, 50.4878}, CountryId{"UA"}}, // Bilychi
    {Coordinate{30.0844, 50.1736}, CountryId{"UA"}}, // Bilky Railway Halt
    {Coordinate{28.9903, 49.8175}, CountryId{"UA"}}, // Bilosillia
    {Coordinate{25.7552, 49.5308}, CountryId{"UA"}}, // Birky-Velyki
    {Coordinate{28.7447, 48.5336}, CountryId{"UA"}}, // Vapniarka
    {Coordinate{28.5561, 49.4637}, CountryId{"UA"}}, // Varshytsia
    {Coordinate{30.2253, 50.2258}, CountryId{"UA"}}, // Vasylkiv 1st
    {Coordinate{30.3186, 50.1725}, CountryId{"UA"}}, // Vasylkiv-Tsentr
    {Coordinate{27.7802, 49.1348}, CountryId{"UA"}}, // Vasiutyntsi
    {Coordinate{32.5449, 51.1143}, CountryId{"UA"}}, // Velyka Zahorivka
    {Coordinate{26.9536, 49.925}, CountryId{"UA"}}, // Velyki Puzyrky
    {Coordinate{26.9433, 49.8319}, CountryId{"UA"}}, // Q12088497
    {Coordinate{33.7381, 50.3647}, CountryId{"UA"}}, // Veneslavivka
    {Coordinate{26.9822, 49.9853}, CountryId{"UA"}}, // Verbivtsi
    {Coordinate{28.7647, 50.3136}, CountryId{"UA"}}, // Veresy
    {Coordinate{28.9499, 49.7877}, CountryId{"UA"}}, // Vernyhorodok
    {Coordinate{34.3686, 48.5539}, CountryId{"UA"}}, // Verkhnodniprovsk
    {Coordinate{36.3074, 47.2072}, CountryId{"UA"}}, // Verkhnii Tokmak 1
    {Coordinate{29.992, 47.1059}, CountryId{"UA"}}, // Veselyi Kut
    {Coordinate{28.4775, 49.1364}, CountryId{"UA"}}, // Veselka
    {Coordinate{33.4281, 47.9958}, CountryId{"UA"}}, // Vechirnii Kut
    {Coordinate{30.3978, 46.6136}, CountryId{"UA"}}, // Vyhoda
    {Coordinate{31.6472, 48.6336}, CountryId{"UA"}}, // Vyska
    {Coordinate{32.8656, 47.9811}, CountryId{"UA"}}, // Vysun
    {Coordinate{30.3689, 50.3844}, CountryId{"UA"}}, // Vyshneve
    {Coordinate{30.0275, 50.1478}, CountryId{"UA"}}, // Vyshniaky
    {Coordinate{35.3778, 45.1694}, CountryId{"UA"}}, // Vladislavovka
    {Coordinate{36.9194, 50.2836}, CountryId{"UA"}}, // Q12089995
    {Coordinate{38.4883, 48.8697}, CountryId{"UA"}}, // Q12090014
    {Coordinate{35.9575, 49.9416}, CountryId{"UA"}}, // Vodiane
    {Coordinate{29.68, 50.0411}, CountryId{"UA"}}, // Volytsia
    {Coordinate{24.3347, 50.8417}, CountryId{"UA"}}, // Q12090407
    {Coordinate{26.2084, 49.5322}, CountryId{"UA"}}, // Volochysk
    {Coordinate{34.2246, 51.1702}, CountryId{"UA"}}, // Vorozhba
    {Coordinate{30.5844, 47.8767}, CountryId{"UA"}}, // Vradiivka
    {Coordinate{21.222, 55.871}, CountryId{"LT"}}, // Bajorai train station
    {Coordinate{29.1167, 49.8927}, CountryId{"UA"}}, // Vchoraishe
    {Coordinate{26.4503, 49.4955}, CountryId{"UA"}}, // Q12093150
    {Coordinate{34.0158, 48.4653}, CountryId{"UA"}}, // Vilnohirsk railway station
    {Coordinate{29.438, 51.3613}, CountryId{"UA"}}, // Vilcha
    {Coordinate{28.5333, 49.2692}, CountryId{"UA"}}, // Vinnytsia-Vantazhna
    {Coordinate{28.511, 49.2393}, CountryId{"UA"}}, // Vinnytsia
    {Coordinate{35.574, 50.0842}, CountryId{"UA"}}, // Havryshi
    {Coordinate{33.9756, 50.3856}, CountryId{"UA"}}, // Q12093803
    {Coordinate{30.8397, 49.7474}, CountryId{"UA"}}, // Halyne
    {Coordinate{32.1907, 50.7063}, CountryId{"UA"}}, // Halka
    {Coordinate{27.3918, 50.1311}, CountryId{"UA"}}, // Hannusyne
    {Coordinate{26.3708, 49.5175}, CountryId{"UA"}}, // Harnyshivka
    {Coordinate{33.0681, 47.9292}, CountryId{"UA"}}, // Heikivka
    {Coordinate{34.7741, 46.1737}, CountryId{"UA"}}, // Q12094739
    {Coordinate{30.3075, 50.2575}, CountryId{"UA"}}, // Hlevakha
    {Coordinate{33.9383, 51.6781}, CountryId{"UA"}}, // Hlukhiv
    {Coordinate{28.7213, 49.8038}, CountryId{"UA"}}, // Hlukhivtsi
    {Coordinate{28.3298, 49.1024}, CountryId{"UA"}}, // Hnivan
    {Coordinate{33.8228, 49.9125}, CountryId{"UA"}}, // Hoholeve
    {Coordinate{28.7153, 49.5653}, CountryId{"UA"}}, // Holendry
    {Coordinate{28.6823, 50.456}, CountryId{"UA"}}, // Horbashi
    {Coordinate{40.3728, 53.2723}, CountryId{"RU"}}, // Q120969222
    {Coordinate{40.3922, 53.2767}, CountryId{"RU"}}, // Q120969223
    {Coordinate{40.611, 53.3189}, CountryId{"RU"}}, // Q120969229
    {Coordinate{31.6419, 51.9144}, CountryId{"UA"}}, // Horodnia
    {Coordinate{24.8156, 50.4498}, CountryId{"UA"}}, // Horokhiv
    {Coordinate{34.9819, 48.4792}, CountryId{"UA"}}, // Horiaiinove
    {Coordinate{8.40956, 48.9385}, CountryId{"DE"}}, // Ettlingen Stadt train station
    {Coordinate{36.8671, 49.7292}, CountryId{"UA"}}, // Q12097411
    {Coordinate{33.3906, 48.0956}, CountryId{"UA"}}, // Hrekuvata
    {Coordinate{26.9511, 49.4282}, CountryId{"UA"}}, // Hrechanskyi Pereizd
    {Coordinate{31.8349, 50.9984}, CountryId{"UA"}}, // Hryhoro-Ivanivka
    {Coordinate{32.8234, 51.0179}, CountryId{"UA"}}, // Hryhorivka
    {Coordinate{33.5397, 51.2139}, CountryId{"UA"}}, // Hruzke
    {Coordinate{26.857, 49.4637}, CountryId{"UA"}}, // Hruzivtsi
    {Coordinate{35.3748, 50.1775}, CountryId{"UA"}}, // Hubarivka
    {Coordinate{35.2661, 48.8022}, CountryId{"UA"}}, // Hubynykha
    {Coordinate{27.725, 50.5286}, CountryId{"UA"}}, // Hulsk
    {Coordinate{30.2736, 50.2444}, CountryId{"UA"}}, // Danylivka
    {Coordinate{30.6755, 50.4385}, CountryId{"UA"}}, // Darnytsia-Depo
    {Coordinate{27.1006, 49.765}, CountryId{"UA"}}, // Q12099624
    {Coordinate{28.2334, 49.0883}, CountryId{"UA"}}, // Demydivka
    {Coordinate{28.409, 49.948}, CountryId{"UA"}}, // Demchyn
    {Coordinate{38.4972, 48.3647}, CountryId{"UA"}}, // Q12100187
    {Coordinate{27.4311, 49.2669}, CountryId{"UA"}}, // Derazhnia
    {Coordinate{28.5596, 49.3239}, CountryId{"UA"}}, // Desenka
    {Coordinate{29.1164, 45.6519}, CountryId{"UA"}}, // Dzynilor
    {Coordinate{30.9408, 50.5923}, CountryId{"UA"}}, // Dymerka
    {Coordinate{34.4169, 48.5892}, CountryId{"UA"}}, // Q12101357
    {Coordinate{34.6353, 48.5897}, CountryId{"UA"}}, // Q12101384
    {Coordinate{34.5875, 48.5256}, CountryId{"UA"}}, // Kamianske
    {Coordinate{34.991, 48.4217}, CountryId{"UA"}}, // Dnipro-Vantazhnyi
    {Coordinate{28.5858, 51.2897}, CountryId{"UA"}}, // Khaichnoryn
    {Coordinate{32.7617, 48.115}, CountryId{"UA"}}, // Dolynska
    {Coordinate{31.688, 50.9443}, CountryId{"UA"}}, // Doslidna
    {Coordinate{28.6724, 50.9424}, CountryId{"UA"}}, // Drevlyanka
    {Coordinate{34.618, 49.6092}, CountryId{"UA"}}, // Dublianshchyna
    {Coordinate{33.3922, 51.1989}, CountryId{"UA"}}, // Duboviazivka
    {Coordinate{36.6941, 48.814}, CountryId{"UA"}}, // Q12102642
    {Coordinate{28.425, 50.3517}, CountryId{"UA"}}, // Dubovets
    {Coordinate{27.3403, 50.3197}, CountryId{"UA"}}, // Dubiivka
    {Coordinate{22.519, 56.265}, CountryId{"LT"}}, // Viekšniai train station
    {Coordinate{26.8381, 49.0206}, CountryId{"UA"}}, // Dunaivtsi
    {Coordinate{34.9089, 48.4614}, CountryId{"UA"}}, // Diivka Railway Station
    {Coordinate{33.3906, 46.7575}, CountryId{"UA"}}, // Q12103718
    {Coordinate{34.0414, 51.8106}, CountryId{"UA"}}, // Q12104126
    {Coordinate{24.0172, 52.2006}, CountryId{"BY"}}, // Zhabinka
    {Coordinate{33.9153, 48.4369}, CountryId{"UA"}}, // Erastivka
    {Coordinate{31.001, 50.6264}, CountryId{"UA"}}, // Zherdove
    {Coordinate{28.6978, 50.2681}, CountryId{"UA"}}, // Zhytomyr
    {Coordinate{36.2475, 49.8475}, CountryId{"UA"}}, // Zhykhor
    {Coordinate{33.6153, 48.3817}, CountryId{"UA"}}, // Zhovti Vody 1
    {Coordinate{28.7204, 48.6012}, CountryId{"UA"}}, // Zhuravlivka
    {Coordinate{31.1357, 50.6901}, CountryId{"UA"}}, // Zavorychi
    {Coordinate{33.5589, 46.7731}, CountryId{"UA"}}, // Q12105183
    {Coordinate{29.795, 50.6567}, CountryId{"UA"}}, // Zahaltsi
    {Coordinate{12.2648, 53.6513}, CountryId{"DE"}}, // Krakow am See (Meckl) train station
    {Coordinate{37.2033, 49.3767}, CountryId{"UA"}}, // Q12105425
    {Coordinate{36.1617, 49.9675}, CountryId{"UA"}}, // Zalyutine
    {Coordinate{27.0186, 49.6111}, CountryId{"UA"}}, // Q12105801
    {Coordinate{35.2378, 47.8842}, CountryId{"UA"}}, // Zaporizhzhia-Ljive
    {Coordinate{35.1881, 47.7958}, CountryId{"UA"}}, // Zaporizhzhia I
    {Coordinate{35.1847, 47.8222}, CountryId{"UA"}}, // Zaporizhzhia 2
    {Coordinate{27.0297, 49.5506}, CountryId{"UA"}}, // Q12105943
    {Coordinate{35.2297, 49.2144}, CountryId{"UA"}}, // Q12106211
    {Coordinate{34.0224, 52.1839}, CountryId{"UA"}}, // Zernove
    {Coordinate{32.7012, 48.7089}, CountryId{"UA"}}, // Znamianka-Pasazhyrska
    {Coordinate{32.6539, 48.7163}, CountryId{"UA"}}, // Znamianka
    {Coordinate{35.9883, 50.2737}, CountryId{"UA"}}, // Q12107002
    {Coordinate{10.375, 54.3871}, CountryId{"DE"}}, // Schönberg (Holst) train station
    {Coordinate{11.1808, 50.6426}, CountryId{"DE"}}, // Schwarzburg train station
    {Coordinate{35.0202, 48.3997}, CountryId{"UA"}}, // Zustrichny
    {Coordinate{36.3031, 49.79}, CountryId{"UA"}}, // Q12107263
    {Coordinate{29.0009, 50.8601}, CountryId{"UA"}}, // Yosypivka
    {Coordinate{30.7846, 49.8419}, CountryId{"UA"}}, // Kaharlyk
    {Coordinate{32.7614, 47.8806}, CountryId{"UA"}}, // Kazanka
    {Coordinate{11.1683, 50.6597}, CountryId{"DE"}}, // Bechstedt-Trippstein train stop
    {Coordinate{8.63756, 51.0226}, CountryId{"DE"}}, // Battenberg (Eder) train station
    {Coordinate{24.3489, 49.0128}, CountryId{"UA"}}, // Kalush
    {Coordinate{33.6389, 48.1325}, CountryId{"UA"}}, // Kamyane Pole
    {Coordinate{26.9744, 49.4167}, CountryId{"UA"}}, // Kamianetskyi Pereizd
    {Coordinate{10.9566, 51.5674}, CountryId{"DE"}}, // Stolberg (Harz) train station
    {Coordinate{31.7806, 51.8633}, CountryId{"UA"}}, // Kamka
    {Coordinate{24.9604, 51.6054}, CountryId{"UA"}}, // Q12108257
    {Coordinate{34.9506, 47.8383}, CountryId{"UA"}}, // Q12108331
    {Coordinate{11.8174, 50.5817}, CountryId{"DE"}}, // Schleiz Hp train stop
    {Coordinate{11.8095, 50.5806}, CountryId{"DE"}}, // Schleiz West train station
    {Coordinate{35.8699, 49.9571}, CountryId{"UA"}}, // Karavanna
    {Coordinate{30.832, 49.6371}, CountryId{"UA"}}, // Karapyshi
    {Coordinate{34.7211, 48.4775}, CountryId{"UA"}}, // Q12108762
    {Coordinate{34.0664, 48.4628}, CountryId{"UA"}}, // Q12108950
    {Coordinate{33.4286, 46.7525}, CountryId{"UA"}}, // Q12109158
    {Coordinate{32.6583, 50.8896}, CountryId{"UA"}}, // Kachanivka
    {Coordinate{30.845, 50.5342}, CountryId{"UA"}}, // Kvitnevyi
    {Coordinate{35.7639, 49.2867}, CountryId{"UA"}}, // Q12109390
    {Coordinate{26.825, 48.4444}, CountryId{"UA"}}, // Kelmentsi
    {Coordinate{23.912, 55.744}, CountryId{"LT"}}, // Laba train station
    {Coordinate{8.9687, 48.3596}, CountryId{"DE"}}, // Hechingen railway station
    {Coordinate{36.4275, 45.3631}, CountryId{"UA"}}, // Kerch Railway station
    {Coordinate{38.6958, 48.4386}, CountryId{"UA"}}, // Q12109879
    {Coordinate{13.0403, 51.2378}, CountryId{"DE"}}, // Altmügeln train station
    {Coordinate{30.0164, 50.5813}, CountryId{"UA"}}, // Klavdijeve
    {Coordinate{23.9803, 49.8556}, CountryId{"UA"}}, // Klepariv
    {Coordinate{24.8793, 54.5626}, CountryId{"LT"}}, // Šklėriai train station
    {Coordinate{24.983, 54.717}, CountryId{"LT"}}, // Rykantai train station
    {Coordinate{28.8618, 50.322}, CountryId{"UA"}}, // Q12110675
    {Coordinate{28.8129, 48.4719}, CountryId{"UA"}}, // Kniazheve
    {Coordinate{30.783, 50.495}, CountryId{"UA"}}, // Kniazhychi
    {Coordinate{34.1033, 49.2306}, CountryId{"UA"}}, // Kobeliaky Railway Station
    {Coordinate{31.5493, 50.8237}, CountryId{"UA"}}, // Kobyzhchi
    {Coordinate{24.7063, 54.3135}, CountryId{"LT"}}, // Pamerkiai train station
    {Coordinate{24.7119, 51.2217}, CountryId{"UA"}}, // Kovel
    {Coordinate{28.6646, 50.1078}, CountryId{"UA"}}, // Kodnia
    {Coordinate{29.7315, 49.9811}, CountryId{"UA"}}, // Kozhanka
    {Coordinate{28.8865, 50.3224}, CountryId{"UA"}}, // Q12111277
    {Coordinate{33.3284, 46.7846}, CountryId{"UA"}}, // Q12111317
    {Coordinate{28.1799, 49.0882}, CountryId{"UA"}}, // Kozachivka
    {Coordinate{28.8389, 49.7114}, CountryId{"UA"}}, // Koziatyn I
    {Coordinate{27.5033, 50.4281}, CountryId{"UA"}}, // Kolodianka
    {Coordinate{28.3597, 50.365}, CountryId{"UA"}}, // Kolodiivka
    {Coordinate{35.2177, 49.855}, CountryId{"UA"}}, // Kolomak
    {Coordinate{31.0172, 47.3036}, CountryId{"UA"}}, // Kolosivka Railway Station
    {Coordinate{27.6656, 49.1947}, CountryId{"UA"}}, // Komarivtsi
    {Coordinate{36.6961, 47.3286}, CountryId{"UA"}}, // Komysh-Zoria
    {Coordinate{32.1067, 50.1775}, CountryId{"UA"}}, // Kononivka
    {Coordinate{28.7834, 49.64}, CountryId{"UA"}}, // Kordyshivka
    {Coordinate{33.0662, 48.7324}, CountryId{"UA"}}, // Korystivka
    {Coordinate{29.5172, 50.0419}, CountryId{"UA"}}, // Kornyn
    {Coordinate{28.6347, 50.9569}, CountryId{"UA"}}, // Korosten
    {Coordinate{29.0202, 50.3163}, CountryId{"UA"}}, // Korostyshiv Railway Station
    {Coordinate{36.0355, 49.9548}, CountryId{"UA"}}, // Korotych
    {Coordinate{30.1353, 50.1942}, CountryId{"UA"}}, // Korchi
    {Coordinate{10.9377, 51.6396}, CountryId{"DE"}}, // Friedrichshöhe train station
    {Coordinate{31.5766, 50.8633}, CountryId{"UA"}}, // Kosmichna
    {Coordinate{34.0989, 51.1703}, CountryId{"UA"}}, // Koshary
    {Coordinate{23.985, 55.744}, CountryId{"LT"}}, // Labučiai train station
    {Coordinate{27.0139, 49.6692}, CountryId{"UA"}}, // Krasyliv Railway Station
    {Coordinate{24.6147, 49.9169}, CountryId{"UA"}}, // Krasne
    {Coordinate{35.445, 49.3606}, CountryId{"UA"}}, // Q12114235
    {Coordinate{28.62, 50.7697}, CountryId{"UA"}}, // Krasnosilka
    {Coordinate{26.9508, 49.8603}, CountryId{"UA"}}, // Q12114331
    {Coordinate{33.3097, 47.8789}, CountryId{"UA"}}, // Kryvyi Rih-West railway station
    {Coordinate{33.3764, 47.8783}, CountryId{"UA"}}, // Kryvyi Rih
    {Coordinate{26.7003, 50.3616}, CountryId{"UA"}}, // Kryvyn
    {Coordinate{28.8642, 48.3797}, CountryId{"UA"}}, // Kryzhopil
    {Coordinate{33.3619, 51.5514}, CountryId{"UA"}}, // Krolevets
    {Coordinate{28.6708, 50.2947}, CountryId{"UA"}}, // Kroshnia
    {Coordinate{33.4356, 49.0344}, CountryId{"UA"}}, // Kriukiv Railway Station
    {Coordinate{}, CountryId{"UA"}}, // Kriukivshchyna
    {Coordinate{34.0489, 48.2739}, CountryId{"UA"}}, // Q12115417
    {Coordinate{54.04, 57.9433}, CountryId{"RU"}}, // Q12115525
    {Coordinate{27.0872, 49.6806}, CountryId{"UA"}}, // Q12115546
    {Coordinate{35.3091, 50.2307}, CountryId{"UA"}}, // Kupievakha
    {Coordinate{28.1189, 50.4308}, CountryId{"UA"}}, // Kurne
    {Coordinate{31.1194, 50.3627}, CountryId{"UA"}}, // Kuchakove
    {Coordinate{35.1969, 47.7197}, CountryId{"UA"}}, // Kushuhum railway station
    {Coordinate{35.2736, 48.8767}, CountryId{"UA"}}, // Q12116431
    {Coordinate{32.2604, 48.5238}, CountryId{"UA"}}, // Kropyvnytskyi
    {Coordinate{35.2183, 45.2272}, CountryId{"UA"}}, // Q12116617
    {Coordinate{32.6436, 50.0955}, CountryId{"UA"}}, // Lazirky
    {Coordinate{26.8505, 48.4311}, CountryId{"UA"}}, // Larha
    {Coordinate{29.4858, 50.0647}, CountryId{"UA"}}, // Lypniak
    {Coordinate{26.2882, 49.5278}, CountryId{"UA"}}, // Lozova
    {Coordinate{31.987, 50.8756}, CountryId{"UA"}}, // Losynivka
    {Coordinate{29.3353, 50.1197}, CountryId{"UA"}}, // Lotos
    {Coordinate{33.4603, 50.3681}, CountryId{"UA"}}, // Lokhvytsia
    {Coordinate{39.2081, 48.4097}, CountryId{"UA"}}, // Q12118937
    {Coordinate{35.9273, 49.9412}, CountryId{"UA"}}, // Lyubotyn
    {Coordinate{35.8936, 49.9517}, CountryId{"UA"}}, // Liubivka
    {Coordinate{30.5341, 50.2963}, CountryId{"UA"}}, // Lisnyky
    {Coordinate{28.8517, 50.1858}, CountryId{"UA"}}, // Lishchyn
    {Coordinate{27.3078, 50.2936}, CountryId{"UA"}}, // Maidan-Vyla
    {Coordinate{31.3262, 50.748}, CountryId{"UA"}}, // Makarivka
    {Coordinate{33.5894, 51.8261}, CountryId{"UA"}}, // Makove
    {Coordinate{35.701, 50.0897}, CountryId{"UA"}}, // Maksymivka
    {Coordinate{29.9482, 50.6035}, CountryId{"UA"}}, // Makiychukove
    {Coordinate{34.52, 49.3964}, CountryId{"UA"}}, // Mala Pereshchepynska
    {Coordinate{29.2949, 50.7746}, CountryId{"UA"}}, // Malyn
    {Coordinate{26.5492, 51.0947}, CountryId{"UA"}}, // Malynsk Railway Station
    {Coordinate{24.0858, 51.7939}, CountryId{"BY"}}, // Malaryta
    {Coordinate{30.305, 50.2897}, CountryId{"UA"}}, // Maliutianka
    {Coordinate{32.2672, 50.1481}, CountryId{"UA"}}, // Marianivka
    {Coordinate{30.5944, 50.2057}, CountryId{"UA"}}, // Marianivska
    {Coordinate{35.4712, 49.9289}, CountryId{"UA"}}, // Marine
    {Coordinate{34.6214, 47.655}, CountryId{"UA"}}, // Q12121308
    {Coordinate{31.2775, 50.7286}, CountryId{"UA"}}, // Markivtsi
    {Coordinate{33.1464, 46.9188}, CountryId{"UA"}}, // Q12121920
    {Coordinate{27.9795, 49.0652}, CountryId{"UA"}}, // Mezhyriv
    {Coordinate{36.7361, 48.2506}, CountryId{"UA"}}, // Q12122299
    {Coordinate{28.8692, 50.8892}, CountryId{"UA"}}, // Meleni
    {Coordinate{35.7626, 50.0076}, CountryId{"UA"}}, // Merchyk
    {Coordinate{36.2017, 47.9833}, CountryId{"UA"}}, // Q12123151
    {Coordinate{24.5111, 51.3617}, CountryId{"UA"}}, // Q12123208
    {Coordinate{32.0619, 46.9372}, CountryId{"UA"}}, // Mykolaiv railway station
    {Coordinate{28.7478, 49.6017}, CountryId{"UA"}}, // Mykolayivka
    {Coordinate{33.9628, 48.1994}, CountryId{"UA"}}, // Q12123391
    {Coordinate{33.6256, 49.9492}, CountryId{"UA"}}, // Myrhorod
    {Coordinate{30.9807, 49.6483}, CountryId{"UA"}}, // Myronivka
    {Coordinate{27.6687, 50.0998}, CountryId{"UA"}}, // Myropil
    {Coordinate{28.4694, 49.9536}, CountryId{"UA"}}, // Myroslavka
    {Coordinate{27.4761, 50.3917}, CountryId{"UA"}}, // Myroslavl
    {Coordinate{26.5572, 50.4152}, CountryId{"UA"}}, // Mohyliany
    {Coordinate{28.2742, 49.0921}, CountryId{"UA"}}, // Mohylivka
    {Coordinate{27.0642, 50.0592}, CountryId{"UA"}}, // Q12124186
    {Coordinate{28.2761, 50.3892}, CountryId{"UA"}}, // Babychivskyi
    {Coordinate{11.1102, 50.6032}, CountryId{"DE"}}, // Q121288172
    {Coordinate{13.3352, 48.4336}, CountryId{"DE"}}, // Ruhstorf
    {Coordinate{13.3231, 48.4948}, CountryId{"DE"}}, // Bad Höhenstadt
    {Coordinate{13.3339, 48.5131}, CountryId{"DE"}}, // Fürstenzell
    {Coordinate{13.1874, 48.408}, CountryId{"DE"}}, // Karpfham
    {Coordinate{13.1351, 48.4141}, CountryId{"DE"}}, // Bayerbach
    {Coordinate{28.1119, 49.0339}, CountryId{"UA"}}, // Zhmerynka
    {Coordinate{31.4345, 50.3356}, CountryId{"UA"}}, // Poliskyi
    {Coordinate{33.6436, 46.7903}, CountryId{"UA"}}, // Q12129294
    {Coordinate{13.074, 48.433}, CountryId{"DE"}}, // Bad Birnbach
    {Coordinate{13.0214, 48.4347}, CountryId{"DE"}}, // Anzenkirchen
    {Coordinate{12.9389, 48.4292}, CountryId{"DE"}}, // Pfarrkirchen
    {Coordinate{12.8187, 48.4166}, CountryId{"DE"}}, // Hebertsfelden
    {Coordinate{12.7677, 48.4062}, CountryId{"DE"}}, // Eggenfelden Mitte
    {Coordinate{12.7485, 48.4038}, CountryId{"DE"}}, // Eggenfelden
    {Coordinate{12.6083, 48.394}, CountryId{"DE"}}, // Massing
    {Coordinate{12.446, 48.3958}, CountryId{"DE"}}, // Egglkofen
    {Coordinate{12.5511, 48.2981}, CountryId{"DE"}}, // Rohrbach (Oberbay)
    {Coordinate{12.2379, 48.7625}, CountryId{"DE"}}, // Niederlindhart
    {Coordinate{30.1053, 50.1822}, CountryId{"UA"}}, // Motovylivka
    {Coordinate{36.4801, 49.8322}, CountryId{"UA"}}, // Q12130339
    {Coordinate{33.4025, 47.9153}, CountryId{"UA"}}, // Mudrona
    {Coordinate{22.7114, 48.4294}, CountryId{"UA"}}, // Mukachevo Railway Station
    {Coordinate{33.2039, 47.8867}, CountryId{"UA"}}, // Musiivka
    {Coordinate{39.1383, 48.5767}, CountryId{"UA"}}, // Milova
    {Coordinate{11.0791, 50.5813}, CountryId{"DE"}}, // Meuselbach-Schwarzmühle train stop
    {Coordinate{27.5744, 50.5564}, CountryId{"UA"}}, // Nalyvna
    {Coordinate{26.6211, 49.5085}, CountryId{"UA"}}, // Narkevychi
    {Coordinate{38.4079, 48.9422}, CountryId{"UA"}}, // Nasvitevich Railway Station
    {Coordinate{12.3904, 51.8009}, CountryId{"DE"}}, // Oranienbaum (Anh) train station
    {Coordinate{28.2278, 50.4008}, CountryId{"UA"}}, // Neborivka
    {Coordinate{30.087, 50.5617}, CountryId{"UA"}}, // Nemishajeve
    {Coordinate{33.8442, 51.9728}, CountryId{"UA"}}, // Neplyujeve
    {Coordinate{11.1369, 50.5065}, CountryId{"DE"}}, // Neuhaus am Rennweg train station
    {Coordinate{34.7378, 45.4472}, CountryId{"UA"}}, // Q12133681
    {Coordinate{35.0636, 48.4981}, CountryId{"UA"}}, // Q12133684
    {Coordinate{28.6243, 50.6912}, CountryId{"UA"}}, // Nova Borova
    {Coordinate{28.7428, 50.2311}, CountryId{"UA"}}, // Nova Bystra
    {Coordinate{28.5164, 50.3322}, CountryId{"UA"}}, // Nova Vyhoda
    {Coordinate{29.7811, 50.0333}, CountryId{"UA"}}, // Nova Volytsia
    {Coordinate{10.9286, 51.6428}, CountryId{"DE"}}, // Q121338497
    {Coordinate{28.7782, 50.9234}, CountryId{"UA"}}, // Novaki
    {Coordinate{33.2551, 51.9932}, CountryId{"UA"}}, // Novhorod-Siverskyi
    {Coordinate{33.4856, 47.9122}, CountryId{"UA"}}, // Novoblochna
    {Coordinate{27.5931, 50.5978}, CountryId{"UA"}}, // Zviahel 1st railway station
    {Coordinate{27.7833, 50.5139}, CountryId{"UA"}}, // Zviahel 2
    {Coordinate{35.4858, 48.0239}, CountryId{"UA"}}, // Novohupolivka (railway station)
    {Coordinate{35.2322, 48.6425}, CountryId{"UA"}}, // Q12134139
    {Coordinate{34.6503, 46.2306}, CountryId{"UA"}}, // Novooleksiivka
    {Coordinate{29.8686, 46.8022}, CountryId{"MD"}}, // Novosavitskaia
    {Coordinate{30.6236, 50.1863}, CountryId{"UA"}}, // Novi Bezradychi
    {Coordinate{34.4042, 49.3281}, CountryId{"UA"}}, // Novi Sanzhary Railway Station
    {Coordinate{31.6041, 50.9028}, CountryId{"UA"}}, // Nosivka
    {Coordinate{34.3944, 47.5867}, CountryId{"UA"}}, // Nikopol Railway Station
    {Coordinate{30.7313, 50.0336}, CountryId{"UA"}}, // Ozernyi
    {Coordinate{26.035, 50.4578}, CountryId{"UA"}}, // Ozeriany
    {Coordinate{33.1325, 48.6739}, CountryId{"UA"}}, // Oleksandriya
    {Coordinate{26.9283, 49.4708}, CountryId{"UA"}}, // Q12135739
    {Coordinate{30.6489, 49.6581}, CountryId{"UA"}}, // Olshanytsia
    {Coordinate{125.405, 58.5978}, CountryId{"RU"}}, // Aldan
    {Coordinate{27.5614, 50.5053}, CountryId{"UA"}}, // Orepy
    {Coordinate{36.0191, 48.9746}, CountryId{"UA"}}, // Q12136461
    {Coordinate{26.9272, 49.4997}, CountryId{"UA"}}, // Q12136731
    {Coordinate{26.4941, 50.437}, CountryId{"UA"}}, // Ostroh
    {Coordinate{34.9165, 50.3175}, CountryId{"UA"}}, // Q12137017
    {Coordinate{33.6478, 48.4271}, CountryId{"UA"}}, // P'yatykhatky-Stykova
    {Coordinate{33.7031, 48.4144}, CountryId{"UA"}}, // P'yatykhatky
    {Coordinate{35.2699, 49.8936}, CountryId{"UA"}}, // Panasivka
    {Coordinate{32.075, 49.5053}, CountryId{"UA"}}, // Panske
    {Coordinate{30.9024, 50.5704}, CountryId{"UA"}}, // Parnykova
    {Coordinate{28.5182, 49.1748}, CountryId{"UA"}}, // Parpurivskyi Railway Halt
    {Coordinate{27.0508, 50.0983}, CountryId{"UA"}}, // Q12139250
    {Coordinate{29.3699, 50.7367}, CountryId{"UA"}}, // Penyzevychi
    {Coordinate{31.1822, 47.2967}, CountryId{"UA"}}, // Pervenets
    {Coordinate{30.8514, 48.0411}, CountryId{"UA"}}, // Golta
    {Coordinate{38.5789, 48.6253}, CountryId{"UA"}}, // Q12139477
    {Coordinate{37.6131, 49.3647}, CountryId{"UA"}}, // Q12139564
    {Coordinate{35.3119, 49.0192}, CountryId{"UA"}}, // Q12139842
    {Coordinate{31.6556, 50.2641}, CountryId{"UA"}}, // Pereiaslavska
    {Coordinate{24.0294, 49.8097}, CountryId{"UA"}}, // Persenkivka
    {Coordinate{27.8004, 50.0752}, CountryId{"UA"}}, // Pechanivka
    {Coordinate{35.8053, 49.9268}, CountryId{"UA"}}, // Pyrohova
    {Coordinate{32.5064, 50.2353}, CountryId{"UA"}}, // Pyriatyn
    {Coordinate{29.2202, 50.8042}, CountryId{"UA"}}, // Pirizhkivskiy
    {Coordinate{33.601, 48.0161}, CountryId{"UA"}}, // Q12140660
    {Coordinate{34.2822, 48.5389}, CountryId{"UA"}}, // Q12140803
    {Coordinate{34.3122, 48.5544}, CountryId{"UA"}}, // Q12140804
    {Coordinate{34.5511, 48.4994}, CountryId{"UA"}}, // Q12140805
    {Coordinate{34.4508, 48.5361}, CountryId{"UA"}}, // Q12140806
    {Coordinate{34.1324, 48.471}, CountryId{"UA"}}, // Hranove
    {Coordinate{32.4403, 51.1028}, CountryId{"UA"}}, // Plysky
    {Coordinate{36.2592, 47.4761}, CountryId{"UA"}}, // Polohy Railway Station
    {Coordinate{27.4882, 50.1396}, CountryId{"UA"}}, // Polonne
    {Coordinate{33.1642, 47.7644}, CountryId{"UA"}}, // Poltavka-Kryvorizka
    {Coordinate{34.2233, 48.4431}, CountryId{"UA"}}, // Q12142068
    {Coordinate{32.7012, 48.7089}, CountryId{"UA"}}, // Pomichna Railway Station
    {Coordinate{27.5248, 50.138}, CountryId{"UA"}}, // Poninka
    {Coordinate{31.4983, 50.7978}, CountryId{"UA"}}, // Popudrenko
    {Coordinate{29.4594, 49.9445}, CountryId{"UA"}}, // Popilnia
    {Coordinate{36.1872, 50.0168}, CountryId{"UA"}}, // Q12142757
    {Coordinate{34.6006, 49.5667}, CountryId{"UA"}}, // Q12142758
    {Coordinate{35.9855, 49.9472}, CountryId{"UA"}}, // Post 21 km
    {Coordinate{33.8864, 48.1597}, CountryId{"UA"}}, // Q12142876
    {Coordinate{29.8786, 50.0533}, CountryId{"UA"}}, // Potiivka
    {Coordinate{34.6589, 48.5172}, CountryId{"UA"}}, // Q12143209
    {Coordinate{12.1316, 51.0567}, CountryId{"DE"}}, // Zeitz
    {Coordinate{9.11246, 48.8303}, CountryId{"DE"}}, // Q121435280
    {Coordinate{34.7558, 48.2269}, CountryId{"UA"}}, // Pryvilne
    {Coordinate{32.0375, 51.0624}, CountryId{"UA"}}, // Pryosternyi
    {Coordinate{35.0731, 48.4522}, CountryId{"UA"}}, // Prospektna
    {Coordinate{36.3764, 48.1175}, CountryId{"UA"}}, // Q12145067
    {Coordinate{36.1678, 50.2402}, CountryId{"UA"}}, // Q12145268
    {Coordinate{28.7064, 50.1758}, CountryId{"UA"}}, // Priazhiv
    {Coordinate{33.8497, 51.2025}, CountryId{"UA"}}, // Putyvl
    {Coordinate{33.6036, 51.2131}, CountryId{"UA"}}, // Putiiska
    {Coordinate{30.0568, 50.166}, CountryId{"UA"}}, // Pivni
    {Coordinate{26.1408, 49.5292}, CountryId{"UA"}}, // Pidvolochysk Railway Station
    {Coordinate{30.8936, 48.1092}, CountryId{"UA"}}, // Pidhorodna
    {Coordinate{30.5542, 50.2668}, CountryId{"UA"}}, // Pidhirtsi
    {Coordinate{24.0339, 49.8511}, CountryId{"UA"}}, // Pidzamche
    {Coordinate{12.9038, 50.7723}, CountryId{"DE"}}, // Klaffenbach train stop
    {Coordinate{33.9264, 47.6328}, CountryId{"UA"}}, // Q12146117
    {Coordinate{11.1266, 51.7527}, CountryId{"DE"}}, // Q121461370
    {Coordinate{29.6454, 50.6946}, CountryId{"UA"}}, // Pisky
    {Coordinate{11.0493, 51.6182}, CountryId{"DE"}}, // Straßberg-Glasebach train stop
    {Coordinate{36.0937, 49.95}, CountryId{"UA"}}, // Pisochyn
    {Coordinate{31.6852, 48.8874}, CountryId{"UA"}}, // Radhospna
    {Coordinate{25.2609, 50.119}, CountryId{"UA"}}, // Radyvyliv
    {Coordinate{27.395, 50.3578}, CountryId{"UA"}}, // Radulyn
    {Coordinate{33.5147, 47.8194}, CountryId{"UA"}}, // Radushna
    {Coordinate{37.6061, 49.2697}, CountryId{"UA"}}, // Q12146685
    {Coordinate{27.7149, 49.1777}, CountryId{"UA"}}, // Radivtsi
    {Coordinate{27.9558, 50.0526}, CountryId{"UA"}}, // Razine
    {Coordinate{36.0937, 49.95}, CountryId{"UA"}}, // Raj-Olenivka
    {Coordinate{28.5122, 49.9452}, CountryId{"UA"}}, // Raiky
    {Coordinate{27.0594, 49.4025}, CountryId{"UA"}}, // Rakove
    {Coordinate{31.7181, 50.2397}, CountryId{"UA"}}, // Rankovyi
    {Coordinate{30.7743, 49.9434}, CountryId{"UA"}}, // Rasava
    {Coordinate{34.5163, 47.6204}, CountryId{"UA"}}, // Q12147209
    {Coordinate{33.4453, 46.755}, CountryId{"UA"}}, // Q12147742
    {Coordinate{34.1433, 49.6372}, CountryId{"UA"}}, // Reshetylivka
    {Coordinate{28.636, 50.0128}, CountryId{"UA"}}, // Reia
    {Coordinate{29.3031, 49.4928}, CountryId{"UA"}}, // Rzhevuska
    {Coordinate{36.1149, 49.9578}, CountryId{"UA"}}, // Ryzhiv
    {Coordinate{35.6712, 49.9235}, CountryId{"UA"}}, // Rohivka
    {Coordinate{32.603, 48.6977}, CountryId{"UA"}}, // 5 km
    {Coordinate{35.5542, 49.3799}, CountryId{"UA"}}, // Q12148412
    {Coordinate{30.5073, 49.6957}, CountryId{"UA"}}, // Rokytne
    {Coordinate{33.4786, 48.0439}, CountryId{"UA"}}, // Rokuvata
    {Coordinate{30.5884, 50.239}, CountryId{"UA"}}, // Romankiv
    {Coordinate{33.3236, 49.9914}, CountryId{"UA"}}, // Romodan
    {Coordinate{27.0469, 49.7722}, CountryId{"UA"}}, // Q12148838
    {Coordinate{30.1871, 49.7796}, CountryId{"UA"}}, // Rotok
    {Coordinate{28.9344, 48.2606}, CountryId{"UA"}}, // Rudnytsia
    {Coordinate{23.9233, 49.8364}, CountryId{"UA"}}, // Rudno
    {Coordinate{35.7655, 50.0725}, CountryId{"UA"}}, // Ripky
    {Coordinate{29.5464, 49.9562}, CountryId{"UA"}}, // Savertsi
    {Coordinate{37.0372, 49.3932}, CountryId{"UA"}}, // Q12149977
    {Coordinate{27.22, 50.2203}, CountryId{"UA"}}, // Savychi
    {Coordinate{33.6267, 48.2947}, CountryId{"UA"}}, // Q12150023
    {Coordinate{35.4192, 49.9345}, CountryId{"UA"}}, // Sadky
    {Coordinate{33.5856, 48.0664}, CountryId{"UA"}}, // Q12150237
    {Coordinate{28.5343, 49.3857}, CountryId{"UA"}}, // Salnytskyi
    {Coordinate{35.8722, 49.1494}, CountryId{"UA"}}, // Q12150831
    {Coordinate{33.9422, 51.9564}, CountryId{"UA"}}, // Svesa
    {Coordinate{37.5503, 49.0752}, CountryId{"UA"}}, // Sviatohirsk Railway Station
    {Coordinate{31.2863, 50.3511}, CountryId{"UA"}}, // Selychivka
    {Coordinate{28.3811, 49.114}, CountryId{"UA"}}, // Selyshchanskyi
    {Coordinate{32.5828, 52.2039}, CountryId{"UA"}}, // Q12151992
    {Coordinate{31.0614, 50.6603}, CountryId{"UA"}}, // Semypolky
    {Coordinate{38.7496, 48.669}, CountryId{"UA"}}, // Q12152121
    {Coordinate{33.4422, 50.1981}, CountryId{"UA"}}, // Sencha
    {Coordinate{28.8936, 49.7499}, CountryId{"UA"}}, // Sestrynivka
    {Coordinate{21.6281, 47.5206}, CountryId{"HU"}}, // Debrecen railway station
    {Coordinate{34.4869, 45.9681}, CountryId{"UA"}}, // Syvash
    {Coordinate{28.8156, 49.6697}, CountryId{"UA"}}, // Syhnal
    {Coordinate{35.5269, 48.3158}, CountryId{"UA"}}, // Synelnykove 1st
    {Coordinate{35.5106, 48.3339}, CountryId{"UA"}}, // Synelnykove 2nd
    {Coordinate{34.8642, 50.7975}, CountryId{"UA"}}, // Syrovatka
    {Coordinate{24.0739, 49.7897}, CountryId{"UA"}}, // Sykhiv
    {Coordinate{30.1992, 50.5335}, CountryId{"UA"}}, // Sklozavodskya
    {Coordinate{23.9308, 49.8169}, CountryId{"UA"}}, // Sknyliv
    {Coordinate{37.6961, 49.5631}, CountryId{"UA"}}, // Q12153350
    {Coordinate{29.3853, 50.1}, CountryId{"UA"}}, // Skochyshche
    {Coordinate{29.735, 50.0414}, CountryId{"UA"}}, // Skryhalivka
    {Coordinate{35.5111, 48.1244}, CountryId{"UA"}}, // Q12153542
    {Coordinate{26.8851, 50.3207}, CountryId{"UA"}}, // Slavuta 1
    {Coordinate{36.1543, 50.2095}, CountryId{"UA"}}, // Slatyne Railway Station
    {Coordinate{32.3893, 50.1264}, CountryId{"UA"}}, // Sloboda-Petrivka
    {Coordinate{29.3442, 47.8851}, CountryId{"UA"}}, // Slobidka
    {Coordinate{37.5903, 48.8467}, CountryId{"UA"}}, // Q12153721
    {Coordinate{37.5558, 48.8325}, CountryId{"UA"}}, // Sloviansk Railway Station
    {Coordinate{27.66, 50.5478}, CountryId{"UA"}}, // Smolka
    {Coordinate{34.9685, 50.4819}, CountryId{"UA"}}, // Trostianets-Smorodyne railway station
    {Coordinate{31.8763, 49.2415}, CountryId{"UA"}}, // Smila
    {Coordinate{32.7797, 47.0653}, CountryId{"UA"}}, // Snihurivka
    {Coordinate{29.9789, 50.1094}, CountryId{"UA"}}, // Snitynka
    {Coordinate{35.8502, 49.9532}, CountryId{"UA"}}, // Liubotyn-Zahidnyi
    {Coordinate{36.1282, 49.6876}, CountryId{"UA"}}, // Q12154992
    {Coordinate{33.8361, 48.0978}, CountryId{"UA"}}, // Q12156907
    {Coordinate{29.6033, 50.0294}, CountryId{"UA"}}, // Stavyshche
    {Coordinate{28.5425, 49.2813}, CountryId{"UA"}}, // Stadnytsia
    {Coordinate{28.7911, 50.2031}, CountryId{"UA"}}, // Stanyshivka
    {Coordinate{31.9756, 46.9575}, CountryId{"UA"}}, // Mykolaiv-Vantazhnyi
    {Coordinate{38.9275, 49.2772}, CountryId{"UA"}}, // Q12157377
    {Coordinate{27.1672, 49.7506}, CountryId{"UA"}}, // Q12157413
    {Coordinate{26.9708, 49.9544}, CountryId{"UA"}}, // Stari Beizymy
    {Coordinate{38.5855, 48.5192}, CountryId{"UA"}}, // Q12157568
    {Coordinate{29.0994, 50.1383}, CountryId{"UA"}}, // Stepok
    {Coordinate{33.9228, 45.1594}, CountryId{"UA"}}, // Storozheve
    {Coordinate{28.8106, 50.912}, CountryId{"UA"}}, // Stremyhorod
    {Coordinate{28.1819, 50.4125}, CountryId{"UA"}}, // Strybizh
    {Coordinate{28.974, 50.3231}, CountryId{"UA"}}, // Q12158200
    {Coordinate{23.8417, 49.2594}, CountryId{"UA"}}, // Stryi Railway Station
    {Coordinate{28.6921, 50.3683}, CountryId{"UA"}}, // Strokovytsi
    {Coordinate{32.8996, 50.0475}, CountryId{"UA"}}, // Stronske
    {Coordinate{30.739, 50.1505}, CountryId{"UA"}}, // Stuhna
    {Coordinate{27.1322, 50.1803}, CountryId{"UA"}}, // Sudylkiv
    {Coordinate{33.4006, 50.3992}, CountryId{"UA"}}, // Sula
    {Coordinate{34.9083, 48.3319}, CountryId{"UA"}}, // Q12158819
    {Coordinate{30.3675, 49.7384}, CountryId{"UA"}}, // Sukholisy
    {Coordinate{10.878, 51.6394}, CountryId{"DE"}}, // Birkenmoor train stop
    {Coordinate{35.2842, 47.4378}, CountryId{"UA"}}, // Q12159700
    {Coordinate{31.1292, 49.5702}, CountryId{"UA"}}, // Tahancha
    {Coordinate{30.3025, 50.3442}, CountryId{"UA"}}, // Tarasivka
    {Coordinate{28.1122, 49.0772}, CountryId{"UA"}}, // Tartak
    {Coordinate{30.6621, 50.1743}, CountryId{"UA"}}, // Tatsenky
    {Coordinate{25.6994, 49.3006}, CountryId{"UA"}}, // Terebovlia Railway Station
    {Coordinate{33.4814, 51.7642}, CountryId{"UA"}}, // Tereshenska
    {Coordinate{33.5344, 48.1786}, CountryId{"UA"}}, // Terny
    {Coordinate{36.3492, 49.8536}, CountryId{"UA"}}, // Q12160819
    {Coordinate{25.601, 49.5552}, CountryId{"UA"}}, // Ternopil Railway Station
    {Coordinate{29.5994, 50.6986}, CountryId{"UA"}}, // Teteriv
    {Coordinate{27.9478, 50.4733}, CountryId{"UA"}}, // Tetirka
    {Coordinate{29.0696, 50.8448}, CountryId{"UA"}}, // Tyshiv
    {Coordinate{28.667, 50.5375}, CountryId{"UA"}}, // Toporyshche
    {Coordinate{31.0762, 50.365}, CountryId{"UA"}}, // Travneva
    {Coordinate{31.3053, 47.7053}, CountryId{"UA"}}, // Trykratne train station
    {Coordinate{29.8322, 50.0098}, CountryId{"UA"}}, // Trylisy
    {Coordinate{30.7531, 50.1398}, CountryId{"UA"}}, // Tripillya-Dniprovske
    {Coordinate{37.5281, 49.1316}, CountryId{"UA"}}, // Q12162474
    {Coordinate{31.195, 50.7036}, CountryId{"UA"}}, // Trubizh
    {Coordinate{31.671, 48.8617}, CountryId{"UA"}}, // Turiia
    {Coordinate{28.4885, 49.1506}, CountryId{"UA"}}, // Tiushky
    {Coordinate{33.9264, 47.6328}, CountryId{"UA"}}, // Q12163177
    {Coordinate{30.2042, 48.7331}, CountryId{"UA"}}, // Uman
    {Coordinate{29.8283, 50.0378}, CountryId{"UA"}}, // Unava
    {Coordinate{28.5891, 50.8626}, CountryId{"UA"}}, // Ushomyr
    {Coordinate{29.9431, 50.0529}, CountryId{"UA"}}, // Fastiv 2nd
    {Coordinate{35.9492, 50.141}, CountryId{"UA"}}, // Q12165665
    {Coordinate{28.4092, 45.4397}, CountryId{"UA"}}, // Frycatzey
    {Coordinate{32.9958, 51.2028}, CountryId{"UA"}}, // Khalymonove
    {Coordinate{36.1813, 50.0262}, CountryId{"UA"}}, // Q12166913
    {Coordinate{29.3407, 49.9515}, CountryId{"UA"}}, // Kharliivka
    {Coordinate{36.1412, 49.9573}, CountryId{"UA"}}, // Khvylynka
    {Coordinate{35.6918, 49.923}, CountryId{"UA"}}, // Khvorostove
    {Coordinate{27.9819, 50.4633}, CountryId{"UA"}}, // Khodorivka
    {Coordinate{31.4931, 52.0297}, CountryId{"UA"}}, // Khorobychi
    {Coordinate{32.2681, 51.0851}, CountryId{"UA"}}, // Khoroshe Ozero
    {Coordinate{24.1747, 51.7039}, CountryId{"BY"}}, // Khatsislaw
    {Coordinate{27.2443, 50.1507}, CountryId{"UA"}}, // Khrolyn
    {Coordinate{29.8537, 50.637}, CountryId{"UA"}}, // Khutir Hai
    {Coordinate{26.9541, 50.2572}, CountryId{"UA"}}, // Tsvitokha
    {Coordinate{37.2696, 49.3083}, CountryId{"UA"}}, // Q12168763
    {Coordinate{36.2336, 48.1272}, CountryId{"UA"}}, // Chaplyne
    {Coordinate{33.3033, 47.9403}, CountryId{"UA"}}, // Q12169607
    {Coordinate{31.7587, 50.9704}, CountryId{"UA"}}, // Volodkova Divytsia
    {Coordinate{32.6223, 51.1266}, CountryId{"UA"}}, // Cheremushky
    {Coordinate{28.6513, 49.5261}, CountryId{"UA"}}, // Cherepashyntsi
    {Coordinate{26.9233, 49.5172}, CountryId{"UA"}}, // Q12169734
    {Coordinate{29.6191, 49.9661}, CountryId{"UA"}}, // Chernyavka
    {Coordinate{31.2489, 51.5197}, CountryId{"UA"}}, // Chernihiv-Pivnichnyi
    {Coordinate{28.9393, 50.8739}, CountryId{"UA"}}, // Chepovychi
    {Coordinate{26.7429, 49.4955}, CountryId{"UA"}}, // Chornyi Ostriv
    {Coordinate{38.4906, 48.3294}, CountryId{"UA"}}, // Q12170600
    {Coordinate{27.0117, 50.0278}, CountryId{"UA"}}, // Chotyrboky Railway Station
    {Coordinate{30.3544, 46.14}, CountryId{"UA"}}, // Shabo
    {Coordinate{28.7108, 50.9358}, CountryId{"UA"}}, // Shatrishche
    {Coordinate{27.0753, 50.1639}, CountryId{"UA"}}, // Shepetivka-Podilska
    {Coordinate{23.5549, 49.9701}, CountryId{"UA"}}, // Q12171997
    {Coordinate{30.3136, 50.2711}, CountryId{"UA"}}, // Shliakhova
    {Coordinate{33.4103, 47.9642}, CountryId{"UA"}}, // Shmakove
    {Coordinate{33.4689, 51.8633}, CountryId{"UA"}}, // Q12172245
    {Coordinate{28.6463, 48.6631}, CountryId{"UA"}}, // Shura
    {Coordinate{33.3944, 48.5944}, CountryId{"UA"}}, // Shchaslyva
    {Coordinate{29.3482, 50.7484}, CountryId{"UA"}}, // Shebzavod
    {Coordinate{30.7565, 50.1239}, CountryId{"UA"}}, // Sherbanivka
    {Coordinate{31.9447, 51.8142}, CountryId{"UA"}}, // Snovsk
    {Coordinate{28.3294, 50.3728}, CountryId{"UA"}}, // Yulianivka
    {Coordinate{33.3317, 50.4708}, CountryId{"UA"}}, // Yuskivtsi
    {Coordinate{35.1639, 46.6805}, CountryId{"UA"}}, // Yakymivka
    {Coordinate{30.7573, 50.4787}, CountryId{"UA"}}, // Yalynka
    {Coordinate{33.7447, 51.9119}, CountryId{"UA"}}, // Yampil
    {Coordinate{35.3564, 47.9081}, CountryId{"UA"}}, // Q12173803
    {Coordinate{25.5511, 52.1289}, CountryId{"BY"}}, // Janaŭ-Palieski train station
    {Coordinate{28.4461, 49.1248}, CountryId{"UA"}}, // Yaryshivka
    {Coordinate{33.8103, 45.1644}, CountryId{"UA"}}, // Q12173902
    {Coordinate{29.2703, 50.1247}, CountryId{"UA"}}, // Yaropovychi
    {Coordinate{12.9711, 50.7805}, CountryId{"DE"}}, // Einsiedel Hp Gymnasium train stop
    {Coordinate{31.2286, 50.7124}, CountryId{"UA"}}, // Yaroslavka
    {Coordinate{28.268, 48.9023}, CountryId{"UA"}}, // Yaroshenka
    {Coordinate{-0.1733, 51.6487}, CountryId{"GB"}}, // New Barnet railway station
    {Coordinate{7.27095, 46.2086}, CountryId{"CH"}}, // Ardon railway station
    {Coordinate{6.55933, 46.6877}, CountryId{"CH"}}, // Bavois railway station
    {Coordinate{7.00067, 46.2515}, CountryId{"CH"}}, // Bex railway station
    {Coordinate{7.2411, 46.1888}, CountryId{"CH"}}, // Chamoson-St-Pierre-de-Clages railway station
    {Coordinate{6.56816, 46.7101}, CountryId{"CH"}}, // Chavornay railway station
    {Coordinate{7.3051, 46.2161}, CountryId{"CH"}}, // Châteauneuf-Conthey railway station
    {Coordinate{7.12648, 46.1268}, CountryId{"CH"}}, // Charrat-Fully railway station
    {Coordinate{6.94875, 46.2713}, CountryId{"CH"}}, // Collombey railway station
    {Coordinate{6.55242, 46.6572}, CountryId{"CH"}}, // Eclépens railway station
    {Coordinate{6.60766, 46.7464}, CountryId{"CH"}}, // Ependes railway station
    {Coordinate{6.58066, 46.7277}, CountryId{"CH"}}, // Essert-Pittet railway station
    {Coordinate{7.74758, 46.3065}, CountryId{"CH"}}, // Gampel-Steg railway station
    {Coordinate{8.86577, 46.179}, CountryId{"CH"}}, // Gordola railway station
    {Coordinate{6.85347, 46.3859}, CountryId{"CH"}}, // Bouveret railway station
    {Coordinate{6.87947, 46.3632}, CountryId{"CH"}}, // Les Evouettes railway station
    {Coordinate{6.98556, 46.2414}, CountryId{"CH"}}, // Massongex railway station
    {Coordinate{8.37411, 47.045}, CountryId{"CH"}}, // Meggen Zentrum railway station
    {Coordinate{8.40906, 47.0677}, CountryId{"CH"}}, // Merlischachen railway station
    {Coordinate{8.38306, 47.0501}, CountryId{"CH"}}, // Meggen railway station
    {Coordinate{6.95523, 46.2556}, CountryId{"CH"}}, // Monthey railway station
    {Coordinate{7.80151, 46.3063}, CountryId{"CH"}}, // Raron railway station
    {Coordinate{7.21785, 46.1725}, CountryId{"CH"}}, // Riddes railway station
    {Coordinate{8.8864, 46.1753}, CountryId{"CH"}}, // Riazzino railway station
    {Coordinate{6.80616, 46.3922}, CountryId{"CH"}}, // St-Gingolph railway station
    {Coordinate{7.57819, 46.3092}, CountryId{"CH"}}, // Salgesch railway station
    {Coordinate{7.41957, 46.2515}, CountryId{"CH"}}, // St-Léonard railway station
    {Coordinate{7.17344, 46.1494}, CountryId{"CH"}}, // Saxon railway station
    {Coordinate{8.94338, 47.2252}, CountryId{"CH"}}, // Schmerikon railway station
    {Coordinate{8.85022, 46.1775}, CountryId{"CH"}}, // Tenero railway station
    {Coordinate{7.6996, 46.3093}, CountryId{"CH"}}, // Turtmann railway station
    {Coordinate{8.98069, 47.2243}, CountryId{"CH"}}, // Uznach railway station
    {Coordinate{6.91625, 46.315}, CountryId{"CH"}}, // Vionnaz railway station
    {Coordinate{6.89806, 46.3369}, CountryId{"CH"}}, // Vouvry railway station
    {Coordinate{6.64115, 46.7819}, CountryId{"CH"}}, // Yverdon-les-Bains railway station
    {Coordinate{11.4446, 48.3339}, CountryId{"DE"}}, // Röhrmoos Hp
    {Coordinate{46.8363, 48.2118}, CountryId{"RU"}}, // Q121819194
    {Coordinate{9.15706, 49.7935}, CountryId{"DE"}}, // Wörth (Main)
    {Coordinate{13.7967, 52.3922}, CountryId{"DE"}}, // Fangschleuse Tesla Süd railway halt
    {Coordinate{21.125, 55.786}, CountryId{"LT"}}, // Kalotė train station
    {Coordinate{-0.1667, 51.6379}, CountryId{"GB"}}, // Oakleigh Park railway station
    {Coordinate{-3.10947, 43.2104}, CountryId{"ES"}}, // Q12253834
    {Coordinate{-3.114, 43.2103}, CountryId{"ES"}}, // Q12253835
    {Coordinate{-3.07167, 43.2011}, CountryId{"ES"}}, // Q12254239
    {Coordinate{-3.18994, 43.1964}, CountryId{"ES"}}, // Q12254735
    {Coordinate{-3.15044, 43.2}, CountryId{"ES"}}, // Q12255418
    {Coordinate{-3.09531, 43.2091}, CountryId{"ES"}}, // Güeñes train station
    {Coordinate{-3.14481, 43.2039}, CountryId{"ES"}}, // Q12259360
    {Coordinate{-3.13872, 43.2109}, CountryId{"ES"}}, // Q12259496
    {Coordinate{-2.97203, 43.2554}, CountryId{"ES"}}, // Q12261355
    {Coordinate{-3.19742, 43.1901}, CountryId{"ES"}}, // La Calzada train station
    {Coordinate{-3.17056, 43.2034}, CountryId{"ES"}}, // Q12261741
    {Coordinate{-3.08264, 43.206}, CountryId{"ES"}}, // Q12261835
    {Coordinate{-3.02489, 43.2229}, CountryId{"ES"}}, // Q12266393
    {Coordinate{-2.97306, 43.2619}, CountryId{"ES"}}, // Q12266971
    {Coordinate{-3.0505, 43.2021}, CountryId{"ES"}}, // Q12267477
    {Coordinate{-3.1981, 43.2332}, CountryId{"ES"}}, // Q12268164
    {Coordinate{-3.13339, 43.2129}, CountryId{"ES"}}, // Zalla railway station
    {Coordinate{-3.016, 43.2333}, CountryId{"ES"}}, // Q12269216
    {Coordinate{-2.97406, 43.274}, CountryId{"ES"}}, // Zorrotza–Zorrozgoiti train station
    {Coordinate{25.682, 43.1398}, CountryId{"BG"}}, // Gorna Oryahovitsa Railway Station
    {Coordinate{8.42786, 49.5201}, CountryId{"DE"}}, // Ludwigshafen (Rhein) BASF Nord
    {Coordinate{27.4727, 42.491}, CountryId{"BG"}}, // Burgas Railway Station
    {Coordinate{10.4082, 57.5926}, CountryId{"DK"}}, // Aalbæk station
    {Coordinate{10.0522, 55.3831}, CountryId{"DK"}}, // Aarup Station
    {Coordinate{9.8456, 56.0526}, CountryId{"DK"}}, // Alken station
    {Coordinate{8.32977, 56.3907}, CountryId{"DK"}}, // Amstrup Station
    {Coordinate{9.86007, 56.7694}, CountryId{"DK"}}, // Arden station
    {Coordinate{8.26568, 56.5293}, CountryId{"DK"}}, // Armose Station
    {Coordinate{11.4994, 55.8086}, CountryId{"DK"}}, // Asnæs Station
    {Coordinate{10.1824, 56.0039}, CountryId{"DK"}}, // Assedrup Station
    {Coordinate{8.78818, 56.2652}, CountryId{"DK"}}, // Aulum Station
    {Coordinate{11.2153, 54.8289}, CountryId{"DK"}}, // Avnede Station
    {Coordinate{11.7022, 55.5458}, CountryId{"DK"}}, // Bagmarken Station
    {Coordinate{8.88932, 54.871}, CountryId{"DE"}}, // Süderlügum station
    {Coordinate{8.86318, 54.8388}, CountryId{"DE"}}, // Uphusum station
    {Coordinate{8.24167, 56.5476}, CountryId{"DK"}}, // Balleby Station
    {Coordinate{8.28306, 55.6358}, CountryId{"DK"}}, // Baunhøj Station
    {Coordinate{10.1981, 56.0569}, CountryId{"DK"}}, // Beder Station
    {Coordinate{8.40776, 56.8067}, CountryId{"DK"}}, // Bedsted Thy Station
    {Coordinate{8.33144, 55.6169}, CountryId{"DK"}}, // Billum railway station
    {Coordinate{9.02962, 56.1253}, CountryId{"DK"}}, // Birk Centerpark railway station
    {Coordinate{9.65855, 56.3742}, CountryId{"DK"}}, // Bjerringbro station
    {Coordinate{8.22296, 56.5208}, CountryId{"DK"}}, // Bonnet Station
    {Coordinate{9.27857, 56.1467}, CountryId{"DK"}}, // Bording railway station
    {Coordinate{8.64445, 55.9584}, CountryId{"DK"}}, // Borris Station
    {Coordinate{11.9722, 55.4944}, CountryId{"DK"}}, // Borup Station
    {Coordinate{8.46, 55.6238}, CountryId{"DK"}}, // Boulevarden Station
    {Coordinate{10.1056, 55.3733}, CountryId{"DK"}}, // Bred Station
    {Coordinate{12.5008, 55.7936}, CountryId{"DK"}}, // Brede Station
    {Coordinate{8.82309, 55.0568}, CountryId{"DK"}}, // Bredebro Station
    {Coordinate{9.65917, 55.6664}, CountryId{"DK"}}, // Brejning Station
    {Coordinate{12.279, 55.8934}, CountryId{"DK"}}, // Brødeskov Station
    {Coordinate{9.9423, 57.2704}, CountryId{"DK"}}, // Brønderslev station
    {Coordinate{8.7408, 55.1947}, CountryId{"DK"}}, // Brøns Station
    {Coordinate{9.01603, 55.4827}, CountryId{"DK"}}, // Brørup Station
    {Coordinate{8.42773, 56.3677}, CountryId{"DK"}}, // Bur railway station
    {Coordinate{8.30806, 56.412}, CountryId{"DK"}}, // Bækmarksbro Station
    {Coordinate{9.65207, 55.6422}, CountryId{"DK"}}, // Børkop Station
    {Coordinate{11.4996, 55.5339}, CountryId{"DK"}}, // Dianalund Station
    {Coordinate{12.3875, 56.0978}, CountryId{"DK"}}, // Dronningmølle station
    {Coordinate{12.2623, 56.0093}, CountryId{"DK"}}, // Duemose Station
    {Coordinate{8.29818, 55.7}, CountryId{"DK"}}, // Dyreby railway station
    {Coordinate{11.9423, 55.9852}, CountryId{"DK"}}, // Dyssekilde Station
    {Coordinate{8.80781, 55.1175}, CountryId{"DK"}}, // Døstrup Sønderjylland Station
    {Coordinate{10.1927, 56.0499}, CountryId{"DK"}}, // Egelund Trinbræt
    {Coordinate{12.19, 55.4236}, CountryId{"DK"}}, // Egøje Station
    {Coordinate{9.93, 55.4287}, CountryId{"DK"}}, // Ejby Station
    {Coordinate{9.9776, 57.5721}, CountryId{"DK"}}, // Emmersbæk halt
    {Coordinate{9.35172, 56.1678}, CountryId{"DK"}}, // Engesvang Station
    {Coordinate{11.8854, 54.8561}, CountryId{"DK"}}, // Eskilstrup Station
    {Coordinate{12.5497, 55.9958}, CountryId{"DK"}}, // Espergærde Station
    {Coordinate{12.162, 55.2171}, CountryId{"DK"}}, // Faxe Ladeplads Station
    {Coordinate{12.1368, 55.2423}, CountryId{"DK"}}, // Faxe Syd Station
    {Coordinate{12.07, 55.6222}, CountryId{"DK"}}, // Festivalpladsen T
    {Coordinate{12.3547, 56.0982}, CountryId{"DK"}}, // Firhøj station
    {Coordinate{12.2984, 56.1163}, CountryId{"DK"}}, // Fjellenstrup railway halt
    {Coordinate{12.4068, 55.9772}, CountryId{"DK"}}, // Fredensborg station
    {Coordinate{12.0195, 55.9686}, CountryId{"DK"}}, // Frederiksværk station
    {Coordinate{8.48667, 55.6278}, CountryId{"DK"}}, // Frisvadvej Station
    {Coordinate{10.3775, 55.3697}, CountryId{"DK"}}, // Fruens Bøge Station
    {Coordinate{12.4974, 55.785}, CountryId{"DK"}}, // Fuglevad Station
    {Coordinate{8.26171, 56.4537}, CountryId{"DK"}}, // Fåre Station
    {Coordinate{11.4697, 55.7881}, CountryId{"DK"}}, // Fårevejle Station
    {Coordinate{12.0994, 55.5728}, CountryId{"DK"}}, // Gadstrup Station
    {Coordinate{9.97444, 55.3961}, CountryId{"DK"}}, // Gelsted railway station
    {Coordinate{12.3088, 56.1229}, CountryId{"DK"}}, // Gilleleje East halt
    {Coordinate{12.3025, 56.1234}, CountryId{"DK"}}, // Gilleleje station
    {Coordinate{11.5469, 55.7297}, CountryId{"DK"}}, // Gislinge Station
    {Coordinate{8.45729, 55.5096}, CountryId{"DK"}}, // Gjesing railway station
    {Coordinate{11.6956, 55.3536}, CountryId{"DK"}}, // Glumsø Station
    {Coordinate{12.0972, 56.0599}, CountryId{"DK"}}, // Godhavn Station
    {Coordinate{8.74116, 55.3974}, CountryId{"DK"}}, // Gredstedbro Station
    {Coordinate{12.3018, 55.9874}, CountryId{"DK"}}, // Gribsø Station
    {Coordinate{12.1025, 55.9156}, CountryId{"DK"}}, // Grimstrup Halt
    {Coordinate{12.2006, 55.3803}, CountryId{"DK"}}, // Grubberholm Station
    {Coordinate{9.5939, 54.9189}, CountryId{"DK"}}, // Gråsten Station
    {Coordinate{11.7651, 54.7741}, CountryId{"DK"}}, // Grænge Station
    {Coordinate{12.2868, 56.0726}, CountryId{"DK"}}, // Græsted station
    {Coordinate{12.2956, 56.0631}, CountryId{"DK"}}, // Græsted South railway halt
    {Coordinate{12.3703, 55.9526}, CountryId{"DK"}}, // Grønholt railway halt
    {Coordinate{12.6112, 56.0404}, CountryId{"DK"}}, // Grønnehave station
    {Coordinate{8.44036, 55.5361}, CountryId{"DK"}}, // Guldager train station
    {Coordinate{10.126, 56.1116}, CountryId{"DK"}}, // Gunnar Clausens Vej Station
    {Coordinate{10.1542, 56.0895}, CountryId{"DK"}}, // Gunnestrup Station
    {Coordinate{8.61167, 55.7656}, CountryId{"DK"}}, // Gårde railway station
    {Coordinate{8.80117, 55.4696}, CountryId{"DK"}}, // Gørding Station
    {Coordinate{12.2025, 55.8867}, CountryId{"DK"}}, // Gørløse Station
    {Coordinate{10.0478, 56.3272}, CountryId{"DK"}}, // Hadsten Station
    {Coordinate{9.06325, 56.1318}, CountryId{"DK"}}, // Hammerum station
    {Coordinate{12.0009, 55.9753}, CountryId{"DK"}}, // Hanehoved Station
    {Coordinate{8.17883, 56.6205}, CountryId{"DK"}}, // Harboøre Station
    {Coordinate{11.9609, 55.3294}, CountryId{"DK"}}, // Haslev Station
    {Coordinate{12.1169, 55.5436}, CountryId{"DK"}}, // Havdrup Station
    {Coordinate{12.1975, 55.6486}, CountryId{"DK"}}, // Hedehusene railway station
    {Coordinate{9.69888, 55.7685}, CountryId{"DK"}}, // Hedensted Station
    {Coordinate{8.2868, 56.144}, CountryId{"DK"}}, // Hee railway station
    {Coordinate{12.5543, 56.0665}, CountryId{"DK"}}, // Hellebæk halt
    {Coordinate{12.2056, 56.0231}, CountryId{"DK"}}, // Helsinge Station
    {Coordinate{8.30441, 55.7104}, CountryId{"DK"}}, // Henne railway station
    {Coordinate{12.1372, 55.4177}, CountryId{"DK"}}, // Herfølge Station
    {Coordinate{8.94435, 56.1236}, CountryId{"DK"}}, // Herning Messecenter railway station
    {Coordinate{9.96587, 57.4732}, CountryId{"DK"}}, // Herregårdsparken halt
    {Coordinate{12.2158, 55.3725}, CountryId{"DK"}}, // Himlingøje Station
    {Coordinate{10.0596, 56.2631}, CountryId{"DK"}}, // Hinnerup Station
    {Coordinate{10.3927, 55.3582}, CountryId{"DK"}}, // Hjallese Station
    {Coordinate{8.63979, 56.439}, CountryId{"DK"}}, // Hjerm station
    {Coordinate{10.2688, 56.2447}, CountryId{"DK"}}, // Hjortshøj station
    {Coordinate{12.1178, 56.0595}, CountryId{"DK"}}, // Holløse Station
    {Coordinate{11.8489, 55.261}, CountryId{"DK"}}, // Holme-Olstrup Station
    {Coordinate{8.91413, 55.4848}, CountryId{"DK"}}, // Holsted Station
    {Coordinate{12.4595, 56.0893}, CountryId{"DK"}}, // Hornbæk station
    {Coordinate{9.97255, 57.5594}, CountryId{"DK"}}, // Horne station
    {Coordinate{12.4356, 56.0899}, CountryId{"DK"}}, // Horneby Sand halt
    {Coordinate{10.3136, 56.3206}, CountryId{"DK"}}, // Hornslet Station
    {Coordinate{10.2556, 56.2342}, CountryId{"DK"}}, // Hovmarken railway halt
    {Coordinate{12.5331, 55.9639}, CountryId{"DK"}}, // Humlebæk station
    {Coordinate{8.55237, 56.5403}, CountryId{"DK"}}, // Humlum station
    {Coordinate{11.8461, 55.9658}, CountryId{"DK"}}, // Hundested Havn Station
    {Coordinate{8.41804, 56.7512}, CountryId{"DK"}}, // Hurup Thy station
    {Coordinate{11.8591, 55.5953}, CountryId{"DK"}}, // Hvalsø Station
    {Coordinate{8.52653, 56.6498}, CountryId{"DK"}}, // Hvidbjerg station
    {Coordinate{8.73018, 55.2745}, CountryId{"DK"}}, // Hviding Station
    {Coordinate{8.40069, 55.6263}, CountryId{"DK"}}, // Hyllerslev Station
    {Coordinate{12.2275, 55.3514}, CountryId{"DK"}}, // Hårlev Station
    {Coordinate{13.5415, 55.9369}, CountryId{"SE"}}, // Höör Station
    {Coordinate{11.6037, 55.9106}, CountryId{"DK"}}, // Højby Sjælland Station
    {Coordinate{10.4342, 55.3298}, CountryId{"DK"}}, // Højby (Fyn) railway station
    {Coordinate{9.11076, 56.5491}, CountryId{"DK"}}, // Højslev station
    {Coordinate{12.594, 56.0472}, CountryId{"DK"}}, // Højstrup halt
    {Coordinate{8.49052, 56.8508}, CountryId{"DK"}}, // Hørdum station
    {Coordinate{10.0378, 56.0822}, CountryId{"DK"}}, // Hørning station
    {Coordinate{11.4562, 55.7526}, CountryId{"DK"}}, // Hørve Station
    {Coordinate{9.15528, 56.1448}, CountryId{"DK"}}, // Ikast railway station
    {Coordinate{8.37417, 55.6228}, CountryId{"DK"}}, // Janderup railway station
    {Coordinate{8.30167, 55.6647}, CountryId{"DK"}}, // Jegum Station
    {Coordinate{9.4199, 55.754}, CountryId{"DK"}}, // Jelling railway station
    {Coordinate{10.4171, 57.5323}, CountryId{"DK"}}, // Jerup station
    {Coordinate{11.398, 55.6603}, CountryId{"DK"}}, // Jyderup Station
    {Coordinate{12.2861, 55.9975}, CountryId{"DK"}}, // Kagerup station
    {Coordinate{12.4686, 56.0831}, CountryId{"DK"}}, // Karinebæk halt
    {Coordinate{12.1958, 55.307}, CountryId{"DK"}}, // Karise Station
    {Coordinate{15.5852, 56.1668}, CountryId{"SE"}}, // Karlskrona central station
    {Coordinate{9.81111, 55.4758}, CountryId{"DK"}}, // Kauslunde Station
    {Coordinate{8.85212, 56.0323}, CountryId{"DK"}}, // Kibæk Station
    {Coordinate{12.286, 55.752}, CountryId{"DK"}}, // Kildedal station
    {Coordinate{12.4242, 56.0925}, CountryId{"DK"}}, // Kildekrog halt
    {Coordinate{8.22028, 56.565}, CountryId{"DK"}}, // Klinkby Station
    {Coordinate{9.39778, 54.9351}, CountryId{"DK"}}, // Kliplev Station
    {Coordinate{12.3253, 55.3464}, CountryId{"DK"}}, // Klippinge Station
    {Coordinate{11.5535, 55.6649}, CountryId{"DK"}}, // Knabstrup Station
    {Coordinate{12.5022, 55.9036}, CountryId{"DK"}}, // Kokkedal station
    {Coordinate{10.5876, 56.3629}, CountryId{"DK"}}, // Kolind station
    {Coordinate{10.1742, 56.1353}, CountryId{"DK"}}, // Kongsvang railway halt
    {Coordinate{11.7648, 55.5738}, CountryId{"DK"}}, // Kr. Eskilstrup Station
    {Coordinate{12.3933, 55.9678}, CountryId{"DK"}}, // Kratbjerg railway halt
    {Coordinate{12.047, 55.9348}, CountryId{"DK"}}, // Kregme Station
    {Coordinate{10.4128, 57.4719}, CountryId{"DK"}}, // Kvissel station
    {Coordinate{12.5029, 55.9906}, CountryId{"DK"}}, // Kvistgård station
    {Coordinate{9.97602, 57.4546}, CountryId{"DK"}}, // Kvægtorvet halt
    {Coordinate{10.5189, 55.1781}, CountryId{"DK"}}, // Kværndrup Station
    {Coordinate{12.1726, 55.4996}, CountryId{"DK"}}, // Køge Nord Station
    {Coordinate{12.999, 56.5022}, CountryId{"SE"}}, // Laholm railway station
    {Coordinate{12.4511, 55.9812}, CountryId{"DK"}}, // Langerød railway halt
    {Coordinate{10.5867, 55.3617}, CountryId{"DK"}}, // Langeskov Station
    {Coordinate{9.71761, 56.1247}, CountryId{"DK"}}, // Laven station
    {Coordinate{11.9714, 55.6046}, CountryId{"DK"}}, // Lejre Station
    {Coordinate{8.3859, 56.025}, CountryId{"DK"}}, // Lem railway station
    {Coordinate{8.29972, 56.5469}, CountryId{"DK"}}, // Lemvig Station
    {Coordinate{12.1403, 55.5114}, CountryId{"DK"}}, // Lille Skensved Station
    {Coordinate{9.97633, 57.5852}, CountryId{"DK"}}, // Lilleheden halt
    {Coordinate{9.90528, 57.0667}, CountryId{"DK"}}, // Lindholm station
    {Coordinate{12.0342, 55.9467}, CountryId{"DK"}}, // Kregme Halt
    {Coordinate{12.2189, 55.3361}, CountryId{"DK"}}, // Lille Linde Station
    {Coordinate{11.8698, 55.1104}, CountryId{"DK"}}, // Lundby Station
    {Coordinate{8.36401, 55.7562}, CountryId{"DK"}}, // Lunde railway station
    {Coordinate{12.5061, 55.7739}, CountryId{"DK"}}, // Lyngby Local Station
    {Coordinate{8.45073, 56.6644}, CountryId{"DK"}}, // Lyngs station
    {Coordinate{10.2347, 56.2309}, CountryId{"DK"}}, // Lystrup Station
    {Coordinate{8.35292, 55.7294}, CountryId{"DK"}}, // Løftgård railway station
    {Coordinate{10.3173, 56.2758}, CountryId{"DK"}}, // Løgten station
    {Coordinate{10.1913, 56.0376}, CountryId{"DK"}}, // Malling Station
    {Coordinate{12.6023, 56.0433}, CountryId{"DK"}}, // Marienlyst halt
    {Coordinate{11.9717, 55.9916}, CountryId{"DK"}}, // Melby Station
    {Coordinate{12.3175, 55.7475}, CountryId{"DK"}}, // Måløv station
    {Coordinate{10.1646, 56.0687}, CountryId{"DK"}}, // Mårslet Station
    {Coordinate{12.317, 56.0307}, CountryId{"DK"}}, // Mårum station
    {Coordinate{10.1543, 56.0727}, CountryId{"DK"}}, // Mølleparken Station
    {Coordinate{12.5319, 56.002}, CountryId{"DK"}}, // Mørdrup railway halt
    {Coordinate{10.3758, 56.3393}, CountryId{"DK"}}, // Mørke station
    {Coordinate{11.5021, 55.6545}, CountryId{"DK"}}, // Mørkøv Station
    {Coordinate{8.18694, 56.5656}, CountryId{"DK"}}, // Nejrup Station
    {Coordinate{12.5064, 55.9336}, CountryId{"DK"}}, // Nivå Station
    {Coordinate{11.6067, 55.8831}, CountryId{"DK"}}, // Nr. Asmindrup Station
    {Coordinate{11.5944, 55.7287}, CountryId{"DK"}}, // Ny Hagested Station
    {Coordinate{11.6556, 55.9219}, CountryId{"DK"}}, // Nyled Station
    {Coordinate{11.6525, 55.5423}, CountryId{"DK"}}, // Nyrup Station
    {Coordinate{12.5282, 55.8139}, CountryId{"DK"}}, // Nærum Station
    {Coordinate{11.7863, 55.2482}, CountryId{"DK"}}, // Næstved Nord Station
    {Coordinate{12.5126, 55.7708}, CountryId{"DK"}}, // Nørgaardsvej Station
    {Coordinate{11.8855, 54.8965}, CountryId{"DK"}}, // Nørre Alslev Station
    {Coordinate{9.87111, 55.46}, CountryId{"DK"}}, // Nørre Åby Station
    {Coordinate{10.1516, 56.092}, CountryId{"DK"}}, // Nørrevænget Station
    {Coordinate{8.54696, 56.5826}, CountryId{"DK"}}, // Oddesund North station
    {Coordinate{8.28368, 55.6259}, CountryId{"DK"}}, // Oksbøl railway station
    {Coordinate{13.9955, 56.381}, CountryId{"SE"}}, // Osby Station
    {Coordinate{8.3445, 55.7172}, CountryId{"DK"}}, // Outrup railway station
    {Coordinate{10.1518, 55.9784}, CountryId{"DK"}}, // Q12331004
    {Coordinate{10.486, 55.2833}, CountryId{"DK"}}, // Pederstrup Station
    {Coordinate{12.3014, 56.1008}, CountryId{"DK"}}, // Pårup railway halt
    {Coordinate{8.21028, 56.4889}, CountryId{"DK"}}, // Ramme Station
    {Coordinate{12.52, 55.8022}, CountryId{"DK"}}, // Ravnholm Station
    {Coordinate{11.6126, 55.6775}, CountryId{"DK"}}, // Regstrup Station
    {Coordinate{8.732, 55.2305}, CountryId{"DK"}}, // Rejsby Station
    {Coordinate{8.77587, 55.3397}, CountryId{"DK"}}, // Ribe Nørremark Station
    {Coordinate{10.4451, 57.5049}, CountryId{"DK"}}, // Rimmen halt
    {Coordinate{10.1472, 56.1169}, CountryId{"DK"}}, // Rosenhøj Station
    {Coordinate{10.1541, 55.9833}, CountryId{"DK"}}, // Rude Havvej railway station
    {Coordinate{10.4872, 55.1986}, CountryId{"DK"}}, // Rudme Station
    {Coordinate{11.3752, 55.5399}, CountryId{"DK"}}, // Ruds Vedby Station
    {Coordinate{9.75889, 56.0908}, CountryId{"DK"}}, // Ry station
    {Coordinate{11.3721, 54.7851}, CountryId{"DK"}}, // Ryde Station
    {Coordinate{12.3788, 55.2548}, CountryId{"DK"}}, // Rødvig Station
    {Coordinate{8.19468, 56.6566}, CountryId{"DK"}}, // Rønland Station
    {Coordinate{11.6353, 54.7965}, CountryId{"DK"}}, // Sakskøbing Station
    {Coordinate{12.3219, 56.0545}, CountryId{"DK"}}, // Saltrup railway halt
    {Coordinate{12.4849, 56.0769}, CountryId{"DK"}}, // Saunte station
    {Coordinate{8.7336, 55.435}, CountryId{"DK"}}, // Sejstrup Station
    {Coordinate{8.57717, 55.6656}, CountryId{"DK"}}, // Sig railway station
    {Coordinate{10.202, 57.4702}, CountryId{"DK"}}, // Sindal station
    {Coordinate{8.28389, 56.4378}, CountryId{"DK"}}, // Sinkbæk Station
    {Coordinate{8.58804, 56.9519}, CountryId{"DK"}}, // Sjørring station
    {Coordinate{10.1411, 55.3661}, CountryId{"DK"}}, // Skalbjerg Station
    {Coordinate{11.449, 55.5379}, CountryId{"DK"}}, // Skellebjerg Station
    {Coordinate{12.5131, 56.0783}, CountryId{"DK"}}, // Skibstrup halt
    {Coordinate{12.5717, 55.8236}, CountryId{"DK"}}, // Skodsborg Station
    {Coordinate{10.2131, 56.1571}, CountryId{"DK"}}, // Skolebakken Station
    {Coordinate{8.77167, 55.1586}, CountryId{"DK"}}, // Skærbæk Station
    {Coordinate{12.1497, 55.9074}, CountryId{"DK"}}, // Skævinge Station
    {Coordinate{10.3031, 56.2618}, CountryId{"DK"}}, // Skødstrup Station
    {Coordinate{9.88722, 56.8358}, CountryId{"DK"}}, // Skørping station
    {Coordinate{12.311, 55.9426}, CountryId{"DK"}}, // Slotspavillonen Station
    {Coordinate{8.52715, 56.8921}, CountryId{"DK"}}, // Snedsted station
    {Coordinate{11.6035, 55.8975}, CountryId{"DK"}}, // Sommerland Sjælland Station
    {Coordinate{8.46083, 55.4925}, CountryId{"DK"}}, // Spangsbjerg railway station
    {Coordinate{11.7113, 55.5449}, CountryId{"DK"}}, // St. Merløse Station
    {Coordinate{11.5913, 55.5391}, CountryId{"DK"}}, // Stenlille Station
    {Coordinate{10.5094, 55.1311}, CountryId{"DK"}}, // Stenstrup Station
    {Coordinate{10.5151, 55.1203}, CountryId{"DK"}}, // Stenstrup Syd Station
    {Coordinate{9.15016, 56.4874}, CountryId{"DK"}}, // Stoholm station
    {Coordinate{12.386, 55.3098}, CountryId{"DK"}}, // Store Heddinge Station
    {Coordinate{8.16056, 56.569}, CountryId{"DK"}}, // Strande Station
    {Coordinate{8.91058, 56.0917}, CountryId{"DK"}}, // Studsgård railway station
    {Coordinate{12.3189, 56.1119}, CountryId{"DK"}}, // Stæremosen halt
    {Coordinate{9.84389, 56.8919}, CountryId{"DK"}}, // Støvring station
    {Coordinate{11.2917, 55.6523}, CountryId{"DK"}}, // Svebølle Station
    {Coordinate{9.63667, 56.1328}, CountryId{"DK"}}, // Svejbæk Station
    {Coordinate{10.5819, 55.0558}, CountryId{"DK"}}, // Svendborg Vest Station
    {Coordinate{11.4675, 55.7234}, CountryId{"DK"}}, // Svinninge Station
    {Coordinate{12.3339, 56.1005}, CountryId{"DK"}}, // Søborg halt
    {Coordinate{11.2702, 54.811}, CountryId{"DK"}}, // Søllested Station
    {Coordinate{9.95113, 57.5252}, CountryId{"DK"}}, // Sønderby halt
    {Coordinate{8.52028, 55.9103}, CountryId{"DK"}}, // Tarm railway station
    {Coordinate{9.96302, 57.4601}, CountryId{"DK"}}, // Teglgårdsvej halt
    {Coordinate{8.20694, 56.6981}, CountryId{"DK"}}, // Thyborøn Kirke Station
    {Coordinate{12.0778, 56.0593}, CountryId{"DK"}}, // Tisvildeleje station
    {Coordinate{8.5981, 55.7167}, CountryId{"DK"}}, // Tistrup railway station
    {Coordinate{12.1429, 55.2833}, CountryId{"DK"}}, // Tokkerup Station
    {Coordinate{10.2283, 56.2057}, CountryId{"DK"}}, // Torsøvej Station
    {Coordinate{10.1357, 56.0967}, CountryId{"DK"}}, // Tranbjerg Station
    {Coordinate{12.1319, 55.6478}, CountryId{"DK"}}, // Trekroner Station
    {Coordinate{12.0759, 55.3732}, CountryId{"DK"}}, // Tureby Station
    {Coordinate{8.8605, 54.9333}, CountryId{"DK"}}, // Tønder station
    {Coordinate{9.79271, 56.3954}, CountryId{"DK"}}, // Ulstrup station
    {Coordinate{8.47222, 55.6121}, CountryId{"DK"}}, // Varde Kaserne station
    {Coordinate{8.47639, 55.6246}, CountryId{"DK"}}, // Varde Vest station
    {Coordinate{8.50056, 55.6314}, CountryId{"DK"}}, // Varde Nord station
    {Coordinate{12.2801, 55.3524}, CountryId{"DK"}}, // Varpelev Station
    {Coordinate{9.53703, 55.7149}, CountryId{"DK"}}, // Vejle Sygehus railway station
    {Coordinate{10.2374, 56.1942}, CountryId{"DK"}}, // Vestre Strandallé railway halt
    {Coordinate{11.8731, 55.9603}, CountryId{"DK"}}, // Vibehus Halt
    {Coordinate{12.5638, 55.7063}, CountryId{"DK"}}, // Vibenshus Runddel station
    {Coordinate{9.9476, 57.5019}, CountryId{"DK"}}, // Vidstrup station
    {Coordinate{11.5822, 55.8526}, CountryId{"DK"}}, // Vig Station
    {Coordinate{8.76859, 56.198}, CountryId{"DK"}}, // Vildbjerg Railway Station
    {Coordinate{10.1791, 56.064}, CountryId{"DK"}}, // Vilhelmsborg Station
    {Coordinate{11.7385, 55.6669}, CountryId{"DK"}}, // Vipperød Station
    {Coordinate{8.39871, 56.7143}, CountryId{"DK"}}, // Ydby station
    {Coordinate{10.4658, 55.3014}, CountryId{"DK"}}, // Årslev railway station
    {Coordinate{11.8361, 54.7597}, CountryId{"DK"}}, // Ø. Toreby Station
    {Coordinate{8.62274, 55.811}, CountryId{"DK"}}, // Ølgod railway station
    {Coordinate{10.1331, 56.1144}, CountryId{"DK"}}, // Øllegårdsvej Station
    {Coordinate{12.0731, 55.923}, CountryId{"DK"}}, // Ølsted train station
    {Coordinate{12.1626, 56.0557}, CountryId{"DK"}}, // Ørby Station
    {Coordinate{12.51, 55.7998}, CountryId{"DK"}}, // Ørholm Station
    {Coordinate{10.2163, 56.1628}, CountryId{"DK"}}, // Østbanetorvet Station
    {Coordinate{11.9139, 55.9769}, CountryId{"DK"}}, // Østerbjerg Station
    {Coordinate{12.4693, 55.699}, CountryId{"DK"}}, // Islev station
    {Coordinate{8.21456, 56.704}, CountryId{"DK"}}, // Thyborøn Station
    {Coordinate{10.3135, 57.4858}, CountryId{"DK"}}, // Tolne station
    {Coordinate{9.94947, 57.5327}, CountryId{"DK"}}, // Tornby station
    {Coordinate{8.86111, 54.9389}, CountryId{"DK"}}, // Tønder Nord Station
    {Coordinate{8.54153, 56.6123}, CountryId{"DK"}}, // Uglev station
    {Coordinate{8.32515, 56.2718}, CountryId{"DK"}}, // Ulfborg railway station
    {Coordinate{12.1922, 55.4003}, CountryId{"DK"}}, // Vallø Station
    {Coordinate{12.136, 56.0627}, CountryId{"DK"}}, // Vejby Station
    {Coordinate{12.0244, 55.5495}, CountryId{"DK"}}, // Viby Sjælland Station
    {Coordinate{8.14328, 56.5773}, CountryId{"DK"}}, // Victoria Street Station
    {Coordinate{8.78315, 56.4828}, CountryId{"DK"}}, // Vinderup station
    {Coordinate{8.14847, 56.6015}, CountryId{"DK"}}, // Vrist Station
    {Coordinate{9.9421, 57.3546}, CountryId{"DK"}}, // Vrå station
    {Coordinate{14.1368, 56.5509}, CountryId{"SE"}}, // Älmhult railway station
    {Coordinate{26.4223, 58.2248}, CountryId{"EE"}}, // Elva railway station
    {Coordinate{26.3999, 58.7476}, CountryId{"EE"}}, // Jõgeva railway station
    {Coordinate{24.6856, 59.2383}, CountryId{"EE"}}, // Kiisa railway station
    {Coordinate{24.9987, 58.7938}, CountryId{"EE"}}, // Q12367397
    {Coordinate{25.0082, 58.8671}, CountryId{"EE"}}, // Lelle railway station
    {Coordinate{24.7231, 59.3875}, CountryId{"EE"}}, // Liiva railway station
    {Coordinate{24.7872, 59.1153}, CountryId{"EE"}}, // Q12368930
    {Coordinate{25.5416, 58.6656}, CountryId{"EE"}}, // Q12371442
    {Coordinate{27.0913, 58.07}, CountryId{"EE"}}, // Põlva railway station
    {Coordinate{24.6765, 59.3009}, CountryId{"EE"}}, // Saku railway station
    {Coordinate{25.5371, 58.4875}, CountryId{"EE"}}, // Sürgavere railway station
    {Coordinate{24.7459, 59.4127}, CountryId{"EE"}}, // Tallinn-Väike
    {Coordinate{25.4242, 58.8047}, CountryId{"EE"}}, // Türi railway station
    {Coordinate{24.7135, 59.2009}, CountryId{"EE"}}, // Q12378648
    {Coordinate{25.5617, 58.6294}, CountryId{"EE"}}, // Võhma railway station
    {Coordinate{27.0234, 57.8273}, CountryId{"EE"}}, // Võru railway station
    {Coordinate{74.6375, 26.4566}, CountryId{"IN"}}, // Ajmer Junction railway station
    {Coordinate{80.8415, 26.7744}, CountryId{"IN"}}, // Amausi railway station
    {Coordinate{76.8287, 30.3382}, CountryId{"IN"}}, // Ambala Cantt Junction railway station
    {Coordinate{76.3225, 9.48376}, CountryId{"IN"}}, // Alappuzha railway station
    {Coordinate{83.1606, 26.0386}, CountryId{"IN"}}, // Azamgarh railway station
    {Coordinate{78.536, 19.6805}, CountryId{"IN"}}, // Adilabad railway station
    {Coordinate{81.8288, 25.4462}, CountryId{"IN"}}, // Prayagraj Junction Railway Station
    {Coordinate{85.2173, 25.1386}, CountryId{"IN"}}, // Islampur railway station
    {Coordinate{73.6996, 24.5669}, CountryId{"IN"}}, // Udaipur City railway station
    {Coordinate{75.1549, 32.9266}, CountryId{"IN"}}, // Udhampur railway station
    {Coordinate{76.2757, 31.4788}, CountryId{"IN"}}, // Una Himachal railway station
    {Coordinate{78.2875, 30.1072}, CountryId{"IN"}}, // Rishikesh railway station
    {Coordinate{69.0738, 22.471}, CountryId{"IN"}}, // Okha railway station
    {Coordinate{77.5425, 8.08803}, CountryId{"IN"}}, // Kanyakumari railway station
    {Coordinate{82.2329, 16.967}, CountryId{"IN"}}, // Kakinada Town railway station
    {Coordinate{82.2401, 16.9552}, CountryId{"IN"}}, // Kakinada Port railway station
    {Coordinate{91.6907, 26.1571}, CountryId{"IN"}}, // Kamakhya Junction railway station
    {Coordinate{76.9318, 30.8377}, CountryId{"IN"}}, // Kalka railway station
    {Coordinate{88.3304, 25.6393}, CountryId{"IN"}}, // Kaliyaganj railway station
    {Coordinate{78.646, 27.8019}, CountryId{"IN"}}, // Kasganj Junction railway station
    {Coordinate{77.1451, 28.6469}, CountryId{"IN"}}, // Kirti Nagar railway station
    {Coordinate{79.3886, 10.953}, CountryId{"IN"}}, // Kumbakonam railway station
    {Coordinate{78.0327, 15.8337}, CountryId{"IN"}}, // Kurnool railway station
    {Coordinate{78.5212, 29.7429}, CountryId{"IN"}}, // Kotdwara railway station
    {Coordinate{82.713, 22.3376}, CountryId{"IN"}}, // Korba railway station
    {Coordinate{82.7194, 18.7922}, CountryId{"IN"}}, // Koraput railway station
    {Coordinate{76.5968, 8.88659}, CountryId{"IN"}}, // Kollam Junction railway station
    {Coordinate{79.89, 24.797}, CountryId{"IN"}}, // Khajuraho railway station
    {Coordinate{75.6425, 15.437}, CountryId{"IN"}}, // Gadag Junction railway station
    {Coordinate{77.4311, 28.6497}, CountryId{"IN"}}, // Ghaziabad railway station
    {Coordinate{83.3819, 26.76}, CountryId{"IN"}}, // Gorakhpur Junction railway station
    {Coordinate{16.3279, 48.1651}, CountryId{"AT"}}, // Tscherttegasse
    {Coordinate{48.8942, 55.8161}, CountryId{"RU"}}, // Yüdin
    {Coordinate{83.1544, 20.2844}, CountryId{"IN"}}, // Titlagarh railway station
    {Coordinate{83.6021, 25.5717}, CountryId{"IN"}}, // Tarighat railway station
    {Coordinate{77.708, 8.73636}, CountryId{"IN"}}, // Tirunelveli Junction railway station
    {Coordinate{77.238, 28.6276}, CountryId{"IN"}}, // Tilak Bridge railway station
    {Coordinate{95.3341, 27.4797}, CountryId{"IN"}}, // New Tinsukia railway station
    {Coordinate{77.1714, 28.6673}, CountryId{"IN"}}, // Daya basti railway station
    {Coordinate{81.88, 25.4426}, CountryId{"IN"}}, // Daraganj railway station
    {Coordinate{77.1436, 28.6283}, CountryId{"IN"}}, // Indrapuri railway station
    {Coordinate{77.2013, 28.6647}, CountryId{"IN"}}, // Delhi Kishanganj railway station
    {Coordinate{77.438, 28.6744}, CountryId{"IN"}}, // Naya Ghaziabad railway station
    {Coordinate{81.86, 25.3931}, CountryId{"IN"}}, // Naini railway station
    {Coordinate{77.1563, 28.66}, CountryId{"IN"}}, // Patel Nagar railway station
    {Coordinate{77.0929, 28.5857}, CountryId{"IN"}}, // Palam railway station
    {Coordinate{81.7416, 25.4449}, CountryId{"IN"}}, // Bamhrauli railway station
    {Coordinate{80.9614, 26.8686}, CountryId{"IN"}}, // Badshahnagar railway station
    {Coordinate{86.9768, 25.2419}, CountryId{"IN"}}, // Bhagalpur Junction railway station
    {Coordinate{73.9707, 15.2679}, CountryId{"IN"}}, // Madgaon Junction railway station
    {Coordinate{3.61524, 51.1544}, CountryId{"BE"}}, // Waarschoot railway station
    {Coordinate{72.8386, 18.9524}, CountryId{"IN"}}, // Masjid railway station
    {Coordinate{3.57417, 51.1814}, CountryId{"BE"}}, // Eeklo railway station
    {Coordinate{77.6751, 28.9776}, CountryId{"IN"}}, // Meerut City railway station
    {Coordinate{77.5717, 28.8279}, CountryId{"IN"}}, // Modinagar railway station
    {Coordinate{81.2506, 24.5371}, CountryId{"IN"}}, // Rewa Terminal railway station
    {Coordinate{80.9179, 26.8591}, CountryId{"IN"}}, // Lucknow City railway station
    {Coordinate{77.2441, 28.5793}, CountryId{"IN"}}, // Lajpat Nagar railway station
    {Coordinate{77.2165, 28.5795}, CountryId{"IN"}}, // Lodhi Colony railway station
    {Coordinate{77.1837, 28.6641}, CountryId{"IN"}}, // Vivekanand Puri Halt railway station
    {Coordinate{70.3707, 20.9134}, CountryId{"IN"}}, // Veraval Junction railway station
    {Coordinate{77.2266, 28.6341}, CountryId{"IN"}}, // Shivaji Bridge railway station
    {Coordinate{73.8714, 29.9318}, CountryId{"IN"}}, // Sri Ganganagar railway station
    {Coordinate{77.1671, 28.5958}, CountryId{"IN"}}, // Sardar Patel Road railway station
    {Coordinate{86.595, 25.8752}, CountryId{"IN"}}, // Saharsa Junction railway station
    {Coordinate{77.5417, 29.9605}, CountryId{"IN"}}, // Saharanpur Junction railway station
    {Coordinate{87.6346, 25.2414}, CountryId{"IN"}}, // Sahibganj Junction railway station
    {Coordinate{77.3642, 28.674}, CountryId{"IN"}}, // Sahibabad Junction railway station
    {Coordinate{8.34944, 49.5353}, CountryId{"DE"}}, // Frankenthal Central Station
    {Coordinate{81.7899, 25.4399}, CountryId{"IN"}}, // Subedarganj railway station
    {Coordinate{77.2278, 28.5786}, CountryId{"IN"}}, // Sewa Nagar railway station
    {Coordinate{4.96806, 51.8339}, CountryId{"NL"}}, // Gorinchem railway station
    {Coordinate{19.0894, 47.5253}, CountryId{"HU"}}, // Rákosrendező railway station
    {Coordinate{82.4867, 45.2528}, CountryId{"KZ"}}, // Dostyk railway station
    {Coordinate{73.0947, 49.793}, CountryId{"KZ"}}, // Karaganda railway station
    {Coordinate{11.3202, 50.2397}, CountryId{"DE"}}, // Kronach
    {Coordinate{15.9539, 45.8092}, CountryId{"HR"}}, // Zagreb Zapadni railway station
    {Coordinate{25.109, 55.533}, CountryId{"LT"}}, // Anykščiai train station
    {Coordinate{23.596, 54.759}, CountryId{"LT"}}, // Jūrė train station
    {Coordinate{24.536, 55.772}, CountryId{"LT"}}, // Karsakiškis train station
    {Coordinate{25.502, 54.676}, CountryId{"LT"}}, // Kyviškės train station
    {Coordinate{25.047, 54.6447}, CountryId{"LT"}}, // Lentvaris train station
    {Coordinate{25.497, 54.72}, CountryId{"LT"}}, // Mickūnai train station
    {Coordinate{26.086, 55.281}, CountryId{"LT"}}, // Pakretuonė train station
    {Coordinate{24.0611, 54.9142}, CountryId{"LT"}}, // Palemonas train station
    {Coordinate{25.392, 55.906}, CountryId{"LT"}}, // Panemunėlis train station
    {Coordinate{25.865, 55.027}, CountryId{"LT"}}, // Pažeimenė train station
    {Coordinate{25.197, 55.865}, CountryId{"LT"}}, // Skapiškis train station
    {Coordinate{25.568, 54.861}, CountryId{"LT"}}, // Skersabaliai train station
    {Coordinate{23.441, 54.674}, CountryId{"LT"}}, // Vinčai train station
    {Coordinate{6.99056, 49.2414}, CountryId{"DE"}}, // Saarbrücken Central Station
    {Coordinate{26.6446, 47.7529}, CountryId{"RO"}}, // Botoșani railway station
    {Coordinate{21.9357, 47.07}, CountryId{"RO"}}, // Oradea Railway Station
    {Coordinate{27.91, 47.7611}, CountryId{"MD"}}, // Bălți-Oraș Railway Station
    {Coordinate{21.3346, 46.1448}, CountryId{"RO"}}, // Aradul Nou railway station
    {Coordinate{26.2661, 47.6706}, CountryId{"RO"}}, // Suceava railway station
    {Coordinate{17.1723, 48.1973}, CountryId{"SK"}}, // Bratislava východ railway station
    {Coordinate{18.679, 47.7998}, CountryId{"SK"}}, // Štúrovo railway station
    {Coordinate{7.90809, 46.5984}, CountryId{"CH"}}, // Lauterbrunnen railway station
    {Coordinate{7.95944, 46.5844}, CountryId{"CH"}}, // Kleine Scheidegg railway station
    {Coordinate{53.4517, 56.8713}, CountryId{"RU"}}, // Q1279157
    {Coordinate{54.0172, 57.0417}, CountryId{"RU"}}, // Q1279171
    {Coordinate{10.5256, 59.8928}, CountryId{"NO"}}, // Sandvika Station
    {Coordinate{7.26331, 47.6416}, CountryId{"FR"}}, // Q128074
    {Coordinate{15.601, 46.127}, CountryId{"SI"}}, // Imeno train station
    {Coordinate{14.6039, 46.2208}, CountryId{"SI"}}, // Kamnik railway station
    {Coordinate{16.4461, 46.5564}, CountryId{"SI"}}, // Lendava train station
    {Coordinate{14.519, 46.0371}, CountryId{"SI"}}, // Lubiana Rakovnik railway station
    {Coordinate{15.635, 46.5545}, CountryId{"SI"}}, // Maribor Studenci train station
    {Coordinate{15.6513, 46.5391}, CountryId{"SI"}}, // Maribor Tezno train station
    {Coordinate{15.323, 45.6425}, CountryId{"SI"}}, // Metlika railway station
    {Coordinate{13.8265, 45.7648}, CountryId{"SI"}}, // Dutovlje railway halt
    {Coordinate{15.6047, 46.1658}, CountryId{"SI"}}, // Podčetrtek Toplice railway station
    {Coordinate{15.7297, 46.2167}, CountryId{"SI"}}, // Vidina Railway Stop
    {Coordinate{8.5804, 49.4487}, CountryId{"DE"}}, // Mannheim-Friedrichsfeld station
    {Coordinate{10.555, 59.8972}, CountryId{"NO"}}, // Blommenholm Station
    {Coordinate{21.2297, 48.5083}, CountryId{"HU"}}, // Hidasnémeti railway station
    {Coordinate{17.7948, 46.3529}, CountryId{"HU"}}, // Kaposvár railway station
    {Coordinate{17.1925, 47.9942}, CountryId{"HU"}}, // Rajka railway station
    {Coordinate{19.1742, 47.4887}, CountryId{"HU"}}, // Rákos railway station
    {Coordinate{19.2581, 47.4861}, CountryId{"HU"}}, // Rákosliget railway station
    {Coordinate{20.1757, 47.1796}, CountryId{"HU"}}, // Szolnok railway station
    {Coordinate{18.3932, 47.5856}, CountryId{"HU"}}, // Tatabánya railway station
    {Coordinate{69.2861, 41.2921}, CountryId{"UZ"}}, // Tashkent Railway Station
    {Coordinate{1.51179, 44.3333}, CountryId{"FR"}}, // Gare de Lalbenque - Fontanes
    {Coordinate{23.9447, 37.9369}, CountryId{"GR"}}, // Athens International Airport station
    {Coordinate{22.9269, 38.4709}, CountryId{"GR"}}, // Livadeia railway station
    {Coordinate{13.7664, 51.1244}, CountryId{"DE"}}, // Dresden Flughafen railway station
    {Coordinate{20.1428, 46.2397}, CountryId{"HU"}}, // Szeged railway station
    {Coordinate{-4.057, 52.544}, CountryId{"GB"}}, // Aberdovey railway station
    {Coordinate{-0.9667, 50.8533}, CountryId{"GB"}}, // Warblington railway station
    {Coordinate{78.3931, 17.2629}, CountryId{"IN"}}, // Umdanagar railway station
    {Coordinate{3.33184, 50.2781}, CountryId{"FR"}}, // Gare de Bouchain
    {Coordinate{30.4033, 53.8769}, CountryId{"BY"}}, // Lupolava
    {Coordinate{29.9781, 55.6764}, CountryId{"BY"}}, // Byčycha
    {Coordinate{9.27, 48.82}, CountryId{"DE"}}, // Fellbach station
    {Coordinate{9.23472, 48.8061}, CountryId{"DE"}}, // Stuttgart Nürnberger Straße station
    {Coordinate{6.43971, 51.1631}, CountryId{"DE"}}, // Rheydt Central Station
    {Coordinate{75.2131, 43.54}, CountryId{"KZ"}}, // Otar
    {Coordinate{73.7199, 16.2588}, CountryId{"IN"}}, // Kankavli railway station
    {Coordinate{70.1181, 22.469}, CountryId{"IN"}}, // Hapa railway station
    {Coordinate{7.25396, 52.1623}, CountryId{"DE"}}, // Metelen Land railway station
    {Coordinate{79.8462, 10.6869}, CountryId{"IN"}}, // Velankanni railway station
    {Coordinate{13.8315, 66.1499}, CountryId{"NO"}}, // Bjerka Station
    {Coordinate{80.04, 44.01}, CountryId{"KZ"}}, // Kundyzdy
    {Coordinate{79.483, 43.738}, CountryId{"KZ"}}, // Taskaras
    {Coordinate{77.0161, 43.4253}, CountryId{"KZ"}}, // Zhety-Su railway station
    {Coordinate{6.62744, 46.5099}, CountryId{"CH"}}, // Jordils station
    {Coordinate{-123.098, 49.2737}, CountryId{"CA"}}, // Pacific Central Station
    {Coordinate{-0.0162, 51.4684}, CountryId{"GB"}}, // Elverson Road
    {Coordinate{28.5971, 49.9183}, CountryId{"UA"}}, // Berdychiv-Zhytomyrskyi
    {Coordinate{32.8184, 51.1785}, CountryId{"UA"}}, // Bakhmach-Homelskyi
    {Coordinate{32.4274, 51.4033}, CountryId{"UA"}}, // Bondarivka
    {Coordinate{27.7013, 50.6465}, CountryId{"UA"}}, // Vershnytsia
    {Coordinate{33.1728, 51.2629}, CountryId{"UA"}}, // Vyrivka
    {Coordinate{27.9332, 50.7675}, CountryId{"UA"}}, // Virivka
    {Coordinate{28.3854, 50.915}, CountryId{"UA"}}, // Hranitnyi
    {Coordinate{29.8059, 49.3079}, CountryId{"UA"}}, // Denhofivka
    {Coordinate{32.5788, 51.316}, CountryId{"UA"}}, // Doch
    {Coordinate{30.0973, 49.2433}, CountryId{"UA"}}, // Zhashkiv
    {Coordinate{29.1978, 49.6461}, CountryId{"UA"}}, // Zarudyntsi
    {Coordinate{28.5936, 50.9565}, CountryId{"UA"}}, // Korosten-Zhytomyrskyi
    {Coordinate{32.2438, 51.7621}, CountryId{"UA"}}, // Koriukivka
    {Coordinate{32.3316, 51.4645}, CountryId{"UA"}}, // Makoshyne
    {Coordinate{28.9143, 49.7278}, CountryId{"UA"}}, // Makharyntsi
    {Coordinate{33.152, 51.368}, CountryId{"UA"}}, // Melnya
    {Coordinate{32.2348, 51.5323}, CountryId{"UA"}}, // Mena
    {Coordinate{32.0748, 51.6714}, CountryId{"UA"}}, // Nyzkivka
    {Coordinate{28.5648, 50.9638}, CountryId{"UA"}}, // Obvidnyi
    {Coordinate{28.2925, 50.8982}, CountryId{"UA"}}, // Omelianivka
    {Coordinate{27.8193, 50.7069}, CountryId{"UA"}}, // Rykhalska
    {Coordinate{29.6495, 49.3754}, CountryId{"UA"}}, // Q13360833
    {Coordinate{29.7103, 49.3663}, CountryId{"UA"}}, // Tetiiv
    {Coordinate{28.1975, 50.8584}, CountryId{"UA"}}, // Ushytsia
    {Coordinate{32.6992, 51.2422}, CountryId{"UA"}}, // Chasnykivka
    {Coordinate{28.0664, 50.8061}, CountryId{"UA"}}, // Yablunets
    {Coordinate{26.8042, 49.1789}, CountryId{"UA"}}, // Yarmolyntsi
    {Coordinate{33.5978, 45.1447}, CountryId{"UA"}}, // Saky railway station
    {Coordinate{34.8008, 48.4403}, CountryId{"UA"}}, // Q13361022
    {Coordinate{32.0678, 49.0492}, CountryId{"UA"}}, // Kamianka
    {Coordinate{32.1708, 49.0119}, CountryId{"UA"}}, // Kosari
    {Coordinate{31.3974, 48.9954}, CountryId{"UA"}}, // Shpola
    {Coordinate{23.2981, 48.1617}, CountryId{"UA"}}, // Khust
    {Coordinate{34.4577, 51.2405}, CountryId{"UA"}}, // Volfine
    {Coordinate{33.0306, 52.0945}, CountryId{"UA"}}, // 70 km
    {Coordinate{33.3259, 51.8839}, CountryId{"UA"}}, // Bohdanivka
    {Coordinate{33.4165, 51.2017}, CountryId{"UA"}}, // Q13361354
    {Coordinate{33.3496, 51.2009}, CountryId{"UA"}}, // Dzhyhaivka
    {Coordinate{33.4656, 51.2152}, CountryId{"UA"}}, // Dubynka
    {Coordinate{33.2302, 51.2192}, CountryId{"UA"}}, // Zalizobetonnyi
    {Coordinate{33.5007, 51.2146}, CountryId{"UA"}}, // Zafativka
    {Coordinate{33.7993, 51.9439}, CountryId{"UA"}}, // Ivotka
    {Coordinate{33.2981, 51.2032}, CountryId{"UA"}}, // Kalynivka
    {Coordinate{33.1243, 51.2154}, CountryId{"UA"}}, // Kukilka
    {Coordinate{33.4519, 51.7033}, CountryId{"UA"}}, // Pyrotchyne
    {Coordinate{28.5894, 50.9762}, CountryId{"UA"}}, // Chyhyri
    {Coordinate{33.985, 52.1162}, CountryId{"UA"}}, // Shalymivka
    {Coordinate{32.9224, 51.1954}, CountryId{"UA"}}, // Khutir-Khalymonove
    {Coordinate{22.8534, 56.6916}, CountryId{"LV"}}, // Josta
    {Coordinate{7.4102, 49.5382}, CountryId{"DE"}}, // Kusel station
    {Coordinate{3.73481, 45.5492}, CountryId{"FR"}}, // Gare d'Ambert
    {Coordinate{7.4448, 49.4702}, CountryId{"DE"}}, // Glan-Münchweiler station
    {Coordinate{8.85501, 47.6561}, CountryId{"CH"}}, // Stein am Rhein railway station
    {Coordinate{44.7978, 41.7233}, CountryId{"GE"}}, // Tbilisi railway station
    {Coordinate{2.1932, 41.4361}, CountryId{"ES"}}, // Sant Andreu Comtal railway station
    {Coordinate{9.20278, 45.3389}, CountryId{"IT"}}, // Pieve Emanuele railway halt
    {Coordinate{6.72258, 49.3526}, CountryId{"DE"}}, // Dillingen (Saar) station
    {Coordinate{31.7833, 51.3271}, CountryId{"UA"}}, // Veresoch
    {Coordinate{31.8823, 51.1762}, CountryId{"UA"}}, // Vertiivka
    {Coordinate{31.1125, 51.7786}, CountryId{"UA"}}, // Q13423562
    {Coordinate{8.58705, 47.5206}, CountryId{"CH"}}, // Embrach-Rorbas railway station with goods shed
    {Coordinate{31.1566, 51.9661}, CountryId{"UA"}}, // Q13423579
    {Coordinate{31.3172, 51.4307}, CountryId{"UA"}}, // Q13423580
    {Coordinate{31.2146, 51.5981}, CountryId{"UA"}}, // Q13423581
    {Coordinate{31.5542, 51.4262}, CountryId{"UA"}}, // Q13423583
    {Coordinate{31.9047, 51.0972}, CountryId{"UA"}}, // Q13423584
    {Coordinate{28.6419, 51.0197}, CountryId{"UA"}}, // Q13423592
    {Coordinate{28.6131, 50.9846}, CountryId{"UA"}}, // Korosten-Podilskyi
    {Coordinate{2.94946, 48.9602}, CountryId{"FR"}}, // Gare de Trilport
    {Coordinate{15.025, 50.99}, CountryId{"CZ"}}, // Q13433906
    {Coordinate{10.9924, 62.958}, CountryId{"NO"}}, // Langlete Station
    {Coordinate{6.8133, 51.3768}, CountryId{"DE"}}, // Duisburg-Entenfang station
    {Coordinate{6.32083, 50.8244}, CountryId{"DE"}}, // Eschweiler-Weisweiler railway station
    {Coordinate{8.65502, 50.1582}, CountryId{"DE"}}, // Frankfurt Eschersheim station
    {Coordinate{4.49278, 52.0464}, CountryId{"NL"}}, // Zoetermeer Oost railway station
    {Coordinate{6.90833, 51.1333}, CountryId{"DE"}}, // Düsseldorf-Hellerhof station
    {Coordinate{11.7388, 53.1607}, CountryId{"DE"}}, // Karstädt station
    {Coordinate{11.9609, 50.4192}, CountryId{"DE"}}, // Gutenfürst
    {Coordinate{-1.673, 52.2952}, CountryId{"GB"}}, // Hatton railway station
    {Coordinate{-1.19861, 53.1422}, CountryId{"GB"}}, // Mansfield railway station
    {Coordinate{-4.3199, 55.9203}, CountryId{"GB"}}, // Hillfoot railway station
    {Coordinate{-1.113, 54.6096}, CountryId{"GB"}}, // British Steel Redcar railway station
    {Coordinate{-2.4636, 54.968}, CountryId{"GB"}}, // Haltwhistle railway station
    {Coordinate{-2.086, 53.464}, CountryId{"GB"}}, // Hyde North railway station
    {Coordinate{-0.36, 53.702}, CountryId{"GB"}}, // New Holland railway station
    {Coordinate{-0.3898, 51.3768}, CountryId{"GB"}}, // Hersham railway station
    {Coordinate{-0.5054, 51.3395}, CountryId{"GB"}}, // West Byfleet railway station
    {Coordinate{0.095, 51.181}, CountryId{"GB"}}, // Hever railway station
    {Coordinate{28.5917, 50.9753}, CountryId{"UA"}}, // Post-Pivdenny
    {Coordinate{7.01389, 51.4514}, CountryId{"DE"}}, // Essen Central Station
    {Coordinate{76.2722, 10.7589}, CountryId{"IN"}}, // Shoranur Junction railway station
    {Coordinate{5.88089, 45.2345}, CountryId{"FR"}}, // Lancey railway station
    {Coordinate{-2.97542, 43.2878}, CountryId{"ES"}}, // Lutxana
    {Coordinate{15.4625, 66.7425}, CountryId{"NO"}}, // Lønsdal Station
    {Coordinate{-0.0998, 51.4944}, CountryId{"GB"}}, // Elephant & Castle railway station
    {Coordinate{-1.621, 51.17}, CountryId{"GB"}}, // Grateley railway station
    {Coordinate{75.797, 22.5142}, CountryId{"IN"}}, // Indore Patalpani railway station
    {Coordinate{-0.010556, 51.4881}, CountryId{"GB"}}, // Island Gardens
    {Coordinate{80.3284, 26.4562}, CountryId{"IN"}}, // Kanpur Anwarganj railway station
    {Coordinate{4.61778, 51.1508}, CountryId{"BE"}}, // Kessel railway station
    {Coordinate{23.4642, 56.7025}, CountryId{"LV"}}, // Līvbērze
    {Coordinate{6.47226, 51.1996}, CountryId{"DE"}}, // Mönchengladbach-Lürrip station
    {Coordinate{37.5818, 55.7764}, CountryId{"RU"}}, // Moscow Belorussky railway station
    {Coordinate{-2.942, 53.26}, CountryId{"GB"}}, // Capenhurst railway station
    {Coordinate{-2.237, 53.304}, CountryId{"GB"}}, // Alderley Edge railway station
    {Coordinate{10.5777, 49.2979}, CountryId{"DE"}}, // Ansbach
    {Coordinate{84.4221, 18.7568}, CountryId{"IN"}}, // Palasa railway station
    {Coordinate{12.0997, 49.0118}, CountryId{"DE"}}, // Regensburg Central Station
    {Coordinate{10.5806, 59.9006}, CountryId{"NO"}}, // Høvik Station
    {Coordinate{37.6392, 55.7294}, CountryId{"RU"}}, // Paveletsky railway station
    {Coordinate{-2.8914, 53.208}, CountryId{"GB"}}, // Bache railway station
    {Coordinate{9.62471, 62.4241}, CountryId{"NO"}}, // Drivstua Station
    {Coordinate{9.35444, 48.8681}, CountryId{"DE"}}, // Schwaikheim station
    {Coordinate{15.9787, 45.8044}, CountryId{"HR"}}, // Zagreb Main Station
    {Coordinate{16.3169, 48.1505}, CountryId{"AT"}}, // Alterlaa
    {Coordinate{11.1191, 46.0726}, CountryId{"IT"}}, // Trento railway station
    {Coordinate{10.7533, 59.9111}, CountryId{"NO"}}, // Oslo Central Station
    {Coordinate{15.2242, 50.925}, CountryId{"CZ"}}, // Nové Město pod Smrkem
    {Coordinate{15.1511, 50.9389}, CountryId{"CZ"}}, // Řasnice (train station)
    {Coordinate{15.0286, 50.9733}, CountryId{"CZ"}}, // Višňová
    {Coordinate{13.4311, 52.4675}, CountryId{"DE"}}, // Hermannstraße railway station
    {Coordinate{-119.446, 52.9578}, CountryId{"CA"}}, // Harvey railway station
    {Coordinate{-0.130833, 51.5161}, CountryId{"GB"}}, // Tottenham Court Road station
    {Coordinate{16.3133, 48.1367}, CountryId{"AT"}}, // Perfektastraße metro station
    {Coordinate{15.0203, 51.1531}, CountryId{"PL"}}, // Zgorzelec Miasto
    {Coordinate{4.02472, 50.9483}, CountryId{"BE"}}, // Aalst-Kerrebroek railway station
    {Coordinate{6.24123, 51.2945}, CountryId{"DE"}}, // Breyell railway station
    {Coordinate{3.92238, 50.9071}, CountryId{"BE"}}, // Burst railway station
    {Coordinate{7.3509, 51.4959}, CountryId{"DE"}}, // Dortmund-Somborn station
    {Coordinate{6.20143, 50.8345}, CountryId{"DE"}}, // Eschweiler-St. Jöris station
    {Coordinate{15.6728, 48.6658}, CountryId{"AT"}}, // Horn station
    {Coordinate{12.94, 49.7431}, CountryId{"CZ"}}, // Milíkov
    {Coordinate{4.90214, 51.174}, CountryId{"BE"}}, // Olen railway station
    {Coordinate{4.65361, 50.8358}, CountryId{"BE"}}, // Oud-Heverlee railway station
    {Coordinate{12.4, 50.1153}, CountryId{"CZ"}}, // Tršnice
    {Coordinate{21.3426, 41.0197}, CountryId{"MK"}}, // Bitola railway station
    {Coordinate{21.6926, 56.6205}, CountryId{"LV"}}, // Kalvene
    {Coordinate{13.7513, 52.4296}, CountryId{"DE"}}, // Erkner railway station
    {Coordinate{18.4128, 49.7914}, CountryId{"CZ"}}, // Havířov railway station
    {Coordinate{24.3986, 57.225}, CountryId{"LV"}}, // Inčupe
    {Coordinate{6.84214, 46.7078}, CountryId{"CH"}}, // Lucens railway station
    {Coordinate{6.89429, 46.7588}, CountryId{"CH"}}, // Granges-Marnand railway station
    {Coordinate{73.8512, 18.5317}, CountryId{"IN"}}, // Shivajinagar railway station
    {Coordinate{24.4328, 57.2863}, CountryId{"LV"}}, // Ķīšupe
    {Coordinate{-81.2467, 42.9813}, CountryId{"CA"}}, // London station (Ontario)
    {Coordinate{6.68628, 50.9381}, CountryId{"DE"}}, // Quadrath-Ichendorf station
    {Coordinate{10.9306, 44.6539}, CountryId{"IT"}}, // Modena railway station
    {Coordinate{9.04722, 51.5247}, CountryId{"DE"}}, // Scherfede station
    {Coordinate{14.435, 50.0875}, CountryId{"CZ"}}, // Praha Masarykovo nádraží
    {Coordinate{6.79722, 50.9981}, CountryId{"DE"}}, // Pulheim station
    {Coordinate{16.4069, 48.1753}, CountryId{"AT"}}, // Wien Geiselbergstraße railway station
    {Coordinate{7.21945, 50.6395}, CountryId{"DE"}}, // Bad Honnef (Rhein) station
    {Coordinate{10.6297, 47.8756}, CountryId{"DE"}}, // Kaufbeuren
    {Coordinate{7.21023, 50.6581}, CountryId{"DE"}}, // Rhöndorf station
    {Coordinate{8.91449, 49.1362}, CountryId{"DE"}}, // Eppingen station
    {Coordinate{8.86361, 52.1719}, CountryId{"DE"}}, // Vlotho station
    {Coordinate{12.6747, 48.2215}, CountryId{"DE"}}, // Altötting station
    {Coordinate{11.1075, 47.9508}, CountryId{"DE"}}, // Dießen station
    {Coordinate{9.82944, 52.9831}, CountryId{"DE"}}, // Soltau (Han) station
    {Coordinate{12.0838, 52.9032}, CountryId{"DE"}}, // Glöwen station
    {Coordinate{10.3321, 47.7313}, CountryId{"DE"}}, // Bahnhof Kempten Ost
    {Coordinate{11.8524, 53.0714}, CountryId{"DE"}}, // Perleberg station
    {Coordinate{10.9883, 48.2627}, CountryId{"DE"}}, // Mering station
    {Coordinate{8.76033, 47.4652}, CountryId{"CH"}}, // Sennhof-Kyburg railway station
    {Coordinate{24.5058, 56.8396}, CountryId{"LV"}}, // Ikšķile
    {Coordinate{14.5606, 50.1067}, CountryId{"CZ"}}, // Rajská zahrada
    {Coordinate{8.41639, 45.3298}, CountryId{"IT"}}, // Vercelli railway station
    {Coordinate{-0.021392, 51.5034}, CountryId{"GB"}}, // Heron Quays
    {Coordinate{18.9588, 47.5059}, CountryId{"HU"}}, // Virágvölgy
    {Coordinate{-0.873252, 38.585}, CountryId{"ES"}}, // Villena AV railway station
    {Coordinate{37.5017, 47.5972}, CountryId{"UA"}}, // Volnovakha Railway Station
    {Coordinate{-1.547, 53.794}, CountryId{"GB"}}, // Leeds railway station
    {Coordinate{-122.292, 37.8407}, CountryId{"US"}}, // Emeryville station
    {Coordinate{-81.9519, 28.0455}, CountryId{"US"}}, // Lakeland
    {Coordinate{-93.217, 30.2382}, CountryId{"US"}}, // Lake Charles
    {Coordinate{-90.0786, 29.9462}, CountryId{"US"}}, // New Orleans Union Passenger Terminal
    {Coordinate{-89.7828, 30.2783}, CountryId{"US"}}, // Slidell
    {Coordinate{-90.4427, 31.5794}, CountryId{"US"}}, // Brookhaven
    {Coordinate{-91.4327, 38.7073}, CountryId{"US"}}, // Hermann
    {Coordinate{-93.2284, 38.7116}, CountryId{"US"}}, // Sedalia
    {Coordinate{-107.872, 48.3605}, CountryId{"US"}}, // Malta
    {Coordinate{-105.643, 48.0915}, CountryId{"US"}}, // Wolf Point
    {Coordinate{-74.4461, 40.4967}, CountryId{"US"}}, // New Brunswick station
    {Coordinate{-74.1907, 40.7044}, CountryId{"US"}}, // Newark Liberty International Airport
    {Coordinate{-80.6246, 35.496}, CountryId{"US"}}, // Kannapolis
    {Coordinate{-94.7283, 32.4941}, CountryId{"US"}}, // Longview
    {Coordinate{-70.3761, 43.5144}, CountryId{"US"}}, // Old Orchard Beach
    {Coordinate{-86.2523, 41.8373}, CountryId{"US"}}, // Niles station
    {Coordinate{37.6325, 55.7928}, CountryId{"RU"}}, // Moscow Rizhsky railway station
    {Coordinate{7.59972, 50.3169}, CountryId{"DE"}}, // Niederlahnstein station
    {Coordinate{22.4228, 39.6295}, CountryId{"GR"}}, // Larissa railway station
    {Coordinate{22.5296, 40.6365}, CountryId{"GR"}}, // Platy railway station
    {Coordinate{14.0444, 50.6597}, CountryId{"CZ"}}, // Ústí nad Labem hlavní nádraží
    {Coordinate{-0.100556, 51.4956}, CountryId{"GB"}}, // Elephant & Castle tube station
    {Coordinate{-121.617, 53.9833}, CountryId{"CA"}}, // Hutton railway station
    {Coordinate{-121.844, 54.077}, CountryId{"CA"}}, // McGregor railway station
    {Coordinate{-98.4147, 55.0294}, CountryId{"CA"}}, // Lyddal
    {Coordinate{-94.1686, 57.1972}, CountryId{"CA"}}, // Silcox railway station
    {Coordinate{-79.8653, 43.2664}, CountryId{"CA"}}, // West Harbour GO Station
    {Coordinate{8.05689, 50.0137}, CountryId{"DE"}}, // Hattenheim station
    {Coordinate{10.8665, 53.9589}, CountryId{"DE"}}, // Lübeck-Travemünde Hafen station
    {Coordinate{13.4809, 54.3563}, CountryId{"DE"}}, // Putbus railway station
    {Coordinate{12.2373, 51.8843}, CountryId{"DE"}}, // Roßlau (Elbe) station
    {Coordinate{8.54825, 49.0876}, CountryId{"DE"}}, // Untergrombach station
    {Coordinate{8.26764, 50.4864}, CountryId{"DE"}}, // Weilburg station
    {Coordinate{7.61046, 49.5841}, CountryId{"DE"}}, // Wolfstein station
    {Coordinate{12.3466, 51.5198}, CountryId{"DE"}}, // Delitzsch oberer Bahnhof
    {Coordinate{16.3996, 48.1879}, CountryId{"AT"}}, // Bahnhof Wien St. Marx
    {Coordinate{11.4158, 47.1935}, CountryId{"AT"}}, // Patsch railway station
    {Coordinate{70.7549, 23.1032}, CountryId{"IN"}}, // Maliya Miyana railway station
    {Coordinate{4.6062, 45.5243}, CountryId{"FR"}}, // Gare de Rive-de-Gier
    {Coordinate{37.515, 55.7444}, CountryId{"RU"}}, // Fili
    {Coordinate{0.07179, 51.509}, CountryId{"GB"}}, // Gallions Reach DLR station
    {Coordinate{37.3973, 55.7237}, CountryId{"RU"}}, // Setun
    {Coordinate{37.5539, 55.8053}, CountryId{"RU"}}, // Grazhdanskaya
    {Coordinate{37.5533, 55.8973}, CountryId{"RU"}}, // Lianozovo
    {Coordinate{37.2467, 55.8233}, CountryId{"RU"}}, // Opalikha
    {Coordinate{35.3789, 55.5131}, CountryId{"RU"}}, // Drovnino
    {Coordinate{42.0228, 58.4252}, CountryId{"RU"}}, // Q14927507
    {Coordinate{45.0122, 53.2043}, CountryId{"RU"}}, // Penza 1 railway station
    {Coordinate{27.4422, 53.9375}, CountryId{"BY"}}, // Lyebyadziny
    {Coordinate{40.1906, 48.1555}, CountryId{"RU"}}, // Lykha
    {Coordinate{31.0615, 59.7556}, CountryId{"RU"}}, // Mga
    {Coordinate{38.1362, 56.1088}, CountryId{"RU"}}, // Krasnoarmeysk
    {Coordinate{38.0309, 54.987}, CountryId{"RU"}}, // Zhilyovo
    {Coordinate{49.3302, 55.9423}, CountryId{"RU"}}, // Käminkä
    {Coordinate{59.9778, 56.8889}, CountryId{"RU"}}, // Q14927533
    {Coordinate{30.9341, 59.976}, CountryId{"RU"}}, // Dunay platform
    {Coordinate{27.0659, 54.2537}, CountryId{"BY"}}, // Usha
    {Coordinate{48.0483, 56.5125}, CountryId{"RU"}}, // Pemba railway station
    {Coordinate{29.1541, 60.552}, CountryId{"RU"}}, // Leypyasuo
    {Coordinate{40.035, 57.7686}, CountryId{"RU"}}, // Q14927543
    {Coordinate{28.7136, 60.5825}, CountryId{"RU"}}, // Popovo railway station
    {Coordinate{35.7175, 56.9533}, CountryId{"RU"}}, // Tvertsa
    {Coordinate{38.9181, 55.0264}, CountryId{"RU"}}, // Chyornaya
    {Coordinate{43.4792, 44.1672}, CountryId{"RU"}}, // Q14927597
    {Coordinate{43.5816, 49.9016}, CountryId{"RU"}}, // Q14927598
    {Coordinate{38.666, 47.6978}, CountryId{"RU"}}, // Q14927599
    {Coordinate{42.992, 50.327}, CountryId{"RU"}}, // Q14927601
    {Coordinate{109.342, 55.6328}, CountryId{"RU"}}, // Severobaykalsk railway station
    {Coordinate{29.5424, 55.8469}, CountryId{"RU"}}, // Q14927614
    {Coordinate{56.9983, 57.4234}, CountryId{"RU"}}, // Kungur Railway Station
    {Coordinate{38.8093, 55.4104}, CountryId{"RU"}}, // Berendino
    {Coordinate{35.7871, 55.9942}, CountryId{"RU"}}, // Blagoveshchenskoye
    {Coordinate{37.2661, 55.6099}, CountryId{"RU"}}, // Aeroport
    {Coordinate{39.2114, 56.7063}, CountryId{"RU"}}, // Q14927621
    {Coordinate{45.4122, 53.1141}, CountryId{"RU"}}, // Q14927622
    {Coordinate{37.4616, 54.9949}, CountryId{"RU"}}, // 92 km
    {Coordinate{75.3441, 43.5342}, CountryId{"KZ"}}, // Q14927624
    {Coordinate{75.4881, 43.535}, CountryId{"KZ"}}, // Q14927625
    {Coordinate{78.8757, 43.7499}, CountryId{"KZ"}}, // Ortakudyk
    {Coordinate{79.8153, 43.9607}, CountryId{"KZ"}}, // Aydarly
    {Coordinate{55.9204, 53.4658}, CountryId{"RU"}}, // Allaguvat railway station
    {Coordinate{55.9256, 53.5367}, CountryId{"RU"}}, // Q14927629
    {Coordinate{55.9137, 53.5556}, CountryId{"RU"}}, // Q14927630
    {Coordinate{55.9196, 53.608}, CountryId{"RU"}}, // Q14927631
    {Coordinate{55.91, 53.5669}, CountryId{"RU"}}, // Q14927632
    {Coordinate{38.4069, 48.3422}, CountryId{"UA"}}, // Debaltseve Railway Station
    {Coordinate{37.4583, 56.1258}, CountryId{"RU"}}, // Bely Rast
    {Coordinate{126.75, 52.6311}, CountryId{"RU"}}, // Q14927635
    {Coordinate{45.1906, 54.1956}, CountryId{"RU"}}, // Saransk railway station
    {Coordinate{39.2425, 56.8027}, CountryId{"RU"}}, // Q14927637
    {Coordinate{38.3264, 55.1019}, CountryId{"RU"}}, // Lyutik
    {Coordinate{35.8914, 56.8352}, CountryId{"RU"}}, // Tver
    {Coordinate{36.7578, 54.515}, CountryId{"RU"}}, // Ferzikovo railway station
    {Coordinate{52.1845, 56.9893}, CountryId{"RU"}}, // Uva-1 station
    {Coordinate{52.3872, 56.9833}, CountryId{"RU"}}, // Karkalay station
    {Coordinate{52.8693, 56.9673}, CountryId{"RU"}}, // Q14927644
    {Coordinate{42.2661, 54.2642}, CountryId{"RU"}}, // Kustaryovka
    {Coordinate{25.3453, 52.7092}, CountryId{"BY"}}, // Ivatsevichy
    {Coordinate{25.2219, 52.6515}, CountryId{"BY"}}, // Kosava-Palyeskaye
    {Coordinate{25.0926, 52.6062}, CountryId{"BY"}}, // Bronnaya Hara
    {Coordinate{53.7375, 63.5572}, CountryId{"RU"}}, // Uhta
    {Coordinate{50.0752, 62.3599}, CountryId{"RU"}}, // Mikun railroad station
    {Coordinate{55.0747, 51.7763}, CountryId{"RU"}}, // Orenburg railway station
    {Coordinate{36.1964, 52.9372}, CountryId{"RU"}}, // Q14927652
    {Coordinate{35.18, 53.1403}, CountryId{"RU"}}, // Q14927653
    {Coordinate{40.1172, 47.4046}, CountryId{"RU"}}, // Novocherkassk railway station
    {Coordinate{34.9817, 53.1344}, CountryId{"RU"}}, // Karachev railway station
    {Coordinate{34.3081, 53.3142}, CountryId{"RU"}}, // Ordzhonikidzegrad
    {Coordinate{31.8484, 53.7258}, CountryId{"BY"}}, // Krychaw II
    {Coordinate{31.7089, 53.7403}, CountryId{"BY"}}, // Krychaw I
    {Coordinate{59.9931, 57.9099}, CountryId{"RU"}}, // Nizhny Tagil train station
    {Coordinate{34.8325, 53.1769}, CountryId{"RU"}}, // Q14927660
    {Coordinate{34.2353, 53.1117}, CountryId{"RU"}}, // Poluzh'ye
    {Coordinate{33.4633, 52.9139}, CountryId{"RU"}}, // Pochep railway station
    {Coordinate{33.1347, 52.8792}, CountryId{"RU"}}, // Zhudilovo
    {Coordinate{32.6783, 52.8428}, CountryId{"RU"}}, // Unecha
    {Coordinate{32.2333, 52.735}, CountryId{"RU"}}, // Q14927665
    {Coordinate{31.9469, 52.5228}, CountryId{"RU"}}, // Novozybkov
    {Coordinate{31.165, 52.3881}, CountryId{"BY"}}, // Laryshchava
    {Coordinate{30.7536, 52.3986}, CountryId{"BY"}}, // Prybar
    {Coordinate{30.3928, 52.3486}, CountryId{"BY"}}, // Rechytsa
    {Coordinate{30.2031, 52.3361}, CountryId{"BY"}}, // Dzyemyakhi
    {Coordinate{29.8311, 52.2539}, CountryId{"BY"}}, // Vasilyevichy
    {Coordinate{29.6728, 52.2217}, CountryId{"BY"}}, // Nakhaw
    {Coordinate{29.4992, 52.1622}, CountryId{"BY"}}, // Halyavitsy
    {Coordinate{57.2351, 65.1582}, CountryId{"RU"}}, // Pechora railway station
    {Coordinate{41.5459, 58.4671}, CountryId{"RU"}}, // Buy railway station
    {Coordinate{41.1154, 57.245}, CountryId{"RU"}}, // Furmanov railway station
    {Coordinate{41.3006, 64.4097}, CountryId{"RU"}}, // Q14927691
    {Coordinate{47.5076, 58.2823}, CountryId{"RU"}}, // Svecha station
    {Coordinate{43.3911, 58.3394}, CountryId{"RU"}}, // Nikolo-Poloma railway station
    {Coordinate{41.6771, 57.9251}, CountryId{"RU"}}, // Q14927694
    {Coordinate{88.3939, 22.6397}, CountryId{"IN"}}, // Noapara metro station
    {Coordinate{7.6681, 45.0004}, CountryId{"IT"}}, // Moncalieri Sangone railway station
    {Coordinate{7.642, 44.9914}, CountryId{"IT"}}, // Nichelino railway halt
    {Coordinate{7.599, 44.9611}, CountryId{"IT"}}, // Candiolo railway station
    {Coordinate{11.4101, 48.14}, CountryId{"DE"}}, // München-Freiham Haltepunkt
    {Coordinate{12.5644, 55.6728}, CountryId{"DK"}}, // Copenhagen Central Station
    {Coordinate{27.4679, 57.84}, CountryId{"EE"}}, // Piusa railway station
    {Coordinate{-0.1609, 51.1565}, CountryId{"GB"}}, // Gatwick Airport railway station
    {Coordinate{-2.73374, 53.3787}, CountryId{"GB"}}, // Widnes railway station
    {Coordinate{11.4116, 63.963}, CountryId{"NO"}}, // Vist Station
    {Coordinate{9.26733, 59.5589}, CountryId{"NO"}}, // Notodden New Station
    {Coordinate{6.71583, 60.5231}, CountryId{"NO"}}, // Granvin Station
    {Coordinate{88.346, 22.5167}, CountryId{"IN"}}, // Kalighat metro station
    {Coordinate{10.2431, 50.0461}, CountryId{"DE"}}, // Schweinfurt Stadt
    {Coordinate{12.6334, 42.2422}, CountryId{"IT"}}, // Poggio Mirteto railway station
    {Coordinate{12.5961, 42.0639}, CountryId{"IT"}}, // Monterotondo-Mentana railway station
    {Coordinate{9.43698, 45.0632}, CountryId{"IT"}}, // Castel San Giovanni railway station
    {Coordinate{11.3764, 44.4817}, CountryId{"IT"}}, // Bologna Mazzini railway halt
    {Coordinate{11.842, 44.6165}, CountryId{"IT"}}, // Argenta railway station
    {Coordinate{12.4609, 44.1502}, CountryId{"IT"}}, // Bellaria railway station
    {Coordinate{12.0401, 44.5116}, CountryId{"IT"}}, // Alfonsine railway station
    {Coordinate{12.0983, 44.4628}, CountryId{"IT"}}, // Mezzano railway station
    {Coordinate{7.7555, 46.3674}, CountryId{"CH"}}, // Goppenstein railway station
    {Coordinate{30.7406, 46.4639}, CountryId{"UA"}}, // Odesa-Holovna
    {Coordinate{8.78478, 47.3671}, CountryId{"CH"}}, // Pfäffikon ZH railway station
    {Coordinate{8.75027, 47.3851}, CountryId{"CH"}}, // Fehraltorf railway station
    {Coordinate{8.70475, 47.4517}, CountryId{"CH"}}, // Kemptthal railway station
    {Coordinate{8.93236, 47.354}, CountryId{"CH"}}, // Steg railway station
    {Coordinate{8.92318, 47.3334}, CountryId{"CH"}}, // Fischenthal railway station
    {Coordinate{8.62656, 47.4383}, CountryId{"CH"}}, // Bassersdorf railway station
    {Coordinate{8.91566, 47.3134}, CountryId{"CH"}}, // Gibswil railway station
    {Coordinate{8.8526, 47.2685}, CountryId{"CH"}}, // Tann-Dürnten railway station
    {Coordinate{8.84241, 47.2237}, CountryId{"CH"}}, // Blumenau railway station
    {Coordinate{8.85488, 47.3938}, CountryId{"CH"}}, // Saland railway station
    {Coordinate{8.84359, 47.4373}, CountryId{"CH"}}, // Turbenthal railway station
    {Coordinate{8.81892, 47.4416}, CountryId{"CH"}}, // Rämismühle-Zell railway station
    {Coordinate{8.76929, 47.5016}, CountryId{"CH"}}, // Winterthur Hegi railway station
    {Coordinate{8.6132, 47.2815}, CountryId{"CH"}}, // Herrliberg-Feldmeilen railway station
    {Coordinate{8.59892, 47.2974}, CountryId{"CH"}}, // Winkel am Zürichsee railway station
    {Coordinate{8.59161, 47.3053}, CountryId{"CH"}}, // Erlenbach ZH railway station
    {Coordinate{8.80066, 47.2136}, CountryId{"CH"}}, // Hurden railway station
    {Coordinate{8.75938, 47.2042}, CountryId{"CH"}}, // Freienbach SOB railway station
    {Coordinate{8.7562, 47.2073}, CountryId{"CH"}}, // Freienbach SBB railway station
    {Coordinate{8.82288, 47.194}, CountryId{"CH"}}, // Altendorf railway station
    {Coordinate{8.64661, 47.516}, CountryId{"CH"}}, // Pfungen railway station
    {Coordinate{8.50364, 47.4874}, CountryId{"CH"}}, // Niederglatt railway station
    {Coordinate{8.51059, 47.4702}, CountryId{"CH"}}, // Oberglatt railway station
    {Coordinate{8.37365, 47.5654}, CountryId{"CH"}}, // Rümikon AG railway station
    {Coordinate{8.35251, 47.5685}, CountryId{"CH"}}, // Mellikon railway station
    {Coordinate{8.32713, 47.57}, CountryId{"CH"}}, // Rekingen AG railway station
    {Coordinate{8.27733, 47.6007}, CountryId{"CH"}}, // Rietheim railway station
    {Coordinate{8.24016, 47.6094}, CountryId{"CH"}}, // Koblenz Dorf railway station
    {Coordinate{8.62586, 47.6829}, CountryId{"CH"}}, // Neuhausen railway station
    {Coordinate{17.9319, 58.8992}, CountryId{"SE"}}, // Gröndalsviken railway station
    {Coordinate{10.2423, 53.6613}, CountryId{"DE"}}, // Ahrensburg Ost
    {Coordinate{13.6618, 51.0132}, CountryId{"DE"}}, // Freital-Potschappel station
    {Coordinate{6.45138, 51.2859}, CountryId{"DE"}}, // Anrath railway station
    {Coordinate{7.63904, 50.6851}, CountryId{"DE"}}, // Altenkirchen (Westerw) station
    {Coordinate{7.96625, 49.2053}, CountryId{"DE"}}, // Annweiler am Trifels station
    {Coordinate{8.0028, 49.1031}, CountryId{"DE"}}, // Bad Bergzabern station
    {Coordinate{7.69807, 47.9197}, CountryId{"DE"}}, // Bad Krozingen station
    {Coordinate{13.4785, 52.5012}, CountryId{"DE"}}, // Berlin-Rummelsburg railway station
    {Coordinate{11.4085, 47.7235}, CountryId{"DE"}}, // Bichl station
    {Coordinate{13.22, 47.4173}, CountryId{"AT"}}, // Bischofshofen railway station
    {Coordinate{12.9521, 50.8612}, CountryId{"DE"}}, // Chemnitz-Hilbersdorf station
    {Coordinate{7.4283, 49.2454}, CountryId{"DE"}}, // Contwig station
    {Coordinate{10.138, 50.1311}, CountryId{"DE"}}, // Ebenhausen (Unterfr)
    {Coordinate{7.89941, 49.4903}, CountryId{"DE"}}, // Enkenbach station
    {Coordinate{6.82356, 50.8104}, CountryId{"DE"}}, // Erftstadt train station
    {Coordinate{8.09867, 47.8716}, CountryId{"DE"}}, // Feldberg-Bärental station
    {Coordinate{7.77304, 49.2031}, CountryId{"DE"}}, // Hinterweidenthal Ost
    {Coordinate{8.89617, 49.4428}, CountryId{"DE"}}, // Hirschhorn (Neckar) station
    {Coordinate{7.89667, 49.4428}, CountryId{"DE"}}, // Hochspeyer station
    {Coordinate{13.2714, 52.6725}, CountryId{"DE"}}, // Hohen Neuendorf West station
    {Coordinate{14.9024, 51.3039}, CountryId{"DE"}}, // Horka station
    {Coordinate{9.7628, 50.6733}, CountryId{"DE"}}, // Hünfeld station
    {Coordinate{9.60383, 50.2328}, CountryId{"DE"}}, // Jossa
    {Coordinate{8.1977, 49.0792}, CountryId{"DE"}}, // Kandel station
    {Coordinate{7.701, 49.5001}, CountryId{"DE"}}, // Katzweiler station
    {Coordinate{11.9884, 51.7522}, CountryId{"DE"}}, // Köthen railway station
    {Coordinate{8.07436, 49.3733}, CountryId{"DE"}}, // Lambrecht (Pfalz) station
    {Coordinate{11.8529, 48.4381}, CountryId{"DE"}}, // Langenbach (Oberbay)
    {Coordinate{8.5037, 49.5016}, CountryId{"DE"}}, // Mannheim-Käfertal station
    {Coordinate{8.81304, 49.3208}, CountryId{"DE"}}, // Meckesheim station
    {Coordinate{9.14667, 49.3522}, CountryId{"DE"}}, // Mosbach (Baden) station
    {Coordinate{11.193, 47.6823}, CountryId{"DE"}}, // Murnau station
    {Coordinate{9.02861, 50.6167}, CountryId{"DE"}}, // Mücke (Hesse) station
    {Coordinate{7.90083, 50.6322}, CountryId{"DE"}}, // Nistertal-Bad Marienberg station
    {Coordinate{7.42624, 51.8922}, CountryId{"DE"}}, // Nottuln-Appelhülsen station
    {Coordinate{7.65284, 49.5381}, CountryId{"DE"}}, // Olsbrücken station
    {Coordinate{7.4442, 49.5421}, CountryId{"DE"}}, // Rammelsbach station
    {Coordinate{7.4404, 49.4852}, CountryId{"DE"}}, // Rehweiler station
    {Coordinate{7.24275, 51.2153}, CountryId{"DE"}}, // Remscheid-Lüttringhausen station
    {Coordinate{11.0972, 47.9826}, CountryId{"DE"}}, // Riederau station
    {Coordinate{8.1414, 49.1379}, CountryId{"DE"}}, // Rohrbach (Pfalz)
    {Coordinate{8.829, 49.9732}, CountryId{"DE"}}, // Rödermark-Ober-Roden station
    {Coordinate{11.0898, 48.0528}, CountryId{"DE"}}, // Schondorf (Bay) station
    {Coordinate{7.68757, 49.3591}, CountryId{"DE"}}, // Schopp station
    {Coordinate{7.44845, 49.5191}, CountryId{"DE"}}, // Theisbergstegen station
    {Coordinate{8.2732, 49.0455}, CountryId{"DE"}}, // Wörth (Rhein) station
    {Coordinate{8.66429, 47.7172}, CountryId{"CH"}}, // Herblingen railway station
    {Coordinate{8.70323, 47.7455}, CountryId{"CH"}}, // Thayngen railway station
    {Coordinate{8.53276, 47.4543}, CountryId{"CH"}}, // Rümlang railway station
    {Coordinate{8.48868, 47.4783}, CountryId{"CH"}}, // Niederhasli railway station
    {Coordinate{8.44683, 47.49}, CountryId{"CH"}}, // Steinmaur railway station
    {Coordinate{16.4654, 48.146}, CountryId{"AT"}}, // Wien Kaiserebersdorf railway station
    {Coordinate{6.975, 50.9408}, CountryId{"DE"}}, // Köln Messe/Deutz station
    {Coordinate{18.3275, 47.6647}, CountryId{"HU"}}, // Tata railway station
    {Coordinate{18.1136, 47.7494}, CountryId{"HU"}}, // Komárom railway station
    {Coordinate{18.0039, 47.717}, CountryId{"HU"}}, // Ács railway station
    {Coordinate{12.3746, 51.3403}, CountryId{"DE"}}, // Leipzig Markt station
    {Coordinate{17.1914, 47.1825}, CountryId{"HU"}}, // Boba railway station
    {Coordinate{7.76528, 45.9844}, CountryId{"CH"}}, // Rotenboden railway station
    {Coordinate{80.2829, 13.0835}, CountryId{"IN"}}, // Chennai Fort railway station
    {Coordinate{91.2785, 23.7924}, CountryId{"IN"}}, // Agartala railway station
    {Coordinate{74.7219, 19.0755}, CountryId{"IN"}}, // Ahilyanagar railway station
    {Coordinate{7.4834, 44.928}, CountryId{"IT"}}, // Airasca railway station
    {Coordinate{77.0055, 20.7231}, CountryId{"IN"}}, // Akola railway station
    {Coordinate{73.7642, 18.6481}, CountryId{"IN"}}, // Akurdi railway station
    {Coordinate{78.0746, 27.8896}, CountryId{"IN"}}, // Aligarh railway station
    {Coordinate{89.534, 26.5233}, CountryId{"IN"}}, // Alipurduar Junction railway station
    {Coordinate{87.1812, 23.579}, CountryId{"IN"}}, // Andal Junction railway station
    {Coordinate{85.1, 20.8594}, CountryId{"IN"}}, // Angul railway station
    {Coordinate{80.2308, 13.3043}, CountryId{"IN"}}, // Anuppambattu railway station
    {Coordinate{73.1526, 18.8635}, CountryId{"IN"}}, // Apta railway station
    {Coordinate{79.668, 13.0815}, CountryId{"IN"}}, // Arakkonam Junction railway station
    {Coordinate{7.30176, 43.7347}, CountryId{"FR"}}, // Gare de l'Ariane - La Trinité
    {Coordinate{7.19454, 43.6624}, CountryId{"FR"}}, // Gare de Saint-Laurent-du-Var
    {Coordinate{13.5382, 52.4525}, CountryId{"DE"}}, // Oberspree station
    {Coordinate{7.75917, 53.2209}, CountryId{"DE"}}, // Augustfehn railway station
    {Coordinate{7.84282, 46.3125}, CountryId{"CH"}}, // Ausserberg railway station
    {Coordinate{77.7323, 20.8568}, CountryId{"IN"}}, // Badnera railway station
    {Coordinate{88.7579, 25.233}, CountryId{"IN"}}, // Balurghat railway station
    {Coordinate{89.5862, 26.0706}, CountryId{"IN"}}, // Bamanhat railway station
    {Coordinate{88.8329, 23.0305}, CountryId{"IN"}}, // Bangaon Junction railway station
    {Coordinate{84.903, 22.6648}, CountryId{"IN"}}, // Bano railway station
    {Coordinate{86.9286, 23.7069}, CountryId{"IN"}}, // Barachak railway station
    {Coordinate{87.8703, 23.2497}, CountryId{"IN"}}, // Barddhaman Junction railway station
    {Coordinate{87.9226, 25.6509}, CountryId{"IN"}}, // Barsoi Junction railway station
    {Coordinate{13.6734, 52.5183}, CountryId{"DE"}}, // Hoppegarten (Mark) station
    {Coordinate{13.7625, 52.5265}, CountryId{"DE"}}, // Fredersdorf station
    {Coordinate{73.709, 18.7012}, CountryId{"IN"}}, // Begdewadi railway station
    {Coordinate{86.447, 23.6422}, CountryId{"IN"}}, // Bhojudih Junction railway station
    {Coordinate{75.7887, 21.0473}, CountryId{"IN"}}, // Bhusaval Junction railway station
    {Coordinate{77.6678, 27.5014}, CountryId{"IN"}}, // Bhuteshwar railway station
    {Coordinate{7.13443, 43.6298}, CountryId{"FR"}}, // Gare de Villeneuve-Loubet-plage
    {Coordinate{87.3013, 23.0651}, CountryId{"IN"}}, // Bishnupur Junction railway station
    {Coordinate{5.09142, 43.6999}, CountryId{"FR"}}, // Lamanon
    {Coordinate{7.33956, 51.3238}, CountryId{"DE"}}, // Gevelsberg Hauptbahnhof
    {Coordinate{86.085, 23.6566}, CountryId{"IN"}}, // Bokaro Steel City Junction railway station
    {Coordinate{84.9251, 22.2355}, CountryId{"IN"}}, // Bondamunda railway station
    {Coordinate{13.8206, 52.8728}, CountryId{"DE"}}, // Britz station
    {Coordinate{8.33269, 44.3362}, CountryId{"IT"}}, // Altare railway station
    {Coordinate{8.19189, 44.3907}, CountryId{"IT"}}, // Cengio train station
    {Coordinate{8.5428, 44.3423}, CountryId{"IT"}}, // Celle Ligure railway halt
    {Coordinate{85.6278, 22.679}, CountryId{"IN"}}, // Chakradharpur railway station
    {Coordinate{83.2677, 25.2611}, CountryId{"IN"}}, // Chandauli Majhwar railway station
    {Coordinate{86.1198, 23.7557}, CountryId{"IN"}}, // Chandrapura railway station
    {Coordinate{74.2377, 16.7026}, CountryId{"IN"}}, // Chattrapati Shahu Maharaj Terminus
    {Coordinate{79.9815, 12.6929}, CountryId{"IN"}}, // Chengalpattu Junction railway station
    {Coordinate{76.6083, 9.3195}, CountryId{"IN"}}, // Chengannur railway station
    {Coordinate{82.8747, 25.1034}, CountryId{"IN"}}, // Chunar railway station
    {Coordinate{13.0575, 52.5436}, CountryId{"DE"}}, // Dallgow-Döberitz railway station
    {Coordinate{86.9085, 23.651}, CountryId{"IN"}}, // Damodar railway station
    {Coordinate{88.2908, 22.6783}, CountryId{"IN"}}, // Dankuni Junction railway station
    {Coordinate{73.8328, 18.58}, CountryId{"IN"}}, // Dapodi railway station
    {Coordinate{75.9196, 14.468}, CountryId{"IN"}}, // Davangere railway station
    {Coordinate{78.0336, 30.314}, CountryId{"IN"}}, // Dehradun railway station
    {Coordinate{84.1854, 24.9149}, CountryId{"IN"}}, // Dehri-on-Sone railway station
    {Coordinate{73.7342, 18.6802}, CountryId{"IN"}}, // Dehu Road railway station
    {Coordinate{71.4791, 22.9872}, CountryId{"IN"}}, // Dharangadhra Junction railway station
    {Coordinate{78.1547, 12.1266}, CountryId{"IN"}}, // Dharmapuri Junction railway station
    {Coordinate{89.978, 26.0231}, CountryId{"IN"}}, // Dhubri railway station
    {Coordinate{94.9353, 27.4636}, CountryId{"IN"}}, // Dibrugarh railway station
    {Coordinate{87.5082, 21.6229}, CountryId{"IN"}}, // Digha railway station
    {Coordinate{93.7278, 25.9057}, CountryId{"IN"}}, // Dimapur railway station
    {Coordinate{76.3363, 10.2854}, CountryId{"IN"}}, // Divine Nagar railway station
    {Coordinate{13.5642, 51.6206}, CountryId{"DE"}}, // Doberlug-Kirchhain railway station
    {Coordinate{9.19753, 47.2267}, CountryId{"CH"}}, // Nesslau-Neu St. Johann railway station
    {Coordinate{88.3933, 22.6209}, CountryId{"IN"}}, // Dum Dum Junction railway station
    {Coordinate{87.3174, 23.4953}, CountryId{"IN"}}, // Durgapur railway station
    {Coordinate{7.88116, 46.3065}, CountryId{"CH"}}, // Eggerberg railway station
    {Coordinate{12.9997, 52.5476}, CountryId{"DE"}}, // Elstal railway station
    {Coordinate{-3.2287, 51.5838}, CountryId{"GB"}}, // Energlyn & Churchill Park railway station
    {Coordinate{9.07719, 47.033}, CountryId{"CH"}}, // Ennenda railway station
    {Coordinate{78.654, 27.5719}, CountryId{"IN"}}, // Etah railway station
    {Coordinate{79.0215, 26.786}, CountryId{"IN"}}, // Etawah railway station
    {Coordinate{77.3094, 28.3762}, CountryId{"IN"}}, // Faridabad New Town railway station
    {Coordinate{77.3074, 28.4115}, CountryId{"IN"}}, // Faridabad railway station
    {Coordinate{80.8019, 25.9175}, CountryId{"IN"}}, // Fatehpur railway station
    {Coordinate{78.3867, 27.1474}, CountryId{"IN"}}, // Firozabad railway station
    {Coordinate{28.2339, 59.3678}, CountryId{"RU"}}, // Ivangorod
    {Coordinate{16.3998, 48.2561}, CountryId{"AT"}}, // Floridsdorf (Vienna U-Bahn)
    {Coordinate{24.2987, 56.921}, CountryId{"LV"}}, // Acone railway station
    {Coordinate{25.5775, 56.6336}, CountryId{"LV"}}, // Alotene
    {Coordinate{26.4075, 56.5303}, CountryId{"LV"}}, // Atašiene
    {Coordinate{25.2442, 56.5083}, CountryId{"LV"}}, // Daudzeva
    {Coordinate{26.6984, 57.1028}, CountryId{"LV"}}, // Elste
    {Coordinate{23.9492, 56.6506}, CountryId{"LV"}}, // Garoza railway station
    {Coordinate{24.2347, 56.6286}, CountryId{"LV"}}, // Iecava
    {Coordinate{25.9763, 56.6871}, CountryId{"LV"}}, // Jaunkalsnava
    {Coordinate{23.7567, 56.6508}, CountryId{"LV"}}, // Jelgava II
    {Coordinate{26.0187, 56.7339}, CountryId{"LV"}}, // Kalsnava
    {Coordinate{22.743, 57.102}, CountryId{"LV"}}, // Līgciems
    {Coordinate{22.4194, 57.1783}, CountryId{"LV"}}, // Līči
    {Coordinate{25.1008, 56.5375}, CountryId{"LV"}}, // Menta
    {Coordinate{24.3964, 56.5914}, CountryId{"LV"}}, // Misa
    {Coordinate{21.9314, 57.3089}, CountryId{"LV"}}, // Puze
    {Coordinate{24.2242, 56.92}, CountryId{"LV"}}, // Q15219689
    {Coordinate{22.6519, 57.1315}, CountryId{"LV"}}, // Sabile
    {Coordinate{25.3703, 56.5106}, CountryId{"LV"}}, // Sece
    {Coordinate{23.2911, 56.8442}, CountryId{"LV"}}, // Slampe
    {Coordinate{25.8254, 56.6616}, CountryId{"LV"}}, // Spīgana
    {Coordinate{25.6139, 56.5261}, CountryId{"LV"}}, // Sēlpils
    {Coordinate{24.9281, 56.5625}, CountryId{"LV"}}, // Taurkalne train station
    {Coordinate{26.7689, 56.5608}, CountryId{"LV"}}, // Q15219970
    {Coordinate{24.5367, 56.5903}, CountryId{"LV"}}, // Vecumnieki
    {Coordinate{26.9383, 56.5608}, CountryId{"LV"}}, // stacija Viļāni
    {Coordinate{28.1161, 56.3917}, CountryId{"LV"}}, // Zilupe railway station
    {Coordinate{24.0856, 56.6414}, CountryId{"LV"}}, // Zālīte railway station
    {Coordinate{70.1478, 23.0691}, CountryId{"IN"}}, // Gandhidham Junction railway station
    {Coordinate{78.002, 22.1264}, CountryId{"IN"}}, // Ghoradongri railway station
    {Coordinate{73.697, 18.7206}, CountryId{"IN"}}, // Ghorawadi railway station
    {Coordinate{89.8307, 26.1084}, CountryId{"IN"}}, // Golokganj railway station
    {Coordinate{7.78222, 45.9833}, CountryId{"CH"}}, // Gornergrat railway station
    {Coordinate{80.2517, 13.0203}, CountryId{"IN"}}, // Greenways Road railway station
    {Coordinate{80.0571, 12.8449}, CountryId{"IN"}}, // Guduvancheri railway station
    {Coordinate{85.2155, 25.7029}, CountryId{"IN"}}, // Hajipur Junction railway station
    {Coordinate{11.4067, 52.2847}, CountryId{"DE"}}, // Haldensleben station
    {Coordinate{88.0659, 22.0453}, CountryId{"IN"}}, // Haldia railway station
    {Coordinate{88.7828, 26.336}, CountryId{"IN"}}, // Haldibari railway station
    {Coordinate{73.0793, 18.7839}, CountryId{"IN"}}, // Hamrapur railway station
    {Coordinate{9.49806, 53.4503}, CountryId{"DE"}}, // Harsefeld station
    {Coordinate{88.9134, 22.5712}, CountryId{"IN"}}, // Hasnabad railway station
    {Coordinate{9.3898, 52.3794}, CountryId{"DE"}}, // Haste (Han) station
    {Coordinate{85.9872, 25.3658}, CountryId{"IN"}}, // Hathidah Junction
    {Coordinate{78.1371, 27.6248}, CountryId{"IN"}}, // Hathras Junction railway station
    {Coordinate{8.97224, 53.4986}, CountryId{"DE"}}, // Heinschenwalde station
    {Coordinate{8.66833, 52.1581}, CountryId{"DE"}}, // Hiddenhausen-Schweicheln station
    {Coordinate{7.76459, 46.3224}, CountryId{"CH"}}, // Hohtenn railway station
    {Coordinate{88.3759, 22.9048}, CountryId{"IN"}}, // Hooghly railway station
    {Coordinate{8.58982, 47.2588}, CountryId{"CH"}}, // Horgen Oberdorf railway station
    {Coordinate{77.8228, 12.7176}, CountryId{"IN"}}, // Hosur railway station
    {Coordinate{73.5624, 19.6941}, CountryId{"IN"}}, // Igatpuri railway station
    {Coordinate{-1.2949, 52.9794}, CountryId{"GB"}}, // Ilkeston railway station
    {Coordinate{76.2809, 10.3395}, CountryId{"IN"}}, // Irinjalakuda railway station
    {Coordinate{79.1192, 21.1578}, CountryId{"IN"}}, // Itwari railway station
    {Coordinate{76.5732, 20.813}, CountryId{"IN"}}, // Jalamb railway station
    {Coordinate{75.5629, 21.0181}, CountryId{"IN"}}, // Jalgaon railway station
    {Coordinate{88.7237, 26.5189}, CountryId{"IN"}}, // Jalpaiguri railway station
    {Coordinate{70.0539, 22.494}, CountryId{"IN"}}, // Jamnagar railway station
    {Coordinate{78.553, 25.4436}, CountryId{"IN"}}, // Virangana Lakshmibai Jhansi railway station
    {Coordinate{73.0862, 18.8196}, CountryId{"IN"}}, // Jite railway station
    {Coordinate{78.5778, 12.5609}, CountryId{"IN"}}, // Jolarpettai Junction railway station
    {Coordinate{73.0178, 19.056}, CountryId{"IN"}}, // Juinagar railway station
    {Coordinate{73.1148, 19.0356}, CountryId{"IN"}}, // Kalamboli railway station
    {Coordinate{72.9191, 19.3365}, CountryId{"IN"}}, // Kaman Road railway station
    {Coordinate{7.66061, 51.585}, CountryId{"DE"}}, // Kamen station
    {Coordinate{73.5524, 18.7669}, CountryId{"IN"}}, // Kamshet railway station
    {Coordinate{79.7051, 12.8484}, CountryId{"IN"}}, // Kanchipuram railway station
    {Coordinate{7.67148, 46.4952}, CountryId{"CH"}}, // Kandersteg railway station
    {Coordinate{73.594, 18.7624}, CountryId{"IN"}}, // Kanhe railway station
    {Coordinate{88.4052, 22.8662}, CountryId{"IN"}}, // Kankinara railway station
    {Coordinate{73.8207, 18.6076}, CountryId{"IN"}}, // Kasarwadi railway station
    {Coordinate{73.0794, 18.6406}, CountryId{"IN"}}, // Kasu railway station
    {Coordinate{80.4005, 23.8334}, CountryId{"IN"}}, // Katni Junction railway station
    {Coordinate{80.0261, 12.8057}, CountryId{"IN"}}, // Kattangulathur railway station
    {Coordinate{88.1236, 23.6398}, CountryId{"IN"}}, // Katwa Junction railway station
    {Coordinate{78.5715, 12.6265}, CountryId{"IN"}}, // Kettandapatti railway station
    {Coordinate{13.62, 53.925}, CountryId{"DE"}}, // Klein Bünzow railway station
    {Coordinate{75.8805, 25.2236}, CountryId{"IN"}}, // Kota Junction railway station
    {Coordinate{7.21349, 45.7066}, CountryId{"IT"}}, // Villeneuve railway halt
    {Coordinate{7.90852, 46.3014}, CountryId{"CH"}}, // Lalden railway station
    {Coordinate{94.3082, 26.6524}, CountryId{"IN"}}, // Mariani Junction railway station
    {Coordinate{16.3847, 48.2063}, CountryId{"AT"}}, // Landstraße (Vienna U-Bahn)
    {Coordinate{9.70713, 46.8193}, CountryId{"CH"}}, // Langwies GR railway station
    {Coordinate{22.3728, 38.8909}, CountryId{"GR"}}, // Leianokladi railway station
    {Coordinate{95.828, 27.321}, CountryId{"IN"}}, // Lekhapani railway station
    {Coordinate{8.91056, 52.0208}, CountryId{"DE"}}, // Lemgo-Lüttfeld railway station
    {Coordinate{88.3392, 22.6207}, CountryId{"IN"}}, // Liluah railway station
    {Coordinate{93.1767, 25.7502}, CountryId{"IN"}}, // Lumding Junction railway station
    {Coordinate{9.61333, 46.8317}, CountryId{"CH"}}, // Lüen-Castiel railway station
    {Coordinate{86.8695, 23.6269}, CountryId{"IN"}}, // Madhukunda railway station
    {Coordinate{76.9429, 10.9009}, CountryId{"IN"}}, // Madukkarai railway station
    {Coordinate{79.0348, 27.2165}, CountryId{"IN"}}, // Mainpuri railway station
    {Coordinate{95.441, 27.4857}, CountryId{"IN"}}, // Makum railway station
    {Coordinate{73.4806, 18.7438}, CountryId{"IN"}}, // Malavli railway station
    {Coordinate{74.4383, 20.2499}, CountryId{"IN"}}, // Manmad Junction railway station
    {Coordinate{80.0199, 12.7966}, CountryId{"IN"}}, // Maraimalai Nagar railway station
    {Coordinate{7.27056, 53.5208}, CountryId{"DE"}}, // Marienhafe station
    {Coordinate{88.0427, 23.1351}, CountryId{"IN"}}, // Masagram junction railway station
    {Coordinate{77.6731, 27.4801}, CountryId{"IN"}}, // Mathura Junction railway station
    {Coordinate{79.6287, 11.0952}, CountryId{"IN"}}, // Mayiladuthurai Junction railway station
    {Coordinate{8.27545, 47.4279}, CountryId{"CH"}}, // Mellingen Heitersberg railway station
    {Coordinate{80.2602, 13.282}, CountryId{"IN"}}, // Minjur railway station
    {Coordinate{82.5699, 25.1343}, CountryId{"IN"}}, // Mirzapur railway station
    {Coordinate{9.08121, 47.0101}, CountryId{"CH"}}, // Mitlödi railway station
    {Coordinate{59.3831, 56.2208}, CountryId{"RU"}}, // Araslanovo (railroad station in p.Araslanovo)
    {Coordinate{70.8293, 22.8253}, CountryId{"IN"}}, // Morbi railway station
    {Coordinate{-76.5028, 40.1087}, CountryId{"US"}}, // Mount Joy
    {Coordinate{76.2078, 10.5969}, CountryId{"IN"}}, // Mulankunnathukavu railway station
    {Coordinate{76.2714, 10.7058}, CountryId{"IN"}}, // Mullurkara railway station
    {Coordinate{11.7858, 48.3537}, CountryId{"DE"}}, // Munich Airport Terminal
    {Coordinate{86.8093, 23.5931}, CountryId{"IN"}}, // Muradi railway station
    {Coordinate{77.3547, 20.7361}, CountryId{"IN"}}, // Murtajapur railway station
    {Coordinate{2.32556, 48.8606}, CountryId{"FR"}}, // Musée d'Orsay
    {Coordinate{8.23507, 47.4145}, CountryId{"CH"}}, // Mägenwil railway station
    {Coordinate{7.69077, 46.6385}, CountryId{"CH"}}, // Mülenen railway station
    {Coordinate{87.8681, 24.5906}, CountryId{"IN"}}, // Nagarnabi railway station
    {Coordinate{73.1408, 18.5399}, CountryId{"IN"}}, // Nagothane railway station
    {Coordinate{88.4175, 22.8871}, CountryId{"IN"}}, // Naihati Junction railway station
    {Coordinate{91.4403, 26.4506}, CountryId{"IN"}}, // Nalbari railway station
    {Coordinate{79.2834, 17.0612}, CountryId{"IN"}}, // Nalgonda railway station
    {Coordinate{73.8419, 19.9476}, CountryId{"IN"}}, // Nasik Road railway station
    {Coordinate{14.546, 52.3223}, CountryId{"DE"}}, // Frankfurt (Oder)-Neuberesinchen
    {Coordinate{13.9033, 53.4417}, CountryId{"DE"}}, // Nechlin railway station
    {Coordinate{76.276, 10.3924}, CountryId{"IN"}}, // Nellayi railway station
    {Coordinate{79.9894, 14.4606}, CountryId{"IN"}}, // Nellore railway station
    {Coordinate{11.3918, 47.2141}, CountryId{"AT"}}, // Unterberg-Stefansbrücke railway station
    {Coordinate{11.4561, 47.278}, CountryId{"AT"}}, // Rum railway station
    {Coordinate{73.319, 19.0271}, CountryId{"IN"}}, // Neral Junction railway station
    {Coordinate{73.0181, 19.0336}, CountryId{"IN"}}, // Nerul railway station
    {Coordinate{86.1482, 23.8731}, CountryId{"IN"}}, // Netaji Subhas Chandra Bose Gomoh railway station
    {Coordinate{9.05944, 47.0645}, CountryId{"CH"}}, // Netstal railway station
    {Coordinate{9.78722, 53.4728}, CountryId{"DE"}}, // Neu Wulmstorf station
    {Coordinate{8.02207, 51.8017}, CountryId{"DE"}}, // Neubeckum station
    {Coordinate{8.33131, 47.4504}, CountryId{"CH"}}, // Neuenhof railway station
    {Coordinate{14.2139, 51.0211}, CountryId{"DE"}}, // Neustadt (Sachs) railway station
    {Coordinate{9.455, 52.5028}, CountryId{"DE"}}, // Neustadt am Rübenberge station
    {Coordinate{90.5368, 26.4758}, CountryId{"IN"}}, // New Bongaigaon Junction railway station
    {Coordinate{80.4205, 23.8136}, CountryId{"IN"}}, // New Katni Junction railway station
    {Coordinate{88.8228, 26.5784}, CountryId{"IN"}}, // New Maynaguri railway station
    {Coordinate{-3.472, 50.7023}, CountryId{"GB"}}, // Newcourt railway station, Exeter
    {Coordinate{-3.06884, 55.8671}, CountryId{"GB"}}, // Newtongrange railway station
    {Coordinate{77.0811, 8.41041}, CountryId{"IN"}}, // Neyyattinkara railway station
    {Coordinate{73.1066, 18.4722}, CountryId{"IN"}}, // Nidi railway station
    {Coordinate{9.06239, 47.1224}, CountryId{"CH"}}, // Nieder- and Oberurnen railway station
    {Coordinate{73.0799, 19.1551}, CountryId{"IN"}}, // Nilaje railway station
    {Coordinate{86.0762, 23.9321}, CountryId{"IN"}}, // Nimiaghat railway station
    {Coordinate{74.0795, 20.0966}, CountryId{"IN"}}, // Niphad railway station
    {Coordinate{7.54, 44.938}, CountryId{"IT"}}, // None railway station
    {Coordinate{9.06996, 47.0987}, CountryId{"CH"}}, // Näfels-Mollis railway station
    {Coordinate{7.03056, 49.3044}, CountryId{"DE"}}, // Fischbach-Camphausen station
    {Coordinate{6.95667, 49.2419}, CountryId{"DE"}}, // Saarbrücken-Burbach station
    {Coordinate{7.00444, 49.2653}, CountryId{"DE"}}, // Jägersfreude station
    {Coordinate{8.81047, 53.2834}, CountryId{"DE"}}, // Oldenbüttel station
    {Coordinate{-0.0172194, 51.5077}, CountryId{"GB"}}, // Poplar DLR station
    {Coordinate{8.21478, 47.4074}, CountryId{"CH"}}, // Othmarsingen railway station
    {Coordinate{83.9826, 26.8977}, CountryId{"IN"}}, // Padrauna railway station
    {Coordinate{87.743, 22.3931}, CountryId{"IN"}}, // Panskura Junction railway station
    {Coordinate{79.9837, 12.7302}, CountryId{"IN"}}, // Paranur railway station
    {Coordinate{83.4337, 18.7839}, CountryId{"IN"}}, // Parvathipuram Town railway station
    {Coordinate{85.0685, 25.6214}, CountryId{"IN"}}, // Patliputra Junction railway station
    {Coordinate{85.1368, 25.6026}, CountryId{"IN"}}, // Patna Junction railway station
    {Coordinate{9.67162, 46.8295}, CountryId{"CH"}}, // Peist railway station
    {Coordinate{73.0868, 18.7356}, CountryId{"IN"}}, // Pen railway station
    {Coordinate{7.3485, 44.8917}, CountryId{"IT"}}, // Pinerolo Olimpica railway station
    {Coordinate{7.4255, 44.9217}, CountryId{"IT"}}, // Piscina di Pinerolo railway station
    {Coordinate{77.0013, 10.6531}, CountryId{"IN"}}, // Pollachi Junction railway station
    {Coordinate{80.1988, 13.3323}, CountryId{"IN"}}, // Ponneri railway station
    {Coordinate{69.6155, 21.6436}, CountryId{"IN"}}, // Porbandar railway station
    {Coordinate{80.0369, 12.8209}, CountryId{"IN"}}, // Potheri railway station
    {Coordinate{76.2609, 10.4207}, CountryId{"IN"}}, // Pudukad railway station
    {Coordinate{78.3181, 20.7267}, CountryId{"IN"}}, // Pulgaon railway station
    {Coordinate{79.9371, 13.1229}, CountryId{"IN"}}, // Putlur railway station
    {Coordinate{77.9966, 27.1938}, CountryId{"IN"}}, // Raja ki Mandi railway station
    {Coordinate{87.8678, 24.545}, CountryId{"IN"}}, // Rajgram railway station
    {Coordinate{79.3068, 9.28097}, CountryId{"IN"}}, // Rameswaram railway station
    {Coordinate{86.7623, 23.5799}, CountryId{"IN"}}, // Ramkanali Junction railway station
    {Coordinate{88.5688, 23.1741}, CountryId{"IN"}}, // Ranaghat Junction railway station
    {Coordinate{91.6059, 26.4479}, CountryId{"IN"}}, // Rangiya railway station
    {Coordinate{87.1174, 23.6037}, CountryId{"IN"}}, // Raniganj railway station
    {Coordinate{73.1519, 18.894}, CountryId{"IN"}}, // Rasayani railway station
    {Coordinate{7.69077, 46.6249}, CountryId{"CH"}}, // Reichenbach im Kandertal railway station
    {Coordinate{80.8287, 16.0198}, CountryId{"IN"}}, // Repalle railway station
    {Coordinate{8.71208, 47.1968}, CountryId{"CH"}}, // Riedmatt railway station
    {Coordinate{73.1236, 18.4465}, CountryId{"IN"}}, // Roha railway station
    {Coordinate{87.9693, 23.2071}, CountryId{"IN"}}, // Saktigarh railway station
    {Coordinate{70.5034, 23.3098}, CountryId{"IN"}}, // Samakhiali Junction railway station
    {Coordinate{7.7822, 45.2186}, CountryId{"IT"}}, // San Benigno Canavese railway station
    {Coordinate{9.65384, 46.8292}, CountryId{"CH"}}, // St. Peter-Molinis railway station
    {Coordinate{76.3562, 26.0183}, CountryId{"IN"}}, // Sawai Madhopur railway station
    {Coordinate{10.2288, 50.0401}, CountryId{"DE"}}, // Schweinfurt Mitte
    {Coordinate{24.6171, 56.8082}, CountryId{"LV"}}, // Pārogre
    {Coordinate{88.3284, 22.7748}, CountryId{"IN"}}, // Seoraphuli Junction railway station
    {Coordinate{78.575, 27.0857}, CountryId{"IN"}}, // Shikohabad railway station
    {Coordinate{80.0011, 12.7625}, CountryId{"IN"}}, // Singaperumal Koil railway station
    {Coordinate{7.045, 49.1431}, CountryId{"DE"}}, // Auersmacher
    {Coordinate{7.03472, 49.1794}, CountryId{"DE"}}, // Bübingen
    {Coordinate{7.03083, 49.1975}, CountryId{"DE"}}, // Güdingen
    {Coordinate{7.04917, 49.2278}, CountryId{"DE"}}, // Schafbrücke station
    {Coordinate{7.99924, 49.0327}, CountryId{"DE"}}, // Schweighofen train station
    {Coordinate{70.4083, 20.8961}, CountryId{"IN"}}, // Somnath railway station
    {Coordinate{73.1455, 18.9522}, CountryId{"IN"}}, // Somtane railway station
    {Coordinate{8.00701, 48.5925}, CountryId{"DE"}}, // Renchen station
    {Coordinate{8.01043, 48.4047}, CountryId{"DE"}}, // Gengenbach station
    {Coordinate{7.62816, 47.8553}, CountryId{"DE"}}, // Buggingen station
    {Coordinate{7.56894, 47.7616}, CountryId{"DE"}}, // Schliengen station
    {Coordinate{7.05765, 47.4398}, CountryId{"CH"}}, // Courchavon railway station
    {Coordinate{7.12825, 47.4242}, CountryId{"CH"}}, // Alle railway station
    {Coordinate{7.01656, 47.4926}, CountryId{"CH"}}, // Boncourt railway station
    {Coordinate{6.47939, 46.9053}, CountryId{"CH"}}, // Les Verrières
    {Coordinate{3.92254, 50.3062}, CountryId{"FR"}}, // Feignies railway station
    {Coordinate{12.5382, 56.075}, CountryId{"DK"}}, // Ålsgårde station
    {Coordinate{8.29229, 55.6538}, CountryId{"DK"}}, // Vrøgum railway station
    {Coordinate{8.80203, 55.0094}, CountryId{"DK"}}, // Visby Station
    {Coordinate{10.1594, 56.1219}, CountryId{"DK"}}, // Viby J station
    {Coordinate{8.57928, 55.4665}, CountryId{"DK"}}, // Tjæreborg Station
    {Coordinate{8.3058, 56.1953}, CountryId{"DK"}}, // Tim railway station
    {Coordinate{9.73958, 47.5029}, CountryId{"AT"}}, // Bregenz railway station
    {Coordinate{8.00294, 49.4143}, CountryId{"DE"}}, // Weidenthal station
    {Coordinate{7.80615, 49.1024}, CountryId{"DE"}}, // Bundenthal-Rumbach railway station
    {Coordinate{8.12722, 49.2839}, CountryId{"DE"}}, // Edenkoben station
    {Coordinate{4.87111, 46.3922}, CountryId{"FR"}}, // Gare de Senozan
    {Coordinate{4.88409, 46.4509}, CountryId{"FR"}}, // Gare de Fleurville - Pont-de-Vaux
    {Coordinate{9.65073, 46.6712}, CountryId{"CH"}}, // Alvaneu railway station
    {Coordinate{7.84079, 49.8067}, CountryId{"DE"}}, // Bahnhof Ebernburg
    {Coordinate{37.3815, 55.6395}, CountryId{"RU"}}, // Novoperedelkino
    {Coordinate{10.4669, 59.8497}, CountryId{"NO"}}, // Vakås Station
    {Coordinate{10.6072, 59.9081}, CountryId{"NO"}}, // Stabekk Station
    {Coordinate{12.4294, 50.8931}, CountryId{"DE"}}, // Gößnitz
    {Coordinate{6.23055, 50.7643}, CountryId{"DE"}}, // Stolberg-Altstadt railway station
    {Coordinate{16.3949, 48.2465}, CountryId{"AT"}}, // Neue Donau
    {Coordinate{8.07051, 49.5545}, CountryId{"DE"}}, // Eisenberg (Pfalz) station
    {Coordinate{83.1584, 19.9339}, CountryId{"IN"}}, // Bhawanipatna railway station
    {Coordinate{3.54684, 47.5269}, CountryId{"FR"}}, // Q15401642
    {Coordinate{3.63513, 47.5378}, CountryId{"FR"}}, // Gare de Châtel-Censoir
    {Coordinate{3.67473, 47.604}, CountryId{"FR"}}, // Gare de Mailly-la-Ville et PN 41
    {Coordinate{12.4587, 52.4996}, CountryId{"DE"}}, // Pritzerbe station
    {Coordinate{11.94, 48.0433}, CountryId{"DE"}}, // Grafing Bahnhof
    {Coordinate{78.1554, 8.80611}, CountryId{"IN"}}, // Thoothukudi railway station
    {Coordinate{15.4484, 47.0538}, CountryId{"AT"}}, // Graz Ostbahnhof-Messe
    {Coordinate{13.5204, 51.2963}, CountryId{"DE"}}, // Großenhain Berliner Bahnhof
    {Coordinate{11.5309, 48.0711}, CountryId{"DE"}}, // Großhesselohe Isartalbahnhof
    {Coordinate{14.1085, 59.3165}, CountryId{"SE"}}, // Kristinehamn railway station
    {Coordinate{7.75058, 49.1975}, CountryId{"DE"}}, // Hinterweidenthal Ort
    {Coordinate{13.3164, 59.505}, CountryId{"SE"}}, // Kil railway station
    {Coordinate{12.5198, 48.248}, CountryId{"DE"}}, // Mühldorf (Oberbay)
    {Coordinate{13.2476, 51.5833}, CountryId{"DE"}}, // Falkenberg (Elster) station
    {Coordinate{17.1666, 49.4417}, CountryId{"CZ"}}, // Bedihošť
    {Coordinate{30.7711, 50.4125}, CountryId{"UA"}}, // Imeni Heorhiia Kirpy
    {Coordinate{14.4694, 50.1267}, CountryId{"CZ"}}, // Ládví
    {Coordinate{17.5328, 59.5689}, CountryId{"SE"}}, // Bålsta railway station
    {Coordinate{13.6559, 51.1031}, CountryId{"DE"}}, // Radebeul-Weintraube station
    {Coordinate{17.9508, 58.9008}, CountryId{"SE"}}, // Nynäshamn railway station
    {Coordinate{79.3161, 11.535}, CountryId{"IN"}}, // Vriddhachalam railway station
    {Coordinate{6.09389, 46.2207}, CountryId{"CH"}}, // Vernier railway station
    {Coordinate{6.0769, 46.2223}, CountryId{"CH"}}, // Meyrin railway station
    {Coordinate{6.06599, 46.2212}, CountryId{"CH"}}, // Zimeysa railway station
    {Coordinate{13.0709, 42.41}, CountryId{"IT"}}, // Antrodoco-Borgo Velino railway station
    {Coordinate{13.0763, 42.4154}, CountryId{"IT"}}, // Antrodoco Centro railway halt
    {Coordinate{13.096, 42.398}, CountryId{"IT"}}, // Rocca di Fondi railway station
    {Coordinate{13.1443, 42.3884}, CountryId{"IT"}}, // Rocca di Corno train station
    {Coordinate{13.19, 42.3606}, CountryId{"IT"}}, // Sella di Corno railway station
    {Coordinate{13.5367, 42.2945}, CountryId{"IT"}}, // San Demetrio de’ Vestini railway station
    {Coordinate{13.5629, 42.2507}, CountryId{"IT"}}, // Fagnano-Campana railway station
    {Coordinate{13.6044, 42.2228}, CountryId{"IT"}}, // Q15617152
    {Coordinate{13.642, 42.2049}, CountryId{"IT"}}, // Q15617153
    {Coordinate{13.6609, 42.1974}, CountryId{"IT"}}, // Beffi railway station
    {Coordinate{13.8091, 42.0981}, CountryId{"IT"}}, // Raiano railway station
    {Coordinate{13.8721, 42.0804}, CountryId{"IT"}}, // Pratola Peligna Superiore railway station
    {Coordinate{13.7111, 42.1767}, CountryId{"IT"}}, // Acciano railway station
    {Coordinate{10.6475, 45.1443}, CountryId{"IT"}}, // Castellucchio railway station
    {Coordinate{10.6043, 45.1298}, CountryId{"IT"}}, // Ospitaletto Mantovano railway halt
    {Coordinate{10.5735, 45.1225}, CountryId{"IT"}}, // San Michele in Bosco railway halt
    {Coordinate{10.5337, 45.1244}, CountryId{"IT"}}, // Marcaria railway station
    {Coordinate{14.25, 51.4333}, CountryId{"DE"}}, // Hoyerswerda railway station
    {Coordinate{7.05539, 49.2994}, CountryId{"DE"}}, // Sulzbach (Saar) station
    {Coordinate{12.3753, 51.3355}, CountryId{"DE"}}, // Leipzig Wilhelm-Leuschner-Platz
    {Coordinate{11.189, 54.4417}, CountryId{"DE"}}, // Fehmarn-Burg station
    {Coordinate{76.5803, 9.39215}, CountryId{"IN"}}, // Tiruvalla railway station
    {Coordinate{9.59089, 47.4669}, CountryId{"CH"}}, // Rheineck railway station
    {Coordinate{9.50512, 47.478}, CountryId{"CH"}}, // Rorschach railway station
    {Coordinate{9.63824, 47.4532}, CountryId{"CH"}}, // St. Margrethen railway station
    {Coordinate{14.0922, 51.2739}, CountryId{"DE"}}, // Kamenz railway station
    {Coordinate{74.858, 31.6315}, CountryId{"IN"}}, // Amritsar railway station
    {Coordinate{80.8603, 26.8471}, CountryId{"IN"}}, // Alamnagar railway station
    {Coordinate{80.9096, 26.8374}, CountryId{"IN"}}, // Aishbagh junction railway station
    {Coordinate{77.187, 28.5821}, CountryId{"IN"}}, // Delhi Safdarjung railway station
    {Coordinate{39.9743, 43.412}, CountryId{"RU"}}, // Olympic Park
    {Coordinate{8.74647, 49.179}, CountryId{"DE"}}, // Odenheim train station
    {Coordinate{73.3166, 28.0141}, CountryId{"IN"}}, // Bikaner Junction railway station
    {Coordinate{25.177, 54.63}, CountryId{"LT"}}, // Paneriai train station
    {Coordinate{25.216, 54.594}, CountryId{"LT"}}, // Vaidotai train station
    {Coordinate{77.8097, 16.2251}, CountryId{"IN"}}, // Gadwal railway station
    {Coordinate{14.4489, 50.0642}, CountryId{"CZ"}}, // Praha-Vršovice railway station
    {Coordinate{78.0416, 15.9157}, CountryId{"IN"}}, // Jogulamba Halt railway station
    {Coordinate{17.7759, 48.4417}, CountryId{"SK"}}, // Leopoldov zastávka
    {Coordinate{17.759, 48.4417}, CountryId{"SK"}}, // Leopoldov station
    {Coordinate{82.7246, 17.4529}, CountryId{"IN"}}, // Narsipatnam Road railway station
    {Coordinate{24.8453, 48.7364}, CountryId{"UA"}}, // Otyniia
    {Coordinate{25.9303, 48.3014}, CountryId{"UA"}}, // Chernivtsi Railway Station
    {Coordinate{8.191, 53.2446}, CountryId{"DE"}}, // Rastede railway station
    {Coordinate{8.14995, 53.399}, CountryId{"DE"}}, // Varel railway station
    {Coordinate{8.03183, 53.4899}, CountryId{"DE"}}, // Sande railway station
    {Coordinate{8.1149, 53.5188}, CountryId{"DE"}}, // Wilhelmshaven railway station
    {Coordinate{8.33681, 53.1182}, CountryId{"DE"}}, // Wüsting railway station
    {Coordinate{8.6799, 53.0571}, CountryId{"DE"}}, // Heidkrug railway station
    {Coordinate{8.5329, 53.0991}, CountryId{"DE"}}, // Bookholzberg railway station
    {Coordinate{8.5786, 53.085}, CountryId{"DE"}}, // Schierbrok railway station
    {Coordinate{8.5989, 53.0695}, CountryId{"DE"}}, // Hoykenkamp railway station
    {Coordinate{11.3677, 44.5777}, CountryId{"IT"}}, // Castelmaggiore railway station
    {Coordinate{11.3789, 44.6467}, CountryId{"IT"}}, // San Giorgio di Piano railway station
    {Coordinate{11.4046, 44.698}, CountryId{"IT"}}, // San Pietro in Casale railway station
    {Coordinate{11.4417, 44.7377}, CountryId{"IT"}}, // Galliera railway station
    {Coordinate{11.5439, 44.7958}, CountryId{"IT"}}, // Coronella railway station
    {Coordinate{10.9779, 44.1558}, CountryId{"IT"}}, // Porretta Terme railway station
    {Coordinate{10.9807, 44.1776}, CountryId{"IT"}}, // Silla railway station
    {Coordinate{11.0535, 44.23}, CountryId{"IT"}}, // Riola railway station
    {Coordinate{11.1141, 44.2828}, CountryId{"IT"}}, // Vergato railway station
    {Coordinate{11.1618, 44.3106}, CountryId{"IT"}}, // Pioppe di Salvaro railway station
    {Coordinate{41.4461, 56.3897}, CountryId{"RU"}}, // Q15714625
    {Coordinate{7.59, 50.3575}, CountryId{"DE"}}, // Koblenz Stadtmitte station
    {Coordinate{10.6981, 53.8022}, CountryId{"DE"}}, // Lübeck-Flughafen station
    {Coordinate{7.01861, 49.2303}, CountryId{"DE"}}, // Saarbrücken Ost station
    {Coordinate{13.6619, 51.1061}, CountryId{"DE"}}, // Weißes Roß
    {Coordinate{16.3064, 48.1982}, CountryId{"AT"}}, // Wien Breitensee railway station
    {Coordinate{16.329, 48.2313}, CountryId{"AT"}}, // Wien Gersthof
    {Coordinate{16.3411, 48.2401}, CountryId{"AT"}}, // Wien Krottenbachstraße railway station
    {Coordinate{16.3587, 48.1802}, CountryId{"AT"}}, // Wien Matzleinsdorfer Platz railway station
    {Coordinate{16.3443, 48.2444}, CountryId{"AT"}}, // Wien Oberdöbling railway station
    {Coordinate{16.3818, 48.188}, CountryId{"AT"}}, // Wien Quartier Belvedere railway station
    {Coordinate{16.3834, 48.2348}, CountryId{"AT"}}, // Wien Traisengasse railway station
    {Coordinate{12.3865, 51.3009}, CountryId{"DE"}}, // Leipzig-Connewitz
    {Coordinate{14.201, 50.7735}, CountryId{"CZ"}}, // Děčín hlavní nádraží
    {Coordinate{14.8872, 50.4073}, CountryId{"CZ"}}, // Mladá Boleslav Main Station
    {Coordinate{14.5333, 50.6752}, CountryId{"CZ"}}, // Česká Lípa hlavní nádraží
    {Coordinate{14.5441, 50.0974}, CountryId{"CZ"}}, // Praha-Kyje
    {Coordinate{25.355, 54.679}, CountryId{"LT"}}, // Pavilnys train station
    {Coordinate{9.46722, 51.23}, CountryId{"DE"}}, // Baunatal-Guntershausen
    {Coordinate{7.28184, 49.2619}, CountryId{"DE"}}, // Bierbach station
    {Coordinate{7.77131, 49.1547}, CountryId{"DE"}}, // Dahn railway station
    {Coordinate{8.10822, 49.564}, CountryId{"DE"}}, // Ebertsheim station
    {Coordinate{7.45633, 49.4948}, CountryId{"DE"}}, // Matzenbach station
    {Coordinate{13.5184, 51.4722}, CountryId{"DE"}}, // Elsterwerda-Biehla station
    {Coordinate{8.21066, 49.4884}, CountryId{"DE"}}, // Erpolzheim station
    {Coordinate{7.96985, 49.439}, CountryId{"DE"}}, // Frankenstein (Pfalz) station
    {Coordinate{9.59564, 49.6981}, CountryId{"DE"}}, // Bahnhof Gamburg
    {Coordinate{11.5014, 47.2769}, CountryId{"AT"}}, // Hall in Tirol railway station
    {Coordinate{8.67521, 49.3799}, CountryId{"DE"}}, // Heidelberg-Kirchheim/Rohrbach station
    {Coordinate{8.72357, 48.4823}, CountryId{"DE"}}, // Hochdorf (b Horb) station
    {Coordinate{7.74978, 49.4475}, CountryId{"DE"}}, // Kaiserslautern West station
    {Coordinate{7.83509, 48.3403}, CountryId{"DE"}}, // Lahr (Schwarzw) station
    {Coordinate{7.56602, 49.4163}, CountryId{"DE"}}, // Landstuhl station
    {Coordinate{9.14595, 49.0764}, CountryId{"DE"}}, // Bahnhof Lauffen
    {Coordinate{8.13336, 50.3776}, CountryId{"DE"}}, // Lindenholzhausen station
    {Coordinate{8.84145, 49.4048}, CountryId{"DE"}}, // Neckarsteinach station
    {Coordinate{8.16125, 50.3593}, CountryId{"DE"}}, // Niederbrechen station
    {Coordinate{8.18806, 50.3546}, CountryId{"DE"}}, // Oberbrechen station
    {Coordinate{7.70987, 47.285}, CountryId{"CH"}}, // Oensingen railway station
    {Coordinate{13.0786, 47.7888}, CountryId{"AT"}}, // Salzburg-Aigen railway station
    {Coordinate{10.1739, 51.8875}, CountryId{"DE"}}, // Seesen station
    {Coordinate{11.0484, 48.0945}, CountryId{"DE"}}, // St. Ottilien station
    {Coordinate{7.16564, 49.467}, CountryId{"DE"}}, // St. Wendel station
    {Coordinate{10.5627, 51.9552}, CountryId{"DE"}}, // Vienenburg station
    {Coordinate{26.3108, 56.1844}, CountryId{"LV"}}, // Sergunta
    {Coordinate{26.478, 55.9338}, CountryId{"LV"}}, // 383. kilometers
    {Coordinate{26.4997, 55.8954}, CountryId{"LV"}}, // 387. kilometers
    {Coordinate{8.78281, 48.4798}, CountryId{"DE"}}, // Eutingen im Gäu station
    {Coordinate{8.1813, 49.5372}, CountryId{"DE"}}, // Kirchheim (Weinstr) station
    {Coordinate{9.73397, 49.1082}, CountryId{"DE"}}, // Schwäbisch Hall station
    {Coordinate{9.36794, 49.5783}, CountryId{"DE"}}, // Walldürn
    {Coordinate{24.2532, 56.883}, CountryId{"LV"}}, // Rumbula
    {Coordinate{24.3242, 56.8644}, CountryId{"LV"}}, // Dole
    {Coordinate{24.4367, 56.8496}, CountryId{"LV"}}, // Saulkalne
    {Coordinate{24.6535, 56.7821}, CountryId{"LV"}}, // Ciemupe
    {Coordinate{25.206, 56.6311}, CountryId{"LV"}}, // Muldakmens
    {Coordinate{14.3979, 52.3369}, CountryId{"DE"}}, // Pillgram station
    {Coordinate{14.2814, 52.3464}, CountryId{"DE"}}, // Briesen (Mark) station
    {Coordinate{14.1653, 52.3571}, CountryId{"DE"}}, // Berkenbrück station
    {Coordinate{13.922, 52.4}, CountryId{"DE"}}, // Hangelsberg station
    {Coordinate{13.8716, 53.5283}, CountryId{"DE"}}, // Blumenhagen
    {Coordinate{14.1544, 53.1851}, CountryId{"DE"}}, // Schönow (Kr Uckermark)
    {Coordinate{14.2528, 53.24}, CountryId{"DE"}}, // Petershagen
    {Coordinate{14.148, 53.9529}, CountryId{"DE"}}, // Heringsdorf Neuhof railway station
    {Coordinate{13.694, 52.7746}, CountryId{"DE"}}, // Melchow
    {Coordinate{13.9287, 52.8307}, CountryId{"DE"}}, // Niederfinow
    {Coordinate{13.6752, 52.7558}, CountryId{"DE"}}, // Biesenthal
    {Coordinate{30.6058, 46.5247}, CountryId{"UA"}}, // Usatove
    {Coordinate{29.5361, 45.9889}, CountryId{"UA"}}, // Hnadental
    {Coordinate{10.9025, 47.8123}, CountryId{"DE"}}, // Schongau station
    {Coordinate{6.12495, 46.1859}, CountryId{"CH"}}, // Lancy-Pont-Rouge railway station
    {Coordinate{12.3793, 51.2501}, CountryId{"DE"}}, // Markkleeberg-Gaschwitz
    {Coordinate{12.3764, 51.2622}, CountryId{"DE"}}, // Markkleeberg-Großstädteln
    {Coordinate{11.2729, 43.3856}, CountryId{"IT"}}, // Badesse
    {Coordinate{11.4063, 43.2944}, CountryId{"IT"}}, // Arbia railway station
    {Coordinate{10.4707, 43.5866}, CountryId{"IT"}}, // Collesalvetti railway station
    {Coordinate{12.3663, 51.367}, CountryId{"DE"}}, // Leipzig Coppiplatz railway station
    {Coordinate{8.56693, 44.3568}, CountryId{"IT"}}, // Varazze railway station
    {Coordinate{2.8411, 50.3352}, CountryId{"FR"}}, // Gare de Bailleul-Sir-Berthoult
    {Coordinate{-93.0861, 44.9478}, CountryId{"US"}}, // Saint Paul Union Depot
    {Coordinate{13.1138, 59.3531}, CountryId{"SE"}}, // Grums railway station
    {Coordinate{12.4648, 58.7019}, CountryId{"SE"}}, // Mellerud railway station
    {Coordinate{14.56, 61.0091}, CountryId{"SE"}}, // Mora Station
    {Coordinate{8.15941, 49.355}, CountryId{"DE"}}, // Neustadt (Weinstr)-Böbig station
    {Coordinate{10.8812, 51.6609}, CountryId{"DE"}}, // Bahnhof Stiege
    {Coordinate{15.0186, 60.8182}, CountryId{"SE"}}, // Tällberg station
    {Coordinate{14.5989, 49.4458}, CountryId{"CZ"}}, // Q15886695
    {Coordinate{15.3983, 49.3175}, CountryId{"CZ"}}, // Batelov
    {Coordinate{14.4777, 49.3}, CountryId{"CZ"}}, // Bechyně railway station
    {Coordinate{15.0911, 49.1397}, CountryId{"CZ"}}, // Blažejov (train station)
    {Coordinate{13.5314, 49.5808}, CountryId{"CZ"}}, // Blovice railway station
    {Coordinate{14.6425, 48.8911}, CountryId{"CZ"}}, // Borovany (train station)
    {Coordinate{14.4442, 48.9269}, CountryId{"CZ"}}, // Boršov nad Vltavou (train station)
    {Coordinate{14.4925, 49.4475}, CountryId{"CZ"}}, // Q15886733
    {Coordinate{14.3456, 49.4025}, CountryId{"CZ"}}, // Q15886735
    {Coordinate{14.6666, 49.7415}, CountryId{"CZ"}}, // Bystřice u Benešova
    {Coordinate{12.843, 50.8156}, CountryId{"DE"}}, // Bahnhof Chemnitz-Siegmar
    {Coordinate{14.8681, 48.9503}, CountryId{"CZ"}}, // Majdalena
    {Coordinate{14.6689, 49.4736}, CountryId{"CZ"}}, // Chotoviny
    {Coordinate{14.5292, 49.0783}, CountryId{"CZ"}}, // Chotýčany
    {Coordinate{14.9839, 49.3419}, CountryId{"CZ"}}, // Chválkov
    {Coordinate{14.8108, 49.4153}, CountryId{"CZ"}}, // Chýnov
    {Coordinate{15.6417, 49.4783}, CountryId{"CZ"}}, // Dobronín
    {Coordinate{14.7994, 49.2081}, CountryId{"CZ"}}, // Q15886782
    {Coordinate{14.6292, 49.1467}, CountryId{"CZ"}}, // Q15886785
    {Coordinate{14.3008, 49.1061}, CountryId{"CZ"}}, // Dívčice
    {Coordinate{14.5834, 49.6031}, CountryId{"CZ"}}, // Heřmaničky
    {Coordinate{14.42, 49.0325}, CountryId{"CZ"}}, // Hluboká nad Vltavou railway station
    {Coordinate{15.3244, 49.3108}, CountryId{"CZ"}}, // Horní Cerekev
    {Coordinate{14.0261, 48.7647}, CountryId{"CZ"}}, // Horní Planá
    {Coordinate{14.6661, 49.1672}, CountryId{"CZ"}}, // Horusice
    {Coordinate{14.1828, 48.7714}, CountryId{"CZ"}}, // Q15886817
    {Coordinate{15.0789, 49.1819}, CountryId{"CZ"}}, // Jarošov nad Nežárkou
    {Coordinate{14.6072, 49.5769}, CountryId{"CZ"}}, // Ješetice
    {Coordinate{15.5995, 49.4147}, CountryId{"CZ"}}, // Jihlava railway station
    {Coordinate{15.2947, 49.2525}, CountryId{"CZ"}}, // Jihlávka
    {Coordinate{15.0042, 49.155}, CountryId{"CZ"}}, // Jindřichův Hradec
    {Coordinate{14.7044, 48.8772}, CountryId{"CZ"}}, // Jílovice
    {Coordinate{15.0744, 49.295}, CountryId{"CZ"}}, // Kamenice nad Lipou
    {Coordinate{14.8605, 49.1836}, CountryId{"CZ"}}, // Kardašova Řečice
    {Coordinate{13.8233, 49.2692}, CountryId{"CZ"}}, // Katovice
    {Coordinate{14.4802, 49.6593}, CountryId{"CZ"}}, // Kosova Hora
    {Coordinate{9.5991, 47.594}, CountryId{"DE"}}, // Kressbronn
    {Coordinate{14.2658, 48.8128}, CountryId{"CZ"}}, // Kájov
    {Coordinate{14.3313, 48.9046}, CountryId{"CZ"}}, // Křemže
    {Coordinate{14.7297, 49.0911}, CountryId{"CZ"}}, // Q15886904
    {Coordinate{15.0506, 49.2014}, CountryId{"CZ"}}, // Lovětín
    {Coordinate{14.5853, 49.3594}, CountryId{"CZ"}}, // Q15886917
    {Coordinate{14.3775, 49.4417}, CountryId{"CZ"}}, // Milevsko
    {Coordinate{13.6083, 49.4975}, CountryId{"CZ"}}, // Nepomuk
    {Coordinate{13.5164, 49.6422}, CountryId{"CZ"}}, // Nezvěstice station
    {Coordinate{15.1108, 49.0189}, CountryId{"CZ"}}, // Nová Bystřice
    {Coordinate{15.1175, 49.4256}, CountryId{"CZ"}}, // Q15886945
    {Coordinate{13.9531, 48.7897}, CountryId{"CZ"}}, // Nová Pec (train station)
    {Coordinate{14.9228, 48.8117}, CountryId{"CZ"}}, // Nová Ves nad Lužnicí
    {Coordinate{15.0664, 49.2369}, CountryId{"CZ"}}, // Q15886952
    {Coordinate{14.8089, 48.8231}, CountryId{"CZ"}}, // Nové Hrady
    {Coordinate{14.9539, 49.4289}, CountryId{"CZ"}}, // Obrataň
    {Coordinate{14.6241, 49.6668}, CountryId{"CZ"}}, // Olbramovice (train station)
    {Coordinate{15.0172, 49.4599}, CountryId{"CZ"}}, // Q15886973
    {Coordinate{13.6206, 49.3913}, CountryId{"CZ"}}, // Pačejov railway station
    {Coordinate{15.2225, 49.4192}, CountryId{"CZ"}}, // Q15886977
    {Coordinate{14.7058, 49.3539}, CountryId{"CZ"}}, // Planá nad Lužnicí
    {Coordinate{14.1203, 48.7994}, CountryId{"CZ"}}, // Q15886990
    {Coordinate{14.1478, 48.7983}, CountryId{"CZ"}}, // Polná na Šumavě
    {Coordinate{15.1786, 49.2203}, CountryId{"CZ"}}, // Popelín
    {Coordinate{14.7822, 49.7378}, CountryId{"CZ"}}, // Postupice
    {Coordinate{14.2117, 49.2122}, CountryId{"CZ"}}, // Protivín
    {Coordinate{14.1314, 49.2639}, CountryId{"CZ"}}, // Putim
    {Coordinate{14.1428, 49.2964}, CountryId{"CZ"}}, // Písek
    {Coordinate{15.5131, 49.4066}, CountryId{"CZ"}}, // Rantířov (train station)
    {Coordinate{14.1083, 49.2447}, CountryId{"CZ"}}, // Ražice
    {Coordinate{14.7153, 49.2969}, CountryId{"CZ"}}, // Roudná
    {Coordinate{14.4339, 49.6558}, CountryId{"CZ"}}, // Sedlčany
    {Coordinate{14.7256, 49.2556}, CountryId{"CZ"}}, // Soběslav
    {Coordinate{13.4783, 49.6953}, CountryId{"CZ"}}, // Starý Plzenec station
    {Coordinate{13.9158, 49.2553}, CountryId{"CZ"}}, // Strakonice
    {Coordinate{14.6775, 49.9494}, CountryId{"CZ"}}, // Strančice
    {Coordinate{13.7789, 49.3053}, CountryId{"CZ"}}, // Q15887089
    {Coordinate{14.6216, 49.5384}, CountryId{"CZ"}}, // Střezimíř
    {Coordinate{15.1344, 49.1347}, CountryId{"CZ"}}, // Střížovice
    {Coordinate{14.8825, 48.9022}, CountryId{"CZ"}}, // Q15887096
    {Coordinate{14.5411, 49.295}, CountryId{"CZ"}}, // Q15887098
    {Coordinate{14.6598, 49.5073}, CountryId{"CZ"}}, // Sudoměřice u Tábora
    {Coordinate{14.6553, 49.6989}, CountryId{"CZ"}}, // Q15887116
    {Coordinate{15.0094, 49.7075}, CountryId{"CZ"}}, // Trhový Štěpánov
    {Coordinate{14.7606, 49.0153}, CountryId{"CZ"}}, // Třeboň
    {Coordinate{14.7167, 49.1936}, CountryId{"CZ"}}, // Veselí nad Lužnicí
    {Coordinate{14.2231, 49.3692}, CountryId{"CZ"}}, // Q15887130
    {Coordinate{14.8975, 49.7003}, CountryId{"CZ"}}, // Vlašim
    {Coordinate{14.6196, 49.6379}, CountryId{"CZ"}}, // Votice
    {Coordinate{14.3514, 48.8506}, CountryId{"CZ"}}, // Zlatá Koruna
    {Coordinate{14.3618, 49.0655}, CountryId{"CZ"}}, // Zliv railway station
    {Coordinate{14.2036, 49.3431}, CountryId{"CZ"}}, // Záhoří
    {Coordinate{14.0156, 49.2517}, CountryId{"CZ"}}, // Čejetice
    {Coordinate{14.0867, 48.7428}, CountryId{"CZ"}}, // Q15887182
    {Coordinate{14.7017, 49.8514}, CountryId{"CZ"}}, // Čerčany
    {Coordinate{14.9572, 48.7694}, CountryId{"CZ"}}, // České Velenice
    {Coordinate{14.3172, 48.8222}, CountryId{"CZ"}}, // Český Krumlov train station
    {Coordinate{14.2216, 49.1536}, CountryId{"CZ"}}, // Číčenice station
    {Coordinate{14.6642, 49.9969}, CountryId{"CZ"}}, // Říčany
    {Coordinate{14.5742, 49.0975}, CountryId{"CZ"}}, // Ševětín
    {Coordinate{15.6526, 49.5452}, CountryId{"CZ"}}, // Q15887220
    {Coordinate{14.5169, 49.6667}, CountryId{"CZ"}}, // Q15887224
    {Coordinate{8.35117, 49.0145}, CountryId{"DE"}}, // Karlsruhe-Mühlburg station
    {Coordinate{38.035, 48.7153}, CountryId{"UA"}}, // Sil Railway Station
    {Coordinate{126.228, 58.9669}, CountryId{"RU"}}, // Tommot
    {Coordinate{125.552, 58.7911}, CountryId{"RU"}}, // Kuranakh
    {Coordinate{16.4261, 48.1542}, CountryId{"AT"}}, // Wien Zentralfriedhof
    {Coordinate{84.8741, 25.5609}, CountryId{"IN"}}, // Bihta railway station
    {Coordinate{8.2831, 45.7163}, CountryId{"IT"}}, // Borgosesia railway station
    {Coordinate{11.6305, 52.1093}, CountryId{"DE"}}, // Bahnhof Magdeburg-Buckau
    {Coordinate{7.5631, 52.0218}, CountryId{"DE"}}, // Münster-Häger station
    {Coordinate{7.48186, 52.0515}, CountryId{"DE"}}, // Altenberge station
    {Coordinate{7.03005, 52.1836}, CountryId{"DE"}}, // Epe (Westf) railway station
    {Coordinate{7.18419, 52.2016}, CountryId{"DE"}}, // Ochtrup station
    {Coordinate{7.37545, 52.1232}, CountryId{"DE"}}, // Steinfurt-Grottenkamp station
    {Coordinate{7.39696, 52.1188}, CountryId{"DE"}}, // Steinfurt-Borghorst station
    {Coordinate{7.46133, 52.0778}, CountryId{"DE"}}, // Nordwalde station
    {Coordinate{7.78105, 51.9811}, CountryId{"DE"}}, // Telgte station
    {Coordinate{7.5282, 51.9146}, CountryId{"DE"}}, // Münster-Albachten station
    {Coordinate{7.59895, 51.8841}, CountryId{"DE"}}, // Münster-Amelsbüren station
    {Coordinate{7.59877, 51.8171}, CountryId{"DE"}}, // Davensberg station
    {Coordinate{7.6892, 51.8446}, CountryId{"DE"}}, // Rinkerode station
    {Coordinate{9.0315, 53.0158}, CountryId{"DE"}}, // Achim railway station
    {Coordinate{9.2464, 52.8469}, CountryId{"DE"}}, // Dörverden railway station
    {Coordinate{9.23139, 52.7829}, CountryId{"DE"}}, // Eystrup railway station
    {Coordinate{9.87639, 53.3244}, CountryId{"DE"}}, // Buchholz (Nordheide) railway station
    {Coordinate{9.19497, 52.9779}, CountryId{"DE"}}, // Langwedel railway station
    {Coordinate{9.69877, 52.4585}, CountryId{"DE"}}, // Hannover Flughafen railway station
    {Coordinate{10.1105, 52.3547}, CountryId{"DE"}}, // Hämelerwald station
    {Coordinate{9.8429, 52.2328}, CountryId{"DE"}}, // Sarstedt railway station
    {Coordinate{9.45102, 52.4222}, CountryId{"DE"}}, // Wunstorf station
    {Coordinate{7.88684, 53.2022}, CountryId{"DE"}}, // Westerstede-Ocholt railway station
    {Coordinate{9.7319, 53.2717}, CountryId{"DE"}}, // Tostedt railway station
    {Coordinate{10.359, 52.2579}, CountryId{"DE"}}, // Vechelde station
    {Coordinate{8.25528, 53.0545}, CountryId{"DE"}}, // Sandkrug railway station
    {Coordinate{8.26644, 52.9905}, CountryId{"DE"}}, // Huntlosen railway station
    {Coordinate{8.01466, 53.5074}, CountryId{"DE"}}, // Sanderbusch railway station
    {Coordinate{8.8871, 53.054}, CountryId{"DE"}}, // Bremen-Hemelingen
    {Coordinate{9.08192, 53.0077}, CountryId{"DE"}}, // Baden railway station
    {Coordinate{9.1241, 52.9991}, CountryId{"DE"}}, // Etelsen station
    {Coordinate{7.7496, 44.9204}, CountryId{"IT"}}, // Villastellone railway station
    {Coordinate{8.55138, 44.8648}, CountryId{"IT"}}, // Cantalupo railway station
    {Coordinate{8.85581, 44.8106}, CountryId{"IT"}}, // Villalvernia railway station
    {Coordinate{6.01755, 46.1878}, CountryId{"CH"}}, // Russin railway station
    {Coordinate{8.60862, 46.5275}, CountryId{"CH"}}, // Airolo railway station
    {Coordinate{8.68993, 46.5108}, CountryId{"CH"}}, // Ambrì-Piotta railway station
    {Coordinate{8.69611, 47.1317}, CountryId{"CH"}}, // Altmatt railway station
    {Coordinate{8.66912, 47.0933}, CountryId{"CH"}}, // Biberegg railway station
    {Coordinate{6.51891, 46.6981}, CountryId{"CH"}}, // Arnex railway station
    {Coordinate{7.10623, 46.8169}, CountryId{"CH"}}, // Belfaux CFF railway station
    {Coordinate{7.11023, 46.8227}, CountryId{"CH"}}, // Belfaux-Village railway station
    {Coordinate{6.81169, 46.9297}, CountryId{"CH"}}, // Bevaix railway station
    {Coordinate{6.87771, 46.9796}, CountryId{"CH"}}, // Auvernier railway station
    {Coordinate{7.27249, 47.1447}, CountryId{"CH"}}, // Biel Mett railway station
    {Coordinate{7.42837, 47.1949}, CountryId{"CH"}}, // Bettlach railway station
    {Coordinate{7.50787, 47.2089}, CountryId{"CH"}}, // Bellach railway station
    {Coordinate{8.36559, 47.2468}, CountryId{"CH"}}, // Benzenschwil railway station
    {Coordinate{8.51706, 47.1831}, CountryId{"CH"}}, // Baar Lindenpark railway station
    {Coordinate{7.90822, 47.3203}, CountryId{"CH"}}, // Aarburg-Oftringen railway station
    {Coordinate{9.50522, 47.0103}, CountryId{"CH"}}, // Bad Ragaz railway station
    {Coordinate{9.55651, 47.3742}, CountryId{"CH"}}, // Altstätten SG railway station
    {Coordinate{9.64125, 47.4361}, CountryId{"CH"}}, // Au SG railway station
    {Coordinate{9.43333, 47.5106}, CountryId{"CH"}}, // Arbon railway station
    {Coordinate{9.42472, 47.5214}, CountryId{"CH"}}, // Arbon Seemoosriet railway station
    {Coordinate{9.26611, 47.6214}, CountryId{"CH"}}, // Altnau station
    {Coordinate{9.02194, 47.6731}, CountryId{"CH"}}, // Berlingen station
    {Coordinate{7.49864, 46.8889}, CountryId{"CH"}}, // Belp railway station
    {Coordinate{7.55951, 47.0955}, CountryId{"CH"}}, // Aefligen railway station
    {Coordinate{6.52369, 46.606}, CountryId{"CH"}}, // Cossonay-Penthalaz railway station
    {Coordinate{6.47474, 46.7151}, CountryId{"CH"}}, // Bretonnières railway station
    {Coordinate{6.69933, 46.5097}, CountryId{"CH"}}, // Bossière railway station
    {Coordinate{6.77855, 46.4811}, CountryId{"CH"}}, // Chexbres-Village railway station
    {Coordinate{7.00043, 46.7492}, CountryId{"CH"}}, // Chénens railway station
    {Coordinate{6.78639, 46.8169}, CountryId{"CH"}}, // Cheyres railway station
    {Coordinate{6.95719, 46.8288}, CountryId{"CH"}}, // Corcelles-Sud railway station
    {Coordinate{6.72317, 46.8509}, CountryId{"CH"}}, // Concise railway station
    {Coordinate{6.83505, 46.9594}, CountryId{"CH"}}, // Boudry railway station
    {Coordinate{6.84888, 46.9676}, CountryId{"CH"}}, // Colombier railway station
    {Coordinate{7.02337, 47.0386}, CountryId{"CH"}}, // Cornaux railway station
    {Coordinate{8.31526, 47.3052}, CountryId{"CH"}}, // Boswil-Bünzen railway station
    {Coordinate{8.45751, 47.1782}, CountryId{"CH"}}, // Cham railway station
    {Coordinate{8.47146, 47.1823}, CountryId{"CH"}}, // Cham Alpenblick railway station
    {Coordinate{8.35666, 47.0937}, CountryId{"CH"}}, // Buchrain railway station
    {Coordinate{7.95702, 47.2627}, CountryId{"CH"}}, // Brittnau-Wikon railway station
    {Coordinate{9.47862, 47.1684}, CountryId{"CH"}}, // Buchs SG railway station
    {Coordinate{6.47813, 46.6967}, CountryId{"CH"}}, // Croy-Romainmôtier railway station
    {Coordinate{6.54051, 46.5291}, CountryId{"CH"}}, // Denges-Echandens railway station
    {Coordinate{9.34791, 47.0966}, CountryId{"CH"}}, // Flums railway station
    {Coordinate{6.81105, 46.6104}, CountryId{"CH"}}, // Ecublens-Rue railway station
    {Coordinate{7.03479, 46.7512}, CountryId{"CH"}}, // Cottens railway station
    {Coordinate{6.84297, 46.8445}, CountryId{"CH"}}, // Estavayer-le-Lac railway station
    {Coordinate{6.88916, 46.816}, CountryId{"CH"}}, // Cugy FR railway station
    {Coordinate{6.97749, 46.8186}, CountryId{"CH"}}, // Cousset railway station
    {Coordinate{7.12271, 46.8671}, CountryId{"CH"}}, // Courtepin railway station
    {Coordinate{7.14972, 46.9002}, CountryId{"CH"}}, // Cressier FR railway station
    {Coordinate{7.03954, 47.0519}, CountryId{"CH"}}, // Cressier NE railway station
    {Coordinate{7.61891, 47.2182}, CountryId{"CH"}}, // Deitingen railway station
    {Coordinate{7.79895, 47.3149}, CountryId{"CH"}}, // Egerkingen railway station
    {Coordinate{7.94667, 47.3542}, CountryId{"CH"}}, // Dulliken railway station
    {Coordinate{7.97833, 47.3564}, CountryId{"CH"}}, // Däniken railway station
    {Coordinate{8.23468, 47.3736}, CountryId{"CH"}}, // Dottikon-Dintikon railway station
    {Coordinate{8.34236, 47.0843}, CountryId{"CH"}}, // Ebikon railway station
    {Coordinate{7.97901, 47.2175}, CountryId{"CH"}}, // Dagmersellen railway station
    {Coordinate{9.383, 47.544}, CountryId{"CH"}}, // Egnach railway station
    {Coordinate{8.87639, 47.6456}, CountryId{"CH"}}, // Eschenz railway station
    {Coordinate{9.08583, 47.67}, CountryId{"CH"}}, // Ermatingen railway station
    {Coordinate{8.7525, 47.6853}, CountryId{"CH"}}, // Diessenhofen railway station
    {Coordinate{7.31957, 46.8885}, CountryId{"CH"}}, // Flamatt railway station
    {Coordinate{6.72265, 46.4969}, CountryId{"CH"}}, // Grandvaux railway station
    {Coordinate{6.8701, 46.735}, CountryId{"CH"}}, // Henniez railway station
    {Coordinate{7.06605, 46.832}, CountryId{"CH"}}, // Grolley railway station
    {Coordinate{6.64194, 46.8063}, CountryId{"CH"}}, // Grandson railway station
    {Coordinate{7.12996, 46.8168}, CountryId{"CH"}}, // Givisiez railway station
    {Coordinate{6.78103, 46.8991}, CountryId{"CH"}}, // Gorgier-St-Aubin railway station
    {Coordinate{7.84381, 47.3303}, CountryId{"CH"}}, // Hägendorf railway station
    {Coordinate{8.16659, 47.4286}, CountryId{"CH"}}, // Holderbank railway station
    {Coordinate{8.20737, 47.3894}, CountryId{"CH"}}, // Hendschiken railway station
    {Coordinate{8.44991, 47.1692}, CountryId{"CH"}}, // Hünenberg Chämleten railway station
    {Coordinate{8.4501, 47.1736}, CountryId{"CH"}}, // Hünenberg Zythus railway station
    {Coordinate{8.39479, 47.1213}, CountryId{"CH"}}, // Gisikon-Root railway station
    {Coordinate{9.62725, 47.4104}, CountryId{"CH"}}, // Heerbrugg railway station
    {Coordinate{9.46335, 47.4931}, CountryId{"CH"}}, // Horn station
    {Coordinate{9.46698, 47.4738}, CountryId{"CH"}}, // Goldach railway station
    {Coordinate{9.2925, 47.6086}, CountryId{"CH"}}, // Güttingen station
    {Coordinate{9.27681, 47.3902}, CountryId{"CH"}}, // Herisau railway station
    {Coordinate{7.65563, 47.016}, CountryId{"CH"}}, // Hasle-Rüegsau railway station
    {Coordinate{7.38944, 47.1917}, CountryId{"CH"}}, // Grenchen Nord railway station
    {Coordinate{7.23441, 46.9422}, CountryId{"CH"}}, // Gümmenen railway station
    {Coordinate{8.83975, 46.4409}, CountryId{"CH"}}, // Lavorgo railway station
    {Coordinate{6.51736, 