# -*- coding: utf-8 -*-
import os,sys
import Editor
import Project
import httplib, mimetypes

# From http://schegloff.livejournal.com/129321.html
def str_between( s, ps1, ps2 ) :
    pos1 = s.find(ps1)
    pos2 = s.find(ps2, pos1+len(ps1))
    if pos1>-1 and pos2>-1 and pos2>pos1 :
        return s[pos1+len(ps1):pos2]
    else :
        return ""

def http_get_cookies(host, selector):
    """
    TBD
    """
    h = httplib.HTTP(host)
    h.putrequest('GET', selector)
    h.putheader('User-Agent', 'Lokalize')
    h.endheaders()

    status, reason, headers = h.getreply()

    cookie = headers.getheader("Set-Cookie")
    data = h.file.read()

    return (cookie, data)

# From http://code.activestate.com/recipes/146306/
# Usage example: 
def post_multipart(host, selector, fields, files, cookie):
    """
    Post fields and files to an http host as multipart/form-data.
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return the server's response page.
    """
    content_type, body = encode_multipart_formdata(fields, files)
    h = httplib.HTTP(host)
    h.putrequest('POST', selector)
    h.putheader('content-type', content_type)
    h.putheader('content-length', str(len(body)))
    h.putheader("Cookie", cookie)
    h.endheaders()
    h.send(body)
    errcode, errmsg, headers = h.getreply()
    return h.file.read()

def encode_multipart_formdata(fields, files):
    """
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return (content_type, body) ready for httplib.HTTP instance
    """
    BOUNDARY = '----------ThIs_Is_tHe_bouNdaRY_$'
    CRLF = '\r\n'
    L = []
    for (key, value) in fields:
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="%s"' % key)
        L.append('')
        L.append(value)
    for (key, filename, value) in files:
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="%s"; filename="%s"' % (key, filename))
        L.append('Content-Type: %s' % get_content_type(filename))
        L.append('')
        L.append(value)
    L.append('--' + BOUNDARY + '--')
    L.append('')
    body = CRLF.join(L)
    content_type = 'multipart/form-data; boundary=%s' % BOUNDARY
    return content_type, body

def get_content_type(filename):
    return mimetypes.guess_type(filename)[0] or 'application/octet-stream'

# TBD: handle connection and parsing errors
#
# This function can be used as following to upload 6 bytes "abcdef" as a file
# named "123.po":
#    print upload_l10n_kde_ru('123.po', 'abcdef')
#
# An URL to the uploaded content will be returned.
def upload_l10n_kde_ru(filename, content):
    (cookie, body) = http_get_cookies('l10n.kde.ru', '/')
    auth_token = str_between(body, "<input name=\"authenticity_token\" type=\"hidden\" value=\"", "\" />")
    reply_data = post_multipart('l10n.kde.ru', '/file_content/create?translation_file_id=1&redirect=content',
                   [('authenticity_token', auth_token)],
                   [('file_content[content]', filename, content)], cookie)
    return str_between(reply_data, '<a href="', '">redirected</a>')

def doOnlineCheckRu():
    if not Editor.isValid() or Editor.currentFile == '': return
    lang = Project.targetLangCode()
    if lang != 'ru': return

    pofullname = Editor.currentFile()
    (path, pofilename)=os.path.split(pofullname)

    with file(pofullname) as f: content = f.read()
    if content == '': return

    import Kross
    forms = Kross.module("forms")
    progress = forms.showProgressDialog(
        "Uploading translation file to l10n.kde.ru",
        'Uploading translation file to l10n.kde.ru...')
    progress.setRange(0,2)
    progress.setValue(0)

    url = upload_l10n_kde_ru(pofilename, content)

    progress.setValue(1)
    progress.addText("Opening %s" % url)
    print "Opening URL: %s" % url

    os.system("kfmclient openURL '%s'" % url)

    progress.setValue(2)
    progress.deleteLater()

doOnlineCheckRu()
