/*  $Revision: 1.1.1.1 $
**
**  Quick CAN Input package -- optimized for reading through a file.
*/


/*
**  State for a quick open file.
*/
typedef struct _QCISTATE {
    ARTCAN	*can;
    long	Bytepos;
    long	Artsize;
    int		Size;
    int		flag;
    int		Length;
    char	*Buffer;
    char	*End;
    char	*Start;
    long	Count;
} QCISTATE;

    /* A reasonable buffersize to use. */
#define QCI_BUFFER	8192

    /* Values for QCIstate.flag */
#define QCI_ok		0
#define QCI_error	1
#define QCI_long	2

#define QCIerror(qp)		((qp)->flag > 0)
#define QCItoolong(qp)		((qp)->flag == QCI_long)
#define QCItell(qp)		((qp)->Count - ((qp)->End - (qp)->Start))
#define QCIlength(qp)		((qp)->Length)
#define QCIfileno(qp)		((qp)->fd)
#define QCIartsize(qp)		((qp)->Artsize)

extern char	*QCIread();
extern QCISTATE	*QCIopen();
extern QCISTATE	*QCIfdopen();
extern void	QCIclose();
extern int	QCIrewind();
