/* pubkey-process-1.test.c - ...
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>
#include <pggcolons.h>
#include <pggpubkey.h>


char * test_data = 
 "pub:u:1024:17:009C42DBCC5CF182:1999-02-28:2004-02-27:381:f:Michael Roth <mroth@gnupg.org>:\n"
 "fpr:::::::::1D8EC918F4F358BCE08E4456009C42DBCC5CF182:\n"
 "sig::::009C42DBCC5CF182:1999-09-17::::Michael Roth <mroth@gnupg.org>:13:\n"
 "sig::::7308657FA77DDABD:1999-09-18::::Michael Roth (This is my old key) <mroth@gnupg.de>:10:\n"
 "sig::::CA15FABA1B13AD41:1999-09-18::::Michael Roth (Used for key signatures) <mroth@gnupg.org>:10:\n"
 "uid:u::::::::Michael Roth <mroth@nessie.de>:\n"
 "sig::::009C42DBCC5CF182:1999-09-17::::Michael Roth <mroth@gnupg.org>:13:\n"
 "sub:u:1792:16:0DF8BD9712CCB97E:1999-02-28::381::\n"
 "sig::::009C42DBCC5CF182:1999-02-28::::Michael Roth <mroth@gnupg.org>:18:\n";
 
 



int colons_callback(void * opaque, int colon, const char * text)
{
    PggErrenv		local_errenv;
    
    pgg_errenv_reset(local_errenv);
    pgg_pubkey_process((PggPubkey)opaque, colon, text, local_errenv);
    
    return pgg_errenv_is_set(local_errenv) ? -1 : 0;
}



int main()
{
    PggColons		colons;
    PggPubkey		pubkey;
    
    pgg_errenv_reset(errenv);
    
    pubkey = pgg_pubkey_new(errenv);
    
    colons = pgg_colons_new(errenv);
    pgg_colons_set_cb(colons, colons_callback, pubkey, errenv);
    
    expect_success();
    
    pgg_pubkey_start(pubkey, errenv);
    pgg_colons_process_data(colons, test_data, strlen(test_data), errenv);
    
    expect_success();
    
    if (pgg_pubkey_get_uid_count(pubkey, errenv) != 2)
        return 1;
    
    if (strcmp(pgg_pubkey_get_uid(pubkey, 0, errenv), "Michael Roth <mroth@gnupg.org>"))
        return 1;
    
    if (strcmp(pgg_pubkey_get_uid(pubkey, 1, errenv), "Michael Roth <mroth@nessie.de>"))
        return 1;
    
    pgg_colons_release(colons, errenv);
    pgg_pubkey_release(pubkey, errenv);
    
    expect_success();
    
    return 0;
}





