/* path_to_srcdir_file.c - Function to get the path of a file in $srcdir
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pggtest.h>


char * path_to_srcdir_file(const char *filename)
{
    char * result;
    char * srcdir = getenv("srcdir");

    if (!srcdir) {
        fprintf(stderr, "Environment variable 'srcdir' not defined.\n");
        exit(1);
    }

    if (!filename) {
        fprintf(stderr, "Internal error: Null pointer filename.\n");
        exit(1);
    }

    if (!( result = (char *) malloc(strlen(filename) + strlen(srcdir) + 2) )) {
        fprintf(stderr, "No more memory left.\n");
        exit(1);
    }

    strcpy(result, srcdir);
    strcat(result, "/");
    strcat(result, filename);

    return result;
}


