/* passcache-5.test.c - heavy clone and timeout tests for PggPasscache
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


int count = 50;



void fill_cache(PggPasscache pc)
{
    int			i;
    char		buffer_keyid[32];
    char		buffer_passphrase[32];
    
    for (i=0; i<count; ++i) {
        sprintf(buffer_keyid, "keyid   %8d", i);
        sprintf(buffer_passphrase, "passphrase %d", i);
        pgg_passcache_set_passphrase(pc, buffer_keyid, buffer_passphrase, errenv);
        expect_success();
    }
}


void test_cache(PggPasscache pc, int fail)
{
    int			i;
    char		buffer_keyid[32];
    
    for (i=0; i<count; ++i) {
        sprintf(buffer_keyid, "keyid   %8d", i);
        pgg_passcache_get_passphrase(pc, buffer_keyid, errenv);
        if (fail)
            expect_failure();
        else
            expect_success();
    }
}


void test_cache_random(PggPasscache pc)
{
    int			i;
    char		buffer_keyid[32];
    
    for (i=0; i<count; ++i) {
        sprintf(buffer_keyid, "keyid   %8d", (int)random() % count);
        pgg_passcache_get_passphrase(pc, buffer_keyid, errenv);
        expect_success();
    }
}


int main()
{
    PggPasscache	clone1, clone2;
    
    INIT_STD_TEST(PggPasscache, passcache)
    
    pgg_passcache_set_policy(passcache, PGG_PASSCACHE_POLICY_REFRESH, errenv);
    pgg_passcache_set_timeout(passcache, 3, errenv);
    expect_success();
    
    fill_cache(passcache);
    
    sleep(1);
    test_cache(passcache, 0);
    
    clone1 = pgg_passcache_clone(passcache, errenv);
    clone2 = pgg_passcache_clone(clone1, errenv);
    
    pgg_passcache_set_timeout(passcache, 6, errenv);
    expect_success();
    
    sleep(1);
    test_cache_random(clone1);
    test_cache_random(clone2);
    
    sleep(1);
    test_cache(clone1, 0);
    
    sleep(2);
    test_cache(clone2, 1);
    
    pgg_passcache_release(clone1, errenv);
    pgg_passcache_release(clone2, errenv);
    expect_success();
    
    test_cache_random(passcache);
    test_cache(passcache, 0);
    
    return 0;
}


