/* pggstate.c - macros for a simple state maschine to use with PggExe
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#define STM_DECLS			int newstate, state; Pgg_Event event;			\
					Pgg_Status status; const char * status_arg;

#define STM_BEGIN			newstate = 0; while (newstate >= 0) { state = newstate;	\
					    event = pgg_exe_wait_event(exe, local_errenv);	\
					    if (event == PGG_EVENT_STATUS) {			\
					        status = pgg_exe_get_status_code(exe, NULL);	\
					        status_arg = pgg_exe_get_status_arg(exe, NULL);	\
					    }							\
					    else {						\
					        status = PGG_STATUS_NONE;			\
					        status_arg = NULL;				\
					    }							\
					    if (0) ((void)0);

#define IF_EVENT_ERROR(s)		else if (state == s && event == PGG_EVENT_ERROR)

#define IF_EVENT_FINISHED(s)		else if (state == s && event == PGG_EVENT_FINISHED)

#define IF_STATUS(s, stat)		else if (state == s && event == PGG_EVENT_STATUS &&	\
					status == PGG_STATUS_##stat)

#define IF_STATUS_ARG(s, stat, arg)	else if (state == s && event == PGG_EVENT_STATUS &&	\
					status == PGG_STATUS_##stat && status_arg &&		\
					strcmp(status_arg, arg)	== 0)

#define IF_STATE(s)			else if (state == s)

#define IF_UNHANDLED()			else

#define SWITCH_TO_STATE(s)		newstate = s

#define STM_LEAVE()			newstate = -1

#define STM_END				}






/*
 * The lines below this notice are only experiments. Just ignore them.
 */


#if 0
    BEGIN_STM
        
        IF_EVENT_ERROR(0) {			/* Error event */
        }
        
        IF_EVENT_FINISHED(0) {			/* Gnupg finished */
            LEAVE_STM();
        }
        
        IF_STATUS(0, PASSPHRASE_SYM) {
            SWITCH_TO_STATE(2);
        }
        
        IF_STATUS(0, OVERWRITE) {		/* A status event with or without an argument */
        }
        
        IF_STATUS_ARG(1, GET_HIDDEN, "file.overwrite") {	/* Status event with specificied argument */
        }
        
        IF_STATE(2) {				/* executed if the given state is reached */
        }
        
        IF_UNHANDLED() {			/* executed if no other group is executed */
        }
        
    END_STM
#endif





#if 0
    PGG_STATE_MASCHINE(
        PGG_STATE(0, 			/* This is the state this entries should apply */
            PGG_STATE_EVENT(FINISHED, 
                PGG_STATE_MASCHINE_LEAVE()
            )
            
            PGG_STATE_EVENT(GET_HIDDEN, 
                PGG_STATE_EVENT_ARG("some arg",
                )
                PGG_STATE_TRANSFER(1)		/* Sets a new state */
            )
        )
        
        /*
         * This is another state
         */
        PGG_STATE(1, 
        )
    )
#endif










