/* pggsiginfo.c - PggSiginfo carries infos about signatures
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>
#include <pggsiginfo.h>


#define siginfo		((PggSiginfoPtr)(_siginfo))


PggSiginfo pgg_siginfo_new(PggErrenv errenv)
{
    PggSiginfoPtr	new_siginfo;
    
    if (!( new_siginfo = _malloc(PggSiginfo) ))
        PGG_RETURN_ERR_ARG(RESOURCE, MEMORY, NULL);
    
    memset(new_siginfo, 0, _size(PggSiginfo));
    
    new_siginfo->magic      = PggSiginfoMAGIC;
    new_siginfo->refcounter = 1;
    
    return _hd(PggSiginfo, new_siginfo);
}


PggSiginfo pgg_siginfo_clone(PggSiginfo _siginfo, PggErrenv errenv)
{
    PggSiginfoPtr	new_siginfo;
    PggErrenv		local_errenv;
    
    PGG_STD_ASSERT_ARG(PggSiginfo, siginfo, NULL);
    
    pgg_errenv_reset(local_errenv);
    
    if (!( new_siginfo = _malloc(PggSiginfo) ))
        PGG_RETURN_ERR_ARG(RESOURCE, MEMORY, NULL);
    
    memset(new_siginfo, 0, _size(PggSiginfo));
    
    new_siginfo->magic      = PggSiginfoMAGIC;
    new_siginfo->refcounter = 1;
    
    return _hd(PggSiginfo, new_siginfo);
}


void pgg_siginfo_addref(PggSiginfo _siginfo, PggErrenv errenv)
{
    PGG_STD_ASSERT(PggSiginfo, siginfo);
    siginfo->refcounter++;
}


void pgg_siginfo_release(PggSiginfo _siginfo, PggErrenv errenv)
{
    PGG_STD_ASSERT(PggSiginfo, siginfo);
    
    if (!--siginfo->refcounter) {
        free(siginfo);
    }
}


