/* pggcolons.h - PggColons
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGCOLONS_H_19990727113644
#define PGG_INCLUDE_PGGCOLONS_H_19990727113644


#include <pgg.h>
#include <pggimpl.h>


typedef struct { int dummy; } * PggColons;


typedef int (*PggColons_CB)(void *opaque, int colon, const char *text);


extern PggColons		pgg_colons_new(PggErrenv errenv);
extern PggColons		pgg_colons_clone(PggColons colons, PggErrenv errenv);
extern void			pgg_colons_addref(PggColons colons, PggErrenv errenv);
extern void			pgg_colons_release(PggColons colons, PggErrenv errenv);

extern void			pgg_colons_set_cb(PggColons colons, PggColons_CB cb, void *opaque, PggErrenv errenv);

extern void			pgg_colons_setup_exe(PggColons colons, PggExe exe, PggErrenv errenv);

extern void			pgg_colons_reset_state(PggColons colons, PggErrenv errenv);
extern void			pgg_colons_process_data(PggColons colons, const char *text, int length, PggErrenv errenv);
extern int			pgg_colons_is_line_complete(PggColons colons, PggErrenv errenv);


_mktype(PggColons)
{
    unsigned long	magic;
    int			refcounter;
    PggColons_CB	cb;
    void *		opaque;
    PggBuffer		buffer;
    int			check_index_resume;
    int			current_colon;
};


_mktypeptr(PggColons);


#define PggColonsMAGIC 0xFF0F1099


#endif


