/* pgg_pubkey_get_config.c - Returns the PggConfig object of this PggPubkey
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>
#include <pggpubkey.h>


#define pubkey		((PggPubkeyPtr)(_pubkey))


PggConfig pgg_pubkey_get_config(PggPubkey _pubkey, PggErrenv errenv)
{
    PGG_STD_ASSERT_ARG(PggPubkey, pubkey, NULL);
    PGG_ASSERT_ARG(pubkey->config, REQUEST, NOTSET, NULL);
    pgg_config_addref(pubkey->config, NULL);
    return pubkey->config;
}


