/* pgg_algo_clone.c - Clones a PggAlgo object
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggalgo.h>
#include <pggdebug.h>


#define old_algo	((PggAlgoPtr)(_old_algo))


PggAlgo pgg_algo_clone(PggAlgo _old_algo, PggErrenv errenv)
{
    PggAlgoPtr	new_algo;
    
    PGG_STD_ASSERT_ARG(PggAlgo, old_algo, NULL);
    
    if (!( new_algo = _malloc(PggAlgo) ))
        PGG_RETURN_ERR_ARG(RESOURCE, MEMORY, NULL);
    
    memcpy(new_algo, old_algo, _size(PggAlgo));
    
    new_algo->refcounter = 1;
    
    return _hd(PggAlgo, new_algo);
}


