/* pgg_algo_build_digest.c - Adds a digest name to a PggExe argument list
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggalgo.h>
#include <pggdebug.h>


#define algo		((PggAlgoPtr)(_algo))


void pgg_algo_build_digest(Pgg_Digest digest, PggExe exe, PggErrenv errenv)
{
    switch (digest) {
        case PGG_DIGEST_MD5:
            pgg_exe_add_arg(exe, "md5", errenv);
            break;
        
        case PGG_DIGEST_SHA1:
            pgg_exe_add_arg(exe, "sha1", errenv);
            break;
        
        case PGG_DIGEST_RIPEMD160:
            pgg_exe_add_arg(exe, "ripemd160", errenv);
            break;
        
        default:
            break;
    }
}


