/* pgg_algo_build_cipher.c - Adds a cipher name to a PggExe argument list
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggalgo.h>
#include <pggdebug.h>


#define algo		((PggAlgoPtr)(_algo))


void pgg_algo_build_cipher(Pgg_Cipher cipher, PggExe exe, PggErrenv errenv)
{
    switch (cipher) {
        case PGG_CIPHER_IDEA:
            pgg_exe_add_arg(exe, "idea", errenv);
            break;
    
        case PGG_CIPHER_3DES:
            pgg_exe_add_arg(exe, "3des", errenv);
            break;

        case PGG_CIPHER_CAST5:
            pgg_exe_add_arg(exe, "cast5", errenv);
            break;

        case PGG_CIPHER_BLOWFISH:
            pgg_exe_add_arg(exe, "blowfish", errenv);
            break;

        case PGG_CIPHER_TWOFISH:
            pgg_exe_add_arg(exe, "twofish", errenv);
            break;

        default:
            break;
    }
}


