;; HiPlatinum
;; by Matt Chisholm http://www.theory.org/~matt/sawfish/
;; Based on the Kaleidoscope theme of the same name by Andrew Lee
;; http://www.geocities.com/SiliconValley/Horizon/8339/hip.html

(let*

  (
    ;; Update window title pixel length
    (title-width
      (lambda (w)
        (let
          ((w-width (car (window-dimensions w))))
          (max 0 (min (- w-width 100) (text-width (window-name w) 
          ))))))

        (topleft (list 
         (make-image  "topleft-i.png")
         (make-image "topleft-a.png")))
	(title-r (list
	 (make-image "title-r-i.png")
	 (make-image "title-r-a.png")))
	(title (list
	 (make-image "title-i.png")
	 (make-image "title-a.png")))
        (top (list 
         (make-image  "top-i.png")
         (make-image "top-a.png")))
        (topright (list 
         (make-image  "topright-i.png")
         (make-image "topright-a.png")))
        (right (list 
         (make-image "right-i.png")
         (make-image "right-a.png")))
        (bottomright (list 
         (make-image "bottomright-i.png")
         (make-image "bottomright-a.png")))
        (bottom (list 
         (make-image "bottom-i.png")
         (make-image "bottom-a.png")))
        (bottomleft (list 
         (make-image "bottomleft-i.png")
         (make-image "bottomleft-a.png")))
        (left (list 
         (make-image "left-i.png")
         (make-image "left-a.png")))

	(close (list
	  (make-image "close-i.png")
	  (make-image "close-a.png")))
	(max (list
	  (make-image "max-i.png")
	  (make-image "max-a.png")))
	(min (list
	  (make-image "min-i.png")
	  (make-image "min-a.png")))

        (topright-s (list 
         (make-image "topright-i-s.png")
         (make-image "topright-a-s.png")))
	(title-r-s (list
	 (make-image "title-r-i-s.png")
	 (make-image "title-r-a-s.png")))
	(title-s (list
	 (make-image "title-i-s.png")
	 (make-image "title-a-s.png")))
        (top-s (list 
         (make-image  "top-i-s.png")
         (make-image "top-a-s.png")))
        (topleft-s (list 
         (make-image  "topleft-i-s.png")
         (make-image "topleft-a-s.png")))

	(font-colors ( list "#404040" "#000000" ))

       (frame `(
         ((class . top-left-corner)
	  (top-edge . -24)
          (left-edge . -7)
          (background . ,topleft))
         ((bottom-edge . -9)
          (left-edge . -7)
          (background . ,bottomleft)
          (class . bottom-left-corner))
         ((top-edge . -26)
          (background . ,topright)
          (right-edge . -7)
          (class . top-right-corner))
         ((right-edge . -7)
          (background . ,bottomright)
          (bottom-edge . -9)
          (class . bottom-right-corner))
         ((left-edge . ,(lambda (w) (+ (title-width w) 38)))
          (right-edge . 37)
          (top-edge . -26)
          (background . ,top)
          (class . title))
         ((top-edge . 10)
          (bottom-edge . 0)
          (left-edge . -7)
          (background . ,left)
          (class . left-border))
         ((left-edge . 0)
          (right-edge . 0)
          (bottom-edge . -9)
          (background . ,bottom)
          (class . bottom-border))
         ((top-edge . 10)
          (right-edge . -7)
          (bottom-edge . 0)
          (background . ,right)
          (class . right-border))
	 ((class . title)
	  (left-edge . 16)
	  (top-edge . -26)
	  (background . ,title-r))
         ((left-edge . 26)
          (top-edge . -26)
          (width . ,(lambda (w) (+ (title-width w) 12 )))
          (y-justify . center)
          (x-justify . center)
          (text . ,window-name)
	  (foreground . ,font-colors)
          (background . ,title)
          (class . title))
	 ((class . close-button)
	  (left-edge . 2)
	  (top-edge . -19)
	  (background . ,close))
	 ((class . shade-button)
	  (right-edge . 3)
	  (top-edge . -19)
	  (background . ,min))
	 ((class . maximize-button)
	  (right-edge . 22)
	  (top-edge . -19)
	  (background . ,max))
    ))
       (shaped-frame `(
         ((class . top-left-corner)
	  (top-edge . -24)
          (left-edge . -7)
          (background . ,topleft-s))
         ((top-edge . -26)
          (background . ,topright-s)
          (right-edge . -7)
          (class . top-right-corner))
         ((left-edge . 26)
;;	  (left-edge . ,(lambda (w) (+ (title-width w) 38)))
          (right-edge . 37)
          (top-edge . -26)
          (background . ,top-s)
          (class . title))
	 ((class . title)
	  (left-edge . 16)
	  (top-edge . -26)
	  (background . ,title-r-s))
         ((left-edge . 26)
          (top-edge . -26)
          (width . ,(lambda (w) (+ (title-width w) 12 )))
          (y-justify . center)
          (x-justify . center)
          (text . ,window-name)
	  (foreground . ,font-colors)
          (background . ,title-s)
          (class . title))
	 ((class . close-button)
	  (left-edge . 2)
	  (top-edge . -19)
	  (background . ,close))
	 ((class . shade-button)
	  (right-edge . 3)
	  (top-edge . -19)
	  (background . ,min))
	 ((class . maximize-button)
	  (right-edge . 22)
	  (top-edge . -19)
	  (background . ,max))
    ))

)

  (add-frame-style 'HiPlatinum
                   (lambda (w type)
                     (case type
                       ((default) frame)
                       ((transient) frame)
                       ((shaped) shaped-frame)
                       ((shaped-transient) shaped-frame))))

  (call-after-property-changed
   'WM_NAME (lambda ()
              (rebuild-frames-with-style 'HiPlatinum))))
