#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <limits.h>
#include "history.h"

#define snprintf g_snprintf

#ifdef MEMORY_DEBUG

#define malloc   xchat_malloc
#define free     xchat_free
#define g_malloc xchat_malloc
#define g_free   xchat_free

void *xchat_malloc (int size);
void free(void *buf);

#endif /* MEMORY_DEBUG */

#ifdef SOCKS
#include <socks.h>
#endif

#ifdef USE_GNOME
#include <gnome.h>
#undef GNOME_APP
#define GNOME_APP(n) ((GnomeApp*)n)
#endif

#undef GTK_WINDOW
#undef GTK_BOX
#undef GTK_OBJECT
#undef GTK_CONTAINER
#undef GTK_CLIST
#undef GTK_TEXT
#undef GTK_LABEL
#undef GTK_ENTRY
#undef GTK_WIDGET
#undef GTK_MENU_BAR
#undef GTK_DIALOG
#undef GTK_FILE_SELECTION
#undef GTK_PANED
#undef GTK_TABLE
#undef GTK_DRAWING_AREA
#undef GTK_FONT_SELECTION_DIALOG
#undef GTK_SCROLLED_WINDOW
#undef GTK_TOGGLE_BUTTON
#undef GTK_NOTEBOOK
#undef GTK_MENU_ITEM

#define GTK_WINDOW(n) ((GtkWindow *)n)
#define GTK_BOX(n) ((GtkBox *)n)
#define GTK_OBJECT(n) ((GtkObject *)n)
#define GTK_CONTAINER(n) ((GtkContainer *)n)
#define GTK_CLIST(n) ((GtkCList *)n)
#define GTK_TEXT(n) ((GtkText *)n)
#define GTK_LABEL(n) ((GtkLabel *)n)
#define GTK_ENTRY(n) ((GtkEntry *)n)
#define GTK_WIDGET(n) ((GtkWidget *)n)
#define GTK_MENU_BAR(n) ((GtkMenuBar *)n)
#define GTK_DIALOG(n) ((GtkDialog *)n)
#define GTK_FILE_SELECTION(n) ((GtkFileSelection *)n)
#define GTK_PANED(n) ((GtkPaned *)n)
#define GTK_TABLE(n) ((GtkTable *)n)
#define GTK_DRAWING_AREA(n) ((GtkDrawingArea *)n)
#define GTK_FONT_SELECTION_DIALOG(n) ((GtkFontSelectionDialog *)n)
#define GTK_SCROLLED_WINDOW(n) ((GtkScrolledWindow *)n)
#define GTK_TOGGLE_BUTTON(n) ((GtkToggleButton *)n)
#define GTK_NOTEBOOK(n) ((GtkNotebook*)n)
#define GTK_MENU_ITEM(n) ((GtkMenuItem*)n)

#define	FONTNAMELEN	127

struct nbexec {
   int myfd, childfd;
   int childpid;
   int tochannel; /* making this int keeps the struct 4-byte aligned */
   gint iotag;
   struct session *sess;
};

struct xchatprefs
{ 
   char nick1[64];
   char nick2[64];
   char nick3[64];
   char realname[127];
   char username[127];
   char awayreason[256];
   char quitreason[256];
   char font_normal[FONTNAMELEN + 1];
   char font_bold[FONTNAMELEN + 1];
   char dialog_font_normal[FONTNAMELEN + 1];
   char dialog_font_bold[FONTNAMELEN + 1];
   char doubleclickuser[256];
   char sounddir[PATH_MAX + 1];
   char soundcmd[PATH_MAX + 1];
   char background[PATH_MAX + 1];
   char background_dialog[PATH_MAX + 1];
   char dccdir[PATH_MAX + 1];
   char bluestring[64];

   int bufsize;
   int zvt_lines;
   int notify_timeout;
   int dcctimeout;
   int dccstalltimeout;
   int mainwindow_left;
   int mainwindow_top;
   int mainwindow_width;
   int mainwindow_height;
   int dccpermissions;
   unsigned char nu_color;
   unsigned char bg_color;
   unsigned char fg_color;
   unsigned char dialog_bg_color;
   unsigned char dialog_fg_color;
   unsigned char bt_color;
   guint32 my_ip;

   int nopanel:1;
   int autosave:1;
   int autodialog:1;
   int autoreconnect:1;
   int invisible:1;
   int servernotice:1;
   int wallops:1;
   int skipmotd:1;
   int away:1;
   int autorejoin:1;
   int colorednicks:1;
   int nochanmodebuttons:1;
   int nouserlistbuttons:1;
   int nickcompletion:1;
   int tabnicks:1;
   int tabchannels:1;
   int nopaned:1;
   int autodccchat:1;
   int autodccsend:1;
   int noautoopendccsendwindow:1;
   int noautoopendccrecvwindow:1;
   int zvt:1;
   int transparent:1;
   int tint:1;   
   int dialog_zvt:1;
   int dialog_transparent:1;
   int dialog_tint:1;
   int stripcolor:1;
   int timestamp:1;
   int fastdccsend:1;
   int skipserverlist:1;
   int filterbeep:1;
   int tabsatbottom:1;
   int beepmsg:1;
   int privmsgtab:1;
   int logging:1;
   int newtabstofront:1;
   int dccwithnick:1;
   int hilitenotify:1;
   int hidever:1;
   int get_ip_from_server:1;
   int panelize_hide:1;
   int panel_vbox:1;
   int raw_modes:1;
   int no_server_logs:1;
   int show_away_once:1;
};

struct setup
{
   GtkWidget *settings_window;
   GtkWidget *nu_color;
   GtkWidget *bt_color;

   GtkWidget *bg_color;
   GtkWidget *fg_color;
   GtkWidget *font_normal;
   GtkWidget *font_bold;

   GtkWidget *dialog_bg_color;
   GtkWidget *dialog_fg_color;
   GtkWidget *dialog_font_normal;
   GtkWidget *dialog_font_bold;

   GtkWidget *entry_bluestring;
   GtkWidget *entry_doubleclickuser;
   GtkWidget *entry_zvt_lines;
   GtkWidget *entry_quit;
   GtkWidget *entry_away;
   GtkWidget *entry_bufsize;
   GtkWidget *entry_timeout;
   GtkWidget *entry_dccdir;
   GtkWidget *entry_dcctimeout;
   GtkWidget *entry_dccstalltimeout;
   GtkWidget *entry_permissions;

   GtkWidget *entry_sounddir;
   GtkWidget *entry_soundcmd;

   GtkWidget *entry_mainw_left;
   GtkWidget *entry_mainw_top;
   GtkWidget *entry_mainw_width;
   GtkWidget *entry_mainw_height;

   GtkWidget *background;
   GtkWidget *background_dialog;

   GtkWidget *check_transparent;
   GtkWidget *check_tint;

   GtkWidget *dialog_check_transparent;
   GtkWidget *dialog_check_tint;

   GtkWidget *cancel_button;

   struct xchatprefs prefs;
};

#define flag_t flag_wid[0]
#define flag_n flag_wid[1]
#define flag_s flag_wid[2]
#define flag_i flag_wid[3]
#define flag_p flag_wid[4]
#define flag_m flag_wid[5]
#define flag_l flag_wid[6]
#define flag_k flag_wid[7]

struct session
{
   GtkWidget *window;
   GtkWidget *vbox;
   GtkWidget *menu;
   GtkWidget *tbox;
   GtkWidget *changad;
   GtkWidget *topicgad; /* FIXME: Pseudo union with ipgad --AGL*/
   GtkWidget *textgad;
   GtkWidget *namelistgad;
   GtkWidget *nickgad;
   GtkWidget *inputgad;
   GtkWidget *namelistinfo;
   GtkWidget *paned;
   GtkWidget *vscrollbar;
   GtkWidget *op_box;
   GtkWidget *op_xpm;
   GtkWidget *userlistbox;
   GtkWidget *nl_box;
   GtkWidget *button_box;
   GtkWidget *bar;
   GtkWidget *leftpane;
   int userlisthidden;

   GtkWidget *flag_wid[8];

   GtkWidget *limit_entry; /* +l */
   GtkWidget *key_entry; /* +k */
#ifdef USE_PANEL
   GtkWidget *panel_button;
#endif

   struct server *server;
   struct user *userlist;
   char channel[202];
   char waitchannel[202]; /* waiting to join this channel */
   char nick[202];
   char willjoinchannel[202]; /* /join done for this channel */
   char channelkey[64];		/* XXX correct max length? */
   int	logfd;

   char lastnick[64];  /* last nick you /msg'ed */

   struct history history;

   int ops; /* num. of ops in channel */
   int total; /* num. of users in channel */

   char *quitreason;

   struct setup *setup;
   struct nbexec *running_exec;

   int is_tab:1; /* is this a tab or toplevel window? */
   int is_dialog:1;
   int new_data:1; /* new data avail? (red tab) */
   int nick_said:1; /* your nick mentioned? (green tab) */
   int zvt:1; /* using zvt instead of gtk_text? */
   int ignore_date:1;
   int ignore_mode:1;
   int ignore_names:1;
   int end_of_names:1;
};

struct server
{
   int port;
   int sok;
   int childread;
   int childpid;
   gint iotag;
   gint bartag;
   char hostname[128];
   char servername[128];
   char password[86];
   char nick[64];
   char linebuf[1024];
   long pos;
   int nickcount;

   struct session *front_session;

   GtkWidget *rawlog_window;
   GtkWidget *rawlog_textlist;

   GtkWidget *chanlist_window;
   GtkWidget *chanlist_list;
   int chanlist_minusers;

   int motd_skipped:1;
   int connected:1;
   int connecting:1;
   int no_login:1;
   int skip_next_who:1;
};

struct DCC
{
   struct server *serv;
   char type; /* 0 = SEND  1 = RECV  2 = CHAT */
   char stat; /* 0 = QUEUED  1 = ACTIVE  2 = FAILED  3 = DONE */
   long sok;
   gint iotag;
   unsigned long addr;
   unsigned long size;
   unsigned long resumable;
   unsigned long ack;
   unsigned long oldack;
   unsigned long pos;
   unsigned long oldpos;
   unsigned long starttime;
   unsigned long offertime;
   unsigned long lasttime;
   long port;
   long cps;
   char file[128];
   char destfile[PATH_MAX + 1];
   char nick[64];
   int fp; /* file pointer */
   struct dccdraw *dccdraw;
   struct dcc_chat *dccchat;
   struct sockaddr_in SAddr;
};

typedef int (*cmd_callback) (struct session *sess, char *tbuf, char *word[], char *word_eol[]);

struct commands
{
   char *name;
   cmd_callback callback;
   char needserver;
   char needchannel;
   char *help;
};

struct away_msg
{
    struct server *server;
    char nick[64];
    char *message;
};
