/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#undef USE_GNOME
#include "xchat.h"
#include "gtkutil.h"


extern GdkColor colors[];


int close_rawlog(GtkWidget *wid, struct server *serv)
{
   serv->rawlog_window = 0;
   return 0;
}

void open_rawlog(struct server *serv)
{
   GtkWidget *hbox, *vscrollbar;

   if(serv->rawlog_window)
   {
      gtk_widget_destroy(serv->rawlog_window);
      return;
   }

   serv->rawlog_window = gtkutil_window_new("X-Chat: Raw Log", "rawlog", 450, 100,
					    close_rawlog, serv);

   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(serv->rawlog_window), hbox);
   gtk_widget_show(hbox);

   serv->rawlog_textlist = gtk_text_new(0, 0);
   gtk_text_set_word_wrap (GTK_TEXT(serv->rawlog_textlist), TRUE);
   gtk_text_set_editable (GTK_TEXT (serv->rawlog_textlist), FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), serv->rawlog_textlist);
   gtk_widget_show(serv->rawlog_textlist); 

   vscrollbar = gtk_vscrollbar_new (GTK_TEXT(serv->rawlog_textlist)->vadj);
   gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
   gtk_widget_show (vscrollbar);

   gtk_widget_show(serv->rawlog_window);
}

void add_rawlog(struct server *serv, char *text, int outbound)
{
   if(serv->rawlog_window)
   {
      int scroll = FALSE;
      GtkAdjustment *adj;

      adj = (GTK_TEXT(serv->rawlog_textlist))->vadj;
      if(adj->value == adj->upper - adj->lower - adj->page_size) scroll = TRUE;

      gtk_text_freeze(GTK_TEXT(serv->rawlog_textlist));
      if(outbound)
	gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, &colors[3], 0,  "<< ", 3);
      else
	gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, &colors[4], 0,  ">> ", 3);
      gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, 0, 0,  text, -1);
      if(!outbound)
	gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, 0, 0,  "\n", 1);
      gtk_text_thaw(GTK_TEXT(serv->rawlog_textlist));

      if(scroll)
	gtk_adjustment_set_value(adj, adj->upper - adj->lower - adj->page_size);
   }
}
