/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <pwd.h>
#include <errno.h>
#include <ctype.h>

int is_data_avail(int sok)
{
   struct timeval tim;
   fd_set rd;

   tim.tv_usec = 0;
   tim.tv_sec = 0;
   FD_ZERO(&rd);
   FD_SET(sok, &rd);
   return(select(sok+1, &rd, 0, 0, &tim));
}

char *file_part(char *file)
{
   char *filepart = file;
   while(1)
   {
      switch(*file)
      {
       case 0:
	 return(filepart);
       case '/':
	 filepart = file + 1;
	 break;
      }
      file++;
   }
}

void path_part(char *file, char *path)
{
   char *filepart = file_part(file);
   *filepart = 0;
   strcpy(path, file);
}

char *nocasestrstr(char *text, char *tofind)  /* like strstr(), but nocase */
{
   char *ret = text, *find = tofind;
   
   while(1)
   {
      if(*find == 0) return ret;
      if(*text == 0) return 0;
      if(toupper(*find) != toupper(*text))
      {
	ret = text+1;
	find = tofind;
      } else
	find++;
      text++;
   }
}

char *errorstring(int err)
{
   static char tbuf[16];
   switch(err)
   {
    case ECONNREFUSED: return("Connection refused");
    case ENETUNREACH:
    case EHOSTUNREACH: return("No route to host");
    case ETIMEDOUT: return("Connection timed out");
   }
   sprintf(tbuf, "%d", err);
   return(tbuf);
}

int waitline(int sok, char *buf, int bufsize)
{
   int i = 0;

   while(1)
   {
      if(read(sok, &buf[i], 1) < 1) return -1;
      if(buf[i] == '\n')
      {
	 buf[i] = 0;
	 return i;
      }
      i++;
      if(i == (bufsize-1)) return 0;
   }
}

char *get_home_dir(void)
{
   static char xdir[80];
   struct passwd *pw;
   pw = getpwuid(getuid());
   strcpy(xdir, pw->pw_dir);
   return(xdir);
}

/* checks for "~" in a file and expands */

void check_homedir(char *file)
{
   char temp[128];
   if(*file == '~')
   {
      strcpy(temp, file);
      sprintf(file, "%s%s", get_home_dir(), (char *)&temp[1]);
   }
}

int get_mhz(void)
{
   char buf[128];
   int fh;

   fh = open("/proc/cpuinfo", O_RDONLY);
   if(fh == -1) return 0;
   while(1)
   {
      if(waitline(fh, buf, sizeof buf) < 0) return 0;
      if(!strncmp(buf, "cpu MHz", 7))
	 return(atoi((char *)&buf[11]));
   }
}
