/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#undef USE_GNOME
#include "xchat.h"
#include "gtkutil.h"


void close_rawlog(GtkWidget *wid, struct server *serv)
{
   gtk_widget_destroy(serv->rawlog_window);
   serv->rawlog_window = 0;
}

void open_rawlog(struct server *serv)
{
   GtkWidget *hbox, *vscrollbar;

   if(serv->rawlog_window)
   {
      gtk_widget_destroy(serv->rawlog_window);
      serv->rawlog_window = 0;
      return;
   }

   serv->rawlog_window = gtkutil_window_new("X-Chat: Raw Log", 450, 100,
					    close_rawlog, serv);

   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(serv->rawlog_window), hbox);
   gtk_widget_show(hbox);

   serv->rawlog_textlist = gtk_text_new(0, 0);
   gtk_text_set_word_wrap (GTK_TEXT(serv->rawlog_textlist), TRUE);
   gtk_text_set_editable (GTK_TEXT (serv->rawlog_textlist), FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), serv->rawlog_textlist);
   gtk_widget_show(serv->rawlog_textlist); 

   vscrollbar = gtk_vscrollbar_new (GTK_TEXT(serv->rawlog_textlist)->vadj);
   gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);
   gtk_widget_show (vscrollbar);

   gtk_widget_show(serv->rawlog_window);
}

void add_rawlog(struct server *serv, char *text)
{
   if(serv->rawlog_window)
   {
      gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, 0, 0,  text, -1);
      gtk_text_insert(GTK_TEXT(serv->rawlog_textlist), 0, 0, 0,  "\n", 1);
   }
}
