/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include "menu.h"
#include "gtkutil.h"
#include "userlist.h"
#include <gdk/gdkkeysyms.h>
#include <fcntl.h>
#ifdef USE_IMLIB
#include <gdk_imlib.h>
#endif
#ifdef USE_GNOME
#include <zvt/zvtterm.h>
#endif


GtkWidget *main_window = 0;
GtkWidget *main_book;
struct session *current_tab = 0;
GtkStyle *normaltab_style = 0;
GtkStyle *redtab_style;

extern struct session *menu_sess;
extern struct xchatprefs prefs;
extern GSList *sess_list;
extern GSList *button_list;
extern GtkStyle *channelwin_style;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GdkFont *font_normal;
extern GdkFont *font_bold;

extern void end_logging (int fd);
extern void menu_popup(struct session *sess, GdkEventButton *event, char *nick);
extern void clear_user_list(struct session *sess);
extern void xchat_cleanup(void);
extern char *get_xdir(void);
extern void dcc_chat(struct session *sess, char *nick);
extern void kill_session_callback(GtkWidget *win, struct session *sess);
#ifdef USE_GNOME
extern void createmenus(void *app, struct session *sess);
#else
extern GtkWidget *createmenus(struct session *sess);
#endif
extern void handle_inputgad(GtkWidget *igad, struct session *sess);
extern void dcc_send_filereq(struct session *sess, char *nick);
extern struct dialog *new_dialog(struct server *serv, char *nick);
extern struct dialog *find_dialog(struct server *serv, char *nick);
extern void my_gtk_entry_set_text(GtkWidget *wid, char *text, struct session *sess);
extern void my_gtk_toggle_state(GtkWidget *wid, int state, char which, struct session *sess);
extern void popup_cmd(GtkWidget *igad, char *cmd);
extern void path_part(char *file, char *path);

void userlist_button(GtkWidget *box, char *label, char *cmd,
		     struct session *sess, int a, int b, int c, int d);

GdkColor colors[] =
{
     { 0, 0xffff, 0xffff, 0xffff }, /* 0  white */
     { 0, 0, 0, 0 },                /* 1  black */
     { 0, 0, 0, 0xcccc },           /* 2  blue */
     { 0, 0, 0xbbbb, 0 },           /* 3  green */
     { 0, 0xbbbb, 0, 0 },           /* 4  red */
     { 0, 0xaaaa, 0xaaaa, 0 },      /* 5  yellow/brown */
     { 0, 0xbbbb, 0, 0xbbbb },      /* 6  purple */
     { 0, 0xcccc, 0xcccc, 0 },      /* 7  orange */  
     { 0, 0xeeee, 0xeeee, 0 },      /* 8  yellow */
     { 0, 0, 0xffff, 0 },           /* 9  green */
     { 0, 0, 0xbbbb, 0xbbbb },      /* 10 aqua */
     { 0, 0, 0xeeee, 0xeeee },      /* 11 light aqua */  
     { 0, 0, 0, 0xffff },           /* 12 blue */
     { 0, 0xffff, 0, 0xffff },      /* 13 pink */    
     { 0, 0x7777, 0x7777, 0x7777 }, /* 14 grey */  
     { 0, 0x9999, 0x9999, 0x9999 }, /* 15 light grey */
/*     { 0, 0xf8f4, 0xffff, 0xbbbb },*/ /* 16 light yellow for tooltips */
};


void make_non_channel_window(struct session *sess)
{
   int i;

   if(sess->flag_wid[0])
   {
      for(i=0; i<8; i++)
      {
	 gtk_widget_set_sensitive(sess->flag_wid[i], FALSE);
      }
      gtk_widget_set_sensitive(sess->limit_entry, FALSE);
      gtk_widget_set_sensitive(sess->key_entry, FALSE);
   }
   gtk_widget_set_sensitive(sess->nl_box, FALSE);
   gtk_entry_set_editable((GtkEntry *)sess->topicgad, FALSE);
}

void maingui_createbuttons(struct session *sess)
{
   struct popup *pop;
   GSList *list = button_list;
   int a = 0, b = 0;

   sess->button_box = gtk_table_new(5, 2, FALSE);
   gtk_box_pack_end(GTK_BOX(sess->nl_box), sess->button_box, FALSE, FALSE, 1);
   gtk_widget_show(sess->button_box);
 
   while(list)
   {
      pop = (struct popup *)list -> data;
      if(pop->cmd[0])
      {
	 userlist_button(sess->button_box, pop->name, pop->cmd, sess, a, a+1, b, b+1);
	 a++;
	 if(a == 2)
	 {
	    a = 0;
	    b++;
	 }
      }
      list = list -> next;
   }
}

void maingui_updatebuttons(struct session *sess)
{
   if(sess->button_box)
   {
      gtk_widget_destroy(sess->button_box);
      sess->button_box = 0;
   }
   if(!prefs.nouserlistbuttons)	maingui_createbuttons(sess);
}

void gui_set_title(struct session *sess)
{
   char tbuf[200];
   if(!sess->server->connected)
     strcpy(tbuf, "X-Chat ("VERSION")");
   else {
      if(sess->channel[0] == 0)
	sprintf(tbuf, "X-Chat ("VERSION"): %s", sess->server->servername);
      else
       	sprintf(tbuf, "X-Chat ("VERSION"): %s / %s", sess->server->servername, sess->channel);
   }
   if(sess->is_tab)
   {
      if(!main_window) return;
      if(current_tab == sess) gtk_window_set_title((GtkWindow *)main_window, tbuf);
   } else
      gtk_window_set_title((GtkWindow *)sess->window, tbuf);
}

void set_channel(struct session *sess)
{
   gtk_label_set(GTK_LABEL(sess->changad), sess->channel);
}

extern char chan_flags[];

void clear_channel(struct session *sess)
{
   sess->channel[0] = 0;
   gtk_entry_set_text(GTK_ENTRY(sess->topicgad), "");
   gtk_label_set(GTK_LABEL(sess->namelistinfo), " ");
   gtk_label_set(GTK_LABEL(sess->changad), "<none>");
   gui_set_title(sess);
   clear_user_list(sess);
   if(sess->flag_wid[0])
   {
      int i;
      for(i=0; i<8; i++)
	 my_gtk_toggle_state(sess->flag_wid[i], FALSE, chan_flags[i], sess);
      my_gtk_entry_set_text(sess->limit_entry, "", sess);
      my_gtk_entry_set_text(sess->key_entry, "", sess);
   }
   if(sess->op_xpm) gtk_widget_destroy(sess->op_xpm);
   sess->op_xpm = 0;
   if (sess->logfd != -1)
   	end_logging(sess->logfd);
}

void gui_change_nick(struct server *serv, char *newnick)
{
   GSList *list = sess_list;
   struct session *sess;
   strcpy(serv->nick, newnick);
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == serv)
	 gtk_label_set(GTK_LABEL(sess->nickgad), newnick);
      list = list->next;
   }
}

void handle_topicgad(GtkWidget *igad, struct session *sess)
{
   char *topic = gtk_entry_get_text(GTK_ENTRY(igad));
   char tbuf[300];
   if(sess->channel[0] && sess->server->connected)
   {
     sprintf(tbuf, "TOPIC %s :%s\r\n", sess->channel, topic);
     send(sess->server->sok, tbuf, strlen(tbuf), 0);
   } else
     gtk_entry_set_text(GTK_ENTRY(igad), "");
}

char *find_selected_nick(struct session *sess)
{
   int row;
   struct user *user = sess->userlist;

   row = gtkutil_clist_selection(sess->namelistgad);
   if(row == -1) return 0;

   user = gtk_clist_get_row_data(GTK_CLIST(sess->namelistgad), row);
   if(!user) return 0;
   return user->user;
}

void ul_button_rel(GtkWidget *widget, GdkEventButton *even, struct session *sess)
{
   if(even && even->button == 3)
   {
      char *nick = find_selected_nick(sess);
      if(nick) menu_popup(sess, even, nick);
   }
}

void add_tip(GtkWidget *wid, char *text)
{
   GtkTooltips *tip = gtk_tooltips_new();
   gtk_tooltips_set_tip(tip, wid, text, 0);
}

void focus_in(GtkWindow *win, GtkWidget *wid, struct session *sess)
{
   if(!sess)
   {
     if(current_tab) gtk_widget_grab_focus(current_tab->inputgad);
   } else {
     sess->server->front_session = sess;
     gtk_widget_grab_focus(sess->inputgad);
     menu_sess = sess;
   }
}

void change_channel_flag(GtkWidget *wid, struct session *sess, char flag)
{
   if(sess->server->connected && sess->channel[0])
   {
      char outbuf[128];
      if(GTK_TOGGLE_BUTTON(wid) -> active)
	sprintf(outbuf, "MODE %s +%c\r\n", sess->channel, flag);
      else
	sprintf(outbuf, "MODE %s -%c\r\n", sess->channel, flag);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, "MODE %s\r\n", sess->channel);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sess->ignore_mode = TRUE;
      sess->ignore_date = TRUE;
   }
}

void flagt_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 't');
}

void flagn_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 'n');
}

void flags_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 's');
}

void flagi_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 'i');
}

void flagp_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 'p');
}

void flagm_hit(GtkWidget *wid, struct session *sess)
{
   change_channel_flag(wid, sess, 'm');
}

void flagl_hit(GtkWidget *wid, struct session *sess)
{
   if(GTK_TOGGLE_BUTTON(wid) -> active)
   {
      if(sess->server->connected && sess->channel[0])
      {
	 char outbuf[128];
	 sprintf(outbuf, "MODE %s +l %d\r\n", sess->channel, atoi(gtk_entry_get_text(GTK_ENTRY(sess->limit_entry))));
	 send(sess->server->sok, outbuf, strlen(outbuf), 0);
         sprintf(outbuf, "MODE %s\r\n", sess->channel);
	 send(sess->server->sok, outbuf, strlen(outbuf), 0);
      }
   } else
      change_channel_flag(wid, sess, 'l');
}


void flagk_hit(GtkWidget *wid, struct session *sess)
{
   if(GTK_TOGGLE_BUTTON(wid) -> active)
   {
      if(sess->server->connected && sess->channel[0])
      {
	 char outbuf[128];
	 sprintf(outbuf, "MODE %s +k %s\r\n", sess->channel, gtk_entry_get_text(GTK_ENTRY(sess->key_entry)));
	 send(sess->server->sok, outbuf, strlen(outbuf), 0);
         sprintf(outbuf, "MODE %s\r\n", sess->channel);
	 send(sess->server->sok, outbuf, strlen(outbuf), 0);
      }
   } else
      change_channel_flag(wid, sess, 'k');
}

void key_entry(GtkWidget *igad, struct session *sess)
{
   if(sess->server->connected && sess->channel[0])
   {
      char outbuf[128];
      sprintf(outbuf, "MODE %s +k %s\r\n", sess->channel, gtk_entry_get_text(GTK_ENTRY(igad)));
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, "MODE %s\r\n", sess->channel);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
   }
}

void limit_entry(GtkWidget *igad, struct session *sess)
{
   if(sess->server->connected && sess->channel[0])
   {
      char outbuf[128];
      sprintf(outbuf, "MODE %s +l %d\r\n", sess->channel, atoi(gtk_entry_get_text(GTK_ENTRY(igad))));
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
      sprintf(outbuf, "MODE %s\r\n", sess->channel);
      send(sess->server->sok, outbuf, strlen(outbuf), 0);
   }
}

void show_and_unfocus(GtkWidget *wid)
{
   GTK_WIDGET_UNSET_FLAGS(wid, GTK_CAN_FOCUS);
   gtk_widget_show(wid);
}

void add_flag_wid(GtkWidget **wid, char *tip, GtkWidget *box, char *face,
		  void *callback, gpointer userdata)
{
   *wid = gtk_toggle_button_new_with_label(face);
   gtk_widget_set_usize(*wid, 18, -1);
   add_tip(*wid, tip);
   gtk_box_pack_end(GTK_BOX(box), *wid, 0, 0, 0);
   gtk_signal_connect(GTK_OBJECT(*wid), "toggled",
		      GTK_SIGNAL_FUNC(callback), userdata);
   show_and_unfocus(*wid);
}

void userlist_button(GtkWidget *box, char *label, char *cmd,
		     struct session *sess, int a, int b, int c, int d)
{
   GtkWidget *wid = gtk_button_new_with_label(label);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(popup_cmd), cmd);
   gtk_table_attach_defaults(GTK_TABLE(box), wid, a, b, c, d);
   show_and_unfocus(wid);
}

void zvt_clear(GtkWidget *wid)
{
#ifdef USE_GNOME
   gtkutil_simpledialog("I can't clear a ZVT text box.");
#endif
}

#ifdef USE_GNOME

void zvt_set_style(GtkWidget *zvt, char *bg_pic, int trans, int tint,
		   GdkFont *norm_font, GdkFont *bold_font)
{
   zvt_term_set_fonts((ZvtTerm*)zvt, norm_font, bold_font);
   if(trans)
     	zvt_term_set_background((ZvtTerm*)zvt, 0, TRUE, tint);
   else {
      if(bg_pic[0])
      {	
	 if(access(bg_pic, R_OK) == 0)
	 {
	    zvt_term_set_background((ZvtTerm*)zvt, bg_pic, FALSE, FALSE);
	 } else {
	    char buf[256];
	    sprintf(buf, "Cannot access %s", bg_pic);
	    gtkutil_simpledialog(buf);
	 }
      } else
	zvt_term_set_background((ZvtTerm*)zvt, 0, FALSE, FALSE);
   }   
}

#endif

GtkStyle *my_widget_get_style(GtkStyle *oldstyle, char *bg_pic, int bg_color)
{
   char buf[256];
   GtkStyle *style;
   GdkPixmap *pixmap;
#ifdef USE_IMLIB
   GdkImlibImage *img;
#endif

   if(oldstyle) style = oldstyle; else style = gtk_style_new();

   style->base[GTK_STATE_NORMAL] = colors[bg_color];
   style->bg[GTK_STATE_NORMAL] = colors[bg_color];

   if(bg_pic[0])
   {
      if(access(bg_pic, R_OK) == 0)
      {
#ifdef USE_IMLIB
	 img = gdk_imlib_load_image(bg_pic);
	 if(img)
	 {
	    gdk_imlib_render(img, img->rgb_width, img->rgb_height);
	    pixmap = gdk_imlib_move_image(img);
	    gdk_imlib_destroy_image(img);
	    if(pixmap) style->bg_pixmap[GTK_STATE_NORMAL] = pixmap;
	 }
#else
	 pixmap = gdk_pixmap_create_from_xpm(0, 0,
					     &style->bg[GTK_STATE_NORMAL], bg_pic);
	 if(pixmap) style->bg_pixmap[0] = pixmap;
#endif
      } else {
         snprintf(buf, sizeof buf, "Cannot access %s", bg_pic);
	 gtkutil_simpledialog(buf);
      }
   }
   return style;
}

int
textgad_get_focus_cb(GtkWidget* wid, GdkEventKey* event, struct session* sess)
{
  char text[2] = " ";
  
  if(event->keyval >= GDK_space && event->keyval <= GDK_asciitilde) 
  {
    text[0] = event->keyval;
    gtk_entry_append_text(GTK_ENTRY(sess->inputgad), text);
    gtk_widget_grab_focus(sess->inputgad);
    return FALSE;
  }
  else if( event->keyval == GDK_BackSpace)
  {
    gtk_widget_grab_focus(sess->inputgad);
    return FALSE;
  }

  return TRUE;
}

gushort rxvt_red[] = { 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
		       0x7777, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000, 0xffff,
		       0xffff, 0x0 };
gushort rxvt_grn[] = { 0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
		       0x7777, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,
		       0xffff, 0x0 };
gushort rxvt_blu[] = { 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
		       0x7777, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
		       0xffff, 0x0 };

void maingui_create_textlist(struct session *sess, GtkWidget *leftpane)
{
   if(prefs.zvt)
   {
#ifdef USE_GNOME
      sess->zvt = TRUE;
      sess->textgad = zvt_term_new();
      /*gtk_widget_set_usize(sess->textgad, 484, 0);*/
      gtk_widget_set_usize(sess->textgad,
			   prefs.mainwindow_width-115, 0);
      zvt_term_set_scrollback((ZvtTerm*)sess->textgad, prefs.zvt_lines);
      zvt_set_style(sess->textgad, prefs.background, prefs.transparent,
		    prefs.tint, font_normal, font_bold);
      gtk_container_add(GTK_CONTAINER(leftpane), sess->textgad);
      gtk_widget_show(sess->textgad);

      sess->vscrollbar = gtk_vscrollbar_new (((ZvtTerm*)sess->textgad)->adjustment);
      gtk_box_pack_start(GTK_BOX(leftpane), sess->vscrollbar, FALSE, FALSE, 0);
      show_and_unfocus(sess->vscrollbar);
#endif
   } else {
      if(!sess->is_tab) gtk_widget_realize(sess->window);
      sess->textgad = gtk_text_new(0, 0);
      if(!channelwin_style)
	channelwin_style = my_widget_get_style(0, prefs.background, prefs.bg_color);
      gtk_widget_set_style(sess->textgad, channelwin_style);
      /*gtk_widget_set_usize(sess->textgad, 484, 0);*/
      gtk_widget_set_usize(sess->textgad,
			   prefs.mainwindow_width-115, 0);
      gtk_signal_connect (GTK_OBJECT(sess->textgad), "key_press_event",
			  GTK_SIGNAL_FUNC(textgad_get_focus_cb), sess);
      gtk_text_set_word_wrap (GTK_TEXT(sess->textgad), TRUE);
      gtk_container_add(GTK_CONTAINER(leftpane), sess->textgad);
      gtk_widget_show(sess->textgad);

      sess->vscrollbar = gtk_vscrollbar_new (GTK_TEXT(sess->textgad)->vadj);
      gtk_box_pack_start(GTK_BOX(leftpane), sess->vscrollbar, FALSE, FALSE, 0);
      show_and_unfocus(sess->vscrollbar);
   }
}

void gui_new_tab(GtkWidget *widget, GtkNotebookPage *nbpage, guint page)
{
   struct session *sess;
   GSList *list = sess_list;
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->window == nbpage->child)
      {
	 current_tab = sess;
	 menu_sess = sess;
	 sess->server->front_session = sess;
	 gui_set_title(sess);
	 gtk_widget_grab_focus(sess->inputgad);
	 if(sess->new_data)
	 {
	    sess->new_data = FALSE;
	    gtk_widget_set_style(sess->changad, normaltab_style);
	 }
	 return;
      }
      list = list->next;
   }
}

void gui_main_window_kill(GtkWidget *win, struct session *sess)
{
   if(!sess_list) xchat_cleanup();
   main_window = 0;
   current_tab = 0;
}

void userlist_hide(GtkWidget *igad, struct session *sess)
{
#ifdef USE_GNOME
   if(sess->userlisthidden)
   {
      if(sess->paned)
	gtk_paned_set_position(GTK_PANED(sess->paned), sess->userlisthidden);
      else
	gtk_widget_show(sess->userlistbox);
      sess->userlisthidden = FALSE;
   } else {
      if(sess->paned)
      {
	 sess->userlisthidden = GTK_PANED(sess->paned)->handle_xpos;
	 gtk_paned_set_position(GTK_PANED(sess->paned), 1200);
      } else {
	 sess->userlisthidden = TRUE;
	 gtk_widget_hide(sess->userlistbox);
      }
   }
#else
   if(sess->userlisthidden)
   {
      gtk_label_set(GTK_LABEL(GTK_BIN(igad)->child), ">");
      if(sess->paned)
	gtk_paned_set_position(GTK_PANED(sess->paned), sess->userlisthidden);
      else
	gtk_widget_show(sess->userlistbox);
      sess->userlisthidden = FALSE;
   } else {
      gtk_label_set(GTK_LABEL(GTK_BIN(igad)->child), "<");
      if(sess->paned)
      {
	 sess->userlisthidden = GTK_PANED(sess->paned)->handle_xpos;
	 gtk_paned_set_position(GTK_PANED(sess->paned), 1200);
      } else {
	 sess->userlisthidden = TRUE;
	 gtk_widget_hide(sess->userlistbox);
      }
   }
#endif
}

void create_window(struct session *sess)
{
   GtkWidget *leftpane, *rightpane;
   GtkWidget *vbox, *tbox, *bbox, *nlbox;
   GtkWidget *wid, *main_box;
   int i, justopened = FALSE;

   if(!sess->server->front_session) sess->server->front_session = sess;

   if(prefs.tabchannels)
   {
      sess->is_tab = TRUE;
      if(!main_window)
      {
	 current_tab = 0;
	 justopened = TRUE;
#ifdef USE_GNOME
	 main_window = gnome_app_new("X-Chat", "X-Chat");
#else
	 main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#endif
	 gtk_widget_realize(main_window);
	 /*gtk_widget_set_usize(main_window, 0, 420);*/
	 gtk_widget_set_usize(main_window,
			      prefs.mainwindow_width,
			      prefs.mainwindow_height);
	 if(prefs.mainwindow_left && prefs.mainwindow_top)
	   gdk_window_move(main_window->window,
			   prefs.mainwindow_left,
			   prefs.mainwindow_top);
	 gtk_signal_connect((GtkObject *)main_window, "destroy",
                            GTK_SIGNAL_FUNC(gui_main_window_kill), sess);
	 gtk_signal_connect((GtkObject *)main_window, "focus_in_event",
                        GTK_SIGNAL_FUNC(focus_in), 0);
	 gtk_window_set_policy((GtkWindow *)main_window, TRUE, TRUE, FALSE);

	 main_box = gtk_vbox_new(0, 0);
#ifdef USE_GNOME
	 gnome_app_set_contents(GNOME_APP(main_window), main_box);
#else
	 gtk_container_add(GTK_CONTAINER(main_window), main_box);
#endif
	 gtk_widget_show(main_box);

#ifdef USE_GNOME
	 createmenus(main_window, sess);
#else
	 wid = createmenus(sess);
	 gtk_box_pack_start(GTK_BOX(main_box), wid, FALSE, TRUE, 0);
	 gtk_widget_show(wid);
#endif
	 main_book = gtk_notebook_new();
	 gtk_signal_connect((GtkObject*)main_book, "switch_page",
			    GTK_SIGNAL_FUNC(gui_new_tab), 0);
	 gtk_container_add(GTK_CONTAINER(main_box), main_book);
	 gtk_widget_show(main_book);
      }
      sess->window = gtk_hbox_new(0, 0);
      gtk_signal_connect((GtkObject *)sess->window, "destroy",
                            GTK_SIGNAL_FUNC(kill_session_callback), sess);
      if(!current_tab)
      {
	 current_tab = sess;
	 gui_set_title(sess);
      }
   } else {
      
#ifdef USE_GNOME
      sess->window = gnome_app_new("X-Chat", "X-Chat");
#else
      sess->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#endif
      gui_set_title(sess);
      /*gtk_widget_set_usize(sess->window, 0, 420);*/
      gtk_widget_set_usize(sess->window,
			   prefs.mainwindow_width,
			   prefs.mainwindow_height);
      if(prefs.mainwindow_left && prefs.mainwindow_top)
	gdk_window_move(sess->window->window,
			prefs.mainwindow_left,
			prefs.mainwindow_top);
      gtk_signal_connect((GtkObject *)sess->window, "destroy",
                            GTK_SIGNAL_FUNC(kill_session_callback), sess);
      gtk_signal_connect ((GtkObject *)sess->window, "focus_in_event",
                        GTK_SIGNAL_FUNC(focus_in), sess);
      gtk_window_set_policy((GtkWindow *)sess->window, TRUE, TRUE, FALSE);
   }

   if(colors[0].pixel == 0)
   {
      for (i=0; i<16; i++) 
      {
	 colors[i].pixel =
	   (gulong)((colors[i].red & 0xff00)*256 +
		    (colors[i].green & 0xff00) +
		    (colors[i].blue & 0xff00)/256);
	 gdk_color_alloc(gtk_widget_get_colormap(sess->window), &colors[i]);
      }
   }

   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_border_width((GtkContainer *)vbox, 2);
   if(!prefs.tabchannels)
   {
#ifdef USE_GNOME
	 gnome_app_set_contents(GNOME_APP(sess->window), vbox);
#else
	 gtk_container_add(GTK_CONTAINER(sess->window), vbox);
#endif
   } else
     gtk_container_add((GtkContainer *)sess->window, vbox);
   gtk_widget_show(vbox);

   if(!prefs.tabchannels)
   {      
#ifdef USE_GNOME
	 createmenus(sess->window, sess);
#else
	 wid = createmenus(sess);
	 gtk_box_pack_start(GTK_BOX(vbox), wid, FALSE, TRUE, 0);
	 gtk_widget_show(wid);
#endif  
   }

   tbox = gtk_hbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(tbox), 0);
   gtk_box_pack_start(GTK_BOX(vbox), tbox, FALSE, TRUE, 2);
   gtk_widget_show(tbox);

/*   if(!prefs.disablex)
   {*/
#ifdef USE_GNOME
      if(sess->is_tab)
	wid = gtkutil_stock_button(main_window, GNOME_STOCK_BUTTON_CANCEL,
				0, gtkutil_destroy, sess->window, 0);
      else
	wid = gtkutil_stock_button(sess->window, GNOME_STOCK_BUTTON_CANCEL,
				0, gtkutil_destroy, sess->window, 0);
      gtk_box_pack_start(GTK_BOX(tbox), wid, 0, 0, 0);
#else
      wid = gtk_button_new_with_label("X");
      gtk_box_pack_start(GTK_BOX(tbox), wid, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(gtkutil_destroy), sess->window);
      gtk_widget_show(wid);
#endif
      add_tip(wid, "Close Channel");
   /*}*/

   if(!prefs.tabchannels)
   {
      sess->changad = gtk_label_new("<none>");
      gtk_box_pack_start(GTK_BOX(tbox), sess->changad, FALSE, FALSE, 10);
      gtk_widget_show(sess->changad);
   }

   sess->topicgad = gtk_entry_new_with_max_length( 255 );  
   gtk_signal_connect(GTK_OBJECT(sess->topicgad), "activate",
                      GTK_SIGNAL_FUNC(handle_topicgad), sess);
   gtk_container_add(GTK_CONTAINER(tbox), sess->topicgad);
   gtk_widget_show(sess->topicgad);

   add_tip(sess->topicgad, "The channel topic");

   if(!prefs.zvt)
   {
#ifdef USE_GNOME
      if(sess->is_tab)
	wid = gtkutil_stock_button(main_window, GNOME_STOCK_PIXMAP_FORWARD, 0,
				userlist_hide, sess, 0);
      else
	wid = gtkutil_stock_button(sess->window, GNOME_STOCK_PIXMAP_FORWARD, 0,
				   userlist_hide, sess, 0);
      gtk_box_pack_end(GTK_BOX(tbox), wid, 0, 0, 0);
#else
      wid = gtk_button_new_with_label(">");
      gtk_box_pack_end(GTK_BOX(tbox), wid, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(wid), "clicked",
			 GTK_SIGNAL_FUNC(userlist_hide), (gpointer)sess);
      /*gtk_widget_show(wid);*/
#endif
      show_and_unfocus(wid);
      add_tip(wid, "Hide/Show Userlist");
   }

   if(!prefs.nochanmodebuttons)
   {
      sess->key_entry = gtk_entry_new_with_max_length(16);
      gtk_widget_set_usize(sess->key_entry, 30, -1);
      gtk_box_pack_end(GTK_BOX(tbox), sess->key_entry, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(sess->key_entry), "activate",
			 GTK_SIGNAL_FUNC(key_entry), (gpointer)sess);
      gtk_widget_show(sess->key_entry);

      add_flag_wid(&(sess->flag_k), "Keyword", tbox, "K", flagk_hit, sess);

      sess->limit_entry = gtk_entry_new_with_max_length(10);
      gtk_widget_set_usize(sess->limit_entry, 30, -1);
      gtk_box_pack_end(GTK_BOX(tbox), sess->limit_entry, 0, 0, 0);
      gtk_signal_connect(GTK_OBJECT(sess->limit_entry), "activate",
			 GTK_SIGNAL_FUNC(limit_entry), (gpointer)sess);
      gtk_widget_show(sess->limit_entry);

      add_flag_wid(&(sess->flag_l), "User Limit", tbox, "L", flagl_hit, sess);

      add_flag_wid(&(sess->flag_m), "Moderated", tbox, "M", flagm_hit, sess);
   
      add_flag_wid(&(sess->flag_p), "Private", tbox, "P", flagp_hit, sess);

      add_flag_wid(&(sess->flag_i), "Invite Only", tbox, "I", flagi_hit, sess);
   
      add_flag_wid(&(sess->flag_s), "Secret", tbox, "S", flags_hit, sess);

      add_flag_wid(&(sess->flag_n), "No outside messages", tbox, "N", flagn_hit, sess);

      add_flag_wid(&(sess->flag_t), "Topic Protection", tbox, "T", flagt_hit, sess);

   } else
     sess->flag_wid[0] = 0;

   leftpane = gtk_hbox_new(FALSE, 0);
   gtk_widget_show(leftpane);

   if(!prefs.nopaned)
   {
      sess->paned = gtk_hpaned_new();
      gtk_container_add(GTK_CONTAINER(vbox), sess->paned);
      gtk_widget_show(sess->paned);
   }

   rightpane = gtk_hbox_new(FALSE, 8);
   gtk_widget_show(rightpane); 
   sess->userlistbox = rightpane;

   if(!prefs.nopaned)
   {
      gtk_paned_pack1(GTK_PANED(sess->paned), leftpane, TRUE, TRUE);
      gtk_paned_pack2(GTK_PANED(sess->paned), rightpane, FALSE, TRUE);
      gtk_paned_gutter_size(GTK_PANED(sess->paned), 10);
   } else {
      wid = gtk_hbox_new(0, 2);
      gtk_container_add(GTK_CONTAINER(vbox), wid);
      gtk_widget_show(wid);
      gtk_container_add(GTK_CONTAINER(wid), leftpane);
      gtk_box_pack_end(GTK_BOX(wid), rightpane, 0, 0, 0);
   }

   sess->nl_box = nlbox = gtk_vbox_new(FALSE, 2);
   gtk_container_add(GTK_CONTAINER(rightpane), nlbox);
   gtk_widget_show(nlbox);

   wid = gtk_frame_new(0);
   gtk_box_pack_start(GTK_BOX(nlbox), wid, 0, 0, 0);
   gtk_widget_show(wid);
   
   sess->namelistinfo = gtk_label_new(" ");
   gtk_container_add(GTK_CONTAINER(wid), sess->namelistinfo);
   gtk_widget_show(sess->namelistinfo);

   maingui_create_textlist(sess, leftpane);

   sess->namelistgad = gtkutil_clist_new(1, 0, nlbox, GTK_POLICY_AUTOMATIC,
					 0, 0,
					 0, 0);
   gtk_clist_set_column_width(GTK_CLIST(sess->namelistgad), 0, 10);
   gtk_widget_set_usize(sess->namelistgad->parent, 115, 0);
   gtk_signal_connect(GTK_OBJECT(sess->namelistgad), "button_press_event",
		      GTK_SIGNAL_FUNC(ul_button_rel), sess);

   if(!prefs.nouserlistbuttons)
      maingui_createbuttons(sess);
   else
      sess->button_box = 0;

   bbox = gtk_hbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(bbox), 0);
   gtk_box_pack_end(GTK_BOX(vbox), bbox, FALSE, TRUE, 2);
   gtk_widget_show(bbox);

   sess->op_box = gtk_hbox_new(0, 0);
   gtk_box_pack_start(GTK_BOX(bbox), sess->op_box, FALSE, FALSE, 2);
   gtk_widget_show(sess->op_box);

   sess->nickgad = gtk_label_new(sess->server->nick);
   gtk_box_pack_start(GTK_BOX(bbox), sess->nickgad, FALSE, FALSE, 4);
   gtk_widget_show(sess->nickgad);

   sess->inputgad = gtk_entry_new_with_max_length( 2048 );
   gtk_container_add(GTK_CONTAINER(bbox), sess->inputgad);
   gtk_signal_connect(GTK_OBJECT(sess->inputgad), "activate",
		      GTK_SIGNAL_FUNC(handle_inputgad), sess);
   gtk_signal_connect(GTK_OBJECT (sess->inputgad), "key_press_event",
	               GTK_SIGNAL_FUNC(history_keypress), &sess->history);
   gtk_widget_show(sess->inputgad);
   gtk_widget_grab_focus(sess->inputgad);
   add_tip(sess->inputgad, "Type in here");

   gtk_widget_show(sess->window);

   if(prefs.tabchannels)
   {
      GtkStyle *style;

      sess->changad = gtk_label_new("<none>");
      gtk_widget_show(sess->changad);

      gtk_notebook_append_page(GTK_NOTEBOOK(main_book), sess->window, sess->changad);
      gtk_widget_realize(sess->textgad);
      if(justopened) gtk_widget_show(main_window);

      style = gtk_widget_get_style(sess->changad);

      if(!normaltab_style)
      {
	 normaltab_style = gtk_style_new();
	 normaltab_style->font = style->font;
	 
	 redtab_style = gtk_style_new();
	 redtab_style->font = style->font;
	 memcpy(redtab_style->fg, &colors[4], sizeof(GdkColor));
      }
   }
#ifdef USE_GNOME
   if(prefs.zvt) zvt_term_set_color_scheme ((ZvtTerm*)sess->textgad, rxvt_red, rxvt_grn, rxvt_blu);
#endif
}
