/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import rfb.Cursor;
import rfb.LogWriter;
import rfb.ManagedPixelBuffer;
import rfb.PixelFormat;
import vncviewer.CConn;
import vncviewer.PixelBufferImage;

class DesktopWindow
extends Canvas {
    CConn cc;
    PixelBufferImage im;
    Graphics graphics;
    Cursor cursor;
    boolean cursorVisible;
    boolean cursorAvailable;
    int cursorPosX;
    int cursorPosY;
    ManagedPixelBuffer cursorBacking;
    int cursorBackingX;
    int cursorBackingY;
    boolean invalidRect;
    int invalidLeft;
    int invalidRight;
    int invalidTop;
    int invalidBottom;
    int lastX;
    int lastY;
    static LogWriter vlog = new LogWriter("DesktopWindow");

    public DesktopWindow(PixelFormat pixelFormat, CConn cConn) {
        this.cc = cConn;
        this.setSize(this.cc.cp.width, this.cc.cp.height);
        this.im = new PixelBufferImage(this.cc.cp.width, this.cc.cp.height, this);
        this.cursor = new Cursor();
        this.cursorBacking = new ManagedPixelBuffer();
    }

    public void initGraphics() {
        this.graphics = this.getGraphics();
    }

    public final PixelFormat getPF() {
        return this.im.getPF();
    }

    public synchronized void setCursor(int n, int n2, int n3, int n4, int[] nArray, byte[] byArray) {
        if (!this.cc.viewer.useLocalCursor.getValue()) {
            return;
        }
        if (!this.cursorAvailable) {
            this.cursorAvailable = true;
        }
        this.hideLocalCursor();
        this.cursor.hotspotX = n;
        this.cursor.hotspotY = n2;
        this.cursor.setSize(n3, n4);
        this.cursor.setPF(this.getPF());
        System.arraycopy(nArray, 0, this.cursor.data, 0, this.cursor.dataLen());
        System.arraycopy(byArray, 0, this.cursor.mask, 0, this.cursor.maskLen());
        this.cursorBacking.setSize(n3, n4);
        this.cursorBacking.setPF(this.getPF());
        this.showLocalCursor();
    }

    public synchronized void resize() {
        System.err.println("DesktopWindow.resize() called");
        int n = this.cc.cp.width;
        int n2 = this.cc.cp.height;
        this.hideLocalCursor();
        this.setSize(n, n2);
        this.im.resize(n, n2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void drawInvalidRect() {
        if (!this.invalidRect) {
            return;
        }
        int n = this.invalidLeft;
        int n2 = this.invalidRight - n;
        int n3 = this.invalidTop;
        int n4 = this.invalidBottom - n3;
        this.invalidRect = false;
        DesktopWindow desktopWindow = this;
        synchronized (desktopWindow) {
            this.im.put(n, n3, n2, n4, this.graphics);
        }
    }

    final void invalidate(int n, int n2, int n3, int n4) {
        if (this.invalidRect) {
            if (n < this.invalidLeft) {
                this.invalidLeft = n;
            }
            if (n + n3 > this.invalidRight) {
                this.invalidRight = n + n3;
            }
            if (n2 < this.invalidTop) {
                this.invalidTop = n2;
            }
            if (n2 + n4 > this.invalidBottom) {
                this.invalidBottom = n2 + n4;
            }
        } else {
            this.invalidLeft = n;
            this.invalidRight = n + n3;
            this.invalidTop = n2;
            this.invalidBottom = n2 + n4;
            this.invalidRect = true;
        }
        if ((this.invalidRight - this.invalidLeft) * (this.invalidBottom - this.invalidTop) > 100000) {
            this.drawInvalidRect();
        }
    }

    public void beginRect(int n, int n2, int n3, int n4, int n5) {
        this.invalidRect = false;
    }

    public void endRect(int n, int n2, int n3, int n4, int n5) {
        this.drawInvalidRect();
    }

    public final synchronized void fillRect(int n, int n2, int n3, int n4, int n5) {
        if (this.overlapsCursor(n, n2, n3, n4)) {
            this.hideLocalCursor();
        }
        this.im.fillRect(n, n2, n3, n4, n5);
        this.invalidate(n, n2, n3, n4);
        this.showLocalCursor();
    }

    public final synchronized void imageRect(int n, int n2, int n3, int n4, int[] nArray) {
        if (this.overlapsCursor(n, n2, n3, n4)) {
            this.hideLocalCursor();
        }
        this.im.imageRect(n, n2, n3, n4, nArray);
        this.invalidate(n, n2, n3, n4);
        this.showLocalCursor();
    }

    public final synchronized void copyRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.overlapsCursor(n, n2, n3, n4) || this.overlapsCursor(n5, n6, n3, n4)) {
            this.hideLocalCursor();
        }
        this.im.copyRect(n, n2, n3, n4, n5, n6);
        this.graphics.setClip(0, 0, this.im.width(), this.im.height());
        this.graphics.copyArea(n5, n6, n3, n4, n - n5, n2 - n6);
    }

    final boolean overlapsCursor(int n, int n2, int n3, int n4) {
        return n < this.cursorBackingX + this.cursorBacking.width() && n2 < this.cursorBackingY + this.cursorBacking.height() && n + n3 > this.cursorBackingX && n2 + n4 > this.cursorBackingY;
    }

    synchronized void resetLocalCursor() {
        this.hideLocalCursor();
        this.cursorAvailable = false;
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this.im.width(), this.im.height());
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(this.im.width(), this.im.height());
    }

    public void update(Graphics graphics) {
        System.err.println("update called");
    }

    public synchronized void paint(Graphics graphics) {
        graphics.drawImage(this.im.image, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 503: 
            case 506: {
                if (!this.cc.viewer.viewOnly.getValue()) {
                    this.cc.writePointerEvent(event);
                }
                DesktopWindow desktopWindow = this;
                synchronized (desktopWindow) {
                    if (this.cursorAvailable && (event.x != this.cursorPosX || event.y != this.cursorPosY)) {
                        this.hideLocalCursor();
                        if (event.x >= 0 && event.x < this.im.width() && event.y >= 0 && event.y < this.im.height()) {
                            this.cursorPosX = event.x;
                            this.cursorPosY = event.y;
                            this.showLocalCursor();
                        }
                    }
                }
                this.lastX = event.x;
                this.lastY = event.y;
                break;
            }
            case 501: 
            case 502: {
                if (!this.cc.viewer.viewOnly.getValue()) {
                    this.cc.writePointerEvent(event);
                }
                this.lastX = event.x;
                this.lastY = event.y;
                break;
            }
            case 403: {
                if (event.key == 1015) {
                    this.cc.showMenu(this.lastX, this.lastY);
                    break;
                }
            }
            case 401: {
                if (this.cc.viewer.viewOnly.getValue()) break;
                this.cc.writeKeyEvent(event);
            }
        }
        return super.handleEvent(event);
    }

    private void hideLocalCursor() {
        if (this.cursorVisible) {
            this.cursorVisible = false;
            this.im.imageRect(this.cursorBackingX, this.cursorBackingY, this.cursorBacking.width(), this.cursorBacking.height(), this.cursorBacking.data);
            this.im.put(this.cursorBackingX, this.cursorBackingY, this.cursorBacking.width(), this.cursorBacking.height(), this.graphics);
        }
    }

    private void showLocalCursor() {
        if (this.cursorAvailable && !this.cursorVisible) {
            if (!this.im.getPF().equal(this.cursor.getPF()) || this.cursor.width() == 0 || this.cursor.height() == 0) {
                vlog.error("attempting to render invalid local cursor");
                this.cursorAvailable = false;
                return;
            }
            this.cursorVisible = true;
            int n = this.cursorPosX - this.cursor.hotspotX;
            int n2 = this.cursorPosY - this.cursor.hotspotY;
            int n3 = n + this.cursor.width();
            int n4 = n2 + this.cursor.height();
            int n5 = n >= 0 ? n : 0;
            int n6 = n2 >= 0 ? n2 : 0;
            int n7 = (n3 < this.im.width() ? n3 : this.im.width()) - n5;
            int n8 = (n4 < this.im.height() ? n4 : this.im.height()) - n6;
            this.cursorBackingX = n5;
            this.cursorBackingY = n6;
            this.cursorBacking.setSize(n7, n8);
            for (int i = 0; i < n8; ++i) {
                System.arraycopy(this.im.data, (n6 + i) * this.im.width() + n5, this.cursorBacking.data, i * n7, n7);
            }
            this.im.maskRect(n, n2, this.cursor.width(), this.cursor.height(), this.cursor.data, this.cursor.mask);
            this.im.put(n5, n6, n7, n8, this.graphics);
        }
    }
}

