/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import rdr.JavaInStream;
import rdr.JavaOutStream;
import rfb.CConnection;
import rfb.CSecurity;
import rfb.CSecurityNone;
import rfb.CSecurityVncAuth;
import rfb.Exception;
import rfb.LogWriter;
import rfb.PasswdGetter;

public class CSecurityTls
extends CSecurity {
    Socket sock;
    int authType;
    CSecurity authSecurity;
    boolean handshakeComplete;
    static LogWriter tlog = new LogWriter("TLS");

    public CSecurityTls(Socket socket, int n, PasswdGetter passwdGetter) {
        this.sock = socket;
        this.authType = n;
        this.handshakeComplete = false;
        switch (this.authType) {
            case 1: {
                this.authSecurity = new CSecurityNone();
                break;
            }
            case 2: {
                this.authSecurity = new CSecurityVncAuth(passwdGetter);
                break;
            }
            default: {
                throw new Exception("Unsupported authType?");
            }
        }
    }

    public int processMsg(CConnection cConnection) {
        if (!this.handshakeComplete) {
            try {
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.sock, this.sock.getInetAddress().getHostName(), this.sock.getPort(), true);
                CSecurityTls.setAnonDHKeyExchangeEnabled(sSLSocket);
                sSLSocket.startHandshake();
                tlog.debug("Completed handshake with server " + sSLSocket.toString());
                cConnection.setStreams(new JavaInStream(sSLSocket.getInputStream()), new JavaOutStream(sSLSocket.getOutputStream()));
                this.handshakeComplete = true;
                return 2;
            }
            catch (IOException iOException) {
                tlog.error("TLS handshake failed " + iOException.toString());
                return 0;
            }
        }
        return this.authSecurity.processMsg(cConnection);
    }

    private static void setAnonDHKeyExchangeEnabled(SSLSocket sSLSocket) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = sSLSocket.getSupportedCipherSuites();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].matches(".*DH_anon.*")) continue;
            arrayList.add(stringArray[i]);
        }
        sSLSocket.setEnabledCipherSuites(arrayList.toArray(new String[0]));
    }

    public String getDescription() {
        switch (this.authType) {
            case 1: {
                return "No Authentication With TLS Encryption";
            }
            case 2: {
                return "Password Authentication With TLS Encryption";
            }
        }
        throw new Exception("Unsupported authType?");
    }
}

