/* gstreamer-interfaces-0.10.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cheader_filename = "gst/interfaces/colorbalance.h")]
	public class ColorBalanceChannel : GLib.Object {
		public weak string label;
		public int max_value;
		public int min_value;
		public virtual signal void value_changed (int value);
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h")]
	public class MixerOptions : Gst.MixerTrack {
		public unowned GLib.List<string> get_values ();
		public static void list_changed (Gst.Mixer mixer, Gst.MixerOptions opts);
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h")]
	public class MixerTrack : GLib.Object {
		[NoAccessorMethod]
		public uint flags { get; }
		[NoAccessorMethod]
		public uint index { get; construct; }
		[NoAccessorMethod]
		public string label { owned get; }
		[NoAccessorMethod]
		public int max_volume { get; }
		[NoAccessorMethod]
		public int min_volume { get; }
		[NoAccessorMethod]
		public int num_channels { get; }
		[NoAccessorMethod]
		public string untranslated_label { owned get; construct; }
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class PhotoSettings {
		public uint aperture;
		public float ev_compensation;
		public uint32 exposure;
		public Gst.FlashMode flash_mode;
		public uint iso_speed;
		public Gst.SceneMode scene_mode;
		public Gst.ColourToneMode tone_mode;
		public Gst.WhiteBalanceMode wb_mode;
		public float zoom;
	}
	[Compact]
	[CCode (cheader_filename = "gst/gst.h")]
	public class Photography {
		public bool get_aperture (uint aperture);
		public Gst.PhotoCaps get_capabilities ();
		public bool get_colour_tone_mode (Gst.ColourToneMode tone_mode);
		public bool get_config (Gst.PhotoSettings config);
		public bool get_ev_compensation (float ev_comp);
		public bool get_exposure (uint32 exposure);
		public bool get_flash_mode (Gst.FlashMode flash_mode);
		public bool get_iso_speed (uint iso_speed);
		public bool get_scene_mode (Gst.SceneMode scene_mode);
		public bool get_white_balance_mode (Gst.WhiteBalanceMode wb_mode);
		public bool get_zoom (float zoom);
		public bool prepare_for_capture (Gst.PhotoCapturePrepared func, Gst.Caps capture_caps);
		public bool set_aperture (uint aperture);
		public void set_autofocus (bool on);
		public bool set_colour_tone_mode (Gst.ColourToneMode tone_mode);
		public bool set_config (Gst.PhotoSettings config);
		public bool set_ev_compensation (float ev_comp);
		public bool set_exposure (uint exposure);
		public bool set_flash_mode (Gst.FlashMode flash_mode);
		public bool set_iso_speed (uint iso_speed);
		public bool set_scene_mode (Gst.SceneMode scene_mode);
		public bool set_white_balance_mode (Gst.WhiteBalanceMode wb_mode);
		public bool set_zoom (float zoom);
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h")]
	public class TunerChannel : GLib.Object {
		public Gst.TunerChannelFlags flags;
		public float freq_multiplicator;
		public weak string label;
		public ulong max_frequency;
		public int max_signal;
		public ulong min_frequency;
		public int min_signal;
		public static void changed (Gst.Tuner tuner, Gst.TunerChannel channel);
		public virtual signal void frequency_changed (ulong frequency);
		public virtual signal void signal_changed (int @signal);
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h")]
	public class TunerNorm : GLib.Object {
		public Gst.Value framerate;
		public weak string label;
		public static void changed (Gst.Tuner tuner, Gst.TunerNorm norm);
	}
	[CCode (cheader_filename = "gst/interfaces/colorbalance.h")]
	public interface ColorBalance : Gst.ImplementsInterface, Gst.Element {
		public Gst.ColorBalanceType get_balance_type ();
		public abstract int get_value (Gst.ColorBalanceChannel channel);
		public abstract unowned GLib.List<Gst.ColorBalanceChannel> list_channels ();
		public abstract void set_value (Gst.ColorBalanceChannel channel, int value);
		[HasEmitter]
		public signal void value_changed (Gst.ColorBalanceChannel channel, int value);
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h")]
	public interface Mixer : Gst.ImplementsInterface, Gst.Element {
		public abstract Gst.MixerFlags get_mixer_flags ();
		public Gst.MixerType get_mixer_type ();
		public abstract unowned string get_option (Gst.MixerOptions opts);
		public abstract void get_volume (Gst.MixerTrack track, int volumes);
		public abstract unowned GLib.List<Gst.MixerTrack> list_tracks ();
		public static Gst.MixerMessageType message_get_type (Gst.Message message);
		public static void message_parse_mute_toggled (Gst.Message message, out unowned Gst.MixerTrack track, bool mute);
		public static void message_parse_option_changed (Gst.Message message, out unowned Gst.MixerOptions options, string value);
		public static void message_parse_options_list_changed (Gst.Message message, out unowned Gst.MixerOptions options);
		public static void message_parse_record_toggled (Gst.Message message, out unowned Gst.MixerTrack track, bool record);
		public static void message_parse_volume_changed (Gst.Message message, out unowned Gst.MixerTrack track, int volumes, int num_channels);
		public void mixer_changed ();
		public abstract void set_mute (Gst.MixerTrack track, bool mute);
		public abstract void set_option (Gst.MixerOptions opts, string value);
		public abstract void set_record (Gst.MixerTrack track, bool record);
		public abstract void set_volume (Gst.MixerTrack track, int volumes);
		[HasEmitter]
		public signal void mute_toggled (Gst.MixerTrack channel, bool mute);
		[HasEmitter]
		public signal void option_changed (Gst.MixerOptions opts, string option);
		[HasEmitter]
		public signal void record_toggled (Gst.MixerTrack channel, bool record);
		[HasEmitter]
		public signal void volume_changed (Gst.MixerTrack channel, void* volumes);
	}
	[CCode (cheader_filename = "gst/interfaces/navigation.h")]
	public interface Navigation : Gst.Element {
		public static Gst.NavigationEventType event_get_type (Gst.Event event);
		public static bool event_parse_command (Gst.Event event, Gst.NavigationCommand command);
		public static bool event_parse_key_event (Gst.Event event, string key);
		public static bool event_parse_mouse_button_event (Gst.Event event, int button, double x, double y);
		public static bool event_parse_mouse_move_event (Gst.Event event, double x, double y);
		public static Gst.NavigationMessageType message_get_type (Gst.Message message);
		public static unowned Gst.Message message_new_angles_changed (Gst.Object src, uint cur_angle, uint n_angles);
		public static unowned Gst.Message message_new_commands_changed (Gst.Object src);
		public static unowned Gst.Message message_new_mouse_over (Gst.Object src, bool active);
		public static bool message_parse_angles_changed (Gst.Message message, uint cur_angle, uint n_angles);
		public static bool message_parse_mouse_over (Gst.Message message, bool active);
		public static Gst.NavigationQueryType query_get_type (Gst.Query query);
		public static unowned Gst.Query query_new_angles ();
		public static unowned Gst.Query query_new_commands ();
		public static bool query_parse_angles (Gst.Query query, uint cur_angle, uint n_angles);
		public static bool query_parse_commands_length (Gst.Query query, uint n_cmds);
		public static bool query_parse_commands_nth (Gst.Query query, uint nth, Gst.NavigationCommand cmd);
		public static void query_set_angles (Gst.Query query, uint cur_angle, uint n_angles);
		public static void query_set_commands (Gst.Query query, int n_cmds);
		public static void query_set_commandsv (Gst.Query query, int n_cmds, Gst.NavigationCommand cmds);
		public void send_command (Gst.NavigationCommand command);
		public abstract void send_event (Gst.Structure structure);
		public void send_key_event (string event, string key);
		public void send_mouse_event (string event, int button, double x, double y);
	}
	[CCode (cheader_filename = "gst/interfaces/propertyprobe.h")]
	public interface PropertyProbe {
		public abstract unowned GLib.List<string> get_properties ();
		public unowned GLib.ParamSpec get_property (string name);
		public abstract unowned GLib.ValueArray get_values (GLib.ParamSpec pspec);
		public unowned GLib.ValueArray get_values_name (string name);
		public abstract bool needs_probe (GLib.ParamSpec pspec);
		public bool needs_probe_name (string name);
		public unowned GLib.ValueArray probe_and_get_values (GLib.ParamSpec pspec);
		public unowned GLib.ValueArray probe_and_get_values_name (string name);
		public abstract void probe_property (GLib.ParamSpec pspec);
		public void probe_property_name (string name);
		public signal void probe_needed (void* pspec);
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h")]
	public interface Tuner : Gst.ImplementsInterface, Gst.Element {
		public unowned Gst.TunerChannel find_channel_by_name (string channel);
		public unowned Gst.TunerNorm find_norm_by_name (string norm);
		public abstract unowned Gst.TunerChannel get_channel ();
		public abstract ulong get_frequency (Gst.TunerChannel channel);
		public abstract unowned Gst.TunerNorm get_norm ();
		public abstract unowned GLib.List<Gst.TunerChannel> list_channels ();
		public abstract unowned GLib.List<Gst.TunerNorm> list_norms ();
		public abstract void set_channel (Gst.TunerChannel channel);
		public abstract void set_frequency (Gst.TunerChannel channel, ulong frequency);
		public abstract void set_norm (Gst.TunerNorm norm);
		public abstract int signal_strength (Gst.TunerChannel channel);
		public signal void channel_changed (Gst.TunerChannel channel);
		[HasEmitter]
		public signal void frequency_changed (Gst.TunerChannel channel, ulong frequency);
		public signal void norm_changed (Gst.TunerNorm norm);
		[HasEmitter]
		public signal void signal_changed (Gst.TunerChannel channel, int @signal);
	}
	[CCode (cheader_filename = "gst/interfaces/videoorientation.h")]
	public interface VideoOrientation : Gst.ImplementsInterface, Gst.Element {
		public abstract bool get_hcenter (int center);
		public abstract bool get_hflip (bool flip);
		public abstract bool get_vcenter (int center);
		public abstract bool get_vflip (bool flip);
		public abstract bool set_hcenter (int center);
		public abstract bool set_hflip (bool flip);
		public abstract bool set_vcenter (int center);
		public abstract bool set_vflip (bool flip);
	}
	[CCode (cheader_filename = "gst/interfaces/xoverlay.h", lower_case_csuffix = "x_overlay")]
	public interface XOverlay : Gst.ImplementsInterface, Gst.Element {
		public abstract void expose ();
		public void got_xwindow_id (ulong xwindow_id);
		public abstract void handle_events (bool handle_events);
		public void prepare_xwindow_id ();
		public abstract void set_xwindow_id (ulong xwindow_id);
	}
	[CCode (cprefix = "GST_COLOR_BALANCE_", cheader_filename = "gst/interfaces/colorbalance.h")]
	public enum ColorBalanceType {
		HARDWARE,
		SOFTWARE
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_COLOUR_TONE_MODE_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum ColourToneMode {
		NORMAL,
		SEPIA,
		NEGATIVE,
		GRAYSCALE,
		NATURAL,
		VIVID,
		COLORSWAP,
		SOLARIZE,
		OUT_OF_FOCUS
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_FLASH_MODE_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum FlashMode {
		AUTO,
		OFF,
		ON,
		FILL_IN,
		RED_EYE
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_FOCUS_STATUS_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum FocusStatus {
		NONE,
		RUNNING,
		FAIL,
		SUCCESS
	}
	[CCode (cprefix = "GST_MIXER_FLAG_", cheader_filename = "gst/interfaces/mixer.h")]
	[Flags]
	public enum MixerFlags {
		NONE,
		AUTO_NOTIFICATIONS,
		HAS_WHITELIST,
		GROUPING
	}
	[CCode (cprefix = "GST_MIXER_MESSAGE_", cheader_filename = "gst/interfaces/mixer.h")]
	public enum MixerMessageType {
		INVALID,
		MUTE_TOGGLED,
		RECORD_TOGGLED,
		VOLUME_CHANGED,
		OPTION_CHANGED,
		OPTIONS_LIST_CHANGED,
		MIXER_CHANGED
	}
	[CCode (cprefix = "GST_MIXER_TRACK_", cheader_filename = "gst/interfaces/mixertrack.h")]
	[Flags]
	public enum MixerTrackFlags {
		INPUT,
		OUTPUT,
		MUTE,
		RECORD,
		MASTER,
		SOFTWARE,
		NO_RECORD,
		NO_MUTE,
		WHITELIST
	}
	[CCode (cprefix = "GST_MIXER_", cheader_filename = "gst/interfaces/mixer.h")]
	public enum MixerType {
		HARDWARE,
		SOFTWARE
	}
	[CCode (cprefix = "GST_NAVIGATION_COMMAND_", cheader_filename = "gst/gst.h")]
	public enum NavigationCommand {
		INVALID,
		MENU1,
		MENU2,
		MENU3,
		MENU4,
		MENU5,
		MENU6,
		MENU7,
		LEFT,
		RIGHT,
		UP,
		DOWN,
		ACTIVATE,
		PREV_ANGLE,
		NEXT_ANGLE
	}
	[CCode (cprefix = "GST_NAVIGATION_EVENT_", cheader_filename = "gst/gst.h")]
	public enum NavigationEventType {
		INVALID,
		KEY_PRESS,
		KEY_RELEASE,
		MOUSE_BUTTON_PRESS,
		MOUSE_BUTTON_RELEASE,
		MOUSE_MOVE,
		COMMAND
	}
	[CCode (cprefix = "GST_NAVIGATION_MESSAGE_", cheader_filename = "gst/gst.h")]
	public enum NavigationMessageType {
		INVALID,
		MOUSE_OVER,
		COMMANDS_CHANGED,
		ANGLES_CHANGED
	}
	[CCode (cprefix = "GST_NAVIGATION_QUERY_", cheader_filename = "gst/gst.h")]
	public enum NavigationQueryType {
		INVALID,
		COMMANDS,
		ANGLES
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_CAPS_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum PhotoCaps {
		NONE,
		EV_COMP,
		ISO_SPEED,
		WB_MODE,
		TONE,
		SCENE,
		FLASH,
		ZOOM,
		FOCUS,
		APERTURE,
		EXPOSURE,
		SHAKE
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_SHAKE_RISK_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum PhotoShakeRisk {
		LOW,
		MEDIUM,
		HIGH
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_SCENE_MODE_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum SceneMode {
		MANUAL,
		CLOSEUP,
		PORTRAIT,
		LANDSCAPE,
		SPORT,
		NIGHT,
		AUTO
	}
	[CCode (cprefix = "GST_TUNER_CHANNEL_", cheader_filename = "gst/interfaces/tuner.h")]
	[Flags]
	public enum TunerChannelFlags {
		INPUT,
		OUTPUT,
		FREQUENCY,
		AUDIO
	}
	[CCode (cprefix = "GST_PHOTOGRAPHY_WB_MODE_", has_type_id = "0", cheader_filename = "gst/gst.h")]
	public enum WhiteBalanceMode {
		AUTO,
		DAYLIGHT,
		CLOUDY,
		SUNSET,
		TUNGSTEN,
		FLUORESCENT
	}
	[CCode (cheader_filename = "gst/gst.h", has_target = false)]
	public delegate void PhotoCapturePrepared (void* data, Gst.Caps configured_caps);
	[CCode (cheader_filename = "gst/gst.h")]
	public const string PHOTOGRAPHY_AUTOFOCUS_DONE;
	[CCode (cheader_filename = "gst/gst.h")]
	public const string PHOTOGRAPHY_SHAKE_RISK;
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type colour_tone_mode_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type flash_mode_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type focus_status_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type photo_caps_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type photo_shake_risk_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type scene_mode_get_type ();
	[CCode (cheader_filename = "gst/gst.h")]
	public static GLib.Type white_balance_mode_get_type ();
}
