/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;
typedef struct _ValaTypeRegisterFunctionPrivate ValaTypeRegisterFunctionPrivate;
typedef struct _ValaParamSpecTypeRegisterFunction ValaParamSpecTypeRegisterFunction;

/**
 * C function to register a type at runtime.
 */
struct _ValaTypeRegisterFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTypeRegisterFunctionPrivate * priv;
};

struct _ValaTypeRegisterFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTypeRegisterFunction *self);
	ValaTypeSymbol* (*get_type_declaration) (ValaTypeRegisterFunction* self);
	char* (*get_type_struct_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_instance_struct_size) (ValaTypeRegisterFunction* self);
	char* (*get_instance_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_parent_type_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_init_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_peek_pointer_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_free_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_copy_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_lcopy_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_collect_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_type_flags) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_declaration) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_statements) (ValaTypeRegisterFunction* self);
	ValaSymbolAccessibility (*get_accessibility) (ValaTypeRegisterFunction* self);
};

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* source_declaration_fragment;
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
	ValaCodeContext* _context;
};

struct _ValaParamSpecTypeRegisterFunction {
	GParamSpec parent_instance;
};


static gpointer vala_typeregister_function_parent_class = NULL;

gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY
};
ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self);
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self);
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_base_finalize_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_class_finalize_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_source_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self);
static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self);
void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value);
static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Constructs the C function from the specified type.
 */
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean use_thread_safe;
	gboolean fundamental;
	ValaTypeSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp1_;
	gboolean _tmp2_;
	char* _tmp4_;
	ValaTypeSymbol* _tmp3_;
	char* _tmp5_;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* fun;
	char* type_value_table_decl_name;
	ValaCCodeBlock* type_init;
	ValaTypeSymbol* _tmp41_;
	gboolean _tmp42_;
	ValaCCodeFragment* _tmp57_;
	gboolean _tmp58_;
	ValaCCodeFunctionCall* reg_call;
	ValaTypeSymbol* _tmp73_;
	gboolean _tmp74_;
	ValaCCodeConstant* _tmp93_;
	char* _tmp92_;
	char* _tmp91_;
	ValaTypeSymbol* _tmp90_;
	ValaTypeSymbol* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp106_;
	ValaCCodeFragment* _tmp111_;
	ValaCCodeFunction* _tmp134_;
	g_return_if_fail (self != NULL);
	use_thread_safe = vala_code_context_require_glib_version (self->priv->_context, 2, 14);
	fundamental = FALSE;
	_tmp0_ = NULL;
	cl = (_tmp0_ = vala_typeregister_function_get_type_declaration (self), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL);
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (cl != NULL) {
		_tmp2_ = !vala_class_get_is_compact (cl);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		fundamental = TRUE;
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	type_id_name = (_tmp5_ = g_strdup_printf ("%s_type_id", _tmp4_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp3_ = vala_typeregister_function_get_type_declaration (self)), NULL)), _tmp4_ = (g_free (_tmp4_), NULL), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL)), _tmp5_);
	type_block = vala_ccode_block_new ();
	_cdecl_ = NULL;
	if (use_thread_safe) {
		ValaCCodeDeclaration* _tmp6_;
		ValaCCodeVariableDeclarator* _tmp9_;
		ValaCCodeConstant* _tmp8_;
		char* _tmp7_;
		_tmp6_ = NULL;
		_cdecl_ = (_tmp6_ = vala_ccode_declaration_new ("gsize"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp6_);
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new (_tmp7_ = g_strconcat (type_id_name, "__volatile", NULL), (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("0")), NULL)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp7_ = (g_free (_tmp7_), NULL);
	} else {
		ValaCCodeDeclaration* _tmp10_;
		ValaCCodeVariableDeclarator* _tmp12_;
		ValaCCodeConstant* _tmp11_;
		_tmp10_ = NULL;
		_cdecl_ = (_tmp10_ = vala_ccode_declaration_new ("GType"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp10_);
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new (type_id_name, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("0")), NULL)));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	}
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (use_thread_safe) {
		vala_ccode_declaration_set_modifiers (_cdecl_, vala_ccode_declaration_get_modifiers (_cdecl_) | VALA_CCODE_MODIFIERS_VOLATILE);
	}
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) _cdecl_);
	} else {
		vala_ccode_fragment_append (self->priv->source_declaration_fragment, (ValaCCodeNode*) _cdecl_);
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		ValaTypeSymbol* _tmp13_;
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		fun = (_tmp16_ = vala_ccode_function_new (_tmp15_ = g_strdup_printf ("%s_get_type", _tmp14_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp13_ = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp16_);
		_tmp15_ = (g_free (_tmp15_), NULL);
		_tmp14_ = (g_free (_tmp14_), NULL);
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_code_node_unref (_tmp13_), NULL));
		/* Function will not be prototyped anyway */
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp20_;
		char* _tmp19_;
		char* _tmp18_;
		ValaTypeSymbol* _tmp17_;
		ValaCCodeFormalParameter* _tmp21_;
		char* _tmp24_;
		char* _tmp23_;
		ValaTypeSymbol* _tmp22_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeBlock* _tmp27_;
		ValaCCodeReturnStatement* _tmp29_;
		ValaCCodeIdentifier* _tmp28_;
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		fun = (_tmp20_ = vala_ccode_function_new (_tmp19_ = g_strdup_printf ("%s_register_type", _tmp18_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp17_ = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp20_);
		_tmp19_ = (g_free (_tmp19_), NULL);
		_tmp18_ = (g_free (_tmp18_), NULL);
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_code_node_unref (_tmp17_), NULL));
		_tmp21_ = NULL;
		vala_ccode_function_add_parameter (fun, _tmp21_ = vala_ccode_formal_parameter_new ("module", "GTypeModule *"));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		_tmp25_ = NULL;
		get_fun = (_tmp25_ = vala_ccode_function_new (_tmp24_ = g_strdup_printf ("%s_get_type", _tmp23_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp22_ = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), _tmp24_ = (g_free (_tmp24_), NULL), _tmp23_ = (g_free (_tmp23_), NULL), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_code_node_unref (_tmp22_), NULL)), _tmp25_);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp26_ = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp26_ = vala_ccode_function_copy (get_fun)));
		(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		_tmp27_ = NULL;
		vala_ccode_function_set_block (get_fun, _tmp27_ = vala_ccode_block_new ());
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), (ValaCCodeNode*) (_tmp29_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new (type_id_name)))));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
		vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) get_fun);
		(get_fun == NULL) ? NULL : (get_fun = (vala_ccode_node_unref (get_fun), NULL));
	}
	type_value_table_decl_name = NULL;
	type_init = vala_ccode_block_new ();
	if (fundamental) {
		ValaCCodeDeclaration* cgtypetabledecl;
		ValaCCodeVariableDeclarator* _tmp38_;
		ValaCCodeConstant* _tmp37_;
		char* _tmp36_;
		char* _tmp35_;
		char* _tmp34_;
		char* _tmp33_;
		char* _tmp32_;
		char* _tmp31_;
		char* _tmp30_;
		char* _tmp39_;
		cgtypetabledecl = vala_ccode_declaration_new ("const GTypeValueTable");
		vala_ccode_declaration_set_modifiers (cgtypetabledecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		_tmp32_ = NULL;
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		vala_ccode_declaration_add_declarator (cgtypetabledecl, (ValaCCodeDeclarator*) (_tmp38_ = vala_ccode_variable_declarator_new ("g_define_type_value_table", (ValaCCodeExpression*) (_tmp37_ = vala_ccode_constant_new (_tmp36_ = g_strdup_printf ("{ %s, %s, %s, %s, \"p\", %s, \"p\", %s }", _tmp30_ = vala_typeregister_function_get_gtype_value_table_init_function_name (self), _tmp31_ = vala_typeregister_function_get_gtype_value_table_free_function_name (self), _tmp32_ = vala_typeregister_function_get_gtype_value_table_copy_function_name (self), _tmp33_ = vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (self), _tmp34_ = vala_typeregister_function_get_gtype_value_table_collect_value_function_name (self), _tmp35_ = vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (self)))), NULL)));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
		_tmp36_ = (g_free (_tmp36_), NULL);
		_tmp35_ = (g_free (_tmp35_), NULL);
		_tmp34_ = (g_free (_tmp34_), NULL);
		_tmp33_ = (g_free (_tmp33_), NULL);
		_tmp32_ = (g_free (_tmp32_), NULL);
		_tmp31_ = (g_free (_tmp31_), NULL);
		_tmp30_ = (g_free (_tmp30_), NULL);
		_tmp39_ = NULL;
		type_value_table_decl_name = (_tmp39_ = g_strdup ("&g_define_type_value_table"), type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL), _tmp39_);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) cgtypetabledecl);
		(cgtypetabledecl == NULL) ? NULL : (cgtypetabledecl = (vala_ccode_node_unref (cgtypetabledecl), NULL));
	} else {
		char* _tmp40_;
		_tmp40_ = NULL;
		type_value_table_decl_name = (_tmp40_ = g_strdup ("NULL"), type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL), _tmp40_);
	}
	_tmp41_ = NULL;
	if ((_tmp42_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp41_ = vala_typeregister_function_get_type_declaration (self)), (_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_code_node_unref (_tmp41_), NULL)), _tmp42_)) {
		ValaCCodeDeclaration* ctypedecl;
		char* _tmp43_;
		ValaCCodeVariableDeclarator* _tmp54_;
		ValaCCodeConstant* _tmp53_;
		char* _tmp52_;
		char* _tmp51_;
		char* _tmp50_;
		char* _tmp49_;
		char* _tmp48_;
		char* _tmp47_;
		char* _tmp46_;
		ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
		vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp43_ = NULL;
		if (plugin) {
			char* _tmp44_;
			_tmp44_ = NULL;
			_tmp43_ = (_tmp44_ = vala_typeregister_function_get_base_finalize_func_name (self), _tmp43_ = (g_free (_tmp43_), NULL), _tmp44_);
		} else {
			char* _tmp45_;
			_tmp45_ = NULL;
			_tmp43_ = (_tmp45_ = g_strdup ("NULL"), _tmp43_ = (g_free (_tmp43_), NULL), _tmp45_);
		}
		_tmp54_ = NULL;
		_tmp53_ = NULL;
		_tmp52_ = NULL;
		_tmp51_ = NULL;
		_tmp50_ = NULL;
		_tmp49_ = NULL;
		_tmp48_ = NULL;
		_tmp47_ = NULL;
		_tmp46_ = NULL;
		vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp54_ = vala_ccode_variable_declarator_new ("g_define_type_info", (ValaCCodeExpression*) (_tmp53_ = vala_ccode_constant_new (_tmp52_ = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) %s, (GClassInitFunc) %s, (GClassFinalizeFunc) %s, NULL, %s, 0, (GInstanceInitFunc) %s, %s }", _tmp46_ = vala_typeregister_function_get_type_struct_name (self), _tmp47_ = vala_typeregister_function_get_base_init_func_name (self), _tmp43_, _tmp48_ = vala_typeregister_function_get_class_init_func_name (self), _tmp49_ = vala_typeregister_function_get_class_finalize_func_name (self), _tmp50_ = vala_typeregister_function_get_instance_struct_size (self), _tmp51_ = vala_typeregister_function_get_instance_init_func_name (self), type_value_table_decl_name))), NULL)));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
		_tmp52_ = (g_free (_tmp52_), NULL);
		_tmp51_ = (g_free (_tmp51_), NULL);
		_tmp50_ = (g_free (_tmp50_), NULL);
		_tmp49_ = (g_free (_tmp49_), NULL);
		_tmp48_ = (g_free (_tmp48_), NULL);
		_tmp47_ = (g_free (_tmp47_), NULL);
		_tmp46_ = (g_free (_tmp46_), NULL);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypedecl);
		if (fundamental) {
			ValaCCodeDeclaration* ctypefundamentaldecl;
			ValaCCodeVariableDeclarator* _tmp56_;
			ValaCCodeConstant* _tmp55_;
			ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
			vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
			_tmp56_ = NULL;
			_tmp55_ = NULL;
			vala_ccode_declaration_add_declarator (ctypefundamentaldecl, (ValaCCodeDeclarator*) (_tmp56_ = vala_ccode_variable_declarator_new ("g_define_type_fundamental_info", (ValaCCodeExpression*) (_tmp55_ = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")), NULL)));
			(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
			(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypefundamentaldecl);
			(ctypefundamentaldecl == NULL) ? NULL : (ctypefundamentaldecl = (vala_ccode_node_unref (ctypefundamentaldecl), NULL));
		}
		(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
		_tmp43_ = (g_free (_tmp43_), NULL);
	}
	_tmp57_ = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp57_ = vala_typeregister_function_get_type_interface_init_declaration (self)));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	_tmp58_ = FALSE;
	if (cl != NULL) {
		_tmp58_ = vala_class_get_has_class_private_fields (cl);
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		ValaCCodeFunctionCall* quark_reg_call;
		ValaCCodeConstant* _tmp66_;
		char* _tmp65_;
		char* _tmp64_;
		ValaTypeSymbol* _tmp63_;
		ValaCCodeExpressionStatement* _tmp72_;
		ValaCCodeAssignment* _tmp71_;
		ValaCCodeIdentifier* _tmp70_;
		char* _tmp69_;
		char* _tmp68_;
		ValaTypeSymbol* _tmp67_;
		quark_reg_call = NULL;
		if (plugin) {
			ValaCCodeFunctionCall* _tmp60_;
			ValaCCodeIdentifier* _tmp59_;
			_tmp60_ = NULL;
			_tmp59_ = NULL;
			quark_reg_call = (_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("g_quark_from_string"))), (quark_reg_call == NULL) ? NULL : (quark_reg_call = (vala_ccode_node_unref (quark_reg_call), NULL)), _tmp60_);
			(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
		} else {
			ValaCCodeFunctionCall* _tmp62_;
			ValaCCodeIdentifier* _tmp61_;
			_tmp62_ = NULL;
			_tmp61_ = NULL;
			quark_reg_call = (_tmp62_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new ("g_quark_from_static_string"))), (quark_reg_call == NULL) ? NULL : (quark_reg_call = (vala_ccode_node_unref (quark_reg_call), NULL)), _tmp62_);
			(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		}
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		_tmp64_ = NULL;
		_tmp63_ = NULL;
		vala_ccode_function_call_add_argument (quark_reg_call, (ValaCCodeExpression*) (_tmp66_ = vala_ccode_constant_new (_tmp65_ = g_strdup_printf ("\"Vala%sClassPrivate\"", _tmp64_ = vala_typesymbol_get_cname (_tmp63_ = vala_typeregister_function_get_type_declaration (self), FALSE)))));
		(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
		_tmp65_ = (g_free (_tmp65_), NULL);
		_tmp64_ = (g_free (_tmp64_), NULL);
		(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_code_node_unref (_tmp63_), NULL));
		_tmp72_ = NULL;
		_tmp71_ = NULL;
		_tmp70_ = NULL;
		_tmp69_ = NULL;
		_tmp68_ = NULL;
		_tmp67_ = NULL;
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp72_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp71_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp70_ = vala_ccode_identifier_new (_tmp69_ = g_strdup_printf ("_vala_%s_class_private_quark", _tmp68_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp67_ = vala_typeregister_function_get_type_declaration (self)), NULL)))), (ValaCCodeExpression*) quark_reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
		(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
		(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
		_tmp69_ = (g_free (_tmp69_), NULL);
		_tmp68_ = (g_free (_tmp68_), NULL);
		(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_code_node_unref (_tmp67_), NULL));
		(quark_reg_call == NULL) ? NULL : (quark_reg_call = (vala_ccode_node_unref (quark_reg_call), NULL));
	}
	reg_call = NULL;
	_tmp73_ = NULL;
	if ((_tmp74_ = VALA_IS_STRUCT (_tmp73_ = vala_typeregister_function_get_type_declaration (self)), (_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_code_node_unref (_tmp73_), NULL)), _tmp74_)) {
		ValaCCodeFunctionCall* _tmp76_;
		ValaCCodeIdentifier* _tmp75_;
		_tmp76_ = NULL;
		_tmp75_ = NULL;
		reg_call = (_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("g_boxed_type_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp76_);
		(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
	} else {
		if (fundamental) {
			ValaCCodeFunctionCall* _tmp78_;
			ValaCCodeIdentifier* _tmp77_;
			ValaCCodeFunctionCall* _tmp80_;
			ValaCCodeIdentifier* _tmp79_;
			_tmp78_ = NULL;
			_tmp77_ = NULL;
			reg_call = (_tmp78_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_identifier_new ("g_type_register_fundamental"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp78_);
			(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
			_tmp80_ = NULL;
			_tmp79_ = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp80_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp79_ = vala_ccode_identifier_new ("g_type_fundamental_next")))));
			(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
			(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
		} else {
			if (!plugin) {
				ValaCCodeFunctionCall* _tmp82_;
				ValaCCodeIdentifier* _tmp81_;
				ValaCCodeIdentifier* _tmp84_;
				char* _tmp83_;
				_tmp82_ = NULL;
				_tmp81_ = NULL;
				reg_call = (_tmp82_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81_ = vala_ccode_identifier_new ("g_type_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp82_);
				(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
				_tmp84_ = NULL;
				_tmp83_ = NULL;
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp84_ = vala_ccode_identifier_new (_tmp83_ = vala_typeregister_function_get_parent_type_name (self))));
				(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
				_tmp83_ = (g_free (_tmp83_), NULL);
			} else {
				ValaCCodeFunctionCall* _tmp86_;
				ValaCCodeIdentifier* _tmp85_;
				ValaCCodeIdentifier* _tmp87_;
				ValaCCodeIdentifier* _tmp89_;
				char* _tmp88_;
				_tmp86_ = NULL;
				_tmp85_ = NULL;
				reg_call = (_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new ("g_type_module_register_type"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp86_);
				(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
				_tmp87_ = NULL;
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("module")));
				(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
				_tmp89_ = NULL;
				_tmp88_ = NULL;
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_identifier_new (_tmp88_ = vala_typeregister_function_get_parent_type_name (self))));
				(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
				_tmp88_ = (g_free (_tmp88_), NULL);
			}
		}
	}
	_tmp93_ = NULL;
	_tmp92_ = NULL;
	_tmp91_ = NULL;
	_tmp90_ = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp93_ = vala_ccode_constant_new (_tmp92_ = g_strdup_printf ("\"%s\"", _tmp91_ = vala_typesymbol_get_cname (_tmp90_ = vala_typeregister_function_get_type_declaration (self), FALSE)))));
	(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
	_tmp92_ = (g_free (_tmp92_), NULL);
	_tmp91_ = (g_free (_tmp91_), NULL);
	(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_code_node_unref (_tmp90_), NULL));
	_tmp94_ = NULL;
	if ((_tmp95_ = VALA_IS_STRUCT (_tmp94_ = vala_typeregister_function_get_type_declaration (self)), (_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_code_node_unref (_tmp94_), NULL)), _tmp95_)) {
		ValaStruct* st;
		ValaCCodeCastExpression* _tmp98_;
		ValaCCodeIdentifier* _tmp97_;
		char* _tmp96_;
		ValaCCodeCastExpression* _tmp101_;
		ValaCCodeIdentifier* _tmp100_;
		char* _tmp99_;
		st = VALA_STRUCT (vala_typeregister_function_get_type_declaration (self));
		_tmp98_ = NULL;
		_tmp97_ = NULL;
		_tmp96_ = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp98_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp97_ = vala_ccode_identifier_new (_tmp96_ = vala_typesymbol_get_dup_function ((ValaTypeSymbol*) st))), "GBoxedCopyFunc")));
		(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
		(_tmp97_ == NULL) ? NULL : (_tmp97_ = (vala_ccode_node_unref (_tmp97_), NULL));
		_tmp96_ = (g_free (_tmp96_), NULL);
		_tmp101_ = NULL;
		_tmp100_ = NULL;
		_tmp99_ = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp101_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp100_ = vala_ccode_identifier_new (_tmp99_ = vala_typesymbol_get_free_function ((ValaTypeSymbol*) st))), "GBoxedFreeFunc")));
		(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
		(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
		_tmp99_ = (g_free (_tmp99_), NULL);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		ValaCCodeIdentifier* _tmp102_;
		ValaCCodeConstant* _tmp105_;
		char* _tmp104_;
		_tmp102_ = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new ("&g_define_type_info")));
		(_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL));
		if (fundamental) {
			ValaCCodeIdentifier* _tmp103_;
			_tmp103_ = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp103_ = vala_ccode_identifier_new ("&g_define_type_fundamental_info")));
			(_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL));
		}
		_tmp105_ = NULL;
		_tmp104_ = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp105_ = vala_ccode_constant_new (_tmp104_ = vala_typeregister_function_get_type_flags (self))));
		(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
		_tmp104_ = (g_free (_tmp104_), NULL);
	}
	_tmp106_ = FALSE;
	if (use_thread_safe) {
		_tmp106_ = !plugin;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaCCodeDeclaration* temp_decl;
		ValaCCodeVariableDeclarator* _tmp107_;
		temp_decl = vala_ccode_declaration_new ("GType");
		_tmp107_ = NULL;
		vala_ccode_declaration_add_declarator (temp_decl, (ValaCCodeDeclarator*) (_tmp107_ = vala_ccode_variable_declarator_new (type_id_name, (ValaCCodeExpression*) reg_call, NULL)));
		(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL));
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) temp_decl);
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_ccode_node_unref (temp_decl), NULL));
	} else {
		ValaCCodeExpressionStatement* _tmp110_;
		ValaCCodeAssignment* _tmp109_;
		ValaCCodeIdentifier* _tmp108_;
		_tmp110_ = NULL;
		_tmp109_ = NULL;
		_tmp108_ = NULL;
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp110_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp109_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp108_ = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL));
		(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
		(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
	}
	_tmp111_ = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp111_ = vala_typeregister_function_get_type_interface_init_statements (self)));
	(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
	if (!plugin) {
		ValaCCodeExpression* condition;
		ValaCCodeIfStatement* cif;
		condition = NULL;
		/* the condition that guards the type initialisation*/
		if (use_thread_safe) {
			ValaCCodeIdentifier* _tmp112_;
			ValaCCodeFunctionCall* _tmp113_;
			ValaCCodeFunctionCall* enter;
			ValaCCodeUnaryExpression* _tmp116_;
			ValaCCodeIdentifier* _tmp115_;
			char* _tmp114_;
			ValaCCodeExpression* _tmp118_;
			ValaCCodeExpression* _tmp117_;
			ValaCCodeIdentifier* _tmp119_;
			ValaCCodeFunctionCall* _tmp120_;
			ValaCCodeFunctionCall* leave;
			ValaCCodeUnaryExpression* _tmp123_;
			ValaCCodeIdentifier* _tmp122_;
			char* _tmp121_;
			ValaCCodeIdentifier* _tmp124_;
			ValaCCodeExpressionStatement* _tmp125_;
			_tmp112_ = NULL;
			_tmp113_ = NULL;
			enter = (_tmp113_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp112_ = vala_ccode_identifier_new ("g_once_init_enter"))), (_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL)), _tmp113_);
			_tmp116_ = NULL;
			_tmp115_ = NULL;
			_tmp114_ = NULL;
			vala_ccode_function_call_add_argument (enter, (ValaCCodeExpression*) (_tmp116_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp115_ = vala_ccode_identifier_new (_tmp114_ = g_strconcat (type_id_name, "__volatile", NULL))))));
			(_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL));
			(_tmp115_ == NULL) ? NULL : (_tmp115_ = (vala_ccode_node_unref (_tmp115_), NULL));
			_tmp114_ = (g_free (_tmp114_), NULL);
			_tmp118_ = NULL;
			_tmp117_ = NULL;
			condition = (_tmp118_ = (_tmp117_ = (ValaCCodeExpression*) enter, (_tmp117_ == NULL) ? NULL : vala_ccode_node_ref (_tmp117_)), (condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)), _tmp118_);
			_tmp119_ = NULL;
			_tmp120_ = NULL;
			leave = (_tmp120_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp119_ = vala_ccode_identifier_new ("g_once_init_leave"))), (_tmp119_ == NULL) ? NULL : (_tmp119_ = (vala_ccode_node_unref (_tmp119_), NULL)), _tmp120_);
			_tmp123_ = NULL;
			_tmp122_ = NULL;
			_tmp121_ = NULL;
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp123_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp122_ = vala_ccode_identifier_new (_tmp121_ = g_strconcat (type_id_name, "__volatile", NULL))))));
			(_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL));
			(_tmp122_ == NULL) ? NULL : (_tmp122_ = (vala_ccode_node_unref (_tmp122_), NULL));
			_tmp121_ = (g_free (_tmp121_), NULL);
			_tmp124_ = NULL;
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp124_ = vala_ccode_identifier_new (type_id_name)));
			(_tmp124_ == NULL) ? NULL : (_tmp124_ = (vala_ccode_node_unref (_tmp124_), NULL));
			_tmp125_ = NULL;
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp125_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) leave)));
			(_tmp125_ == NULL) ? NULL : (_tmp125_ = (vala_ccode_node_unref (_tmp125_), NULL));
			(enter == NULL) ? NULL : (enter = (vala_ccode_node_unref (enter), NULL));
			(leave == NULL) ? NULL : (leave = (vala_ccode_node_unref (leave), NULL));
		} else {
			ValaCCodeIdentifier* id;
			ValaCCodeConstant* zero;
			ValaCCodeExpression* _tmp126_;
			id = vala_ccode_identifier_new (type_id_name);
			zero = vala_ccode_constant_new ("0");
			_tmp126_ = NULL;
			condition = (_tmp126_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) id, (ValaCCodeExpression*) zero), (condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)), _tmp126_);
			(id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL));
			(zero == NULL) ? NULL : (zero = (vala_ccode_node_unref (zero), NULL));
		}
		cif = vala_ccode_if_statement_new (condition, (ValaCCodeStatement*) type_init, NULL);
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) cif);
		(condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL));
		(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	} else {
		ValaCCodeBlock* _tmp128_;
		ValaCCodeBlock* _tmp127_;
		_tmp128_ = NULL;
		_tmp127_ = NULL;
		type_block = (_tmp128_ = (_tmp127_ = type_init, (_tmp127_ == NULL) ? NULL : vala_ccode_node_ref (_tmp127_)), (type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL)), _tmp128_);
	}
	if (use_thread_safe) {
		ValaCCodeReturnStatement* _tmp131_;
		ValaCCodeIdentifier* _tmp130_;
		char* _tmp129_;
		_tmp131_ = NULL;
		_tmp130_ = NULL;
		_tmp129_ = NULL;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp131_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp130_ = vala_ccode_identifier_new (_tmp129_ = g_strconcat (type_id_name, "__volatile", NULL))))));
		(_tmp131_ == NULL) ? NULL : (_tmp131_ = (vala_ccode_node_unref (_tmp131_), NULL));
		(_tmp130_ == NULL) ? NULL : (_tmp130_ = (vala_ccode_node_unref (_tmp130_), NULL));
		_tmp129_ = (g_free (_tmp129_), NULL);
	} else {
		ValaCCodeReturnStatement* _tmp133_;
		ValaCCodeIdentifier* _tmp132_;
		_tmp133_ = NULL;
		_tmp132_ = NULL;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp133_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp132_ = vala_ccode_identifier_new (type_id_name)))));
		(_tmp133_ == NULL) ? NULL : (_tmp133_ = (vala_ccode_node_unref (_tmp133_), NULL));
		(_tmp132_ == NULL) ? NULL : (_tmp132_ = (vala_ccode_node_unref (_tmp132_), NULL));
	}
	_tmp134_ = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp134_ = vala_ccode_function_copy (fun)));
	(_tmp134_ == NULL) ? NULL : (_tmp134_ = (vala_ccode_node_unref (_tmp134_), NULL));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) fun);
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	type_id_name = (g_free (type_id_name), NULL);
	(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL);
	(type_init == NULL) ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL));
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
}


static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_declaration'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the data type to be registered.
 *
 * @return type to be registered
 */
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


/**
 * Returns the name of the type struct in C code.
 *
 * @return C struct name
 */
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


/**
 * Returns the name of the base_init function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


/**
 * Returns the name of the class_finalize function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_class_finalize_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_finalize_func_name (self);
}


/**
 * Returns the name of the base_finalize function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_base_finalize_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_finalize_func_name (self);
}


/**
 * Returns the name of the class_init function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


/**
 * Returns the size of the instance struct in C code.
 *
 * @return C instance struct size
 */
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


/**
 * Returns the name of the instance_init function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


/**
 * Returns the name of the parent type in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable init function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_init_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable peek pointer function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_peek_pointer_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable free function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_free_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable copy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_copy_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable lcopy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_lcopy_value_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable collect value function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_collect_value_function_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup ("0");
	return result;
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = vala_ccode_fragment_new ();
	return result;
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_interface_init_statements'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns additional C initialization statements to setup interfaces.
 *
 * @return C statements
 */
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


ValaCCodeFragment* vala_typeregister_function_get_source_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	ValaCCodeFragment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->source_declaration_fragment, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	return result;
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	ValaCCodeFragment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->declaration_fragment, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	return result;
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	ValaCCodeFragment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->definition_fragment, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	return result;
}


static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_accessibility'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


/**
 * Returns the accessibility for this type.
 */
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_context = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_context_ref (_tmp0_)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp1_);
}


static void vala_value_typeregister_function_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_typeregister_function_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_typeregister_function_unref (value->data[0].v_pointer);
	}
}


static void vala_value_typeregister_function_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_typeregister_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_typeregister_function_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_typeregister_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaTypeRegisterFunction* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_typeregister_function_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_typeregister_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaTypeRegisterFunction** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_typeregister_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecTypeRegisterFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_typeregister_function (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_typeregister_function (GValue* value, gpointer v_object) {
	ValaTypeRegisterFunction* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TYPEREGISTER_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_typeregister_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_typeregister_function_unref (old);
	}
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_typeregister_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_typeregister_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_typeregister_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_typeregister_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_finalize_func_name = vala_typeregister_function_real_get_class_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_finalize_func_name = vala_typeregister_function_real_get_base_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_typeregister_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_typeregister_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_typeregister_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_typeregister_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_typeregister_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_typeregister_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_typeregister_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_typeregister_function_real_get_type_interface_init_statements;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_typeregister_function_real_get_accessibility;
}


static void vala_typeregister_function_instance_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->source_declaration_fragment = vala_ccode_fragment_new ();
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
	self->ref_count = 1;
}


static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	(self->priv->source_declaration_fragment == NULL) ? NULL : (self->priv->source_declaration_fragment = (vala_ccode_node_unref (self->priv->source_declaration_fragment), NULL));
	(self->priv->declaration_fragment == NULL) ? NULL : (self->priv->declaration_fragment = (vala_ccode_node_unref (self->priv->declaration_fragment), NULL));
	(self->priv->definition_fragment == NULL) ? NULL : (self->priv->definition_fragment = (vala_ccode_node_unref (self->priv->definition_fragment), NULL));
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (vala_typeregister_function_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_typeregister_function_init, vala_value_typeregister_function_free_value, vala_value_typeregister_function_copy_value, vala_value_typeregister_function_peek_pointer, "p", vala_value_typeregister_function_collect_value, "p", vala_value_typeregister_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_typeregister_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTypeRegisterFunction", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}


gpointer vala_typeregister_function_ref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_typeregister_function_unref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




