/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;
typedef struct _ValaMemberAccessPrivate ValaMemberAccessPrivate;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_LOOP (vala_loop_get_type ())
#define VALA_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOOP, ValaLoop))
#define VALA_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOOP, ValaLoopClass))
#define VALA_IS_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOOP))
#define VALA_IS_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOOP))
#define VALA_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOOP, ValaLoopClass))

typedef struct _ValaLoop ValaLoop;
typedef struct _ValaLoopClass ValaLoopClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_DYNAMIC_METHOD (vala_dynamic_method_get_type ())
#define VALA_DYNAMIC_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod))
#define VALA_DYNAMIC_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethodClass))
#define VALA_IS_DYNAMIC_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DYNAMIC_METHOD))
#define VALA_IS_DYNAMIC_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DYNAMIC_METHOD))
#define VALA_DYNAMIC_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethodClass))

typedef struct _ValaDynamicMethod ValaDynamicMethod;
typedef struct _ValaDynamicMethodClass ValaDynamicMethodClass;

#define VALA_TYPE_ERROR_TYPE (vala_error_type_get_type ())
#define VALA_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorType))
#define VALA_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))
#define VALA_IS_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_TYPE))
#define VALA_IS_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_TYPE))
#define VALA_ERROR_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))

typedef struct _ValaErrorType ValaErrorType;
typedef struct _ValaErrorTypeClass ValaErrorTypeClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_ASSIGNMENT_OPERATOR (vala_assignment_operator_get_type ())

#define VALA_TYPE_DYNAMIC_SIGNAL (vala_dynamic_signal_get_type ())
#define VALA_DYNAMIC_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal))
#define VALA_DYNAMIC_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignalClass))
#define VALA_IS_DYNAMIC_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DYNAMIC_SIGNAL))
#define VALA_IS_DYNAMIC_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DYNAMIC_SIGNAL))
#define VALA_DYNAMIC_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignalClass))

typedef struct _ValaDynamicSignal ValaDynamicSignal;
typedef struct _ValaDynamicSignalClass ValaDynamicSignalClass;

#define VALA_TYPE_DYNAMIC_PROPERTY (vala_dynamic_property_get_type ())
#define VALA_DYNAMIC_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicProperty))
#define VALA_DYNAMIC_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicPropertyClass))
#define VALA_IS_DYNAMIC_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DYNAMIC_PROPERTY))
#define VALA_IS_DYNAMIC_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DYNAMIC_PROPERTY))
#define VALA_DYNAMIC_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicPropertyClass))

typedef struct _ValaDynamicProperty ValaDynamicProperty;
typedef struct _ValaDynamicPropertyClass ValaDynamicPropertyClass;

#define VALA_TYPE_FIELD_PROTOTYPE (vala_field_prototype_get_type ())
#define VALA_FIELD_PROTOTYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototype))
#define VALA_FIELD_PROTOTYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypeClass))
#define VALA_IS_FIELD_PROTOTYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD_PROTOTYPE))
#define VALA_IS_FIELD_PROTOTYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD_PROTOTYPE))
#define VALA_FIELD_PROTOTYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypeClass))

typedef struct _ValaFieldPrototype ValaFieldPrototype;
typedef struct _ValaFieldPrototypeClass ValaFieldPrototypeClass;

#define VALA_TYPE_INVALID_TYPE (vala_invalid_type_get_type ())
#define VALA_INVALID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INVALID_TYPE, ValaInvalidType))
#define VALA_INVALID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INVALID_TYPE, ValaInvalidTypeClass))
#define VALA_IS_INVALID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INVALID_TYPE))
#define VALA_IS_INVALID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INVALID_TYPE))
#define VALA_INVALID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INVALID_TYPE, ValaInvalidTypeClass))

typedef struct _ValaInvalidType ValaInvalidType;
typedef struct _ValaInvalidTypeClass ValaInvalidTypeClass;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * Base class for all code nodes that might be used as an expression.
 */
struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
	GeeArrayList* temp_vars;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
};

/**
 * Represents an access to a type member in the source code.
 */
struct _ValaMemberAccess {
	ValaExpression parent_instance;
	ValaMemberAccessPrivate * priv;
};

struct _ValaMemberAccessClass {
	ValaExpressionClass parent_class;
};

struct _ValaMemberAccessPrivate {
	char* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	GeeList* type_argument_list;
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCodeVisitor* self, ValaLoop* stmt);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	VALA_ASSIGNMENT_OPERATOR_NONE,
	VALA_ASSIGNMENT_OPERATOR_SIMPLE,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_OR,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_AND,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR,
	VALA_ASSIGNMENT_OPERATOR_ADD,
	VALA_ASSIGNMENT_OPERATOR_SUB,
	VALA_ASSIGNMENT_OPERATOR_MUL,
	VALA_ASSIGNMENT_OPERATOR_DIV,
	VALA_ASSIGNMENT_OPERATOR_PERCENT,
	VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT,
	VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT
} ValaAssignmentOperator;


static gpointer vala_member_access_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_member_access_get_type (void);
#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
enum  {
	VALA_MEMBER_ACCESS_DUMMY_PROPERTY
};
void vala_member_access_set_inner (ValaMemberAccess* self, ValaExpression* value);
void vala_member_access_set_member_name (ValaMemberAccess* self, const char* value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaMemberAccess* vala_member_access_new (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct (GType object_type, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_new (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_new_simple (const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct_simple (GType object_type, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_new_simple (const char* member_name, ValaSourceReference* source_reference);
void vala_member_access_set_pointer_member_access (ValaMemberAccess* self, gboolean value);
ValaMemberAccess* vala_member_access_new_pointer (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct_pointer (GType object_type, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_new_pointer (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_member_access_add_type_argument (ValaMemberAccess* self, ValaDataType* arg);
GeeList* vala_member_access_get_type_arguments (ValaMemberAccess* self);
void vala_code_visitor_visit_member_access (ValaCodeVisitor* self, ValaMemberAccess* expr);
void vala_code_visitor_visit_expression (ValaCodeVisitor* self, ValaExpression* expr);
static void vala_member_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaExpression* vala_member_access_get_inner (ValaMemberAccess* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
GType vala_member_get_type (void);
GType vala_field_get_type (void);
GType member_binding_get_type (void);
MemberBinding vala_field_get_binding (ValaField* self);
GType vala_method_get_type (void);
GType vala_creation_method_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_property_get_type (void);
MemberBinding vala_property_get_binding (ValaProperty* self);
GType vala_enum_value_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_error_code_get_type (void);
const char* vala_member_access_get_member_name (ValaMemberAccess* self);
char* vala_code_node_to_string (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
static char* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
gboolean vala_expression_is_pure (ValaExpression* self);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static void vala_member_access_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GType vala_constant_get_type (void);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
ValaDataType* vala_constant_get_type_reference (ValaConstant* self);
gboolean vala_data_type_get_nullable (ValaDataType* self);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
GType vala_formal_parameter_get_type (void);
void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value);
gboolean vala_member_access_get_qualified (ValaMemberAccess* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
GType vala_namespace_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
GType vala_struct_get_type (void);
GType vala_interface_get_type (void);
GType vala_enum_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_delegate_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_signal_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_loop_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
gboolean vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaFormalParameter* vala_constructor_get_this_parameter (ValaConstructor* self);
ValaFormalParameter* vala_destructor_get_this_parameter (ValaDestructor* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
GeeList* vala_source_file_get_using_directives (ValaSourceFile* self);
ValaSymbol* vala_using_directive_get_namespace_symbol (ValaUsingDirective* self);
gboolean vala_member_access_get_pointer_member_access (ValaMemberAccess* self);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GType vala_pointer_type_get_type (void);
ValaDataType* vala_pointer_type_get_base_type (ValaPointerType* self);
GType vala_value_type_get_type (void);
ValaPointerIndirection* vala_pointer_indirection_new (ValaExpression* inner, ValaSourceReference* source_reference);
ValaPointerIndirection* vala_pointer_indirection_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference);
gboolean vala_member_access_get_prototype_access (ValaMemberAccess* self);
ValaSymbol* vala_data_type_get_pointer_member (ValaDataType* self, const char* member_name);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
ValaSymbol* vala_data_type_get_member (ValaDataType* self, const char* member_name);
gboolean vala_data_type_get_is_dynamic (ValaDataType* self);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
ValaExpression* vala_method_call_get_call (ValaMethodCall* self);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
ValaVoidType* vala_void_type_new (ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_void_type_get_type (void);
ValaDynamicMethod* vala_dynamic_method_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDynamicMethod* vala_dynamic_method_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
GType vala_dynamic_method_get_type (void);
void vala_dynamic_method_set_invocation (ValaDynamicMethod* self, ValaMethodCall* value);
void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type);
ValaErrorType* vala_error_type_new (ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
ValaErrorType* vala_error_type_construct (GType object_type, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
GType vala_error_type_get_type (void);
GType vala_symbol_accessibility_get_type (void);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
ValaFormalParameter* vala_formal_parameter_new_with_ellipsis (ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference);
ValaObjectTypeSymbol* vala_object_type_get_type_symbol (ValaObjectType* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
ValaExpression* vala_assignment_get_left (ValaAssignment* self);
GType vala_assignment_operator_get_type (void);
ValaAssignmentOperator vala_assignment_get_operator (ValaAssignment* self);
ValaDynamicSignal* vala_dynamic_signal_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDynamicSignal* vala_dynamic_signal_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
GType vala_dynamic_signal_get_type (void);
ValaExpression* vala_assignment_get_right (ValaAssignment* self);
void vala_dynamic_signal_set_handler (ValaDynamicSignal* self, ValaExpression* value);
ValaDynamicProperty* vala_dynamic_property_new (ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference);
ValaDynamicProperty* vala_dynamic_property_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference);
GType vala_dynamic_property_get_type (void);
ValaPropertyAccessor* vala_property_accessor_new (gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference);
ValaPropertyAccessor* vala_property_accessor_construct (GType object_type, gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_accessor_set_access (ValaPropertyAccessor* self, ValaSymbolAccessibility value);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
void vala_property_set_property_type (ValaProperty* self, ValaDataType* value);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
ValaMethod* vala_method_get_base_method (ValaMethod* self);
ValaSignal* vala_method_get_signal_reference (ValaMethod* self);
ValaMethod* vala_method_get_base_interface_method (ValaMethod* self);
ValaProperty* vala_property_get_base_property (ValaProperty* self);
ValaProperty* vala_property_get_base_interface_property (ValaProperty* self);
gboolean vala_expression_get_lvalue (ValaExpression* self);
ValaSymbolAccessibility vala_property_accessor_get_access (ValaPropertyAccessor* self);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
void vala_member_access_set_prototype_access (ValaMemberAccess* self, gboolean value);
ValaDataType* vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self, ValaSymbol* sym, gboolean lvalue);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
ValaFieldPrototype* vala_field_prototype_new (ValaField* field_symbol);
ValaFieldPrototype* vala_field_prototype_construct (GType object_type, ValaField* field_symbol);
GType vala_field_prototype_get_type (void);
ValaInvalidType* vala_invalid_type_new (void);
ValaInvalidType* vala_invalid_type_construct (GType object_type);
GType vala_invalid_type_get_type (void);
ValaDataType* vala_formal_parameter_get_parameter_type (ValaFormalParameter* self);
void vala_expression_set_formal_value_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_formal_value_type (ValaExpression* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
static gboolean vala_member_access_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_get_defined_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
void vala_code_node_get_used_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
gboolean vala_member_access_get_creation_member (ValaMemberAccess* self);
void vala_member_access_set_creation_member (ValaMemberAccess* self, gboolean value);
void vala_member_access_set_qualified (ValaMemberAccess* self, gboolean value);
static void vala_member_access_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess* vala_member_access_construct (GType object_type, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference) {
	ValaMemberAccess* self;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) g_type_create_instance (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess* vala_member_access_new (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference) {
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess* vala_member_access_construct_simple (GType object_type, const char* member_name, ValaSourceReference* source_reference) {
	ValaMemberAccess* self;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) g_type_create_instance (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess* vala_member_access_new_simple (const char* member_name, ValaSourceReference* source_reference) {
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess* vala_member_access_construct_pointer (GType object_type, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference) {
	ValaMemberAccess* self;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) g_type_create_instance (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess* vala_member_access_new_pointer (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference) {
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void vala_member_access_add_type_argument (ValaMemberAccess* self, ValaDataType* arg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	gee_collection_add ((GeeCollection*) self->priv->type_argument_list, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
GeeList* vala_member_access_get_type_arguments (ValaMemberAccess* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->type_argument_list);
	return result;
}


static void vala_member_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void vala_member_access_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_member_access_get_inner (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_member_access_get_inner (self), visitor);
	}
	{
		GeeIterator* _type_arg_it;
		_type_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_argument_list);
		while (TRUE) {
			ValaDataType* type_arg;
			if (!gee_iterator_next (_type_arg_it)) {
				break;
			}
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			vala_code_node_accept ((ValaCodeNode*) type_arg, visitor);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
}


static char* vala_member_access_real_to_string (ValaCodeNode* base) {
	ValaMemberAccess * self;
	char* result;
	gboolean instance;
	self = (ValaMemberAccess*) base;
	instance = TRUE;
	if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
		ValaField* _tmp0_;
		ValaField* f;
		_tmp0_ = NULL;
		f = (_tmp0_ = VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		instance = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
		(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
			ValaMethod* _tmp1_;
			ValaMethod* m;
			_tmp1_ = NULL;
			m = (_tmp1_ = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
			if (!VALA_IS_CREATION_METHOD (m)) {
				instance = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		} else {
			if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
				ValaProperty* _tmp2_;
				ValaProperty* prop;
				_tmp2_ = NULL;
				prop = (_tmp2_ = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
				instance = vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE;
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			} else {
				if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
					instance = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
						instance = FALSE;
					}
				}
			}
		}
	}
	if (instance) {
		if (vala_member_access_get_inner (self) == NULL) {
			const char* _tmp3_;
			_tmp3_ = NULL;
			result = (_tmp3_ = self->priv->_member_name, (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
			return result;
		} else {
			char* _tmp4_;
			char* _tmp5_;
			_tmp4_ = NULL;
			_tmp5_ = NULL;
			result = (_tmp5_ = g_strdup_printf ("%s.%s", _tmp4_ = vala_code_node_to_string ((ValaCodeNode*) vala_member_access_get_inner (self)), self->priv->_member_name), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
			return result;
		}
	} else {
		/* ensure to always use fully-qualified name
		 to refer to static members*/
		result = vala_symbol_get_full_name (vala_expression_get_symbol_reference ((ValaExpression*) self));
		return result;
	}
}


static void vala_member_access_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_member_access_get_inner (self) == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean vala_member_access_real_is_pure (ValaExpression* base) {
	ValaMemberAccess * self;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	if (vala_member_access_get_inner (self) == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_expression_is_pure (vala_member_access_get_inner (self));
	}
	if (_tmp1_) {
		_tmp0_ = !VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) self));
	} else {
		_tmp0_ = FALSE;
	}
	/* accessing property could have side-effects*/
	result = _tmp0_;
	return result;
}


static void vala_member_access_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < gee_collection_get_size ((GeeCollection*) self->priv->type_argument_list))) {
					break;
				}
				_tmp1_ = NULL;
				if ((_tmp2_ = (_tmp1_ = (ValaDataType*) gee_list_get (self->priv->type_argument_list, i)) == old_type, (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL)), _tmp2_)) {
					gee_list_set (self->priv->type_argument_list, i, new_type);
					return;
				}
			}
		}
	}
}


static gboolean vala_member_access_real_is_constant (ValaExpression* base) {
	ValaMemberAccess * self;
	gboolean result;
	self = (ValaMemberAccess*) base;
	if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean vala_member_access_real_is_non_null (ValaExpression* base) {
	ValaMemberAccess * self;
	gboolean result;
	ValaConstant* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaConstant* c;
	self = (ValaMemberAccess*) base;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	c = (_tmp1_ = (_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self), VALA_IS_CONSTANT (_tmp0_) ? ((ValaConstant*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (c != NULL) {
		result = !vala_data_type_get_nullable (vala_constant_get_type_reference (c));
		(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
		return result;
	} else {
		result = FALSE;
		(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
		return result;
	}
	(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
}


static gboolean vala_member_access_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaMemberAccess * self;
	gboolean result;
	ValaSymbol* base_symbol;
	ValaFormalParameter* this_parameter;
	gboolean may_access_instance_members;
	ValaSymbol* _tmp70_;
	ValaSymbol* member;
	ValaSymbolAccessibility access;
	gboolean instance;
	gboolean klass;
	gboolean _tmp103_;
	gboolean _tmp104_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (vala_member_access_get_inner (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_member_access_get_inner (self), analyzer);
	}
	{
		GeeIterator* _type_arg_it;
		_type_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_argument_list);
		while (TRUE) {
			ValaDataType* type_arg;
			if (!gee_iterator_next (_type_arg_it)) {
				break;
			}
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			vala_code_node_check ((ValaCodeNode*) type_arg, analyzer);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	if (self->priv->_qualified) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp2_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		base_symbol = (_tmp1_ = (_tmp0_ = analyzer->root_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)), _tmp1_);
		_tmp2_ = NULL;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp2_ = vala_scope_lookup (vala_symbol_get_scope (analyzer->root_symbol), self->priv->_member_name));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
	} else {
		if (vala_member_access_get_inner (self) == NULL) {
			ValaSymbol* _tmp4_;
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp5_;
			ValaSymbol* sym;
			if (_vala_strcmp0 (self->priv->_member_name, "this") == 0) {
				if (!vala_semantic_analyzer_is_in_instance_method (analyzer)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "This access invalid outside of instance methods");
					result = FALSE;
					(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
					(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
					return result;
				}
			}
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			base_symbol = (_tmp4_ = (_tmp3_ = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)), _tmp4_);
			_tmp5_ = NULL;
			sym = (_tmp5_ = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
			while (TRUE) {
				gboolean _tmp6_;
				ValaSymbol* _tmp22_;
				ValaSymbol* _tmp24_;
				ValaSymbol* _tmp23_;
				_tmp6_ = FALSE;
				if (sym != NULL) {
					_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (!_tmp6_) {
					break;
				}
				if (this_parameter == NULL) {
					if (VALA_IS_CREATION_METHOD (sym)) {
						ValaCreationMethod* _tmp7_;
						ValaCreationMethod* cm;
						ValaFormalParameter* _tmp9_;
						ValaFormalParameter* _tmp8_;
						_tmp7_ = NULL;
						cm = (_tmp7_ = VALA_CREATION_METHOD (sym), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
						_tmp9_ = NULL;
						_tmp8_ = NULL;
						this_parameter = (_tmp9_ = (_tmp8_ = vala_method_get_this_parameter ((ValaMethod*) cm), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_)), (this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)), _tmp9_);
						may_access_instance_members = TRUE;
						(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
					} else {
						if (VALA_IS_PROPERTY (sym)) {
							ValaProperty* _tmp10_;
							ValaProperty* prop;
							ValaFormalParameter* _tmp12_;
							ValaFormalParameter* _tmp11_;
							_tmp10_ = NULL;
							prop = (_tmp10_ = VALA_PROPERTY (sym), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
							_tmp12_ = NULL;
							_tmp11_ = NULL;
							this_parameter = (_tmp12_ = (_tmp11_ = vala_property_get_this_parameter (prop), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_)), (this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)), _tmp12_);
							may_access_instance_members = TRUE;
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						} else {
							if (VALA_IS_CONSTRUCTOR (sym)) {
								ValaConstructor* _tmp13_;
								ValaConstructor* c;
								ValaFormalParameter* _tmp15_;
								ValaFormalParameter* _tmp14_;
								_tmp13_ = NULL;
								c = (_tmp13_ = VALA_CONSTRUCTOR (sym), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
								_tmp15_ = NULL;
								_tmp14_ = NULL;
								this_parameter = (_tmp15_ = (_tmp14_ = vala_constructor_get_this_parameter (c), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_)), (this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)), _tmp15_);
								may_access_instance_members = TRUE;
								(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
							} else {
								if (VALA_IS_DESTRUCTOR (sym)) {
									ValaDestructor* _tmp16_;
									ValaDestructor* d;
									ValaFormalParameter* _tmp18_;
									ValaFormalParameter* _tmp17_;
									_tmp16_ = NULL;
									d = (_tmp16_ = VALA_DESTRUCTOR (sym), (_tmp16_ == NULL) ? NULL : vala_code_node_ref (_tmp16_));
									_tmp18_ = NULL;
									_tmp17_ = NULL;
									this_parameter = (_tmp18_ = (_tmp17_ = vala_destructor_get_this_parameter (d), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_)), (this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)), _tmp18_);
									may_access_instance_members = TRUE;
									(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
								} else {
									if (VALA_IS_METHOD (sym)) {
										ValaMethod* _tmp19_;
										ValaMethod* m;
										ValaFormalParameter* _tmp21_;
										ValaFormalParameter* _tmp20_;
										_tmp19_ = NULL;
										m = (_tmp19_ = VALA_METHOD (sym), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
										_tmp21_ = NULL;
										_tmp20_ = NULL;
										this_parameter = (_tmp21_ = (_tmp20_ = vala_method_get_this_parameter (m), (_tmp20_ == NULL) ? NULL : vala_code_node_ref (_tmp20_)), (this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)), _tmp21_);
										may_access_instance_members = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
										(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
									}
								}
							}
						}
					}
				}
				_tmp22_ = NULL;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp22_ = vala_semantic_analyzer_symbol_lookup_inherited (sym, self->priv->_member_name));
				(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_code_node_unref (_tmp22_), NULL));
				_tmp24_ = NULL;
				_tmp23_ = NULL;
				sym = (_tmp24_ = (_tmp23_ = vala_symbol_get_parent_symbol (sym), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp24_);
			}
			if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
				{
					GeeList* _tmp25_;
					GeeIterator* _tmp26_;
					GeeIterator* _ns_it;
					_tmp25_ = NULL;
					_tmp26_ = NULL;
					_ns_it = (_tmp26_ = gee_iterable_iterator ((GeeIterable*) (_tmp25_ = vala_source_file_get_using_directives (vala_semantic_analyzer_get_current_source_file (analyzer)))), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (gee_collection_object_unref (_tmp25_), NULL)), _tmp26_);
					while (TRUE) {
						ValaUsingDirective* ns;
						ValaSymbol* local_sym;
						if (!gee_iterator_next (_ns_it)) {
							break;
						}
						ns = (ValaUsingDirective*) gee_iterator_get (_ns_it);
						local_sym = vala_scope_lookup (vala_symbol_get_scope (vala_using_directive_get_namespace_symbol (ns)), self->priv->_member_name);
						if (local_sym != NULL) {
							if (vala_expression_get_symbol_reference ((ValaExpression*) self) != NULL) {
								char* _tmp29_;
								char* _tmp28_;
								char* _tmp27_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp29_ = NULL;
								_tmp28_ = NULL;
								_tmp27_ = NULL;
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp29_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", self->priv->_member_name, _tmp27_ = vala_symbol_get_full_name (vala_expression_get_symbol_reference ((ValaExpression*) self)), _tmp28_ = vala_symbol_get_full_name (local_sym)));
								_tmp29_ = (g_free (_tmp29_), NULL);
								_tmp28_ = (g_free (_tmp28_), NULL);
								_tmp27_ = (g_free (_tmp27_), NULL);
								result = FALSE;
								(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
								(local_sym == NULL) ? NULL : (local_sym = (vala_code_node_unref (local_sym), NULL));
								(_ns_it == NULL) ? NULL : (_ns_it = (gee_collection_object_unref (_ns_it), NULL));
								(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
								(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
								(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
								return result;
							}
							vala_expression_set_symbol_reference ((ValaExpression*) self, local_sym);
						}
						(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
						(local_sym == NULL) ? NULL : (local_sym = (vala_code_node_unref (local_sym), NULL));
					}
					(_ns_it == NULL) ? NULL : (_ns_it = (gee_collection_object_unref (_ns_it), NULL));
				}
			}
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
		} else {
			gboolean _tmp37_;
			gboolean _tmp43_;
			gboolean _tmp48_;
			gboolean _tmp49_;
			if (vala_code_node_get_error ((ValaCodeNode*) vala_member_access_get_inner (self))) {
				/* if there was an error in the inner expression, skip this check */
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
				(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
				return result;
			}
			if (self->priv->_pointer_member_access) {
				ValaPointerType* _tmp31_;
				ValaDataType* _tmp30_;
				ValaPointerType* pointer_type;
				gboolean _tmp32_;
				_tmp31_ = NULL;
				_tmp30_ = NULL;
				pointer_type = (_tmp31_ = (_tmp30_ = vala_expression_get_value_type (vala_member_access_get_inner (self)), VALA_IS_POINTER_TYPE (_tmp30_) ? ((ValaPointerType*) _tmp30_) : NULL), (_tmp31_ == NULL) ? NULL : vala_code_node_ref (_tmp31_));
				_tmp32_ = FALSE;
				if (pointer_type != NULL) {
					_tmp32_ = VALA_IS_VALUE_TYPE (vala_pointer_type_get_base_type (pointer_type));
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					ValaPointerIndirection* _tmp33_;
					/* transform foo->bar to (*foo).bar*/
					_tmp33_ = NULL;
					vala_member_access_set_inner (self, (ValaExpression*) (_tmp33_ = vala_pointer_indirection_new (vala_member_access_get_inner (self), vala_code_node_get_source_reference ((ValaCodeNode*) self))));
					(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_code_node_unref (_tmp33_), NULL));
					vala_code_node_check ((ValaCodeNode*) vala_member_access_get_inner (self), analyzer);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
			}
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (self))) {
				ValaMemberAccess* _tmp34_;
				ValaMemberAccess* ma;
				_tmp34_ = NULL;
				ma = (_tmp34_ = VALA_MEMBER_ACCESS (vala_member_access_get_inner (self)), (_tmp34_ == NULL) ? NULL : vala_code_node_ref (_tmp34_));
				if (ma->priv->_prototype_access) {
					char* _tmp36_;
					char* _tmp35_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = NULL;
					_tmp35_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp36_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp35_ = vala_symbol_get_full_name (vala_expression_get_symbol_reference (vala_member_access_get_inner (self)))));
					_tmp36_ = (g_free (_tmp36_), NULL);
					_tmp35_ = (g_free (_tmp35_), NULL);
					result = FALSE;
					(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
					(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
					(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
					return result;
				}
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			_tmp37_ = FALSE;
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (self))) {
				_tmp37_ = TRUE;
			} else {
				_tmp37_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (self));
			}
			if (_tmp37_) {
				ValaSymbol* _tmp39_;
				ValaSymbol* _tmp38_;
				gboolean _tmp40_;
				_tmp39_ = NULL;
				_tmp38_ = NULL;
				base_symbol = (_tmp39_ = (_tmp38_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (self)), (_tmp38_ == NULL) ? NULL : vala_code_node_ref (_tmp38_)), (base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)), _tmp39_);
				_tmp40_ = FALSE;
				if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
					gboolean _tmp41_;
					_tmp41_ = FALSE;
					if (VALA_IS_NAMESPACE (base_symbol)) {
						_tmp41_ = TRUE;
					} else {
						_tmp41_ = VALA_IS_TYPESYMBOL (base_symbol);
					}
					_tmp40_ = _tmp41_;
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					ValaSymbol* _tmp42_;
					_tmp42_ = NULL;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp42_ = vala_scope_lookup (vala_symbol_get_scope (base_symbol), self->priv->_member_name));
					(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_code_node_unref (_tmp42_), NULL));
					if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (self))) {
						/* inner expression is base access
						 access to instance members of the base type possible*/
						may_access_instance_members = TRUE;
					}
				}
			}
			_tmp43_ = FALSE;
			if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
				_tmp43_ = vala_expression_get_value_type (vala_member_access_get_inner (self)) != NULL;
			} else {
				_tmp43_ = FALSE;
			}
			if (_tmp43_) {
				if (self->priv->_pointer_member_access) {
					ValaSymbol* _tmp44_;
					_tmp44_ = NULL;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp44_ = vala_data_type_get_pointer_member (vala_expression_get_value_type (vala_member_access_get_inner (self)), self->priv->_member_name));
					(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_code_node_unref (_tmp44_), NULL));
				} else {
					ValaSymbol* _tmp47_;
					if (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (self))) != NULL) {
						ValaSymbol* _tmp46_;
						ValaSymbol* _tmp45_;
						_tmp46_ = NULL;
						_tmp45_ = NULL;
						base_symbol = (_tmp46_ = (_tmp45_ = (ValaSymbol*) vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (self))), (_tmp45_ == NULL) ? NULL : vala_code_node_ref (_tmp45_)), (base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)), _tmp46_);
					}
					_tmp47_ = NULL;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp47_ = vala_data_type_get_member (vala_expression_get_value_type (vala_member_access_get_inner (self)), self->priv->_member_name));
					(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_code_node_unref (_tmp47_), NULL));
				}
				if (vala_expression_get_symbol_reference ((ValaExpression*) self) != NULL) {
					/* inner expression is variable, field, or parameter
					 access to instance members of the corresponding type possible*/
					may_access_instance_members = TRUE;
				}
			}
			_tmp48_ = FALSE;
			_tmp49_ = FALSE;
			if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
				_tmp49_ = vala_expression_get_value_type (vala_member_access_get_inner (self)) != NULL;
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				_tmp48_ = vala_data_type_get_is_dynamic (vala_expression_get_value_type (vala_member_access_get_inner (self)));
			} else {
				_tmp48_ = FALSE;
			}
			if (_tmp48_) {
				ValaObjectType* _tmp50_;
				ValaObjectType* dynamic_object_type;
				/* allow late bound members for dynamic types*/
				_tmp50_ = NULL;
				dynamic_object_type = (_tmp50_ = VALA_OBJECT_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (self))), (_tmp50_ == NULL) ? NULL : vala_code_node_ref (_tmp50_));
				if (VALA_IS_METHOD_CALL (vala_code_node_get_parent_node ((ValaCodeNode*) self))) {
					ValaMethodCall* _tmp51_;
					ValaMethodCall* invoc;
					_tmp51_ = NULL;
					invoc = (_tmp51_ = VALA_METHOD_CALL (vala_code_node_get_parent_node ((ValaCodeNode*) self)), (_tmp51_ == NULL) ? NULL : vala_code_node_ref (_tmp51_));
					if (vala_method_call_get_call (invoc) == VALA_EXPRESSION (self)) {
						ValaDataType* ret_type;
						ValaDynamicMethod* m;
						ValaErrorType* _tmp55_;
						ValaFormalParameter* _tmp56_;
						/* dynamic method*/
						ret_type = NULL;
						if (vala_expression_get_target_type ((ValaExpression*) invoc) != NULL) {
							ValaDataType* _tmp52_;
							_tmp52_ = NULL;
							ret_type = (_tmp52_ = vala_data_type_copy (vala_expression_get_target_type ((ValaExpression*) invoc)), (ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)), _tmp52_);
							vala_data_type_set_value_owned (ret_type, TRUE);
						} else {
							if (VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) invoc))) {
								ValaDataType* _tmp53_;
								_tmp53_ = NULL;
								ret_type = (_tmp53_ = (ValaDataType*) vala_void_type_new (NULL), (ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)), _tmp53_);
							} else {
								ValaDataType* _tmp54_;
								/* expect dynamic object of the same type*/
								_tmp54_ = NULL;
								ret_type = (_tmp54_ = vala_data_type_copy (vala_expression_get_value_type (vala_member_access_get_inner (self))), (ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)), _tmp54_);
							}
						}
						m = vala_dynamic_method_new (vala_expression_get_value_type (vala_member_access_get_inner (self)), self->priv->_member_name, ret_type, vala_code_node_get_source_reference ((ValaCodeNode*) self));
						vala_dynamic_method_set_invocation (m, invoc);
						_tmp55_ = NULL;
						vala_code_node_add_error_type ((ValaCodeNode*) m, (ValaDataType*) (_tmp55_ = vala_error_type_new (NULL, NULL, NULL)));
						(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_code_node_unref (_tmp55_), NULL));
						vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp56_ = NULL;
						vala_method_add_parameter ((ValaMethod*) m, _tmp56_ = vala_formal_parameter_new_with_ellipsis (NULL));
						(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_code_node_unref (_tmp56_), NULL));
						vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) vala_object_type_get_type_symbol (dynamic_object_type)), NULL, (ValaSymbol*) m);
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) m);
						(ret_type == NULL) ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL));
						(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					}
					(invoc == NULL) ? NULL : (invoc = (vala_code_node_unref (invoc), NULL));
				} else {
					if (VALA_IS_ASSIGNMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self))) {
						ValaAssignment* _tmp57_;
						ValaAssignment* a;
						gboolean _tmp58_;
						_tmp57_ = NULL;
						a = (_tmp57_ = VALA_ASSIGNMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self)), (_tmp57_ == NULL) ? NULL : vala_code_node_ref (_tmp57_));
						_tmp58_ = FALSE;
						if (vala_assignment_get_left (a) == VALA_EXPRESSION (self)) {
							gboolean _tmp59_;
							_tmp59_ = FALSE;
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp59_ = TRUE;
							} else {
								_tmp59_ = vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp58_ = _tmp59_;
						} else {
							_tmp58_ = FALSE;
						}
						if (_tmp58_) {
							ValaVoidType* _tmp60_;
							ValaDynamicSignal* _tmp61_;
							ValaDynamicSignal* s;
							/* dynamic signal*/
							_tmp60_ = NULL;
							_tmp61_ = NULL;
							s = (_tmp61_ = vala_dynamic_signal_new (vala_expression_get_value_type (vala_member_access_get_inner (self)), self->priv->_member_name, (ValaDataType*) (_tmp60_ = vala_void_type_new (NULL)), vala_code_node_get_source_reference ((ValaCodeNode*) self)), (_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_code_node_unref (_tmp60_), NULL)), _tmp61_);
							vala_dynamic_signal_set_handler (s, vala_assignment_get_right (a));
							vala_symbol_set_access ((ValaSymbol*) s, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) vala_object_type_get_type_symbol (dynamic_object_type)), NULL, (ValaSymbol*) s);
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) s);
							(s == NULL) ? NULL : (s = (vala_code_node_unref (s), NULL));
						} else {
							if (vala_assignment_get_left (a) == VALA_EXPRESSION (self)) {
								ValaDynamicProperty* prop;
								ValaPropertyAccessor* _tmp62_;
								/* dynamic property assignment*/
								prop = vala_dynamic_property_new (vala_expression_get_value_type (vala_member_access_get_inner (self)), self->priv->_member_name, vala_code_node_get_source_reference ((ValaCodeNode*) self));
								vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp62_ = NULL;
								vala_property_set_set_accessor ((ValaProperty*) prop, _tmp62_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, vala_code_node_get_source_reference ((ValaCodeNode*) prop)));
								(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_code_node_unref (_tmp62_), NULL));
								vala_property_accessor_set_access (vala_property_get_set_accessor ((ValaProperty*) prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								vala_symbol_set_owner ((ValaSymbol*) prop, vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (self)))));
								vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) vala_object_type_get_type_symbol (dynamic_object_type)), NULL, (ValaSymbol*) prop);
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) prop);
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							}
						}
						(a == NULL) ? NULL : (a = (vala_code_node_unref (a), NULL));
					}
				}
				if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
					ValaDynamicProperty* prop;
					ValaPropertyAccessor* _tmp65_;
					ValaDataType* _tmp64_;
					/* dynamic property read access*/
					prop = vala_dynamic_property_new (vala_expression_get_value_type (vala_member_access_get_inner (self)), self->priv->_member_name, vala_code_node_get_source_reference ((ValaCodeNode*) self));
					if (vala_expression_get_target_type ((ValaExpression*) self) != NULL) {
						vala_property_set_property_type ((ValaProperty*) prop, vala_expression_get_target_type ((ValaExpression*) self));
					} else {
						ValaDataType* _tmp63_;
						/* expect dynamic object of the same type*/
						_tmp63_ = NULL;
						vala_property_set_property_type ((ValaProperty*) prop, _tmp63_ = vala_data_type_copy (vala_expression_get_value_type (vala_member_access_get_inner (self))));
						(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_code_node_unref (_tmp63_), NULL));
					}
					vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp65_ = NULL;
					_tmp64_ = NULL;
					vala_property_set_get_accessor ((ValaProperty*) prop, _tmp65_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp64_ = vala_data_type_copy (vala_property_get_property_type ((ValaProperty*) prop)), NULL, vala_code_node_get_source_reference ((ValaCodeNode*) prop)));
					(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_code_node_unref (_tmp65_), NULL));
					(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_code_node_unref (_tmp64_), NULL));
					vala_property_accessor_set_access (vala_property_get_get_accessor ((ValaProperty*) prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					vala_symbol_set_owner ((ValaSymbol*) prop, vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (self)))));
					vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) vala_object_type_get_type_symbol (dynamic_object_type)), NULL, (ValaSymbol*) prop);
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) prop);
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				}
				if (vala_expression_get_symbol_reference ((ValaExpression*) self) != NULL) {
					may_access_instance_members = TRUE;
				}
				(dynamic_object_type == NULL) ? NULL : (dynamic_object_type = (vala_code_node_unref (dynamic_object_type), NULL));
			}
		}
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
		char* base_type_name;
		gboolean _tmp66_;
		char* _tmp69_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		base_type_name = g_strdup ("(null)");
		_tmp66_ = FALSE;
		if (vala_member_access_get_inner (self) != NULL) {
			_tmp66_ = vala_expression_get_value_type (vala_member_access_get_inner (self)) != NULL;
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			char* _tmp67_;
			_tmp67_ = NULL;
			base_type_name = (_tmp67_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (vala_member_access_get_inner (self))), base_type_name = (g_free (base_type_name), NULL), _tmp67_);
		} else {
			if (base_symbol != NULL) {
				char* _tmp68_;
				_tmp68_ = NULL;
				base_type_name = (_tmp68_ = vala_symbol_get_full_name (base_symbol), base_type_name = (g_free (base_type_name), NULL), _tmp68_);
			}
		}
		_tmp69_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp69_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", self->priv->_member_name, base_type_name));
		_tmp69_ = (g_free (_tmp69_), NULL);
		result = FALSE;
		base_type_name = (g_free (base_type_name), NULL);
		(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
		(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
		return result;
	}
	_tmp70_ = NULL;
	member = (_tmp70_ = vala_expression_get_symbol_reference ((ValaExpression*) self), (_tmp70_ == NULL) ? NULL : vala_code_node_ref (_tmp70_));
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	if (!vala_code_node_check ((ValaCodeNode*) member, analyzer)) {
		result = FALSE;
		(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
		(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
		(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
		return result;
	}
	if (VALA_IS_FIELD (member)) {
		ValaField* _tmp71_;
		ValaField* f;
		_tmp71_ = NULL;
		f = (_tmp71_ = VALA_FIELD (member), (_tmp71_ == NULL) ? NULL : vala_code_node_ref (_tmp71_));
		access = vala_symbol_get_access ((ValaSymbol*) f);
		instance = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
		klass = vala_field_get_binding (f) == MEMBER_BINDING_CLASS;
		(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
	} else {
		if (VALA_IS_METHOD (member)) {
			ValaMethod* _tmp72_;
			ValaMethod* m;
			_tmp72_ = NULL;
			m = (_tmp72_ = VALA_METHOD (member), (_tmp72_ == NULL) ? NULL : vala_code_node_ref (_tmp72_));
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* _tmp74_;
				ValaMethod* _tmp73_;
				ValaSymbol* _tmp76_;
				ValaSymbol* _tmp75_;
				/* refer to base method to inherit default arguments*/
				_tmp74_ = NULL;
				_tmp73_ = NULL;
				m = (_tmp74_ = (_tmp73_ = vala_method_get_base_method (m), (_tmp73_ == NULL) ? NULL : vala_code_node_ref (_tmp73_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp74_);
				if (vala_method_get_signal_reference (m) != NULL) {
					/* method is class/default handler for a signal
					 let signal deal with member access*/
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) vala_method_get_signal_reference (m));
				} else {
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) m);
				}
				_tmp76_ = NULL;
				_tmp75_ = NULL;
				member = (_tmp76_ = (_tmp75_ = vala_expression_get_symbol_reference ((ValaExpression*) self), (_tmp75_ == NULL) ? NULL : vala_code_node_ref (_tmp75_)), (member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL)), _tmp76_);
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaMethod* _tmp78_;
					ValaMethod* _tmp77_;
					ValaSymbol* _tmp80_;
					ValaSymbol* _tmp79_;
					/* refer to base method to inherit default arguments*/
					_tmp78_ = NULL;
					_tmp77_ = NULL;
					m = (_tmp78_ = (_tmp77_ = vala_method_get_base_interface_method (m), (_tmp77_ == NULL) ? NULL : vala_code_node_ref (_tmp77_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp78_);
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) m);
					_tmp80_ = NULL;
					_tmp79_ = NULL;
					member = (_tmp80_ = (_tmp79_ = vala_expression_get_symbol_reference ((ValaExpression*) self), (_tmp79_ == NULL) ? NULL : vala_code_node_ref (_tmp79_)), (member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL)), _tmp80_);
				}
			}
			access = vala_symbol_get_access ((ValaSymbol*) m);
			if (!VALA_IS_CREATION_METHOD (m)) {
				instance = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
			}
			klass = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		} else {
			if (VALA_IS_PROPERTY (member)) {
				ValaProperty* _tmp81_;
				ValaProperty* prop;
				_tmp81_ = NULL;
				prop = (_tmp81_ = VALA_PROPERTY (member), (_tmp81_ == NULL) ? NULL : vala_code_node_ref (_tmp81_));
				if (!vala_code_node_check ((ValaCodeNode*) prop, analyzer)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
					(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
					(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
					return result;
				}
				if (vala_property_get_base_property (prop) != NULL) {
					ValaProperty* _tmp83_;
					ValaProperty* _tmp82_;
					ValaSymbol* _tmp85_;
					ValaSymbol* _tmp84_;
					/* refer to base property*/
					_tmp83_ = NULL;
					_tmp82_ = NULL;
					prop = (_tmp83_ = (_tmp82_ = vala_property_get_base_property (prop), (_tmp82_ == NULL) ? NULL : vala_code_node_ref (_tmp82_)), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp83_);
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) prop);
					_tmp85_ = NULL;
					_tmp84_ = NULL;
					member = (_tmp85_ = (_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self), (_tmp84_ == NULL) ? NULL : vala_code_node_ref (_tmp84_)), (member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL)), _tmp85_);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaProperty* _tmp87_;
						ValaProperty* _tmp86_;
						ValaSymbol* _tmp89_;
						ValaSymbol* _tmp88_;
						/* refer to base property*/
						_tmp87_ = NULL;
						_tmp86_ = NULL;
						prop = (_tmp87_ = (_tmp86_ = vala_property_get_base_interface_property (prop), (_tmp86_ == NULL) ? NULL : vala_code_node_ref (_tmp86_)), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp87_);
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) prop);
						_tmp89_ = NULL;
						_tmp88_ = NULL;
						member = (_tmp89_ = (_tmp88_ = vala_expression_get_symbol_reference ((ValaExpression*) self), (_tmp88_ == NULL) ? NULL : vala_code_node_ref (_tmp88_)), (member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL)), _tmp89_);
					}
				}
				access = vala_symbol_get_access ((ValaSymbol*) prop);
				if (vala_expression_get_lvalue ((ValaExpression*) self)) {
					if (vala_property_get_set_accessor (prop) == NULL) {
						char* _tmp91_;
						char* _tmp90_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp91_ = NULL;
						_tmp90_ = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp91_ = g_strdup_printf ("Property `%s' is read-only", _tmp90_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
						_tmp91_ = (g_free (_tmp91_), NULL);
						_tmp90_ = (g_free (_tmp90_), NULL);
						result = FALSE;
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
						(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
						(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
						return result;
					}
					if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						access = vala_property_accessor_get_access (vala_property_get_set_accessor (prop));
					} else {
						gboolean _tmp92_;
						_tmp92_ = FALSE;
						if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
							_tmp92_ = vala_property_accessor_get_access (vala_property_get_set_accessor (prop)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
						} else {
							_tmp92_ = FALSE;
						}
						if (_tmp92_) {
							access = vala_property_accessor_get_access (vala_property_get_set_accessor (prop));
						}
					}
				} else {
					if (vala_property_get_get_accessor (prop) == NULL) {
						char* _tmp94_;
						char* _tmp93_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp94_ = NULL;
						_tmp93_ = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp94_ = g_strdup_printf ("Property `%s' is write-only", _tmp93_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
						_tmp94_ = (g_free (_tmp94_), NULL);
						_tmp93_ = (g_free (_tmp93_), NULL);
						result = FALSE;
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
						(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
						(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
						return result;
					}
					if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						access = vala_property_accessor_get_access (vala_property_get_get_accessor (prop));
					} else {
						gboolean _tmp95_;
						_tmp95_ = FALSE;
						if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
							_tmp95_ = vala_property_accessor_get_access (vala_property_get_get_accessor (prop)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
						} else {
							_tmp95_ = FALSE;
						}
						if (_tmp95_) {
							access = vala_property_accessor_get_access (vala_property_get_get_accessor (prop));
						}
					}
				}
				instance = vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE;
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			} else {
				if (VALA_IS_SIGNAL (member)) {
					instance = TRUE;
				}
			}
		}
	}
	vala_symbol_set_used (member, TRUE);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaSymbol* _tmp96_;
		ValaSymbol* target_type;
		gboolean in_target_type;
		_tmp96_ = NULL;
		target_type = (_tmp96_ = vala_symbol_get_parent_symbol (member), (_tmp96_ == NULL) ? NULL : vala_code_node_ref (_tmp96_));
		in_target_type = FALSE;
		{
			ValaSymbol* _tmp97_;
			ValaSymbol* this_symbol;
			_tmp97_ = NULL;
			this_symbol = (_tmp97_ = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp97_ == NULL) ? NULL : vala_code_node_ref (_tmp97_));
			{
				gboolean _tmp98_;
				_tmp98_ = TRUE;
				while (TRUE) {
					if (!_tmp98_) {
						ValaSymbol* _tmp100_;
						ValaSymbol* _tmp99_;
						_tmp100_ = NULL;
						_tmp99_ = NULL;
						this_symbol = (_tmp100_ = (_tmp99_ = vala_symbol_get_parent_symbol (this_symbol), (_tmp99_ == NULL) ? NULL : vala_code_node_ref (_tmp99_)), (this_symbol == NULL) ? NULL : (this_symbol = (vala_code_node_unref (this_symbol), NULL)), _tmp100_);
					}
					_tmp98_ = FALSE;
					if (!(this_symbol != NULL)) {
						break;
					}
					if (target_type == this_symbol) {
						in_target_type = TRUE;
						break;
					}
				}
			}
			(this_symbol == NULL) ? NULL : (this_symbol = (vala_code_node_unref (this_symbol), NULL));
		}
		if (!in_target_type) {
			char* _tmp102_;
			char* _tmp101_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp102_ = NULL;
			_tmp101_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp102_ = g_strdup_printf ("Access to private member `%s' denied", _tmp101_ = vala_symbol_get_full_name (member)));
			_tmp102_ = (g_free (_tmp102_), NULL);
			_tmp101_ = (g_free (_tmp101_), NULL);
			result = FALSE;
			(target_type == NULL) ? NULL : (target_type = (vala_code_node_unref (target_type), NULL));
			(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
			(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
			(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
			return result;
		}
		(target_type == NULL) ? NULL : (target_type = (vala_code_node_unref (target_type), NULL));
	}
	_tmp103_ = FALSE;
	_tmp104_ = FALSE;
	if (instance) {
		_tmp104_ = TRUE;
	} else {
		_tmp104_ = klass;
	}
	if (_tmp104_) {
		_tmp103_ = !may_access_instance_members;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		vala_member_access_set_prototype_access (self, TRUE);
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
			ValaDataType* _tmp105_;
			/* also set static type for prototype access
			 required when using instance methods as delegates in constants
			 TODO replace by MethodPrototype*/
			_tmp105_ = NULL;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp105_ = vala_semantic_analyzer_get_value_type_for_symbol (analyzer, vala_expression_get_symbol_reference ((ValaExpression*) self), vala_expression_get_lvalue ((ValaExpression*) self)));
			(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_code_node_unref (_tmp105_), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
				ValaFieldPrototype* _tmp106_;
				_tmp106_ = NULL;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) (_tmp106_ = vala_field_prototype_new (VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) self)))));
				(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_code_node_unref (_tmp106_), NULL));
			} else {
				ValaInvalidType* _tmp107_;
				_tmp107_ = NULL;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) (_tmp107_ = vala_invalid_type_new ()));
				(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_code_node_unref (_tmp107_), NULL));
			}
		}
	} else {
		gboolean _tmp108_;
		ValaDataType* _tmp111_;
		gboolean _tmp112_;
		_tmp108_ = FALSE;
		if (instance) {
			_tmp108_ = vala_member_access_get_inner (self) == NULL;
		} else {
			_tmp108_ = FALSE;
		}
		/* implicit this access*/
		if (_tmp108_) {
			ValaMemberAccess* _tmp109_;
			ValaDataType* _tmp110_;
			_tmp109_ = NULL;
			vala_member_access_set_inner (self, (ValaExpression*) (_tmp109_ = vala_member_access_new (NULL, "this", vala_code_node_get_source_reference ((ValaCodeNode*) self))));
			(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_code_node_unref (_tmp109_), NULL));
			_tmp110_ = NULL;
			vala_expression_set_value_type (vala_member_access_get_inner (self), _tmp110_ = vala_data_type_copy (vala_formal_parameter_get_parameter_type (this_parameter)));
			(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_code_node_unref (_tmp110_), NULL));
			vala_expression_set_symbol_reference (vala_member_access_get_inner (self), (ValaSymbol*) this_parameter);
		}
		_tmp111_ = NULL;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp111_ = vala_semantic_analyzer_get_value_type_for_symbol (analyzer, vala_expression_get_symbol_reference ((ValaExpression*) self), vala_expression_get_lvalue ((ValaExpression*) self)));
		(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_code_node_unref (_tmp111_), NULL));
		_tmp112_ = FALSE;
		if (vala_member_access_get_inner (self) != NULL) {
			_tmp112_ = vala_expression_get_formal_value_type ((ValaExpression*) self) != NULL;
		} else {
			_tmp112_ = FALSE;
		}
		if (_tmp112_) {
			ValaDataType* _tmp113_;
			_tmp113_ = NULL;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp113_ = vala_data_type_get_actual_type (vala_expression_get_formal_value_type ((ValaExpression*) self), vala_expression_get_value_type (vala_member_access_get_inner (self)), NULL, (ValaCodeNode*) self));
			(_tmp113_ == NULL) ? NULL : (_tmp113_ = (vala_code_node_unref (_tmp113_), NULL));
		} else {
			vala_expression_set_value_type ((ValaExpression*) self, vala_expression_get_formal_value_type ((ValaExpression*) self));
		}
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
			ValaMethod* _tmp114_;
			ValaMethod* m;
			ValaMethod* base_method;
			gboolean _tmp121_;
			_tmp114_ = NULL;
			m = (_tmp114_ = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp114_ == NULL) ? NULL : vala_code_node_ref (_tmp114_));
			base_method = NULL;
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* _tmp116_;
				ValaMethod* _tmp115_;
				_tmp116_ = NULL;
				_tmp115_ = NULL;
				base_method = (_tmp116_ = (_tmp115_ = vala_method_get_base_method (m), (_tmp115_ == NULL) ? NULL : vala_code_node_ref (_tmp115_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp116_);
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaMethod* _tmp118_;
					ValaMethod* _tmp117_;
					_tmp118_ = NULL;
					_tmp117_ = NULL;
					base_method = (_tmp118_ = (_tmp117_ = vala_method_get_base_interface_method (m), (_tmp117_ == NULL) ? NULL : vala_code_node_ref (_tmp117_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp118_);
				} else {
					ValaMethod* _tmp120_;
					ValaMethod* _tmp119_;
					_tmp120_ = NULL;
					_tmp119_ = NULL;
					base_method = (_tmp120_ = (_tmp119_ = m, (_tmp119_ == NULL) ? NULL : vala_code_node_ref (_tmp119_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp120_);
				}
			}
			_tmp121_ = FALSE;
			if (instance) {
				_tmp121_ = VALA_IS_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method));
			} else {
				_tmp121_ = FALSE;
			}
			if (_tmp121_) {
				ValaDataType* _tmp122_;
				_tmp122_ = NULL;
				vala_expression_set_target_type (vala_member_access_get_inner (self), _tmp122_ = vala_semantic_analyzer_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))));
				(_tmp122_ == NULL) ? NULL : (_tmp122_ = (vala_code_node_unref (_tmp122_), NULL));
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
		} else {
			if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
				ValaProperty* _tmp123_;
				ValaProperty* prop;
				ValaProperty* base_property;
				gboolean _tmp130_;
				_tmp123_ = NULL;
				prop = (_tmp123_ = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp123_ == NULL) ? NULL : vala_code_node_ref (_tmp123_));
				base_property = NULL;
				if (vala_property_get_base_property (prop) != NULL) {
					ValaProperty* _tmp125_;
					ValaProperty* _tmp124_;
					_tmp125_ = NULL;
					_tmp124_ = NULL;
					base_property = (_tmp125_ = (_tmp124_ = vala_property_get_base_property (prop), (_tmp124_ == NULL) ? NULL : vala_code_node_ref (_tmp124_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp125_);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaProperty* _tmp127_;
						ValaProperty* _tmp126_;
						_tmp127_ = NULL;
						_tmp126_ = NULL;
						base_property = (_tmp127_ = (_tmp126_ = vala_property_get_base_interface_property (prop), (_tmp126_ == NULL) ? NULL : vala_code_node_ref (_tmp126_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp127_);
					} else {
						ValaProperty* _tmp129_;
						ValaProperty* _tmp128_;
						_tmp129_ = NULL;
						_tmp128_ = NULL;
						base_property = (_tmp129_ = (_tmp128_ = prop, (_tmp128_ == NULL) ? NULL : vala_code_node_ref (_tmp128_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp129_);
					}
				}
				_tmp130_ = FALSE;
				if (instance) {
					_tmp130_ = vala_symbol_get_parent_symbol ((ValaSymbol*) base_property) != NULL;
				} else {
					_tmp130_ = FALSE;
				}
				if (_tmp130_) {
					ValaDataType* _tmp131_;
					_tmp131_ = NULL;
					vala_expression_set_target_type (vala_member_access_get_inner (self), _tmp131_ = vala_semantic_analyzer_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) base_property))));
					(_tmp131_ == NULL) ? NULL : (_tmp131_ = (vala_code_node_unref (_tmp131_), NULL));
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
			} else {
				gboolean _tmp132_;
				gboolean _tmp133_;
				gboolean _tmp134_;
				_tmp132_ = FALSE;
				_tmp133_ = FALSE;
				_tmp134_ = FALSE;
				if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
					_tmp134_ = TRUE;
				} else {
					_tmp134_ = VALA_IS_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) self));
				}
				if (_tmp134_) {
					_tmp133_ = instance;
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference ((ValaExpression*) self)) != NULL;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaDataType* _tmp135_;
					_tmp135_ = NULL;
					vala_expression_set_target_type (vala_member_access_get_inner (self), _tmp135_ = vala_semantic_analyzer_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference ((ValaExpression*) self)))));
					(_tmp135_ == NULL) ? NULL : (_tmp135_ = (vala_code_node_unref (_tmp135_), NULL));
				}
			}
		}
	}
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	(base_symbol == NULL) ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL));
	(this_parameter == NULL) ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL));
	(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
	return result;
}


static void vala_member_access_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	if (vala_member_access_get_inner (self) != NULL) {
		vala_code_node_get_defined_variables ((ValaCodeNode*) vala_member_access_get_inner (self), collection);
	}
}


static void vala_member_access_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaMemberAccess * self;
	ValaLocalVariable* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaLocalVariable* local;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	if (vala_member_access_get_inner (self) != NULL) {
		vala_code_node_get_used_variables ((ValaCodeNode*) vala_member_access_get_inner (self), collection);
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	local = (_tmp1_ = (_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self), VALA_IS_LOCAL_VARIABLE (_tmp0_) ? ((ValaLocalVariable*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (local != NULL) {
		gee_collection_add (collection, local);
	}
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


ValaExpression* vala_member_access_get_inner (ValaMemberAccess* self) {
	ValaExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_inner;
	return result;
}


void vala_member_access_set_inner (ValaMemberAccess* self, ValaExpression* value) {
	ValaExpression* _tmp1_;
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_inner = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)), _tmp1_);
	if (self->priv->_inner != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_inner, (ValaCodeNode*) self);
	}
}


const char* vala_member_access_get_member_name (ValaMemberAccess* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_member_name;
	return result;
}


void vala_member_access_set_member_name (ValaMemberAccess* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_member_name = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_member_name = (g_free (self->priv->_member_name), NULL), _tmp1_);
}


gboolean vala_member_access_get_pointer_member_access (ValaMemberAccess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}


void vala_member_access_set_pointer_member_access (ValaMemberAccess* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean vala_member_access_get_prototype_access (ValaMemberAccess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}


void vala_member_access_set_prototype_access (ValaMemberAccess* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean vala_member_access_get_creation_member (ValaMemberAccess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}


void vala_member_access_set_creation_member (ValaMemberAccess* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean vala_member_access_get_qualified (ValaMemberAccess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}


void vala_member_access_set_qualified (ValaMemberAccess* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void vala_member_access_class_init (ValaMemberAccessClass * klass) {
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_member_access_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_member_access_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_member_access_real_to_string;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_member_access_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_member_access_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_member_access_real_replace_type;
	VALA_EXPRESSION_CLASS (klass)->is_constant = vala_member_access_real_is_constant;
	VALA_EXPRESSION_CLASS (klass)->is_non_null = vala_member_access_real_is_non_null;
	VALA_CODE_NODE_CLASS (klass)->check = vala_member_access_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_member_access_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_member_access_real_get_used_variables;
}


static void vala_member_access_instance_init (ValaMemberAccess * self) {
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	self->priv->type_argument_list = (GeeList*) gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_member_access_finalize (ValaCodeNode* obj) {
	ValaMemberAccess * self;
	self = VALA_MEMBER_ACCESS (obj);
	self->priv->_member_name = (g_free (self->priv->_member_name), NULL);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL));
	(self->priv->type_argument_list == NULL) ? NULL : (self->priv->type_argument_list = (gee_collection_object_unref (self->priv->type_argument_list), NULL));
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


GType vala_member_access_get_type (void) {
	static GType vala_member_access_type_id = 0;
	if (vala_member_access_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	}
	return vala_member_access_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




