/* webkit-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "WebKit", lower_case_cprefix = "webkit_")]
namespace WebKit {
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class Download : GLib.Object {
		public void cancel ();
		public uint64 get_current_size ();
		public unowned string get_destination_uri ();
		public double get_elapsed_time ();
		public unowned WebKit.NetworkRequest get_network_request ();
		public double get_progress ();
		public WebKit.DownloadStatus get_status ();
		public unowned string get_suggested_filename ();
		public uint64 get_total_size ();
		public unowned string get_uri ();
		[CCode (has_construct_function = false)]
		public Download (WebKit.NetworkRequest request);
		public void set_destination_uri (string destination_uri);
		public void start ();
		public uint64 current_size { get; }
		public string destination_uri { get; set; }
		public WebKit.NetworkRequest network_request { get; construct; }
		public double progress { get; }
		public WebKit.DownloadStatus status { get; }
		public string suggested_filename { get; }
		public uint64 total_size { get; }
		public virtual signal bool error (int p0, int p1, string p2);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class NetworkRequest : GLib.Object {
		public unowned Soup.Message get_message ();
		public unowned string get_uri ();
		[CCode (has_construct_function = false)]
		public NetworkRequest (string uri);
		public void set_uri (string uri);
		public Soup.Message message { get; construct; }
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class SoupAuthDialog : GLib.Object, Soup.SessionFeature {
		public virtual signal unowned Gtk.Widget current_toplevel (Soup.Message message);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebBackForwardList : GLib.Object {
		public void add_item (WebKit.WebHistoryItem history_item);
		public bool contains_item (WebKit.WebHistoryItem history_item);
		public unowned WebKit.WebHistoryItem get_back_item ();
		public int get_back_length ();
		public unowned GLib.List get_back_list_with_limit (int limit);
		public unowned WebKit.WebHistoryItem get_current_item ();
		public unowned WebKit.WebHistoryItem get_forward_item ();
		public int get_forward_length ();
		public unowned GLib.List get_forward_list_with_limit (int limit);
		public int get_limit ();
		public unowned WebKit.WebHistoryItem get_nth_item (int index);
		public void go_back ();
		public void go_forward ();
		public void go_to_item (WebKit.WebHistoryItem history_item);
		public void set_limit (int limit);
		[CCode (has_construct_function = false)]
		public WebBackForwardList.with_web_view (WebKit.WebView web_view);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebFrame : GLib.Object {
		public unowned WebKit.WebFrame find_frame (string name);
		public WebKit.LoadStatus get_load_status ();
		public unowned string get_name ();
		public unowned WebKit.WebFrame get_parent ();
		public unowned string get_title ();
		public unowned string get_uri ();
		public unowned WebKit.WebView get_web_view ();
		public void load_alternate_string (string content, string base_url, string unreachable_url);
		public void load_request (WebKit.NetworkRequest request);
		public void load_string (string content, string mime_type, string encoding, string base_uri);
		public void load_uri (string uri);
		[CCode (has_construct_function = false)]
		public WebFrame (WebKit.WebView web_view);
		public void print ();
		public Gtk.PrintOperationResult print_full (Gtk.PrintOperation operation, Gtk.PrintOperationAction action) throws GLib.Error;
		public void reload ();
		public void stop_loading ();
		public WebKit.LoadStatus load_status { get; }
		public string name { get; }
		public string title { get; }
		public string uri { get; }
		public virtual signal void cleared ();
		public virtual signal void hovering_over_link (string p0, string p1);
		public virtual signal void load_committed ();
		public virtual signal void load_done (bool p0);
		public virtual signal void title_changed (string p0);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebHistoryItem : GLib.Object {
		public unowned string get_alternate_title ();
		public double get_last_visited_time ();
		public unowned string get_original_uri ();
		public unowned string get_title ();
		public unowned string get_uri ();
		[CCode (has_construct_function = false)]
		public WebHistoryItem ();
		public void set_alternate_title (string title);
		[CCode (has_construct_function = false)]
		public WebHistoryItem.with_data (string uri, string title);
		public string alternate_title { get; set; }
		public double last_visited_time { get; }
		public string original_uri { get; }
		public string title { get; }
		public string uri { get; }
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebInspector : GLib.Object {
		public unowned string get_inspected_uri ();
		public unowned WebKit.WebView get_web_view ();
		public string inspected_uri { get; }
		[NoAccessorMethod]
		public bool javascript_profiling_enabled { get; set; }
		public WebKit.WebView web_view { get; }
		public virtual signal bool attach_window ();
		public virtual signal bool close_window ();
		public virtual signal bool detach_window ();
		public virtual signal void finished ();
		public virtual signal unowned WebKit.WebView inspect_web_view (WebKit.WebView p0);
		public virtual signal bool show_window ();
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebNavigationAction : GLib.Object {
		public int get_button ();
		public int get_modifier_state ();
		public unowned string get_original_uri ();
		public WebKit.WebNavigationReason get_reason ();
		public void set_original_uri (string originalUri);
		public void set_reason (WebKit.WebNavigationReason reason);
		public int button { get; construct; }
		public int modifier_state { get; construct; }
		public string original_uri { get; set construct; }
		public WebKit.WebNavigationReason reason { get; set construct; }
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebPolicyDecision : GLib.Object {
		public void download ();
		public void ignore ();
		public void use ();
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebSettings : GLib.Object {
		public unowned WebKit.WebSettings copy ();
		[CCode (has_construct_function = false)]
		public WebSettings ();
		[NoAccessorMethod]
		public bool auto_load_images { get; set construct; }
		[NoAccessorMethod]
		public bool auto_shrink_images { get; set construct; }
		[NoAccessorMethod]
		public string cursive_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public string default_encoding { owned get; set construct; }
		[NoAccessorMethod]
		public string default_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public int default_font_size { get; set construct; }
		[NoAccessorMethod]
		public int default_monospace_font_size { get; set construct; }
		[NoAccessorMethod]
		public bool enable_caret_browsing { get; set construct; }
		[NoAccessorMethod]
		public bool enable_developer_extras { get; set construct; }
		[NoAccessorMethod]
		public bool enable_html5_database { get; set construct; }
		[NoAccessorMethod]
		public bool enable_html5_local_storage { get; set construct; }
		[NoAccessorMethod]
		public bool enable_plugins { get; set construct; }
		[NoAccessorMethod]
		public bool enable_private_browsing { get; set construct; }
		[NoAccessorMethod]
		public bool enable_scripts { get; set construct; }
		[NoAccessorMethod]
		public bool enable_spell_checking { get; set construct; }
		[NoAccessorMethod]
		public bool enforce_96_dpi { get; set construct; }
		[NoAccessorMethod]
		public string fantasy_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public int minimum_font_size { get; set construct; }
		[NoAccessorMethod]
		public int minimum_logical_font_size { get; set construct; }
		[NoAccessorMethod]
		public string monospace_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public bool print_backgrounds { get; set construct; }
		[NoAccessorMethod]
		public bool resizable_text_areas { get; set construct; }
		[NoAccessorMethod]
		public string sans_serif_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public string serif_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public string spell_checking_languages { owned get; set construct; }
		[NoAccessorMethod]
		public string user_stylesheet_uri { owned get; set construct; }
		[NoAccessorMethod]
		public float zoom_step { get; set construct; }
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebView : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		public bool can_copy_clipboard ();
		public bool can_cut_clipboard ();
		public bool can_go_back ();
		public bool can_go_back_or_forward (int steps);
		public bool can_go_forward ();
		public bool can_paste_clipboard ();
		public bool can_show_mime_type (string mime_type);
		[NoWrapper]
		public virtual unowned string choose_file (WebKit.WebFrame frame, string old_file);
		public void delete_selection ();
		public void execute_script (string script);
		public unowned WebKit.WebBackForwardList get_back_forward_list ();
		public unowned Gtk.TargetList get_copy_target_list ();
		public unowned string get_custom_encoding ();
		public bool get_editable ();
		public unowned string get_encoding ();
		public unowned WebKit.WebFrame get_focused_frame ();
		public bool get_full_content_zoom ();
		public unowned WebKit.WebInspector get_inspector ();
		public WebKit.LoadStatus get_load_status ();
		public unowned WebKit.WebFrame get_main_frame ();
		public unowned Gtk.TargetList get_paste_target_list ();
		public double get_progress ();
		public unowned WebKit.WebSettings get_settings ();
		public unowned string get_title ();
		public bool get_transparent ();
		public unowned string get_uri ();
		public unowned WebKit.WebWindowFeatures get_window_features ();
		public float get_zoom_level ();
		public void go_back ();
		public void go_back_or_forward (int steps);
		public void go_forward ();
		public bool go_to_back_forward_item (WebKit.WebHistoryItem item);
		public bool has_selection ();
		public void load_html_string (string content, string base_uri);
		public void load_request (WebKit.NetworkRequest request);
		public void load_string (string content, string mime_type, string encoding, string base_uri);
		public void load_uri (string uri);
		public uint mark_text_matches (string str, bool case_sensitive, uint limit);
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public WebView ();
		public void open (string uri);
		public void reload ();
		public void reload_bypass_cache ();
		public bool search_text (string text, bool case_sensitive, bool forward, bool wrap);
		public void set_custom_encoding (string encoding);
		public void set_editable (bool flag);
		public void set_full_content_zoom (bool full_content_zoom);
		public void set_highlight_text_matches (bool highlight);
		public void set_maintains_back_forward_list (bool flag);
		public void set_settings (WebKit.WebSettings settings);
		public void set_transparent (bool flag);
		public void set_zoom_level (float zoom_level);
		public void stop_loading ();
		public void unmark_text_matches ();
		public void zoom_in ();
		public void zoom_out ();
		public Gtk.TargetList copy_target_list { get; }
		public string custom_encoding { get; set; }
		public bool editable { get; set; }
		public string encoding { get; }
		public bool full_content_zoom { get; set; }
		public WebKit.LoadStatus load_status { get; }
		public Gtk.TargetList paste_target_list { get; }
		public double progress { get; }
		public WebKit.WebSettings settings { get; set; }
		public string title { get; }
		public bool transparent { get; set; }
		public string uri { get; }
		[NoAccessorMethod]
		public WebKit.WebInspector web_inspector { owned get; }
		[NoAccessorMethod]
		public WebKit.WebWindowFeatures window_features { owned get; set; }
		public float zoom_level { get; set; }
		public virtual signal bool console_message (string message, int line_number, string source_id);
		[HasEmitter]
		public virtual signal void copy_clipboard ();
		public virtual signal unowned Gtk.Widget create_plugin_widget (string p0, string p1, GLib.HashTable p2);
		public virtual signal unowned WebKit.WebView create_web_view (WebKit.WebFrame web_frame);
		[HasEmitter]
		public virtual signal void cut_clipboard ();
		public virtual signal bool download_requested (GLib.Object p0);
		public virtual signal void hovering_over_link (string? p0, string p1);
		public virtual signal void icon_loaded ();
		public virtual signal void load_committed (WebKit.WebFrame p0);
		public virtual signal bool load_error (WebKit.WebFrame p0, string p1, void* p2);
		public virtual signal void load_finished (WebKit.WebFrame p0);
		public virtual signal void load_progress_changed (int p0);
		public virtual signal void load_started (WebKit.WebFrame p0);
		public virtual signal bool mime_type_policy_decision_requested (WebKit.WebFrame p0, WebKit.NetworkRequest p1, string p2, WebKit.WebPolicyDecision p3);
		[HasEmitter]
		public virtual signal bool move_cursor (Gtk.MovementStep step, int count);
		public virtual signal bool navigation_policy_decision_requested (WebKit.WebFrame p0, WebKit.NetworkRequest p1, WebKit.WebNavigationAction p2, WebKit.WebPolicyDecision p3);
		public virtual signal WebKit.NavigationResponse navigation_requested (WebKit.WebFrame frame, WebKit.NetworkRequest request);
		public virtual signal bool new_window_policy_decision_requested (WebKit.WebFrame p0, WebKit.NetworkRequest p1, WebKit.WebNavigationAction p2, WebKit.WebPolicyDecision p3);
		[HasEmitter]
		public virtual signal void paste_clipboard ();
		public virtual signal void populate_popup (Gtk.Menu p0);
		public virtual signal bool print_requested (WebKit.WebFrame p0);
		public virtual signal bool script_alert (WebKit.WebFrame frame, string alert_message);
		public virtual signal bool script_confirm (WebKit.WebFrame frame, string confirm_message, void* did_confirm);
		public virtual signal bool script_prompt (WebKit.WebFrame frame, string message, string default_value, void* value);
		[HasEmitter]
		public virtual signal void select_all ();
		public virtual signal void selection_changed ();
		public virtual signal void set_scroll_adjustments (Gtk.Adjustment hadjustment, Gtk.Adjustment vadjustment);
		public virtual signal void status_bar_text_changed (string p0);
		public virtual signal void title_changed (WebKit.WebFrame p0, string p1);
		public virtual signal bool web_view_ready ();
		public virtual signal void window_object_cleared (WebKit.WebFrame frame, void* context, void* window_object);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebWindowFeatures : GLib.Object {
		public bool equal (WebKit.WebWindowFeatures features2);
		[CCode (has_construct_function = false)]
		public WebWindowFeatures ();
		[NoAccessorMethod]
		public bool fullscreen { get; set construct; }
		[NoAccessorMethod]
		public int height { get; set construct; }
		[NoAccessorMethod]
		public bool locationbar_visible { get; set construct; }
		[NoAccessorMethod]
		public bool menubar_visible { get; set construct; }
		[NoAccessorMethod]
		public bool scrollbar_visible { get; set construct; }
		[NoAccessorMethod]
		public bool statusbar_visible { get; set construct; }
		[NoAccessorMethod]
		public bool toolbar_visible { get; set construct; }
		[NoAccessorMethod]
		public int width { get; set construct; }
		[NoAccessorMethod]
		public int x { get; set construct; }
		[NoAccessorMethod]
		public int y { get; set construct; }
	}
	[CCode (cprefix = "WEBKIT_DOWNLOAD_ERROR_", cheader_filename = "webkit/webkit.h")]
	public enum DownloadError {
		CANCELLED_BY_USER,
		DESTINATION,
		NETWORK
	}
	[CCode (cprefix = "WEBKIT_DOWNLOAD_STATUS_", cheader_filename = "webkit/webkit.h")]
	public enum DownloadStatus {
		ERROR,
		CREATED,
		STARTED,
		CANCELLED,
		FINISHED
	}
	[CCode (cprefix = "WEBKIT_LOAD_", cheader_filename = "webkit/webkit.h")]
	public enum LoadStatus {
		PROVISIONAL,
		COMMITTED,
		FINISHED
	}
	[CCode (cprefix = "WEBKIT_NAVIGATION_RESPONSE_", cheader_filename = "webkit/webkit.h")]
	public enum NavigationResponse {
		ACCEPT,
		IGNORE,
		DOWNLOAD
	}
	[CCode (cprefix = "WEBKIT_NETWORK_ERROR_", cheader_filename = "webkit/webkit.h")]
	public enum NetworkError {
		FAILED,
		TRANSPORT,
		UNKNOWN_PROTOCOL,
		CANCELLED,
		FILE_DOES_NOT_EXIST
	}
	[CCode (cprefix = "WEBKIT_PLUGIN_ERROR_", cheader_filename = "webkit/webkit.h")]
	public enum PluginError {
		FAILED,
		CANNOT_FIND_PLUGIN,
		CANNOT_LOAD_PLUGIN,
		JAVA_UNAVAILABLE,
		CONNECTION_CANCELLED,
		WILL_HANDLE_LOAD
	}
	[CCode (cprefix = "WEBKIT_POLICY_ERROR_", cheader_filename = "webkit/webkit.h")]
	public enum PolicyError {
		FAILED,
		CANNOT_SHOW_MIME_TYPE,
		CANNOT_SHOW_URL,
		FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE,
		CANNOT_USE_RESTRICTED_PORT
	}
	[CCode (cprefix = "WEBKIT_WEB_NAVIGATION_REASON_", cheader_filename = "webkit/webkit.h")]
	public enum WebNavigationReason {
		LINK_CLICKED,
		FORM_SUBMITTED,
		BACK_FORWARD,
		RELOAD,
		FORM_RESUBMITTED,
		OTHER
	}
	[CCode (cprefix = "WEBKIT_WEB_VIEW_TARGET_INFO_", cheader_filename = "webkit/webkit.h")]
	public enum WebViewTargetInfo {
		HTML,
		TEXT
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "webkit/webkit.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "webkit/webkit.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "webkit/webkit.h")]
	public const int SOUP_AUTH_DIALOG_H;
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static unowned Soup.Session get_default_session ();
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static uint major_version ();
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static uint micro_version ();
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static uint minor_version ();
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static GLib.Quark network_error_quark ();
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static GLib.Quark plugin_error_quark ();
	[CCode (cheader_filename = "webkit/webkit.h")]
	public static GLib.Quark policy_error_quark ();
}
