/* valaccodedelegatemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};


static gpointer vala_ccode_delegate_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
enum  {
	VALA_CCODE_DELEGATE_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_delegate_module_real_generate_delegate_declaration (ValaCCodeBaseModule* base, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d);
static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr);
static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d);
ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_delegate_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeDelegateModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeDelegateModule*) vala_ccode_array_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_delegate_module_construct (VALA_TYPE_CCODE_DELEGATE_MODULE, codegen, next);
}


static void vala_ccode_delegate_module_real_generate_delegate_declaration (ValaCCodeBaseModule* base, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space) {
	ValaCCodeDelegateModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	char* return_type_cname;
	char* _tmp2_;
	gboolean _tmp3_;
	char* _tmp5_;
	ValaCCodeFunctionDeclarator* _tmp6_;
	ValaCCodeFunctionDeclarator* cfundecl;
	gboolean _tmp22_;
	GeeList* _tmp31_;
	gboolean _tmp32_;
	ValaCCodeTypeDefinition* ctypedef;
	gboolean _tmp33_;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) d, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	return_type_cname = vala_data_type_get_cname (vala_delegate_get_return_type (d));
	_tmp2_ = NULL;
	if ((_tmp3_ = _vala_strcmp0 (return_type_cname, _tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)) == 0, _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_)) {
		char* _tmp4_;
		/* recursive delegate*/
		_tmp4_ = NULL;
		return_type_cname = (_tmp4_ = g_strdup ("GCallback"), return_type_cname = (g_free (return_type_cname), NULL), _tmp4_);
	} else {
		vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_delegate_get_return_type (d), decl_space);
	}
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	cfundecl = (_tmp6_ = vala_ccode_function_declarator_new (_tmp5_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _tmp5_ = (g_free (_tmp5_), NULL), _tmp6_);
	{
		GeeList* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _param_it;
		_tmp7_ = NULL;
		_tmp8_ = NULL;
		_param_it = (_tmp8_ = gee_iterable_iterator ((GeeIterable*) (_tmp7_ = vala_delegate_get_parameters (d))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (gee_collection_object_unref (_tmp7_), NULL)), _tmp8_);
		while (TRUE) {
			ValaFormalParameter* param;
			GeeHashMap* _tmp9_;
			gboolean _tmp10_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp9_ = NULL;
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, decl_space, (GeeMap*) (_tmp9_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal)), NULL);
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL));
			vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			_tmp10_ = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp10_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp10_ = FALSE;
			}
			/* handle array parameters*/
			if (_tmp10_) {
				ValaArrayType* _tmp11_;
				ValaArrayType* array_type;
				char* length_ctype;
				_tmp11_ = NULL;
				array_type = (_tmp11_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp12_;
					_tmp12_ = NULL;
					length_ctype = (_tmp12_ = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp12_);
				}
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							char* _tmp15_;
							char* _tmp14_;
							ValaCCodeFormalParameter* _tmp16_;
							ValaCCodeFormalParameter* cparam;
							if (!_tmp13_) {
								dim++;
							}
							_tmp13_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							_tmp15_ = NULL;
							_tmp14_ = NULL;
							_tmp16_ = NULL;
							cparam = (_tmp16_ = vala_ccode_formal_parameter_new (_tmp15_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp14_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), dim), length_ctype), _tmp15_ = (g_free (_tmp15_), NULL), _tmp14_ = (g_free (_tmp14_), NULL), _tmp16_);
							vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
							(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				length_ctype = (g_free (length_ctype), NULL);
			}
			/* handle delegate parameters*/
			if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaDelegateType* _tmp17_;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp18_;
				ValaDelegate* param_d;
				_tmp17_ = NULL;
				deleg_type = (_tmp17_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_));
				_tmp18_ = NULL;
				param_d = (_tmp18_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp18_ == NULL) ? NULL : vala_code_node_ref (_tmp18_));
				if (vala_delegate_get_has_target (param_d)) {
					char* _tmp20_;
					char* _tmp19_;
					ValaCCodeFormalParameter* _tmp21_;
					ValaCCodeFormalParameter* cparam;
					_tmp20_ = NULL;
					_tmp19_ = NULL;
					_tmp21_ = NULL;
					cparam = (_tmp21_ = vala_ccode_formal_parameter_new (_tmp20_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp19_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), "void*"), _tmp20_ = (g_free (_tmp20_), NULL), _tmp19_ = (g_free (_tmp19_), NULL), _tmp21_);
					vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(param_d == NULL) ? NULL : (param_d = (vala_code_node_unref (param_d), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp22_ = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp22_ = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaArrayType* _tmp23_;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp23_ = NULL;
		array_type = (_tmp23_ = VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp24_;
				_tmp24_ = TRUE;
				while (TRUE) {
					char* _tmp25_;
					ValaCCodeFormalParameter* _tmp26_;
					ValaCCodeFormalParameter* cparam;
					if (!_tmp24_) {
						dim++;
					}
					_tmp24_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp25_ = NULL;
					_tmp26_ = NULL;
					cparam = (_tmp26_ = vala_ccode_formal_parameter_new (_tmp25_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp25_ = (g_free (_tmp25_), NULL), _tmp26_);
					vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_delegate_get_return_type (d))) {
			ValaDelegateType* _tmp27_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp28_;
			ValaDelegate* result_d;
			/* return delegate target if appropriate*/
			_tmp27_ = NULL;
			deleg_type = (_tmp27_ = VALA_DELEGATE_TYPE (vala_delegate_get_return_type (d)), (_tmp27_ == NULL) ? NULL : vala_code_node_ref (_tmp27_));
			_tmp28_ = NULL;
			result_d = (_tmp28_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp28_ == NULL) ? NULL : vala_code_node_ref (_tmp28_));
			if (vala_delegate_get_has_target (result_d)) {
				char* _tmp29_;
				ValaCCodeFormalParameter* _tmp30_;
				ValaCCodeFormalParameter* cparam;
				_tmp29_ = NULL;
				_tmp30_ = NULL;
				cparam = (_tmp30_ = vala_ccode_formal_parameter_new (_tmp29_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void**"), _tmp29_ = (g_free (_tmp29_), NULL), _tmp30_);
				vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(result_d == NULL) ? NULL : (result_d = (vala_code_node_unref (result_d), NULL));
		}
	}
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	_tmp31_ = NULL;
	if ((_tmp32_ = gee_collection_get_size ((GeeCollection*) (_tmp31_ = vala_code_node_get_error_types ((ValaCodeNode*) d))) > 0, (_tmp31_ == NULL) ? NULL : (_tmp31_ = (gee_collection_object_unref (_tmp31_), NULL)), _tmp32_)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	ctypedef = vala_ccode_type_definition_new (return_type_cname, (ValaCCodeDeclarator*) cfundecl);
	_tmp33_ = FALSE;
	if (vala_code_node_get_source_reference ((ValaCodeNode*) d) != NULL) {
		_tmp33_ = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) d)) != NULL;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ValaCCodeComment* _tmp34_;
		_tmp34_ = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp34_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) d)))));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) ctypedef);
	return_type_cname = (g_free (return_type_cname), NULL);
	(cfundecl == NULL) ? NULL : (cfundecl = (vala_ccode_node_unref (cfundecl), NULL));
	(ctypedef == NULL) ? NULL : (ctypedef = (vala_ccode_node_unref (ctypedef), NULL));
}


static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) d)) {
		vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->header_declarations);
	}
	vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
}


static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	char* result;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	result = g_strdup_printf ("%s_target", delegate_cname);
	return result;
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr) {
	ValaCCodeDelegateModule * self;
	ValaCCodeExpression* result;
	gboolean is_out;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* _tmp0_;
		ValaUnaryExpression* unary_expr;
		gboolean _tmp1_;
		_tmp0_ = NULL;
		unary_expr = (_tmp0_ = VALA_UNARY_EXPRESSION (delegate_expr), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = FALSE;
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp1_) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL) ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL));
	}
	if (VALA_IS_METHOD_CALL (delegate_expr)) {
		ValaMethodCall* _tmp2_;
		ValaMethodCall* invocation_expr;
		ValaCCodeExpression* _tmp3_;
		_tmp2_ = NULL;
		invocation_expr = (_tmp2_ = VALA_METHOD_CALL (delegate_expr), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		_tmp3_ = NULL;
		result = (_tmp3_ = vala_method_call_get_delegate_target (invocation_expr), (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_));
		(invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL));
		return result;
		(invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL));
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (delegate_expr)) {
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp4_ = FALSE;
			_tmp5_ = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp5_ = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = ((ValaCCodeBaseModule*) self)->in_constructor;
			}
			if (_tmp4_) {
				result = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
				return result;
			} else {
				result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
				return result;
			}
		} else {
			if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaFormalParameter* _tmp6_;
					ValaFormalParameter* param;
					char* _tmp8_;
					char* _tmp7_;
					ValaCCodeExpression* _tmp9_;
					ValaCCodeExpression* target_expr;
					_tmp6_ = NULL;
					param = (_tmp6_ = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
					_tmp8_ = NULL;
					_tmp7_ = NULL;
					_tmp9_ = NULL;
					target_expr = (_tmp9_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp7_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp9_);
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeExpression* _tmp10_;
						/* accessing argument of out/ref param*/
						_tmp10_ = NULL;
						target_expr = (_tmp10_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp10_);
					}
					if (is_out) {
						/* passing array as out/ref*/
						result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
						return result;
					} else {
						result = target_expr;
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						return result;
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaLocalVariable* _tmp11_;
						ValaLocalVariable* local;
						char* _tmp12_;
						ValaCCodeIdentifier* _tmp13_;
						ValaCCodeIdentifier* target_expr;
						_tmp11_ = NULL;
						local = (_tmp11_ = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr)), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
						_tmp12_ = NULL;
						_tmp13_ = NULL;
						target_expr = (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))), _tmp12_ = (g_free (_tmp12_), NULL), _tmp13_);
						if (is_out) {
							result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) target_expr);
							(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
							return result;
						} else {
							result = (ValaCCodeExpression*) target_expr;
							(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							return result;
						}
						(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
						(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaField* _tmp14_;
							ValaField* field;
							char* _tmp15_;
							char* _tmp16_;
							char* target_cname;
							ValaMemberAccess* _tmp17_;
							ValaMemberAccess* ma;
							ValaCCodeExpression* target_expr;
							_tmp14_ = NULL;
							field = (_tmp14_ = VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_));
							_tmp15_ = NULL;
							_tmp16_ = NULL;
							target_cname = (_tmp16_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp15_ = vala_field_get_cname (field)), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_);
							_tmp17_ = NULL;
							ma = (_tmp17_ = VALA_MEMBER_ACCESS (delegate_expr), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_));
							target_expr = NULL;
							if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
								ValaDataType* _tmp18_;
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* pub_inst;
								ValaCCodeExpression* typed_inst;
								ValaCCodeExpression* inst;
								_tmp18_ = NULL;
								instance_expression_type = (_tmp18_ = vala_expression_get_value_type (vala_member_access_get_inner (ma)), (_tmp18_ == NULL) ? NULL : vala_code_node_ref (_tmp18_));
								instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)));
								pub_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
								typed_inst = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, pub_inst, instance_expression_type, instance_target_type, NULL);
								inst = NULL;
								if (vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* _tmp19_;
									_tmp19_ = NULL;
									inst = (_tmp19_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp19_);
								} else {
									ValaCCodeExpression* _tmp21_;
									ValaCCodeExpression* _tmp20_;
									_tmp21_ = NULL;
									_tmp20_ = NULL;
									inst = (_tmp21_ = (_tmp20_ = typed_inst, (_tmp20_ == NULL) ? NULL : vala_ccode_node_ref (_tmp20_)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp21_);
								}
								if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
									ValaCCodeExpression* _tmp22_;
									_tmp22_ = NULL;
									target_expr = (_tmp22_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, target_cname), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp22_);
								} else {
									ValaCCodeExpression* _tmp23_;
									_tmp23_ = NULL;
									target_expr = (_tmp23_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, target_cname, FALSE), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp23_);
								}
								(instance_expression_type == NULL) ? NULL : (instance_expression_type = (vala_code_node_unref (instance_expression_type), NULL));
								(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
								(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
							} else {
								ValaCCodeExpression* _tmp24_;
								_tmp24_ = NULL;
								target_expr = (_tmp24_ = (ValaCCodeExpression*) vala_ccode_identifier_new (target_cname), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp24_);
							}
							if (is_out) {
								result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr);
								(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
								target_cname = (g_free (target_cname), NULL);
								(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
								(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
								return result;
							} else {
								result = target_expr;
								(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
								target_cname = (g_free (target_cname), NULL);
								(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
								return result;
							}
							(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
							target_cname = (g_free (target_cname), NULL);
							(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
						} else {
							if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
								ValaMethod* _tmp25_;
								ValaMethod* m;
								ValaMemberAccess* _tmp26_;
								ValaMemberAccess* ma;
								_tmp25_ = NULL;
								m = (_tmp25_ = VALA_METHOD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp25_ == NULL) ? NULL : vala_code_node_ref (_tmp25_));
								_tmp26_ = NULL;
								ma = (_tmp26_ = VALA_MEMBER_ACCESS (delegate_expr), (_tmp26_ == NULL) ? NULL : vala_code_node_ref (_tmp26_));
								if (vala_method_get_binding (m) == MEMBER_BINDING_STATIC) {
									result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
									(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
									(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
									return result;
								} else {
									result = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
									(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
									(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
									return result;
								}
								(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
								(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							}
						}
					}
				}
			}
		}
	}
	result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
	return result;
}


static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	char* result;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	result = g_strdup_printf ("%s_target_destroy_notify", delegate_cname);
	return result;
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeDelegateModule * self;
	ValaCCodeExpression* result;
	gboolean _tmp0_;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_DELEGATE_TYPE (target_type)) {
		_tmp0_ = VALA_IS_METHOD_TYPE (expression_type);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDelegateType* _tmp1_;
		ValaDelegateType* dt;
		ValaMethodType* _tmp2_;
		ValaMethodType* mt;
		ValaMethod* _tmp3_;
		ValaMethod* method;
		char* _tmp8_;
		ValaCCodeExpression* _tmp9_;
		_tmp1_ = NULL;
		dt = (_tmp1_ = VALA_DELEGATE_TYPE (target_type), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		_tmp2_ = NULL;
		mt = (_tmp2_ = VALA_METHOD_TYPE (expression_type), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		_tmp3_ = NULL;
		method = (_tmp3_ = vala_method_type_get_method_symbol (mt), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
		if (vala_method_get_base_method (method) != NULL) {
			ValaMethod* _tmp5_;
			ValaMethod* _tmp4_;
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			method = (_tmp5_ = (_tmp4_ = vala_method_get_base_method (method), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp5_);
		} else {
			if (vala_method_get_base_interface_method (method) != NULL) {
				ValaMethod* _tmp7_;
				ValaMethod* _tmp6_;
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				method = (_tmp7_ = (_tmp6_ = vala_method_get_base_interface_method (method), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp7_);
			}
		}
		_tmp8_ = NULL;
		_tmp9_ = NULL;
		result = (_tmp9_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8_ = vala_ccode_delegate_module_generate_delegate_wrapper (self, method, vala_delegate_type_get_delegate_symbol (dt))), _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_);
		(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
		(mt == NULL) ? NULL : (mt = (vala_code_node_unref (mt), NULL));
		(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
		return result;
		(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
		(mt == NULL) ? NULL : (mt = (vala_code_node_unref (mt), NULL));
		(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->get_implicit_cast_expression ((ValaCCodeBaseModule*) VALA_CCODE_ARRAY_MODULE (self), source_cexpr, expression_type, target_type, expr);
		return result;
	}
}


static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d) {
	char* result;
	char* delegate_name;
	ValaSignal* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaSignal* sig;
	ValaDynamicSignal* _tmp3_;
	ValaSignal* _tmp2_;
	ValaDynamicSignal* dynamic_sig;
	char* _tmp10_;
	char* _tmp11_;
	char* wrapper_name;
	char* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeList* d_params;
	gboolean _tmp14_;
	GeeList* _tmp22_;
	gboolean _tmp23_;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	gboolean first;
	gboolean _tmp64_;
	GeeList* _tmp73_;
	gboolean _tmp74_;
	ValaCCodeIdentifier* _tmp77_;
	char* _tmp76_;
	ValaCCodeFunctionCall* _tmp78_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp86_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	delegate_name = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	sig = (_tmp1_ = (_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) d), VALA_IS_SIGNAL (_tmp0_) ? ((ValaSignal*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	dynamic_sig = (_tmp3_ = (_tmp2_ = sig, VALA_IS_DYNAMIC_SIGNAL (_tmp2_) ? ((ValaDynamicSignal*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	if (dynamic_sig != NULL) {
		char* _tmp4_;
		_tmp4_ = NULL;
		delegate_name = (_tmp4_ = vala_ccode_module_get_dynamic_signal_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), dynamic_sig), delegate_name = (g_free (delegate_name), NULL), _tmp4_);
	} else {
		if (sig != NULL) {
			char* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			delegate_name = (_tmp7_ = g_strconcat (_tmp5_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), _tmp6_ = vala_signal_get_cname (sig), NULL), delegate_name = (g_free (delegate_name), NULL), _tmp7_);
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
		} else {
			char* _tmp9_;
			char* _tmp8_;
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			delegate_name = (_tmp9_ = vala_symbol_camel_case_to_lower_case (_tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), delegate_name = (g_free (delegate_name), NULL), _tmp9_);
			_tmp8_ = (g_free (_tmp8_), NULL);
		}
	}
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	wrapper_name = (_tmp11_ = g_strdup_printf ("_%s_%s", _tmp10_ = vala_method_get_cname (m), delegate_name), _tmp10_ = (g_free (_tmp10_), NULL), _tmp11_);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, wrapper_name)) {
		/* wrapper already defined*/
		result = wrapper_name;
		delegate_name = (g_free (delegate_name), NULL);
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		(dynamic_sig == NULL) ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL));
		return result;
	}
	/* declaration*/
	_tmp12_ = NULL;
	_tmp13_ = NULL;
	function = (_tmp13_ = vala_ccode_function_new (wrapper_name, _tmp12_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp12_ = (g_free (_tmp12_), NULL), _tmp13_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) function);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	if (vala_delegate_get_sender_type (d) != NULL) {
		ValaFormalParameter* param;
		param = vala_formal_parameter_new ("_sender", vala_delegate_get_sender_type (d), NULL);
		vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, NULL);
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	d_params = vala_delegate_get_parameters (d);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) d_params);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, NULL);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp14_ = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp14_ = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaArrayType* _tmp15_;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp15_ = NULL;
		array_type = (_tmp15_ = VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)), (_tmp15_ == NULL) ? NULL : vala_code_node_ref (_tmp15_));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp16_;
				_tmp16_ = TRUE;
				while (TRUE) {
					char* _tmp17_;
					ValaCCodeFormalParameter* _tmp18_;
					ValaCCodeFormalParameter* cparam;
					if (!_tmp16_) {
						dim++;
					}
					_tmp16_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp17_ = NULL;
					_tmp18_ = NULL;
					cparam = (_tmp18_ = vala_ccode_formal_parameter_new (_tmp17_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp17_ = (g_free (_tmp17_), NULL), _tmp18_);
					gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_carray_length_parameter_position (d) + (0.01 * dim), FALSE)), cparam);
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_delegate_get_return_type (d))) {
			ValaDelegateType* _tmp19_;
			ValaDelegateType* deleg_type;
			/* return delegate target if appropriate*/
			_tmp19_ = NULL;
			deleg_type = (_tmp19_ = VALA_DELEGATE_TYPE (vala_delegate_get_return_type (d)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (deleg_type))) {
				char* _tmp20_;
				ValaCCodeFormalParameter* _tmp21_;
				ValaCCodeFormalParameter* cparam;
				_tmp20_ = NULL;
				_tmp21_ = NULL;
				cparam = (_tmp21_ = vala_ccode_formal_parameter_new (_tmp20_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void**"), _tmp20_ = (g_free (_tmp20_), NULL), _tmp21_);
				gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cdelegate_target_parameter_position (d), FALSE)), cparam);
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
		}
	}
	_tmp22_ = NULL;
	if ((_tmp23_ = gee_collection_get_size ((GeeCollection*) (_tmp22_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp22_ == NULL) ? NULL : (_tmp22_ = (gee_collection_object_unref (_tmp22_), NULL)), _tmp23_)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp28_;
		min_pos = -1;
		{
			GeeSet* _tmp24_;
			GeeIterator* _tmp25_;
			GeeIterator* _pos_it;
			_tmp24_ = NULL;
			_tmp25_ = NULL;
			_pos_it = (_tmp25_ = gee_iterable_iterator ((GeeIterable*) (_tmp24_ = gee_map_get_keys ((GeeMap*) cparam_map))), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (gee_collection_object_unref (_tmp24_), NULL)), _tmp25_);
			while (TRUE) {
				gint pos;
				gboolean _tmp26_;
				if (!gee_iterator_next (_pos_it)) {
					break;
				}
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp26_ = FALSE;
				if (pos > last_pos) {
					gboolean _tmp27_;
					_tmp27_ = FALSE;
					if (min_pos == (-1)) {
						_tmp27_ = TRUE;
					} else {
						_tmp27_ = pos < min_pos;
					}
					_tmp26_ = _tmp27_;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp28_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp28_ = (ValaCCodeFormalParameter*) gee_map_get ((GeeMap*) cparam_map, GINT_TO_POINTER (min_pos)));
		(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
		last_pos = min_pos;
	}
	/* definition*/
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	i = 0;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* arg;
		arg = NULL;
		if (vala_delegate_get_has_target (d)) {
			ValaCCodeExpression* _tmp29_;
			_tmp29_ = NULL;
			arg = (_tmp29_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp29_);
		} else {
			ValaCCodeExpression* _tmp32_;
			ValaFormalParameter* _tmp30_;
			ValaCCodeNode* _tmp31_;
			/* use first delegate parameter as instance*/
			_tmp32_ = NULL;
			_tmp30_ = NULL;
			_tmp31_ = NULL;
			arg = (_tmp32_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name ((_tmp31_ = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp30_ = (ValaFormalParameter*) gee_list_get (d_params, 0))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp31_) ? ((ValaCCodeFormalParameter*) _tmp31_) : NULL))), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp32_);
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_code_node_unref (_tmp30_), NULL));
			i = 1;
		}
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), arg);
		(arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL));
	}
	first = TRUE;
	{
		GeeList* _tmp33_;
		GeeIterator* _tmp34_;
		GeeIterator* _param_it;
		_tmp33_ = NULL;
		_tmp34_ = NULL;
		_param_it = (_tmp34_ = gee_iterable_iterator ((GeeIterable*) (_tmp33_ = vala_method_get_parameters (m))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (gee_collection_object_unref (_tmp33_), NULL)), _tmp34_);
		while (TRUE) {
			ValaFormalParameter* param;
			gboolean _tmp35_;
			gboolean _tmp36_;
			ValaCCodeExpression* arg;
			ValaCCodeExpression* _tmp42_;
			ValaFormalParameter* _tmp40_;
			ValaCCodeNode* _tmp41_;
			gboolean _tmp43_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp35_ = FALSE;
			_tmp36_ = FALSE;
			if (first) {
				_tmp36_ = vala_delegate_get_sender_type (d) != NULL;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				GeeList* _tmp38_;
				GeeList* _tmp37_;
				_tmp38_ = NULL;
				_tmp37_ = NULL;
				_tmp35_ = gee_collection_get_size ((GeeCollection*) (_tmp37_ = vala_method_get_parameters (m))) == (gee_collection_get_size ((GeeCollection*) (_tmp38_ = vala_delegate_get_parameters (d))) + 1);
				(_tmp38_ == NULL) ? NULL : (_tmp38_ = (gee_collection_object_unref (_tmp38_), NULL));
				(_tmp37_ == NULL) ? NULL : (_tmp37_ = (gee_collection_object_unref (_tmp37_), NULL));
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				ValaCCodeIdentifier* _tmp39_;
				/* sender parameter*/
				_tmp39_ = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("_sender")));
				(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
				first = FALSE;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			arg = NULL;
			_tmp42_ = NULL;
			_tmp40_ = NULL;
			_tmp41_ = NULL;
			arg = (_tmp42_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name ((_tmp41_ = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp40_ = (ValaFormalParameter*) gee_list_get (d_params, i))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp41_) ? ((ValaCCodeFormalParameter*) _tmp41_) : NULL))), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp42_);
			(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_code_node_unref (_tmp40_), NULL));
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
			_tmp43_ = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp43_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp43_ = FALSE;
			}
			/* handle array arguments*/
			if (_tmp43_) {
				ValaArrayType* _tmp44_;
				ValaArrayType* array_type;
				_tmp44_ = NULL;
				array_type = (_tmp44_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp44_ == NULL) ? NULL : vala_code_node_ref (_tmp44_));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp45_;
						_tmp45_ = TRUE;
						while (TRUE) {
							ValaCCodeExpression* clength;
							ValaFormalParameter* _tmp46_;
							gboolean _tmp47_;
							if (!_tmp45_) {
								dim++;
							}
							_tmp45_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							clength = NULL;
							_tmp46_ = NULL;
							if ((_tmp47_ = vala_formal_parameter_get_array_null_terminated (_tmp46_ = (ValaFormalParameter*) gee_list_get (d_params, i)), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_code_node_unref (_tmp46_), NULL)), _tmp47_)) {
								ValaCCodeIdentifier* _tmp48_;
								ValaCCodeFunctionCall* _tmp49_;
								ValaCCodeFunctionCall* len_call;
								ValaCCodeIdentifier* _tmp51_;
								ValaFormalParameter* _tmp50_;
								ValaCCodeExpression* _tmp53_;
								ValaCCodeExpression* _tmp52_;
								((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
								_tmp48_ = NULL;
								_tmp49_ = NULL;
								len_call = (_tmp49_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL)), _tmp49_);
								_tmp51_ = NULL;
								_tmp50_ = NULL;
								vala_ccode_function_call_add_argument (len_call, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) (_tmp50_ = (ValaFormalParameter*) gee_list_get (d_params, i))))));
								(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
								(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_code_node_unref (_tmp50_), NULL));
								_tmp53_ = NULL;
								_tmp52_ = NULL;
								clength = (_tmp53_ = (_tmp52_ = (ValaCCodeExpression*) len_call, (_tmp52_ == NULL) ? NULL : vala_ccode_node_ref (_tmp52_)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp53_);
								(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
							} else {
								ValaFormalParameter* _tmp54_;
								gboolean _tmp55_;
								_tmp54_ = NULL;
								if ((_tmp55_ = vala_formal_parameter_get_no_array_length (_tmp54_ = (ValaFormalParameter*) gee_list_get (d_params, i)), (_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_code_node_unref (_tmp54_), NULL)), _tmp55_)) {
									ValaCCodeExpression* _tmp56_;
									_tmp56_ = NULL;
									clength = (_tmp56_ = (ValaCCodeExpression*) vala_ccode_constant_new ("-1"), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp56_);
								} else {
									ValaCCodeExpression* _tmp59_;
									char* _tmp58_;
									ValaFormalParameter* _tmp57_;
									_tmp59_ = NULL;
									_tmp58_ = NULL;
									_tmp57_ = NULL;
									clength = (_tmp59_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp58_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) (_tmp57_ = (ValaFormalParameter*) gee_list_get (d_params, i))), dim)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp59_);
									_tmp58_ = (g_free (_tmp58_), NULL);
									(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_code_node_unref (_tmp57_), NULL));
								}
							}
							gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), clength);
							(clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL));
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaDelegateType* _tmp60_;
					ValaDelegateType* deleg_type;
					_tmp60_ = NULL;
					deleg_type = (_tmp60_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp60_ == NULL) ? NULL : vala_code_node_ref (_tmp60_));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (deleg_type))) {
						char* _tmp62_;
						ValaFormalParameter* _tmp61_;
						ValaCCodeIdentifier* _tmp63_;
						ValaCCodeIdentifier* ctarget;
						_tmp62_ = NULL;
						_tmp61_ = NULL;
						_tmp63_ = NULL;
						ctarget = (_tmp63_ = vala_ccode_identifier_new (_tmp62_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) (_tmp61_ = (ValaFormalParameter*) gee_list_get (d_params, i))))), _tmp62_ = (g_free (_tmp62_), NULL), (_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_code_node_unref (_tmp61_), NULL)), _tmp63_);
						gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) ctarget);
						(ctarget == NULL) ? NULL : (ctarget = (vala_ccode_node_unref (ctarget), NULL));
					}
					(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				}
			}
			i++;
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp64_ = FALSE;
	if (!vala_method_get_no_array_length (m)) {
		_tmp64_ = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ValaArrayType* _tmp65_;
		ValaArrayType* array_type;
		_tmp65_ = NULL;
		array_type = (_tmp65_ = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp65_ == NULL) ? NULL : vala_code_node_ref (_tmp65_));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp66_;
				_tmp66_ = TRUE;
				while (TRUE) {
					ValaCCodeExpression* clength;
					if (!_tmp66_) {
						dim++;
					}
					_tmp66_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					clength = NULL;
					if (vala_delegate_get_no_array_length (d)) {
						ValaCCodeExpression* _tmp67_;
						_tmp67_ = NULL;
						clength = (_tmp67_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp67_);
					} else {
						ValaCCodeExpression* _tmp69_;
						char* _tmp68_;
						_tmp69_ = NULL;
						_tmp68_ = NULL;
						clength = (_tmp69_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp68_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp69_);
						_tmp68_ = (g_free (_tmp68_), NULL);
					}
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), clength);
					(clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL));
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp70_;
			ValaDelegateType* deleg_type;
			_tmp70_ = NULL;
			deleg_type = (_tmp70_ = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp70_ == NULL) ? NULL : vala_code_node_ref (_tmp70_));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (deleg_type))) {
				char* _tmp71_;
				ValaCCodeIdentifier* _tmp72_;
				ValaCCodeIdentifier* ctarget;
				_tmp71_ = NULL;
				_tmp72_ = NULL;
				ctarget = (_tmp72_ = vala_ccode_identifier_new (_tmp71_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result")), _tmp71_ = (g_free (_tmp71_), NULL), _tmp72_);
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) ctarget);
				(ctarget == NULL) ? NULL : (ctarget = (vala_ccode_node_unref (ctarget), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
		}
	}
	_tmp73_ = NULL;
	if ((_tmp74_ = gee_collection_get_size ((GeeCollection*) (_tmp73_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp73_ == NULL) ? NULL : (_tmp73_ = (gee_collection_object_unref (_tmp73_), NULL)), _tmp74_)) {
		ValaCCodeIdentifier* _tmp75_;
		_tmp75_ = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("error")));
		(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
	}
	_tmp77_ = NULL;
	_tmp76_ = NULL;
	_tmp78_ = NULL;
	ccall = (_tmp78_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_identifier_new (_tmp76_ = vala_method_get_cname (m)))), (_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL)), _tmp76_ = (g_free (_tmp76_), NULL), _tmp78_);
	/* append C arguments in the right order*/
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp83_;
		min_pos = -1;
		{
			GeeSet* _tmp79_;
			GeeIterator* _tmp80_;
			GeeIterator* _pos_it;
			_tmp79_ = NULL;
			_tmp80_ = NULL;
			_pos_it = (_tmp80_ = gee_iterable_iterator ((GeeIterable*) (_tmp79_ = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp79_ == NULL) ? NULL : (_tmp79_ = (gee_collection_object_unref (_tmp79_), NULL)), _tmp80_);
			while (TRUE) {
				gint pos;
				gboolean _tmp81_;
				if (!gee_iterator_next (_pos_it)) {
					break;
				}
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp81_ = FALSE;
				if (pos > last_pos) {
					gboolean _tmp82_;
					_tmp82_ = FALSE;
					if (min_pos == (-1)) {
						_tmp82_ = TRUE;
					} else {
						_tmp82_ = pos < min_pos;
					}
					_tmp81_ = _tmp82_;
				} else {
					_tmp81_ = FALSE;
				}
				if (_tmp81_) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp83_ = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp83_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
		(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp84_;
		_tmp84_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp84_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
	} else {
		ValaCCodeReturnStatement* _tmp85_;
		_tmp85_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp85_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
	}
	/* append to file*/
	_tmp86_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp86_ = vala_ccode_function_copy (function)));
	(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = wrapper_name;
	delegate_name = (g_free (delegate_name), NULL);
	(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	(dynamic_sig == NULL) ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(d_params == NULL) ? NULL : (d_params = (gee_collection_object_unref (d_params), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static void vala_ccode_delegate_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaCCodeDelegateModule * self;
	gboolean _tmp0_;
	char* ctypename;
	char* target_ctypename;
	gboolean _tmp1_;
	ValaCCodeFormalParameter* _tmp8_;
	char* _tmp7_;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param));
	}
	if (!_tmp0_) {
		VALA_CCODE_METHOD_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) VALA_CCODE_ARRAY_MODULE (self), param, decl_space, cparam_map, carg_map);
		return;
	}
	ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param));
	target_ctypename = g_strdup ("void*");
	_tmp1_ = FALSE;
	if (VALA_IS_DELEGATE (vala_symbol_get_parent_symbol ((ValaSymbol*) param))) {
		char* _tmp3_;
		char* _tmp2_;
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		_tmp1_ = _vala_strcmp0 (_tmp2_ = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)), _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) VALA_DELEGATE (vala_symbol_get_parent_symbol ((ValaSymbol*) param)), FALSE)) == 0;
		_tmp3_ = (g_free (_tmp3_), NULL);
		_tmp2_ = (g_free (_tmp2_), NULL);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp4_;
		/* recursive delegate*/
		_tmp4_ = NULL;
		ctypename = (_tmp4_ = g_strdup ("GCallback"), ctypename = (g_free (ctypename), NULL), _tmp4_);
	}
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		char* _tmp5_;
		char* _tmp6_;
		_tmp5_ = NULL;
		ctypename = (_tmp5_ = g_strconcat (ctypename, "*", NULL), ctypename = (g_free (ctypename), NULL), _tmp5_);
		_tmp6_ = NULL;
		target_ctypename = (_tmp6_ = g_strconcat (target_ctypename, "*", NULL), target_ctypename = (g_free (target_ctypename), NULL), _tmp6_);
	}
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp8_ = vala_ccode_formal_parameter_new (_tmp7_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), ctypename)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeExpression* _tmp9_;
		_tmp9_ = NULL;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), _tmp9_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	}
	if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		ValaDelegateType* _tmp10_;
		ValaDelegateType* deleg_type;
		ValaDelegate* _tmp11_;
		ValaDelegate* d;
		_tmp10_ = NULL;
		deleg_type = (_tmp10_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
		_tmp11_ = NULL;
		d = (_tmp11_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
		vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, decl_space);
		if (vala_delegate_get_has_target (d)) {
			char* _tmp13_;
			char* _tmp12_;
			ValaCCodeFormalParameter* _tmp14_;
			ValaCCodeFormalParameter* cparam;
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			_tmp14_ = NULL;
			cparam = (_tmp14_ = vala_ccode_formal_parameter_new (_tmp13_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp12_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), target_ctypename), _tmp13_ = (g_free (_tmp13_), NULL), _tmp12_ = (g_free (_tmp12_), NULL), _tmp14_);
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeExpression* _tmp15_;
				_tmp15_ = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp15_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
				(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
			}
			if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
				ValaCCodeFormalParameter* _tmp18_;
				char* _tmp17_;
				char* _tmp16_;
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				cparam = (_tmp18_ = vala_ccode_formal_parameter_new (_tmp17_ = vala_ccode_base_module_get_delegate_target_destroy_notify_cname ((ValaCCodeBaseModule*) self, _tmp16_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), "GDestroyNotify"), (cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)), _tmp18_);
				_tmp17_ = (g_free (_tmp17_), NULL);
				_tmp16_ = (g_free (_tmp16_), NULL);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeExpression* _tmp19_;
					_tmp19_ = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), _tmp19_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
					(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
				}
			}
			(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
		}
		(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
		(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
	} else {
		if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			char* _tmp21_;
			char* _tmp20_;
			ValaCCodeFormalParameter* _tmp22_;
			ValaCCodeFormalParameter* cparam;
			_tmp21_ = NULL;
			_tmp20_ = NULL;
			_tmp22_ = NULL;
			cparam = (_tmp22_ = vala_ccode_formal_parameter_new (_tmp21_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp20_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), target_ctypename), _tmp21_ = (g_free (_tmp21_), NULL), _tmp20_ = (g_free (_tmp20_), NULL), _tmp22_);
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeExpression* _tmp23_;
				_tmp23_ = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp23_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
			}
			(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
		}
	}
	ctypename = (g_free (ctypename), NULL);
	target_ctypename = (g_free (target_ctypename), NULL);
}


static void vala_ccode_delegate_module_class_init (ValaCCodeDelegateModuleClass * klass) {
	vala_ccode_delegate_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_delegate_declaration = vala_ccode_delegate_module_real_generate_delegate_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delegate = vala_ccode_delegate_module_real_visit_delegate;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_delegate_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_delegate_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_delegate_module_real_get_implicit_cast_expression;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_delegate_module_real_generate_parameter;
}


static void vala_ccode_delegate_module_instance_init (ValaCCodeDelegateModule * self) {
}


GType vala_ccode_delegate_module_get_type (void) {
	static GType vala_ccode_delegate_module_type_id = 0;
	if (vala_ccode_delegate_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDelegateModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_delegate_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDelegateModule), 0, (GInstanceInitFunc) vala_ccode_delegate_module_instance_init, NULL };
		vala_ccode_delegate_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ARRAY_MODULE, "ValaCCodeDelegateModule", &g_define_type_info, 0);
	}
	return vala_ccode_delegate_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




