/* valaprofile.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define VALA_TYPE_PROFILE (vala_profile_get_type ())

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT
} ValaProfile;



GType vala_profile_get_type (void);




GType vala_profile_get_type (void) {
	static GType vala_profile_type_id = 0;
	if (G_UNLIKELY (vala_profile_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_PROFILE_POSIX, "VALA_PROFILE_POSIX", "posix"}, {VALA_PROFILE_GOBJECT, "VALA_PROFILE_GOBJECT", "gobject"}, {0, NULL, NULL}};
		vala_profile_type_id = g_enum_register_static ("ValaProfile", values);
	}
	return vala_profile_type_id;
}




