/* arraylist.c generated by valac, the Vala compiler
 * generated from arraylist.vala, do not modify */

/* arraylist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define VALA_TYPE_COLLECTION_OBJECT (vala_collection_object_get_type ())
#define VALA_COLLECTION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COLLECTION_OBJECT, ValaCollectionObject))
#define VALA_COLLECTION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COLLECTION_OBJECT, ValaCollectionObjectClass))
#define VALA_IS_COLLECTION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COLLECTION_OBJECT))
#define VALA_IS_COLLECTION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COLLECTION_OBJECT))
#define VALA_COLLECTION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COLLECTION_OBJECT, ValaCollectionObjectClass))

typedef struct _ValaCollectionObject ValaCollectionObject;
typedef struct _ValaCollectionObjectClass ValaCollectionObjectClass;
typedef struct _ValaCollectionObjectPrivate ValaCollectionObjectPrivate;

#define VALA_TYPE_ITERABLE (vala_iterable_get_type ())
#define VALA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERABLE, ValaIterable))
#define VALA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERABLE))
#define VALA_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_ITERABLE, ValaIterableIface))

typedef struct _ValaIterable ValaIterable;
typedef struct _ValaIterableIface ValaIterableIface;

#define VALA_TYPE_ITERATOR (vala_iterator_get_type ())
#define VALA_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERATOR, ValaIterator))
#define VALA_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERATOR))
#define VALA_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_ITERATOR, ValaIteratorIface))

typedef struct _ValaIterator ValaIterator;
typedef struct _ValaIteratorIface ValaIteratorIface;

#define VALA_TYPE_COLLECTION (vala_collection_get_type ())
#define VALA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COLLECTION, ValaCollection))
#define VALA_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COLLECTION))
#define VALA_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_COLLECTION, ValaCollectionIface))

typedef struct _ValaCollection ValaCollection;
typedef struct _ValaCollectionIface ValaCollectionIface;

#define VALA_TYPE_LIST (vala_list_get_type ())
#define VALA_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LIST, ValaList))
#define VALA_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LIST))
#define VALA_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LIST, ValaListIface))

typedef struct _ValaList ValaList;
typedef struct _ValaListIface ValaListIface;

#define VALA_TYPE_ARRAY_LIST (vala_array_list_get_type ())
#define VALA_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_LIST, ValaArrayList))
#define VALA_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_LIST, ValaArrayListClass))
#define VALA_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_LIST))
#define VALA_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_LIST))
#define VALA_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_LIST, ValaArrayListClass))

typedef struct _ValaArrayList ValaArrayList;
typedef struct _ValaArrayListClass ValaArrayListClass;
typedef struct _ValaArrayListPrivate ValaArrayListPrivate;

#define VALA_ARRAY_LIST_TYPE_ITERATOR (vala_array_list_iterator_get_type ())
#define VALA_ARRAY_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_ARRAY_LIST_TYPE_ITERATOR, ValaArrayListIterator))
#define VALA_ARRAY_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_ARRAY_LIST_TYPE_ITERATOR, ValaArrayListIteratorClass))
#define VALA_ARRAY_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_ARRAY_LIST_TYPE_ITERATOR))
#define VALA_ARRAY_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_ARRAY_LIST_TYPE_ITERATOR))
#define VALA_ARRAY_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_ARRAY_LIST_TYPE_ITERATOR, ValaArrayListIteratorClass))

typedef struct _ValaArrayListIterator ValaArrayListIterator;
typedef struct _ValaArrayListIteratorClass ValaArrayListIteratorClass;
typedef struct _ValaArrayListIteratorPrivate ValaArrayListIteratorPrivate;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

struct _ValaCollectionObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCollectionObjectPrivate * priv;
};

struct _ValaCollectionObjectClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCollectionObject *self);
};

struct _ValaIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (ValaIterator* self);
	gpointer (*get) (ValaIterator* self);
};

struct _ValaIterableIface {
	GTypeInterface parent_iface;
	GType (*get_element_type) (ValaIterable* self);
	ValaIterator* (*iterator) (ValaIterable* self);
};

struct _ValaCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (ValaCollection* self, gconstpointer item);
	gboolean (*add) (ValaCollection* self, gconstpointer item);
	gboolean (*remove) (ValaCollection* self, gconstpointer item);
	void (*clear) (ValaCollection* self);
	gint (*get_size) (ValaCollection* self);
};

struct _ValaListIface {
	GTypeInterface parent_iface;
	gpointer (*get) (ValaList* self, gint index);
	void (*set) (ValaList* self, gint index, gconstpointer item);
	gint (*index_of) (ValaList* self, gconstpointer item);
	void (*insert) (ValaList* self, gint index, gconstpointer item);
	void (*remove_at) (ValaList* self, gint index);
};

struct _ValaArrayList {
	ValaCollectionObject parent_instance;
	ValaArrayListPrivate * priv;
};

struct _ValaArrayListClass {
	ValaCollectionObjectClass parent_class;
};

struct _ValaArrayListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer* _items;
	gint _items_length1;
	gint _items_size;
	gint _size;
	GEqualFunc _equal_func;
	gint _stamp;
};

struct _ValaArrayListIterator {
	ValaCollectionObject parent_instance;
	ValaArrayListIteratorPrivate * priv;
	gint _stamp;
};

struct _ValaArrayListIteratorClass {
	ValaCollectionObjectClass parent_class;
};

struct _ValaArrayListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	ValaArrayList* _list;
	gint _index;
};


static gpointer vala_array_list_iterator_parent_class = NULL;
static ValaIteratorIface* vala_array_list_iterator_vala_iterator_parent_iface = NULL;
static gpointer vala_array_list_parent_class = NULL;
static ValaIterableIface* vala_array_list_vala_iterable_parent_iface = NULL;
static ValaCollectionIface* vala_array_list_vala_collection_parent_iface = NULL;
static ValaListIface* vala_array_list_vala_list_parent_iface = NULL;

gpointer vala_collection_object_ref (gpointer instance);
void vala_collection_object_unref (gpointer instance);
GParamSpec* vala_param_spec_collection_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_collection_object (GValue* value, gpointer v_object);
gpointer vala_value_get_collection_object (const GValue* value);
GType vala_collection_object_get_type (void);
GType vala_iterator_get_type (void);
GType vala_iterable_get_type (void);
GType vala_collection_get_type (void);
GType vala_list_get_type (void);
GType vala_array_list_get_type (void);
#define VALA_ARRAY_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_LIST, ValaArrayListPrivate))
enum  {
	VALA_ARRAY_LIST_DUMMY_PROPERTY
};
ValaCollectionObject* vala_collection_object_new (void);
ValaCollectionObject* vala_collection_object_construct (GType object_type);
void vala_array_list_set_equal_func (ValaArrayList* self, GEqualFunc value);
ValaArrayList* vala_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
ValaArrayList* vala_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
static GType vala_array_list_real_get_element_type (ValaIterable* base);
static ValaArrayListIterator* vala_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaArrayList* list);
static ValaArrayListIterator* vala_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaArrayList* list);
static GType vala_array_list_iterator_get_type (void);
static ValaIterator* vala_array_list_real_iterator (ValaIterable* base);
gint vala_list_index_of (ValaList* self, gconstpointer item);
static gboolean vala_array_list_real_contains (ValaCollection* base, gconstpointer item);
static gint vala_array_list_real_index_of (ValaList* base, gconstpointer item);
static gpointer vala_array_list_real_get (ValaList* base, gint index);
static void vala_array_list_real_set (ValaList* base, gint index, gconstpointer item);
static void vala_array_list_grow_if_needed (ValaArrayList* self, gint new_count);
static gboolean vala_array_list_real_add (ValaCollection* base, gconstpointer item);
static void vala_array_list_shift (ValaArrayList* self, gint start, gint delta);
static void vala_array_list_real_insert (ValaList* base, gint index, gconstpointer item);
void vala_list_remove_at (ValaList* self, gint index);
static gboolean vala_array_list_real_remove (ValaCollection* base, gconstpointer item);
static void vala_array_list_real_remove_at (ValaList* base, gint index);
static void vala_array_list_real_clear (ValaCollection* base);
static void vala_array_list_set_capacity (ValaArrayList* self, gint value);
#define VALA_ARRAY_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_ARRAY_LIST_TYPE_ITERATOR, ValaArrayListIteratorPrivate))
enum  {
	VALA_ARRAY_LIST_ITERATOR_DUMMY_PROPERTY
};
static void vala_array_list_iterator_set_list (ValaArrayListIterator* self, ValaArrayList* value);
static gboolean vala_array_list_iterator_real_next (ValaIterator* base);
gpointer vala_list_get (ValaList* self, gint index);
static gpointer vala_array_list_iterator_real_get (ValaIterator* base);
static void vala_array_list_iterator_finalize (ValaCollectionObject* obj);
static void vala_array_list_finalize (ValaCollectionObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);



ValaArrayList* vala_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	ValaArrayList* self;
	self = (ValaArrayList*) vala_collection_object_construct (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	vala_array_list_set_equal_func (self, equal_func);
	return self;
}


ValaArrayList* vala_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
	return vala_array_list_construct (VALA_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}


static GType vala_array_list_real_get_element_type (ValaIterable* base) {
	ValaArrayList * self;
	GType result;
	self = (ValaArrayList*) base;
	result = self->priv->g_type;
	return result;
}


static ValaIterator* vala_array_list_real_iterator (ValaIterable* base) {
	ValaArrayList * self;
	ValaIterator* result;
	self = (ValaArrayList*) base;
	result = (ValaIterator*) vala_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static gboolean vala_array_list_real_contains (ValaCollection* base, gconstpointer item) {
	ValaArrayList * self;
	gboolean result;
	self = (ValaArrayList*) base;
	result = vala_list_index_of ((ValaList*) self, item) != (-1);
	return result;
}


static gint vala_array_list_real_index_of (ValaList* base, gconstpointer item) {
	ValaArrayList * self;
	gint result;
	self = (ValaArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					index++;
				}
				_tmp0_ = FALSE;
				if (!(index < self->priv->_size)) {
					break;
				}
				if (self->priv->_equal_func (self->priv->_items[index], item)) {
					result = index;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


static gpointer vala_array_list_real_get (ValaList* base, gint index) {
	ValaArrayList * self;
	gpointer result;
	gconstpointer _tmp0_;
	self = (ValaArrayList*) base;
	g_assert ((index >= 0) && (index < self->priv->_size));
	result = (_tmp0_ = self->priv->_items[index], ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static void vala_array_list_real_set (ValaList* base, gint index, gconstpointer item) {
	ValaArrayList * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (ValaArrayList*) base;
	g_assert ((index >= 0) && (index < self->priv->_size));
	self->priv->_items[index] = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp1_);
}


static gboolean vala_array_list_real_add (ValaCollection* base, gconstpointer item) {
	ValaArrayList * self;
	gboolean result;
	gpointer _tmp2_;
	gpointer *_tmp1_;
	gconstpointer _tmp0_;
	self = (ValaArrayList*) base;
	if (self->priv->_size == self->priv->_items_length1) {
		vala_array_list_grow_if_needed (self, 1);
	}
	_tmp1_ = &self->priv->_items[self->priv->_size++];
	(*_tmp1_) = (_tmp2_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), (((*_tmp1_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp1_) = (self->priv->g_destroy_func ((*_tmp1_)), NULL)), _tmp2_);
	self->priv->_stamp++;
	result = TRUE;
	return result;
}


static void vala_array_list_real_insert (ValaList* base, gint index, gconstpointer item) {
	ValaArrayList * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (ValaArrayList*) base;
	g_assert ((index >= 0) && (index <= self->priv->_size));
	if (self->priv->_size == self->priv->_items_length1) {
		vala_array_list_grow_if_needed (self, 1);
	}
	vala_array_list_shift (self, index, 1);
	self->priv->_items[index] = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp1_);
	self->priv->_stamp++;
}


static gboolean vala_array_list_real_remove (ValaCollection* base, gconstpointer item) {
	ValaArrayList * self;
	gboolean result;
	self = (ValaArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					index++;
				}
				_tmp0_ = FALSE;
				if (!(index < self->priv->_size)) {
					break;
				}
				if (self->priv->_equal_func (self->priv->_items[index], item)) {
					vala_list_remove_at ((ValaList*) self, index);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void vala_array_list_real_remove_at (ValaList* base, gint index) {
	ValaArrayList * self;
	gpointer _tmp0_;
	self = (ValaArrayList*) base;
	g_assert ((index >= 0) && (index < self->priv->_size));
	self->priv->_items[index] = (_tmp0_ = NULL, ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp0_);
	vala_array_list_shift (self, index + 1, -1);
	self->priv->_stamp++;
}


static void vala_array_list_real_clear (ValaCollection* base) {
	ValaArrayList * self;
	self = (ValaArrayList*) base;
	{
		gint index;
		index = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp1_;
				if (!_tmp0_) {
					index++;
				}
				_tmp0_ = FALSE;
				if (!(index < self->priv->_size)) {
					break;
				}
				self->priv->_items[index] = (_tmp1_ = NULL, ((self->priv->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_items[index] = (self->priv->g_destroy_func (self->priv->_items[index]), NULL)), _tmp1_);
			}
		}
	}
	self->priv->_size = 0;
	self->priv->_stamp++;
}


static void vala_array_list_shift (ValaArrayList* self, gint start, gint delta) {
	g_return_if_fail (self != NULL);
	g_assert (((start >= 0) && (start <= self->priv->_size)) && (start >= (-delta)));
	_vala_array_move (self->priv->_items, sizeof (gpointer), start, start + delta, self->priv->_size - start);
	self->priv->_size = self->priv->_size + delta;
}


static void vala_array_list_grow_if_needed (ValaArrayList* self, gint new_count) {
	gint minimum_size;
	g_return_if_fail (self != NULL);
	g_assert (new_count >= 0);
	minimum_size = self->priv->_size + new_count;
	if (minimum_size > self->priv->_items_length1) {
		gint _tmp0_ = 0;
		if (new_count > self->priv->_items_length1) {
			_tmp0_ = minimum_size;
		} else {
			_tmp0_ = 2 * self->priv->_items_length1;
		}
		vala_array_list_set_capacity (self, _tmp0_);
	}
}


static void vala_array_list_set_capacity (ValaArrayList* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_assert (value >= self->priv->_size);
	_tmp0_ = value;
	self->priv->_items = g_renew (gpointer, self->priv->_items, value);
	(_tmp0_ > self->priv->_items_length1) ? memset (self->priv->_items + self->priv->_items_length1, 0, sizeof (gpointer) * (_tmp0_ - self->priv->_items_length1)) : NULL;
	self->priv->_items_length1 = _tmp0_;
}


static gint vala_array_list_real_get_size (ValaCollection* base) {
	gint result;
	ValaArrayList* self;
	self = (ValaArrayList*) base;
	result = self->priv->_size;
	return result;
}


void vala_array_list_set_equal_func (ValaArrayList* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
}


static ValaArrayListIterator* vala_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaArrayList* list) {
	ValaArrayListIterator* self;
	g_return_val_if_fail (list != NULL, NULL);
	self = (ValaArrayListIterator*) vala_collection_object_construct (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	vala_array_list_iterator_set_list (self, list);
	return self;
}


static ValaArrayListIterator* vala_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaArrayList* list) {
	return vala_array_list_iterator_construct (VALA_ARRAY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}


static gboolean vala_array_list_iterator_real_next (ValaIterator* base) {
	ValaArrayListIterator * self;
	gboolean result;
	self = (ValaArrayListIterator*) base;
	g_assert (self->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->_index < self->priv->_list->priv->_size) {
		self->priv->_index++;
	}
	result = self->priv->_index < self->priv->_list->priv->_size;
	return result;
}


static gpointer vala_array_list_iterator_real_get (ValaIterator* base) {
	ValaArrayListIterator * self;
	gpointer result;
	gboolean _tmp0_ = FALSE;
	self = (ValaArrayListIterator*) base;
	g_assert (self->_stamp == self->priv->_list->priv->_stamp);
	if (self->priv->_index < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_index >= self->priv->_list->priv->_size;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	result = vala_list_get ((ValaList*) self->priv->_list, self->priv->_index);
	return result;
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


static void vala_array_list_iterator_set_list (ValaArrayListIterator* self, ValaArrayList* value) {
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_list = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_list), _tmp0_);
	self->_stamp = self->priv->_list->priv->_stamp;
}


static void vala_array_list_iterator_class_init (ValaArrayListIteratorClass * klass) {
	vala_array_list_iterator_parent_class = g_type_class_peek_parent (klass);
	VALA_COLLECTION_OBJECT_CLASS (klass)->finalize = vala_array_list_iterator_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayListIteratorPrivate));
}


static void vala_array_list_iterator_vala_iterator_interface_init (ValaIteratorIface * iface) {
	vala_array_list_iterator_vala_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = vala_array_list_iterator_real_next;
	iface->get = vala_array_list_iterator_real_get;
}


static void vala_array_list_iterator_instance_init (ValaArrayListIterator * self) {
	self->priv = VALA_ARRAY_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->_stamp = 0;
}


static void vala_array_list_iterator_finalize (ValaCollectionObject* obj) {
	ValaArrayListIterator * self;
	self = VALA_ARRAY_LIST_ITERATOR (obj);
	_vala_collection_object_unref0 (self->priv->_list);
	VALA_COLLECTION_OBJECT_CLASS (vala_array_list_iterator_parent_class)->finalize (obj);
}


static GType vala_array_list_iterator_get_type (void) {
	static GType vala_array_list_iterator_type_id = 0;
	if (vala_array_list_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayListIterator), 0, (GInstanceInitFunc) vala_array_list_iterator_instance_init, NULL };
		static const GInterfaceInfo vala_iterator_info = { (GInterfaceInitFunc) vala_array_list_iterator_vala_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_array_list_iterator_type_id = g_type_register_static (VALA_TYPE_COLLECTION_OBJECT, "ValaArrayListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (vala_array_list_iterator_type_id, VALA_TYPE_ITERATOR, &vala_iterator_info);
	}
	return vala_array_list_iterator_type_id;
}


static void vala_array_list_class_init (ValaArrayListClass * klass) {
	vala_array_list_parent_class = g_type_class_peek_parent (klass);
	VALA_COLLECTION_OBJECT_CLASS (klass)->finalize = vala_array_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayListPrivate));
}


static void vala_array_list_vala_iterable_interface_init (ValaIterableIface * iface) {
	vala_array_list_vala_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element_type = vala_array_list_real_get_element_type;
	iface->iterator = vala_array_list_real_iterator;
}


static void vala_array_list_vala_collection_interface_init (ValaCollectionIface * iface) {
	vala_array_list_vala_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = vala_array_list_real_contains;
	iface->add = vala_array_list_real_add;
	iface->remove = vala_array_list_real_remove;
	iface->clear = vala_array_list_real_clear;
	iface->get_size = vala_array_list_real_get_size;
}


static void vala_array_list_vala_list_interface_init (ValaListIface * iface) {
	vala_array_list_vala_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->index_of = vala_array_list_real_index_of;
	iface->get = vala_array_list_real_get;
	iface->set = vala_array_list_real_set;
	iface->insert = vala_array_list_real_insert;
	iface->remove_at = vala_array_list_real_remove_at;
}


static void vala_array_list_instance_init (ValaArrayList * self) {
	self->priv = VALA_ARRAY_LIST_GET_PRIVATE (self);
	self->priv->_items = g_new0 (gpointer, 4);
	self->priv->_items_length1 = 4;
	self->priv->_items_size = self->priv->_items_length1;
	self->priv->_stamp = 0;
}


static void vala_array_list_finalize (ValaCollectionObject* obj) {
	ValaArrayList * self;
	self = VALA_ARRAY_LIST (obj);
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	VALA_COLLECTION_OBJECT_CLASS (vala_array_list_parent_class)->finalize (obj);
}


GType vala_array_list_get_type (void) {
	static GType vala_array_list_type_id = 0;
	if (vala_array_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayList), 0, (GInstanceInitFunc) vala_array_list_instance_init, NULL };
		static const GInterfaceInfo vala_iterable_info = { (GInterfaceInitFunc) vala_array_list_vala_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo vala_collection_info = { (GInterfaceInitFunc) vala_array_list_vala_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo vala_list_info = { (GInterfaceInitFunc) vala_array_list_vala_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_array_list_type_id = g_type_register_static (VALA_TYPE_COLLECTION_OBJECT, "ValaArrayList", &g_define_type_info, 0);
		g_type_add_interface_static (vala_array_list_type_id, VALA_TYPE_ITERABLE, &vala_iterable_info);
		g_type_add_interface_static (vala_array_list_type_id, VALA_TYPE_COLLECTION, &vala_collection_info);
		g_type_add_interface_static (vala_array_list_type_id, VALA_TYPE_LIST, &vala_list_info);
	}
	return vala_array_list_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if (src < dest) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	}
}




